/*
 * Copyright (c) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#include <linux/device.h>
#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/vmalloc.h>

#include "ddp_cmdq_reg.h"
#include "ddp_cmdq_record.h"

#include "mtk_mdp_core.h"
#include "mtk_mdp_ipi.h"
#include "mtk_mdp_type.h"
#include "mtk_mdp_frvc.h"


static cmdqRecHandle g_cmdq_handle; /* NULL */

/* h_mdp_cmd_720x480_1920x1080 */
/* RDMA0->SCL->WDMA0 */
static void nv16_720x480_yuyv_1920x1080(cmdqRecHandle handle,
		struct mdp_buffer *input,	struct mdp_buffer *output)
{
	cmdqRecWrite(handle, 0x14001008, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x14001008, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14001000, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14001028, 0x00020070, ~0xfffcff8f);
	cmdqRecWrite(handle, 0x14001030, 0x00000605, ~0xfefee980);
	cmdqRecWrite(handle, 0x14001040, input->addr_mva[0], ~0x00000000);
	cmdqRecWrite(handle, 0x14001048, input->addr_mva[1], ~0x00000000);
	cmdqRecWrite(handle, 0x14001050, input->addr_mva[2], ~0x00000000);
	cmdqRecWrite(handle, 0x14001060, 0x000002d0, ~0xffe00000);
	cmdqRecWrite(handle, 0x14001090, 0x000002d0, ~0xffe00000);
	cmdqRecWrite(handle, 0x14001100, 0x08000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001108, 0x080e1000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001110, 0x081c2000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001200, 0x00000000, ~0xf0eeffff);
	cmdqRecWrite(handle, 0x140010c8, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x140010e0, 0x00000a00, ~0xffff0000);
	cmdqRecWrite(handle, 0x14002000, 0x00010000, ~0xfffeffff);
	cmdqRecWrite(handle, 0x14002000, 0x00000000, ~0xfffeffff);
	cmdqRecWrite(handle, 0x14002000, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14002014, 0x00002ff5, ~0xff800000);
	cmdqRecWrite(handle, 0x14002018, 0x000038d3, ~0xff800000);
	cmdqRecWrite(handle, 0x14002004, 0x04000013, ~0xfbfffe0c);
	cmdqRecWrite(handle, 0x1400400c, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400400c, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14004008, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14004014, 0x00000140, ~0xf0ffd00f);
	cmdqRecWrite(handle, 0x14004024, output->addr_mva[0], ~0x00000000);
	cmdqRecWrite(handle, 0x14004070, output->addr_mva[1], ~0x00000000);
	cmdqRecWrite(handle, 0x14004074, output->addr_mva[2], ~0x00000000);
	cmdqRecWrite(handle, 0x14004028, 0x00000f00, ~0xffff0000);
	cmdqRecWrite(handle, 0x14004078, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x1400402c, 0x800000ff, ~0x7fffff00);
	cmdqRecWrite(handle, 0x14004e00, 0x00000010, ~0xffffffee);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000032, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004080, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004084, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004088, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004018, 0x043802fe, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400401c, 0x043802fe, ~0xc000c000);
	cmdqRecWrite(handle, 0x14004020, 0x00000000, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400200c, 0x81e00122, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x843802fe, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00122008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x01400028, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00122010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00a00014, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400f068, 0x00000015, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffcd);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WDMA_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000032, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004080, 0x000005fc, ~0x00000000);
	cmdqRecWrite(handle, 0x14004084, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004088, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004018, 0x043802f2, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400401c, 0x043802f2, ~0xc000c000);
	cmdqRecWrite(handle, 0x14004020, 0x00000000, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400200c, 0xc1e00122, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000002, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00007f16, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00007f16, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x843802f2, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00122008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x01400028, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00122010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00a00014, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x0000011a, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x0000011a, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x0000011a, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400f068, 0x00000015, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffcd);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WDMA_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000032, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004080, 0x00000be0, ~0x00000000);
	cmdqRecWrite(handle, 0x14004084, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004088, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004018, 0x04380190, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400401c, 0x04380190, ~0xc000c000);
	cmdqRecWrite(handle, 0x14004020, 0x00000000, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400200c, 0xc1e0009a, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00003eb0, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000beb0, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x04380190, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x0009a008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00a00014, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x0009a010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x00000236, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x00000236, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x00000236, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e0009a, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e0009a, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400f068, 0x00000015, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffcd);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WDMA_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
}

/* v_mdp_cmd_720x480_1080x1920 */
/* RDMA0->SCL->WROT */
static void nv16_720x480_yuyv_1080x1920(cmdqRecHandle handle,
		struct mdp_buffer *input,	struct mdp_buffer *output)
{
	cmdqRecWrite(handle, 0x14001008, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x14001008, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14001000, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14001028, 0x00020070, ~0xfffcff8f);
	cmdqRecWrite(handle, 0x14001030, 0x00000605, ~0xfefee980);
	cmdqRecWrite(handle, 0x14001040, input->addr_mva[0], ~0x00000000);
	cmdqRecWrite(handle, 0x14001048, input->addr_mva[1], ~0x00000000);
	cmdqRecWrite(handle, 0x14001050, input->addr_mva[2], ~0x00000000);
	cmdqRecWrite(handle, 0x14001060, 0x000002d0, ~0xffe00000);
	cmdqRecWrite(handle, 0x14001090, 0x000002d0, ~0xffe00000);
	cmdqRecWrite(handle, 0x14001100, 0x08000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001108, 0x08054600, ~0x00000000);
	cmdqRecWrite(handle, 0x14001110, 0x080a8c00, ~0x00000000);
	cmdqRecWrite(handle, 0x14001200, 0x00000000, ~0xf0eeffff);
	cmdqRecWrite(handle, 0x140010c8, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x140010e0, 0x00000a00, ~0xffff0000);
	cmdqRecWrite(handle, 0x14002000, 0x00010000, ~0xfffeffff);
	cmdqRecWrite(handle, 0x14002000, 0x00000000, ~0xfffeffff);
	cmdqRecWrite(handle, 0x14002000, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14002014, 0x00002ff5, ~0xff800000);
	cmdqRecWrite(handle, 0x14002018, 0x000038d3, ~0xff800000);
	cmdqRecWrite(handle, 0x14002004, 0x04000013, ~0xfbfffe0c);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005028, output->addr_mva[0], ~0x00000000);
	cmdqRecWrite(handle, 0x14005034, output->addr_mva[1], ~0x00000000);
	cmdqRecWrite(handle, 0x14005064, output->addr_mva[2], ~0x00000000);
	cmdqRecWrite(handle, 0x14005000, 0x20100200, ~0x0ecfec38);
	cmdqRecWrite(handle, 0x14005030, 0x00000870, ~0xffff0000);
	cmdqRecWrite(handle, 0x1400503c, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x1400506c, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x14005004, 0x07000000, ~0xe0ffffff);
	cmdqRecWrite(handle, 0x14005084, 0x00000000, ~0xffffff0c);
	cmdqRecWrite(handle, 0x14005054, 0xff000000, ~0x00ffffff);
	cmdqRecWrite(handle, 0x14005070, 0x80000000, ~0x7fffffff);
	cmdqRecWrite(handle, 0x140050a4, 0x00000002, ~0xfffffffc);
	cmdqRecWrite(handle, 0x14005054, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0000086f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0x81e00064, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00064008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00800010, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00064010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00400008, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00064, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00064, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0008786f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc1e00068, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00007500, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000f500, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00068008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00800010, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00068010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00400008, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x0000005c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x0000005c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x0000005c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00068, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00068, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0010e86f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc1e00068, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00006a00, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000ea00, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00068008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00800010, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00068010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00400008, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x000000bc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x000000bc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x000000bc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00068, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00068, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0019586f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc1e00068, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00005f00, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000df00, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00068008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00800010, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00068010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00400008, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x0000011c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x0000011c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x0000011c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00068, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00068, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0021c86f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc1e00066, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00005400, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000d400, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00066008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00800010, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00066010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00400008, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x0000017c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x0000017c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x0000017c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00066, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00066, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x002a386f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc1e00066, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00004900, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000c900, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00066008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00800010, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00066010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00400008, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x000001dc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x000001dc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x000001dc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00066, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00066, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0032a86f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc1e00066, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00003e00, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000be00, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00066008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00800010, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00066010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00400008, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x0000023c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x0000023c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x0000023c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00066, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00066, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x003b186f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380080, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380080, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x00802000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc1e00034, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00003300, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000b300, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x04380080, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00034008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00400008, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00034010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00200004, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x0000029c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x0000029c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x0000029c, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x01e00034, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x01e00034, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
}

/* h_mdp_cmd_1280x720_1920x1080 */
/* RDMA0->SCL->WDMA0 */
static void nv16_1280x720_yuyv_1920x1080(cmdqRecHandle handle,
		struct mdp_buffer *input,	struct mdp_buffer *output)
{
	cmdqRecWrite(handle, 0x14001008, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x14001008, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14001000, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14001028, 0x00020070, ~0xfffcff8f);
	cmdqRecWrite(handle, 0x14001030, 0x00000605, ~0xfefee980);
	cmdqRecWrite(handle, 0x14001040, input->addr_mva[0], ~0x00000000);
	cmdqRecWrite(handle, 0x14001048, input->addr_mva[1], ~0x00000000);
	cmdqRecWrite(handle, 0x14001050, input->addr_mva[2], ~0x00000000);
	cmdqRecWrite(handle, 0x14001060, 0x00000500, ~0xffe00000);
	cmdqRecWrite(handle, 0x14001090, 0x00000500, ~0xffe00000);
	cmdqRecWrite(handle, 0x14001100, 0x08000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001108, 0x080e1000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001110, 0x081c2000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001200, 0x00000000, ~0xf0eeffff);
	cmdqRecWrite(handle, 0x140010c8, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x140010e0, 0x00000a00, ~0xffff0000);
	cmdqRecWrite(handle, 0x14002000, 0x00010000, ~0xfffeffff);
	cmdqRecWrite(handle, 0x14002000, 0x00000000, ~0xfffeffff);
	cmdqRecWrite(handle, 0x14002000, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14002014, 0x00005550, ~0xff800000);
	cmdqRecWrite(handle, 0x14002018, 0x0000554b, ~0xff800000);
	cmdqRecWrite(handle, 0x14002004, 0x04000013, ~0xfbfffe0c);
	cmdqRecWrite(handle, 0x1400400c, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400400c, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14004008, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14004014, 0x00000140, ~0xf0ffd00f);
	cmdqRecWrite(handle, 0x14004024, output->addr_mva[0], ~0x00000000);
	cmdqRecWrite(handle, 0x14004070, output->addr_mva[1], ~0x00000000);
	cmdqRecWrite(handle, 0x14004074, output->addr_mva[2], ~0x00000000);
	cmdqRecWrite(handle, 0x14004028, 0x00000f00, ~0xffff0000);
	cmdqRecWrite(handle, 0x14004078, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x1400402c, 0x800000ff, ~0x7fffff00);
	cmdqRecWrite(handle, 0x14004e00, 0x00000010, ~0xffffffee);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000032, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004080, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004084, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004088, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004018, 0x043801ae, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400401c, 0x043801ae, ~0xc000c000);
	cmdqRecWrite(handle, 0x14004020, 0x00000000, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400200c, 0x82d00122, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x843801ae, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00122008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x01400028, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00122010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00a00014, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400f068, 0x00000015, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffcd);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WDMA_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000032, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004080, 0x0000035c, ~0x00000000);
	cmdqRecWrite(handle, 0x14004084, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004088, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004018, 0x043801a8, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400401c, 0x043801a8, ~0xc000c000);
	cmdqRecWrite(handle, 0x14004020, 0x00000000, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d00122, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000002, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00004c60, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00004c60, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x843801a8, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00122008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x01400028, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00122010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00a00014, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x0000011a, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x0000011a, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x0000011a, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400f068, 0x00000015, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffcd);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WDMA_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000032, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004080, 0x000006ac, ~0x00000000);
	cmdqRecWrite(handle, 0x14004084, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004088, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004018, 0x043801aa, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400401c, 0x043801aa, ~0xc000c000);
	cmdqRecWrite(handle, 0x14004020, 0x00000000, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d00122, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x000018e0, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x000098e0, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x843801aa, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00122008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x01400028, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00122010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00a00014, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x00000236, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x00000236, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x00000236, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400f068, 0x00000015, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffcd);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WDMA_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000032, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004080, 0x00000a00, ~0x00000000);
	cmdqRecWrite(handle, 0x14004084, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004088, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004018, 0x043801aa, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400401c, 0x043801aa, ~0xc000c000);
	cmdqRecWrite(handle, 0x14004020, 0x00000000, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d00122, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00001000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00009000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x843801aa, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00122008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x01400028, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00122010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00a00014, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x00000352, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x00000352, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x00000352, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d00122, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400f068, 0x00000015, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffcd);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WDMA_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000032, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004080, 0x00000d54, ~0x00000000);
	cmdqRecWrite(handle, 0x14004084, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004088, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14004018, 0x043800d6, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400401c, 0x043800d6, ~0xc000c000);
	cmdqRecWrite(handle, 0x14004020, 0x00000000, ~0xc000c000);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d00092, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00000720, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00008720, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x043800d6, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x00092008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00a00014, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x00092010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x0000046e, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x0000046e, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x0000046e, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d00092, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d00092, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecPoll(handle, 0x140040a0, 0x00000001, ~0xfffffc00);
	cmdqRecWrite(handle, 0x1400f068, 0x00000015, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffcd);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WDMA_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000048, 0x00000000, ~0x00000000);
}

/* v_mdp_cmd_1280x720_1080x1920 */
/* RDMA0 ->SCL-> WROT */
static void nv16_1280x720_yuyv_1080x1920(cmdqRecHandle handle,
		struct mdp_buffer *input,	struct mdp_buffer *output)
{
	cmdqRecWrite(handle, 0x14001008, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x14001008, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14001000, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14001028, 0x00020070, ~0xfffcff8f);
	cmdqRecWrite(handle, 0x14001030, 0x00000605, ~0xfefee980);
	cmdqRecWrite(handle, 0x14001040, input->addr_mva[0], ~0x00000000);
	cmdqRecWrite(handle, 0x14001048, input->addr_mva[1], ~0x00000000);
	cmdqRecWrite(handle, 0x14001050, input->addr_mva[2], ~0x00000000);
	cmdqRecWrite(handle, 0x14001060, 0x00000500, ~0xffe00000);
	cmdqRecWrite(handle, 0x14001090, 0x00000500, ~0xffe00000);
	cmdqRecWrite(handle, 0x14001100, 0x08000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001108, 0x080e1000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001110, 0x081c2000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001200, 0x00000000, ~0xf0eeffff);
	cmdqRecWrite(handle, 0x140010c8, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x140010e0, 0x00000a00, ~0xffff0000);
	cmdqRecWrite(handle, 0x14002000, 0x00010000, ~0xfffeffff);
	cmdqRecWrite(handle, 0x14002000, 0x00000000, ~0xfffeffff);
	cmdqRecWrite(handle, 0x14002000, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14002014, 0x00005550, ~0xff800000);
	cmdqRecWrite(handle, 0x14002018, 0x0000554b, ~0xff800000);
	cmdqRecWrite(handle, 0x14002004, 0x04000013, ~0xfbfffe0c);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005028, output->addr_mva[0], ~0x00000000);
	cmdqRecWrite(handle, 0x14005034, output->addr_mva[1], ~0x00000000);
	cmdqRecWrite(handle, 0x14005064, output->addr_mva[2], ~0x00000000);
	cmdqRecWrite(handle, 0x14005000, 0x20100200, ~0x0ecfec38);
	cmdqRecWrite(handle, 0x14005030, 0x00000870, ~0xffff0000);
	cmdqRecWrite(handle, 0x1400503c, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x1400506c, 0x00000000, ~0xffff0000);
	cmdqRecWrite(handle, 0x14005004, 0x07000000, ~0xe0ffffff);
	cmdqRecWrite(handle, 0x14005084, 0x00000000, ~0xffffff0c);
	cmdqRecWrite(handle, 0x14005054, 0xff000000, ~0x00ffffff);
	cmdqRecWrite(handle, 0x14005070, 0x80000000, ~0x7fffffff);
	cmdqRecWrite(handle, 0x140050a4, 0x00000002, ~0xfffffffc);
	cmdqRecWrite(handle, 0x14005054, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0000086f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0x82d000ae, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x000ae008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00c00018, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x000ae010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d000ae, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d000ae, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0008786f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d000b2, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000002, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00005000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00005000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x000b2008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00c00018, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x000b2010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x000000a6, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x000000a6, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x000000a6, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0010e86f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d000b2, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00002000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000a000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x000b2008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00c00018, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x000b2010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x00000152, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x00000152, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x00000152, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0019586f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d000b2, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00007000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000f000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x000b2008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00c00018, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x000b2010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x000001fc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x000001fc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x000001fc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0021c86f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d000b2, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000002, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00004000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00004000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x000b2008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00c00018, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x000b2010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x000002a6, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x000002a6, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x000002a6, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x002a386f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d000b2, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00001000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00009000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x000b2008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00c00018, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x000b2010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x00000352, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x00000352, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x00000352, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x0032a86f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380100, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x01002000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d000b2, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00006000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x0000e000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x84380100, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x000b2008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x00c00018, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x000b2010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x000003fc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x000003fc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x000003fc, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d000b2, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a8, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000002, ~0xfffffffd);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000023, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0b0, 0x00000000, ~0xfffffff8);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000001, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000002, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14005010, 0x00000001, ~0xfffffffe);
	cmdqRecPoll(handle, 0x14005014, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x14005010, 0x00000000, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400507c, 0x00000001, ~0xfffffffe);
	cmdqRecWrite(handle, 0x1400502c, 0x003b186f, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005038, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005068, 0xffffffff, ~0xf0000000);
	cmdqRecWrite(handle, 0x14005078, 0x04380080, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005024, 0x04380080, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005000, 0x00001000, ~0xffffefff);
	cmdqRecWrite(handle, 0x14005020, 0x00000000, ~0xe000e000);
	cmdqRecWrite(handle, 0x14005008, 0x00802000, ~0xe00080ff);
	cmdqRecWrite(handle, 0x1400200c, 0xc2d0005a, ~0x2000e000);
	cmdqRecWrite(handle, 0x1400201c, 0x00000002, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002020, 0x00003000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002024, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002028, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x1400202c, 0x00000001, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002030, 0x00003000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002034, 0x00000000, ~0xffffe000);
	cmdqRecWrite(handle, 0x14002038, 0x00000000, ~0xffe00000);
	cmdqRecWrite(handle, 0x14002010, 0x04380080, ~0x6000e000);
	cmdqRecWrite(handle, 0x14001020, 0x00001000, ~0xffffeeff);
	cmdqRecWrite(handle, 0x140010c0, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x14001088, 0x0005a008, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010d0, 0x0060000c, ~0xc000e000);
	cmdqRecWrite(handle, 0x140010d8, 0x00000008, ~0xffffff80);
	cmdqRecWrite(handle, 0x140010b8, 0x0005a010, ~0xe0000c00);
	cmdqRecWrite(handle, 0x140010e8, 0x00400008, ~0xc000e000);
	cmdqRecWrite(handle, 0x14001118, 0x000004a6, ~0x00000000);
	cmdqRecWrite(handle, 0x14001120, 0x000004a6, ~0x00000000);
	cmdqRecWrite(handle, 0x14001128, 0x000004a6, ~0x00000000);
	cmdqRecWrite(handle, 0x14001070, 0x02d0005a, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001078, 0x02d0005a, ~0xe000e000);
	cmdqRecWrite(handle, 0x14001080, 0x00000000, ~0xffc0ffe0);
	cmdqRecPoll(handle, 0x14001408, 0x00000100, ~0xfffffeff);
	cmdqRecWrite(handle, 0x1400f068, 0x00000014, ~0xffffffe0);
	cmdqRecWrite(handle, 0x14005018, 0x00000b00, ~0xffffc0ff);
	cmdqRecPoll(handle, 0x140050d0, 0x00000000, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400f068, 0x00000016, ~0xffffffe0);
	cmdqRecWrite(handle, 0x1400e0a4, 0x00000000, ~0xfffffffe);
	cmdqRecPoll(handle, 0x1400e0a4, 0x00000000, ~0xfffffffd);
	cmdqRecPoll(handle, 0x1400e00c, 0x00000000, ~0xffffffdc);
	cmdqRecWrite(handle, 0x1400e004, 0x00000000, ~0xffffffef);
	cmdqRecWrite(handle, 0x1400e0ac, 0x00000000, ~0xfffff000);
	cmdqRecWrite(handle, 0x1400e0a0, 0x00000000, ~0xfffffffe);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_RDMA_EOF);
	cmdqRecWait(handle, CMDQ_EVENT_MDP_WROT_EOF);
	cmdqRecWrite(handle, 0x14000038, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000020, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000024, 0x00000000, ~0x00000000);
	cmdqRecWrite(handle, 0x14000044, 0x00000000, ~0x00000000);
}

int mtk_mdp_frvc_process(struct mtk_mdp_ctx *ctx)
{
	struct mdp_process_vsi *vsi;
	struct mdp_config *src_cfg, *dst_cfg;
	int ret;
	int support = 1;

	if (g_cmdq_handle == NULL) {
		if (cmdqRecCreate(CMDQ_SCENARIO_DEBUG, &g_cmdq_handle) != 0) {
			mtk_mdp_dbg(0, "create cmdq handle failed!");
			return -1;
		}
	}

	vsi = ctx->vpu.vsi;
	src_cfg = &vsi->src_config;
	dst_cfg = &vsi->dst_config;

	/* input is 720x480 or 1280x720, output is 1920x1080 or 1080x1920 */
	/* NV16->YUYV */
	if (src_cfg->format == DP_COLOR_NV16 &&
		src_cfg->x == 0 &&
		src_cfg->y == 0 &&
		src_cfg->crop_x == 0 &&
		src_cfg->crop_y == 0 &&
		dst_cfg->format == DP_COLOR_YUYV &&
		dst_cfg->x == 0 &&
		dst_cfg->y == 0 &&
		dst_cfg->crop_x == 0 &&
		dst_cfg->crop_y == 0 &&
		vsi->misc.hflip == 0 &&
		vsi->misc.vflip == 0) {

		if (src_cfg->crop_w == 720 && src_cfg->crop_h == 480 &&
			dst_cfg->crop_w == 1920 && dst_cfg->crop_h == 1080 &&
			vsi->misc.orientation == 0) {
			cmdqRecReset(g_cmdq_handle);
			nv16_720x480_yuyv_1920x1080(g_cmdq_handle, &vsi->src_buffer,
				&vsi->dst_buffer);
			ret = cmdqRecFlush(g_cmdq_handle);
		} else if (src_cfg->crop_w == 720 && src_cfg->crop_h == 480 &&
			dst_cfg->crop_w == 1080 && dst_cfg->crop_h == 1920 &&
			vsi->misc.orientation == 90) {
			cmdqRecReset(g_cmdq_handle);
			nv16_720x480_yuyv_1080x1920(g_cmdq_handle, &vsi->src_buffer,
				&vsi->dst_buffer);
			ret = cmdqRecFlush(g_cmdq_handle);
		} else if (src_cfg->crop_w == 1280 && src_cfg->crop_h == 720 &&
			dst_cfg->crop_w == 1920 && dst_cfg->crop_h == 1080 &&
			vsi->misc.orientation == 0) {
			cmdqRecReset(g_cmdq_handle);
			nv16_1280x720_yuyv_1920x1080(g_cmdq_handle, &vsi->src_buffer,
				&vsi->dst_buffer);
			ret = cmdqRecFlush(g_cmdq_handle);
		} else if (src_cfg->crop_w == 1280 && src_cfg->crop_h == 720 &&
			dst_cfg->crop_w == 1080 && dst_cfg->crop_h == 1920 &&
			vsi->misc.orientation == 90) {
			cmdqRecReset(g_cmdq_handle);
			nv16_1280x720_yuyv_1080x1920(g_cmdq_handle, &vsi->src_buffer,
				&vsi->dst_buffer);
			ret = cmdqRecFlush(g_cmdq_handle);
		} else
			support = 0;
	} else
		support = 0;

	if (support == 0) {
		ret = -1;
		mtk_mdp_dbg(0, "frvc unsupport:");
		mtk_mdp_dbg(0, "in: (%d, %d, %d, %d, %08x)\n",
			src_cfg->x, src_cfg->y, src_cfg->w, src_cfg->h,
			src_cfg->format);
		mtk_mdp_dbg(0, "out: (%d, %d, %d, %d, %08x)\n",
			dst_cfg->x, dst_cfg->y, dst_cfg->w, dst_cfg->h,
			dst_cfg->format);
		mtk_mdp_dbg(0, "misc: (%d, %d, %d)\n",
			vsi->misc.hflip, vsi->misc.vflip, vsi->misc.orientation);
	}

	return ret;
}

int mtk_mdp_frvc_stop(void)
{
	cmdqRecDestroy(g_cmdq_handle);
	g_cmdq_handle = NULL;

	return 0;
}
