/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#include "mtk_cpufreq_config.h"

#define NR_FREQ		16
#define ARRAY_COL_SIZE	4

static unsigned int fyTbl[NR_FREQ * NR_MT_CPU_DVFS][ARRAY_COL_SIZE] = {
	/* Freq, Vproc, post_div, clk_div */
	{ 1508, 99, 1, 1 },	/* LL */
	{ 1482, 95, 2, 1 },
	{ 1430, 91, 2, 1 },
	{ 1404, 87, 2, 1 },
	{ 1365, 82, 2, 1 },
	{ 1300, 77, 2, 1 },
	{ 1235, 72, 2, 1 },
	{ 1183, 67, 2, 1 },
	{ 1105, 61, 2, 1 },
	{ 1001, 55, 2, 1 },
	{ 884,  48, 2, 1 },
	{ 793,  43, 2, 1 },
	{ 715,  38, 2, 2 },
	{ 624,  33, 2, 2 },
	{ 481,  25, 2, 2 },
	{ 338,  16, 2, 4 },

	{ 2002, 99, 1, 1 },	/* L */
	{ 1976, 95, 1, 1 },
	{ 1937, 91, 1, 1 },
	{ 1911, 87, 1, 1 },
	{ 1859, 82, 1, 1 },
	{ 1807, 77, 1, 1 },
	{ 1742, 72, 1, 1 },
	{ 1690, 67, 1, 1 },
	{ 1586, 61, 1, 1 },
	{ 1456, 55, 1, 1 },
	{ 1287, 48, 2, 1 },
	{ 1170, 43, 2, 1 },
	{ 1040, 38, 2, 1 },
	{ 910,  33, 2, 1 },
	{ 715,  25, 2, 1 },
	{ 520,  16, 2, 2 },

	{ 910, 99, 2, 1 },	/* CCI */
	{ 897, 95, 2, 1 },
	{ 884, 91, 2, 1 },
	{ 871, 87, 2, 1 },
	{ 858, 82, 2, 1 },
	{ 806, 77, 2, 1 },
	{ 767, 72, 2, 1 },
	{ 728, 67, 2, 2 },
	{ 676, 61, 2, 2 },
	{ 611, 55, 2, 2 },
	{ 559, 48, 2, 2 },
	{ 507, 43, 2, 2 },
	{ 442, 38, 2, 2 },
	{ 390, 33, 2, 2 },
	{ 299, 25, 2, 4 },
	{ 195, 16, 2, 4 },
};

static unsigned int fy2Tbl[NR_FREQ * NR_MT_CPU_DVFS][ARRAY_COL_SIZE] = {
	/* Freq, Vproc, post_div, clk_div */
	{ 1690, 99, 1, 1 },	/* LL */
	{ 1677, 94, 1, 1 },
	{ 1651, 88, 1, 1 },
	{ 1625, 83, 1, 1 },
	{ 1547, 78, 1, 1 },
	{ 1495, 74, 2, 1 },
	{ 1417, 69, 2, 1 },
	{ 1339, 64, 2, 1 },
	{ 1248, 59, 2, 1 },
	{ 1144, 54, 2, 1 },
	{ 1014, 48, 2, 1 },
	{ 884,  42, 2, 1 },
	{ 780,  37, 2, 1 },
	{ 663,  32, 2, 2 },
	{ 520,  25, 2, 2 },
	{ 338,  16, 2, 4 },

	{ 2340, 99, 1, 1 },	/* L */
	{ 2288, 94, 1, 1 },
	{ 2236, 88, 1, 1 },
	{ 2184, 83, 1, 1 },
	{ 2119, 78, 1, 1 },
	{ 2054, 74, 1, 1 },
	{ 1989, 69, 1, 1 },
	{ 1924, 64, 1, 1 },
	{ 1781, 59, 1, 1 },
	{ 1638, 54, 1, 1 },
	{ 1469, 48, 2, 1 },
	{ 1287, 42, 2, 1 },
	{ 1131, 37, 2, 1 },
	{ 962,  32, 2, 1 },
	{ 767,  25, 2, 1 },
	{ 520,  16, 2, 2 },

	{ 1040, 99, 2, 1 },	/* CCI */
	{ 1027, 94, 2, 1 },
	{ 1001, 88, 2, 1 },
	{ 988,  83, 2, 1 },
	{ 936,  78, 2, 1 },
	{ 897,  74, 2, 1 },
	{ 845,  69, 2, 1 },
	{ 793,  64, 2, 1 },
	{ 741,  59, 2, 2 },
	{ 689,  54, 2, 2 },
	{ 624,  48, 2, 2 },
	{ 546,  42, 2, 2 },
	{ 481,  37, 2, 2 },
	{ 416,  32, 2, 2 },
	{ 325,  25, 2, 4 },
	{ 195,  16, 2, 4 },
};

static unsigned int sb2Tbl[NR_FREQ * NR_MT_CPU_DVFS][ARRAY_COL_SIZE] = {
	/* Freq, Vproc, post_div, clk_div */
	{ 1794, 99, 1, 1 },	/* LL */
	{ 1755, 95, 1, 1 },
	{ 1703, 91, 1, 1 },
	{ 1664, 87, 1, 1 },
	{ 1612, 82, 1, 1 },
	{ 1534, 77, 1, 1 },
	{ 1456, 72, 2, 1 },
	{ 1391, 67, 2, 1 },
	{ 1287, 61, 2, 1 },
	{ 1157, 55, 2, 1 },
	{ 1014, 48, 2, 1 },
	{ 910,  43, 2, 1 },
	{ 806,  38, 2, 1 },
	{ 689,  33, 2, 2 },
	{ 520,  25, 2, 2 },
	{ 338,  16, 2, 4 },

	{ 2340, 99, 1, 1 },	/* L */
	{ 2288, 95, 1, 1 },
	{ 2236, 91, 1, 1 },
	{ 2184, 87, 1, 1 },
	{ 2119, 82, 1, 1 },
	{ 2054, 77, 1, 1 },
	{ 1989, 72, 1, 1 },
	{ 1924, 67, 1, 1 },
	{ 1781, 61, 1, 1 },
	{ 1638, 55, 1, 1 },
	{ 1469, 48, 2, 1 },
	{ 1287, 43, 2, 1 },
	{ 1131, 38, 2, 1 },
	{ 962,  33, 2, 1 },
	{ 767,  25, 2, 1 },
	{ 520,  16, 2, 2 },

	{ 1040, 99, 2, 1 },	/* CCI */
	{ 1027, 95, 2, 1 },
	{ 1014, 91, 2, 1 },
	{ 1001, 87, 2, 1 },
	{ 975,  82, 2, 1 },
	{ 923,  77, 2, 1 },
	{ 871,  72, 2, 1 },
	{ 819,  67, 2, 1 },
	{ 767,  61, 2, 1 },
	{ 689,  55, 2, 2 },
	{ 624,  48, 2, 2 },
	{ 559,  43, 2, 2 },
	{ 494,  38, 2, 2 },
	{ 429,  33, 2, 2 },
	{ 325,  25, 2, 4 },
	{ 195,  16, 2, 4 },
};

static unsigned int fy3Tbl[NR_FREQ * NR_MT_CPU_DVFS][ARRAY_COL_SIZE] = {
	/* Freq, Vproc, post_div, clk_div */
	{ 1690, 99, 1, 1 },	/* LL */
	{ 1677, 95, 1, 1 },
	{ 1664, 91, 1, 1 },
	{ 1651, 87, 1, 1 },
	{ 1612, 82, 1, 1 },
	{ 1534, 77, 1, 1 },
	{ 1456, 72, 2, 1 },
	{ 1391, 67, 2, 1 },
	{ 1287, 61, 2, 1 },
	{ 1157, 55, 2, 1 },
	{ 1014, 48, 2, 1 },
	{ 910,  43, 2, 1 },
	{ 806,  38, 2, 1 },
	{ 689,  33, 2, 2 },
	{ 520,  25, 2, 2 },
	{ 338,  16, 2, 4 },

	{ 2496, 99, 1, 1 },	/* L */
	{ 2418, 95, 1, 1 },
	{ 2340, 91, 1, 1 },
	{ 2262, 87, 1, 1 },
	{ 2171, 82, 1, 1 },
	{ 2106, 77, 1, 1 },
	{ 2028, 72, 1, 1 },
	{ 1963, 67, 1, 1 },
	{ 1833, 61, 1, 1 },
	{ 1664, 55, 1, 1 },
	{ 1469, 48, 2, 1 },
	{ 1313, 43, 2, 1 },
	{ 1157, 38, 2, 1 },
	{ 1001, 33, 2, 1 },
	{ 767,  25, 2, 1 },
	{ 520,  16, 2, 2 },

	{ 1092, 99, 2, 1 },	/* CCI */
	{ 1066, 95, 2, 1 },
	{ 1040, 91, 2, 1 },
	{ 1014, 87, 2, 1 },
	{ 975,  82, 2, 1 },
	{ 923,  77, 2, 1 },
	{ 871,  72, 2, 1 },
	{ 819,  67, 2, 1 },
	{ 767,  61, 2, 1 },
	{ 689,  55, 2, 2 },
	{ 624,  48, 2, 2 },
	{ 559,  43, 2, 2 },
	{ 494,  38, 2, 2 },
	{ 429,  33, 2, 2 },
	{ 325,  25, 2, 4 },
	{ 195,  16, 2, 4 },
};

static unsigned int sb3Tbl[NR_FREQ * NR_MT_CPU_DVFS][ARRAY_COL_SIZE] = {
	/* Freq, Vproc, post_div, clk_div */
	{ 1885, 99, 1, 1 },	/* LL */
	{ 1820, 95, 1, 1 },
	{ 1755, 91, 1, 1 },
	{ 1690, 87, 1, 1 },
	{ 1612, 82, 1, 1 },
	{ 1534, 77, 1, 1 },
	{ 1456, 72, 2, 1 },
	{ 1391, 67, 2, 1 },
	{ 1287, 61, 2, 1 },
	{ 1157, 55, 2, 1 },
	{ 1014, 48, 2, 1 },
	{ 910,  43, 2, 1 },
	{ 806,  38, 2, 1 },
	{ 689,  33, 2, 2 },
	{ 520,  25, 2, 2 },
	{ 338,  16, 2, 4 },

	{ 2496, 99, 1, 1 },	/* L */
	{ 2418, 95, 1, 1 },
	{ 2340, 91, 1, 1 },
	{ 2262, 87, 1, 1 },
	{ 2171, 82, 1, 1 },
	{ 2106, 77, 1, 1 },
	{ 2028, 72, 1, 1 },
	{ 1963, 67, 1, 1 },
	{ 1833, 61, 1, 1 },
	{ 1664, 55, 1, 1 },
	{ 1469, 48, 2, 1 },
	{ 1313, 43, 2, 1 },
	{ 1157, 38, 2, 1 },
	{ 1001, 33, 2, 1 },
	{ 767,  25, 2, 1 },
	{ 520,  16, 2, 2 },

	{ 1092, 99, 2, 1 },	/* CCI */
	{ 1066, 95, 2, 1 },
	{ 1040, 91, 2, 1 },
	{ 1014, 87, 2, 1 },
	{ 975,  82, 2, 1 },
	{ 923,  77, 2, 1 },
	{ 871,  72, 2, 1 },
	{ 819,  67, 2, 1 },
	{ 767,  61, 2, 1 },
	{ 689,  55, 2, 2 },
	{ 624,  48, 2, 2 },
	{ 559,  43, 2, 2 },
	{ 494,  38, 2, 2 },
	{ 429,  33, 2, 2 },
	{ 325,  25, 2, 4 },
	{ 195,  16, 2, 4 },
};

unsigned int *xrecordTbl[NUM_CPU_LEVEL] = {	/* v1.1 */
	[CPU_LEVEL_0] = &fyTbl[0][0],
	[CPU_LEVEL_1] = &fy2Tbl[0][0],
	[CPU_LEVEL_2] = &sb2Tbl[0][0],
	[CPU_LEVEL_3] = &fy3Tbl[0][0],
	[CPU_LEVEL_4] = &sb3Tbl[0][0],
};
