/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _MTK_DEFEEM_
#define _MTK_DEFEEM_

#ifdef __KERNEL__
	#include <linux/kernel.h>
#endif

#ifdef __KERNEL__
	#define EEMCONF_S		0x0012A010
	#define EEMCONF_E		0x0012A250
	#define EEMCONF_SIZE	(EEMCONF_E - EEMCONF_S)

	extern void __iomem *eem_base;
	#define EEM_BASEADDR eem_base

	#ifdef CONFIG_OF
	struct devinfo_ptp_tag {
		u32 size;
		u32 tag;
		u32 volt0;
		u32 volt1;
		u32 volt2;
		u32 have_550;
	};
	#endif
#else
	#define EEM_BASEADDR		(0x1100B000)
	#define eem_base EEM_BASEADDR
#endif

#define EEM_TEMPMONCTL0		(EEM_BASEADDR + 0x000)
#define EEM_TEMPMONCTL1		(EEM_BASEADDR + 0x004)
#define EEM_TEMPMONCTL2		(EEM_BASEADDR + 0x008)
#define EEM_TEMPMONINT		(EEM_BASEADDR + 0x00C)
#define EEM_TEMPMONINTSTS		(EEM_BASEADDR + 0x010)
#define EEM_TEMPMONIDET0		(EEM_BASEADDR + 0x014)
#define EEM_TEMPMONIDET1		(EEM_BASEADDR + 0x018)
#define EEM_TEMPMONIDET2		(EEM_BASEADDR + 0x01C)

#define EEM_TEMPH2NTHRE			(EEM_BASEADDR + 0x024)
#define EEM_TEMPHTHRE			(EEM_BASEADDR + 0x028)
#define EEM_TEMPCTHRE			(EEM_BASEADDR + 0x02C)
#define EEM_TEMPOFFSETH			(EEM_BASEADDR + 0x030)
#define EEM_TEMPOFFSETL			(EEM_BASEADDR + 0x034)
#define EEM_TEMPMSRCTL0			(EEM_BASEADDR + 0x038)
#define EEM_TEMPMSRCTL1			(EEM_BASEADDR + 0x03C)
#define EEM_TEMPAHBPOLL			(EEM_BASEADDR + 0x040)
#define EEM_TEMPAHBTO			(EEM_BASEADDR + 0x044)
#define EEM_TEMPADCPNP0			(EEM_BASEADDR + 0x048)
#define EEM_TEMPADCPNP1			(EEM_BASEADDR + 0x04C)
#define EEM_TEMPADCPNP2			(EEM_BASEADDR + 0x050)
#define EEM_TEMPADCMUX			(EEM_BASEADDR + 0x054)
#define EEM_TEMPADCEXT			(EEM_BASEADDR + 0x058)
#define EEM_TEMPADCEXT1			(EEM_BASEADDR + 0x05C)
#define EEM_TEMPADCEN			(EEM_BASEADDR + 0x060)
#define EEM_TEMPPNPMUXADDR		(EEM_BASEADDR + 0x064)
#define EEM_TEMPADCMUXADDR		(EEM_BASEADDR + 0x068)
#define EEM_TEMPADCEXTADDR		(EEM_BASEADDR + 0x06C)
#define EEM_TEMPADCEXT1ADDR		(EEM_BASEADDR + 0x070)
#define EEM_TEMPADCENADDR		(EEM_BASEADDR + 0x074)
#define EEM_TEMPADCVALIDADDR	(EEM_BASEADDR + 0x078)
#define EEM_TEMPADCVOLTADDR		(EEM_BASEADDR + 0x07C)
#define EEM_TEMPRDCTRL			(EEM_BASEADDR + 0x080)
#define EEM_TEMPADCVALIDMASK	(EEM_BASEADDR + 0x084)
#define EEM_TEMPADCVOLTAGESHIFT (EEM_BASEADDR + 0x088)
#define EEM_TEMPADCWRITECTRL	(EEM_BASEADDR + 0x08C)
#define EEM_TEMPMSR0			(EEM_BASEADDR + 0x090)
#define EEM_TEMPMSR1			(EEM_BASEADDR + 0x094)
#define EEM_TEMPMSR2			(EEM_BASEADDR + 0x098)

#define EEM_TEMPIMMD0		(EEM_BASEADDR + 0x0A0)
#define EEM_TEMPIMMD1		(EEM_BASEADDR + 0x0A4)
#define EEM_TEMPIMMD2		(EEM_BASEADDR + 0x0A8)

#define EEM_TEMPMONIDET3	(EEM_BASEADDR + 0x0B0)
#define EEM_TEMPADCPNP3		(EEM_BASEADDR + 0x0B4)
#define EEM_TEMPMSR3		(EEM_BASEADDR + 0x0B8)
#define EEM_TEMPIMMD3		(EEM_BASEADDR + 0x0BC)
#define EEM_TEMPPROTCTL		(EEM_BASEADDR + 0x0C0)
#define EEM_TEMPPROTTA		(EEM_BASEADDR + 0x0C4)
#define EEM_TEMPPROTTB		(EEM_BASEADDR + 0x0C8)
#define EEM_TEMPPROTTC		(EEM_BASEADDR + 0x0CC)

#define EEM_TEMPSPARE0		(EEM_BASEADDR + 0x0F0)
#define EEM_TEMPSPARE1		(EEM_BASEADDR + 0x0F4)
#define EEM_TEMPSPARE2		(EEM_BASEADDR + 0x0F8)
#define EEM_TEMPSPARE3		(EEM_BASEADDR + 0x0FC)

#define EEM_DESCHAR			(EEM_BASEADDR + 0xC00)
#define EEM_TEMPCHAR		(EEM_BASEADDR + 0xC04)
#define EEM_DETCHAR			(EEM_BASEADDR + 0xC08)
#define EEM_AGECHAR			(EEM_BASEADDR + 0xC0C)
#define EEM_DCCONFIG		(EEM_BASEADDR + 0xC10)
#define EEM_AGECONFIG		(EEM_BASEADDR + 0xC14)
#define EEM_FREQPCT30		(EEM_BASEADDR + 0xC18)
#define EEM_FREQPCT74		(EEM_BASEADDR + 0xC1C)
#define EEM_LIMITVALS		(EEM_BASEADDR + 0xC20)
#define EEM_VBOOT		(EEM_BASEADDR + 0xC24)
#define EEM_DETWINDOW		(EEM_BASEADDR + 0xC28)
#define EEMCONFIG		(EEM_BASEADDR + 0xC2C)
#define EEM_TSCALCS		(EEM_BASEADDR + 0xC30)
#define EEM_RUNCONFIG		(EEM_BASEADDR + 0xC34)
#define EEMEN			(EEM_BASEADDR + 0xC38)
#define EEM_INIT2VALS		(EEM_BASEADDR + 0xC3C)
#define EEM_DCVALUES		(EEM_BASEADDR + 0xC40)
#define EEM_AGEVALUES		(EEM_BASEADDR + 0xC44)
#define EEM_VOP30		(EEM_BASEADDR + 0xC48)
#define EEM_VOP74		(EEM_BASEADDR + 0xC4C)
#define TEMP			(EEM_BASEADDR + 0xC50)
#define EEMINTSTS		(EEM_BASEADDR + 0xC54)
#define EEMINTSTSRAW		(EEM_BASEADDR + 0xC58)
#define EEMINTEN		(EEM_BASEADDR + 0xC5C)

#define EEM_CHKSHIFT		(EEM_BASEADDR + 0xC64)

#define EEM_VDESIGN30		(EEM_BASEADDR + 0xC6C)
#define EEM_VDESIGN74		(EEM_BASEADDR + 0xC70)

#define EEM_AGECOUNT		(EEM_BASEADDR + 0xC7C)
#define EEM_SMSTATE0		(EEM_BASEADDR + 0xC80)
#define EEM_SMSTATE1		(EEM_BASEADDR + 0xC84)
#define EEM_CTL0			(EEM_BASEADDR + 0xC88)

#define EEMCORESEL		(EEM_BASEADDR + 0xF00)
#define EEM_THERMINTST		(EEM_BASEADDR + 0xF04)
#define EEMODINTST		(EEM_BASEADDR + 0xF08)
#define EEM_THSTAGE0ST		(EEM_BASEADDR + 0xF0C)
#define EEM_THSTAGE1ST		(EEM_BASEADDR + 0xF10)
#define EEM_THSTAGE2ST		(EEM_BASEADDR + 0xF14)
#define EEM_THAHBST0		(EEM_BASEADDR + 0xF18)
#define EEM_THAHBST1		(EEM_BASEADDR + 0xF1C)
#define EEMSPARE0		(EEM_BASEADDR + 0xF20)
#define EEMSPARE1		(EEM_BASEADDR + 0xF24)
#define EEMSPARE2		(EEM_BASEADDR + 0xF28)
#define EEMSPARE3		(EEM_BASEADDR + 0xF2C)
#define EEM_THSLPEVEB		(EEM_BASEADDR + 0xF30)

#endif
