
/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _MTK_EEM_INTERNAL_SSPM_H_
#define _MTK_EEM_INTERNAL_SSPM_H_

struct eem_det;
struct eem_ctrl;

enum {
	IPI_EEM_INIT,
	IPI_EEM_PROBE,
	IPI_EEM_INIT01,
	IPI_EEM_INIT02,
	IPI_EEM_DEBUG_PROC_WRITE,
	IPI_EEM_VCORE_INIT,
	IPI_EEM_VCORE_UPDATE_PROC_WRITE,
	IPI_EEM_SEND_UPOWER_TBL_REF,

	#ifdef EEM_CUR_VOLT_PROC_SHOW
	IPI_EEM_CUR_VOLT_PROC_SHOW,
	#endif

	#ifdef EEM_OFFSET
	IPI_EEM_OFFSET_PROC_WRITE,
	#endif

	#ifdef EEM_LOG_EN
	IPI_EEM_LOGEN_PROC_SHOW,
	IPI_EEM_LOGEN_PROC_WRITE,
	#endif
	/* IPI_EEM_VCORE_GET_VOLT,*/
	/* IPI_EEM_GPU_DVFS_GET_STATUS,*/
	NR_EEM_IPI,
};

struct eem_ipi_data {
	unsigned int cmd;
	union {
		struct {
			unsigned int arg[3];
		} data;
	} u;
};

struct eem_det_ops {
	/* interface to PMIC */
	int (*volt_2_pmic)(struct eem_det *det, int volt);
	int (*volt_2_eem)(struct eem_det *det, int volt);
	int (*pmic_2_volt)(struct eem_det *det, int pmic_val);
	int (*eem_2_pmic)(struct eem_det *det, int eev_val);
};

/* define as same as the struct in sspm */
struct eem_det {
	int temp; /* det temperature */
	/* slope */
	unsigned int MTS;
	unsigned int BTS;
	unsigned int t250;

	/* constant */
	unsigned int AGECONFIG;
	unsigned int DCCONFIG;

	/* dvfs */
	/* maximum frequency used to calculate percentage */
	unsigned int max_freq_khz;

	/* for debug */
	unsigned int dcvalues[NR_EEM_PHASE];
	unsigned int eem_26c[NR_EEM_PHASE];
	unsigned int vop30[NR_EEM_PHASE];

	struct eem_det_ops *ops;
	enum eem_ctrl_id ctrl_id;

	unsigned short volt_tbl_pmic[NR_FREQ]; /* pmic value */

	/* Generated by EEM init01. Used in EEM init02 */
	unsigned short DCVOFFSETIN;
	unsigned short AGEVOFFSETIN;

	/* constant */
	unsigned short DETWINDOW;
	unsigned short DETMAX;

	/* for PMIC */
	unsigned short eem_v_base;
	unsigned short eem_step;
	unsigned short pmic_base;
	unsigned short pmic_step;

	/* dvfs */
	unsigned char freq_tbl[NR_FREQ]; /* percentage to maximum freq */
	unsigned char volt_tbl[NR_FREQ]; /* pmic value */
	/* unsigned char volt_tbl_init2[NR_FREQ]; *//* pmic value */
	/*unsigned int volt_tbl_bin[NR_FREQ];*/

	unsigned char features; /* enum eem_features */

	unsigned char BDES;
	unsigned char MDES;
	unsigned char DCBDET;
	unsigned char DCMDET;
	unsigned char AGEDELTA;
	unsigned char MTDES;

	unsigned char VMAX;
	unsigned char VMIN;
	unsigned char DTHI;
	unsigned char DTLO;
	unsigned char VBOOT;
	unsigned char AGEM;
	unsigned char DVTFIXED;
	unsigned char VCO;

	const char *name;
	/*only when init2, eem need to set volt to upower*/
	unsigned char set_volt_to_upower;
	unsigned char real_vboot;

	/* devinfo */
	unsigned char EEMINITEN;
	unsigned char EEMMONEN;
	unsigned char disabled; /* Disabled by error or sysfs */
	unsigned char num_freq_tbl;

	/* for debug */
	unsigned char eem_eemEn[NR_EEM_PHASE];

	#ifdef EEM_OFFSET
	signed char volt_offset;
	#endif

	/* char pi_offset; */
};


struct eem_log_det {
	enum eem_ctrl_id ctrl_id;
	unsigned char num_freq_tbl;
	unsigned int dcvalues[NR_EEM_PHASE];
	unsigned int freqpct30[NR_EEM_PHASE];
	unsigned int eem_26c[NR_EEM_PHASE];
	unsigned int vop30[NR_EEM_PHASE];
	unsigned int eem_eemEn[NR_EEM_PHASE];
	unsigned int temp;

	/* orig volt table for restoreing to dvfs*/
	unsigned short volt_tbl_orig[NR_FREQ];
	unsigned char volt_tbl_init2[NR_FREQ];
	unsigned char volt_tbl[NR_FREQ];
	unsigned short volt_tbl_pmic[NR_FREQ];
	unsigned char freq_tbl[NR_FREQ];
	unsigned char lock;
	#if DUMP_DATA_TO_DE
	unsigned int reg_dump_data[ARRAY_SIZE(reg_dump_addr_off)][NR_EEM_PHASE];
	#endif
};

struct eem_log {
	unsigned int hw_res[NR_HW_RES];
	struct eem_log_det det_log[NR_EEM_DET];
};

extern struct eem_det_ops big_det_ops;
extern struct eem_det_ops gpu_det_ops;
extern struct eem_det_ops soc_det_ops;
extern struct eem_det_ops little_det_ops;
extern struct eem_det_ops dual_little_det_ops;
extern struct eem_det_ops cci_det_ops;
extern struct eem_det_ops dmy_det_ops;

/* for upower */
extern int mt_eem_send_upower_table_ref(
phys_addr_t phy_addr, unsigned long long size);
#endif
