/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#ifndef __MTK_SPOWER_DATA_MTK6763_H__
#define __MTK_SPOWER_DATA_MTK6763_H__

/* Data: M17 pre 20170106 */
#include "mtk_static_power.h"
#define VSIZE 14
#define TSIZE 22
#define MAX_TABLE_SIZE 3

/* sheet name : ClusterL_Core */
#define CPUL_TABLE_0 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 11434, 12944, 14555, 16275, 18094, 20063, 22234, \
		24526, 26933, 29485, 32148, 34980, 37977, 41156, \
	25, 13511, 15293, 17195, 19231, 21413, 23734, 26216, \
		28859, 31659, 34777, 37923, 41176, 44652, 48391, \
	30, 15904, 18006, 20250, 22668, 25244, 27996, 30940, \
		34092, 37457, 40991, 44705, 48674, 53111, 57726, \
	35, 18631, 21096, 23758, 26599, 29643, 32889, 36377, \
		40101, 44062, 48251, 52648, 57300, 62301, 67590, \
	40, 21788, 24697, 27821, 31164, 34773, 38636, 42759, \
		47148, 51755, 56594, 61780, 67359, 73315, 79379, \
	45, 25412, 28835, 32489, 36438, 40714, 45268, 50125, \
		55285, 60650, 66316, 72501, 78999, 85835, 92936, \
	50, 29590, 33573, 37849, 42508, 47506, 52846, 58543, \
		64620, 71044, 77739, 84705, 92206, 100031, 109122, \
	55, 34332, 38956, 43997, 49419, 55231, 61451, 68118, \
		75258, 82723, 90509, 98646, 107150, 116542, 126446, \
	60, 39731, 45145, 51046, 57380, 64117, 71282, 78952, \
		87032, 95592, 104651, 114222, 124350, 135138, 146693, \
	65, 45344, 51658, 58455, 65730, 73316, 81436, 90184, \
		99580, 109659, 120380, 132109, 144064, 156856, 170255, \
	70, 52285, 59638, 67460, 75763, 84639, 94117, 104260, \
		115061, 126522, 138693, 151605, 164881, 179298, 194903, \
	75, 60038, 68280, 77037, 86588, 96746, 107600, 119227, \
		131849, 145034, 159045, 173991, 189780, 206542, 224464, \
	80, 68608, 77971, 88168, 99075, 110479, 122897, 136152, \
		150743, 166298, 182427, 199592, 217831, 237228, 257865, \
	85, 78713, 89531, 101178, 113689, 127115, 141500, 156909, \
		173302, 190678, 208703, 226799, 246957, 269210, 292999, \
	90, 89056, 101353, 114406, 128420, 143450, 159551, 176756, \
		195153, 214955, 236084, 258629, 282633, 308194, 335418, \
	95, 100312, 113947, 129271, 145971, 163314, 181824, 201609, \
		222785, 245395, 269507, 295177, 322504, 351650, 382646, \
	100, 114228, 130045, 146922, 165319, 184880, 205545, 227274, \
		252279, 277867, 305235, 334470, 365569, 398643, 433637, \
	105, 127637, 145421, 164468, 185003, 207052, 230672, 255845, \
		282829, 311685, 342568, 376965, 413182, 450700, 490440, \
	110, 145486, 165633, 187063, 210493, 235509, 262303, 290590, \
		320847, 353260, 387895, 424723, 464053, 506057, 550967, \
	115, 162565, 185517, 209453, 236282, 264451, 294708, 327150, \
		361844, 398856, 438384, 480528, 524357, 571380, 622060, \
	120, 180885, 206462, 234465, 264271, 295596, 329493, 366049, \
		405201, 447075, 491749, 539274, 589741, 643575, 700872, \
	125, 202268, 230342, 261941, 295256, 330308, 368103, 408516, \
		451761, 498524, 548437, 601824, 658623, 718959, 783183, \
}

#define CPUL_TABLE_1 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 3320, 3720, 4146, 4598, 5073, 5571, 6085, \
		6618, 7158, 7701, 8249, 8754, 9194, 9501, \
	25, 4007, 4492, 5012, 5559, 6130, 6735, 7357, \
		7993, 8643, 9307, 9975, 10638, 11221, 11684, \
	30, 4810, 5398, 6027, 6672, 7360, 8085, 8831, \
		9603, 10400, 11208, 12040, 12852, 13602, 14267, \
	35, 5791, 6503, 7235, 8019, 8843, 9717, 10637, \
		11586, 12570, 13580, 14590, 15569, 16502, 17377, \
	40, 6919, 7749, 8623, 9557, 10528, 11569, 12661, \
		13808, 15001, 16208, 17442, 18658, 19828, 20910, \
	45, 8228, 9195, 10242, 11343, 12478, 13699, 14992, \
		16348, 17765, 19238, 20703, 22178, 23642, 25030, \
	50, 9728, 10878, 12119, 13408, 14763, 16205, 17732, \
		19340, 21019, 22756, 24516, 26287, 28047, 29751, \
	55, 11473, 12846, 14291, 15826, 17446, 19163, 20956, \
		22819, 24776, 26853, 29015, 31210, 33369, 35473, \
	60, 13460, 15074, 16737, 18498, 20412, 22428, 24500, \
		26706, 29040, 31504, 34092, 36736, 39348, 41922, \
	65, 15754, 17586, 19536, 21631, 23863, 26183, 28635, \
		31212, 33940, 36809, 39813, 42953, 46076, 49168, \
	70, 18358, 20487, 22768, 25197, 27736, 30432, 33248, \
		36230, 39415, 42758, 46248, 49891, 53623, 57290, \
	75, 21287, 23792, 26413, 29228, 32165, 35246, 38500, \
		41970, 45655, 49564, 53674, 57963, 62392, 66803, \
	80, 24542, 27449, 30480, 33677, 37059, 40657, 44483, \
		48493, 52731, 57244, 61976, 66912, 71992, 77179, \
	85, 28229, 31577, 35070, 38794, 42725, 46875, 51251, \
		55910, 60830, 66028, 71470, 77153, 83063, 89181, \
	90, 32339, 36268, 40304, 44579, 49110, 53882, 58955, \
		64307, 69944, 75888, 82115, 88660, 95557, 102628, \
	95, 36972, 41447, 46109, 50944, 56122, 61581, 67374, \
		73458, 79913, 86745, 93960, 101529, 109350, 117459, \
	100, 42083, 47164, 52508, 58004, 63886, 70086, 76690, \
		83655, 91071, 98887, 107030, 115585, 124494, 133964, \
	105, 47651, 53382, 59413, 65703, 72364, 79442, 86963, \
		94846, 103130, 111908, 121208, 131015, 141200, 151982, \
	110, 53888, 60223, 67064, 74226, 81764, 89752, 98175, \
		107104, 116478, 126403, 136903, 147920, 159471, 171503, \
	115, 60693, 67821, 75373, 83382, 91922, 100872, 110313, \
		120323, 130844, 141947, 153724, 166182, 179285, 192922, \
	120, 68011, 76005, 84386, 93291, 102832, 112847, 123420, \
		134520, 146219, 158617, 171876, 185831, 200415, 215797, \
	125, 75651, 84659, 94224, 104206, 114822, 125809, 137512, \
		149897, 162971, 176798, 191229, 206525, 222803, 239943, \
}

#define CPUL_TABLE_2 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 461, 511, 560, 615, 671, 733, 796, \
		860, 919, 963, 984, 973, 905, 746, \
	25, 576, 634, 696, 762, 838, 916, 997, \
		1073, 1153, 1226, 1272, 1291, 1214, 1061, \
	30, 722, 799, 879, 958, 1043, 1143, 1246, \
		1351, 1460, 1555, 1628, 1664, 1621, 1491, \
	35, 894, 989, 1082, 1187, 1302, 1420, 1546, \
		1672, 1799, 1923, 2039, 2093, 2092, 2003, \
	40, 1104, 1215, 1327, 1459, 1598, 1749, 1907, \
		2070, 2233, 2397, 2549, 2647, 2682, 2628, \
	45, 1350, 1483, 1625, 1777, 1940, 2121, 2318, \
		2519, 2729, 2943, 3126, 3268, 3371, 3360, \
	50, 1643, 1778, 1950, 2144, 2348, 2570, 2802, \
		3048, 3310, 3567, 3825, 4041, 4192, 4257, \
	55, 1973, 2146, 2356, 2588, 2827, 3086, 3368, \
		3666, 3980, 4303, 4622, 4908, 5132, 5312, \
	60, 2373, 2591, 2843, 3109, 3389, 3686, 4015, \
		4370, 4747, 5146, 5559, 5912, 6255, 6477, \
	65, 2831, 3077, 3364, 3664, 3983, 4338, 4752, \
		5149, 5598, 6047, 6557, 7095, 7559, 7894, \
	70, 3338, 3651, 3972, 4321, 4701, 5108, 5545, \
		6017, 6543, 7076, 7604, 8161, 8694, 9206, \
	75, 4007, 4360, 4749, 5150, 5601, 6074, 6584, \
		7146, 7748, 8405, 9068, 9735, 10389, 11037, \
	80, 4809, 5205, 5632, 6093, 6607, 7158, 7741, \
		8389, 9087, 9845, 10665, 11491, 12294, 13103, \
	85, 5684, 6154, 6598, 7153, 7743, 8361, 9064, \
		9833, 10638, 11496, 12407, 13366, 14390, 15553, \
	90, 6639, 7184, 7747, 8362, 9070, 9786, 10580, \
		11452, 12377, 13379, 14452, 15605, 17007, 18300, \
	95, 7779, 8353, 9041, 9762, 10546, 11376, 12268, \
		13232, 14283, 15454, 16810, 18272, 19712, 21156, \
	100, 9206, 9841, 10653, 11376, 12229, 13183, 14192, \
		15382, 16662, 18000, 19508, 21129, 22799, 24676, \
	105, 10580, 11375, 12245, 13126, 14102, 15249, 16469, \
		17831, 19293, 20771, 22357, 24229, 26298, 28532, \
	110, 12313, 13125, 14128, 15098, 16262, 17550, 18823, \
		20230, 21770, 23495, 25410, 27540, 29905, 32585, \
	115, 14066, 15099, 16153, 17343, 18620, 19941, 21407, \
		23067, 24858, 26821, 29052, 31447, 34065, 36930, \
	120, 16209, 17290, 18395, 19638, 21064, 22615, 24296, \
		26070, 28049, 30237, 32736, 35393, 38273, 41461, \
	125, 18572, 19856, 21068, 22430, 23881, 25523, 27303, \
		29277, 31579, 34037, 36716, 39532, 42595, 46036, \
}

/* sheet name : ClusterL_nCPU */
#define CPUL_CLUSTER_TABLE_0 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 11741, 13305, 14970, 16769, 18744, 20806, 23129, \
		25624, 28177, 30871, 33814, 36991, 40389, 43929, \
	25, 13808, 15658, 17639, 19768, 22047, 24472, 27085, \
		29868, 32901, 36218, 39699, 43365, 47171, 51350, \
	30, 16261, 18393, 20718, 23191, 25864, 28737, 31815, \
		34973, 38414, 42144, 46154, 50311, 54782, 59523, \
	35, 19056, 21588, 24280, 27194, 30253, 33483, 36954, \
		40693, 44638, 48911, 53688, 58829, 64063, 69479, \
	40, 22321, 25241, 28376, 31693, 35147, 38865, 42770, \
		46948, 51639, 56951, 62532, 68065, 73911, 80536, \
	45, 26042, 29415, 33046, 36799, 40691, 44993, 49478, \
		54322, 59960, 66210, 72282, 78591, 85281, 92758, \
	50, 30212, 34105, 38265, 42461, 47012, 51863, 56964, \
		62425, 68438, 75412, 82839, 90418, 98883, 106735, \
	55, 34916, 39428, 44012, 48807, 53996, 59458, 65246, \
		71454, 78521, 86065, 94403, 103646, 112405, 122072, \
	60, 40480, 45392, 50599, 56032, 61887, 68273, 74952, \
		82438, 90366, 98831, 108084, 118041, 128683, 140042, \
	65, 46363, 51802, 57743, 63874, 71315, 79490, 88337, \
		96721, 105621, 115159, 125487, 136309, 147676, 159573, \
	70, 52917, 59128, 65819, 72997, 80757, 89070, 97974, \
		107677, 117705, 128568, 140295, 154287, 167969, 181117, \
	75, 60042, 67279, 75191, 82896, 91609, 101171, 111346, \
		122085, 133488, 145971, 158904, 172528, 187101, 202437, \
	80, 67953, 76144, 84296, 93447, 104403, 115201, 126681, \
		138904, 151913, 165509, 180131, 195506, 211836, 228869, \
	85, 76848, 86320, 96183, 106564, 117743, 129580, 141332, \
		154410, 168383, 183094, 202818, 220815, 238256, 257368, \
	90, 88582, 98634, 110006, 121949, 134669, 148280, 162868, \
		178151, 193581, 209983, 227365, 246162, 265427, 285436, \
	95, 99210, 111310, 124164, 137589, 151640, 166914, 183160, \
		200199, 218160, 237190, 257533, 279057, 301449, 325401, \
	100, 111306, 124595, 138995, 153352, 169358, 186779, 204874, \
		223957, 244347, 265657, 288153, 312092, 337295, 364291, \
	105, 123515, 138291, 154023, 170408, 188085, 206726, 227236, \
		249049, 271976, 295377, 320139, 346671, 374307, 404220, \
	110, 136157, 152600, 170699, 188895, 208508, 229086, 250413, \
		273415, 297824, 323713, 351755, 381916, 413296, 445044, \
	115, 152229, 170472, 190042, 208191, 229385, 251678, 275330, \
		301101, 327904, 356182, 385911, 420738, 456708, 493701, \
	120, 167768, 188735, 210437, 233164, 257125, 281442, 306468, \
		333005, 361049, 390874, 422653, 456871, 493305, 532644, \
	125, 183938, 206006, 231120, 256515, 283492, 311746, 341249, \
		372241, 402928, 435226, 470710, 508333, 547397, 586840, \
}

#define CPUL_CLUSTER_TABLE_1 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 3469, 3910, 4383, 4911, 5507, 6151, 6869, \
		7665, 8528, 9490, 10544, 11652, 12745, 13796, \
	25, 4188, 4697, 5238, 5840, 6518, 7298, 8143, \
		9073, 10123, 11216, 12452, 13710, 15045, 16346, \
	30, 5041, 5633, 6252, 6967, 7738, 8611, 9609, \
		10745, 11975, 13298, 14694, 16179, 17769, 19333, \
	35, 6040, 6692, 7435, 8257, 9181, 10235, 11404, \
		12691, 14083, 15614, 17296, 19087, 20930, 22764, \
	40, 7178, 7948, 8811, 9769, 10858, 12092, 13405, \
		14863, 16495, 18296, 20237, 22376, 24589, 26883, \
	45, 8499, 9408, 10412, 11520, 12806, 14171, 15683, \
		17386, 19285, 21371, 23640, 26139, 28815, 31565, \
	50, 10037, 11077, 12223, 13547, 14981, 16562, 18331, \
		20282, 22482, 24907, 27543, 30430, 33618, 36845, \
	55, 11849, 13019, 14364, 15883, 17565, 19394, 21428, \
		23668, 26147, 28903, 31905, 35317, 39004, 42931, \
	60, 13899, 15292, 16865, 18606, 20465, 22513, 24870, \
		27386, 30199, 33357, 36834, 40699, 44908, 49522, \
	65, 16325, 17933, 19688, 21615, 23717, 26060, 28673, \
		31587, 34835, 38418, 42443, 46849, 51714, 57071, \
	70, 19105, 20923, 22904, 25064, 27480, 30139, 33109, \
		36415, 40042, 44136, 48646, 53680, 59105, 65559, \
	75, 22271, 24334, 26598, 29078, 31807, 34837, 38190, \
		41855, 45950, 50493, 55602, 61313, 67685, 74883, \
	80, 25934, 28224, 30737, 33534, 36593, 39993, 43774, \
		47918, 52476, 57680, 63480, 69976, 77300, 85460, \
	85, 30061, 32612, 35512, 38606, 42030, 45883, 50008, \
		54579, 59779, 65623, 72254, 79597, 87884, 97304, \
	90, 34802, 37593, 40809, 44295, 48054, 52174, 56759, \
		61917, 67798, 74449, 81928, 90068, 99544, 110200, \
	95, 40062, 43132, 46767, 50711, 54823, 59525, 64686, \
		70600, 77148, 84440, 92551, 101750, 112471, 124241, \
	100, 46093, 49622, 53461, 57929, 62555, 67730, 73289, \
		79726, 86926, 95000, 104244, 114760, 126354, 139379, \
	105, 52977, 56859, 61143, 66052, 71258, 76926, 83109, \
		90160, 98307, 107321, 117232, 128475, 141141, 155680, \
	110, 60263, 65076, 69667, 74858, 80573, 87014, 94096, \
		101828, 110614, 120259, 130801, 143263, 157631, 174055, \
	115, 68644, 74079, 79664, 85340, 91551, 98539, 106236, \
		114460, 124012, 134535, 146220, 159668, 175286, 192152, \
	120, 77955, 83908, 90252, 96808, 103770, 111305, 119543, \
		128591, 138844, 150226, 162898, 177529, 194195, 211834, \
	125, 89070, 95203, 101923, 109086, 116263, 124363, 133208, \
		143129, 154321, 166610, 180714, 196552, 213693, 233774, \
}

#define CPUL_CLUSTER_TABLE_2 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 566, 631, 715, 822, 950, 1097, 1287, \
		1515, 1794, 2121, 2551, 3066, 3701, 4510, \
	25, 687, 768, 864, 978, 1116, 1287, 1493, \
		1743, 2058, 2421, 2883, 3450, 4190, 5035, \
	30, 835, 928, 1046, 1176, 1335, 1526, 1766, \
		2039, 2382, 2806, 3326, 3978, 4786, 5729, \
	35, 1012, 1117, 1235, 1383, 1571, 1787, 2043, \
		2382, 2797, 3282, 3896, 4631, 5500, 6613, \
	40, 1226, 1342, 1482, 1659, 1863, 2103, 2410, \
		2782, 3244, 3788, 4469, 5309, 6298, 7608, \
	45, 1489, 1619, 1776, 1972, 2205, 2482, 2826, \
		3252, 3743, 4350, 5126, 6082, 7232, 8734, \
	50, 1791, 1939, 2123, 2337, 2603, 2907, 3301, \
		3766, 4318, 5052, 5911, 6989, 8381, 10094, \
	55, 2165, 2334, 2535, 2767, 3068, 3424, 3835, \
		4357, 5007, 5867, 6873, 8060, 9628, 11606, \
	60, 2583, 2794, 3011, 3277, 3621, 4039, 4515, \
		5096, 5845, 6773, 7887, 9370, 11051, 13271, \
	65, 3070, 3264, 3535, 3838, 4196, 4679, 5236, \
		5924, 6801, 7945, 9126, 10796, 12697, 15307, \
	70, 3695, 3914, 4186, 4490, 4876, 5360, 5982, \
		6738, 7615, 8796, 10367, 12263, 14579, 17542, \
	75, 4446, 4687, 4939, 5280, 5693, 6276, 6974, \
		7821, 8877, 10141, 11827, 13903, 16584, 19859, \
	80, 5338, 5634, 5930, 6305, 6767, 7385, 8198, \
		9136, 10280, 11738, 13582, 16030, 19229, 23043, \
	85, 6526, 6789, 7129, 7503, 7991, 8711, 9504, \
		10470, 11881, 13602, 15778, 18615, 21894, 26239, \
	90, 7852, 8160, 8495, 8967, 9558, 10315, 11227, \
		12439, 14035, 15980, 18354, 21316, 25208, 30013, \
	95, 9437, 9822, 10086, 10621, 11263, 12109, 13240, \
		14723, 16376, 18402, 20972, 24292, 28519, 34437, \
	100, 11236, 11583, 12072, 12652, 13271, 14180, 15500, \
		17021, 18876, 21199, 23892, 27688, 32800, 39312, \
	105, 13796, 14055, 14528, 15193, 15923, 16795, 18170, \
		19770, 21791, 24407, 27869, 31965, 37219, 43989, \
	110, 16666, 16986, 17296, 18035, 18760, 19739, 21297, \
		23225, 25399, 28088, 31501, 36108, 41936, 48674, \
	115, 20038, 20315, 20719, 21352, 22149, 23314, 24732, \
		26533, 28795, 31722, 35504, 40368, 46373, 53744, \
	120, 23946, 24254, 24533, 25161, 25693, 26820, 28496, \
		30454, 33028, 36150, 40015, 44914, 51719, 61072, \
	125, 28564, 28630, 28868, 29431, 30256, 31406, 32979, \
		35051, 37787, 40993, 45382, 51278, 58758, 68885, \
}

/* sheet name : ClusterLL_Core */
#define CPULL_TABLE_0 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 1903, 2198, 2532, 2829, 3121, 3433, 3676, \
		3986, 4437, 4799, 5131, 5426, 5904, 6472, \
	25, 2248, 2538, 2925, 3334, 3735, 4155, 4599, \
		5056, 5495, 5850, 6250, 6889, 7503, 8089, \
	30, 2685, 3126, 3607, 4070, 4498, 4930, 5457, \
		6054, 6695, 7320, 7846, 8281, 8897, 9881, \
	35, 3346, 3888, 4402, 4846, 5303, 5775, 6312, \
		7004, 7762, 8569, 9439, 10288, 11027, 11606, \
	40, 4043, 4617, 5185, 5696, 6224, 6789, 7393, \
		8165, 9002, 9903, 10900, 11990, 13103, 14131, \
	45, 4765, 5434, 6044, 6617, 7225, 7854, 8625, \
		9503, 10439, 11438, 12552, 13764, 15088, 16383, \
	50, 5579, 6343, 7000, 7649, 8339, 9229, 10149, \
		11108, 12127, 13261, 14468, 15812, 17270, 18854, \
	55, 6520, 7368, 8100, 8875, 9860, 10852, 11910, \
		13036, 14248, 15578, 16965, 18555, 20325, 21993, \
	60, 7650, 8522, 9341, 10359, 11452, 12598, 13808, \
		15119, 16580, 18168, 19914, 21767, 23600, 25205, \
	65, 9073, 10335, 11629, 12998, 14164, 15519, 16918, \
		18358, 19912, 21529, 23159, 25053, 27211, 29579, \
	70, 10213, 11272, 12550, 13901, 15324, 16862, 18482, \
		20190, 21955, 23954, 26085, 28872, 31274, 33593, \
	75, 11953, 13580, 15177, 16628, 17891, 20211, 21911, \
		23674, 25788, 28027, 30354, 32667, 35206, 37985, \
	80, 13677, 15236, 17315, 19277, 21364, 23575, 25274, \
		26978, 29422, 32009, 34799, 37670, 40658, 43608, \
	85, 15541, 17326, 19259, 21423, 23705, 26129, 28667, \
		31523, 34299, 37124, 40318, 43853, 47142, 50668, \
	90, 17730, 19804, 22256, 24849, 27282, 29960, 32670, \
		35531, 38599, 41866, 45372, 49260, 53311, 56894, \
	95, 19792, 22143, 24737, 27526, 30534, 33700, 36708, \
		39870, 43799, 47883, 51863, 55985, 60367, 64699, \
	100, 21939, 24635, 27486, 30597, 33880, 37667, 42357, \
		45078, 47180, 50216, 53572, 57324, 62154, 66523, \
	105, 25111, 28028, 31239, 34719, 38366, 42213, 46234, \
		50513, 54998, 59683, 64557, 62985, 65534, 69978, \
	110, 26784, 30429, 34365, 38537, 42958, 47804, 52534, \
		57492, 62635, 63696, 68330, 72969, 77913, 83003, \
	115, 29243, 32752, 36437, 40325, 44259, 48623, 53204, \
		57112, 62684, 67665, 72865, 75805, 75128, 76086, \
	120, 32276, 35513, 39061, 42600, 46863, 51191, 56061, \
		60959, 63742, 69808, 70401, 69944, 68520, 73129, \
	125, 33273, 35890, 40397, 45070, 48424, 52770, 56260, \
		57813, 63410, 64676, 69197, 74023, 79182, 84711, \
}

#define CPULL_TABLE_1 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 532, 598, 659, 720, 778, 834, 894, \
		945, 996, 1058, 1124, 1217, 1314, 1375, \
	25, 653, 724, 791, 864, 945, 1027, 1105, \
		1181, 1270, 1353, 1427, 1509, 1590, 1703, \
	30, 822, 911, 995, 1083, 1185, 1273, 1358, \
		1468, 1586, 1697, 1822, 1938, 2034, 2127, \
	35, 993, 1092, 1198, 1311, 1426, 1558, 1684, \
		1811, 1934, 2077, 2230, 2350, 2471, 2647, \
	40, 1208, 1324, 1448, 1571, 1713, 1855, 2015, \
		2184, 2359, 2545, 2720, 2888, 3039, 3207, \
	45, 1448, 1588, 1755, 1920, 2091, 2284, 2471, \
		2662, 2890, 3139, 3366, 3591, 3807, 4030, \
	50, 1753, 1941, 2130, 2339, 2557, 2763, 3001, \
		3262, 3529, 3830, 4159, 4455, 4754, 5045, \
	55, 2115, 2325, 2537, 2764, 2994, 3284, 3581, \
		3880, 4166, 4476, 4860, 5250, 5629, 6020, \
	60, 2499, 2733, 3003, 3310, 3633, 3979, 4338, \
		4711, 5045, 5378, 5805, 6274, 6758, 7206, \
	65, 2947, 3241, 3606, 3972, 4378, 4802, 5216, \
		5642, 6079, 6489, 6957, 7442, 7926, 8533, \
	70, 3467, 3843, 4280, 4735, 5212, 5670, 6142, \
		6637, 7170, 7707, 8275, 8907, 9490, 10086, \
	75, 4081, 4540, 5065, 5597, 6133, 6663, 7251, \
		7862, 8499, 9106, 9736, 10486, 11232, 12022, \
	80, 4802, 5328, 5942, 6544, 7169, 7826, 8539, \
		9285, 10041, 10809, 11517, 12322, 13220, 14039, \
	85, 5672, 6252, 6934, 7597, 8303, 9022, 9793, \
		10650, 11547, 12451, 13350, 14267, 15244, 16300, \
	90, 6580, 7283, 8060, 8847, 9656, 10460, 11381, \
		12366, 13372, 14418, 15521, 16621, 17733, 19025, \
	95, 7654, 8513, 9401, 10267, 11145, 12060, 13115, \
		14185, 15343, 16550, 17843, 19256, 20618, 22197, \
	100, 8857, 9864, 10918, 11884, 12916, 13970, 15119, \
		16335, 17643, 19081, 20609, 22225, 23931, 25515, \
	105, 10152, 11260, 12471, 13600, 14806, 16066, 17434, \
		18832, 20318, 21924, 23616, 25449, 27237, 29049, \
	110, 11659, 12968, 14284, 15620, 16896, 18329, 19938, \
		21567, 23255, 25081, 26970, 29022, 31078, 33253, \
	115, 13160, 14706, 16317, 17859, 19331, 20906, 22653, \
		24647, 26716, 28892, 31109, 33384, 35635, 37999, \
	120, 15126, 16861, 18645, 20208, 21983, 23919, 25717, \
		27849, 30051, 32406, 34962, 37599, 40426, 43201, \
	125, 17170, 19104, 21030, 22956, 25049, 27287, 29413, \
		31689, 34335, 37035, 39927, 42969, 46166, 49505, \
}

#define CPULL_TABLE_2 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 163, 175, 187, 209, 233, 255, 276, \
		299, 320, 338, 364, 394, 433, 424, \
	25, 200, 224, 237, 265, 287, 307, 343, \
		368, 384, 418, 445, 476, 558, 574, \
	30, 242, 267, 290, 319, 357, 397, 434, \
		458, 484, 516, 555, 600, 687, 707, \
	35, 312, 335, 361, 393, 428, 458, 499, \
		550, 594, 656, 720, 777, 826, 909, \
	40, 392, 431, 461, 496, 538, 583, 626, \
		672, 732, 797, 874, 936, 1038, 1177, \
	45, 494, 530, 571, 607, 658, 713, 769, \
		837, 899, 975, 1069, 1163, 1238, 1366, \
	50, 600, 637, 693, 745, 806, 872, 940, \
		1008, 1096, 1183, 1278, 1374, 1485, 1621, \
	55, 711, 774, 835, 920, 1000, 1059, 1142, \
		1232, 1342, 1448, 1569, 1744, 1835, 1974, \
	60, 875, 958, 1038, 1120, 1204, 1283, 1363, \
		1451, 1571, 1720, 1855, 1977, 2186, 2416, \
	65, 1111, 1218, 1288, 1384, 1502, 1629, 1743, \
		1890, 2027, 2135, 2240, 2390, 2540, 2950, \
	70, 1346, 1416, 1513, 1604, 1704, 1836, 1960, \
		2150, 2284, 2440, 2661, 3038, 3312, 3522, \
	75, 1597, 1704, 1812, 1910, 2048, 2218, 2364, \
		2512, 2695, 2879, 3151, 3468, 3696, 4320, \
	80, 1918, 2036, 2187, 2325, 2480, 2644, 2796, \
		2999, 3239, 3500, 3760, 4064, 4573, 4986, \
	85, 2360, 2456, 2596, 2778, 2983, 3190, 3396, \
		3635, 3927, 4261, 4594, 5013, 5531, 5887, \
	90, 2846, 2977, 3116, 3318, 3573, 3826, 4073, \
		4352, 4698, 5057, 5533, 6114, 6488, 6968, \
	95, 3430, 3604, 3743, 3956, 4198, 4447, 4744, \
		5063, 5457, 5877, 6370, 6937, 7432, 8117, \
	100, 4112, 4352, 4552, 4719, 4974, 5267, 5554, \
		5981, 6496, 6948, 7467, 8113, 9095, 10064, \
	105, 4863, 5035, 5461, 5786, 6027, 6287, 6589, \
		7098, 7670, 8412, 9011, 9700, 10283, 11400, \
	110, 5776, 6036, 6400, 6557, 7085, 7611, 8109, \
		8607, 9125, 9772, 10407, 11330, 12477, 13817, \
	115, 6803, 7148, 7507, 7919, 8259, 8749, 9371, \
		10008, 10659, 11382, 12227, 13159, 14385, 15759, \
	120, 8006, 8230, 8812, 9189, 9700, 10308, 11041, \
		11825, 12439, 13180, 14050, 15220, 16730, 18160, \
	125, 9503, 9834, 10184, 10895, 10898, 11422, 12168, \
		13048, 13964, 14848, 15846, 17090, 18490, 19902, \
}

/* sheet name : ClusterLL_nCPU */
#define CPULL_CLUSTER_TABLE_0 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 2839, 3025, 3141, 3558, 4100, 4730, 5133, \
		5570, 6312, 7251, 8416, 9738, 10678, 11624, \
	25, 2887, 3396, 3626, 3934, 4447, 5080, 5767, \
		6603, 7632, 8622, 10198, 11700, 13298, 14944, \
	30, 3648, 3880, 4125, 4682, 5281, 5903, 6570, \
		7367, 8262, 9373, 10833, 12920, 14557, 15609, \
	35, 4097, 4360, 4964, 5640, 6355, 7201, 8061, \
		8979, 10015, 11154, 12401, 13720, 15595, 18305, \
	40, 4629, 5263, 5958, 6694, 7532, 8435, 9414, \
		10523, 11800, 13154, 14658, 16332, 18184, 20665, \
	45, 5526, 6264, 7101, 8053, 8948, 9995, 11152, \
		12450, 13966, 15638, 17372, 19710, 22511, 25671, \
	50, 6594, 7540, 8557, 9603, 10684, 11900, 13277, \
		14855, 16627, 18639, 21241, 24172, 27480, 29090, \
	55, 7886, 8946, 10115, 11336, 12691, 14289, 15969, \
		17645, 19734, 22452, 25665, 28953, 32355, 36117, \
	60, 9353, 10570, 11903, 13319, 15036, 17141, 19504, \
		22112, 24890, 27868, 31097, 34746, 38877, 43506, \
	65, 12234, 13618, 15255, 17136, 20169, 22504, 24708, \
		27708, 30572, 34010, 36885, 41839, 47137, 52908, \
	70, 14427, 15906, 17929, 20454, 23337, 26370, 29623, \
		33290, 37565, 41748, 46296, 51373, 56947, 62968, \
	75, 15331, 16481, 18765, 21370, 23940, 26561, 33502, \
		37766, 42123, 47194, 53003, 60026, 67356, 74889, \
	80, 18091, 20518, 23139, 25783, 28622, 31825, 38278, \
		44230, 47720, 53116, 59051, 65711, 73026, 80977, \
	85, 20925, 23694, 26854, 30026, 33532, 37439, 41698, \
		45441, 48773, 55170, 62898, 71058, 78780, 87266, \
	90, 22937, 26312, 30002, 33776, 37882, 42448, 47811, \
		53785, 60278, 67504, 75347, 83259, 92194, 102677, \
	95, 28778, 32909, 35442, 37470, 41377, 45665, 50633, \
		56025, 62202, 69066, 76634, 85193, 94485, 105809, \
	100, 30595, 34417, 38524, 42773, 47400, 52015, 55049, \
		60741, 70921, 78847, 87595, 97273, 108210, 120067, \
	105, 36812, 41184, 45656, 50581, 55901, 61653, 68250, \
		75147, 82751, 91270, 96166, 103260, 123069, 136464, \
	110, 39802, 42869, 45897, 49084, 52393, 56742, 63472, \
		70965, 79281, 88841, 99764, 112215, 126258, 141892, \
	115, 47002, 51101, 58475, 64522, 71376, 78890, 86916, \
		95941, 106207, 117523, 129565, 141965, 155669, 171194, \
	120, 54555, 58850, 63131, 71722, 80168, 89040, 98211, \
		108652, 120079, 132708, 146813, 162347, 179485, 198253, \
	125, 64390, 72266, 73396, 77865, 91999, 103654, 111488, \
		122856, 136550, 151279, 166918, 184307, 203425, 224904, \
}

#define CPULL_CLUSTER_TABLE_1 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 698, 731, 809, 912, 1046, 1210, 1424, \
		1739, 2143, 2565, 2994, 3563, 4260, 5173, \
	25, 885, 952, 1060, 1192, 1348, 1480, 1716, \
		2077, 2520, 3095, 3729, 4403, 5211, 6236, \
	30, 1068, 1146, 1270, 1399, 1566, 1811, 2144, \
		2492, 2916, 3514, 4186, 5071, 6154, 7254, \
	35, 1331, 1436, 1559, 1691, 1886, 2077, 2388, \
		2804, 3297, 3911, 4686, 5777, 7138, 8540, \
	40, 1599, 1718, 1880, 2101, 2343, 2658, 3060, \
		3528, 4043, 4748, 5612, 6694, 8123, 10014, \
	45, 1952, 2125, 2293, 2481, 2863, 3249, 3711, \
		4248, 4825, 5537, 6566, 7840, 9374, 11240, \
	50, 2372, 2511, 2679, 2966, 3375, 3833, 4349, \
		4920, 5577, 6443, 7613, 9055, 10836, 12997, \
	55, 2834, 3046, 3272, 3604, 3993, 4347, 4874, \
		5710, 6713, 7805, 8985, 10382, 12243, 14545, \
	60, 3425, 3691, 3991, 4397, 4703, 5092, 5728, \
		6542, 7677, 9167, 10446, 11965, 14138, 16791, \
	65, 4083, 4487, 4791, 5075, 5350, 5870, 6652, \
		7636, 8787, 10142, 11693, 13457, 15852, 18605, \
	70, 4917, 5363, 5585, 5882, 6335, 7057, 8058, \
		9234, 10458, 11894, 13603, 15665, 18258, 21596, \
	75, 6066, 6358, 6660, 6948, 7567, 8468, 9496, \
		10826, 12381, 14168, 16054, 18191, 20801, 24237, \
	80, 7346, 7558, 7876, 8533, 9346, 10210, 11219, \
		12576, 14235, 16095, 18474, 21344, 24754, 28936, \
	85, 8723, 9084, 9420, 10139, 10983, 11980, 13265, \
		14643, 16353, 18395, 21147, 24587, 28561, 33060, \
	90, 10562, 10712, 11040, 11807, 12774, 14177, 15492, \
		17004, 18940, 21266, 24093, 27849, 32322, 37314, \
	95, 12562, 12781, 13111, 14013, 15189, 16725, 18232, \
		20137, 22192, 24693, 27791, 31366, 36320, 41732, \
	100, 14825, 15244, 15717, 16746, 17965, 19607, 21379, \
		23506, 25867, 28524, 31777, 35775, 40506, 46635, \
	105, 17580, 18268, 19271, 20293, 21609, 23172, 24640, \
		26813, 29450, 32424, 36136, 40440, 46074, 52769, \
	110, 20870, 21574, 22558, 23738, 25282, 26637, 28005, \
		30014, 32889, 36278, 40398, 45314, 51520, 59540, \
	115, 24801, 25678, 26008, 27579, 28856, 30308, 32318, \
		34491, 37314, 40924, 45325, 50822, 58007, 66867, \
	120, 28426, 29424, 30697, 32245, 33500, 34946, 37408, \
		39951, 43231, 47164, 51785, 57555, 64642, 73578, \
	125, 32933, 34169, 34986, 36786, 37052, 39538, 42692, \
		45943, 48279, 51895, 57168, 63385, 71129, 80075, \
}

#define CPULL_CLUSTER_TABLE_2 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 227, 265, 315, 338, 381, 450, 557, \
		692, 859, 1149, 1568, 2088, 2841, 4217, \
	25, 280, 297, 337, 370, 413, 506, 620, \
		824, 1053, 1326, 1723, 2250, 3159, 4547, \
	30, 359, 361, 398, 474, 524, 580, 707, \
		921, 1185, 1578, 2063, 2729, 3512, 5007, \
	35, 442, 461, 544, 607, 672, 831, 999, \
		1212, 1520, 1905, 2389, 3314, 4387, 5722, \
	40, 549, 569, 620, 661, 760, 878, 1032, \
		1282, 1644, 2094, 2706, 3758, 5001, 6330, \
	45, 667, 686, 719, 864, 947, 1071, 1233, \
		1451, 1861, 2380, 3067, 4252, 5709, 7538, \
	50, 815, 964, 991, 1059, 1116, 1226, 1426, \
		1766, 2189, 2781, 3604, 4732, 6443, 8422, \
	55, 1096, 1167, 1189, 1209, 1326, 1519, 1802, \
		2161, 2539, 3069, 4000, 5218, 7204, 9516, \
	60, 1422, 1398, 1389, 1430, 1591, 1854, 2199, \
		2625, 3098, 3661, 4532, 5833, 7813, 10687, \
	65, 1564, 1565, 1558, 1628, 1800, 2007, 2235, \
		2659, 3176, 4253, 5648, 6866, 9023, 11779, \
	70, 1955, 1952, 2030, 2198, 2360, 2510, 2804, \
		3280, 3887, 4707, 5807, 7458, 9873, 13001, \
	75, 2405, 2362, 2417, 2607, 2671, 2838, 3208, \
		3723, 4363, 5359, 6625, 8001, 10364, 13570, \
	80, 2842, 2856, 2946, 3079, 3180, 3395, 3860, \
		4325, 4921, 5725, 7069, 9156, 11357, 14878, \
	85, 3370, 3424, 3811, 3791, 3888, 4209, 4699, \
		5294, 5952, 6864, 8257, 10141, 12996, 16882, \
	90, 4553, 4437, 4522, 4571, 4648, 4870, 5415, \
		6011, 6709, 7918, 9331, 11019, 13593, 18598, \
	95, 5685, 5609, 5419, 5342, 5416, 5814, 6409, \
		6992, 7883, 9107, 10553, 12378, 16538, 21649, \
	100, 6759, 6660, 5953, 6021, 6154, 6468, 7083, \
		7461, 8149, 9753, 11504, 13626, 16957, 20881, \
	105, 8501, 8451, 7633, 7143, 7258, 7329, 7667, \
		7976, 8790, 9876, 12609, 15795, 19364, 23576, \
	110, 9668, 9714, 9284, 9185, 8938, 8604, 8786, \
		9377, 10655, 12464, 15003, 17712, 21336, 25709, \
	115, 12274, 11517, 11140, 10588, 10652, 10742, 10946, \
		11173, 12042, 13917, 16102, 19405, 23343, 28164, \
	120, 14729, 14352, 13763, 13764, 13900, 14077, 13845, \
		14357, 15578, 17114, 19353, 22616, 26886, 32805, \
	125, 18079, 16852, 16805, 16264, 17273, 17541, 18049, \
		18516, 19189, 21092, 23960, 27515, 32613, 39101, \
}

/* sheet name : McuSys */
#define CCI_TABLE_0 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 1758, 2035, 2364, 2741, 3179, 3667, 4228, \
		4891, 5656, 6549, 7587, 8784, 10184, 11860, \
	25, 2092, 2417, 2798, 3231, 3728, 4300, 4958, \
		5726, 6606, 7597, 8758, 10126, 11733, 13555, \
	30, 2489, 2880, 3321, 3825, 4402, 5054, 5794, \
		6669, 7635, 8792, 10142, 11696, 13478, 15547, \
	35, 2967, 3414, 3926, 4493, 5163, 5929, 6761, \
		7711, 8828, 10125, 11620, 13352, 15364, 17737, \
	40, 3511, 4034, 4615, 5289, 6056, 6890, 7878, \
		9004, 10294, 11768, 13433, 15400, 17632, 20206, \
	45, 4145, 4740, 5406, 6170, 7040, 7987, 9106, \
		10375, 11825, 13451, 15360, 17528, 20017, 22932, \
	50, 4869, 5555, 6316, 7187, 8152, 9245, 10506, \
		11932, 13556, 15373, 17508, 19912, 22680, 25904, \
	55, 5719, 6496, 7360, 8347, 9429, 10677, 12099, \
		13699, 15462, 17510, 19873, 22585, 25634, 29111, \
	60, 6613, 7523, 8488, 9620, 10894, 12259, 13803, \
		15547, 17569, 19869, 22434, 25353, 28703, 32560, \
	65, 7719, 8754, 9852, 11147, 12532, 14051, 15713, \
		17695, 19933, 22450, 25218, 28427, 32106, 36509, \
	70, 8942, 10116, 11415, 12840, 14377, 16084, 17990, \
		20066, 22549, 25306, 28391, 31908, 35920, 40646, \
	75, 10376, 11663, 13070, 14618, 16328, 18202, 20302, \
		22707, 25415, 28339, 31760, 35664, 40045, 45016, \
	80, 11864, 13349, 15025, 16760, 18629, 20711, 23035, \
		25630, 28544, 31894, 35599, 39842, 44609, 50065, \
	85, 13708, 15225, 16927, 18841, 20883, 23152, 25960, \
		28864, 32063, 35670, 39764, 44321, 49549, 55200, \
	90, 15781, 17525, 19439, 21582, 23938, 26508, 29301, \
		32467, 36047, 39997, 44397, 49225, 54880, 61356, \
	95, 18256, 20261, 22355, 24686, 27268, 30042, 33112, \
		36533, 40329, 44553, 49273, 54571, 60566, 67202, \
	100, 20937, 23066, 25466, 28132, 30961, 33871, 37267, \
		40990, 45045, 49546, 54548, 60181, 66580, 73816, \
	105, 23847, 26223, 28904, 31824, 34904, 38299, 41913, \
		45832, 50191, 55174, 60650, 66653, 73552, 81148, \
	110, 27276, 29923, 32843, 35833, 39125, 42733, 46848, \
		51211, 55982, 61238, 67041, 73310, 80470, 88999, \
	115, 30668, 33716, 36840, 40250, 43937, 47937, 52268, \
		56776, 61824, 67389, 73635, 80731, 88420, 96656, \
	120, 34602, 37620, 40963, 44632, 48625, 52992, 57663, \
		62675, 68126, 74086, 80711, 88008, 95923, 104416, \
	125, 39006, 42397, 45659, 49460, 53532, 57898, 62753, \
		68099, 73973, 80467, 87107, 94455, 102941, 112884, \
}

#define CCI_TABLE_1 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 466, 553, 658, 786, 943, 1142, 1392, \
		1705, 2110, 2627, 3290, 4155, 5301, 6796, \
	25, 575, 675, 797, 949, 1134, 1359, 1643, \
		1999, 2448, 3038, 3781, 4749, 6008, 7656, \
	30, 706, 824, 969, 1141, 1351, 1611, 1933, \
		2330, 2841, 3492, 4325, 5407, 6791, 8610, \
	35, 861, 1001, 1164, 1366, 1609, 1904, 2267, \
		2723, 3298, 4015, 4933, 6118, 7652, 9650, \
	40, 1048, 1207, 1400, 1630, 1906, 2235, 2649, \
		3161, 3795, 4596, 5614, 6910, 8582, 10732, \
	45, 1272, 1460, 1678, 1940, 2244, 2623, 3085, \
		3659, 4365, 5251, 6371, 7785, 9588, 11926, \
	50, 1544, 1760, 2008, 2296, 2643, 3066, 3586, \
		4225, 5008, 5982, 7204, 8752, 10690, 13226, \
	55, 1856, 2106, 2390, 2715, 3103, 3580, 4155, \
		4864, 5728, 6796, 8140, 9803, 11914, 14623, \
	60, 2238, 2514, 2832, 3195, 3631, 4163, 4804, \
		5583, 6535, 7706, 9156, 10967, 13247, 16130, \
	65, 2682, 2992, 3345, 3749, 4238, 4826, 5529, \
		6384, 7431, 8711, 10269, 12226, 14667, 17748, \
	70, 3206, 3550, 3940, 4395, 4934, 5582, 6354, \
		7286, 8408, 9771, 11476, 13567, 16214, 19455, \
	75, 3828, 4200, 4634, 5140, 5734, 6439, 7278, \
		8284, 9497, 10980, 12796, 15032, 17801, 21243, \
	80, 4554, 4966, 5451, 5995, 6643, 7400, 8299, \
		9387, 10709, 12274, 14189, 16530, 19434, 23076, \
	85, 5396, 5863, 6394, 6998, 7700, 8502, 9482, \
		10650, 12035, 13704, 15716, 18214, 21247, 24983, \
	90, 6390, 6887, 7457, 8109, 8868, 9750, 10789, \
		12020, 13478, 15232, 17367, 20019, 23130, 26974, \
	95, 7536, 8081, 8675, 9352, 10166, 11100, 12193, \
		13485, 15038, 16905, 19148, 21846, 25068, 29169, \
	100, 8842, 9402, 10072, 10764, 11620, 12624, 13799, \
		15158, 16756, 18682, 21027, 23786, 27272, 31375, \
	105, 10312, 10917, 11573, 12336, 13218, 14272, 15498, \
		16928, 18590, 20595, 23028, 25939, 29510, 33691, \
	110, 12063, 12663, 13360, 14119, 15035, 16085, 17330, \
		18825, 20535, 22616, 25189, 28175, 31722, 35878, \
	115, 14002, 14598, 15268, 16017, 16954, 18043, 19304, \
		20837, 22607, 24787, 27374, 30340, 33846, 38385, \
	120, 16192, 16781, 17443, 18241, 19139, 20197, 21464, \
		23048, 24906, 27114, 29599, 32552, 36249, 41116, \
	125, 18705, 19300, 19915, 20621, 21543, 22682, 24013, \
		25523, 27320, 29485, 32039, 35100, 38925, 43529, \
}

#define CCI_TABLE_2 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 140, 172, 212, 264, 334, 428, 548, \
		714, 948, 1275, 1722, 2361, 3269, 4585, \
	25, 176, 213, 263, 328, 410, 516, 659, \
		853, 1118, 1484, 1994, 2710, 3714, 5167, \
	30, 220, 264, 320, 398, 495, 622, 784, \
		1011, 1313, 1718, 2285, 3072, 4192, 5780, \
	35, 274, 328, 399, 486, 596, 740, 933, \
		1184, 1521, 1981, 2599, 3479, 4708, 6433, \
	40, 337, 403, 483, 580, 709, 881, 1099, \
		1382, 1762, 2273, 2965, 3934, 5259, 7127, \
	45, 412, 487, 580, 694, 845, 1038, 1280, \
		1600, 2031, 2595, 3355, 4388, 5817, 7799, \
	50, 505, 591, 695, 828, 998, 1216, 1494, \
		1851, 2326, 2941, 3767, 4879, 6408, 8514, \
	55, 612, 711, 829, 981, 1172, 1412, 1721, \
		2116, 2632, 3298, 4178, 5387, 7007, 9248, \
	60, 736, 847, 980, 1151, 1364, 1629, 1966, \
		2406, 2961, 3680, 4637, 5917, 7655, 9996, \
	65, 883, 1007, 1153, 1340, 1574, 1864, 2234, \
		2702, 3306, 4083, 5128, 6462, 8323, 10752, \
	70, 1060, 1188, 1347, 1549, 1803, 2114, 2507, \
		3012, 3659, 4510, 5605, 7023, 8947, 11458, \
	75, 1252, 1405, 1584, 1803, 2084, 2413, 2827, \
		3358, 4024, 4884, 6007, 7527, 9516, 12132, \
	80, 1488, 1652, 1845, 2082, 2374, 2726, 3166, \
		3729, 4455, 5368, 6510, 8001, 9982, 12705, \
	85, 1757, 1918, 2123, 2387, 2706, 3077, 3549, \
		4158, 4885, 5839, 7056, 8568, 10614, 13194, \
	90, 2067, 2233, 2456, 2711, 3045, 3446, 3950, \
		4565, 5325, 6285, 7525, 9093, 11023, 13629, \
	95, 2404, 2575, 2798, 3063, 3419, 3836, 4346, \
		4922, 5712, 6723, 7978, 9559, 11583, 13992, \
	100, 2760, 2948, 3147, 3452, 3840, 4251, 4747, \
		5354, 6131, 7142, 8463, 10020, 11912, 14328, \
	105, 3167, 3353, 3567, 3862, 4227, 4622, 5131, \
		5761, 6534, 7582, 8816, 10304, 12254, 14682, \
	110, 3653, 3794, 4027, 4301, 4625, 5031, 5537, \
		6152, 6984, 7990, 9212, 10688, 12591, 15011, \
	115, 4124, 4233, 4462, 4717, 5027, 5418, 5925, \
		6563, 7389, 8368, 9533, 11018, 12979, 15401, \
	120, 4624, 4731, 4920, 5129, 5444, 5809, 6291, \
		6943, 7681, 8685, 9880, 11424, 13316, 15336, \
	125, 5131, 5199, 5359, 5577, 5829, 6208, 6689, \
		7352, 8049, 8988, 10155, 11591, 13288, 15261, \
}

/* sheet name : GPU */
#define GPU_TABLE_0 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 9230, 10488, 11850, 13329, 14935, 16714, 18667, \
		20812, 23299, 25923, 28766, 31896, 35304, 39163, \
	25, 11120, 12599, 14237, 16003, 17943, 20110, 22415, \
		24953, 27749, 30883, 34364, 37989, 41885, 46488, \
	30, 13437, 15251, 17185, 19305, 21602, 24137, 26908, \
		29928, 33207, 36801, 40804, 45107, 49725, 55066, \
	35, 16332, 18467, 20735, 23242, 25935, 28937, 32223, \
		35772, 39702, 43858, 48483, 53620, 59180, 65113, \
	40, 19622, 22216, 25031, 28093, 31383, 34842, 38594, \
		42739, 47352, 52352, 57723, 63570, 70117, 77301, \
	45, 23491, 26585, 29934, 33485, 37226, 41316, 45838, \
		50758, 56090, 61900, 68576, 75309, 82733, 91127, \
	50, 28036, 31682, 35583, 39636, 44127, 49041, 54357, \
		60081, 66334, 73071, 80887, 88788, 97323, 106790, \
	55, 33308, 37547, 42028, 46899, 52177, 57883, 64117, \
		70860, 78175, 86017, 94546, 103762, 113815, 124853, \
	60, 39417, 44363, 49650, 55344, 61539, 68200, 75415, \
		83211, 91713, 100866, 110758, 121741, 133318, 145643, \
	65, 46405, 52214, 58356, 64892, 72045, 79674, 88024, \
		97013, 106669, 117665, 129234, 141562, 154910, 169271, \
	70, 54417, 61023, 68105, 75752, 84042, 92708, 101960, \
		111942, 123078, 135367, 148620, 162760, 177425, 193080, \
	75, 63526, 71138, 79478, 88173, 97729, 107490, 118023, \
		129358, 141550, 154707, 168936, 184598, 202065, 221067, \
	80, 74089, 83054, 92816, 102994, 113614, 124821, 137067, \
		150250, 164770, 180842, 198655, 216653, 235547, 255536, \
	85, 86414, 96827, 107708, 119595, 131708, 144506, 158298, \
		173472, 190081, 208072, 227592, 248728, 269938, 295804, \
	90, 100407, 112408, 125353, 138442, 152705, 168175, 184855, \
		201935, 220645, 240780, 262197, 284944, 310004, 337439, \
	95, 116574, 129283, 143884, 159553, 175573, 193061, 211817, \
		231003, 252650, 276005, 299632, 324639, 352064, 382339, \
	100, 135063, 150783, 167274, 183972, 201715, 221367, 241903, \
		264423, 287996, 313090, 340269, 368972, 400342, 434572, \
	105, 155562, 173096, 191417, 210898, 231247, 252606, 275186, \
		300481, 327659, 356799, 387406, 418233, 452283, 491630, \
	110, 177104, 197212, 217123, 238437, 261599, 286466, 311887, \
		341053, 370732, 403059, 437123, 472431, 509441, 550346, \
	115, 201697, 224329, 247464, 271792, 297185, 323801, 352058, \
		383683, 417241, 452730, 489873, 529383, 572662, 617996, \
	120, 227349, 252933, 280074, 307078, 335803, 364872, 396048, \
		430505, 468095, 507466, 549386, 594430, 640865, 691403, \
	125, 255179, 283866, 312975, 343694, 376036, 409159, 443059, \
		481386, 522514, 566697, 614030, 662515, 715464, 771053, \
}

#define GPU_TABLE_1 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 2534, 2844, 3197, 3606, 4083, 4644, 5303, \
		6071, 7002, 8121, 9470, 11073, 13022, 15372, \
	25, 3144, 3507, 3931, 4433, 5001, 5662, 6440, \
		7350, 8436, 9730, 11311, 13228, 15517, 18162, \
	30, 3879, 4318, 4849, 5437, 6107, 6885, 7790, \
		8862, 10143, 11667, 13496, 15696, 18365, 21477, \
	35, 4770, 5324, 5927, 6613, 7412, 8332, 9401, \
		10654, 12140, 13917, 16038, 18583, 21664, 25350, \
	40, 5861, 6483, 7203, 8005, 8932, 10010, 11269, \
		12735, 14455, 16488, 18963, 21910, 25386, 29697, \
	45, 7162, 7908, 8742, 9691, 10785, 12042, 13497, \
		15181, 17178, 19549, 22350, 25766, 29760, 34610, \
	50, 8741, 9628, 10612, 11731, 12995, 14439, 16114, \
		18070, 20380, 23103, 26326, 30159, 34768, 40242, \
	55, 10659, 11701, 12854, 14123, 15569, 17258, 19202, \
		21453, 24103, 27226, 30884, 35257, 40507, 46727, \
	60, 12951, 14135, 15449, 16977, 18685, 20610, 22829, \
		25439, 28479, 32007, 36158, 41149, 46985, 54065, \
	65, 15680, 17018, 18554, 20305, 22257, 24475, 27060, \
		30039, 33501, 37517, 42225, 47822, 54525, 62423, \
	70, 18945, 20551, 22339, 24313, 26493, 29018, 31965, \
		35311, 39208, 43724, 49030, 55286, 62792, 71764, \
	75, 22875, 24750, 26795, 29013, 31405, 34362, 37680, \
		41488, 45922, 51054, 57031, 64019, 72360, 82343, \
	80, 27551, 29672, 31974, 34457, 37233, 40564, 44286, \
		48641, 53637, 59382, 66076, 73948, 83239, 94500, \
	85, 33073, 35404, 38030, 40826, 44009, 47790, 51983, \
		56874, 62502, 68985, 76479, 85193, 95663, 108091, \
	90, 39479, 42215, 45060, 48219, 51876, 56136, 60806, \
		66275, 72531, 79762, 88159, 97952, 109650, 123234, \
	95, 46864, 50016, 53325, 56932, 61025, 65755, 70918, \
		76994, 83947, 91935, 101236, 112192, 125003, 139807, \
	100, 55364, 58836, 62751, 66900, 71479, 76665, 82516, \
		89360, 97071, 105873, 116054, 128400, 142331, 158555, \
	105, 65559, 69410, 73767, 78544, 83514, 89137, 95724, \
		103169, 111565, 121150, 132576, 146171, 161413, 179139, \
	110, 77723, 81526, 86262, 91640, 97490, 103667, 110506, \
		118451, 127644, 138338, 151356, 166137, 182418, 201969, \
	115, 92132, 96525, 101409, 106714, 113136, 120045, 127509, \
		136171, 146399, 158183, 172035, 187875, 206080, 227282, \
	120, 108685, 113592, 118623, 124512, 131281, 138373, 147275, \
		156537, 167385, 180364, 195539, 212701, 231973, 255409, \
	125, 128048, 132774, 138367, 144660, 151596, 159357, 168576, \
		179258, 191231, 205099, 221132, 239482, 261219, 286321, \
}

#define GPU_TABLE_2 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 812, 906, 1027, 1180, 1370, 1610, 1931, \
		2358, 2915, 3655, 4681, 6121, 8048, 10720, \
	25, 1016, 1130, 1274, 1449, 1673, 1960, 2318, \
		2796, 3418, 4243, 5379, 6964, 9127, 12122, \
	30, 1283, 1413, 1574, 1778, 2044, 2383, 2801, \
		3340, 4036, 4972, 6269, 8008, 10456, 13753, \
	35, 1602, 1751, 1943, 2192, 2500, 2891, 3391, \
		4039, 4837, 5907, 7334, 9334, 12106, 15725, \
	40, 1975, 2160, 2386, 2670, 3023, 3461, 4034, \
		4757, 5694, 6913, 8515, 10796, 13726, 17848, \
	45, 2438, 2654, 2926, 3253, 3641, 4136, 4777, \
		5617, 6699, 8093, 9880, 12295, 15530, 20200, \
	50, 3027, 3271, 3575, 3930, 4387, 4956, 5681, \
		6623, 7849, 9401, 11430, 14078, 17603, 22727, \
	55, 3750, 4020, 4363, 4759, 5262, 5914, 6739, \
		7787, 9176, 10907, 13208, 16179, 20088, 25372, \
	60, 4606, 4895, 5269, 5719, 6297, 7030, 7965, \
		9112, 10660, 12658, 15224, 18542, 22948, 28625, \
	65, 5621, 5876, 6277, 6752, 7433, 8290, 9329, \
		10652, 12346, 14499, 17377, 21160, 26046, 32421, \
	70, 6938, 7221, 7597, 8119, 8823, 9734, 10874, \
		12314, 14139, 16507, 19614, 23708, 29324, 36369, \
	75, 8556, 8903, 9293, 9864, 10660, 11629, 12867, \
		14446, 16518, 19105, 22456, 26848, 32802, 40720, \
	80, 10560, 10932, 11394, 12013, 12861, 13905, 15255, \
		17028, 19251, 22111, 25877, 30611, 37065, 45495, \
	85, 12960, 13328, 13825, 14567, 15456, 16631, 18155, \
		20051, 22524, 25674, 29653, 34781, 41948, 51061, \
	90, 16081, 16369, 16893, 17556, 18571, 19778, 21476, \
		23604, 26249, 29640, 34140, 39678, 47101, 57471, \
	95, 20011, 20049, 20527, 21229, 22239, 23553, 25417, \
		27651, 30563, 34284, 39090, 45162, 53229, 64591, \
	100, 24811, 24938, 25095, 25714, 26730, 28129, 30020, \
		32576, 35803, 39858, 45001, 51759, 60514, 72718, \
	105, 30634, 30405, 30591, 31065, 32189, 33715, 35807, \
		38426, 41764, 46107, 51597, 58811, 68680, 81625, \
	110, 37771, 37274, 37144, 37431, 38437, 39830, 42028, \
		44860, 48407, 53036, 59375, 67242, 77872, 91418, \
	115, 46175, 45478, 44778, 44941, 45651, 47252, 49251, \
		52240, 55998, 61078, 67804, 76545, 88259, 102167, \
	120, 56492, 55214, 54020, 53965, 54281, 55678, 57805, \
		60769, 64950, 70607, 77733, 87087, 98768, 114301, \
	125, 69348, 66719, 65662, 64470, 64409, 65844, 68089, \
		70634, 75185, 81077, 88628, 98499, 111327, 127430, \
}

/* sheet name : VCORE */
#define VCORE_TABLE_0 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 48449, 65397, 86958, 114232, 149408, 192494, 245983, \
		311821, 394124, 496300, 620972, 776961, 975441, 1216099, \
	25, 60112, 80220, 105338, 137335, 178852, 228316, 290285, \
		367487, 462466, 579108, 722581, 902103, 1126734, 1405407, \
	30, 73938, 97792, 126672, 164568, 212911, 270840, 343553, \
		432095, 542033, 678505, 845694, 1051195, 1303609, 1613141, \
	35, 90595, 117803, 152200, 197055, 253648, 320174, 404764, \
		507127, 634376, 788352, 980066, 1213962, 1503807, 1857480, \
	40, 109417, 141816, 183654, 236135, 300876, 378145, 475999, \
		594731, 741346, 920576, 1139173, 1407554, 1737380, 2135055, \
	45, 132170, 171212, 220295, 282732, 356574, 447313, 558451, \
		696726, 864311, 1070686, 1323265, 1632815, 1998660, 2452575, \
	50, 159854, 206459, 265152, 334524, 420322, 525920, 655632, \
		816322, 1009126, 1246181, 1535673, 1880631, 2299370, 2813840, \
	55, 193509, 248251, 314971, 396915, 495431, 619368, 770932, \
		955513, 1177649, 1450674, 1775700, 2169195, 2655264, 3217609, \
	60, 232637, 296361, 374272, 469267, 589104, 732436, 906555, \
		1117879, 1373629, 1686181, 2057978, 2510987, 3047430, 3682071, \
	65, 277594, 352194, 444857, 558100, 697562, 863670, 1066545, \
		1313036, 1603802, 1956305, 2381855, 2900733, 3492337, 4180823, \
	70, 332690, 422240, 530525, 663604, 824006, 1017408, 1251312, \
		1534580, 1871491, 2272004, 2749206, 3342320, 4000174, 4758786, \
	75, 399201, 502965, 628496, 781961, 968643, 1192245, 1462153, \
		1786240, 2177193, 2639726, 3172747, 3839170, 4563187, 5423524, \
	80, 476676, 598871, 745257, 922913, 1137896, 1397418, 1711282, \
		2081485, 2528681, 3060049, 3667005, 4394799, 5213830, 6171969, \
	85, 566802, 708939, 878358, 1083686, 1332995, 1631580, 1991184, \
		2423776, 2934844, 3551469, 4246377, 5061260, 5959907, 7015106, \
	90, 674025, 838016, 1036121, 1273899, 1561686, 1906207, 2318527, \
		2813448, 3411322, 4100045, 4895031, 5794598, 6794990, 7937491, \
	95, 797642, 992228, 1223926, 1501616, 1835019, 2234912, 2710819, \
		3279592, 3962557, 4773823, 5658907, 6643301, 7771002, 8924240, \
	100, 946652, 1173533, 1443602, 1767876, 2154258, 2617281, 3165951, \
		3818456, 4593249, 5478913, 6494609, 7597955, \
			8747490, 10042555, \
	105, 1115755, 1377920, 1690855, 2068232, 2516464, 3051234, 3681732, \
		4426761, 5300628, 6288370, 7489593, 8638752, \
			9907013, 11364285, \
	110, 1312336, 1616827, 1982245, 2417406, 2932113, 3544476, 4264271, \
		5113228, 6096052, 7250766, 8461313, 9769087, \
			11223023, 12832148, \
	115, 1543454, 1898881, 2321280, 2819448, 3411043, 4111737, 4932225, \
		5897528, 7000732, 8280129, 9587552, 11118630, \
			12751374, 14562021, \
	120, 1810364, 2226945, 2713172, 3285791, 3965536, 4763630, 5686280, \
		6798309, 8016167, 9394868, 10892096, 12586807, \
			14440670, 16593427, \
	125, 2131612, 2607151, 3168560, 3825912, 4601341, 5504401, 6562885, \
		7778820, 9173038, 10677517, 12425449, 14249012, \
			16346821, 18818323, \
}

#define VCORE_TABLE_1 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 11916, 15240, 19333, 24487, 30873, 38705, 48523, \
		60709, 75782, 94373, 117420, 146179, 181950, 225626, \
	25, 14470, 18430, 23301, 29385, 36893, 46180, 57699, \
		72032, 89703, 111290, 138076, 171502, 212346, 262732, \
	30, 17491, 22249, 28081, 35216, 44146, 54985, 68523, \
		85250, 106006, 131065, 162343, 200529, 247460, 304893, \
	35, 21073, 26802, 33670, 42129, 52671, 65462, 81287, \
		100787, 124918, 154152, 189693, 233647, 287383, 353082, \
	40, 25434, 32209, 40329, 50359, 62687, 77791, 96173, \
		118823, 146711, 180900, 221875, 272316, 333540, 408268, \
	45, 30628, 38620, 48189, 60084, 74533, 92123, 113629, \
		140057, 172290, 211680, 259132, 317134, 387473, 472633, \
	50, 36790, 46214, 57639, 71446, 88487, 109085, 133997, \
		165028, 202146, 247425, 301993, 368420, 448632, 545636, \
	55, 44217, 55286, 68668, 85079, 104927, 128992, 158084, \
		193797, 236658, 288498, 351123, 427384, 518223, 628238, \
	60, 52915, 65998, 81653, 100988, 124265, 152108, 186129, \
		227175, 276488, 335674, 407773, 494546, 598104, 722257, \
	65, 63313, 78561, 97081, 119385, 146631, 179024, 218660, \
		265802, 322384, 390174, 472751, 571212, 689224, 829446, \
	70, 75504, 93388, 115061, 141044, 172516, 210399, 255526, \
		310051, 375405, 452778, 546205, 658490, 791978, 950925, \
	75, 90337, 111026, 136398, 166647, 202981, 246787, 299214, \
		361036, 436152, 524506, 630111, 757754, 908245, 1087410, \
	80, 107365, 132469, 161351, 196369, 238406, 288958, 348082, \
		419741, 505313, 606578, 726189, 870281, 1040425, 1242182, \
	85, 127569, 156702, 191146, 231431, 280285, 337736, 405661, \
		487106, 586155, 700188, 835128, 997842, 1189300, 1415957, \
	90, 151710, 185102, 225277, 271970, 328732, 394803, 472384, \
		564658, 677701, 806809, 961308, 1141317, 1355710, 1609615, \
	95, 179597, 218624, 265051, 319882, 384643, 461619, 550552, \
		655362, 781683, 929655, 1102777, 1306676, 1546258, 1826330, \
	100, 212358, 257841, 311269, 374857, 449142, 537693, 640356, \
		760316, 901029, 1067321, 1261258, 1489532, 1756642, 2074399, \
	105, 250462, 303858, 364677, 437929, 523277, 624896, 741240, \
		877116, 1036794, 1222683, 1440282, 1697073, 1994721, 2344802, \
	110, 295414, 356096, 427546, 511803, 609015, 724582, 856577, \
		1010793, 1188713, 1398399, 1648706, 1934807, 2265695, 2649824, \
	115, 347631, 418564, 500794, 595339, 707366, 838939, 988270, \
		1162778, 1367903, 1605035, 1871465, 2201658, 2571301, 2999981, \
	120, 410021, 491259, 584764, 692676, 821250, 969385, 1141462, \
		1339357, 1563593, 1836182, 2142912, 2489269, 2910152, 3384092, \
	125, 480625, 574991, 683277, 806220, 951032, 1117274, 1314686, \
		1536844, 1788205, 2084017, 2437933, 2830903, 3283457, 3807325, \
}

#define VCORE_TABLE_2 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 3886, 4940, 6244, 7860, 9883, 12395, 15512, \
		19364, 24091, 30034, 37497, 46772, 58345, 73019, \
	25, 4702, 5960, 7500, 9419, 11788, 14710, 18271, \
		22722, 28183, 35131, 43661, 54067, 67273, 83804, \
	30, 5681, 7171, 9003, 11277, 14017, 17416, 21617, \
		26712, 33135, 41059, 50788, 62717, 77679, 96078, \
	35, 6878, 8665, 10825, 13499, 16712, 20677, 25477, \
		31521, 38903, 47883, 58951, 72741, 89719, 110842, \
	40, 8317, 10439, 12986, 16123, 19841, 24493, 30151, \
		37006, 45525, 55912, 68528, 84175, 103451, 126985, \
	45, 10065, 12568, 15583, 19218, 23651, 29045, 35617, \
		43684, 53293, 65115, 79569, 97373, 119230, 145649, \
	50, 12181, 15135, 18693, 22954, 28215, 34386, 42026, \
		51323, 62644, 76028, 92517, 113045, 137482, 166885, \
	55, 14727, 18205, 22413, 27455, 33605, 40710, 49555, \
		60325, 73439, 88831, 107376, 130705, 158232, 191344, \
	60, 17792, 21924, 26792, 32759, 39963, 48227, 58467, \
		70894, 85936, 103717, 124987, 151159, 182483, 219479, \
	65, 21499, 26399, 32178, 39075, 47525, 57162, 68950, \
		83351, 100434, 120861, 145440, 174906, 210165, 252536, \
	70, 25986, 31724, 38654, 46707, 56472, 67801, 81323, \
		97829, 117526, 140934, 168923, 202381, 242168, 290188, \
	75, 31351, 38052, 46392, 55817, 67150, 80378, 95946, \
		114852, 137480, 164348, 196341, 234372, 279087, 332934, \
	80, 38004, 45731, 55462, 66491, 79706, 95342, 113302, \
		135090, 160969, 191740, 228244, 271381, 321660, 382652, \
	85, 45968, 55103, 66332, 79510, 94872, 112968, 134042, \
		159021, 188612, 223566, 264998, 313616, 370712, 438341, \
	90, 55570, 66391, 79689, 94854, 112972, 133754, 158390, \
		187108, 221044, 260581, 306749, 361643, 426054, 503117, \
	95, 67067, 80059, 95411, 113449, 134080, 158493, 186829, \
		219597, 257723, 302491, 355955, 418837, 490658, 574930, \
	100, 81438, 96442, 114085, 135225, 159415, 187200, 220241, \
		258057, 302104, 353209, 412181, 482402, 563107, 658509, \
	105, 98823, 116689, 137213, 161227, 189539, 222161, 259548, \
		303518, 354359, 411064, 477586, 557304, 648756, 756159, \
	110, 119367, 140454, 164423, 192820, 225579, 263191, 306239, \
		356263, 413034, 479174, 556522, 644972, 747577, 866272, \
	115, 144145, 169175, 196934, 230397, 269186, 312462, 361647, \
		418924, 484027, 557651, 644065, 744990, 859064, 992546, \
	120, 174833, 204364, 236530, 275162, 319117, 369800, 427431, \
		493205, 568323, 652664, 750699, 864668, 995551, 1145097, \
	125, 212212, 247310, 285039, 329362, 378528, 437080, 502954, \
		579296, 665206, 762015, 873752, 1000137, 1146069, 1313595, \
}

#define VMD_TABLE_0 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 3722, 4298, 4952, 5533, 6102, 6713, 7189, \
		7795, 8675, 9383, 10033, 10609, 11544, 12654, \
	25, 4396, 4963, 5720, 6520, 7304, 8124, 8993, \
		9886, 10745, 11438, 12221, 13471, 14671, 15817, \
	30, 5250, 6112, 7054, 7958, 8796, 9640, 10670, \
		11838, 13092, 14313, 15341, 16192, 17397, 19322, \
	35, 6544, 7603, 8608, 9476, 10370, 11292, 12343, \
		13697, 15178, 16756, 18457, 20118, 21563, 22695, \
	40, 7906, 9027, 10139, 11138, 12170, 13276, 14457, \
		15966, 17603, 19365, 21315, 23446, 25622, 27633, \
	45, 9318, 10626, 11819, 12939, 14127, 15358, 16866, \
		18583, 20413, 22366, 24544, 26915, 29503, 32036, \
	50, 10909, 12402, 13687, 14956, 16306, 18047, 19845, \
		21721, 23714, 25930, 28292, 30920, 33770, 36867, \
	55, 12749, 14408, 15840, 17355, 19281, 21220, 23289, \
		25490, 27861, 30461, 33173, 36283, 39744, 43005, \
	60, 14960, 16664, 18265, 20256, 22394, 24634, 27000, \
		29564, 32421, 35527, 38940, 42563, 46147, 49285, \
	65, 17741, 20210, 22739, 25416, 27697, 30346, 33082, \
		35898, 38936, 42099, 45286, 48989, 53209, 57839, \
	70, 19970, 22042, 24540, 27181, 29966, 32972, 36140, \
		39480, 42931, 46840, 51008, 56456, 61155, 65689, \
	75, 23372, 26555, 29678, 32515, 34983, 39521, 42845, \
		46292, 50427, 54804, 59354, 63877, 68841, 74276, \
	80, 26745, 29792, 33859, 37694, 41775, 46099, 49421, \
		52753, 57532, 62590, 68046, 73660, 79503, 85272, \
	85, 30389, 33880, 37659, 41890, 46353, 51092, 56056, \
		61641, 67068, 72593, 78839, 85750, 92182, 99077, \
	90, 34670, 38725, 43520, 48589, 53348, 58584, 63883, \
		69479, 75477, 81865, 88722, 96324, 104245, 111251, \
	95, 38701, 43299, 48372, 53824, 59707, 65897, 71779, \
		77962, 85645, 93630, 101414, 109473, 118042, 126513, \
	100, 42900, 48172, 53747, 59830, 66250, 73655, 82825, \
		88146, 92256, 98192, 104755, 112092, 121537, 130079, \
	105, 49103, 54807, 61085, 67890, 75020, 82544, 90406, \
		98774, 107543, 116705, 126237, 123162, 128146, 136837, \
	110, 52375, 59502, 67197, 75356, 84001, 93476, 102726, \
		112420, 122478, 124551, 133613, 142685, 152352, 162306, \
	115, 57182, 64045, 71249, 78851, 86545, 95078, 104037, \
		111677, 122574, 132314, 142481, 148230, 146906, 148780, \
	120, 63113, 69443, 76381, 83301, 91637, 100101, 109623, \
		119201, 124642, 136504, 137664, 136769, 133985, 142997, \
	125, 65062, 70180, 78993, 88130, 94690, 103187, 110012, \
		113048, 123993, 126468, 135309, 144745, 154833, 165645, \
}

#define VMD_TABLE_1 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 1040, 1169, 1289, 1408, 1522, 1631, 1749, \
		1848, 1947, 2068, 2198, 2380, 2570, 2689, \
	25, 1277, 1416, 1546, 1689, 1847, 2009, 2161, \
		2308, 2484, 2645, 2790, 2950, 3109, 3330, \
	30, 1608, 1781, 1946, 2117, 2317, 2489, 2656, \
		2870, 3101, 3318, 3563, 3790, 3978, 4160, \
	35, 1943, 2136, 2342, 2563, 2789, 3046, 3293, \
		3541, 3781, 4061, 4360, 4595, 4831, 5175, \
	40, 2361, 2590, 2832, 3073, 3350, 3626, 3941, \
		4271, 4614, 4977, 5319, 5648, 5943, 6270, \
	45, 2831, 3104, 3431, 3754, 4089, 4466, 4833, \
		5205, 5651, 6138, 6583, 7023, 7444, 7881, \
	50, 3429, 3796, 4165, 4574, 5000, 5403, 5869, \
		6379, 6901, 7490, 8132, 8712, 9296, 9864, \
	55, 4136, 4547, 4960, 5406, 5855, 6422, 7001, \
		7586, 8146, 8753, 9504, 10266, 11007, 11772, \
	60, 4886, 5345, 5873, 6472, 7103, 7780, 8483, \
		9213, 9866, 10517, 11350, 12269, 13215, 14091, \
	65, 5762, 6337, 7050, 7767, 8560, 9390, 10199, \
		11032, 11887, 12688, 13604, 14552, 15499, 16685, \
	70, 6779, 7515, 8370, 9258, 10191, 11088, 12010, \
		12979, 14020, 15070, 16182, 17416, 18557, 19722, \
	75, 7980, 8877, 9904, 10945, 11993, 13029, 14179, \
		15374, 16618, 17805, 19038, 20504, 21962, 23508, \
	80, 9390, 10418, 11619, 12795, 14019, 15304, 16698, \
		18156, 19634, 21137, 22521, 24095, 25851, 27452, \
	85, 11091, 12226, 13559, 14856, 16235, 17642, 19150, \
		20824, 22578, 24347, 26105, 27898, 29809, 31873, \
	90, 12866, 14242, 15760, 17299, 18881, 20453, 22254, \
		24180, 26149, 28194, 30350, 32501, 34675, 37202, \
	95, 14967, 16647, 18383, 20076, 21794, 23583, 25645, \
		27738, 30003, 32361, 34890, 37654, 40318, 43404, \
	100, 17319, 19287, 21350, 23239, 25256, 27317, 29565, \
		31941, 34499, 37312, 40299, 43460, 46795, 49892, \
	105, 19852, 22019, 24386, 26593, 28951, 31416, 34091, \
		36825, 39730, 42870, 46178, 49762, 53260, 56803, \
	110, 22799, 25359, 27931, 30543, 33039, 35841, 38988, \
		42173, 45473, 49044, 52737, 56749, 60770, 65024, \
	115, 25733, 28756, 31907, 34921, 37800, 40880, 44296, \
		48196, 52240, 56496, 60832, 65280, 69682, 74305, \
	120, 29577, 32970, 36459, 39514, 42985, 46772, 50288, \
		54456, 58762, 63367, 68366, 73521, 79049, 84475, \
	125, 33574, 37356, 41122, 44889, 48980, 53357, 57515, \
		61965, 67140, 72419, 78074, 84023, 90274, 96802, \
}

#define VMD_TABLE_2 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 319, 342, 366, 409, 456, 498, 540, \
		585, 625, 661, 713, 770, 847, 829, \
	25, 392, 438, 463, 518, 561, 601, 670, \
		719, 751, 818, 871, 931, 1090, 1122, \
	30, 473, 521, 567, 623, 699, 776, 848, \
		895, 947, 1010, 1085, 1174, 1344, 1383, \
	35, 610, 655, 705, 768, 838, 895, 975, \
		1076, 1162, 1283, 1407, 1520, 1615, 1777, \
	40, 767, 842, 901, 970, 1053, 1139, 1224, \
		1314, 1431, 1559, 1709, 1830, 2030, 2301, \
	45, 967, 1036, 1116, 1187, 1286, 1395, 1505, \
		1637, 1758, 1906, 2090, 2275, 2420, 2670, \
	50, 1174, 1245, 1355, 1457, 1576, 1705, 1838, \
		1971, 2144, 2314, 2500, 2687, 2905, 3170, \
	55, 1391, 1514, 1633, 1800, 1956, 2071, 2233, \
		2408, 2624, 2831, 3068, 3410, 3588, 3859, \
	60, 1711, 1874, 2030, 2189, 2354, 2508, 2666, \
		2838, 3071, 3363, 3627, 3867, 4275, 4724, \
	65, 2173, 2382, 2518, 2706, 2936, 3185, 3408, \
		3695, 3963, 4174, 4381, 4673, 4967, 5768, \
	70, 2632, 2769, 2959, 3136, 3332, 3590, 3833, \
		4203, 4467, 4772, 5203, 5940, 6476, 6887, \
	75, 3124, 3333, 3543, 3736, 4004, 4338, 4622, \
		4912, 5271, 5629, 6162, 6781, 7227, 8447, \
	80, 3751, 3981, 4276, 4546, 4849, 5170, 5467, \
		5865, 6333, 6845, 7353, 7946, 8943, 9751, \
	85, 4615, 4802, 5076, 5433, 5832, 6238, 6641, \
		7109, 7679, 8332, 8983, 9802, 10816, 11511, \
	90, 5565, 5821, 6094, 6489, 6986, 7481, 7964, \
		8509, 9186, 9888, 10819, 11955, 12686, 13625, \
	95, 6707, 7048, 7318, 7736, 8208, 8696, 9276, \
		9901, 10672, 11491, 12455, 13565, 14532, 15872, \
	100, 8042, 8509, 8900, 9227, 9726, 10299, 10861, \
		11695, 12702, 13587, 14601, 15864, 17785, 19680, \
	105, 9509, 9845, 10678, 11314, 11785, 12294, 12884, \
		13880, 14997, 16449, 17621, 18968, 20108, 22293, \
	110, 11294, 11804, 12515, 12821, 13854, 14883, 15856, \
		16830, 17843, 19109, 20350, 22154, 24397, 27018, \
	115, 13302, 13977, 14680, 15484, 16150, 17107, 18325, \
		19570, 20843, 22256, 23910, 25732, 28129, 30814, \
	120, 15655, 16092, 17231, 17968, 18967, 20157, 21590, \
		23122, 24324, 25772, 27474, 29761, 32715, 35509, \
	125, 18583, 19230, 19914, 21304, 21310, 22335, 23793, \
		25515, 27305, 29033, 30985, 33418, 36156, 38917, \
}

#define MODEM_TABLE_0 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 6407, 7399, 8524, 9525, 10505, 11557, 12376, \
		13419, 14935, 16153, 17272, 18264, 19873, 21784, \
	25, 7567, 8543, 9847, 11224, 12573, 13986, 15482, \
		17018, 18498, 19691, 21039, 23191, 25256, 27228, \
	30, 9038, 10522, 12143, 13700, 15143, 16594, 18369, \
		20379, 22537, 24640, 26410, 27874, 29949, 33262, \
	35, 11265, 13089, 14818, 16312, 17852, 19439, 21249, \
		23578, 26128, 28845, 31773, 34632, 37120, 39069, \
	40, 13610, 15540, 17454, 19173, 20950, 22855, 24888, \
		27485, 30303, 33337, 36693, 40362, 44108, 47569, \
	45, 16042, 18292, 20346, 22275, 24320, 26438, 29034, \
		31990, 35140, 38502, 42252, 46333, 50788, 55149, \
	50, 18780, 21350, 23562, 25746, 28071, 31067, 34163, \
		37392, 40823, 44637, 48704, 53227, 58134, 63466, \
	55, 21947, 24803, 27267, 29876, 33191, 36530, 40091, \
		43880, 47962, 52438, 57106, 62461, 68419, 74033, \
	60, 25752, 28686, 31444, 34869, 38550, 42407, 46480, \
		50894, 55812, 61158, 67034, 73271, 79441, 84844, \
	65, 30541, 34790, 39144, 43753, 47680, 52240, 56951, \
		61797, 67028, 72472, 77959, 84334, 91599, 99568, \
	70, 34378, 37945, 42246, 46792, 51585, 56760, 62214, \
		67964, 73905, 80634, 87809, 97188, 105276, 113082, \
	75, 40235, 45714, 51089, 55974, 60223, 68034, 73757, \
		79690, 86809, 94343, 102176, 109962, 118509, 127863, \
	80, 46041, 51287, 58287, 64889, 71914, 79358, 85076, \
		90814, 99040, 107747, 117140, 126805, 136862, 146794, \
	85, 52314, 58324, 64830, 72113, 79795, 87954, 96499, \
		106114, 115456, 124968, 135719, 147617, 158689, 170558, \
	90, 59683, 66664, 74919, 83645, 91837, 100851, 109972, \
		119606, 129931, 140929, 152732, 165819, 179455, 191516, \
	95, 66622, 74538, 83271, 92656, 102784, 113440, 123565, \
		134210, 147435, 161182, 174582, 188456, 203207, 217790, \
	100, 73851, 82927, 92524, 102996, 114047, 126795, 142581, \
		151741, 158817, 169036, 180332, 192964, 209224, 223928, \
	105, 84529, 94349, 105156, 116871, 129146, 142098, 155632, \
		170037, 185133, 200904, 217313, 212021, 220601, 235561, \
	110, 90161, 102431, 115679, 129724, 144605, 160916, 176841, \
		193528, 210843, 214412, 230011, 245628, 262270, 279406, \
	115, 98438, 110251, 122653, 135740, 148985, 163674, 179096, \
		192249, 211008, 227775, 245278, 255175, 252896, 256120, \
	120, 108647, 119544, 131488, 143400, 157751, 172321, 188714, \
		205201, 214568, 234989, 236985, 235445, 230652, 246165, \
	125, 112003, 120813, 135985, 151714, 163006, 177634, 189383, \
		194609, 213451, 217711, 232931, 249175, 266542, 285155, \
}

#define MODEM_TABLE_1 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 1791, 2013, 2219, 2424, 2620, 2808, 3010, \
		3181, 3352, 3560, 3784, 4097, 4424, 4629, \
	25, 2199, 2437, 2662, 2908, 3180, 3458, 3721, \
		3974, 4276, 4554, 4803, 5079, 5352, 5732, \
	30, 2767, 3065, 3350, 3645, 3989, 4285, 4573, \
		4941, 5338, 5711, 6133, 6524, 6848, 7162, \
	35, 3344, 3676, 4031, 4412, 4800, 5244, 5668, \
		6095, 6509, 6992, 7506, 7910, 8316, 8909, \
	40, 4065, 4458, 4875, 5290, 5766, 6243, 6784, \
		7353, 7942, 8568, 9157, 9723, 10230, 10794, \
	45, 4873, 5344, 5907, 6462, 7039, 7689, 8319, \
		8960, 9728, 10567, 11332, 12089, 12814, 13567, \
	50, 5903, 6534, 7169, 7874, 8608, 9301, 10103, \
		10981, 11880, 12894, 14000, 14997, 16004, 16981, \
	55, 7120, 7827, 8539, 9306, 10080, 11056, 12053, \
		13059, 14024, 15067, 16361, 17673, 18949, 20265, \
	60, 8411, 9201, 10110, 11141, 12228, 13393, 14603, \
		15860, 16984, 18104, 19539, 21120, 22750, 24257, \
	65, 9920, 10909, 12137, 13370, 14736, 16164, 17558, \
		18991, 20463, 21842, 23419, 25052, 26682, 28723, \
	70, 11670, 12938, 14409, 15938, 17543, 19087, 20675, \
		22343, 24136, 25943, 27857, 29982, 31946, 33951, \
	75, 13737, 15282, 17049, 18842, 20645, 22429, 24408, \
		26466, 28608, 30651, 32773, 35297, 37808, 40468, \
	80, 16165, 17935, 20001, 22027, 24134, 26345, 28744, \
		31255, 33800, 36386, 38770, 41480, 44502, 47259, \
	85, 19092, 21047, 23341, 25574, 27948, 30370, 32967, \
		35849, 38868, 41913, 44939, 48025, 51315, 54868, \
	90, 22148, 24516, 27130, 29781, 32502, 35209, 38310, \
		41625, 45014, 48534, 52247, 55949, 59692, 64042, \
	95, 25765, 28658, 31647, 34560, 37517, 40597, 44146, \
		47750, 51649, 55709, 60062, 64820, 69406, 74719, \
	100, 29814, 33203, 36754, 40005, 43478, 47026, 50895, \
		54985, 59388, 64231, 69374, 74815, 80556, 85888, \
	105, 34174, 37905, 41979, 45779, 49839, 54082, 58686, \
		63394, 68395, 73800, 79495, 85665, 91686, 97786, \
	110, 39248, 43654, 48082, 52578, 56876, 61699, 67116, \
		72599, 78281, 84428, 90785, 97692, 104615, 111937, \
	115, 44299, 49503, 54927, 60116, 65071, 70375, 76255, \
		82968, 89930, 97256, 104721, 112378, 119955, 127914, \
	120, 50917, 56757, 62763, 68022, 73998, 80517, 86569, \
		93745, 101157, 109085, 117690, 126565, 136080, 145421, \
	125, 57797, 64307, 70790, 77275, 84318, 91852, 99011, \
		106671, 115580, 124668, 134403, 144643, 155404, 166643, \
}

#define MODEM_TABLE_2 { \
	600, 650, 700, 750, 800, 850, 900, 950, \
		1000, 1050, 1100, 1150, 1200, 1250, \
	20, 549, 589, 631, 705, 784, 857, 930, \
		1007, 1077, 1138, 1227, 1325, 1458, 1427, \
	25, 675, 754, 797, 891, 966, 1034, 1154, \
		1238, 1292, 1408, 1499, 1603, 1877, 1932, \
	30, 815, 897, 976, 1072, 1203, 1336, 1460, \
		1541, 1630, 1738, 1867, 2020, 2314, 2381, \
	35, 1050, 1128, 1214, 1322, 1442, 1540, 1678, \
		1852, 2000, 2209, 2423, 2616, 2780, 3059, \
	40, 1320, 1450, 1551, 1670, 1812, 1961, 2107, \
		2262, 2464, 2684, 2942, 3151, 3494, 3962, \
	45, 1664, 1783, 1921, 2043, 2214, 2401, 2590, \
		2818, 3027, 3281, 3598, 3916, 4167, 4597, \
	50, 2021, 2143, 2333, 2509, 2714, 2936, 3163, \
		3393, 3691, 3983, 4303, 4625, 5000, 5457, \
	55, 2395, 2607, 2812, 3098, 3367, 3565, 3845, \
		4146, 4516, 4874, 5282, 5870, 6177, 6644, \
	60, 2945, 3226, 3495, 3769, 4052, 4318, 4590, \
		4886, 5287, 5790, 6243, 6656, 7360, 8131, \
	65, 3741, 4101, 4334, 4658, 5055, 5483, 5868, \
		6361, 6822, 7186, 7542, 8045, 8550, 9930, \
	70, 4531, 4766, 5094, 5399, 5736, 6180, 6598, \
		7236, 7689, 8215, 8956, 10225, 11149, 11856, \
	75, 5377, 5737, 6100, 6431, 6894, 7468, 7956, \
		8455, 9073, 9690, 10607, 11674, 12442, 14541, \
	80, 6457, 6853, 7361, 7825, 8347, 8900, 9411, \
		10097, 10902, 11783, 12658, 13679, 15395, 16785, \
	85, 7945, 8267, 8737, 9352, 10040, 10739, 11433, \
		12238, 13220, 14343, 15463, 16874, 18620, 19817, \
	90, 9580, 10020, 10490, 11170, 12026, 12878, 13710, \
		14648, 15813, 17022, 18625, 20581, 21839, 23455, \
	95, 11545, 12133, 12598, 13317, 14131, 14971, 15968, \
		17044, 18371, 19782, 21441, 23351, 25017, 27323, \
	100, 13843, 14648, 15322, 15884, 16744, 17730, 18697, \
		20133, 21866, 23390, 25135, 27309, 30616, 33879, \
	105, 16370, 16948, 18382, 19476, 20288, 21164, 22180, \
		23895, 25817, 28316, 30334, 32652, 34616, 38376, \
	110, 19443, 20320, 21545, 22071, 23849, 25621, 27296, \
		28973, 30716, 32895, 35032, 38138, 42000, 46511, \
	115, 22899, 24061, 25271, 26655, 27802, 29449, 31546, \
		33689, 35882, 38313, 41160, 44296, 48424, 53046, \
	120, 26949, 27702, 29663, 30932, 32651, 34700, 37167, \
		39804, 41873, 44366, 47297, 51233, 56318, 61129, \
	125, 31989, 33104, 34282, 36674, 36684, 38449, 40959, \
		43924, 47004, 49980, 53340, 57529, 62241, 66995, \
}
/** table order: ff,tt,ss **/
int cpul_leakage_data[][VSIZE*TSIZE+VSIZE+TSIZE] = {
		CPUL_TABLE_0,
		CPUL_TABLE_1,
		CPUL_TABLE_2,
};

int cpul_cluster_leakage_data[][VSIZE*TSIZE+VSIZE+TSIZE] = {
		CPUL_CLUSTER_TABLE_0,
		CPUL_CLUSTER_TABLE_1,
		CPUL_CLUSTER_TABLE_2,
};

int cpull_leakage_data[][VSIZE*TSIZE+VSIZE+TSIZE] = {
		CPULL_TABLE_0,
		CPULL_TABLE_1,
		CPULL_TABLE_2,
};

int cpull_cluster_leakage_data[][VSIZE*TSIZE+VSIZE+TSIZE] = {
		CPULL_CLUSTER_TABLE_0,
		CPULL_CLUSTER_TABLE_1,
		CPULL_CLUSTER_TABLE_2,
};

int cci_leakage_data[][VSIZE*TSIZE+VSIZE+TSIZE] = {
		CCI_TABLE_0,
		CCI_TABLE_1,
		CCI_TABLE_2,
};
int gpu_leakage_data[][VSIZE*TSIZE+VSIZE+TSIZE] = {
		GPU_TABLE_0,
		GPU_TABLE_1,
		GPU_TABLE_2,
};

int vcore_leakage_data[][VSIZE*TSIZE+VSIZE+TSIZE] = {
		VCORE_TABLE_0,
		VCORE_TABLE_1,
		VCORE_TABLE_2,
};

int vmd_leakage_data[][VSIZE*TSIZE+VSIZE+TSIZE] = {
		VMD_TABLE_0,
		VMD_TABLE_1,
		VMD_TABLE_2,
};

int modem_leakage_data[][VSIZE*TSIZE+VSIZE+TSIZE] = {
		MODEM_TABLE_0,
		MODEM_TABLE_1,
		MODEM_TABLE_2,
};

struct spower_raw_t spower_raw[MTK_SPOWER_MAX] = {
	{
		.vsize = VSIZE,
		.tsize = TSIZE,
		.table_size = MAX_TABLE_SIZE,
		.table = {
			(int *)&cpull_leakage_data[0],
			(int *)&cpull_leakage_data[1],
			(int *)&cpull_leakage_data[2]
		},
		.devinfo_domain = LL_DEVINFO_DOMAIN,
		.leakage_id = MTK_LL_LEAKAGE,
		.instance = DEFAULT_CORE_INSTANCE,
		.print_leakage = true,
	},
	{
		.vsize = VSIZE,
		.tsize = TSIZE,
		.table_size = MAX_TABLE_SIZE,
		.table = {
			(int *)&cpull_cluster_leakage_data[0],
			(int *)&cpull_cluster_leakage_data[1],
			(int *)&cpull_cluster_leakage_data[2]
		},
		.devinfo_domain = LL_DEVINFO_DOMAIN,
		.leakage_id = MTK_LL_LEAKAGE,
		.instance = DEFAULT_INSTANCE,
		.print_leakage = false,
	},
	{
		.vsize = VSIZE,
		.tsize = TSIZE,
		.table_size = MAX_TABLE_SIZE,
		.table = {
			(int *)&cpul_leakage_data[0],
			(int *)&cpul_leakage_data[1],
			(int *)&cpul_leakage_data[2]
		},
		.devinfo_domain = L_DEVINFO_DOMAIN,
		.leakage_id = MTK_L_LEAKAGE,
		.instance = DEFAULT_CORE_INSTANCE,
		.print_leakage = true,
	},
	{
		.vsize = VSIZE,
		.tsize = TSIZE,
		.table_size = MAX_TABLE_SIZE,
		.table = {
			(int *)&cpul_cluster_leakage_data[0],
			(int *)&cpul_cluster_leakage_data[1],
			(int *)&cpul_cluster_leakage_data[2]
		},
		.devinfo_domain = L_DEVINFO_DOMAIN,
		.leakage_id = MTK_L_LEAKAGE,
		.instance = DEFAULT_INSTANCE,
		.print_leakage = false,
	},
	{
		.vsize = VSIZE,
		.tsize = TSIZE,
		.table_size = MAX_TABLE_SIZE,
		.table = {
			(int *)&cci_leakage_data[0],
			(int *)&cci_leakage_data[1],
			(int *)&cci_leakage_data[2]
		},
		.devinfo_domain = CCI_DEVINFO_DOMAIN,
		.leakage_id = MTK_CCI_LEAKAGE,
		.instance = DEFAULT_INSTANCE,
		.print_leakage = true,
	},
	{
		.vsize = VSIZE,
		.tsize = TSIZE,
		.table_size = MAX_TABLE_SIZE,
		.table = {
			(int *)&gpu_leakage_data[0],
			(int *)&gpu_leakage_data[1],
			(int *)&gpu_leakage_data[2]
		},
		.devinfo_domain = GPU_DEVINFO_DOMAIN,
		.leakage_id = MTK_GPU_LEAKAGE,
		.instance = DEFAULT_INSTANCE,
		.print_leakage = true,
	},
	{
		.vsize = VSIZE,
		.tsize = TSIZE,
		.table_size = MAX_TABLE_SIZE,
		.table = {
			(int *)&vcore_leakage_data[0],
			(int *)&vcore_leakage_data[1],
			(int *)&vcore_leakage_data[2]
		},
		.devinfo_domain = VCORE_DEVINFO_DOMAIN,
		.leakage_id = MTK_VCORE_LEAKAGE,
		.instance = DEFAULT_INSTANCE,
		.print_leakage = true,
	},
	{
		.vsize = VSIZE,
		.tsize = TSIZE,
		.table_size = MAX_TABLE_SIZE,
		.table = {
			(int *)&vmd_leakage_data[0],
			(int *)&vmd_leakage_data[1],
			(int *)&vmd_leakage_data[2]
		},
		.devinfo_domain = VMD_DEVINFO_DOMAIN,
		.leakage_id = MTK_VMD_LEAKAGE,
		.instance = DEFAULT_INSTANCE,
		.print_leakage = true,
	},
	{
		.vsize = VSIZE,
		.tsize = TSIZE,
		.table_size = MAX_TABLE_SIZE,
		.table = {
			(int *)&modem_leakage_data[0],
			(int *)&modem_leakage_data[1],
			(int *)&modem_leakage_data[2]
		},
		.devinfo_domain = MODEM_DEVINFO_DOMAIN,
		.leakage_id = MTK_MODEM_LEAKAGE,
		.instance = DEFAULT_INSTANCE,
		.print_leakage = true,
	},
};
#endif

