/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

/* Ver: MT6763-PTPOFF_WAT0_85C_20170807 */
/*      others-PTPOFF_WAT0_85C_20170425 */
/* 1: MT6763_WAT0_ptpoff_85C (FY) */
/* 2: MT6763T_WAT0_ptpoff_85C (FY) */
/* 3: MT6763T_WAT0_ptpoff_85C (SB) */
/* 4: MT6763TT_WAT0_ptpoff_85C (FY) */
/* 5: MT6763TT_WAT0_ptpoff_85C (SB) */
#ifndef MTK_UNIFIED_POWER_DATA_MT6763_H
#define MTK_UNIFIED_POWER_DATA_MT6763_H
/* MT6763_WAT0_ptpoff_85C (FY) */
struct upower_tbl upower_tbl_ll_1_FY = {
	.row = {
		{.cap = 173, .volt = 60000, .dyn_pwr = 9842, .lkg_pwr = {
			5539, 5539, 5539, 5539, 5539, 5539} },
		{.cap = 246, .volt = 65600, .dyn_pwr = 16086, .lkg_pwr = {
			6026, 6026, 6026, 6026, 6026, 6026} },
		{.cap = 319, .volt = 70600, .dyn_pwr = 24240, .lkg_pwr = {
			6678, 6678, 6678, 6678, 6678, 6678} },
		{.cap = 366, .volt = 73700, .dyn_pwr = 30315, .lkg_pwr = {
			7082, 7082, 7082, 7082, 7082, 7082} },
		{.cap = 406, .volt = 76900, .dyn_pwr = 36660, .lkg_pwr = {
			7502, 7502, 7502, 7502, 7502, 7502} },
		{.cap = 452, .volt = 80000, .dyn_pwr = 44287, .lkg_pwr = {
			7929, 7929, 7929, 7929, 7929, 7929} },
		{.cap = 512, .volt = 84400, .dyn_pwr = 55913, .lkg_pwr = {
			8544, 8544, 8544, 8544, 8544, 8544} },
		{.cap = 565, .volt = 88100, .dyn_pwr = 67341, .lkg_pwr = {
			9082, 9082, 9082, 9082, 9082, 9082} },
		{.cap = 605, .volt = 91900, .dyn_pwr = 78545, .lkg_pwr = {
			9664, 9664, 9664, 9664, 9664, 9664} },
		{.cap = 632, .volt = 95000, .dyn_pwr = 87704, .lkg_pwr = {
			10183, 10183, 10183, 10183, 10183, 10183} },
		{.cap = 665, .volt = 98100, .dyn_pwr = 98530, .lkg_pwr = {
			10715, 10715, 10715, 10715, 10715, 10715} },
		{.cap = 698, .volt = 101200, .dyn_pwr = 110189, .lkg_pwr = {
			11258, 11258, 11258, 11258, 11258, 11258} },
		{.cap = 718, .volt = 104400, .dyn_pwr = 120715, .lkg_pwr = {
			11824, 11824, 11824, 11824, 11824, 11824} },
		{.cap = 731, .volt = 106900, .dyn_pwr = 128985, .lkg_pwr = {
			12265, 12265, 12265, 12265, 12265, 12265} },
		{.cap = 758, .volt = 109400, .dyn_pwr = 140080, .lkg_pwr = {
			12704, 12704, 12704, 12704, 12704, 12704} },
		{.cap = 771, .volt = 111900, .dyn_pwr = 149206, .lkg_pwr = {
			13145, 13145, 13145, 13145, 13145, 13145} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
	},
};

struct upower_tbl upower_tbl_cluster_ll_1_FY = {
	.row = {
		{.cap = 173, .volt = 60000, .dyn_pwr = 1483, .lkg_pwr = {
			8518, 8518, 8518, 8518, 8518, 8518} },
		{.cap = 246, .volt = 65600, .dyn_pwr = 2424, .lkg_pwr = {
			8822, 8822, 8822, 8822, 8822, 8822} },
		{.cap = 319, .volt = 70600, .dyn_pwr = 3653, .lkg_pwr = {
			9154, 9154, 9154, 9154, 9154, 9154} },
		{.cap = 366, .volt = 73700, .dyn_pwr = 4568, .lkg_pwr = {
			9536, 9536, 9536, 9536, 9536, 9536} },
		{.cap = 406, .volt = 76900, .dyn_pwr = 5524, .lkg_pwr = {
			10000, 10000, 10000, 10000, 10000, 10000} },
		{.cap = 452, .volt = 80000, .dyn_pwr = 6673, .lkg_pwr = {
			10511, 10511, 10511, 10511, 10511, 10511} },
		{.cap = 512, .volt = 84400, .dyn_pwr = 8425, .lkg_pwr = {
			11329, 11329, 11329, 11329, 11329, 11329} },
		{.cap = 565, .volt = 88100, .dyn_pwr = 10147, .lkg_pwr = {
			12151, 12151, 12151, 12151, 12151, 12151} },
		{.cap = 605, .volt = 91900, .dyn_pwr = 11836, .lkg_pwr = {
			13116, 13116, 13116, 13116, 13116, 13116} },
		{.cap = 632, .volt = 95000, .dyn_pwr = 13216, .lkg_pwr = {
			13950, 13950, 13950, 13950, 13950, 13950} },
		{.cap = 665, .volt = 98100, .dyn_pwr = 14847, .lkg_pwr = {
			14901, 14901, 14901, 14901, 14901, 14901} },
		{.cap = 698, .volt = 101200, .dyn_pwr = 16604, .lkg_pwr = {
			15936, 15936, 15936, 15936, 15936, 15936} },
		{.cap = 718, .volt = 104400, .dyn_pwr = 18190, .lkg_pwr = {
			17206, 17206, 17206, 17206, 17206, 17206} },
		{.cap = 731, .volt = 106900, .dyn_pwr = 19436, .lkg_pwr = {
			18287, 18287, 18287, 18287, 18287, 18287} },
		{.cap = 758, .volt = 109400, .dyn_pwr = 21108, .lkg_pwr = {
			19631, 19631, 19631, 19631, 19631, 19631} },
		{.cap = 771, .volt = 111900, .dyn_pwr = 22483, .lkg_pwr = {
			21055, 21055, 21055, 21055, 21055, 21055} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
	},
};

struct upower_tbl upower_tbl_l_1_FY = {
	.row = {
		{.cap = 266, .volt = 60000, .dyn_pwr = 18253, .lkg_pwr = {
			27567, 27567, 27567, 27567, 27567, 27567} },
		{.cap = 366, .volt = 65600, .dyn_pwr = 28825, .lkg_pwr = {
			30379, 30379, 30379, 30379, 30379, 30379} },
		{.cap = 465, .volt = 70600, .dyn_pwr = 42613, .lkg_pwr = {
			33770, 33770, 33770, 33770, 33770, 33770} },
		{.cap = 532, .volt = 73700, .dyn_pwr = 53155, .lkg_pwr = {
			35994, 35994, 35994, 35994, 35994, 35994} },
		{.cap = 598, .volt = 76900, .dyn_pwr = 65203, .lkg_pwr = {
			38346, 38346, 38346, 38346, 38346, 38346} },
		{.cap = 658, .volt = 80000, .dyn_pwr = 77725, .lkg_pwr = {
			40726, 40726, 40726, 40726, 40726, 40726} },
		{.cap = 745, .volt = 84400, .dyn_pwr = 98039, .lkg_pwr = {
			44236, 44236, 44236, 44236, 44236, 44236} },
		{.cap = 811, .volt = 88100, .dyn_pwr = 116514, .lkg_pwr = {
			47314, 47314, 47314, 47314, 47314, 47314} },
		{.cap = 864, .volt = 91900, .dyn_pwr = 135263, .lkg_pwr = {
			50595, 50595, 50595, 50595, 50595, 50595} },
		{.cap = 891, .volt = 95000, .dyn_pwr = 149129, .lkg_pwr = {
			53417, 53417, 53417, 53417, 53417, 53417} },
		{.cap = 924, .volt = 98100, .dyn_pwr = 165099, .lkg_pwr = {
			56330, 56330, 56330, 56330, 56330, 56330} },
		{.cap = 951, .volt = 101200, .dyn_pwr = 180903, .lkg_pwr = {
			59309, 59309, 59309, 59309, 59309, 59309} },
		{.cap = 977, .volt = 104400, .dyn_pwr = 198068, .lkg_pwr = {
			62551, 62551, 62551, 62551, 62551, 62551} },
		{.cap = 991, .volt = 106900, .dyn_pwr = 210617, .lkg_pwr = {
			65118, 65118, 65118, 65118, 65118, 65118} },
		{.cap = 1011, .volt = 109400, .dyn_pwr = 225151, .lkg_pwr = {
			67775, 67775, 67775, 67775, 67775, 67775} },
		{.cap = 1024, .volt = 111900, .dyn_pwr = 238787, .lkg_pwr = {
			70461, 70461, 70461, 70461, 70461, 70461} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
	},
};

struct upower_tbl upower_tbl_cluster_l_1_FY = {
	.row = {
		{.cap = 266, .volt = 60000, .dyn_pwr = 3526, .lkg_pwr = {
			29357, 29357, 29357, 29357, 29357, 29357} },
		{.cap = 366, .volt = 65600, .dyn_pwr = 5568, .lkg_pwr = {
			31499, 31499, 31499, 31499, 31499, 31499} },
		{.cap = 465, .volt = 70600, .dyn_pwr = 8232, .lkg_pwr = {
			34283, 34283, 34283, 34283, 34283, 34283} },
		{.cap = 532, .volt = 73700, .dyn_pwr = 10269, .lkg_pwr = {
			36130, 36130, 36130, 36130, 36130, 36130} },
		{.cap = 598, .volt = 76900, .dyn_pwr = 12596, .lkg_pwr = {
			38102, 38102, 38102, 38102, 38102, 38102} },
		{.cap = 658, .volt = 80000, .dyn_pwr = 15015, .lkg_pwr = {
			40176, 40176, 40176, 40176, 40176, 40176} },
		{.cap = 745, .volt = 84400, .dyn_pwr = 18939, .lkg_pwr = {
			43378, 43378, 43378, 43378, 43378, 43378} },
		{.cap = 811, .volt = 88100, .dyn_pwr = 22508, .lkg_pwr = {
			46258, 46258, 46258, 46258, 46258, 46258} },
		{.cap = 864, .volt = 91900, .dyn_pwr = 26130, .lkg_pwr = {
			49372, 49372, 49372, 49372, 49372, 49372} },
		{.cap = 891, .volt = 95000, .dyn_pwr = 28809, .lkg_pwr = {
			52139, 52139, 52139, 52139, 52139, 52139} },
		{.cap = 924, .volt = 98100, .dyn_pwr = 31894, .lkg_pwr = {
			55128, 55128, 55128, 55128, 55128, 55128} },
		{.cap = 951, .volt = 101200, .dyn_pwr = 34947, .lkg_pwr = {
			58276, 58276, 58276, 58276, 58276, 58276} },
		{.cap = 977, .volt = 104400, .dyn_pwr = 38263, .lkg_pwr = {
			61917, 61917, 61917, 61917, 61917, 61917} },
		{.cap = 991, .volt = 106900, .dyn_pwr = 40687, .lkg_pwr = {
			64862, 64862, 64862, 64862, 64862, 64862} },
		{.cap = 1011, .volt = 109400, .dyn_pwr = 43495, .lkg_pwr = {
			68100, 68100, 68100, 68100, 68100, 68100} },
		{.cap = 1024, .volt = 111900, .dyn_pwr = 46129, .lkg_pwr = {
			71421, 71421, 71421, 71421, 71421, 71421} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
	},
};

struct upower_tbl upower_tbl_cci_1_FY = {
	.row = {
		{.cap = 0, .volt = 60000, .dyn_pwr = 1478, .lkg_pwr = {
			5269, 5269, 5269, 5269, 5269, 5269} },
		{.cap = 0, .volt = 65600, .dyn_pwr = 2603, .lkg_pwr = {
			5662, 5662, 5662, 5662, 5662, 5662} },
		{.cap = 0, .volt = 70600, .dyn_pwr = 3943, .lkg_pwr = {
			6172, 6172, 6172, 6172, 6172, 6172} },
		{.cap = 0, .volt = 73700, .dyn_pwr = 4878, .lkg_pwr = {
			6527, 6527, 6527, 6527, 6527, 6527} },
		{.cap = 0, .volt = 76900, .dyn_pwr = 6100, .lkg_pwr = {
			6916, 6916, 6916, 6916, 6916, 6916} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 7289, .lkg_pwr = {
			7341, 7341, 7341, 7341, 7341, 7341} },
		{.cap = 0, .volt = 84400, .dyn_pwr = 8883, .lkg_pwr = {
			8005, 8005, 8005, 8005, 8005, 8005} },
		{.cap = 0, .volt = 88100, .dyn_pwr = 10722, .lkg_pwr = {
			8647, 8647, 8647, 8647, 8647, 8647} },
		{.cap = 0, .volt = 91900, .dyn_pwr = 12580, .lkg_pwr = {
			9396, 9396, 9396, 9396, 9396, 9396} },
		{.cap = 0, .volt = 95000, .dyn_pwr = 14177, .lkg_pwr = {
			10103, 10103, 10103, 10103, 10103, 10103} },
		{.cap = 0, .volt = 98100, .dyn_pwr = 15900, .lkg_pwr = {
			10887, 10887, 10887, 10887, 10887, 10887} },
		{.cap = 0, .volt = 101200, .dyn_pwr = 18027, .lkg_pwr = {
			11726, 11726, 11726, 11726, 11726, 11726} },
		{.cap = 0, .volt = 104400, .dyn_pwr = 19491, .lkg_pwr = {
			12764, 12764, 12764, 12764, 12764, 12764} },
		{.cap = 0, .volt = 106900, .dyn_pwr = 20753, .lkg_pwr = {
			13619, 13619, 13619, 13619, 13619, 13619} },
		{.cap = 0, .volt = 109400, .dyn_pwr = 22067, .lkg_pwr = {
			14601, 14601, 14601, 14601, 14601, 14601} },
		{.cap = 0, .volt = 111900, .dyn_pwr = 23435, .lkg_pwr = {
			15640, 15640, 15640, 15640, 15640, 15640} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
	},
};

/* as same as L */
struct upower_tbl upower_tbl_l_plus_1_FY = {
	.row = {
		{.cap = 266, .volt = 60000, .dyn_pwr = 18253, .lkg_pwr = {
			27567, 27567, 27567, 27567, 27567, 27567} },
		{.cap = 366, .volt = 65600, .dyn_pwr = 28825, .lkg_pwr = {
			30379, 30379, 30379, 30379, 30379, 30379} },
		{.cap = 465, .volt = 70600, .dyn_pwr = 42613, .lkg_pwr = {
			33770, 33770, 33770, 33770, 33770, 33770} },
		{.cap = 532, .volt = 73700, .dyn_pwr = 53155, .lkg_pwr = {
			35994, 35994, 35994, 35994, 35994, 35994} },
		{.cap = 598, .volt = 76900, .dyn_pwr = 65203, .lkg_pwr = {
			38346, 38346, 38346, 38346, 38346, 38346} },
		{.cap = 658, .volt = 80000, .dyn_pwr = 77725, .lkg_pwr = {
			40726, 40726, 40726, 40726, 40726, 40726} },
		{.cap = 745, .volt = 84400, .dyn_pwr = 98039, .lkg_pwr = {
			44236, 44236, 44236, 44236, 44236, 44236} },
		{.cap = 811, .volt = 88100, .dyn_pwr = 116514, .lkg_pwr = {
			47314, 47314, 47314, 47314, 47314, 47314} },
		{.cap = 864, .volt = 91900, .dyn_pwr = 135263, .lkg_pwr = {
			50595, 50595, 50595, 50595, 50595, 50595} },
		{.cap = 891, .volt = 95000, .dyn_pwr = 149129, .lkg_pwr = {
			53417, 53417, 53417, 53417, 53417, 53417} },
		{.cap = 924, .volt = 98100, .dyn_pwr = 165099, .lkg_pwr = {
			56330, 56330, 56330, 56330, 56330, 56330} },
		{.cap = 951, .volt = 101200, .dyn_pwr = 180903, .lkg_pwr = {
			59309, 59309, 59309, 59309, 59309, 59309} },
		{.cap = 977, .volt = 104400, .dyn_pwr = 198068, .lkg_pwr = {
			62551, 62551, 62551, 62551, 62551, 62551} },
		{.cap = 991, .volt = 106900, .dyn_pwr = 210617, .lkg_pwr = {
			65118, 65118, 65118, 65118, 65118, 65118} },
		{.cap = 1011, .volt = 109400, .dyn_pwr = 225151, .lkg_pwr = {
			67775, 67775, 67775, 67775, 67775, 67775} },
		{.cap = 1024, .volt = 111900, .dyn_pwr = 238787, .lkg_pwr = {
			70461, 70461, 70461, 70461, 70461, 70461} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
	},
};

/* MT6763T_WAT0_ptpoff_85C (FY) */
struct upower_tbl upower_tbl_ll_2_FY = {
	.row = {
		{.cap = 148, .volt = 60000, .dyn_pwr = 9842, .lkg_pwr = {
			5539, 5539, 5539, 5539, 5539, 5539} },
		{.cap = 228, .volt = 65600, .dyn_pwr = 17390, .lkg_pwr = {
			6026, 6026, 6026, 6026, 6026, 6026} },
		{.cap = 290, .volt = 70000, .dyn_pwr = 25311, .lkg_pwr = {
			6598, 6598, 6598, 6598, 6598, 6598} },
		{.cap = 341, .volt = 73100, .dyn_pwr = 32525, .lkg_pwr = {
			7005, 7005, 7005, 7005, 7005, 7005} },
		{.cap = 387, .volt = 76200, .dyn_pwr = 40114, .lkg_pwr = {
			7406, 7406, 7406, 7406, 7406, 7406} },
		{.cap = 444, .volt = 80000, .dyn_pwr = 50800, .lkg_pwr = {
			7929, 7929, 7929, 7929, 7929, 7929} },
		{.cap = 501, .volt = 83700, .dyn_pwr = 62828, .lkg_pwr = {
			8445, 8445, 8445, 8445, 8445, 8445} },
		{.cap = 546, .volt = 86900, .dyn_pwr = 73967, .lkg_pwr = {
			8901, 8901, 8901, 8901, 8901, 8901} },
		{.cap = 586, .volt = 90000, .dyn_pwr = 85213, .lkg_pwr = {
			9368, 9368, 9368, 9368, 9368, 9368} },
		{.cap = 620, .volt = 93100, .dyn_pwr = 96590, .lkg_pwr = {
			9865, 9865, 9865, 9865, 9865, 9865} },
		{.cap = 654, .volt = 96200, .dyn_pwr = 108905, .lkg_pwr = {
			10383, 10383, 10383, 10383, 10383, 10383} },
		{.cap = 677, .volt = 98700, .dyn_pwr = 118709, .lkg_pwr = {
			10820, 10820, 10820, 10820, 10820, 10820} },
		{.cap = 711, .volt = 101900, .dyn_pwr = 133022, .lkg_pwr = {
			11382, 11382, 11382, 11382, 11382, 11382} },
		{.cap = 722, .volt = 105000, .dyn_pwr = 143609, .lkg_pwr = {
			11930, 11930, 11930, 11930, 11930, 11930} },
		{.cap = 734, .volt = 108700, .dyn_pwr = 156465, .lkg_pwr = {
			12581, 12581, 12581, 12581, 12581, 12581} },
		{.cap = 740, .volt = 111900, .dyn_pwr = 167214, .lkg_pwr = {
			13145, 13145, 13145, 13145, 13145, 13145} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
	},
};

struct upower_tbl upower_tbl_cluster_ll_2_FY = {
	.row = {
		{.cap = 148, .volt = 60000, .dyn_pwr = 1483, .lkg_pwr = {
			8518, 8518, 8518, 8518, 8518, 8518} },
		{.cap = 228, .volt = 65600, .dyn_pwr = 2620, .lkg_pwr = {
			8822, 8822, 8822, 8822, 8822, 8822} },
		{.cap = 290, .volt = 70000, .dyn_pwr = 3814, .lkg_pwr = {
			9114, 9114, 9114, 9114, 9114, 9114} },
		{.cap = 341, .volt = 73100, .dyn_pwr = 4901, .lkg_pwr = {
			9452, 9452, 9452, 9452, 9452, 9452} },
		{.cap = 387, .volt = 76200, .dyn_pwr = 6045, .lkg_pwr = {
			9887, 9887, 9887, 9887, 9887, 9887} },
		{.cap = 444, .volt = 80000, .dyn_pwr = 7655, .lkg_pwr = {
			10511, 10511, 10511, 10511, 10511, 10511} },
		{.cap = 501, .volt = 83700, .dyn_pwr = 9467, .lkg_pwr = {
			11193, 11193, 11193, 11193, 11193, 11193} },
		{.cap = 546, .volt = 86900, .dyn_pwr = 11146, .lkg_pwr = {
			11849, 11849, 11849, 11849, 11849, 11849} },
		{.cap = 586, .volt = 90000, .dyn_pwr = 12840, .lkg_pwr = {
			12628, 12628, 12628, 12628, 12628, 12628} },
		{.cap = 620, .volt = 93100, .dyn_pwr = 14555, .lkg_pwr = {
			13439, 13439, 13439, 13439, 13439, 13439} },
		{.cap = 654, .volt = 96200, .dyn_pwr = 16410, .lkg_pwr = {
			14273, 14273, 14273, 14273, 14273, 14273} },
		{.cap = 677, .volt = 98700, .dyn_pwr = 17888, .lkg_pwr = {
			15102, 15102, 15102, 15102, 15102, 15102} },
		{.cap = 711, .volt = 101900, .dyn_pwr = 20044, .lkg_pwr = {
			16209, 16209, 16209, 16209, 16209, 16209} },
		{.cap = 722, .volt = 105000, .dyn_pwr = 21640, .lkg_pwr = {
			17446, 17446, 17446, 17446, 17446, 17446} },
		{.cap = 734, .volt = 108700, .dyn_pwr = 23577, .lkg_pwr = {
			19254, 19254, 19254, 19254, 19254, 19254} },
		{.cap = 740, .volt = 111900, .dyn_pwr = 25197, .lkg_pwr = {
			21055, 21055, 21055, 21055, 21055, 21055} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
	},
};

struct upower_tbl upower_tbl_l_2_FY = {
	.row = {
		{.cap = 228, .volt = 60000, .dyn_pwr = 18253, .lkg_pwr = {
			27567, 27567, 27567, 27567, 27567, 27567} },
		{.cap = 336, .volt = 65600, .dyn_pwr = 30921, .lkg_pwr = {
			30379, 30379, 30379, 30379, 30379, 30379} },
		{.cap = 421, .volt = 70000, .dyn_pwr = 44271, .lkg_pwr = {
			33361, 33361, 33361, 33361, 33361, 33361} },
		{.cap = 495, .volt = 73100, .dyn_pwr = 56852, .lkg_pwr = {
			35557, 35557, 35557, 35557, 35557, 35557} },
		{.cap = 563, .volt = 76200, .dyn_pwr = 70401, .lkg_pwr = {
			37812, 37812, 37812, 37812, 37812, 37812} },
		{.cap = 643, .volt = 80000, .dyn_pwr = 88717, .lkg_pwr = {
			40726, 40726, 40726, 40726, 40726, 40726} },
		{.cap = 717, .volt = 83700, .dyn_pwr = 108444, .lkg_pwr = {
			43669, 43669, 43669, 43669, 43669, 43669} },
		{.cap = 779, .volt = 86900, .dyn_pwr = 127247, .lkg_pwr = {
			46289, 46289, 46289, 46289, 46289, 46289} },
		{.cap = 842, .volt = 90000, .dyn_pwr = 147600, .lkg_pwr = {
			48938, 48938, 48938, 48938, 48938, 48938} },
		{.cap = 870, .volt = 93100, .dyn_pwr = 163439, .lkg_pwr = {
			51688, 51688, 51688, 51688, 51688, 51688} },
		{.cap = 899, .volt = 96200, .dyn_pwr = 180372, .lkg_pwr = {
			54509, 54509, 54509, 54509, 54509, 54509} },
		{.cap = 927, .volt = 98700, .dyn_pwr = 196013, .lkg_pwr = {
			56906, 56906, 56906, 56906, 56906, 56906} },
		{.cap = 956, .volt = 101900, .dyn_pwr = 215518, .lkg_pwr = {
			60014, 60014, 60014, 60014, 60014, 60014} },
		{.cap = 978, .volt = 105000, .dyn_pwr = 234458, .lkg_pwr = {
			63160, 63160, 63160, 63160, 63160, 63160} },
	{.cap = 1001, .volt = 108700, .dyn_pwr = 257336, .lkg_pwr = {
			67031, 67031, 67031, 67031, 67031, 67031} },
	{.cap = 1024, .volt = 111900, .dyn_pwr = 279101, .lkg_pwr = {
			70461, 70461, 70461, 70461, 70461, 70461} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
	},
};

struct upower_tbl upower_tbl_cluster_l_2_FY = {
	.row = {
		{.cap = 228, .volt = 60000, .dyn_pwr = 3526, .lkg_pwr = {
			29357, 29357, 29357, 29357, 29357, 29357} },
		{.cap = 336, .volt = 65600, .dyn_pwr = 5973, .lkg_pwr = {
			31499, 31499, 31499, 31499, 31499, 31499} },
		{.cap = 421, .volt = 70000, .dyn_pwr = 8552, .lkg_pwr = {
			33943, 33943, 33943, 33943, 33943, 33943} },
		{.cap = 495, .volt = 73100, .dyn_pwr = 10983, .lkg_pwr = {
			35767, 35767, 35767, 35767, 35767, 35767} },
		{.cap = 563, .volt = 76200, .dyn_pwr = 13600, .lkg_pwr = {
			37641, 37641, 37641, 37641, 37641, 37641} },
		{.cap = 643, .volt = 80000, .dyn_pwr = 17139, .lkg_pwr = {
			40176, 40176, 40176, 40176, 40176, 40176} },
		{.cap = 717, .volt = 83700, .dyn_pwr = 20949, .lkg_pwr = {
			42851, 42851, 42851, 42851, 42851, 42851} },
		{.cap = 779, .volt = 86900, .dyn_pwr = 24582, .lkg_pwr = {
			45291, 45291, 45291, 45291, 45291, 45291} },
		{.cap = 842, .volt = 90000, .dyn_pwr = 28514, .lkg_pwr = {
			47789, 47789, 47789, 47789, 47789, 47789} },
		{.cap = 870, .volt = 93100, .dyn_pwr = 31573, .lkg_pwr = {
			50443, 50443, 50443, 50443, 50443, 50443} },
		{.cap = 899, .volt = 96200, .dyn_pwr = 34845, .lkg_pwr = {
			53211, 53211, 53211, 53211, 53211, 53211} },
		{.cap = 927, .volt = 98700, .dyn_pwr = 37866, .lkg_pwr = {
			55737, 55737, 55737, 55737, 55737, 55737} },
		{.cap = 956, .volt = 101900, .dyn_pwr = 41634, .lkg_pwr = {
			59063, 59063, 59063, 59063, 59063, 59063} },
		{.cap = 978, .volt = 105000, .dyn_pwr = 45293, .lkg_pwr = {
			62601, 62601, 62601, 62601, 62601, 62601} },
		{.cap = 1001, .volt = 108700, .dyn_pwr = 49713, .lkg_pwr = {
			67194, 67194, 67194, 67194, 67194, 67194} },
		{.cap = 1024, .volt = 111900, .dyn_pwr = 53917, .lkg_pwr = {
			71421, 71421, 71421, 71421, 71421, 71421} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
	},
};

struct upower_tbl upower_tbl_cci_2_FY = {
	.row = {
		{.cap = 0, .volt = 60000, .dyn_pwr = 1478, .lkg_pwr = {
			5269, 5269, 5269, 5269, 5269, 5269} },
		{.cap = 0, .volt = 65600, .dyn_pwr = 2829, .lkg_pwr = {
			5662, 5662, 5662, 5662, 5662, 5662} },
		{.cap = 0, .volt = 70000, .dyn_pwr = 4133, .lkg_pwr = {
			6110, 6110, 6110, 6110, 6110, 6110} },
		{.cap = 0, .volt = 73100, .dyn_pwr = 5220, .lkg_pwr = {
			6457, 6457, 6457, 6457, 6457, 6457} },
		{.cap = 0, .volt = 76200, .dyn_pwr = 6449, .lkg_pwr = {
			6822, 6822, 6822, 6822, 6822, 6822} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 8137, .lkg_pwr = {
			7341, 7341, 7341, 7341, 7341, 7341} },
		{.cap = 0, .volt = 83700, .dyn_pwr = 9849, .lkg_pwr = {
			7895, 7895, 7895, 7895, 7895, 7895} },
		{.cap = 0, .volt = 86900, .dyn_pwr = 11431, .lkg_pwr = {
			8417, 8417, 8417, 8417, 8417, 8417} },
		{.cap = 0, .volt = 90000, .dyn_pwr = 13135, .lkg_pwr = {
			9011, 9011, 9011, 9011, 9011, 9011} },
		{.cap = 0, .volt = 93100, .dyn_pwr = 14992, .lkg_pwr = {
			9670, 9670, 9670, 9670, 9670, 9670} },
		{.cap = 0, .volt = 96200, .dyn_pwr = 17007, .lkg_pwr = {
			10377, 10377, 10377, 10377, 10377, 10377} },
		{.cap = 0, .volt = 98700, .dyn_pwr = 18694, .lkg_pwr = {
			11050, 11050, 11050, 11050, 11050, 11050} },
		{.cap = 0, .volt = 101900, .dyn_pwr = 21050, .lkg_pwr = {
			11949, 11949, 11949, 11949, 11949, 11949} },
		{.cap = 0, .volt = 105000, .dyn_pwr = 22662, .lkg_pwr = {
			12959, 12959, 12959, 12959, 12959, 12959} },
		{.cap = 0, .volt = 108700, .dyn_pwr = 24939, .lkg_pwr = {
			14326, 14326, 14326, 14326, 14326, 14326} },
		{.cap = 0, .volt = 111900, .dyn_pwr = 26782, .lkg_pwr = {
			15640, 15640, 15640, 15640, 15640, 15640} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
	},
};

struct upower_tbl upower_tbl_l_plus_2_FY = {
	.row = {
		{.cap = 228, .volt = 60000, .dyn_pwr = 20950, .lkg_pwr = {
			41351, 41351, 41351, 41351, 41351, 41351} },
		{.cap = 336, .volt = 65600, .dyn_pwr = 35489, .lkg_pwr = {
			45568, 45568, 45568, 45568, 45568, 45568} },
		{.cap = 421, .volt = 70000, .dyn_pwr = 50812, .lkg_pwr = {
			50042, 50042, 50042, 50042, 50042, 50042} },
		{.cap = 495, .volt = 73100, .dyn_pwr = 65251, .lkg_pwr = {
			53336, 53336, 53336, 53336, 53336, 53336} },
		{.cap = 563, .volt = 76200, .dyn_pwr = 80801, .lkg_pwr = {
			56718, 56718, 56718, 56718, 56718, 56718} },
		{.cap = 643, .volt = 80000, .dyn_pwr = 101823, .lkg_pwr = {
			61089, 61089, 61089, 61089, 61089, 61089} },
		{.cap = 717, .volt = 83700, .dyn_pwr = 124464, .lkg_pwr = {
			65503, 65503, 65503, 65503, 65503, 65503} },
		{.cap = 779, .volt = 86900, .dyn_pwr = 146045, .lkg_pwr = {
			69433, 69433, 69433, 69433, 69433, 69433} },
		{.cap = 842, .volt = 90000, .dyn_pwr = 169405, .lkg_pwr = {
			73407, 73407, 73407, 73407, 73407, 73407} },
		{.cap = 870, .volt = 93100, .dyn_pwr = 187583, .lkg_pwr = {
			77531, 77531, 77531, 77531, 77531, 77531} },
		{.cap = 899, .volt = 96200, .dyn_pwr = 207017, .lkg_pwr = {
			81763, 81763, 81763, 81763, 81763, 81763} },
		{.cap = 927, .volt = 98700, .dyn_pwr = 224969, .lkg_pwr = {
			85359, 85359, 85359, 85359, 85359, 85359} },
		{.cap = 956, .volt = 101900, .dyn_pwr = 247356, .lkg_pwr = {
			90021, 90021, 90021, 90021, 90021, 90021} },
		{.cap = 978, .volt = 105000, .dyn_pwr = 269094, .lkg_pwr = {
			94741, 94741, 94741, 94741, 94741, 94741} },
	{.cap = 1001, .volt = 108700, .dyn_pwr = 295351, .lkg_pwr = {
			100547, 100547, 100547, 100547, 100547, 100547} },
	{.cap = 1024, .volt = 111900, .dyn_pwr = 320332, .lkg_pwr = {
			105691, 105691, 105691, 105691, 105691, 105691} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
	},
};

/* MT6763T_WAT0_ptpoff_85C (SB) */
struct upower_tbl upower_tbl_ll_2_SB = {
	.row = {
		{.cap = 148, .volt = 60000, .dyn_pwr = 9842, .lkg_pwr = {
			5539, 5539, 5539, 5539, 5539, 5539} },
		{.cap = 228, .volt = 65600, .dyn_pwr = 17390, .lkg_pwr = {
			6026, 6026, 6026, 6026, 6026, 6026} },
		{.cap = 302, .volt = 70600, .dyn_pwr = 26765, .lkg_pwr = {
			6678, 6678, 6678, 6678, 6678, 6678} },
		{.cap = 353, .volt = 73700, .dyn_pwr = 34173, .lkg_pwr = {
			7082, 7082, 7082, 7082, 7082, 7082} },
		{.cap = 398, .volt = 76900, .dyn_pwr = 42069, .lkg_pwr = {
			7502, 7502, 7502, 7502, 7502, 7502} },
		{.cap = 444, .volt = 80000, .dyn_pwr = 50800, .lkg_pwr = {
			7929, 7929, 7929, 7929, 7929, 7929} },
		{.cap = 506, .volt = 84400, .dyn_pwr = 64627, .lkg_pwr = {
			8544, 8544, 8544, 8544, 8544, 8544} },
		{.cap = 563, .volt = 88100, .dyn_pwr = 78432, .lkg_pwr = {
			9082, 9082, 9082, 9082, 9082, 9082} },
		{.cap = 609, .volt = 91900, .dyn_pwr = 92355, .lkg_pwr = {
			9664, 9664, 9664, 9664, 9664, 9664} },
		{.cap = 637, .volt = 95000, .dyn_pwr = 103399, .lkg_pwr = {
			10183, 10183, 10183, 10183, 10183, 10183} },
		{.cap = 671, .volt = 98100, .dyn_pwr = 116266, .lkg_pwr = {
			10715, 10715, 10715, 10715, 10715, 10715} },
		{.cap = 705, .volt = 101200, .dyn_pwr = 130128, .lkg_pwr = {
			11258, 11258, 11258, 11258, 11258, 11258} },
		{.cap = 728, .volt = 104400, .dyn_pwr = 143069, .lkg_pwr = {
			11824, 11824, 11824, 11824, 11824, 11824} },
		{.cap = 745, .volt = 106900, .dyn_pwr = 153610, .lkg_pwr = {
			12265, 12265, 12265, 12265, 12265, 12265} },
		{.cap = 768, .volt = 109400, .dyn_pwr = 165884, .lkg_pwr = {
			12704, 12704, 12704, 12704, 12704, 12704} },
		{.cap = 785, .volt = 111900, .dyn_pwr = 177504, .lkg_pwr = {
			13145, 13145, 13145, 13145, 13145, 13145} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
	},
};

struct upower_tbl upower_tbl_cluster_ll_2_SB = {
	.row = {
		{.cap = 148, .volt = 60000, .dyn_pwr = 1483, .lkg_pwr = {
			8518, 8518, 8518, 8518, 8518, 8518} },
		{.cap = 228, .volt = 65600, .dyn_pwr = 2620, .lkg_pwr = {
			8822, 8822, 8822, 8822, 8822, 8822} },
		{.cap = 302, .volt = 70600, .dyn_pwr = 4033, .lkg_pwr = {
			9154, 9154, 9154, 9154, 9154, 9154} },
		{.cap = 353, .volt = 73700, .dyn_pwr = 5149, .lkg_pwr = {
			9536, 9536, 9536, 9536, 9536, 9536} },
		{.cap = 398, .volt = 76900, .dyn_pwr = 6339, .lkg_pwr = {
			10000, 10000, 10000, 10000, 10000, 10000} },
		{.cap = 444, .volt = 80000, .dyn_pwr = 7655, .lkg_pwr = {
			10511, 10511, 10511, 10511, 10511, 10511} },
		{.cap = 506, .volt = 84400, .dyn_pwr = 9738, .lkg_pwr = {
			11329, 11329, 11329, 11329, 11329, 11329} },
		{.cap = 563, .volt = 88100, .dyn_pwr = 11819, .lkg_pwr = {
			12151, 12151, 12151, 12151, 12151, 12151} },
		{.cap = 609, .volt = 91900, .dyn_pwr = 13916, .lkg_pwr = {
			13116, 13116, 13116, 13116, 13116, 13116} },
		{.cap = 637, .volt = 95000, .dyn_pwr = 15581, .lkg_pwr = {
			13950, 13950, 13950, 13950, 13950, 13950} },
		{.cap = 671, .volt = 98100, .dyn_pwr = 17519, .lkg_pwr = {
			14901, 14901, 14901, 14901, 14901, 14901} },
		{.cap = 705, .volt = 101200, .dyn_pwr = 19608, .lkg_pwr = {
			15936, 15936, 15936, 15936, 15936, 15936} },
		{.cap = 728, .volt = 104400, .dyn_pwr = 21558, .lkg_pwr = {
			17206, 17206, 17206, 17206, 17206, 17206} },
		{.cap = 745, .volt = 106900, .dyn_pwr = 23147, .lkg_pwr = {
			18287, 18287, 18287, 18287, 18287, 18287} },
		{.cap = 768, .volt = 109400, .dyn_pwr = 24996, .lkg_pwr = {
			19631, 19631, 19631, 19631, 19631, 19631} },
		{.cap = 785, .volt = 111900, .dyn_pwr = 26747, .lkg_pwr = {
			21055, 21055, 21055, 21055, 21055, 21055} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
	},
};

struct upower_tbl upower_tbl_l_2_SB = {
	.row = {
		{.cap = 228, .volt = 60000, .dyn_pwr = 18253, .lkg_pwr = {
			27567, 27567, 27567, 27567, 27567, 27567} },
		{.cap = 336, .volt = 65600, .dyn_pwr = 30921, .lkg_pwr = {
			30379, 30379, 30379, 30379, 30379, 30379} },
		{.cap = 438, .volt = 70600, .dyn_pwr = 46874, .lkg_pwr = {
			33770, 33770, 33770, 33770, 33770, 33770} },
		{.cap = 506, .volt = 73700, .dyn_pwr = 59135, .lkg_pwr = {
			35994, 35994, 35994, 35994, 35994, 35994} },
		{.cap = 575, .volt = 76900, .dyn_pwr = 73172, .lkg_pwr = {
			38346, 38346, 38346, 38346, 38346, 38346} },
		{.cap = 643, .volt = 80000, .dyn_pwr = 88717, .lkg_pwr = {
			40726, 40726, 40726, 40726, 40726, 40726} },
		{.cap = 728, .volt = 84400, .dyn_pwr = 112045, .lkg_pwr = {
			44236, 44236, 44236, 44236, 44236, 44236} },
		{.cap = 802, .volt = 88100, .dyn_pwr = 134660, .lkg_pwr = {
			47314, 47314, 47314, 47314, 47314, 47314} },
		{.cap = 859, .volt = 91900, .dyn_pwr = 157113, .lkg_pwr = {
			50595, 50595, 50595, 50595, 50595, 50595} },
		{.cap = 887, .volt = 95000, .dyn_pwr = 173613, .lkg_pwr = {
			53417, 53417, 53417, 53417, 53417, 53417} },
		{.cap = 922, .volt = 98100, .dyn_pwr = 192417, .lkg_pwr = {
			56330, 56330, 56330, 56330, 56330, 56330} },
		{.cap = 950, .volt = 101200, .dyn_pwr = 211264, .lkg_pwr = {
			59309, 59309, 59309, 59309, 59309, 59309} },
		{.cap = 973, .volt = 104400, .dyn_pwr = 230405, .lkg_pwr = {
			62551, 62551, 62551, 62551, 62551, 62551} },
		{.cap = 990, .volt = 106900, .dyn_pwr = 245955, .lkg_pwr = {
			65118, 65118, 65118, 65118, 65118, 65118} },
	{.cap = 1007, .volt = 109400, .dyn_pwr = 262182, .lkg_pwr = {
			67775, 67775, 67775, 67775, 67775, 67775} },
	{.cap = 1024, .volt = 111900, .dyn_pwr = 279101, .lkg_pwr = {
			70461, 70461, 70461, 70461, 70461, 70461} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
	},
};

struct upower_tbl upower_tbl_cluster_l_2_SB = {
	.row = {
		{.cap = 228, .volt = 60000, .dyn_pwr = 3526, .lkg_pwr = {
			29357, 29357, 29357, 29357, 29357, 29357} },
		{.cap = 336, .volt = 65600, .dyn_pwr = 5973, .lkg_pwr = {
			31499, 31499, 31499, 31499, 31499, 31499} },
		{.cap = 438, .volt = 70600, .dyn_pwr = 9055, .lkg_pwr = {
			34283, 34283, 34283, 34283, 34283, 34283} },
		{.cap = 506, .volt = 73700, .dyn_pwr = 11424, .lkg_pwr = {
			36130, 36130, 36130, 36130, 36130, 36130} },
		{.cap = 575, .volt = 76900, .dyn_pwr = 14135, .lkg_pwr = {
			38102, 38102, 38102, 38102, 38102, 38102} },
		{.cap = 643, .volt = 80000, .dyn_pwr = 17139, .lkg_pwr = {
			40176, 40176, 40176, 40176, 40176, 40176} },
		{.cap = 728, .volt = 84400, .dyn_pwr = 21645, .lkg_pwr = {
			43378, 43378, 43378, 43378, 43378, 43378} },
		{.cap = 802, .volt = 88100, .dyn_pwr = 26014, .lkg_pwr = {
			46258, 46258, 46258, 46258, 46258, 46258} },
		{.cap = 859, .volt = 91900, .dyn_pwr = 30351, .lkg_pwr = {
			49372, 49372, 49372, 49372, 49372, 49372} },
		{.cap = 887, .volt = 95000, .dyn_pwr = 33539, .lkg_pwr = {
			52139, 52139, 52139, 52139, 52139, 52139} },
		{.cap = 922, .volt = 98100, .dyn_pwr = 37172, .lkg_pwr = {
			55128, 55128, 55128, 55128, 55128, 55128} },
		{.cap = 950, .volt = 101200, .dyn_pwr = 40812, .lkg_pwr = {
			58276, 58276, 58276, 58276, 58276, 58276} },
		{.cap = 973, .volt = 104400, .dyn_pwr = 44510, .lkg_pwr = {
			61917, 61917, 61917, 61917, 61917, 61917} },
		{.cap = 990, .volt = 106900, .dyn_pwr = 47514, .lkg_pwr = {
			64862, 64862, 64862, 64862, 64862, 64862} },
		{.cap = 1007, .volt = 109400, .dyn_pwr = 50649, .lkg_pwr = {
			68100, 68100, 68100, 68100, 68100, 68100} },
		{.cap = 1024, .volt = 111900, .dyn_pwr = 53917, .lkg_pwr = {
			71421, 71421, 71421, 71421, 71421, 71421} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
	},
};

struct upower_tbl upower_tbl_cci_2_SB = {
	.row = {
		{.cap = 0, .volt = 60000, .dyn_pwr = 1478, .lkg_pwr = {
			5269, 5269, 5269, 5269, 5269, 5269} },
		{.cap = 0, .volt = 65600, .dyn_pwr = 2829, .lkg_pwr = {
			5662, 5662, 5662, 5662, 5662, 5662} },
		{.cap = 0, .volt = 70600, .dyn_pwr = 4337, .lkg_pwr = {
			6172, 6172, 6172, 6172, 6172, 6172} },
		{.cap = 0, .volt = 73700, .dyn_pwr = 5451, .lkg_pwr = {
			6527, 6527, 6527, 6527, 6527, 6527} },
		{.cap = 0, .volt = 76900, .dyn_pwr = 6726, .lkg_pwr = {
			6916, 6916, 6916, 6916, 6916, 6916} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 8137, .lkg_pwr = {
			7341, 7341, 7341, 7341, 7341, 7341} },
		{.cap = 0, .volt = 84400, .dyn_pwr = 10017, .lkg_pwr = {
			8005, 8005, 8005, 8005, 8005, 8005} },
		{.cap = 0, .volt = 88100, .dyn_pwr = 12166, .lkg_pwr = {
			8647, 8647, 8647, 8647, 8647, 8647} },
		{.cap = 0, .volt = 91900, .dyn_pwr = 14153, .lkg_pwr = {
			9396, 9396, 9396, 9396, 9396, 9396} },
		{.cap = 0, .volt = 95000, .dyn_pwr = 16099, .lkg_pwr = {
			10103, 10103, 10103, 10103, 10103, 10103} },
		{.cap = 0, .volt = 98100, .dyn_pwr = 18208, .lkg_pwr = {
			10887, 10887, 10887, 10887, 10887, 10887} },
		{.cap = 0, .volt = 101200, .dyn_pwr = 20485, .lkg_pwr = {
			11726, 11726, 11726, 11726, 11726, 11726} },
		{.cap = 0, .volt = 104400, .dyn_pwr = 22401, .lkg_pwr = {
			12764, 12764, 12764, 12764, 12764, 12764} },
		{.cap = 0, .volt = 106900, .dyn_pwr = 23805, .lkg_pwr = {
			13619, 13619, 13619, 13619, 13619, 13619} },
		{.cap = 0, .volt = 109400, .dyn_pwr = 25266, .lkg_pwr = {
			14601, 14601, 14601, 14601, 14601, 14601} },
		{.cap = 0, .volt = 111900, .dyn_pwr = 26782, .lkg_pwr = {
			15640, 15640, 15640, 15640, 15640, 15640} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
	},
};

struct upower_tbl upower_tbl_l_plus_2_SB = {
	.row = {
		{.cap = 228, .volt = 60000, .dyn_pwr = 20950, .lkg_pwr = {
			41351, 41351, 41351, 41351, 41351, 41351} },
		{.cap = 336, .volt = 65600, .dyn_pwr = 35489, .lkg_pwr = {
			45568, 45568, 45568, 45568, 45568, 45568} },
		{.cap = 438, .volt = 70600, .dyn_pwr = 53799, .lkg_pwr = {
			50656, 50656, 50656, 50656, 50656, 50656} },
		{.cap = 506, .volt = 73700, .dyn_pwr = 67871, .lkg_pwr = {
			53991, 53991, 53991, 53991, 53991, 53991} },
		{.cap = 575, .volt = 76900, .dyn_pwr = 83981, .lkg_pwr = {
			57519, 57519, 57519, 57519, 57519, 57519} },
		{.cap = 643, .volt = 80000, .dyn_pwr = 101823, .lkg_pwr = {
			61089, 61089, 61089, 61089, 61089, 61089} },
		{.cap = 728, .volt = 84400, .dyn_pwr = 128597, .lkg_pwr = {
			66354, 66354, 66354, 66354, 66354, 66354} },
		{.cap = 802, .volt = 88100, .dyn_pwr = 154553, .lkg_pwr = {
			70972, 70972, 70972, 70972, 70972, 70972} },
		{.cap = 859, .volt = 91900, .dyn_pwr = 180323, .lkg_pwr = {
			75893, 75893, 75893, 75893, 75893, 75893} },
		{.cap = 887, .volt = 95000, .dyn_pwr = 199261, .lkg_pwr = {
			80125, 80125, 80125, 80125, 80125, 80125} },
		{.cap = 922, .volt = 98100, .dyn_pwr = 220843, .lkg_pwr = {
			84495, 84495, 84495, 84495, 84495, 84495} },
		{.cap = 950, .volt = 101200, .dyn_pwr = 242474, .lkg_pwr = {
			88963, 88963, 88963, 88963, 88963, 88963} },
		{.cap = 973, .volt = 104400, .dyn_pwr = 264442, .lkg_pwr = {
			93827, 93827, 93827, 93827, 93827, 93827} },
		{.cap = 990, .volt = 106900, .dyn_pwr = 282289, .lkg_pwr = {
			97677, 97677, 97677, 97677, 97677, 97677} },
	{.cap = 1007, .volt = 109400, .dyn_pwr = 300914, .lkg_pwr = {
			101663, 101663, 101663, 101663, 101663, 101663} },
	{.cap = 1024, .volt = 111900, .dyn_pwr = 320332, .lkg_pwr = {
			105691, 105691, 105691, 105691, 105691, 105691} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
	},
};

/* MT6763TT_WAT0_ptpoff_85C (FY) */
struct upower_tbl upower_tbl_ll_3_FY = {
	.row = {
		{.cap = 139, .volt = 60000, .dyn_pwr = 9842, .lkg_pwr = {
			5539, 5539, 5539, 5539, 5539, 5539} },
		{.cap = 213, .volt = 65600, .dyn_pwr = 17390, .lkg_pwr = {
			6026, 6026, 6026, 6026, 6026, 6026} },
		{.cap = 283, .volt = 70600, .dyn_pwr = 26765, .lkg_pwr = {
			6678, 6678, 6678, 6678, 6678, 6678} },
		{.cap = 331, .volt = 73700, .dyn_pwr = 34173, .lkg_pwr = {
			7082, 7082, 7082, 7082, 7082, 7082} },
		{.cap = 373, .volt = 76900, .dyn_pwr = 42069, .lkg_pwr = {
			7502, 7502, 7502, 7502, 7502, 7502} },
		{.cap = 416, .volt = 80000, .dyn_pwr = 50800, .lkg_pwr = {
			7929, 7929, 7929, 7929, 7929, 7929} },
		{.cap = 475, .volt = 84400, .dyn_pwr = 64627, .lkg_pwr = {
			8544, 8544, 8544, 8544, 8544, 8544} },
		{.cap = 528, .volt = 88100, .dyn_pwr = 78432, .lkg_pwr = {
			9082, 9082, 9082, 9082, 9082, 9082} },
		{.cap = 571, .volt = 91900, .dyn_pwr = 92355, .lkg_pwr = {
			9664, 9664, 9664, 9664, 9664, 9664} },
		{.cap = 597, .volt = 95000, .dyn_pwr = 103399, .lkg_pwr = {
			10183, 10183, 10183, 10183, 10183, 10183} },
		{.cap = 629, .volt = 98100, .dyn_pwr = 116266, .lkg_pwr = {
			10715, 10715, 10715, 10715, 10715, 10715} },
		{.cap = 661, .volt = 101200, .dyn_pwr = 130128, .lkg_pwr = {
			11258, 11258, 11258, 11258, 11258, 11258} },
		{.cap = 677, .volt = 104400, .dyn_pwr = 141952, .lkg_pwr = {
			11824, 11824, 11824, 11824, 11824, 11824} },
		{.cap = 683, .volt = 106900, .dyn_pwr = 150092, .lkg_pwr = {
			12265, 12265, 12265, 12265, 12265, 12265} },
		{.cap = 688, .volt = 109400, .dyn_pwr = 158511, .lkg_pwr = {
			12704, 12704, 12704, 12704, 12704, 12704} },
		{.cap = 693, .volt = 111900, .dyn_pwr = 167214, .lkg_pwr = {
			13145, 13145, 13145, 13145, 13145, 13145} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
	},
};

struct upower_tbl upower_tbl_cluster_ll_3_FY = {
	.row = {
		{.cap = 139, .volt = 60000, .dyn_pwr = 1483, .lkg_pwr = {
			8518, 8518, 8518, 8518, 8518, 8518} },
		{.cap = 213, .volt = 65600, .dyn_pwr = 2620, .lkg_pwr = {
			8822, 8822, 8822, 8822, 8822, 8822} },
		{.cap = 283, .volt = 70600, .dyn_pwr = 4033, .lkg_pwr = {
			9154, 9154, 9154, 9154, 9154, 9154} },
		{.cap = 331, .volt = 73700, .dyn_pwr = 5149, .lkg_pwr = {
			9536, 9536, 9536, 9536, 9536, 9536} },
		{.cap = 373, .volt = 76900, .dyn_pwr = 6339, .lkg_pwr = {
			10000, 10000, 10000, 10000, 10000, 10000} },
		{.cap = 416, .volt = 80000, .dyn_pwr = 7655, .lkg_pwr = {
			10511, 10511, 10511, 10511, 10511, 10511} },
		{.cap = 475, .volt = 84400, .dyn_pwr = 9738, .lkg_pwr = {
			11329, 11329, 11329, 11329, 11329, 11329} },
		{.cap = 528, .volt = 88100, .dyn_pwr = 11819, .lkg_pwr = {
			12151, 12151, 12151, 12151, 12151, 12151} },
		{.cap = 571, .volt = 91900, .dyn_pwr = 13916, .lkg_pwr = {
			13116, 13116, 13116, 13116, 13116, 13116} },
		{.cap = 597, .volt = 95000, .dyn_pwr = 15581, .lkg_pwr = {
			13950, 13950, 13950, 13950, 13950, 13950} },
		{.cap = 629, .volt = 98100, .dyn_pwr = 17519, .lkg_pwr = {
			14901, 14901, 14901, 14901, 14901, 14901} },
		{.cap = 661, .volt = 101200, .dyn_pwr = 19608, .lkg_pwr = {
			15936, 15936, 15936, 15936, 15936, 15936} },
		{.cap = 677, .volt = 104400, .dyn_pwr = 21390, .lkg_pwr = {
			17206, 17206, 17206, 17206, 17206, 17206} },
		{.cap = 683, .volt = 106900, .dyn_pwr = 22617, .lkg_pwr = {
			18287, 18287, 18287, 18287, 18287, 18287} },
		{.cap = 688, .volt = 109400, .dyn_pwr = 23885, .lkg_pwr = {
			19631, 19631, 19631, 19631, 19631, 19631} },
		{.cap = 693, .volt = 111900, .dyn_pwr = 25197, .lkg_pwr = {
			21055, 21055, 21055, 21055, 21055, 21055} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
	},
};

struct upower_tbl upower_tbl_l_3_FY = {
	.row = {
		{.cap = 213, .volt = 60000, .dyn_pwr = 18253, .lkg_pwr = {
			27567, 27567, 27567, 27567, 27567, 27567} },
		{.cap = 315, .volt = 65600, .dyn_pwr = 30921, .lkg_pwr = {
			30379, 30379, 30379, 30379, 30379, 30379} },
		{.cap = 411, .volt = 70600, .dyn_pwr = 46874, .lkg_pwr = {
			33770, 33770, 33770, 33770, 33770, 33770} },
		{.cap = 475, .volt = 73700, .dyn_pwr = 59135, .lkg_pwr = {
			35994, 35994, 35994, 35994, 35994, 35994} },
		{.cap = 539, .volt = 76900, .dyn_pwr = 73172, .lkg_pwr = {
			38346, 38346, 38346, 38346, 38346, 38346} },
		{.cap = 603, .volt = 80000, .dyn_pwr = 88717, .lkg_pwr = {
			40726, 40726, 40726, 40726, 40726, 40726} },
		{.cap = 683, .volt = 84400, .dyn_pwr = 112045, .lkg_pwr = {
			44236, 44236, 44236, 44236, 44236, 44236} },
		{.cap = 752, .volt = 88100, .dyn_pwr = 134660, .lkg_pwr = {
			47314, 47314, 47314, 47314, 47314, 47314} },
		{.cap = 805, .volt = 91900, .dyn_pwr = 157113, .lkg_pwr = {
			50595, 50595, 50595, 50595, 50595, 50595} },
		{.cap = 832, .volt = 95000, .dyn_pwr = 173613, .lkg_pwr = {
			53417, 53417, 53417, 53417, 53417, 53417} },
		{.cap = 864, .volt = 98100, .dyn_pwr = 192417, .lkg_pwr = {
			56330, 56330, 56330, 56330, 56330, 56330} },
		{.cap = 891, .volt = 101200, .dyn_pwr = 211264, .lkg_pwr = {
			59309, 59309, 59309, 59309, 59309, 59309} },
		{.cap = 928, .volt = 104400, .dyn_pwr = 234447, .lkg_pwr = {
			62551, 62551, 62551, 62551, 62551, 62551} },
		{.cap = 960, .volt = 106900, .dyn_pwr = 254436, .lkg_pwr = {
			65118, 65118, 65118, 65118, 65118, 65118} },
		{.cap = 992, .volt = 109400, .dyn_pwr = 275514, .lkg_pwr = {
			67775, 67775, 67775, 67775, 67775, 67775} },
	{.cap = 1024, .volt = 111900, .dyn_pwr = 297708, .lkg_pwr = {
			70461, 70461, 70461, 70461, 70461, 70461} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
	},
};

struct upower_tbl upower_tbl_cluster_l_3_FY = {
	.row = {
		{.cap = 213, .volt = 60000, .dyn_pwr = 3526, .lkg_pwr = {
			29357, 29357, 29357, 29357, 29357, 29357} },
		{.cap = 315, .volt = 65600, .dyn_pwr = 5973, .lkg_pwr = {
			31499, 31499, 31499, 31499, 31499, 31499} },
		{.cap = 411, .volt = 70600, .dyn_pwr = 9055, .lkg_pwr = {
			34283, 34283, 34283, 34283, 34283, 34283} },
		{.cap = 475, .volt = 73700, .dyn_pwr = 11424, .lkg_pwr = {
			36130, 36130, 36130, 36130, 36130, 36130} },
		{.cap = 539, .volt = 76900, .dyn_pwr = 14135, .lkg_pwr = {
			38102, 38102, 38102, 38102, 38102, 38102} },
		{.cap = 603, .volt = 80000, .dyn_pwr = 17139, .lkg_pwr = {
			40176, 40176, 40176, 40176, 40176, 40176} },
		{.cap = 683, .volt = 84400, .dyn_pwr = 21645, .lkg_pwr = {
			43378, 43378, 43378, 43378, 43378, 43378} },
		{.cap = 752, .volt = 88100, .dyn_pwr = 26014, .lkg_pwr = {
			46258, 46258, 46258, 46258, 46258, 46258} },
		{.cap = 805, .volt = 91900, .dyn_pwr = 30351, .lkg_pwr = {
			49372, 49372, 49372, 49372, 49372, 49372} },
		{.cap = 832, .volt = 95000, .dyn_pwr = 33539, .lkg_pwr = {
			52139, 52139, 52139, 52139, 52139, 52139} },
		{.cap = 864, .volt = 98100, .dyn_pwr = 37172, .lkg_pwr = {
			55128, 55128, 55128, 55128, 55128, 55128} },
		{.cap = 891, .volt = 101200, .dyn_pwr = 40812, .lkg_pwr = {
			58276, 58276, 58276, 58276, 58276, 58276} },
		{.cap = 928, .volt = 104400, .dyn_pwr = 45291, .lkg_pwr = {
			61917, 61917, 61917, 61917, 61917, 61917} },
		{.cap = 960, .volt = 106900, .dyn_pwr = 49152, .lkg_pwr = {
			64862, 64862, 64862, 64862, 64862, 64862} },
		{.cap = 992, .volt = 109400, .dyn_pwr = 53224, .lkg_pwr = {
			68100, 68100, 68100, 68100, 68100, 68100} },
		{.cap = 1024, .volt = 111900, .dyn_pwr = 57512, .lkg_pwr = {
			71421, 71421, 71421, 71421, 71421, 71421} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
	},
};

struct upower_tbl upower_tbl_cci_3_FY = {
	.row = {
		{.cap = 0, .volt = 60000, .dyn_pwr = 1478, .lkg_pwr = {
			5269, 5269, 5269, 5269, 5269, 5269} },
		{.cap = 0, .volt = 65600, .dyn_pwr = 2829, .lkg_pwr = {
			5662, 5662, 5662, 5662, 5662, 5662} },
		{.cap = 0, .volt = 70600, .dyn_pwr = 4337, .lkg_pwr = {
			6172, 6172, 6172, 6172, 6172, 6172} },
		{.cap = 0, .volt = 73700, .dyn_pwr = 5451, .lkg_pwr = {
			6527, 6527, 6527, 6527, 6527, 6527} },
		{.cap = 0, .volt = 76900, .dyn_pwr = 6726, .lkg_pwr = {
			6916, 6916, 6916, 6916, 6916, 6916} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 8137, .lkg_pwr = {
			7341, 7341, 7341, 7341, 7341, 7341} },
		{.cap = 0, .volt = 84400, .dyn_pwr = 10017, .lkg_pwr = {
			8005, 8005, 8005, 8005, 8005, 8005} },
		{.cap = 0, .volt = 88100, .dyn_pwr = 12166, .lkg_pwr = {
			8647, 8647, 8647, 8647, 8647, 8647} },
		{.cap = 0, .volt = 91900, .dyn_pwr = 14153, .lkg_pwr = {
			9396, 9396, 9396, 9396, 9396, 9396} },
		{.cap = 0, .volt = 95000, .dyn_pwr = 16099, .lkg_pwr = {
			10103, 10103, 10103, 10103, 10103, 10103} },
		{.cap = 0, .volt = 98100, .dyn_pwr = 18208, .lkg_pwr = {
			10887, 10887, 10887, 10887, 10887, 10887} },
		{.cap = 0, .volt = 101200, .dyn_pwr = 20485, .lkg_pwr = {
			11726, 11726, 11726, 11726, 11726, 11726} },
		{.cap = 0, .volt = 104400, .dyn_pwr = 22691, .lkg_pwr = {
			12764, 12764, 12764, 12764, 12764, 12764} },
		{.cap = 0, .volt = 106900, .dyn_pwr = 24416, .lkg_pwr = {
			13619, 13619, 13619, 13619, 13619, 13619} },
		{.cap = 0, .volt = 109400, .dyn_pwr = 26225, .lkg_pwr = {
			14601, 14601, 14601, 14601, 14601, 14601} },
		{.cap = 0, .volt = 111900, .dyn_pwr = 28122, .lkg_pwr = {
			15640, 15640, 15640, 15640, 15640, 15640} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
	},
};

struct upower_tbl upower_tbl_l_plus_3_FY = {
	.row = {
		{.cap = 213, .volt = 60000, .dyn_pwr = 20950, .lkg_pwr = {
			41351, 41351, 41351, 41351, 41351, 41351} },
		{.cap = 315, .volt = 65600, .dyn_pwr = 35489, .lkg_pwr = {
			45568, 45568, 45568, 45568, 45568, 45568} },
		{.cap = 411, .volt = 70600, .dyn_pwr = 53799, .lkg_pwr = {
			50656, 50656, 50656, 50656, 50656, 50656} },
		{.cap = 475, .volt = 73700, .dyn_pwr = 67871, .lkg_pwr = {
			53991, 53991, 53991, 53991, 53991, 53991} },
		{.cap = 539, .volt = 76900, .dyn_pwr = 83981, .lkg_pwr = {
			57519, 57519, 57519, 57519, 57519, 57519} },
		{.cap = 603, .volt = 80000, .dyn_pwr = 101823, .lkg_pwr = {
			61089, 61089, 61089, 61089, 61089, 61089} },
		{.cap = 683, .volt = 84400, .dyn_pwr = 128597, .lkg_pwr = {
			66354, 66354, 66354, 66354, 66354, 66354} },
		{.cap = 752, .volt = 88100, .dyn_pwr = 154553, .lkg_pwr = {
			70972, 70972, 70972, 70972, 70972, 70972} },
		{.cap = 805, .volt = 91900, .dyn_pwr = 180323, .lkg_pwr = {
			75893, 75893, 75893, 75893, 75893, 75893} },
		{.cap = 832, .volt = 95000, .dyn_pwr = 199261, .lkg_pwr = {
			80125, 80125, 80125, 80125, 80125, 80125} },
		{.cap = 864, .volt = 98100, .dyn_pwr = 220843, .lkg_pwr = {
			84495, 84495, 84495, 84495, 84495, 84495} },
		{.cap = 891, .volt = 101200, .dyn_pwr = 242474, .lkg_pwr = {
			88963, 88963, 88963, 88963, 88963, 88963} },
		{.cap = 928, .volt = 104400, .dyn_pwr = 269082, .lkg_pwr = {
			93827, 93827, 93827, 93827, 93827, 93827} },
		{.cap = 960, .volt = 106900, .dyn_pwr = 292024, .lkg_pwr = {
			97677, 97677, 97677, 97677, 97677, 97677} },
	{.cap = 992, .volt = 109400, .dyn_pwr = 316215, .lkg_pwr = {
			101663, 101663, 101663, 101663, 101663, 101663} },
	{.cap = 1024, .volt = 111900, .dyn_pwr = 341687, .lkg_pwr = {
			105691, 105691, 105691, 105691, 105691, 105691} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
	},
};

/* MT6763TT_WAT0_ptpoff_85C (SB) */
struct upower_tbl upower_tbl_ll_3_SB = {
	.row = {
		{.cap = 139, .volt = 60000, .dyn_pwr = 9842, .lkg_pwr = {
			5539, 5539, 5539, 5539, 5539, 5539} },
		{.cap = 213, .volt = 65600, .dyn_pwr = 17390, .lkg_pwr = {
			6026, 6026, 6026, 6026, 6026, 6026} },
		{.cap = 283, .volt = 70600, .dyn_pwr = 26765, .lkg_pwr = {
			6678, 6678, 6678, 6678, 6678, 6678} },
		{.cap = 331, .volt = 73700, .dyn_pwr = 34173, .lkg_pwr = {
			7082, 7082, 7082, 7082, 7082, 7082} },
		{.cap = 373, .volt = 76900, .dyn_pwr = 42069, .lkg_pwr = {
			7502, 7502, 7502, 7502, 7502, 7502} },
		{.cap = 416, .volt = 80000, .dyn_pwr = 50800, .lkg_pwr = {
			7929, 7929, 7929, 7929, 7929, 7929} },
		{.cap = 475, .volt = 84400, .dyn_pwr = 64627, .lkg_pwr = {
			8544, 8544, 8544, 8544, 8544, 8544} },
		{.cap = 528, .volt = 88100, .dyn_pwr = 78432, .lkg_pwr = {
			9082, 9082, 9082, 9082, 9082, 9082} },
		{.cap = 571, .volt = 91900, .dyn_pwr = 92355, .lkg_pwr = {
			9664, 9664, 9664, 9664, 9664, 9664} },
		{.cap = 597, .volt = 95000, .dyn_pwr = 103399, .lkg_pwr = {
			10183, 10183, 10183, 10183, 10183, 10183} },
		{.cap = 629, .volt = 98100, .dyn_pwr = 116266, .lkg_pwr = {
			10715, 10715, 10715, 10715, 10715, 10715} },
		{.cap = 661, .volt = 101200, .dyn_pwr = 130128, .lkg_pwr = {
			11258, 11258, 11258, 11258, 11258, 11258} },
		{.cap = 693, .volt = 104400, .dyn_pwr = 145305, .lkg_pwr = {
			11824, 11824, 11824, 11824, 11824, 11824} },
		{.cap = 720, .volt = 106900, .dyn_pwr = 158300, .lkg_pwr = {
			12265, 12265, 12265, 12265, 12265, 12265} },
		{.cap = 747, .volt = 109400, .dyn_pwr = 172028, .lkg_pwr = {
			12704, 12704, 12704, 12704, 12704, 12704} },
		{.cap = 773, .volt = 111900, .dyn_pwr = 186508, .lkg_pwr = {
			13145, 13145, 13145, 13145, 13145, 13145} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
		{{0}, {5539} },
	},
};

struct upower_tbl upower_tbl_cluster_ll_3_SB = {
	.row = {
		{.cap = 139, .volt = 60000, .dyn_pwr = 1483, .lkg_pwr = {
			8518, 8518, 8518, 8518, 8518, 8518} },
		{.cap = 213, .volt = 65600, .dyn_pwr = 2620, .lkg_pwr = {
			8822, 8822, 8822, 8822, 8822, 8822} },
		{.cap = 283, .volt = 70600, .dyn_pwr = 4033, .lkg_pwr = {
			9154, 9154, 9154, 9154, 9154, 9154} },
		{.cap = 331, .volt = 73700, .dyn_pwr = 5149, .lkg_pwr = {
			9536, 9536, 9536, 9536, 9536, 9536} },
		{.cap = 373, .volt = 76900, .dyn_pwr = 6339, .lkg_pwr = {
			10000, 10000, 10000, 10000, 10000, 10000} },
		{.cap = 416, .volt = 80000, .dyn_pwr = 7655, .lkg_pwr = {
			10511, 10511, 10511, 10511, 10511, 10511} },
		{.cap = 475, .volt = 84400, .dyn_pwr = 9738, .lkg_pwr = {
			11329, 11329, 11329, 11329, 11329, 11329} },
		{.cap = 528, .volt = 88100, .dyn_pwr = 11819, .lkg_pwr = {
			12151, 12151, 12151, 12151, 12151, 12151} },
		{.cap = 571, .volt = 91900, .dyn_pwr = 13916, .lkg_pwr = {
			13116, 13116, 13116, 13116, 13116, 13116} },
		{.cap = 597, .volt = 95000, .dyn_pwr = 15581, .lkg_pwr = {
			13950, 13950, 13950, 13950, 13950, 13950} },
		{.cap = 629, .volt = 98100, .dyn_pwr = 17519, .lkg_pwr = {
			14901, 14901, 14901, 14901, 14901, 14901} },
		{.cap = 661, .volt = 101200, .dyn_pwr = 19608, .lkg_pwr = {
			15936, 15936, 15936, 15936, 15936, 15936} },
		{.cap = 693, .volt = 104400, .dyn_pwr = 21895, .lkg_pwr = {
			17206, 17206, 17206, 17206, 17206, 17206} },
		{.cap = 720, .volt = 106900, .dyn_pwr = 23853, .lkg_pwr = {
			18287, 18287, 18287, 18287, 18287, 18287} },
		{.cap = 747, .volt = 109400, .dyn_pwr = 25922, .lkg_pwr = {
			19631, 19631, 19631, 19631, 19631, 19631} },
		{.cap = 773, .volt = 111900, .dyn_pwr = 28104, .lkg_pwr = {
			21055, 21055, 21055, 21055, 21055, 21055} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
		{{0}, {8518} },
	},
};

struct upower_tbl upower_tbl_l_3_SB = {
	.row = {
		{.cap = 213, .volt = 60000, .dyn_pwr = 18253, .lkg_pwr = {
			27567, 27567, 27567, 27567, 27567, 27567} },
		{.cap = 315, .volt = 65600, .dyn_pwr = 30921, .lkg_pwr = {
			30379, 30379, 30379, 30379, 30379, 30379} },
		{.cap = 411, .volt = 70600, .dyn_pwr = 46874, .lkg_pwr = {
			33770, 33770, 33770, 33770, 33770, 33770} },
		{.cap = 475, .volt = 73700, .dyn_pwr = 59135, .lkg_pwr = {
			35994, 35994, 35994, 35994, 35994, 35994} },
		{.cap = 539, .volt = 76900, .dyn_pwr = 73172, .lkg_pwr = {
			38346, 38346, 38346, 38346, 38346, 38346} },
		{.cap = 603, .volt = 80000, .dyn_pwr = 88717, .lkg_pwr = {
			40726, 40726, 40726, 40726, 40726, 40726} },
		{.cap = 683, .volt = 84400, .dyn_pwr = 112045, .lkg_pwr = {
			44236, 44236, 44236, 44236, 44236, 44236} },
		{.cap = 752, .volt = 88100, .dyn_pwr = 134660, .lkg_pwr = {
			47314, 47314, 47314, 47314, 47314, 47314} },
		{.cap = 805, .volt = 91900, .dyn_pwr = 157113, .lkg_pwr = {
			50595, 50595, 50595, 50595, 50595, 50595} },
		{.cap = 832, .volt = 95000, .dyn_pwr = 173613, .lkg_pwr = {
			53417, 53417, 53417, 53417, 53417, 53417} },
		{.cap = 864, .volt = 98100, .dyn_pwr = 192417, .lkg_pwr = {
			56330, 56330, 56330, 56330, 56330, 56330} },
		{.cap = 891, .volt = 101200, .dyn_pwr = 211264, .lkg_pwr = {
			59309, 59309, 59309, 59309, 59309, 59309} },
		{.cap = 928, .volt = 104400, .dyn_pwr = 234447, .lkg_pwr = {
			62551, 62551, 62551, 62551, 62551, 62551} },
		{.cap = 960, .volt = 106900, .dyn_pwr = 254436, .lkg_pwr = {
			65118, 65118, 65118, 65118, 65118, 65118} },
		{.cap = 992, .volt = 109400, .dyn_pwr = 275514, .lkg_pwr = {
			67775, 67775, 67775, 67775, 67775, 67775} },
		{.cap = 1024, .volt = 111900, .dyn_pwr = 297708, .lkg_pwr = {
			70461, 70461, 70461, 70461, 70461, 70461} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
		{{0}, {27567} },
	},
};

struct upower_tbl upower_tbl_cluster_l_3_SB = {
	.row = {
		{.cap = 213, .volt = 60000, .dyn_pwr = 3526, .lkg_pwr = {
			29357, 29357, 29357, 29357, 29357, 29357} },
		{.cap = 315, .volt = 65600, .dyn_pwr = 5973, .lkg_pwr = {
			31499, 31499, 31499, 31499, 31499, 31499} },
		{.cap = 411, .volt = 70600, .dyn_pwr = 9055, .lkg_pwr = {
			34283, 34283, 34283, 34283, 34283, 34283} },
		{.cap = 475, .volt = 73700, .dyn_pwr = 11424, .lkg_pwr = {
			36130, 36130, 36130, 36130, 36130, 36130} },
		{.cap = 539, .volt = 76900, .dyn_pwr = 14135, .lkg_pwr = {
			38102, 38102, 38102, 38102, 38102, 38102} },
		{.cap = 603, .volt = 80000, .dyn_pwr = 17139, .lkg_pwr = {
			40176, 40176, 40176, 40176, 40176, 40176} },
		{.cap = 683, .volt = 84400, .dyn_pwr = 21645, .lkg_pwr = {
			43378, 43378, 43378, 43378, 43378, 43378} },
		{.cap = 752, .volt = 88100, .dyn_pwr = 26014, .lkg_pwr = {
			46258, 46258, 46258, 46258, 46258, 46258} },
		{.cap = 805, .volt = 91900, .dyn_pwr = 30351, .lkg_pwr = {
			49372, 49372, 49372, 49372, 49372, 49372} },
		{.cap = 832, .volt = 95000, .dyn_pwr = 33539, .lkg_pwr = {
			52139, 52139, 52139, 52139, 52139, 52139} },
		{.cap = 864, .volt = 98100, .dyn_pwr = 37172, .lkg_pwr = {
			55128, 55128, 55128, 55128, 55128, 55128} },
		{.cap = 891, .volt = 101200, .dyn_pwr = 40812, .lkg_pwr = {
			58276, 58276, 58276, 58276, 58276, 58276} },
		{.cap = 928, .volt = 104400, .dyn_pwr = 45291, .lkg_pwr = {
			61917, 61917, 61917, 61917, 61917, 61917} },
		{.cap = 960, .volt = 106900, .dyn_pwr = 49152, .lkg_pwr = {
			64862, 64862, 64862, 64862, 64862, 64862} },
		{.cap = 992, .volt = 109400, .dyn_pwr = 53224, .lkg_pwr = {
			68100, 68100, 68100, 68100, 68100, 68100} },
		{.cap = 1024, .volt = 111900, .dyn_pwr = 57512, .lkg_pwr = {
			71421, 71421, 71421, 71421, 71421, 71421} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
		{{0}, {29357} },
	},
};

struct upower_tbl upower_tbl_cci_3_SB = {
	.row = {
		{.cap = 0, .volt = 60000, .dyn_pwr = 1478, .lkg_pwr = {
			5269, 5269, 5269, 5269, 5269, 5269} },
		{.cap = 0, .volt = 65600, .dyn_pwr = 2829, .lkg_pwr = {
			5662, 5662, 5662, 5662, 5662, 5662} },
		{.cap = 0, .volt = 70600, .dyn_pwr = 4337, .lkg_pwr = {
			6172, 6172, 6172, 6172, 6172, 6172} },
		{.cap = 0, .volt = 73700, .dyn_pwr = 5451, .lkg_pwr = {
			6527, 6527, 6527, 6527, 6527, 6527} },
		{.cap = 0, .volt = 76900, .dyn_pwr = 6726, .lkg_pwr = {
			6916, 6916, 6916, 6916, 6916, 6916} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 8137, .lkg_pwr = {
			7341, 7341, 7341, 7341, 7341, 7341} },
		{.cap = 0, .volt = 84400, .dyn_pwr = 10017, .lkg_pwr = {
			8005, 8005, 8005, 8005, 8005, 8005} },
		{.cap = 0, .volt = 88100, .dyn_pwr = 12166, .lkg_pwr = {
			8647, 8647, 8647, 8647, 8647, 8647} },
		{.cap = 0, .volt = 91900, .dyn_pwr = 14153, .lkg_pwr = {
			9396, 9396, 9396, 9396, 9396, 9396} },
		{.cap = 0, .volt = 95000, .dyn_pwr = 16099, .lkg_pwr = {
			10103, 10103, 10103, 10103, 10103, 10103} },
		{.cap = 0, .volt = 98100, .dyn_pwr = 18208, .lkg_pwr = {
			10887, 10887, 10887, 10887, 10887, 10887} },
		{.cap = 0, .volt = 101200, .dyn_pwr = 20485, .lkg_pwr = {
			11726, 11726, 11726, 11726, 11726, 11726} },
		{.cap = 0, .volt = 104400, .dyn_pwr = 22691, .lkg_pwr = {
			12764, 12764, 12764, 12764, 12764, 12764} },
		{.cap = 0, .volt = 106900, .dyn_pwr = 24416, .lkg_pwr = {
			13619, 13619, 13619, 13619, 13619, 13619} },
		{.cap = 0, .volt = 109400, .dyn_pwr = 26225, .lkg_pwr = {
			14601, 14601, 14601, 14601, 14601, 14601} },
		{.cap = 0, .volt = 111900, .dyn_pwr = 28122, .lkg_pwr = {
			15640, 15640, 15640, 15640, 15640, 15640} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
		{{0}, {5269} },
	},
};

struct upower_tbl upower_tbl_l_plus_3_SB = {
	.row = {
		{.cap = 213, .volt = 60000, .dyn_pwr = 20950, .lkg_pwr = {
			41351, 41351, 41351, 41351, 41351, 41351} },
		{.cap = 315, .volt = 65600, .dyn_pwr = 35489, .lkg_pwr = {
			45568, 45568, 45568, 45568, 45568, 45568} },
		{.cap = 411, .volt = 70600, .dyn_pwr = 53799, .lkg_pwr = {
			50656, 50656, 50656, 50656, 50656, 50656} },
		{.cap = 475, .volt = 73700, .dyn_pwr = 67871, .lkg_pwr = {
			53991, 53991, 53991, 53991, 53991, 53991} },
		{.cap = 539, .volt = 76900, .dyn_pwr = 83981, .lkg_pwr = {
			57519, 57519, 57519, 57519, 57519, 57519} },
		{.cap = 603, .volt = 80000, .dyn_pwr = 101823, .lkg_pwr = {
			61089, 61089, 61089, 61089, 61089, 61089} },
		{.cap = 683, .volt = 84400, .dyn_pwr = 128597, .lkg_pwr = {
			66354, 66354, 66354, 66354, 66354, 66354} },
		{.cap = 752, .volt = 88100, .dyn_pwr = 154553, .lkg_pwr = {
			70972, 70972, 70972, 70972, 70972, 70972} },
		{.cap = 805, .volt = 91900, .dyn_pwr = 180323, .lkg_pwr = {
			75893, 75893, 75893, 75893, 75893, 75893} },
		{.cap = 832, .volt = 95000, .dyn_pwr = 199261, .lkg_pwr = {
			80125, 80125, 80125, 80125, 80125, 80125} },
		{.cap = 864, .volt = 98100, .dyn_pwr = 220843, .lkg_pwr = {
			84495, 84495, 84495, 84495, 84495, 84495} },
		{.cap = 891, .volt = 101200, .dyn_pwr = 242474, .lkg_pwr = {
			88963, 88963, 88963, 88963, 88963, 88963} },
		{.cap = 928, .volt = 104400, .dyn_pwr = 269082, .lkg_pwr = {
			93827, 93827, 93827, 93827, 93827, 93827} },
		{.cap = 960, .volt = 106900, .dyn_pwr = 292024, .lkg_pwr = {
			97677, 97677, 97677, 97677, 97677, 97677} },
		{.cap = 992, .volt = 109400, .dyn_pwr = 316215, .lkg_pwr = {
			101663, 101663, 101663, 101663, 101663, 101663} },
		{.cap = 1024, .volt = 111900, .dyn_pwr = 341687, .lkg_pwr = {
			105691, 105691, 105691, 105691, 105691, 105691} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
		{{0}, {41351} },
	},
};
#endif /* UNIFIED_POWER_DATA_MT6763H */
