/*
 * Copyright (C) 2015 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

/* MDP start frame */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RDMA0_SOF, 0, mdp_rdma0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RDMA1_SOF, 1, mdp_rdma1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RSZ0_SOF, 2, mdp_rsz0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RSZ1_SOF, 3, mdp_rsz1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RSZ2_SOF, 4, mdp_rsz2_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_TDSHP_SOF, 5, mdp_tdshp_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_TDSHP0_SOF, 6, mdp_tdshp0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_TDSHP1_SOF, 7, mdp_tdshp1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WDMA_SOF, 8, mdp_wdma_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT_SOF, 9, mdp_wrot_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT0_SOF, 10, mdp_wrot0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT1_SOF, 11, mdp_wrot1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_COLOR_SOF, 12, mdp_color_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_MVW_SOF, 13, mdp_mvw_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_CROP_SOF, 14, mdp_crop_sof)

/* Display start frame */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_OVL0_SOF, 15, disp_ovl0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_OVL1_SOF, 16, disp_ovl1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_2L_OVL0_SOF, 17, disp_2l_ovl0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_2L_OVL1_SOF, 18, disp_2l_ovl1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_RDMA0_SOF, 19, disp_rdma0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_RDMA1_SOF, 20, disp_rdma1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_RDMA2_SOF, 21, disp_rdma2_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_WDMA0_SOF, 22, disp_wdma0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_WDMA1_SOF, 23, disp_wdma1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_COLOR_SOF, 24, disp_color_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_COLOR0_SOF, 25, disp_color0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_COLOR1_SOF, 26, disp_color1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_CCORR_SOF, 27, disp_ccorr_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_CCORR0_SOF, 28, disp_ccorr0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_CCORR1_SOF, 29, disp_ccorr1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_AAL_SOF, 30, disp_aal_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_AAL0_SOF, 31, disp_aal0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_AAL1_SOF, 32, disp_aal1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_GAMMA_SOF, 33, disp_gamma_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_GAMMA0_SOF, 34, disp_gamma0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_GAMMA1_SOF, 35, disp_gamma1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DITHER_SOF, 36, disp_dither_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DITHER0_SOF, 37, disp_dither0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DITHER1_SOF, 38, disp_dither1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_UFOE_SOF, 39, disp_ufoe_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_PWM0_SOF, 40, disp_pwm0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_PWM1_SOF, 41, disp_pwm1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_OD_SOF, 42, disp_od_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DSC_SOF, 43, disp_dsc_sof)

DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA0_L0_SOF, 44, ufod_rdma0_l0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA0_L1_SOF, 45, ufod_rdma0_l1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA0_L2_SOF, 46, ufod_rdma0_l2_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA0_L3_SOF, 47, ufod_rdma0_l3_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA1_L0_SOF, 48, ufod_rdma1_l0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA1_L1_SOF, 49, ufod_rdma1_l1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA1_L2_SOF, 50, ufod_rdma1_l2_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA1_L3_SOF, 51, ufod_rdma1_l3_sof)

/* MDP frame done */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RDMA0_EOF, 52, mdp_rdma0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RDMA1_EOF, 53, mdp_rdma1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RSZ0_EOF, 54, mdp_rsz0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RSZ1_EOF, 55, mdp_rsz1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RSZ2_EOF, 56, mdp_rsz2_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_TDSHP_EOF, 57, mdp_tdshp_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_TDSHP0_EOF, 58, mdp_tdshp0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_TDSHP1_EOF, 59, mdp_tdshp1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WDMA_EOF, 60, mdp_wdma_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT_WRITE_EOF, 61, mdp_wrot_write_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT_READ_EOF, 62, mdp_wrot_read_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT0_WRITE_EOF, 63,
		   mdp_wrot0_write_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT0_READ_EOF, 64, mdp_wrot0_read_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT1_WRITE_EOF, 65,
		   mdp_wrot1_write_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT1_READ_EOF, 66, mdp_wrot1_read_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT0_W_EOF, 67, mdp_wrot0_write_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT0_R_EOF, 68, mdp_wrot0_read_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT1_W_EOF, 69, mdp_wrot1_write_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT1_R_EOF, 70, mdp_wrot1_read_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_COLOR_EOF, 71, mdp_color_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_CROP_EOF, 72, mdp_crop_frame_done)

/* Display frame done */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_OVL0_EOF, 73, disp_ovl0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_OVL1_EOF, 74, disp_ovl1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_2L_OVL0_EOF, 75, disp_2l_ovl0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_2L_OVL1_EOF, 76, disp_2l_ovl1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_RDMA0_EOF, 77, disp_rdma0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_RDMA1_EOF, 78, disp_rdma1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_RDMA2_EOF, 79, disp_rdma2_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_WDMA0_EOF, 80, disp_wdma0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_WDMA1_EOF, 81, disp_wdma1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_COLOR_EOF, 82, disp_color_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_COLOR0_EOF, 83, disp_color0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_COLOR1_EOF, 84, disp_color1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_CCORR_EOF, 85, disp_ccorr_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_CCORR0_EOF, 86, disp_ccorr0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_CCORR1_EOF, 87, disp_ccorr1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_AAL_EOF, 88, disp_aal_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_AAL0_EOF, 89, disp_aal0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_AAL1_EOF, 90, disp_aal1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_GAMMA_EOF, 91, disp_gamma_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_GAMMA0_EOF, 92, disp_gamma0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_GAMMA1_EOF, 93, disp_gamma1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DITHER_EOF, 94, disp_dither_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DITHER0_EOF, 95, disp_dither0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DITHER1_EOF, 96, disp_dither1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_UFOE_EOF, 97, disp_ufoe_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_OD_EOF, 98, disp_od_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_OD_RDMA_EOF, 99, disp_od_rdma_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_OD_WDMA_EOF, 100, disp_od_wdma_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DSC_EOF, 101, disp_dsc_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DSI0_EOF, 102, disp_dsi0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DSI1_EOF, 103, disp_dsi1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DPI0_EOF, 104, disp_dpi0_frame_done)

DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA0_L0_EOF, 105, ufod_rdma0_l0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA0_L1_EOF, 106, ufod_rdma0_l1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA0_L2_EOF, 107, ufod_rdma0_l2_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA0_L3_EOF, 108, ufod_rdma0_l3_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA1_L0_EOF, 109, ufod_rdma1_l0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA1_L1_EOF, 110, ufod_rdma1_l1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA1_L2_EOF, 111, ufod_rdma1_l2_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_UFOD_RAMA1_L3_EOF, 112, ufod_rdma1_l3_frame_done)

/* Mutex frame done */
/* DISPSYS */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX0_STREAM_EOF, 113, stream_done_0)
/* DISPSYS */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX1_STREAM_EOF, 114, stream_done_1)
/* DISPSYS */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX2_STREAM_EOF, 115, stream_done_2)
/* DISPSYS */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX3_STREAM_EOF, 116, stream_done_3)
/* DISPSYS, please refer to disp_hal.h */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX4_STREAM_EOF, 117, stream_done_4)
/* DpFramework */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX5_STREAM_EOF, 118, stream_done_5)
/* DpFramework */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX6_STREAM_EOF, 119, stream_done_6)
/* DpFramework */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX7_STREAM_EOF, 120, stream_done_7)
/* DpFramework */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX8_STREAM_EOF, 121, stream_done_8)
/* DpFramework via CMDQ_IOCTL_LOCK_MUTEX */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX9_STREAM_EOF, 122, stream_done_9)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX10_STREAM_EOF, 123, stream_done_10)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX11_STREAM_EOF, 124, stream_done_11)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX12_STREAM_EOF, 125, stream_done_12)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX13_STREAM_EOF, 126, stream_done_13)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX14_STREAM_EOF, 127, stream_done_14)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MUTEX15_STREAM_EOF, 128, stream_done_15)

/* Display underrun */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_RDMA0_UNDERRUN, 129, buf_underrun_event_0)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_RDMA1_UNDERRUN, 130, buf_underrun_event_1)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_RDMA2_UNDERRUN, 131, buf_underrun_event_2)

/* Display TE */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI_TE, 132, dsi0_te_event)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI0_TE, 133, dsi0_te_event)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI1_TE, 134, dsi1_te_event)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_DSI0_TE_SOF, 135, mdp_dsi0_te_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_DSI1_TE_SOF, 136, mdp_dsi1_te_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DSI0_SOF, 137, disp_dsi0_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DSI1_SOF, 138, disp_dsi1_sof)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK0, 139, dsi0_to_gce_mmck0)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK1, 140, dsi0_to_gce_mmck1)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK2, 141, dsi0_to_gce_mmck2)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK3, 142, dsi0_to_gce_mmck3)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI0_TO_GCE_MMCK4, 143, dsi0_to_gce_mmck4)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK0, 144, dsi1_to_gce_mmck0)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK1, 145, dsi1_to_gce_mmck1)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK2, 146, dsi1_to_gce_mmck2)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK3, 147, dsi1_to_gce_mmck3)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DSI1_TO_GCE_MMCK4, 148, dsi1_to_gce_mmck4)

/* Reset Event */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_WDMA0_RST_DONE, 149, disp_wdma0_rst_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_WDMA1_RST_DONE, 150, disp_wdma1_rst_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT0_RST_DONE, 151, mdp_wrot0_rst_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WROT1_RST_DONE, 152, mdp_wrot1_rst_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_WDMA_RST_DONE, 153, mdp_wdma_rst_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RDMA0_RST_DONE, 154, mdp_rdma0_rst_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_MDP_RDMA1_RST_DONE, 155, mdp_rdma1_rst_done)

/* Display Mutex */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD0, 156,
		   disp_mutex_all_module_upd0)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD1, 157,
		   disp_mutex_all_module_upd1)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD2, 158,
		   disp_mutex_all_module_upd2)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD3, 159,
		   disp_mutex_all_module_upd3)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD4, 160,
		   disp_mutex_all_module_upd4)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD5, 161,
		   disp_mutex_all_module_upd5)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD6, 162,
		   disp_mutex_all_module_upd6)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD7, 163,
		   disp_mutex_all_module_upd7)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD8, 164,
		   disp_mutex_all_module_upd8)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD9, 165,
		   disp_mutex_all_module_upd9)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD10, 166,
		   disp_mutex_all_module_upd10)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD11, 167,
		   disp_mutex_all_module_upd11)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD12, 168,
		   disp_mutex_all_module_upd12)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD13, 169,
		   disp_mutex_all_module_upd13)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD14, 170,
		   disp_mutex_all_module_upd14)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_ALL_MODULE_UPD15, 171,
		   disp_mutex_all_module_upd15)

DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE0, 172,
		   disp_mutex_reg_upd_for_module0)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE1, 173,
		   disp_mutex_reg_upd_for_module1)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE2, 174,
		   disp_mutex_reg_upd_for_module2)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE3, 175,
		   disp_mutex_reg_upd_for_module3)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE4, 176,
		   disp_mutex_reg_upd_for_module4)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE5, 177,
		   disp_mutex_reg_upd_for_module5)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE6, 178,
		   disp_mutex_reg_upd_for_module6)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE7, 179,
		   disp_mutex_reg_upd_for_module7)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE8, 180,
		   disp_mutex_reg_upd_for_module8)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE9, 181,
		   disp_mutex_reg_upd_for_module9)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE10, 182,
		   disp_mutex_reg_upd_for_module10)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE11, 183,
		   disp_mutex_reg_upd_for_module11)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE12, 184,
		   disp_mutex_reg_upd_for_module12)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE13, 185,
		   disp_mutex_reg_upd_for_module13)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE14, 186,
		   disp_mutex_reg_upd_for_module14)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE15, 187,
		   disp_mutex_reg_upd_for_module15)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE16, 188,
		   disp_mutex_reg_upd_for_module16)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE17, 189,
		   disp_mutex_reg_upd_for_module17)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE18, 190,
		   disp_mutex_reg_upd_for_module18)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE19, 191,
		   disp_mutex_reg_upd_for_module19)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE20, 192,
		   disp_mutex_reg_upd_for_module20)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE21, 193,
		   disp_mutex_reg_upd_for_module21)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE22, 194,
		   disp_mutex_reg_upd_for_module22)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE23, 195,
		   disp_mutex_reg_upd_for_module23)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE24, 196,
		   disp_mutex_reg_upd_for_module24)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE25, 197,
		   disp_mutex_reg_upd_for_module25)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE26, 198,
		   disp_mutex_reg_upd_for_module26)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE27, 199,
		   disp_mutex_reg_upd_for_module27)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE28, 200,
		   disp_mutex_reg_upd_for_module28)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE29, 201,
		   disp_mutex_reg_upd_for_module29)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE30, 202,
		   disp_mutex_reg_upd_for_module30)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE31, 203,
		   disp_mutex_reg_upd_for_module31)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE32, 204,
		   disp_mutex_reg_upd_for_module32)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE33, 205,
		   disp_mutex_reg_upd_for_module33)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_MUTEX_REG_UPD_FOR_MODULE34, 206,
		   disp_mutex_reg_upd_for_module34)

/* ISP frame done */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_PASS2_2_EOF, 207, isp_frame_done_p2_2)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_PASS2_1_EOF, 208, isp_frame_done_p2_1)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_PASS2_0_EOF, 209, isp_frame_done_p2_0)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_PASS1_1_EOF, 210, isp_frame_done_p1_1)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_PASS1_0_EOF, 211, isp_frame_done_p1_0)

/* ISP (IMGSYS) frame done */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD0_EOF, 212,
		   dip_cq_thread0_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD1_EOF, 213,
		   dip_cq_thread1_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD2_EOF, 214,
		   dip_cq_thread2_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD3_EOF, 215,
		   dip_cq_thread3_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD4_EOF, 216,
		   dip_cq_thread4_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD5_EOF, 217,
		   dip_cq_thread5_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD6_EOF, 218,
		   dip_cq_thread6_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD7_EOF, 219,
		   dip_cq_thread7_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD8_EOF, 220,
		   dip_cq_thread8_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD9_EOF, 221,
		   dip_cq_thread9_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD10_EOF, 222,
		   dip_cq_thread10_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD11_EOF, 223,
		   dip_cq_thread11_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD12_EOF, 224,
		   dip_cq_thread12_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD13_EOF, 225,
		   dip_cq_thread13_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DIP_CQ_THREAD14_EOF, 226,
		   dip_cq_thread14_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DPE_EOF, 227, dpe_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DVE_EOF, 228, dve_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_WMF_EOF, 229, wmf_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_GEPF_EOF, 230, gepf_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_GEPF_TEMP_EOF, 231, gepf_temp_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_GEPF_BYPASS_EOF, 232, gepf_bypass_frame_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_RSC_EOF, 233, rsc_frame_done)

/* ISP (IMGSYS) engine events */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_SENINF_CAM1_2_3_FULL, 234,
		   seninf_cam1_2_3_fifo_full)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_SENINF_CAM0_FULL, 235, seninf_cam0_fifo_full)

/* VENC frame done */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_VENC_EOF, 236, venc_done)

/* JPEG frame done */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_JPEG_ENC_EOF, 237, jpgenc_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_JPEG_ENC_PASS2_EOF, 238, jpgenc_pass2_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_JPEG_ENC_PASS1_EOF, 239, jpgenc_pass1_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_JPEG_DEC_EOF, 240, jpgdec_done)

/* VENC engine events */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_VENC_MB_DONE, 241, venc_mb_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_VENC_128BYTE_CNT_DONE, 242, venc_128byte_cnt_done)

/* ISP (CAMSYS) frame done */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_FRAME_DONE_A, 243, isp_frame_done_a)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_FRAME_DONE_B, 244, isp_frame_done_b)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_CAMSV_0_PASS1_DONE, 245, camsv_0_pass1_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_CAMSV_1_PASS1_DONE, 246, camsv_1_pass1_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_CAMSV_2_PASS1_DONE, 247, camsv_2_pass1_done)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_ISP_TSF_DONE, 248, tsf_done)

/* ISP (CAMSYS) engine events */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_SENINF_0_FIFO_FULL, 249, seninf_0_fifo_full)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_SENINF_1_FIFO_FULL, 250, seninf_1_fifo_full)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_SENINF_2_FIFO_FULL, 251, seninf_2_fifo_full)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_SENINF_3_FIFO_FULL, 252, seninf_3_fifo_full)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_SENINF_4_FIFO_FULL, 253, seninf_4_fifo_full)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_SENINF_5_FIFO_FULL, 254, seninf_5_fifo_full)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_SENINF_6_FIFO_FULL, 255, seninf_6_fifo_full)
DECLARE_CMDQ_EVENT(CMDQ_EVENT_SENINF_7_FIFO_FULL, 256, seninf_7_fifo_full)

/* DPI1 frame done */
DECLARE_CMDQ_EVENT(CMDQ_EVENT_DISP_DPI1_EOF, 257, disp_dpi1_frame_done)

/* Keep this at the end of HW events */
DECLARE_CMDQ_EVENT(CMDQ_MAX_HW_EVENT_COUNT, 400, hw_event_conunt)

/* SW Sync Tokens (Pre-defined) */
/* Config thread notify trigger thread */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_CONFIG_DIRTY, 401, sw_token)
/* Trigger thread notify config thread */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_STREAM_EOF, 402, sw_token)
/* Block Trigger thread until the ESD check finishes. */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_ESD_EOF, 403, sw_token)
/* check CABC setup finish */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_CABC_EOF, 404, sw_token)
/* Block Trigger thread until the path freeze finishes */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_FREEZE_EOF, 405, sw_token)
/* Pass-2 notifies VENC frame is ready to be encoded */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_VENC_INPUT_READY, 406, sw_token)
/* VENC notifies Pass-2 encode done so next frame may start */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_VENC_EOF, 407, sw_token)

/* Notify normal CMDQ there are some secure task done */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_SECURE_THR_EOF, 408, sw_token)
/* Lock WSM resource */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_SECURE_WSM_LOCK, 409, sw_token)

/* SW Sync Tokens (User-defined) */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_USER_0, 410, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_USER_1, 411, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_POLL_MONITOR, 412, sw_token)

/* Secure video path notify SW token */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_DISP_OVL0_2NONSEC_END, 420, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_DISP_OVL1_2NONSEC_END, 421, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_DISP_2LOVL0_2NONSEC_END, 422, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_DISP_2LOVL1_2NONSEC_END, 423, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_DISP_RDMA0_2NONSEC_END, 424, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_DISP_RDMA1_2NONSEC_END, 425, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_DISP_WDMA0_2NONSEC_END, 426, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_DISP_WDMA1_2NONSEC_END, 427, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_DISP_EXT_STREAM_EOF, 428, sw_token)

/* Event for CMDQ to block executing command when append command
 * Plz sync CMDQ_SYNC_TOKEN_APPEND_THR(id) in cmdq_core source file.
 */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR0, 432, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR1, 433, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR2, 434, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR3, 435, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR4, 436, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR5, 437, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR6, 438, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR7, 439, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR8, 440, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR9, 441, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR10, 442, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR11, 443, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR12, 444, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR13, 445, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR14, 446, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_APPEND_THR15, 447, sw_token)

/* GPR access tokens (for HW register backup) */
/* There are 15 32-bit GPR, 3 GPR form a set (64-bit for address, 32-bit for
 * value)
 */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_0, 450, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_1, 451, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_2, 452, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_3, 453, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_GPR_SET_4, 454, sw_token)

/* Resource lock event to control resource in GCE thread */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_RESOURCE_WROT0, 460, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_RESOURCE_WROT1, 461, sw_token)

/* Event for CMDQ delay implement
 * Plz sync CMDQ_SYNC_TOKEN_DELAY_THR(id) in cmdq_core source file.
 */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR0, 470, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR1, 471, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR2, 472, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR3, 473, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR4, 474, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR5, 475, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR6, 476, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR7, 477, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR8, 478, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR9, 479, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR10, 480, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR11, 481, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR12, 482, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR13, 483, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR14, 484, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR15, 485, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR16, 486, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR17, 487, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR18, 488, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR19, 489, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR20, 490, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR21, 491, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR22, 492, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR23, 493, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR24, 494, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR25, 495, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR26, 496, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR27, 497, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR28, 498, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR29, 499, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR30, 500, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_DELAY_THR31, 501, sw_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_TIMER, 502, sw_token)

/* event id is 9 bit */
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_MAX, (0x1FF), max_token)
DECLARE_CMDQ_EVENT(CMDQ_SYNC_TOKEN_INVALID, (-1), invalid_token)
