/*
 * Copyright (C) 2015 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _CMDQ_SUBSYS_COMMON_H_
#define _CMDQ_SUBSYS_COMMON_H_

/* Define CMDQ subsys
 *
 * CMDQ subsys base address define in DTS.
 * Mapping dts name and subsys define must sync with
 * subsys table define in cmdq_subsys_common.c.
 */
enum CMDQ_SUBSYS_ENUM {
	CMDQ_SUBSYS_G3D_CONFIG_BASE,
	CMDQ_SUBSYS_MMSYS_CONFIG,
	CMDQ_SUBSYS_DISP_DITHER,
	CMDQ_SUBSYS_NA,
	CMDQ_SUBSYS_IMGSYS,
	CMDQ_SUBSYS_VDEC_GCON,
	CMDQ_SUBSYS_VENC_GCON,
	CMDQ_SUBSYS_CONN_PERIPHERALS,

	CMDQ_SUBSYS_TOPCKGEN,
	CMDQ_SUBSYS_KP,
	CMDQ_SUBSYS_SCP_SRAM,
	CMDQ_SUBSYS_INFRA_NA3,
	CMDQ_SUBSYS_INFRA_NA4,
	CMDQ_SUBSYS_SCP,

	CMDQ_SUBSYS_MCUCFG,
	CMDQ_SUBSYS_GCPU,
	CMDQ_SUBSYS_USB0,
	CMDQ_SUBSYS_USB_SIF,
	CMDQ_SUBSYS_AUDIO,
	CMDQ_SUBSYS_MSDC0,
	CMDQ_SUBSYS_MSDC1,
	CMDQ_SUBSYS_MSDC2,
	CMDQ_SUBSYS_MSDC3,
	CMDQ_SUBSYS_AP_DMA,
	CMDQ_SUBSYS_GCE,

	CMDQ_SUBSYS_VDEC,
	CMDQ_SUBSYS_VDEC1,
	CMDQ_SUBSYS_VDEC2,
	CMDQ_SUBSYS_VDEC3,
	CMDQ_SUBSYS_CAMSYS,
	CMDQ_SUBSYS_CAMSYS1,
	CMDQ_SUBSYS_CAMSYS2,
	CMDQ_SUBSYS_CAMSYS3,
	CMDQ_SUBSYS_IMGSYS1,

	CMDQ_SUBSYS_SMI_LAB1,

	/* Special subsys */
	CMDQ_SUBSYS_PWM_SW,
	CMDQ_SUBSYS_PWM1_SW,
	CMDQ_SUBSYS_DIP_A0_SW,
	CMDQ_SUBSYS_MIPITX0,
	CMDQ_SUBSYS_MIPITX1,
	CMDQ_SUBSYS_VENC,
	CMDQ_SUBSYS_IMGSYS2,
	CMDQ_SUBSYS_IPESYS,
	CMDQ_SUBSYS_DPE,

	/* ALWAYS keep at the end */
	CMDQ_SUBSYS_MAX_COUNT
};

#endif
