/*
 * Copyright (C) 2015 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef __MPU_PLATFORM_H__
#define __MPU_PLATFORM_H__

enum {
	/* M0: APMCU 1 */
	M0_AXI_MST_MCUSYS_MP0, M0_AXI_MST_MCUSYS_MP1,

	/* M1: APMCU 2 */
	M1_AXI_MST_MCUSYS_MP0, M1_AXI_MST_MCUSYS_MP1,

	/* M2: MM 1 */
	M2_AXI_MST_MMSYS_SMI_LARB0,
	M2_AXI_MST_IMGSYS_SMI_LARB1,
	M2_AXI_MST_CAMSYS_SMI_LARB2,
	M2_AXI_MST_VDEC_SMI_LARB3,

	/* M3: MDMCU */
	M3_MD_MM, M3_MD_MMU, M3_USIP,

	/* M4: MDDMA */
	M4_MCUSYS_DFD, M4_HRQ_RD, M4_HRQ_RD1_WR,
	M4_VTB, M4_TBO, M4_DFE_DUMP,
	M4_BR_DMA, M4_MD2G, M4_TXBRP0, M4_TXBRP1,
	M4_TPC, M4_RXDFE_DMA,
	M4_MRSG0, M4_MRSG1, M4_CNWDMA,
	M4_CSH_DCXO, M4_MML2, M4_LOG_TOP,
	M4_TRACE_TOP, M4_PPPHA, M4_IPSEC,
	M4_DBGSYS, M4_GDMA,

	/* M5: MM 2 */
	M5_AXI_MST_MMSYS_SMI_LARB0,
	M5_AXI_MST_IMGSYS_SMI_LARB1,
	M5_AXI_MST_CAMSYS_SMI_LARB2,
	M5_AXI_MST_VDEC_SMI_LARB3,

	/* M6: MFG */
	M6_AXI_MST_MFG_MALI,

	/* M7: PERI */
	M7_AHB_MST_AUDIO, M7_AHB_MST_CONN_N9,
	M7_AHB_MST_MSDC1, M7_AHB_MST_MSDC2,
	M7_AHB_MST_PWM, M7_AHB_MST_SSPM,
	M7_AHB_MST_SPI0, M7_AHB_MST_SPI1, M7_AHB_MST_SPI2,
	M7_AHB_MST_SPI3, M7_AHB_MST_SPI4, M7_AHB_MST_SPI5,
	M7_AHB_MST_SPM, M7_AHB_MST_THERM,
	M7_AHB_MST_USB20_TOP_DMA,
	M7_AXI_MST_APDMA_E, M7_AXI_MST_CLDMA_CABGEN,
	M7_AXI_MST_CQ_DMA, M7_AXI_MST_DBG,
	M7_AXI_MST_DXCC, M7_AXI_MST_GCE,
	M7_AXI_MST_MFG_MALI, M7_AXI_MST_MSDC0, M7_AXI_MST_UFSHCI_TOP_UFS,

	MST_INVALID,
	NR_MST,
};

static const struct mst_tbl_entry mst_tbl[] = {
	/* APMCU 1 */
	{.master = M0_AXI_MST_MCUSYS_MP0, .port = 0x0, .id_mask = 0x0001,
		.id_val = 0x0000,
		.note = "MT63_M0_MCUSYS_MP0",
		.name = "MT63_M0_MCUSYS_MP0"},
	{.master = M0_AXI_MST_MCUSYS_MP1, .port = 0x0, .id_mask = 0x0001,
		.id_val = 0x0001,
		.note = "MT63_M0_MCUSYS_MP1",
		.name = "MT63_M0_MCUSYS_MP1"},

	/* APMCU 2 */
	{.master = M1_AXI_MST_MCUSYS_MP0, .port = 0x1, .id_mask = 0x0001,
		.id_val = 0x0000,
		.note = "MT63_M1_MCUSYS_MP0",
		.name = "MT63_M1_MCUSYS_MP0"},
	{.master = M1_AXI_MST_MCUSYS_MP1, .port = 0x1, .id_mask = 0x0001,
		.id_val = 0x0001,
		.note = "MT63_M1_MCUSYS_MP1",
		.name = "MT63_M1_MCUSYS_MP1"},

	/* MM 1 */
	{.master = M2_AXI_MST_MMSYS_SMI_LARB0, .port = 0x2, .id_mask = 0x0380,
		.id_val = 0x0000,
		.note = "MT63_M2_LARB0",
		.name = "MT63_M2_LARB0"},
	{.master = M2_AXI_MST_IMGSYS_SMI_LARB1, .port = 0x2, .id_mask = 0x0380,
		.id_val = 0x0080,
		.note = "MT63_M2_LARB1",
		.name = "MT63_M2_LARB1"},
	{.master = M2_AXI_MST_CAMSYS_SMI_LARB2, .port = 0x2, .id_mask = 0x0380,
		.id_val = 0x0100,
		.note = "MT63_M2_LARB2",
		.name = "MT63_M2_LARB2"},
	{.master = M2_AXI_MST_VDEC_SMI_LARB3, .port = 0x2, .id_mask = 0x0380,
		.id_val = 0x0180,
		.note = "MT63_M2_LARB3",
		.name = "MT63_M2_LARB3"},

	/* MDMCU */
	{.master = M3_MD_MM, .port = 0x3, .id_mask = 0x0003,
		.id_val = 0x0000,
		.note = "MT63_M3_MD_MM",
		.name = "MT63_M3_MD_MM"},
	{.master = M3_MD_MMU, .port = 0x3, .id_mask = 0x0003,
		.id_val = 0x0001,
		.note = "MT63_M3_MD_MMU",
		.name = "Mt63_M3_MD_MMU"},
	{.master = M3_USIP, .port = 0x3, .id_mask = 0x0003,
		.id_val = 0x0002,
		.note = "MT63_M3_USIP",
		.name = "MT63_M3_USIP"},

	/* MDDMA */
	{.master = M4_MCUSYS_DFD, .port = 0x4, .id_mask = 0x0001,
		.id_val = 0x0001,
		.note = "MT63_M4_MCUSYS_DFD",
		.name = "MT63_M4_MCUSUS_DFD"},
	{.master = M4_HRQ_RD, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x0000,
		.note = "MT63_M4_HRQ_RD",
		.name = "MT63_M4_HRQ_RD"},
	{.master = M4_HRQ_RD1_WR, .port = 0x4, .id_mask = 0x1FF5,
		.id_val = 0x1000,
		.note = "MT63_M4_HRQ_RD1_WR",
		.name = "MT63_M4_HRQ_RD1_WR"},
	{.master = M4_VTB, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x100C,
		.note = "MT63_M4_VTB",
		.name = "MT63_M4_VTB"},
	{.master = M4_TBO, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x1014,
		.note = "MT63_M4_TBO",
		.name = "MT63_M4_TBO"},
	{.master = M4_DFE_DUMP, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x0808,
		.note = "MT63_M4_DFE_DUMP",
		.name = "MT63_M4_DFE_DUMP"},
	{.master = M4_BR_DMA, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x080A,
		.note = "MT63_M4_BR_DMA",
		.name = "MT63_M4_BR_DMA"},
	{.master = M4_MD2G, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x0010,
		.note = "MT63_M4_MD2G",
		.name = "MT63_M4_MD2G"},
	{.master = M4_TXBRP0, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x0050,
		.note = "MT63_M4_TXBRP0",
		.name = "MT63_M4_TXBRP0"},
	{.master = M4_TXBRP1, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x0150,
		.note = "MT63_M4_TXBRP1",
		.name = "MT63_M4_TXBRP1"},
	{.master = M4_TPC, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x01D0,
		.note = "MT63_M4_TPC",
		.name = "MT63_M4_TPC"},
	{.master = M4_RXDFE_DMA, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x0070,
		.note = "MT63_M4_RXDFE_DMA",
		.name = "MT63_M4_RXDFE_DMA"},
	{.master = M4_MRSG0, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x00F0,
		.note = "MT63_M4_MRSG0",
		.name = "MT63_M4_MRSG0"},
	{.master = M4_MRSG1, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x0170,
		.note = "MT63_M4_MRSG1",
		.name = "MT63_M4_MRSG1"},
	{.master = M4_CNWDMA, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x0130,
		.note = "MT63_M4_CNWDMA",
		.name = "MT63_M4_CNWDMA"},
	{.master = M4_CSH_DCXO, .port = 0x4, .id_mask = 0x1F7F,
		.id_val = 0x0030,
		.note = "MT63_M4_CSH_DCXO",
		.name = "MT63_M4_CSH_DCXO"},
	{.master = M4_MML2, .port = 0x4, .id_mask = 0x1800,
		.id_val = 0x1800,
		.note = "MT63_M4_MML2",
		.name = "MT63_M4_MML2"},
	{.master = M4_LOG_TOP, .port = 0x4, .id_mask = 0x1FDD,
		.id_val = 0x0004,
		.note = "MT63_M4_LOG_TOP",
		.name = "MT63_M4_LOG_TOP"},
	{.master = M4_TRACE_TOP, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x0008,
		.note = "MT63_M4_TRACE_TOP",
		.name = "MT63_M4_TRACE_TOP"},
	{.master = M4_PPPHA, .port = 0x4, .id_mask = 0x1FBF,
		.id_val = 0x0002,
		.note = "MT63_M4_PPPHA",
		.name = "MT63_M4_PPPHA"},
	{.master = M4_IPSEC, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x000A,
		.note = "MT63_M4_IPSEC",
		.name = "MT63_M4_IPSEC"},
	{.master = M4_DBGSYS, .port = 0x4, .id_mask = 0x1FFF,
		.id_val = 0x000E,
		.note = "MT63_M4_DBGSYS",
		.name = "MT63_M4_DBGSYS"},
	{.master = M4_GDMA, .port = 0x4, .id_mask = 0x1E3F,
		.id_val = 0x000E,
		.note = "MT63_M4_GDMA",
		.name = "MT63_M4_GDMA"},

	/* MM 2 */
	{.master = M5_AXI_MST_MMSYS_SMI_LARB0, .port = 0x5, .id_mask = 0x0380,
		.id_val = 0x0000,
		.note = "MT63_M5_LARB0",
		.name = "MT63_M5_LARB0"},
	{.master = M5_AXI_MST_IMGSYS_SMI_LARB1, .port = 0x5, .id_mask = 0x0380,
		.id_val = 0x0080,
		.note = "MT63_M5_LARB1",
		.name = "MT63_M5_LARB1"},
	{.master = M5_AXI_MST_CAMSYS_SMI_LARB2, .port = 0x5, .id_mask = 0x0380,
		.id_val = 0x0100,
		.note = "MT63_M5_LARB2",
		.name = "MT63_M5_LARB2"},
	{.master = M5_AXI_MST_VDEC_SMI_LARB3, .port = 0x5, .id_mask = 0x0380,
		.id_val = 0x0180,
		.note = "MT63_M5_LARB3",
		.name = "MT63_M5_LARB3"},

	/* MFG */
	{.master = M6_AXI_MST_MFG_MALI, .port = 0x6, .id_mask = 0x0000,
		.id_val = 0x0000,
		.note = "MT63_M6_AXI_MST_MFG_MALI",
		.name = "MT63_M6_AXI_MST_MFG_MALI"},

	/* PERI */
	{.master = M7_AHB_MST_AUDIO, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x0106,
		.note = "MT63_M7_AHB_MST_AUDIO",
		.name = "MT63_M7_AHB_MST_AUDIO"},
	{.master = M7_AHB_MST_CONN_N9, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x000a,
		.note = "MT63_M7_AHB_MST_CONN_N9",
		.name = "MT63_M7_AHB_MST_CONN_N9"},
	{.master = M7_AHB_MST_MSDC1, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x0070,
		.note = "MT63_M7_AHB_MST_MSDC1",
		.name = "MT63_M7_AHB_MST_MSDC1"},
	{.master = M7_AHB_MST_MSDC2, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x00B0,
		.note = "MT63_M7_AHB_MST_MSDC2",
		.name = "MT63_M7_AHB_MST_MSDC2"},
	{.master = M7_AHB_MST_PWM, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x0030,
		.note = "MT63_M7_AHB_MST_PWM",
		.name = "MT63_M7_AHB_MST_PWM"},
	{.master = M7_AHB_MST_SSPM, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x0126,
		.note = "MT63_M7_AHB_MST_SSPM",
		.name = "MT63_M7_AHB_MST_SSPM"},
	{.master = M7_AHB_MST_SPI0, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x00F0,
		.note = "MT63_M7_AHB_MST_SPI0",
		.name = "MT63_M7_AHB_MST_SPI0"},
	{.master = M7_AHB_MST_SPI1, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x0306,
		.note = "MT63_M7_AHB_MST_SPI1",
		.name = "MT63_M7_AHB_MST_SPI1"},
	{.master = M7_AHB_MST_SPI2, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x00A6,
		.note = "MT63_M7_AHB_MST_SPI2",
		.name = "MT63_M7_AHB_MST_SPI2"},
	{.master = M7_AHB_MST_SPI3, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x01A6,
		.note = "MT63_M7_AHB_MST_SPI3",
		.name = "MT63_M7_AHB_MST_SPI3"},
	{.master = M7_AHB_MST_SPI4, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x02A6,
		.note = "MT63_M7_AHB_MST_SPI4",
		.name = "MT63_M7_AHB_MST_SPI4"},
	{.master = M7_AHB_MST_SPI5, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x03A6,
		.note = "MT63_M7_AHB_MST_SPI5",
		.name = "MT63_M7_AHB_MST_SPI5"},
	{.master = M7_AHB_MST_SPM, .port = 0x7, .id_mask = 0x1EFF,
		.id_val = 0x0126,
		.note = "MT63_M7_AHB_MST_SPM",
		.name = "MT63_M7_AHB_MST_SPM"},
	{.master = M7_AHB_MST_THERM, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x0326,
		.note = "MT63_M7_AHB_MST_THERM",
		.name = "MT63_M7_AHB_MST_THERM"},
	{.master = M7_AHB_MST_USB20_TOP_DMA, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x0006,
		.note = "MT63_M7_AHB_MST_USB20_TOP_DMA",
		.name = "MT63_M7_AHB_MST_USB20_TOP_DMA"},
	{.master = M7_AXI_MST_APDMA_E, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x0066,
		.note = "MT63_M7_AXI_MST_APDMA_E",
		.name = "MT63_M7_AXI_MST_APDMA_E"},
	{.master = M7_AXI_MST_CLDMA_CABGEN, .port = 0x7, .id_mask = 0x1F1F,
		.id_val = 0x0016,
		.note = "MT63_M7_AXI_MST_CLDMA_CABGEN",
		.name = "MT63_M7_AXI_MST_CLDMA_CABGEN"},
	{.master = M7_AXI_MST_CQ_DMA, .port = 0x7, .id_mask = 0x1F1F,
		.id_val = 0x0012,
		.note = "MT63_M7_AXI_MST_CQ_DMA",
		.name = "MT63_M7_AXI_MST_CQ_DMA"},
	{.master = M7_AXI_MST_DBG, .port = 0x7, .id_mask = 0x1FDF,
		.id_val = 0x0002,
		.note = "MT63_M7_AXI_MST_DBG",
		.name = "MT63_M7_AXI_MST_DBG"},
	{.master = M7_AXI_MST_DXCC, .port = 0x7, .id_mask = 0x1E0F,
		.id_val = 0x000E,
		.note = "MT63_M7_AXI_MST_DXCC",
		.name = "MT63_M7_AXI_MST_DXCC"},
	{.master = M7_AXI_MST_GCE, .port = 0x7, .id_mask = 0x1E1F,
		.id_val = 0x001A,
		.note = "MT63_M7_AXI_MST_GCE",
		.name = "MT63_M7_AXI_MST_GCE"},
	{.master = M7_AXI_MST_MFG_MALI, .port = 0x7, .id_mask = 0x1F81,
		.id_val = 0x0001,
		.note = "MT63_M7_AXI_MST_MFG_MALI",
		.name = "MT63_M7_AXI_MST_MFG_MALI"},
	{.master = M7_AXI_MST_MSDC0, .port = 0x7, .id_mask = 0x1FFF,
		.id_val = 0x0010,
		.note = "MT63_M7_AXI_MST_MSDC0",
		.name = "MT63_M7_AXI_MST_MSDC0"},
	{.master = M7_AXI_MST_UFSHCI_TOP_UFS, .port = 0x7, .id_mask = 0x1CFF,
		.id_val = 0x0046,
		.note = "MT63_M7_AXI_MST_UFSHCI_TOP_UFS",
		.name = "MT63_M7_AXI_MST_UFSHCI_TOP_UFS" },
};

#endif /* end of __MPU_PLATFORM_H__ */
