/*
 * Copyright (C) 2015 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

/*****************************************************************************
 *
 * Filename:
 * ---------
 *     s5k2l7_setting_mode3.h
 *
 * Project:
 * --------
 *     ALPS
 *
 * Description:
 * ------------
 *     CMOS sensor setting file
 *
 * Setting Release Date:
 * ------------
 *     2016.09.01
 *
 ****************************************************************************/
#ifndef _s5k2l7MIPI_SETTING_MODE3_H_
#define _s5k2l7MIPI_SETTING_MODE3_H_

#define _S5K2L7_MODE3_SENSOR_INFO_                                             \
static struct imgsensor_info_struct _imgsensor_info_m3 =                       \
{                                                                              \
	/* record sensor id defined in Kd_imgsensor.h */		       \
	.sensor_id = S5K2L7_SENSOR_ID,                                         \
	.checksum_value = 0xb4cb9203,/* checksum value for Camera Auto Test */ \
	.pre = {                                                               \
		.pclk = 960000000, /* record different mode's pclk */          \
		.linelength = 10160, /* record different mode's linelength */  \
		.framelength = 3149, /* record different mode's framelength */ \
		.startx = 0, /* record different mode's startx of grabwindow */\
		.starty = 0, /* record different mode's starty of grabwindow */\
	/* Dual PD: need to tg grab width / 2, p1 drv will * 2 itself */       \
		.grabwindow_width = 2016,				       \
	/* record different mode's height of grabwindow */		       \
		.grabwindow_height = 1512,				       \
		.mipi_pixel_rate = 281000000, /* unit , ns */               \
		.mipi_data_lp2hs_settle_dc = 85, /* unit , ns */               \
		.max_framerate = 300                                           \
	},                                                                     \
	.cap = {                                                               \
		.pclk = 960000000, /* record different mode's pclk */          \
		.linelength = 10160,/* record different mode's linelength */   \
		.framelength = 3149,/* record different mode's framelength */  \
		.startx = 0, /* record different mode's startx of grabwindow */\
		.starty = 0, /* record different mode's starty of grabwindow */\
	/* Dual PD: need to tg grab width / 2, p1 drv will * 2 itself */       \
		.grabwindow_width = 4032,				       \
		/* record different mode's height of grabwindow */	       \
		.grabwindow_height = 3024,                                     \
		.mipi_pixel_rate = 512000000, /* unit , ns */               \
		.mipi_data_lp2hs_settle_dc = 85, /* unit , ns */               \
		.max_framerate = 300                                           \
	},                                                                     \
	.cap1 = {                                                              \
		.pclk = 960000000, /* record different mode's pclk */          \
		.linelength = 10160, /* record different mode's lineength */   \
		.framelength = 3149, /* record different mode's framelength */ \
		.startx = 0, /* record different mode's startx of grabwindow */\
		.starty = 0, /* record different mode's starty of grabwindow */\
	/* Dual PD: need to tg grab width / 2, p1 drv will * 2 itself */       \
		.grabwindow_width = 4032,                                      \
	/* record different mode's height of grabwindow */		       \
		.grabwindow_height = 3024,                                     \
		.mipi_pixel_rate = 512000000, /* unit , ns */               \
		.mipi_data_lp2hs_settle_dc = 85, /* unit , ns */               \
		.max_framerate = 300                                           \
	},                                                                     \
	.normal_video = {                                                      \
		.pclk = 960000000, /* record different mode's pclk */          \
		.linelength = 10160, /* record different mode's linelength */  \
		.framelength = 3149, /* record different mode's framelength */ \
		.startx = 0, /* record different mode's startx of grabwindow */\
		.starty = 0, /* record different mode's starty of grabwindow */\
	/* Dual PD: need to tg grab width / 2, p1 drv will * 2 itself */       \
		.grabwindow_width = 4032,				       \
	/* record different mode's height of grabwindow */                     \
		.grabwindow_height = 3024,				       \
		.mipi_data_lp2hs_settle_dc = 85, /* unit , ns */               \
		.mipi_pixel_rate = 512000000,               \
		.max_framerate = 300                                           \
	},                                                                     \
	.hs_video = {                                                          \
		.pclk = 960000000,                                             \
		.linelength = 7776,                                            \
		.framelength = 1028,                                           \
		.startx = 0,                                                   \
		.starty = 0,                                                   \
		/* record different mode's width of grabwindow */              \
		.grabwindow_width = 1344,                                      \
		/* record different mode's height of grabwindow */             \
		.grabwindow_height = 756,				       \
		.mipi_data_lp2hs_settle_dc = 85, /* unit , ns */               \
		.mipi_pixel_rate = 361000000,               \
		.max_framerate = 1200,                                         \
	},                                                                     \
	.slim_video = {                                                        \
		.pclk = 960000000,                                             \
		.linelength = 7776,                                            \
		.framelength = 4111,                                           \
		.startx = 0,                                                   \
		.starty = 0,                                                   \
	/* record different mode's width of grabwindow */		       \
		.grabwindow_width = 1344,                                      \
	/* record different mode's height of grabwindow */                     \
		.grabwindow_height = 756,				       \
		.mipi_data_lp2hs_settle_dc = 85, /* unit , ns */               \
		.mipi_pixel_rate = 361000000,               \
		.max_framerate = 300,                                          \
	},                                                                     \
	.margin = 16,                                                          \
	.min_shutter = 1,                                                      \
	.max_frame_length = 0xffff,                                            \
	.ae_shut_delay_frame = 0,                                              \
	.ae_sensor_gain_delay_frame = 0,                                       \
	.ae_ispGain_delay_frame = 2,                                           \
	.ihdr_support = 0,	    /* 1, support; 0,not support */            \
	.ihdr_le_firstline = 0, /* 1,le first ; 0, se first */                 \
	.sensor_mode_num = 5,   /* support sensor mode num */                  \
	.cap_delay_frame = 3,                                                  \
	.pre_delay_frame = 3,                                                  \
	.video_delay_frame = 3,                                                \
	.hs_video_delay_frame = 3,                                             \
	.slim_video_delay_frame = 3,                                           \
	.isp_driving_current = ISP_DRIVING_8MA,                                \
	.sensor_interface_type = SENSOR_INTERFACE_TYPE_MIPI,                   \
	/* 0,MIPI_OPHY_NCSI2;  1,MIPI_OPHY_CSI2 */                             \
	.mipi_sensor_type = MIPI_OPHY_NCSI2,				       \
	/* 0,MIPI_SETTLEDELAY_AUTO; 1,MIPI_SETTLEDELAY_MANNUAL */	       \
	.mipi_settle_delay_mode = MIPI_SETTLEDELAY_AUTO,		       \
	.sensor_output_dataformat = SENSOR_OUTPUT_FORMAT_RAW_Gr,               \
	.mclk = 24,                                                            \
	.mipi_lane_num = SENSOR_MIPI_4_LANE,                                   \
	.i2c_addr_table = { 0x20, 0x5A, 0xFF},                                 \
	.i2c_speed = 1000,                                                     \
}

/* full_w; full_h; x0_offset; y0_offset; w0_size; h0_size; scale_w; scale_h;
 * x1_offset;  y1_offset;  w1_size;  h1_size;
 * x2_tg_offset;	 y2_tg_offset;	w2_tg_size;  h2_tg_size;
 */
#define struct_SENSOR_WINSIZE_INFO struct SENSOR_WINSIZE_INFO_STRUCT
#define _S5K2L7_MODE3_WINSIZE_INFO_                                            \
static struct_SENSOR_WINSIZE_INFO _imgsensor_winsize_info_m3[5] =              \
{                                                                              \
	{ 4032, 3024, 0,   0, 4032, 3024, 2016,                                \
	  1512, 0, 0, 2016, 1512, 0, 0, 2016, 1512}, /* Preview */             \
	{ 4032, 3024, 0,   0, 4032, 3024, 4032,                                \
	  3024, 0, 0, 4032, 3024, 0, 0, 4032, 3024}, /* capture */             \
	{ 4032, 3024, 0,   0, 4032, 3024, 4032,                                \
	  3024, 0, 0, 4032, 3024, 0, 0, 4032, 3024}, /* normal_video */        \
	{ 4032, 3024, 0, 378, 4032, 2268, 1344,                                \
	  756, 0, 0, 1344,  756, 0, 0, 1344,  756}, /* hs_video */             \
	{ 4032, 3024, 0, 378, 4032, 2268, 1344,                                \
	  756, 0, 0, 1344,  756, 0, 0, 1344,  756}, /* slim_video */           \
}

#define _SET_MODE3_SENSOR_INFO_AND_WINSIZE_ do {                               \
	memcpy((void *)&imgsensor_info,                                        \
		(void *)&_imgsensor_info_m3,                                   \
		sizeof(struct imgsensor_info_struct));                         \
	memcpy((void *)&imgsensor_winsize_info,                                \
		(void *)&_imgsensor_winsize_info_m3,                           \
		sizeof(struct SENSOR_WINSIZE_INFO_STRUCT)*5);		       \
} while (0)


/*****************************************************************************
 *
 * Description:
 * ------------
 *     mode 3 initial setting
 *
 ****************************************************************************/
kal_uint16 addr_data_pair_init_2l7_m3[] = {
	0X6214, 0X7970,
	0X6218, 0X7150,
	0X6028, 0X2000,
	0X602A, 0X87AC,
	0X6F12, 0X0000,
	0X6F12, 0X0000,
	0X6F12, 0X0449,
	0X6F12, 0X0348,
	0X6F12, 0X044A,
	0X6F12, 0X4860,
	0X6F12, 0X101A,
	0X6F12, 0X0881,
	0X6F12, 0X00F0,
	0X6F12, 0X2AB9,
	0X6F12, 0X2000,
	0X6F12, 0X8B32,
	0X6F12, 0X2000,
	0X6F12, 0X5C20,
	0X6F12, 0X2000,
	0X6F12, 0XA3D4,
	0X6F12, 0X0000,
	0X6F12, 0X0000,
	0X6F12, 0X30B5,
	0X6F12, 0XAB4C,
	0X6F12, 0XB0F8,
	0X6F12, 0XE232,
	0X6F12, 0X608C,
	0X6F12, 0X081A,
	0X6F12, 0XA18C,
	0X6F12, 0X401E,
	0X6F12, 0X1944,
	0X6F12, 0X8142,
	0X6F12, 0X01D9,
	0X6F12, 0X0020,
	0X6F12, 0X0346,
	0X6F12, 0XA649,
	0X6F12, 0X9340,
	0X6F12, 0X4880,
	0X6F12, 0X9040,
	0X6F12, 0XA54A,
	0X6F12, 0X99B2,
	0X6F12, 0XD181,
	0X6F12, 0X1082,
	0X6F12, 0XA44D,
	0X6F12, 0XAD79,
	0X6F12, 0X002D,
	0X6F12, 0X06D1,
	0X6F12, 0X33B1,
	0X6F12, 0X94F8,
	0X6F12, 0XB730,
	0X6F12, 0X1BB1,
	0X6F12, 0X5181,
	0X6F12, 0X401E,
	0X6F12, 0X9081,
	0X6F12, 0X30BD,
	0X6F12, 0X4FF6,
	0X6F12, 0XFF70,
	0X6F12, 0X5081,
	0X6F12, 0XF9E7,
	0X6F12, 0X2DE9,
	0X6F12, 0XF041,
	0X6F12, 0X0646,
	0X6F12, 0X9848,
	0X6F12, 0X0D46,
	0X6F12, 0X1C38,
	0X6F12, 0X4268,
	0X6F12, 0X140C,
	0X6F12, 0X97B2,
	0X6F12, 0X0022,
	0X6F12, 0X3946,
	0X6F12, 0X2046,
	0X6F12, 0X00F0,
	0X6F12, 0X4BF9,
	0X6F12, 0X2946,
	0X6F12, 0X3046,
	0X6F12, 0X00F0,
	0X6F12, 0X4CF9,
	0X6F12, 0X9148,
	0X6F12, 0X9349,
	0X6F12, 0X0122,
	0X6F12, 0X4088,
	0X6F12, 0XA1F8,
	0X6F12, 0XBC07,
	0X6F12, 0X3946,
	0X6F12, 0X2046,
	0X6F12, 0XBDE8,
	0X6F12, 0XF041,
	0X6F12, 0X00F0,
	0X6F12, 0X3BB9,
	0X6F12, 0X70B5,
	0X6F12, 0X0646,
	0X6F12, 0X8A48,
	0X6F12, 0X0022,
	0X6F12, 0X1C38,
	0X6F12, 0X8168,
	0X6F12, 0X0C0C,
	0X6F12, 0X8DB2,
	0X6F12, 0X2946,
	0X6F12, 0X2046,
	0X6F12, 0X00F0,
	0X6F12, 0X2FF9,
	0X6F12, 0X3046,
	0X6F12, 0X00F0,
	0X6F12, 0X36F9,
	0X6F12, 0X8749,
	0X6F12, 0X96F8,
	0X6F12, 0XB100,
	0X6F12, 0X0880,
	0X6F12, 0X2946,
	0X6F12, 0X2046,
	0X6F12, 0XBDE8,
	0X6F12, 0X7040,
	0X6F12, 0X0122,
	0X6F12, 0X00F0,
	0X6F12, 0X21B9,
	0X6F12, 0X70B5,
	0X6F12, 0X0646,
	0X6F12, 0X7D48,
	0X6F12, 0X0022,
	0X6F12, 0X1C38,
	0X6F12, 0XC168,
	0X6F12, 0X0C0C,
	0X6F12, 0X8DB2,
	0X6F12, 0X2946,
	0X6F12, 0X2046,
	0X6F12, 0X00F0,
	0X6F12, 0X15F9,
	0X6F12, 0X3046,
	0X6F12, 0X00F0,
	0X6F12, 0X21F9,
	0X6F12, 0X26B3,
	0X6F12, 0X7948,
	0X6F12, 0XB0F8,
	0X6F12, 0XA007,
	0X6F12, 0X00B3,
	0X6F12, 0X7748,
	0X6F12, 0X6521,
	0X6F12, 0X90F8,
	0X6F12, 0XE407,
	0X6F12, 0X4843,
	0X6F12, 0X7649,
	0X6F12, 0X01EB,
	0X6F12, 0X8003,
	0X6F12, 0X01F6,
	0X6F12, 0X9C02,
	0X6F12, 0X7549,
	0X6F12, 0XB3F8,
	0X6F12, 0X3202,
	0X6F12, 0X91F8,
	0X6F12, 0XF719,
	0X6F12, 0X32F8,
	0X6F12, 0X1110,
	0X6F12, 0X0844,
	0X6F12, 0X40F4,
	0X6F12, 0X8051,
	0X6F12, 0X7148,
	0X6F12, 0X0180,
	0X6F12, 0XB3F8,
	0X6F12, 0X3612,
	0X6F12, 0X6E4B,
	0X6F12, 0X93F8,
	0X6F12, 0XF939,
	0X6F12, 0X32F8,
	0X6F12, 0X1320,
	0X6F12, 0X1144,
	0X6F12, 0X41F4,
	0X6F12, 0X8051,
	0X6F12, 0X8180,
	0X6F12, 0X2946,
	0X6F12, 0X2046,
	0X6F12, 0XBDE8,
	0X6F12, 0X7040,
	0X6F12, 0X0122,
	0X6F12, 0X00F0,
	0X6F12, 0XE5B8,
	0X6F12, 0X70B5,
	0X6F12, 0X674D,
	0X6F12, 0X41F2,
	0X6F12, 0XF046,
	0X6F12, 0X1544,
	0X6F12, 0X049C,
	0X6F12, 0XAD5D,
	0X6F12, 0X0DB9,
	0X6F12, 0X1B78,
	0X6F12, 0X03B1,
	0X6F12, 0X0123,
	0X6F12, 0X2370,
	0X6F12, 0X634B,
	0X6F12, 0X03EB,
	0X6F12, 0XC203,
	0X6F12, 0XB3F8,
	0X6F12, 0XD630,
	0X6F12, 0X2381,
	0X6F12, 0X90F8,
	0X6F12, 0XCC50,
	0X6F12, 0X1346,
	0X6F12, 0X05B1,
	0X6F12, 0X0223,
	0X6F12, 0X5E4D,
	0X6F12, 0X03EB,
	0X6F12, 0XC303,
	0X6F12, 0X05EB,
	0X6F12, 0X8303,
	0X6F12, 0X1B79,
	0X6F12, 0X53B1,
	0X6F12, 0X544B,
	0X6F12, 0XB3F8,
	0X6F12, 0XB855,
	0X6F12, 0X4F4B,
	0X6F12, 0X1B78,
	0X6F12, 0X03F5,
	0X6F12, 0XFC63,
	0X6F12, 0X9D42,
	0X6F12, 0X01D9,
	0X6F12, 0X0123,
	0X6F12, 0X2370,
	0X6F12, 0X90F8,
	0X6F12, 0X2830,
	0X6F12, 0X03B1,
	0X6F12, 0X0123,
	0X6F12, 0X6370,
	0X6F12, 0X90F8,
	0X6F12, 0X1833,
	0X6F12, 0XE370,
	0X6F12, 0X90F8,
	0X6F12, 0X1703,
	0X6F12, 0XA070,
	0X6F12, 0X01EB,
	0X6F12, 0X8200,
	0X6F12, 0XD0F8,
	0X6F12, 0X2C11,
	0X6F12, 0XC1F3,
	0X6F12, 0X8F11,
	0X6F12, 0XA180,
	0X6F12, 0XD0F8,
	0X6F12, 0X3401,
	0X6F12, 0XC0F3,
	0X6F12, 0X8F10,
	0X6F12, 0XE080,
	0X6F12, 0X70BD,
	0X6F12, 0X0346,
	0X6F12, 0X30B5,
	0X6F12, 0X4148,
	0X6F12, 0XB0F8,
	0X6F12, 0XD007,
	0X6F12, 0X0844,
	0X6F12, 0X3E49,
	0X6F12, 0XB1F8,
	0X6F12, 0X6E40,
	0X6F12, 0X001B,
	0X6F12, 0X3A4C,
	0X6F12, 0X00B2,
	0X6F12, 0XA080,
	0X6F12, 0X01EB,
	0X6F12, 0X4304,
	0X6F12, 0X101A,
	0X6F12, 0XB4F9,
	0X6F12, 0X7E40,
	0X6F12, 0X2044,
	0X6F12, 0X3B4C,
	0X6F12, 0X9840,
	0X6F12, 0XD4F8,
	0X6F12, 0X0459,
	0X6F12, 0X0524,
	0X6F12, 0X9C40,
	0X6F12, 0X2C44,
	0X6F12, 0X8442,
	0X6F12, 0X04DD,
	0X6F12, 0X91F8,
	0X6F12, 0X7010,
	0X6F12, 0X9A40,
	0X6F12, 0X09B1,
	0X6F12, 0X1044,
	0X6F12, 0X30BD,
	0X6F12, 0X1046,
	0X6F12, 0X30BD,
	0X6F12, 0X70B5,
	0X6F12, 0X0446,
	0X6F12, 0X2C48,
	0X6F12, 0X0022,
	0X6F12, 0X1C38,
	0X6F12, 0X8069,
	0X6F12, 0X86B2,
	0X6F12, 0X050C,
	0X6F12, 0X3146,
	0X6F12, 0X2846,
	0X6F12, 0X00F0,
	0X6F12, 0X74F8,
	0X6F12, 0X2046,
	0X6F12, 0X00F0,
	0X6F12, 0X85F8,
	0X6F12, 0X94F8,
	0X6F12, 0X2500,
	0X6F12, 0X8107,
	0X6F12, 0X2448,
	0X6F12, 0X04D5,
	0X6F12, 0X6188,
	0X6F12, 0X4078,
	0X6F12, 0X0844,
	0X6F12, 0X6080,
	0X6F12, 0X03E0,
	0X6F12, 0XE188,
	0X6F12, 0X4078,
	0X6F12, 0X081A,
	0X6F12, 0XE080,
	0X6F12, 0X3146,
	0X6F12, 0X2846,
	0X6F12, 0XBDE8,
	0X6F12, 0X7040,
	0X6F12, 0X0122,
	0X6F12, 0X00F0,
	0X6F12, 0X5CB8,
	0X6F12, 0X10B5,
	0X6F12, 0X0022,
	0X6F12, 0XAFF2,
	0X6F12, 0X4B21,
	0X6F12, 0X2448,
	0X6F12, 0X00F0,
	0X6F12, 0X6EF8,
	0X6F12, 0X184C,
	0X6F12, 0X1C3C,
	0X6F12, 0X0122,
	0X6F12, 0XAFF2,
	0X6F12, 0X1121,
	0X6F12, 0X2060,
	0X6F12, 0X2148,
	0X6F12, 0X00F0,
	0X6F12, 0X65F8,
	0X6F12, 0X0022,
	0X6F12, 0XAFF2,
	0X6F12, 0XE111,
	0X6F12, 0X6060,
	0X6F12, 0X1E48,
	0X6F12, 0X00F0,
	0X6F12, 0X5EF8,
	0X6F12, 0X0022,
	0X6F12, 0XAFF2,
	0X6F12, 0XBD11,
	0X6F12, 0XA060,
	0X6F12, 0X1C48,
	0X6F12, 0X00F0,
	0X6F12, 0X57F8,
	0X6F12, 0X0022,
	0X6F12, 0XAFF2,
	0X6F12, 0X5111,
	0X6F12, 0XE060,
	0X6F12, 0X1948,
	0X6F12, 0X00F0,
	0X6F12, 0X50F8,
	0X6F12, 0X0022,
	0X6F12, 0XAFF2,
	0X6F12, 0XDF01,
	0X6F12, 0X2061,
	0X6F12, 0X1748,
	0X6F12, 0X00F0,
	0X6F12, 0X49F8,
	0X6F12, 0X0022,
	0X6F12, 0XAFF2,
	0X6F12, 0XA301,
	0X6F12, 0X6061,
	0X6F12, 0X1448,
	0X6F12, 0X00F0,
	0X6F12, 0X42F8,
	0X6F12, 0XA061,
	0X6F12, 0X10BD,
	0X6F12, 0X0000,
	0X6F12, 0X2000,
	0X6F12, 0X0AE0,
	0X6F12, 0X2000,
	0X6F12, 0X8B2C,
	0X6F12, 0X4000,
	0X6F12, 0XF000,
	0X6F12, 0X2000,
	0X6F12, 0X0A40,
	0X6F12, 0X2000,
	0X6F12, 0X5D00,
	0X6F12, 0X4000,
	0X6F12, 0X6B56,
	0X6F12, 0X2000,
	0X6F12, 0X68F0,
	0X6F12, 0X2000,
	0X6F12, 0X0BB0,
	0X6F12, 0X4000,
	0X6F12, 0XF66E,
	0X6F12, 0X2000,
	0X6F12, 0X7220,
	0X6F12, 0X2000,
	0X6F12, 0X5900,
	0X6F12, 0X2000,
	0X6F12, 0X8720,
	0X6F12, 0X0001,
	0X6F12, 0X14E7,
	0X6F12, 0X0000,
	0X6F12, 0X5059,
	0X6F12, 0X0000,
	0X6F12, 0X512F,
	0X6F12, 0X0000,
	0X6F12, 0XFB2B,
	0X6F12, 0X0000,
	0X6F12, 0XD02D,
	0X6F12, 0X0000,
	0X6F12, 0X724F,
	0X6F12, 0X0000,
	0X6F12, 0X287F,
	0X6F12, 0X45F6,
	0X6F12, 0X576C,
	0X6F12, 0XC0F2,
	0X6F12, 0X000C,
	0X6F12, 0X6047,
	0X6F12, 0X45F2,
	0X6F12, 0X590C,
	0X6F12, 0XC0F2,
	0X6F12, 0X000C,
	0X6F12, 0X6047,
	0X6F12, 0X45F2,
	0X6F12, 0X2F1C,
	0X6F12, 0XC0F2,
	0X6F12, 0X000C,
	0X6F12, 0X6047,
	0X6F12, 0X4FF6,
	0X6F12, 0X2B3C,
	0X6F12, 0XC0F2,
	0X6F12, 0X000C,
	0X6F12, 0X6047,
	0X6F12, 0X42F6,
	0X6F12, 0X7F0C,
	0X6F12, 0XC0F2,
	0X6F12, 0X000C,
	0X6F12, 0X6047,
	0X6F12, 0X43F2,
	0X6F12, 0X7B5C,
	0X6F12, 0XC0F2,
	0X6F12, 0X000C,
	0X6F12, 0X6047,
	0X6028, 0X4000,
	0X0208, 0X0000,
	0XF466, 0X000C,
	0XF468, 0X000D,
	0X0200, 0X0100,
	0X0202, 0X0100,
	0X0224, 0X0100,
	0X0226, 0X0100,
	0XF488, 0X0008,
	0XF414, 0X0007,
	0XF416, 0X0004,
	0X0110, 0X1002,
	0X30C0, 0X0001,
	0X30C6, 0X0100,
	0X30CA, 0X0300,
	0X30C8, 0X05DC,
	0X6B36, 0X5200,
	0X6B38, 0X0000,
	0X0B04, 0X0101,
	0X3094, 0X2800,
	0X3096, 0X5400,
	0X6028, 0X2000,
	0X602A, 0X16B0,
	0X6F12, 0X0040,
	0X6F12, 0X0040,
	0X602A, 0X167E,
	0X6F12, 0X0018,
	0X602A, 0X1682,
	0X6F12, 0X0010,
	0X602A, 0X16A0,
	0X6F12, 0X2101,
	0X602A, 0X1664,
	0X6F12, 0X0100,
	0X602A, 0X2A98,
	0X6F12, 0X0001,
	0X6F12, 0X0100,
	0X6F12, 0X03FF,
	0X6F12, 0X1000,
	0X6F12, 0X0FC0,
	0X602A, 0X2AC2,
	0X6F12, 0X0100,
	0X6F12, 0X03FF,
	0X6F12, 0X1000,
	0X6F12, 0X0FC0,
	0X602A, 0X2AEA,
	0X6F12, 0X0100,
	0X6F12, 0X03FF,
	0X6F12, 0X1000,
	0X6F12, 0X0FC0,
	0X602A, 0X2B12,
	0X6F12, 0X0100,
	0X6F12, 0X03FF,
	0X6F12, 0X1000,
	0X6F12, 0X0FC0,
	0X602A, 0X2B3A,
	0X6F12, 0X0100,
	0X6F12, 0X03FF,
	0X6F12, 0X1000,
	0X6F12, 0X0FC0,
	0X602A, 0X2B62,
	0X6F12, 0X0100,
	0X6F12, 0X03FF,
	0X6F12, 0X1000,
	0X6F12, 0X0FC0,
	0X602A, 0X2B8A,
	0X6F12, 0X0100,
	0X6F12, 0X03FF,
	0X6F12, 0X1000,
	0X6F12, 0X0FC0,
	0X602A, 0X2BB2,
	0X6F12, 0X0100,
	0X6F12, 0X03FF,
	0X6F12, 0X1000,
	0X6F12, 0X0FC0,
	0X602A, 0X3568,
	0X6F12, 0X0100,
	0X602A, 0X402C,
	0X6F12, 0X0100,
	0X602A, 0X4AF0,
	0X6F12, 0X0100,
	0X602A, 0X35C4,
	0X6F12, 0XFF9A,
	0X602A, 0X35F6,
	0X6F12, 0XFF9A,
	0X602A, 0X35BA,
	0X6F12, 0XFF9A,
	0X602A, 0X35EC,
	0X6F12, 0XFF9A,
	0X602A, 0X35B0,
	0X6F12, 0XFF9A,
	0X602A, 0X35E2,
	0X6F12, 0XFF9A,
	0X602A, 0X35A6,
	0X6F12, 0XFF9A,
	0X602A, 0X35D8,
	0X6F12, 0XFF9A,
	0X602A, 0X4088,
	0X6F12, 0XFF9A,
	0X602A, 0X40BA,
	0X6F12, 0XFF9A,
	0X602A, 0X407E,
	0X6F12, 0XFF9A,
	0X602A, 0X40B0,
	0X6F12, 0XFF9A,
	0X602A, 0X4074,
	0X6F12, 0XFF9A,
	0X602A, 0X40A6,
	0X6F12, 0XFF9A,
	0X602A, 0X406A,
	0X6F12, 0XFF9A,
	0X602A, 0X409C,
	0X6F12, 0XFF9A,
	0X602A, 0X4B4C,
	0X6F12, 0XFFCD,
	0X602A, 0X4B7E,
	0X6F12, 0XFFCD,
	0X602A, 0X4B42,
	0X6F12, 0XFFCD,
	0X602A, 0X4B74,
	0X6F12, 0XFFCD,
	0X602A, 0X4B38,
	0X6F12, 0XFFCD,
	0X602A, 0X4B6A,
	0X6F12, 0XFFCD,
	0X602A, 0X4B2E,
	0X6F12, 0XFFCD,
	0X602A, 0X4B60,
	0X6F12, 0XFFCD,
	0X602A, 0X3684,
	0X6F12, 0X0100,
	0X602A, 0X4148,
	0X6F12, 0X0100,
	0X602A, 0X4C0C,
	0X6F12, 0X0100,
	0X602A, 0X3688,
	0X6F12, 0X000E,
	0X6F12, 0X000E,
	0X602A, 0X368E,
	0X6F12, 0X0000,
	0X602A, 0X414C,
	0X6F12, 0X000E,
	0X6F12, 0X000E,
	0X602A, 0X4152,
	0X6F12, 0X0000,
	0X602A, 0X4C10,
	0X6F12, 0X000E,
	0X6F12, 0X000E,
	0X6F12, 0X0002,
	0X6F12, 0X0000,
	0X602A, 0X0B52,
	0X6F12, 0X0000,
	0X6F12, 0X0001,
	0X602A, 0X1686,
	0X6F12, 0X0328,
	0X602A, 0X0B02,
	0X6F12, 0X0100,
	0X602A, 0X4C54,
	0X6F12, 0X0000,
	0X602A, 0X4C58,
	0X6F12, 0X0000,
	0X602A, 0X4C5C,
	0X6F12, 0X010F,
	0X602A, 0X09A2,
	0X6F12, 0X0080,
	0X602A, 0X09A6,
	0X6F12, 0X008C,
	0X602A, 0X09AE,
	0X6F12, 0XF408,
	0X602A, 0X09A0,
	0X6F12, 0X0101,
	0X602A, 0X09A4,
	0X6F12, 0X007F,
	0X602A, 0X09A8,
	0X6F12, 0X007F,
	0X602A, 0X09DA,
	0X6F12, 0X0009,
	0X6F12, 0X0012,
	0X6F12, 0XF482,
	0X6F12, 0X0009,
	0X6F12, 0X0012,
	0X6F12, 0XF484,
	0X602A, 0X1666,
	0X6F12, 0X054C,
	0X6F12, 0X0183,
	0X6F12, 0X07FF,
	0X602A, 0X16B4,
	0X6F12, 0X54C2,
	0X602A, 0X16AA,
	0X6F12, 0X2608,
	0X602A, 0X16AE,
	0X6F12, 0X2608,
	0X602A, 0X1620,
	0X6F12, 0X0408,
	0X6F12, 0X0808,
	0X602A, 0X1628,
	0X6F12, 0X0408,
	0X6F12, 0X0808,
	0X602A, 0X168A,
	0X6F12, 0X001B,
	0X602A, 0X1640,
	0X6F12, 0X0505,
	0X6F12, 0X070E,
	0X602A, 0X1648,
	0X6F12, 0X0505,
	0X6F12, 0X070E,
	0X602A, 0X1650,
	0X6F12, 0X0A0A,
	0X6F12, 0X040A,
	0X602A, 0X1658,
	0X6F12, 0X0A0A,
	0X6F12, 0X040A,
	0X602A, 0X15E4,
	0X6F12, 0X0001,
	0X6F12, 0X0101,
	0X602A, 0X15EA,
	0X6F12, 0X0302,
	0X602A, 0X0BB8,
	0X6F12, 0X01A0,
	0X6F12, 0X01A0,
	0X602A, 0X0BBE,
	0X6F12, 0X01A0,
	0X602A, 0X0BC8,
	0X6F12, 0X06E0,
	0X6F12, 0X0420,
	0X602A, 0X0BCE,
	0X6F12, 0X0420,
	0X602A, 0X0BD8,
	0X6F12, 0X000A,
	0X6F12, 0X0006,
	0X602A, 0X0BDE,
	0X6F12, 0X0003,
	0X602A, 0X16BC,
	0X6F12, 0X0100,
	0X602A, 0X0A10,
	0X6F12, 0X0064,
	0X6F12, 0X0520,
	0X6F12, 0X06E0,
	0X6F12, 0X06DE,
	0X602A, 0X15FE,
	0X6F12, 0X0001,
	0X602A, 0X0C10,
	0X6F12, 0X0361,
	0X6F12, 0X028A,
	0X602A, 0X0C16,
	0X6F12, 0X01D8,
	0X602A, 0X0C28,
	0X6F12, 0X019D,
	0X6F12, 0X0114,
	0X602A, 0X0C2E,
	0X6F12, 0X00BF,
	0X6F12, 0X01D5,
	0X6F12, 0X014C,
	0X602A, 0X0C36,
	0X6F12, 0X00F7,
	0X6F12, 0X019C,
	0X6F12, 0X0113,
	0X602A, 0X0C3E,
	0X6F12, 0X00BE,
	0X6F12, 0X01D6,
	0X6F12, 0X014D,
	0X602A, 0X0C46,
	0X6F12, 0X00F8,
	0X6F12, 0X0094,
	0X6F12, 0X0072,
	0X602A, 0X0C4E,
	0X6F12, 0X010F,
	0X6F12, 0X007F,
	0X6F12, 0X005D,
	0X602A, 0X0C56,
	0X6F12, 0X00FA,
	0X6F12, 0X0069,
	0X6F12, 0X005B,
	0X602A, 0X0C5E,
	0X6F12, 0X005B,
	0X602A, 0X0C68,
	0X6F12, 0X008D,
	0X6F12, 0X006B,
	0X602A, 0X0C6E,
	0X6F12, 0X0108,
	0X6F12, 0X0086,
	0X6F12, 0X0064,
	0X602A, 0X0C76,
	0X6F12, 0X0101,
	0X6F12, 0X0062,
	0X6F12, 0X0054,
	0X602A, 0X0C7E,
	0X6F12, 0X0054,
	0X602A, 0X0C88,
	0X6F12, 0X0063,
	0X6F12, 0X0055,
	0X602A, 0X0C8E,
	0X6F12, 0X0055,
	0X602A, 0X0C98,
	0X6F12, 0X008D,
	0X6F12, 0X006B,
	0X602A, 0X0C9E,
	0X6F12, 0X0108,
	0X6F12, 0X0086,
	0X6F12, 0X0064,
	0X602A, 0X0CA6,
	0X6F12, 0X0101,
	0X6F12, 0X0062,
	0X6F12, 0X0054,
	0X602A, 0X0CAE,
	0X6F12, 0X0054,
	0X602A, 0X0CC0,
	0X6F12, 0X019B,
	0X6F12, 0X0112,
	0X602A, 0X0CC6,
	0X6F12, 0X00BD,
	0X6F12, 0X0355,
	0X6F12, 0X0282,
	0X602A, 0X0CCE,
	0X6F12, 0X01D5,
	0X6F12, 0X019D,
	0X6F12, 0X0114,
	0X602A, 0X0CD6,
	0X6F12, 0X00BF,
	0X6F12, 0X0353,
	0X6F12, 0X0280,
	0X602A, 0X0CDE,
	0X6F12, 0X01D3,
	0X6F12, 0X019B,
	0X6F12, 0X0112,
	0X602A, 0X0CE6,
	0X6F12, 0X00BD,
	0X6F12, 0X01F3,
	0X6F12, 0X016A,
	0X602A, 0X0CEE,
	0X6F12, 0X0113,
	0X602A, 0X0CF8,
	0X6F12, 0X00DF,
	0X6F12, 0X005A,
	0X602A, 0X0D08,
	0X6F12, 0X00D6,
	0X6F12, 0X0051,
	0X602A, 0X0D18,
	0X6F12, 0X00DD,
	0X6F12, 0X0058,
	0X602A, 0X0D20,
	0X6F12, 0X0018,
	0X6F12, 0X0018,
	0X602A, 0X0D26,
	0X6F12, 0X0018,
	0X6F12, 0X0193,
	0X6F12, 0X010A,
	0X602A, 0X0D2E,
	0X6F12, 0X00BA,
	0X602A, 0X0D38,
	0X6F12, 0X0012,
	0X6F12, 0X0012,
	0X602A, 0X0D3E,
	0X6F12, 0X0010,
	0X6F12, 0X01D5,
	0X6F12, 0X014C,
	0X602A, 0X0D46,
	0X6F12, 0X00F7,
	0X6F12, 0X01EB,
	0X6F12, 0X0162,
	0X602A, 0X0D4E,
	0X6F12, 0X010B,
	0X6F12, 0X0000,
	0X6F12, 0X0000,
	0X602A, 0X0D56,
	0X6F12, 0X0000,
	0X6F12, 0X0000,
	0X6F12, 0X0000,
	0X602A, 0X0D5E,
	0X6F12, 0X0000,
	0X602A, 0X0D68,
	0X6F12, 0X0361,
	0X6F12, 0X028A,
	0X602A, 0X0D6E,
	0X6F12, 0X01D8,
	0X6F12, 0X0012,
	0X6F12, 0X0012,
	0X602A, 0X0D76,
	0X6F12, 0X0012,
	0X602A, 0X0D88,
	0X6F12, 0X0361,
	0X6F12, 0X028A,
	0X602A, 0X0D8E,
	0X6F12, 0X01D8,
	0X602A, 0X0D98,
	0X6F12, 0X0361,
	0X6F12, 0X028A,
	0X602A, 0X0D9E,
	0X6F12, 0X01D8,
	0X602A, 0X0DA8,
	0X6F12, 0X0355,
	0X6F12, 0X0282,
	0X602A, 0X0DAE,
	0X6F12, 0X01D5,
	0X602A, 0X0DB8,
	0X6F12, 0X0355,
	0X6F12, 0X0282,
	0X602A, 0X0DBE,
	0X6F12, 0X01D5,
	0X6F12, 0X015F,
	0X6F12, 0X00DA,
	0X602A, 0X0DC6,
	0X6F12, 0X008D,
	0X6F12, 0X0193,
	0X6F12, 0X010A,
	0X602A, 0X0DCE,
	0X6F12, 0X00BA,
	0X6F12, 0X026D,
	0X6F12, 0X01E4,
	0X602A, 0X0DD6,
	0X6F12, 0X013A,
	0X6F12, 0X0351,
	0X6F12, 0X027E,
	0X602A, 0X0DDE,
	0X6F12, 0X01D1,
	0X6F12, 0X019B,
	0X6F12, 0X0112,
	0X602A, 0X0DE6,
	0X6F12, 0X00C2,
	0X6F12, 0X01AD,
	0X6F12, 0X0124,
	0X602A, 0X0DEE,
	0X6F12, 0X00D4,
	0X6F12, 0X01A0,
	0X6F12, 0X0117,
	0X602A, 0X0DF6,
	0X6F12, 0X00C7,
	0X6F12, 0X01B2,
	0X6F12, 0X0129,
	0X602A, 0X0DFE,
	0X6F12, 0X00D9,
	0X6F12, 0X01A5,
	0X6F12, 0X011C,
	0X602A, 0X0E06,
	0X6F12, 0X00CC,
	0X6F12, 0X01B2,
	0X6F12, 0X0129,
	0X602A, 0X0E0E,
	0X6F12, 0X00D9,
	0X6F12, 0X019B,
	0X6F12, 0X0112,
	0X602A, 0X0E16,
	0X6F12, 0X00C2,
	0X6F12, 0X019E,
	0X6F12, 0X0115,
	0X602A, 0X0E1E,
	0X6F12, 0X00C5,
	0X602A, 0X0E30,
	0X6F12, 0X01A3,
	0X6F12, 0X011A,
	0X602A, 0X0E36,
	0X6F12, 0X00CA,
	0X6F12, 0X01B2,
	0X6F12, 0X0129,
	0X602A, 0X0E3E,
	0X6F12, 0X00D9,
	0X602A, 0X0E50,
	0X6F12, 0X019B,
	0X6F12, 0X0112,
	0X602A, 0X0E56,
	0X6F12, 0X00C2,
	0X6F12, 0X019E,
	0X6F12, 0X0115,
	0X602A, 0X0E5E,
	0X6F12, 0X00C5,
	0X6F12, 0X00FC,
	0X6F12, 0X0077,
	0X602A, 0X0E66,
	0X6F12, 0X0074,
	0X6F12, 0X0196,
	0X6F12, 0X010D,
	0X602A, 0X0E6E,
	0X6F12, 0X00BD,
	0X6F12, 0X026B,
	0X6F12, 0X01E2,
	0X602A, 0X0E76,
	0X6F12, 0X0138,
	0X6F12, 0X0353,
	0X6F12, 0X0280,
	0X602A, 0X0E7E,
	0X6F12, 0X01D2,
	0X602A, 0X0E90,
	0X6F12, 0X019A,
	0X6F12, 0X0111,
	0X602A, 0X0E96,
	0X6F12, 0X00C1,
	0X6F12, 0X01B0,
	0X6F12, 0X0127,
	0X602A, 0X0E9E,
	0X6F12, 0X00D6,
	0X6F12, 0X01B2,
	0X6F12, 0X0129,
	0X602A, 0X0EA6,
	0X6F12, 0X00D8,
	0X6F12, 0X01C8,
	0X6F12, 0X013F,
	0X602A, 0X0EAE,
	0X6F12, 0X00ED,
	0X6F12, 0X01CA,
	0X6F12, 0X0141,
	0X602A, 0X0EB6,
	0X6F12, 0X00EF,
	0X6F12, 0X01E0,
	0X6F12, 0X0157,
	0X602A, 0X0EBE,
	0X6F12, 0X0104,
	0X6F12, 0X01E3,
	0X6F12, 0X015A,
	0X602A, 0X0EC6,
	0X6F12, 0X0107,
	0X6F12, 0X01F9,
	0X6F12, 0X0170,
	0X602A, 0X0ECE,
	0X6F12, 0X011C,
	0X6F12, 0X01FB,
	0X6F12, 0X0172,
	0X602A, 0X0ED6,
	0X6F12, 0X011E,
	0X6F12, 0X0211,
	0X6F12, 0X0188,
	0X602A, 0X0EDE,
	0X6F12, 0X0133,
	0X6F12, 0X0213,
	0X6F12, 0X018A,
	0X602A, 0X0EE6,
	0X6F12, 0X0135,
	0X6F12, 0X0229,
	0X6F12, 0X01A0,
	0X602A, 0X0EEE,
	0X6F12, 0X014A,
	0X6F12, 0X022B,
	0X6F12, 0X01A2,
	0X602A, 0X0EF6,
	0X6F12, 0X014C,
	0X6F12, 0X0241,
	0X6F12, 0X01B8,
	0X602A, 0X0EFE,
	0X6F12, 0X0161,
	0X6F12, 0X0243,
	0X6F12, 0X01BA,
	0X602A, 0X0F06,
	0X6F12, 0X0163,
	0X6F12, 0X0259,
	0X6F12, 0X01D0,
	0X602A, 0X0F0E,
	0X6F12, 0X0178,
	0X6F12, 0X030E,
	0X6F12, 0X0237,
	0X602A, 0X0F16,
	0X6F12, 0X018B,
	0X6F12, 0X0324,
	0X6F12, 0X024D,
	0X602A, 0X0F1E,
	0X6F12, 0X01A0,
	0X6F12, 0X0326,
	0X6F12, 0X024F,
	0X602A, 0X0F26,
	0X6F12, 0X01A2,
	0X6F12, 0X033C,
	0X6F12, 0X0265,
	0X602A, 0X0F2E,
	0X6F12, 0X01B7,
	0X6F12, 0X033E,
	0X6F12, 0X0267,
	0X602A, 0X0F36,
	0X6F12, 0X01B9,
	0X6F12, 0X0354,
	0X6F12, 0X027D,
	0X602A, 0X0F3E,
	0X6F12, 0X01CE,
	0X602A, 0X0FB0,
	0X6F12, 0X019B,
	0X6F12, 0X0112,
	0X602A, 0X0FB6,
	0X6F12, 0X00C2,
	0X6F12, 0X01B2,
	0X6F12, 0X0129,
	0X602A, 0X0FBE,
	0X6F12, 0X00D9,
	0X602A, 0X0FD0,
	0X6F12, 0X019B,
	0X6F12, 0X0112,
	0X602A, 0X0FD6,
	0X6F12, 0X00C2,
	0X6F12, 0X019E,
	0X6F12, 0X0115,
	0X602A, 0X0FDE,
	0X6F12, 0X00C5,
	0X6F12, 0X0012,
	0X6F12, 0X0012,
	0X602A, 0X0FE6,
	0X6F12, 0X0012,
	0X6F12, 0X0357,
	0X6F12, 0X0284,
	0X602A, 0X0FEE,
	0X6F12, 0X01D7,
	0X6F12, 0X00F7,
	0X6F12, 0X0072,
	0X602A, 0X0FF6,
	0X6F12, 0X006F,
	0X602A, 0X1008,
	0X6F12, 0X00FA,
	0X6F12, 0X0075,
	0X602A, 0X100E,
	0X6F12, 0X0072,
	0X6F12, 0X019A,
	0X6F12, 0X0111,
	0X602A, 0X1016,
	0X6F12, 0X00C1,
	0X6F12, 0X019D,
	0X6F12, 0X0114,
	0X602A, 0X101E,
	0X6F12, 0X00C4,
	0X6F12, 0X0352,
	0X6F12, 0X027F,
	0X602A, 0X1026,
	0X6F12, 0X01D2,
	0X6F12, 0X0355,
	0X6F12, 0X0282,
	0X602A, 0X102E,
	0X6F12, 0X01D5,
	0X6F12, 0X019A,
	0X6F12, 0X0111,
	0X602A, 0X1036,
	0X6F12, 0X00C1,
	0X6F12, 0X0012,
	0X6F12, 0X0012,
	0X602A, 0X103E,
	0X6F12, 0X0012,
	0X6F12, 0X019F,
	0X6F12, 0X0116,
	0X602A, 0X1046,
	0X6F12, 0X00C6,
	0X602A, 0X1058,
	0X6F12, 0X0013,
	0X6F12, 0X0013,
	0X602A, 0X105E,
	0X6F12, 0X0013,
	0X6F12, 0X0353,
	0X6F12, 0X0280,
	0X602A, 0X1066,
	0X6F12, 0X01D3,
	0X602A, 0X1098,
	0X6F12, 0X01BC,
	0X6F12, 0X0133,
	0X602A, 0X109E,
	0X6F12, 0X00E3,
	0X6F12, 0X01C6,
	0X6F12, 0X013D,
	0X602A, 0X10A6,
	0X6F12, 0X00ED,
	0X602A, 0X10D8,
	0X6F12, 0X019B,
	0X6F12, 0X0112,
	0X602A, 0X10DE,
	0X6F12, 0X00C2,
	0X6F12, 0X01AD,
	0X6F12, 0X0124,
	0X602A, 0X10E6,
	0X6F12, 0X00D4,
	0X602A, 0X1118,
	0X6F12, 0X01D3,
	0X6F12, 0X014A,
	0X602A, 0X111E,
	0X6F12, 0X00F5,
	0X602A, 0X1158,
	0X6F12, 0X0352,
	0X6F12, 0X027F,
	0X602A, 0X115E,
	0X6F12, 0X01D2,
	0X602A, 0X1198,
	0X6F12, 0X01A0,
	0X6F12, 0X0117,
	0X602A, 0X119E,
	0X6F12, 0X00C7,
	0X6F12, 0X01B2,
	0X6F12, 0X0129,
	0X602A, 0X11A6,
	0X6F12, 0X00D9,
	0X602A, 0X11B8,
	0X6F12, 0X0014,
	0X6F12, 0X0014,
	0X602A, 0X11BE,
	0X6F12, 0X0014,
	0X6F12, 0X0198,
	0X6F12, 0X010F,
	0X602A, 0X11C6,
	0X6F12, 0X00BF,
	0X6F12, 0X0275,
	0X6F12, 0X01EC,
	0X602A, 0X11CE,
	0X6F12, 0X0142,
	0X6F12, 0X02C1,
	0X602A, 0X11D6,
	0X6F12, 0X018A,
	0X602A, 0X1258,
	0X6F12, 0X000B,
	0X6F12, 0X000B,
	0X602A, 0X125E,
	0X6F12, 0X000B,
	0X602A, 0X1268,
	0X6F12, 0X0009,
	0X6F12, 0X0009,
	0X602A, 0X126E,
	0X6F12, 0X00C1,
	0X6F12, 0X0013,
	0X6F12, 0X0013,
	0X602A, 0X1276,
	0X6F12, 0X00CB,
	0X6F12, 0X01B5,
	0X602A, 0X127E,
	0X6F12, 0X00D5,
	0X6F12, 0X01BF,
	0X602A, 0X1286,
	0X6F12, 0X00DF,
	0X6F12, 0X01C9,
	0X602A, 0X128E,
	0X6F12, 0X00E9,
	0X6F12, 0X01D3,
	0X602A, 0X1296,
	0X6F12, 0X00F3,
	0X6F12, 0X01DD,
	0X602A, 0X129E,
	0X6F12, 0X00FD,
	0X6F12, 0X01E7,
	0X602A, 0X12A6,
	0X6F12, 0X0107,
	0X6F12, 0X01F1,
	0X602A, 0X12AE,
	0X6F12, 0X0111,
	0X6F12, 0X01FB,
	0X602A, 0X12B6,
	0X6F12, 0X011B,
	0X6F12, 0X0205,
	0X602A, 0X12BE,
	0X6F12, 0X0125,
	0X6F12, 0X020F,
	0X602A, 0X12C6,
	0X6F12, 0X012F,
	0X6F12, 0X0219,
	0X602A, 0X12CE,
	0X6F12, 0X0139,
	0X6F12, 0X0223,
	0X602A, 0X12D6,
	0X6F12, 0X0143,
	0X6F12, 0X022D,
	0X602A, 0X12DE,
	0X6F12, 0X014D,
	0X6F12, 0X0237,
	0X602A, 0X12E6,
	0X6F12, 0X0157,
	0X6F12, 0X0241,
	0X602A, 0X12EE,
	0X6F12, 0X0161,
	0X6F12, 0X024B,
	0X602A, 0X12F6,
	0X6F12, 0X016B,
	0X6F12, 0X0255,
	0X602A, 0X12FE,
	0X6F12, 0X0175,
	0X6F12, 0X025F,
	0X602A, 0X1306,
	0X6F12, 0X017F,
	0X6F12, 0X0269,
	0X602A, 0X130E,
	0X6F12, 0X0189,
	0X6F12, 0X0273,
	0X602A, 0X1316,
	0X6F12, 0X0193,
	0X6F12, 0X027D,
	0X602A, 0X131E,
	0X6F12, 0X019D,
	0X6F12, 0X0287,
	0X602A, 0X1326,
	0X6F12, 0X01A7,
	0X6F12, 0X0291,
	0X602A, 0X132E,
	0X6F12, 0X01B1,
	0X6F12, 0X029B,
	0X602A, 0X1336,
	0X6F12, 0X01BB,
	0X6F12, 0X01B0,
	0X602A, 0X133E,
	0X6F12, 0X00D0,
	0X6F12, 0X01C4,
	0X602A, 0X1346,
	0X6F12, 0X00E4,
	0X6F12, 0X01D8,
	0X602A, 0X134E,
	0X6F12, 0X00F8,
	0X6F12, 0X01EC,
	0X602A, 0X1356,
	0X6F12, 0X010C,
	0X6F12, 0X0200,
	0X602A, 0X135E,
	0X6F12, 0X0120,
	0X6F12, 0X0214,
	0X602A, 0X1366,
	0X6F12, 0X0134,
	0X6F12, 0X0228,
	0X602A, 0X136E,
	0X6F12, 0X0148,
	0X6F12, 0X023C,
	0X602A, 0X1376,
	0X6F12, 0X015C,
	0X6F12, 0X0250,
	0X602A, 0X137E,
	0X6F12, 0X0170,
	0X6F12, 0X0264,
	0X602A, 0X1386,
	0X6F12, 0X0184,
	0X6F12, 0X0278,
	0X602A, 0X138E,
	0X6F12, 0X0198,
	0X6F12, 0X028C,
	0X602A, 0X1396,
	0X6F12, 0X01AC,
	0X6F12, 0X02A0,
	0X602A, 0X139E,
	0X6F12, 0X01C0,
	0X602A, 0X14B8,
	0X6F12, 0X00BE,
	0X602A, 0X14BE,
	0X6F12, 0X0105,
	0X6F12, 0X0024,
	0X6F12, 0X0012,
	0X602A, 0X14C6,
	0X6F12, 0X0012,
	0X602A, 0X14D0,
	0X6F12, 0X019A,
	0X6F12, 0X0111,
	0X602A, 0X14D6,
	0X6F12, 0X00C1,
	0X6F12, 0X0087,
	0X6F12, 0X0065,
	0X602A, 0X14DE,
	0X6F12, 0X0102,
	0X6F12, 0X0362,
	0X6F12, 0X028B,
	0X602A, 0X14E6,
	0X6F12, 0X01D9,
	0X6F12, 0X001A,
	0X6F12, 0X001A,
	0X602A, 0X14EE,
	0X6F12, 0X001A,
	0X602A, 0X1508,
	0X6F12, 0X0603,
	0X602A, 0X1550,
	0X6F12, 0X0306,
	0X6F12, 0X0606,
	0X6F12, 0X0606,
	0X6F12, 0X0603,
	0X602A, 0X15DE,
	0X6F12, 0X0107,
	0X602A, 0X0AEC,
	0X6F12, 0X0207,
	0X602A, 0X0A96,
	0X6F12, 0X1E00,
	0X602A, 0X2800,
	0X6F12, 0X0245,
	0X6F12, 0X0105,
	0X602A, 0X2816,
	0X6F12, 0X0000,
	0X6F12, 0X0180,
	0X602A, 0X2824,
	0X6F12, 0X0000,
	0X602A, 0X2814,
	0X6F12, 0X0100,
	0X602A, 0X0998,
	0X6F12, 0X0100,
	0X602A, 0X55BE,
	0X6F12, 0X0000,
	0X6F12, 0X0000,
	0X602A, 0X51D0,
	0X6F12, 0X0100,
	0X602A, 0X51E0,
	0X6F12, 0X0100,
	0X602A, 0X51F0,
	0X6F12, 0X0100,
	0X602A, 0X2A12,
	0X6F12, 0X0102,
	0X602A, 0X2C68,
	0X6F12, 0X0005,
	0X6F12, 0X0005,
	0X6F12, 0X0005,
	0X6F12, 0X0005,
	0X6F12, 0X0003,
	0X6F12, 0X0003,
	0X6F12, 0X0003,
	0X6F12, 0X0003,
	0X6F12, 0X0005,
	0X6F12, 0X0005,
	0X6F12, 0X0005,
	0X6F12, 0X0005,
	0X6F12, 0X0003,
	0X6F12, 0X0003,
	0X6F12, 0X0003,
	0X6F12, 0X0003,
	0X602A, 0X372C,
	0X6F12, 0X000F,
	0X6F12, 0X000D,
	0X6F12, 0X000F,
	0X6F12, 0X000D,
	0X6F12, 0X000B,
	0X6F12, 0X000C,
	0X6F12, 0X000B,
	0X6F12, 0X000C,
	0X6F12, 0X000F,
	0X6F12, 0X000D,
	0X6F12, 0X000F,
	0X6F12, 0X000D,
	0X6F12, 0X000B,
	0X6F12, 0X000C,
	0X6F12, 0X000B,
	0X6F12, 0X000C,
	0X602A, 0X41F0,
	0X6F12, 0X001B,
	0X6F12, 0X001A,
	0X6F12, 0X001B,
	0X6F12, 0X001A,
	0X6F12, 0X0017,
	0X6F12, 0X0014,
	0X6F12, 0X0017,
	0X6F12, 0X0014,
	0X6F12, 0X001B,
	0X6F12, 0X001A,
	0X6F12, 0X001B,
	0X6F12, 0X001A,
	0X6F12, 0X0017,
	0X6F12, 0X0014,
	0X6F12, 0X0017,
	0X6F12, 0X0014,
	0X602A, 0X0A80,
	0X6F12, 0X0100,
	0X6F12, 0X3110,
	0X602A, 0X51D2,
	0X6F12, 0X0000,
	0X602A, 0X51E2,
	0X6F12, 0X0800,
	0X602A, 0X51F2,
	0X6F12, 0X1000,
	0X602A, 0X0A52,
	0X6F12, 0X2100,
	0X602A, 0X0A50,
	0X6F12, 0X2100,
	0X602A, 0X0B06,
	0X6F12, 0X0800,
	0X602A, 0X5840,
	0X6F12, 0X0000,
	0X602A, 0X0AF4,
	0X6F12, 0X0004
};


/*****************************************************************************
 *
 * Description:
 * ------------
 *     mode 3 preview setting
 *     M3 setting, RZ8_V1.0settings
 *     Bining 30fps
 *
 ****************************************************************************/
kal_uint16 addr_data_pair_preview_2l7_m3[] = {
	0X6028, 0X4000,
	0X6214, 0X7970,
	0X6218, 0X7150,
	0X0344, 0X0000,
	0X0346, 0X0000,
	0X0348, 0X1F7F,
	0X034A, 0X0BDF,
	0X034C, 0X07E0,
	0X034E, 0X05E8,
	0X0408, 0X0000,
	0X040A, 0X0004,
	0X0900, 0X0122,
	0X0380, 0X0001,
	0X0382, 0X0003,
	0X0384, 0X0001,
	0X0386, 0X0003,
	0X0400, 0X0000,
	0X0404, 0X0010,
	0X3060, 0X0100,
	0X0114, 0X0300,
	0X0110, 0X1002,
	0X0136, 0X1800,
	0X0304, 0X0006,
	0X0306, 0X01E0,
	0X0302, 0X0001,
	0X0300, 0X0004,
	0X030C, 0X0001,
	0X030E, 0X0004,
	0X0310, 0X00EA,
	0X0312, 0X0001,
	0X030A, 0X0001,
	0X0308, 0X0008,
	0X0342, 0X27B0,
	0X0340, 0X0C4D,
	0X021E, 0X0000,
	0X3098, 0X0300,
	0X309A, 0X0102,
	0X30BC, 0X0131,
	0X30A8, 0X0000,
	0X30AC, 0X0000,
	0X30A0, 0X0001,
	0X30A4, 0X017A,
	0XF41E, 0X2180,
	0X6028, 0X2000,
	0X602A, 0X0990,
	0X6F12, 0X0040,
	0X602A, 0X27A8,
	0X6F12, 0X0000,
	0X602A, 0X09AA,
	0X6F12, 0X1E7F,
	0X6F12, 0X1E7F,
	0X602A, 0X16B6,
	0X6F12, 0X12AF,
	0X6F12, 0X0328,
	0X602A, 0X1688,
	0X6F12, 0X00A0,
	0X602A, 0X168C,
	0X6F12, 0X0028,
	0X6F12, 0X0030,
	0X6F12, 0X0C18,
	0X6F12, 0X0C18,
	0X6F12, 0X0C28,
	0X6F12, 0X0C28,
	0X6F12, 0X0C20,
	0X6F12, 0X0C20,
	0X6F12, 0X0C30,
	0X6F12, 0X0C30,
	0X602A, 0X15F4,
	0X6F12, 0X0004,
	0X602A, 0X16BE,
	0X6F12, 0X06C0,
	0X6F12, 0X0101,
	0X602A, 0X0B16,
	0X6F12, 0X0100,
	0X602A, 0X11D2,
	0X6F12, 0X0258,
	0X602A, 0X127A,
	0X6F12, 0X01B5,
	0X602A, 0X1282,
	0X6F12, 0X01BF,
	0X602A, 0X128A,
	0X6F12, 0X01C9,
	0X602A, 0X1292,
	0X6F12, 0X01D3,
	0X602A, 0X129A,
	0X6F12, 0X01DD,
	0X602A, 0X12A2,
	0X6F12, 0X01E7,
	0X602A, 0X12AA,
	0X6F12, 0X01F1,
	0X602A, 0X12B2,
	0X6F12, 0X01FB,
	0X602A, 0X12BA,
	0X6F12, 0X0205,
	0X602A, 0X12C2,
	0X6F12, 0X020F,
	0X602A, 0X12CA,
	0X6F12, 0X0219,
	0X602A, 0X12D2,
	0X6F12, 0X0223,
	0X602A, 0X12DA,
	0X6F12, 0X022D,
	0X602A, 0X12E2,
	0X6F12, 0X0237,
	0X602A, 0X12EA,
	0X6F12, 0X0241,
	0X602A, 0X12F2,
	0X6F12, 0X024B,
	0X602A, 0X12FA,
	0X6F12, 0X0255,
	0X602A, 0X1302,
	0X6F12, 0X025F,
	0X602A, 0X130A,
	0X6F12, 0X0269,
	0X602A, 0X1312,
	0X6F12, 0X0273,
	0X602A, 0X131A,
	0X6F12, 0X027D,
	0X602A, 0X1322,
	0X6F12, 0X0287,
	0X602A, 0X132A,
	0X6F12, 0X0291,
	0X602A, 0X1332,
	0X6F12, 0X029B,
	0X602A, 0X133A,
	0X6F12, 0X01B0,
	0X602A, 0X1342,
	0X6F12, 0X01C4,
	0X602A, 0X134A,
	0X6F12, 0X01D8,
	0X602A, 0X1352,
	0X6F12, 0X01EC,
	0X602A, 0X135A,
	0X6F12, 0X0200,
	0X602A, 0X1362,
	0X6F12, 0X0214,
	0X602A, 0X136A,
	0X6F12, 0X0228,
	0X602A, 0X1372,
	0X6F12, 0X023C,
	0X602A, 0X137A,
	0X6F12, 0X0250,
	0X602A, 0X1382,
	0X6F12, 0X0264,
	0X602A, 0X138A,
	0X6F12, 0X0278,
	0X602A, 0X1392,
	0X6F12, 0X028C,
	0X602A, 0X139A,
	0X6F12, 0X02A0,
	0X602A, 0X14BA,
	0X6F12, 0X0096,
	0X602A, 0X0C22,
	0X6F12, 0X000A,
	0X602A, 0X15DC,
	0X6F12, 0X0001,
	0X602A, 0X0A94,
	0X6F12, 0X1000,
	0X602A, 0X0B62,
	0X6F12, 0X0146,
	0X602A, 0X8B2C,
	0X6F12, 0X0008,
	0X602A, 0X5150,
	0X6F12, 0X0100,
	0X602A, 0X0AE6,
	0X6F12, 0X0BE0,
	0X602A, 0X29D8,
	0X6F12, 0X0BE0,
	0X602A, 0X29E2,
	0X6F12, 0X0BE0,
	0X602A, 0X2958,
	0X6F12, 0X0BE0,
	0X602A, 0X2998,
	0X6F12, 0X0BE0,
	0X602A, 0X2962,
	0X6F12, 0X0BE0,
	0X602A, 0X29A2,
	0X6F12, 0X0BE0,
	0X602A, 0X5684,
	0X6F12, 0XFFC0,
	0X602A, 0X568C,
	0X6F12, 0X010A,
	0X6F12, 0X0000,
	0X6F12, 0X0240,
	0X6F12, 0X0000,
	0X602A, 0X56C8,
	0X6F12, 0XFFC0,
	0X602A, 0X56D0,
	0X6F12, 0X010A,
	0X6F12, 0X0000,
	0X6F12, 0X0240,
	0X6F12, 0X0000,
	0X6028, 0X4000,
	0X6214, 0X79F0,
	0X6218, 0X79F0,
	0X6028, 0X4000
};


/*****************************************************************************
 *
 * Description:
 * ------------
 *     mode 3 capture setting
 *     M3 setting, RZ8_V1.0settings
 *     Full 30fps
 *
 ****************************************************************************/
kal_uint16 addr_data_pair_capture_2l7_m3[] = {
	0X6028, 0X4000,
	0X6214, 0X7970,
	0X6218, 0X7150,
	0X0344, 0X0000,
	0X0346, 0X0000,
	0X0348, 0X1F7F,
	0X034A, 0X0BDF,
	0X034C, 0X0FC0,
	0X034E, 0X0BD0,
	0X0408, 0X0000,
	0X040A, 0X0008,
	0X0900, 0X0011,
	0X0380, 0X0001,
	0X0382, 0X0001,
	0X0384, 0X0001,
	0X0386, 0X0001,
	0X0400, 0X0000,
	0X0404, 0X0010,
	0X3060, 0X0100,
	0X0114, 0X0300,
	0X0110, 0X1002,
	0X0136, 0X1800,
	0X0304, 0X0006,
	0X0306, 0X01E0,
	0X0302, 0X0001,
	0X0300, 0X0004,
	0X030C, 0X0001,
	0X030E, 0X0004,
	0X0310, 0X00D9,
	0X0312, 0X0000,
	0X030A, 0X0001,
	0X0308, 0X0008,
	0X0342, 0X27B0,
	0X0340, 0X0C4D,
	0X021E, 0X0000,
	0X3098, 0X0300,
	0X309A, 0X0102,
	0X30BC, 0X0131,
	0X30A8, 0X0002,
	0X30AC, 0X02F4,
	0X30A0, 0X0000,
	0X30A4, 0X0000,
	0XF41E, 0X2180,
	0X6028, 0X2000,
	0X602A, 0X0990,
	0X6F12, 0X0040,
	0X602A, 0X27A8,
	0X6F12, 0X0100,
	0X602A, 0X09AA,
	0X6F12, 0X1E7F,
	0X6F12, 0X1E7F,
	0X602A, 0X16B6,
	0X6F12, 0X122F,
	0X6F12, 0X4328,
	0X602A, 0X1688,
	0X6F12, 0X00A2,
	0X602A, 0X168C,
	0X6F12, 0X0028,
	0X6F12, 0X0030,
	0X6F12, 0X0C18,
	0X6F12, 0X0C18,
	0X6F12, 0X0C28,
	0X6F12, 0X0C28,
	0X6F12, 0X0C20,
	0X6F12, 0X0C20,
	0X6F12, 0X0C30,
	0X6F12, 0X0C30,
	0X602A, 0X15F4,
	0X6F12, 0X0004,
	0X602A, 0X16BE,
	0X6F12, 0X06C0,
	0X6F12, 0X0101,
	0X602A, 0X0B16,
	0X6F12, 0X0200,
	0X602A, 0X11D2,
	0X6F12, 0X0258,
	0X602A, 0X127A,
	0X6F12, 0X01B5,
	0X602A, 0X1282,
	0X6F12, 0X01BF,
	0X602A, 0X128A,
	0X6F12, 0X01C9,
	0X602A, 0X1292,
	0X6F12, 0X01D3,
	0X602A, 0X129A,
	0X6F12, 0X01DD,
	0X602A, 0X12A2,
	0X6F12, 0X01E7,
	0X602A, 0X12AA,
	0X6F12, 0X01F1,
	0X602A, 0X12B2,
	0X6F12, 0X01FB,
	0X602A, 0X12BA,
	0X6F12, 0X0205,
	0X602A, 0X12C2,
	0X6F12, 0X020F,
	0X602A, 0X12CA,
	0X6F12, 0X0219,
	0X602A, 0X12D2,
	0X6F12, 0X0223,
	0X602A, 0X12DA,
	0X6F12, 0X022D,
	0X602A, 0X12E2,
	0X6F12, 0X0237,
	0X602A, 0X12EA,
	0X6F12, 0X0241,
	0X602A, 0X12F2,
	0X6F12, 0X024B,
	0X602A, 0X12FA,
	0X6F12, 0X0255,
	0X602A, 0X1302,
	0X6F12, 0X025F,
	0X602A, 0X130A,
	0X6F12, 0X0269,
	0X602A, 0X1312,
	0X6F12, 0X0273,
	0X602A, 0X131A,
	0X6F12, 0X027D,
	0X602A, 0X1322,
	0X6F12, 0X0287,
	0X602A, 0X132A,
	0X6F12, 0X0291,
	0X602A, 0X1332,
	0X6F12, 0X029B,
	0X602A, 0X133A,
	0X6F12, 0X01B0,
	0X602A, 0X1342,
	0X6F12, 0X01C4,
	0X602A, 0X134A,
	0X6F12, 0X01D8,
	0X602A, 0X1352,
	0X6F12, 0X01EC,
	0X602A, 0X135A,
	0X6F12, 0X0200,
	0X602A, 0X1362,
	0X6F12, 0X0214,
	0X602A, 0X136A,
	0X6F12, 0X0228,
	0X602A, 0X1372,
	0X6F12, 0X023C,
	0X602A, 0X137A,
	0X6F12, 0X0250,
	0X602A, 0X1382,
	0X6F12, 0X0264,
	0X602A, 0X138A,
	0X6F12, 0X0278,
	0X602A, 0X1392,
	0X6F12, 0X028C,
	0X602A, 0X139A,
	0X6F12, 0X02A0,
	0X602A, 0X14BA,
	0X6F12, 0X0096,
	0X602A, 0X0C22,
	0X6F12, 0X000A,
	0X602A, 0X15DC,
	0X6F12, 0X0001,
	0X602A, 0X0A94,
	0X6F12, 0X2000,
	0X602A, 0X0B62,
	0X6F12, 0X0146,
	0X602A, 0X8B2C,
	0X6F12, 0X0008,
	0X602A, 0X5150,
	0X6F12, 0X0000,
	0X602A, 0X0AE6,
	0X6F12, 0X0BE0,
	0X602A, 0X29D8,
	0X6F12, 0X0BE0,
	0X602A, 0X29E2,
	0X6F12, 0X0BE0,
	0X602A, 0X2958,
	0X6F12, 0X0BE0,
	0X602A, 0X2998,
	0X6F12, 0X0BE0,
	0X602A, 0X2962,
	0X6F12, 0X0BE0,
	0X602A, 0X29A2,
	0X6F12, 0X0BE0,
	0X602A, 0X5684,
	0X6F12, 0XFFC0,
	0X602A, 0X568C,
	0X6F12, 0X010A,
	0X6F12, 0X0000,
	0X6F12, 0X0240,
	0X6F12, 0X0000,
	0X602A, 0X56C8,
	0X6F12, 0XFFC0,
	0X602A, 0X56D0,
	0X6F12, 0X010A,
	0X6F12, 0X0000,
	0X6F12, 0X0240,
	0X6F12, 0X0000,
	0X6028, 0X4000,
	0X6214, 0X79F0,
	0X6218, 0X79F0,
	0X6028, 0X4000
};


/*****************************************************************************
 *
 * Description:
 * ------------
 *     mode 3 high speed video setting
 *     M3 setting, RZ8_V1.0settings
 *     Slim 30fps
 *
 ****************************************************************************/
kal_uint16 addr_data_pair_hs_2l7_m3[] = {
	0X6028, 0X4000,
	0X6214, 0X7970,
	0X6218, 0X7150,
	0X0344, 0X0000,
	0X0346, 0X016E,
	0X0348, 0X1F7F,
	0X034A, 0X0A61,
	0X034C, 0X0540,
	0X034E, 0X02F4,
	0X0408, 0X0000,
	0X040A, 0X0004,
	0X0900, 0X0113,
	0X0380, 0X0001,
	0X0382, 0X0001,
	0X0384, 0X0001,
	0X0386, 0X0005,
	0X0400, 0X0000,
	0X0404, 0X0010,
	0X3060, 0X0103,
	0X0114, 0X0300,
	0X0110, 0X1002,
	0X0136, 0X1800,
	0X0304, 0X0006,
	0X0306, 0X01E0,
	0X0302, 0X0001,
	0X0300, 0X0004,
	0X030C, 0X0001,
	0X030E, 0X0004,
	0X0310, 0X012C,
	0X0312, 0X0001,
	0X030A, 0X0001,
	0X0308, 0X0008,
	0X0342, 0X1E60,
	0X0340, 0X0404,
	0X021E, 0X0000,
	0X3098, 0X0300,
	0X309A, 0X0102,
	0X30BC, 0X0131,
	0X30A8, 0X0001,
	0X30AC, 0X00BD,
	0X30A0, 0X0000,
	0X30A4, 0X0000,
	0XF41E, 0X2100,
	0X6028, 0X2000,
	0X602A, 0X0990,
	0X6F12, 0X0040,
	0X602A, 0X27A8,
	0X6F12, 0X0000,
	0X602A, 0X09AA,
	0X6F12, 0X0F7F,
	0X6F12, 0X0F7F,
	0X602A, 0X16B6,
	0X6F12, 0X122F,
	0X6F12, 0X0328,
	0X602A, 0X1688,
	0X6F12, 0X00A0,
	0X602A, 0X168C,
	0X6F12, 0X0028,
	0X6F12, 0X0034,
	0X6F12, 0X0C16,
	0X6F12, 0X0C16,
	0X6F12, 0X0C1C,
	0X6F12, 0X0C1C,
	0X6F12, 0X0C22,
	0X6F12, 0X0C22,
	0X6F12, 0X0C28,
	0X6F12, 0X0C28,
	0X602A, 0X15F4,
	0X6F12, 0X0104,
	0X602A, 0X16BE,
	0X6F12, 0X0800,
	0X6F12, 0X0201,
	0X602A, 0X0B16,
	0X6F12, 0X0100,
	0X602A, 0X11D2,
	0X6F12, 0X022C,
	0X602A, 0X127A,
	0X6F12, 0X0129,
	0X602A, 0X1282,
	0X6F12, 0X0133,
	0X602A, 0X128A,
	0X6F12, 0X013D,
	0X602A, 0X1292,
	0X6F12, 0X0147,
	0X602A, 0X129A,
	0X6F12, 0X0151,
	0X602A, 0X12A2,
	0X6F12, 0X015B,
	0X602A, 0X12AA,
	0X6F12, 0X0165,
	0X602A, 0X12B2,
	0X6F12, 0X016F,
	0X602A, 0X12BA,
	0X6F12, 0X0179,
	0X602A, 0X12C2,
	0X6F12, 0X0183,
	0X602A, 0X12CA,
	0X6F12, 0X018D,
	0X602A, 0X12D2,
	0X6F12, 0X0197,
	0X602A, 0X12DA,
	0X6F12, 0X01A1,
	0X602A, 0X12E2,
	0X6F12, 0X01AB,
	0X602A, 0X12EA,
	0X6F12, 0X01B5,
	0X602A, 0X12F2,
	0X6F12, 0X01BF,
	0X602A, 0X12FA,
	0X6F12, 0X01C9,
	0X602A, 0X1302,
	0X6F12, 0X01D3,
	0X602A, 0X130A,
	0X6F12, 0X01DD,
	0X602A, 0X1312,
	0X6F12, 0X01E7,
	0X602A, 0X131A,
	0X6F12, 0X01F1,
	0X602A, 0X1322,
	0X6F12, 0X01FB,
	0X602A, 0X132A,
	0X6F12, 0X0205,
	0X602A, 0X1332,
	0X6F12, 0X020F,
	0X602A, 0X133A,
	0X6F12, 0X0124,
	0X602A, 0X1342,
	0X6F12, 0X0138,
	0X602A, 0X134A,
	0X6F12, 0X014C,
	0X602A, 0X1352,
	0X6F12, 0X0160,
	0X602A, 0X135A,
	0X6F12, 0X0174,
	0X602A, 0X1362,
	0X6F12, 0X0188,
	0X602A, 0X136A,
	0X6F12, 0X019C,
	0X602A, 0X1372,
	0X6F12, 0X01B0,
	0X602A, 0X137A,
	0X6F12, 0X01C4,
	0X602A, 0X1382,
	0X6F12, 0X01D8,
	0X602A, 0X138A,
	0X6F12, 0X01EC,
	0X602A, 0X1392,
	0X6F12, 0X0200,
	0X602A, 0X139A,
	0X6F12, 0X0214,
	0X602A, 0X14BA,
	0X6F12, 0X027C,
	0X602A, 0X0C22,
	0X6F12, 0X0009,
	0X602A, 0X15DC,
	0X6F12, 0X0006,
	0X602A, 0X0A94,
	0X6F12, 0X0800,
	0X602A, 0X0B62,
	0X6F12, 0X0126,
	0X602A, 0X8B2C,
	0X6F12, 0X000C,
	0X602A, 0X5150,
	0X6F12, 0X0100,
	0X602A, 0X0AE6,
	0X6F12, 0X0BD0,
	0X602A, 0X29D8,
	0X6F12, 0X0BD0,
	0X602A, 0X29E2,
	0X6F12, 0X0BD0,
	0X602A, 0X2958,
	0X6F12, 0X0BD0,
	0X602A, 0X2998,
	0X6F12, 0X0BD0,
	0X602A, 0X2962,
	0X6F12, 0X0BD0,
	0X602A, 0X29A2,
	0X6F12, 0X0BD0,
	0X602A, 0X5684,
	0X6F12, 0XFFC0,
	0X602A, 0X568C,
	0X6F12, 0X010A,
	0X6F12, 0X0000,
	0X6F12, 0X0240,
	0X6F12, 0X0000,
	0X602A, 0X56C8,
	0X6F12, 0XFFC0,
	0X602A, 0X56D0,
	0X6F12, 0X010A,
	0X6F12, 0X0000,
	0X6F12, 0X0240,
	0X6F12, 0X0000,
	0X6028, 0X4000,
	0X6214, 0X79F0,
	0X6218, 0X79F0,
	0X6028, 0X4000
};

/*****************************************************************************
 *
 * Description:
 * ------------
 *     mode 3 slim video setting
 *     M3 setting, RZ8_V1.0settings
 *     Slim 30fps
 *
 ****************************************************************************/
kal_uint16 addr_data_pair_slim_2l7_m3[] = {
	0X6028, 0X4000,
	0X6214, 0X7970,
	0X6218, 0X7150,
	0X0344, 0X0000,
	0X0346, 0X016E,
	0X0348, 0X1F7F,
	0X034A, 0X0A61,
	0X034C, 0X0540,
	0X034E, 0X02F4,
	0X0408, 0X0000,
	0X040A, 0X0004,
	0X0900, 0X0113,
	0X0380, 0X0001,
	0X0382, 0X0001,
	0X0384, 0X0001,
	0X0386, 0X0005,
	0X0400, 0X0000,
	0X0404, 0X0010,
	0X3060, 0X0103,
	0X0114, 0X0300,
	0X0110, 0X1002,
	0X0136, 0X1800,
	0X0304, 0X0006,
	0X0306, 0X01E0,
	0X0302, 0X0001,
	0X0300, 0X0004,
	0X030C, 0X0001,
	0X030E, 0X0004,
	0X0310, 0X012C,
	0X0312, 0X0001,
	0X030A, 0X0001,
	0X0308, 0X0008,
	0X0342, 0X1E60,
	0X0340, 0X100F,
	0X021E, 0X0000,
	0X3098, 0X0300,
	0X309A, 0X0102,
	0X30BC, 0X0131,
	0X30A8, 0X0001,
	0X30AC, 0X00BD,
	0X30A0, 0X0000,
	0X30A4, 0X0000,
	0XF41E, 0X2100,
	0X6028, 0X2000,
	0X602A, 0X0990,
	0X6F12, 0X0040,
	0X602A, 0X27A8,
	0X6F12, 0X0000,
	0X602A, 0X09AA,
	0X6F12, 0X0F7F,
	0X6F12, 0X0F7F,
	0X602A, 0X16B6,
	0X6F12, 0X122F,
	0X6F12, 0X0328,
	0X602A, 0X1688,
	0X6F12, 0X00A0,
	0X602A, 0X168C,
	0X6F12, 0X0028,
	0X6F12, 0X0034,
	0X6F12, 0X0C16,
	0X6F12, 0X0C16,
	0X6F12, 0X0C1C,
	0X6F12, 0X0C1C,
	0X6F12, 0X0C22,
	0X6F12, 0X0C22,
	0X6F12, 0X0C28,
	0X6F12, 0X0C28,
	0X602A, 0X15F4,
	0X6F12, 0X0104,
	0X602A, 0X16BE,
	0X6F12, 0X0800,
	0X6F12, 0X0201,
	0X602A, 0X0B16,
	0X6F12, 0X0100,
	0X602A, 0X11D2,
	0X6F12, 0X022C,
	0X602A, 0X127A,
	0X6F12, 0X0129,
	0X602A, 0X1282,
	0X6F12, 0X0133,
	0X602A, 0X128A,
	0X6F12, 0X013D,
	0X602A, 0X1292,
	0X6F12, 0X0147,
	0X602A, 0X129A,
	0X6F12, 0X0151,
	0X602A, 0X12A2,
	0X6F12, 0X015B,
	0X602A, 0X12AA,
	0X6F12, 0X0165,
	0X602A, 0X12B2,
	0X6F12, 0X016F,
	0X602A, 0X12BA,
	0X6F12, 0X0179,
	0X602A, 0X12C2,
	0X6F12, 0X0183,
	0X602A, 0X12CA,
	0X6F12, 0X018D,
	0X602A, 0X12D2,
	0X6F12, 0X0197,
	0X602A, 0X12DA,
	0X6F12, 0X01A1,
	0X602A, 0X12E2,
	0X6F12, 0X01AB,
	0X602A, 0X12EA,
	0X6F12, 0X01B5,
	0X602A, 0X12F2,
	0X6F12, 0X01BF,
	0X602A, 0X12FA,
	0X6F12, 0X01C9,
	0X602A, 0X1302,
	0X6F12, 0X01D3,
	0X602A, 0X130A,
	0X6F12, 0X01DD,
	0X602A, 0X1312,
	0X6F12, 0X01E7,
	0X602A, 0X131A,
	0X6F12, 0X01F1,
	0X602A, 0X1322,
	0X6F12, 0X01FB,
	0X602A, 0X132A,
	0X6F12, 0X0205,
	0X602A, 0X1332,
	0X6F12, 0X020F,
	0X602A, 0X133A,
	0X6F12, 0X0124,
	0X602A, 0X1342,
	0X6F12, 0X0138,
	0X602A, 0X134A,
	0X6F12, 0X014C,
	0X602A, 0X1352,
	0X6F12, 0X0160,
	0X602A, 0X135A,
	0X6F12, 0X0174,
	0X602A, 0X1362,
	0X6F12, 0X0188,
	0X602A, 0X136A,
	0X6F12, 0X019C,
	0X602A, 0X1372,
	0X6F12, 0X01B0,
	0X602A, 0X137A,
	0X6F12, 0X01C4,
	0X602A, 0X1382,
	0X6F12, 0X01D8,
	0X602A, 0X138A,
	0X6F12, 0X01EC,
	0X602A, 0X1392,
	0X6F12, 0X0200,
	0X602A, 0X139A,
	0X6F12, 0X0214,
	0X602A, 0X14BA,
	0X6F12, 0X027C,
	0X602A, 0X0C22,
	0X6F12, 0X0009,
	0X602A, 0X15DC,
	0X6F12, 0X0006,
	0X602A, 0X0A94,
	0X6F12, 0X0800,
	0X602A, 0X0B62,
	0X6F12, 0X0126,
	0X602A, 0X8B2C,
	0X6F12, 0X000C,
	0X602A, 0X5150,
	0X6F12, 0X0100,
	0X602A, 0X0AE6,
	0X6F12, 0X0BD0,
	0X602A, 0X29D8,
	0X6F12, 0X0BD0,
	0X602A, 0X29E2,
	0X6F12, 0X0BD0,
	0X602A, 0X2958,
	0X6F12, 0X0BD0,
	0X602A, 0X2998,
	0X6F12, 0X0BD0,
	0X602A, 0X2962,
	0X6F12, 0X0BD0,
	0X602A, 0X29A2,
	0X6F12, 0X0BD0,
	0X602A, 0X5684,
	0X6F12, 0XFFC0,
	0X602A, 0X568C,
	0X6F12, 0X010A,
	0X6F12, 0X0000,
	0X6F12, 0X0240,
	0X6F12, 0X0000,
	0X602A, 0X56C8,
	0X6F12, 0XFFC0,
	0X602A, 0X56D0,
	0X6F12, 0X010A,
	0X6F12, 0X0000,
	0X6F12, 0X0240,
	0X6F12, 0X0000,
	0X6028, 0X4000,
	0X6214, 0X79F0,
	0X6218, 0X79F0,
	0X6028, 0X4000
};

/*****************************************************************************
 *
 * Description:
 * ------------
 *     mode 3 cpature with WDR setting
 *     M3 setting, RZ8_V1.0settings
 *     Full 30fps
 *
 ****************************************************************************/
kal_uint16 addr_data_pair_capture_wdr_2l7_m3[] = {
	0X6028, 0X4000,
	0X6214, 0X7970,
	0X6218, 0X7150,
	0X0344, 0X0000,
	0X0346, 0X0000,
	0X0348, 0X1F7F,
	0X034A, 0X0BDF,
	0X034C, 0X0FC0,
	0X034E, 0X0BD0,
	0X0408, 0X0000,
	0X040A, 0X0008,
	0X0900, 0X0011,
	0X0380, 0X0001,
	0X0382, 0X0001,
	0X0384, 0X0001,
	0X0386, 0X0001,
	0X0400, 0X0000,
	0X0404, 0X0010,
	0X3060, 0X0100,
	0X0114, 0X0300,
	0X0110, 0X1002,
	0X0136, 0X1800,
	0X0304, 0X0006,
	0X0306, 0X01E0,
	0X0302, 0X0001,
	0X0300, 0X0004,
	0X030C, 0X0001,
	0X030E, 0X0004,
	0X0310, 0X00D9,
	0X0312, 0X0000,
	0X030A, 0X0001,
	0X0308, 0X0008,
	0X0342, 0X27B0,
	0X0340, 0X0C4D,
	0X021E, 0X0000,
	0X3098, 0X0300,
	0X309A, 0X0102,
	0X30BC, 0X0131,
	0X30A8, 0X0002,
	0X30AC, 0X02F4,
	0X30A0, 0X0000,
	0X30A4, 0X0000,
	0XF41E, 0X2180,
	0X6028, 0X2000,
	0X602A, 0X0990,
	0X6F12, 0X0040,
	0X602A, 0X0AF8,
	0X6F12, 0X0004,
	0X602A, 0X27A8,
	0X6F12, 0X0100,
	0X602A, 0X09AA,
	0X6F12, 0X1E7F,
	0X6F12, 0X1E7F,
	0X602A, 0X16B6,
	0X6F12, 0X122F,
	0X6F12, 0X4328,
	0X602A, 0X1688,
	0X6F12, 0X00A2,
	0X602A, 0X168C,
	0X6F12, 0X0028,
	0X6F12, 0X0030,
	0X6F12, 0X0C18,
	0X6F12, 0X0C18,
	0X6F12, 0X0C28,
	0X6F12, 0X0C28,
	0X6F12, 0X0C20,
	0X6F12, 0X0C20,
	0X6F12, 0X0C30,
	0X6F12, 0X0C30,
	0X602A, 0X15F4,
	0X6F12, 0X0004,
	0X602A, 0X16BE,
	0X6F12, 0X06C0,
	0X6F12, 0X0101,
	0X602A, 0X0B16,
	0X6F12, 0X0200,
	0X602A, 0X11D2,
	0X6F12, 0X0258,
	0X602A, 0X127A,
	0X6F12, 0X01B5,
	0X602A, 0X1282,
	0X6F12, 0X01BF,
	0X602A, 0X128A,
	0X6F12, 0X01C9,
	0X602A, 0X1292,
	0X6F12, 0X01D3,
	0X602A, 0X129A,
	0X6F12, 0X01DD,
	0X602A, 0X12A2,
	0X6F12, 0X01E7,
	0X602A, 0X12AA,
	0X6F12, 0X01F1,
	0X602A, 0X12B2,
	0X6F12, 0X01FB,
	0X602A, 0X12BA,
	0X6F12, 0X0205,
	0X602A, 0X12C2,
	0X6F12, 0X020F,
	0X602A, 0X12CA,
	0X6F12, 0X0219,
	0X602A, 0X12D2,
	0X6F12, 0X0223,
	0X602A, 0X12DA,
	0X6F12, 0X022D,
	0X602A, 0X12E2,
	0X6F12, 0X0237,
	0X602A, 0X12EA,
	0X6F12, 0X0241,
	0X602A, 0X12F2,
	0X6F12, 0X024B,
	0X602A, 0X12FA,
	0X6F12, 0X0255,
	0X602A, 0X1302,
	0X6F12, 0X025F,
	0X602A, 0X130A,
	0X6F12, 0X0269,
	0X602A, 0X1312,
	0X6F12, 0X0273,
	0X602A, 0X131A,
	0X6F12, 0X027D,
	0X602A, 0X1322,
	0X6F12, 0X0287,
	0X602A, 0X132A,
	0X6F12, 0X0291,
	0X602A, 0X1332,
	0X6F12, 0X029B,
	0X602A, 0X133A,
	0X6F12, 0X01B0,
	0X602A, 0X1342,
	0X6F12, 0X01C4,
	0X602A, 0X134A,
	0X6F12, 0X01D8,
	0X602A, 0X1352,
	0X6F12, 0X01EC,
	0X602A, 0X135A,
	0X6F12, 0X0200,
	0X602A, 0X1362,
	0X6F12, 0X0214,
	0X602A, 0X136A,
	0X6F12, 0X0228,
	0X602A, 0X1372,
	0X6F12, 0X023C,
	0X602A, 0X137A,
	0X6F12, 0X0250,
	0X602A, 0X1382,
	0X6F12, 0X0264,
	0X602A, 0X138A,
	0X6F12, 0X0278,
	0X602A, 0X1392,
	0X6F12, 0X028C,
	0X602A, 0X139A,
	0X6F12, 0X02A0,
	0X602A, 0X14BA,
	0X6F12, 0X0096,
	0X602A, 0X0C22,
	0X6F12, 0X000A,
	0X602A, 0X15DC,
	0X6F12, 0X0001,
	0X602A, 0X0A94,
	0X6F12, 0X2000,
	0X602A, 0X0B62,
	0X6F12, 0X0146,
	0X602A, 0X8B2C,
	0X6F12, 0X0008,
	0X602A, 0X5150,
	0X6F12, 0X0000,
	0X602A, 0X0AE6,
	0X6F12, 0X0BE0,
	0X602A, 0X29D8,
	0X6F12, 0X0BE0,
	0X602A, 0X29E2,
	0X6F12, 0X0BE0,
	0X602A, 0X2958,
	0X6F12, 0X0BE0,
	0X602A, 0X2998,
	0X6F12, 0X0BE0,
	0X602A, 0X2962,
	0X6F12, 0X0BE0,
	0X602A, 0X29A2,
	0X6F12, 0X0BE0,
	0X6028, 0X4000,
	0X6214, 0X79F0,
	0X6218, 0X79F0
};

#define _S5K2L7_MODE3_INIT_ do { \
	table_write_cmos_sensor(addr_data_pair_init_2l7_m3, \
		sizeof(addr_data_pair_init_2l7_m3)/sizeof(kal_uint16)); \
	sensor_WDR_zhdr();\
} while (0)


#define _S5K2L7_MODE3_PREVIEW_ do { \
	table_write_cmos_sensor(addr_data_pair_preview_2l7_m3, \
		sizeof(addr_data_pair_preview_2l7_m3)/sizeof(kal_uint16)); \
	sensor_WDR_zhdr();\
} while (0)

#define _S5K2L7_MODE3_CAPTURE_ do { \
	table_write_cmos_sensor(addr_data_pair_capture_2l7_m3, \
		sizeof(addr_data_pair_capture_2l7_m3)/sizeof(kal_uint16)); \
	sensor_WDR_zhdr();\
} while (0)

#define _S5K2L7_MODE3_HS_VIDEO_ do { \
	table_write_cmos_sensor(addr_data_pair_hs_2l7_m3, \
		sizeof(addr_data_pair_hs_2l7_m3)/sizeof(kal_uint16)); \
	sensor_WDR_zhdr();\
} while (0)

#define _S5K2L7_MODE3_SLIM_VIDEO_ do { \
	table_write_cmos_sensor(addr_data_pair_slim_2l7_m3, \
		sizeof(addr_data_pair_slim_2l7_m3)/sizeof(kal_uint16)); \
	sensor_WDR_zhdr();\
} while (0)

#define _S5K2L7_MODE3_CAPTURE_WDR_ do { \
	table_write_cmos_sensor(addr_data_pair_capture_wdr_2l7_m3, \
		sizeof(addr_data_pair_capture_wdr_2l7_m3)/sizeof(kal_uint16)); \
	sensor_WDR_zhdr();\
} while (0)
#endif
