/*
 * Copyright (C) 2017 MediaTek Inc.

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#ifndef _MT_PMIC_UPMU_HW_H_
#define _MT_PMIC_UPMU_HW_H_

#define PMU_FLAG_TABLE_ENTRY struct pmu_flag_table_entry_t
#define PMU_FLAGS_LIST_ENUM enum PMU_FLAGS_LIST

#define MT6356_PMIC_REG_BASE (0x0)

#define MT6356_TOP0_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x0))
#define MT6356_TOP0_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2))
#define MT6356_TOP0_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4))
#define MT6356_HWCID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6))
#define MT6356_SWCID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8))
#define MT6356_PONSTS ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa))
#define MT6356_POFFSTS ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc))
#define MT6356_PSTSCTL ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe))
#define MT6356_PG_DEB_STS0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x10))
#define MT6356_PG_DEB_STS1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12))
#define MT6356_PG_SDN_STS0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14))
#define MT6356_PG_SDN_STS1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16))
#define MT6356_OC_SDN_STS0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x18))
#define MT6356_THERMALSTATUS ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1a))
#define MT6356_TOP_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1c))
#define MT6356_TEST_OUT ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1e))
#define MT6356_TEST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x20))
#define MT6356_TEST_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x22))
#define MT6356_TESTMODE_SW ((unsigned int)(MT6356_PMIC_REG_BASE + 0x24))
#define MT6356_TOPSTATUS ((unsigned int)(MT6356_PMIC_REG_BASE + 0x26))
#define MT6356_TDSEL_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0x28))
#define MT6356_RDSEL_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2a))
#define MT6356_SMT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2c))
#define MT6356_SMT_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2e))
#define MT6356_TOP_RSV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x30))
#define MT6356_TOP_RSV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x32))
#define MT6356_DRV_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x34))
#define MT6356_DRV_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x36))
#define MT6356_DRV_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x38))
#define MT6356_DRV_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3a))
#define MT6356_FILTER_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3c))
#define MT6356_FILTER_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3e))
#define MT6356_FILTER_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x40))
#define MT6356_FILTER_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x42))
#define MT6356_TOP_STATUS ((unsigned int)(MT6356_PMIC_REG_BASE + 0x44))
#define MT6356_TOP_STATUS_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x46))
#define MT6356_TOP_STATUS_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x48))
#define MT6356_TOP_TRAP ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4a))
#define MT6356_GPIO_DIR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4c))
#define MT6356_GPIO_DIR0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4e))
#define MT6356_GPIO_DIR0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x50))
#define MT6356_GPIO_PULLEN0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x52))
#define MT6356_GPIO_PULLEN0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x54))
#define MT6356_GPIO_PULLEN0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x56))
#define MT6356_GPIO_PULLSEL0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x58))
#define MT6356_GPIO_PULLSEL0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x5a))
#define MT6356_GPIO_PULLSEL0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x5c))
#define MT6356_GPIO_DINV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x5e))
#define MT6356_GPIO_DINV0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x60))
#define MT6356_GPIO_DINV0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x62))
#define MT6356_GPIO_DOUT0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x64))
#define MT6356_GPIO_DOUT0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x66))
#define MT6356_GPIO_DOUT0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x68))
#define MT6356_GPIO_PI0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6a))
#define MT6356_GPIO_POE0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6c))
#define MT6356_GPIO_MODE0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6e))
#define MT6356_GPIO_MODE0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x70))
#define MT6356_GPIO_MODE0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x72))
#define MT6356_GPIO_MODE1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x74))
#define MT6356_GPIO_MODE1_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x76))
#define MT6356_GPIO_MODE1_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x78))
#define MT6356_GPIO_MODE2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7a))
#define MT6356_GPIO_MODE2_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7c))
#define MT6356_GPIO_MODE2_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7e))
#define MT6356_GPIO_MODE3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x80))
#define MT6356_GPIO_MODE3_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x82))
#define MT6356_GPIO_MODE3_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x84))
#define MT6356_GPIO_RSV ((unsigned int)(MT6356_PMIC_REG_BASE + 0x86))
#define MT6356_TOP1_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x100))
#define MT6356_TOP1_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x102))
#define MT6356_TOP1_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x104))
#define MT6356_TOP_PAM0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x106))
#define MT6356_TOP_PAM1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x108))
#define MT6356_TOP_CKPDN_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x10a))
#define MT6356_TOP_CKPDN_CON0_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10c))
#define MT6356_TOP_CKPDN_CON0_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10e))
#define MT6356_TOP_CKPDN_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x110))
#define MT6356_TOP_CKPDN_CON1_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x112))
#define MT6356_TOP_CKPDN_CON1_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x114))
#define MT6356_TOP_CKSEL_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x116))
#define MT6356_TOP_CKSEL_CON0_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x118))
#define MT6356_TOP_CKSEL_CON0_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x11a))
#define MT6356_TOP_CKSEL_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x11c))
#define MT6356_TOP_CKSEL_CON1_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x11e))
#define MT6356_TOP_CKSEL_CON1_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x120))
#define MT6356_TOP_CKDIVSEL_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x122))
#define MT6356_TOP_CKDIVSEL_CON0_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x124))
#define MT6356_TOP_CKDIVSEL_CON0_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x126))
#define MT6356_TOP_CKHWEN_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x128))
#define MT6356_TOP_CKHWEN_CON0_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x12a))
#define MT6356_TOP_CKHWEN_CON0_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x12c))
#define MT6356_TOP_CKTST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12e))
#define MT6356_TOP_CKTST_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x130))
#define MT6356_TOP_CLKSQ ((unsigned int)(MT6356_PMIC_REG_BASE + 0x132))
#define MT6356_TOP_CLKSQ_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x134))
#define MT6356_TOP_CLKSQ_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x136))
#define MT6356_TOP_CLKSQ_RTC ((unsigned int)(MT6356_PMIC_REG_BASE + 0x138))
#define MT6356_TOP_CLKSQ_RTC_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13a))
#define MT6356_TOP_CLKSQ_RTC_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13c))
#define MT6356_TOP_CLK_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13e))
#define MT6356_TOP_CLK_CON0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x140))
#define MT6356_TOP_CLK_CON0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x142))
#define MT6356_TOP_DCM_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x144))
#define MT6356_TOP_HANDOVER_DEBUG0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x146))
#define MT6356_TOP_RST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x148))
#define MT6356_TOP_RST_CON0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14a))
#define MT6356_TOP_RST_CON0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14c))
#define MT6356_TOP_RST_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14e))
#define MT6356_TOP_RST_CON1_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x150))
#define MT6356_TOP_RST_CON1_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x152))
#define MT6356_TOP_RST_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x154))
#define MT6356_TOP_RST_MISC ((unsigned int)(MT6356_PMIC_REG_BASE + 0x156))
#define MT6356_TOP_RST_MISC_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x158))
#define MT6356_TOP_RST_MISC_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x15a))
#define MT6356_TOP_RST_STATUS ((unsigned int)(MT6356_PMIC_REG_BASE + 0x15c))
#define MT6356_TOP_RST_STATUS_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15e))
#define MT6356_TOP_RST_STATUS_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x160))
#define MT6356_MISC_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x162))
#define MT6356_MISC_TOP_INT_CON0_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x164))
#define MT6356_MISC_TOP_INT_CON0_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x166))
#define MT6356_MISC_TOP_INT_MASK_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x168))
#define MT6356_MISC_TOP_INT_MASK_CON0_SET                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x16a))
#define MT6356_MISC_TOP_INT_MASK_CON0_CLR                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x16c))
#define MT6356_MISC_TOP_INT_STATUS0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x16e))
#define MT6356_MISC_TOP_INT_RAW_STATUS0                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x170))
#define MT6356_INT_EINT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x172))
#define MT6356_INT_EINT_CON0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x174))
#define MT6356_INT_EINT_CON0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x176))
#define MT6356_INT_EINT_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x178))
#define MT6356_INT_EINT_CON1_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x17a))
#define MT6356_INT_EINT_CON1_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x17c))
#define MT6356_INT_EINT_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x17e))
#define MT6356_INT_EINT_CON2_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x180))
#define MT6356_INT_EINT_CON2_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x182))
#define MT6356_INT_EINT_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x184))
#define MT6356_INT_EINT_CON3_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x186))
#define MT6356_INT_EINT_CON3_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x188))
#define MT6356_INT_EINT_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x18a))
#define MT6356_INT_EINT_CON4_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x18c))
#define MT6356_INT_EINT_CON4_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x18e))
#define MT6356_INT_EINT_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x190))
#define MT6356_INT_EINT_CON5_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x192))
#define MT6356_INT_EINT_CON5_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x194))
#define MT6356_TOP_INT_MASK_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x196))
#define MT6356_TOP_INT_MASK_CON0_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x198))
#define MT6356_TOP_INT_MASK_CON0_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x19a))
#define MT6356_TOP_INT_STATUS0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x19c))
#define MT6356_TOP_INT_RAW_STATUS0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x19e))
#define MT6356_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1a0))
#define MT6356_OTP_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1a2))
#define MT6356_OTP_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1a4))
#define MT6356_OTP_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1a6))
#define MT6356_OTP_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1a8))
#define MT6356_OTP_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1aa))
#define MT6356_OTP_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1ac))
#define MT6356_OTP_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1ae))
#define MT6356_OTP_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1b0))
#define MT6356_OTP_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1b2))
#define MT6356_OTP_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1b4))
#define MT6356_OTP_CON10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1b6))
#define MT6356_OTP_CON11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1b8))
#define MT6356_OTP_CON12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1ba))
#define MT6356_OTP_CON13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1bc))
#define MT6356_OTP_CON14 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1be))
#define MT6356_TOP1_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1c0))
#define MT6356_TOP1_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1c2))
#define MT6356_TOP1_ELR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1c4))
#define MT6356_TOP1_ELR2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1c6))
#define MT6356_TOPA0_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x200))
#define MT6356_TOPA0_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x202))
#define MT6356_TOPA0_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x204))
#define MT6356_FQMTR_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x206))
#define MT6356_FQMTR_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x208))
#define MT6356_FQMTR_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x20a))
#define MT6356_TOP_CLK_TRIM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x20c))
#define MT6356_TOP_MDB_CONF0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x20e))
#define MT6356_TOP_MDB_CONF1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x210))
#define MT6356_TOPA0_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x212))
#define MT6356_TOPA0_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x214))
#define MT6356_SPISLV_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x240))
#define MT6356_SPISLV_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x242))
#define MT6356_SPISLV_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x244))
#define MT6356_RG_SPI_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x246))
#define MT6356_DEW_DIO_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0x248))
#define MT6356_DEW_READ_TEST ((unsigned int)(MT6356_PMIC_REG_BASE + 0x24a))
#define MT6356_DEW_WRITE_TEST ((unsigned int)(MT6356_PMIC_REG_BASE + 0x24c))
#define MT6356_DEW_CRC_SWRST ((unsigned int)(MT6356_PMIC_REG_BASE + 0x24e))
#define MT6356_DEW_CRC_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0x250))
#define MT6356_DEW_CRC_VAL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x252))
#define MT6356_DEW_DBG_MON_SEL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x254))
#define MT6356_DEW_CIPHER_KEY_SEL                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x256))
#define MT6356_DEW_CIPHER_IV_SEL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x258))
#define MT6356_DEW_CIPHER_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0x25a))
#define MT6356_DEW_CIPHER_RDY ((unsigned int)(MT6356_PMIC_REG_BASE + 0x25c))
#define MT6356_DEW_CIPHER_MODE ((unsigned int)(MT6356_PMIC_REG_BASE + 0x25e))
#define MT6356_DEW_CIPHER_SWRST ((unsigned int)(MT6356_PMIC_REG_BASE + 0x260))
#define MT6356_DEW_RDDMY_NO ((unsigned int)(MT6356_PMIC_REG_BASE + 0x262))
#define MT6356_INT_TYPE_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x264))
#define MT6356_INT_TYPE_CON0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x266))
#define MT6356_INT_TYPE_CON0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x268))
#define MT6356_INT_TYPE_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x26a))
#define MT6356_INT_TYPE_CON1_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x26c))
#define MT6356_INT_TYPE_CON1_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x26e))
#define MT6356_INT_TYPE_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x270))
#define MT6356_INT_TYPE_CON2_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x272))
#define MT6356_INT_TYPE_CON2_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x274))
#define MT6356_INT_TYPE_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x276))
#define MT6356_INT_TYPE_CON3_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x278))
#define MT6356_INT_TYPE_CON3_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x27a))
#define MT6356_INT_TYPE_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x27c))
#define MT6356_INT_TYPE_CON4_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x27e))
#define MT6356_INT_TYPE_CON4_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x280))
#define MT6356_INT_TYPE_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x282))
#define MT6356_INT_TYPE_CON5_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x284))
#define MT6356_INT_TYPE_CON5_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x286))
#define MT6356_INT_TYPE_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x288))
#define MT6356_INT_TYPE_CON6_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x28a))
#define MT6356_INT_TYPE_CON6_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x28c))
#define MT6356_INT_STA ((unsigned int)(MT6356_PMIC_REG_BASE + 0x28e))
#define MT6356_RG_SPI_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x290))
#define MT6356_RG_SPI_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x292))
#define MT6356_RG_SPI_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x294))
#define MT6356_RG_SPI_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x296))
#define MT6356_RG_SPI_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x298))
#define MT6356_RG_SPI_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x29a))
#define MT6356_RG_SPI_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x29c))
#define MT6356_RG_SPI_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x29e))
#define MT6356_RG_SPI_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2a0))
#define MT6356_RG_SPI_CON10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2a2))
#define MT6356_RG_SPI_CON11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2a4))
#define MT6356_RG_SPI_CON12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2a6))
#define MT6356_RG_SPI_CON13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2a8))
#define MT6356_TOP_SPI_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2aa))
#define MT6356_TOP_SPI_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2ac))
#define MT6356_PSC_TOP_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2c0))
#define MT6356_PSC_TOP_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2c2))
#define MT6356_PSC_TOP_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2c4))
#define MT6356_PSC_TOP_PAM0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2c6))
#define MT6356_PSC_TOP_PAM1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2c8))
#define MT6356_PSC_TOP_RSTCTL_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2ca))
#define MT6356_PSC_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2cc))
#define MT6356_PSC_TOP_INT_CON0_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2ce))
#define MT6356_PSC_TOP_INT_CON0_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2d0))
#define MT6356_PSC_TOP_INT_MASK_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2d2))
#define MT6356_PSC_TOP_INT_MASK_CON0_SET                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2d4))
#define MT6356_PSC_TOP_INT_MASK_CON0_CLR                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2d6))
#define MT6356_PSC_TOP_INT_STATUS0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2d8))
#define MT6356_PSC_TOP_INT_RAW_STATUS0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2da))
#define MT6356_PSC_TOP_INT_MISC_CON                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2dc))
#define MT6356_PSC_TOP_INT_MISC_CON_SET                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2de))
#define MT6356_PSC_TOP_INT_MISC_CON_CLR                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x2e0))
#define MT6356_PSC_TOP_MON_CTL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x2e2))
#define MT6356_STRUP_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x300))
#define MT6356_STRUP_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x302))
#define MT6356_STRUP_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x304))
#define MT6356_STRUP_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x306))
#define MT6356_STRUP_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x308))
#define MT6356_STRUP_ANA_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x30a))
#define MT6356_STRUP_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x30c))
#define MT6356_STRUP_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x30e))
#define MT6356_PSEQ_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x340))
#define MT6356_PSEQ_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x342))
#define MT6356_PSEQ_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x344))
#define MT6356_PPCCTL0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x346))
#define MT6356_PPCCTL1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x348))
#define MT6356_PPCCTL2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x34a))
#define MT6356_PPCCFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x34c))
#define MT6356_PPCTST0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x34e))
#define MT6356_PPCRSV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x350))
#define MT6356_CPSWKEY ((unsigned int)(MT6356_PMIC_REG_BASE + 0x352))
#define MT6356_CPSCFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x354))
#define MT6356_CPSDSA0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x356))
#define MT6356_CPSDSA1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x358))
#define MT6356_CPSDSA2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x35a))
#define MT6356_CPSDSA3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x35c))
#define MT6356_CPSDSA4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x35e))
#define MT6356_CPSDSA5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x360))
#define MT6356_CPSDSA6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x362))
#define MT6356_CPSDSA7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x364))
#define MT6356_CPSDSA8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x366))
#define MT6356_CPSDSA9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x368))
#define MT6356_PORFLAG ((unsigned int)(MT6356_PMIC_REG_BASE + 0x36a))
#define MT6356_STRUP_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x36c))
#define MT6356_STRUP_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x36e))
#define MT6356_STRUP_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x370))
#define MT6356_STRUP_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x372))
#define MT6356_STRUP_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x374))
#define MT6356_STRUP_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x376))
#define MT6356_STRUP_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x378))
#define MT6356_STRUP_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x37a))
#define MT6356_STRUP_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x37c))
#define MT6356_STRUP_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x37e))
#define MT6356_STRUP_CON10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x380))
#define MT6356_STRUP_CON11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x382))
#define MT6356_STRUP_CON12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x384))
#define MT6356_STRUP_CON13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x386))
#define MT6356_STRUP_CON14 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x388))
#define MT6356_STRUP_CON15 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x38a))
#define MT6356_STRUP_CON16 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x38c))
#define MT6356_STRUP_CON17 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x38e))
#define MT6356_STRUP_CON18 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x390))
#define MT6356_STRUP_CON19 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x392))
#define MT6356_PSEQ_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x394))
#define MT6356_PSEQ_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x396))
#define MT6356_PSEQ_ELR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x398))
#define MT6356_PSEQ_ELR2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x39a))
#define MT6356_PSEQ_ELR3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x39c))
#define MT6356_PSEQ_ELR4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x39e))
#define MT6356_PSEQ_ELR5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3a0))
#define MT6356_PSEQ_ELR6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3a2))
#define MT6356_PSEQ_ELR7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3a4))
#define MT6356_PSEQ_ELR8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3a6))
#define MT6356_PCHR_DIG_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3c0))
#define MT6356_PCHR_DIG_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3c2))
#define MT6356_PCHR_DIG_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3c4))
#define MT6356_PCHR_DIG_REV2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3c6))
#define MT6356_CHR_TOP_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3c8))
#define MT6356_CHR_TOP_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3ca))
#define MT6356_CHR_TOP_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3cc))
#define MT6356_CHR_TOP_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3ce))
#define MT6356_CHR_TOP_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3d0))
#define MT6356_CHR_TOP_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3d2))
#define MT6356_CHR_TOP_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3d4))
#define MT6356_PCHR_DIG_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3d6))
#define MT6356_PCHR_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3d8))
#define MT6356_PCHR_ELR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3da))
#define MT6356_PCHR_ELR2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3dc))
#define MT6356_PCHR_ELR3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x3de))
#define MT6356_PCHR_MACRO_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x400))
#define MT6356_PCHR_MACRO_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x402))
#define MT6356_PCHR_MACRO_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x404))
#define MT6356_PCHR_MACRO_REV2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x406))
#define MT6356_CHR_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x408))
#define MT6356_CHR_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x40a))
#define MT6356_CHR_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x40c))
#define MT6356_CHR_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x40e))
#define MT6356_CHR_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x410))
#define MT6356_CHR_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x412))
#define MT6356_CHR_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x414))
#define MT6356_CHR_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x416))
#define MT6356_CHR_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x418))
#define MT6356_CHR_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x41a))
#define MT6356_CHR_CON10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x41c))
#define MT6356_CHR_CON11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x41e))
#define MT6356_CHR_CON12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x420))
#define MT6356_CHR_CON13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x422))
#define MT6356_CHR_CON14 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x424))
#define MT6356_CHR_CON15 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x426))
#define MT6356_CHR_CON16 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x428))
#define MT6356_CHR_CON17 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x42a))
#define MT6356_CHR_CON18 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x42c))
#define MT6356_BM_TOP_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x440))
#define MT6356_BM_TOP_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x442))
#define MT6356_BM_TOP_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x444))
#define MT6356_BM_TOP_PAM0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x446))
#define MT6356_BM_TOP_PAM1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x448))
#define MT6356_BM_TOP_CLK_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x44a))
#define MT6356_BM_TOP_CKPDN_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x44c))
#define MT6356_BM_TOP_CKPDN_CON0_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x44e))
#define MT6356_BM_TOP_CKPDN_CON0_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x450))
#define MT6356_BM_TOP_CKSEL_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x452))
#define MT6356_BM_TOP_CKSEL_CON0_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x454))
#define MT6356_BM_TOP_CKSEL_CON0_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x456))
#define MT6356_BM_TOP_CKDIVSEL_CON0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x458))
#define MT6356_BM_TOP_CKDIVSEL_CON0_SET                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x45a))
#define MT6356_BM_TOP_CKDIVSEL_CON0_CLR                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x45c))
#define MT6356_BM_TOP_CKHWEN_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x45e))
#define MT6356_BM_TOP_CKHWEN_CON0_SET                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x460))
#define MT6356_BM_TOP_CKHWEN_CON0_CLR                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x462))
#define MT6356_BM_TOP_CKTST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x464))
#define MT6356_BM_TOP_RST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x466))
#define MT6356_BM_TOP_RST_CON0_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x468))
#define MT6356_BM_TOP_RST_CON0_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x46a))
#define MT6356_BM_TOP_RST_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x46c))
#define MT6356_BM_TOP_RST_CON1_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x46e))
#define MT6356_BM_TOP_RST_CON1_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x470))
#define MT6356_BM_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x472))
#define MT6356_BM_TOP_INT_CON0_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x474))
#define MT6356_BM_TOP_INT_CON0_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x476))
#define MT6356_BM_TOP_INT_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x478))
#define MT6356_BM_TOP_INT_CON1_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x47a))
#define MT6356_BM_TOP_INT_CON1_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x47c))
#define MT6356_BM_TOP_INT_MASK_CON0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x47e))
#define MT6356_BM_TOP_INT_MASK_CON0_SET                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x480))
#define MT6356_BM_TOP_INT_MASK_CON0_CLR                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x482))
#define MT6356_BM_TOP_INT_MASK_CON1                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x484))
#define MT6356_BM_TOP_INT_MASK_CON1_SET                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x486))
#define MT6356_BM_TOP_INT_MASK_CON1_CLR                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x488))
#define MT6356_BM_TOP_INT_STATUS0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x48a))
#define MT6356_BM_TOP_INT_STATUS1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x48c))
#define MT6356_BM_TOP_INT_RAW_STATUS0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x48e))
#define MT6356_BM_TOP_INT_RAW_STATUS1                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x490))
#define MT6356_BM_TOP_INT_MISC_CON                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x492))
#define MT6356_BM_TOP_DBG_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0x494))
#define MT6356_BM_TOP_RSV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x496))
#define MT6356_BM_TOP_RSV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x498))
#define MT6356_BM_TOP_RSV2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x49a))
#define MT6356_BM_TOP_RSV3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x49c))
#define MT6356_BM_TOP_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x49e))
#define MT6356_BM_TOP_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4a0))
#define MT6356_FGADC_ANA_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4c0))
#define MT6356_FGADC_ANA_DSN_REV0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x4c2))
#define MT6356_FGADC_ANA_DSN_REV1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x4c4))
#define MT6356_FGADC_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4c6))
#define MT6356_FGADC_ANA_TEST_CON0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x4c8))
#define MT6356_FGADC_ANA_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4ca))
#define MT6356_FGADC_ANA_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4cc))
#define MT6356_FGADC_ANA_ELR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x4ce))
#define MT6356_FGADC_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x500))
#define MT6356_FGADC_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x502))
#define MT6356_FGADC_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x504))
#define MT6356_FGADC_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x506))
#define MT6356_FGADC_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x508))
#define MT6356_FGADC_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x50a))
#define MT6356_FGADC_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x50c))
#define MT6356_FGADC_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x50e))
#define MT6356_FGADC_RST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x510))
#define MT6356_FGADC_R_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x512))
#define MT6356_FGADC_CUR_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x514))
#define MT6356_FGADC_CUR_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x516))
#define MT6356_FGADC_CUR_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x518))
#define MT6356_FGADC_CUR_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x51a))
#define MT6356_FGADC_CAR_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x51c))
#define MT6356_FGADC_CAR_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x51e))
#define MT6356_FGADC_CAR_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x520))
#define MT6356_FGADC_CAR_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x522))
#define MT6356_FGADC_CAR_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x524))
#define MT6356_FGADC_CAR_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x526))
#define MT6356_FGADC_CAR_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x528))
#define MT6356_FGADC_CAR_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x52a))
#define MT6356_FGADC_CAR_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x52c))
#define MT6356_FGADC_CAR_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x52e))
#define MT6356_FGADC_NCAR_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x530))
#define MT6356_FGADC_NCAR_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x532))
#define MT6356_FGADC_NCAR_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x534))
#define MT6356_FGADC_NCAR_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x536))
#define MT6356_FGADC_IAVG_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x538))
#define MT6356_FGADC_IAVG_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x53a))
#define MT6356_FGADC_IAVG_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x53c))
#define MT6356_FGADC_IAVG_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x53e))
#define MT6356_FGADC_IAVG_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x540))
#define MT6356_FGADC_IAVG_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x542))
#define MT6356_FGADC_NTER_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x544))
#define MT6356_FGADC_NTER_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x546))
#define MT6356_FGADC_NTER_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x548))
#define MT6356_FGADC_NTER_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x54a))
#define MT6356_FGADC_OFFSET_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x54c))
#define MT6356_FGADC_OFFSET_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x54e))
#define MT6356_FGADC_GAIN_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x550))
#define MT6356_FGADC_SON_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x552))
#define MT6356_FGADC_SON_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x554))
#define MT6356_FGADC_SON_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x556))
#define MT6356_FGADC_SON_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x558))
#define MT6356_FGADC_SOFF_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x55a))
#define MT6356_FGADC_SOFF_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x55c))
#define MT6356_FGADC_SOFF_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x55e))
#define MT6356_FGADC_SOFF_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x560))
#define MT6356_FGADC_SOFF_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x562))
#define MT6356_FGADC_PWR_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x564))
#define MT6356_FGADC_PWR_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x566))
#define MT6356_FGADC_ZCV_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x568))
#define MT6356_FGADC_ZCV_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x56a))
#define MT6356_FGADC_ZCV_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x56c))
#define MT6356_FGADC_ZCV_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x56e))
#define MT6356_FGADC_ZCV_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x570))
#define MT6356_FGADC_ZCV_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x572))
#define MT6356_FGADC_TEST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x574))
#define MT6356_FGADC_RSV_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x576))
#define MT6356_FGADC_RSV_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x578))
#define MT6356_FGADC_RSV_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x57a))
#define MT6356_FGADC_RSV_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x57c))
#define MT6356_SYSTEM_INFO_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x57e))
#define MT6356_SYSTEM_INFO_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x580))
#define MT6356_SYSTEM_INFO_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x582))
#define MT6356_SYSTEM_INFO_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x584))
#define MT6356_SYSTEM_INFO_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x586))
#define MT6356_BAT_ANA_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x600))
#define MT6356_BAT_ANA_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x602))
#define MT6356_BAT_ANA_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x604))
#define MT6356_BATON_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x606))
#define MT6356_BATON_ANA_MON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x608))
#define MT6356_BIF_ANA_MON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x60a))
#define MT6356_BATON_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x640))
#define MT6356_BATON_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x642))
#define MT6356_BATON_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x644))
#define MT6356_BATON_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x646))
#define MT6356_BATON_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x648))
#define MT6356_BATON_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x64a))
#define MT6356_BATON_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x64c))
#define MT6356_BATON_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x64e))
#define MT6356_BATON_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x650))
#define MT6356_BIF_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x680))
#define MT6356_BIF_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x682))
#define MT6356_BIF_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x684))
#define MT6356_BIF_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x686))
#define MT6356_BIF_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x688))
#define MT6356_BIF_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x68a))
#define MT6356_BIF_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x68c))
#define MT6356_BIF_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x68e))
#define MT6356_BIF_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x690))
#define MT6356_BIF_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x692))
#define MT6356_BIF_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x694))
#define MT6356_BIF_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x696))
#define MT6356_BIF_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x698))
#define MT6356_BIF_CON10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x69a))
#define MT6356_BIF_CON11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x69c))
#define MT6356_BIF_CON12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x69e))
#define MT6356_BIF_CON13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6a0))
#define MT6356_BIF_CON14 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6a2))
#define MT6356_BIF_CON15 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6a4))
#define MT6356_BIF_CON16 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6a6))
#define MT6356_BIF_CON17 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6a8))
#define MT6356_BIF_CON18 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6aa))
#define MT6356_BIF_CON19 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6ac))
#define MT6356_BIF_CON20 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6ae))
#define MT6356_BIF_CON21 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6b0))
#define MT6356_BIF_CON22 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6b2))
#define MT6356_BIF_CON23 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6b4))
#define MT6356_BIF_CON24 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6b6))
#define MT6356_BIF_CON25 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6b8))
#define MT6356_BIF_CON26 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6ba))
#define MT6356_BIF_CON27 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6bc))
#define MT6356_BIF_CON28 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6be))
#define MT6356_BIF_CON29 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6c0))
#define MT6356_BIF_CON30 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6c2))
#define MT6356_BIF_CON31 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6c4))
#define MT6356_BIF_CON32 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6c6))
#define MT6356_BIF_CON33 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6c8))
#define MT6356_BIF_CON34 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6ca))
#define MT6356_BIF_CON35 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6cc))
#define MT6356_BIF_CON36 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6ce))
#define MT6356_BIF_CON37 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6d0))
#define MT6356_BIF_CON38 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6d2))
#define MT6356_BIF_CON39 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x6d4))
#define MT6356_HK_TOP_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x700))
#define MT6356_HK_TOP_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x702))
#define MT6356_HK_TOP_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x704))
#define MT6356_HK_TOP_PAM0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x706))
#define MT6356_HK_TOP_PAM1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x708))
#define MT6356_HK_TOP_CLK_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x70a))
#define MT6356_HK_TOP_CLK_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x70c))
#define MT6356_HK_TOP_RST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x70e))
#define MT6356_HK_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x710))
#define MT6356_HK_TOP_INT_CON0_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x712))
#define MT6356_HK_TOP_INT_CON0_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x714))
#define MT6356_HK_TOP_INT_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x716))
#define MT6356_HK_TOP_INT_CON1_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x718))
#define MT6356_HK_TOP_INT_CON1_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x71a))
#define MT6356_HK_TOP_INT_MASK_CON0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x71c))
#define MT6356_HK_TOP_INT_MASK_CON0_SET                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x71e))
#define MT6356_HK_TOP_INT_MASK_CON0_CLR                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x720))
#define MT6356_HK_TOP_INT_MASK_CON1                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x722))
#define MT6356_HK_TOP_INT_MASK_CON1_SET                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x724))
#define MT6356_HK_TOP_INT_MASK_CON1_CLR                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x726))
#define MT6356_HK_TOP_INT_STATUS0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x728))
#define MT6356_HK_TOP_INT_STATUS1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x72a))
#define MT6356_HK_TOP_INT_RAW_STATUS0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x72c))
#define MT6356_HK_TOP_INT_RAW_STATUS1                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x72e))
#define MT6356_HK_TOP_MON_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x730))
#define MT6356_HK_TOP_MON_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x732))
#define MT6356_HK_TOP_MON_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x734))
#define MT6356_AUXADC_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x740))
#define MT6356_AUXADC_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x742))
#define MT6356_AUXADC_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x744))
#define MT6356_AUXADC_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x746))
#define MT6356_AUXADC_DIG_1_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x780))
#define MT6356_AUXADC_DIG_1_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x782))
#define MT6356_AUXADC_DIG_1_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x784))
#define MT6356_AUXADC_ADC0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x786))
#define MT6356_AUXADC_ADC1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x788))
#define MT6356_AUXADC_ADC2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x78a))
#define MT6356_AUXADC_ADC3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x78c))
#define MT6356_AUXADC_ADC4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x78e))
#define MT6356_AUXADC_ADC5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x790))
#define MT6356_AUXADC_ADC6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x792))
#define MT6356_AUXADC_ADC7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x794))
#define MT6356_AUXADC_ADC8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x796))
#define MT6356_AUXADC_ADC9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x798))
#define MT6356_AUXADC_ADC10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x79a))
#define MT6356_AUXADC_ADC11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x79c))
#define MT6356_AUXADC_ADC12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x79e))
#define MT6356_AUXADC_ADC13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7a0))
#define MT6356_AUXADC_ADC14 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7a2))
#define MT6356_AUXADC_ADC15 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7a4))
#define MT6356_AUXADC_ADC16 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7a6))
#define MT6356_AUXADC_ADC17 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7a8))
#define MT6356_AUXADC_ADC18 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7aa))
#define MT6356_AUXADC_ADC19 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7ac))
#define MT6356_AUXADC_ADC20 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7ae))
#define MT6356_AUXADC_ADC21 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7b0))
#define MT6356_AUXADC_ADC22 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7b2))
#define MT6356_AUXADC_ADC23 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7b4))
#define MT6356_AUXADC_ADC24 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7b6))
#define MT6356_AUXADC_ADC25 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7b8))
#define MT6356_AUXADC_ADC26 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7ba))
#define MT6356_AUXADC_ADC27 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7bc))
#define MT6356_AUXADC_ADC28 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7be))
#define MT6356_AUXADC_ADC29 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7c0))
#define MT6356_AUXADC_ADC30 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7c2))
#define MT6356_AUXADC_ADC31 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7c4))
#define MT6356_AUXADC_ADC32 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7c6))
#define MT6356_AUXADC_ADC33 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7c8))
#define MT6356_AUXADC_ADC34 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7ca))
#define MT6356_AUXADC_ADC35 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7cc))
#define MT6356_AUXADC_ADC36 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7ce))
#define MT6356_AUXADC_ADC37 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7d0))
#define MT6356_AUXADC_ADC38 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7d2))
#define MT6356_AUXADC_ADC39 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7d4))
#define MT6356_AUXADC_ADC40 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7d6))
#define MT6356_AUXADC_ADC41 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7d8))
#define MT6356_AUXADC_ADC42 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7da))
#define MT6356_AUXADC_ADC43 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7dc))
#define MT6356_AUXADC_ADC44 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7de))
#define MT6356_AUXADC_ADC45 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7e0))
#define MT6356_AUXADC_ADC46 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7e2))
#define MT6356_AUXADC_ADC47 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7e4))
#define MT6356_AUXADC_STA0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7e6))
#define MT6356_AUXADC_STA1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7e8))
#define MT6356_AUXADC_STA2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7ea))
#define MT6356_AUXADC_RQST0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7ec))
#define MT6356_AUXADC_RQST0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7ee))
#define MT6356_AUXADC_RQST0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7f0))
#define MT6356_AUXADC_RQST2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7f2))
#define MT6356_AUXADC_RQST2_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7f4))
#define MT6356_AUXADC_RQST2_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7f6))
#define MT6356_AUXADC_RQST1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7f8))
#define MT6356_AUXADC_RQST1_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7fa))
#define MT6356_AUXADC_RQST1_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7fc))
#define MT6356_AUXADC_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x7fe))
#define MT6356_AUXADC_CON0_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x800))
#define MT6356_AUXADC_CON0_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x802))
#define MT6356_AUXADC_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x804))
#define MT6356_AUXADC_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x806))
#define MT6356_AUXADC_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x808))
#define MT6356_AUXADC_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x80a))
#define MT6356_AUXADC_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x80c))
#define MT6356_AUXADC_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x80e))
#define MT6356_AUXADC_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x810))
#define MT6356_AUXADC_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x812))
#define MT6356_AUXADC_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x814))
#define MT6356_AUXADC_CON10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x816))
#define MT6356_AUXADC_CON11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x818))
#define MT6356_AUXADC_CON12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x81a))
#define MT6356_AUXADC_CON13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x81c))
#define MT6356_AUXADC_CON14 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x81e))
#define MT6356_AUXADC_CON15 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x820))
#define MT6356_AUXADC_CON16 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x822))
#define MT6356_AUXADC_CON17 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x824))
#define MT6356_AUXADC_CON18 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x826))
#define MT6356_AUXADC_CON19 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x828))
#define MT6356_AUXADC_CON20 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x82a))
#define MT6356_AUXADC_AUTORPT0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x82c))
#define MT6356_AUXADC_LBAT0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x82e))
#define MT6356_AUXADC_LBAT1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x830))
#define MT6356_AUXADC_LBAT2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x832))
#define MT6356_AUXADC_LBAT3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x834))
#define MT6356_AUXADC_LBAT4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x836))
#define MT6356_AUXADC_LBAT5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x838))
#define MT6356_AUXADC_LBAT6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x83a))
#define MT6356_AUXADC_ACCDET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x83c))
#define MT6356_AUXADC_DIG_1_ELR_NUM                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x83e))
#define MT6356_AUXADC_DIG_1_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x840))
#define MT6356_AUXADC_DIG_1_ELR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x842))
#define MT6356_AUXADC_DIG_2_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x880))
#define MT6356_AUXADC_DIG_2_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x882))
#define MT6356_AUXADC_DIG_2_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x884))
#define MT6356_AUXADC_THR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x886))
#define MT6356_AUXADC_THR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x888))
#define MT6356_AUXADC_THR2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x88a))
#define MT6356_AUXADC_THR3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x88c))
#define MT6356_AUXADC_THR4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x88e))
#define MT6356_AUXADC_THR5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x890))
#define MT6356_AUXADC_THR6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x892))
#define MT6356_AUXADC_DBG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x894))
#define MT6356_AUXADC_IMP0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x896))
#define MT6356_AUXADC_IMP1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x898))
#define MT6356_AUXADC_BAT_TEMP_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x89a))
#define MT6356_AUXADC_BAT_TEMP_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x89c))
#define MT6356_AUXADC_BAT_TEMP_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x89e))
#define MT6356_AUXADC_BAT_TEMP_3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8a0))
#define MT6356_AUXADC_BAT_TEMP_4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8a2))
#define MT6356_AUXADC_BAT_TEMP_5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8a4))
#define MT6356_AUXADC_BAT_TEMP_6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8a6))
#define MT6356_AUXADC_BAT_TEMP_7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8a8))
#define MT6356_AUXADC_LBAT2_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8aa))
#define MT6356_AUXADC_LBAT2_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8ac))
#define MT6356_AUXADC_LBAT2_3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8ae))
#define MT6356_AUXADC_LBAT2_4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8b0))
#define MT6356_AUXADC_LBAT2_5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8b2))
#define MT6356_AUXADC_LBAT2_6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8b4))
#define MT6356_AUXADC_LBAT2_7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8b6))
#define MT6356_AUXADC_MDRT_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8b8))
#define MT6356_AUXADC_MDRT_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8ba))
#define MT6356_AUXADC_MDRT_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8bc))
#define MT6356_AUXADC_MDRT_3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8be))
#define MT6356_AUXADC_MDRT_4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8c0))
#define MT6356_AUXADC_JEITA_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8c2))
#define MT6356_AUXADC_JEITA_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8c4))
#define MT6356_AUXADC_JEITA_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8c6))
#define MT6356_AUXADC_JEITA_3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8c8))
#define MT6356_AUXADC_JEITA_4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8ca))
#define MT6356_AUXADC_JEITA_5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8cc))
#define MT6356_AUXADC_DCXO_MDRT_0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x8ce))
#define MT6356_AUXADC_DCXO_MDRT_1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x8d0))
#define MT6356_AUXADC_DCXO_MDRT_2                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x8d2))
#define MT6356_AUXADC_NAG_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8d4))
#define MT6356_AUXADC_NAG_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8d6))
#define MT6356_AUXADC_NAG_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8d8))
#define MT6356_AUXADC_NAG_3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8da))
#define MT6356_AUXADC_NAG_4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8dc))
#define MT6356_AUXADC_NAG_5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8de))
#define MT6356_AUXADC_NAG_6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8e0))
#define MT6356_AUXADC_NAG_7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8e2))
#define MT6356_AUXADC_NAG_8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8e4))
#define MT6356_AUXADC_RSV_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8e6))
#define MT6356_AUXADC_ANA_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8e8))
#define MT6356_AUXADC_IMP_CG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8ea))
#define MT6356_AUXADC_LBAT_CG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8ec))
#define MT6356_AUXADC_THR_CG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8ee))
#define MT6356_AUXADC_BAT_TEMP_CG0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x8f0))
#define MT6356_AUXADC_LBAT2_CG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8f2))
#define MT6356_AUXADC_JEITA_CG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8f4))
#define MT6356_AUXADC_NAG_CG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8f6))
#define MT6356_AUXADC_PRI_NEW ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8f8))
#define MT6356_AUXADC_CHR_TOP_CON2                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x8fa))
#define MT6356_AUXADC_TYPEC_H_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8fc))
#define MT6356_AUXADC_TYPEC_H_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x8fe))
#define MT6356_AUXADC_TYPEC_H_3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x900))
#define MT6356_AUXADC_TYPEC_H_4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x902))
#define MT6356_AUXADC_TYPEC_H_5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x904))
#define MT6356_AUXADC_TYPEC_H_6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x906))
#define MT6356_AUXADC_TYPEC_H_7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x908))
#define MT6356_AUXADC_TYPEC_H_8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x90a))
#define MT6356_AUXADC_TYPEC_L_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x90c))
#define MT6356_AUXADC_TYPEC_L_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x90e))
#define MT6356_AUXADC_TYPEC_L_3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x910))
#define MT6356_AUXADC_TYPEC_L_4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x912))
#define MT6356_AUXADC_TYPEC_L_5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x914))
#define MT6356_AUXADC_TYPEC_L_6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x916))
#define MT6356_AUXADC_TYPEC_L_7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x918))
#define MT6356_AUXADC_TYPEC_L_8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x91a))
#define MT6356_AUXADC_DIG_2_ELR_NUM                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x91c))
#define MT6356_AUXADC_DIG_2_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x91e))
#define MT6356_AUXADC_DIG_2_ELR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x920))
#define MT6356_AUXADC_DIG_2_ELR2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x922))
#define MT6356_AUXADC_DIG_2_ELR3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x924))
#define MT6356_AUXADC_DIG_2_ELR4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x926))
#define MT6356_AUXADC_DIG_2_ELR5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x928))
#define MT6356_AUXADC_DIG_2_ELR6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x92a))
#define MT6356_AUXADC_DIG_2_ELR7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x92c))
#define MT6356_AUXADC_DIG_2_ELR8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x92e))
#define MT6356_AUXADC_DIG_2_ELR9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x930))
#define MT6356_AUXADC_DIG_2_ELR10                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x932))
#define MT6356_AUXADC_DIG_2_ELR11                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x934))
#define MT6356_SCK_TOP_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x980))
#define MT6356_SCK_TOP_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x982))
#define MT6356_SCK_TOP_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x984))
#define MT6356_SCK_TOP_PAM0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x986))
#define MT6356_SCK_TOP_PAM1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x988))
#define MT6356_SCK_TOP_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x98a))
#define MT6356_SCK_TOP_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x98c))
#define MT6356_SCK_TOP_TEST_OUT ((unsigned int)(MT6356_PMIC_REG_BASE + 0x98e))
#define MT6356_SCK_TOP_TEST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x990))
#define MT6356_SCK_TOP_CKPDN_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x992))
#define MT6356_SCK_TOP_CKPDN_CON0_SET                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x994))
#define MT6356_SCK_TOP_CKPDN_CON0_CLR                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x996))
#define MT6356_SCK_TOP_CKHWEN_CON0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x998))
#define MT6356_SCK_TOP_CKHWEN_CON0_SET                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x99a))
#define MT6356_SCK_TOP_CKHWEN_CON0_CLR                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x99c))
#define MT6356_SCK_TOP_CKTST_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0x99e))
#define MT6356_SCK_TOP_MDB_DCM_CON                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9a0))
#define MT6356_SCK_TOP_RST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9a2))
#define MT6356_SCK_TOP_RST_CON0_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9a4))
#define MT6356_SCK_TOP_RST_CON0_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9a6))
#define MT6356_SCK_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9a8))
#define MT6356_SCK_TOP_INT_CON0_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9aa))
#define MT6356_SCK_TOP_INT_CON0_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9ac))
#define MT6356_SCK_TOP_INT_MASK_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9ae))
#define MT6356_SCK_TOP_INT_MASK_CON0_SET                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9b0))
#define MT6356_SCK_TOP_INT_MASK_CON0_CLR                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9b2))
#define MT6356_SCK_TOP_INT_STATUS0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9b4))
#define MT6356_SCK_TOP_INT_RAW_STATUS0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9b6))
#define MT6356_SCK_TOP_INT_MISC_CON                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x9b8))
#define MT6356_DCXO_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9c0))
#define MT6356_DCXO_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9c2))
#define MT6356_DCXO_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9c4))
#define MT6356_DCXO_CW00 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9c6))
#define MT6356_DCXO_CW00_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9c8))
#define MT6356_DCXO_CW00_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9ca))
#define MT6356_DCXO_CW01 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9cc))
#define MT6356_DCXO_CW02 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9ce))
#define MT6356_DCXO_CW03 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9d0))
#define MT6356_DCXO_CW04 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9d2))
#define MT6356_DCXO_CW05 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9d4))
#define MT6356_DCXO_CW06 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9d6))
#define MT6356_DCXO_CW07 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9d8))
#define MT6356_DCXO_CW08 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9da))
#define MT6356_DCXO_CW09 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9dc))
#define MT6356_DCXO_CW10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9de))
#define MT6356_DCXO_CW11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9e0))
#define MT6356_DCXO_CW11_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9e2))
#define MT6356_DCXO_CW11_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9e4))
#define MT6356_DCXO_CW12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9e6))
#define MT6356_DCXO_CW13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9e8))
#define MT6356_DCXO_CW14 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9ea))
#define MT6356_DCXO_CW15 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9ec))
#define MT6356_DCXO_CW16 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9ee))
#define MT6356_DCXO_CW17 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9f0))
#define MT6356_DCXO_CW18 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9f2))
#define MT6356_DCXO_CW19 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9f4))
#define MT6356_DCXO_CW20 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9f6))
#define MT6356_DCXO_CW21 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9f8))
#define MT6356_DCXO_CW22 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9fa))
#define MT6356_DCXO_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9fc))
#define MT6356_DCXO_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x9fe))
#define MT6356_RTC_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa00))
#define MT6356_RTC_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa02))
#define MT6356_RTC_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa04))
#define MT6356_RTC_DUMMY_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa06))
#define MT6356_RTC_BBPU ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa08))
#define MT6356_RTC_IRQ_STA ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa0a))
#define MT6356_RTC_IRQ_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa0c))
#define MT6356_RTC_CII_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa0e))
#define MT6356_RTC_AL_MASK ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa10))
#define MT6356_RTC_TC_SEC ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa12))
#define MT6356_RTC_TC_MIN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa14))
#define MT6356_RTC_TC_HOU ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa16))
#define MT6356_RTC_TC_DOM ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa18))
#define MT6356_RTC_TC_DOW ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa1a))
#define MT6356_RTC_TC_MTH ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa1c))
#define MT6356_RTC_TC_YEA ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa1e))
#define MT6356_RTC_AL_SEC ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa20))
#define MT6356_RTC_AL_MIN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa22))
#define MT6356_RTC_AL_HOU ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa24))
#define MT6356_RTC_AL_DOM ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa26))
#define MT6356_RTC_AL_DOW ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa28))
#define MT6356_RTC_AL_MTH ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa2a))
#define MT6356_RTC_AL_YEA ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa2c))
#define MT6356_RTC_OSC32CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa2e))
#define MT6356_RTC_POWERKEY1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa30))
#define MT6356_RTC_POWERKEY2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa32))
#define MT6356_RTC_PDN1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa34))
#define MT6356_RTC_PDN2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa36))
#define MT6356_RTC_SPAR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa38))
#define MT6356_RTC_SPAR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa3a))
#define MT6356_RTC_PROT ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa3c))
#define MT6356_RTC_DIFF ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa3e))
#define MT6356_RTC_CALI ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa40))
#define MT6356_RTC_WRTGR ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa42))
#define MT6356_RTC_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa44))
#define MT6356_RTC_SEC_CTRL ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa46))
#define MT6356_RTC_INT_CNT ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa48))
#define MT6356_RTC_SEC_DAT0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa4a))
#define MT6356_RTC_SEC_DAT1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa4c))
#define MT6356_RTC_SEC_DAT2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa4e))
#define MT6356_EOSC_CALI_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa80))
#define MT6356_EOSC_CALI_DSN_REV0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xa82))
#define MT6356_EOSC_CALI_DSN_REV1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xa84))
#define MT6356_EOSC_CALI_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa86))
#define MT6356_EOSC_CALI_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa88))
#define MT6356_RTC_MIX_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa8a))
#define MT6356_RTC_MIX_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa8c))
#define MT6356_RTC_MIX_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xa8e))
#define MT6356_RTC_SEC_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xac0))
#define MT6356_RTC_SEC_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xac2))
#define MT6356_RTC_SEC_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xac4))
#define MT6356_RTC_SEC_DUMMY_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xac6))
#define MT6356_RTC_TC_SEC_SEC ((unsigned int)(MT6356_PMIC_REG_BASE + 0xac8))
#define MT6356_RTC_TC_MIN_SEC ((unsigned int)(MT6356_PMIC_REG_BASE + 0xaca))
#define MT6356_RTC_TC_HOU_SEC ((unsigned int)(MT6356_PMIC_REG_BASE + 0xacc))
#define MT6356_RTC_TC_DOM_SEC ((unsigned int)(MT6356_PMIC_REG_BASE + 0xace))
#define MT6356_RTC_TC_DOW_SEC ((unsigned int)(MT6356_PMIC_REG_BASE + 0xad0))
#define MT6356_RTC_TC_MTH_SEC ((unsigned int)(MT6356_PMIC_REG_BASE + 0xad2))
#define MT6356_RTC_TC_YEA_SEC ((unsigned int)(MT6356_PMIC_REG_BASE + 0xad4))
#define MT6356_RTC_SEC_CK_PDN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xad6))
#define MT6356_RTC_SEC_WRTGR ((unsigned int)(MT6356_PMIC_REG_BASE + 0xad8))
#define MT6356_BUCK_TOP_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb00))
#define MT6356_BUCK_TOP_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb02))
#define MT6356_BUCK_TOP_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb04))
#define MT6356_BUCK_TOP_PAM0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb06))
#define MT6356_BUCK_TOP_PAM1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb08))
#define MT6356_BUCK_TOP_CLK_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb0a))
#define MT6356_BUCK_TOP_CLK_CON0_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb0c))
#define MT6356_BUCK_TOP_CLK_CON0_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb0e))
#define MT6356_BUCK_TOP_CLK_HWEN_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb10))
#define MT6356_BUCK_TOP_CLK_HWEN_CON0_SET                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb12))
#define MT6356_BUCK_TOP_CLK_HWEN_CON0_CLR                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb14))
#define MT6356_BUCK_TOP_CLK_MISC_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb16))
#define MT6356_BUCK_TOP_RST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb18))
#define MT6356_BUCK_TOP_RST_CON0_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb1a))
#define MT6356_BUCK_TOP_RST_CON0_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb1c))
#define MT6356_BUCK_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb1e))
#define MT6356_BUCK_TOP_INT_CON0_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb20))
#define MT6356_BUCK_TOP_INT_CON0_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb22))
#define MT6356_BUCK_TOP_INT_MASK_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb24))
#define MT6356_BUCK_TOP_INT_MASK_CON0_SET                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb26))
#define MT6356_BUCK_TOP_INT_MASK_CON0_CLR                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb28))
#define MT6356_BUCK_TOP_INT_STATUS0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb2a))
#define MT6356_BUCK_TOP_INT_RAW_STATUS0                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb2c))
#define MT6356_BUCK_TOP_ALL_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb2e))
#define MT6356_BUCK_TOP_STB_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb30))
#define MT6356_BUCK_TOP_SLP_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb32))
#define MT6356_BUCK_TOP_SLP_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb34))
#define MT6356_BUCK_TOP_SLP_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb36))
#define MT6356_BUCK_TOP_MINFREQ_CON                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb38))
#define MT6356_BUCK_TOP_OC_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb3a))
#define MT6356_BUCK_TOP_K_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb3c))
#define MT6356_BUCK_TOP_K_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb3e))
#define MT6356_BUCK_TOP_K_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb40))
#define MT6356_BUCK_TOP_WDTDBG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb42))
#define MT6356_BUCK_TOP_WDTDBG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb44))
#define MT6356_BUCK_TOP_WDTDBG2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb46))
#define MT6356_BUCK_TOP_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb48))
#define MT6356_BUCK_TOP_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb4a))
#define MT6356_BUCK_TOP_ELR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb4c))
#define MT6356_BUCK_VPROC_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb80))
#define MT6356_BUCK_VPROC_DSN_REV0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb82))
#define MT6356_BUCK_VPROC_DSN_REV1                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb84))
#define MT6356_BUCK_VPROC_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb86))
#define MT6356_BUCK_VPROC_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb88))
#define MT6356_BUCK_VPROC_CFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb8a))
#define MT6356_BUCK_VPROC_CFG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb8c))
#define MT6356_BUCK_VPROC_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb8e))
#define MT6356_BUCK_VPROC_OP_EN_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb90))
#define MT6356_BUCK_VPROC_OP_EN_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb92))
#define MT6356_BUCK_VPROC_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb94))
#define MT6356_BUCK_VPROC_OP_CFG_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb96))
#define MT6356_BUCK_VPROC_OP_CFG_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xb98))
#define MT6356_BUCK_VPROC_SP_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb9a))
#define MT6356_BUCK_VPROC_SP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb9c))
#define MT6356_BUCK_VPROC_OC_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xb9e))
#define MT6356_BUCK_VPROC_DBG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xba0))
#define MT6356_BUCK_VPROC_DBG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xba2))
#define MT6356_BUCK_VPROC_DBG2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xba4))
#define MT6356_BUCK_VPROC_ELR_NUM                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xba6))
#define MT6356_BUCK_VPROC_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xba8))
#define MT6356_BUCK_VCORE_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbc0))
#define MT6356_BUCK_VCORE_DSN_REV0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xbc2))
#define MT6356_BUCK_VCORE_DSN_REV1                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xbc4))
#define MT6356_BUCK_VCORE_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbc6))
#define MT6356_BUCK_VCORE_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbc8))
#define MT6356_BUCK_VCORE_CFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbca))
#define MT6356_BUCK_VCORE_CFG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbcc))
#define MT6356_BUCK_VCORE_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbce))
#define MT6356_BUCK_VCORE_OP_EN_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xbd0))
#define MT6356_BUCK_VCORE_OP_EN_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xbd2))
#define MT6356_BUCK_VCORE_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbd4))
#define MT6356_BUCK_VCORE_OP_CFG_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xbd6))
#define MT6356_BUCK_VCORE_OP_CFG_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xbd8))
#define MT6356_BUCK_VCORE_SP_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbda))
#define MT6356_BUCK_VCORE_SP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbdc))
#define MT6356_BUCK_VCORE_OC_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbde))
#define MT6356_BUCK_VCORE_DBG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbe0))
#define MT6356_BUCK_VCORE_DBG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbe2))
#define MT6356_BUCK_VCORE_DBG2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbe4))
#define MT6356_BUCK_VCORE_ELR_NUM                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xbe6))
#define MT6356_BUCK_VCORE_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xbe8))
#define MT6356_BUCK_VMODEM_DSN_ID                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc00))
#define MT6356_BUCK_VMODEM_DSN_REV0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc02))
#define MT6356_BUCK_VMODEM_DSN_REV1                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc04))
#define MT6356_BUCK_VMODEM_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc06))
#define MT6356_BUCK_VMODEM_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc08))
#define MT6356_BUCK_VMODEM_CFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc0a))
#define MT6356_BUCK_VMODEM_CFG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc0c))
#define MT6356_BUCK_VMODEM_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc0e))
#define MT6356_BUCK_VMODEM_OP_EN_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc10))
#define MT6356_BUCK_VMODEM_OP_EN_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc12))
#define MT6356_BUCK_VMODEM_OP_CFG                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc14))
#define MT6356_BUCK_VMODEM_OP_CFG_SET                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc16))
#define MT6356_BUCK_VMODEM_OP_CFG_CLR                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc18))
#define MT6356_BUCK_VMODEM_SP_CON                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc1a))
#define MT6356_BUCK_VMODEM_SP_CFG                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc1c))
#define MT6356_BUCK_VMODEM_OC_CFG                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc1e))
#define MT6356_BUCK_VMODEM_DBG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc20))
#define MT6356_BUCK_VMODEM_DBG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc22))
#define MT6356_BUCK_VMODEM_DBG2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc24))
#define MT6356_BUCK_VMODEM_DLC_CON0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc26))
#define MT6356_BUCK_VMODEM_DLC_CON1                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc28))
#define MT6356_BUCK_VMODEM_DLC_CON2                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc2a))
#define MT6356_BUCK_VMODEM_DLC_CON3                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc2c))
#define MT6356_BUCK_VMODEM_ELR_NUM                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc2e))
#define MT6356_BUCK_VMODEM_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc30))
#define MT6356_BUCK_VS1_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc40))
#define MT6356_BUCK_VS1_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc42))
#define MT6356_BUCK_VS1_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc44))
#define MT6356_BUCK_VS1_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc46))
#define MT6356_BUCK_VS1_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc48))
#define MT6356_BUCK_VS1_CFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc4a))
#define MT6356_BUCK_VS1_CFG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc4c))
#define MT6356_BUCK_VS1_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc4e))
#define MT6356_BUCK_VS1_OP_EN_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc50))
#define MT6356_BUCK_VS1_OP_EN_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc52))
#define MT6356_BUCK_VS1_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc54))
#define MT6356_BUCK_VS1_OP_CFG_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc56))
#define MT6356_BUCK_VS1_OP_CFG_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc58))
#define MT6356_BUCK_VS1_SP_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc5a))
#define MT6356_BUCK_VS1_SP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc5c))
#define MT6356_BUCK_VS1_OC_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc5e))
#define MT6356_BUCK_VS1_DBG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc60))
#define MT6356_BUCK_VS1_DBG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc62))
#define MT6356_BUCK_VS1_DBG2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc64))
#define MT6356_BUCK_VS1_VOTER ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc66))
#define MT6356_BUCK_VS1_VOTER_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc68))
#define MT6356_BUCK_VS1_VOTER_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc6a))
#define MT6356_BUCK_VS1_VOTER_CFG                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc6c))
#define MT6356_BUCK_VS1_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc6e))
#define MT6356_BUCK_VS1_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc70))
#define MT6356_BUCK_VS2_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc80))
#define MT6356_BUCK_VS2_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc82))
#define MT6356_BUCK_VS2_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc84))
#define MT6356_BUCK_VS2_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc86))
#define MT6356_BUCK_VS2_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc88))
#define MT6356_BUCK_VS2_CFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc8a))
#define MT6356_BUCK_VS2_CFG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc8c))
#define MT6356_BUCK_VS2_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc8e))
#define MT6356_BUCK_VS2_OP_EN_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc90))
#define MT6356_BUCK_VS2_OP_EN_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc92))
#define MT6356_BUCK_VS2_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc94))
#define MT6356_BUCK_VS2_OP_CFG_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc96))
#define MT6356_BUCK_VS2_OP_CFG_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xc98))
#define MT6356_BUCK_VS2_SP_CON ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc9a))
#define MT6356_BUCK_VS2_SP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc9c))
#define MT6356_BUCK_VS2_OC_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xc9e))
#define MT6356_BUCK_VS2_DBG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xca0))
#define MT6356_BUCK_VS2_DBG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xca2))
#define MT6356_BUCK_VS2_DBG2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xca4))
#define MT6356_BUCK_VS2_VOTER ((unsigned int)(MT6356_PMIC_REG_BASE + 0xca6))
#define MT6356_BUCK_VS2_VOTER_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xca8))
#define MT6356_BUCK_VS2_VOTER_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcaa))
#define MT6356_BUCK_VS2_VOTER_CFG                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcac))
#define MT6356_BUCK_VS2_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcae))
#define MT6356_BUCK_VS2_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcb0))
#define MT6356_BUCK_VPA_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcc0))
#define MT6356_BUCK_VPA_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcc2))
#define MT6356_BUCK_VPA_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcc4))
#define MT6356_BUCK_VPA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcc6))
#define MT6356_BUCK_VPA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcc8))
#define MT6356_BUCK_VPA_CFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcca))
#define MT6356_BUCK_VPA_CFG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xccc))
#define MT6356_BUCK_VPA_OC_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcce))
#define MT6356_BUCK_VPA_DBG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcd0))
#define MT6356_BUCK_VPA_DBG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcd2))
#define MT6356_BUCK_VPA_DBG2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcd4))
#define MT6356_BUCK_VPA_DLC_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcd6))
#define MT6356_BUCK_VPA_DLC_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcd8))
#define MT6356_BUCK_VPA_DLC_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xcda))
#define MT6356_BUCK_VPA_MSFG_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcdc))
#define MT6356_BUCK_VPA_MSFG_CON1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcde))
#define MT6356_BUCK_VPA_MSFG_RRATE0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xce0))
#define MT6356_BUCK_VPA_MSFG_RRATE1                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xce2))
#define MT6356_BUCK_VPA_MSFG_RRATE2                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xce4))
#define MT6356_BUCK_VPA_MSFG_RTHD0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xce6))
#define MT6356_BUCK_VPA_MSFG_RTHD1                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xce8))
#define MT6356_BUCK_VPA_MSFG_RTHD2                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcea))
#define MT6356_BUCK_VPA_MSFG_FRATE0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcec))
#define MT6356_BUCK_VPA_MSFG_FRATE1                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcee))
#define MT6356_BUCK_VPA_MSFG_FRATE2                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcf0))
#define MT6356_BUCK_VPA_MSFG_FTHD0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcf2))
#define MT6356_BUCK_VPA_MSFG_FTHD1                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcf4))
#define MT6356_BUCK_VPA_MSFG_FTHD2                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xcf6))
#define MT6356_BUCK_ANA_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd00))
#define MT6356_BUCK_ANA_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd02))
#define MT6356_BUCK_ANA_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd04))
#define MT6356_SMPS_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd06))
#define MT6356_SMPS_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd08))
#define MT6356_SMPS_ANA_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd0a))
#define MT6356_SMPS_ANA_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd0c))
#define MT6356_VCORE_VPROC_ANA_CON0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd0e))
#define MT6356_VCORE_VPROC_ANA_CON1                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd10))
#define MT6356_VCORE_VPROC_ANA_CON2                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd12))
#define MT6356_VCORE_VPROC_ANA_CON3                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd14))
#define MT6356_VCORE_VPROC_ANA_CON4                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd16))
#define MT6356_VCORE_VPROC_ANA_CON5                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd18))
#define MT6356_VCORE_VPROC_ANA_CON6                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd1a))
#define MT6356_VCORE_VPROC_ANA_CON7                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd1c))
#define MT6356_VCORE_VPROC_ANA_CON8                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd1e))
#define MT6356_VCORE_VPROC_ANA_CON9                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd20))
#define MT6356_VCORE_VPROC_ANA_CON10                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd22))
#define MT6356_VCORE_VPROC_ANA_CON11                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd24))
#define MT6356_VMODEM_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd26))
#define MT6356_VMODEM_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd28))
#define MT6356_VMODEM_ANA_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd2a))
#define MT6356_VMODEM_ANA_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd2c))
#define MT6356_VMODEM_ANA_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd2e))
#define MT6356_VMODEM_ANA_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd30))
#define MT6356_VMODEM_ANA_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd32))
#define MT6356_VMODEM_ANA_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd34))
#define MT6356_VS1_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd36))
#define MT6356_VS1_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd38))
#define MT6356_VS1_ANA_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd3a))
#define MT6356_VS1_ANA_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd3c))
#define MT6356_VS1_ANA_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd3e))
#define MT6356_VS1_ANA_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd40))
#define MT6356_VS2_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd42))
#define MT6356_VS2_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd44))
#define MT6356_VS2_ANA_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd46))
#define MT6356_VS2_ANA_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd48))
#define MT6356_VS2_ANA_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd4a))
#define MT6356_VS2_ANA_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd4c))
#define MT6356_VPA_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd4e))
#define MT6356_VPA_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd50))
#define MT6356_VPA_ANA_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd52))
#define MT6356_VPA_ANA_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd54))
#define MT6356_VPA_ANA_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd56))
#define MT6356_VPA_ANA_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd58))
#define MT6356_BUCK_ANA_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd5a))
#define MT6356_SMPS_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd5c))
#define MT6356_SMPS_ELR_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd5e))
#define MT6356_SMPS_ELR_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd60))
#define MT6356_SMPS_ELR_3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd62))
#define MT6356_SMPS_ELR_4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd64))
#define MT6356_SMPS_ELR_5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd66))
#define MT6356_SMPS_ELR_6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd68))
#define MT6356_SMPS_ELR_7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd6a))
#define MT6356_VCORE_VPROC_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd6c))
#define MT6356_VCORE_VPROC_ELR_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd6e))
#define MT6356_VCORE_VPROC_ELR_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd70))
#define MT6356_VCORE_VPROC_ELR_3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd72))
#define MT6356_VCORE_VPROC_ELR_4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd74))
#define MT6356_VMODEM_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd76))
#define MT6356_VS1_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd78))
#define MT6356_VS2_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd7a))
#define MT6356_VPA_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd7c))
#define MT6356_LDO_TOP_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd80))
#define MT6356_LDO_TOP_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd82))
#define MT6356_LDO_TOP_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd84))
#define MT6356_LDO_TOP_PAM0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd86))
#define MT6356_LDO_TOP_PAM1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xd88))
#define MT6356_LDO_TOP_CLK_DCM_CON0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd8a))
#define MT6356_LDO_TOP_CLK_VIO28_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd8c))
#define MT6356_LDO_TOP_CLK_VIO18_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd8e))
#define MT6356_LDO_TOP_CLK_VAUD28_CON0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd90))
#define MT6356_LDO_TOP_CLK_VDRAM_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd92))
#define MT6356_LDO_TOP_CLK_VA12_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd94))
#define MT6356_LDO_TOP_CLK_VSRAM_PROC_CON0                                    \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd96))
#define MT6356_LDO_TOP_CLK_VSRAM_OTHERS_CON0                                  \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd98))
#define MT6356_LDO_TOP_CLK_VSRAM_GPU_CON0                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd9a))
#define MT6356_LDO_TOP_CLK_VAUX18_CON0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd9c))
#define MT6356_LDO_TOP_CLK_VUSB_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xd9e))
#define MT6356_LDO_TOP_CLK_VEMC_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xda0))
#define MT6356_LDO_TOP_CLK_VXO22_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xda2))
#define MT6356_LDO_TOP_CLK_VSIM1_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xda4))
#define MT6356_LDO_TOP_CLK_VSIM2_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xda6))
#define MT6356_LDO_TOP_CLK_VCAMD_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xda8))
#define MT6356_LDO_TOP_CLK_VCAMIO_CON0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdaa))
#define MT6356_LDO_TOP_CLK_VMIPI_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdac))
#define MT6356_LDO_TOP_CLK_VCN33_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdae))
#define MT6356_LDO_TOP_CLK_VCN18_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdb0))
#define MT6356_LDO_TOP_CLK_VCN28_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdb2))
#define MT6356_LDO_TOP_CLK_VIBR_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdb4))
#define MT6356_LDO_TOP_CLK_VBIF28_CON0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdb6))
#define MT6356_LDO_TOP_CLK_VFE28_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdb8))
#define MT6356_LDO_TOP_CLK_VMCH_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdba))
#define MT6356_LDO_TOP_CLK_VMC_CON0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdbc))
#define MT6356_LDO_TOP_CLK_VRF18_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdbe))
#define MT6356_LDO_TOP_CLK_VLDO28_CON0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdc0))
#define MT6356_LDO_TOP_CLK_VRF12_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdc2))
#define MT6356_LDO_TOP_CLK_VCAMA_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdc4))
#define MT6356_LDO_TOP_RST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xdc6))
#define MT6356_LDO_TOP_RST_CON0_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdc8))
#define MT6356_LDO_TOP_RST_CON0_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdca))
#define MT6356_LDO_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xdcc))
#define MT6356_LDO_TOP_INT_CON0_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdce))
#define MT6356_LDO_TOP_INT_CON0_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdd0))
#define MT6356_LDO_TOP_INT_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xdd2))
#define MT6356_LDO_TOP_INT_CON1_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdd4))
#define MT6356_LDO_TOP_INT_CON1_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdd6))
#define MT6356_LDO_TOP_INT_MASK_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdd8))
#define MT6356_LDO_TOP_INT_MASK_CON0_SET                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdda))
#define MT6356_LDO_TOP_INT_MASK_CON0_CLR                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xddc))
#define MT6356_LDO_TOP_INT_MASK_CON1                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdde))
#define MT6356_LDO_TOP_INT_MASK_CON1_SET                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xde0))
#define MT6356_LDO_TOP_INT_MASK_CON1_CLR                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xde2))
#define MT6356_LDO_TOP_INT_STATUS0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xde4))
#define MT6356_LDO_TOP_INT_STATUS1                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xde6))
#define MT6356_LDO_TOP_INT_RAW_STATUS0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xde8))
#define MT6356_LDO_TOP_INT_RAW_STATUS1                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xdea))
#define MT6356_LDO_TEST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xdec))
#define MT6356_LDO_TOP_WDT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xdee))
#define MT6356_LDO_TOP_RSV_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xdf0))
#define MT6356_LDO_TOP_RSV_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xdf2))
#define MT6356_LDO_GON_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe00))
#define MT6356_LDO_GON_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe02))
#define MT6356_LDO_GON_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe04))
#define MT6356_LDO_GON_RSV_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe06))
#define MT6356_LDO_GON_RSV_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe08))
#define MT6356_LDO_VXO22_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe0a))
#define MT6356_LDO_VXO22_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe0c))
#define MT6356_LDO_VXO22_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe0e))
#define MT6356_LDO_VXO22_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe10))
#define MT6356_LDO_VXO22_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe12))
#define MT6356_LDO_VXO22_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe14))
#define MT6356_LDO_VXO22_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe16))
#define MT6356_LDO_VXO22_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe18))
#define MT6356_LDO_VXO22_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe1a))
#define MT6356_LDO_VXO22_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe1c))
#define MT6356_LDO_VA12_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe1e))
#define MT6356_LDO_VA12_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe20))
#define MT6356_LDO_VA12_OP_EN_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe22))
#define MT6356_LDO_VA12_OP_EN_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe24))
#define MT6356_LDO_VA12_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe26))
#define MT6356_LDO_VA12_OP_CFG_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe28))
#define MT6356_LDO_VA12_OP_CFG_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe2a))
#define MT6356_LDO_VA12_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe2c))
#define MT6356_LDO_VA12_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe2e))
#define MT6356_LDO_VA12_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe30))
#define MT6356_LDO_VAUX18_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe32))
#define MT6356_LDO_VAUX18_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe34))
#define MT6356_LDO_VAUX18_OP_EN_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe36))
#define MT6356_LDO_VAUX18_OP_EN_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe38))
#define MT6356_LDO_VAUX18_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe3a))
#define MT6356_LDO_VAUX18_OP_CFG_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe3c))
#define MT6356_LDO_VAUX18_OP_CFG_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe3e))
#define MT6356_LDO_VAUX18_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe40))
#define MT6356_LDO_VAUX18_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe42))
#define MT6356_LDO_VAUX18_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe44))
#define MT6356_LDO_VAUD28_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe46))
#define MT6356_LDO_VAUD28_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe48))
#define MT6356_LDO_VAUD28_OP_EN_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe4a))
#define MT6356_LDO_VAUD28_OP_EN_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe4c))
#define MT6356_LDO_VAUD28_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe4e))
#define MT6356_LDO_VAUD28_OP_CFG_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe50))
#define MT6356_LDO_VAUD28_OP_CFG_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe52))
#define MT6356_LDO_VAUD28_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe54))
#define MT6356_LDO_VAUD28_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe56))
#define MT6356_LDO_VAUD28_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe58))
#define MT6356_LDO_VIO28_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe5a))
#define MT6356_LDO_VIO28_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe5c))
#define MT6356_LDO_VIO28_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe5e))
#define MT6356_LDO_VIO28_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe60))
#define MT6356_LDO_VIO28_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe62))
#define MT6356_LDO_VIO28_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe64))
#define MT6356_LDO_VIO28_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe66))
#define MT6356_LDO_VIO28_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe68))
#define MT6356_LDO_VIO28_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe6a))
#define MT6356_LDO_VIO28_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe6c))
#define MT6356_LDO_VIO18_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe6e))
#define MT6356_LDO_VIO18_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe70))
#define MT6356_LDO_VIO18_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe72))
#define MT6356_LDO_VIO18_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe74))
#define MT6356_LDO_VIO18_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe76))
#define MT6356_LDO_VIO18_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe78))
#define MT6356_LDO_VIO18_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe7a))
#define MT6356_LDO_VIO18_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe7c))
#define MT6356_LDO_VIO18_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe7e))
#define MT6356_LDO_VIO18_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe80))
#define MT6356_LDO_VDRAM_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe82))
#define MT6356_LDO_VDRAM_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe84))
#define MT6356_LDO_VDRAM_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe86))
#define MT6356_LDO_VDRAM_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe88))
#define MT6356_LDO_VDRAM_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe8a))
#define MT6356_LDO_VDRAM_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe8c))
#define MT6356_LDO_VDRAM_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe8e))
#define MT6356_LDO_VDRAM_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe90))
#define MT6356_LDO_VDRAM_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe92))
#define MT6356_LDO_VDRAM_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe94))
#define MT6356_LDO_VEMC_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe96))
#define MT6356_LDO_VEMC_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe98))
#define MT6356_LDO_VEMC_OP_EN_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe9a))
#define MT6356_LDO_VEMC_OP_EN_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xe9c))
#define MT6356_LDO_VEMC_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xe9e))
#define MT6356_LDO_VEMC_OP_CFG_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xea0))
#define MT6356_LDO_VEMC_OP_CFG_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xea2))
#define MT6356_LDO_VEMC_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xea4))
#define MT6356_LDO_VEMC_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xea6))
#define MT6356_LDO_VEMC_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xea8))
#define MT6356_LDO_VA12_ULP_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xeaa))
#define MT6356_LDO_VIO28_ULP_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xeac))
#define MT6356_LDO_OCFB0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xeae))
#define MT6356_LDO_LP_PROTECTION ((unsigned int)(MT6356_PMIC_REG_BASE + 0xeb0))
#define MT6356_LDO_DUMMY_LOAD_GATED                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xeb2))
#define MT6356_LDO_GOFF0_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf00))
#define MT6356_LDO_GOFF0_DSN_REV0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf02))
#define MT6356_LDO_GOFF0_DSN_REV1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf04))
#define MT6356_LDO_GOFF0_RSV_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf06))
#define MT6356_LDO_GOFF0_RSV_CON1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf08))
#define MT6356_LDO_VFE28_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf0a))
#define MT6356_LDO_VFE28_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf0c))
#define MT6356_LDO_VFE28_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf0e))
#define MT6356_LDO_VFE28_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf10))
#define MT6356_LDO_VFE28_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf12))
#define MT6356_LDO_VFE28_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf14))
#define MT6356_LDO_VFE28_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf16))
#define MT6356_LDO_VFE28_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf18))
#define MT6356_LDO_VFE28_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf1a))
#define MT6356_LDO_VFE28_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf1c))
#define MT6356_LDO_VRF18_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf1e))
#define MT6356_LDO_VRF18_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf20))
#define MT6356_LDO_VRF18_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf22))
#define MT6356_LDO_VRF18_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf24))
#define MT6356_LDO_VRF18_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf26))
#define MT6356_LDO_VRF18_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf28))
#define MT6356_LDO_VRF18_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf2a))
#define MT6356_LDO_VRF18_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf2c))
#define MT6356_LDO_VRF18_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf2e))
#define MT6356_LDO_VRF18_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf30))
#define MT6356_LDO_VRF12_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf32))
#define MT6356_LDO_VRF12_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf34))
#define MT6356_LDO_VRF12_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf36))
#define MT6356_LDO_VRF12_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf38))
#define MT6356_LDO_VRF12_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf3a))
#define MT6356_LDO_VRF12_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf3c))
#define MT6356_LDO_VRF12_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf3e))
#define MT6356_LDO_VRF12_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf40))
#define MT6356_LDO_VRF12_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf42))
#define MT6356_LDO_VRF12_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf44))
#define MT6356_LDO_VMIPI_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf46))
#define MT6356_LDO_VMIPI_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf48))
#define MT6356_LDO_VMIPI_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf4a))
#define MT6356_LDO_VMIPI_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf4c))
#define MT6356_LDO_VMIPI_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf4e))
#define MT6356_LDO_VMIPI_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf50))
#define MT6356_LDO_VMIPI_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf52))
#define MT6356_LDO_VMIPI_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf54))
#define MT6356_LDO_VMIPI_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf56))
#define MT6356_LDO_VMIPI_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf58))
#define MT6356_LDO_VCN18_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf5a))
#define MT6356_LDO_VCN18_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf5c))
#define MT6356_LDO_VCN18_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf5e))
#define MT6356_LDO_VCN18_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf60))
#define MT6356_LDO_VCN18_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf62))
#define MT6356_LDO_VCN18_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf64))
#define MT6356_LDO_VCN18_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf66))
#define MT6356_LDO_VCN18_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf68))
#define MT6356_LDO_VCN18_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf6a))
#define MT6356_LDO_VCN18_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf6c))
#define MT6356_LDO_VCAMA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf6e))
#define MT6356_LDO_VCAMA_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf70))
#define MT6356_LDO_VCAMA_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf72))
#define MT6356_LDO_VCAMA_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf74))
#define MT6356_LDO_VCAMA_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf76))
#define MT6356_LDO_VCAMA_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf78))
#define MT6356_LDO_VCAMA_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf7a))
#define MT6356_LDO_VCAMA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf7c))
#define MT6356_LDO_VCAMA_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf7e))
#define MT6356_LDO_VCAMA_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf80))
#define MT6356_LDO_VCAMD_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf82))
#define MT6356_LDO_VCAMD_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf84))
#define MT6356_LDO_VCAMD_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf86))
#define MT6356_LDO_VCAMD_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf88))
#define MT6356_LDO_VCAMD_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf8a))
#define MT6356_LDO_VCAMD_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf8c))
#define MT6356_LDO_VCAMD_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf8e))
#define MT6356_LDO_VCAMD_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf90))
#define MT6356_LDO_VCAMD_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf92))
#define MT6356_LDO_VCAMD_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf94))
#define MT6356_LDO_VCAMIO_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf96))
#define MT6356_LDO_VCAMIO_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf98))
#define MT6356_LDO_VCAMIO_OP_EN_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf9a))
#define MT6356_LDO_VCAMIO_OP_EN_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xf9c))
#define MT6356_LDO_VCAMIO_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xf9e))
#define MT6356_LDO_VCAMIO_OP_CFG_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfa0))
#define MT6356_LDO_VCAMIO_OP_CFG_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfa2))
#define MT6356_LDO_VCAMIO_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfa4))
#define MT6356_LDO_VCAMIO_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfa6))
#define MT6356_LDO_VCAMIO_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfa8))
#define MT6356_LDO_VMC_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfaa))
#define MT6356_LDO_VMC_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfac))
#define MT6356_LDO_VMC_OP_EN_SET ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfae))
#define MT6356_LDO_VMC_OP_EN_CLR ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfb0))
#define MT6356_LDO_VMC_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfb2))
#define MT6356_LDO_VMC_OP_CFG_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfb4))
#define MT6356_LDO_VMC_OP_CFG_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfb6))
#define MT6356_LDO_VMC_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfb8))
#define MT6356_LDO_VMC_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfba))
#define MT6356_LDO_VMC_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfbc))
#define MT6356_LDO_VMCH_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfbe))
#define MT6356_LDO_VMCH_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfc0))
#define MT6356_LDO_VMCH_OP_EN_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfc2))
#define MT6356_LDO_VMCH_OP_EN_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfc4))
#define MT6356_LDO_VMCH_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfc6))
#define MT6356_LDO_VMCH_OP_CFG_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfc8))
#define MT6356_LDO_VMCH_OP_CFG_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfca))
#define MT6356_LDO_VMCH_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfcc))
#define MT6356_LDO_VMCH_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfce))
#define MT6356_LDO_VMCH_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfd0))
#define MT6356_LDO_VSIM1_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfd2))
#define MT6356_LDO_VSIM1_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfd4))
#define MT6356_LDO_VSIM1_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfd6))
#define MT6356_LDO_VSIM1_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfd8))
#define MT6356_LDO_VSIM1_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfda))
#define MT6356_LDO_VSIM1_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfdc))
#define MT6356_LDO_VSIM1_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfde))
#define MT6356_LDO_VSIM1_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfe0))
#define MT6356_LDO_VSIM1_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfe2))
#define MT6356_LDO_VSIM1_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfe4))
#define MT6356_LDO_VSIM2_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfe6))
#define MT6356_LDO_VSIM2_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfe8))
#define MT6356_LDO_VSIM2_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfea))
#define MT6356_LDO_VSIM2_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xfec))
#define MT6356_LDO_VSIM2_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0xfee))
#define MT6356_LDO_VSIM2_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xff0))
#define MT6356_LDO_VSIM2_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0xff2))
#define MT6356_LDO_VSIM2_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xff4))
#define MT6356_LDO_VSIM2_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xff6))
#define MT6356_LDO_VSIM2_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0xff8))
#define MT6356_LDO_GOFF1_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1000))
#define MT6356_LDO_GOFF1_DSN_REV0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1002))
#define MT6356_LDO_GOFF1_DSN_REV1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1004))
#define MT6356_LDO_GOFF1_RSV_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1006))
#define MT6356_LDO_GOFF1_RSV_CON1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1008))
#define MT6356_LDO_VIBR_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x100a))
#define MT6356_LDO_VIBR_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0x100c))
#define MT6356_LDO_VIBR_OP_EN_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x100e))
#define MT6356_LDO_VIBR_OP_EN_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1010))
#define MT6356_LDO_VIBR_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1012))
#define MT6356_LDO_VIBR_OP_CFG_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1014))
#define MT6356_LDO_VIBR_OP_CFG_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1016))
#define MT6356_LDO_VIBR_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1018))
#define MT6356_LDO_VIBR_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x101a))
#define MT6356_LDO_VIBR_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x101c))
#define MT6356_LDO_VBIF28_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x101e))
#define MT6356_LDO_VBIF28_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1020))
#define MT6356_LDO_VBIF28_OP_EN_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1022))
#define MT6356_LDO_VBIF28_OP_EN_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1024))
#define MT6356_LDO_VBIF28_OP_CFG                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1026))
#define MT6356_LDO_VBIF28_OP_CFG_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1028))
#define MT6356_LDO_VBIF28_OP_CFG_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x102a))
#define MT6356_LDO_VBIF28_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x102c))
#define MT6356_LDO_VBIF28_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x102e))
#define MT6356_LDO_VBIF28_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1030))
#define MT6356_LDO_MULTIUSER_DSN_ID                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1040))
#define MT6356_LDO_MULTIUSER_DSN_REV0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1042))
#define MT6356_LDO_MULTIUSER_DSN_REV1                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1044))
#define MT6356_LDO_MULTIUSER_RSV_CON0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1046))
#define MT6356_LDO_MULTIUSER_RSV_CON1                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1048))
#define MT6356_LDO_VCN33_CON0_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x104a))
#define MT6356_LDO_VCN33_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0x104c))
#define MT6356_LDO_VCN33_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x104e))
#define MT6356_LDO_VCN33_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1050))
#define MT6356_LDO_VCN33_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1052))
#define MT6356_LDO_VCN33_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1054))
#define MT6356_LDO_VCN33_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1056))
#define MT6356_LDO_VCN33_CON0_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1058))
#define MT6356_LDO_VCN33_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x105a))
#define MT6356_LDO_VCN33_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x105c))
#define MT6356_LDO_VCN33_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x105e))
#define MT6356_LDO_VLDO28_CON0_0                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1060))
#define MT6356_LDO_VLDO28_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1062))
#define MT6356_LDO_VLDO28_OP_EN_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1064))
#define MT6356_LDO_VLDO28_OP_EN_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1066))
#define MT6356_LDO_VLDO28_OP_CFG                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1068))
#define MT6356_LDO_VLDO28_OP_CFG_SET                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x106a))
#define MT6356_LDO_VLDO28_OP_CFG_CLR                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x106c))
#define MT6356_LDO_VLDO28_CON0_1                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x106e))
#define MT6356_LDO_VLDO28_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1070))
#define MT6356_LDO_VLDO28_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1072))
#define MT6356_LDO_VLDO28_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1074))
#define MT6356_LDO_VUSB_CON0_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1076))
#define MT6356_LDO_VUSB_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1078))
#define MT6356_LDO_VUSB_OP_EN_SET                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x107a))
#define MT6356_LDO_VUSB_OP_EN_CLR                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x107c))
#define MT6356_LDO_VUSB_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0x107e))
#define MT6356_LDO_VUSB_OP_CFG_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1080))
#define MT6356_LDO_VUSB_OP_CFG_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1082))
#define MT6356_LDO_VUSB_CON0_1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1084))
#define MT6356_LDO_VUSB_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1086))
#define MT6356_LDO_VUSB_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1088))
#define MT6356_LDO_VUSB_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x108a))
#define MT6356_LDO_VLDO28_ULP_CON0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x108c))
#define MT6356_LDO_VUSB_ULP_CON0                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x108e))
#define MT6356_LDO_FOURUSER_DSN_ID                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10c0))
#define MT6356_LDO_FOURUSER_DSN_REV0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10c2))
#define MT6356_LDO_FOURUSER_DSN_REV1                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10c4))
#define MT6356_LDO_FOURUSER_RSV_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10c6))
#define MT6356_LDO_FOURUSER_RSV_CON1                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10c8))
#define MT6356_LDO_VCN28_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x10ca))
#define MT6356_LDO_VCN28_OP_EN ((unsigned int)(MT6356_PMIC_REG_BASE + 0x10cc))
#define MT6356_LDO_VCN28_OP_EN_SET                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10ce))
#define MT6356_LDO_VCN28_OP_EN_CLR                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10d0))
#define MT6356_LDO_VCN28_OP_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0x10d2))
#define MT6356_LDO_VCN28_OP_CFG_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10d4))
#define MT6356_LDO_VCN28_OP_CFG_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x10d6))
#define MT6356_LDO_VCN28_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x10d8))
#define MT6356_LDO_VCN28_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x10da))
#define MT6356_LDO_VCN28_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x10dc))
#define MT6356_LDO_VSRAM_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1100))
#define MT6356_LDO_VSRAM_DSN_REV0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1102))
#define MT6356_LDO_VSRAM_DSN_REV1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1104))
#define MT6356_LDO_VSRAM_RSV_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1106))
#define MT6356_LDO_VSRAM_RSV_CON1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1108))
#define MT6356_LDO_VSRAM_PROC_CON0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x110a))
#define MT6356_LDO_VSRAM_PROC_CON2                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x110c))
#define MT6356_LDO_VSRAM_PROC_CFG0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x110e))
#define MT6356_LDO_VSRAM_PROC_CFG1                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1110))
#define MT6356_LDO_VSRAM_PROC_OP_EN                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1112))
#define MT6356_LDO_VSRAM_PROC_OP_EN_SET                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1114))
#define MT6356_LDO_VSRAM_PROC_OP_EN_CLR                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1116))
#define MT6356_LDO_VSRAM_PROC_OP_CFG                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1118))
#define MT6356_LDO_VSRAM_PROC_OP_CFG_SET                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x111a))
#define MT6356_LDO_VSRAM_PROC_OP_CFG_CLR                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x111c))
#define MT6356_LDO_VSRAM_PROC_CON3                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x111e))
#define MT6356_LDO_VSRAM_PROC_CON4                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1120))
#define MT6356_LDO_VSRAM_PROC_CON5                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1122))
#define MT6356_LDO_VSRAM_PROC_DBG0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1124))
#define MT6356_LDO_VSRAM_PROC_DBG1                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1126))
#define MT6356_LDO_VSRAM_OTHERS_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1128))
#define MT6356_LDO_VSRAM_OTHERS_CON2                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x112a))
#define MT6356_LDO_VSRAM_OTHERS_CFG0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x112c))
#define MT6356_LDO_VSRAM_OTHERS_CFG1                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x112e))
#define MT6356_LDO_VSRAM_OTHERS_OP_EN                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1130))
#define MT6356_LDO_VSRAM_OTHERS_OP_EN_SET                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1132))
#define MT6356_LDO_VSRAM_OTHERS_OP_EN_CLR                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1134))
#define MT6356_LDO_VSRAM_OTHERS_OP_CFG                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1136))
#define MT6356_LDO_VSRAM_OTHERS_OP_CFG_SET                                    \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1138))
#define MT6356_LDO_VSRAM_OTHERS_OP_CFG_CLR                                    \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x113a))
#define MT6356_LDO_VSRAM_OTHERS_CON3                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x113c))
#define MT6356_LDO_VSRAM_OTHERS_CON4                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x113e))
#define MT6356_LDO_VSRAM_OTHERS_CON5                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1140))
#define MT6356_LDO_VSRAM_OTHERS_DBG0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1142))
#define MT6356_LDO_VSRAM_OTHERS_DBG1                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1144))
#define MT6356_LDO_VSRAM_GPU_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1146))
#define MT6356_LDO_VSRAM_GPU_CON2                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1148))
#define MT6356_LDO_VSRAM_GPU_CFG0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x114a))
#define MT6356_LDO_VSRAM_GPU_CFG1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x114c))
#define MT6356_LDO_VSRAM_GPU_OP_EN                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x114e))
#define MT6356_LDO_VSRAM_GPU_OP_EN_SET                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1150))
#define MT6356_LDO_VSRAM_GPU_OP_EN_CLR                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1152))
#define MT6356_LDO_VSRAM_GPU_OP_CFG                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1154))
#define MT6356_LDO_VSRAM_GPU_OP_CFG_SET                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1156))
#define MT6356_LDO_VSRAM_GPU_OP_CFG_CLR                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1158))
#define MT6356_LDO_VSRAM_GPU_CON3                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x115a))
#define MT6356_LDO_VSRAM_GPU_CON4                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x115c))
#define MT6356_LDO_VSRAM_GPU_CON5                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x115e))
#define MT6356_LDO_VSRAM_GPU_DBG0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1160))
#define MT6356_LDO_VSRAM_GPU_DBG1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1162))
#define MT6356_LDO_VSRAM_PROC_SP                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1164))
#define MT6356_LDO_VSRAM_GPU_SP ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1166))
#define MT6356_LDO_VSRAM_OTHERS_SP                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1168))
#define MT6356_LDO_VSRAM_CORE_SSHUB                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x116a))
#define MT6356_LDO_VSRAM_PROC_R2R_PDN_DIS                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x116c))
#define MT6356_LDO_VSRAM_OTHERS_R2R_PDN_DIS                                   \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x116e))
#define MT6356_LDO_VSRAM_GPU_R2R_PDN_DIS                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1170))
#define MT6356_LDO_TRACKING_CON0                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1172))
#define MT6356_LDO_TRACKING_CON1                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1174))
#define MT6356_LDO_TRACKING_CON2                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1176))
#define MT6356_LDO_TRACKING_CON3                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1178))
#define MT6356_LDO_VSRAM_STB_CON                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x117a))
#define MT6356_LDO_VSRAM_SLP_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x117c))
#define MT6356_LDO_VSRAM_SLP_CON1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x117e))
#define MT6356_LDO_VSRAM_SLP_CON2                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1180))
#define MT6356_LDO_VSRAM_WDT_DBG0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1182))
#define MT6356_LDO_VSRAM_WDT_DBG1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1184))
#define MT6356_LDO_VSRAM_ELR_NUM                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1186))
#define MT6356_LDO_VSRAM_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1188))
#define MT6356_LDO_VSRAM_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x118a))
#define MT6356_LDO_VSRAM_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x118c))
#define MT6356_LDO_VSRAM_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x118e))
#define MT6356_LDO_VRTC_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1200))
#define MT6356_LDO_VRTC_DSN_REV0                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1202))
#define MT6356_LDO_VRTC_DSN_REV1                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1204))
#define MT6356_LDO_VRTC_RSV_CON0                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1206))
#define MT6356_LDO_VRTC_RSV_CON1                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1208))
#define MT6356_VRTC_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x120a))
#define MT6356_LDO_ANA_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1240))
#define MT6356_LDO_ANA_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1242))
#define MT6356_LDO_ANA_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1244))
#define MT6356_VCAMA_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1246))
#define MT6356_VCAMA_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1248))
#define MT6356_VFE28_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x124a))
#define MT6356_VFE28_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x124c))
#define MT6356_VCN28_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x124e))
#define MT6356_VCN28_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1250))
#define MT6356_VBIF28_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1252))
#define MT6356_VBIF28_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1254))
#define MT6356_VAUD28_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1256))
#define MT6356_VAUD28_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1258))
#define MT6356_VAUX18_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x125a))
#define MT6356_VAUX18_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x125c))
#define MT6356_VXO22_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x125e))
#define MT6356_VXO22_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1260))
#define MT6356_VCN33_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1262))
#define MT6356_VCN33_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1264))
#define MT6356_VUSB_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1266))
#define MT6356_VUSB_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1268))
#define MT6356_VEMC_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x126a))
#define MT6356_VEMC_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x126c))
#define MT6356_VLDO28_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x126e))
#define MT6356_VLDO28_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1270))
#define MT6356_VIO28_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1272))
#define MT6356_VIO28_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1274))
#define MT6356_VIBR_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1276))
#define MT6356_VIBR_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1278))
#define MT6356_VSIM1_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x127a))
#define MT6356_VSIM1_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x127c))
#define MT6356_VSIM2_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x127e))
#define MT6356_VSIM2_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1280))
#define MT6356_VMCH_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1282))
#define MT6356_VMCH_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1284))
#define MT6356_VMC_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1286))
#define MT6356_VMC_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1288))
#define MT6356_VCAMIO_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x128a))
#define MT6356_VCAMIO_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x128c))
#define MT6356_VCN18_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x128e))
#define MT6356_VCN18_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1290))
#define MT6356_VRF18_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1292))
#define MT6356_VRF18_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1294))
#define MT6356_VIO18_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1296))
#define MT6356_VIO18_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1298))
#define MT6356_VMIPI_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x129a))
#define MT6356_VMIPI_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x129c))
#define MT6356_VDRAM_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x129e))
#define MT6356_VDRAM_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12a0))
#define MT6356_VRF12_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12a2))
#define MT6356_VRF12_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12a4))
#define MT6356_VA12_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12a6))
#define MT6356_VA12_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12a8))
#define MT6356_VSRAM_PROC_ANA_CON0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x12aa))
#define MT6356_VSRAM_OTHERS_ANA_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x12ac))
#define MT6356_VSRAM_GPU_ANA_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x12ae))
#define MT6356_CAMD_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12b0))
#define MT6356_CAMD_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12b2))
#define MT6356_LDO_ANA_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12b4))
#define MT6356_VCAMA_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12b6))
#define MT6356_VFE28_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12b8))
#define MT6356_VCN28_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12ba))
#define MT6356_VBIF28_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12bc))
#define MT6356_VAUD28_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12be))
#define MT6356_VAUX18_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12c0))
#define MT6356_VXO22_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12c2))
#define MT6356_VCN33_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12c4))
#define MT6356_VUSB_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12c6))
#define MT6356_VEMC_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12c8))
#define MT6356_VLDO28_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12ca))
#define MT6356_VIO28_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12cc))
#define MT6356_VIBR_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12ce))
#define MT6356_VSIM1_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12d0))
#define MT6356_VSIM2_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12d2))
#define MT6356_VMCH_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12d4))
#define MT6356_VMC_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12d6))
#define MT6356_VCAMIO_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12d8))
#define MT6356_VCN18_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12da))
#define MT6356_VRF18_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12dc))
#define MT6356_VIO18_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12de))
#define MT6356_VMIPI_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12e0))
#define MT6356_VDRAM_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12e2))
#define MT6356_VRF12_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12e4))
#define MT6356_VA12_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12e6))
#define MT6356_VSRAM_PROC_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12e8))
#define MT6356_VSRAM_OTHERS_ELR_0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x12ea))
#define MT6356_VSRAM_GPU_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12ec))
#define MT6356_CAMD_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12ee))
#define MT6356_VRTC_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x12f0))
#define MT6356_XPP_TOP_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1340))
#define MT6356_XPP_TOP_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1342))
#define MT6356_XPP_TOP_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1344))
#define MT6356_XPP_TOP_PAM0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1346))
#define MT6356_XPP_TOP_PAM1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1348))
#define MT6356_XPP_TOP_TEST_OUT ((unsigned int)(MT6356_PMIC_REG_BASE + 0x134a))
#define MT6356_XPP_TOP_TEST_CON0                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x134c))
#define MT6356_XPP_TOP_CKPDN_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x134e))
#define MT6356_XPP_TOP_CKPDN_CON0_SET                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1350))
#define MT6356_XPP_TOP_CKPDN_CON0_CLR                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1352))
#define MT6356_XPP_TOP_CKSEL_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1354))
#define MT6356_XPP_TOP_CKSEL_CON0_SET                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1356))
#define MT6356_XPP_TOP_CKSEL_CON0_CLR                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1358))
#define MT6356_XPP_TOP_CKDIVSEL_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x135a))
#define MT6356_XPP_TOP_CKDIVSEL_CON0_SET                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x135c))
#define MT6356_XPP_TOP_CKDIVSEL_CON0_CLR                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x135e))
#define MT6356_XPP_TOP_CKHWEN_CON0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1360))
#define MT6356_XPP_TOP_CKHWEN_CON0_SET                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1362))
#define MT6356_XPP_TOP_CKHWEN_CON0_CLR                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1364))
#define MT6356_XPP_TOP_RST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1366))
#define MT6356_XPP_TOP_RST_CON0_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1368))
#define MT6356_XPP_TOP_RST_CON0_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x136a))
#define MT6356_XPP_TOP_RST_BANK_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x136c))
#define MT6356_XPP_TOP_RST_BANK_CON0_SET                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x136e))
#define MT6356_XPP_TOP_RST_BANK_CON0_CLR                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1370))
#define MT6356_XPP_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1372))
#define MT6356_XPP_TOP_INT_CON0_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1374))
#define MT6356_XPP_TOP_INT_CON0_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1376))
#define MT6356_XPP_TOP_INT_MASK_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1378))
#define MT6356_XPP_TOP_INT_MASK_CON0_SET                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x137a))
#define MT6356_XPP_TOP_INT_MASK_CON0_CLR                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x137c))
#define MT6356_XPP_TOP_INT_STATUS0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x137e))
#define MT6356_XPP_TOP_INT_RAW_STATUS0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1380))
#define MT6356_XPP_TOP_INT_MISC_CON                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1382))
#define MT6356_DRIVER_BL_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13c0))
#define MT6356_DRIVER_BL_DSN_REV0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x13c2))
#define MT6356_DRIVER_BL_DSN_REV1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x13c4))
#define MT6356_ISINK0_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13c6))
#define MT6356_ISINK0_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13c8))
#define MT6356_ISINK0_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13ca))
#define MT6356_ISINK0_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13cc))
#define MT6356_ISINK1_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13ce))
#define MT6356_ISINK1_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13d0))
#define MT6356_ISINK1_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13d2))
#define MT6356_ISINK1_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13d4))
#define MT6356_ISINK_ANA1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13d6))
#define MT6356_ISINK_PHASE_DLY ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13d8))
#define MT6356_ISINK_SFSTR ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13da))
#define MT6356_ISINK_EN_CTRL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13dc))
#define MT6356_ISINK_MODE_CTRL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13de))
#define MT6356_ISINK_PWM_CTRL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13e0))
#define MT6356_ISINK_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x13e2))
#define MT6356_DRIVER_CI_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1400))
#define MT6356_DRIVER_CI_DSN_REV0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1402))
#define MT6356_DRIVER_CI_DSN_REV1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1404))
#define MT6356_CHRIND_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1406))
#define MT6356_CHRIND_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1408))
#define MT6356_CHRIND_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x140a))
#define MT6356_CHRIND_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x140c))
#define MT6356_CHRIND_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x140e))
#define MT6356_CHRIND_EN_CTRL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1410))
#define MT6356_DRIVER_DL_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1440))
#define MT6356_DRIVER_DL_DSN_REV0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1442))
#define MT6356_DRIVER_DL_DSN_REV1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1444))
#define MT6356_ISINK2_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1446))
#define MT6356_ISINK3_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1448))
#define MT6356_ISINK_CHOPSW_CON0                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x144a))
#define MT6356_ISINK_EN_CTRL_SMPL                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x144c))
#define MT6356_DRIVER_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1480))
#define MT6356_DRIVER_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1482))
#define MT6356_DRIVER_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1484))
#define MT6356_DRIVER_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1486))
#define MT6356_DRIVER_ANA_ELR_NUM                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1488))
#define MT6356_DRIVER_ANA_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x148a))
#define MT6356_TYPE_C_DIG_DSN_ID                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14c0))
#define MT6356_TYPE_C_DIG_DSN_REV0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14c2))
#define MT6356_TYPE_C_DIG_DSN_REV1                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14c4))
#define MT6356_TYPE_C_PHY_RG_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14c6))
#define MT6356_TYPE_C_PHY_RG_CC_RESERVE_CSR                                   \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14c8))
#define MT6356_TYPE_C_VCMP_CTRL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14ca))
#define MT6356_TYPE_C_CTRL ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14cc))
#define MT6356_TYPE_C_CC_SW_CTRL                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14ce))
#define MT6356_TYPE_C_CC_VOL_PERIODIC_MEAS_VAL                                \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14d0))
#define MT6356_TYPE_C_CC_VOL_DEBOUCE_CNT_VAL                                  \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14d2))
#define MT6356_TYPE_C_DRP_SRC_CNT_VAL_0                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14d4))
#define MT6356_TYPE_C_DRP_SNK_CNT_VAL_0                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14d6))
#define MT6356_TYPE_C_DRP_TRY_CNT_VAL_0                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14d8))
#define MT6356_TYPE_C_CC_SRC_DEFAULT_DAC_VAL                                  \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14da))
#define MT6356_TYPE_C_CC_SRC_15_DAC_VAL                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14dc))
#define MT6356_TYPE_C_CC_SRC_30_DAC_VAL                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14de))
#define MT6356_TYPE_C_CC_SNK_DAC_VAL_0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14e0))
#define MT6356_TYPE_C_CC_SNK_DAC_VAL_1                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14e2))
#define MT6356_TYPE_C_INTR_EN_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14e4))
#define MT6356_TYPE_C_INTR_EN_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14e6))
#define MT6356_TYPE_C_INTR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14e8))
#define MT6356_TYPE_C_INTR_2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14ea))
#define MT6356_TYPE_C_CC_STATUS ((unsigned int)(MT6356_PMIC_REG_BASE + 0x14ec))
#define MT6356_TYPE_C_PWR_STATUS                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14ee))
#define MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0                               \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14f0))
#define MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0                                  \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14f2))
#define MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_1                                  \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14f4))
#define MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_1                               \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14f6))
#define MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_2                                  \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14f8))
#define MT6356_TYPE_C_CC_DAC_CALI_CTRL                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14fa))
#define MT6356_TYPE_C_CC_DAC_CALI_RESULT                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14fc))
#define MT6356_TYPE_C_DEBUG_PORT_SELECT_0                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x14fe))
#define MT6356_TYPE_C_DEBUG_PORT_SELECT_1                                     \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1500))
#define MT6356_TYPE_C_DEBUG_MODE_SELECT                                       \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1502))
#define MT6356_TYPE_C_DEBUG_OUT_READ_0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1504))
#define MT6356_TYPE_C_DEBUG_OUT_READ_1                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1506))
#define MT6356_TYPE_C_SW_DEBUG_PORT_0                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1508))
#define MT6356_TYPE_C_SW_DEBUG_PORT_1                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x150a))
#define MT6356_TYPE_C_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x150c))
#define MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_0                                 \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x150e))
#define MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_1                                 \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1510))
#define MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_0                                 \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1512))
#define MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_1                                 \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1514))
#define MT6356_AUD_TOP_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1540))
#define MT6356_AUD_TOP_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1542))
#define MT6356_AUD_TOP_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1544))
#define MT6356_AUD_TOP_CKPDN_PM0                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1546))
#define MT6356_AUD_TOP_CKPDN_PM1                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1548))
#define MT6356_AUD_TOP_CKPDN_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x154a))
#define MT6356_AUD_TOP_CKSEL_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x154c))
#define MT6356_AUD_TOP_CKTST_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x154e))
#define MT6356_AUD_TOP_RST_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1550))
#define MT6356_AUD_TOP_RST_BANK_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1552))
#define MT6356_AUD_TOP_INT_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1554))
#define MT6356_AUD_TOP_INT_CON0_SET                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1556))
#define MT6356_AUD_TOP_INT_CON0_CLR                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1558))
#define MT6356_AUD_TOP_INT_MASK_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x155a))
#define MT6356_AUD_TOP_INT_MASK_CON0_SET                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x155c))
#define MT6356_AUD_TOP_INT_MASK_CON0_CLR                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x155e))
#define MT6356_AUD_TOP_INT_STATUS0                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1560))
#define MT6356_AUD_TOP_INT_RAW_STATUS0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1562))
#define MT6356_AUD_TOP_INT_MISC_CON0                                          \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1564))
#define MT6356_AUDNCP_CLKDIV_CON0                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1566))
#define MT6356_AUDNCP_CLKDIV_CON1                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1568))
#define MT6356_AUDNCP_CLKDIV_CON2                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x156a))
#define MT6356_AUDNCP_CLKDIV_CON3                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x156c))
#define MT6356_AUDNCP_CLKDIV_CON4                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x156e))
#define MT6356_AUD_TOP_MON_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1570))
#define MT6356_AUDIO_DIG_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1580))
#define MT6356_AUDIO_DIG_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1582))
#define MT6356_AUDIO_DIG_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1584))
#define MT6356_AFE_UL_DL_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1586))
#define MT6356_AFE_DL_SRC2_CON0_L                                             \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x1588))
#define MT6356_AFE_UL_SRC_CON0_H                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x158a))
#define MT6356_AFE_UL_SRC_CON0_L                                              \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x158c))
#define MT6356_AFE_TOP_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x158e))
#define MT6356_AUDIO_TOP_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1590))
#define MT6356_AFE_MON_DEBUG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1592))
#define MT6356_AFUNC_AUD_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1594))
#define MT6356_AFUNC_AUD_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1596))
#define MT6356_AFUNC_AUD_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1598))
#define MT6356_AFUNC_AUD_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x159a))
#define MT6356_AFUNC_AUD_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x159c))
#define MT6356_AFUNC_AUD_MON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x159e))
#define MT6356_AUDRC_TUNE_MON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x15a0))
#define MT6356_AFE_ADDA_MTKAIF_FIFO_CFG0                                      \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15a2))
#define MT6356_AFE_ADDA_MTKAIF_FIFO_LOG_MON1                                  \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15a4))
#define MT6356_AFE_ADDA_MTKAIF_MON0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15a6))
#define MT6356_AFE_ADDA_MTKAIF_MON1                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15a8))
#define MT6356_AFE_ADDA_MTKAIF_MON2                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15aa))
#define MT6356_AFE_ADDA_MTKAIF_MON3                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15ac))
#define MT6356_AFE_ADDA_MTKAIF_CFG0                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15ae))
#define MT6356_AFE_ADDA_MTKAIF_RX_CFG0                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15b0))
#define MT6356_AFE_ADDA_MTKAIF_RX_CFG1                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15b2))
#define MT6356_AFE_ADDA_MTKAIF_RX_CFG2                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15b4))
#define MT6356_AFE_ADDA_MTKAIF_RX_CFG3                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15b6))
#define MT6356_AFE_ADDA_MTKAIF_TX_CFG1                                        \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15b8))
#define MT6356_AFE_SGEN_CFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x15ba))
#define MT6356_AFE_SGEN_CFG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x15bc))
#define MT6356_AFE_ADC_ASYNC_FIFO_CFG                                         \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15be))
#define MT6356_AFE_DCCLK_CFG0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x15c0))
#define MT6356_AFE_DCCLK_CFG1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x15c2))
#define MT6356_AUDIO_DIG_CFG ((unsigned int)(MT6356_PMIC_REG_BASE + 0x15c4))
#define MT6356_AFE_AUD_PAD_TOP ((unsigned int)(MT6356_PMIC_REG_BASE + 0x15c6))
#define MT6356_AFE_AUD_PAD_TOP_MON                                            \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15c8))
#define MT6356_AFE_AUD_PAD_TOP_MON1                                           \
	((unsigned int)(MT6356_PMIC_REG_BASE + 0x15ca))
#define MT6356_AUDENC_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1600))
#define MT6356_AUDENC_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1602))
#define MT6356_AUDENC_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1604))
#define MT6356_AUDENC_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1606))
#define MT6356_AUDENC_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1608))
#define MT6356_AUDENC_ANA_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x160a))
#define MT6356_AUDENC_ANA_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x160c))
#define MT6356_AUDENC_ANA_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x160e))
#define MT6356_AUDENC_ANA_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1610))
#define MT6356_AUDENC_ANA_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1612))
#define MT6356_AUDENC_ANA_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1614))
#define MT6356_AUDENC_ANA_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1616))
#define MT6356_AUDENC_ANA_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1618))
#define MT6356_AUDENC_ANA_CON10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x161a))
#define MT6356_AUDENC_ANA_CON11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x161c))
#define MT6356_AUDENC_ANA_CON12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x161e))
#define MT6356_AUDDEC_DSN_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1640))
#define MT6356_AUDDEC_DSN_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1642))
#define MT6356_AUDDEC_DSN_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1644))
#define MT6356_AUDDEC_ANA_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1646))
#define MT6356_AUDDEC_ANA_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1648))
#define MT6356_AUDDEC_ANA_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x164a))
#define MT6356_AUDDEC_ANA_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x164c))
#define MT6356_AUDDEC_ANA_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x164e))
#define MT6356_AUDDEC_ANA_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1650))
#define MT6356_AUDDEC_ANA_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1652))
#define MT6356_AUDDEC_ANA_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1654))
#define MT6356_AUDDEC_ANA_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1656))
#define MT6356_AUDDEC_ANA_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1658))
#define MT6356_AUDDEC_ANA_CON10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x165a))
#define MT6356_AUDDEC_ANA_CON11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x165c))
#define MT6356_AUDDEC_ANA_CON12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x165e))
#define MT6356_AUDDEC_ANA_CON13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1660))
#define MT6356_AUDDEC_ANA_CON14 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1662))
#define MT6356_AUDDEC_ANA_CON15 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1664))
#define MT6356_AUDDEC_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1666))
#define MT6356_AUDDEC_ELR_0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1668))
#define MT6356_AUDZCDID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1680))
#define MT6356_AUDZCDREV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1682))
#define MT6356_AUDZCDREV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1684))
#define MT6356_ZCD_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1686))
#define MT6356_ZCD_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1688))
#define MT6356_ZCD_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x168a))
#define MT6356_ZCD_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x168c))
#define MT6356_ZCD_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x168e))
#define MT6356_ZCD_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1690))
#define MT6356_ACCDET_DIG_ID ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16c0))
#define MT6356_ACCDET_DIG_REV0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16c2))
#define MT6356_ACCDET_DIG_REV1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16c4))
#define MT6356_ACCDET_CON0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16c6))
#define MT6356_ACCDET_CON1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16c8))
#define MT6356_ACCDET_CON2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16ca))
#define MT6356_ACCDET_CON3 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16cc))
#define MT6356_ACCDET_CON4 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16ce))
#define MT6356_ACCDET_CON5 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16d0))
#define MT6356_ACCDET_CON6 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16d2))
#define MT6356_ACCDET_CON7 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16d4))
#define MT6356_ACCDET_CON8 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16d6))
#define MT6356_ACCDET_CON9 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16d8))
#define MT6356_ACCDET_CON10 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16da))
#define MT6356_ACCDET_CON11 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16dc))
#define MT6356_ACCDET_CON12 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16de))
#define MT6356_ACCDET_CON13 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16e0))
#define MT6356_ACCDET_CON14 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16e2))
#define MT6356_ACCDET_CON15 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16e4))
#define MT6356_ACCDET_CON16 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16e6))
#define MT6356_ACCDET_CON17 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16e8))
#define MT6356_ACCDET_CON18 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16ea))
#define MT6356_ACCDET_CON19 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16ec))
#define MT6356_ACCDET_CON20 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16ee))
#define MT6356_ACCDET_CON21 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16f0))
#define MT6356_ACCDET_CON22 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16f2))
#define MT6356_ACCDET_CON23 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16f4))
#define MT6356_ACCDET_CON24 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16f6))
#define MT6356_ACCDET_CON25 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16f8))
#define MT6356_ACCDET_CON26 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16fa))
#define MT6356_ACCDET_CON27 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16fc))
#define MT6356_ACCDET_CON28 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x16fe))
#define MT6356_ACCDET_ELR_NUM ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1700))
#define MT6356_ACCDET_ELR0 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1702))
#define MT6356_ACCDET_ELR1 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1704))
#define MT6356_ACCDET_ELR2 ((unsigned int)(MT6356_PMIC_REG_BASE + 0x1706))
/* mask is HEX;  shift is Integer */
#define PMIC_TOP0_ANA_ID_ADDR MT6356_TOP0_ID
#define PMIC_TOP0_ANA_ID_MASK 0xFF
#define PMIC_TOP0_ANA_ID_SHIFT 0
#define PMIC_TOP0_DIG_ID_ADDR MT6356_TOP0_ID
#define PMIC_TOP0_DIG_ID_MASK 0xFF
#define PMIC_TOP0_DIG_ID_SHIFT 8
#define PMIC_TOP0_ANA_MINOR_REV_ADDR MT6356_TOP0_REV0
#define PMIC_TOP0_ANA_MINOR_REV_MASK 0xF
#define PMIC_TOP0_ANA_MINOR_REV_SHIFT 0
#define PMIC_TOP0_ANA_MAJOR_REV_ADDR MT6356_TOP0_REV0
#define PMIC_TOP0_ANA_MAJOR_REV_MASK 0xF
#define PMIC_TOP0_ANA_MAJOR_REV_SHIFT 4
#define PMIC_TOP0_DIG_MINOR_REV_ADDR MT6356_TOP0_REV0
#define PMIC_TOP0_DIG_MINOR_REV_MASK 0xF
#define PMIC_TOP0_DIG_MINOR_REV_SHIFT 8
#define PMIC_TOP0_DIG_MAJOR_REV_ADDR MT6356_TOP0_REV0
#define PMIC_TOP0_DIG_MAJOR_REV_MASK 0xF
#define PMIC_TOP0_DIG_MAJOR_REV_SHIFT 12
#define PMIC_TOP0_SW_MINOR_REV_ADDR MT6356_TOP0_REV1
#define PMIC_TOP0_SW_MINOR_REV_MASK 0xF
#define PMIC_TOP0_SW_MINOR_REV_SHIFT 0
#define PMIC_TOP0_SW_MAJOR_REV_ADDR MT6356_TOP0_REV1
#define PMIC_TOP0_SW_MAJOR_REV_MASK 0xF
#define PMIC_TOP0_SW_MAJOR_REV_SHIFT 4
#define PMIC_TOP0_ESP_ADDR MT6356_TOP0_REV1
#define PMIC_TOP0_ESP_MASK 0xFF
#define PMIC_TOP0_ESP_SHIFT 8
#define PMIC_HWCID_ADDR MT6356_HWCID
#define PMIC_HWCID_MASK 0xFFFF
#define PMIC_HWCID_SHIFT 0
#define PMIC_SWCID_ADDR MT6356_SWCID
#define PMIC_SWCID_MASK 0xFFFF
#define PMIC_SWCID_SHIFT 0
#define PMIC_STS_PWRKEY_ADDR MT6356_PONSTS
#define PMIC_STS_PWRKEY_MASK 0x1
#define PMIC_STS_PWRKEY_SHIFT 0
#define PMIC_STS_RTCA_ADDR MT6356_PONSTS
#define PMIC_STS_RTCA_MASK 0x1
#define PMIC_STS_RTCA_SHIFT 1
#define PMIC_STS_CHRIN_ADDR MT6356_PONSTS
#define PMIC_STS_CHRIN_MASK 0x1
#define PMIC_STS_CHRIN_SHIFT 2
#define PMIC_STS_SPAR_ADDR MT6356_PONSTS
#define PMIC_STS_SPAR_MASK 0x1
#define PMIC_STS_SPAR_SHIFT 3
#define PMIC_STS_RBOOT_ADDR MT6356_PONSTS
#define PMIC_STS_RBOOT_MASK 0x1
#define PMIC_STS_RBOOT_SHIFT 4
#define PMIC_STS_UVLO_ADDR MT6356_POFFSTS
#define PMIC_STS_UVLO_MASK 0x1
#define PMIC_STS_UVLO_SHIFT 0
#define PMIC_STS_PGFAIL_ADDR MT6356_POFFSTS
#define PMIC_STS_PGFAIL_MASK 0x1
#define PMIC_STS_PGFAIL_SHIFT 1
#define PMIC_STS_PSOC_ADDR MT6356_POFFSTS
#define PMIC_STS_PSOC_MASK 0x1
#define PMIC_STS_PSOC_SHIFT 2
#define PMIC_STS_THRDN_ADDR MT6356_POFFSTS
#define PMIC_STS_THRDN_MASK 0x1
#define PMIC_STS_THRDN_SHIFT 3
#define PMIC_STS_WRST_ADDR MT6356_POFFSTS
#define PMIC_STS_WRST_MASK 0x1
#define PMIC_STS_WRST_SHIFT 4
#define PMIC_STS_CRST_ADDR MT6356_POFFSTS
#define PMIC_STS_CRST_MASK 0x1
#define PMIC_STS_CRST_SHIFT 5
#define PMIC_STS_PKEYLP_ADDR MT6356_POFFSTS
#define PMIC_STS_PKEYLP_MASK 0x1
#define PMIC_STS_PKEYLP_SHIFT 6
#define PMIC_STS_NORMOFF_ADDR MT6356_POFFSTS
#define PMIC_STS_NORMOFF_MASK 0x1
#define PMIC_STS_NORMOFF_SHIFT 7
#define PMIC_STS_BWDT_ADDR MT6356_POFFSTS
#define PMIC_STS_BWDT_MASK 0x1
#define PMIC_STS_BWDT_SHIFT 8
#define PMIC_STS_DDLO_ADDR MT6356_POFFSTS
#define PMIC_STS_DDLO_MASK 0x1
#define PMIC_STS_DDLO_SHIFT 9
#define PMIC_STS_WDT_ADDR MT6356_POFFSTS
#define PMIC_STS_WDT_MASK 0x1
#define PMIC_STS_WDT_SHIFT 10
#define PMIC_STS_PUPSRC_ADDR MT6356_POFFSTS
#define PMIC_STS_PUPSRC_MASK 0x1
#define PMIC_STS_PUPSRC_SHIFT 11
#define PMIC_STS_KEYPWR_ADDR MT6356_POFFSTS
#define PMIC_STS_KEYPWR_MASK 0x1
#define PMIC_STS_KEYPWR_SHIFT 12
#define PMIC_RG_POFFSTS_CLR_ADDR MT6356_PSTSCTL
#define PMIC_RG_POFFSTS_CLR_MASK 0x1
#define PMIC_RG_POFFSTS_CLR_SHIFT 0
#define PMIC_RG_PONSTS_CLR_ADDR MT6356_PSTSCTL
#define PMIC_RG_PONSTS_CLR_MASK 0x1
#define PMIC_RG_PONSTS_CLR_SHIFT 8
#define PMIC_VUSB_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VUSB_PG_DEB_MASK 0x1
#define PMIC_VUSB_PG_DEB_SHIFT 0
#define PMIC_VDRAM_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VDRAM_PG_DEB_MASK 0x1
#define PMIC_VDRAM_PG_DEB_SHIFT 1
#define PMIC_VIO28_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VIO28_PG_DEB_MASK 0x1
#define PMIC_VIO28_PG_DEB_SHIFT 2
#define PMIC_VEMC_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VEMC_PG_DEB_MASK 0x1
#define PMIC_VEMC_PG_DEB_SHIFT 3
#define PMIC_VIO18_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VIO18_PG_DEB_MASK 0x1
#define PMIC_VIO18_PG_DEB_SHIFT 4
#define PMIC_VSRAM_PROC_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VSRAM_PROC_PG_DEB_MASK 0x1
#define PMIC_VSRAM_PROC_PG_DEB_SHIFT 5
#define PMIC_VA12_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VA12_PG_DEB_MASK 0x1
#define PMIC_VA12_PG_DEB_SHIFT 6
#define PMIC_VSRAM_GPU_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VSRAM_GPU_PG_DEB_MASK 0x1
#define PMIC_VSRAM_GPU_PG_DEB_SHIFT 7
#define PMIC_VSRAM_OTHERS_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VSRAM_OTHERS_PG_DEB_MASK 0x1
#define PMIC_VSRAM_OTHERS_PG_DEB_SHIFT 8
#define PMIC_VAUX18_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VAUX18_PG_DEB_MASK 0x1
#define PMIC_VAUX18_PG_DEB_SHIFT 9
#define PMIC_BUCK_RSV_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_BUCK_RSV_PG_DEB_MASK 0x1
#define PMIC_BUCK_RSV_PG_DEB_SHIFT 10
#define PMIC_VPROC_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VPROC_PG_DEB_MASK 0x1
#define PMIC_VPROC_PG_DEB_SHIFT 11
#define PMIC_VS1_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VS1_PG_DEB_MASK 0x1
#define PMIC_VS1_PG_DEB_SHIFT 12
#define PMIC_VMODEM_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VMODEM_PG_DEB_MASK 0x1
#define PMIC_VMODEM_PG_DEB_SHIFT 13
#define PMIC_VCORE_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VCORE_PG_DEB_MASK 0x1
#define PMIC_VCORE_PG_DEB_SHIFT 14
#define PMIC_VS2_PG_DEB_ADDR MT6356_PG_DEB_STS0
#define PMIC_VS2_PG_DEB_MASK 0x1
#define PMIC_VS2_PG_DEB_SHIFT 15
#define PMIC_EXT_PMIC_PG_DEB_ADDR MT6356_PG_DEB_STS1
#define PMIC_EXT_PMIC_PG_DEB_MASK 0x1
#define PMIC_EXT_PMIC_PG_DEB_SHIFT 13
#define PMIC_VXO22_PG_DEB_ADDR MT6356_PG_DEB_STS1
#define PMIC_VXO22_PG_DEB_MASK 0x1
#define PMIC_VXO22_PG_DEB_SHIFT 14
#define PMIC_VAUD28_PG_DEB_ADDR MT6356_PG_DEB_STS1
#define PMIC_VAUD28_PG_DEB_MASK 0x1
#define PMIC_VAUD28_PG_DEB_SHIFT 15
#define PMIC_STRUP_VUSB_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VUSB_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VUSB_PG_STATUS_SHIFT 0
#define PMIC_STRUP_VDRAM_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VDRAM_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VDRAM_PG_STATUS_SHIFT 1
#define PMIC_STRUP_VIO28_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VIO28_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VIO28_PG_STATUS_SHIFT 2
#define PMIC_STRUP_VEMC_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VEMC_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VEMC_PG_STATUS_SHIFT 3
#define PMIC_STRUP_VIO18_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VIO18_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VIO18_PG_STATUS_SHIFT 4
#define PMIC_STRUP_VSRAM_PROC_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VSRAM_PROC_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VSRAM_PROC_PG_STATUS_SHIFT 5
#define PMIC_STRUP_VA12_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VA12_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VA12_PG_STATUS_SHIFT 6
#define PMIC_STRUP_VSRAM_GPU_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VSRAM_GPU_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VSRAM_GPU_PG_STATUS_SHIFT 7
#define PMIC_STRUP_VSRAM_OTHERS_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VSRAM_OTHERS_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VSRAM_OTHERS_PG_STATUS_SHIFT 8
#define PMIC_STRUP_VAUX18_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VAUX18_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VAUX18_PG_STATUS_SHIFT 9
#define PMIC_STRUP_BUCK_RSV_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_BUCK_RSV_PG_STATUS_MASK 0x1
#define PMIC_STRUP_BUCK_RSV_PG_STATUS_SHIFT 10
#define PMIC_STRUP_VPROC_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VPROC_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VPROC_PG_STATUS_SHIFT 11
#define PMIC_STRUP_VS1_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VS1_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VS1_PG_STATUS_SHIFT 12
#define PMIC_STRUP_VMODEM_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VMODEM_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VMODEM_PG_STATUS_SHIFT 13
#define PMIC_STRUP_VCORE_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VCORE_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VCORE_PG_STATUS_SHIFT 14
#define PMIC_STRUP_VS2_PG_STATUS_ADDR MT6356_PG_SDN_STS0
#define PMIC_STRUP_VS2_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VS2_PG_STATUS_SHIFT 15
#define PMIC_STRUP_EXT_PMIC_PG_STATUS_ADDR MT6356_PG_SDN_STS1
#define PMIC_STRUP_EXT_PMIC_PG_STATUS_MASK 0x1
#define PMIC_STRUP_EXT_PMIC_PG_STATUS_SHIFT 13
#define PMIC_STRUP_VXO22_PG_STATUS_ADDR MT6356_PG_SDN_STS1
#define PMIC_STRUP_VXO22_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VXO22_PG_STATUS_SHIFT 14
#define PMIC_STRUP_VAUD28_PG_STATUS_ADDR MT6356_PG_SDN_STS1
#define PMIC_STRUP_VAUD28_PG_STATUS_MASK 0x1
#define PMIC_STRUP_VAUD28_PG_STATUS_SHIFT 15
#define PMIC_STRUP_BUCK_RSV_OC_STATUS_ADDR MT6356_OC_SDN_STS0
#define PMIC_STRUP_BUCK_RSV_OC_STATUS_MASK 0x1
#define PMIC_STRUP_BUCK_RSV_OC_STATUS_SHIFT 10
#define PMIC_STRUP_VPROC_OC_STATUS_ADDR MT6356_OC_SDN_STS0
#define PMIC_STRUP_VPROC_OC_STATUS_MASK 0x1
#define PMIC_STRUP_VPROC_OC_STATUS_SHIFT 11
#define PMIC_STRUP_VS1_OC_STATUS_ADDR MT6356_OC_SDN_STS0
#define PMIC_STRUP_VS1_OC_STATUS_MASK 0x1
#define PMIC_STRUP_VS1_OC_STATUS_SHIFT 12
#define PMIC_STRUP_VMODEM_OC_STATUS_ADDR MT6356_OC_SDN_STS0
#define PMIC_STRUP_VMODEM_OC_STATUS_MASK 0x1
#define PMIC_STRUP_VMODEM_OC_STATUS_SHIFT 13
#define PMIC_STRUP_VCORE_OC_STATUS_ADDR MT6356_OC_SDN_STS0
#define PMIC_STRUP_VCORE_OC_STATUS_MASK 0x1
#define PMIC_STRUP_VCORE_OC_STATUS_SHIFT 14
#define PMIC_STRUP_VS2_OC_STATUS_ADDR MT6356_OC_SDN_STS0
#define PMIC_STRUP_VS2_OC_STATUS_MASK 0x1
#define PMIC_STRUP_VS2_OC_STATUS_SHIFT 15
#define PMIC_PMU_THERMAL_DEB_ADDR MT6356_THERMALSTATUS
#define PMIC_PMU_THERMAL_DEB_MASK 0x1
#define PMIC_PMU_THERMAL_DEB_SHIFT 14
#define PMIC_STRUP_THERMAL_STATUS_ADDR MT6356_THERMALSTATUS
#define PMIC_STRUP_THERMAL_STATUS_MASK 0x1
#define PMIC_STRUP_THERMAL_STATUS_SHIFT 15
#define PMIC_RG_SRCLKEN_IN0_EN_ADDR MT6356_TOP_CON
#define PMIC_RG_SRCLKEN_IN0_EN_MASK 0x1
#define PMIC_RG_SRCLKEN_IN0_EN_SHIFT 0
#define PMIC_RG_SRCLKEN_IN0_HW_MODE_ADDR MT6356_TOP_CON
#define PMIC_RG_SRCLKEN_IN0_HW_MODE_MASK 0x1
#define PMIC_RG_SRCLKEN_IN0_HW_MODE_SHIFT 1
#define PMIC_RG_SRCLKEN_IN1_EN_ADDR MT6356_TOP_CON
#define PMIC_RG_SRCLKEN_IN1_EN_MASK 0x1
#define PMIC_RG_SRCLKEN_IN1_EN_SHIFT 2
#define PMIC_RG_SRCLKEN_IN1_HW_MODE_ADDR MT6356_TOP_CON
#define PMIC_RG_SRCLKEN_IN1_HW_MODE_MASK 0x1
#define PMIC_RG_SRCLKEN_IN1_HW_MODE_SHIFT 3
#define PMIC_RG_SRCLKEN_IN_SYNC_EN_ADDR MT6356_TOP_CON
#define PMIC_RG_SRCLKEN_IN_SYNC_EN_MASK 0x1
#define PMIC_RG_SRCLKEN_IN_SYNC_EN_SHIFT 8
#define PMIC_RG_OSC_EN_AUTO_OFF_ADDR MT6356_TOP_CON
#define PMIC_RG_OSC_EN_AUTO_OFF_MASK 0x1
#define PMIC_RG_OSC_EN_AUTO_OFF_SHIFT 9
#define PMIC_TEST_OUT_ADDR MT6356_TEST_OUT
#define PMIC_TEST_OUT_MASK 0xFF
#define PMIC_TEST_OUT_SHIFT 0
#define PMIC_RG_MON_FLAG_SEL_ADDR MT6356_TEST_CON0
#define PMIC_RG_MON_FLAG_SEL_MASK 0xFF
#define PMIC_RG_MON_FLAG_SEL_SHIFT 0
#define PMIC_RG_MON_GRP_SEL_ADDR MT6356_TEST_CON0
#define PMIC_RG_MON_GRP_SEL_MASK 0x1F
#define PMIC_RG_MON_GRP_SEL_SHIFT 8
#define PMIC_RG_NANDTREE_MODE_ADDR MT6356_TEST_CON1
#define PMIC_RG_NANDTREE_MODE_MASK 0x1
#define PMIC_RG_NANDTREE_MODE_SHIFT 0
#define PMIC_RG_TEST_AUXADC_ADDR MT6356_TEST_CON1
#define PMIC_RG_TEST_AUXADC_MASK 0x1
#define PMIC_RG_TEST_AUXADC_SHIFT 1
#define PMIC_RG_EFUSE_MODE_ADDR MT6356_TEST_CON1
#define PMIC_RG_EFUSE_MODE_MASK 0x1
#define PMIC_RG_EFUSE_MODE_SHIFT 2
#define PMIC_RG_TEST_STRUP_ADDR MT6356_TEST_CON1
#define PMIC_RG_TEST_STRUP_MASK 0x1
#define PMIC_RG_TEST_STRUP_SHIFT 3
#define PMIC_TESTMODE_SW_ADDR MT6356_TESTMODE_SW
#define PMIC_TESTMODE_SW_MASK 0x1
#define PMIC_TESTMODE_SW_SHIFT 0
#define PMIC_PMU_TEST_MODE_SCAN_ADDR MT6356_TOPSTATUS
#define PMIC_PMU_TEST_MODE_SCAN_MASK 0x1
#define PMIC_PMU_TEST_MODE_SCAN_SHIFT 0
#define PMIC_PWRKEY_DEB_ADDR MT6356_TOPSTATUS
#define PMIC_PWRKEY_DEB_MASK 0x1
#define PMIC_PWRKEY_DEB_SHIFT 1
#define PMIC_CHRDET_DEB_ADDR MT6356_TOPSTATUS
#define PMIC_CHRDET_DEB_MASK 0x1
#define PMIC_CHRDET_DEB_SHIFT 2
#define PMIC_HOMEKEY_DEB_ADDR MT6356_TOPSTATUS
#define PMIC_HOMEKEY_DEB_MASK 0x1
#define PMIC_HOMEKEY_DEB_SHIFT 3
#define PMIC_RG_PMU_TDSEL_ADDR MT6356_TDSEL_CON
#define PMIC_RG_PMU_TDSEL_MASK 0x1
#define PMIC_RG_PMU_TDSEL_SHIFT 0
#define PMIC_RG_SPI_TDSEL_ADDR MT6356_TDSEL_CON
#define PMIC_RG_SPI_TDSEL_MASK 0x1
#define PMIC_RG_SPI_TDSEL_SHIFT 1
#define PMIC_RG_AUD_TDSEL_ADDR MT6356_TDSEL_CON
#define PMIC_RG_AUD_TDSEL_MASK 0x1
#define PMIC_RG_AUD_TDSEL_SHIFT 2
#define PMIC_RG_E32CAL_TDSEL_ADDR MT6356_TDSEL_CON
#define PMIC_RG_E32CAL_TDSEL_MASK 0x1
#define PMIC_RG_E32CAL_TDSEL_SHIFT 3
#define PMIC_RG_PMU_RDSEL_ADDR MT6356_RDSEL_CON
#define PMIC_RG_PMU_RDSEL_MASK 0x1
#define PMIC_RG_PMU_RDSEL_SHIFT 0
#define PMIC_RG_SPI_RDSEL_ADDR MT6356_RDSEL_CON
#define PMIC_RG_SPI_RDSEL_MASK 0x1
#define PMIC_RG_SPI_RDSEL_SHIFT 1
#define PMIC_RG_AUD_RDSEL_ADDR MT6356_RDSEL_CON
#define PMIC_RG_AUD_RDSEL_MASK 0x1
#define PMIC_RG_AUD_RDSEL_SHIFT 2
#define PMIC_RG_E32CAL_RDSEL_ADDR MT6356_RDSEL_CON
#define PMIC_RG_E32CAL_RDSEL_MASK 0x1
#define PMIC_RG_E32CAL_RDSEL_SHIFT 3
#define PMIC_RG_SMT_WDTRSTB_IN_ADDR MT6356_SMT_CON0
#define PMIC_RG_SMT_WDTRSTB_IN_MASK 0x1
#define PMIC_RG_SMT_WDTRSTB_IN_SHIFT 0
#define PMIC_RG_SMT_SRCLKEN_IN0_ADDR MT6356_SMT_CON0
#define PMIC_RG_SMT_SRCLKEN_IN0_MASK 0x1
#define PMIC_RG_SMT_SRCLKEN_IN0_SHIFT 1
#define PMIC_RG_SMT_SRCLKEN_IN1_ADDR MT6356_SMT_CON0
#define PMIC_RG_SMT_SRCLKEN_IN1_MASK 0x1
#define PMIC_RG_SMT_SRCLKEN_IN1_SHIFT 2
#define PMIC_RG_SMT_RTC_32K1V8_0_ADDR MT6356_SMT_CON0
#define PMIC_RG_SMT_RTC_32K1V8_0_MASK 0x1
#define PMIC_RG_SMT_RTC_32K1V8_0_SHIFT 3
#define PMIC_RG_SMT_RTC_32K1V8_1_ADDR MT6356_SMT_CON0
#define PMIC_RG_SMT_RTC_32K1V8_1_MASK 0x1
#define PMIC_RG_SMT_RTC_32K1V8_1_SHIFT 4
#define PMIC_RG_SMT_SPI_CLK_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_SPI_CLK_MASK 0x1
#define PMIC_RG_SMT_SPI_CLK_SHIFT 0
#define PMIC_RG_SMT_SPI_CSN_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_SPI_CSN_MASK 0x1
#define PMIC_RG_SMT_SPI_CSN_SHIFT 1
#define PMIC_RG_SMT_SPI_MOSI_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_SPI_MOSI_MASK 0x1
#define PMIC_RG_SMT_SPI_MOSI_SHIFT 2
#define PMIC_RG_SMT_SPI_MISO_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_SPI_MISO_MASK 0x1
#define PMIC_RG_SMT_SPI_MISO_SHIFT 3
#define PMIC_RG_SMT_AUD_CLK_MOSI_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_AUD_CLK_MOSI_MASK 0x1
#define PMIC_RG_SMT_AUD_CLK_MOSI_SHIFT 4
#define PMIC_RG_SMT_AUD_DAT_MOSI0_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_AUD_DAT_MOSI0_MASK 0x1
#define PMIC_RG_SMT_AUD_DAT_MOSI0_SHIFT 5
#define PMIC_RG_SMT_AUD_DAT_MOSI1_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_AUD_DAT_MOSI1_MASK 0x1
#define PMIC_RG_SMT_AUD_DAT_MOSI1_SHIFT 6
#define PMIC_RG_SMT_AUD_SYNC_MOSI_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_AUD_SYNC_MOSI_MASK 0x1
#define PMIC_RG_SMT_AUD_SYNC_MOSI_SHIFT 7
#define PMIC_RG_SMT_AUD_CLK_MISO_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_AUD_CLK_MISO_MASK 0x1
#define PMIC_RG_SMT_AUD_CLK_MISO_SHIFT 8
#define PMIC_RG_SMT_AUD_DAT_MISO0_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_AUD_DAT_MISO0_MASK 0x1
#define PMIC_RG_SMT_AUD_DAT_MISO0_SHIFT 9
#define PMIC_RG_SMT_AUD_DAT_MISO1_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_AUD_DAT_MISO1_MASK 0x1
#define PMIC_RG_SMT_AUD_DAT_MISO1_SHIFT 10
#define PMIC_RG_SMT_AUD_SYNC_MISO_ADDR MT6356_SMT_CON1
#define PMIC_RG_SMT_AUD_SYNC_MISO_MASK 0x1
#define PMIC_RG_SMT_AUD_SYNC_MISO_SHIFT 11
#define PMIC_RG_TOP_RSV0_ADDR MT6356_TOP_RSV0
#define PMIC_RG_TOP_RSV0_MASK 0x1
#define PMIC_RG_TOP_RSV0_SHIFT 0
#define PMIC_RG_TOP_RSV1_ADDR MT6356_TOP_RSV1
#define PMIC_RG_TOP_RSV1_MASK 0x1
#define PMIC_RG_TOP_RSV1_SHIFT 0
#define PMIC_RG_OCTL_SRCLKEN_IN0_ADDR MT6356_DRV_CON0
#define PMIC_RG_OCTL_SRCLKEN_IN0_MASK 0xF
#define PMIC_RG_OCTL_SRCLKEN_IN0_SHIFT 0
#define PMIC_RG_OCTL_SRCLKEN_IN1_ADDR MT6356_DRV_CON0
#define PMIC_RG_OCTL_SRCLKEN_IN1_MASK 0xF
#define PMIC_RG_OCTL_SRCLKEN_IN1_SHIFT 4
#define PMIC_RG_OCTL_RTC_32K1V8_0_ADDR MT6356_DRV_CON0
#define PMIC_RG_OCTL_RTC_32K1V8_0_MASK 0xF
#define PMIC_RG_OCTL_RTC_32K1V8_0_SHIFT 8
#define PMIC_RG_OCTL_RTC_32K1V8_1_ADDR MT6356_DRV_CON0
#define PMIC_RG_OCTL_RTC_32K1V8_1_MASK 0xF
#define PMIC_RG_OCTL_RTC_32K1V8_1_SHIFT 12
#define PMIC_RG_OCTL_SPI_CLK_ADDR MT6356_DRV_CON1
#define PMIC_RG_OCTL_SPI_CLK_MASK 0xF
#define PMIC_RG_OCTL_SPI_CLK_SHIFT 0
#define PMIC_RG_OCTL_SPI_CSN_ADDR MT6356_DRV_CON1
#define PMIC_RG_OCTL_SPI_CSN_MASK 0xF
#define PMIC_RG_OCTL_SPI_CSN_SHIFT 4
#define PMIC_RG_OCTL_SPI_MOSI_ADDR MT6356_DRV_CON1
#define PMIC_RG_OCTL_SPI_MOSI_MASK 0xF
#define PMIC_RG_OCTL_SPI_MOSI_SHIFT 8
#define PMIC_RG_OCTL_SPI_MISO_ADDR MT6356_DRV_CON1
#define PMIC_RG_OCTL_SPI_MISO_MASK 0xF
#define PMIC_RG_OCTL_SPI_MISO_SHIFT 12
#define PMIC_RG_OCTL_AUD_CLK_MOSI_ADDR MT6356_DRV_CON2
#define PMIC_RG_OCTL_AUD_CLK_MOSI_MASK 0xF
#define PMIC_RG_OCTL_AUD_CLK_MOSI_SHIFT 0
#define PMIC_RG_OCTL_AUD_DAT_MOSI0_ADDR MT6356_DRV_CON2
#define PMIC_RG_OCTL_AUD_DAT_MOSI0_MASK 0xF
#define PMIC_RG_OCTL_AUD_DAT_MOSI0_SHIFT 4
#define PMIC_RG_OCTL_AUD_DAT_MOSI1_ADDR MT6356_DRV_CON2
#define PMIC_RG_OCTL_AUD_DAT_MOSI1_MASK 0xF
#define PMIC_RG_OCTL_AUD_DAT_MOSI1_SHIFT 8
#define PMIC_RG_OCTL_AUD_SYNC_MOSI_ADDR MT6356_DRV_CON2
#define PMIC_RG_OCTL_AUD_SYNC_MOSI_MASK 0xF
#define PMIC_RG_OCTL_AUD_SYNC_MOSI_SHIFT 12
#define PMIC_RG_OCTL_AUD_CLK_MISO_ADDR MT6356_DRV_CON3
#define PMIC_RG_OCTL_AUD_CLK_MISO_MASK 0xF
#define PMIC_RG_OCTL_AUD_CLK_MISO_SHIFT 0
#define PMIC_RG_OCTL_AUD_DAT_MISO0_ADDR MT6356_DRV_CON3
#define PMIC_RG_OCTL_AUD_DAT_MISO0_MASK 0xF
#define PMIC_RG_OCTL_AUD_DAT_MISO0_SHIFT 4
#define PMIC_RG_OCTL_AUD_DAT_MISO1_ADDR MT6356_DRV_CON3
#define PMIC_RG_OCTL_AUD_DAT_MISO1_MASK 0xF
#define PMIC_RG_OCTL_AUD_DAT_MISO1_SHIFT 8
#define PMIC_RG_OCTL_AUD_SYNC_MISO_ADDR MT6356_DRV_CON3
#define PMIC_RG_OCTL_AUD_SYNC_MISO_MASK 0xF
#define PMIC_RG_OCTL_AUD_SYNC_MISO_SHIFT 12
#define PMIC_RG_SRCLKEN_IN0_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_SRCLKEN_IN0_FILTER_EN_MASK 0x1
#define PMIC_RG_SRCLKEN_IN0_FILTER_EN_SHIFT 0
#define PMIC_RG_SRCLKEN_IN1_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_SRCLKEN_IN1_FILTER_EN_MASK 0x1
#define PMIC_RG_SRCLKEN_IN1_FILTER_EN_SHIFT 1
#define PMIC_RG_RTC32K_1V8_0_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_RTC32K_1V8_0_FILTER_EN_MASK 0x1
#define PMIC_RG_RTC32K_1V8_0_FILTER_EN_SHIFT 2
#define PMIC_RG_RTC32K_1V8_1_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_RTC32K_1V8_1_FILTER_EN_MASK 0x1
#define PMIC_RG_RTC32K_1V8_1_FILTER_EN_SHIFT 3
#define PMIC_RG_SPI_CLK_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_SPI_CLK_FILTER_EN_MASK 0x1
#define PMIC_RG_SPI_CLK_FILTER_EN_SHIFT 4
#define PMIC_RG_SPI_CSN_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_SPI_CSN_FILTER_EN_MASK 0x1
#define PMIC_RG_SPI_CSN_FILTER_EN_SHIFT 5
#define PMIC_RG_SPI_MOSI_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_SPI_MOSI_FILTER_EN_MASK 0x1
#define PMIC_RG_SPI_MOSI_FILTER_EN_SHIFT 6
#define PMIC_RG_SPI_MISO_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_SPI_MISO_FILTER_EN_MASK 0x1
#define PMIC_RG_SPI_MISO_FILTER_EN_SHIFT 7
#define PMIC_RG_AUD_CLK_MOSI_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_AUD_CLK_MOSI_FILTER_EN_MASK 0x1
#define PMIC_RG_AUD_CLK_MOSI_FILTER_EN_SHIFT 8
#define PMIC_RG_AUD_DAT_MOSI0_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_AUD_DAT_MOSI0_FILTER_EN_MASK 0x1
#define PMIC_RG_AUD_DAT_MOSI0_FILTER_EN_SHIFT 9
#define PMIC_RG_AUD_DAT_MOSI1_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_AUD_DAT_MOSI1_FILTER_EN_MASK 0x1
#define PMIC_RG_AUD_DAT_MOSI1_FILTER_EN_SHIFT 10
#define PMIC_RG_AUD_SYNC_MOSI_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_AUD_SYNC_MOSI_FILTER_EN_MASK 0x1
#define PMIC_RG_AUD_SYNC_MOSI_FILTER_EN_SHIFT 11
#define PMIC_RG_AUD_CLK_MISO_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_AUD_CLK_MISO_FILTER_EN_MASK 0x1
#define PMIC_RG_AUD_CLK_MISO_FILTER_EN_SHIFT 12
#define PMIC_RG_AUD_DAT_MISO0_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_AUD_DAT_MISO0_FILTER_EN_MASK 0x1
#define PMIC_RG_AUD_DAT_MISO0_FILTER_EN_SHIFT 13
#define PMIC_RG_AUD_DAT_MISO1_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_AUD_DAT_MISO1_FILTER_EN_MASK 0x1
#define PMIC_RG_AUD_DAT_MISO1_FILTER_EN_SHIFT 14
#define PMIC_RG_AUD_SYNC_MISO_FILTER_EN_ADDR MT6356_FILTER_CON0
#define PMIC_RG_AUD_SYNC_MISO_FILTER_EN_MASK 0x1
#define PMIC_RG_AUD_SYNC_MISO_FILTER_EN_SHIFT 15
#define PMIC_RG_WDTRSTB_IN_FILTER_EN_ADDR MT6356_FILTER_CON1
#define PMIC_RG_WDTRSTB_IN_FILTER_EN_MASK 0x1
#define PMIC_RG_WDTRSTB_IN_FILTER_EN_SHIFT 0
#define PMIC_RG_SRCLKEN_IN0_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_SRCLKEN_IN0_RCSEL_MASK 0x1
#define PMIC_RG_SRCLKEN_IN0_RCSEL_SHIFT 0
#define PMIC_RG_SRCLKEN_IN1_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_SRCLKEN_IN1_RCSEL_MASK 0x1
#define PMIC_RG_SRCLKEN_IN1_RCSEL_SHIFT 1
#define PMIC_RG_RTC32K_1V8_0_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_RTC32K_1V8_0_RCSEL_MASK 0x1
#define PMIC_RG_RTC32K_1V8_0_RCSEL_SHIFT 2
#define PMIC_RG_RTC32K_1V8_1_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_RTC32K_1V8_1_RCSEL_MASK 0x1
#define PMIC_RG_RTC32K_1V8_1_RCSEL_SHIFT 3
#define PMIC_RG_SPI_CLK_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_SPI_CLK_RCSEL_MASK 0x1
#define PMIC_RG_SPI_CLK_RCSEL_SHIFT 4
#define PMIC_RG_SPI_CSN_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_SPI_CSN_RCSEL_MASK 0x1
#define PMIC_RG_SPI_CSN_RCSEL_SHIFT 5
#define PMIC_RG_SPI_MOSI_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_SPI_MOSI_RCSEL_MASK 0x1
#define PMIC_RG_SPI_MOSI_RCSEL_SHIFT 6
#define PMIC_RG_SPI_MISO_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_SPI_MISO_RCSEL_MASK 0x1
#define PMIC_RG_SPI_MISO_RCSEL_SHIFT 7
#define PMIC_RG_AUD_CLK_MOSI_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_AUD_CLK_MOSI_RCSEL_MASK 0x1
#define PMIC_RG_AUD_CLK_MOSI_RCSEL_SHIFT 8
#define PMIC_RG_AUD_DAT_MOSI0_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_AUD_DAT_MOSI0_RCSEL_MASK 0x1
#define PMIC_RG_AUD_DAT_MOSI0_RCSEL_SHIFT 9
#define PMIC_RG_AUD_DAT_MOSI1_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_AUD_DAT_MOSI1_RCSEL_MASK 0x1
#define PMIC_RG_AUD_DAT_MOSI1_RCSEL_SHIFT 10
#define PMIC_RG_AUD_SYNC_MOSI_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_AUD_SYNC_MOSI_RCSEL_MASK 0x1
#define PMIC_RG_AUD_SYNC_MOSI_RCSEL_SHIFT 11
#define PMIC_RG_AUD_CLK_MISO_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_AUD_CLK_MISO_RCSEL_MASK 0x1
#define PMIC_RG_AUD_CLK_MISO_RCSEL_SHIFT 12
#define PMIC_RG_AUD_DAT_MISO0_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_AUD_DAT_MISO0_RCSEL_MASK 0x1
#define PMIC_RG_AUD_DAT_MISO0_RCSEL_SHIFT 13
#define PMIC_RG_AUD_DAT_MISO1_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_AUD_DAT_MISO1_RCSEL_MASK 0x1
#define PMIC_RG_AUD_DAT_MISO1_RCSEL_SHIFT 14
#define PMIC_RG_AUD_SYNC_MISO_RCSEL_ADDR MT6356_FILTER_CON2
#define PMIC_RG_AUD_SYNC_MISO_RCSEL_MASK 0x1
#define PMIC_RG_AUD_SYNC_MISO_RCSEL_SHIFT 15
#define PMIC_RG_WDTRSTB_IN_RCSEL_ADDR MT6356_FILTER_CON3
#define PMIC_RG_WDTRSTB_IN_RCSEL_MASK 0x1
#define PMIC_RG_WDTRSTB_IN_RCSEL_SHIFT 0
#define PMIC_TOP_STATUS_ADDR MT6356_TOP_STATUS
#define PMIC_TOP_STATUS_MASK 0xF
#define PMIC_TOP_STATUS_SHIFT 0
#define PMIC_TOP_STATUS_SET_ADDR MT6356_TOP_STATUS_SET
#define PMIC_TOP_STATUS_SET_MASK 0x3
#define PMIC_TOP_STATUS_SET_SHIFT 0
#define PMIC_TOP_STATUS_CLR_ADDR MT6356_TOP_STATUS_CLR
#define PMIC_TOP_STATUS_CLR_MASK 0x3
#define PMIC_TOP_STATUS_CLR_SHIFT 0
#define PMIC_VM_MODE_ADDR MT6356_TOP_TRAP
#define PMIC_VM_MODE_MASK 0x3
#define PMIC_VM_MODE_SHIFT 0
#define PMIC_GPIO_DIR0_ADDR MT6356_GPIO_DIR0
#define PMIC_GPIO_DIR0_MASK 0xFFFF
#define PMIC_GPIO_DIR0_SHIFT 0
#define PMIC_GPIO_DIR0_SET_ADDR MT6356_GPIO_DIR0_SET
#define PMIC_GPIO_DIR0_SET_MASK 0xFFFF
#define PMIC_GPIO_DIR0_SET_SHIFT 0
#define PMIC_GPIO_DIR0_CLR_ADDR MT6356_GPIO_DIR0_CLR
#define PMIC_GPIO_DIR0_CLR_MASK 0xFFFF
#define PMIC_GPIO_DIR0_CLR_SHIFT 0
#define PMIC_GPIO_PULLEN0_ADDR MT6356_GPIO_PULLEN0
#define PMIC_GPIO_PULLEN0_MASK 0xFFFF
#define PMIC_GPIO_PULLEN0_SHIFT 0
#define PMIC_GPIO_PULLEN0_SET_ADDR MT6356_GPIO_PULLEN0_SET
#define PMIC_GPIO_PULLEN0_SET_MASK 0xFFFF
#define PMIC_GPIO_PULLEN0_SET_SHIFT 0
#define PMIC_GPIO_PULLEN0_CLR_ADDR MT6356_GPIO_PULLEN0_CLR
#define PMIC_GPIO_PULLEN0_CLR_MASK 0xFFFF
#define PMIC_GPIO_PULLEN0_CLR_SHIFT 0
#define PMIC_GPIO_PULLSEL0_ADDR MT6356_GPIO_PULLSEL0
#define PMIC_GPIO_PULLSEL0_MASK 0xFFFF
#define PMIC_GPIO_PULLSEL0_SHIFT 0
#define PMIC_GPIO_PULLSEL0_SET_ADDR MT6356_GPIO_PULLSEL0_SET
#define PMIC_GPIO_PULLSEL0_SET_MASK 0xFFFF
#define PMIC_GPIO_PULLSEL0_SET_SHIFT 0
#define PMIC_GPIO_PULLSEL0_CLR_ADDR MT6356_GPIO_PULLSEL0_CLR
#define PMIC_GPIO_PULLSEL0_CLR_MASK 0xFFFF
#define PMIC_GPIO_PULLSEL0_CLR_SHIFT 0
#define PMIC_GPIO_DINV0_ADDR MT6356_GPIO_DINV0
#define PMIC_GPIO_DINV0_MASK 0xFFFF
#define PMIC_GPIO_DINV0_SHIFT 0
#define PMIC_GPIO_DINV0_SET_ADDR MT6356_GPIO_DINV0_SET
#define PMIC_GPIO_DINV0_SET_MASK 0xFFFF
#define PMIC_GPIO_DINV0_SET_SHIFT 0
#define PMIC_GPIO_DINV0_CLR_ADDR MT6356_GPIO_DINV0_CLR
#define PMIC_GPIO_DINV0_CLR_MASK 0xFFFF
#define PMIC_GPIO_DINV0_CLR_SHIFT 0
#define PMIC_GPIO_DOUT0_ADDR MT6356_GPIO_DOUT0
#define PMIC_GPIO_DOUT0_MASK 0xFFFF
#define PMIC_GPIO_DOUT0_SHIFT 0
#define PMIC_GPIO_DOUT0_SET_ADDR MT6356_GPIO_DOUT0_SET
#define PMIC_GPIO_DOUT0_SET_MASK 0xFFFF
#define PMIC_GPIO_DOUT0_SET_SHIFT 0
#define PMIC_GPIO_DOUT0_CLR_ADDR MT6356_GPIO_DOUT0_CLR
#define PMIC_GPIO_DOUT0_CLR_MASK 0xFFFF
#define PMIC_GPIO_DOUT0_CLR_SHIFT 0
#define PMIC_GPIO_PI0_ADDR MT6356_GPIO_PI0
#define PMIC_GPIO_PI0_MASK 0xFFFF
#define PMIC_GPIO_PI0_SHIFT 0
#define PMIC_GPIO_POE0_ADDR MT6356_GPIO_POE0
#define PMIC_GPIO_POE0_MASK 0xFFFF
#define PMIC_GPIO_POE0_SHIFT 0
#define PMIC_GPIO0_MODE_ADDR MT6356_GPIO_MODE0
#define PMIC_GPIO0_MODE_MASK 0x7
#define PMIC_GPIO0_MODE_SHIFT 0
#define PMIC_GPIO1_MODE_ADDR MT6356_GPIO_MODE0
#define PMIC_GPIO1_MODE_MASK 0x7
#define PMIC_GPIO1_MODE_SHIFT 3
#define PMIC_GPIO2_MODE_ADDR MT6356_GPIO_MODE0
#define PMIC_GPIO2_MODE_MASK 0x7
#define PMIC_GPIO2_MODE_SHIFT 6
#define PMIC_GPIO3_MODE_ADDR MT6356_GPIO_MODE0
#define PMIC_GPIO3_MODE_MASK 0x7
#define PMIC_GPIO3_MODE_SHIFT 9
#define PMIC_GPIO_MODE0_SET_ADDR MT6356_GPIO_MODE0_SET
#define PMIC_GPIO_MODE0_SET_MASK 0xFFFF
#define PMIC_GPIO_MODE0_SET_SHIFT 0
#define PMIC_GPIO_MODE0_CLR_ADDR MT6356_GPIO_MODE0_CLR
#define PMIC_GPIO_MODE0_CLR_MASK 0xFFFF
#define PMIC_GPIO_MODE0_CLR_SHIFT 0
#define PMIC_GPIO4_MODE_ADDR MT6356_GPIO_MODE1
#define PMIC_GPIO4_MODE_MASK 0x7
#define PMIC_GPIO4_MODE_SHIFT 0
#define PMIC_GPIO5_MODE_ADDR MT6356_GPIO_MODE1
#define PMIC_GPIO5_MODE_MASK 0x7
#define PMIC_GPIO5_MODE_SHIFT 3
#define PMIC_GPIO6_MODE_ADDR MT6356_GPIO_MODE1
#define PMIC_GPIO6_MODE_MASK 0x7
#define PMIC_GPIO6_MODE_SHIFT 6
#define PMIC_GPIO7_MODE_ADDR MT6356_GPIO_MODE1
#define PMIC_GPIO7_MODE_MASK 0x7
#define PMIC_GPIO7_MODE_SHIFT 9
#define PMIC_GPIO_MODE1_SET_ADDR MT6356_GPIO_MODE1_SET
#define PMIC_GPIO_MODE1_SET_MASK 0xFFFF
#define PMIC_GPIO_MODE1_SET_SHIFT 0
#define PMIC_GPIO_MODE1_CLR_ADDR MT6356_GPIO_MODE1_CLR
#define PMIC_GPIO_MODE1_CLR_MASK 0xFFFF
#define PMIC_GPIO_MODE1_CLR_SHIFT 0
#define PMIC_GPIO8_MODE_ADDR MT6356_GPIO_MODE2
#define PMIC_GPIO8_MODE_MASK 0x7
#define PMIC_GPIO8_MODE_SHIFT 0
#define PMIC_GPIO9_MODE_ADDR MT6356_GPIO_MODE2
#define PMIC_GPIO9_MODE_MASK 0x7
#define PMIC_GPIO9_MODE_SHIFT 3
#define PMIC_GPIO10_MODE_ADDR MT6356_GPIO_MODE2
#define PMIC_GPIO10_MODE_MASK 0x7
#define PMIC_GPIO10_MODE_SHIFT 6
#define PMIC_GPIO11_MODE_ADDR MT6356_GPIO_MODE2
#define PMIC_GPIO11_MODE_MASK 0x7
#define PMIC_GPIO11_MODE_SHIFT 9
#define PMIC_GPIO_MODE2_SET_ADDR MT6356_GPIO_MODE2_SET
#define PMIC_GPIO_MODE2_SET_MASK 0xFFFF
#define PMIC_GPIO_MODE2_SET_SHIFT 0
#define PMIC_GPIO_MODE2_CLR_ADDR MT6356_GPIO_MODE2_CLR
#define PMIC_GPIO_MODE2_CLR_MASK 0xFFFF
#define PMIC_GPIO_MODE2_CLR_SHIFT 0
#define PMIC_GPIO12_MODE_ADDR MT6356_GPIO_MODE3
#define PMIC_GPIO12_MODE_MASK 0x7
#define PMIC_GPIO12_MODE_SHIFT 0
#define PMIC_GPIO13_MODE_ADDR MT6356_GPIO_MODE3
#define PMIC_GPIO13_MODE_MASK 0x7
#define PMIC_GPIO13_MODE_SHIFT 3
#define PMIC_GPIO14_MODE_ADDR MT6356_GPIO_MODE3
#define PMIC_GPIO14_MODE_MASK 0x7
#define PMIC_GPIO14_MODE_SHIFT 6
#define PMIC_GPIO15_MODE_ADDR MT6356_GPIO_MODE3
#define PMIC_GPIO15_MODE_MASK 0x7
#define PMIC_GPIO15_MODE_SHIFT 9
#define PMIC_GPIO_MODE3_SET_ADDR MT6356_GPIO_MODE3_SET
#define PMIC_GPIO_MODE3_SET_MASK 0xFFFF
#define PMIC_GPIO_MODE3_SET_SHIFT 0
#define PMIC_GPIO_MODE3_CLR_ADDR MT6356_GPIO_MODE3_CLR
#define PMIC_GPIO_MODE3_CLR_MASK 0xFFFF
#define PMIC_GPIO_MODE3_CLR_SHIFT 0
#define PMIC_GPIO_RSV_ADDR MT6356_GPIO_RSV
#define PMIC_GPIO_RSV_MASK 0xFFFF
#define PMIC_GPIO_RSV_SHIFT 0
#define PMIC_TOP1_ANA_ID_ADDR MT6356_TOP1_ID
#define PMIC_TOP1_ANA_ID_MASK 0xFF
#define PMIC_TOP1_ANA_ID_SHIFT 0
#define PMIC_TOP1_DIG_ID_ADDR MT6356_TOP1_ID
#define PMIC_TOP1_DIG_ID_MASK 0xFF
#define PMIC_TOP1_DIG_ID_SHIFT 8
#define PMIC_TOP1_ANA_MINOR_REV_ADDR MT6356_TOP1_REV0
#define PMIC_TOP1_ANA_MINOR_REV_MASK 0xF
#define PMIC_TOP1_ANA_MINOR_REV_SHIFT 0
#define PMIC_TOP1_ANA_MAJOR_REV_ADDR MT6356_TOP1_REV0
#define PMIC_TOP1_ANA_MAJOR_REV_MASK 0xF
#define PMIC_TOP1_ANA_MAJOR_REV_SHIFT 4
#define PMIC_TOP1_DIG_MINOR_REV_ADDR MT6356_TOP1_REV0
#define PMIC_TOP1_DIG_MINOR_REV_MASK 0xF
#define PMIC_TOP1_DIG_MINOR_REV_SHIFT 8
#define PMIC_TOP1_DIG_MAJOR_REV_ADDR MT6356_TOP1_REV0
#define PMIC_TOP1_DIG_MAJOR_REV_MASK 0xF
#define PMIC_TOP1_DIG_MAJOR_REV_SHIFT 12
#define PMIC_TOP1_SW_MINOR_REV_ADDR MT6356_TOP1_REV1
#define PMIC_TOP1_SW_MINOR_REV_MASK 0xF
#define PMIC_TOP1_SW_MINOR_REV_SHIFT 0
#define PMIC_TOP1_SW_MAJOR_REV_ADDR MT6356_TOP1_REV1
#define PMIC_TOP1_SW_MAJOR_REV_MASK 0xF
#define PMIC_TOP1_SW_MAJOR_REV_SHIFT 4
#define PMIC_TOP1_ESP_ADDR MT6356_TOP1_REV1
#define PMIC_TOP1_ESP_MASK 0xFF
#define PMIC_TOP1_ESP_SHIFT 8
#define PMIC_TOP_CLK_OFFSET_ADDR MT6356_TOP_PAM0
#define PMIC_TOP_CLK_OFFSET_MASK 0xFF
#define PMIC_TOP_CLK_OFFSET_SHIFT 0
#define PMIC_TOP_RST_OFFSET_ADDR MT6356_TOP_PAM0
#define PMIC_TOP_RST_OFFSET_MASK 0xFF
#define PMIC_TOP_RST_OFFSET_SHIFT 8
#define PMIC_TOP_INT_OFFSET_ADDR MT6356_TOP_PAM1
#define PMIC_TOP_INT_OFFSET_MASK 0xFF
#define PMIC_TOP_INT_OFFSET_SHIFT 0
#define PMIC_TOP_INT_LEN_ADDR MT6356_TOP_PAM1
#define PMIC_TOP_INT_LEN_MASK 0xFF
#define PMIC_TOP_INT_LEN_SHIFT 8
#define PMIC_RG_G_SMPS_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_G_SMPS_CK_PDN_MASK 0x1
#define PMIC_RG_G_SMPS_CK_PDN_SHIFT 0
#define PMIC_RG_G_SMPS_TEST_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_G_SMPS_TEST_CK_PDN_MASK 0x1
#define PMIC_RG_G_SMPS_TEST_CK_PDN_SHIFT 1
#define PMIC_RG_INTRP_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_INTRP_CK_PDN_MASK 0x1
#define PMIC_RG_INTRP_CK_PDN_SHIFT 2
#define PMIC_RG_INTRP_PRE_OC_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_INTRP_PRE_OC_CK_PDN_MASK 0x1
#define PMIC_RG_INTRP_PRE_OC_CK_PDN_SHIFT 3
#define PMIC_RG_EFUSE_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_EFUSE_CK_PDN_MASK 0x1
#define PMIC_RG_EFUSE_CK_PDN_SHIFT 4
#define PMIC_RG_EINT_32K_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_EINT_32K_CK_PDN_MASK 0x1
#define PMIC_RG_EINT_32K_CK_PDN_SHIFT 5
#define PMIC_RG_PMU1M_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_PMU1M_CK_PDN_MASK 0x1
#define PMIC_RG_PMU1M_CK_PDN_SHIFT 6
#define PMIC_RG_SPI_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_SPI_CK_PDN_MASK 0x1
#define PMIC_RG_SPI_CK_PDN_SHIFT 7
#define PMIC_RG_REG_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_REG_CK_PDN_MASK 0x1
#define PMIC_RG_REG_CK_PDN_SHIFT 8
#define PMIC_RG_PMU32K_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_PMU32K_CK_PDN_MASK 0x1
#define PMIC_RG_PMU32K_CK_PDN_SHIFT 9
#define PMIC_RG_FQMTR_32K_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_FQMTR_32K_CK_PDN_MASK 0x1
#define PMIC_RG_FQMTR_32K_CK_PDN_SHIFT 10
#define PMIC_RG_FQMTR_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_FQMTR_CK_PDN_MASK 0x1
#define PMIC_RG_FQMTR_CK_PDN_SHIFT 11
#define PMIC_RG_PMU26M_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_PMU26M_CK_PDN_MASK 0x1
#define PMIC_RG_PMU26M_CK_PDN_SHIFT 12
#define PMIC_RG_PMU128K_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_PMU128K_CK_PDN_MASK 0x1
#define PMIC_RG_PMU128K_CK_PDN_SHIFT 13
#define PMIC_RG_RTC26M_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_RTC26M_CK_PDN_MASK 0x1
#define PMIC_RG_RTC26M_CK_PDN_SHIFT 14
#define PMIC_RG_RTC32K_CK_PDN_ADDR MT6356_TOP_CKPDN_CON0
#define PMIC_RG_RTC32K_CK_PDN_MASK 0x1
#define PMIC_RG_RTC32K_CK_PDN_SHIFT 15
#define PMIC_TOP_CKPDN_CON0_SET_ADDR MT6356_TOP_CKPDN_CON0_SET
#define PMIC_TOP_CKPDN_CON0_SET_MASK 0xFFFF
#define PMIC_TOP_CKPDN_CON0_SET_SHIFT 0
#define PMIC_TOP_CKPDN_CON0_CLR_ADDR MT6356_TOP_CKPDN_CON0_CLR
#define PMIC_TOP_CKPDN_CON0_CLR_MASK 0xFFFF
#define PMIC_TOP_CKPDN_CON0_CLR_SHIFT 0
#define PMIC_RG_RTC32K_1V8_0_PDN_ADDR MT6356_TOP_CKPDN_CON1
#define PMIC_RG_RTC32K_1V8_0_PDN_MASK 0x1
#define PMIC_RG_RTC32K_1V8_0_PDN_SHIFT 0
#define PMIC_RG_RTC32K_1V8_1_PDN_ADDR MT6356_TOP_CKPDN_CON1
#define PMIC_RG_RTC32K_1V8_1_PDN_MASK 0x1
#define PMIC_RG_RTC32K_1V8_1_PDN_SHIFT 1
#define PMIC_RG_TRIM_128K_CK_PDN_ADDR MT6356_TOP_CKPDN_CON1
#define PMIC_RG_TRIM_128K_CK_PDN_MASK 0x1
#define PMIC_RG_TRIM_128K_CK_PDN_SHIFT 2
#define PMIC_RG_BGR_TEST_CK_PDN_ADDR MT6356_TOP_CKPDN_CON1
#define PMIC_RG_BGR_TEST_CK_PDN_MASK 0x1
#define PMIC_RG_BGR_TEST_CK_PDN_SHIFT 3
#define PMIC_RG_PCHR_TEST_CK_PDN_ADDR MT6356_TOP_CKPDN_CON1
#define PMIC_RG_PCHR_TEST_CK_PDN_MASK 0x1
#define PMIC_RG_PCHR_TEST_CK_PDN_SHIFT 4
#define PMIC_TOP_CKPDN_CON1_SET_ADDR MT6356_TOP_CKPDN_CON1_SET
#define PMIC_TOP_CKPDN_CON1_SET_MASK 0xFFFF
#define PMIC_TOP_CKPDN_CON1_SET_SHIFT 0
#define PMIC_TOP_CKPDN_CON1_CLR_ADDR MT6356_TOP_CKPDN_CON1_CLR
#define PMIC_TOP_CKPDN_CON1_CLR_MASK 0xFFFF
#define PMIC_TOP_CKPDN_CON1_CLR_SHIFT 0
#define PMIC_RG_FQMTR_CK_CKSEL_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_FQMTR_CK_CKSEL_MASK 0x7
#define PMIC_RG_FQMTR_CK_CKSEL_SHIFT 0
#define PMIC_RG_RTC_32K1V8_SEL_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_RTC_32K1V8_SEL_MASK 0x1
#define PMIC_RG_RTC_32K1V8_SEL_SHIFT 3
#define PMIC_RG_BGR_TEST_CK_CKSEL_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_BGR_TEST_CK_CKSEL_MASK 0x1
#define PMIC_RG_BGR_TEST_CK_CKSEL_SHIFT 4
#define PMIC_RG_PCHR_TEST_CK_CKSEL_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_PCHR_TEST_CK_CKSEL_MASK 0x1
#define PMIC_RG_PCHR_TEST_CK_CKSEL_SHIFT 5
#define PMIC_RG_26M_CK_SEL_HWEN_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_26M_CK_SEL_HWEN_MASK 0x1
#define PMIC_RG_26M_CK_SEL_HWEN_SHIFT 6
#define PMIC_RG_26M_CK_SEL_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_26M_CK_SEL_MASK 0x1
#define PMIC_RG_26M_CK_SEL_SHIFT 7
#define PMIC_RG_PMU_1M_CK_SEL_HWEN_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_PMU_1M_CK_SEL_HWEN_MASK 0x1
#define PMIC_RG_PMU_1M_CK_SEL_HWEN_SHIFT 8
#define PMIC_RG_PMU_1M_CK_SEL_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_PMU_1M_CK_SEL_MASK 0x1
#define PMIC_RG_PMU_1M_CK_SEL_SHIFT 9
#define PMIC_RG_PMU32K_CK_CKSEL_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_PMU32K_CK_CKSEL_MASK 0x1
#define PMIC_RG_PMU32K_CK_CKSEL_SHIFT 10
#define PMIC_RG_TOP_CKSEL_CON0_RSV_ADDR MT6356_TOP_CKSEL_CON0
#define PMIC_RG_TOP_CKSEL_CON0_RSV_MASK 0x1F
#define PMIC_RG_TOP_CKSEL_CON0_RSV_SHIFT 11
#define PMIC_TOP_CKSEL_CON0_SET_ADDR MT6356_TOP_CKSEL_CON0_SET
#define PMIC_TOP_CKSEL_CON0_SET_MASK 0xFFFF
#define PMIC_TOP_CKSEL_CON0_SET_SHIFT 0
#define PMIC_TOP_CKSEL_CON0_CLR_ADDR MT6356_TOP_CKSEL_CON0_CLR
#define PMIC_TOP_CKSEL_CON0_CLR_MASK 0xFFFF
#define PMIC_TOP_CKSEL_CON0_CLR_SHIFT 0
#define PMIC_RG_SRCVOLTEN_SW_ADDR MT6356_TOP_CKSEL_CON1
#define PMIC_RG_SRCVOLTEN_SW_MASK 0x1
#define PMIC_RG_SRCVOLTEN_SW_SHIFT 0
#define PMIC_RG_BUCK_OSC_SEL_SW_ADDR MT6356_TOP_CKSEL_CON1
#define PMIC_RG_BUCK_OSC_SEL_SW_MASK 0x1
#define PMIC_RG_BUCK_OSC_SEL_SW_SHIFT 1
#define PMIC_RG_VOWEN_SW_ADDR MT6356_TOP_CKSEL_CON1
#define PMIC_RG_VOWEN_SW_MASK 0x1
#define PMIC_RG_VOWEN_SW_SHIFT 2
#define PMIC_RG_SRCVOLTEN_MODE_ADDR MT6356_TOP_CKSEL_CON1
#define PMIC_RG_SRCVOLTEN_MODE_MASK 0x1
#define PMIC_RG_SRCVOLTEN_MODE_SHIFT 3
#define PMIC_RG_BUCK_OSC_SEL_MODE_ADDR MT6356_TOP_CKSEL_CON1
#define PMIC_RG_BUCK_OSC_SEL_MODE_MASK 0x1
#define PMIC_RG_BUCK_OSC_SEL_MODE_SHIFT 4
#define PMIC_RG_VOWEN_MODE_ADDR MT6356_TOP_CKSEL_CON1
#define PMIC_RG_VOWEN_MODE_MASK 0x1
#define PMIC_RG_VOWEN_MODE_SHIFT 5
#define PMIC_RG_TOP_CKSEL_CON2_RSV_ADDR MT6356_TOP_CKSEL_CON1
#define PMIC_RG_TOP_CKSEL_CON2_RSV_MASK 0xFF
#define PMIC_RG_TOP_CKSEL_CON2_RSV_SHIFT 8
#define PMIC_TOP_CKSEL_CON1_SET_ADDR MT6356_TOP_CKSEL_CON1_SET
#define PMIC_TOP_CKSEL_CON1_SET_MASK 0xFFFF
#define PMIC_TOP_CKSEL_CON1_SET_SHIFT 0
#define PMIC_TOP_CKSEL_CON1_CLR_ADDR MT6356_TOP_CKSEL_CON1_CLR
#define PMIC_TOP_CKSEL_CON1_CLR_MASK 0xFFFF
#define PMIC_TOP_CKSEL_CON1_CLR_SHIFT 0
#define PMIC_RG_REG_CK_DIVSEL_ADDR MT6356_TOP_CKDIVSEL_CON0
#define PMIC_RG_REG_CK_DIVSEL_MASK 0x3
#define PMIC_RG_REG_CK_DIVSEL_SHIFT 0
#define PMIC_TOP_CKDIVSEL_CON0_RSV_ADDR MT6356_TOP_CKDIVSEL_CON0
#define PMIC_TOP_CKDIVSEL_CON0_RSV_MASK 0x3F
#define PMIC_TOP_CKDIVSEL_CON0_RSV_SHIFT 10
#define PMIC_TOP_CKDIVSEL_CON0_SET_ADDR MT6356_TOP_CKDIVSEL_CON0_SET
#define PMIC_TOP_CKDIVSEL_CON0_SET_MASK 0xFFFF
#define PMIC_TOP_CKDIVSEL_CON0_SET_SHIFT 0
#define PMIC_TOP_CKDIVSEL_CON0_CLR_ADDR MT6356_TOP_CKDIVSEL_CON0_CLR
#define PMIC_TOP_CKDIVSEL_CON0_CLR_MASK 0xFFFF
#define PMIC_TOP_CKDIVSEL_CON0_CLR_SHIFT 0
#define PMIC_RG_G_SMPS_CK_PDN_HWEN_ADDR MT6356_TOP_CKHWEN_CON0
#define PMIC_RG_G_SMPS_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_G_SMPS_CK_PDN_HWEN_SHIFT 0
#define PMIC_RG_REG_CK_PDN_HWEN_ADDR MT6356_TOP_CKHWEN_CON0
#define PMIC_RG_REG_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_REG_CK_PDN_HWEN_SHIFT 1
#define PMIC_RG_EFUSE_CK_PDN_HWEN_ADDR MT6356_TOP_CKHWEN_CON0
#define PMIC_RG_EFUSE_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_EFUSE_CK_PDN_HWEN_SHIFT 2
#define PMIC_RG_EINT_32K_CK_PDN_HWEN_ADDR MT6356_TOP_CKHWEN_CON0
#define PMIC_RG_EINT_32K_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_EINT_32K_CK_PDN_HWEN_SHIFT 3
#define PMIC_RG_RTC26M_CK_PDN_HWEN_ADDR MT6356_TOP_CKHWEN_CON0
#define PMIC_RG_RTC26M_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_RTC26M_CK_PDN_HWEN_SHIFT 5
#define PMIC_RG_PMU26M_CK_PDN_HWEN_ADDR MT6356_TOP_CKHWEN_CON0
#define PMIC_RG_PMU26M_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_PMU26M_CK_PDN_HWEN_SHIFT 6
#define PMIC_TOP_CKHWEN_CON0_RSV_ADDR MT6356_TOP_CKHWEN_CON0
#define PMIC_TOP_CKHWEN_CON0_RSV_MASK 0x3
#define PMIC_TOP_CKHWEN_CON0_RSV_SHIFT 14
#define PMIC_TOP_CKHWEN_CON0_SET_ADDR MT6356_TOP_CKHWEN_CON0_SET
#define PMIC_TOP_CKHWEN_CON0_SET_MASK 0xFFFF
#define PMIC_TOP_CKHWEN_CON0_SET_SHIFT 0
#define PMIC_TOP_CKHWEN_CON0_CLR_ADDR MT6356_TOP_CKHWEN_CON0_CLR
#define PMIC_TOP_CKHWEN_CON0_CLR_MASK 0xFFFF
#define PMIC_TOP_CKHWEN_CON0_CLR_SHIFT 0
#define PMIC_RG_PMU128K_CK_TST_DIS_ADDR MT6356_TOP_CKTST_CON0
#define PMIC_RG_PMU128K_CK_TST_DIS_MASK 0x1
#define PMIC_RG_PMU128K_CK_TST_DIS_SHIFT 0
#define PMIC_RG_SMPS_CK_TST_DIS_ADDR MT6356_TOP_CKTST_CON0
#define PMIC_RG_SMPS_CK_TST_DIS_MASK 0x1
#define PMIC_RG_SMPS_CK_TST_DIS_SHIFT 1
#define PMIC_RG_XO_CLK_26M_PMU_TST_DIS_ADDR MT6356_TOP_CKTST_CON0
#define PMIC_RG_XO_CLK_26M_PMU_TST_DIS_MASK 0x1
#define PMIC_RG_XO_CLK_26M_PMU_TST_DIS_SHIFT 2
#define PMIC_RG_XO_CLK_26M_DIG_TST_DIS_ADDR MT6356_TOP_CKTST_CON0
#define PMIC_RG_XO_CLK_26M_DIG_TST_DIS_MASK 0x1
#define PMIC_RG_XO_CLK_26M_DIG_TST_DIS_SHIFT 3
#define PMIC_RG_RTC_26M_CK_TST_DIS_ADDR MT6356_TOP_CKTST_CON0
#define PMIC_RG_RTC_26M_CK_TST_DIS_MASK 0x1
#define PMIC_RG_RTC_26M_CK_TST_DIS_SHIFT 4
#define PMIC_RG_RTC_32K_CK_TST_DIS_ADDR MT6356_TOP_CKTST_CON0
#define PMIC_RG_RTC_32K_CK_TST_DIS_MASK 0x1
#define PMIC_RG_RTC_32K_CK_TST_DIS_SHIFT 5
#define PMIC_RG_PMU_M_CK_TST_DIS_ADDR MT6356_TOP_CKTST_CON0
#define PMIC_RG_PMU_M_CK_TST_DIS_MASK 0x1
#define PMIC_RG_PMU_M_CK_TST_DIS_SHIFT 6
#define PMIC_TOP_CKTST_CON0_RSV_ADDR MT6356_TOP_CKTST_CON0
#define PMIC_TOP_CKTST_CON0_RSV_MASK 0xFF
#define PMIC_TOP_CKTST_CON0_RSV_SHIFT 8
#define PMIC_RG_PMU128K_CK_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_PMU128K_CK_TSTSEL_MASK 0x1
#define PMIC_RG_PMU128K_CK_TSTSEL_SHIFT 0
#define PMIC_RG_SMPS_CK_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_SMPS_CK_TSTSEL_MASK 0x1
#define PMIC_RG_SMPS_CK_TSTSEL_SHIFT 1
#define PMIC_RG_XO_CLK_26M_PMU_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_XO_CLK_26M_PMU_TSTSEL_MASK 0x1
#define PMIC_RG_XO_CLK_26M_PMU_TSTSEL_SHIFT 2
#define PMIC_RG_XO_CLK_26M_DIG_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_XO_CLK_26M_DIG_TSTSEL_MASK 0x1
#define PMIC_RG_XO_CLK_26M_DIG_TSTSEL_SHIFT 3
#define PMIC_RG_RTC_26M_CK_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_RTC_26M_CK_TSTSEL_MASK 0x1
#define PMIC_RG_RTC_26M_CK_TSTSEL_SHIFT 4
#define PMIC_RG_RTC_32K_CK_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_RTC_32K_CK_TSTSEL_MASK 0x1
#define PMIC_RG_RTC_32K_CK_TSTSEL_SHIFT 5
#define PMIC_RG_PMU_M_CK_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_PMU_M_CK_TSTSEL_MASK 0x1
#define PMIC_RG_PMU_M_CK_TSTSEL_SHIFT 6
#define PMIC_RG_EFUSE_CK_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_EFUSE_CK_TSTSEL_MASK 0x1
#define PMIC_RG_EFUSE_CK_TSTSEL_SHIFT 7
#define PMIC_RG_BGR_TEST_CK_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_BGR_TEST_CK_TSTSEL_MASK 0x1
#define PMIC_RG_BGR_TEST_CK_TSTSEL_SHIFT 8
#define PMIC_RG_PCHR_TEST_CK_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_PCHR_TEST_CK_TSTSEL_MASK 0x1
#define PMIC_RG_PCHR_TEST_CK_TSTSEL_SHIFT 9
#define PMIC_RG_FQMTR_CK_TSTSEL_ADDR MT6356_TOP_CKTST_CON1
#define PMIC_RG_FQMTR_CK_TSTSEL_MASK 0x1
#define PMIC_RG_FQMTR_CK_TSTSEL_SHIFT 10
#define PMIC_RG_CLKSQ_EN_AUD_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_EN_AUD_MASK 0x1
#define PMIC_RG_CLKSQ_EN_AUD_SHIFT 0
#define PMIC_RG_CLKSQ_EN_FQR_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_EN_FQR_MASK 0x1
#define PMIC_RG_CLKSQ_EN_FQR_SHIFT 1
#define PMIC_RG_CLKSQ_EN_AUX_AP_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_EN_AUX_AP_MASK 0x1
#define PMIC_RG_CLKSQ_EN_AUX_AP_SHIFT 2
#define PMIC_RG_CLKSQ_EN_AUX_MD_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_EN_AUX_MD_MASK 0x1
#define PMIC_RG_CLKSQ_EN_AUX_MD_SHIFT 3
#define PMIC_RG_CLKSQ_EN_AUX_GPS_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_EN_AUX_GPS_MASK 0x1
#define PMIC_RG_CLKSQ_EN_AUX_GPS_SHIFT 4
#define PMIC_RG_CLKSQ_EN_AUX_RSV_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_EN_AUX_RSV_MASK 0x1
#define PMIC_RG_CLKSQ_EN_AUX_RSV_SHIFT 5
#define PMIC_RG_CLKSQ_EN_AUX_AP_MODE_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_EN_AUX_AP_MODE_MASK 0x1
#define PMIC_RG_CLKSQ_EN_AUX_AP_MODE_SHIFT 8
#define PMIC_RG_CLKSQ_EN_AUX_MD_MODE_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_EN_AUX_MD_MODE_MASK 0x1
#define PMIC_RG_CLKSQ_EN_AUX_MD_MODE_SHIFT 9
#define PMIC_RG_CLKSQ_IN_SEL_VA28_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_IN_SEL_VA28_MASK 0x1
#define PMIC_RG_CLKSQ_IN_SEL_VA28_SHIFT 10
#define PMIC_RG_CLKSQ_IN_SEL_VA28_SWCTRL_ADDR MT6356_TOP_CLKSQ
#define PMIC_RG_CLKSQ_IN_SEL_VA28_SWCTRL_MASK 0x1
#define PMIC_RG_CLKSQ_IN_SEL_VA28_SWCTRL_SHIFT 11
#define PMIC_TOP_CLKSQ_RSV_ADDR MT6356_TOP_CLKSQ
#define PMIC_TOP_CLKSQ_RSV_MASK 0x7
#define PMIC_TOP_CLKSQ_RSV_SHIFT 12
#define PMIC_DA_CLKSQ_EN_VA28_ADDR MT6356_TOP_CLKSQ
#define PMIC_DA_CLKSQ_EN_VA28_MASK 0x1
#define PMIC_DA_CLKSQ_EN_VA28_SHIFT 15
#define PMIC_TOP_CLKSQ_SET_ADDR MT6356_TOP_CLKSQ_SET
#define PMIC_TOP_CLKSQ_SET_MASK 0xFFFF
#define PMIC_TOP_CLKSQ_SET_SHIFT 0
#define PMIC_TOP_CLKSQ_CLR_ADDR MT6356_TOP_CLKSQ_CLR
#define PMIC_TOP_CLKSQ_CLR_MASK 0xFFFF
#define PMIC_TOP_CLKSQ_CLR_SHIFT 0
#define PMIC_RG_CLKSQ_RTC_EN_ADDR MT6356_TOP_CLKSQ_RTC
#define PMIC_RG_CLKSQ_RTC_EN_MASK 0x1
#define PMIC_RG_CLKSQ_RTC_EN_SHIFT 0
#define PMIC_RG_CLKSQ_RTC_EN_HW_MODE_ADDR MT6356_TOP_CLKSQ_RTC
#define PMIC_RG_CLKSQ_RTC_EN_HW_MODE_MASK 0x1
#define PMIC_RG_CLKSQ_RTC_EN_HW_MODE_SHIFT 1
#define PMIC_TOP_CLKSQ_RTC_RSV0_ADDR MT6356_TOP_CLKSQ_RTC
#define PMIC_TOP_CLKSQ_RTC_RSV0_MASK 0xF
#define PMIC_TOP_CLKSQ_RTC_RSV0_SHIFT 2
#define PMIC_RG_ENBB_SEL_ADDR MT6356_TOP_CLKSQ_RTC
#define PMIC_RG_ENBB_SEL_MASK 0x1
#define PMIC_RG_ENBB_SEL_SHIFT 8
#define PMIC_RG_XOSC_EN_SEL_ADDR MT6356_TOP_CLKSQ_RTC
#define PMIC_RG_XOSC_EN_SEL_MASK 0x1
#define PMIC_RG_XOSC_EN_SEL_SHIFT 9
#define PMIC_TOP_CLKSQ_RTC_RSV1_ADDR MT6356_TOP_CLKSQ_RTC
#define PMIC_TOP_CLKSQ_RTC_RSV1_MASK 0x3
#define PMIC_TOP_CLKSQ_RTC_RSV1_SHIFT 10
#define PMIC_DA_CLKSQ_EN_VDIG28_ADDR MT6356_TOP_CLKSQ_RTC
#define PMIC_DA_CLKSQ_EN_VDIG28_MASK 0x1
#define PMIC_DA_CLKSQ_EN_VDIG28_SHIFT 15
#define PMIC_TOP_CLKSQ_RTC_SET_ADDR MT6356_TOP_CLKSQ_RTC_SET
#define PMIC_TOP_CLKSQ_RTC_SET_MASK 0xFFFF
#define PMIC_TOP_CLKSQ_RTC_SET_SHIFT 0
#define PMIC_TOP_CLKSQ_RTC_CLR_ADDR MT6356_TOP_CLKSQ_RTC_CLR
#define PMIC_TOP_CLKSQ_RTC_CLR_MASK 0xFFFF
#define PMIC_TOP_CLKSQ_RTC_CLR_SHIFT 0
#define PMIC_RG_OSC_SEL_SW_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_OSC_SEL_SW_EN_MASK 0x1
#define PMIC_RG_OSC_SEL_SW_EN_SHIFT 0
#define PMIC_RG_OSC_SEL_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_OSC_SEL_MASK 0x1
#define PMIC_RG_OSC_SEL_SHIFT 1
#define PMIC_RG_OSC_EN_SW_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_OSC_EN_SW_EN_MASK 0x1
#define PMIC_RG_OSC_EN_SW_EN_SHIFT 2
#define PMIC_RG_OSC_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_OSC_EN_MASK 0x1
#define PMIC_RG_OSC_EN_SHIFT 3
#define PMIC_RG_G_SMPS_CK_PDN_VOWEN_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_G_SMPS_CK_PDN_VOWEN_EN_MASK 0x1
#define PMIC_RG_G_SMPS_CK_PDN_VOWEN_EN_SHIFT 4
#define PMIC_RG_SRCLKEN0_LP_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_SRCLKEN0_LP_EN_MASK 0x1
#define PMIC_RG_SRCLKEN0_LP_EN_SHIFT 5
#define PMIC_RG_SRCLKEN1_LP_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_SRCLKEN1_LP_EN_MASK 0x1
#define PMIC_RG_SRCLKEN1_LP_EN_SHIFT 6
#define PMIC_RG_SRCLKEN2_LP_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_SRCLKEN2_LP_EN_MASK 0x1
#define PMIC_RG_SRCLKEN2_LP_EN_SHIFT 7
#define PMIC_RG_BUCK_LP_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_BUCK_LP_EN_MASK 0x1
#define PMIC_RG_BUCK_LP_EN_SHIFT 8
#define PMIC_RG_LDO_LP_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_LDO_LP_EN_MASK 0x1
#define PMIC_RG_LDO_LP_EN_SHIFT 9
#define PMIC_RG_BUCK_PFM_FLAG_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_BUCK_PFM_FLAG_MASK 0x1
#define PMIC_RG_BUCK_PFM_FLAG_SHIFT 10
#define PMIC_RG_BUCK_PFM_FLAG_SW_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_BUCK_PFM_FLAG_SW_EN_MASK 0x1
#define PMIC_RG_BUCK_PFM_FLAG_SW_EN_SHIFT 11
#define PMIC_RG_DCXO26M_RDY_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_DCXO26M_RDY_MASK 0x1
#define PMIC_RG_DCXO26M_RDY_SHIFT 12
#define PMIC_RG_DCXO26M_RDY_SW_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_DCXO26M_RDY_SW_EN_MASK 0x1
#define PMIC_RG_DCXO26M_RDY_SW_EN_SHIFT 13
#define PMIC_RG_PMU_LP_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_PMU_LP_MASK 0x1
#define PMIC_RG_PMU_LP_SHIFT 14
#define PMIC_RG_PMU_LP_SW_EN_ADDR MT6356_TOP_CLK_CON0
#define PMIC_RG_PMU_LP_SW_EN_MASK 0x1
#define PMIC_RG_PMU_LP_SW_EN_SHIFT 15
#define PMIC_TOP_CLK_CON0_SET_ADDR MT6356_TOP_CLK_CON0_SET
#define PMIC_TOP_CLK_CON0_SET_MASK 0xFFFF
#define PMIC_TOP_CLK_CON0_SET_SHIFT 0
#define PMIC_TOP_CLK_CON0_CLR_ADDR MT6356_TOP_CLK_CON0_CLR
#define PMIC_TOP_CLK_CON0_CLR_MASK 0xFFFF
#define PMIC_TOP_CLK_CON0_CLR_SHIFT 0
#define PMIC_RG_PMU_MDB_DCM_SW_EN_ADDR MT6356_TOP_DCM_CON0
#define PMIC_RG_PMU_MDB_DCM_SW_EN_MASK 0x1
#define PMIC_RG_PMU_MDB_DCM_SW_EN_SHIFT 0
#define PMIC_RG_PMU_MDB_DCM_SW_MODE_ADDR MT6356_TOP_DCM_CON0
#define PMIC_RG_PMU_MDB_DCM_SW_MODE_MASK 0x1
#define PMIC_RG_PMU_MDB_DCM_SW_MODE_SHIFT 1
#define PMIC_RG_RTC_SEC_MDB_DCM_SW_EN_ADDR MT6356_TOP_DCM_CON0
#define PMIC_RG_RTC_SEC_MDB_DCM_SW_EN_MASK 0x1
#define PMIC_RG_RTC_SEC_MDB_DCM_SW_EN_SHIFT 4
#define PMIC_RG_RTC_SEC_MDB_DCM_SW_MODE_ADDR MT6356_TOP_DCM_CON0
#define PMIC_RG_RTC_SEC_MDB_DCM_SW_MODE_MASK 0x1
#define PMIC_RG_RTC_SEC_MDB_DCM_SW_MODE_SHIFT 5
#define PMIC_RG_RTC_MDB_DCM_SW_EN_ADDR MT6356_TOP_DCM_CON0
#define PMIC_RG_RTC_MDB_DCM_SW_EN_MASK 0x1
#define PMIC_RG_RTC_MDB_DCM_SW_EN_SHIFT 6
#define PMIC_RG_RTC_MDB_DCM_SW_MODE_ADDR MT6356_TOP_DCM_CON0
#define PMIC_RG_RTC_MDB_DCM_SW_MODE_MASK 0x1
#define PMIC_RG_RTC_MDB_DCM_SW_MODE_SHIFT 7
#define PMIC_RO_HANDOVER_DEBUG_ADDR MT6356_TOP_HANDOVER_DEBUG0
#define PMIC_RO_HANDOVER_DEBUG_MASK 0xFFFF
#define PMIC_RO_HANDOVER_DEBUG_SHIFT 0
#define PMIC_RG_EFUSE_MAN_RST_ADDR MT6356_TOP_RST_CON0
#define PMIC_RG_EFUSE_MAN_RST_MASK 0x1
#define PMIC_RG_EFUSE_MAN_RST_SHIFT 0
#define PMIC_RG_DRIVER_RST_ADDR MT6356_TOP_RST_CON0
#define PMIC_RG_DRIVER_RST_MASK 0x1
#define PMIC_RG_DRIVER_RST_SHIFT 6
#define PMIC_RG_FQMTR_RST_ADDR MT6356_TOP_RST_CON0
#define PMIC_RG_FQMTR_RST_MASK 0x1
#define PMIC_RG_FQMTR_RST_SHIFT 8
#define PMIC_RG_RTC_RST_ADDR MT6356_TOP_RST_CON0
#define PMIC_RG_RTC_RST_MASK 0x1
#define PMIC_RG_RTC_RST_SHIFT 9
#define PMIC_RG_TYPE_C_CC_RST_ADDR MT6356_TOP_RST_CON0
#define PMIC_RG_TYPE_C_CC_RST_MASK 0x1
#define PMIC_RG_TYPE_C_CC_RST_SHIFT 10
#define PMIC_RG_CLK_TRIM_RST_ADDR MT6356_TOP_RST_CON0
#define PMIC_RG_CLK_TRIM_RST_MASK 0x1
#define PMIC_RG_CLK_TRIM_RST_SHIFT 14
#define PMIC_RG_BUCK_SRCLKEN_RST_ADDR MT6356_TOP_RST_CON0
#define PMIC_RG_BUCK_SRCLKEN_RST_MASK 0x1
#define PMIC_RG_BUCK_SRCLKEN_RST_SHIFT 15
#define PMIC_TOP_RST_CON0_SET_ADDR MT6356_TOP_RST_CON0_SET
#define PMIC_TOP_RST_CON0_SET_MASK 0xFFFF
#define PMIC_TOP_RST_CON0_SET_SHIFT 0
#define PMIC_TOP_RST_CON0_CLR_ADDR MT6356_TOP_RST_CON0_CLR
#define PMIC_TOP_RST_CON0_CLR_MASK 0xFFFF
#define PMIC_TOP_RST_CON0_CLR_SHIFT 0
#define PMIC_RG_BUCK_PROT_PMPP_RST_ADDR MT6356_TOP_RST_CON1
#define PMIC_RG_BUCK_PROT_PMPP_RST_MASK 0x1
#define PMIC_RG_BUCK_PROT_PMPP_RST_SHIFT 1
#define PMIC_RG_SPK_RST_ADDR MT6356_TOP_RST_CON1
#define PMIC_RG_SPK_RST_MASK 0x1
#define PMIC_RG_SPK_RST_SHIFT 2
#define PMIC_RG_FT_VR_SYSRSTB_ADDR MT6356_TOP_RST_CON1
#define PMIC_RG_FT_VR_SYSRSTB_MASK 0x1
#define PMIC_RG_FT_VR_SYSRSTB_SHIFT 4
#define PMIC_RG_LDO_CALI_RST_ADDR MT6356_TOP_RST_CON1
#define PMIC_RG_LDO_CALI_RST_MASK 0x1
#define PMIC_RG_LDO_CALI_RST_SHIFT 7
#define PMIC_TOP_RST_CON1_RSV_ADDR MT6356_TOP_RST_CON1
#define PMIC_TOP_RST_CON1_RSV_MASK 0x1
#define PMIC_TOP_RST_CON1_RSV_SHIFT 8
#define PMIC_TOP_RST_CON1_SET_ADDR MT6356_TOP_RST_CON1_SET
#define PMIC_TOP_RST_CON1_SET_MASK 0xFFFF
#define PMIC_TOP_RST_CON1_SET_SHIFT 0
#define PMIC_TOP_RST_CON1_CLR_ADDR MT6356_TOP_RST_CON1_CLR
#define PMIC_TOP_RST_CON1_CLR_MASK 0xFFFF
#define PMIC_TOP_RST_CON1_CLR_SHIFT 0
#define PMIC_RG_CHR_LDO_DET_MODE_ADDR MT6356_TOP_RST_CON2
#define PMIC_RG_CHR_LDO_DET_MODE_MASK 0x1
#define PMIC_RG_CHR_LDO_DET_MODE_SHIFT 0
#define PMIC_RG_CHR_LDO_DET_SW_ADDR MT6356_TOP_RST_CON2
#define PMIC_RG_CHR_LDO_DET_SW_MASK 0x1
#define PMIC_RG_CHR_LDO_DET_SW_SHIFT 1
#define PMIC_RG_CHRWDT_FLAG_MODE_ADDR MT6356_TOP_RST_CON2
#define PMIC_RG_CHRWDT_FLAG_MODE_MASK 0x1
#define PMIC_RG_CHRWDT_FLAG_MODE_SHIFT 2
#define PMIC_RG_CHRWDT_FLAG_SW_ADDR MT6356_TOP_RST_CON2
#define PMIC_RG_CHRWDT_FLAG_SW_MASK 0x1
#define PMIC_RG_CHRWDT_FLAG_SW_SHIFT 3
#define PMIC_TOP_RST_CON2_RSV_ADDR MT6356_TOP_RST_CON2
#define PMIC_TOP_RST_CON2_RSV_MASK 0xF
#define PMIC_TOP_RST_CON2_RSV_SHIFT 4
#define PMIC_RG_WDTRSTB_EN_ADDR MT6356_TOP_RST_MISC
#define PMIC_RG_WDTRSTB_EN_MASK 0x1
#define PMIC_RG_WDTRSTB_EN_SHIFT 0
#define PMIC_RG_WDTRSTB_MODE_ADDR MT6356_TOP_RST_MISC
#define PMIC_RG_WDTRSTB_MODE_MASK 0x1
#define PMIC_RG_WDTRSTB_MODE_SHIFT 1
#define PMIC_WDTRSTB_STATUS_ADDR MT6356_TOP_RST_MISC
#define PMIC_WDTRSTB_STATUS_MASK 0x1
#define PMIC_WDTRSTB_STATUS_SHIFT 2
#define PMIC_WDTRSTB_STATUS_CLR_ADDR MT6356_TOP_RST_MISC
#define PMIC_WDTRSTB_STATUS_CLR_MASK 0x1
#define PMIC_WDTRSTB_STATUS_CLR_SHIFT 3
#define PMIC_RG_WDTRSTB_FB_EN_ADDR MT6356_TOP_RST_MISC
#define PMIC_RG_WDTRSTB_FB_EN_MASK 0x1
#define PMIC_RG_WDTRSTB_FB_EN_SHIFT 4
#define PMIC_RG_WDTRSTB_DEB_ADDR MT6356_TOP_RST_MISC
#define PMIC_RG_WDTRSTB_DEB_MASK 0x1
#define PMIC_RG_WDTRSTB_DEB_SHIFT 5
#define PMIC_RG_HOMEKEY_RST_EN_ADDR MT6356_TOP_RST_MISC
#define PMIC_RG_HOMEKEY_RST_EN_MASK 0x1
#define PMIC_RG_HOMEKEY_RST_EN_SHIFT 8
#define PMIC_RG_PWRKEY_RST_EN_ADDR MT6356_TOP_RST_MISC
#define PMIC_RG_PWRKEY_RST_EN_MASK 0x1
#define PMIC_RG_PWRKEY_RST_EN_SHIFT 9
#define PMIC_RG_PWRRST_TMR_DIS_ADDR MT6356_TOP_RST_MISC
#define PMIC_RG_PWRRST_TMR_DIS_MASK 0x1
#define PMIC_RG_PWRRST_TMR_DIS_SHIFT 10
#define PMIC_RG_PWRKEY_RST_TD_ADDR MT6356_TOP_RST_MISC
#define PMIC_RG_PWRKEY_RST_TD_MASK 0x3
#define PMIC_RG_PWRKEY_RST_TD_SHIFT 12
#define PMIC_TOP_RST_MISC_RSV_ADDR MT6356_TOP_RST_MISC
#define PMIC_TOP_RST_MISC_RSV_MASK 0x3
#define PMIC_TOP_RST_MISC_RSV_SHIFT 14
#define PMIC_TOP_RST_MISC_SET_ADDR MT6356_TOP_RST_MISC_SET
#define PMIC_TOP_RST_MISC_SET_MASK 0xFFFF
#define PMIC_TOP_RST_MISC_SET_SHIFT 0
#define PMIC_TOP_RST_MISC_CLR_ADDR MT6356_TOP_RST_MISC_CLR
#define PMIC_TOP_RST_MISC_CLR_MASK 0xFFFF
#define PMIC_TOP_RST_MISC_CLR_SHIFT 0
#define PMIC_VPWRIN_RSTB_STATUS_ADDR MT6356_TOP_RST_STATUS
#define PMIC_VPWRIN_RSTB_STATUS_MASK 0x1
#define PMIC_VPWRIN_RSTB_STATUS_SHIFT 0
#define PMIC_DDLO_RSTB_STATUS_ADDR MT6356_TOP_RST_STATUS
#define PMIC_DDLO_RSTB_STATUS_MASK 0x1
#define PMIC_DDLO_RSTB_STATUS_SHIFT 1
#define PMIC_UVLO_RSTB_STATUS_ADDR MT6356_TOP_RST_STATUS
#define PMIC_UVLO_RSTB_STATUS_MASK 0x1
#define PMIC_UVLO_RSTB_STATUS_SHIFT 2
#define PMIC_RTC_DDLO_RSTB_STATUS_ADDR MT6356_TOP_RST_STATUS
#define PMIC_RTC_DDLO_RSTB_STATUS_MASK 0x1
#define PMIC_RTC_DDLO_RSTB_STATUS_SHIFT 3
#define PMIC_CHRWDT_REG_RSTB_STATUS_ADDR MT6356_TOP_RST_STATUS
#define PMIC_CHRWDT_REG_RSTB_STATUS_MASK 0x1
#define PMIC_CHRWDT_REG_RSTB_STATUS_SHIFT 4
#define PMIC_CHRDET_REG_RSTB_STATUS_ADDR MT6356_TOP_RST_STATUS
#define PMIC_CHRDET_REG_RSTB_STATUS_MASK 0x1
#define PMIC_CHRDET_REG_RSTB_STATUS_SHIFT 5
#define PMIC_BWDT_DDLO_RSTB_STATUS_ADDR MT6356_TOP_RST_STATUS
#define PMIC_BWDT_DDLO_RSTB_STATUS_MASK 0x1
#define PMIC_BWDT_DDLO_RSTB_STATUS_SHIFT 6
#define PMIC_TOP_RST_STATUS_RSV_ADDR MT6356_TOP_RST_STATUS
#define PMIC_TOP_RST_STATUS_RSV_MASK 0x1
#define PMIC_TOP_RST_STATUS_RSV_SHIFT 7
#define PMIC_TOP_RST_STATUS_SET_ADDR MT6356_TOP_RST_STATUS_SET
#define PMIC_TOP_RST_STATUS_SET_MASK 0xFFFF
#define PMIC_TOP_RST_STATUS_SET_SHIFT 0
#define PMIC_TOP_RST_STATUS_CLR_ADDR MT6356_TOP_RST_STATUS_CLR
#define PMIC_TOP_RST_STATUS_CLR_MASK 0xFFFF
#define PMIC_TOP_RST_STATUS_CLR_SHIFT 0
#define PMIC_RG_INT_EN_EINT_RTC32K_1V8_1_ADDR MT6356_MISC_TOP_INT_CON0
#define PMIC_RG_INT_EN_EINT_RTC32K_1V8_1_MASK 0x1
#define PMIC_RG_INT_EN_EINT_RTC32K_1V8_1_SHIFT 0
#define PMIC_RG_INT_EN_SPI_CMD_ALERT_ADDR MT6356_MISC_TOP_INT_CON0
#define PMIC_RG_INT_EN_SPI_CMD_ALERT_MASK 0x1
#define PMIC_RG_INT_EN_SPI_CMD_ALERT_SHIFT 1
#define PMIC_MISC_TOP_INT_CON0_SET_ADDR MT6356_MISC_TOP_INT_CON0_SET
#define PMIC_MISC_TOP_INT_CON0_SET_MASK 0xFFFF
#define PMIC_MISC_TOP_INT_CON0_SET_SHIFT 0
#define PMIC_MISC_TOP_INT_CON0_CLR_ADDR MT6356_MISC_TOP_INT_CON0_CLR
#define PMIC_MISC_TOP_INT_CON0_CLR_MASK 0xFFFF
#define PMIC_MISC_TOP_INT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_EINT_RTC32K_1V8_1_ADDR MT6356_MISC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_EINT_RTC32K_1V8_1_MASK 0x1
#define PMIC_RG_INT_MASK_EINT_RTC32K_1V8_1_SHIFT 0
#define PMIC_RG_INT_MASK_SPI_CMD_ALERT_ADDR MT6356_MISC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_SPI_CMD_ALERT_MASK 0x1
#define PMIC_RG_INT_MASK_SPI_CMD_ALERT_SHIFT 1
#define PMIC_MISC_TOP_INT_MASK_CON0_SET_ADDR MT6356_MISC_TOP_INT_MASK_CON0_SET
#define PMIC_MISC_TOP_INT_MASK_CON0_SET_MASK 0xFFFF
#define PMIC_MISC_TOP_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_MISC_TOP_INT_MASK_CON0_CLR_ADDR MT6356_MISC_TOP_INT_MASK_CON0_CLR
#define PMIC_MISC_TOP_INT_MASK_CON0_CLR_MASK 0xFFFF
#define PMIC_MISC_TOP_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_STATUS_EINT_RTC32K_1V8_1_ADDR MT6356_MISC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_EINT_RTC32K_1V8_1_MASK 0x1
#define PMIC_RG_INT_STATUS_EINT_RTC32K_1V8_1_SHIFT 0
#define PMIC_RG_INT_STATUS_SPI_CMD_ALERT_ADDR MT6356_MISC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_SPI_CMD_ALERT_MASK 0x1
#define PMIC_RG_INT_STATUS_SPI_CMD_ALERT_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_EINT_RTC32K_1V8_1_ADDR                         \
	MT6356_MISC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_EINT_RTC32K_1V8_1_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_EINT_RTC32K_1V8_1_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_SPI_CMD_ALERT_ADDR                             \
	MT6356_MISC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_SPI_CMD_ALERT_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_SPI_CMD_ALERT_SHIFT 1
#define PMIC_RG_INT_SEN_EINT_RTC32K_1V8_1_ADDR MT6356_INT_EINT_CON0
#define PMIC_RG_INT_SEN_EINT_RTC32K_1V8_1_MASK 0x1
#define PMIC_RG_INT_SEN_EINT_RTC32K_1V8_1_SHIFT 0
#define PMIC_INT_EINT_CON0_SET_ADDR MT6356_INT_EINT_CON0_SET
#define PMIC_INT_EINT_CON0_SET_MASK 0xFFFF
#define PMIC_INT_EINT_CON0_SET_SHIFT 0
#define PMIC_INT_EINT_CON0_CLR_ADDR MT6356_INT_EINT_CON0_CLR
#define PMIC_INT_EINT_CON0_CLR_MASK 0xFFFF
#define PMIC_INT_EINT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_POL_EINT_RTC32K_1V8_1_ADDR MT6356_INT_EINT_CON1
#define PMIC_RG_INT_POL_EINT_RTC32K_1V8_1_MASK 0x1
#define PMIC_RG_INT_POL_EINT_RTC32K_1V8_1_SHIFT 0
#define PMIC_INT_EINT_CON1_SET_ADDR MT6356_INT_EINT_CON1_SET
#define PMIC_INT_EINT_CON1_SET_MASK 0xFFFF
#define PMIC_INT_EINT_CON1_SET_SHIFT 0
#define PMIC_INT_EINT_CON1_CLR_ADDR MT6356_INT_EINT_CON1_CLR
#define PMIC_INT_EINT_CON1_CLR_MASK 0xFFFF
#define PMIC_INT_EINT_CON1_CLR_SHIFT 0
#define PMIC_RG_SW_SEL_EINT_RTC32K_1V8_1_ADDR MT6356_INT_EINT_CON2
#define PMIC_RG_SW_SEL_EINT_RTC32K_1V8_1_MASK 0x1
#define PMIC_RG_SW_SEL_EINT_RTC32K_1V8_1_SHIFT 0
#define PMIC_INT_EINT_CON2_SET_ADDR MT6356_INT_EINT_CON2_SET
#define PMIC_INT_EINT_CON2_SET_MASK 0xFFFF
#define PMIC_INT_EINT_CON2_SET_SHIFT 0
#define PMIC_INT_EINT_CON2_CLR_ADDR MT6356_INT_EINT_CON2_CLR
#define PMIC_INT_EINT_CON2_CLR_MASK 0xFFFF
#define PMIC_INT_EINT_CON2_CLR_SHIFT 0
#define PMIC_RG_SW_EINT_RTC32K_1V8_1_ADDR MT6356_INT_EINT_CON3
#define PMIC_RG_SW_EINT_RTC32K_1V8_1_MASK 0x1
#define PMIC_RG_SW_EINT_RTC32K_1V8_1_SHIFT 0
#define PMIC_INT_EINT_CON3_SET_ADDR MT6356_INT_EINT_CON3_SET
#define PMIC_INT_EINT_CON3_SET_MASK 0xFFFF
#define PMIC_INT_EINT_CON3_SET_SHIFT 0
#define PMIC_INT_EINT_CON3_CLR_ADDR MT6356_INT_EINT_CON3_CLR
#define PMIC_INT_EINT_CON3_CLR_MASK 0xFFFF
#define PMIC_INT_EINT_CON3_CLR_SHIFT 0
#define PMIC_RG_DEB_EINT_RTC32K_1V8_1_ADDR MT6356_INT_EINT_CON4
#define PMIC_RG_DEB_EINT_RTC32K_1V8_1_MASK 0x3
#define PMIC_RG_DEB_EINT_RTC32K_1V8_1_SHIFT 0
#define PMIC_INT_EINT_CON4_SET_ADDR MT6356_INT_EINT_CON4_SET
#define PMIC_INT_EINT_CON4_SET_MASK 0xFFFF
#define PMIC_INT_EINT_CON4_SET_SHIFT 0
#define PMIC_INT_EINT_CON4_CLR_ADDR MT6356_INT_EINT_CON4_CLR
#define PMIC_INT_EINT_CON4_CLR_MASK 0xFFFF
#define PMIC_INT_EINT_CON4_CLR_SHIFT 0
#define PMIC_RG_DEB_EINT_AUD_CLK_MOSI_ADDR MT6356_INT_EINT_CON5
#define PMIC_RG_DEB_EINT_AUD_CLK_MOSI_MASK 0x3
#define PMIC_RG_DEB_EINT_AUD_CLK_MOSI_SHIFT 0
#define PMIC_INT_EINT_CON5_SET_ADDR MT6356_INT_EINT_CON5_SET
#define PMIC_INT_EINT_CON5_SET_MASK 0xFFFF
#define PMIC_INT_EINT_CON5_SET_SHIFT 0
#define PMIC_INT_EINT_CON5_CLR_ADDR MT6356_INT_EINT_CON5_CLR
#define PMIC_INT_EINT_CON5_CLR_MASK 0xFFFF
#define PMIC_INT_EINT_CON5_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_BUCK_TOP_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_BUCK_TOP_MASK 0x1
#define PMIC_RG_INT_MASK_BUCK_TOP_SHIFT 0
#define PMIC_RG_INT_MASK_LDO_TOP_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_LDO_TOP_MASK 0x1
#define PMIC_RG_INT_MASK_LDO_TOP_SHIFT 1
#define PMIC_RG_INT_MASK_PSC_TOP_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_PSC_TOP_MASK 0x1
#define PMIC_RG_INT_MASK_PSC_TOP_SHIFT 2
#define PMIC_RG_INT_MASK_SCK_TOP_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_SCK_TOP_MASK 0x1
#define PMIC_RG_INT_MASK_SCK_TOP_SHIFT 3
#define PMIC_RG_INT_MASK_BM_TOP_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_BM_TOP_MASK 0x1
#define PMIC_RG_INT_MASK_BM_TOP_SHIFT 4
#define PMIC_RG_INT_MASK_HK_TOP_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_HK_TOP_MASK 0x1
#define PMIC_RG_INT_MASK_HK_TOP_SHIFT 5
#define PMIC_RG_INT_MASK_XPP_TOP_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_XPP_TOP_MASK 0x1
#define PMIC_RG_INT_MASK_XPP_TOP_SHIFT 6
#define PMIC_RG_INT_MASK_AUD_TOP_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_AUD_TOP_MASK 0x1
#define PMIC_RG_INT_MASK_AUD_TOP_SHIFT 7
#define PMIC_RG_INT_MASK_MISC_TOP_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_MISC_TOP_MASK 0x1
#define PMIC_RG_INT_MASK_MISC_TOP_SHIFT 8
#define PMIC_RG_INT_MASK_TOP_CON0_RSV_ADDR MT6356_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_TOP_CON0_RSV_MASK 0x7F
#define PMIC_RG_INT_MASK_TOP_CON0_RSV_SHIFT 9
#define PMIC_TOP_INT_MASK_CON0_SET_ADDR MT6356_TOP_INT_MASK_CON0_SET
#define PMIC_TOP_INT_MASK_CON0_SET_MASK 0xFFFF
#define PMIC_TOP_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_TOP_INT_MASK_CON0_CLR_ADDR MT6356_TOP_INT_MASK_CON0_CLR
#define PMIC_TOP_INT_MASK_CON0_CLR_MASK 0xFFFF
#define PMIC_TOP_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_INT_STATUS_BUCK_TOP_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_BUCK_TOP_MASK 0x1
#define PMIC_INT_STATUS_BUCK_TOP_SHIFT 0
#define PMIC_INT_STATUS_LDO_TOP_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_LDO_TOP_MASK 0x1
#define PMIC_INT_STATUS_LDO_TOP_SHIFT 1
#define PMIC_INT_STATUS_PSC_TOP_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_PSC_TOP_MASK 0x1
#define PMIC_INT_STATUS_PSC_TOP_SHIFT 2
#define PMIC_INT_STATUS_SCK_TOP_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_SCK_TOP_MASK 0x1
#define PMIC_INT_STATUS_SCK_TOP_SHIFT 3
#define PMIC_INT_STATUS_BM_TOP_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_BM_TOP_MASK 0x1
#define PMIC_INT_STATUS_BM_TOP_SHIFT 4
#define PMIC_INT_STATUS_HK_TOP_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_HK_TOP_MASK 0x1
#define PMIC_INT_STATUS_HK_TOP_SHIFT 5
#define PMIC_INT_STATUS_XPP_TOP_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_XPP_TOP_MASK 0x1
#define PMIC_INT_STATUS_XPP_TOP_SHIFT 6
#define PMIC_INT_STATUS_AUD_TOP_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_AUD_TOP_MASK 0x1
#define PMIC_INT_STATUS_AUD_TOP_SHIFT 7
#define PMIC_INT_STATUS_MISC_TOP_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_MISC_TOP_MASK 0x1
#define PMIC_INT_STATUS_MISC_TOP_SHIFT 8
#define PMIC_INT_STATUS_TOP_RSV_ADDR MT6356_TOP_INT_STATUS0
#define PMIC_INT_STATUS_TOP_RSV_MASK 0x7F
#define PMIC_INT_STATUS_TOP_RSV_SHIFT 9
#define PMIC_INT_RAW_STATUS_BUCK_TOP_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_BUCK_TOP_MASK 0x1
#define PMIC_INT_RAW_STATUS_BUCK_TOP_SHIFT 0
#define PMIC_INT_RAW_STATUS_LDO_TOP_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_LDO_TOP_MASK 0x1
#define PMIC_INT_RAW_STATUS_LDO_TOP_SHIFT 1
#define PMIC_INT_RAW_STATUS_PSC_TOP_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_PSC_TOP_MASK 0x1
#define PMIC_INT_RAW_STATUS_PSC_TOP_SHIFT 2
#define PMIC_INT_RAW_STATUS_SCK_TOP_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_SCK_TOP_MASK 0x1
#define PMIC_INT_RAW_STATUS_SCK_TOP_SHIFT 3
#define PMIC_INT_RAW_STATUS_BM_TOP_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_BM_TOP_MASK 0x1
#define PMIC_INT_RAW_STATUS_BM_TOP_SHIFT 4
#define PMIC_INT_RAW_STATUS_HK_TOP_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_HK_TOP_MASK 0x1
#define PMIC_INT_RAW_STATUS_HK_TOP_SHIFT 5
#define PMIC_INT_RAW_STATUS_XPP_TOP_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_XPP_TOP_MASK 0x1
#define PMIC_INT_RAW_STATUS_XPP_TOP_SHIFT 6
#define PMIC_INT_RAW_STATUS_AUD_TOP_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_AUD_TOP_MASK 0x1
#define PMIC_INT_RAW_STATUS_AUD_TOP_SHIFT 7
#define PMIC_INT_RAW_STATUS_MISC_TOP_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_MISC_TOP_MASK 0x1
#define PMIC_INT_RAW_STATUS_MISC_TOP_SHIFT 8
#define PMIC_INT_RAW_STATUS_TOP_RSV_ADDR MT6356_TOP_INT_RAW_STATUS0
#define PMIC_INT_RAW_STATUS_TOP_RSV_MASK 0x7F
#define PMIC_INT_RAW_STATUS_TOP_RSV_SHIFT 9
#define PMIC_RG_INT_POLARITY_ADDR MT6356_TOP_INT_CON0
#define PMIC_RG_INT_POLARITY_MASK 0x1
#define PMIC_RG_INT_POLARITY_SHIFT 0
#define PMIC_RG_OTP_PA_ADDR MT6356_OTP_CON0
#define PMIC_RG_OTP_PA_MASK 0xFF
#define PMIC_RG_OTP_PA_SHIFT 0
#define PMIC_RG_OTP_PDIN_ADDR MT6356_OTP_CON1
#define PMIC_RG_OTP_PDIN_MASK 0xFF
#define PMIC_RG_OTP_PDIN_SHIFT 0
#define PMIC_RG_OTP_PTM_ADDR MT6356_OTP_CON2
#define PMIC_RG_OTP_PTM_MASK 0x3
#define PMIC_RG_OTP_PTM_SHIFT 0
#define PMIC_RG_OTP_PWE_ADDR MT6356_OTP_CON3
#define PMIC_RG_OTP_PWE_MASK 0x3
#define PMIC_RG_OTP_PWE_SHIFT 0
#define PMIC_RG_OTP_PPROG_ADDR MT6356_OTP_CON4
#define PMIC_RG_OTP_PPROG_MASK 0x1
#define PMIC_RG_OTP_PPROG_SHIFT 0
#define PMIC_RG_OTP_PWE_SRC_ADDR MT6356_OTP_CON5
#define PMIC_RG_OTP_PWE_SRC_MASK 0x1
#define PMIC_RG_OTP_PWE_SRC_SHIFT 0
#define PMIC_RG_OTP_PROG_PKEY_ADDR MT6356_OTP_CON6
#define PMIC_RG_OTP_PROG_PKEY_MASK 0xFFFF
#define PMIC_RG_OTP_PROG_PKEY_SHIFT 0
#define PMIC_RG_OTP_RD_PKEY_ADDR MT6356_OTP_CON7
#define PMIC_RG_OTP_RD_PKEY_MASK 0xFFFF
#define PMIC_RG_OTP_RD_PKEY_SHIFT 0
#define PMIC_RG_OTP_RD_TRIG_ADDR MT6356_OTP_CON8
#define PMIC_RG_OTP_RD_TRIG_MASK 0x1
#define PMIC_RG_OTP_RD_TRIG_SHIFT 0
#define PMIC_RG_RD_RDY_BYPASS_ADDR MT6356_OTP_CON9
#define PMIC_RG_RD_RDY_BYPASS_MASK 0x1
#define PMIC_RG_RD_RDY_BYPASS_SHIFT 0
#define PMIC_RG_SKIP_OTP_OUT_ADDR MT6356_OTP_CON10
#define PMIC_RG_SKIP_OTP_OUT_MASK 0x1
#define PMIC_RG_SKIP_OTP_OUT_SHIFT 0
#define PMIC_RG_OTP_RD_SW_ADDR MT6356_OTP_CON11
#define PMIC_RG_OTP_RD_SW_MASK 0x1
#define PMIC_RG_OTP_RD_SW_SHIFT 0
#define PMIC_RG_OTP_DOUT_SW_ADDR MT6356_OTP_CON12
#define PMIC_RG_OTP_DOUT_SW_MASK 0xFFFF
#define PMIC_RG_OTP_DOUT_SW_SHIFT 0
#define PMIC_RG_OTP_RD_BUSY_ADDR MT6356_OTP_CON13
#define PMIC_RG_OTP_RD_BUSY_MASK 0x1
#define PMIC_RG_OTP_RD_BUSY_SHIFT 0
#define PMIC_RG_OTP_RD_ACK_ADDR MT6356_OTP_CON13
#define PMIC_RG_OTP_RD_ACK_MASK 0x1
#define PMIC_RG_OTP_RD_ACK_SHIFT 2
#define PMIC_RG_OTP_PA_SW_ADDR MT6356_OTP_CON14
#define PMIC_RG_OTP_PA_SW_MASK 0x7F
#define PMIC_RG_OTP_PA_SW_SHIFT 0
#define PMIC_TOP1_ELR_LEN_ADDR MT6356_TOP1_ELR_NUM
#define PMIC_TOP1_ELR_LEN_MASK 0xFF
#define PMIC_TOP1_ELR_LEN_SHIFT 0
#define PMIC_RG_TOP1_RSV0_ADDR MT6356_TOP1_ELR0
#define PMIC_RG_TOP1_RSV0_MASK 0xFFFF
#define PMIC_RG_TOP1_RSV0_SHIFT 0
#define PMIC_RG_TOP1_RSV1_ADDR MT6356_TOP1_ELR1
#define PMIC_RG_TOP1_RSV1_MASK 0xFFFF
#define PMIC_RG_TOP1_RSV1_SHIFT 0
#define PMIC_EFUSE_OSC_MODE_ADDR MT6356_TOP1_ELR2
#define PMIC_EFUSE_OSC_MODE_MASK 0x3
#define PMIC_EFUSE_OSC_MODE_SHIFT 0
#define PMIC_TOPA0_ANA_ID_ADDR MT6356_TOPA0_ID
#define PMIC_TOPA0_ANA_ID_MASK 0xFF
#define PMIC_TOPA0_ANA_ID_SHIFT 0
#define PMIC_TOPA0_DIG_ID_ADDR MT6356_TOPA0_ID
#define PMIC_TOPA0_DIG_ID_MASK 0xFF
#define PMIC_TOPA0_DIG_ID_SHIFT 8
#define PMIC_TOPA0_ANA_MINOR_REV_ADDR MT6356_TOPA0_REV0
#define PMIC_TOPA0_ANA_MINOR_REV_MASK 0xF
#define PMIC_TOPA0_ANA_MINOR_REV_SHIFT 0
#define PMIC_TOPA0_ANA_MAJOR_REV_ADDR MT6356_TOPA0_REV0
#define PMIC_TOPA0_ANA_MAJOR_REV_MASK 0xF
#define PMIC_TOPA0_ANA_MAJOR_REV_SHIFT 4
#define PMIC_TOPA0_DIG_MINOR_REV_ADDR MT6356_TOPA0_REV0
#define PMIC_TOPA0_DIG_MINOR_REV_MASK 0xF
#define PMIC_TOPA0_DIG_MINOR_REV_SHIFT 8
#define PMIC_TOPA0_DIG_MAJOR_REV_ADDR MT6356_TOPA0_REV0
#define PMIC_TOPA0_DIG_MAJOR_REV_MASK 0xF
#define PMIC_TOPA0_DIG_MAJOR_REV_SHIFT 12
#define PMIC_TOPA0_SW_MINOR_REV_ADDR MT6356_TOPA0_REV1
#define PMIC_TOPA0_SW_MINOR_REV_MASK 0xF
#define PMIC_TOPA0_SW_MINOR_REV_SHIFT 0
#define PMIC_TOPA0_SW_MAJOR_REV_ADDR MT6356_TOPA0_REV1
#define PMIC_TOPA0_SW_MAJOR_REV_MASK 0xF
#define PMIC_TOPA0_SW_MAJOR_REV_SHIFT 4
#define PMIC_TOPA0_ESP_ADDR MT6356_TOPA0_REV1
#define PMIC_TOPA0_ESP_MASK 0xFF
#define PMIC_TOPA0_ESP_SHIFT 8
#define PMIC_FQMTR_TCKSEL_ADDR MT6356_FQMTR_CON0
#define PMIC_FQMTR_TCKSEL_MASK 0x7
#define PMIC_FQMTR_TCKSEL_SHIFT 0
#define PMIC_FQMTR_BUSY_ADDR MT6356_FQMTR_CON0
#define PMIC_FQMTR_BUSY_MASK 0x1
#define PMIC_FQMTR_BUSY_SHIFT 3
#define PMIC_FQMTR_DCXO26M_EN_ADDR MT6356_FQMTR_CON0
#define PMIC_FQMTR_DCXO26M_EN_MASK 0x1
#define PMIC_FQMTR_DCXO26M_EN_SHIFT 4
#define PMIC_FQMTR_EN_ADDR MT6356_FQMTR_CON0
#define PMIC_FQMTR_EN_MASK 0x1
#define PMIC_FQMTR_EN_SHIFT 15
#define PMIC_FQMTR_WINSET_ADDR MT6356_FQMTR_CON1
#define PMIC_FQMTR_WINSET_MASK 0xFFFF
#define PMIC_FQMTR_WINSET_SHIFT 0
#define PMIC_FQMTR_DATA_ADDR MT6356_FQMTR_CON2
#define PMIC_FQMTR_DATA_MASK 0xFFFF
#define PMIC_FQMTR_DATA_SHIFT 0
#define PMIC_RG_OSC_128K_TRIM_EN_ADDR MT6356_TOP_CLK_TRIM
#define PMIC_RG_OSC_128K_TRIM_EN_MASK 0x1
#define PMIC_RG_OSC_128K_TRIM_EN_SHIFT 6
#define PMIC_RG_OSC_128K_TRIM_RATE_ADDR MT6356_TOP_CLK_TRIM
#define PMIC_RG_OSC_128K_TRIM_RATE_MASK 0x3
#define PMIC_RG_OSC_128K_TRIM_RATE_SHIFT 7
#define PMIC_DA_OSC_128K_TRIM_ADDR MT6356_TOP_CLK_TRIM
#define PMIC_DA_OSC_128K_TRIM_MASK 0x3F
#define PMIC_DA_OSC_128K_TRIM_SHIFT 9
#define PMIC_TOP_MDB_RSV0_ADDR MT6356_TOP_MDB_CONF0
#define PMIC_TOP_MDB_RSV0_MASK 0xFFFF
#define PMIC_TOP_MDB_RSV0_SHIFT 0
#define PMIC_RG_MDB_DM1_DS_EN_ADDR MT6356_TOP_MDB_CONF1
#define PMIC_RG_MDB_DM1_DS_EN_MASK 0x1
#define PMIC_RG_MDB_DM1_DS_EN_SHIFT 0
#define PMIC_TOP_MDB_RSV1_ADDR MT6356_TOP_MDB_CONF1
#define PMIC_TOP_MDB_RSV1_MASK 0x7FFF
#define PMIC_TOP_MDB_RSV1_SHIFT 1
#define PMIC_TOPA0_ELR_LEN_ADDR MT6356_TOPA0_ELR_NUM
#define PMIC_TOPA0_ELR_LEN_MASK 0xFF
#define PMIC_TOPA0_ELR_LEN_SHIFT 0
#define PMIC_RG_OSC_128K_TRIM_ADDR MT6356_TOPA0_ELR0
#define PMIC_RG_OSC_128K_TRIM_MASK 0x3F
#define PMIC_RG_OSC_128K_TRIM_SHIFT 0
#define PMIC_SPISLV_ANA_ID_ADDR MT6356_SPISLV_ID
#define PMIC_SPISLV_ANA_ID_MASK 0xFF
#define PMIC_SPISLV_ANA_ID_SHIFT 0
#define PMIC_SPISLV_DIG_ID_ADDR MT6356_SPISLV_ID
#define PMIC_SPISLV_DIG_ID_MASK 0xFF
#define PMIC_SPISLV_DIG_ID_SHIFT 8
#define PMIC_SPISLV_ANA_MINOR_REV_ADDR MT6356_SPISLV_REV0
#define PMIC_SPISLV_ANA_MINOR_REV_MASK 0xF
#define PMIC_SPISLV_ANA_MINOR_REV_SHIFT 0
#define PMIC_SPISLV_ANA_MAJOR_REV_ADDR MT6356_SPISLV_REV0
#define PMIC_SPISLV_ANA_MAJOR_REV_MASK 0xF
#define PMIC_SPISLV_ANA_MAJOR_REV_SHIFT 4
#define PMIC_SPISLV_DIG_MINOR_REV_ADDR MT6356_SPISLV_REV0
#define PMIC_SPISLV_DIG_MINOR_REV_MASK 0xF
#define PMIC_SPISLV_DIG_MINOR_REV_SHIFT 8
#define PMIC_SPISLV_DIG_MAJOR_REV_ADDR MT6356_SPISLV_REV0
#define PMIC_SPISLV_DIG_MAJOR_REV_MASK 0xF
#define PMIC_SPISLV_DIG_MAJOR_REV_SHIFT 12
#define PMIC_SPISLV_SW_MINOR_REV_ADDR MT6356_SPISLV_REV1
#define PMIC_SPISLV_SW_MINOR_REV_MASK 0xF
#define PMIC_SPISLV_SW_MINOR_REV_SHIFT 0
#define PMIC_SPISLV_SW_MAJOR_REV_ADDR MT6356_SPISLV_REV1
#define PMIC_SPISLV_SW_MAJOR_REV_MASK 0xF
#define PMIC_SPISLV_SW_MAJOR_REV_SHIFT 4
#define PMIC_SPISLV_ESP_ADDR MT6356_SPISLV_REV1
#define PMIC_SPISLV_ESP_MASK 0xFF
#define PMIC_SPISLV_ESP_SHIFT 8
#define PMIC_RG_SLP_RW_EN_ADDR MT6356_RG_SPI_CON0
#define PMIC_RG_SLP_RW_EN_MASK 0x1
#define PMIC_RG_SLP_RW_EN_SHIFT 0
#define PMIC_RG_EN_RECORD_ADDR MT6356_RG_SPI_CON0
#define PMIC_RG_EN_RECORD_MASK 0x1
#define PMIC_RG_EN_RECORD_SHIFT 1
#define PMIC_RG_MDB_BRIDGE_SWRST_ADDR MT6356_RG_SPI_CON0
#define PMIC_RG_MDB_BRIDGE_SWRST_MASK 0x1
#define PMIC_RG_MDB_BRIDGE_SWRST_SHIFT 2
#define PMIC_RG_MDB_BRIDGE_BYPASS_MODE_ADDR MT6356_RG_SPI_CON0
#define PMIC_RG_MDB_BRIDGE_BYPASS_MODE_MASK 0x1
#define PMIC_RG_MDB_BRIDGE_BYPASS_MODE_SHIFT 3
#define PMIC_RG_SPI_RSV_ADDR MT6356_RG_SPI_CON0
#define PMIC_RG_SPI_RSV_MASK 0xFFF
#define PMIC_RG_SPI_RSV_SHIFT 4
#define PMIC_DEW_DIO_EN_ADDR MT6356_DEW_DIO_EN
#define PMIC_DEW_DIO_EN_MASK 0x1
#define PMIC_DEW_DIO_EN_SHIFT 0
#define PMIC_DEW_READ_TEST_ADDR MT6356_DEW_READ_TEST
#define PMIC_DEW_READ_TEST_MASK 0xFFFF
#define PMIC_DEW_READ_TEST_SHIFT 0
#define PMIC_DEW_WRITE_TEST_ADDR MT6356_DEW_WRITE_TEST
#define PMIC_DEW_WRITE_TEST_MASK 0xFFFF
#define PMIC_DEW_WRITE_TEST_SHIFT 0
#define PMIC_DEW_CRC_SWRST_ADDR MT6356_DEW_CRC_SWRST
#define PMIC_DEW_CRC_SWRST_MASK 0x1
#define PMIC_DEW_CRC_SWRST_SHIFT 0
#define PMIC_DEW_CRC_EN_ADDR MT6356_DEW_CRC_EN
#define PMIC_DEW_CRC_EN_MASK 0x1
#define PMIC_DEW_CRC_EN_SHIFT 0
#define PMIC_DEW_CRC_VAL_ADDR MT6356_DEW_CRC_VAL
#define PMIC_DEW_CRC_VAL_MASK 0xFF
#define PMIC_DEW_CRC_VAL_SHIFT 0
#define PMIC_DEW_DBG_MON_SEL_ADDR MT6356_DEW_DBG_MON_SEL
#define PMIC_DEW_DBG_MON_SEL_MASK 0xF
#define PMIC_DEW_DBG_MON_SEL_SHIFT 0
#define PMIC_DEW_CIPHER_KEY_SEL_ADDR MT6356_DEW_CIPHER_KEY_SEL
#define PMIC_DEW_CIPHER_KEY_SEL_MASK 0x3
#define PMIC_DEW_CIPHER_KEY_SEL_SHIFT 0
#define PMIC_DEW_CIPHER_IV_SEL_ADDR MT6356_DEW_CIPHER_IV_SEL
#define PMIC_DEW_CIPHER_IV_SEL_MASK 0x3
#define PMIC_DEW_CIPHER_IV_SEL_SHIFT 0
#define PMIC_DEW_CIPHER_EN_ADDR MT6356_DEW_CIPHER_EN
#define PMIC_DEW_CIPHER_EN_MASK 0x1
#define PMIC_DEW_CIPHER_EN_SHIFT 0
#define PMIC_DEW_CIPHER_RDY_ADDR MT6356_DEW_CIPHER_RDY
#define PMIC_DEW_CIPHER_RDY_MASK 0x1
#define PMIC_DEW_CIPHER_RDY_SHIFT 0
#define PMIC_DEW_CIPHER_MODE_ADDR MT6356_DEW_CIPHER_MODE
#define PMIC_DEW_CIPHER_MODE_MASK 0x1
#define PMIC_DEW_CIPHER_MODE_SHIFT 0
#define PMIC_DEW_CIPHER_SWRST_ADDR MT6356_DEW_CIPHER_SWRST
#define PMIC_DEW_CIPHER_SWRST_MASK 0x1
#define PMIC_DEW_CIPHER_SWRST_SHIFT 0
#define PMIC_DEW_RDDMY_NO_ADDR MT6356_DEW_RDDMY_NO
#define PMIC_DEW_RDDMY_NO_MASK 0xF
#define PMIC_DEW_RDDMY_NO_SHIFT 0
#define PMIC_INT_TYPE_CON0_ADDR MT6356_INT_TYPE_CON0
#define PMIC_INT_TYPE_CON0_MASK 0xFFFF
#define PMIC_INT_TYPE_CON0_SHIFT 0
#define PMIC_INT_TYPE_CON0_SET_ADDR MT6356_INT_TYPE_CON0_SET
#define PMIC_INT_TYPE_CON0_SET_MASK 0xFFFF
#define PMIC_INT_TYPE_CON0_SET_SHIFT 0
#define PMIC_INT_TYPE_CON0_CLR_ADDR MT6356_INT_TYPE_CON0_CLR
#define PMIC_INT_TYPE_CON0_CLR_MASK 0xFFFF
#define PMIC_INT_TYPE_CON0_CLR_SHIFT 0
#define PMIC_INT_TYPE_CON1_ADDR MT6356_INT_TYPE_CON1
#define PMIC_INT_TYPE_CON1_MASK 0xFFFF
#define PMIC_INT_TYPE_CON1_SHIFT 0
#define PMIC_INT_TYPE_CON1_SET_ADDR MT6356_INT_TYPE_CON1_SET
#define PMIC_INT_TYPE_CON1_SET_MASK 0xFFFF
#define PMIC_INT_TYPE_CON1_SET_SHIFT 0
#define PMIC_INT_TYPE_CON1_CLR_ADDR MT6356_INT_TYPE_CON1_CLR
#define PMIC_INT_TYPE_CON1_CLR_MASK 0xFFFF
#define PMIC_INT_TYPE_CON1_CLR_SHIFT 0
#define PMIC_INT_TYPE_CON2_ADDR MT6356_INT_TYPE_CON2
#define PMIC_INT_TYPE_CON2_MASK 0xFFFF
#define PMIC_INT_TYPE_CON2_SHIFT 0
#define PMIC_INT_TYPE_CON2_SET_ADDR MT6356_INT_TYPE_CON2_SET
#define PMIC_INT_TYPE_CON2_SET_MASK 0xFFFF
#define PMIC_INT_TYPE_CON2_SET_SHIFT 0
#define PMIC_INT_TYPE_CON2_CLR_ADDR MT6356_INT_TYPE_CON2_CLR
#define PMIC_INT_TYPE_CON2_CLR_MASK 0xFFFF
#define PMIC_INT_TYPE_CON2_CLR_SHIFT 0
#define PMIC_INT_TYPE_CON3_ADDR MT6356_INT_TYPE_CON3
#define PMIC_INT_TYPE_CON3_MASK 0xFFFF
#define PMIC_INT_TYPE_CON3_SHIFT 0
#define PMIC_INT_TYPE_CON3_SET_ADDR MT6356_INT_TYPE_CON3_SET
#define PMIC_INT_TYPE_CON3_SET_MASK 0xFFFF
#define PMIC_INT_TYPE_CON3_SET_SHIFT 0
#define PMIC_INT_TYPE_CON3_CLR_ADDR MT6356_INT_TYPE_CON3_CLR
#define PMIC_INT_TYPE_CON3_CLR_MASK 0xFFFF
#define PMIC_INT_TYPE_CON3_CLR_SHIFT 0
#define PMIC_INT_TYPE_CON4_ADDR MT6356_INT_TYPE_CON4
#define PMIC_INT_TYPE_CON4_MASK 0xFFFF
#define PMIC_INT_TYPE_CON4_SHIFT 0
#define PMIC_INT_TYPE_CON4_SET_ADDR MT6356_INT_TYPE_CON4_SET
#define PMIC_INT_TYPE_CON4_SET_MASK 0xFFFF
#define PMIC_INT_TYPE_CON4_SET_SHIFT 0
#define PMIC_INT_TYPE_CON4_CLR_ADDR MT6356_INT_TYPE_CON4_CLR
#define PMIC_INT_TYPE_CON4_CLR_MASK 0xFFFF
#define PMIC_INT_TYPE_CON4_CLR_SHIFT 0
#define PMIC_INT_TYPE_CON5_ADDR MT6356_INT_TYPE_CON5
#define PMIC_INT_TYPE_CON5_MASK 0xFFFF
#define PMIC_INT_TYPE_CON5_SHIFT 0
#define PMIC_INT_TYPE_CON5_SET_ADDR MT6356_INT_TYPE_CON5_SET
#define PMIC_INT_TYPE_CON5_SET_MASK 0xFFFF
#define PMIC_INT_TYPE_CON5_SET_SHIFT 0
#define PMIC_INT_TYPE_CON5_CLR_ADDR MT6356_INT_TYPE_CON5_CLR
#define PMIC_INT_TYPE_CON5_CLR_MASK 0xFFFF
#define PMIC_INT_TYPE_CON5_CLR_SHIFT 0
#define PMIC_INT_TYPE_CON6_ADDR MT6356_INT_TYPE_CON6
#define PMIC_INT_TYPE_CON6_MASK 0xFFFF
#define PMIC_INT_TYPE_CON6_SHIFT 0
#define PMIC_INT_TYPE_CON6_SET_ADDR MT6356_INT_TYPE_CON6_SET
#define PMIC_INT_TYPE_CON6_SET_MASK 0xFFFF
#define PMIC_INT_TYPE_CON6_SET_SHIFT 0
#define PMIC_INT_TYPE_CON6_CLR_ADDR MT6356_INT_TYPE_CON6_CLR
#define PMIC_INT_TYPE_CON6_CLR_MASK 0xFFFF
#define PMIC_INT_TYPE_CON6_CLR_SHIFT 0
#define PMIC_CPU_INT_STA_ADDR MT6356_INT_STA
#define PMIC_CPU_INT_STA_MASK 0x1
#define PMIC_CPU_INT_STA_SHIFT 0
#define PMIC_MD32_INT_STA_ADDR MT6356_INT_STA
#define PMIC_MD32_INT_STA_MASK 0x1
#define PMIC_MD32_INT_STA_SHIFT 1
#define PMIC_RG_SRCLKEN_IN3_SMPS_CLK_MODE_ADDR MT6356_RG_SPI_CON1
#define PMIC_RG_SRCLKEN_IN3_SMPS_CLK_MODE_MASK 0x1
#define PMIC_RG_SRCLKEN_IN3_SMPS_CLK_MODE_SHIFT 0
#define PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST_ADDR MT6356_RG_SPI_CON1
#define PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST_MASK 0x1
#define PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST_SHIFT 1
#define PMIC_RG_SRCLKEN_IN2_SMPS_CLK_MODE_ADDR MT6356_RG_SPI_CON1
#define PMIC_RG_SRCLKEN_IN2_SMPS_CLK_MODE_MASK 0x1
#define PMIC_RG_SRCLKEN_IN2_SMPS_CLK_MODE_SHIFT 2
#define PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST_ADDR MT6356_RG_SPI_CON1
#define PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST_MASK 0x1
#define PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST_SHIFT 3
#define PMIC_RG_SPI_DLY_SEL_ADDR MT6356_RG_SPI_CON2
#define PMIC_RG_SPI_DLY_SEL_MASK 0xF
#define PMIC_RG_SPI_DLY_SEL_SHIFT 0
#define PMIC_RECORD_CMD0_ADDR MT6356_RG_SPI_CON3
#define PMIC_RECORD_CMD0_MASK 0xFFFF
#define PMIC_RECORD_CMD0_SHIFT 0
#define PMIC_RECORD_CMD1_ADDR MT6356_RG_SPI_CON4
#define PMIC_RECORD_CMD1_MASK 0xFFFF
#define PMIC_RECORD_CMD1_SHIFT 0
#define PMIC_RECORD_CMD2_ADDR MT6356_RG_SPI_CON5
#define PMIC_RECORD_CMD2_MASK 0xFFFF
#define PMIC_RECORD_CMD2_SHIFT 0
#define PMIC_RECORD_WDATA0_ADDR MT6356_RG_SPI_CON6
#define PMIC_RECORD_WDATA0_MASK 0xFFFF
#define PMIC_RECORD_WDATA0_SHIFT 0
#define PMIC_RECORD_WDATA1_ADDR MT6356_RG_SPI_CON7
#define PMIC_RECORD_WDATA1_MASK 0xFFFF
#define PMIC_RECORD_WDATA1_SHIFT 0
#define PMIC_RECORD_WDATA2_ADDR MT6356_RG_SPI_CON8
#define PMIC_RECORD_WDATA2_MASK 0xFFFF
#define PMIC_RECORD_WDATA2_SHIFT 0
#define PMIC_RG_ADDR_TARGET_ADDR MT6356_RG_SPI_CON9
#define PMIC_RG_ADDR_TARGET_MASK 0xFFFF
#define PMIC_RG_ADDR_TARGET_SHIFT 0
#define PMIC_RG_ADDR_MASK_ADDR MT6356_RG_SPI_CON10
#define PMIC_RG_ADDR_MASK_MASK 0xFFFF
#define PMIC_RG_ADDR_MASK_SHIFT 0
#define PMIC_RG_WDATA_TARGET_ADDR MT6356_RG_SPI_CON11
#define PMIC_RG_WDATA_TARGET_MASK 0xFFFF
#define PMIC_RG_WDATA_TARGET_SHIFT 0
#define PMIC_RG_WDATA_MASK_ADDR MT6356_RG_SPI_CON12
#define PMIC_RG_WDATA_MASK_MASK 0xFFFF
#define PMIC_RG_WDATA_MASK_SHIFT 0
#define PMIC_RG_SPI_RECORD_CLR_ADDR MT6356_RG_SPI_CON13
#define PMIC_RG_SPI_RECORD_CLR_MASK 0x1
#define PMIC_RG_SPI_RECORD_CLR_SHIFT 0
#define PMIC_RG_CMD_ALERT_CLR_ADDR MT6356_RG_SPI_CON13
#define PMIC_RG_CMD_ALERT_CLR_MASK 0x1
#define PMIC_RG_CMD_ALERT_CLR_SHIFT 15
#define PMIC_RG_SRCLKEN_IN2_EN_ADDR MT6356_TOP_SPI_CON0
#define PMIC_RG_SRCLKEN_IN2_EN_MASK 0x1
#define PMIC_RG_SRCLKEN_IN2_EN_SHIFT 0
#define PMIC_RG_SRCLKEN_IN3_EN_ADDR MT6356_TOP_SPI_CON1
#define PMIC_RG_SRCLKEN_IN3_EN_MASK 0x1
#define PMIC_RG_SRCLKEN_IN3_EN_SHIFT 0
#define PMIC_PSC_TOP_ANA_ID_ADDR MT6356_PSC_TOP_ID
#define PMIC_PSC_TOP_ANA_ID_MASK 0xFF
#define PMIC_PSC_TOP_ANA_ID_SHIFT 0
#define PMIC_PSC_TOP_DIG_ID_ADDR MT6356_PSC_TOP_ID
#define PMIC_PSC_TOP_DIG_ID_MASK 0xFF
#define PMIC_PSC_TOP_DIG_ID_SHIFT 8
#define PMIC_PSC_TOP_ANA_MINOR_REV_ADDR MT6356_PSC_TOP_REV0
#define PMIC_PSC_TOP_ANA_MINOR_REV_MASK 0xF
#define PMIC_PSC_TOP_ANA_MINOR_REV_SHIFT 0
#define PMIC_PSC_TOP_ANA_MAJOR_REV_ADDR MT6356_PSC_TOP_REV0
#define PMIC_PSC_TOP_ANA_MAJOR_REV_MASK 0xF
#define PMIC_PSC_TOP_ANA_MAJOR_REV_SHIFT 4
#define PMIC_PSC_TOP_DIG_MINOR_REV_ADDR MT6356_PSC_TOP_REV0
#define PMIC_PSC_TOP_DIG_MINOR_REV_MASK 0xF
#define PMIC_PSC_TOP_DIG_MINOR_REV_SHIFT 8
#define PMIC_PSC_TOP_DIG_MAJOR_REV_ADDR MT6356_PSC_TOP_REV0
#define PMIC_PSC_TOP_DIG_MAJOR_REV_MASK 0xF
#define PMIC_PSC_TOP_DIG_MAJOR_REV_SHIFT 12
#define PMIC_PSC_TOP_SW_MINOR_REV_ADDR MT6356_PSC_TOP_REV1
#define PMIC_PSC_TOP_SW_MINOR_REV_MASK 0xF
#define PMIC_PSC_TOP_SW_MINOR_REV_SHIFT 0
#define PMIC_PSC_TOP_SW_MAJOR_REV_ADDR MT6356_PSC_TOP_REV1
#define PMIC_PSC_TOP_SW_MAJOR_REV_MASK 0xF
#define PMIC_PSC_TOP_SW_MAJOR_REV_SHIFT 4
#define PMIC_PSC_TOP_ESP_ADDR MT6356_PSC_TOP_REV1
#define PMIC_PSC_TOP_ESP_MASK 0xFF
#define PMIC_PSC_TOP_ESP_SHIFT 8
#define PMIC_PSC_TOP_CLK_OFFSET_ADDR MT6356_PSC_TOP_PAM0
#define PMIC_PSC_TOP_CLK_OFFSET_MASK 0xFF
#define PMIC_PSC_TOP_CLK_OFFSET_SHIFT 0
#define PMIC_PSC_TOP_RST_OFFSET_ADDR MT6356_PSC_TOP_PAM0
#define PMIC_PSC_TOP_RST_OFFSET_MASK 0xFF
#define PMIC_PSC_TOP_RST_OFFSET_SHIFT 8
#define PMIC_PSC_TOP_INT_OFFSET_ADDR MT6356_PSC_TOP_PAM1
#define PMIC_PSC_TOP_INT_OFFSET_MASK 0xFF
#define PMIC_PSC_TOP_INT_OFFSET_SHIFT 0
#define PMIC_PSC_TOP_INT_LEN_ADDR MT6356_PSC_TOP_PAM1
#define PMIC_PSC_TOP_INT_LEN_MASK 0xFF
#define PMIC_PSC_TOP_INT_LEN_SHIFT 8
#define PMIC_RG_STRUP_LONG_PRESS_RST_ADDR MT6356_PSC_TOP_RSTCTL_0
#define PMIC_RG_STRUP_LONG_PRESS_RST_MASK 0x1
#define PMIC_RG_STRUP_LONG_PRESS_RST_SHIFT 0
#define PMIC_RG_PSEQ_PWRMSK_RST_SEL_ADDR MT6356_PSC_TOP_RSTCTL_0
#define PMIC_RG_PSEQ_PWRMSK_RST_SEL_MASK 0x1
#define PMIC_RG_PSEQ_PWRMSK_RST_SEL_SHIFT 4
#define PMIC_BANK_STRUP_SWRST_ADDR MT6356_PSC_TOP_RSTCTL_0
#define PMIC_BANK_STRUP_SWRST_MASK 0x1
#define PMIC_BANK_STRUP_SWRST_SHIFT 8
#define PMIC_BANK_PSEQ_SWRST_ADDR MT6356_PSC_TOP_RSTCTL_0
#define PMIC_BANK_PSEQ_SWRST_MASK 0x1
#define PMIC_BANK_PSEQ_SWRST_SHIFT 9
#define PMIC_BANK_PCHR_DIG_SWRST_ADDR MT6356_PSC_TOP_RSTCTL_0
#define PMIC_BANK_PCHR_DIG_SWRST_MASK 0x1
#define PMIC_BANK_PCHR_DIG_SWRST_SHIFT 10
#define PMIC_BANK_PCHR_MACRO_SWRST_ADDR MT6356_PSC_TOP_RSTCTL_0
#define PMIC_BANK_PCHR_MACRO_SWRST_MASK 0x1
#define PMIC_BANK_PCHR_MACRO_SWRST_SHIFT 11
#define PMIC_RG_INT_EN_PWRKEY_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_PWRKEY_MASK 0x1
#define PMIC_RG_INT_EN_PWRKEY_SHIFT 0
#define PMIC_RG_INT_EN_HOMEKEY_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_HOMEKEY_MASK 0x1
#define PMIC_RG_INT_EN_HOMEKEY_SHIFT 1
#define PMIC_RG_INT_EN_PWRKEY_R_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_PWRKEY_R_MASK 0x1
#define PMIC_RG_INT_EN_PWRKEY_R_SHIFT 2
#define PMIC_RG_INT_EN_HOMEKEY_R_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_HOMEKEY_R_MASK 0x1
#define PMIC_RG_INT_EN_HOMEKEY_R_SHIFT 3
#define PMIC_RG_INT_EN_NI_LBAT_INT_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_NI_LBAT_INT_MASK 0x1
#define PMIC_RG_INT_EN_NI_LBAT_INT_SHIFT 4
#define PMIC_RG_INT_EN_CHRDET_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_CHRDET_MASK 0x1
#define PMIC_RG_INT_EN_CHRDET_SHIFT 5
#define PMIC_RG_INT_EN_CHRDET_EDGE_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_CHRDET_EDGE_MASK 0x1
#define PMIC_RG_INT_EN_CHRDET_EDGE_SHIFT 6
#define PMIC_RG_INT_EN_VCDT_HV_DET_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_VCDT_HV_DET_MASK 0x1
#define PMIC_RG_INT_EN_VCDT_HV_DET_SHIFT 7
#define PMIC_RG_INT_EN_PCHR_CM_VINC_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_PCHR_CM_VINC_MASK 0x1
#define PMIC_RG_INT_EN_PCHR_CM_VINC_SHIFT 8
#define PMIC_RG_INT_EN_PCHR_CM_VDEC_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_PCHR_CM_VDEC_MASK 0x1
#define PMIC_RG_INT_EN_PCHR_CM_VDEC_SHIFT 9
#define PMIC_RG_INT_EN_WATCHDOG_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_WATCHDOG_MASK 0x1
#define PMIC_RG_INT_EN_WATCHDOG_SHIFT 10
#define PMIC_RG_INT_EN_VBATON_UNDET_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_VBATON_UNDET_MASK 0x1
#define PMIC_RG_INT_EN_VBATON_UNDET_SHIFT 11
#define PMIC_RG_INT_EN_BVALID_DET_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_BVALID_DET_MASK 0x1
#define PMIC_RG_INT_EN_BVALID_DET_SHIFT 12
#define PMIC_RG_INT_EN_OV_ADDR MT6356_PSC_TOP_INT_CON0
#define PMIC_RG_INT_EN_OV_MASK 0x1
#define PMIC_RG_INT_EN_OV_SHIFT 13
#define PMIC_PSC_INT_CON0_SET_ADDR MT6356_PSC_TOP_INT_CON0_SET
#define PMIC_PSC_INT_CON0_SET_MASK 0xFFFF
#define PMIC_PSC_INT_CON0_SET_SHIFT 0
#define PMIC_PSC_INT_CON0_CLR_ADDR MT6356_PSC_TOP_INT_CON0_CLR
#define PMIC_PSC_INT_CON0_CLR_MASK 0xFFFF
#define PMIC_PSC_INT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_PWRKEY_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_PWRKEY_MASK 0x1
#define PMIC_RG_INT_MASK_PWRKEY_SHIFT 0
#define PMIC_RG_INT_MASK_HOMEKEY_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_HOMEKEY_MASK 0x1
#define PMIC_RG_INT_MASK_HOMEKEY_SHIFT 1
#define PMIC_RG_INT_MASK_PWRKEY_R_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_PWRKEY_R_MASK 0x1
#define PMIC_RG_INT_MASK_PWRKEY_R_SHIFT 2
#define PMIC_RG_INT_MASK_HOMEKEY_R_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_HOMEKEY_R_MASK 0x1
#define PMIC_RG_INT_MASK_HOMEKEY_R_SHIFT 3
#define PMIC_RG_INT_MASK_NI_LBAT_INT_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_NI_LBAT_INT_MASK 0x1
#define PMIC_RG_INT_MASK_NI_LBAT_INT_SHIFT 4
#define PMIC_RG_INT_MASK_CHRDET_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_CHRDET_MASK 0x1
#define PMIC_RG_INT_MASK_CHRDET_SHIFT 5
#define PMIC_RG_INT_MASK_CHRDET_EDGE_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_CHRDET_EDGE_MASK 0x1
#define PMIC_RG_INT_MASK_CHRDET_EDGE_SHIFT 6
#define PMIC_RG_INT_MASK_VCDT_HV_DET_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VCDT_HV_DET_MASK 0x1
#define PMIC_RG_INT_MASK_VCDT_HV_DET_SHIFT 7
#define PMIC_RG_INT_MASK_PCHR_CM_VINC_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_PCHR_CM_VINC_MASK 0x1
#define PMIC_RG_INT_MASK_PCHR_CM_VINC_SHIFT 8
#define PMIC_RG_INT_MASK_PCHR_CM_VDEC_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_PCHR_CM_VDEC_MASK 0x1
#define PMIC_RG_INT_MASK_PCHR_CM_VDEC_SHIFT 9
#define PMIC_RG_INT_MASK_WATCHDOG_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_WATCHDOG_MASK 0x1
#define PMIC_RG_INT_MASK_WATCHDOG_SHIFT 10
#define PMIC_RG_INT_MASK_VBATON_UNDET_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VBATON_UNDET_MASK 0x1
#define PMIC_RG_INT_MASK_VBATON_UNDET_SHIFT 11
#define PMIC_RG_INT_MASK_BVALID_DET_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_BVALID_DET_MASK 0x1
#define PMIC_RG_INT_MASK_BVALID_DET_SHIFT 12
#define PMIC_RG_INT_MASK_OV_ADDR MT6356_PSC_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_OV_MASK 0x1
#define PMIC_RG_INT_MASK_OV_SHIFT 13
#define PMIC_PSC_INT_MASK_CON0_SET_ADDR MT6356_PSC_TOP_INT_MASK_CON0_SET
#define PMIC_PSC_INT_MASK_CON0_SET_MASK 0xFFFF
#define PMIC_PSC_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_PSC_INT_MASK_CON0_CLR_ADDR MT6356_PSC_TOP_INT_MASK_CON0_CLR
#define PMIC_PSC_INT_MASK_CON0_CLR_MASK 0xFFFF
#define PMIC_PSC_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_STATUS_PWRKEY_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_PWRKEY_MASK 0x1
#define PMIC_RG_INT_STATUS_PWRKEY_SHIFT 0
#define PMIC_RG_INT_STATUS_HOMEKEY_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_HOMEKEY_MASK 0x1
#define PMIC_RG_INT_STATUS_HOMEKEY_SHIFT 1
#define PMIC_RG_INT_STATUS_PWRKEY_R_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_PWRKEY_R_MASK 0x1
#define PMIC_RG_INT_STATUS_PWRKEY_R_SHIFT 2
#define PMIC_RG_INT_STATUS_HOMEKEY_R_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_HOMEKEY_R_MASK 0x1
#define PMIC_RG_INT_STATUS_HOMEKEY_R_SHIFT 3
#define PMIC_RG_INT_STATUS_NI_LBAT_INT_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_NI_LBAT_INT_MASK 0x1
#define PMIC_RG_INT_STATUS_NI_LBAT_INT_SHIFT 4
#define PMIC_RG_INT_STATUS_CHRDET_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_CHRDET_MASK 0x1
#define PMIC_RG_INT_STATUS_CHRDET_SHIFT 5
#define PMIC_RG_INT_STATUS_CHRDET_EDGE_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_CHRDET_EDGE_MASK 0x1
#define PMIC_RG_INT_STATUS_CHRDET_EDGE_SHIFT 6
#define PMIC_RG_INT_STATUS_VCDT_HV_DET_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VCDT_HV_DET_MASK 0x1
#define PMIC_RG_INT_STATUS_VCDT_HV_DET_SHIFT 7
#define PMIC_RG_INT_STATUS_PCHR_CM_VINC_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_PCHR_CM_VINC_MASK 0x1
#define PMIC_RG_INT_STATUS_PCHR_CM_VINC_SHIFT 8
#define PMIC_RG_INT_STATUS_PCHR_CM_VDEC_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_PCHR_CM_VDEC_MASK 0x1
#define PMIC_RG_INT_STATUS_PCHR_CM_VDEC_SHIFT 9
#define PMIC_RG_INT_STATUS_WATCHDOG_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_WATCHDOG_MASK 0x1
#define PMIC_RG_INT_STATUS_WATCHDOG_SHIFT 10
#define PMIC_RG_INT_STATUS_VBATON_UNDET_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VBATON_UNDET_MASK 0x1
#define PMIC_RG_INT_STATUS_VBATON_UNDET_SHIFT 11
#define PMIC_RG_INT_STATUS_BVALID_DET_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_BVALID_DET_MASK 0x1
#define PMIC_RG_INT_STATUS_BVALID_DET_SHIFT 12
#define PMIC_RG_INT_STATUS_OV_ADDR MT6356_PSC_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_OV_MASK 0x1
#define PMIC_RG_INT_STATUS_OV_SHIFT 13
#define PMIC_RG_INT_RAW_STATUS_PWRKEY_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_PWRKEY_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_PWRKEY_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_HOMEKEY_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_HOMEKEY_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_HOMEKEY_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_PWRKEY_R_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_PWRKEY_R_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_PWRKEY_R_SHIFT 2
#define PMIC_RG_INT_RAW_STATUS_HOMEKEY_R_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_HOMEKEY_R_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_HOMEKEY_R_SHIFT 3
#define PMIC_RG_INT_RAW_STATUS_NI_LBAT_INT_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_NI_LBAT_INT_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_NI_LBAT_INT_SHIFT 4
#define PMIC_RG_INT_RAW_STATUS_CHRDET_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_CHRDET_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_CHRDET_SHIFT 5
#define PMIC_RG_INT_RAW_STATUS_CHRDET_EDGE_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_CHRDET_EDGE_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_CHRDET_EDGE_SHIFT 6
#define PMIC_RG_INT_RAW_STATUS_VCDT_HV_DET_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VCDT_HV_DET_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VCDT_HV_DET_SHIFT 7
#define PMIC_RG_INT_RAW_STATUS_PCHR_CM_VINC_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_PCHR_CM_VINC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_PCHR_CM_VINC_SHIFT 8
#define PMIC_RG_INT_RAW_STATUS_PCHR_CM_VDEC_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_PCHR_CM_VDEC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_PCHR_CM_VDEC_SHIFT 9
#define PMIC_RG_INT_RAW_STATUS_WATCHDOG_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_WATCHDOG_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_WATCHDOG_SHIFT 10
#define PMIC_RG_INT_RAW_STATUS_VBATON_UNDET_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VBATON_UNDET_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VBATON_UNDET_SHIFT 11
#define PMIC_RG_INT_RAW_STATUS_BVALID_DET_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_BVALID_DET_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BVALID_DET_SHIFT 12
#define PMIC_RG_INT_RAW_STATUS_OV_ADDR MT6356_PSC_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_OV_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_OV_SHIFT 13
#define PMIC_RG_PSC_INT_POLARITY_ADDR MT6356_PSC_TOP_INT_MISC_CON
#define PMIC_RG_PSC_INT_POLARITY_MASK 0x1
#define PMIC_RG_PSC_INT_POLARITY_SHIFT 0
#define PMIC_RG_HOMEKEY_INT_SEL_ADDR MT6356_PSC_TOP_INT_MISC_CON
#define PMIC_RG_HOMEKEY_INT_SEL_MASK 0x1
#define PMIC_RG_HOMEKEY_INT_SEL_SHIFT 1
#define PMIC_RG_PWRKEY_INT_SEL_ADDR MT6356_PSC_TOP_INT_MISC_CON
#define PMIC_RG_PWRKEY_INT_SEL_MASK 0x1
#define PMIC_RG_PWRKEY_INT_SEL_SHIFT 2
#define PMIC_RG_CHRDET_INT_SEL_ADDR MT6356_PSC_TOP_INT_MISC_CON
#define PMIC_RG_CHRDET_INT_SEL_MASK 0x1
#define PMIC_RG_CHRDET_INT_SEL_SHIFT 3
#define PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_ADDR MT6356_PSC_TOP_INT_MISC_CON
#define PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_MASK 0x1
#define PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_SHIFT 4
#define PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_ADDR MT6356_PSC_TOP_INT_MISC_CON
#define PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_MASK 0x1
#define PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_SHIFT 5
#define PMIC_INT_MISC_CON_SET_ADDR MT6356_PSC_TOP_INT_MISC_CON_SET
#define PMIC_INT_MISC_CON_SET_MASK 0xFFFF
#define PMIC_INT_MISC_CON_SET_SHIFT 0
#define PMIC_INT_MISC_CON_CLR_ADDR MT6356_PSC_TOP_INT_MISC_CON_CLR
#define PMIC_INT_MISC_CON_CLR_MASK 0xFFFF
#define PMIC_INT_MISC_CON_CLR_SHIFT 0
#define PMIC_RG_PSC_MON_GRP_SEL_ADDR MT6356_PSC_TOP_MON_CTL
#define PMIC_RG_PSC_MON_GRP_SEL_MASK 0x7
#define PMIC_RG_PSC_MON_GRP_SEL_SHIFT 0
#define PMIC_STRUP_ANA_ID_ADDR MT6356_STRUP_ID
#define PMIC_STRUP_ANA_ID_MASK 0xFF
#define PMIC_STRUP_ANA_ID_SHIFT 0
#define PMIC_STRUP_DIG_ID_ADDR MT6356_STRUP_ID
#define PMIC_STRUP_DIG_ID_MASK 0xFF
#define PMIC_STRUP_DIG_ID_SHIFT 8
#define PMIC_STRUP_ANA_MINOR_REV_ADDR MT6356_STRUP_REV0
#define PMIC_STRUP_ANA_MINOR_REV_MASK 0xF
#define PMIC_STRUP_ANA_MINOR_REV_SHIFT 0
#define PMIC_STRUP_ANA_MAJOR_REV_ADDR MT6356_STRUP_REV0
#define PMIC_STRUP_ANA_MAJOR_REV_MASK 0xF
#define PMIC_STRUP_ANA_MAJOR_REV_SHIFT 4
#define PMIC_STRUP_DIG_MINOR_REV_ADDR MT6356_STRUP_REV0
#define PMIC_STRUP_DIG_MINOR_REV_MASK 0xF
#define PMIC_STRUP_DIG_MINOR_REV_SHIFT 8
#define PMIC_STRUP_DIG_MAJOR_REV_ADDR MT6356_STRUP_REV0
#define PMIC_STRUP_DIG_MAJOR_REV_MASK 0xF
#define PMIC_STRUP_DIG_MAJOR_REV_SHIFT 12
#define PMIC_STRUP_SW_MINOR_REV_ADDR MT6356_STRUP_REV1
#define PMIC_STRUP_SW_MINOR_REV_MASK 0xF
#define PMIC_STRUP_SW_MINOR_REV_SHIFT 0
#define PMIC_STRUP_SW_MAJOR_REV_ADDR MT6356_STRUP_REV1
#define PMIC_STRUP_SW_MAJOR_REV_MASK 0xF
#define PMIC_STRUP_SW_MAJOR_REV_SHIFT 4
#define PMIC_STRUP_ESP_ADDR MT6356_STRUP_REV1
#define PMIC_STRUP_ESP_MASK 0xFF
#define PMIC_STRUP_ESP_SHIFT 8
#define PMIC_RG_TM_OUT_ADDR MT6356_STRUP_ANA_CON0
#define PMIC_RG_TM_OUT_MASK 0xF
#define PMIC_RG_TM_OUT_SHIFT 0
#define PMIC_RG_THRDET_SEL_ADDR MT6356_STRUP_ANA_CON0
#define PMIC_RG_THRDET_SEL_MASK 0x1
#define PMIC_RG_THRDET_SEL_SHIFT 8
#define PMIC_RG_STRUP_THR_SEL_ADDR MT6356_STRUP_ANA_CON0
#define PMIC_RG_STRUP_THR_SEL_MASK 0x3
#define PMIC_RG_STRUP_THR_SEL_SHIFT 9
#define PMIC_RG_THR_TMODE_ADDR MT6356_STRUP_ANA_CON0
#define PMIC_RG_THR_TMODE_MASK 0x1
#define PMIC_RG_THR_TMODE_SHIFT 11
#define PMIC_RG_VREF_BG_ADDR MT6356_STRUP_ANA_CON0
#define PMIC_RG_VREF_BG_MASK 0x7
#define PMIC_RG_VREF_BG_SHIFT 12
#define PMIC_RG_RST_DRVSEL_ADDR MT6356_STRUP_ANA_CON1
#define PMIC_RG_RST_DRVSEL_MASK 0x1
#define PMIC_RG_RST_DRVSEL_SHIFT 6
#define PMIC_RG_EN1_DRVSEL_ADDR MT6356_STRUP_ANA_CON1
#define PMIC_RG_EN1_DRVSEL_MASK 0x1
#define PMIC_RG_EN1_DRVSEL_SHIFT 7
#define PMIC_RG_EN2_DRVSEL_ADDR MT6356_STRUP_ANA_CON1
#define PMIC_RG_EN2_DRVSEL_MASK 0x1
#define PMIC_RG_EN2_DRVSEL_SHIFT 8
#define PMIC_RG_PMU_RSV_ADDR MT6356_STRUP_ANA_CON1
#define PMIC_RG_PMU_RSV_MASK 0xF
#define PMIC_RG_PMU_RSV_SHIFT 9
#define PMIC_RGS_ANA_CHIP_ID_ADDR MT6356_STRUP_ANA_CON1
#define PMIC_RGS_ANA_CHIP_ID_MASK 0x7
#define PMIC_RGS_ANA_CHIP_ID_SHIFT 13
#define PMIC_RG_FCHR_PU_EN_ADDR MT6356_STRUP_ANA_CON2
#define PMIC_RG_FCHR_PU_EN_MASK 0x1
#define PMIC_RG_FCHR_PU_EN_SHIFT 0
#define PMIC_RG_FCHR_KEYDET_EN_ADDR MT6356_STRUP_ANA_CON2
#define PMIC_RG_FCHR_KEYDET_EN_MASK 0x1
#define PMIC_RG_FCHR_KEYDET_EN_SHIFT 1
#define PMIC_STRUP_ELR_LEN_ADDR MT6356_STRUP_ELR_NUM
#define PMIC_STRUP_ELR_LEN_MASK 0xFF
#define PMIC_STRUP_ELR_LEN_SHIFT 0
#define PMIC_RG_STRUP_IREF_TRIM_ADDR MT6356_STRUP_ELR_0
#define PMIC_RG_STRUP_IREF_TRIM_MASK 0x3F
#define PMIC_RG_STRUP_IREF_TRIM_SHIFT 0
#define PMIC_RG_THR_LOC_SEL_ADDR MT6356_STRUP_ELR_0
#define PMIC_RG_THR_LOC_SEL_MASK 0xF
#define PMIC_RG_THR_LOC_SEL_SHIFT 6
#define PMIC_PSEQ_ANA_ID_ADDR MT6356_PSEQ_ID
#define PMIC_PSEQ_ANA_ID_MASK 0xFF
#define PMIC_PSEQ_ANA_ID_SHIFT 0
#define PMIC_PSEQ_DIG_ID_ADDR MT6356_PSEQ_ID
#define PMIC_PSEQ_DIG_ID_MASK 0xFF
#define PMIC_PSEQ_DIG_ID_SHIFT 8
#define PMIC_PSEQ_ANA_MINOR_REV_ADDR MT6356_PSEQ_REV0
#define PMIC_PSEQ_ANA_MINOR_REV_MASK 0xF
#define PMIC_PSEQ_ANA_MINOR_REV_SHIFT 0
#define PMIC_PSEQ_ANA_MAJOR_REV_ADDR MT6356_PSEQ_REV0
#define PMIC_PSEQ_ANA_MAJOR_REV_MASK 0xF
#define PMIC_PSEQ_ANA_MAJOR_REV_SHIFT 4
#define PMIC_PSEQ_DIG_MINOR_REV_ADDR MT6356_PSEQ_REV0
#define PMIC_PSEQ_DIG_MINOR_REV_MASK 0xF
#define PMIC_PSEQ_DIG_MINOR_REV_SHIFT 8
#define PMIC_PSEQ_DIG_MAJOR_REV_ADDR MT6356_PSEQ_REV0
#define PMIC_PSEQ_DIG_MAJOR_REV_MASK 0xF
#define PMIC_PSEQ_DIG_MAJOR_REV_SHIFT 12
#define PMIC_PSEQ_SW_MINOR_REV_ADDR MT6356_PSEQ_REV1
#define PMIC_PSEQ_SW_MINOR_REV_MASK 0xF
#define PMIC_PSEQ_SW_MINOR_REV_SHIFT 0
#define PMIC_PSEQ_SW_MAJOR_REV_ADDR MT6356_PSEQ_REV1
#define PMIC_PSEQ_SW_MAJOR_REV_MASK 0xF
#define PMIC_PSEQ_SW_MAJOR_REV_SHIFT 4
#define PMIC_PSEQ_ESP_ADDR MT6356_PSEQ_REV1
#define PMIC_PSEQ_ESP_MASK 0xFF
#define PMIC_PSEQ_ESP_SHIFT 8
#define PMIC_RG_PWRHOLD_ADDR MT6356_PPCCTL0
#define PMIC_RG_PWRHOLD_MASK 0x1
#define PMIC_RG_PWRHOLD_SHIFT 0
#define PMIC_RG_USBDL_MODE_ADDR MT6356_PPCCTL0
#define PMIC_RG_USBDL_MODE_MASK 0x1
#define PMIC_RG_USBDL_MODE_SHIFT 4
#define PMIC_RG_CRST_ADDR MT6356_PPCCTL0
#define PMIC_RG_CRST_MASK 0x1
#define PMIC_RG_CRST_SHIFT 8
#define PMIC_RG_WRST_ADDR MT6356_PPCCTL0
#define PMIC_RG_WRST_MASK 0x1
#define PMIC_RG_WRST_SHIFT 9
#define PMIC_RG_RSTB_ONINTV_ADDR MT6356_PPCCTL1
#define PMIC_RG_RSTB_ONINTV_MASK 0x3
#define PMIC_RG_RSTB_ONINTV_SHIFT 0
#define PMIC_RG_CRST_INTV_ADDR MT6356_PPCCTL1
#define PMIC_RG_CRST_INTV_MASK 0x3
#define PMIC_RG_CRST_INTV_SHIFT 8
#define PMIC_RG_WRST_INTV_ADDR MT6356_PPCCTL1
#define PMIC_RG_WRST_INTV_MASK 0x3
#define PMIC_RG_WRST_INTV_SHIFT 10
#define PMIC_RG_PSEQ_PG_CK_SEL_ADDR MT6356_PPCCTL2
#define PMIC_RG_PSEQ_PG_CK_SEL_MASK 0x1
#define PMIC_RG_PSEQ_PG_CK_SEL_SHIFT 0
#define PMIC_RG_PSEQ_SPAR_XCPT_MASK_ADDR MT6356_PPCCTL2
#define PMIC_RG_PSEQ_SPAR_XCPT_MASK_MASK 0x1
#define PMIC_RG_PSEQ_SPAR_XCPT_MASK_SHIFT 4
#define PMIC_RG_PSEQ_RTCA_XCPT_MASK_ADDR MT6356_PPCCTL2
#define PMIC_RG_PSEQ_RTCA_XCPT_MASK_MASK 0x1
#define PMIC_RG_PSEQ_RTCA_XCPT_MASK_SHIFT 5
#define PMIC_RG_THM_SHDN_EN_ADDR MT6356_PPCCTL2
#define PMIC_RG_THM_SHDN_EN_MASK 0x1
#define PMIC_RG_THM_SHDN_EN_SHIFT 8
#define PMIC_RG_WDTRST_EN_ADDR MT6356_PPCCFG0
#define PMIC_RG_WDTRST_EN_MASK 0x1
#define PMIC_RG_WDTRST_EN_SHIFT 0
#define PMIC_RG_WDTRST_ACT_ADDR MT6356_PPCCFG0
#define PMIC_RG_WDTRST_ACT_MASK 0x3
#define PMIC_RG_WDTRST_ACT_SHIFT 4
#define PMIC_RG_KEYPWR_VCORE_OPT_ADDR MT6356_PPCCFG0
#define PMIC_RG_KEYPWR_VCORE_OPT_MASK 0x1
#define PMIC_RG_KEYPWR_VCORE_OPT_SHIFT 8
#define PMIC_RG_PSEQ_FORCE_ON_ADDR MT6356_PPCTST0
#define PMIC_RG_PSEQ_FORCE_ON_MASK 0x1
#define PMIC_RG_PSEQ_FORCE_ON_SHIFT 0
#define PMIC_RG_PSEQ_FORCE_ALL_DOFF_ADDR MT6356_PPCTST0
#define PMIC_RG_PSEQ_FORCE_ALL_DOFF_MASK 0x1
#define PMIC_RG_PSEQ_FORCE_ALL_DOFF_SHIFT 8
#define PMIC_RG_PSEQ_RSV0_ADDR MT6356_PPCRSV0
#define PMIC_RG_PSEQ_RSV0_MASK 0xFF
#define PMIC_RG_PSEQ_RSV0_SHIFT 0
#define PMIC_RG_PSEQ_RSV1_ADDR MT6356_PPCRSV0
#define PMIC_RG_PSEQ_RSV1_MASK 0xF
#define PMIC_RG_PSEQ_RSV1_SHIFT 8
#define PMIC_RG_PSEQ_RSV2_ADDR MT6356_PPCRSV0
#define PMIC_RG_PSEQ_RSV2_MASK 0xF
#define PMIC_RG_PSEQ_RSV2_SHIFT 12
#define PMIC_RG_CPS_W_KEY_ADDR MT6356_CPSWKEY
#define PMIC_RG_CPS_W_KEY_MASK 0xFFFF
#define PMIC_RG_CPS_W_KEY_SHIFT 0
#define PMIC_RG_SLOT_INTV_DOWN_ADDR MT6356_CPSCFG0
#define PMIC_RG_SLOT_INTV_DOWN_MASK 0x3
#define PMIC_RG_SLOT_INTV_DOWN_SHIFT 0
#define PMIC_RG_DSEQ_LEN_ADDR MT6356_CPSCFG0
#define PMIC_RG_DSEQ_LEN_MASK 0x1F
#define PMIC_RG_DSEQ_LEN_SHIFT 8
#define PMIC_RG_VAUX18_DSA_ADDR MT6356_CPSDSA0
#define PMIC_RG_VAUX18_DSA_MASK 0x1F
#define PMIC_RG_VAUX18_DSA_SHIFT 0
#define PMIC_RG_VS2_DSA_ADDR MT6356_CPSDSA0
#define PMIC_RG_VS2_DSA_MASK 0x1F
#define PMIC_RG_VS2_DSA_SHIFT 8
#define PMIC_RG_VSRAM_OTHERS_DSA_ADDR MT6356_CPSDSA1
#define PMIC_RG_VSRAM_OTHERS_DSA_MASK 0x1F
#define PMIC_RG_VSRAM_OTHERS_DSA_SHIFT 0
#define PMIC_RG_VSRAM_GPU_DSA_ADDR MT6356_CPSDSA1
#define PMIC_RG_VSRAM_GPU_DSA_MASK 0x1F
#define PMIC_RG_VSRAM_GPU_DSA_SHIFT 8
#define PMIC_RG_VCORE_DSA_ADDR MT6356_CPSDSA2
#define PMIC_RG_VCORE_DSA_MASK 0x1F
#define PMIC_RG_VCORE_DSA_SHIFT 0
#define PMIC_RG_VMODEM_DSA_ADDR MT6356_CPSDSA2
#define PMIC_RG_VMODEM_DSA_MASK 0x1F
#define PMIC_RG_VMODEM_DSA_SHIFT 8
#define PMIC_RG_VS1_DSA_ADDR MT6356_CPSDSA3
#define PMIC_RG_VS1_DSA_MASK 0x1F
#define PMIC_RG_VS1_DSA_SHIFT 0
#define PMIC_RG_VA12_DSA_ADDR MT6356_CPSDSA3
#define PMIC_RG_VA12_DSA_MASK 0x1F
#define PMIC_RG_VA12_DSA_SHIFT 8
#define PMIC_RG_VSRAM_PROC_DSA_ADDR MT6356_CPSDSA4
#define PMIC_RG_VSRAM_PROC_DSA_MASK 0x1F
#define PMIC_RG_VSRAM_PROC_DSA_SHIFT 0
#define PMIC_RG_VPROC_DSA_ADDR MT6356_CPSDSA4
#define PMIC_RG_VPROC_DSA_MASK 0x1F
#define PMIC_RG_VPROC_DSA_SHIFT 8
#define PMIC_RG_VIO18_DSA_ADDR MT6356_CPSDSA5
#define PMIC_RG_VIO18_DSA_MASK 0x1F
#define PMIC_RG_VIO18_DSA_SHIFT 0
#define PMIC_RG_VEMC_DSA_ADDR MT6356_CPSDSA5
#define PMIC_RG_VEMC_DSA_MASK 0x1F
#define PMIC_RG_VEMC_DSA_SHIFT 8
#define PMIC_RG_EXT_PMIC_1_DSA_ADDR MT6356_CPSDSA6
#define PMIC_RG_EXT_PMIC_1_DSA_MASK 0x1F
#define PMIC_RG_EXT_PMIC_1_DSA_SHIFT 0
#define PMIC_RG_VIO28_DSA_ADDR MT6356_CPSDSA6
#define PMIC_RG_VIO28_DSA_MASK 0x1F
#define PMIC_RG_VIO28_DSA_SHIFT 8
#define PMIC_RG_VDRAM_DSA_ADDR MT6356_CPSDSA7
#define PMIC_RG_VDRAM_DSA_MASK 0x1F
#define PMIC_RG_VDRAM_DSA_SHIFT 0
#define PMIC_RG_EXT_PMIC_2_DSA_ADDR MT6356_CPSDSA7
#define PMIC_RG_EXT_PMIC_2_DSA_MASK 0x1F
#define PMIC_RG_EXT_PMIC_2_DSA_SHIFT 8
#define PMIC_RG_VUSB_DSA_ADDR MT6356_CPSDSA8
#define PMIC_RG_VUSB_DSA_MASK 0x1F
#define PMIC_RG_VUSB_DSA_SHIFT 0
#define PMIC_RG_VAUD28_DSA_ADDR MT6356_CPSDSA8
#define PMIC_RG_VAUD28_DSA_MASK 0x1F
#define PMIC_RG_VAUD28_DSA_SHIFT 8
#define PMIC_RG_VXO22_DSA_ADDR MT6356_CPSDSA9
#define PMIC_RG_VXO22_DSA_MASK 0x1F
#define PMIC_RG_VXO22_DSA_SHIFT 0
#define PMIC_RG_BUCK_RSV_DSA_ADDR MT6356_CPSDSA9
#define PMIC_RG_BUCK_RSV_DSA_MASK 0x1F
#define PMIC_RG_BUCK_RSV_DSA_SHIFT 8
#define PMIC_RG_POR_FLAG_ADDR MT6356_PORFLAG
#define PMIC_RG_POR_FLAG_MASK 0x1
#define PMIC_RG_POR_FLAG_SHIFT 0
#define PMIC_USBDL_ADDR MT6356_STRUP_CON0
#define PMIC_USBDL_MASK 0x1
#define PMIC_USBDL_SHIFT 0
#define PMIC_RG_THR_DET_DIS_ADDR MT6356_STRUP_CON0
#define PMIC_RG_THR_DET_DIS_MASK 0x1
#define PMIC_RG_THR_DET_DIS_SHIFT 12
#define PMIC_RG_THR_TEST_ADDR MT6356_STRUP_CON0
#define PMIC_RG_THR_TEST_MASK 0x3
#define PMIC_RG_THR_TEST_SHIFT 13
#define PMIC_RG_STRUP_THER_DEB_RMAX_ADDR MT6356_STRUP_CON1
#define PMIC_RG_STRUP_THER_DEB_RMAX_MASK 0xFFFF
#define PMIC_RG_STRUP_THER_DEB_RMAX_SHIFT 0
#define PMIC_RG_STRUP_THER_DEB_FMAX_ADDR MT6356_STRUP_CON2
#define PMIC_RG_STRUP_THER_DEB_FMAX_MASK 0xFFFF
#define PMIC_RG_STRUP_THER_DEB_FMAX_SHIFT 0
#define PMIC_DDUVLO_DEB_EN_ADDR MT6356_STRUP_CON3
#define PMIC_DDUVLO_DEB_EN_MASK 0x1
#define PMIC_DDUVLO_DEB_EN_SHIFT 0
#define PMIC_RG_STRUP_OSC_EN_ADDR MT6356_STRUP_CON3
#define PMIC_RG_STRUP_OSC_EN_MASK 0x1
#define PMIC_RG_STRUP_OSC_EN_SHIFT 2
#define PMIC_RG_STRUP_OSC_EN_SEL_ADDR MT6356_STRUP_CON3
#define PMIC_RG_STRUP_OSC_EN_SEL_MASK 0x1
#define PMIC_RG_STRUP_OSC_EN_SEL_SHIFT 3
#define PMIC_RG_STRUP_FT_CTRL_ADDR MT6356_STRUP_CON3
#define PMIC_RG_STRUP_FT_CTRL_MASK 0x3
#define PMIC_RG_STRUP_FT_CTRL_SHIFT 4
#define PMIC_RG_STRUP_PWRON_FORCE_ADDR MT6356_STRUP_CON3
#define PMIC_RG_STRUP_PWRON_FORCE_MASK 0x1
#define PMIC_RG_STRUP_PWRON_FORCE_SHIFT 6
#define PMIC_RG_BIASGEN_FORCE_ADDR MT6356_STRUP_CON3
#define PMIC_RG_BIASGEN_FORCE_MASK 0x1
#define PMIC_RG_BIASGEN_FORCE_SHIFT 7
#define PMIC_RG_STRUP_PWRON_ADDR MT6356_STRUP_CON3
#define PMIC_RG_STRUP_PWRON_MASK 0x1
#define PMIC_RG_STRUP_PWRON_SHIFT 8
#define PMIC_RG_STRUP_PWRON_SEL_ADDR MT6356_STRUP_CON3
#define PMIC_RG_STRUP_PWRON_SEL_MASK 0x1
#define PMIC_RG_STRUP_PWRON_SEL_SHIFT 9
#define PMIC_RG_BIASGEN_ADDR MT6356_STRUP_CON3
#define PMIC_RG_BIASGEN_MASK 0x1
#define PMIC_RG_BIASGEN_SHIFT 10
#define PMIC_RG_BIASGEN_SEL_ADDR MT6356_STRUP_CON3
#define PMIC_RG_BIASGEN_SEL_MASK 0x1
#define PMIC_RG_BIASGEN_SEL_SHIFT 11
#define PMIC_RG_RTC_XOSC32_ENB_ADDR MT6356_STRUP_CON3
#define PMIC_RG_RTC_XOSC32_ENB_MASK 0x1
#define PMIC_RG_RTC_XOSC32_ENB_SHIFT 12
#define PMIC_RG_RTC_XOSC32_ENB_SEL_ADDR MT6356_STRUP_CON3
#define PMIC_RG_RTC_XOSC32_ENB_SEL_MASK 0x1
#define PMIC_RG_RTC_XOSC32_ENB_SEL_SHIFT 13
#define PMIC_STRUP_DIG_IO_PG_FORCE_ADDR MT6356_STRUP_CON3
#define PMIC_STRUP_DIG_IO_PG_FORCE_MASK 0x1
#define PMIC_STRUP_DIG_IO_PG_FORCE_SHIFT 15
#define PMIC_RG_CLR_JUST_SMART_RST_ADDR MT6356_STRUP_CON4
#define PMIC_RG_CLR_JUST_SMART_RST_MASK 0x1
#define PMIC_RG_CLR_JUST_SMART_RST_SHIFT 3
#define PMIC_CLR_JUST_RST_ADDR MT6356_STRUP_CON4
#define PMIC_CLR_JUST_RST_MASK 0x1
#define PMIC_CLR_JUST_RST_SHIFT 4
#define PMIC_JUST_SMART_RST_ADDR MT6356_STRUP_CON4
#define PMIC_JUST_SMART_RST_MASK 0x1
#define PMIC_JUST_SMART_RST_SHIFT 13
#define PMIC_JUST_PWRKEY_RST_ADDR MT6356_STRUP_CON4
#define PMIC_JUST_PWRKEY_RST_MASK 0x1
#define PMIC_JUST_PWRKEY_RST_SHIFT 14
#define PMIC_DA_QI_OSC_EN_ADDR MT6356_STRUP_CON4
#define PMIC_DA_QI_OSC_EN_MASK 0x1
#define PMIC_DA_QI_OSC_EN_SHIFT 15
#define PMIC_RG_STRUP_EXT_PMIC_EN_ADDR MT6356_STRUP_CON5
#define PMIC_RG_STRUP_EXT_PMIC_EN_MASK 0x3
#define PMIC_RG_STRUP_EXT_PMIC_EN_SHIFT 0
#define PMIC_RG_STRUP_EXT_PMIC_SEL_ADDR MT6356_STRUP_CON5
#define PMIC_RG_STRUP_EXT_PMIC_SEL_MASK 0x3
#define PMIC_RG_STRUP_EXT_PMIC_SEL_SHIFT 4
#define PMIC_DA_EXT_PMIC_EN1_ADDR MT6356_STRUP_CON5
#define PMIC_DA_EXT_PMIC_EN1_MASK 0x1
#define PMIC_DA_EXT_PMIC_EN1_SHIFT 8
#define PMIC_DA_EXT_PMIC_EN2_ADDR MT6356_STRUP_CON5
#define PMIC_DA_EXT_PMIC_EN2_MASK 0x1
#define PMIC_DA_EXT_PMIC_EN2_SHIFT 9
#define PMIC_STRUP_CON5_RSV0_ADDR MT6356_STRUP_CON5
#define PMIC_STRUP_CON5_RSV0_MASK 0x3F
#define PMIC_STRUP_CON5_RSV0_SHIFT 10
#define PMIC_RG_STRUP_AUXADC_START_SW_ADDR MT6356_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_START_SW_MASK 0x1
#define PMIC_RG_STRUP_AUXADC_START_SW_SHIFT 0
#define PMIC_RG_STRUP_AUXADC_RSTB_SW_ADDR MT6356_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_RSTB_SW_MASK 0x1
#define PMIC_RG_STRUP_AUXADC_RSTB_SW_SHIFT 1
#define PMIC_RG_STRUP_AUXADC_START_SEL_ADDR MT6356_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_START_SEL_MASK 0x1
#define PMIC_RG_STRUP_AUXADC_START_SEL_SHIFT 2
#define PMIC_RG_STRUP_AUXADC_RSTB_SEL_ADDR MT6356_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_RSTB_SEL_MASK 0x1
#define PMIC_RG_STRUP_AUXADC_RSTB_SEL_SHIFT 3
#define PMIC_RG_STRUP_AUXADC_RPCNT_MAX_ADDR MT6356_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_RPCNT_MAX_MASK 0x7F
#define PMIC_RG_STRUP_AUXADC_RPCNT_MAX_SHIFT 4
#define PMIC_STRUP_PWROFF_SEQ_EN_ADDR MT6356_STRUP_CON7
#define PMIC_STRUP_PWROFF_SEQ_EN_MASK 0x1
#define PMIC_STRUP_PWROFF_SEQ_EN_SHIFT 0
#define PMIC_STRUP_PWROFF_PREOFF_EN_ADDR MT6356_STRUP_CON7
#define PMIC_STRUP_PWROFF_PREOFF_EN_MASK 0x1
#define PMIC_STRUP_PWROFF_PREOFF_EN_SHIFT 1
#define PMIC_STRUP_DIG0_RSV0_ADDR MT6356_STRUP_CON8
#define PMIC_STRUP_DIG0_RSV0_MASK 0xF
#define PMIC_STRUP_DIG0_RSV0_SHIFT 2
#define PMIC_STRUP_DIG1_RSV0_ADDR MT6356_STRUP_CON8
#define PMIC_STRUP_DIG1_RSV0_MASK 0x1F
#define PMIC_STRUP_DIG1_RSV0_SHIFT 6
#define PMIC_RG_RSV_SWREG_ADDR MT6356_STRUP_CON9
#define PMIC_RG_RSV_SWREG_MASK 0xFFFF
#define PMIC_RG_RSV_SWREG_SHIFT 0
#define PMIC_RG_STRUP_UVLO_U1U2_SEL_ADDR MT6356_STRUP_CON10
#define PMIC_RG_STRUP_UVLO_U1U2_SEL_MASK 0x1
#define PMIC_RG_STRUP_UVLO_U1U2_SEL_SHIFT 0
#define PMIC_RG_STRUP_UVLO_U1U2_SEL_SWCTRL_ADDR MT6356_STRUP_CON10
#define PMIC_RG_STRUP_UVLO_U1U2_SEL_SWCTRL_MASK 0x1
#define PMIC_RG_STRUP_UVLO_U1U2_SEL_SWCTRL_SHIFT 1
#define PMIC_RG_STRUP_THR_CLR_ADDR MT6356_STRUP_CON11
#define PMIC_RG_STRUP_THR_CLR_MASK 0x1
#define PMIC_RG_STRUP_THR_CLR_SHIFT 0
#define PMIC_RG_STRUP_LONG_PRESS_EXT_SEL_ADDR MT6356_STRUP_CON12
#define PMIC_RG_STRUP_LONG_PRESS_EXT_SEL_MASK 0x3
#define PMIC_RG_STRUP_LONG_PRESS_EXT_SEL_SHIFT 0
#define PMIC_RG_STRUP_LONG_PRESS_EXT_TD_ADDR MT6356_STRUP_CON12
#define PMIC_RG_STRUP_LONG_PRESS_EXT_TD_MASK 0x3
#define PMIC_RG_STRUP_LONG_PRESS_EXT_TD_SHIFT 2
#define PMIC_RG_STRUP_LONG_PRESS_EXT_EN_ADDR MT6356_STRUP_CON12
#define PMIC_RG_STRUP_LONG_PRESS_EXT_EN_MASK 0x1
#define PMIC_RG_STRUP_LONG_PRESS_EXT_EN_SHIFT 4
#define PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL_ADDR MT6356_STRUP_CON12
#define PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL_MASK 0x1
#define PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL_SHIFT 5
#define PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKEY_CTRL_ADDR MT6356_STRUP_CON12
#define PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKEY_CTRL_MASK 0x1
#define PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKEY_CTRL_SHIFT 6
#define PMIC_RG_STRUP_LONG_PRESS_EXT_SPAR_CTRL_ADDR MT6356_STRUP_CON12
#define PMIC_RG_STRUP_LONG_PRESS_EXT_SPAR_CTRL_MASK 0x1
#define PMIC_RG_STRUP_LONG_PRESS_EXT_SPAR_CTRL_SHIFT 7
#define PMIC_RG_STRUP_LONG_PRESS_EXT_RTCA_CTRL_ADDR MT6356_STRUP_CON12
#define PMIC_RG_STRUP_LONG_PRESS_EXT_RTCA_CTRL_MASK 0x1
#define PMIC_RG_STRUP_LONG_PRESS_EXT_RTCA_CTRL_SHIFT 8
#define PMIC_RG_SMART_RST_SDN_EN_ADDR MT6356_STRUP_CON12
#define PMIC_RG_SMART_RST_SDN_EN_MASK 0x1
#define PMIC_RG_SMART_RST_SDN_EN_SHIFT 12
#define PMIC_RG_SMART_RST_MODE_ADDR MT6356_STRUP_CON12
#define PMIC_RG_SMART_RST_MODE_MASK 0x1
#define PMIC_RG_SMART_RST_MODE_SHIFT 13
#define PMIC_RG_STRUP_ENVTEM_ADDR MT6356_STRUP_CON12
#define PMIC_RG_STRUP_ENVTEM_MASK 0x1
#define PMIC_RG_STRUP_ENVTEM_SHIFT 14
#define PMIC_RG_STRUP_ENVTEM_CTRL_ADDR MT6356_STRUP_CON12
#define PMIC_RG_STRUP_ENVTEM_CTRL_MASK 0x1
#define PMIC_RG_STRUP_ENVTEM_CTRL_SHIFT 15
#define PMIC_RG_STRUP_PWRKEY_COUNT_RESET_ADDR MT6356_STRUP_CON13
#define PMIC_RG_STRUP_PWRKEY_COUNT_RESET_MASK 0x1
#define PMIC_RG_STRUP_PWRKEY_COUNT_RESET_SHIFT 0
#define PMIC_RG_STRUP_EXT_PMIC_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_EXT_PMIC_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_EXT_PMIC_PG_H2L_EN_SHIFT 0
#define PMIC_RG_STRUP_VAUD28_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VAUD28_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VAUD28_PG_H2L_EN_SHIFT 1
#define PMIC_RG_STRUP_VUSB_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VUSB_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VUSB_PG_H2L_EN_SHIFT 2
#define PMIC_RG_STRUP_VDRAM_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VDRAM_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VDRAM_PG_H2L_EN_SHIFT 3
#define PMIC_RG_STRUP_VEMC_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VEMC_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VEMC_PG_H2L_EN_SHIFT 4
#define PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_SHIFT 5
#define PMIC_RG_STRUP_VA12_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VA12_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VA12_PG_H2L_EN_SHIFT 6
#define PMIC_RG_STRUP_VSRAM_GPU_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VSRAM_GPU_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VSRAM_GPU_PG_H2L_EN_SHIFT 7
#define PMIC_RG_STRUP_VSRAM_OTHERS_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VSRAM_OTHERS_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VSRAM_OTHERS_PG_H2L_EN_SHIFT 8
#define PMIC_RG_STRUP_VAUX18_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VAUX18_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VAUX18_PG_H2L_EN_SHIFT 9
#define PMIC_RG_STRUP_BUCK_RSV_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_BUCK_RSV_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_BUCK_RSV_PG_H2L_EN_SHIFT 10
#define PMIC_RG_STRUP_VPROC_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VPROC_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VPROC_PG_H2L_EN_SHIFT 11
#define PMIC_RG_STRUP_VS1_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VS1_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VS1_PG_H2L_EN_SHIFT 12
#define PMIC_RG_STRUP_VMODEM_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VMODEM_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VMODEM_PG_H2L_EN_SHIFT 13
#define PMIC_RG_STRUP_VCORE_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VCORE_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VCORE_PG_H2L_EN_SHIFT 14
#define PMIC_RG_STRUP_VS2_PG_H2L_EN_ADDR MT6356_STRUP_CON14
#define PMIC_RG_STRUP_VS2_PG_H2L_EN_MASK 0x1
#define PMIC_RG_STRUP_VS2_PG_H2L_EN_SHIFT 15
#define PMIC_RG_STRUP_CON15_RSV_ADDR MT6356_STRUP_CON15
#define PMIC_RG_STRUP_CON15_RSV_MASK 0x1
#define PMIC_RG_STRUP_CON15_RSV_SHIFT 15
#define PMIC_RG_STRUP_VUSB_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VUSB_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VUSB_PG_ENB_SHIFT 0
#define PMIC_RG_STRUP_VDRAM_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VDRAM_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VDRAM_PG_ENB_SHIFT 1
#define PMIC_RG_STRUP_VIO28_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VIO28_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VIO28_PG_ENB_SHIFT 2
#define PMIC_RG_STRUP_VEMC_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VEMC_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VEMC_PG_ENB_SHIFT 3
#define PMIC_RG_STRUP_VIO18_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VIO18_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VIO18_PG_ENB_SHIFT 4
#define PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_SHIFT 5
#define PMIC_RG_STRUP_VA12_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VA12_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VA12_PG_ENB_SHIFT 6
#define PMIC_RG_STRUP_VSRAM_GPU_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VSRAM_GPU_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VSRAM_GPU_PG_ENB_SHIFT 7
#define PMIC_RG_STRUP_VSRAM_OTHERS_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VSRAM_OTHERS_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VSRAM_OTHERS_PG_ENB_SHIFT 8
#define PMIC_RG_STRUP_VAUX18_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VAUX18_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VAUX18_PG_ENB_SHIFT 9
#define PMIC_RG_STRUP_BUCK_RSV_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_BUCK_RSV_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_BUCK_RSV_PG_ENB_SHIFT 10
#define PMIC_RG_STRUP_VPROC_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VPROC_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VPROC_PG_ENB_SHIFT 11
#define PMIC_RG_STRUP_VS1_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VS1_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VS1_PG_ENB_SHIFT 12
#define PMIC_RG_STRUP_VMODEM_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VMODEM_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VMODEM_PG_ENB_SHIFT 13
#define PMIC_RG_STRUP_VCORE_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VCORE_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VCORE_PG_ENB_SHIFT 14
#define PMIC_RG_STRUP_VS2_PG_ENB_ADDR MT6356_STRUP_CON16
#define PMIC_RG_STRUP_VS2_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VS2_PG_ENB_SHIFT 15
#define PMIC_RG_STRUP_EXT_PMIC_PG_ENB_ADDR MT6356_STRUP_CON17
#define PMIC_RG_STRUP_EXT_PMIC_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_EXT_PMIC_PG_ENB_SHIFT 13
#define PMIC_RG_STRUP_VXO22_PG_ENB_ADDR MT6356_STRUP_CON17
#define PMIC_RG_STRUP_VXO22_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VXO22_PG_ENB_SHIFT 14
#define PMIC_RG_STRUP_VAUD28_PG_ENB_ADDR MT6356_STRUP_CON17
#define PMIC_RG_STRUP_VAUD28_PG_ENB_MASK 0x1
#define PMIC_RG_STRUP_VAUD28_PG_ENB_SHIFT 15
#define PMIC_RG_STRUP_BUCK_RSV_OC_ENB_ADDR MT6356_STRUP_CON18
#define PMIC_RG_STRUP_BUCK_RSV_OC_ENB_MASK 0x1
#define PMIC_RG_STRUP_BUCK_RSV_OC_ENB_SHIFT 10
#define PMIC_RG_STRUP_VPROC_OC_ENB_ADDR MT6356_STRUP_CON18
#define PMIC_RG_STRUP_VPROC_OC_ENB_MASK 0x1
#define PMIC_RG_STRUP_VPROC_OC_ENB_SHIFT 11
#define PMIC_RG_STRUP_VS1_OC_ENB_ADDR MT6356_STRUP_CON18
#define PMIC_RG_STRUP_VS1_OC_ENB_MASK 0x1
#define PMIC_RG_STRUP_VS1_OC_ENB_SHIFT 12
#define PMIC_RG_STRUP_VMODEM_OC_ENB_ADDR MT6356_STRUP_CON18
#define PMIC_RG_STRUP_VMODEM_OC_ENB_MASK 0x1
#define PMIC_RG_STRUP_VMODEM_OC_ENB_SHIFT 13
#define PMIC_RG_STRUP_VCORE_OC_ENB_ADDR MT6356_STRUP_CON18
#define PMIC_RG_STRUP_VCORE_OC_ENB_MASK 0x1
#define PMIC_RG_STRUP_VCORE_OC_ENB_SHIFT 14
#define PMIC_RG_STRUP_VS2_OC_ENB_ADDR MT6356_STRUP_CON18
#define PMIC_RG_STRUP_VS2_OC_ENB_MASK 0x1
#define PMIC_RG_STRUP_VS2_OC_ENB_SHIFT 15
#define PMIC_RG_EXT_PMIC_PG_DEBTD_ADDR MT6356_STRUP_CON19
#define PMIC_RG_EXT_PMIC_PG_DEBTD_MASK 0x1
#define PMIC_RG_EXT_PMIC_PG_DEBTD_SHIFT 0
#define PMIC_RG_RTC_SPAR_DEB_EN_ADDR MT6356_STRUP_CON19
#define PMIC_RG_RTC_SPAR_DEB_EN_MASK 0x1
#define PMIC_RG_RTC_SPAR_DEB_EN_SHIFT 8
#define PMIC_RG_RTC_ALARM_DEB_EN_ADDR MT6356_STRUP_CON19
#define PMIC_RG_RTC_ALARM_DEB_EN_MASK 0x1
#define PMIC_RG_RTC_ALARM_DEB_EN_SHIFT 9
#define PMIC_PSEQ_ELR_LEN_ADDR MT6356_PSEQ_ELR_NUM
#define PMIC_PSEQ_ELR_LEN_MASK 0xFF
#define PMIC_PSEQ_ELR_LEN_SHIFT 0
#define PMIC_RG_VAUX18_USA_ADDR MT6356_PSEQ_ELR0
#define PMIC_RG_VAUX18_USA_MASK 0x1F
#define PMIC_RG_VAUX18_USA_SHIFT 0
#define PMIC_RG_VS2_USA_ADDR MT6356_PSEQ_ELR0
#define PMIC_RG_VS2_USA_MASK 0x1F
#define PMIC_RG_VS2_USA_SHIFT 5
#define PMIC_RG_VSRAM_OTHERS_USA_ADDR MT6356_PSEQ_ELR0
#define PMIC_RG_VSRAM_OTHERS_USA_MASK 0x1F
#define PMIC_RG_VSRAM_OTHERS_USA_SHIFT 10
#define PMIC_RG_VSRAM_GPU_USA_ADDR MT6356_PSEQ_ELR1
#define PMIC_RG_VSRAM_GPU_USA_MASK 0x1F
#define PMIC_RG_VSRAM_GPU_USA_SHIFT 0
#define PMIC_RG_VCORE_USA_ADDR MT6356_PSEQ_ELR1
#define PMIC_RG_VCORE_USA_MASK 0x1F
#define PMIC_RG_VCORE_USA_SHIFT 5
#define PMIC_RG_VMODEM_USA_ADDR MT6356_PSEQ_ELR1
#define PMIC_RG_VMODEM_USA_MASK 0x1F
#define PMIC_RG_VMODEM_USA_SHIFT 10
#define PMIC_RG_VS1_USA_ADDR MT6356_PSEQ_ELR2
#define PMIC_RG_VS1_USA_MASK 0x1F
#define PMIC_RG_VS1_USA_SHIFT 0
#define PMIC_RG_VA12_USA_ADDR MT6356_PSEQ_ELR2
#define PMIC_RG_VA12_USA_MASK 0x1F
#define PMIC_RG_VA12_USA_SHIFT 5
#define PMIC_RG_VSRAM_PROC_USA_ADDR MT6356_PSEQ_ELR2
#define PMIC_RG_VSRAM_PROC_USA_MASK 0x1F
#define PMIC_RG_VSRAM_PROC_USA_SHIFT 10
#define PMIC_RG_VPROC_USA_ADDR MT6356_PSEQ_ELR3
#define PMIC_RG_VPROC_USA_MASK 0x1F
#define PMIC_RG_VPROC_USA_SHIFT 0
#define PMIC_RG_VIO18_USA_ADDR MT6356_PSEQ_ELR3
#define PMIC_RG_VIO18_USA_MASK 0x1F
#define PMIC_RG_VIO18_USA_SHIFT 5
#define PMIC_RG_VEMC_USA_ADDR MT6356_PSEQ_ELR3
#define PMIC_RG_VEMC_USA_MASK 0x1F
#define PMIC_RG_VEMC_USA_SHIFT 10
#define PMIC_RG_EXT_PMIC_1_USA_ADDR MT6356_PSEQ_ELR4
#define PMIC_RG_EXT_PMIC_1_USA_MASK 0x1F
#define PMIC_RG_EXT_PMIC_1_USA_SHIFT 0
#define PMIC_RG_VIO28_USA_ADDR MT6356_PSEQ_ELR4
#define PMIC_RG_VIO28_USA_MASK 0x1F
#define PMIC_RG_VIO28_USA_SHIFT 5
#define PMIC_RG_VDRAM_USA_ADDR MT6356_PSEQ_ELR4
#define PMIC_RG_VDRAM_USA_MASK 0x1F
#define PMIC_RG_VDRAM_USA_SHIFT 10
#define PMIC_RG_EXT_PMIC_2_USA_ADDR MT6356_PSEQ_ELR5
#define PMIC_RG_EXT_PMIC_2_USA_MASK 0x1F
#define PMIC_RG_EXT_PMIC_2_USA_SHIFT 0
#define PMIC_RG_VUSB_USA_ADDR MT6356_PSEQ_ELR5
#define PMIC_RG_VUSB_USA_MASK 0x1F
#define PMIC_RG_VUSB_USA_SHIFT 5
#define PMIC_RG_VAUD28_USA_ADDR MT6356_PSEQ_ELR5
#define PMIC_RG_VAUD28_USA_MASK 0x1F
#define PMIC_RG_VAUD28_USA_SHIFT 10
#define PMIC_RG_VXO22_USA_ADDR MT6356_PSEQ_ELR6
#define PMIC_RG_VXO22_USA_MASK 0x1F
#define PMIC_RG_VXO22_USA_SHIFT 0
#define PMIC_RG_BUCK_RSV_USA_ADDR MT6356_PSEQ_ELR6
#define PMIC_RG_BUCK_RSV_USA_MASK 0x1F
#define PMIC_RG_BUCK_RSV_USA_SHIFT 5
#define PMIC_RG_SEQ_LEN_ADDR MT6356_PSEQ_ELR6
#define PMIC_RG_SEQ_LEN_MASK 0x1F
#define PMIC_RG_SEQ_LEN_SHIFT 10
#define PMIC_RG_BWDT_EN_ADDR MT6356_PSEQ_ELR7
#define PMIC_RG_BWDT_EN_MASK 0x1
#define PMIC_RG_BWDT_EN_SHIFT 0
#define PMIC_RG_BWDT_TSEL_ADDR MT6356_PSEQ_ELR7
#define PMIC_RG_BWDT_TSEL_MASK 0x1
#define PMIC_RG_BWDT_TSEL_SHIFT 1
#define PMIC_RG_BWDT_CSEL_ADDR MT6356_PSEQ_ELR7
#define PMIC_RG_BWDT_CSEL_MASK 0x1
#define PMIC_RG_BWDT_CSEL_SHIFT 2
#define PMIC_RG_BWDT_TD_ADDR MT6356_PSEQ_ELR7
#define PMIC_RG_BWDT_TD_MASK 0x3
#define PMIC_RG_BWDT_TD_SHIFT 3
#define PMIC_RG_BWDT_CHRTD_ADDR MT6356_PSEQ_ELR7
#define PMIC_RG_BWDT_CHRTD_MASK 0x1
#define PMIC_RG_BWDT_CHRTD_SHIFT 5
#define PMIC_RG_BWDT_DDLO_TD_ADDR MT6356_PSEQ_ELR7
#define PMIC_RG_BWDT_DDLO_TD_MASK 0x3
#define PMIC_RG_BWDT_DDLO_TD_SHIFT 6
#define PMIC_RG_BWDT_SRCSEL_ADDR MT6356_PSEQ_ELR7
#define PMIC_RG_BWDT_SRCSEL_MASK 0x1
#define PMIC_RG_BWDT_SRCSEL_SHIFT 8
#define PMIC_RG_SLOT_INTV_UP_ADDR MT6356_PSEQ_ELR7
#define PMIC_RG_SLOT_INTV_UP_MASK 0x3
#define PMIC_RG_SLOT_INTV_UP_SHIFT 9
#define PMIC_RG_PSPG_SHDN_EN_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_PSPG_SHDN_EN_MASK 0x3
#define PMIC_RG_PSPG_SHDN_EN_SHIFT 0
#define PMIC_RG_PSEQ_FSM_RST_SEL_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_PSEQ_FSM_RST_SEL_MASK 0x1
#define PMIC_RG_PSEQ_FSM_RST_SEL_SHIFT 2
#define PMIC_RG_PSEQ_F75K_FORCE_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_PSEQ_F75K_FORCE_MASK 0x1
#define PMIC_RG_PSEQ_F75K_FORCE_SHIFT 3
#define PMIC_RG_PSEQ_1MS_TK_EXT_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_PSEQ_1MS_TK_EXT_MASK 0x1
#define PMIC_RG_PSEQ_1MS_TK_EXT_SHIFT 4
#define PMIC_RG_PSEQ_IVGEN_SEL_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_PSEQ_IVGEN_SEL_MASK 0x1
#define PMIC_RG_PSEQ_IVGEN_SEL_SHIFT 5
#define PMIC_RG_STRUP_LONG_PRESS_RESET_EXTEND_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_STRUP_LONG_PRESS_RESET_EXTEND_MASK 0x1
#define PMIC_RG_STRUP_LONG_PRESS_RESET_EXTEND_SHIFT 6
#define PMIC_RG_CPS_S0EXT_ENB_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_CPS_S0EXT_ENB_MASK 0x1
#define PMIC_RG_CPS_S0EXT_ENB_SHIFT 7
#define PMIC_RG_CPS_S0EXT_TD_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_CPS_S0EXT_TD_MASK 0x1
#define PMIC_RG_CPS_S0EXT_TD_SHIFT 8
#define PMIC_RG_SDN_DLY_ENB_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_SDN_DLY_ENB_MASK 0x1
#define PMIC_RG_SDN_DLY_ENB_SHIFT 9
#define PMIC_RG_CHRDET_DEB_TD_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_CHRDET_DEB_TD_MASK 0x1
#define PMIC_RG_CHRDET_DEB_TD_SHIFT 10
#define PMIC_RG_STRUP_UVLO_U1U2_SEL_OLD_ADDR MT6356_PSEQ_ELR8
#define PMIC_RG_STRUP_UVLO_U1U2_SEL_OLD_MASK 0x1
#define PMIC_RG_STRUP_UVLO_U1U2_SEL_OLD_SHIFT 11
#define PMIC_EFUSE_IVGEN_ENB_SEL_ADDR MT6356_PSEQ_ELR8
#define PMIC_EFUSE_IVGEN_ENB_SEL_MASK 0x1
#define PMIC_EFUSE_IVGEN_ENB_SEL_SHIFT 12
#define PMIC_PCHR_DIG_ANA_ID_ADDR MT6356_PCHR_DIG_ID
#define PMIC_PCHR_DIG_ANA_ID_MASK 0xFF
#define PMIC_PCHR_DIG_ANA_ID_SHIFT 0
#define PMIC_PCHR_DIG_DIG_ID_ADDR MT6356_PCHR_DIG_ID
#define PMIC_PCHR_DIG_DIG_ID_MASK 0xFF
#define PMIC_PCHR_DIG_DIG_ID_SHIFT 8
#define PMIC_PCHR_DIG_ANA_MINOR_REV_ADDR MT6356_PCHR_DIG_REV0
#define PMIC_PCHR_DIG_ANA_MINOR_REV_MASK 0xF
#define PMIC_PCHR_DIG_ANA_MINOR_REV_SHIFT 0
#define PMIC_PCHR_DIG_ANA_MAJOR_REV_ADDR MT6356_PCHR_DIG_REV0
#define PMIC_PCHR_DIG_ANA_MAJOR_REV_MASK 0xF
#define PMIC_PCHR_DIG_ANA_MAJOR_REV_SHIFT 4
#define PMIC_PCHR_DIG_DIG_MINOR_REV_ADDR MT6356_PCHR_DIG_REV0
#define PMIC_PCHR_DIG_DIG_MINOR_REV_MASK 0xF
#define PMIC_PCHR_DIG_DIG_MINOR_REV_SHIFT 8
#define PMIC_PCHR_DIG_DIG_MAJOR_REV_ADDR MT6356_PCHR_DIG_REV0
#define PMIC_PCHR_DIG_DIG_MAJOR_REV_MASK 0xF
#define PMIC_PCHR_DIG_DIG_MAJOR_REV_SHIFT 12
#define PMIC_PCHR_DIG_SW_MINOR_REV_ADDR MT6356_PCHR_DIG_REV1
#define PMIC_PCHR_DIG_SW_MINOR_REV_MASK 0xF
#define PMIC_PCHR_DIG_SW_MINOR_REV_SHIFT 0
#define PMIC_PCHR_DIG_SW_MAJOR_REV_ADDR MT6356_PCHR_DIG_REV1
#define PMIC_PCHR_DIG_SW_MAJOR_REV_MASK 0xF
#define PMIC_PCHR_DIG_SW_MAJOR_REV_SHIFT 4
#define PMIC_PCHR_DIG_ESP_ADDR MT6356_PCHR_DIG_REV1
#define PMIC_PCHR_DIG_ESP_MASK 0xFF
#define PMIC_PCHR_DIG_ESP_SHIFT 8
#define PMIC_PCHR_DIG_REG_ID_ADDR MT6356_PCHR_DIG_REV2
#define PMIC_PCHR_DIG_REG_ID_MASK 0x3
#define PMIC_PCHR_DIG_REG_ID_SHIFT 0
#define PMIC_RGS_CHRWDT_OUT_ADDR MT6356_CHR_TOP_CON0
#define PMIC_RGS_CHRWDT_OUT_MASK 0x1
#define PMIC_RGS_CHRWDT_OUT_SHIFT 0
#define PMIC_RGS_OTG_BVALID_DET_ADDR MT6356_CHR_TOP_CON0
#define PMIC_RGS_OTG_BVALID_DET_MASK 0x1
#define PMIC_RGS_OTG_BVALID_DET_SHIFT 1
#define PMIC_RGS_VBAT_OV_DET_ADDR MT6356_CHR_TOP_CON0
#define PMIC_RGS_VBAT_OV_DET_MASK 0x1
#define PMIC_RGS_VBAT_OV_DET_SHIFT 2
#define PMIC_RGS_CHR_LDO_DET_ADDR MT6356_CHR_TOP_CON0
#define PMIC_RGS_CHR_LDO_DET_MASK 0x1
#define PMIC_RGS_CHR_LDO_DET_SHIFT 3
#define PMIC_RGS_CHRDET_ADDR MT6356_CHR_TOP_CON0
#define PMIC_RGS_CHRDET_MASK 0x1
#define PMIC_RGS_CHRDET_SHIFT 4
#define PMIC_RG_PCHR_RV_ADDR MT6356_CHR_TOP_CON1
#define PMIC_RG_PCHR_RV_MASK 0xFF
#define PMIC_RG_PCHR_RV_SHIFT 0
#define PMIC_RG_VCDT_UVLO_EN_ADDR MT6356_CHR_TOP_CON3
#define PMIC_RG_VCDT_UVLO_EN_MASK 0x1
#define PMIC_RG_VCDT_UVLO_EN_SHIFT 0
#define PMIC_RG_VCDT_UVLO_VTH_ADDR MT6356_CHR_TOP_CON3
#define PMIC_RG_VCDT_UVLO_VTH_MASK 0x1
#define PMIC_RG_VCDT_UVLO_VTH_SHIFT 1
#define PMIC_RG_UVLO_VTHL_ADDR MT6356_CHR_TOP_CON3
#define PMIC_RG_UVLO_VTHL_MASK 0x1F
#define PMIC_RG_UVLO_VTHL_SHIFT 2
#define PMIC_RG_UVLO_VH_LAT_ADDR MT6356_CHR_TOP_CON3
#define PMIC_RG_UVLO_VH_LAT_MASK 0x1
#define PMIC_RG_UVLO_VH_LAT_SHIFT 7
#define PMIC_RG_VCDT_MODE_ADDR MT6356_CHR_TOP_CON4
#define PMIC_RG_VCDT_MODE_MASK 0x1
#define PMIC_RG_VCDT_MODE_SHIFT 0
#define PMIC_RG_VCDT_LV_VTH_ADDR MT6356_CHR_TOP_CON4
#define PMIC_RG_VCDT_LV_VTH_MASK 0x1F
#define PMIC_RG_VCDT_LV_VTH_SHIFT 1
#define PMIC_RG_VCDT_HV_VTH_ADDR MT6356_CHR_TOP_CON4
#define PMIC_RG_VCDT_HV_VTH_MASK 0x1F
#define PMIC_RG_VCDT_HV_VTH_SHIFT 6
#define PMIC_RG_VBAT_OV_VTH_ADDR MT6356_CHR_TOP_CON4
#define PMIC_RG_VBAT_OV_VTH_MASK 0xF
#define PMIC_RG_VBAT_OV_VTH_SHIFT 11
#define PMIC_DA_QI_BGR_EXT_BUF_EN_ADDR MT6356_CHR_TOP_CON5
#define PMIC_DA_QI_BGR_EXT_BUF_EN_MASK 0x1
#define PMIC_DA_QI_BGR_EXT_BUF_EN_SHIFT 0
#define PMIC_RG_BGR_TEST_EN_ADDR MT6356_CHR_TOP_CON5
#define PMIC_RG_BGR_TEST_EN_MASK 0x1
#define PMIC_RG_BGR_TEST_EN_SHIFT 1
#define PMIC_RG_BGR_TEST_RSTB_ADDR MT6356_CHR_TOP_CON5
#define PMIC_RG_BGR_TEST_RSTB_MASK 0x1
#define PMIC_RG_BGR_TEST_RSTB_SHIFT 2
#define PMIC_RG_BGR_UNCHOP_PH_ADDR MT6356_CHR_TOP_CON5
#define PMIC_RG_BGR_UNCHOP_PH_MASK 0x1
#define PMIC_RG_BGR_UNCHOP_PH_SHIFT 3
#define PMIC_RG_BGR_UNCHOP_ADDR MT6356_CHR_TOP_CON5
#define PMIC_RG_BGR_UNCHOP_MASK 0x1
#define PMIC_RG_BGR_UNCHOP_SHIFT 4
#define PMIC_RG_PCHR_FT_CTRL_ADDR MT6356_CHR_TOP_CON6
#define PMIC_RG_PCHR_FT_CTRL_MASK 0x7
#define PMIC_RG_PCHR_FT_CTRL_SHIFT 0
#define PMIC_PCHR_CM_VINC_STATUS_ADDR MT6356_CHR_TOP_CON6
#define PMIC_PCHR_CM_VINC_STATUS_MASK 0x1
#define PMIC_PCHR_CM_VINC_STATUS_SHIFT 3
#define PMIC_PCHR_CM_VDEC_STATUS_ADDR MT6356_CHR_TOP_CON6
#define PMIC_PCHR_CM_VDEC_STATUS_MASK 0x1
#define PMIC_PCHR_CM_VDEC_STATUS_SHIFT 4
#define PMIC_RG_PCHR_FLAG_EN_ADDR MT6356_CHR_TOP_CON6
#define PMIC_RG_PCHR_FLAG_EN_MASK 0x1
#define PMIC_RG_PCHR_FLAG_EN_SHIFT 5
#define PMIC_RG_PCHR_FLAG_SEL_ADDR MT6356_CHR_TOP_CON6
#define PMIC_RG_PCHR_FLAG_SEL_MASK 0x3F
#define PMIC_RG_PCHR_FLAG_SEL_SHIFT 6
#define PMIC_RG_LBAT_INT_VTH_ADDR MT6356_CHR_TOP_CON7
#define PMIC_RG_LBAT_INT_VTH_MASK 0x1F
#define PMIC_RG_LBAT_INT_VTH_SHIFT 0
#define PMIC_RG_OTG_BVALID_EN_ADDR MT6356_CHR_TOP_CON7
#define PMIC_RG_OTG_BVALID_EN_MASK 0x1
#define PMIC_RG_OTG_BVALID_EN_SHIFT 7
#define PMIC_PCHR_DIG_ELR_LEN_ADDR MT6356_PCHR_DIG_ELR_NUM
#define PMIC_PCHR_DIG_ELR_LEN_MASK 0xFF
#define PMIC_PCHR_DIG_ELR_LEN_SHIFT 0
#define PMIC_RG_ICHRG_TRIM_ADDR MT6356_PCHR_ELR0
#define PMIC_RG_ICHRG_TRIM_MASK 0x3F
#define PMIC_RG_ICHRG_TRIM_SHIFT 0
#define PMIC_RG_VBAT_CV_VTH_ADDR MT6356_PCHR_ELR0
#define PMIC_RG_VBAT_CV_VTH_MASK 0x3F
#define PMIC_RG_VBAT_CV_VTH_SHIFT 6
#define PMIC_RG_BGR_RSEL_ADDR MT6356_PCHR_ELR0
#define PMIC_RG_BGR_RSEL_MASK 0xF
#define PMIC_RG_BGR_RSEL_SHIFT 12
#define PMIC_RG_CHR_OSC_TRIM_ADDR MT6356_PCHR_ELR1
#define PMIC_RG_CHR_OSC_TRIM_MASK 0x1F
#define PMIC_RG_CHR_OSC_TRIM_SHIFT 0
#define PMIC_RG_OVP_TRIM_ADDR MT6356_PCHR_ELR1
#define PMIC_RG_OVP_TRIM_MASK 0xF
#define PMIC_RG_OVP_TRIM_SHIFT 5
#define PMIC_RG_BGR_TRIM_ADDR MT6356_PCHR_ELR1
#define PMIC_RG_BGR_TRIM_MASK 0x1F
#define PMIC_RG_BGR_TRIM_SHIFT 9
#define PMIC_RG_BGR_TRIM_EN_ADDR MT6356_PCHR_ELR1
#define PMIC_RG_BGR_TRIM_EN_MASK 0x1
#define PMIC_RG_BGR_TRIM_EN_SHIFT 14
#define PMIC_RG_PCHR_SPARE_ELR0_ADDR MT6356_PCHR_ELR1
#define PMIC_RG_PCHR_SPARE_ELR0_MASK 0x1
#define PMIC_RG_PCHR_SPARE_ELR0_SHIFT 15
#define PMIC_RG_INDICATOR_TRIM_ADDR MT6356_PCHR_ELR2
#define PMIC_RG_INDICATOR_TRIM_MASK 0x7
#define PMIC_RG_INDICATOR_TRIM_SHIFT 0
#define PMIC_RG_VBAT_CV_TRIM_ADDR MT6356_PCHR_ELR2
#define PMIC_RG_VBAT_CV_TRIM_MASK 0xF
#define PMIC_RG_VBAT_CV_TRIM_SHIFT 3
#define PMIC_RG_VCDT_TRIM_ADDR MT6356_PCHR_ELR2
#define PMIC_RG_VCDT_TRIM_MASK 0xF
#define PMIC_RG_VCDT_TRIM_SHIFT 7
#define PMIC_RG_PCHR_SPARE_ELR1_ADDR MT6356_PCHR_ELR2
#define PMIC_RG_PCHR_SPARE_ELR1_MASK 0x1F
#define PMIC_RG_PCHR_SPARE_ELR1_SHIFT 11
#define PMIC_RG_PCHR_APP2_ADDR MT6356_PCHR_ELR3
#define PMIC_RG_PCHR_APP2_MASK 0xFF
#define PMIC_RG_PCHR_APP2_SHIFT 0
#define PMIC_RG_PCHR_APP1_ADDR MT6356_PCHR_ELR3
#define PMIC_RG_PCHR_APP1_MASK 0xFF
#define PMIC_RG_PCHR_APP1_SHIFT 8
#define PMIC_PCHR_MACRO_ANA_ID_ADDR MT6356_PCHR_MACRO_ID
#define PMIC_PCHR_MACRO_ANA_ID_MASK 0xFF
#define PMIC_PCHR_MACRO_ANA_ID_SHIFT 0
#define PMIC_PCHR_MACRO_DIG_ID_ADDR MT6356_PCHR_MACRO_ID
#define PMIC_PCHR_MACRO_DIG_ID_MASK 0xFF
#define PMIC_PCHR_MACRO_DIG_ID_SHIFT 8
#define PMIC_PCHR_MACRO_ANA_MINOR_REV_ADDR MT6356_PCHR_MACRO_REV0
#define PMIC_PCHR_MACRO_ANA_MINOR_REV_MASK 0xF
#define PMIC_PCHR_MACRO_ANA_MINOR_REV_SHIFT 0
#define PMIC_PCHR_MACRO_ANA_MAJOR_REV_ADDR MT6356_PCHR_MACRO_REV0
#define PMIC_PCHR_MACRO_ANA_MAJOR_REV_MASK 0xF
#define PMIC_PCHR_MACRO_ANA_MAJOR_REV_SHIFT 4
#define PMIC_PCHR_MACRO_DIG_MINOR_REV_ADDR MT6356_PCHR_MACRO_REV0
#define PMIC_PCHR_MACRO_DIG_MINOR_REV_MASK 0xF
#define PMIC_PCHR_MACRO_DIG_MINOR_REV_SHIFT 8
#define PMIC_PCHR_MACRO_DIG_MAJOR_REV_ADDR MT6356_PCHR_MACRO_REV0
#define PMIC_PCHR_MACRO_DIG_MAJOR_REV_MASK 0xF
#define PMIC_PCHR_MACRO_DIG_MAJOR_REV_SHIFT 12
#define PMIC_PCHR_MACRO_SW_MINOR_REV_ADDR MT6356_PCHR_MACRO_REV1
#define PMIC_PCHR_MACRO_SW_MINOR_REV_MASK 0xF
#define PMIC_PCHR_MACRO_SW_MINOR_REV_SHIFT 0
#define PMIC_PCHR_MACRO_SW_MAJOR_REV_ADDR MT6356_PCHR_MACRO_REV1
#define PMIC_PCHR_MACRO_SW_MAJOR_REV_MASK 0xF
#define PMIC_PCHR_MACRO_SW_MAJOR_REV_SHIFT 4
#define PMIC_PCHR_MACRO_ESP_ADDR MT6356_PCHR_MACRO_REV1
#define PMIC_PCHR_MACRO_ESP_MASK 0xFF
#define PMIC_PCHR_MACRO_ESP_SHIFT 8
#define PMIC_PCHR_MACRO_REG_ID_ADDR MT6356_PCHR_MACRO_REV2
#define PMIC_PCHR_MACRO_REG_ID_MASK 0x3
#define PMIC_PCHR_MACRO_REG_ID_SHIFT 0
#define PMIC_RG_CS_VTH_ADDR MT6356_CHR_CON0
#define PMIC_RG_CS_VTH_MASK 0xF
#define PMIC_RG_CS_VTH_SHIFT 0
#define PMIC_RG_CS_EN_ADDR MT6356_CHR_CON0
#define PMIC_RG_CS_EN_MASK 0x1
#define PMIC_RG_CS_EN_SHIFT 4
#define PMIC_RG_VBAT_OV_EN_ADDR MT6356_CHR_CON0
#define PMIC_RG_VBAT_OV_EN_MASK 0x1
#define PMIC_RG_VBAT_OV_EN_SHIFT 5
#define PMIC_RG_VBAT_OV_DEG_ADDR MT6356_CHR_CON0
#define PMIC_RG_VBAT_OV_DEG_MASK 0x1
#define PMIC_RG_VBAT_OV_DEG_SHIFT 6
#define PMIC_RG_VBAT_CV_EN_ADDR MT6356_CHR_CON0
#define PMIC_RG_VBAT_CV_EN_MASK 0x1
#define PMIC_RG_VBAT_CV_EN_SHIFT 7
#define PMIC_RG_VBAT_CC_VTH_ADDR MT6356_CHR_CON0
#define PMIC_RG_VBAT_CC_VTH_MASK 0x3
#define PMIC_RG_VBAT_CC_VTH_SHIFT 8
#define PMIC_RG_VBAT_CC_EN_ADDR MT6356_CHR_CON0
#define PMIC_RG_VBAT_CC_EN_MASK 0x1
#define PMIC_RG_VBAT_CC_EN_SHIFT 10
#define PMIC_RG_VCDT_HV_EN_ADDR MT6356_CHR_CON0
#define PMIC_RG_VCDT_HV_EN_MASK 0x1
#define PMIC_RG_VCDT_HV_EN_SHIFT 11
#define PMIC_RG_LOW_ICH_DB_ADDR MT6356_CHR_CON1
#define PMIC_RG_LOW_ICH_DB_MASK 0x3F
#define PMIC_RG_LOW_ICH_DB_SHIFT 0
#define PMIC_RG_CV_MODE_ADDR MT6356_CHR_CON1
#define PMIC_RG_CV_MODE_MASK 0x1
#define PMIC_RG_CV_MODE_SHIFT 6
#define PMIC_RG_CSDAC_MODE_ADDR MT6356_CHR_CON1
#define PMIC_RG_CSDAC_MODE_MASK 0x1
#define PMIC_RG_CSDAC_MODE_SHIFT 7
#define PMIC_RG_TRACKING_EN_ADDR MT6356_CHR_CON1
#define PMIC_RG_TRACKING_EN_MASK 0x1
#define PMIC_RG_TRACKING_EN_SHIFT 8
#define PMIC_RG_HWCV_EN_ADDR MT6356_CHR_CON1
#define PMIC_RG_HWCV_EN_MASK 0x1
#define PMIC_RG_HWCV_EN_SHIFT 9
#define PMIC_RG_ULC_DET_EN_ADDR MT6356_CHR_CON1
#define PMIC_RG_ULC_DET_EN_MASK 0x1
#define PMIC_RG_ULC_DET_EN_SHIFT 10
#define PMIC_RG_CSDAC_EN_ADDR MT6356_CHR_CON1
#define PMIC_RG_CSDAC_EN_MASK 0x1
#define PMIC_RG_CSDAC_EN_SHIFT 11
#define PMIC_RG_CHR_EN_ADDR MT6356_CHR_CON1
#define PMIC_RG_CHR_EN_MASK 0x1
#define PMIC_RG_CHR_EN_SHIFT 12
#define PMIC_RGS_CS_DET_ADDR MT6356_CHR_CON2
#define PMIC_RGS_CS_DET_MASK 0x1
#define PMIC_RGS_CS_DET_SHIFT 0
#define PMIC_RGS_VBAT_CV_DET_ADDR MT6356_CHR_CON2
#define PMIC_RGS_VBAT_CV_DET_MASK 0x1
#define PMIC_RGS_VBAT_CV_DET_SHIFT 1
#define PMIC_RGS_VBAT_CC_DET_ADDR MT6356_CHR_CON2
#define PMIC_RGS_VBAT_CC_DET_MASK 0x1
#define PMIC_RGS_VBAT_CC_DET_SHIFT 2
#define PMIC_RGS_VCDT_LV_DET_ADDR MT6356_CHR_CON2
#define PMIC_RGS_VCDT_LV_DET_MASK 0x1
#define PMIC_RGS_VCDT_LV_DET_SHIFT 3
#define PMIC_RGS_VCDT_HV_DET_ADDR MT6356_CHR_CON2
#define PMIC_RGS_VCDT_HV_DET_MASK 0x1
#define PMIC_RGS_VCDT_HV_DET_SHIFT 4
#define PMIC_RG_CSDAC_DLY_ADDR MT6356_CHR_CON3
#define PMIC_RG_CSDAC_DLY_MASK 0x7
#define PMIC_RG_CSDAC_DLY_SHIFT 0
#define PMIC_RG_CSDAC_STP_ADDR MT6356_CHR_CON3
#define PMIC_RG_CSDAC_STP_MASK 0x7
#define PMIC_RG_CSDAC_STP_SHIFT 3
#define PMIC_RG_CSDAC_STP_INC_ADDR MT6356_CHR_CON3
#define PMIC_RG_CSDAC_STP_INC_MASK 0x7
#define PMIC_RG_CSDAC_STP_INC_SHIFT 6
#define PMIC_RG_CSDAC_STP_DEC_ADDR MT6356_CHR_CON3
#define PMIC_RG_CSDAC_STP_DEC_MASK 0x7
#define PMIC_RG_CSDAC_STP_DEC_SHIFT 9
#define PMIC_RG_PCHR_TOHTC_ADDR MT6356_CHR_CON4
#define PMIC_RG_PCHR_TOHTC_MASK 0x7
#define PMIC_RG_PCHR_TOHTC_SHIFT 0
#define PMIC_RG_PCHR_TOLTC_ADDR MT6356_CHR_CON4
#define PMIC_RG_PCHR_TOLTC_MASK 0x7
#define PMIC_RG_PCHR_TOLTC_SHIFT 3
#define PMIC_RG_CSDAC_DATA_ADDR MT6356_CHR_CON5
#define PMIC_RG_CSDAC_DATA_MASK 0x3FF
#define PMIC_RG_CSDAC_DATA_SHIFT 0
#define PMIC_RG_FRC_CSVTH_USBDL_ADDR MT6356_CHR_CON6
#define PMIC_RG_FRC_CSVTH_USBDL_MASK 0x1
#define PMIC_RG_FRC_CSVTH_USBDL_SHIFT 0
#define PMIC_RG_USBDL_RST_ADDR MT6356_CHR_CON6
#define PMIC_RG_USBDL_RST_MASK 0x1
#define PMIC_RG_USBDL_RST_SHIFT 1
#define PMIC_RG_USBDL_SET_ADDR MT6356_CHR_CON6
#define PMIC_RG_USBDL_SET_MASK 0x1
#define PMIC_RG_USBDL_SET_SHIFT 2
#define PMIC_RG_DAC_USBDL_MAX_ADDR MT6356_CHR_CON6
#define PMIC_RG_DAC_USBDL_MAX_MASK 0x3FF
#define PMIC_RG_DAC_USBDL_MAX_SHIFT 3
#define PMIC_RGS_PCHR_FLAG_OUT_ADDR MT6356_CHR_CON7
#define PMIC_RGS_PCHR_FLAG_OUT_MASK 0xF
#define PMIC_RGS_PCHR_FLAG_OUT_SHIFT 0
#define PMIC_RG_PCHR_TESTMODE_ADDR MT6356_CHR_CON7
#define PMIC_RG_PCHR_TESTMODE_MASK 0x1
#define PMIC_RG_PCHR_TESTMODE_SHIFT 4
#define PMIC_RG_CSDAC_TESTMODE_ADDR MT6356_CHR_CON7
#define PMIC_RG_CSDAC_TESTMODE_MASK 0x1
#define PMIC_RG_CSDAC_TESTMODE_SHIFT 5
#define PMIC_RG_PCHR_RST_ADDR MT6356_CHR_CON7
#define PMIC_RG_PCHR_RST_MASK 0x1
#define PMIC_RG_PCHR_RST_SHIFT 6
#define PMIC_RG_BC11_VREF_VTH_ADDR MT6356_CHR_CON8
#define PMIC_RG_BC11_VREF_VTH_MASK 0x3
#define PMIC_RG_BC11_VREF_VTH_SHIFT 0
#define PMIC_RG_BC11_CMP_EN_ADDR MT6356_CHR_CON8
#define PMIC_RG_BC11_CMP_EN_MASK 0x3
#define PMIC_RG_BC11_CMP_EN_SHIFT 2
#define PMIC_RG_BC11_IPD_EN_ADDR MT6356_CHR_CON8
#define PMIC_RG_BC11_IPD_EN_MASK 0x3
#define PMIC_RG_BC11_IPD_EN_SHIFT 4
#define PMIC_RG_BC11_IPU_EN_ADDR MT6356_CHR_CON8
#define PMIC_RG_BC11_IPU_EN_MASK 0x3
#define PMIC_RG_BC11_IPU_EN_SHIFT 6
#define PMIC_RG_BC11_BIAS_EN_ADDR MT6356_CHR_CON8
#define PMIC_RG_BC11_BIAS_EN_MASK 0x1
#define PMIC_RG_BC11_BIAS_EN_SHIFT 8
#define PMIC_RG_BC11_BB_CTRL_ADDR MT6356_CHR_CON8
#define PMIC_RG_BC11_BB_CTRL_MASK 0x1
#define PMIC_RG_BC11_BB_CTRL_SHIFT 9
#define PMIC_RG_BC11_RST_ADDR MT6356_CHR_CON8
#define PMIC_RG_BC11_RST_MASK 0x1
#define PMIC_RG_BC11_RST_SHIFT 10
#define PMIC_RG_BC11_VSRC_EN_ADDR MT6356_CHR_CON8
#define PMIC_RG_BC11_VSRC_EN_MASK 0x3
#define PMIC_RG_BC11_VSRC_EN_SHIFT 11
#define PMIC_RG_BC11_DCD_EN_ADDR MT6356_CHR_CON8
#define PMIC_RG_BC11_DCD_EN_MASK 0x1
#define PMIC_RG_BC11_DCD_EN_SHIFT 13
#define PMIC_RGS_BC11_CMP_OUT_ADDR MT6356_CHR_CON8
#define PMIC_RGS_BC11_CMP_OUT_MASK 0x1
#define PMIC_RGS_BC11_CMP_OUT_SHIFT 14
#define PMIC_RG_CM_VDEC_HPRD1_ADDR MT6356_CHR_CON9
#define PMIC_RG_CM_VDEC_HPRD1_MASK 0x3F
#define PMIC_RG_CM_VDEC_HPRD1_SHIFT 0
#define PMIC_RG_CM_VDEC_HPRD2_ADDR MT6356_CHR_CON9
#define PMIC_RG_CM_VDEC_HPRD2_MASK 0x3F
#define PMIC_RG_CM_VDEC_HPRD2_SHIFT 6
#define PMIC_RG_CM_VDEC_HPRD3_ADDR MT6356_CHR_CON10
#define PMIC_RG_CM_VDEC_HPRD3_MASK 0x3F
#define PMIC_RG_CM_VDEC_HPRD3_SHIFT 0
#define PMIC_RG_CM_VDEC_HPRD4_ADDR MT6356_CHR_CON10
#define PMIC_RG_CM_VDEC_HPRD4_MASK 0x3F
#define PMIC_RG_CM_VDEC_HPRD4_SHIFT 6
#define PMIC_RG_CM_VDEC_HPRD5_ADDR MT6356_CHR_CON11
#define PMIC_RG_CM_VDEC_HPRD5_MASK 0x3F
#define PMIC_RG_CM_VDEC_HPRD5_SHIFT 0
#define PMIC_RG_CM_VDEC_HPRD6_ADDR MT6356_CHR_CON11
#define PMIC_RG_CM_VDEC_HPRD6_MASK 0x3F
#define PMIC_RG_CM_VDEC_HPRD6_SHIFT 6
#define PMIC_RG_CM_VINC_HPRD1_ADDR MT6356_CHR_CON12
#define PMIC_RG_CM_VINC_HPRD1_MASK 0x3F
#define PMIC_RG_CM_VINC_HPRD1_SHIFT 0
#define PMIC_RG_CM_VINC_HPRD2_ADDR MT6356_CHR_CON12
#define PMIC_RG_CM_VINC_HPRD2_MASK 0x3F
#define PMIC_RG_CM_VINC_HPRD2_SHIFT 6
#define PMIC_RG_CM_VINC_HPRD3_ADDR MT6356_CHR_CON13
#define PMIC_RG_CM_VINC_HPRD3_MASK 0x3F
#define PMIC_RG_CM_VINC_HPRD3_SHIFT 0
#define PMIC_RG_CM_VINC_HPRD4_ADDR MT6356_CHR_CON13
#define PMIC_RG_CM_VINC_HPRD4_MASK 0x3F
#define PMIC_RG_CM_VINC_HPRD4_SHIFT 6
#define PMIC_RG_CM_VINC_HPRD5_ADDR MT6356_CHR_CON14
#define PMIC_RG_CM_VINC_HPRD5_MASK 0x3F
#define PMIC_RG_CM_VINC_HPRD5_SHIFT 0
#define PMIC_RG_CM_VINC_HPRD6_ADDR MT6356_CHR_CON14
#define PMIC_RG_CM_VINC_HPRD6_MASK 0x3F
#define PMIC_RG_CM_VINC_HPRD6_SHIFT 6
#define PMIC_RG_CM_LPRD_ADDR MT6356_CHR_CON15
#define PMIC_RG_CM_LPRD_MASK 0x3F
#define PMIC_RG_CM_LPRD_SHIFT 0
#define PMIC_RG_CM_CS_VTHL_ADDR MT6356_CHR_CON16
#define PMIC_RG_CM_CS_VTHL_MASK 0xF
#define PMIC_RG_CM_CS_VTHL_SHIFT 0
#define PMIC_RG_CM_CS_VTHH_ADDR MT6356_CHR_CON16
#define PMIC_RG_CM_CS_VTHH_MASK 0xF
#define PMIC_RG_CM_CS_VTHH_SHIFT 4
#define PMIC_RG_CM_VINC_TRIG_ADDR MT6356_CHR_CON17
#define PMIC_RG_CM_VINC_TRIG_MASK 0x1
#define PMIC_RG_CM_VINC_TRIG_SHIFT 0
#define PMIC_RG_CM_VDEC_TRIG_ADDR MT6356_CHR_CON17
#define PMIC_RG_CM_VDEC_TRIG_MASK 0x1
#define PMIC_RG_CM_VDEC_TRIG_SHIFT 1
#define PMIC_RG_ENVTEM_D_ADDR MT6356_CHR_CON18
#define PMIC_RG_ENVTEM_D_MASK 0x1
#define PMIC_RG_ENVTEM_D_SHIFT 0
#define PMIC_RG_ENVTEM_EN_ADDR MT6356_CHR_CON18
#define PMIC_RG_ENVTEM_EN_MASK 0x1
#define PMIC_RG_ENVTEM_EN_SHIFT 1
#define PMIC_RG_CHRWDT_TD_ADDR MT6356_CHR_CON18
#define PMIC_RG_CHRWDT_TD_MASK 0xF
#define PMIC_RG_CHRWDT_TD_SHIFT 2
#define PMIC_RG_CHRWDT_EN_ADDR MT6356_CHR_CON18
#define PMIC_RG_CHRWDT_EN_MASK 0x1
#define PMIC_RG_CHRWDT_EN_SHIFT 6
#define PMIC_RG_CHRWDT_WR_ADDR MT6356_CHR_CON18
#define PMIC_RG_CHRWDT_WR_MASK 0x1
#define PMIC_RG_CHRWDT_WR_SHIFT 7
#define PMIC_BM_TOP_ANA_ID_ADDR MT6356_BM_TOP_DSN_ID
#define PMIC_BM_TOP_ANA_ID_MASK 0xFF
#define PMIC_BM_TOP_ANA_ID_SHIFT 0
#define PMIC_BM_TOP_DIG_ID_ADDR MT6356_BM_TOP_DSN_ID
#define PMIC_BM_TOP_DIG_ID_MASK 0xFF
#define PMIC_BM_TOP_DIG_ID_SHIFT 8
#define PMIC_BM_TOP_ANA_MINOR_REV_ADDR MT6356_BM_TOP_DSN_REV0
#define PMIC_BM_TOP_ANA_MINOR_REV_MASK 0xF
#define PMIC_BM_TOP_ANA_MINOR_REV_SHIFT 0
#define PMIC_BM_TOP_ANA_MAJOR_REV_ADDR MT6356_BM_TOP_DSN_REV0
#define PMIC_BM_TOP_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BM_TOP_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BM_TOP_DIG_MINOR_REV_ADDR MT6356_BM_TOP_DSN_REV0
#define PMIC_BM_TOP_DIG_MINOR_REV_MASK 0xF
#define PMIC_BM_TOP_DIG_MINOR_REV_SHIFT 8
#define PMIC_BM_TOP_DIG_MAJOR_REV_ADDR MT6356_BM_TOP_DSN_REV0
#define PMIC_BM_TOP_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BM_TOP_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BM_TOP_SW_MINOR_REV_ADDR MT6356_BM_TOP_DSN_REV1
#define PMIC_BM_TOP_SW_MINOR_REV_MASK 0xF
#define PMIC_BM_TOP_SW_MINOR_REV_SHIFT 0
#define PMIC_BM_TOP_SW_MAJOR_REV_ADDR MT6356_BM_TOP_DSN_REV1
#define PMIC_BM_TOP_SW_MAJOR_REV_MASK 0xF
#define PMIC_BM_TOP_SW_MAJOR_REV_SHIFT 4
#define PMIC_BM_TOP_ESP_ADDR MT6356_BM_TOP_DSN_REV1
#define PMIC_BM_TOP_ESP_MASK 0xFF
#define PMIC_BM_TOP_ESP_SHIFT 8
#define PMIC_BM_TOP_CLK_OFFSET_ADDR MT6356_BM_TOP_PAM0
#define PMIC_BM_TOP_CLK_OFFSET_MASK 0xFF
#define PMIC_BM_TOP_CLK_OFFSET_SHIFT 0
#define PMIC_BM_TOP_RST_OFFSET_ADDR MT6356_BM_TOP_PAM0
#define PMIC_BM_TOP_RST_OFFSET_MASK 0xFF
#define PMIC_BM_TOP_RST_OFFSET_SHIFT 8
#define PMIC_BM_TOP_INT_OFFSET_ADDR MT6356_BM_TOP_PAM1
#define PMIC_BM_TOP_INT_OFFSET_MASK 0xFF
#define PMIC_BM_TOP_INT_OFFSET_SHIFT 0
#define PMIC_BM_TOP_INT_LEN_ADDR MT6356_BM_TOP_PAM1
#define PMIC_BM_TOP_INT_LEN_MASK 0xFF
#define PMIC_BM_TOP_INT_LEN_SHIFT 8
#define PMIC_RG_FGADC_32K_CK_SEL_ADDR MT6356_BM_TOP_CLK_CON0
#define PMIC_RG_FGADC_32K_CK_SEL_MASK 0x1
#define PMIC_RG_FGADC_32K_CK_SEL_SHIFT 0
#define PMIC_RG_BATON_32K_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_BATON_32K_CK_PDN_MASK 0x1
#define PMIC_RG_BATON_32K_CK_PDN_SHIFT 0
#define PMIC_RG_BATON_1K_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_BATON_1K_CK_PDN_MASK 0x1
#define PMIC_RG_BATON_1K_CK_PDN_SHIFT 1
#define PMIC_RG_FGADC_FT_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_FGADC_FT_CK_PDN_MASK 0x1
#define PMIC_RG_FGADC_FT_CK_PDN_SHIFT 2
#define PMIC_RG_FGADC_DIG_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_FGADC_DIG_CK_PDN_MASK 0x1
#define PMIC_RG_FGADC_DIG_CK_PDN_SHIFT 3
#define PMIC_RG_FGADC_ANA_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_FGADC_ANA_CK_PDN_MASK 0x1
#define PMIC_RG_FGADC_ANA_CK_PDN_SHIFT 4
#define PMIC_RG_G_BIF_1M_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_G_BIF_1M_CK_PDN_MASK 0x1
#define PMIC_RG_G_BIF_1M_CK_PDN_SHIFT 5
#define PMIC_RG_BIF_X1_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_BIF_X1_CK_PDN_MASK 0x1
#define PMIC_RG_BIF_X1_CK_PDN_SHIFT 6
#define PMIC_RG_BIF_X4_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_BIF_X4_CK_PDN_MASK 0x1
#define PMIC_RG_BIF_X4_CK_PDN_SHIFT 7
#define PMIC_RG_BIF_X104_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_BIF_X104_CK_PDN_MASK 0x1
#define PMIC_RG_BIF_X104_CK_PDN_SHIFT 8
#define PMIC_RG_PMU26M_CK_DIV_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_PMU26M_CK_DIV_PDN_MASK 0x1
#define PMIC_RG_PMU26M_CK_DIV_PDN_SHIFT 9
#define PMIC_RG_BM_INTRP_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_BM_INTRP_CK_PDN_MASK 0x1
#define PMIC_RG_BM_INTRP_CK_PDN_SHIFT 10
#define PMIC_RG_BM_INTRP_PRE_OC_CK_PDN_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_BM_INTRP_PRE_OC_CK_PDN_MASK 0x1
#define PMIC_RG_BM_INTRP_PRE_OC_CK_PDN_SHIFT 11
#define PMIC_RG_BM_TOP_CKPDN_CON0_RSV_ADDR MT6356_BM_TOP_CKPDN_CON0
#define PMIC_RG_BM_TOP_CKPDN_CON0_RSV_MASK 0xF
#define PMIC_RG_BM_TOP_CKPDN_CON0_RSV_SHIFT 12
#define PMIC_BM_TOP_CKPDN_CON0_SET_ADDR MT6356_BM_TOP_CKPDN_CON0_SET
#define PMIC_BM_TOP_CKPDN_CON0_SET_MASK 0xFFFF
#define PMIC_BM_TOP_CKPDN_CON0_SET_SHIFT 0
#define PMIC_BM_TOP_CKPDN_CON0_CLR_ADDR MT6356_BM_TOP_CKPDN_CON0_CLR
#define PMIC_BM_TOP_CKPDN_CON0_CLR_MASK 0xFFFF
#define PMIC_BM_TOP_CKPDN_CON0_CLR_SHIFT 0
#define PMIC_RG_FGADC_ANA_CK_CKSEL_ADDR MT6356_BM_TOP_CKSEL_CON0
#define PMIC_RG_FGADC_ANA_CK_CKSEL_MASK 0x1
#define PMIC_RG_FGADC_ANA_CK_CKSEL_SHIFT 0
#define PMIC_RG_BM_TOP_CKSEL_CON0_RSV_ADDR MT6356_BM_TOP_CKSEL_CON0
#define PMIC_RG_BM_TOP_CKSEL_CON0_RSV_MASK 0x7FFF
#define PMIC_RG_BM_TOP_CKSEL_CON0_RSV_SHIFT 1
#define PMIC_BM_TOP_CKSEL_CON0_SET_ADDR MT6356_BM_TOP_CKSEL_CON0_SET
#define PMIC_BM_TOP_CKSEL_CON0_SET_MASK 0xFFFF
#define PMIC_BM_TOP_CKSEL_CON0_SET_SHIFT 0
#define PMIC_BM_TOP_CKSEL_CON0_CLR_ADDR MT6356_BM_TOP_CKSEL_CON0_CLR
#define PMIC_BM_TOP_CKSEL_CON0_CLR_MASK 0xFFFF
#define PMIC_BM_TOP_CKSEL_CON0_CLR_SHIFT 0
#define PMIC_RG_BIF_X4_CK_DIVSEL_ADDR MT6356_BM_TOP_CKDIVSEL_CON0
#define PMIC_RG_BIF_X4_CK_DIVSEL_MASK 0x7
#define PMIC_RG_BIF_X4_CK_DIVSEL_SHIFT 0
#define PMIC_BM_TOP_CKDIVSEL_CON0_RSV_ADDR MT6356_BM_TOP_CKDIVSEL_CON0
#define PMIC_BM_TOP_CKDIVSEL_CON0_RSV_MASK 0x1FFF
#define PMIC_BM_TOP_CKDIVSEL_CON0_RSV_SHIFT 3
#define PMIC_BM_TOP_CKDIVSEL_CON0_SET_ADDR MT6356_BM_TOP_CKDIVSEL_CON0_SET
#define PMIC_BM_TOP_CKDIVSEL_CON0_SET_MASK 0xFFFF
#define PMIC_BM_TOP_CKDIVSEL_CON0_SET_SHIFT 0
#define PMIC_BM_TOP_CKDIVSEL_CON0_CLR_ADDR MT6356_BM_TOP_CKDIVSEL_CON0_CLR
#define PMIC_BM_TOP_CKDIVSEL_CON0_CLR_MASK 0xFFFF
#define PMIC_BM_TOP_CKDIVSEL_CON0_CLR_SHIFT 0
#define PMIC_RG_BIF_X4_CK_PDN_HWEN_ADDR MT6356_BM_TOP_CKHWEN_CON0
#define PMIC_RG_BIF_X4_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_BIF_X4_CK_PDN_HWEN_SHIFT 0
#define PMIC_RG_BIF_X104_CK_PDN_HWEN_ADDR MT6356_BM_TOP_CKHWEN_CON0
#define PMIC_RG_BIF_X104_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_BIF_X104_CK_PDN_HWEN_SHIFT 1
#define PMIC_BM_TOP_CKHWEN_CON0_RSV_ADDR MT6356_BM_TOP_CKHWEN_CON0
#define PMIC_BM_TOP_CKHWEN_CON0_RSV_MASK 0x3FFF
#define PMIC_BM_TOP_CKHWEN_CON0_RSV_SHIFT 2
#define PMIC_BM_TOP_CKHWEN_CON0_SET_ADDR MT6356_BM_TOP_CKHWEN_CON0_SET
#define PMIC_BM_TOP_CKHWEN_CON0_SET_MASK 0xFFFF
#define PMIC_BM_TOP_CKHWEN_CON0_SET_SHIFT 0
#define PMIC_BM_TOP_CKHWEN_CON0_CLR_ADDR MT6356_BM_TOP_CKHWEN_CON0_CLR
#define PMIC_BM_TOP_CKHWEN_CON0_CLR_MASK 0xFFFF
#define PMIC_BM_TOP_CKHWEN_CON0_CLR_SHIFT 0
#define PMIC_RG_FG_CK_TSTSEL_ADDR MT6356_BM_TOP_CKTST_CON0
#define PMIC_RG_FG_CK_TSTSEL_MASK 0x1
#define PMIC_RG_FG_CK_TSTSEL_SHIFT 0
#define PMIC_RG_FGADC_ANA_CK_TSTSEL_ADDR MT6356_BM_TOP_CKTST_CON0
#define PMIC_RG_FGADC_ANA_CK_TSTSEL_MASK 0x1
#define PMIC_RG_FGADC_ANA_CK_TSTSEL_SHIFT 1
#define PMIC_RG_FG_CK_TST_DIS_ADDR MT6356_BM_TOP_CKTST_CON0
#define PMIC_RG_FG_CK_TST_DIS_MASK 0x1
#define PMIC_RG_FG_CK_TST_DIS_SHIFT 2
#define PMIC_BM_TOP_CKTST_CON0_RSV_ADDR MT6356_BM_TOP_CKTST_CON0
#define PMIC_BM_TOP_CKTST_CON0_RSV_MASK 0x1FFF
#define PMIC_BM_TOP_CKTST_CON0_RSV_SHIFT 3
#define PMIC_RG_FGADC_SWRST_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_RG_FGADC_SWRST_MASK 0x1
#define PMIC_RG_FGADC_SWRST_SHIFT 0
#define PMIC_RG_BATON_SWRST_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_RG_BATON_SWRST_MASK 0x1
#define PMIC_RG_BATON_SWRST_SHIFT 1
#define PMIC_RG_BIF_SWRST_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_RG_BIF_SWRST_MASK 0x1
#define PMIC_RG_BIF_SWRST_SHIFT 2
#define PMIC_RG_SWRST_RSV_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_RG_SWRST_RSV_MASK 0x1
#define PMIC_RG_SWRST_RSV_SHIFT 3
#define PMIC_RG_BANK_FGADC_ANA_SWRST_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_RG_BANK_FGADC_ANA_SWRST_MASK 0x1
#define PMIC_RG_BANK_FGADC_ANA_SWRST_SHIFT 4
#define PMIC_RG_BANK_FGADC_SWRST_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_RG_BANK_FGADC_SWRST_MASK 0x1
#define PMIC_RG_BANK_FGADC_SWRST_SHIFT 5
#define PMIC_RG_BANK_BAT_ANA_SWRST_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_RG_BANK_BAT_ANA_SWRST_MASK 0x1
#define PMIC_RG_BANK_BAT_ANA_SWRST_SHIFT 6
#define PMIC_RG_BANK_BATON_SWRST_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_RG_BANK_BATON_SWRST_MASK 0x1
#define PMIC_RG_BANK_BATON_SWRST_SHIFT 7
#define PMIC_RG_BANK_BIF_SWRST_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_RG_BANK_BIF_SWRST_MASK 0x1
#define PMIC_RG_BANK_BIF_SWRST_SHIFT 8
#define PMIC_BM_TOP_RST_CON0_RSV_ADDR MT6356_BM_TOP_RST_CON0
#define PMIC_BM_TOP_RST_CON0_RSV_MASK 0x7F
#define PMIC_BM_TOP_RST_CON0_RSV_SHIFT 9
#define PMIC_BM_TOP_RST_CON0_SET_ADDR MT6356_BM_TOP_RST_CON0_SET
#define PMIC_BM_TOP_RST_CON0_SET_MASK 0xFFFF
#define PMIC_BM_TOP_RST_CON0_SET_SHIFT 0
#define PMIC_BM_TOP_RST_CON0_CLR_ADDR MT6356_BM_TOP_RST_CON0_CLR
#define PMIC_BM_TOP_RST_CON0_CLR_MASK 0xFFFF
#define PMIC_BM_TOP_RST_CON0_CLR_SHIFT 0
#define PMIC_RG_FGADC_RST_SRC_SEL_ADDR MT6356_BM_TOP_RST_CON1
#define PMIC_RG_FGADC_RST_SRC_SEL_MASK 0x1
#define PMIC_RG_FGADC_RST_SRC_SEL_SHIFT 0
#define PMIC_BM_TOP_RST_CON1_RSV_ADDR MT6356_BM_TOP_RST_CON1
#define PMIC_BM_TOP_RST_CON1_RSV_MASK 0x3
#define PMIC_BM_TOP_RST_CON1_RSV_SHIFT 1
#define PMIC_BM_TOP_RST_CON1_SET_ADDR MT6356_BM_TOP_RST_CON1_SET
#define PMIC_BM_TOP_RST_CON1_SET_MASK 0xFFFF
#define PMIC_BM_TOP_RST_CON1_SET_SHIFT 0
#define PMIC_BM_TOP_RST_CON1_CLR_ADDR MT6356_BM_TOP_RST_CON1_CLR
#define PMIC_BM_TOP_RST_CON1_CLR_MASK 0xFFFF
#define PMIC_BM_TOP_RST_CON1_CLR_SHIFT 0
#define PMIC_RG_INT_EN_FG_BAT0_H_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_BAT0_H_MASK 0x1
#define PMIC_RG_INT_EN_FG_BAT0_H_SHIFT 0
#define PMIC_RG_INT_EN_FG_BAT0_L_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_BAT0_L_MASK 0x1
#define PMIC_RG_INT_EN_FG_BAT0_L_SHIFT 1
#define PMIC_RG_INT_EN_FG_CUR_H_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_CUR_H_MASK 0x1
#define PMIC_RG_INT_EN_FG_CUR_H_SHIFT 2
#define PMIC_RG_INT_EN_FG_CUR_L_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_CUR_L_MASK 0x1
#define PMIC_RG_INT_EN_FG_CUR_L_SHIFT 3
#define PMIC_RG_INT_EN_FG_ZCV_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_ZCV_MASK 0x1
#define PMIC_RG_INT_EN_FG_ZCV_SHIFT 4
#define PMIC_RG_INT_EN_FG_BAT1_H_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_BAT1_H_MASK 0x1
#define PMIC_RG_INT_EN_FG_BAT1_H_SHIFT 5
#define PMIC_RG_INT_EN_FG_BAT1_L_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_BAT1_L_MASK 0x1
#define PMIC_RG_INT_EN_FG_BAT1_L_SHIFT 6
#define PMIC_RG_INT_EN_FG_N_CHARGE_L_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_N_CHARGE_L_MASK 0x1
#define PMIC_RG_INT_EN_FG_N_CHARGE_L_SHIFT 7
#define PMIC_RG_INT_EN_FG_IAVG_H_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_IAVG_H_MASK 0x1
#define PMIC_RG_INT_EN_FG_IAVG_H_SHIFT 8
#define PMIC_RG_INT_EN_FG_IAVG_L_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_IAVG_L_MASK 0x1
#define PMIC_RG_INT_EN_FG_IAVG_L_SHIFT 9
#define PMIC_RG_INT_EN_FG_TIME_H_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_TIME_H_MASK 0x1
#define PMIC_RG_INT_EN_FG_TIME_H_SHIFT 10
#define PMIC_RG_INT_EN_FG_DISCHARGE_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_DISCHARGE_MASK 0x1
#define PMIC_RG_INT_EN_FG_DISCHARGE_SHIFT 11
#define PMIC_RG_INT_EN_FG_CHARGE_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_INT_EN_FG_CHARGE_MASK 0x1
#define PMIC_RG_INT_EN_FG_CHARGE_SHIFT 12
#define PMIC_RG_BM_INT_EN_CON0_RSV_ADDR MT6356_BM_TOP_INT_CON0
#define PMIC_RG_BM_INT_EN_CON0_RSV_MASK 0x7
#define PMIC_RG_BM_INT_EN_CON0_RSV_SHIFT 13
#define PMIC_INT_CON0_SET_ADDR MT6356_BM_TOP_INT_CON0_SET
#define PMIC_INT_CON0_SET_MASK 0xFFFF
#define PMIC_INT_CON0_SET_SHIFT 0
#define PMIC_INT_CON0_CLR_ADDR MT6356_BM_TOP_INT_CON0_CLR
#define PMIC_INT_CON0_CLR_MASK 0xFFFF
#define PMIC_INT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_EN_BATON_LV_ADDR MT6356_BM_TOP_INT_CON1
#define PMIC_RG_INT_EN_BATON_LV_MASK 0x1
#define PMIC_RG_INT_EN_BATON_LV_SHIFT 0
#define PMIC_RG_INT_EN_BATON_BAT_IN_ADDR MT6356_BM_TOP_INT_CON1
#define PMIC_RG_INT_EN_BATON_BAT_IN_MASK 0x1
#define PMIC_RG_INT_EN_BATON_BAT_IN_SHIFT 1
#define PMIC_RG_INT_EN_BATON_BAT_OUT_ADDR MT6356_BM_TOP_INT_CON1
#define PMIC_RG_INT_EN_BATON_BAT_OUT_MASK 0x1
#define PMIC_RG_INT_EN_BATON_BAT_OUT_SHIFT 2
#define PMIC_RG_INT_EN_BIF_ADDR MT6356_BM_TOP_INT_CON1
#define PMIC_RG_INT_EN_BIF_MASK 0x1
#define PMIC_RG_INT_EN_BIF_SHIFT 3
#define PMIC_INT_CON1_SET_ADDR MT6356_BM_TOP_INT_CON1_SET
#define PMIC_INT_CON1_SET_MASK 0xFFFF
#define PMIC_INT_CON1_SET_SHIFT 0
#define PMIC_INT_CON1_CLR_ADDR MT6356_BM_TOP_INT_CON1_CLR
#define PMIC_INT_CON1_CLR_MASK 0xFFFF
#define PMIC_INT_CON1_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_FG_BAT0_H_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_BAT0_H_MASK 0x1
#define PMIC_RG_INT_MASK_FG_BAT0_H_SHIFT 0
#define PMIC_RG_INT_MASK_FG_BAT0_L_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_BAT0_L_MASK 0x1
#define PMIC_RG_INT_MASK_FG_BAT0_L_SHIFT 1
#define PMIC_RG_INT_MASK_FG_CUR_H_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_CUR_H_MASK 0x1
#define PMIC_RG_INT_MASK_FG_CUR_H_SHIFT 2
#define PMIC_RG_INT_MASK_FG_CUR_L_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_CUR_L_MASK 0x1
#define PMIC_RG_INT_MASK_FG_CUR_L_SHIFT 3
#define PMIC_RG_INT_MASK_FG_ZCV_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_ZCV_MASK 0x1
#define PMIC_RG_INT_MASK_FG_ZCV_SHIFT 4
#define PMIC_RG_INT_MASK_FG_BAT1_H_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_BAT1_H_MASK 0x1
#define PMIC_RG_INT_MASK_FG_BAT1_H_SHIFT 5
#define PMIC_RG_INT_MASK_FG_BAT1_L_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_BAT1_L_MASK 0x1
#define PMIC_RG_INT_MASK_FG_BAT1_L_SHIFT 6
#define PMIC_RG_INT_MASK_FG_N_CHARGE_L_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_N_CHARGE_L_MASK 0x1
#define PMIC_RG_INT_MASK_FG_N_CHARGE_L_SHIFT 7
#define PMIC_RG_INT_MASK_FG_IAVG_H_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_IAVG_H_MASK 0x1
#define PMIC_RG_INT_MASK_FG_IAVG_H_SHIFT 8
#define PMIC_RG_INT_MASK_FG_IAVG_L_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_IAVG_L_MASK 0x1
#define PMIC_RG_INT_MASK_FG_IAVG_L_SHIFT 9
#define PMIC_RG_INT_MASK_FG_TIME_H_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_TIME_H_MASK 0x1
#define PMIC_RG_INT_MASK_FG_TIME_H_SHIFT 10
#define PMIC_RG_INT_MASK_FG_DISCHARGE_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_DISCHARGE_MASK 0x1
#define PMIC_RG_INT_MASK_FG_DISCHARGE_SHIFT 11
#define PMIC_RG_INT_MASK_FG_CHARGE_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_FG_CHARGE_MASK 0x1
#define PMIC_RG_INT_MASK_FG_CHARGE_SHIFT 12
#define PMIC_RG_BM_INT_MASK_CON0_RSV_ADDR MT6356_BM_TOP_INT_MASK_CON0
#define PMIC_RG_BM_INT_MASK_CON0_RSV_MASK 0x7
#define PMIC_RG_BM_INT_MASK_CON0_RSV_SHIFT 13
#define PMIC_INT_MASK_CON0_SET_ADDR MT6356_BM_TOP_INT_MASK_CON0_SET
#define PMIC_INT_MASK_CON0_SET_MASK 0xFFFF
#define PMIC_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_INT_MASK_CON0_CLR_ADDR MT6356_BM_TOP_INT_MASK_CON0_CLR
#define PMIC_INT_MASK_CON0_CLR_MASK 0xFFFF
#define PMIC_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_BATON_LV_ADDR MT6356_BM_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_BATON_LV_MASK 0x1
#define PMIC_RG_INT_MASK_BATON_LV_SHIFT 0
#define PMIC_RG_INT_MASK_BATON_BAT_IN_ADDR MT6356_BM_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_BATON_BAT_IN_MASK 0x1
#define PMIC_RG_INT_MASK_BATON_BAT_IN_SHIFT 1
#define PMIC_RG_INT_MASK_BATON_BAT_OUT_ADDR MT6356_BM_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_BATON_BAT_OUT_MASK 0x1
#define PMIC_RG_INT_MASK_BATON_BAT_OUT_SHIFT 2
#define PMIC_RG_INT_MASK_BIF_ADDR MT6356_BM_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_BIF_MASK 0x1
#define PMIC_RG_INT_MASK_BIF_SHIFT 3
#define PMIC_INT_MASK_CON1_SET_ADDR MT6356_BM_TOP_INT_MASK_CON1_SET
#define PMIC_INT_MASK_CON1_SET_MASK 0xFFFF
#define PMIC_INT_MASK_CON1_SET_SHIFT 0
#define PMIC_INT_MASK_CON1_CLR_ADDR MT6356_BM_TOP_INT_MASK_CON1_CLR
#define PMIC_INT_MASK_CON1_CLR_MASK 0xFFFF
#define PMIC_INT_MASK_CON1_CLR_SHIFT 0
#define PMIC_RG_INT_STATUS_FG_BAT0_H_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_BAT0_H_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_BAT0_H_SHIFT 0
#define PMIC_RG_INT_STATUS_FG_BAT0_L_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_BAT0_L_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_BAT0_L_SHIFT 1
#define PMIC_RG_INT_STATUS_FG_CUR_H_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_CUR_H_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_CUR_H_SHIFT 2
#define PMIC_RG_INT_STATUS_FG_CUR_L_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_CUR_L_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_CUR_L_SHIFT 3
#define PMIC_RG_INT_STATUS_FG_ZCV_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_ZCV_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_ZCV_SHIFT 4
#define PMIC_RG_INT_STATUS_FG_BAT1_H_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_BAT1_H_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_BAT1_H_SHIFT 5
#define PMIC_RG_INT_STATUS_FG_BAT1_L_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_BAT1_L_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_BAT1_L_SHIFT 6
#define PMIC_RG_INT_STATUS_FG_N_CHARGE_L_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_N_CHARGE_L_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_N_CHARGE_L_SHIFT 7
#define PMIC_RG_INT_STATUS_FG_IAVG_H_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_IAVG_H_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_IAVG_H_SHIFT 8
#define PMIC_RG_INT_STATUS_FG_IAVG_L_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_IAVG_L_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_IAVG_L_SHIFT 9
#define PMIC_RG_INT_STATUS_FG_TIME_H_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_TIME_H_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_TIME_H_SHIFT 10
#define PMIC_RG_INT_STATUS_FG_DISCHARGE_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_DISCHARGE_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_DISCHARGE_SHIFT 11
#define PMIC_RG_INT_STATUS_FG_CHARGE_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_FG_CHARGE_MASK 0x1
#define PMIC_RG_INT_STATUS_FG_CHARGE_SHIFT 12
#define PMIC_RG_BM_INT_STATUS0_RSV_ADDR MT6356_BM_TOP_INT_STATUS0
#define PMIC_RG_BM_INT_STATUS0_RSV_MASK 0x7
#define PMIC_RG_BM_INT_STATUS0_RSV_SHIFT 13
#define PMIC_RG_INT_STATUS_BATON_LV_ADDR MT6356_BM_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_BATON_LV_MASK 0x1
#define PMIC_RG_INT_STATUS_BATON_LV_SHIFT 0
#define PMIC_RG_INT_STATUS_BATON_BAT_IN_ADDR MT6356_BM_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_BATON_BAT_IN_MASK 0x1
#define PMIC_RG_INT_STATUS_BATON_BAT_IN_SHIFT 1
#define PMIC_RG_INT_STATUS_BATON_BAT_OUT_ADDR MT6356_BM_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_BATON_BAT_OUT_MASK 0x1
#define PMIC_RG_INT_STATUS_BATON_BAT_OUT_SHIFT 2
#define PMIC_RG_INT_STATUS_BIF_ADDR MT6356_BM_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_BIF_MASK 0x1
#define PMIC_RG_INT_STATUS_BIF_SHIFT 3
#define PMIC_RG_INT_RAW_STATUS_FG_BAT0_H_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_BAT0_H_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_BAT0_H_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_FG_BAT0_L_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_BAT0_L_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_BAT0_L_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_FG_CUR_H_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_CUR_H_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_CUR_H_SHIFT 2
#define PMIC_RG_INT_RAW_STATUS_FG_CUR_L_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_CUR_L_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_CUR_L_SHIFT 3
#define PMIC_RG_INT_RAW_STATUS_FG_ZCV_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_ZCV_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_ZCV_SHIFT 4
#define PMIC_RG_INT_RAW_STATUS_FG_BAT1_H_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_BAT1_H_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_BAT1_H_SHIFT 5
#define PMIC_RG_INT_RAW_STATUS_FG_BAT1_L_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_BAT1_L_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_BAT1_L_SHIFT 6
#define PMIC_RG_INT_RAW_STATUS_FG_N_CHARGE_L_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_N_CHARGE_L_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_N_CHARGE_L_SHIFT 7
#define PMIC_RG_INT_RAW_STATUS_FG_IAVG_H_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_IAVG_H_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_IAVG_H_SHIFT 8
#define PMIC_RG_INT_RAW_STATUS_FG_IAVG_L_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_IAVG_L_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_IAVG_L_SHIFT 9
#define PMIC_RG_INT_RAW_STATUS_FG_TIME_H_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_TIME_H_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_TIME_H_SHIFT 10
#define PMIC_RG_INT_RAW_STATUS_FG_DISCHARGE_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_DISCHARGE_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_DISCHARGE_SHIFT 11
#define PMIC_RG_INT_RAW_STATUS_FG_CHARGE_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_FG_CHARGE_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_FG_CHARGE_SHIFT 12
#define PMIC_RG_BM_INT_RAW_STATUS_RSV_ADDR MT6356_BM_TOP_INT_RAW_STATUS0
#define PMIC_RG_BM_INT_RAW_STATUS_RSV_MASK 0x7
#define PMIC_RG_BM_INT_RAW_STATUS_RSV_SHIFT 13
#define PMIC_RG_INT_RAW_STATUS_BATON_LV_ADDR MT6356_BM_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_BATON_LV_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BATON_LV_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_BATON_BAT_IN_ADDR MT6356_BM_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_BATON_BAT_IN_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BATON_BAT_IN_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_BATON_BAT_OUT_ADDR MT6356_BM_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_BATON_BAT_OUT_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BATON_BAT_OUT_SHIFT 2
#define PMIC_RG_INT_RAW_STATUS_BIF_ADDR MT6356_BM_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_BIF_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BIF_SHIFT 3
#define PMIC_POLARITY_ADDR MT6356_BM_TOP_INT_MISC_CON
#define PMIC_POLARITY_MASK 0x1
#define PMIC_POLARITY_SHIFT 0
#define PMIC_BM_INT_MISC_CON_RSV_ADDR MT6356_BM_TOP_INT_MISC_CON
#define PMIC_BM_INT_MISC_CON_RSV_MASK 0x7F
#define PMIC_BM_INT_MISC_CON_RSV_SHIFT 1
#define PMIC_RG_BM_MON_FLAG_SEL_ADDR MT6356_BM_TOP_DBG_CON
#define PMIC_RG_BM_MON_FLAG_SEL_MASK 0xFF
#define PMIC_RG_BM_MON_FLAG_SEL_SHIFT 0
#define PMIC_RG_BM_MON_GRP_SEL_ADDR MT6356_BM_TOP_DBG_CON
#define PMIC_RG_BM_MON_GRP_SEL_MASK 0x1F
#define PMIC_RG_BM_MON_GRP_SEL_SHIFT 8
#define PMIC_RG_BM_TOP_RSV0_ADDR MT6356_BM_TOP_RSV0
#define PMIC_RG_BM_TOP_RSV0_MASK 0xFFFF
#define PMIC_RG_BM_TOP_RSV0_SHIFT 0
#define PMIC_RG_BM_TOP_RSV1_ADDR MT6356_BM_TOP_RSV1
#define PMIC_RG_BM_TOP_RSV1_MASK 0xFFFF
#define PMIC_RG_BM_TOP_RSV1_SHIFT 0
#define PMIC_RG_BM_TOP_RSV2_ADDR MT6356_BM_TOP_RSV2
#define PMIC_RG_BM_TOP_RSV2_MASK 0xFFFF
#define PMIC_RG_BM_TOP_RSV2_SHIFT 0
#define PMIC_RG_BM_TOP_RSV3_ADDR MT6356_BM_TOP_RSV3
#define PMIC_RG_BM_TOP_RSV3_MASK 0xFFFF
#define PMIC_RG_BM_TOP_RSV3_SHIFT 0
#define PMIC_BM_TOP_ELR_LEN_ADDR MT6356_BM_TOP_ELR_NUM
#define PMIC_BM_TOP_ELR_LEN_MASK 0xFF
#define PMIC_BM_TOP_ELR_LEN_SHIFT 0
#define PMIC_BM_TOP_ELR0_RSV_ADDR MT6356_BM_TOP_ELR0
#define PMIC_BM_TOP_ELR0_RSV_MASK 0xFFFF
#define PMIC_BM_TOP_ELR0_RSV_SHIFT 0
#define PMIC_FGADC_ANA_ANA_ID_ADDR MT6356_FGADC_ANA_DSN_ID
#define PMIC_FGADC_ANA_ANA_ID_MASK 0xFF
#define PMIC_FGADC_ANA_ANA_ID_SHIFT 0
#define PMIC_FGADC_ANA_DIG_ID_ADDR MT6356_FGADC_ANA_DSN_ID
#define PMIC_FGADC_ANA_DIG_ID_MASK 0xFF
#define PMIC_FGADC_ANA_DIG_ID_SHIFT 8
#define PMIC_FGADC_ANA_ANA_MINOR_REV_ADDR MT6356_FGADC_ANA_DSN_REV0
#define PMIC_FGADC_ANA_ANA_MINOR_REV_MASK 0xF
#define PMIC_FGADC_ANA_ANA_MINOR_REV_SHIFT 0
#define PMIC_FGADC_ANA_ANA_MAJOR_REV_ADDR MT6356_FGADC_ANA_DSN_REV0
#define PMIC_FGADC_ANA_ANA_MAJOR_REV_MASK 0xF
#define PMIC_FGADC_ANA_ANA_MAJOR_REV_SHIFT 4
#define PMIC_FGADC_ANA_DIG_MINOR_REV_ADDR MT6356_FGADC_ANA_DSN_REV0
#define PMIC_FGADC_ANA_DIG_MINOR_REV_MASK 0xF
#define PMIC_FGADC_ANA_DIG_MINOR_REV_SHIFT 8
#define PMIC_FGADC_ANA_DIG_MAJOR_REV_ADDR MT6356_FGADC_ANA_DSN_REV0
#define PMIC_FGADC_ANA_DIG_MAJOR_REV_MASK 0xF
#define PMIC_FGADC_ANA_DIG_MAJOR_REV_SHIFT 12
#define PMIC_FGADC_ANA_SW_MINOR_REV_ADDR MT6356_FGADC_ANA_DSN_REV1
#define PMIC_FGADC_ANA_SW_MINOR_REV_MASK 0xF
#define PMIC_FGADC_ANA_SW_MINOR_REV_SHIFT 0
#define PMIC_FGADC_ANA_SW_MAJOR_REV_ADDR MT6356_FGADC_ANA_DSN_REV1
#define PMIC_FGADC_ANA_SW_MAJOR_REV_MASK 0xF
#define PMIC_FGADC_ANA_SW_MAJOR_REV_SHIFT 4
#define PMIC_FGADC_ANA_ESP_ADDR MT6356_FGADC_ANA_DSN_REV1
#define PMIC_FGADC_ANA_ESP_MASK 0xFF
#define PMIC_FGADC_ANA_ESP_SHIFT 8
#define PMIC_RG_FGANALOGTEST_3_1_ADDR MT6356_FGADC_ANA_CON0
#define PMIC_RG_FGANALOGTEST_3_1_MASK 0x7
#define PMIC_RG_FGANALOGTEST_3_1_SHIFT 1
#define PMIC_RG_FGINTMODE_ADDR MT6356_FGADC_ANA_CON0
#define PMIC_RG_FGINTMODE_MASK 0x1
#define PMIC_RG_FGINTMODE_SHIFT 4
#define PMIC_RG_SPARE_ADDR MT6356_FGADC_ANA_CON0
#define PMIC_RG_SPARE_MASK 0xFF
#define PMIC_RG_SPARE_SHIFT 5
#define PMIC_FGADC_ANA_TEST_CON0_RSV_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FGADC_ANA_TEST_CON0_RSV_MASK 0xF
#define PMIC_FGADC_ANA_TEST_CON0_RSV_SHIFT 0
#define PMIC_FG_RNG_BIT_MODE_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FG_RNG_BIT_MODE_MASK 0x1
#define PMIC_FG_RNG_BIT_MODE_SHIFT 4
#define PMIC_FG_RNG_BIT_SW_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FG_RNG_BIT_SW_MASK 0x1
#define PMIC_FG_RNG_BIT_SW_SHIFT 5
#define PMIC_FG_RNG_EN_MODE_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FG_RNG_EN_MODE_MASK 0x1
#define PMIC_FG_RNG_EN_MODE_SHIFT 6
#define PMIC_FG_RNG_EN_SW_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FG_RNG_EN_SW_MASK 0x1
#define PMIC_FG_RNG_EN_SW_SHIFT 7
#define PMIC_FG_DWA_T0_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FG_DWA_T0_MASK 0x3
#define PMIC_FG_DWA_T0_SHIFT 8
#define PMIC_FG_DWA_T1_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FG_DWA_T1_MASK 0x3
#define PMIC_FG_DWA_T1_SHIFT 10
#define PMIC_FG_DWA_RST_MODE_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FG_DWA_RST_MODE_MASK 0x1
#define PMIC_FG_DWA_RST_MODE_SHIFT 12
#define PMIC_FG_DWA_RST_SW_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FG_DWA_RST_SW_MASK 0x1
#define PMIC_FG_DWA_RST_SW_SHIFT 13
#define PMIC_FG_DWA_RST_ADDR MT6356_FGADC_ANA_TEST_CON0
#define PMIC_FG_DWA_RST_MASK 0x1
#define PMIC_FG_DWA_RST_SHIFT 15
#define PMIC_FGADC_ANA_ELR_LEN_ADDR MT6356_FGADC_ANA_ELR_NUM
#define PMIC_FGADC_ANA_ELR_LEN_MASK 0xFF
#define PMIC_FGADC_ANA_ELR_LEN_SHIFT 0
#define PMIC_RG_FGADC_GAINERROR_CAL_ADDR MT6356_FGADC_ANA_ELR0
#define PMIC_RG_FGADC_GAINERROR_CAL_MASK 0x1FFF
#define PMIC_RG_FGADC_GAINERROR_CAL_SHIFT 0
#define PMIC_RG_FG_OFFSET_SWAP_ADDR MT6356_FGADC_ANA_ELR1
#define PMIC_RG_FG_OFFSET_SWAP_MASK 0x7
#define PMIC_RG_FG_OFFSET_SWAP_SHIFT 0
#define PMIC_FGADC_ANA_ID_ADDR MT6356_FGADC_DSN_ID
#define PMIC_FGADC_ANA_ID_MASK 0xFF
#define PMIC_FGADC_ANA_ID_SHIFT 0
#define PMIC_FGADC_DIG_ID_ADDR MT6356_FGADC_DSN_ID
#define PMIC_FGADC_DIG_ID_MASK 0xFF
#define PMIC_FGADC_DIG_ID_SHIFT 8
#define PMIC_FGADC_ANA_MINOR_REV_ADDR MT6356_FGADC_DSN_REV0
#define PMIC_FGADC_ANA_MINOR_REV_MASK 0xF
#define PMIC_FGADC_ANA_MINOR_REV_SHIFT 0
#define PMIC_FGADC_ANA_MAJOR_REV_ADDR MT6356_FGADC_DSN_REV0
#define PMIC_FGADC_ANA_MAJOR_REV_MASK 0xF
#define PMIC_FGADC_ANA_MAJOR_REV_SHIFT 4
#define PMIC_FGADC_DIG_MINOR_REV_ADDR MT6356_FGADC_DSN_REV0
#define PMIC_FGADC_DIG_MINOR_REV_MASK 0xF
#define PMIC_FGADC_DIG_MINOR_REV_SHIFT 8
#define PMIC_FGADC_DIG_MAJOR_REV_ADDR MT6356_FGADC_DSN_REV0
#define PMIC_FGADC_DIG_MAJOR_REV_MASK 0xF
#define PMIC_FGADC_DIG_MAJOR_REV_SHIFT 12
#define PMIC_FGADC_SW_MINOR_REV_ADDR MT6356_FGADC_DSN_REV1
#define PMIC_FGADC_SW_MINOR_REV_MASK 0xF
#define PMIC_FGADC_SW_MINOR_REV_SHIFT 0
#define PMIC_FGADC_SW_MAJOR_REV_ADDR MT6356_FGADC_DSN_REV1
#define PMIC_FGADC_SW_MAJOR_REV_MASK 0xF
#define PMIC_FGADC_SW_MAJOR_REV_SHIFT 4
#define PMIC_FGADC_ESP_ADDR MT6356_FGADC_DSN_REV1
#define PMIC_FGADC_ESP_MASK 0xFF
#define PMIC_FGADC_ESP_SHIFT 8
#define PMIC_FG_ON_ADDR MT6356_FGADC_CON0
#define PMIC_FG_ON_MASK 0x1
#define PMIC_FG_ON_SHIFT 0
#define PMIC_FG_CAL_ADDR MT6356_FGADC_CON0
#define PMIC_FG_CAL_MASK 0x3
#define PMIC_FG_CAL_SHIFT 2
#define PMIC_FG_AUTOCALRATE_ADDR MT6356_FGADC_CON0
#define PMIC_FG_AUTOCALRATE_MASK 0x7
#define PMIC_FG_AUTOCALRATE_SHIFT 4
#define PMIC_FG_SON_SLP_EN_ADDR MT6356_FGADC_CON0
#define PMIC_FG_SON_SLP_EN_MASK 0x1
#define PMIC_FG_SON_SLP_EN_SHIFT 8
#define PMIC_FG_SOFF_SLP_EN_ADDR MT6356_FGADC_CON0
#define PMIC_FG_SOFF_SLP_EN_MASK 0x1
#define PMIC_FG_SOFF_SLP_EN_SHIFT 9
#define PMIC_FG_ZCV_DET_EN_ADDR MT6356_FGADC_CON0
#define PMIC_FG_ZCV_DET_EN_MASK 0x1
#define PMIC_FG_ZCV_DET_EN_SHIFT 10
#define PMIC_FG_AUXADC_R_ADDR MT6356_FGADC_CON0
#define PMIC_FG_AUXADC_R_MASK 0x1
#define PMIC_FG_AUXADC_R_SHIFT 11
#define PMIC_FG_IAVG_MODE_ADDR MT6356_FGADC_CON0
#define PMIC_FG_IAVG_MODE_MASK 0xF
#define PMIC_FG_IAVG_MODE_SHIFT 12
#define PMIC_FG_SW_READ_PRE_ADDR MT6356_FGADC_CON1
#define PMIC_FG_SW_READ_PRE_MASK 0x1
#define PMIC_FG_SW_READ_PRE_SHIFT 0
#define PMIC_FG_SW_RSTCLR_ADDR MT6356_FGADC_CON1
#define PMIC_FG_SW_RSTCLR_MASK 0x1
#define PMIC_FG_SW_RSTCLR_SHIFT 1
#define PMIC_FG_SW_CR_ADDR MT6356_FGADC_CON1
#define PMIC_FG_SW_CR_MASK 0x1
#define PMIC_FG_SW_CR_SHIFT 2
#define PMIC_FG_SW_CLEAR_ADDR MT6356_FGADC_CON1
#define PMIC_FG_SW_CLEAR_MASK 0x1
#define PMIC_FG_SW_CLEAR_SHIFT 3
#define PMIC_FG_OFFSET_RST_ADDR MT6356_FGADC_CON1
#define PMIC_FG_OFFSET_RST_MASK 0x1
#define PMIC_FG_OFFSET_RST_SHIFT 8
#define PMIC_FG_TIME_RST_ADDR MT6356_FGADC_CON1
#define PMIC_FG_TIME_RST_MASK 0x1
#define PMIC_FG_TIME_RST_SHIFT 9
#define PMIC_FG_CHARGE_RST_ADDR MT6356_FGADC_CON1
#define PMIC_FG_CHARGE_RST_MASK 0x1
#define PMIC_FG_CHARGE_RST_SHIFT 10
#define PMIC_FG_N_CHARGE_RST_ADDR MT6356_FGADC_CON1
#define PMIC_FG_N_CHARGE_RST_MASK 0x1
#define PMIC_FG_N_CHARGE_RST_SHIFT 11
#define PMIC_FG_SOFF_RST_ADDR MT6356_FGADC_CON1
#define PMIC_FG_SOFF_RST_MASK 0x1
#define PMIC_FG_SOFF_RST_SHIFT 12
#define PMIC_FG_LATCHDATA_ST_ADDR MT6356_FGADC_CON1
#define PMIC_FG_LATCHDATA_ST_MASK 0x1
#define PMIC_FG_LATCHDATA_ST_SHIFT 15
#define PMIC_EVENT_FG_BAT0_L_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_BAT0_L_MASK 0x1
#define PMIC_EVENT_FG_BAT0_L_SHIFT 0
#define PMIC_EVENT_FG_BAT0_H_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_BAT0_H_MASK 0x1
#define PMIC_EVENT_FG_BAT0_H_SHIFT 1
#define PMIC_EVENT_FG_BAT1_L_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_BAT1_L_MASK 0x1
#define PMIC_EVENT_FG_BAT1_L_SHIFT 2
#define PMIC_EVENT_FG_BAT1_H_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_BAT1_H_MASK 0x1
#define PMIC_EVENT_FG_BAT1_H_SHIFT 3
#define PMIC_EVENT_FG_CUR_L_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_CUR_L_MASK 0x1
#define PMIC_EVENT_FG_CUR_L_SHIFT 4
#define PMIC_EVENT_FG_CUR_H_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_CUR_H_MASK 0x1
#define PMIC_EVENT_FG_CUR_H_SHIFT 5
#define PMIC_EVENT_FG_IAVG_L_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_IAVG_L_MASK 0x1
#define PMIC_EVENT_FG_IAVG_L_SHIFT 6
#define PMIC_EVENT_FG_IAVG_H_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_IAVG_H_MASK 0x1
#define PMIC_EVENT_FG_IAVG_H_SHIFT 7
#define PMIC_EVENT_FG_N_CHARGE_L_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_N_CHARGE_L_MASK 0x1
#define PMIC_EVENT_FG_N_CHARGE_L_SHIFT 8
#define PMIC_EVENT_FG_TIME_H_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_TIME_H_MASK 0x1
#define PMIC_EVENT_FG_TIME_H_SHIFT 11
#define PMIC_EVENT_FG_DISCHARGE_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_DISCHARGE_MASK 0x1
#define PMIC_EVENT_FG_DISCHARGE_SHIFT 12
#define PMIC_EVENT_FG_CHARGE_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_CHARGE_MASK 0x1
#define PMIC_EVENT_FG_CHARGE_SHIFT 13
#define PMIC_EVENT_FG_ZCV_ADDR MT6356_FGADC_CON2
#define PMIC_EVENT_FG_ZCV_MASK 0x1
#define PMIC_EVENT_FG_ZCV_SHIFT 14
#define PMIC_FG_OSR1_ADDR MT6356_FGADC_CON3
#define PMIC_FG_OSR1_MASK 0xF
#define PMIC_FG_OSR1_SHIFT 0
#define PMIC_FG_OSR2_ADDR MT6356_FGADC_CON3
#define PMIC_FG_OSR2_MASK 0x3
#define PMIC_FG_OSR2_SHIFT 8
#define PMIC_FG_FIR1BYPASS_ADDR MT6356_FGADC_CON4
#define PMIC_FG_FIR1BYPASS_MASK 0x1
#define PMIC_FG_FIR1BYPASS_SHIFT 0
#define PMIC_FG_FIR2BYPASS_ADDR MT6356_FGADC_CON4
#define PMIC_FG_FIR2BYPASS_MASK 0x1
#define PMIC_FG_FIR2BYPASS_SHIFT 1
#define PMIC_FG_ADJ_OFFSET_EN_ADDR MT6356_FGADC_CON4
#define PMIC_FG_ADJ_OFFSET_EN_MASK 0x1
#define PMIC_FG_ADJ_OFFSET_EN_SHIFT 2
#define PMIC_FG_ADC_AUTORST_ADDR MT6356_FGADC_CON4
#define PMIC_FG_ADC_AUTORST_MASK 0x1
#define PMIC_FG_ADC_AUTORST_SHIFT 3
#define PMIC_FG_ADC_RSTDETECT_ADDR MT6356_FGADC_CON4
#define PMIC_FG_ADC_RSTDETECT_MASK 0x1
#define PMIC_FG_ADC_RSTDETECT_SHIFT 4
#define PMIC_FG_VA18_AON_ADDR MT6356_FGADC_CON4
#define PMIC_FG_VA18_AON_MASK 0x1
#define PMIC_FG_VA18_AON_SHIFT 5
#define PMIC_FG_VA18_AOFF_ADDR MT6356_FGADC_CON4
#define PMIC_FG_VA18_AOFF_MASK 0x1
#define PMIC_FG_VA18_AOFF_SHIFT 6
#define PMIC_FG_SON_SW_ADDR MT6356_FGADC_CON4
#define PMIC_FG_SON_SW_MASK 0x1
#define PMIC_FG_SON_SW_SHIFT 7
#define PMIC_FG_SON_SW_MODE_ADDR MT6356_FGADC_CON4
#define PMIC_FG_SON_SW_MODE_MASK 0x1
#define PMIC_FG_SON_SW_MODE_SHIFT 8
#define PMIC_FGADC_CON4_RSV_ADDR MT6356_FGADC_CON4
#define PMIC_FGADC_CON4_RSV_MASK 0x7F
#define PMIC_FGADC_CON4_RSV_SHIFT 9
#define PMIC_FG_RSTB_STATUS_ADDR MT6356_FGADC_RST_CON0
#define PMIC_FG_RSTB_STATUS_MASK 0x1
#define PMIC_FG_RSTB_STATUS_SHIFT 0
#define PMIC_FG_R_CURR_ADDR MT6356_FGADC_R_CON0
#define PMIC_FG_R_CURR_MASK 0xFFFF
#define PMIC_FG_R_CURR_SHIFT 0
#define PMIC_FG_CURRENT_OUT_ADDR MT6356_FGADC_CUR_CON0
#define PMIC_FG_CURRENT_OUT_MASK 0xFFFF
#define PMIC_FG_CURRENT_OUT_SHIFT 0
#define PMIC_FG_CUR_LTH_ADDR MT6356_FGADC_CUR_CON1
#define PMIC_FG_CUR_LTH_MASK 0xFFFF
#define PMIC_FG_CUR_LTH_SHIFT 0
#define PMIC_FG_CUR_HTH_ADDR MT6356_FGADC_CUR_CON2
#define PMIC_FG_CUR_HTH_MASK 0xFFFF
#define PMIC_FG_CUR_HTH_SHIFT 0
#define PMIC_FG_CIC2_ADDR MT6356_FGADC_CUR_CON3
#define PMIC_FG_CIC2_MASK 0xFFFF
#define PMIC_FG_CIC2_SHIFT 0
#define PMIC_FG_CAR_31_16_ADDR MT6356_FGADC_CAR_CON0
#define PMIC_FG_CAR_31_16_MASK 0xFFFF
#define PMIC_FG_CAR_31_16_SHIFT 0
#define PMIC_FG_CAR_15_00_ADDR MT6356_FGADC_CAR_CON1
#define PMIC_FG_CAR_15_00_MASK 0xFFFF
#define PMIC_FG_CAR_15_00_SHIFT 0
#define PMIC_FG_BAT0_LTH_31_16_ADDR MT6356_FGADC_CAR_CON2
#define PMIC_FG_BAT0_LTH_31_16_MASK 0xFFFF
#define PMIC_FG_BAT0_LTH_31_16_SHIFT 0
#define PMIC_FG_BAT0_LTH_15_14_ADDR MT6356_FGADC_CAR_CON3
#define PMIC_FG_BAT0_LTH_15_14_MASK 0x3
#define PMIC_FG_BAT0_LTH_15_14_SHIFT 14
#define PMIC_FG_BAT0_HTH_31_16_ADDR MT6356_FGADC_CAR_CON4
#define PMIC_FG_BAT0_HTH_31_16_MASK 0xFFFF
#define PMIC_FG_BAT0_HTH_31_16_SHIFT 0
#define PMIC_FG_BAT0_HTH_15_14_ADDR MT6356_FGADC_CAR_CON5
#define PMIC_FG_BAT0_HTH_15_14_MASK 0x3
#define PMIC_FG_BAT0_HTH_15_14_SHIFT 14
#define PMIC_FG_BAT1_LTH_31_16_ADDR MT6356_FGADC_CAR_CON6
#define PMIC_FG_BAT1_LTH_31_16_MASK 0xFFFF
#define PMIC_FG_BAT1_LTH_31_16_SHIFT 0
#define PMIC_FG_BAT1_LTH_15_14_ADDR MT6356_FGADC_CAR_CON7
#define PMIC_FG_BAT1_LTH_15_14_MASK 0x3
#define PMIC_FG_BAT1_LTH_15_14_SHIFT 14
#define PMIC_FG_BAT1_HTH_31_16_ADDR MT6356_FGADC_CAR_CON8
#define PMIC_FG_BAT1_HTH_31_16_MASK 0xFFFF
#define PMIC_FG_BAT1_HTH_31_16_SHIFT 0
#define PMIC_FG_BAT1_HTH_15_14_ADDR MT6356_FGADC_CAR_CON9
#define PMIC_FG_BAT1_HTH_15_14_MASK 0x3
#define PMIC_FG_BAT1_HTH_15_14_SHIFT 14
#define PMIC_FG_NCAR_31_16_ADDR MT6356_FGADC_NCAR_CON0
#define PMIC_FG_NCAR_31_16_MASK 0xFFFF
#define PMIC_FG_NCAR_31_16_SHIFT 0
#define PMIC_FG_NCAR_15_00_ADDR MT6356_FGADC_NCAR_CON1
#define PMIC_FG_NCAR_15_00_MASK 0xFFFF
#define PMIC_FG_NCAR_15_00_SHIFT 0
#define PMIC_FG_N_CHARGE_LTH_31_16_ADDR MT6356_FGADC_NCAR_CON2
#define PMIC_FG_N_CHARGE_LTH_31_16_MASK 0xFFFF
#define PMIC_FG_N_CHARGE_LTH_31_16_SHIFT 0
#define PMIC_FG_N_CHARGE_LTH_15_14_ADDR MT6356_FGADC_NCAR_CON3
#define PMIC_FG_N_CHARGE_LTH_15_14_MASK 0x3
#define PMIC_FG_N_CHARGE_LTH_15_14_SHIFT 14
#define PMIC_FG_IAVG_27_16_ADDR MT6356_FGADC_IAVG_CON0
#define PMIC_FG_IAVG_27_16_MASK 0xFFF
#define PMIC_FG_IAVG_27_16_SHIFT 0
#define PMIC_FG_IAVG_VLD_ADDR MT6356_FGADC_IAVG_CON0
#define PMIC_FG_IAVG_VLD_MASK 0x1
#define PMIC_FG_IAVG_VLD_SHIFT 15
#define PMIC_FG_IAVG_15_00_ADDR MT6356_FGADC_IAVG_CON1
#define PMIC_FG_IAVG_15_00_MASK 0xFFFF
#define PMIC_FG_IAVG_15_00_SHIFT 0
#define PMIC_FG_IAVG_LTH_28_16_ADDR MT6356_FGADC_IAVG_CON2
#define PMIC_FG_IAVG_LTH_28_16_MASK 0x1FFF
#define PMIC_FG_IAVG_LTH_28_16_SHIFT 0
#define PMIC_FG_IAVG_LTH_15_00_ADDR MT6356_FGADC_IAVG_CON3
#define PMIC_FG_IAVG_LTH_15_00_MASK 0xFFFF
#define PMIC_FG_IAVG_LTH_15_00_SHIFT 0
#define PMIC_FG_IAVG_HTH_28_16_ADDR MT6356_FGADC_IAVG_CON4
#define PMIC_FG_IAVG_HTH_28_16_MASK 0x1FFF
#define PMIC_FG_IAVG_HTH_28_16_SHIFT 0
#define PMIC_FG_IAVG_HTH_15_00_ADDR MT6356_FGADC_IAVG_CON5
#define PMIC_FG_IAVG_HTH_15_00_MASK 0xFFFF
#define PMIC_FG_IAVG_HTH_15_00_SHIFT 0
#define PMIC_FG_NTER_29_16_ADDR MT6356_FGADC_NTER_CON0
#define PMIC_FG_NTER_29_16_MASK 0x3FFF
#define PMIC_FG_NTER_29_16_SHIFT 0
#define PMIC_FG_NTER_15_00_ADDR MT6356_FGADC_NTER_CON1
#define PMIC_FG_NTER_15_00_MASK 0xFFFF
#define PMIC_FG_NTER_15_00_SHIFT 0
#define PMIC_FG_TIME_HTH_29_16_ADDR MT6356_FGADC_NTER_CON2
#define PMIC_FG_TIME_HTH_29_16_MASK 0x3FFF
#define PMIC_FG_TIME_HTH_29_16_SHIFT 0
#define PMIC_FG_TIME_HTH_15_00_ADDR MT6356_FGADC_NTER_CON3
#define PMIC_FG_TIME_HTH_15_00_MASK 0xFFFF
#define PMIC_FG_TIME_HTH_15_00_SHIFT 0
#define PMIC_FG_OFFSET_ADDR MT6356_FGADC_OFFSET_CON0
#define PMIC_FG_OFFSET_MASK 0xFFFF
#define PMIC_FG_OFFSET_SHIFT 0
#define PMIC_FG_ADJUST_OFFSET_VALUE_ADDR MT6356_FGADC_OFFSET_CON1
#define PMIC_FG_ADJUST_OFFSET_VALUE_MASK 0xFFFF
#define PMIC_FG_ADJUST_OFFSET_VALUE_SHIFT 0
#define PMIC_FG_GAIN_ADDR MT6356_FGADC_GAIN_CON0
#define PMIC_FG_GAIN_MASK 0x1FFF
#define PMIC_FG_GAIN_SHIFT 0
#define PMIC_FG_SON_SLP_CUR_TH_ADDR MT6356_FGADC_SON_CON0
#define PMIC_FG_SON_SLP_CUR_TH_MASK 0xFFFF
#define PMIC_FG_SON_SLP_CUR_TH_SHIFT 0
#define PMIC_FG_SON_SLP_TIME_ADDR MT6356_FGADC_SON_CON1
#define PMIC_FG_SON_SLP_TIME_MASK 0x3FF
#define PMIC_FG_SON_SLP_TIME_SHIFT 0
#define PMIC_FG_SON_DET_TIME_ADDR MT6356_FGADC_SON_CON2
#define PMIC_FG_SON_DET_TIME_MASK 0x3FF
#define PMIC_FG_SON_DET_TIME_SHIFT 0
#define PMIC_FG_FP_FTIME_ADDR MT6356_FGADC_SON_CON3
#define PMIC_FG_FP_FTIME_MASK 0xFF
#define PMIC_FG_FP_FTIME_SHIFT 0
#define PMIC_FG_SOFF_SLP_CUR_TH_ADDR MT6356_FGADC_SOFF_CON0
#define PMIC_FG_SOFF_SLP_CUR_TH_MASK 0xFFFF
#define PMIC_FG_SOFF_SLP_CUR_TH_SHIFT 0
#define PMIC_FG_SOFF_SLP_TIME_ADDR MT6356_FGADC_SOFF_CON1
#define PMIC_FG_SOFF_SLP_TIME_MASK 0x3FF
#define PMIC_FG_SOFF_SLP_TIME_SHIFT 0
#define PMIC_FG_SOFF_DET_TIME_ADDR MT6356_FGADC_SOFF_CON2
#define PMIC_FG_SOFF_DET_TIME_MASK 0x3FF
#define PMIC_FG_SOFF_DET_TIME_SHIFT 0
#define PMIC_FG_SOFF_TIME_29_16_ADDR MT6356_FGADC_SOFF_CON3
#define PMIC_FG_SOFF_TIME_29_16_MASK 0x3FFF
#define PMIC_FG_SOFF_TIME_29_16_SHIFT 0
#define PMIC_FG_SOFF_ADDR MT6356_FGADC_SOFF_CON3
#define PMIC_FG_SOFF_MASK 0x1
#define PMIC_FG_SOFF_SHIFT 15
#define PMIC_FG_SOFF_TIME_15_00_ADDR MT6356_FGADC_SOFF_CON4
#define PMIC_FG_SOFF_TIME_15_00_MASK 0xFFFF
#define PMIC_FG_SOFF_TIME_15_00_SHIFT 0
#define PMIC_FG_PWR_TIME0_ADDR MT6356_FGADC_PWR_CON0
#define PMIC_FG_PWR_TIME0_MASK 0xFF
#define PMIC_FG_PWR_TIME0_SHIFT 0
#define PMIC_FG_PWR_TIME1_ADDR MT6356_FGADC_PWR_CON0
#define PMIC_FG_PWR_TIME1_MASK 0xFF
#define PMIC_FG_PWR_TIME1_SHIFT 8
#define PMIC_FG_PWR_TIME2_ADDR MT6356_FGADC_PWR_CON1
#define PMIC_FG_PWR_TIME2_MASK 0xFF
#define PMIC_FG_PWR_TIME2_SHIFT 0
#define PMIC_FG_ZCV_DET_IV_ADDR MT6356_FGADC_ZCV_CON0
#define PMIC_FG_ZCV_DET_IV_MASK 0xF
#define PMIC_FG_ZCV_DET_IV_SHIFT 0
#define PMIC_FG_ZCV_CAR_TH_30_16_ADDR MT6356_FGADC_ZCV_CON1
#define PMIC_FG_ZCV_CAR_TH_30_16_MASK 0x7FFF
#define PMIC_FG_ZCV_CAR_TH_30_16_SHIFT 0
#define PMIC_FG_ZCV_CAR_TH_15_00_ADDR MT6356_FGADC_ZCV_CON2
#define PMIC_FG_ZCV_CAR_TH_15_00_MASK 0xFFFF
#define PMIC_FG_ZCV_CAR_TH_15_00_SHIFT 0
#define PMIC_FG_ZCV_CAR_31_16_ADDR MT6356_FGADC_ZCV_CON3
#define PMIC_FG_ZCV_CAR_31_16_MASK 0xFFFF
#define PMIC_FG_ZCV_CAR_31_16_SHIFT 0
#define PMIC_FG_ZCV_CAR_15_00_ADDR MT6356_FGADC_ZCV_CON4
#define PMIC_FG_ZCV_CAR_15_00_MASK 0xFFFF
#define PMIC_FG_ZCV_CAR_15_00_SHIFT 0
#define PMIC_FG_ZCV_CURR_ADDR MT6356_FGADC_ZCV_CON5
#define PMIC_FG_ZCV_CURR_MASK 0xFFFF
#define PMIC_FG_ZCV_CURR_SHIFT 0
#define PMIC_FG_MODE_ADDR MT6356_FGADC_TEST_CON0
#define PMIC_FG_MODE_MASK 0x1
#define PMIC_FG_MODE_SHIFT 0
#define PMIC_FG_RST_SW_ADDR MT6356_FGADC_TEST_CON0
#define PMIC_FG_RST_SW_MASK 0x1
#define PMIC_FG_RST_SW_SHIFT 1
#define PMIC_FG_FGCAL_EN_SW_ADDR MT6356_FGADC_TEST_CON0
#define PMIC_FG_FGCAL_EN_SW_MASK 0x1
#define PMIC_FG_FGCAL_EN_SW_SHIFT 2
#define PMIC_FG_FGADC_EN_SW_ADDR MT6356_FGADC_TEST_CON0
#define PMIC_FG_FGADC_EN_SW_MASK 0x1
#define PMIC_FG_FGADC_EN_SW_SHIFT 3
#define PMIC_FGADC_TEST_CON0_RSV_ADDR MT6356_FGADC_TEST_CON0
#define PMIC_FGADC_TEST_CON0_RSV_MASK 0xFFF
#define PMIC_FGADC_TEST_CON0_RSV_SHIFT 4
#define PMIC_FG_RSV_CON0_RSV_ADDR MT6356_FGADC_RSV_CON0
#define PMIC_FG_RSV_CON0_RSV_MASK 0xFFFF
#define PMIC_FG_RSV_CON0_RSV_SHIFT 0
#define PMIC_FG_RSV_CON1_RSV_ADDR MT6356_FGADC_RSV_CON1
#define PMIC_FG_RSV_CON1_RSV_MASK 0xFFFF
#define PMIC_FG_RSV_CON1_RSV_SHIFT 0
#define PMIC_FG_RSV_CON2_RSV_ADDR MT6356_FGADC_RSV_CON2
#define PMIC_FG_RSV_CON2_RSV_MASK 0xFFFF
#define PMIC_FG_RSV_CON2_RSV_SHIFT 0
#define PMIC_FG_RSV_CON3_RSV_ADDR MT6356_FGADC_RSV_CON3
#define PMIC_FG_RSV_CON3_RSV_MASK 0xFFFF
#define PMIC_FG_RSV_CON3_RSV_SHIFT 0
#define PMIC_RG_SYSTEM_INFO_CON0_ADDR MT6356_SYSTEM_INFO_CON0
#define PMIC_RG_SYSTEM_INFO_CON0_MASK 0xFFFF
#define PMIC_RG_SYSTEM_INFO_CON0_SHIFT 0
#define PMIC_RG_SYSTEM_INFO_CON1_ADDR MT6356_SYSTEM_INFO_CON1
#define PMIC_RG_SYSTEM_INFO_CON1_MASK 0xFFFF
#define PMIC_RG_SYSTEM_INFO_CON1_SHIFT 0
#define PMIC_RG_SYSTEM_INFO_CON2_ADDR MT6356_SYSTEM_INFO_CON2
#define PMIC_RG_SYSTEM_INFO_CON2_MASK 0xFFFF
#define PMIC_RG_SYSTEM_INFO_CON2_SHIFT 0
#define PMIC_RG_SYSTEM_INFO_CON3_ADDR MT6356_SYSTEM_INFO_CON3
#define PMIC_RG_SYSTEM_INFO_CON3_MASK 0xFFFF
#define PMIC_RG_SYSTEM_INFO_CON3_SHIFT 0
#define PMIC_RG_SYSTEM_INFO_CON4_ADDR MT6356_SYSTEM_INFO_CON4
#define PMIC_RG_SYSTEM_INFO_CON4_MASK 0xFFFF
#define PMIC_RG_SYSTEM_INFO_CON4_SHIFT 0
#define PMIC_BAT_ANA_ANA_ID_ADDR MT6356_BAT_ANA_DSN_ID
#define PMIC_BAT_ANA_ANA_ID_MASK 0xFF
#define PMIC_BAT_ANA_ANA_ID_SHIFT 0
#define PMIC_BAT_ANA_DIG_ID_ADDR MT6356_BAT_ANA_DSN_ID
#define PMIC_BAT_ANA_DIG_ID_MASK 0xFF
#define PMIC_BAT_ANA_DIG_ID_SHIFT 8
#define PMIC_BAT_ANA_ANA_MINOR_REV_ADDR MT6356_BAT_ANA_DSN_REV0
#define PMIC_BAT_ANA_ANA_MINOR_REV_MASK 0xF
#define PMIC_BAT_ANA_ANA_MINOR_REV_SHIFT 0
#define PMIC_BAT_ANA_ANA_MAJOR_REV_ADDR MT6356_BAT_ANA_DSN_REV0
#define PMIC_BAT_ANA_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BAT_ANA_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BAT_ANA_DIG_MINOR_REV_ADDR MT6356_BAT_ANA_DSN_REV0
#define PMIC_BAT_ANA_DIG_MINOR_REV_MASK 0xF
#define PMIC_BAT_ANA_DIG_MINOR_REV_SHIFT 8
#define PMIC_BAT_ANA_DIG_MAJOR_REV_ADDR MT6356_BAT_ANA_DSN_REV0
#define PMIC_BAT_ANA_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BAT_ANA_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BAT_ANA_SW_MINOR_REV_ADDR MT6356_BAT_ANA_DSN_REV1
#define PMIC_BAT_ANA_SW_MINOR_REV_MASK 0xF
#define PMIC_BAT_ANA_SW_MINOR_REV_SHIFT 0
#define PMIC_BAT_ANA_SW_MAJOR_REV_ADDR MT6356_BAT_ANA_DSN_REV1
#define PMIC_BAT_ANA_SW_MAJOR_REV_MASK 0xF
#define PMIC_BAT_ANA_SW_MAJOR_REV_SHIFT 4
#define PMIC_BAT_ANA_ESP_ADDR MT6356_BAT_ANA_DSN_REV1
#define PMIC_BAT_ANA_ESP_MASK 0xFF
#define PMIC_BAT_ANA_ESP_SHIFT 8
#define PMIC_RG_BATON_EN_ADDR MT6356_BATON_ANA_CON0
#define PMIC_RG_BATON_EN_MASK 0x1
#define PMIC_RG_BATON_EN_SHIFT 0
#define PMIC_RGS_BATON_UNDET_ADDR MT6356_BATON_ANA_CON0
#define PMIC_RGS_BATON_UNDET_MASK 0x1
#define PMIC_RGS_BATON_UNDET_SHIFT 1
#define PMIC_RG_BATON_LT_EN_ADDR MT6356_BATON_ANA_CON0
#define PMIC_RG_BATON_LT_EN_MASK 0x1
#define PMIC_RG_BATON_LT_EN_SHIFT 2
#define PMIC_DA_BATON_HT_EN_ADDR MT6356_BATON_ANA_MON0
#define PMIC_DA_BATON_HT_EN_MASK 0x1
#define PMIC_DA_BATON_HT_EN_SHIFT 0
#define PMIC_DA_BIF_TX_EN_ADDR MT6356_BIF_ANA_MON0
#define PMIC_DA_BIF_TX_EN_MASK 0x1
#define PMIC_DA_BIF_TX_EN_SHIFT 0
#define PMIC_DA_BIF_TX_DATA_ADDR MT6356_BIF_ANA_MON0
#define PMIC_DA_BIF_TX_DATA_MASK 0x1
#define PMIC_DA_BIF_TX_DATA_SHIFT 1
#define PMIC_DA_BIF_RX_EN_ADDR MT6356_BIF_ANA_MON0
#define PMIC_DA_BIF_RX_EN_MASK 0x1
#define PMIC_DA_BIF_RX_EN_SHIFT 2
#define PMIC_AD_BIF_RX_DATA_ADDR MT6356_BIF_ANA_MON0
#define PMIC_AD_BIF_RX_DATA_MASK 0x1
#define PMIC_AD_BIF_RX_DATA_SHIFT 3
#define PMIC_BATON_ANA_ID_ADDR MT6356_BATON_DSN_ID
#define PMIC_BATON_ANA_ID_MASK 0xFF
#define PMIC_BATON_ANA_ID_SHIFT 0
#define PMIC_BATON_DIG_ID_ADDR MT6356_BATON_DSN_ID
#define PMIC_BATON_DIG_ID_MASK 0xFF
#define PMIC_BATON_DIG_ID_SHIFT 8
#define PMIC_BATON_ANA_MINOR_REV_ADDR MT6356_BATON_DSN_REV0
#define PMIC_BATON_ANA_MINOR_REV_MASK 0xF
#define PMIC_BATON_ANA_MINOR_REV_SHIFT 0
#define PMIC_BATON_ANA_MAJOR_REV_ADDR MT6356_BATON_DSN_REV0
#define PMIC_BATON_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BATON_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BATON_DIG_MINOR_REV_ADDR MT6356_BATON_DSN_REV0
#define PMIC_BATON_DIG_MINOR_REV_MASK 0xF
#define PMIC_BATON_DIG_MINOR_REV_SHIFT 8
#define PMIC_BATON_DIG_MAJOR_REV_ADDR MT6356_BATON_DSN_REV0
#define PMIC_BATON_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BATON_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BATON_SW_MINOR_REV_ADDR MT6356_BATON_DSN_REV1
#define PMIC_BATON_SW_MINOR_REV_MASK 0xF
#define PMIC_BATON_SW_MINOR_REV_SHIFT 0
#define PMIC_BATON_SW_MAJOR_REV_ADDR MT6356_BATON_DSN_REV1
#define PMIC_BATON_SW_MAJOR_REV_MASK 0xF
#define PMIC_BATON_SW_MAJOR_REV_SHIFT 4
#define PMIC_BATON_ESP_ADDR MT6356_BATON_DSN_REV1
#define PMIC_BATON_ESP_MASK 0xFF
#define PMIC_BATON_ESP_SHIFT 8
#define PMIC_RG_BATON_DEBOUNCE_WND_ADDR MT6356_BATON_CON0
#define PMIC_RG_BATON_DEBOUNCE_WND_MASK 0x3
#define PMIC_RG_BATON_DEBOUNCE_WND_SHIFT 0
#define PMIC_RG_BATON_DEBOUNCE_THD_ADDR MT6356_BATON_CON0
#define PMIC_RG_BATON_DEBOUNCE_THD_MASK 0x3
#define PMIC_RG_BATON_DEBOUNCE_THD_SHIFT 2
#define PMIC_RG_BATON_CHRDET_TEST_MODE_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_CHRDET_TEST_MODE_MASK 0x1
#define PMIC_RG_BATON_CHRDET_TEST_MODE_SHIFT 0
#define PMIC_RG_BATON_UNDET_TEST_MODE_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_UNDET_TEST_MODE_MASK 0x1
#define PMIC_RG_BATON_UNDET_TEST_MODE_SHIFT 1
#define PMIC_RG_BATON_AUXADC_TEST_MODE_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_AUXADC_TEST_MODE_MASK 0x1
#define PMIC_RG_BATON_AUXADC_TEST_MODE_SHIFT 2
#define PMIC_RG_BATON_FGADC_TEST_MODE_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_FGADC_TEST_MODE_MASK 0x1
#define PMIC_RG_BATON_FGADC_TEST_MODE_SHIFT 3
#define PMIC_RG_BATON_RTC_TEST_MODE_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_RTC_TEST_MODE_MASK 0x1
#define PMIC_RG_BATON_RTC_TEST_MODE_SHIFT 4
#define PMIC_RG_BATON_BIF_TEST_MODE_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_BIF_TEST_MODE_MASK 0x1
#define PMIC_RG_BATON_BIF_TEST_MODE_SHIFT 5
#define PMIC_RG_BATON_RSV_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_RSV_MASK 0x3
#define PMIC_RG_BATON_RSV_SHIFT 6
#define PMIC_RG_BATON_CHRDET_SW_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_CHRDET_SW_MASK 0x1
#define PMIC_RG_BATON_CHRDET_SW_SHIFT 8
#define PMIC_RG_BATON_UNDET_SW_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_UNDET_SW_MASK 0x1
#define PMIC_RG_BATON_UNDET_SW_SHIFT 9
#define PMIC_RG_BATON_AUXADC_SW_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_AUXADC_SW_MASK 0x1
#define PMIC_RG_BATON_AUXADC_SW_SHIFT 10
#define PMIC_RG_BATON_FGADC_SW_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_FGADC_SW_MASK 0x1
#define PMIC_RG_BATON_FGADC_SW_SHIFT 11
#define PMIC_RG_BATON_RTC_SW_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_RTC_SW_MASK 0x1
#define PMIC_RG_BATON_RTC_SW_SHIFT 12
#define PMIC_RG_BATON_BIF_SW_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_BIF_SW_MASK 0x1
#define PMIC_RG_BATON_BIF_SW_SHIFT 13
#define PMIC_RG_BATON_RSV_SW_ADDR MT6356_BATON_CON1
#define PMIC_RG_BATON_RSV_SW_MASK 0x3
#define PMIC_RG_BATON_RSV_SW_SHIFT 14
#define PMIC_BATON_STATUS_ADDR MT6356_BATON_CON2
#define PMIC_BATON_STATUS_MASK 0x1
#define PMIC_BATON_STATUS_SHIFT 0
#define PMIC_BATON_AUXADC_SET_ADDR MT6356_BATON_CON2
#define PMIC_BATON_AUXADC_SET_MASK 0x1
#define PMIC_BATON_AUXADC_SET_SHIFT 1
#define PMIC_BATON_DEB_VALID_ADDR MT6356_BATON_CON2
#define PMIC_BATON_DEB_VALID_MASK 0x1
#define PMIC_BATON_DEB_VALID_SHIFT 2
#define PMIC_BATON_BIF_STATUS_ADDR MT6356_BATON_CON2
#define PMIC_BATON_BIF_STATUS_MASK 0x1
#define PMIC_BATON_BIF_STATUS_SHIFT 3
#define PMIC_BATON_RTC_STATUS_ADDR MT6356_BATON_CON2
#define PMIC_BATON_RTC_STATUS_MASK 0x1
#define PMIC_BATON_RTC_STATUS_SHIFT 4
#define PMIC_BATON_FGADC_STATUS_ADDR MT6356_BATON_CON2
#define PMIC_BATON_FGADC_STATUS_MASK 0x1
#define PMIC_BATON_FGADC_STATUS_SHIFT 5
#define PMIC_BATON_AUXADC_TRIG_ADDR MT6356_BATON_CON2
#define PMIC_BATON_AUXADC_TRIG_MASK 0x1
#define PMIC_BATON_AUXADC_TRIG_SHIFT 6
#define PMIC_BATON_CHRDET_DEB_ADDR MT6356_BATON_CON2
#define PMIC_BATON_CHRDET_DEB_MASK 0x1
#define PMIC_BATON_CHRDET_DEB_SHIFT 7
#define PMIC_BATON_IVGEN_ENB_ADDR MT6356_BATON_CON2
#define PMIC_BATON_IVGEN_ENB_MASK 0x1
#define PMIC_BATON_IVGEN_ENB_SHIFT 8
#define PMIC_BATON_VBIF28_STB_ADDR MT6356_BATON_CON2
#define PMIC_BATON_VBIF28_STB_MASK 0x1
#define PMIC_BATON_VBIF28_STB_SHIFT 9
#define PMIC_BATON_VBIF28_EN_ADDR MT6356_BATON_CON2
#define PMIC_BATON_VBIF28_EN_MASK 0x1
#define PMIC_BATON_VBIF28_EN_SHIFT 10
#define PMIC_BATON_RSV_0_ADDR MT6356_BATON_CON2
#define PMIC_BATON_RSV_0_MASK 0x1F
#define PMIC_BATON_RSV_0_SHIFT 11
#define PMIC_RG_BATON_PWR_TIME0_ADDR MT6356_BATON_CON3
#define PMIC_RG_BATON_PWR_TIME0_MASK 0xFF
#define PMIC_RG_BATON_PWR_TIME0_SHIFT 0
#define PMIC_RG_BATON_PWR_TIME1_ADDR MT6356_BATON_CON3
#define PMIC_RG_BATON_PWR_TIME1_MASK 0xFF
#define PMIC_RG_BATON_PWR_TIME1_SHIFT 8
#define PMIC_BATON_ELR_LEN_ADDR MT6356_BATON_ELR_NUM
#define PMIC_BATON_ELR_LEN_MASK 0xFF
#define PMIC_BATON_ELR_LEN_SHIFT 0
#define PMIC_RG_BATON_CHRDET_DEB_TD_ADDR MT6356_BATON_ELR0
#define PMIC_RG_BATON_CHRDET_DEB_TD_MASK 0x1
#define PMIC_RG_BATON_CHRDET_DEB_TD_SHIFT 0
#define PMIC_BIF_ANA_ID_ADDR MT6356_BIF_DSN_ID
#define PMIC_BIF_ANA_ID_MASK 0xFF
#define PMIC_BIF_ANA_ID_SHIFT 0
#define PMIC_BIF_DIG_ID_ADDR MT6356_BIF_DSN_ID
#define PMIC_BIF_DIG_ID_MASK 0xFF
#define PMIC_BIF_DIG_ID_SHIFT 8
#define PMIC_BIF_ANA_MINOR_REV_ADDR MT6356_BIF_DSN_REV0
#define PMIC_BIF_ANA_MINOR_REV_MASK 0xF
#define PMIC_BIF_ANA_MINOR_REV_SHIFT 0
#define PMIC_BIF_ANA_MAJOR_REV_ADDR MT6356_BIF_DSN_REV0
#define PMIC_BIF_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BIF_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BIF_DIG_MINOR_REV_ADDR MT6356_BIF_DSN_REV0
#define PMIC_BIF_DIG_MINOR_REV_MASK 0xF
#define PMIC_BIF_DIG_MINOR_REV_SHIFT 8
#define PMIC_BIF_DIG_MAJOR_REV_ADDR MT6356_BIF_DSN_REV0
#define PMIC_BIF_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BIF_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BIF_SW_MINOR_REV_ADDR MT6356_BIF_DSN_REV1
#define PMIC_BIF_SW_MINOR_REV_MASK 0xF
#define PMIC_BIF_SW_MINOR_REV_SHIFT 0
#define PMIC_BIF_SW_MAJOR_REV_ADDR MT6356_BIF_DSN_REV1
#define PMIC_BIF_SW_MAJOR_REV_MASK 0xF
#define PMIC_BIF_SW_MAJOR_REV_SHIFT 4
#define PMIC_BIF_ESP_ADDR MT6356_BIF_DSN_REV1
#define PMIC_BIF_ESP_MASK 0xFF
#define PMIC_BIF_ESP_SHIFT 8
#define PMIC_BIF_COMMAND_0_ADDR MT6356_BIF_CON0
#define PMIC_BIF_COMMAND_0_MASK 0x7FF
#define PMIC_BIF_COMMAND_0_SHIFT 0
#define PMIC_BIF_COMMAND_1_ADDR MT6356_BIF_CON1
#define PMIC_BIF_COMMAND_1_MASK 0x7FF
#define PMIC_BIF_COMMAND_1_SHIFT 0
#define PMIC_BIF_COMMAND_2_ADDR MT6356_BIF_CON2
#define PMIC_BIF_COMMAND_2_MASK 0x7FF
#define PMIC_BIF_COMMAND_2_SHIFT 0
#define PMIC_BIF_COMMAND_3_ADDR MT6356_BIF_CON3
#define PMIC_BIF_COMMAND_3_MASK 0x7FF
#define PMIC_BIF_COMMAND_3_SHIFT 0
#define PMIC_BIF_COMMAND_4_ADDR MT6356_BIF_CON4
#define PMIC_BIF_COMMAND_4_MASK 0x7FF
#define PMIC_BIF_COMMAND_4_SHIFT 0
#define PMIC_BIF_COMMAND_5_ADDR MT6356_BIF_CON5
#define PMIC_BIF_COMMAND_5_MASK 0x7FF
#define PMIC_BIF_COMMAND_5_SHIFT 0
#define PMIC_BIF_COMMAND_6_ADDR MT6356_BIF_CON6
#define PMIC_BIF_COMMAND_6_MASK 0x7FF
#define PMIC_BIF_COMMAND_6_SHIFT 0
#define PMIC_BIF_COMMAND_7_ADDR MT6356_BIF_CON7
#define PMIC_BIF_COMMAND_7_MASK 0x7FF
#define PMIC_BIF_COMMAND_7_SHIFT 0
#define PMIC_BIF_COMMAND_8_ADDR MT6356_BIF_CON8
#define PMIC_BIF_COMMAND_8_MASK 0x7FF
#define PMIC_BIF_COMMAND_8_SHIFT 0
#define PMIC_BIF_COMMAND_9_ADDR MT6356_BIF_CON9
#define PMIC_BIF_COMMAND_9_MASK 0x7FF
#define PMIC_BIF_COMMAND_9_SHIFT 0
#define PMIC_BIF_COMMAND_10_ADDR MT6356_BIF_CON10
#define PMIC_BIF_COMMAND_10_MASK 0x7FF
#define PMIC_BIF_COMMAND_10_SHIFT 0
#define PMIC_BIF_COMMAND_11_ADDR MT6356_BIF_CON11
#define PMIC_BIF_COMMAND_11_MASK 0x7FF
#define PMIC_BIF_COMMAND_11_SHIFT 0
#define PMIC_BIF_COMMAND_12_ADDR MT6356_BIF_CON12
#define PMIC_BIF_COMMAND_12_MASK 0x7FF
#define PMIC_BIF_COMMAND_12_SHIFT 0
#define PMIC_BIF_COMMAND_13_ADDR MT6356_BIF_CON13
#define PMIC_BIF_COMMAND_13_MASK 0x7FF
#define PMIC_BIF_COMMAND_13_SHIFT 0
#define PMIC_BIF_COMMAND_14_ADDR MT6356_BIF_CON14
#define PMIC_BIF_COMMAND_14_MASK 0x7FF
#define PMIC_BIF_COMMAND_14_SHIFT 0
#define PMIC_BIF_RSV_ADDR MT6356_BIF_CON15
#define PMIC_BIF_RSV_MASK 0x7F
#define PMIC_BIF_RSV_SHIFT 0
#define PMIC_BIF_COMMAND_TYPE_ADDR MT6356_BIF_CON15
#define PMIC_BIF_COMMAND_TYPE_MASK 0x3
#define PMIC_BIF_COMMAND_TYPE_SHIFT 8
#define PMIC_BIF_TRASFER_NUM_ADDR MT6356_BIF_CON15
#define PMIC_BIF_TRASFER_NUM_MASK 0xF
#define PMIC_BIF_TRASFER_NUM_SHIFT 12
#define PMIC_BIF_LOGIC_0_SET_ADDR MT6356_BIF_CON16
#define PMIC_BIF_LOGIC_0_SET_MASK 0xF
#define PMIC_BIF_LOGIC_0_SET_SHIFT 0
#define PMIC_BIF_LOGIC_1_SET_ADDR MT6356_BIF_CON16
#define PMIC_BIF_LOGIC_1_SET_MASK 0x1F
#define PMIC_BIF_LOGIC_1_SET_SHIFT 4
#define PMIC_BIF_STOP_SET_ADDR MT6356_BIF_CON16
#define PMIC_BIF_STOP_SET_MASK 0x3F
#define PMIC_BIF_STOP_SET_SHIFT 10
#define PMIC_BIF_DEBOUNCE_EN_ADDR MT6356_BIF_CON17
#define PMIC_BIF_DEBOUNCE_EN_MASK 0x1
#define PMIC_BIF_DEBOUNCE_EN_SHIFT 4
#define PMIC_BIF_READ_EXPECT_NUM_ADDR MT6356_BIF_CON17
#define PMIC_BIF_READ_EXPECT_NUM_MASK 0xF
#define PMIC_BIF_READ_EXPECT_NUM_SHIFT 12
#define PMIC_BIF_TRASACT_TRIGGER_ADDR MT6356_BIF_CON18
#define PMIC_BIF_TRASACT_TRIGGER_MASK 0x1
#define PMIC_BIF_TRASACT_TRIGGER_SHIFT 0
#define PMIC_BIF_DATA_NUM_ADDR MT6356_BIF_CON19
#define PMIC_BIF_DATA_NUM_MASK 0xF
#define PMIC_BIF_DATA_NUM_SHIFT 0
#define PMIC_BIF_RESPONSE_ADDR MT6356_BIF_CON19
#define PMIC_BIF_RESPONSE_MASK 0x1
#define PMIC_BIF_RESPONSE_SHIFT 12
#define PMIC_BIF_DATA_0_ADDR MT6356_BIF_CON20
#define PMIC_BIF_DATA_0_MASK 0xFF
#define PMIC_BIF_DATA_0_SHIFT 0
#define PMIC_BIF_ACK_0_ADDR MT6356_BIF_CON20
#define PMIC_BIF_ACK_0_MASK 0x1
#define PMIC_BIF_ACK_0_SHIFT 8
#define PMIC_BIF_ERROR_0_ADDR MT6356_BIF_CON20
#define PMIC_BIF_ERROR_0_MASK 0x1
#define PMIC_BIF_ERROR_0_SHIFT 15
#define PMIC_BIF_DATA_1_ADDR MT6356_BIF_CON21
#define PMIC_BIF_DATA_1_MASK 0xFF
#define PMIC_BIF_DATA_1_SHIFT 0
#define PMIC_BIF_ACK_1_ADDR MT6356_BIF_CON21
#define PMIC_BIF_ACK_1_MASK 0x1
#define PMIC_BIF_ACK_1_SHIFT 8
#define PMIC_BIF_ERROR_1_ADDR MT6356_BIF_CON21
#define PMIC_BIF_ERROR_1_MASK 0x1
#define PMIC_BIF_ERROR_1_SHIFT 15
#define PMIC_BIF_DATA_2_ADDR MT6356_BIF_CON22
#define PMIC_BIF_DATA_2_MASK 0xFF
#define PMIC_BIF_DATA_2_SHIFT 0
#define PMIC_BIF_ACK_2_ADDR MT6356_BIF_CON22
#define PMIC_BIF_ACK_2_MASK 0x1
#define PMIC_BIF_ACK_2_SHIFT 8
#define PMIC_BIF_ERROR_2_ADDR MT6356_BIF_CON22
#define PMIC_BIF_ERROR_2_MASK 0x1
#define PMIC_BIF_ERROR_2_SHIFT 15
#define PMIC_BIF_DATA_3_ADDR MT6356_BIF_CON23
#define PMIC_BIF_DATA_3_MASK 0xFF
#define PMIC_BIF_DATA_3_SHIFT 0
#define PMIC_BIF_ACK_3_ADDR MT6356_BIF_CON23
#define PMIC_BIF_ACK_3_MASK 0x1
#define PMIC_BIF_ACK_3_SHIFT 8
#define PMIC_BIF_ERROR_3_ADDR MT6356_BIF_CON23
#define PMIC_BIF_ERROR_3_MASK 0x1
#define PMIC_BIF_ERROR_3_SHIFT 15
#define PMIC_BIF_DATA_4_ADDR MT6356_BIF_CON24
#define PMIC_BIF_DATA_4_MASK 0xFF
#define PMIC_BIF_DATA_4_SHIFT 0
#define PMIC_BIF_ACK_4_ADDR MT6356_BIF_CON24
#define PMIC_BIF_ACK_4_MASK 0x1
#define PMIC_BIF_ACK_4_SHIFT 8
#define PMIC_BIF_ERROR_4_ADDR MT6356_BIF_CON24
#define PMIC_BIF_ERROR_4_MASK 0x1
#define PMIC_BIF_ERROR_4_SHIFT 15
#define PMIC_BIF_DATA_5_ADDR MT6356_BIF_CON25
#define PMIC_BIF_DATA_5_MASK 0xFF
#define PMIC_BIF_DATA_5_SHIFT 0
#define PMIC_BIF_ACK_5_ADDR MT6356_BIF_CON25
#define PMIC_BIF_ACK_5_MASK 0x1
#define PMIC_BIF_ACK_5_SHIFT 8
#define PMIC_BIF_ERROR_5_ADDR MT6356_BIF_CON25
#define PMIC_BIF_ERROR_5_MASK 0x1
#define PMIC_BIF_ERROR_5_SHIFT 15
#define PMIC_BIF_DATA_6_ADDR MT6356_BIF_CON26
#define PMIC_BIF_DATA_6_MASK 0xFF
#define PMIC_BIF_DATA_6_SHIFT 0
#define PMIC_BIF_ACK_6_ADDR MT6356_BIF_CON26
#define PMIC_BIF_ACK_6_MASK 0x1
#define PMIC_BIF_ACK_6_SHIFT 8
#define PMIC_BIF_ERROR_6_ADDR MT6356_BIF_CON26
#define PMIC_BIF_ERROR_6_MASK 0x1
#define PMIC_BIF_ERROR_6_SHIFT 15
#define PMIC_BIF_DATA_7_ADDR MT6356_BIF_CON27
#define PMIC_BIF_DATA_7_MASK 0xFF
#define PMIC_BIF_DATA_7_SHIFT 0
#define PMIC_BIF_ACK_7_ADDR MT6356_BIF_CON27
#define PMIC_BIF_ACK_7_MASK 0x1
#define PMIC_BIF_ACK_7_SHIFT 8
#define PMIC_BIF_ERROR_7_ADDR MT6356_BIF_CON27
#define PMIC_BIF_ERROR_7_MASK 0x1
#define PMIC_BIF_ERROR_7_SHIFT 15
#define PMIC_BIF_DATA_8_ADDR MT6356_BIF_CON28
#define PMIC_BIF_DATA_8_MASK 0xFF
#define PMIC_BIF_DATA_8_SHIFT 0
#define PMIC_BIF_ACK_8_ADDR MT6356_BIF_CON28
#define PMIC_BIF_ACK_8_MASK 0x1
#define PMIC_BIF_ACK_8_SHIFT 8
#define PMIC_BIF_ERROR_8_ADDR MT6356_BIF_CON28
#define PMIC_BIF_ERROR_8_MASK 0x1
#define PMIC_BIF_ERROR_8_SHIFT 15
#define PMIC_BIF_DATA_9_ADDR MT6356_BIF_CON29
#define PMIC_BIF_DATA_9_MASK 0xFF
#define PMIC_BIF_DATA_9_SHIFT 0
#define PMIC_BIF_ACK_9_ADDR MT6356_BIF_CON29
#define PMIC_BIF_ACK_9_MASK 0x1
#define PMIC_BIF_ACK_9_SHIFT 8
#define PMIC_BIF_ERROR_9_ADDR MT6356_BIF_CON29
#define PMIC_BIF_ERROR_9_MASK 0x1
#define PMIC_BIF_ERROR_9_SHIFT 15
#define PMIC_BIF_TEST_MODE0_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TEST_MODE0_MASK 0x1
#define PMIC_BIF_TEST_MODE0_SHIFT 0
#define PMIC_BIF_TEST_MODE1_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TEST_MODE1_MASK 0x1
#define PMIC_BIF_TEST_MODE1_SHIFT 1
#define PMIC_BIF_TEST_MODE2_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TEST_MODE2_MASK 0x1
#define PMIC_BIF_TEST_MODE2_SHIFT 2
#define PMIC_BIF_TEST_MODE3_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TEST_MODE3_MASK 0x1
#define PMIC_BIF_TEST_MODE3_SHIFT 3
#define PMIC_BIF_TEST_MODE4_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TEST_MODE4_MASK 0x1
#define PMIC_BIF_TEST_MODE4_SHIFT 4
#define PMIC_BIF_TEST_MODE5_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TEST_MODE5_MASK 0x1
#define PMIC_BIF_TEST_MODE5_SHIFT 5
#define PMIC_BIF_TEST_MODE6_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TEST_MODE6_MASK 0x1
#define PMIC_BIF_TEST_MODE6_SHIFT 6
#define PMIC_BIF_TEST_MODE7_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TEST_MODE7_MASK 0x1
#define PMIC_BIF_TEST_MODE7_SHIFT 7
#define PMIC_BIF_TEST_MODE8_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TEST_MODE8_MASK 0x1
#define PMIC_BIF_TEST_MODE8_SHIFT 8
#define PMIC_BIF_BAT_LOST_SW_ADDR MT6356_BIF_CON30
#define PMIC_BIF_BAT_LOST_SW_MASK 0x1
#define PMIC_BIF_BAT_LOST_SW_SHIFT 11
#define PMIC_BIF_RX_DATA_SW_ADDR MT6356_BIF_CON30
#define PMIC_BIF_RX_DATA_SW_MASK 0x1
#define PMIC_BIF_RX_DATA_SW_SHIFT 12
#define PMIC_BIF_TX_DATA_SW_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TX_DATA_SW_MASK 0x1
#define PMIC_BIF_TX_DATA_SW_SHIFT 13
#define PMIC_BIF_RX_EN_SW_ADDR MT6356_BIF_CON30
#define PMIC_BIF_RX_EN_SW_MASK 0x1
#define PMIC_BIF_RX_EN_SW_SHIFT 14
#define PMIC_BIF_TX_EN_SW_ADDR MT6356_BIF_CON30
#define PMIC_BIF_TX_EN_SW_MASK 0x1
#define PMIC_BIF_TX_EN_SW_SHIFT 15
#define PMIC_BIF_BACK_NORMAL_ADDR MT6356_BIF_CON31
#define PMIC_BIF_BACK_NORMAL_MASK 0x1
#define PMIC_BIF_BACK_NORMAL_SHIFT 0
#define PMIC_BIF_IRQ_CLR_ADDR MT6356_BIF_CON31
#define PMIC_BIF_IRQ_CLR_MASK 0x1
#define PMIC_BIF_IRQ_CLR_SHIFT 1
#define PMIC_BIF_IRQ_ADDR MT6356_BIF_CON31
#define PMIC_BIF_IRQ_MASK 0x1
#define PMIC_BIF_IRQ_SHIFT 11
#define PMIC_BIF_TIMEOUT_ADDR MT6356_BIF_CON31
#define PMIC_BIF_TIMEOUT_MASK 0x1
#define PMIC_BIF_TIMEOUT_SHIFT 12
#define PMIC_BIF_BAT_UNDET_ADDR MT6356_BIF_CON31
#define PMIC_BIF_BAT_UNDET_MASK 0x1
#define PMIC_BIF_BAT_UNDET_SHIFT 13
#define PMIC_BIF_TOTAL_VALID_ADDR MT6356_BIF_CON31
#define PMIC_BIF_TOTAL_VALID_MASK 0x1
#define PMIC_BIF_TOTAL_VALID_SHIFT 14
#define PMIC_BIF_BUS_STATUS_ADDR MT6356_BIF_CON31
#define PMIC_BIF_BUS_STATUS_MASK 0x1
#define PMIC_BIF_BUS_STATUS_SHIFT 15
#define PMIC_BIF_POWER_UP_COUNT_ADDR MT6356_BIF_CON32
#define PMIC_BIF_POWER_UP_COUNT_MASK 0x1F
#define PMIC_BIF_POWER_UP_COUNT_SHIFT 0
#define PMIC_BIF_POWER_UP_ADDR MT6356_BIF_CON32
#define PMIC_BIF_POWER_UP_MASK 0x1
#define PMIC_BIF_POWER_UP_SHIFT 15
#define PMIC_BIF_RX_ERROR_UNKNOWN_ADDR MT6356_BIF_CON33
#define PMIC_BIF_RX_ERROR_UNKNOWN_MASK 0x1
#define PMIC_BIF_RX_ERROR_UNKNOWN_SHIFT 2
#define PMIC_BIF_RX_ERROR_INSUFF_ADDR MT6356_BIF_CON33
#define PMIC_BIF_RX_ERROR_INSUFF_MASK 0x1
#define PMIC_BIF_RX_ERROR_INSUFF_SHIFT 3
#define PMIC_BIF_RX_ERROR_LOWPHASE_ADDR MT6356_BIF_CON33
#define PMIC_BIF_RX_ERROR_LOWPHASE_MASK 0x1
#define PMIC_BIF_RX_ERROR_LOWPHASE_SHIFT 4
#define PMIC_BIF_RX_STATE_ADDR MT6356_BIF_CON33
#define PMIC_BIF_RX_STATE_MASK 0x7
#define PMIC_BIF_RX_STATE_SHIFT 5
#define PMIC_BIF_FLOW_CTL_STATE_ADDR MT6356_BIF_CON33
#define PMIC_BIF_FLOW_CTL_STATE_MASK 0x3
#define PMIC_BIF_FLOW_CTL_STATE_SHIFT 8
#define PMIC_BIF_TX_STATE_ADDR MT6356_BIF_CON33
#define PMIC_BIF_TX_STATE_MASK 0x3
#define PMIC_BIF_TX_STATE_SHIFT 10
#define PMIC_BIF_TX_DATA_FIANL_ADDR MT6356_BIF_CON34
#define PMIC_BIF_TX_DATA_FIANL_MASK 0xFFFF
#define PMIC_BIF_TX_DATA_FIANL_SHIFT 0
#define PMIC_BIF_RX_DATA_SAMPLING_ADDR MT6356_BIF_CON35
#define PMIC_BIF_RX_DATA_SAMPLING_MASK 0xFFFF
#define PMIC_BIF_RX_DATA_SAMPLING_SHIFT 0
#define PMIC_BIF_RX_DATA_RECOVERY_ADDR MT6356_BIF_CON36
#define PMIC_BIF_RX_DATA_RECOVERY_MASK 0x3FFF
#define PMIC_BIF_RX_DATA_RECOVERY_SHIFT 0
#define PMIC_RG_BATON_HT_EN_ADDR MT6356_BIF_CON36
#define PMIC_RG_BATON_HT_EN_MASK 0x1
#define PMIC_RG_BATON_HT_EN_SHIFT 14
#define PMIC_RG_BATON_HT_EN_DLY_TIME_ADDR MT6356_BIF_CON36
#define PMIC_RG_BATON_HT_EN_DLY_TIME_MASK 0x1
#define PMIC_RG_BATON_HT_EN_DLY_TIME_SHIFT 15
#define PMIC_BIF_TIMEOUT_SET_ADDR MT6356_BIF_CON37
#define PMIC_BIF_TIMEOUT_SET_MASK 0xFFFF
#define PMIC_BIF_TIMEOUT_SET_SHIFT 0
#define PMIC_BIF_RX_DEG_WND_ADDR MT6356_BIF_CON38
#define PMIC_BIF_RX_DEG_WND_MASK 0x7FF
#define PMIC_BIF_RX_DEG_WND_SHIFT 0
#define PMIC_BIF_RX_DEG_EN_ADDR MT6356_BIF_CON38
#define PMIC_BIF_RX_DEG_EN_MASK 0x1
#define PMIC_BIF_RX_DEG_EN_SHIFT 15
#define PMIC_BIF_RSV1_ADDR MT6356_BIF_CON39
#define PMIC_BIF_RSV1_MASK 0xFF
#define PMIC_BIF_RSV1_SHIFT 0
#define PMIC_BIF_RSV0_ADDR MT6356_BIF_CON39
#define PMIC_BIF_RSV0_MASK 0xFF
#define PMIC_BIF_RSV0_SHIFT 8
#define PMIC_HK_TOP_ANA_ID_ADDR MT6356_HK_TOP_ID
#define PMIC_HK_TOP_ANA_ID_MASK 0xFF
#define PMIC_HK_TOP_ANA_ID_SHIFT 0
#define PMIC_HK_TOP_DIG_ID_ADDR MT6356_HK_TOP_ID
#define PMIC_HK_TOP_DIG_ID_MASK 0xFF
#define PMIC_HK_TOP_DIG_ID_SHIFT 8
#define PMIC_HK_TOP_ANA_MINOR_REV_ADDR MT6356_HK_TOP_REV0
#define PMIC_HK_TOP_ANA_MINOR_REV_MASK 0xF
#define PMIC_HK_TOP_ANA_MINOR_REV_SHIFT 0
#define PMIC_HK_TOP_ANA_MAJOR_REV_ADDR MT6356_HK_TOP_REV0
#define PMIC_HK_TOP_ANA_MAJOR_REV_MASK 0xF
#define PMIC_HK_TOP_ANA_MAJOR_REV_SHIFT 4
#define PMIC_HK_TOP_DIG_MINOR_REV_ADDR MT6356_HK_TOP_REV0
#define PMIC_HK_TOP_DIG_MINOR_REV_MASK 0xF
#define PMIC_HK_TOP_DIG_MINOR_REV_SHIFT 8
#define PMIC_HK_TOP_DIG_MAJOR_REV_ADDR MT6356_HK_TOP_REV0
#define PMIC_HK_TOP_DIG_MAJOR_REV_MASK 0xF
#define PMIC_HK_TOP_DIG_MAJOR_REV_SHIFT 12
#define PMIC_HK_TOP_SW_MINOR_REV_ADDR MT6356_HK_TOP_REV1
#define PMIC_HK_TOP_SW_MINOR_REV_MASK 0xF
#define PMIC_HK_TOP_SW_MINOR_REV_SHIFT 0
#define PMIC_HK_TOP_SW_MAJOR_REV_ADDR MT6356_HK_TOP_REV1
#define PMIC_HK_TOP_SW_MAJOR_REV_MASK 0xF
#define PMIC_HK_TOP_SW_MAJOR_REV_SHIFT 4
#define PMIC_HK_TOP_ESP_ADDR MT6356_HK_TOP_REV1
#define PMIC_HK_TOP_ESP_MASK 0xFF
#define PMIC_HK_TOP_ESP_SHIFT 8
#define PMIC_HK_TOP_CLK_OFFSET_ADDR MT6356_HK_TOP_PAM0
#define PMIC_HK_TOP_CLK_OFFSET_MASK 0xFF
#define PMIC_HK_TOP_CLK_OFFSET_SHIFT 0
#define PMIC_HK_TOP_RST_OFFSET_ADDR MT6356_HK_TOP_PAM0
#define PMIC_HK_TOP_RST_OFFSET_MASK 0xFF
#define PMIC_HK_TOP_RST_OFFSET_SHIFT 8
#define PMIC_HK_TOP_INT_OFFSET_ADDR MT6356_HK_TOP_PAM1
#define PMIC_HK_TOP_INT_OFFSET_MASK 0xFF
#define PMIC_HK_TOP_INT_OFFSET_SHIFT 0
#define PMIC_HK_TOP_INT_LEN_ADDR MT6356_HK_TOP_PAM1
#define PMIC_HK_TOP_INT_LEN_MASK 0xFF
#define PMIC_HK_TOP_INT_LEN_SHIFT 8
#define PMIC_RG_AUXADC_AO_1M_CK_PDN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_AO_1M_CK_PDN_MASK 0x1
#define PMIC_RG_AUXADC_AO_1M_CK_PDN_SHIFT 0
#define PMIC_RG_AUXADC_1M_CK_PDN_HWEN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_1M_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_AUXADC_1M_CK_PDN_HWEN_SHIFT 1
#define PMIC_RG_AUXADC_1M_CK_PDN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_1M_CK_PDN_MASK 0x1
#define PMIC_RG_AUXADC_1M_CK_PDN_SHIFT 2
#define PMIC_RG_AUXADC_CK_PDN_HWEN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_AUXADC_CK_PDN_HWEN_SHIFT 3
#define PMIC_RG_AUXADC_CK_PDN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_CK_PDN_MASK 0x1
#define PMIC_RG_AUXADC_CK_PDN_SHIFT 4
#define PMIC_RG_AUXADC_RNG_CK_PDN_HWEN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_RNG_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_AUXADC_RNG_CK_PDN_HWEN_SHIFT 5
#define PMIC_RG_AUXADC_RNG_CK_PDN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_RNG_CK_PDN_MASK 0x1
#define PMIC_RG_AUXADC_RNG_CK_PDN_SHIFT 6
#define PMIC_RG_AUXADC_32K_CK_PDN_HWEN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_32K_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_AUXADC_32K_CK_PDN_HWEN_SHIFT 7
#define PMIC_RG_AUXADC_32K_CK_PDN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_32K_CK_PDN_MASK 0x1
#define PMIC_RG_AUXADC_32K_CK_PDN_SHIFT 8
#define PMIC_RG_AUXADC_1K_CK_PDN_ADDR MT6356_HK_TOP_CLK_CON0
#define PMIC_RG_AUXADC_1K_CK_PDN_MASK 0x1
#define PMIC_RG_AUXADC_1K_CK_PDN_SHIFT 9
#define PMIC_RG_AUXADC_CK_DIVSEL_ADDR MT6356_HK_TOP_CLK_CON1
#define PMIC_RG_AUXADC_CK_DIVSEL_MASK 0x1
#define PMIC_RG_AUXADC_CK_DIVSEL_SHIFT 0
#define PMIC_RG_AUXADC_CK_TSTSEL_ADDR MT6356_HK_TOP_CLK_CON1
#define PMIC_RG_AUXADC_CK_TSTSEL_MASK 0x1
#define PMIC_RG_AUXADC_CK_TSTSEL_SHIFT 1
#define PMIC_RG_AUXADC_INTRP_CK_PDN_ADDR MT6356_HK_TOP_CLK_CON1
#define PMIC_RG_AUXADC_INTRP_CK_PDN_MASK 0x1
#define PMIC_RG_AUXADC_INTRP_CK_PDN_SHIFT 2
#define PMIC_RG_AUXADC_RST_ADDR MT6356_HK_TOP_RST_CON0
#define PMIC_RG_AUXADC_RST_MASK 0x1
#define PMIC_RG_AUXADC_RST_SHIFT 0
#define PMIC_RG_AUXADC_REG_RST_ADDR MT6356_HK_TOP_RST_CON0
#define PMIC_RG_AUXADC_REG_RST_MASK 0x1
#define PMIC_RG_AUXADC_REG_RST_SHIFT 1
#define PMIC_BANK_HK_TOP_SWRST_ADDR MT6356_HK_TOP_RST_CON0
#define PMIC_BANK_HK_TOP_SWRST_MASK 0x1
#define PMIC_BANK_HK_TOP_SWRST_SHIFT 2
#define PMIC_BANK_AUXADC_SWRST_ADDR MT6356_HK_TOP_RST_CON0
#define PMIC_BANK_AUXADC_SWRST_MASK 0x1
#define PMIC_BANK_AUXADC_SWRST_SHIFT 3
#define PMIC_BANK_AUXADC_DIG_1_SWRST_ADDR MT6356_HK_TOP_RST_CON0
#define PMIC_BANK_AUXADC_DIG_1_SWRST_MASK 0x1
#define PMIC_BANK_AUXADC_DIG_1_SWRST_SHIFT 4
#define PMIC_BANK_AUXADC_DIG_2_SWRST_ADDR MT6356_HK_TOP_RST_CON0
#define PMIC_BANK_AUXADC_DIG_2_SWRST_MASK 0x1
#define PMIC_BANK_AUXADC_DIG_2_SWRST_SHIFT 5
#define PMIC_RG_INT_EN_THR_H_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_THR_H_MASK 0x1
#define PMIC_RG_INT_EN_THR_H_SHIFT 0
#define PMIC_RG_INT_EN_THR_L_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_THR_L_MASK 0x1
#define PMIC_RG_INT_EN_THR_L_SHIFT 1
#define PMIC_RG_INT_EN_BAT_H_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_BAT_H_MASK 0x1
#define PMIC_RG_INT_EN_BAT_H_SHIFT 2
#define PMIC_RG_INT_EN_BAT_L_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_BAT_L_MASK 0x1
#define PMIC_RG_INT_EN_BAT_L_SHIFT 3
#define PMIC_RG_INT_EN_BAT2_H_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_BAT2_H_MASK 0x1
#define PMIC_RG_INT_EN_BAT2_H_SHIFT 4
#define PMIC_RG_INT_EN_BAT2_L_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_BAT2_L_MASK 0x1
#define PMIC_RG_INT_EN_BAT2_L_SHIFT 5
#define PMIC_RG_INT_EN_BAT_TEMP_H_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_BAT_TEMP_H_MASK 0x1
#define PMIC_RG_INT_EN_BAT_TEMP_H_SHIFT 6
#define PMIC_RG_INT_EN_BAT_TEMP_L_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_BAT_TEMP_L_MASK 0x1
#define PMIC_RG_INT_EN_BAT_TEMP_L_SHIFT 7
#define PMIC_RG_INT_EN_AUXADC_IMP_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_AUXADC_IMP_MASK 0x1
#define PMIC_RG_INT_EN_AUXADC_IMP_SHIFT 8
#define PMIC_RG_INT_EN_NAG_C_DLTV_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_NAG_C_DLTV_MASK 0x1
#define PMIC_RG_INT_EN_NAG_C_DLTV_SHIFT 9
#define PMIC_RG_INT_EN_JEITA_HOT_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_JEITA_HOT_MASK 0x1
#define PMIC_RG_INT_EN_JEITA_HOT_SHIFT 10
#define PMIC_RG_INT_EN_JEITA_WARM_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_JEITA_WARM_MASK 0x1
#define PMIC_RG_INT_EN_JEITA_WARM_SHIFT 11
#define PMIC_RG_INT_EN_JEITA_COOL_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_JEITA_COOL_MASK 0x1
#define PMIC_RG_INT_EN_JEITA_COOL_SHIFT 12
#define PMIC_RG_INT_EN_JEITA_COLD_ADDR MT6356_HK_TOP_INT_CON0
#define PMIC_RG_INT_EN_JEITA_COLD_MASK 0x1
#define PMIC_RG_INT_EN_JEITA_COLD_SHIFT 13
#define PMIC_HK_INT_CON0_SET_ADDR MT6356_HK_TOP_INT_CON0_SET
#define PMIC_HK_INT_CON0_SET_MASK 0xFFFF
#define PMIC_HK_INT_CON0_SET_SHIFT 0
#define PMIC_HK_INT_CON0_CLR_ADDR MT6356_HK_TOP_INT_CON0_CLR
#define PMIC_HK_INT_CON0_CLR_MASK 0xFFFF
#define PMIC_HK_INT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_EN_TYPEC_H_MAX_ADDR MT6356_HK_TOP_INT_CON1
#define PMIC_RG_INT_EN_TYPEC_H_MAX_MASK 0x1
#define PMIC_RG_INT_EN_TYPEC_H_MAX_SHIFT 0
#define PMIC_RG_INT_EN_TYPEC_H_MIN_ADDR MT6356_HK_TOP_INT_CON1
#define PMIC_RG_INT_EN_TYPEC_H_MIN_MASK 0x1
#define PMIC_RG_INT_EN_TYPEC_H_MIN_SHIFT 1
#define PMIC_RG_INT_EN_TYPEC_L_MAX_ADDR MT6356_HK_TOP_INT_CON1
#define PMIC_RG_INT_EN_TYPEC_L_MAX_MASK 0x1
#define PMIC_RG_INT_EN_TYPEC_L_MAX_SHIFT 2
#define PMIC_RG_INT_EN_TYPEC_L_MIN_ADDR MT6356_HK_TOP_INT_CON1
#define PMIC_RG_INT_EN_TYPEC_L_MIN_MASK 0x1
#define PMIC_RG_INT_EN_TYPEC_L_MIN_SHIFT 3
#define PMIC_HK_INT_CON1_SET_ADDR MT6356_HK_TOP_INT_CON1_SET
#define PMIC_HK_INT_CON1_SET_MASK 0xFFFF
#define PMIC_HK_INT_CON1_SET_SHIFT 0
#define PMIC_HK_INT_CON1_CLR_ADDR MT6356_HK_TOP_INT_CON1_CLR
#define PMIC_HK_INT_CON1_CLR_MASK 0xFFFF
#define PMIC_HK_INT_CON1_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_THR_H_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_THR_H_MASK 0x1
#define PMIC_RG_INT_MASK_THR_H_SHIFT 0
#define PMIC_RG_INT_MASK_THR_L_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_THR_L_MASK 0x1
#define PMIC_RG_INT_MASK_THR_L_SHIFT 1
#define PMIC_RG_INT_MASK_BAT_H_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_BAT_H_MASK 0x1
#define PMIC_RG_INT_MASK_BAT_H_SHIFT 2
#define PMIC_RG_INT_MASK_BAT_L_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_BAT_L_MASK 0x1
#define PMIC_RG_INT_MASK_BAT_L_SHIFT 3
#define PMIC_RG_INT_MASK_BAT2_H_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_BAT2_H_MASK 0x1
#define PMIC_RG_INT_MASK_BAT2_H_SHIFT 4
#define PMIC_RG_INT_MASK_BAT2_L_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_BAT2_L_MASK 0x1
#define PMIC_RG_INT_MASK_BAT2_L_SHIFT 5
#define PMIC_RG_INT_MASK_BAT_TEMP_H_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_BAT_TEMP_H_MASK 0x1
#define PMIC_RG_INT_MASK_BAT_TEMP_H_SHIFT 6
#define PMIC_RG_INT_MASK_BAT_TEMP_L_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_BAT_TEMP_L_MASK 0x1
#define PMIC_RG_INT_MASK_BAT_TEMP_L_SHIFT 7
#define PMIC_RG_INT_MASK_AUXADC_IMP_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_AUXADC_IMP_MASK 0x1
#define PMIC_RG_INT_MASK_AUXADC_IMP_SHIFT 8
#define PMIC_RG_INT_MASK_NAG_C_DLTV_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_NAG_C_DLTV_MASK 0x1
#define PMIC_RG_INT_MASK_NAG_C_DLTV_SHIFT 9
#define PMIC_RG_INT_MASK_JEITA_HOT_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_JEITA_HOT_MASK 0x1
#define PMIC_RG_INT_MASK_JEITA_HOT_SHIFT 10
#define PMIC_RG_INT_MASK_JEITA_WARM_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_JEITA_WARM_MASK 0x1
#define PMIC_RG_INT_MASK_JEITA_WARM_SHIFT 11
#define PMIC_RG_INT_MASK_JEITA_COOL_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_JEITA_COOL_MASK 0x1
#define PMIC_RG_INT_MASK_JEITA_COOL_SHIFT 12
#define PMIC_RG_INT_MASK_JEITA_COLD_ADDR MT6356_HK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_JEITA_COLD_MASK 0x1
#define PMIC_RG_INT_MASK_JEITA_COLD_SHIFT 13
#define PMIC_HK_INT_MASK_CON0_SET_ADDR MT6356_HK_TOP_INT_MASK_CON0_SET
#define PMIC_HK_INT_MASK_CON0_SET_MASK 0xFFFF
#define PMIC_HK_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_HK_INT_MASK_CON0_CLR_ADDR MT6356_HK_TOP_INT_MASK_CON0_CLR
#define PMIC_HK_INT_MASK_CON0_CLR_MASK 0xFFFF
#define PMIC_HK_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_TYPEC_H_MAX_ADDR MT6356_HK_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_TYPEC_H_MAX_MASK 0x1
#define PMIC_RG_INT_MASK_TYPEC_H_MAX_SHIFT 0
#define PMIC_RG_INT_MASK_TYPEC_H_MIN_ADDR MT6356_HK_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_TYPEC_H_MIN_MASK 0x1
#define PMIC_RG_INT_MASK_TYPEC_H_MIN_SHIFT 1
#define PMIC_RG_INT_MASK_TYPEC_L_MAX_ADDR MT6356_HK_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_TYPEC_L_MAX_MASK 0x1
#define PMIC_RG_INT_MASK_TYPEC_L_MAX_SHIFT 2
#define PMIC_RG_INT_MASK_TYPEC_L_MIN_ADDR MT6356_HK_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_TYPEC_L_MIN_MASK 0x1
#define PMIC_RG_INT_MASK_TYPEC_L_MIN_SHIFT 3
#define PMIC_HK_INT_MASK_CON1_SET_ADDR MT6356_HK_TOP_INT_MASK_CON1_SET
#define PMIC_HK_INT_MASK_CON1_SET_MASK 0xFFFF
#define PMIC_HK_INT_MASK_CON1_SET_SHIFT 0
#define PMIC_HK_INT_MASK_CON1_CLR_ADDR MT6356_HK_TOP_INT_MASK_CON1_CLR
#define PMIC_HK_INT_MASK_CON1_CLR_MASK 0xFFFF
#define PMIC_HK_INT_MASK_CON1_CLR_SHIFT 0
#define PMIC_RG_INT_STATUS_THR_H_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_THR_H_MASK 0x1
#define PMIC_RG_INT_STATUS_THR_H_SHIFT 0
#define PMIC_RG_INT_STATUS_THR_L_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_THR_L_MASK 0x1
#define PMIC_RG_INT_STATUS_THR_L_SHIFT 1
#define PMIC_RG_INT_STATUS_BAT_H_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_BAT_H_MASK 0x1
#define PMIC_RG_INT_STATUS_BAT_H_SHIFT 2
#define PMIC_RG_INT_STATUS_BAT_L_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_BAT_L_MASK 0x1
#define PMIC_RG_INT_STATUS_BAT_L_SHIFT 3
#define PMIC_RG_INT_STATUS_BAT2_H_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_BAT2_H_MASK 0x1
#define PMIC_RG_INT_STATUS_BAT2_H_SHIFT 4
#define PMIC_RG_INT_STATUS_BAT2_L_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_BAT2_L_MASK 0x1
#define PMIC_RG_INT_STATUS_BAT2_L_SHIFT 5
#define PMIC_RG_INT_STATUS_BAT_TEMP_H_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_BAT_TEMP_H_MASK 0x1
#define PMIC_RG_INT_STATUS_BAT_TEMP_H_SHIFT 6
#define PMIC_RG_INT_STATUS_BAT_TEMP_L_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_BAT_TEMP_L_MASK 0x1
#define PMIC_RG_INT_STATUS_BAT_TEMP_L_SHIFT 7
#define PMIC_RG_INT_STATUS_AUXADC_IMP_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_AUXADC_IMP_MASK 0x1
#define PMIC_RG_INT_STATUS_AUXADC_IMP_SHIFT 8
#define PMIC_RG_INT_STATUS_NAG_C_DLTV_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_NAG_C_DLTV_MASK 0x1
#define PMIC_RG_INT_STATUS_NAG_C_DLTV_SHIFT 9
#define PMIC_RG_INT_STATUS_JEITA_HOT_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_JEITA_HOT_MASK 0x1
#define PMIC_RG_INT_STATUS_JEITA_HOT_SHIFT 10
#define PMIC_RG_INT_STATUS_JEITA_WARM_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_JEITA_WARM_MASK 0x1
#define PMIC_RG_INT_STATUS_JEITA_WARM_SHIFT 11
#define PMIC_RG_INT_STATUS_JEITA_COOL_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_JEITA_COOL_MASK 0x1
#define PMIC_RG_INT_STATUS_JEITA_COOL_SHIFT 12
#define PMIC_RG_INT_STATUS_JEITA_COLD_ADDR MT6356_HK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_JEITA_COLD_MASK 0x1
#define PMIC_RG_INT_STATUS_JEITA_COLD_SHIFT 13
#define PMIC_RG_INT_STATUS_TYPEC_H_MAX_ADDR MT6356_HK_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_TYPEC_H_MAX_MASK 0x1
#define PMIC_RG_INT_STATUS_TYPEC_H_MAX_SHIFT 0
#define PMIC_RG_INT_STATUS_TYPEC_H_MIN_ADDR MT6356_HK_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_TYPEC_H_MIN_MASK 0x1
#define PMIC_RG_INT_STATUS_TYPEC_H_MIN_SHIFT 1
#define PMIC_RG_INT_STATUS_TYPEC_L_MAX_ADDR MT6356_HK_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_TYPEC_L_MAX_MASK 0x1
#define PMIC_RG_INT_STATUS_TYPEC_L_MAX_SHIFT 2
#define PMIC_RG_INT_STATUS_TYPEC_L_MIN_ADDR MT6356_HK_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_TYPEC_L_MIN_MASK 0x1
#define PMIC_RG_INT_STATUS_TYPEC_L_MIN_SHIFT 3
#define PMIC_RG_INT_RAW_STATUS_THR_H_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_THR_H_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_THR_H_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_THR_L_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_THR_L_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_THR_L_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_BAT_H_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_BAT_H_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BAT_H_SHIFT 2
#define PMIC_RG_INT_RAW_STATUS_BAT_L_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_BAT_L_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BAT_L_SHIFT 3
#define PMIC_RG_INT_RAW_STATUS_BAT2_H_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_BAT2_H_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BAT2_H_SHIFT 4
#define PMIC_RG_INT_RAW_STATUS_BAT2_L_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_BAT2_L_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BAT2_L_SHIFT 5
#define PMIC_RG_INT_RAW_STATUS_BAT_TEMP_H_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_BAT_TEMP_H_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BAT_TEMP_H_SHIFT 6
#define PMIC_RG_INT_RAW_STATUS_BAT_TEMP_L_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_BAT_TEMP_L_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_BAT_TEMP_L_SHIFT 7
#define PMIC_RG_INT_RAW_STATUS_AUXADC_IMP_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_AUXADC_IMP_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_AUXADC_IMP_SHIFT 8
#define PMIC_RG_INT_RAW_STATUS_NAG_C_DLTV_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_NAG_C_DLTV_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_NAG_C_DLTV_SHIFT 9
#define PMIC_RG_INT_RAW_STATUS_JEITA_HOT_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_JEITA_HOT_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_JEITA_HOT_SHIFT 10
#define PMIC_RG_INT_RAW_STATUS_JEITA_WARM_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_JEITA_WARM_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_JEITA_WARM_SHIFT 11
#define PMIC_RG_INT_RAW_STATUS_JEITA_COOL_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_JEITA_COOL_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_JEITA_COOL_SHIFT 12
#define PMIC_RG_INT_RAW_STATUS_JEITA_COLD_ADDR MT6356_HK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_JEITA_COLD_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_JEITA_COLD_SHIFT 13
#define PMIC_RG_INT_RAW_STATUS_TYPEC_H_MAX_ADDR MT6356_HK_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_TYPEC_H_MAX_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_TYPEC_H_MAX_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_TYPEC_H_MIN_ADDR MT6356_HK_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_TYPEC_H_MIN_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_TYPEC_H_MIN_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_TYPEC_L_MAX_ADDR MT6356_HK_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_TYPEC_L_MAX_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_TYPEC_L_MAX_SHIFT 2
#define PMIC_RG_INT_RAW_STATUS_TYPEC_L_MIN_ADDR MT6356_HK_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_TYPEC_L_MIN_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_TYPEC_L_MIN_SHIFT 3
#define PMIC_RG_CLK_MON_FLAG_EN_ADDR MT6356_HK_TOP_MON_CON0
#define PMIC_RG_CLK_MON_FLAG_EN_MASK 0x1
#define PMIC_RG_CLK_MON_FLAG_EN_SHIFT 0
#define PMIC_RG_CLK_MON_FLAG_SEL_ADDR MT6356_HK_TOP_MON_CON0
#define PMIC_RG_CLK_MON_FLAG_SEL_MASK 0xFF
#define PMIC_RG_CLK_MON_FLAG_SEL_SHIFT 1
#define PMIC_RG_INT_MON_FLAG_EN_ADDR MT6356_HK_TOP_MON_CON1
#define PMIC_RG_INT_MON_FLAG_EN_MASK 0x1
#define PMIC_RG_INT_MON_FLAG_EN_SHIFT 0
#define PMIC_RG_INT_MON_FLAG_SEL_ADDR MT6356_HK_TOP_MON_CON1
#define PMIC_RG_INT_MON_FLAG_SEL_MASK 0xFF
#define PMIC_RG_INT_MON_FLAG_SEL_SHIFT 1
#define PMIC_RG_HK_MON_FLAG_SEL_ADDR MT6356_HK_TOP_MON_CON2
#define PMIC_RG_HK_MON_FLAG_SEL_MASK 0xFF
#define PMIC_RG_HK_MON_FLAG_SEL_SHIFT 0
#define PMIC_RG_MON_FLAG_SEL_AUXADC_ADDR MT6356_HK_TOP_MON_CON2
#define PMIC_RG_MON_FLAG_SEL_AUXADC_MASK 0x1
#define PMIC_RG_MON_FLAG_SEL_AUXADC_SHIFT 8
#define PMIC_AUXADC_ANA_ID_ADDR MT6356_AUXADC_ID
#define PMIC_AUXADC_ANA_ID_MASK 0xFF
#define PMIC_AUXADC_ANA_ID_SHIFT 0
#define PMIC_AUXADC_DIG_ID_ADDR MT6356_AUXADC_ID
#define PMIC_AUXADC_DIG_ID_MASK 0xFF
#define PMIC_AUXADC_DIG_ID_SHIFT 8
#define PMIC_AUXADC_ANA_MINOR_REV_ADDR MT6356_AUXADC_REV0
#define PMIC_AUXADC_ANA_MINOR_REV_MASK 0xF
#define PMIC_AUXADC_ANA_MINOR_REV_SHIFT 0
#define PMIC_AUXADC_ANA_MAJOR_REV_ADDR MT6356_AUXADC_REV0
#define PMIC_AUXADC_ANA_MAJOR_REV_MASK 0xF
#define PMIC_AUXADC_ANA_MAJOR_REV_SHIFT 4
#define PMIC_AUXADC_DIG_MINOR_REV_ADDR MT6356_AUXADC_REV0
#define PMIC_AUXADC_DIG_MINOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_MINOR_REV_SHIFT 8
#define PMIC_AUXADC_DIG_MAJOR_REV_ADDR MT6356_AUXADC_REV0
#define PMIC_AUXADC_DIG_MAJOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_MAJOR_REV_SHIFT 12
#define PMIC_AUXADC_SW_MINOR_REV_ADDR MT6356_AUXADC_REV1
#define PMIC_AUXADC_SW_MINOR_REV_MASK 0xF
#define PMIC_AUXADC_SW_MINOR_REV_SHIFT 0
#define PMIC_AUXADC_SW_MAJOR_REV_ADDR MT6356_AUXADC_REV1
#define PMIC_AUXADC_SW_MAJOR_REV_MASK 0xF
#define PMIC_AUXADC_SW_MAJOR_REV_SHIFT 4
#define PMIC_AUXADC_ESP_ADDR MT6356_AUXADC_REV1
#define PMIC_AUXADC_ESP_MASK 0xFF
#define PMIC_AUXADC_ESP_SHIFT 8
#define PMIC_RG_AUXADC_CALI_ADDR MT6356_AUXADC_ANA_CON0
#define PMIC_RG_AUXADC_CALI_MASK 0xF
#define PMIC_RG_AUXADC_CALI_SHIFT 0
#define PMIC_RG_AUX_RSV_ADDR MT6356_AUXADC_ANA_CON0
#define PMIC_RG_AUX_RSV_MASK 0xF
#define PMIC_RG_AUX_RSV_SHIFT 4
#define PMIC_RG_VBUF_BYP_ADDR MT6356_AUXADC_ANA_CON0
#define PMIC_RG_VBUF_BYP_MASK 0x1
#define PMIC_RG_VBUF_BYP_SHIFT 8
#define PMIC_RG_VBUF_CALEN_ADDR MT6356_AUXADC_ANA_CON0
#define PMIC_RG_VBUF_CALEN_MASK 0x1
#define PMIC_RG_VBUF_CALEN_SHIFT 9
#define PMIC_RG_VBUF_EXTEN_ADDR MT6356_AUXADC_ANA_CON0
#define PMIC_RG_VBUF_EXTEN_MASK 0x1
#define PMIC_RG_VBUF_EXTEN_SHIFT 10
#define PMIC_AUXADC_DIG_1_ANA_ID_ADDR MT6356_AUXADC_DIG_1_ID
#define PMIC_AUXADC_DIG_1_ANA_ID_MASK 0xFF
#define PMIC_AUXADC_DIG_1_ANA_ID_SHIFT 0
#define PMIC_AUXADC_DIG_1_DIG_ID_ADDR MT6356_AUXADC_DIG_1_ID
#define PMIC_AUXADC_DIG_1_DIG_ID_MASK 0xFF
#define PMIC_AUXADC_DIG_1_DIG_ID_SHIFT 8
#define PMIC_AUXADC_DIG_1_ANA_MINOR_REV_ADDR MT6356_AUXADC_DIG_1_REV0
#define PMIC_AUXADC_DIG_1_ANA_MINOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_1_ANA_MINOR_REV_SHIFT 0
#define PMIC_AUXADC_DIG_1_ANA_MAJOR_REV_ADDR MT6356_AUXADC_DIG_1_REV0
#define PMIC_AUXADC_DIG_1_ANA_MAJOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_1_ANA_MAJOR_REV_SHIFT 4
#define PMIC_AUXADC_DIG_1_DIG_MINOR_REV_ADDR MT6356_AUXADC_DIG_1_REV0
#define PMIC_AUXADC_DIG_1_DIG_MINOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_1_DIG_MINOR_REV_SHIFT 8
#define PMIC_AUXADC_DIG_1_DIG_MAJOR_REV_ADDR MT6356_AUXADC_DIG_1_REV0
#define PMIC_AUXADC_DIG_1_DIG_MAJOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_1_DIG_MAJOR_REV_SHIFT 12
#define PMIC_AUXADC_DIG_1_SW_MINOR_REV_ADDR MT6356_AUXADC_DIG_1_REV1
#define PMIC_AUXADC_DIG_1_SW_MINOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_1_SW_MINOR_REV_SHIFT 0
#define PMIC_AUXADC_DIG_1_SW_MAJOR_REV_ADDR MT6356_AUXADC_DIG_1_REV1
#define PMIC_AUXADC_DIG_1_SW_MAJOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_1_SW_MAJOR_REV_SHIFT 4
#define PMIC_AUXADC_DIG_1_ESP_ADDR MT6356_AUXADC_DIG_1_REV1
#define PMIC_AUXADC_DIG_1_ESP_MASK 0xFF
#define PMIC_AUXADC_DIG_1_ESP_SHIFT 8
#define PMIC_AUXADC_ADC_OUT_CH0_ADDR MT6356_AUXADC_ADC0
#define PMIC_AUXADC_ADC_OUT_CH0_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH0_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH0_ADDR MT6356_AUXADC_ADC0
#define PMIC_AUXADC_ADC_RDY_CH0_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH0_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH1_ADDR MT6356_AUXADC_ADC1
#define PMIC_AUXADC_ADC_OUT_CH1_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH1_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH1_ADDR MT6356_AUXADC_ADC1
#define PMIC_AUXADC_ADC_RDY_CH1_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH1_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH2_ADDR MT6356_AUXADC_ADC2
#define PMIC_AUXADC_ADC_OUT_CH2_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH2_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH2_ADDR MT6356_AUXADC_ADC2
#define PMIC_AUXADC_ADC_RDY_CH2_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH2_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH3_ADDR MT6356_AUXADC_ADC3
#define PMIC_AUXADC_ADC_OUT_CH3_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH3_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH3_ADDR MT6356_AUXADC_ADC3
#define PMIC_AUXADC_ADC_RDY_CH3_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH3_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH4_ADDR MT6356_AUXADC_ADC4
#define PMIC_AUXADC_ADC_OUT_CH4_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH4_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH4_ADDR MT6356_AUXADC_ADC4
#define PMIC_AUXADC_ADC_RDY_CH4_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH4_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH5_ADDR MT6356_AUXADC_ADC5
#define PMIC_AUXADC_ADC_OUT_CH5_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH5_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH5_ADDR MT6356_AUXADC_ADC5
#define PMIC_AUXADC_ADC_RDY_CH5_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH5_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH6_ADDR MT6356_AUXADC_ADC6
#define PMIC_AUXADC_ADC_OUT_CH6_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH6_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH6_ADDR MT6356_AUXADC_ADC6
#define PMIC_AUXADC_ADC_RDY_CH6_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH6_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH7_ADDR MT6356_AUXADC_ADC7
#define PMIC_AUXADC_ADC_OUT_CH7_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH7_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH7_ADDR MT6356_AUXADC_ADC7
#define PMIC_AUXADC_ADC_RDY_CH7_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH7_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH8_ADDR MT6356_AUXADC_ADC8
#define PMIC_AUXADC_ADC_OUT_CH8_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH8_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH8_ADDR MT6356_AUXADC_ADC8
#define PMIC_AUXADC_ADC_RDY_CH8_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH8_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH9_ADDR MT6356_AUXADC_ADC9
#define PMIC_AUXADC_ADC_OUT_CH9_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH9_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH9_ADDR MT6356_AUXADC_ADC9
#define PMIC_AUXADC_ADC_RDY_CH9_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH9_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH10_ADDR MT6356_AUXADC_ADC10
#define PMIC_AUXADC_ADC_OUT_CH10_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH10_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH10_ADDR MT6356_AUXADC_ADC10
#define PMIC_AUXADC_ADC_RDY_CH10_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH10_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH11_ADDR MT6356_AUXADC_ADC11
#define PMIC_AUXADC_ADC_OUT_CH11_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH11_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH11_ADDR MT6356_AUXADC_ADC11
#define PMIC_AUXADC_ADC_RDY_CH11_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH11_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH12_15_ADDR MT6356_AUXADC_ADC12
#define PMIC_AUXADC_ADC_OUT_CH12_15_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH12_15_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH12_15_ADDR MT6356_AUXADC_ADC12
#define PMIC_AUXADC_ADC_RDY_CH12_15_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH12_15_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_THR_HW_ADDR MT6356_AUXADC_ADC13
#define PMIC_AUXADC_ADC_OUT_THR_HW_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_THR_HW_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_THR_HW_ADDR MT6356_AUXADC_ADC13
#define PMIC_AUXADC_ADC_RDY_THR_HW_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_THR_HW_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_LBAT_ADDR MT6356_AUXADC_ADC14
#define PMIC_AUXADC_ADC_OUT_LBAT_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_LBAT_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_LBAT_ADDR MT6356_AUXADC_ADC14
#define PMIC_AUXADC_ADC_RDY_LBAT_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_LBAT_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_LBAT2_ADDR MT6356_AUXADC_ADC15
#define PMIC_AUXADC_ADC_OUT_LBAT2_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_LBAT2_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_LBAT2_ADDR MT6356_AUXADC_ADC15
#define PMIC_AUXADC_ADC_RDY_LBAT2_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_LBAT2_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_ADDR MT6356_AUXADC_ADC16
#define PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_ADDR MT6356_AUXADC_ADC16
#define PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH7_BY_MD_ADDR MT6356_AUXADC_ADC17
#define PMIC_AUXADC_ADC_OUT_CH7_BY_MD_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH7_BY_MD_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH7_BY_MD_ADDR MT6356_AUXADC_ADC17
#define PMIC_AUXADC_ADC_RDY_CH7_BY_MD_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH7_BY_MD_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH7_BY_AP_ADDR MT6356_AUXADC_ADC18
#define PMIC_AUXADC_ADC_OUT_CH7_BY_AP_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH7_BY_AP_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH7_BY_AP_ADDR MT6356_AUXADC_ADC18
#define PMIC_AUXADC_ADC_RDY_CH7_BY_AP_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH7_BY_AP_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH4_BY_MD_ADDR MT6356_AUXADC_ADC19
#define PMIC_AUXADC_ADC_OUT_CH4_BY_MD_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH4_BY_MD_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH4_BY_MD_ADDR MT6356_AUXADC_ADC19
#define PMIC_AUXADC_ADC_RDY_CH4_BY_MD_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH4_BY_MD_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_PWRON_PCHR_ADDR MT6356_AUXADC_ADC20
#define PMIC_AUXADC_ADC_OUT_PWRON_PCHR_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_PWRON_PCHR_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_PWRON_PCHR_ADDR MT6356_AUXADC_ADC20
#define PMIC_AUXADC_ADC_RDY_PWRON_PCHR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_PWRON_PCHR_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_PWRON_SWCHR_ADDR MT6356_AUXADC_ADC21
#define PMIC_AUXADC_ADC_OUT_PWRON_SWCHR_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_PWRON_SWCHR_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_PWRON_SWCHR_ADDR MT6356_AUXADC_ADC21
#define PMIC_AUXADC_ADC_RDY_PWRON_SWCHR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_PWRON_SWCHR_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_ADDR MT6356_AUXADC_ADC22
#define PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_ADDR MT6356_AUXADC_ADC22
#define PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_ADDR MT6356_AUXADC_ADC23
#define PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_ADDR MT6356_AUXADC_ADC23
#define PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH0_BY_MD_ADDR MT6356_AUXADC_ADC24
#define PMIC_AUXADC_ADC_OUT_CH0_BY_MD_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH0_BY_MD_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH0_BY_MD_ADDR MT6356_AUXADC_ADC24
#define PMIC_AUXADC_ADC_RDY_CH0_BY_MD_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH0_BY_MD_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH0_BY_AP_ADDR MT6356_AUXADC_ADC25
#define PMIC_AUXADC_ADC_OUT_CH0_BY_AP_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH0_BY_AP_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH0_BY_AP_ADDR MT6356_AUXADC_ADC25
#define PMIC_AUXADC_ADC_RDY_CH0_BY_AP_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH0_BY_AP_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH1_BY_MD_ADDR MT6356_AUXADC_ADC26
#define PMIC_AUXADC_ADC_OUT_CH1_BY_MD_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH1_BY_MD_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH1_BY_MD_ADDR MT6356_AUXADC_ADC26
#define PMIC_AUXADC_ADC_RDY_CH1_BY_MD_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH1_BY_MD_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH1_BY_AP_ADDR MT6356_AUXADC_ADC27
#define PMIC_AUXADC_ADC_OUT_CH1_BY_AP_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH1_BY_AP_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH1_BY_AP_ADDR MT6356_AUXADC_ADC27
#define PMIC_AUXADC_ADC_RDY_CH1_BY_AP_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH1_BY_AP_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_BAT_TEMP_ADDR MT6356_AUXADC_ADC28
#define PMIC_AUXADC_ADC_OUT_BAT_TEMP_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_BAT_TEMP_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_BAT_TEMP_ADDR MT6356_AUXADC_ADC28
#define PMIC_AUXADC_ADC_RDY_BAT_TEMP_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_BAT_TEMP_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_FGADC_PCHR_ADDR MT6356_AUXADC_ADC29
#define PMIC_AUXADC_ADC_OUT_FGADC_PCHR_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_FGADC_PCHR_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_FGADC_PCHR_ADDR MT6356_AUXADC_ADC29
#define PMIC_AUXADC_ADC_RDY_FGADC_PCHR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_FGADC_PCHR_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_FGADC_SWCHR_ADDR MT6356_AUXADC_ADC30
#define PMIC_AUXADC_ADC_OUT_FGADC_SWCHR_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_FGADC_SWCHR_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_FGADC_SWCHR_ADDR MT6356_AUXADC_ADC30
#define PMIC_AUXADC_ADC_RDY_FGADC_SWCHR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_FGADC_SWCHR_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_ADDR MT6356_AUXADC_ADC31
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR_ADDR MT6356_AUXADC_ADC31
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR_ADDR MT6356_AUXADC_ADC32
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR_ADDR MT6356_AUXADC_ADC32
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_IMP_ADDR MT6356_AUXADC_ADC33
#define PMIC_AUXADC_ADC_OUT_IMP_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_IMP_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_IMP_ADDR MT6356_AUXADC_ADC33
#define PMIC_AUXADC_ADC_RDY_IMP_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_IMP_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_IMP_AVG_ADDR MT6356_AUXADC_ADC34
#define PMIC_AUXADC_ADC_OUT_IMP_AVG_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_IMP_AVG_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_IMP_AVG_ADDR MT6356_AUXADC_ADC34
#define PMIC_AUXADC_ADC_RDY_IMP_AVG_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_IMP_AVG_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_RAW_ADDR MT6356_AUXADC_ADC35
#define PMIC_AUXADC_ADC_OUT_RAW_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_RAW_SHIFT 0
#define PMIC_AUXADC_ADC_OUT_MDRT_ADDR MT6356_AUXADC_ADC36
#define PMIC_AUXADC_ADC_OUT_MDRT_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_MDRT_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_MDRT_ADDR MT6356_AUXADC_ADC36
#define PMIC_AUXADC_ADC_RDY_MDRT_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_MDRT_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_JEITA_ADDR MT6356_AUXADC_ADC37
#define PMIC_AUXADC_ADC_OUT_JEITA_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_JEITA_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_JEITA_ADDR MT6356_AUXADC_ADC37
#define PMIC_AUXADC_ADC_RDY_JEITA_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_JEITA_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_ADDR MT6356_AUXADC_ADC38
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_ADDR MT6356_AUXADC_ADC38
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_ADDR MT6356_AUXADC_ADC39
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_ADDR MT6356_AUXADC_ADC39
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_ADDR MT6356_AUXADC_ADC40
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_ADDR MT6356_AUXADC_ADC40
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_DCXO_MDRT_ADDR MT6356_AUXADC_ADC41
#define PMIC_AUXADC_ADC_OUT_DCXO_MDRT_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_DCXO_MDRT_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_DCXO_MDRT_ADDR MT6356_AUXADC_ADC41
#define PMIC_AUXADC_ADC_RDY_DCXO_MDRT_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_DCXO_MDRT_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_NAG_ADDR MT6356_AUXADC_ADC42
#define PMIC_AUXADC_ADC_OUT_NAG_MASK 0x7FFF
#define PMIC_AUXADC_ADC_OUT_NAG_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_NAG_ADDR MT6356_AUXADC_ADC42
#define PMIC_AUXADC_ADC_RDY_NAG_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_NAG_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_BATID_ADDR MT6356_AUXADC_ADC43
#define PMIC_AUXADC_ADC_OUT_BATID_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_BATID_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_BATID_ADDR MT6356_AUXADC_ADC43
#define PMIC_AUXADC_ADC_RDY_BATID_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_BATID_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_TYPEC_H_ADDR MT6356_AUXADC_ADC44
#define PMIC_AUXADC_ADC_OUT_TYPEC_H_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_TYPEC_H_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_TYPEC_H_ADDR MT6356_AUXADC_ADC44
#define PMIC_AUXADC_ADC_RDY_TYPEC_H_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_TYPEC_H_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_TYPEC_L_ADDR MT6356_AUXADC_ADC45
#define PMIC_AUXADC_ADC_OUT_TYPEC_L_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_TYPEC_L_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_TYPEC_L_ADDR MT6356_AUXADC_ADC45
#define PMIC_AUXADC_ADC_RDY_TYPEC_L_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_TYPEC_L_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH4_BY_THR1_ADDR MT6356_AUXADC_ADC46
#define PMIC_AUXADC_ADC_OUT_CH4_BY_THR1_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH4_BY_THR1_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH4_BY_THR1_ADDR MT6356_AUXADC_ADC46
#define PMIC_AUXADC_ADC_RDY_CH4_BY_THR1_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH4_BY_THR1_SHIFT 15
#define PMIC_AUXADC_ADC_OUT_CH4_BY_THR2_ADDR MT6356_AUXADC_ADC47
#define PMIC_AUXADC_ADC_OUT_CH4_BY_THR2_MASK 0xFFF
#define PMIC_AUXADC_ADC_OUT_CH4_BY_THR2_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_CH4_BY_THR2_ADDR MT6356_AUXADC_ADC47
#define PMIC_AUXADC_ADC_RDY_CH4_BY_THR2_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_CH4_BY_THR2_SHIFT 15
#define PMIC_AUXADC_ADC_BUSY_IN_ADDR MT6356_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_MASK 0xFFF
#define PMIC_AUXADC_ADC_BUSY_IN_SHIFT 0
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT_ADDR MT6356_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT_SHIFT 12
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT2_ADDR MT6356_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT2_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT2_SHIFT 13
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP_ADDR MT6356_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP_SHIFT 14
#define PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_ADDR MT6356_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_SHIFT 15
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_SHIFT 0
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_SHIFT 1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_SHIFT 2
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_SHIFT 3
#define PMIC_AUXADC_ADC_BUSY_IN_JEITA_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_JEITA_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_JEITA_SHIFT 4
#define PMIC_AUXADC_ADC_BUSY_IN_MDRT_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_MDRT_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_MDRT_SHIFT 5
#define PMIC_AUXADC_ADC_BUSY_IN_SHARE_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_SHARE_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_SHARE_SHIFT 7
#define PMIC_AUXADC_ADC_BUSY_IN_IMP_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_IMP_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_IMP_SHIFT 8
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR_SHIFT 9
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR_SHIFT 10
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_SHIFT 11
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_SHIFT 12
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_SHIFT 13
#define PMIC_AUXADC_ADC_BUSY_IN_THR_HW_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_THR_HW_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_THR_HW_SHIFT 14
#define PMIC_AUXADC_ADC_BUSY_IN_THR_MD_ADDR MT6356_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_THR_MD_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_THR_MD_SHIFT 15
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR_ADDR MT6356_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR_SHIFT 0
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR_ADDR MT6356_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR_SHIFT 1
#define PMIC_AUXADC_ADC_BUSY_IN_BATID_ADDR MT6356_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_BATID_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_BATID_SHIFT 2
#define PMIC_AUXADC_ADC_BUSY_IN_PWRON_ADDR MT6356_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_PWRON_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_PWRON_SHIFT 3
#define PMIC_AUXADC_ADC_BUSY_IN_THR1_ADDR MT6356_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_THR1_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_THR1_SHIFT 11
#define PMIC_AUXADC_ADC_BUSY_IN_THR2_ADDR MT6356_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_THR2_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_THR2_SHIFT 12
#define PMIC_AUXADC_ADC_BUSY_IN_TYPEC_H_ADDR MT6356_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_TYPEC_H_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_TYPEC_H_SHIFT 13
#define PMIC_AUXADC_ADC_BUSY_IN_TYPEC_L_ADDR MT6356_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_TYPEC_L_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_TYPEC_L_SHIFT 14
#define PMIC_AUXADC_ADC_BUSY_IN_NAG_ADDR MT6356_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_NAG_MASK 0x1
#define PMIC_AUXADC_ADC_BUSY_IN_NAG_SHIFT 15
#define PMIC_AUXADC_RQST_CH0_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH0_MASK 0x1
#define PMIC_AUXADC_RQST_CH0_SHIFT 0
#define PMIC_AUXADC_RQST_CH1_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH1_MASK 0x1
#define PMIC_AUXADC_RQST_CH1_SHIFT 1
#define PMIC_AUXADC_RQST_CH2_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH2_MASK 0x1
#define PMIC_AUXADC_RQST_CH2_SHIFT 2
#define PMIC_AUXADC_RQST_CH3_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH3_MASK 0x1
#define PMIC_AUXADC_RQST_CH3_SHIFT 3
#define PMIC_AUXADC_RQST_CH4_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH4_MASK 0x1
#define PMIC_AUXADC_RQST_CH4_SHIFT 4
#define PMIC_AUXADC_RQST_CH5_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH5_MASK 0x1
#define PMIC_AUXADC_RQST_CH5_SHIFT 5
#define PMIC_AUXADC_RQST_CH6_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH6_MASK 0x1
#define PMIC_AUXADC_RQST_CH6_SHIFT 6
#define PMIC_AUXADC_RQST_CH7_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH7_MASK 0x1
#define PMIC_AUXADC_RQST_CH7_SHIFT 7
#define PMIC_AUXADC_RQST_CH8_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH8_MASK 0x1
#define PMIC_AUXADC_RQST_CH8_SHIFT 8
#define PMIC_AUXADC_RQST_CH9_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH9_MASK 0x1
#define PMIC_AUXADC_RQST_CH9_SHIFT 9
#define PMIC_AUXADC_RQST_CH10_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH10_MASK 0x1
#define PMIC_AUXADC_RQST_CH10_SHIFT 10
#define PMIC_AUXADC_RQST_CH11_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH11_MASK 0x1
#define PMIC_AUXADC_RQST_CH11_SHIFT 11
#define PMIC_AUXADC_RQST_CH12_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH12_MASK 0x1
#define PMIC_AUXADC_RQST_CH12_SHIFT 12
#define PMIC_AUXADC_RQST_CH13_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH13_MASK 0x1
#define PMIC_AUXADC_RQST_CH13_SHIFT 13
#define PMIC_AUXADC_RQST_CH14_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH14_MASK 0x1
#define PMIC_AUXADC_RQST_CH14_SHIFT 14
#define PMIC_AUXADC_RQST_CH15_ADDR MT6356_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH15_MASK 0x1
#define PMIC_AUXADC_RQST_CH15_SHIFT 15
#define PMIC_AUXADC_RQST0_SET_ADDR MT6356_AUXADC_RQST0_SET
#define PMIC_AUXADC_RQST0_SET_MASK 0xFFFF
#define PMIC_AUXADC_RQST0_SET_SHIFT 0
#define PMIC_AUXADC_RQST0_CLR_ADDR MT6356_AUXADC_RQST0_CLR
#define PMIC_AUXADC_RQST0_CLR_MASK 0xFFFF
#define PMIC_AUXADC_RQST0_CLR_SHIFT 0
#define PMIC_AUXADC_RQST_CH4_BY_THR1_ADDR MT6356_AUXADC_RQST2
#define PMIC_AUXADC_RQST_CH4_BY_THR1_MASK 0x1
#define PMIC_AUXADC_RQST_CH4_BY_THR1_SHIFT 5
#define PMIC_AUXADC_RQST_CH4_BY_THR2_ADDR MT6356_AUXADC_RQST2
#define PMIC_AUXADC_RQST_CH4_BY_THR2_MASK 0x1
#define PMIC_AUXADC_RQST_CH4_BY_THR2_SHIFT 6
#define PMIC_AUXADC_RQST2_SET_ADDR MT6356_AUXADC_RQST2_SET
#define PMIC_AUXADC_RQST2_SET_MASK 0xFFFF
#define PMIC_AUXADC_RQST2_SET_SHIFT 0
#define PMIC_AUXADC_RQST2_CLR_ADDR MT6356_AUXADC_RQST2_CLR
#define PMIC_AUXADC_RQST2_CLR_MASK 0xFFFF
#define PMIC_AUXADC_RQST2_CLR_SHIFT 0
#define PMIC_AUXADC_RQST_CH0_BY_MD_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH0_BY_MD_MASK 0x1
#define PMIC_AUXADC_RQST_CH0_BY_MD_SHIFT 0
#define PMIC_AUXADC_RQST_CH1_BY_MD_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH1_BY_MD_MASK 0x1
#define PMIC_AUXADC_RQST_CH1_BY_MD_SHIFT 1
#define PMIC_AUXADC_RQST_RSV0_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_RSV0_MASK 0x1
#define PMIC_AUXADC_RQST_RSV0_SHIFT 2
#define PMIC_AUXADC_RQST_BATID_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_BATID_MASK 0x1
#define PMIC_AUXADC_RQST_BATID_SHIFT 3
#define PMIC_AUXADC_RQST_CH4_BY_MD_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH4_BY_MD_MASK 0x1
#define PMIC_AUXADC_RQST_CH4_BY_MD_SHIFT 4
#define PMIC_AUXADC_RQST_CH7_BY_MD_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH7_BY_MD_MASK 0x1
#define PMIC_AUXADC_RQST_CH7_BY_MD_SHIFT 7
#define PMIC_AUXADC_RQST_CH7_BY_GPS_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH7_BY_GPS_MASK 0x1
#define PMIC_AUXADC_RQST_CH7_BY_GPS_SHIFT 8
#define PMIC_AUXADC_RQST_DCXO_BY_MD_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_DCXO_BY_MD_MASK 0x1
#define PMIC_AUXADC_RQST_DCXO_BY_MD_SHIFT 9
#define PMIC_AUXADC_RQST_DCXO_BY_GPS_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_DCXO_BY_GPS_MASK 0x1
#define PMIC_AUXADC_RQST_DCXO_BY_GPS_SHIFT 10
#define PMIC_AUXADC_RQST_RSV1_ADDR MT6356_AUXADC_RQST1
#define PMIC_AUXADC_RQST_RSV1_MASK 0x1F
#define PMIC_AUXADC_RQST_RSV1_SHIFT 11
#define PMIC_AUXADC_RQST1_SET_ADDR MT6356_AUXADC_RQST1_SET
#define PMIC_AUXADC_RQST1_SET_MASK 0xFFFF
#define PMIC_AUXADC_RQST1_SET_SHIFT 0
#define PMIC_AUXADC_RQST1_CLR_ADDR MT6356_AUXADC_RQST1_CLR
#define PMIC_AUXADC_RQST1_CLR_MASK 0xFFFF
#define PMIC_AUXADC_RQST1_CLR_SHIFT 0
#define PMIC_AUXADC_CK_ON_EXTD_ADDR MT6356_AUXADC_CON0
#define PMIC_AUXADC_CK_ON_EXTD_MASK 0x3F
#define PMIC_AUXADC_CK_ON_EXTD_SHIFT 0
#define PMIC_AUXADC_SRCLKEN_SRC_SEL_ADDR MT6356_AUXADC_CON0
#define PMIC_AUXADC_SRCLKEN_SRC_SEL_MASK 0x3
#define PMIC_AUXADC_SRCLKEN_SRC_SEL_SHIFT 6
#define PMIC_AUXADC_ADC_PWDB_ADDR MT6356_AUXADC_CON0
#define PMIC_AUXADC_ADC_PWDB_MASK 0x1
#define PMIC_AUXADC_ADC_PWDB_SHIFT 8
#define PMIC_AUXADC_ADC_PWDB_SWCTRL_ADDR MT6356_AUXADC_CON0
#define PMIC_AUXADC_ADC_PWDB_SWCTRL_MASK 0x1
#define PMIC_AUXADC_ADC_PWDB_SWCTRL_SHIFT 9
#define PMIC_AUXADC_STRUP_CK_ON_ENB_ADDR MT6356_AUXADC_CON0
#define PMIC_AUXADC_STRUP_CK_ON_ENB_MASK 0x1
#define PMIC_AUXADC_STRUP_CK_ON_ENB_SHIFT 10
#define PMIC_AUXADC_SRCLKEN_CK_EN_ADDR MT6356_AUXADC_CON0
#define PMIC_AUXADC_SRCLKEN_CK_EN_MASK 0x1
#define PMIC_AUXADC_SRCLKEN_CK_EN_SHIFT 12
#define PMIC_AUXADC_CK_AON_GPS_ADDR MT6356_AUXADC_CON0
#define PMIC_AUXADC_CK_AON_GPS_MASK 0x1
#define PMIC_AUXADC_CK_AON_GPS_SHIFT 13
#define PMIC_AUXADC_CK_AON_MD_ADDR MT6356_AUXADC_CON0
#define PMIC_AUXADC_CK_AON_MD_MASK 0x1
#define PMIC_AUXADC_CK_AON_MD_SHIFT 14
#define PMIC_AUXADC_CK_AON_ADDR MT6356_AUXADC_CON0
#define PMIC_AUXADC_CK_AON_MASK 0x1
#define PMIC_AUXADC_CK_AON_SHIFT 15
#define PMIC_AUXADC_CON0_SET_ADDR MT6356_AUXADC_CON0_SET
#define PMIC_AUXADC_CON0_SET_MASK 0xFFFF
#define PMIC_AUXADC_CON0_SET_SHIFT 0
#define PMIC_AUXADC_CON0_CLR_ADDR MT6356_AUXADC_CON0_CLR
#define PMIC_AUXADC_CON0_CLR_MASK 0xFFFF
#define PMIC_AUXADC_CON0_CLR_SHIFT 0
#define PMIC_AUXADC_AVG_NUM_SMALL_ADDR MT6356_AUXADC_CON1
#define PMIC_AUXADC_AVG_NUM_SMALL_MASK 0x7
#define PMIC_AUXADC_AVG_NUM_SMALL_SHIFT 0
#define PMIC_AUXADC_AVG_NUM_LARGE_ADDR MT6356_AUXADC_CON1
#define PMIC_AUXADC_AVG_NUM_LARGE_MASK 0x7
#define PMIC_AUXADC_AVG_NUM_LARGE_SHIFT 3
#define PMIC_AUXADC_SPL_NUM_ADDR MT6356_AUXADC_CON1
#define PMIC_AUXADC_SPL_NUM_MASK 0x3FF
#define PMIC_AUXADC_SPL_NUM_SHIFT 6
#define PMIC_AUXADC_AVG_NUM_SEL_ADDR MT6356_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_MASK 0xFFF
#define PMIC_AUXADC_AVG_NUM_SEL_SHIFT 0
#define PMIC_AUXADC_AVG_NUM_SEL_SHARE_ADDR MT6356_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_SHARE_MASK 0x1
#define PMIC_AUXADC_AVG_NUM_SEL_SHARE_SHIFT 12
#define PMIC_AUXADC_AVG_NUM_SEL_LBAT_ADDR MT6356_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_LBAT_MASK 0x1
#define PMIC_AUXADC_AVG_NUM_SEL_LBAT_SHIFT 13
#define PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP_ADDR MT6356_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP_MASK 0x1
#define PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP_SHIFT 14
#define PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_ADDR MT6356_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_MASK 0x1
#define PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_SHIFT 15
#define PMIC_AUXADC_SPL_NUM_LARGE_ADDR MT6356_AUXADC_CON3
#define PMIC_AUXADC_SPL_NUM_LARGE_MASK 0x3FF
#define PMIC_AUXADC_SPL_NUM_LARGE_SHIFT 0
#define PMIC_AUXADC_SPL_NUM_SLEEP_ADDR MT6356_AUXADC_CON4
#define PMIC_AUXADC_SPL_NUM_SLEEP_MASK 0x3FF
#define PMIC_AUXADC_SPL_NUM_SLEEP_SHIFT 0
#define PMIC_AUXADC_SPL_NUM_SLEEP_SEL_ADDR MT6356_AUXADC_CON4
#define PMIC_AUXADC_SPL_NUM_SLEEP_SEL_MASK 0x1
#define PMIC_AUXADC_SPL_NUM_SLEEP_SEL_SHIFT 15
#define PMIC_AUXADC_SPL_NUM_SEL_ADDR MT6356_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_MASK 0xFFF
#define PMIC_AUXADC_SPL_NUM_SEL_SHIFT 0
#define PMIC_AUXADC_SPL_NUM_SEL_SHARE_ADDR MT6356_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_SHARE_MASK 0x1
#define PMIC_AUXADC_SPL_NUM_SEL_SHARE_SHIFT 12
#define PMIC_AUXADC_SPL_NUM_SEL_LBAT_ADDR MT6356_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_LBAT_MASK 0x1
#define PMIC_AUXADC_SPL_NUM_SEL_LBAT_SHIFT 13
#define PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP_ADDR MT6356_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP_MASK 0x1
#define PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP_SHIFT 14
#define PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_ADDR MT6356_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_MASK 0x1
#define PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_SHIFT 15
#define PMIC_AUXADC_SPL_NUM_CH0_ADDR MT6356_AUXADC_CON6
#define PMIC_AUXADC_SPL_NUM_CH0_MASK 0x3FF
#define PMIC_AUXADC_SPL_NUM_CH0_SHIFT 0
#define PMIC_AUXADC_SPL_NUM_CH3_ADDR MT6356_AUXADC_CON7
#define PMIC_AUXADC_SPL_NUM_CH3_MASK 0x3FF
#define PMIC_AUXADC_SPL_NUM_CH3_SHIFT 0
#define PMIC_AUXADC_SPL_NUM_CH7_ADDR MT6356_AUXADC_CON8
#define PMIC_AUXADC_SPL_NUM_CH7_MASK 0x3FF
#define PMIC_AUXADC_SPL_NUM_CH7_SHIFT 0
#define PMIC_AUXADC_AVG_NUM_LBAT_ADDR MT6356_AUXADC_CON9
#define PMIC_AUXADC_AVG_NUM_LBAT_MASK 0x7
#define PMIC_AUXADC_AVG_NUM_LBAT_SHIFT 0
#define PMIC_AUXADC_AVG_NUM_CH7_ADDR MT6356_AUXADC_CON9
#define PMIC_AUXADC_AVG_NUM_CH7_MASK 0x7
#define PMIC_AUXADC_AVG_NUM_CH7_SHIFT 4
#define PMIC_AUXADC_AVG_NUM_CH3_ADDR MT6356_AUXADC_CON9
#define PMIC_AUXADC_AVG_NUM_CH3_MASK 0x7
#define PMIC_AUXADC_AVG_NUM_CH3_SHIFT 8
#define PMIC_AUXADC_AVG_NUM_CH0_ADDR MT6356_AUXADC_CON9
#define PMIC_AUXADC_AVG_NUM_CH0_MASK 0x7
#define PMIC_AUXADC_AVG_NUM_CH0_SHIFT 12
#define PMIC_AUXADC_AVG_NUM_HPC_ADDR MT6356_AUXADC_CON10
#define PMIC_AUXADC_AVG_NUM_HPC_MASK 0x7
#define PMIC_AUXADC_AVG_NUM_HPC_SHIFT 0
#define PMIC_AUXADC_AVG_NUM_DCXO_ADDR MT6356_AUXADC_CON10
#define PMIC_AUXADC_AVG_NUM_DCXO_MASK 0x7
#define PMIC_AUXADC_AVG_NUM_DCXO_SHIFT 4
#define PMIC_AUXADC_TRIM_CH0_SEL_ADDR MT6356_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH0_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH0_SEL_SHIFT 0
#define PMIC_AUXADC_TRIM_CH1_SEL_ADDR MT6356_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH1_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH1_SEL_SHIFT 2
#define PMIC_AUXADC_TRIM_CH2_SEL_ADDR MT6356_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH2_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH2_SEL_SHIFT 4
#define PMIC_AUXADC_TRIM_CH3_SEL_ADDR MT6356_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH3_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH3_SEL_SHIFT 6
#define PMIC_AUXADC_TRIM_CH4_SEL_ADDR MT6356_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH4_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH4_SEL_SHIFT 8
#define PMIC_AUXADC_TRIM_CH5_SEL_ADDR MT6356_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH5_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH5_SEL_SHIFT 10
#define PMIC_AUXADC_TRIM_CH6_SEL_ADDR MT6356_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH6_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH6_SEL_SHIFT 12
#define PMIC_AUXADC_TRIM_CH7_SEL_ADDR MT6356_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH7_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH7_SEL_SHIFT 14
#define PMIC_AUXADC_TRIM_CH8_SEL_ADDR MT6356_AUXADC_CON12
#define PMIC_AUXADC_TRIM_CH8_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH8_SEL_SHIFT 0
#define PMIC_AUXADC_TRIM_CH9_SEL_ADDR MT6356_AUXADC_CON12
#define PMIC_AUXADC_TRIM_CH9_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH9_SEL_SHIFT 2
#define PMIC_AUXADC_TRIM_CH10_SEL_ADDR MT6356_AUXADC_CON12
#define PMIC_AUXADC_TRIM_CH10_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH10_SEL_SHIFT 4
#define PMIC_AUXADC_TRIM_CH11_SEL_ADDR MT6356_AUXADC_CON12
#define PMIC_AUXADC_TRIM_CH11_SEL_MASK 0x3
#define PMIC_AUXADC_TRIM_CH11_SEL_SHIFT 6
#define PMIC_AUXADC_ADC_2S_COMP_ENB_ADDR MT6356_AUXADC_CON12
#define PMIC_AUXADC_ADC_2S_COMP_ENB_MASK 0x1
#define PMIC_AUXADC_ADC_2S_COMP_ENB_SHIFT 14
#define PMIC_AUXADC_ADC_TRIM_COMP_ADDR MT6356_AUXADC_CON12
#define PMIC_AUXADC_ADC_TRIM_COMP_MASK 0x1
#define PMIC_AUXADC_ADC_TRIM_COMP_SHIFT 15
#define PMIC_AUXADC_RNG_EN_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_RNG_EN_MASK 0x1
#define PMIC_AUXADC_RNG_EN_SHIFT 0
#define PMIC_AUXADC_TEST_MODE_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_TEST_MODE_MASK 0x1
#define PMIC_AUXADC_TEST_MODE_SHIFT 3
#define PMIC_AUXADC_BIT_SEL_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_BIT_SEL_MASK 0x1
#define PMIC_AUXADC_BIT_SEL_SHIFT 4
#define PMIC_AUXADC_START_SW_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_START_SW_MASK 0x1
#define PMIC_AUXADC_START_SW_SHIFT 5
#define PMIC_AUXADC_START_SWCTRL_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_START_SWCTRL_MASK 0x1
#define PMIC_AUXADC_START_SWCTRL_SHIFT 6
#define PMIC_AUXADC_TS_VBE_SEL_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_TS_VBE_SEL_MASK 0x7
#define PMIC_AUXADC_TS_VBE_SEL_SHIFT 7
#define PMIC_AUXADC_TS_VBE_SEL_SWCTRL_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_TS_VBE_SEL_SWCTRL_MASK 0x1
#define PMIC_AUXADC_TS_VBE_SEL_SWCTRL_SHIFT 10
#define PMIC_AUXADC_VBUF_EN_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_VBUF_EN_MASK 0x1
#define PMIC_AUXADC_VBUF_EN_SHIFT 11
#define PMIC_AUXADC_VBUF_EN_SWCTRL_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_VBUF_EN_SWCTRL_MASK 0x1
#define PMIC_AUXADC_VBUF_EN_SWCTRL_SHIFT 12
#define PMIC_AUXADC_OUT_SEL_ADDR MT6356_AUXADC_CON13
#define PMIC_AUXADC_OUT_SEL_MASK 0x1
#define PMIC_AUXADC_OUT_SEL_SHIFT 13
#define PMIC_AUXADC_DA_DAC_ADDR MT6356_AUXADC_CON14
#define PMIC_AUXADC_DA_DAC_MASK 0xFFF
#define PMIC_AUXADC_DA_DAC_SHIFT 0
#define PMIC_AUXADC_DA_DAC_SWCTRL_ADDR MT6356_AUXADC_CON14
#define PMIC_AUXADC_DA_DAC_SWCTRL_MASK 0x1
#define PMIC_AUXADC_DA_DAC_SWCTRL_SHIFT 12
#define PMIC_AD_AUXADC_COMP_ADDR MT6356_AUXADC_CON14
#define PMIC_AD_AUXADC_COMP_MASK 0x1
#define PMIC_AD_AUXADC_COMP_SHIFT 15
#define PMIC_AUXADC_ADCIN_VSEN_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_ADCIN_VSEN_EN_MASK 0x1
#define PMIC_AUXADC_ADCIN_VSEN_EN_SHIFT 0
#define PMIC_AUXADC_ADCIN_VBAT_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_ADCIN_VBAT_EN_MASK 0x1
#define PMIC_AUXADC_ADCIN_VBAT_EN_SHIFT 1
#define PMIC_AUXADC_ADCIN_VSEN_MUX_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_ADCIN_VSEN_MUX_EN_MASK 0x1
#define PMIC_AUXADC_ADCIN_VSEN_MUX_EN_SHIFT 2
#define PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_MASK 0x1
#define PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_SHIFT 3
#define PMIC_AUXADC_ADCIN_CHR_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_ADCIN_CHR_EN_MASK 0x1
#define PMIC_AUXADC_ADCIN_CHR_EN_SHIFT 4
#define PMIC_AUXADC_ADCIN_BATON_TDET_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_ADCIN_BATON_TDET_EN_MASK 0x1
#define PMIC_AUXADC_ADCIN_BATON_TDET_EN_SHIFT 5
#define PMIC_AUXADC_ACCDET_ANASWCTRL_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_ACCDET_ANASWCTRL_EN_MASK 0x1
#define PMIC_AUXADC_ACCDET_ANASWCTRL_EN_SHIFT 6
#define PMIC_AUXADC_XO_THADC_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_XO_THADC_EN_MASK 0x1
#define PMIC_AUXADC_XO_THADC_EN_SHIFT 7
#define PMIC_AUXADC_ADCIN_BATID_SW_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_ADCIN_BATID_SW_EN_MASK 0x1
#define PMIC_AUXADC_ADCIN_BATID_SW_EN_SHIFT 8
#define PMIC_AUXADC_DIG0_RSV0_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_DIG0_RSV0_MASK 0x3
#define PMIC_AUXADC_DIG0_RSV0_SHIFT 9
#define PMIC_AUXADC_CHSEL_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_CHSEL_MASK 0xF
#define PMIC_AUXADC_CHSEL_SHIFT 11
#define PMIC_AUXADC_SWCTRL_EN_ADDR MT6356_AUXADC_CON15
#define PMIC_AUXADC_SWCTRL_EN_MASK 0x1
#define PMIC_AUXADC_SWCTRL_EN_SHIFT 15
#define PMIC_AUXADC_SOURCE_LBAT_SEL_ADDR MT6356_AUXADC_CON16
#define PMIC_AUXADC_SOURCE_LBAT_SEL_MASK 0x1
#define PMIC_AUXADC_SOURCE_LBAT_SEL_SHIFT 0
#define PMIC_AUXADC_SOURCE_LBAT2_SEL_ADDR MT6356_AUXADC_CON16
#define PMIC_AUXADC_SOURCE_LBAT2_SEL_MASK 0x1
#define PMIC_AUXADC_SOURCE_LBAT2_SEL_SHIFT 1
#define PMIC_AUXADC_START_EXTD_ADDR MT6356_AUXADC_CON16
#define PMIC_AUXADC_START_EXTD_MASK 0x7F
#define PMIC_AUXADC_START_EXTD_SHIFT 2
#define PMIC_AUXADC_DAC_EXTD_ADDR MT6356_AUXADC_CON16
#define PMIC_AUXADC_DAC_EXTD_MASK 0xF
#define PMIC_AUXADC_DAC_EXTD_SHIFT 11
#define PMIC_AUXADC_DAC_EXTD_EN_ADDR MT6356_AUXADC_CON16
#define PMIC_AUXADC_DAC_EXTD_EN_MASK 0x1
#define PMIC_AUXADC_DAC_EXTD_EN_SHIFT 15
#define PMIC_AUXADC_PMU_THR_PDN_SW_ADDR MT6356_AUXADC_CON17
#define PMIC_AUXADC_PMU_THR_PDN_SW_MASK 0x1
#define PMIC_AUXADC_PMU_THR_PDN_SW_SHIFT 10
#define PMIC_AUXADC_PMU_THR_PDN_SEL_ADDR MT6356_AUXADC_CON17
#define PMIC_AUXADC_PMU_THR_PDN_SEL_MASK 0x1
#define PMIC_AUXADC_PMU_THR_PDN_SEL_SHIFT 11
#define PMIC_AUXADC_PMU_THR_PDN_STATUS_ADDR MT6356_AUXADC_CON17
#define PMIC_AUXADC_PMU_THR_PDN_STATUS_MASK 0x1
#define PMIC_AUXADC_PMU_THR_PDN_STATUS_SHIFT 12
#define PMIC_AUXADC_DIG0_RSV1_ADDR MT6356_AUXADC_CON17
#define PMIC_AUXADC_DIG0_RSV1_MASK 0x7
#define PMIC_AUXADC_DIG0_RSV1_SHIFT 13
#define PMIC_AUXADC_START_SHADE_NUM_ADDR MT6356_AUXADC_CON18
#define PMIC_AUXADC_START_SHADE_NUM_MASK 0x3FF
#define PMIC_AUXADC_START_SHADE_NUM_SHIFT 0
#define PMIC_AUXADC_START_SHADE_EN_ADDR MT6356_AUXADC_CON18
#define PMIC_AUXADC_START_SHADE_EN_MASK 0x1
#define PMIC_AUXADC_START_SHADE_EN_SHIFT 14
#define PMIC_AUXADC_START_SHADE_SEL_ADDR MT6356_AUXADC_CON18
#define PMIC_AUXADC_START_SHADE_SEL_MASK 0x1
#define PMIC_AUXADC_START_SHADE_SEL_SHIFT 15
#define PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_ADDR MT6356_AUXADC_CON19
#define PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_SHIFT 0
#define PMIC_AUXADC_ADC_RDY_FGADC_CLR_ADDR MT6356_AUXADC_CON19
#define PMIC_AUXADC_ADC_RDY_FGADC_CLR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_FGADC_CLR_SHIFT 1
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR_ADDR MT6356_AUXADC_CON19
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR_SHIFT 2
#define PMIC_AUXADC_ADC_RDY_PWRON_CLR_ADDR MT6356_AUXADC_CON19
#define PMIC_AUXADC_ADC_RDY_PWRON_CLR_MASK 0x1
#define PMIC_AUXADC_ADC_RDY_PWRON_CLR_SHIFT 3
#define PMIC_AUXADC_DATA_REUSE_SEL_ADDR MT6356_AUXADC_CON20
#define PMIC_AUXADC_DATA_REUSE_SEL_MASK 0x3
#define PMIC_AUXADC_DATA_REUSE_SEL_SHIFT 0
#define PMIC_AUXADC_CH0_DATA_REUSE_SEL_ADDR MT6356_AUXADC_CON20
#define PMIC_AUXADC_CH0_DATA_REUSE_SEL_MASK 0x3
#define PMIC_AUXADC_CH0_DATA_REUSE_SEL_SHIFT 2
#define PMIC_AUXADC_CH1_DATA_REUSE_SEL_ADDR MT6356_AUXADC_CON20
#define PMIC_AUXADC_CH1_DATA_REUSE_SEL_MASK 0x3
#define PMIC_AUXADC_CH1_DATA_REUSE_SEL_SHIFT 4
#define PMIC_AUXADC_DCXO_DATA_REUSE_SEL_ADDR MT6356_AUXADC_CON20
#define PMIC_AUXADC_DCXO_DATA_REUSE_SEL_MASK 0x3
#define PMIC_AUXADC_DCXO_DATA_REUSE_SEL_SHIFT 6
#define PMIC_AUXADC_DATA_REUSE_EN_ADDR MT6356_AUXADC_CON20
#define PMIC_AUXADC_DATA_REUSE_EN_MASK 0x1
#define PMIC_AUXADC_DATA_REUSE_EN_SHIFT 8
#define PMIC_AUXADC_CH0_DATA_REUSE_EN_ADDR MT6356_AUXADC_CON20
#define PMIC_AUXADC_CH0_DATA_REUSE_EN_MASK 0x1
#define PMIC_AUXADC_CH0_DATA_REUSE_EN_SHIFT 9
#define PMIC_AUXADC_CH1_DATA_REUSE_EN_ADDR MT6356_AUXADC_CON20
#define PMIC_AUXADC_CH1_DATA_REUSE_EN_MASK 0x1
#define PMIC_AUXADC_CH1_DATA_REUSE_EN_SHIFT 10
#define PMIC_AUXADC_DCXO_DATA_REUSE_EN_ADDR MT6356_AUXADC_CON20
#define PMIC_AUXADC_DCXO_DATA_REUSE_EN_MASK 0x1
#define PMIC_AUXADC_DCXO_DATA_REUSE_EN_SHIFT 11
#define PMIC_AUXADC_AUTORPT_PRD_ADDR MT6356_AUXADC_AUTORPT0
#define PMIC_AUXADC_AUTORPT_PRD_MASK 0x3FF
#define PMIC_AUXADC_AUTORPT_PRD_SHIFT 0
#define PMIC_AUXADC_AUTORPT_EN_ADDR MT6356_AUXADC_AUTORPT0
#define PMIC_AUXADC_AUTORPT_EN_MASK 0x1
#define PMIC_AUXADC_AUTORPT_EN_SHIFT 15
#define PMIC_AUXADC_LBAT_DEBT_MAX_ADDR MT6356_AUXADC_LBAT0
#define PMIC_AUXADC_LBAT_DEBT_MAX_MASK 0xFF
#define PMIC_AUXADC_LBAT_DEBT_MAX_SHIFT 0
#define PMIC_AUXADC_LBAT_DEBT_MIN_ADDR MT6356_AUXADC_LBAT0
#define PMIC_AUXADC_LBAT_DEBT_MIN_MASK 0xFF
#define PMIC_AUXADC_LBAT_DEBT_MIN_SHIFT 8
#define PMIC_AUXADC_LBAT_DET_PRD_15_0_ADDR MT6356_AUXADC_LBAT1
#define PMIC_AUXADC_LBAT_DET_PRD_15_0_MASK 0xFFFF
#define PMIC_AUXADC_LBAT_DET_PRD_15_0_SHIFT 0
#define PMIC_AUXADC_LBAT_DET_PRD_19_16_ADDR MT6356_AUXADC_LBAT2
#define PMIC_AUXADC_LBAT_DET_PRD_19_16_MASK 0xF
#define PMIC_AUXADC_LBAT_DET_PRD_19_16_SHIFT 0
#define PMIC_AUXADC_LBAT_VOLT_MAX_ADDR MT6356_AUXADC_LBAT3
#define PMIC_AUXADC_LBAT_VOLT_MAX_MASK 0xFFF
#define PMIC_AUXADC_LBAT_VOLT_MAX_SHIFT 0
#define PMIC_AUXADC_LBAT_IRQ_EN_MAX_ADDR MT6356_AUXADC_LBAT3
#define PMIC_AUXADC_LBAT_IRQ_EN_MAX_MASK 0x1
#define PMIC_AUXADC_LBAT_IRQ_EN_MAX_SHIFT 12
#define PMIC_AUXADC_LBAT_EN_MAX_ADDR MT6356_AUXADC_LBAT3
#define PMIC_AUXADC_LBAT_EN_MAX_MASK 0x1
#define PMIC_AUXADC_LBAT_EN_MAX_SHIFT 13
#define PMIC_AUXADC_LBAT_MAX_IRQ_B_ADDR MT6356_AUXADC_LBAT3
#define PMIC_AUXADC_LBAT_MAX_IRQ_B_MASK 0x1
#define PMIC_AUXADC_LBAT_MAX_IRQ_B_SHIFT 15
#define PMIC_AUXADC_LBAT_VOLT_MIN_ADDR MT6356_AUXADC_LBAT4
#define PMIC_AUXADC_LBAT_VOLT_MIN_MASK 0xFFF
#define PMIC_AUXADC_LBAT_VOLT_MIN_SHIFT 0
#define PMIC_AUXADC_LBAT_IRQ_EN_MIN_ADDR MT6356_AUXADC_LBAT4
#define PMIC_AUXADC_LBAT_IRQ_EN_MIN_MASK 0x1
#define PMIC_AUXADC_LBAT_IRQ_EN_MIN_SHIFT 12
#define PMIC_AUXADC_LBAT_EN_MIN_ADDR MT6356_AUXADC_LBAT4
#define PMIC_AUXADC_LBAT_EN_MIN_MASK 0x1
#define PMIC_AUXADC_LBAT_EN_MIN_SHIFT 13
#define PMIC_AUXADC_LBAT_MIN_IRQ_B_ADDR MT6356_AUXADC_LBAT4
#define PMIC_AUXADC_LBAT_MIN_IRQ_B_MASK 0x1
#define PMIC_AUXADC_LBAT_MIN_IRQ_B_SHIFT 15
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_ADDR MT6356_AUXADC_LBAT5
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_MASK 0x1FF
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_SHIFT 0
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_ADDR MT6356_AUXADC_LBAT6
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_MASK 0x1FF
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_SHIFT 0
#define PMIC_AUXADC_ACCDET_AUTO_SPL_ADDR MT6356_AUXADC_ACCDET
#define PMIC_AUXADC_ACCDET_AUTO_SPL_MASK 0x1
#define PMIC_AUXADC_ACCDET_AUTO_SPL_SHIFT 0
#define PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_ADDR MT6356_AUXADC_ACCDET
#define PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_MASK 0x1
#define PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_SHIFT 1
#define PMIC_AUXADC_ACCDET_DIG1_RSV0_ADDR MT6356_AUXADC_ACCDET
#define PMIC_AUXADC_ACCDET_DIG1_RSV0_MASK 0x3F
#define PMIC_AUXADC_ACCDET_DIG1_RSV0_SHIFT 2
#define PMIC_AUXADC_ACCDET_DIG0_RSV0_ADDR MT6356_AUXADC_ACCDET
#define PMIC_AUXADC_ACCDET_DIG0_RSV0_MASK 0xFF
#define PMIC_AUXADC_ACCDET_DIG0_RSV0_SHIFT 8
#define PMIC_AUXADC_DIG_1_ELR_LEN_ADDR MT6356_AUXADC_DIG_1_ELR_NUM
#define PMIC_AUXADC_DIG_1_ELR_LEN_MASK 0xFF
#define PMIC_AUXADC_DIG_1_ELR_LEN_SHIFT 0
#define PMIC_AUXADC_SW_GAIN_TRIM_ADDR MT6356_AUXADC_DIG_1_ELR0
#define PMIC_AUXADC_SW_GAIN_TRIM_MASK 0x7FFF
#define PMIC_AUXADC_SW_GAIN_TRIM_SHIFT 0
#define PMIC_AUXADC_SW_OFFSET_TRIM_ADDR MT6356_AUXADC_DIG_1_ELR1
#define PMIC_AUXADC_SW_OFFSET_TRIM_MASK 0x7FFF
#define PMIC_AUXADC_SW_OFFSET_TRIM_SHIFT 0
#define PMIC_AUXADC_DIG_2_ANA_ID_ADDR MT6356_AUXADC_DIG_2_ID
#define PMIC_AUXADC_DIG_2_ANA_ID_MASK 0xFF
#define PMIC_AUXADC_DIG_2_ANA_ID_SHIFT 0
#define PMIC_AUXADC_DIG_2_DIG_ID_ADDR MT6356_AUXADC_DIG_2_ID
#define PMIC_AUXADC_DIG_2_DIG_ID_MASK 0xFF
#define PMIC_AUXADC_DIG_2_DIG_ID_SHIFT 8
#define PMIC_AUXADC_DIG_2_ANA_MINOR_REV_ADDR MT6356_AUXADC_DIG_2_REV0
#define PMIC_AUXADC_DIG_2_ANA_MINOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_2_ANA_MINOR_REV_SHIFT 0
#define PMIC_AUXADC_DIG_2_ANA_MAJOR_REV_ADDR MT6356_AUXADC_DIG_2_REV0
#define PMIC_AUXADC_DIG_2_ANA_MAJOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_2_ANA_MAJOR_REV_SHIFT 4
#define PMIC_AUXADC_DIG_2_DIG_MINOR_REV_ADDR MT6356_AUXADC_DIG_2_REV0
#define PMIC_AUXADC_DIG_2_DIG_MINOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_2_DIG_MINOR_REV_SHIFT 8
#define PMIC_AUXADC_DIG_2_DIG_MAJOR_REV_ADDR MT6356_AUXADC_DIG_2_REV0
#define PMIC_AUXADC_DIG_2_DIG_MAJOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_2_DIG_MAJOR_REV_SHIFT 12
#define PMIC_AUXADC_DIG_2_SW_MINOR_REV_ADDR MT6356_AUXADC_DIG_2_REV1
#define PMIC_AUXADC_DIG_2_SW_MINOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_2_SW_MINOR_REV_SHIFT 0
#define PMIC_AUXADC_DIG_2_SW_MAJOR_REV_ADDR MT6356_AUXADC_DIG_2_REV1
#define PMIC_AUXADC_DIG_2_SW_MAJOR_REV_MASK 0xF
#define PMIC_AUXADC_DIG_2_SW_MAJOR_REV_SHIFT 4
#define PMIC_AUXADC_DIG_2_ESP_ADDR MT6356_AUXADC_DIG_2_REV1
#define PMIC_AUXADC_DIG_2_ESP_MASK 0xFF
#define PMIC_AUXADC_DIG_2_ESP_SHIFT 8
#define PMIC_AUXADC_THR_DEBT_MAX_ADDR MT6356_AUXADC_THR0
#define PMIC_AUXADC_THR_DEBT_MAX_MASK 0xFF
#define PMIC_AUXADC_THR_DEBT_MAX_SHIFT 0
#define PMIC_AUXADC_THR_DEBT_MIN_ADDR MT6356_AUXADC_THR0
#define PMIC_AUXADC_THR_DEBT_MIN_MASK 0xFF
#define PMIC_AUXADC_THR_DEBT_MIN_SHIFT 8
#define PMIC_AUXADC_THR_DET_PRD_15_0_ADDR MT6356_AUXADC_THR1
#define PMIC_AUXADC_THR_DET_PRD_15_0_MASK 0xFFFF
#define PMIC_AUXADC_THR_DET_PRD_15_0_SHIFT 0
#define PMIC_AUXADC_THR_DET_PRD_19_16_ADDR MT6356_AUXADC_THR2
#define PMIC_AUXADC_THR_DET_PRD_19_16_MASK 0xF
#define PMIC_AUXADC_THR_DET_PRD_19_16_SHIFT 0
#define PMIC_AUXADC_THR_VOLT_MAX_ADDR MT6356_AUXADC_THR3
#define PMIC_AUXADC_THR_VOLT_MAX_MASK 0xFFF
#define PMIC_AUXADC_THR_VOLT_MAX_SHIFT 0
#define PMIC_AUXADC_THR_IRQ_EN_MAX_ADDR MT6356_AUXADC_THR3
#define PMIC_AUXADC_THR_IRQ_EN_MAX_MASK 0x1
#define PMIC_AUXADC_THR_IRQ_EN_MAX_SHIFT 12
#define PMIC_AUXADC_THR_EN_MAX_ADDR MT6356_AUXADC_THR3
#define PMIC_AUXADC_THR_EN_MAX_MASK 0x1
#define PMIC_AUXADC_THR_EN_MAX_SHIFT 13
#define PMIC_AUXADC_THR_MAX_IRQ_B_ADDR MT6356_AUXADC_THR3
#define PMIC_AUXADC_THR_MAX_IRQ_B_MASK 0x1
#define PMIC_AUXADC_THR_MAX_IRQ_B_SHIFT 15
#define PMIC_AUXADC_THR_VOLT_MIN_ADDR MT6356_AUXADC_THR4
#define PMIC_AUXADC_THR_VOLT_MIN_MASK 0xFFF
#define PMIC_AUXADC_THR_VOLT_MIN_SHIFT 0
#define PMIC_AUXADC_THR_IRQ_EN_MIN_ADDR MT6356_AUXADC_THR4
#define PMIC_AUXADC_THR_IRQ_EN_MIN_MASK 0x1
#define PMIC_AUXADC_THR_IRQ_EN_MIN_SHIFT 12
#define PMIC_AUXADC_THR_EN_MIN_ADDR MT6356_AUXADC_THR4
#define PMIC_AUXADC_THR_EN_MIN_MASK 0x1
#define PMIC_AUXADC_THR_EN_MIN_SHIFT 13
#define PMIC_AUXADC_THR_MIN_IRQ_B_ADDR MT6356_AUXADC_THR4
#define PMIC_AUXADC_THR_MIN_IRQ_B_MASK 0x1
#define PMIC_AUXADC_THR_MIN_IRQ_B_SHIFT 15
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_ADDR MT6356_AUXADC_THR5
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_MASK 0x1FF
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_SHIFT 0
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_ADDR MT6356_AUXADC_THR6
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_MASK 0x1FF
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_SHIFT 0
#define PMIC_AUXADC_FGADC_START_SW_ADDR MT6356_AUXADC_DBG0
#define PMIC_AUXADC_FGADC_START_SW_MASK 0x1
#define PMIC_AUXADC_FGADC_START_SW_SHIFT 0
#define PMIC_AUXADC_FGADC_START_SEL_ADDR MT6356_AUXADC_DBG0
#define PMIC_AUXADC_FGADC_START_SEL_MASK 0x1
#define PMIC_AUXADC_FGADC_START_SEL_SHIFT 1
#define PMIC_AUXADC_FGADC_R_SW_ADDR MT6356_AUXADC_DBG0
#define PMIC_AUXADC_FGADC_R_SW_MASK 0x1
#define PMIC_AUXADC_FGADC_R_SW_SHIFT 2
#define PMIC_AUXADC_FGADC_R_SEL_ADDR MT6356_AUXADC_DBG0
#define PMIC_AUXADC_FGADC_R_SEL_MASK 0x1
#define PMIC_AUXADC_FGADC_R_SEL_SHIFT 3
#define PMIC_AUXADC_BAT_PLUGIN_START_SW_ADDR MT6356_AUXADC_DBG0
#define PMIC_AUXADC_BAT_PLUGIN_START_SW_MASK 0x1
#define PMIC_AUXADC_BAT_PLUGIN_START_SW_SHIFT 4
#define PMIC_AUXADC_BAT_PLUGIN_START_SEL_ADDR MT6356_AUXADC_DBG0
#define PMIC_AUXADC_BAT_PLUGIN_START_SEL_MASK 0x1
#define PMIC_AUXADC_BAT_PLUGIN_START_SEL_SHIFT 5
#define PMIC_AUXADC_DBG_DIG0_RSV2_ADDR MT6356_AUXADC_DBG0
#define PMIC_AUXADC_DBG_DIG0_RSV2_MASK 0xF
#define PMIC_AUXADC_DBG_DIG0_RSV2_SHIFT 6
#define PMIC_AUXADC_DBG_DIG1_RSV2_ADDR MT6356_AUXADC_DBG0
#define PMIC_AUXADC_DBG_DIG1_RSV2_MASK 0x3F
#define PMIC_AUXADC_DBG_DIG1_RSV2_SHIFT 10
#define PMIC_AUXADC_IMPEDANCE_CNT_ADDR MT6356_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_CNT_MASK 0x3F
#define PMIC_AUXADC_IMPEDANCE_CNT_SHIFT 0
#define PMIC_AUXADC_IMPEDANCE_CHSEL_ADDR MT6356_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_CHSEL_MASK 0x1
#define PMIC_AUXADC_IMPEDANCE_CHSEL_SHIFT 6
#define PMIC_AUXADC_IMPEDANCE_IRQ_CLR_ADDR MT6356_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_IRQ_CLR_MASK 0x1
#define PMIC_AUXADC_IMPEDANCE_IRQ_CLR_SHIFT 7
#define PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_ADDR MT6356_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_MASK 0x1
#define PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_SHIFT 8
#define PMIC_AUXADC_CLR_IMP_CNT_STOP_ADDR MT6356_AUXADC_IMP0
#define PMIC_AUXADC_CLR_IMP_CNT_STOP_MASK 0x1
#define PMIC_AUXADC_CLR_IMP_CNT_STOP_SHIFT 14
#define PMIC_AUXADC_IMPEDANCE_MODE_ADDR MT6356_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_MODE_MASK 0x1
#define PMIC_AUXADC_IMPEDANCE_MODE_SHIFT 15
#define PMIC_AUXADC_IMP_AUTORPT_PRD_ADDR MT6356_AUXADC_IMP1
#define PMIC_AUXADC_IMP_AUTORPT_PRD_MASK 0x3FF
#define PMIC_AUXADC_IMP_AUTORPT_PRD_SHIFT 0
#define PMIC_AUXADC_IMP_AUTORPT_EN_ADDR MT6356_AUXADC_IMP1
#define PMIC_AUXADC_IMP_AUTORPT_EN_MASK 0x1
#define PMIC_AUXADC_IMP_AUTORPT_EN_SHIFT 15
#define PMIC_AUXADC_BAT_TEMP_FROZE_EN_ADDR MT6356_AUXADC_BAT_TEMP_0
#define PMIC_AUXADC_BAT_TEMP_FROZE_EN_MASK 0x1
#define PMIC_AUXADC_BAT_TEMP_FROZE_EN_SHIFT 0
#define PMIC_AUXADC_BAT_TEMP_DEBT_MAX_ADDR MT6356_AUXADC_BAT_TEMP_1
#define PMIC_AUXADC_BAT_TEMP_DEBT_MAX_MASK 0xFF
#define PMIC_AUXADC_BAT_TEMP_DEBT_MAX_SHIFT 0
#define PMIC_AUXADC_BAT_TEMP_DEBT_MIN_ADDR MT6356_AUXADC_BAT_TEMP_1
#define PMIC_AUXADC_BAT_TEMP_DEBT_MIN_MASK 0xFF
#define PMIC_AUXADC_BAT_TEMP_DEBT_MIN_SHIFT 8
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0_ADDR MT6356_AUXADC_BAT_TEMP_2
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0_MASK 0xFFFF
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0_SHIFT 0
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16_ADDR MT6356_AUXADC_BAT_TEMP_3
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16_MASK 0xF
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16_SHIFT 0
#define PMIC_AUXADC_BAT_TEMP_VOLT_MAX_ADDR MT6356_AUXADC_BAT_TEMP_4
#define PMIC_AUXADC_BAT_TEMP_VOLT_MAX_MASK 0xFFF
#define PMIC_AUXADC_BAT_TEMP_VOLT_MAX_SHIFT 0
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX_ADDR MT6356_AUXADC_BAT_TEMP_4
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX_MASK 0x1
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX_SHIFT 12
#define PMIC_AUXADC_BAT_TEMP_EN_MAX_ADDR MT6356_AUXADC_BAT_TEMP_4
#define PMIC_AUXADC_BAT_TEMP_EN_MAX_MASK 0x1
#define PMIC_AUXADC_BAT_TEMP_EN_MAX_SHIFT 13
#define PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B_ADDR MT6356_AUXADC_BAT_TEMP_4
#define PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B_MASK 0x1
#define PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B_SHIFT 15
#define PMIC_AUXADC_BAT_TEMP_VOLT_MIN_ADDR MT6356_AUXADC_BAT_TEMP_5
#define PMIC_AUXADC_BAT_TEMP_VOLT_MIN_MASK 0xFFF
#define PMIC_AUXADC_BAT_TEMP_VOLT_MIN_SHIFT 0
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN_ADDR MT6356_AUXADC_BAT_TEMP_5
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN_MASK 0x1
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN_SHIFT 12
#define PMIC_AUXADC_BAT_TEMP_EN_MIN_ADDR MT6356_AUXADC_BAT_TEMP_5
#define PMIC_AUXADC_BAT_TEMP_EN_MIN_MASK 0x1
#define PMIC_AUXADC_BAT_TEMP_EN_MIN_SHIFT 13
#define PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B_ADDR MT6356_AUXADC_BAT_TEMP_5
#define PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B_MASK 0x1
#define PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B_SHIFT 15
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX_ADDR MT6356_AUXADC_BAT_TEMP_6
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX_MASK 0x1FF
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX_SHIFT 0
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN_ADDR MT6356_AUXADC_BAT_TEMP_7
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN_MASK 0x1FF
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN_SHIFT 0
#define PMIC_AUXADC_LBAT2_DEBT_MAX_ADDR MT6356_AUXADC_LBAT2_1
#define PMIC_AUXADC_LBAT2_DEBT_MAX_MASK 0xFF
#define PMIC_AUXADC_LBAT2_DEBT_MAX_SHIFT 0
#define PMIC_AUXADC_LBAT2_DEBT_MIN_ADDR MT6356_AUXADC_LBAT2_1
#define PMIC_AUXADC_LBAT2_DEBT_MIN_MASK 0xFF
#define PMIC_AUXADC_LBAT2_DEBT_MIN_SHIFT 8
#define PMIC_AUXADC_LBAT2_DET_PRD_15_0_ADDR MT6356_AUXADC_LBAT2_2
#define PMIC_AUXADC_LBAT2_DET_PRD_15_0_MASK 0xFFFF
#define PMIC_AUXADC_LBAT2_DET_PRD_15_0_SHIFT 0
#define PMIC_AUXADC_LBAT2_DET_PRD_19_16_ADDR MT6356_AUXADC_LBAT2_3
#define PMIC_AUXADC_LBAT2_DET_PRD_19_16_MASK 0xF
#define PMIC_AUXADC_LBAT2_DET_PRD_19_16_SHIFT 0
#define PMIC_AUXADC_LBAT2_VOLT_MAX_ADDR MT6356_AUXADC_LBAT2_4
#define PMIC_AUXADC_LBAT2_VOLT_MAX_MASK 0xFFF
#define PMIC_AUXADC_LBAT2_VOLT_MAX_SHIFT 0
#define PMIC_AUXADC_LBAT2_IRQ_EN_MAX_ADDR MT6356_AUXADC_LBAT2_4
#define PMIC_AUXADC_LBAT2_IRQ_EN_MAX_MASK 0x1
#define PMIC_AUXADC_LBAT2_IRQ_EN_MAX_SHIFT 12
#define PMIC_AUXADC_LBAT2_EN_MAX_ADDR MT6356_AUXADC_LBAT2_4
#define PMIC_AUXADC_LBAT2_EN_MAX_MASK 0x1
#define PMIC_AUXADC_LBAT2_EN_MAX_SHIFT 13
#define PMIC_AUXADC_LBAT2_MAX_IRQ_B_ADDR MT6356_AUXADC_LBAT2_4
#define PMIC_AUXADC_LBAT2_MAX_IRQ_B_MASK 0x1
#define PMIC_AUXADC_LBAT2_MAX_IRQ_B_SHIFT 15
#define PMIC_AUXADC_LBAT2_VOLT_MIN_ADDR MT6356_AUXADC_LBAT2_5
#define PMIC_AUXADC_LBAT2_VOLT_MIN_MASK 0xFFF
#define PMIC_AUXADC_LBAT2_VOLT_MIN_SHIFT 0
#define PMIC_AUXADC_LBAT2_IRQ_EN_MIN_ADDR MT6356_AUXADC_LBAT2_5
#define PMIC_AUXADC_LBAT2_IRQ_EN_MIN_MASK 0x1
#define PMIC_AUXADC_LBAT2_IRQ_EN_MIN_SHIFT 12
#define PMIC_AUXADC_LBAT2_EN_MIN_ADDR MT6356_AUXADC_LBAT2_5
#define PMIC_AUXADC_LBAT2_EN_MIN_MASK 0x1
#define PMIC_AUXADC_LBAT2_EN_MIN_SHIFT 13
#define PMIC_AUXADC_LBAT2_MIN_IRQ_B_ADDR MT6356_AUXADC_LBAT2_5
#define PMIC_AUXADC_LBAT2_MIN_IRQ_B_MASK 0x1
#define PMIC_AUXADC_LBAT2_MIN_IRQ_B_SHIFT 15
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_ADDR MT6356_AUXADC_LBAT2_6
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_MASK 0x1FF
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_SHIFT 0
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_ADDR MT6356_AUXADC_LBAT2_7
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_MASK 0x1FF
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_SHIFT 0
#define PMIC_AUXADC_MDRT_DET_PRD_ADDR MT6356_AUXADC_MDRT_0
#define PMIC_AUXADC_MDRT_DET_PRD_MASK 0x3FF
#define PMIC_AUXADC_MDRT_DET_PRD_SHIFT 0
#define PMIC_AUXADC_MDRT_DET_EN_ADDR MT6356_AUXADC_MDRT_0
#define PMIC_AUXADC_MDRT_DET_EN_MASK 0x1
#define PMIC_AUXADC_MDRT_DET_EN_SHIFT 15
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_ADDR MT6356_AUXADC_MDRT_1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_MASK 0xFFF
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_SHIFT 0
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_ADDR MT6356_AUXADC_MDRT_1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_MASK 0x1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_SHIFT 15
#define PMIC_AUXADC_MDRT_DET_WKUP_START_ADDR MT6356_AUXADC_MDRT_2
#define PMIC_AUXADC_MDRT_DET_WKUP_START_MASK 0x1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_SHIFT 0
#define PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_ADDR MT6356_AUXADC_MDRT_2
#define PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_MASK 0x1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_SHIFT 1
#define PMIC_AUXADC_MDRT_DET_WKUP_EN_ADDR MT6356_AUXADC_MDRT_2
#define PMIC_AUXADC_MDRT_DET_WKUP_EN_MASK 0x1
#define PMIC_AUXADC_MDRT_DET_WKUP_EN_SHIFT 2
#define PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_ADDR MT6356_AUXADC_MDRT_2
#define PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_MASK 0x1
#define PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_SHIFT 3
#define PMIC_AUXADC_MDRT_DET_RDY_ST_PRD_ADDR MT6356_AUXADC_MDRT_3
#define PMIC_AUXADC_MDRT_DET_RDY_ST_PRD_MASK 0x3FF
#define PMIC_AUXADC_MDRT_DET_RDY_ST_PRD_SHIFT 0
#define PMIC_AUXADC_MDRT_DET_RDY_ST_EN_ADDR MT6356_AUXADC_MDRT_3
#define PMIC_AUXADC_MDRT_DET_RDY_ST_EN_MASK 0x1
#define PMIC_AUXADC_MDRT_DET_RDY_ST_EN_SHIFT 15
#define PMIC_AUXADC_MDRT_DET_START_SEL_ADDR MT6356_AUXADC_MDRT_4
#define PMIC_AUXADC_MDRT_DET_START_SEL_MASK 0x1
#define PMIC_AUXADC_MDRT_DET_START_SEL_SHIFT 0
#define PMIC_AUXADC_JEITA_IRQ_EN_ADDR MT6356_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_IRQ_EN_MASK 0x1
#define PMIC_AUXADC_JEITA_IRQ_EN_SHIFT 0
#define PMIC_AUXADC_JEITA_EN_ADDR MT6356_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_EN_MASK 0x1
#define PMIC_AUXADC_JEITA_EN_SHIFT 1
#define PMIC_AUXADC_JEITA_DET_PRD_ADDR MT6356_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_DET_PRD_MASK 0xF
#define PMIC_AUXADC_JEITA_DET_PRD_SHIFT 2
#define PMIC_AUXADC_JEITA_DEBT_ADDR MT6356_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_DEBT_MASK 0xF
#define PMIC_AUXADC_JEITA_DEBT_SHIFT 6
#define PMIC_AUXADC_JEITA_MIPI_DIS_ADDR MT6356_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_MIPI_DIS_MASK 0x1
#define PMIC_AUXADC_JEITA_MIPI_DIS_SHIFT 10
#define PMIC_AUXADC_JEITA_FROZE_EN_ADDR MT6356_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_FROZE_EN_MASK 0x1
#define PMIC_AUXADC_JEITA_FROZE_EN_SHIFT 11
#define PMIC_AUXADC_JEITA_VOLT_HOT_ADDR MT6356_AUXADC_JEITA_1
#define PMIC_AUXADC_JEITA_VOLT_HOT_MASK 0xFFF
#define PMIC_AUXADC_JEITA_VOLT_HOT_SHIFT 0
#define PMIC_AUXADC_JEITA_HOT_IRQ_ADDR MT6356_AUXADC_JEITA_1
#define PMIC_AUXADC_JEITA_HOT_IRQ_MASK 0x1
#define PMIC_AUXADC_JEITA_HOT_IRQ_SHIFT 15
#define PMIC_AUXADC_JEITA_VOLT_WARM_ADDR MT6356_AUXADC_JEITA_2
#define PMIC_AUXADC_JEITA_VOLT_WARM_MASK 0xFFF
#define PMIC_AUXADC_JEITA_VOLT_WARM_SHIFT 0
#define PMIC_AUXADC_JEITA_WARM_IRQ_ADDR MT6356_AUXADC_JEITA_2
#define PMIC_AUXADC_JEITA_WARM_IRQ_MASK 0x1
#define PMIC_AUXADC_JEITA_WARM_IRQ_SHIFT 15
#define PMIC_AUXADC_JEITA_VOLT_COOL_ADDR MT6356_AUXADC_JEITA_3
#define PMIC_AUXADC_JEITA_VOLT_COOL_MASK 0xFFF
#define PMIC_AUXADC_JEITA_VOLT_COOL_SHIFT 0
#define PMIC_AUXADC_JEITA_COOL_IRQ_ADDR MT6356_AUXADC_JEITA_3
#define PMIC_AUXADC_JEITA_COOL_IRQ_MASK 0x1
#define PMIC_AUXADC_JEITA_COOL_IRQ_SHIFT 15
#define PMIC_AUXADC_JEITA_VOLT_COLD_ADDR MT6356_AUXADC_JEITA_4
#define PMIC_AUXADC_JEITA_VOLT_COLD_MASK 0xFFF
#define PMIC_AUXADC_JEITA_VOLT_COLD_SHIFT 0
#define PMIC_AUXADC_JEITA_COLD_IRQ_ADDR MT6356_AUXADC_JEITA_4
#define PMIC_AUXADC_JEITA_COLD_IRQ_MASK 0x1
#define PMIC_AUXADC_JEITA_COLD_IRQ_SHIFT 15
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_ADDR MT6356_AUXADC_JEITA_5
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_MASK 0xF
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_SHIFT 0
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_ADDR MT6356_AUXADC_JEITA_5
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_MASK 0xF
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_SHIFT 4
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_ADDR MT6356_AUXADC_JEITA_5
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_MASK 0xF
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_SHIFT 8
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_ADDR MT6356_AUXADC_JEITA_5
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_MASK 0xF
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_SHIFT 12
#define PMIC_AUXADC_DCXO_MDRT_DET_PRD_ADDR MT6356_AUXADC_DCXO_MDRT_0
#define PMIC_AUXADC_DCXO_MDRT_DET_PRD_MASK 0x3FF
#define PMIC_AUXADC_DCXO_MDRT_DET_PRD_SHIFT 0
#define PMIC_AUXADC_DCXO_MDRT_DET_EN_ADDR MT6356_AUXADC_DCXO_MDRT_0
#define PMIC_AUXADC_DCXO_MDRT_DET_EN_MASK 0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_EN_SHIFT 15
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_ADDR MT6356_AUXADC_DCXO_MDRT_1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_MASK 0xFFF
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_SHIFT 0
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_ADDR MT6356_AUXADC_DCXO_MDRT_1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_MASK 0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_SHIFT 15
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_ADDR MT6356_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_MASK 0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_SHIFT 0
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_ADDR MT6356_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_MASK 0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_SHIFT 1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_ADDR MT6356_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_MASK 0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SHIFT 2
#define PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_ADDR MT6356_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_MASK 0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_SHIFT 3
#define PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_ADDR MT6356_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_MASK 0x1
#define PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_SHIFT 4
#define PMIC_AUXADC_NAG_EN_ADDR MT6356_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_EN_MASK 0x1
#define PMIC_AUXADC_NAG_EN_SHIFT 0
#define PMIC_AUXADC_NAG_CLR_ADDR MT6356_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_CLR_MASK 0x1
#define PMIC_AUXADC_NAG_CLR_SHIFT 1
#define PMIC_AUXADC_NAG_VBAT1_SEL_ADDR MT6356_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_VBAT1_SEL_MASK 0x1
#define PMIC_AUXADC_NAG_VBAT1_SEL_SHIFT 2
#define PMIC_AUXADC_NAG_PRD_ADDR MT6356_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_PRD_MASK 0x7F
#define PMIC_AUXADC_NAG_PRD_SHIFT 3
#define PMIC_AUXADC_NAG_IRQ_EN_ADDR MT6356_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_IRQ_EN_MASK 0x1
#define PMIC_AUXADC_NAG_IRQ_EN_SHIFT 10
#define PMIC_AUXADC_NAG_C_DLTV_IRQ_ADDR MT6356_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_C_DLTV_IRQ_MASK 0x1
#define PMIC_AUXADC_NAG_C_DLTV_IRQ_SHIFT 15
#define PMIC_AUXADC_NAG_ZCV_ADDR MT6356_AUXADC_NAG_1
#define PMIC_AUXADC_NAG_ZCV_MASK 0x7FFF
#define PMIC_AUXADC_NAG_ZCV_SHIFT 0
#define PMIC_AUXADC_NAG_C_DLTV_TH_15_0_ADDR MT6356_AUXADC_NAG_2
#define PMIC_AUXADC_NAG_C_DLTV_TH_15_0_MASK 0xFFFF
#define PMIC_AUXADC_NAG_C_DLTV_TH_15_0_SHIFT 0
#define PMIC_AUXADC_NAG_C_DLTV_TH_26_16_ADDR MT6356_AUXADC_NAG_3
#define PMIC_AUXADC_NAG_C_DLTV_TH_26_16_MASK 0x7FF
#define PMIC_AUXADC_NAG_C_DLTV_TH_26_16_SHIFT 0
#define PMIC_AUXADC_NAG_CNT_15_0_ADDR MT6356_AUXADC_NAG_4
#define PMIC_AUXADC_NAG_CNT_15_0_MASK 0xFFFF
#define PMIC_AUXADC_NAG_CNT_15_0_SHIFT 0
#define PMIC_AUXADC_NAG_CNT_25_16_ADDR MT6356_AUXADC_NAG_5
#define PMIC_AUXADC_NAG_CNT_25_16_MASK 0x3FF
#define PMIC_AUXADC_NAG_CNT_25_16_SHIFT 0
#define PMIC_AUXADC_NAG_DLTV_ADDR MT6356_AUXADC_NAG_6
#define PMIC_AUXADC_NAG_DLTV_MASK 0xFFFF
#define PMIC_AUXADC_NAG_DLTV_SHIFT 0
#define PMIC_AUXADC_NAG_C_DLTV_15_0_ADDR MT6356_AUXADC_NAG_7
#define PMIC_AUXADC_NAG_C_DLTV_15_0_MASK 0xFFFF
#define PMIC_AUXADC_NAG_C_DLTV_15_0_SHIFT 0
#define PMIC_AUXADC_NAG_C_DLTV_26_16_ADDR MT6356_AUXADC_NAG_8
#define PMIC_AUXADC_NAG_C_DLTV_26_16_MASK 0x7FF
#define PMIC_AUXADC_NAG_C_DLTV_26_16_SHIFT 0
#define PMIC_AUXADC_RSV_1RSV0_ADDR MT6356_AUXADC_RSV_1
#define PMIC_AUXADC_RSV_1RSV0_MASK 0xFFFF
#define PMIC_AUXADC_RSV_1RSV0_SHIFT 0
#define PMIC_DA_ADCIN_VBAT_EN_ADDR MT6356_AUXADC_ANA_0
#define PMIC_DA_ADCIN_VBAT_EN_MASK 0x1
#define PMIC_DA_ADCIN_VBAT_EN_SHIFT 0
#define PMIC_DA_AUXADC_VBAT_EN_ADDR MT6356_AUXADC_ANA_0
#define PMIC_DA_AUXADC_VBAT_EN_MASK 0x1
#define PMIC_DA_AUXADC_VBAT_EN_SHIFT 1
#define PMIC_DA_ADCIN_VSEN_MUX_EN_ADDR MT6356_AUXADC_ANA_0
#define PMIC_DA_ADCIN_VSEN_MUX_EN_MASK 0x1
#define PMIC_DA_ADCIN_VSEN_MUX_EN_SHIFT 2
#define PMIC_DA_ADCIN_VSEN_EN_ADDR MT6356_AUXADC_ANA_0
#define PMIC_DA_ADCIN_VSEN_EN_MASK 0x1
#define PMIC_DA_ADCIN_VSEN_EN_SHIFT 3
#define PMIC_DA_ADCIN_CHR_EN_ADDR MT6356_AUXADC_ANA_0
#define PMIC_DA_ADCIN_CHR_EN_MASK 0x1
#define PMIC_DA_ADCIN_CHR_EN_SHIFT 4
#define PMIC_DA_BATON_TDET_EN_ADDR MT6356_AUXADC_ANA_0
#define PMIC_DA_BATON_TDET_EN_MASK 0x1
#define PMIC_DA_BATON_TDET_EN_SHIFT 5
#define PMIC_DA_ADCIN_BATID_SW_EN_ADDR MT6356_AUXADC_ANA_0
#define PMIC_DA_ADCIN_BATID_SW_EN_MASK 0x1
#define PMIC_DA_ADCIN_BATID_SW_EN_SHIFT 6
#define PMIC_RG_AUXADC_IMP_CK_SW_MODE_ADDR MT6356_AUXADC_IMP_CG0
#define PMIC_RG_AUXADC_IMP_CK_SW_MODE_MASK 0x1
#define PMIC_RG_AUXADC_IMP_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_IMP_CK_SW_EN_ADDR MT6356_AUXADC_IMP_CG0
#define PMIC_RG_AUXADC_IMP_CK_SW_EN_MASK 0x1
#define PMIC_RG_AUXADC_IMP_CK_SW_EN_SHIFT 1
#define PMIC_RG_AUXADC_LBAT_CK_SW_MODE_ADDR MT6356_AUXADC_LBAT_CG0
#define PMIC_RG_AUXADC_LBAT_CK_SW_MODE_MASK 0x1
#define PMIC_RG_AUXADC_LBAT_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_LBAT_CK_SW_EN_ADDR MT6356_AUXADC_LBAT_CG0
#define PMIC_RG_AUXADC_LBAT_CK_SW_EN_MASK 0x1
#define PMIC_RG_AUXADC_LBAT_CK_SW_EN_SHIFT 1
#define PMIC_RG_AUXADC_THR_CK_SW_MODE_ADDR MT6356_AUXADC_THR_CG0
#define PMIC_RG_AUXADC_THR_CK_SW_MODE_MASK 0x1
#define PMIC_RG_AUXADC_THR_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_THR_CK_SW_EN_ADDR MT6356_AUXADC_THR_CG0
#define PMIC_RG_AUXADC_THR_CK_SW_EN_MASK 0x1
#define PMIC_RG_AUXADC_THR_CK_SW_EN_SHIFT 1
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE_ADDR MT6356_AUXADC_BAT_TEMP_CG0
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE_MASK 0x1
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_ADDR MT6356_AUXADC_BAT_TEMP_CG0
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_MASK 0x1
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_SHIFT 1
#define PMIC_RG_AUXADC_LBAT2_CK_SW_MODE_ADDR MT6356_AUXADC_LBAT2_CG0
#define PMIC_RG_AUXADC_LBAT2_CK_SW_MODE_MASK 0x1
#define PMIC_RG_AUXADC_LBAT2_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_LBAT2_CK_SW_EN_ADDR MT6356_AUXADC_LBAT2_CG0
#define PMIC_RG_AUXADC_LBAT2_CK_SW_EN_MASK 0x1
#define PMIC_RG_AUXADC_LBAT2_CK_SW_EN_SHIFT 1
#define PMIC_RG_AUXADC_JEITA_CK_SW_MODE_ADDR MT6356_AUXADC_JEITA_CG0
#define PMIC_RG_AUXADC_JEITA_CK_SW_MODE_MASK 0x1
#define PMIC_RG_AUXADC_JEITA_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_JEITA_CK_SW_EN_ADDR MT6356_AUXADC_JEITA_CG0
#define PMIC_RG_AUXADC_JEITA_CK_SW_EN_MASK 0x1
#define PMIC_RG_AUXADC_JEITA_CK_SW_EN_SHIFT 1
#define PMIC_RG_AUXADC_NAG_CK_SW_MODE_ADDR MT6356_AUXADC_NAG_CG0
#define PMIC_RG_AUXADC_NAG_CK_SW_MODE_MASK 0x1
#define PMIC_RG_AUXADC_NAG_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_NAG_CK_SW_EN_ADDR MT6356_AUXADC_NAG_CG0
#define PMIC_RG_AUXADC_NAG_CK_SW_EN_MASK 0x1
#define PMIC_RG_AUXADC_NAG_CK_SW_EN_SHIFT 1
#define PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL_ADDR MT6356_AUXADC_PRI_NEW
#define PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL_MASK 0x1
#define PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL_SHIFT 0
#define PMIC_RG_ADCIN_VSEN_MUX_EN_ADDR MT6356_AUXADC_CHR_TOP_CON2
#define PMIC_RG_ADCIN_VSEN_MUX_EN_MASK 0x1
#define PMIC_RG_ADCIN_VSEN_MUX_EN_SHIFT 0
#define PMIC_BATON_TDET_EN_ADDR MT6356_AUXADC_CHR_TOP_CON2
#define PMIC_BATON_TDET_EN_MASK 0x1
#define PMIC_BATON_TDET_EN_SHIFT 1
#define PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_ADDR MT6356_AUXADC_CHR_TOP_CON2
#define PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_MASK 0x1
#define PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_SHIFT 2
#define PMIC_RG_ADCIN_VBAT_EN_ADDR MT6356_AUXADC_CHR_TOP_CON2
#define PMIC_RG_ADCIN_VBAT_EN_MASK 0x1
#define PMIC_RG_ADCIN_VBAT_EN_SHIFT 3
#define PMIC_RG_ADCIN_VSEN_EN_ADDR MT6356_AUXADC_CHR_TOP_CON2
#define PMIC_RG_ADCIN_VSEN_EN_MASK 0x1
#define PMIC_RG_ADCIN_VSEN_EN_SHIFT 4
#define PMIC_RG_ADCIN_CHR_EN_ADDR MT6356_AUXADC_CHR_TOP_CON2
#define PMIC_RG_ADCIN_CHR_EN_MASK 0x1
#define PMIC_RG_ADCIN_CHR_EN_SHIFT 5
#define PMIC_AUXADC_TYPEC_H_DEBT_MAX_ADDR MT6356_AUXADC_TYPEC_H_1
#define PMIC_AUXADC_TYPEC_H_DEBT_MAX_MASK 0xFF
#define PMIC_AUXADC_TYPEC_H_DEBT_MAX_SHIFT 0
#define PMIC_AUXADC_TYPEC_H_DEBT_MIN_ADDR MT6356_AUXADC_TYPEC_H_1
#define PMIC_AUXADC_TYPEC_H_DEBT_MIN_MASK 0xFF
#define PMIC_AUXADC_TYPEC_H_DEBT_MIN_SHIFT 8
#define PMIC_AUXADC_TYPEC_H_DET_PRD_15_0_ADDR MT6356_AUXADC_TYPEC_H_2
#define PMIC_AUXADC_TYPEC_H_DET_PRD_15_0_MASK 0xFFFF
#define PMIC_AUXADC_TYPEC_H_DET_PRD_15_0_SHIFT 0
#define PMIC_AUXADC_TYPEC_H_DET_PRD_19_16_ADDR MT6356_AUXADC_TYPEC_H_3
#define PMIC_AUXADC_TYPEC_H_DET_PRD_19_16_MASK 0xF
#define PMIC_AUXADC_TYPEC_H_DET_PRD_19_16_SHIFT 0
#define PMIC_AUXADC_TYPEC_H_VOLT_MAX_ADDR MT6356_AUXADC_TYPEC_H_4
#define PMIC_AUXADC_TYPEC_H_VOLT_MAX_MASK 0xFFF
#define PMIC_AUXADC_TYPEC_H_VOLT_MAX_SHIFT 0
#define PMIC_AUXADC_TYPEC_H_IRQ_EN_MAX_ADDR MT6356_AUXADC_TYPEC_H_4
#define PMIC_AUXADC_TYPEC_H_IRQ_EN_MAX_MASK 0x1
#define PMIC_AUXADC_TYPEC_H_IRQ_EN_MAX_SHIFT 12
#define PMIC_AUXADC_TYPEC_H_EN_MAX_ADDR MT6356_AUXADC_TYPEC_H_4
#define PMIC_AUXADC_TYPEC_H_EN_MAX_MASK 0x1
#define PMIC_AUXADC_TYPEC_H_EN_MAX_SHIFT 13
#define PMIC_AUXADC_TYPEC_H_MAX_IRQ_B_ADDR MT6356_AUXADC_TYPEC_H_4
#define PMIC_AUXADC_TYPEC_H_MAX_IRQ_B_MASK 0x1
#define PMIC_AUXADC_TYPEC_H_MAX_IRQ_B_SHIFT 15
#define PMIC_AUXADC_TYPEC_H_VOLT_MIN_ADDR MT6356_AUXADC_TYPEC_H_5
#define PMIC_AUXADC_TYPEC_H_VOLT_MIN_MASK 0xFFF
#define PMIC_AUXADC_TYPEC_H_VOLT_MIN_SHIFT 0
#define PMIC_AUXADC_TYPEC_H_IRQ_EN_MIN_ADDR MT6356_AUXADC_TYPEC_H_5
#define PMIC_AUXADC_TYPEC_H_IRQ_EN_MIN_MASK 0x1
#define PMIC_AUXADC_TYPEC_H_IRQ_EN_MIN_SHIFT 12
#define PMIC_AUXADC_TYPEC_H_EN_MIN_ADDR MT6356_AUXADC_TYPEC_H_5
#define PMIC_AUXADC_TYPEC_H_EN_MIN_MASK 0x1
#define PMIC_AUXADC_TYPEC_H_EN_MIN_SHIFT 13
#define PMIC_AUXADC_TYPEC_H_MIN_IRQ_B_ADDR MT6356_AUXADC_TYPEC_H_5
#define PMIC_AUXADC_TYPEC_H_MIN_IRQ_B_MASK 0x1
#define PMIC_AUXADC_TYPEC_H_MIN_IRQ_B_SHIFT 15
#define PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MAX_ADDR MT6356_AUXADC_TYPEC_H_6
#define PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MAX_MASK 0x1FF
#define PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MAX_SHIFT 0
#define PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MIN_ADDR MT6356_AUXADC_TYPEC_H_7
#define PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MIN_MASK 0x1FF
#define PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MIN_SHIFT 0
#define PMIC_RG_AUXADC_TYPEC_H_CK_SW_MODE_ADDR MT6356_AUXADC_TYPEC_H_8
#define PMIC_RG_AUXADC_TYPEC_H_CK_SW_MODE_MASK 0x1
#define PMIC_RG_AUXADC_TYPEC_H_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_TYPEC_H_CK_SW_EN_ADDR MT6356_AUXADC_TYPEC_H_8
#define PMIC_RG_AUXADC_TYPEC_H_CK_SW_EN_MASK 0x1
#define PMIC_RG_AUXADC_TYPEC_H_CK_SW_EN_SHIFT 1
#define PMIC_AUXADC_TYPEC_L_DEBT_MAX_ADDR MT6356_AUXADC_TYPEC_L_1
#define PMIC_AUXADC_TYPEC_L_DEBT_MAX_MASK 0xFF
#define PMIC_AUXADC_TYPEC_L_DEBT_MAX_SHIFT 0
#define PMIC_AUXADC_TYPEC_L_DEBT_MIN_ADDR MT6356_AUXADC_TYPEC_L_1
#define PMIC_AUXADC_TYPEC_L_DEBT_MIN_MASK 0xFF
#define PMIC_AUXADC_TYPEC_L_DEBT_MIN_SHIFT 8
#define PMIC_AUXADC_TYPEC_L_DET_PRD_15_0_ADDR MT6356_AUXADC_TYPEC_L_2
#define PMIC_AUXADC_TYPEC_L_DET_PRD_15_0_MASK 0xFFFF
#define PMIC_AUXADC_TYPEC_L_DET_PRD_15_0_SHIFT 0
#define PMIC_AUXADC_TYPEC_L_DET_PRD_19_16_ADDR MT6356_AUXADC_TYPEC_L_3
#define PMIC_AUXADC_TYPEC_L_DET_PRD_19_16_MASK 0xF
#define PMIC_AUXADC_TYPEC_L_DET_PRD_19_16_SHIFT 0
#define PMIC_AUXADC_TYPEC_L_VOLT_MAX_ADDR MT6356_AUXADC_TYPEC_L_4
#define PMIC_AUXADC_TYPEC_L_VOLT_MAX_MASK 0xFFF
#define PMIC_AUXADC_TYPEC_L_VOLT_MAX_SHIFT 0
#define PMIC_AUXADC_TYPEC_L_IRQ_EN_MAX_ADDR MT6356_AUXADC_TYPEC_L_4
#define PMIC_AUXADC_TYPEC_L_IRQ_EN_MAX_MASK 0x1
#define PMIC_AUXADC_TYPEC_L_IRQ_EN_MAX_SHIFT 12
#define PMIC_AUXADC_TYPEC_L_EN_MAX_ADDR MT6356_AUXADC_TYPEC_L_4
#define PMIC_AUXADC_TYPEC_L_EN_MAX_MASK 0x1
#define PMIC_AUXADC_TYPEC_L_EN_MAX_SHIFT 13
#define PMIC_AUXADC_TYPEC_L_MAX_IRQ_B_ADDR MT6356_AUXADC_TYPEC_L_4
#define PMIC_AUXADC_TYPEC_L_MAX_IRQ_B_MASK 0x1
#define PMIC_AUXADC_TYPEC_L_MAX_IRQ_B_SHIFT 15
#define PMIC_AUXADC_TYPEC_L_VOLT_MIN_ADDR MT6356_AUXADC_TYPEC_L_5
#define PMIC_AUXADC_TYPEC_L_VOLT_MIN_MASK 0xFFF
#define PMIC_AUXADC_TYPEC_L_VOLT_MIN_SHIFT 0
#define PMIC_AUXADC_TYPEC_L_IRQ_EN_MIN_ADDR MT6356_AUXADC_TYPEC_L_5
#define PMIC_AUXADC_TYPEC_L_IRQ_EN_MIN_MASK 0x1
#define PMIC_AUXADC_TYPEC_L_IRQ_EN_MIN_SHIFT 12
#define PMIC_AUXADC_TYPEC_L_EN_MIN_ADDR MT6356_AUXADC_TYPEC_L_5
#define PMIC_AUXADC_TYPEC_L_EN_MIN_MASK 0x1
#define PMIC_AUXADC_TYPEC_L_EN_MIN_SHIFT 13
#define PMIC_AUXADC_TYPEC_L_MIN_IRQ_B_ADDR MT6356_AUXADC_TYPEC_L_5
#define PMIC_AUXADC_TYPEC_L_MIN_IRQ_B_MASK 0x1
#define PMIC_AUXADC_TYPEC_L_MIN_IRQ_B_SHIFT 15
#define PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MAX_ADDR MT6356_AUXADC_TYPEC_L_6
#define PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MAX_MASK 0x1FF
#define PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MAX_SHIFT 0
#define PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MIN_ADDR MT6356_AUXADC_TYPEC_L_7
#define PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MIN_MASK 0x1FF
#define PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MIN_SHIFT 0
#define PMIC_RG_AUXADC_TYPEC_L_CK_SW_MODE_ADDR MT6356_AUXADC_TYPEC_L_8
#define PMIC_RG_AUXADC_TYPEC_L_CK_SW_MODE_MASK 0x1
#define PMIC_RG_AUXADC_TYPEC_L_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_TYPEC_L_CK_SW_EN_ADDR MT6356_AUXADC_TYPEC_L_8
#define PMIC_RG_AUXADC_TYPEC_L_CK_SW_EN_MASK 0x1
#define PMIC_RG_AUXADC_TYPEC_L_CK_SW_EN_SHIFT 1
#define PMIC_AUXADC_DIG_2_ELR_LEN_ADDR MT6356_AUXADC_DIG_2_ELR_NUM
#define PMIC_AUXADC_DIG_2_ELR_LEN_MASK 0xFF
#define PMIC_AUXADC_DIG_2_ELR_LEN_SHIFT 0
#define PMIC_EFUSE_GAIN_CH4_TRIM_ADDR MT6356_AUXADC_DIG_2_ELR0
#define PMIC_EFUSE_GAIN_CH4_TRIM_MASK 0xFFF
#define PMIC_EFUSE_GAIN_CH4_TRIM_SHIFT 0
#define PMIC_EFUSE_OFFSET_CH4_TRIM_ADDR MT6356_AUXADC_DIG_2_ELR1
#define PMIC_EFUSE_OFFSET_CH4_TRIM_MASK 0x7FF
#define PMIC_EFUSE_OFFSET_CH4_TRIM_SHIFT 0
#define PMIC_EFUSE_GAIN_CH0_TRIM_ADDR MT6356_AUXADC_DIG_2_ELR2
#define PMIC_EFUSE_GAIN_CH0_TRIM_MASK 0xFFF
#define PMIC_EFUSE_GAIN_CH0_TRIM_SHIFT 0
#define PMIC_EFUSE_OFFSET_CH0_TRIM_ADDR MT6356_AUXADC_DIG_2_ELR3
#define PMIC_EFUSE_OFFSET_CH0_TRIM_MASK 0x7FF
#define PMIC_EFUSE_OFFSET_CH0_TRIM_SHIFT 0
#define PMIC_EFUSE_GAIN_CH7_TRIM_ADDR MT6356_AUXADC_DIG_2_ELR4
#define PMIC_EFUSE_GAIN_CH7_TRIM_MASK 0xFFF
#define PMIC_EFUSE_GAIN_CH7_TRIM_SHIFT 0
#define PMIC_EFUSE_OFFSET_CH7_TRIM_ADDR MT6356_AUXADC_DIG_2_ELR5
#define PMIC_EFUSE_OFFSET_CH7_TRIM_MASK 0x7FF
#define PMIC_EFUSE_OFFSET_CH7_TRIM_SHIFT 0
#define PMIC_AUXADC_EFUSE_DEGC_CALI_ADDR MT6356_AUXADC_DIG_2_ELR6
#define PMIC_AUXADC_EFUSE_DEGC_CALI_MASK 0x3F
#define PMIC_AUXADC_EFUSE_DEGC_CALI_SHIFT 0
#define PMIC_AUXADC_EFUSE_ADC_CALI_EN_ADDR MT6356_AUXADC_DIG_2_ELR6
#define PMIC_AUXADC_EFUSE_ADC_CALI_EN_MASK 0x1
#define PMIC_AUXADC_EFUSE_ADC_CALI_EN_SHIFT 8
#define PMIC_AUXADC_EFUSE_1RSV0_ADDR MT6356_AUXADC_DIG_2_ELR6
#define PMIC_AUXADC_EFUSE_1RSV0_MASK 0x7F
#define PMIC_AUXADC_EFUSE_1RSV0_SHIFT 9
#define PMIC_AUXADC_EFUSE_O_VTS_ADDR MT6356_AUXADC_DIG_2_ELR7
#define PMIC_AUXADC_EFUSE_O_VTS_MASK 0x1FFF
#define PMIC_AUXADC_EFUSE_O_VTS_SHIFT 0
#define PMIC_AUXADC_EFUSE_2RSV0_ADDR MT6356_AUXADC_DIG_2_ELR7
#define PMIC_AUXADC_EFUSE_2RSV0_MASK 0x7
#define PMIC_AUXADC_EFUSE_2RSV0_SHIFT 13
#define PMIC_AUXADC_EFUSE_O_SLOPE_ADDR MT6356_AUXADC_DIG_2_ELR8
#define PMIC_AUXADC_EFUSE_O_SLOPE_MASK 0x3F
#define PMIC_AUXADC_EFUSE_O_SLOPE_SHIFT 0
#define PMIC_AUXADC_EFUSE_O_SLOPE_SIGN_ADDR MT6356_AUXADC_DIG_2_ELR8
#define PMIC_AUXADC_EFUSE_O_SLOPE_SIGN_MASK 0x1
#define PMIC_AUXADC_EFUSE_O_SLOPE_SIGN_SHIFT 8
#define PMIC_AUXADC_EFUSE_3RSV0_ADDR MT6356_AUXADC_DIG_2_ELR8
#define PMIC_AUXADC_EFUSE_3RSV0_MASK 0x7F
#define PMIC_AUXADC_EFUSE_3RSV0_SHIFT 9
#define PMIC_AUXADC_EFUSE_AUXADC_RSV_ADDR MT6356_AUXADC_DIG_2_ELR9
#define PMIC_AUXADC_EFUSE_AUXADC_RSV_MASK 0xF
#define PMIC_AUXADC_EFUSE_AUXADC_RSV_SHIFT 0
#define PMIC_AUXADC_EFUSE_ID_ADDR MT6356_AUXADC_DIG_2_ELR9
#define PMIC_AUXADC_EFUSE_ID_MASK 0x1
#define PMIC_AUXADC_EFUSE_ID_SHIFT 4
#define PMIC_AUXADC_EFUSE_4RSV0_ADDR MT6356_AUXADC_DIG_2_ELR9
#define PMIC_AUXADC_EFUSE_4RSV0_MASK 0x7FF
#define PMIC_AUXADC_EFUSE_4RSV0_SHIFT 5
#define PMIC_AUXADC_EFUSE_O_VTS_2_ADDR MT6356_AUXADC_DIG_2_ELR10
#define PMIC_AUXADC_EFUSE_O_VTS_2_MASK 0x1FFF
#define PMIC_AUXADC_EFUSE_O_VTS_2_SHIFT 0
#define PMIC_AUXADC_EFUSE_2RSV0_2_ADDR MT6356_AUXADC_DIG_2_ELR10
#define PMIC_AUXADC_EFUSE_2RSV0_2_MASK 0x7
#define PMIC_AUXADC_EFUSE_2RSV0_2_SHIFT 13
#define PMIC_AUXADC_EFUSE_O_VTS_3_ADDR MT6356_AUXADC_DIG_2_ELR11
#define PMIC_AUXADC_EFUSE_O_VTS_3_MASK 0x1FFF
#define PMIC_AUXADC_EFUSE_O_VTS_3_SHIFT 0
#define PMIC_AUXADC_EFUSE_2RSV0_3_ADDR MT6356_AUXADC_DIG_2_ELR11
#define PMIC_AUXADC_EFUSE_2RSV0_3_MASK 0x7
#define PMIC_AUXADC_EFUSE_2RSV0_3_SHIFT 13
#define PMIC_SCK_TOP_ANA_ID_ADDR MT6356_SCK_TOP_DSN_ID
#define PMIC_SCK_TOP_ANA_ID_MASK 0xFF
#define PMIC_SCK_TOP_ANA_ID_SHIFT 0
#define PMIC_SCK_TOP_DIG_ID_ADDR MT6356_SCK_TOP_DSN_ID
#define PMIC_SCK_TOP_DIG_ID_MASK 0xFF
#define PMIC_SCK_TOP_DIG_ID_SHIFT 8
#define PMIC_SCK_TOP_ANA_MINOR_REV_ADDR MT6356_SCK_TOP_DSN_REV0
#define PMIC_SCK_TOP_ANA_MINOR_REV_MASK 0xF
#define PMIC_SCK_TOP_ANA_MINOR_REV_SHIFT 0
#define PMIC_SCK_TOP_ANA_MAJOR_REV_ADDR MT6356_SCK_TOP_DSN_REV0
#define PMIC_SCK_TOP_ANA_MAJOR_REV_MASK 0xF
#define PMIC_SCK_TOP_ANA_MAJOR_REV_SHIFT 4
#define PMIC_SCK_TOP_DIG_MINOR_REV_ADDR MT6356_SCK_TOP_DSN_REV0
#define PMIC_SCK_TOP_DIG_MINOR_REV_MASK 0xF
#define PMIC_SCK_TOP_DIG_MINOR_REV_SHIFT 8
#define PMIC_SCK_TOP_DIG_MAJOR_REV_ADDR MT6356_SCK_TOP_DSN_REV0
#define PMIC_SCK_TOP_DIG_MAJOR_REV_MASK 0xF
#define PMIC_SCK_TOP_DIG_MAJOR_REV_SHIFT 12
#define PMIC_SCK_TOP_SW_MINOR_REV_ADDR MT6356_SCK_TOP_DSN_REV1
#define PMIC_SCK_TOP_SW_MINOR_REV_MASK 0xF
#define PMIC_SCK_TOP_SW_MINOR_REV_SHIFT 0
#define PMIC_SCK_TOP_SW_MAJOR_REV_ADDR MT6356_SCK_TOP_DSN_REV1
#define PMIC_SCK_TOP_SW_MAJOR_REV_MASK 0xF
#define PMIC_SCK_TOP_SW_MAJOR_REV_SHIFT 4
#define PMIC_SCK_TOP_ESP_ADDR MT6356_SCK_TOP_DSN_REV1
#define PMIC_SCK_TOP_ESP_MASK 0xFF
#define PMIC_SCK_TOP_ESP_SHIFT 8
#define PMIC_SCK_TOP_CLK_OFFSET_ADDR MT6356_SCK_TOP_PAM0
#define PMIC_SCK_TOP_CLK_OFFSET_MASK 0xFF
#define PMIC_SCK_TOP_CLK_OFFSET_SHIFT 0
#define PMIC_SCK_TOP_RST_OFFSET_ADDR MT6356_SCK_TOP_PAM0
#define PMIC_SCK_TOP_RST_OFFSET_MASK 0xFF
#define PMIC_SCK_TOP_RST_OFFSET_SHIFT 8
#define PMIC_SCK_TOP_INT_OFFSET_ADDR MT6356_SCK_TOP_PAM1
#define PMIC_SCK_TOP_INT_OFFSET_MASK 0xFF
#define PMIC_SCK_TOP_INT_OFFSET_SHIFT 0
#define PMIC_SCK_TOP_INT_LEN_ADDR MT6356_SCK_TOP_PAM1
#define PMIC_SCK_TOP_INT_LEN_MASK 0xFF
#define PMIC_SCK_TOP_INT_LEN_SHIFT 8
#define PMIC_SCK_TOP_XTAL_SEL_ADDR MT6356_SCK_TOP_CON0
#define PMIC_SCK_TOP_XTAL_SEL_MASK 0x1
#define PMIC_SCK_TOP_XTAL_SEL_SHIFT 0
#define PMIC_SCK_TOP_RESERVED_ADDR MT6356_SCK_TOP_CON0
#define PMIC_SCK_TOP_RESERVED_MASK 0x7FFF
#define PMIC_SCK_TOP_RESERVED_SHIFT 1
#define PMIC_XOSC32_ENB_DET_ADDR MT6356_SCK_TOP_CON1
#define PMIC_XOSC32_ENB_DET_MASK 0x1
#define PMIC_XOSC32_ENB_DET_SHIFT 0
#define PMIC_SCK_TOP_TEST_OUT_ADDR MT6356_SCK_TOP_TEST_OUT
#define PMIC_SCK_TOP_TEST_OUT_MASK 0xFF
#define PMIC_SCK_TOP_TEST_OUT_SHIFT 0
#define PMIC_SCK_TOP_MON_FLAG_SEL_ADDR MT6356_SCK_TOP_TEST_CON0
#define PMIC_SCK_TOP_MON_FLAG_SEL_MASK 0xFF
#define PMIC_SCK_TOP_MON_FLAG_SEL_SHIFT 0
#define PMIC_SCK_TOP_MON_GRP_SEL_ADDR MT6356_SCK_TOP_TEST_CON0
#define PMIC_SCK_TOP_MON_GRP_SEL_MASK 0x3
#define PMIC_SCK_TOP_MON_GRP_SEL_SHIFT 8
#define PMIC_RG_RTC_SEC_MCLK_PDN_ADDR MT6356_SCK_TOP_CKPDN_CON0
#define PMIC_RG_RTC_SEC_MCLK_PDN_MASK 0x1
#define PMIC_RG_RTC_SEC_MCLK_PDN_SHIFT 0
#define PMIC_RG_EOSC_CALI_TEST_CK_PDN_ADDR MT6356_SCK_TOP_CKPDN_CON0
#define PMIC_RG_EOSC_CALI_TEST_CK_PDN_MASK 0x1
#define PMIC_RG_EOSC_CALI_TEST_CK_PDN_SHIFT 1
#define PMIC_RG_RTC_EOSC32_CK_PDN_ADDR MT6356_SCK_TOP_CKPDN_CON0
#define PMIC_RG_RTC_EOSC32_CK_PDN_MASK 0x1
#define PMIC_RG_RTC_EOSC32_CK_PDN_SHIFT 2
#define PMIC_RG_RTC_SEC_32K_CK_PDN_ADDR MT6356_SCK_TOP_CKPDN_CON0
#define PMIC_RG_RTC_SEC_32K_CK_PDN_MASK 0x1
#define PMIC_RG_RTC_SEC_32K_CK_PDN_SHIFT 3
#define PMIC_RG_RTC_MCLK_PDN_ADDR MT6356_SCK_TOP_CKPDN_CON0
#define PMIC_RG_RTC_MCLK_PDN_MASK 0x1
#define PMIC_RG_RTC_MCLK_PDN_SHIFT 4
#define PMIC_RG_RTC_32K_CK_PDN_ADDR MT6356_SCK_TOP_CKPDN_CON0
#define PMIC_RG_RTC_32K_CK_PDN_MASK 0x1
#define PMIC_RG_RTC_32K_CK_PDN_SHIFT 5
#define PMIC_RG_RTC_26M_CK_PDN_ADDR MT6356_SCK_TOP_CKPDN_CON0
#define PMIC_RG_RTC_26M_CK_PDN_MASK 0x1
#define PMIC_RG_RTC_26M_CK_PDN_SHIFT 6
#define PMIC_RG_RTC_2SEC_OFF_DET_PDN_ADDR MT6356_SCK_TOP_CKPDN_CON0
#define PMIC_RG_RTC_2SEC_OFF_DET_PDN_MASK 0x1
#define PMIC_RG_RTC_2SEC_OFF_DET_PDN_SHIFT 7
#define PMIC_SCK_TOP_CKPDN_CON0_SET_ADDR MT6356_SCK_TOP_CKPDN_CON0_SET
#define PMIC_SCK_TOP_CKPDN_CON0_SET_MASK 0xFF
#define PMIC_SCK_TOP_CKPDN_CON0_SET_SHIFT 0
#define PMIC_SCK_TOP_CKPDN_CON0_CLR_ADDR MT6356_SCK_TOP_CKPDN_CON0_CLR
#define PMIC_SCK_TOP_CKPDN_CON0_CLR_MASK 0xFF
#define PMIC_SCK_TOP_CKPDN_CON0_CLR_SHIFT 0
#define PMIC_RG_RTC_26M_CK_PDN_HWEN_ADDR MT6356_SCK_TOP_CKHWEN_CON0
#define PMIC_RG_RTC_26M_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_RTC_26M_CK_PDN_HWEN_SHIFT 0
#define PMIC_RG_RTC_MCLK_PDN_HWEN_ADDR MT6356_SCK_TOP_CKHWEN_CON0
#define PMIC_RG_RTC_MCLK_PDN_HWEN_MASK 0x1
#define PMIC_RG_RTC_MCLK_PDN_HWEN_SHIFT 1
#define PMIC_RG_RTC_SEC_32K_CK_PDN_HWEN_ADDR MT6356_SCK_TOP_CKHWEN_CON0
#define PMIC_RG_RTC_SEC_32K_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_RTC_SEC_32K_CK_PDN_HWEN_SHIFT 2
#define PMIC_RG_RTC_SEC_MCLK_PDN_HWEN_ADDR MT6356_SCK_TOP_CKHWEN_CON0
#define PMIC_RG_RTC_SEC_MCLK_PDN_HWEN_MASK 0x1
#define PMIC_RG_RTC_SEC_MCLK_PDN_HWEN_SHIFT 3
#define PMIC_RG_RTC_CLK_PDN_HWEN_RSV_1_ADDR MT6356_SCK_TOP_CKHWEN_CON0
#define PMIC_RG_RTC_CLK_PDN_HWEN_RSV_1_MASK 0x3F
#define PMIC_RG_RTC_CLK_PDN_HWEN_RSV_1_SHIFT 4
#define PMIC_RG_RTC_CLK_PDN_HWEN_RSV_0_ADDR MT6356_SCK_TOP_CKHWEN_CON0
#define PMIC_RG_RTC_CLK_PDN_HWEN_RSV_0_MASK 0x3F
#define PMIC_RG_RTC_CLK_PDN_HWEN_RSV_0_SHIFT 10
#define PMIC_SCK_TOP_CKHWEN_CON_SET_ADDR MT6356_SCK_TOP_CKHWEN_CON0_SET
#define PMIC_SCK_TOP_CKHWEN_CON_SET_MASK 0xFFFF
#define PMIC_SCK_TOP_CKHWEN_CON_SET_SHIFT 0
#define PMIC_SCK_TOP_CKHWEN_CON_CLR_ADDR MT6356_SCK_TOP_CKHWEN_CON0_CLR
#define PMIC_SCK_TOP_CKHWEN_CON_CLR_MASK 0xFFFF
#define PMIC_SCK_TOP_CKHWEN_CON_CLR_SHIFT 0
#define PMIC_RG_RTC_CK_TSTSEL_RSV_ADDR MT6356_SCK_TOP_CKTST_CON
#define PMIC_RG_RTC_CK_TSTSEL_RSV_MASK 0xF
#define PMIC_RG_RTC_CK_TSTSEL_RSV_SHIFT 0
#define PMIC_RG_RTCDET_CK_TSTSEL_ADDR MT6356_SCK_TOP_CKTST_CON
#define PMIC_RG_RTCDET_CK_TSTSEL_MASK 0x1
#define PMIC_RG_RTCDET_CK_TSTSEL_SHIFT 4
#define PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_ADDR MT6356_SCK_TOP_CKTST_CON
#define PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_MASK 0x1
#define PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_SHIFT 5
#define PMIC_RG_RTC_EOSC32_CK_TSTSEL_ADDR MT6356_SCK_TOP_CKTST_CON
#define PMIC_RG_RTC_EOSC32_CK_TSTSEL_MASK 0x1
#define PMIC_RG_RTC_EOSC32_CK_TSTSEL_SHIFT 6
#define PMIC_RG_RTC_MDB_DCM_CK_N_ADDR MT6356_SCK_TOP_MDB_DCM_CON
#define PMIC_RG_RTC_MDB_DCM_CK_N_MASK 0xF
#define PMIC_RG_RTC_MDB_DCM_CK_N_SHIFT 0
#define PMIC_RG_RTC_SEC_MDB_DCM_CK_N_ADDR MT6356_SCK_TOP_MDB_DCM_CON
#define PMIC_RG_RTC_SEC_MDB_DCM_CK_N_MASK 0xF
#define PMIC_RG_RTC_SEC_MDB_DCM_CK_N_SHIFT 4
#define PMIC_RG_RTC_SWRST_ADDR MT6356_SCK_TOP_RST_CON0
#define PMIC_RG_RTC_SWRST_MASK 0x1
#define PMIC_RG_RTC_SWRST_SHIFT 0
#define PMIC_RG_RTC_SEC_SWRST_ADDR MT6356_SCK_TOP_RST_CON0
#define PMIC_RG_RTC_SEC_SWRST_MASK 0x1
#define PMIC_RG_RTC_SEC_SWRST_SHIFT 1
#define PMIC_RG_BANK_RTC_SWRST_ADDR MT6356_SCK_TOP_RST_CON0
#define PMIC_RG_BANK_RTC_SWRST_MASK 0x1
#define PMIC_RG_BANK_RTC_SWRST_SHIFT 2
#define PMIC_RG_BANK_RTC_SEC_SWRST_ADDR MT6356_SCK_TOP_RST_CON0
#define PMIC_RG_BANK_RTC_SEC_SWRST_MASK 0x1
#define PMIC_RG_BANK_RTC_SEC_SWRST_SHIFT 3
#define PMIC_RG_BANK_EOSC_CALI_SWRST_ADDR MT6356_SCK_TOP_RST_CON0
#define PMIC_RG_BANK_EOSC_CALI_SWRST_MASK 0x1
#define PMIC_RG_BANK_EOSC_CALI_SWRST_SHIFT 4
#define PMIC_RG_BANK_SCK_TOP_SWRST_ADDR MT6356_SCK_TOP_RST_CON0
#define PMIC_RG_BANK_SCK_TOP_SWRST_MASK 0x1
#define PMIC_RG_BANK_SCK_TOP_SWRST_SHIFT 5
#define PMIC_SCK_TOP_RST_CON0_SET_ADDR MT6356_SCK_TOP_RST_CON0_SET
#define PMIC_SCK_TOP_RST_CON0_SET_MASK 0x3F
#define PMIC_SCK_TOP_RST_CON0_SET_SHIFT 0
#define PMIC_SCK_TOP_RST_CON0_CLR_ADDR MT6356_SCK_TOP_RST_CON0_CLR
#define PMIC_SCK_TOP_RST_CON0_CLR_MASK 0x3F
#define PMIC_SCK_TOP_RST_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_EN_RTC_ADDR MT6356_SCK_TOP_INT_CON0
#define PMIC_RG_INT_EN_RTC_MASK 0x1
#define PMIC_RG_INT_EN_RTC_SHIFT 0
#define PMIC_SCK_TOP_INT_CON0_SET_ADDR MT6356_SCK_TOP_INT_CON0_SET
#define PMIC_SCK_TOP_INT_CON0_SET_MASK 0x1
#define PMIC_SCK_TOP_INT_CON0_SET_SHIFT 0
#define PMIC_SCK_TOP_INT_CON0_CLR_ADDR MT6356_SCK_TOP_INT_CON0_CLR
#define PMIC_SCK_TOP_INT_CON0_CLR_MASK 0x1
#define PMIC_SCK_TOP_INT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_RTC_ADDR MT6356_SCK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_RTC_MASK 0x1
#define PMIC_RG_INT_MASK_RTC_SHIFT 0
#define PMIC_SCK_TOP_INT_MASK_CON0_SET_ADDR MT6356_SCK_TOP_INT_MASK_CON0_SET
#define PMIC_SCK_TOP_INT_MASK_CON0_SET_MASK 0x1
#define PMIC_SCK_TOP_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_SCK_TOP_INT_MASK_CON0_CLR_ADDR MT6356_SCK_TOP_INT_MASK_CON0_CLR
#define PMIC_SCK_TOP_INT_MASK_CON0_CLR_MASK 0x1
#define PMIC_SCK_TOP_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_STATUS_RTC_ADDR MT6356_SCK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_RTC_MASK 0x1
#define PMIC_RG_INT_STATUS_RTC_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_RTC_ADDR MT6356_SCK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_RTC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_RTC_SHIFT 0
#define PMIC_SCK_TOP_POLARITY_ADDR MT6356_SCK_TOP_INT_MISC_CON
#define PMIC_SCK_TOP_POLARITY_MASK 0x1
#define PMIC_SCK_TOP_POLARITY_SHIFT 0
#define PMIC_DCXO_ANA_ID_ADDR MT6356_DCXO_DSN_ID
#define PMIC_DCXO_ANA_ID_MASK 0xFF
#define PMIC_DCXO_ANA_ID_SHIFT 0
#define PMIC_DCXO_DIG_ID_ADDR MT6356_DCXO_DSN_ID
#define PMIC_DCXO_DIG_ID_MASK 0xFF
#define PMIC_DCXO_DIG_ID_SHIFT 8
#define PMIC_DCXO_ANA_MINOR_REV_ADDR MT6356_DCXO_DSN_REV0
#define PMIC_DCXO_ANA_MINOR_REV_MASK 0xF
#define PMIC_DCXO_ANA_MINOR_REV_SHIFT 0
#define PMIC_DCXO_ANA_MAJOR_REV_ADDR MT6356_DCXO_DSN_REV0
#define PMIC_DCXO_ANA_MAJOR_REV_MASK 0xF
#define PMIC_DCXO_ANA_MAJOR_REV_SHIFT 4
#define PMIC_DCXO_DIG_MINOR_REV_ADDR MT6356_DCXO_DSN_REV0
#define PMIC_DCXO_DIG_MINOR_REV_MASK 0xF
#define PMIC_DCXO_DIG_MINOR_REV_SHIFT 8
#define PMIC_DCXO_DIG_MAJOR_REV_ADDR MT6356_DCXO_DSN_REV0
#define PMIC_DCXO_DIG_MAJOR_REV_MASK 0xF
#define PMIC_DCXO_DIG_MAJOR_REV_SHIFT 12
#define PMIC_DCXO_SW_MINOR_REV_ADDR MT6356_DCXO_DSN_REV1
#define PMIC_DCXO_SW_MINOR_REV_MASK 0xF
#define PMIC_DCXO_SW_MINOR_REV_SHIFT 0
#define PMIC_DCXO_SW_MAJOR_REV_ADDR MT6356_DCXO_DSN_REV1
#define PMIC_DCXO_SW_MAJOR_REV_MASK 0xF
#define PMIC_DCXO_SW_MAJOR_REV_SHIFT 4
#define PMIC_DCXO_ESP_ADDR MT6356_DCXO_DSN_REV1
#define PMIC_DCXO_ESP_MASK 0xFF
#define PMIC_DCXO_ESP_SHIFT 8
#define PMIC_XO_EXTBUF1_MODE_ADDR MT6356_DCXO_CW00
#define PMIC_XO_EXTBUF1_MODE_MASK 0x3
#define PMIC_XO_EXTBUF1_MODE_SHIFT 0
#define PMIC_XO_EXTBUF1_EN_M_ADDR MT6356_DCXO_CW00
#define PMIC_XO_EXTBUF1_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF1_EN_M_SHIFT 2
#define PMIC_XO_EXTBUF2_MODE_ADDR MT6356_DCXO_CW00
#define PMIC_XO_EXTBUF2_MODE_MASK 0x3
#define PMIC_XO_EXTBUF2_MODE_SHIFT 3
#define PMIC_XO_EXTBUF2_EN_M_ADDR MT6356_DCXO_CW00
#define PMIC_XO_EXTBUF2_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF2_EN_M_SHIFT 5
#define PMIC_XO_EXTBUF3_MODE_ADDR MT6356_DCXO_CW00
#define PMIC_XO_EXTBUF3_MODE_MASK 0x3
#define PMIC_XO_EXTBUF3_MODE_SHIFT 6
#define PMIC_XO_EXTBUF3_EN_M_ADDR MT6356_DCXO_CW00
#define PMIC_XO_EXTBUF3_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF3_EN_M_SHIFT 8
#define PMIC_XO_EXTBUF4_MODE_ADDR MT6356_DCXO_CW00
#define PMIC_XO_EXTBUF4_MODE_MASK 0x3
#define PMIC_XO_EXTBUF4_MODE_SHIFT 9
#define PMIC_XO_EXTBUF4_EN_M_ADDR MT6356_DCXO_CW00
#define PMIC_XO_EXTBUF4_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF4_EN_M_SHIFT 11
#define PMIC_XO_BB_LPM_EN_ADDR MT6356_DCXO_CW00
#define PMIC_XO_BB_LPM_EN_MASK 0x1
#define PMIC_XO_BB_LPM_EN_SHIFT 12
#define PMIC_XO_ENBB_MAN_ADDR MT6356_DCXO_CW00
#define PMIC_XO_ENBB_MAN_MASK 0x1
#define PMIC_XO_ENBB_MAN_SHIFT 13
#define PMIC_XO_ENBB_EN_M_ADDR MT6356_DCXO_CW00
#define PMIC_XO_ENBB_EN_M_MASK 0x1
#define PMIC_XO_ENBB_EN_M_SHIFT 14
#define PMIC_XO_CLKSEL_MAN_ADDR MT6356_DCXO_CW00
#define PMIC_XO_CLKSEL_MAN_MASK 0x1
#define PMIC_XO_CLKSEL_MAN_SHIFT 15
#define PMIC_DCXO_CW00_SET_ADDR MT6356_DCXO_CW00_SET
#define PMIC_DCXO_CW00_SET_MASK 0xFFFF
#define PMIC_DCXO_CW00_SET_SHIFT 0
#define PMIC_DCXO_CW00_CLR_ADDR MT6356_DCXO_CW00_CLR
#define PMIC_DCXO_CW00_CLR_MASK 0xFFFF
#define PMIC_DCXO_CW00_CLR_SHIFT 0
#define PMIC_XO_CLKSEL_EN_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_CLKSEL_EN_M_MASK 0x1
#define PMIC_XO_CLKSEL_EN_M_SHIFT 0
#define PMIC_XO_EXTBUF1_CKG_MAN_ADDR MT6356_DCXO_CW01
#define PMIC_XO_EXTBUF1_CKG_MAN_MASK 0x1
#define PMIC_XO_EXTBUF1_CKG_MAN_SHIFT 1
#define PMIC_XO_EXTBUF1_CKG_EN_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_EXTBUF1_CKG_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF1_CKG_EN_M_SHIFT 2
#define PMIC_XO_EXTBUF2_CKG_MAN_ADDR MT6356_DCXO_CW01
#define PMIC_XO_EXTBUF2_CKG_MAN_MASK 0x1
#define PMIC_XO_EXTBUF2_CKG_MAN_SHIFT 3
#define PMIC_XO_EXTBUF2_CKG_EN_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_EXTBUF2_CKG_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF2_CKG_EN_M_SHIFT 4
#define PMIC_XO_EXTBUF3_CKG_MAN_ADDR MT6356_DCXO_CW01
#define PMIC_XO_EXTBUF3_CKG_MAN_MASK 0x1
#define PMIC_XO_EXTBUF3_CKG_MAN_SHIFT 5
#define PMIC_XO_EXTBUF3_CKG_EN_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_EXTBUF3_CKG_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF3_CKG_EN_M_SHIFT 6
#define PMIC_XO_EXTBUF4_CKG_MAN_ADDR MT6356_DCXO_CW01
#define PMIC_XO_EXTBUF4_CKG_MAN_MASK 0x1
#define PMIC_XO_EXTBUF4_CKG_MAN_SHIFT 7
#define PMIC_XO_EXTBUF4_CKG_EN_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_EXTBUF4_CKG_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF4_CKG_EN_M_SHIFT 8
#define PMIC_XO_INTBUF_MAN_ADDR MT6356_DCXO_CW01
#define PMIC_XO_INTBUF_MAN_MASK 0x1
#define PMIC_XO_INTBUF_MAN_SHIFT 9
#define PMIC_XO_PBUF_EN_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_PBUF_EN_M_MASK 0x1
#define PMIC_XO_PBUF_EN_M_SHIFT 10
#define PMIC_XO_IBUF_EN_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_IBUF_EN_M_MASK 0x1
#define PMIC_XO_IBUF_EN_M_SHIFT 11
#define PMIC_XO_LPMBUF_MAN_ADDR MT6356_DCXO_CW01
#define PMIC_XO_LPMBUF_MAN_MASK 0x1
#define PMIC_XO_LPMBUF_MAN_SHIFT 12
#define PMIC_XO_LPM_PREBUF_EN_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_LPM_PREBUF_EN_M_MASK 0x1
#define PMIC_XO_LPM_PREBUF_EN_M_SHIFT 13
#define PMIC_XO_LPBUF_EN_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_LPBUF_EN_M_MASK 0x1
#define PMIC_XO_LPBUF_EN_M_SHIFT 14
#define PMIC_XO_BBLPM_CKSEL_M_ADDR MT6356_DCXO_CW01
#define PMIC_XO_BBLPM_CKSEL_M_MASK 0x1
#define PMIC_XO_BBLPM_CKSEL_M_SHIFT 15
#define PMIC_XO_EN32K_MAN_ADDR MT6356_DCXO_CW02
#define PMIC_XO_EN32K_MAN_MASK 0x1
#define PMIC_XO_EN32K_MAN_SHIFT 0
#define PMIC_XO_EN32K_M_ADDR MT6356_DCXO_CW02
#define PMIC_XO_EN32K_M_MASK 0x1
#define PMIC_XO_EN32K_M_SHIFT 1
#define PMIC_XO_XMODE_MAN_ADDR MT6356_DCXO_CW02
#define PMIC_XO_XMODE_MAN_MASK 0x1
#define PMIC_XO_XMODE_MAN_SHIFT 2
#define PMIC_XO_XMODE_M_ADDR MT6356_DCXO_CW02
#define PMIC_XO_XMODE_M_MASK 0x1
#define PMIC_XO_XMODE_M_SHIFT 3
#define PMIC_XO_STRUP_MODE_ADDR MT6356_DCXO_CW02
#define PMIC_XO_STRUP_MODE_MASK 0x1
#define PMIC_XO_STRUP_MODE_SHIFT 4
#define PMIC_XO_AAC_FPM_TIME_ADDR MT6356_DCXO_CW02
#define PMIC_XO_AAC_FPM_TIME_MASK 0x3
#define PMIC_XO_AAC_FPM_TIME_SHIFT 5
#define PMIC_XO_AAC_MODE_LPM_ADDR MT6356_DCXO_CW02
#define PMIC_XO_AAC_MODE_LPM_MASK 0x3
#define PMIC_XO_AAC_MODE_LPM_SHIFT 7
#define PMIC_XO_AAC_MODE_FPM_ADDR MT6356_DCXO_CW02
#define PMIC_XO_AAC_MODE_FPM_MASK 0x3
#define PMIC_XO_AAC_MODE_FPM_SHIFT 9
#define PMIC_XO_EN26M_OFFSQ_EN_ADDR MT6356_DCXO_CW02
#define PMIC_XO_EN26M_OFFSQ_EN_MASK 0x1
#define PMIC_XO_EN26M_OFFSQ_EN_SHIFT 11
#define PMIC_XO_LDOCAL_EN_ADDR MT6356_DCXO_CW02
#define PMIC_XO_LDOCAL_EN_MASK 0x1
#define PMIC_XO_LDOCAL_EN_SHIFT 12
#define PMIC_XO_CBANK_SYNC_DYN_ADDR MT6356_DCXO_CW02
#define PMIC_XO_CBANK_SYNC_DYN_MASK 0x1
#define PMIC_XO_CBANK_SYNC_DYN_SHIFT 13
#define PMIC_XO_26MLP_MAN_EN_ADDR MT6356_DCXO_CW02
#define PMIC_XO_26MLP_MAN_EN_MASK 0x1
#define PMIC_XO_26MLP_MAN_EN_SHIFT 14
#define PMIC_XO_BUFLDOK_EN_ADDR MT6356_DCXO_CW02
#define PMIC_XO_BUFLDOK_EN_MASK 0x1
#define PMIC_XO_BUFLDOK_EN_SHIFT 15
#define PMIC_XO_PMU_CKEN_M_ADDR MT6356_DCXO_CW03
#define PMIC_XO_PMU_CKEN_M_MASK 0x1
#define PMIC_XO_PMU_CKEN_M_SHIFT 0
#define PMIC_XO_PMU_CKEN_MAN_ADDR MT6356_DCXO_CW03
#define PMIC_XO_PMU_CKEN_MAN_MASK 0x1
#define PMIC_XO_PMU_CKEN_MAN_SHIFT 1
#define PMIC_XO_EXTBUF6_CKG_MAN_ADDR MT6356_DCXO_CW03
#define PMIC_XO_EXTBUF6_CKG_MAN_MASK 0x1
#define PMIC_XO_EXTBUF6_CKG_MAN_SHIFT 2
#define PMIC_XO_EXTBUF6_CKG_EN_M_ADDR MT6356_DCXO_CW03
#define PMIC_XO_EXTBUF6_CKG_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF6_CKG_EN_M_SHIFT 3
#define PMIC_XO_EXTBUF7_CKG_MAN_ADDR MT6356_DCXO_CW03
#define PMIC_XO_EXTBUF7_CKG_MAN_MASK 0x1
#define PMIC_XO_EXTBUF7_CKG_MAN_SHIFT 4
#define PMIC_XO_EXTBUF7_CKG_EN_M_ADDR MT6356_DCXO_CW03
#define PMIC_XO_EXTBUF7_CKG_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF7_CKG_EN_M_SHIFT 5
#define PMIC_XO_LPM_ISEL_MAN_ADDR MT6356_DCXO_CW03
#define PMIC_XO_LPM_ISEL_MAN_MASK 0x1F
#define PMIC_XO_LPM_ISEL_MAN_SHIFT 6
#define PMIC_XO_FPM_ISEL_MAN_ADDR MT6356_DCXO_CW03
#define PMIC_XO_FPM_ISEL_MAN_MASK 0x1F
#define PMIC_XO_FPM_ISEL_MAN_SHIFT 11
#define PMIC_XO_CDAC_FPM_ADDR MT6356_DCXO_CW04
#define PMIC_XO_CDAC_FPM_MASK 0xFF
#define PMIC_XO_CDAC_FPM_SHIFT 0
#define PMIC_XO_CDAC_LPM_ADDR MT6356_DCXO_CW04
#define PMIC_XO_CDAC_LPM_MASK 0xFF
#define PMIC_XO_CDAC_LPM_SHIFT 8
#define PMIC_XO_32KDIV_NFRAC_FPM_ADDR MT6356_DCXO_CW05
#define PMIC_XO_32KDIV_NFRAC_FPM_MASK 0x3FFF
#define PMIC_XO_32KDIV_NFRAC_FPM_SHIFT 0
#define PMIC_XO_COFST_FPM_ADDR MT6356_DCXO_CW05
#define PMIC_XO_COFST_FPM_MASK 0x3
#define PMIC_XO_COFST_FPM_SHIFT 14
#define PMIC_XO_32KDIV_NFRAC_LPM_ADDR MT6356_DCXO_CW06
#define PMIC_XO_32KDIV_NFRAC_LPM_MASK 0x3FFF
#define PMIC_XO_32KDIV_NFRAC_LPM_SHIFT 0
#define PMIC_XO_COFST_LPM_ADDR MT6356_DCXO_CW06
#define PMIC_XO_COFST_LPM_MASK 0x3
#define PMIC_XO_COFST_LPM_SHIFT 14
#define PMIC_XO_CORE_MAN_ADDR MT6356_DCXO_CW07
#define PMIC_XO_CORE_MAN_MASK 0x1
#define PMIC_XO_CORE_MAN_SHIFT 0
#define PMIC_XO_CORE_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_CORE_EN_M_MASK 0x1
#define PMIC_XO_CORE_EN_M_SHIFT 1
#define PMIC_XO_CORE_TURBO_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_CORE_TURBO_EN_M_MASK 0x1
#define PMIC_XO_CORE_TURBO_EN_M_SHIFT 2
#define PMIC_XO_CORE_AAC_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_CORE_AAC_EN_M_MASK 0x1
#define PMIC_XO_CORE_AAC_EN_M_SHIFT 3
#define PMIC_XO_STARTUP_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_STARTUP_EN_M_MASK 0x1
#define PMIC_XO_STARTUP_EN_M_SHIFT 4
#define PMIC_XO_CORE_VBFPM_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_CORE_VBFPM_EN_M_MASK 0x1
#define PMIC_XO_CORE_VBFPM_EN_M_SHIFT 5
#define PMIC_XO_CORE_VBLPM_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_CORE_VBLPM_EN_M_MASK 0x1
#define PMIC_XO_CORE_VBLPM_EN_M_SHIFT 6
#define PMIC_XO_LPMBIAS_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_LPMBIAS_EN_M_MASK 0x1
#define PMIC_XO_LPMBIAS_EN_M_SHIFT 7
#define PMIC_XO_VTCGEN_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_VTCGEN_EN_M_MASK 0x1
#define PMIC_XO_VTCGEN_EN_M_SHIFT 8
#define PMIC_XO_IAAC_COMP_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_IAAC_COMP_EN_M_MASK 0x1
#define PMIC_XO_IAAC_COMP_EN_M_SHIFT 9
#define PMIC_XO_IFPM_COMP_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_IFPM_COMP_EN_M_MASK 0x1
#define PMIC_XO_IFPM_COMP_EN_M_SHIFT 10
#define PMIC_XO_ILPM_COMP_EN_M_ADDR MT6356_DCXO_CW07
#define PMIC_XO_ILPM_COMP_EN_M_MASK 0x1
#define PMIC_XO_ILPM_COMP_EN_M_SHIFT 11
#define PMIC_XO_CORE_BYPCAS_FPM_ADDR MT6356_DCXO_CW07
#define PMIC_XO_CORE_BYPCAS_FPM_MASK 0x1
#define PMIC_XO_CORE_BYPCAS_FPM_SHIFT 12
#define PMIC_XO_CORE_GMX2_FPM_ADDR MT6356_DCXO_CW07
#define PMIC_XO_CORE_GMX2_FPM_MASK 0x1
#define PMIC_XO_CORE_GMX2_FPM_SHIFT 13
#define PMIC_XO_CORE_IDAC_FPM_ADDR MT6356_DCXO_CW07
#define PMIC_XO_CORE_IDAC_FPM_MASK 0x3
#define PMIC_XO_CORE_IDAC_FPM_SHIFT 14
#define PMIC_XO_AAC_COMP_MAN_ADDR MT6356_DCXO_CW08
#define PMIC_XO_AAC_COMP_MAN_MASK 0x1
#define PMIC_XO_AAC_COMP_MAN_SHIFT 0
#define PMIC_XO_AAC_EN_M_ADDR MT6356_DCXO_CW08
#define PMIC_XO_AAC_EN_M_MASK 0x1
#define PMIC_XO_AAC_EN_M_SHIFT 1
#define PMIC_XO_AAC_MONEN_M_ADDR MT6356_DCXO_CW08
#define PMIC_XO_AAC_MONEN_M_MASK 0x1
#define PMIC_XO_AAC_MONEN_M_SHIFT 2
#define PMIC_XO_COMP_EN_M_ADDR MT6356_DCXO_CW08
#define PMIC_XO_COMP_EN_M_MASK 0x1
#define PMIC_XO_COMP_EN_M_SHIFT 3
#define PMIC_XO_COMP_TSTEN_M_ADDR MT6356_DCXO_CW08
#define PMIC_XO_COMP_TSTEN_M_MASK 0x1
#define PMIC_XO_COMP_TSTEN_M_SHIFT 4
#define PMIC_XO_AAC_HV_FPM_ADDR MT6356_DCXO_CW08
#define PMIC_XO_AAC_HV_FPM_MASK 0x1
#define PMIC_XO_AAC_HV_FPM_SHIFT 5
#define PMIC_XO_AAC_IBIAS_FPM_ADDR MT6356_DCXO_CW08
#define PMIC_XO_AAC_IBIAS_FPM_MASK 0x3
#define PMIC_XO_AAC_IBIAS_FPM_SHIFT 6
#define PMIC_XO_AAC_VOFST_FPM_ADDR MT6356_DCXO_CW08
#define PMIC_XO_AAC_VOFST_FPM_MASK 0x3
#define PMIC_XO_AAC_VOFST_FPM_SHIFT 8
#define PMIC_XO_AAC_COMP_HV_FPM_ADDR MT6356_DCXO_CW08
#define PMIC_XO_AAC_COMP_HV_FPM_MASK 0x1
#define PMIC_XO_AAC_COMP_HV_FPM_SHIFT 10
#define PMIC_XO_AAC_VSEL_FPM_ADDR MT6356_DCXO_CW08
#define PMIC_XO_AAC_VSEL_FPM_MASK 0xF
#define PMIC_XO_AAC_VSEL_FPM_SHIFT 11
#define PMIC_XO_AAC_COMP_POL_ADDR MT6356_DCXO_CW08
#define PMIC_XO_AAC_COMP_POL_MASK 0x1
#define PMIC_XO_AAC_COMP_POL_SHIFT 15
#define PMIC_XO_CORE_BYPCAS_LPM_ADDR MT6356_DCXO_CW09
#define PMIC_XO_CORE_BYPCAS_LPM_MASK 0x1
#define PMIC_XO_CORE_BYPCAS_LPM_SHIFT 0
#define PMIC_XO_CORE_GMX2_LPM_ADDR MT6356_DCXO_CW09
#define PMIC_XO_CORE_GMX2_LPM_MASK 0x1
#define PMIC_XO_CORE_GMX2_LPM_SHIFT 1
#define PMIC_XO_CORE_IDAC_LPM_ADDR MT6356_DCXO_CW09
#define PMIC_XO_CORE_IDAC_LPM_MASK 0x3
#define PMIC_XO_CORE_IDAC_LPM_SHIFT 2
#define PMIC_XO_AAC_COMP_HV_LPM_ADDR MT6356_DCXO_CW09
#define PMIC_XO_AAC_COMP_HV_LPM_MASK 0x1
#define PMIC_XO_AAC_COMP_HV_LPM_SHIFT 4
#define PMIC_XO_AAC_VSEL_LPM_ADDR MT6356_DCXO_CW09
#define PMIC_XO_AAC_VSEL_LPM_MASK 0xF
#define PMIC_XO_AAC_VSEL_LPM_SHIFT 5
#define PMIC_XO_AAC_HV_LPM_ADDR MT6356_DCXO_CW09
#define PMIC_XO_AAC_HV_LPM_MASK 0x1
#define PMIC_XO_AAC_HV_LPM_SHIFT 9
#define PMIC_XO_AAC_IBIAS_LPM_ADDR MT6356_DCXO_CW09
#define PMIC_XO_AAC_IBIAS_LPM_MASK 0x3
#define PMIC_XO_AAC_IBIAS_LPM_SHIFT 10
#define PMIC_XO_AAC_VOFST_LPM_ADDR MT6356_DCXO_CW09
#define PMIC_XO_AAC_VOFST_LPM_MASK 0x3
#define PMIC_XO_AAC_VOFST_LPM_SHIFT 12
#define PMIC_XO_AAC_FPM_SWEN_ADDR MT6356_DCXO_CW09
#define PMIC_XO_AAC_FPM_SWEN_MASK 0x1
#define PMIC_XO_AAC_FPM_SWEN_SHIFT 14
#define PMIC_XO_SWRST_ADDR MT6356_DCXO_CW09
#define PMIC_XO_SWRST_MASK 0x1
#define PMIC_XO_SWRST_SHIFT 15
#define PMIC_XO_32KDIV_SWRST_ADDR MT6356_DCXO_CW10
#define PMIC_XO_32KDIV_SWRST_MASK 0x1
#define PMIC_XO_32KDIV_SWRST_SHIFT 0
#define PMIC_XO_32KDIV_RATIO_MAN_ADDR MT6356_DCXO_CW10
#define PMIC_XO_32KDIV_RATIO_MAN_MASK 0x1
#define PMIC_XO_32KDIV_RATIO_MAN_SHIFT 1
#define PMIC_XO_32KDIV_TEST_EN_ADDR MT6356_DCXO_CW10
#define PMIC_XO_32KDIV_TEST_EN_MASK 0x1
#define PMIC_XO_32KDIV_TEST_EN_SHIFT 2
#define PMIC_XO_CBANK_SYNC_MAN_ADDR MT6356_DCXO_CW10
#define PMIC_XO_CBANK_SYNC_MAN_MASK 0x1
#define PMIC_XO_CBANK_SYNC_MAN_SHIFT 3
#define PMIC_XO_CBANK_SYNC_EN_M_ADDR MT6356_DCXO_CW10
#define PMIC_XO_CBANK_SYNC_EN_M_MASK 0x1
#define PMIC_XO_CBANK_SYNC_EN_M_SHIFT 4
#define PMIC_XO_CTL_SYNC_MAN_ADDR MT6356_DCXO_CW10
#define PMIC_XO_CTL_SYNC_MAN_MASK 0x1
#define PMIC_XO_CTL_SYNC_MAN_SHIFT 5
#define PMIC_XO_CTL_SYNC_EN_M_ADDR MT6356_DCXO_CW10
#define PMIC_XO_CTL_SYNC_EN_M_MASK 0x1
#define PMIC_XO_CTL_SYNC_EN_M_SHIFT 6
#define PMIC_XO_LDO_MAN_ADDR MT6356_DCXO_CW10
#define PMIC_XO_LDO_MAN_MASK 0x1
#define PMIC_XO_LDO_MAN_SHIFT 7
#define PMIC_XO_LDOPBUF_EN_M_ADDR MT6356_DCXO_CW10
#define PMIC_XO_LDOPBUF_EN_M_MASK 0x1
#define PMIC_XO_LDOPBUF_EN_M_SHIFT 8
#define PMIC_XO_LDOPBUF_VSET_M_ADDR MT6356_DCXO_CW10
#define PMIC_XO_LDOPBUF_VSET_M_MASK 0xF
#define PMIC_XO_LDOPBUF_VSET_M_SHIFT 9
#define PMIC_XO_LDOVTST_EN_M_ADDR MT6356_DCXO_CW10
#define PMIC_XO_LDOVTST_EN_M_MASK 0x1
#define PMIC_XO_LDOVTST_EN_M_SHIFT 13
#define PMIC_XO_TEST_VCAL_EN_M_ADDR MT6356_DCXO_CW10
#define PMIC_XO_TEST_VCAL_EN_M_MASK 0x1
#define PMIC_XO_TEST_VCAL_EN_M_SHIFT 14
#define PMIC_XO_VBIST_EN_M_ADDR MT6356_DCXO_CW10
#define PMIC_XO_VBIST_EN_M_MASK 0x1
#define PMIC_XO_VBIST_EN_M_SHIFT 15
#define PMIC_XO_VTEST_SEL_MUX_ADDR MT6356_DCXO_CW11
#define PMIC_XO_VTEST_SEL_MUX_MASK 0x1F
#define PMIC_XO_VTEST_SEL_MUX_SHIFT 0
#define PMIC_XO_RESERVED3_ADDR MT6356_DCXO_CW11
#define PMIC_XO_RESERVED3_MASK 0x7
#define PMIC_XO_RESERVED3_SHIFT 5
#define PMIC_XO_EXTBUF6_MODE_ADDR MT6356_DCXO_CW11
#define PMIC_XO_EXTBUF6_MODE_MASK 0x3
#define PMIC_XO_EXTBUF6_MODE_SHIFT 8
#define PMIC_XO_EXTBUF6_EN_M_ADDR MT6356_DCXO_CW11
#define PMIC_XO_EXTBUF6_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF6_EN_M_SHIFT 10
#define PMIC_XO_EXTBUF7_MODE_ADDR MT6356_DCXO_CW11
#define PMIC_XO_EXTBUF7_MODE_MASK 0x3
#define PMIC_XO_EXTBUF7_MODE_SHIFT 11
#define PMIC_XO_EXTBUF7_EN_M_ADDR MT6356_DCXO_CW11
#define PMIC_XO_EXTBUF7_EN_M_MASK 0x1
#define PMIC_XO_EXTBUF7_EN_M_SHIFT 13
#define PMIC_XO_BUFLDOK_MAN_ADDR MT6356_DCXO_CW11
#define PMIC_XO_BUFLDOK_MAN_MASK 0x1
#define PMIC_XO_BUFLDOK_MAN_SHIFT 14
#define PMIC_XO_BUF1LDO_CAL_M_ADDR MT6356_DCXO_CW11
#define PMIC_XO_BUF1LDO_CAL_M_MASK 0x1
#define PMIC_XO_BUF1LDO_CAL_M_SHIFT 15
#define PMIC_DCXO_CW11_SET_ADDR MT6356_DCXO_CW11_SET
#define PMIC_DCXO_CW11_SET_MASK 0xFFFF
#define PMIC_DCXO_CW11_SET_SHIFT 0
#define PMIC_DCXO_CW11_CLR_ADDR MT6356_DCXO_CW11_CLR
#define PMIC_DCXO_CW11_CLR_MASK 0xFFFF
#define PMIC_DCXO_CW11_CLR_SHIFT 0
#define PMIC_XO_BUFLDO_CAL_M_ADDR MT6356_DCXO_CW12
#define PMIC_XO_BUFLDO_CAL_M_MASK 0x1
#define PMIC_XO_BUFLDO_CAL_M_SHIFT 0
#define PMIC_XO_EXTBUF4_CLKSEL_MAN_ADDR MT6356_DCXO_CW12
#define PMIC_XO_EXTBUF4_CLKSEL_MAN_MASK 0x1
#define PMIC_XO_EXTBUF4_CLKSEL_MAN_SHIFT 1
#define PMIC_XO_VIO18PG_BUFEN_ADDR MT6356_DCXO_CW12
#define PMIC_XO_VIO18PG_BUFEN_MASK 0x1
#define PMIC_XO_VIO18PG_BUFEN_SHIFT 2
#define PMIC_XO_CAL_EN_MAN_ADDR MT6356_DCXO_CW12
#define PMIC_XO_CAL_EN_MAN_MASK 0x1
#define PMIC_XO_CAL_EN_MAN_SHIFT 3
#define PMIC_XO_CAL_EN_M_ADDR MT6356_DCXO_CW12
#define PMIC_XO_CAL_EN_M_MASK 0x1
#define PMIC_XO_CAL_EN_M_SHIFT 4
#define PMIC_RG_XO_CORE_OSCTD_ADDR MT6356_DCXO_CW12
#define PMIC_RG_XO_CORE_OSCTD_MASK 0x3
#define PMIC_RG_XO_CORE_OSCTD_SHIFT 5
#define PMIC_XO_THADC_EN_ADDR MT6356_DCXO_CW12
#define PMIC_XO_THADC_EN_MASK 0x1
#define PMIC_XO_THADC_EN_SHIFT 7
#define PMIC_RG_XO_SYNC_CKPOL_ADDR MT6356_DCXO_CW12
#define PMIC_RG_XO_SYNC_CKPOL_MASK 0x1
#define PMIC_RG_XO_SYNC_CKPOL_SHIFT 8
#define PMIC_RG_XO_CBANK_POL_ADDR MT6356_DCXO_CW12
#define PMIC_RG_XO_CBANK_POL_MASK 0x1
#define PMIC_RG_XO_CBANK_POL_SHIFT 9
#define PMIC_RG_XO_CBANK_SYNC_BYP_ADDR MT6356_DCXO_CW12
#define PMIC_RG_XO_CBANK_SYNC_BYP_MASK 0x1
#define PMIC_RG_XO_CBANK_SYNC_BYP_SHIFT 10
#define PMIC_RG_XO_CTL_POL_ADDR MT6356_DCXO_CW12
#define PMIC_RG_XO_CTL_POL_MASK 0x1
#define PMIC_RG_XO_CTL_POL_SHIFT 11
#define PMIC_RG_XO_CTL_SYNC_BYP_ADDR MT6356_DCXO_CW12
#define PMIC_RG_XO_CTL_SYNC_BYP_MASK 0x1
#define PMIC_RG_XO_CTL_SYNC_BYP_SHIFT 12
#define PMIC_RG_XO_LPBUF_INV_ADDR MT6356_DCXO_CW12
#define PMIC_RG_XO_LPBUF_INV_MASK 0x1
#define PMIC_RG_XO_LPBUF_INV_SHIFT 13
#define PMIC_RG_XO_LDOPBUF_BYP_ADDR MT6356_DCXO_CW12
#define PMIC_RG_XO_LDOPBUF_BYP_MASK 0x1
#define PMIC_RG_XO_LDOPBUF_BYP_SHIFT 14
#define PMIC_RG_XO_LDOPBUF_ENCL_ADDR MT6356_DCXO_CW12
#define PMIC_RG_XO_LDOPBUF_ENCL_MASK 0x1
#define PMIC_RG_XO_LDOPBUF_ENCL_SHIFT 15
#define PMIC_RG_XO_VGBIAS_VSET_ADDR MT6356_DCXO_CW13
#define PMIC_RG_XO_VGBIAS_VSET_MASK 0x3
#define PMIC_RG_XO_VGBIAS_VSET_SHIFT 0
#define PMIC_RG_XO_PBUF_ISET_ADDR MT6356_DCXO_CW13
#define PMIC_RG_XO_PBUF_ISET_MASK 0x3
#define PMIC_RG_XO_PBUF_ISET_SHIFT 2
#define PMIC_RG_XO_IBUF_ISET_ADDR MT6356_DCXO_CW13
#define PMIC_RG_XO_IBUF_ISET_MASK 0x3
#define PMIC_RG_XO_IBUF_ISET_SHIFT 4
#define PMIC_RG_XO_RESERVED4_ADDR MT6356_DCXO_CW13
#define PMIC_RG_XO_RESERVED4_MASK 0x3
#define PMIC_RG_XO_RESERVED4_SHIFT 6
#define PMIC_RG_XO_VOW_EN_ADDR MT6356_DCXO_CW13
#define PMIC_RG_XO_VOW_EN_MASK 0x1
#define PMIC_RG_XO_VOW_EN_SHIFT 8
#define PMIC_RG_XO_VOW_DIV_ADDR MT6356_DCXO_CW13
#define PMIC_RG_XO_VOW_DIV_MASK 0x3
#define PMIC_RG_XO_VOW_DIV_SHIFT 9
#define PMIC_RG_XO_BUFLDO24_ENCL_ADDR MT6356_DCXO_CW13
#define PMIC_RG_XO_BUFLDO24_ENCL_MASK 0x1
#define PMIC_RG_XO_BUFLDO24_ENCL_SHIFT 11
#define PMIC_RG_XO_BUFLDO24_IBX2_ADDR MT6356_DCXO_CW13
#define PMIC_RG_XO_BUFLDO24_IBX2_MASK 0x1
#define PMIC_RG_XO_BUFLDO24_IBX2_SHIFT 12
#define PMIC_RG_XO_RESERVED5_ADDR MT6356_DCXO_CW13
#define PMIC_RG_XO_RESERVED5_MASK 0x7
#define PMIC_RG_XO_RESERVED5_SHIFT 13
#define PMIC_RG_XO_BUFLDO13_ENCL_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_BUFLDO13_ENCL_MASK 0x1
#define PMIC_RG_XO_BUFLDO13_ENCL_SHIFT 0
#define PMIC_RG_XO_BUFLDO13_IBX2_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_BUFLDO13_IBX2_MASK 0x1
#define PMIC_RG_XO_BUFLDO13_IBX2_SHIFT 1
#define PMIC_RG_XO_BUFLDO13_IX2_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_BUFLDO13_IX2_MASK 0x1
#define PMIC_RG_XO_BUFLDO13_IX2_SHIFT 2
#define PMIC_RG_XO_LVLDO_I_CTRL_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_LVLDO_I_CTRL_MASK 0x3
#define PMIC_RG_XO_LVLDO_I_CTRL_SHIFT 3
#define PMIC_RG_XO_BUFLDO67_ENCL_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_BUFLDO67_ENCL_MASK 0x1
#define PMIC_RG_XO_BUFLDO67_ENCL_SHIFT 5
#define PMIC_RG_XO_BUFLDO67_IBX2_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_BUFLDO67_IBX2_MASK 0x1
#define PMIC_RG_XO_BUFLDO67_IBX2_SHIFT 6
#define PMIC_RG_XO_BUFLDO67_IX2_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_BUFLDO67_IX2_MASK 0x1
#define PMIC_RG_XO_BUFLDO67_IX2_SHIFT 7
#define PMIC_RG_XO_LVLDO_RFB_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_LVLDO_RFB_MASK 0x3
#define PMIC_RG_XO_LVLDO_RFB_SHIFT 8
#define PMIC_RG_XO_EXTBUF_INV_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_EXTBUF_INV_MASK 0x1
#define PMIC_RG_XO_EXTBUF_INV_SHIFT 10
#define PMIC_RG_XO_RESERVED0_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_RESERVED0_MASK 0x1
#define PMIC_RG_XO_RESERVED0_SHIFT 11
#define PMIC_XO_EXTBUF2_CLKSEL_MAN_ADDR MT6356_DCXO_CW14
#define PMIC_XO_EXTBUF2_CLKSEL_MAN_MASK 0x1
#define PMIC_XO_EXTBUF2_CLKSEL_MAN_SHIFT 12
#define PMIC_XO_AUDIO_EN_M_ADDR MT6356_DCXO_CW14
#define PMIC_XO_AUDIO_EN_M_MASK 0x1
#define PMIC_XO_AUDIO_EN_M_SHIFT 13
#define PMIC_RG_XO_AUDIO_ATTEN_ADDR MT6356_DCXO_CW14
#define PMIC_RG_XO_AUDIO_ATTEN_MASK 0x3
#define PMIC_RG_XO_AUDIO_ATTEN_SHIFT 14
#define PMIC_RG_XO_AUDIO_ISET_ADDR MT6356_DCXO_CW15
#define PMIC_RG_XO_AUDIO_ISET_MASK 0x3
#define PMIC_RG_XO_AUDIO_ISET_SHIFT 0
#define PMIC_RG_XO_EXTBUF1_HD_ADDR MT6356_DCXO_CW15
#define PMIC_RG_XO_EXTBUF1_HD_MASK 0x3
#define PMIC_RG_XO_EXTBUF1_HD_SHIFT 2
#define PMIC_RG_XO_EXTBUF2_HD_ADDR MT6356_DCXO_CW15
#define PMIC_RG_XO_EXTBUF2_HD_MASK 0x3
#define PMIC_RG_XO_EXTBUF2_HD_SHIFT 4
#define PMIC_RG_XO_EXTBUF3_HD_ADDR MT6356_DCXO_CW15
#define PMIC_RG_XO_EXTBUF3_HD_MASK 0x3
#define PMIC_RG_XO_EXTBUF3_HD_SHIFT 6
#define PMIC_RG_XO_EXTBUF4_HD_ADDR MT6356_DCXO_CW15
#define PMIC_RG_XO_EXTBUF4_HD_MASK 0x3
#define PMIC_RG_XO_EXTBUF4_HD_SHIFT 8
#define PMIC_RG_XO_RESERVED8_ADDR MT6356_DCXO_CW15
#define PMIC_RG_XO_RESERVED8_MASK 0x3
#define PMIC_RG_XO_RESERVED8_SHIFT 10
#define PMIC_RG_XO_EXTBUF6_HD_ADDR MT6356_DCXO_CW15
#define PMIC_RG_XO_EXTBUF6_HD_MASK 0x3
#define PMIC_RG_XO_EXTBUF6_HD_SHIFT 12
#define PMIC_RG_XO_EXTBUF7_HD_ADDR MT6356_DCXO_CW15
#define PMIC_RG_XO_EXTBUF7_HD_MASK 0x3
#define PMIC_RG_XO_EXTBUF7_HD_SHIFT 14
#define PMIC_XO_EXTBUF1_ISET_M_ADDR MT6356_DCXO_CW16
#define PMIC_XO_EXTBUF1_ISET_M_MASK 0x3
#define PMIC_XO_EXTBUF1_ISET_M_SHIFT 0
#define PMIC_XO_EXTBUF2_ISET_M_ADDR MT6356_DCXO_CW16
#define PMIC_XO_EXTBUF2_ISET_M_MASK 0x3
#define PMIC_XO_EXTBUF2_ISET_M_SHIFT 2
#define PMIC_XO_EXTBUF3_ISET_M_ADDR MT6356_DCXO_CW16
#define PMIC_XO_EXTBUF3_ISET_M_MASK 0x3
#define PMIC_XO_EXTBUF3_ISET_M_SHIFT 4
#define PMIC_XO_EXTBUF4_ISET_M_ADDR MT6356_DCXO_CW16
#define PMIC_XO_EXTBUF4_ISET_M_MASK 0x3
#define PMIC_XO_EXTBUF4_ISET_M_SHIFT 6
#define PMIC_XO_RESERVED9_ADDR MT6356_DCXO_CW16
#define PMIC_XO_RESERVED9_MASK 0x3
#define PMIC_XO_RESERVED9_SHIFT 8
#define PMIC_XO_EXTBUF6_ISET_M_ADDR MT6356_DCXO_CW16
#define PMIC_XO_EXTBUF6_ISET_M_MASK 0x3
#define PMIC_XO_EXTBUF6_ISET_M_SHIFT 10
#define PMIC_XO_EXTBUF7_ISET_M_ADDR MT6356_DCXO_CW16
#define PMIC_XO_EXTBUF7_ISET_M_MASK 0x3
#define PMIC_XO_EXTBUF7_ISET_M_SHIFT 12
#define PMIC_RG_XO_LPM_PREBUF_ISET_ADDR MT6356_DCXO_CW16
#define PMIC_RG_XO_LPM_PREBUF_ISET_MASK 0x3
#define PMIC_RG_XO_LPM_PREBUF_ISET_SHIFT 14
#define PMIC_RG_XO_RESERVED1_ADDR MT6356_DCXO_CW17
#define PMIC_RG_XO_RESERVED1_MASK 0x3
#define PMIC_RG_XO_RESERVED1_SHIFT 0
#define PMIC_XO_THADC_EN_MAN_ADDR MT6356_DCXO_CW17
#define PMIC_XO_THADC_EN_MAN_MASK 0x1
#define PMIC_XO_THADC_EN_MAN_SHIFT 2
#define PMIC_RG_XO_TSOURCE_EN_ADDR MT6356_DCXO_CW17
#define PMIC_RG_XO_TSOURCE_EN_MASK 0x1
#define PMIC_RG_XO_TSOURCE_EN_SHIFT 3
#define PMIC_XO_BUFLDO13_VSET_M_ADDR MT6356_DCXO_CW17
#define PMIC_XO_BUFLDO13_VSET_M_MASK 0xF
#define PMIC_XO_BUFLDO13_VSET_M_SHIFT 4
#define PMIC_XO_BUFLDO24_VSET_M_ADDR MT6356_DCXO_CW17
#define PMIC_XO_BUFLDO24_VSET_M_MASK 0xF
#define PMIC_XO_BUFLDO24_VSET_M_SHIFT 8
#define PMIC_XO_BUFLDO67_VSET_M_ADDR MT6356_DCXO_CW17
#define PMIC_XO_BUFLDO67_VSET_M_MASK 0xF
#define PMIC_XO_BUFLDO67_VSET_M_SHIFT 12
#define PMIC_XO_STATIC_AUXOUT_SEL_ADDR MT6356_DCXO_CW18
#define PMIC_XO_STATIC_AUXOUT_SEL_MASK 0x3F
#define PMIC_XO_STATIC_AUXOUT_SEL_SHIFT 0
#define PMIC_XO_AUXOUT_SEL_ADDR MT6356_DCXO_CW18
#define PMIC_XO_AUXOUT_SEL_MASK 0x3FF
#define PMIC_XO_AUXOUT_SEL_SHIFT 6
#define PMIC_XO_STATIC_AUXOUT_ADDR MT6356_DCXO_CW19
#define PMIC_XO_STATIC_AUXOUT_MASK 0xFFFF
#define PMIC_XO_STATIC_AUXOUT_SHIFT 0
#define PMIC_RG_XO_PCTAT_COMP_EN_ADDR MT6356_DCXO_CW20
#define PMIC_RG_XO_PCTAT_COMP_EN_MASK 0x1
#define PMIC_RG_XO_PCTAT_COMP_EN_SHIFT 0
#define PMIC_RG_XO_HEATER_SEL_ADDR MT6356_DCXO_CW20
#define PMIC_RG_XO_HEATER_SEL_MASK 0x3
#define PMIC_RG_XO_HEATER_SEL_SHIFT 1
#define PMIC_RG_XO_CORNER_DETECT_EN_ADDR MT6356_DCXO_CW20
#define PMIC_RG_XO_CORNER_DETECT_EN_MASK 0x1
#define PMIC_RG_XO_CORNER_DETECT_EN_SHIFT 3
#define PMIC_RG_XO_CORNER_DETECT_EN_MAN_ADDR MT6356_DCXO_CW20
#define PMIC_RG_XO_CORNER_DETECT_EN_MAN_MASK 0x1
#define PMIC_RG_XO_CORNER_DETECT_EN_MAN_SHIFT 4
#define PMIC_RG_XO_RESRVED10_ADDR MT6356_DCXO_CW20
#define PMIC_RG_XO_RESRVED10_MASK 0x7FF
#define PMIC_RG_XO_RESRVED10_SHIFT 5
#define PMIC_RG_XO_CORNER_SETTING_TUNE_ADDR MT6356_DCXO_CW21
#define PMIC_RG_XO_CORNER_SETTING_TUNE_MASK 0x3FF
#define PMIC_RG_XO_CORNER_SETTING_TUNE_SHIFT 0
#define PMIC_RG_XO_RESRVED11_ADDR MT6356_DCXO_CW21
#define PMIC_RG_XO_RESRVED11_MASK 0x3F
#define PMIC_RG_XO_RESRVED11_SHIFT 10
#define PMIC_RGS_AD_XO_CORNER_CAL_DONE_ADDR MT6356_DCXO_CW22
#define PMIC_RGS_AD_XO_CORNER_CAL_DONE_MASK 0x1
#define PMIC_RGS_AD_XO_CORNER_CAL_DONE_SHIFT 0
#define PMIC_RGS_AD_XO_CORNER_SEL_ADDR MT6356_DCXO_CW22
#define PMIC_RGS_AD_XO_CORNER_SEL_MASK 0xF
#define PMIC_RGS_AD_XO_CORNER_SEL_SHIFT 1
#define PMIC_XO_MDB_TBO_EN_SEL_ADDR MT6356_DCXO_CW22
#define PMIC_XO_MDB_TBO_EN_SEL_MASK 0x1
#define PMIC_XO_MDB_TBO_EN_SEL_SHIFT 5
#define PMIC_XO_PTATCTAT_EN_MAN_ADDR MT6356_DCXO_CW22
#define PMIC_XO_PTATCTAT_EN_MAN_MASK 0x1
#define PMIC_XO_PTATCTAT_EN_MAN_SHIFT 6
#define PMIC_XO_PTATCTAT_EN_M_ADDR MT6356_DCXO_CW22
#define PMIC_XO_PTATCTAT_EN_M_MASK 0x1
#define PMIC_XO_PTATCTAT_EN_M_SHIFT 7
#define PMIC_XO_PTATCTAT_EN_LPM_ADDR MT6356_DCXO_CW22
#define PMIC_XO_PTATCTAT_EN_LPM_MASK 0x1
#define PMIC_XO_PTATCTAT_EN_LPM_SHIFT 8
#define PMIC_XO_PTATCTAT_EN_FPM_ADDR MT6356_DCXO_CW22
#define PMIC_XO_PTATCTAT_EN_FPM_MASK 0x1
#define PMIC_XO_PTATCTAT_EN_FPM_SHIFT 9
#define PMIC_DCXO_ELR_LEN_ADDR MT6356_DCXO_ELR_NUM
#define PMIC_DCXO_ELR_LEN_MASK 0xFF
#define PMIC_DCXO_ELR_LEN_SHIFT 0
#define PMIC_RG_XO_PCTAT_RDEG_SEL_ADDR MT6356_DCXO_ELR0
#define PMIC_RG_XO_PCTAT_RDEG_SEL_MASK 0x1
#define PMIC_RG_XO_PCTAT_RDEG_SEL_SHIFT 0
#define PMIC_RG_XO_GS_VTEMP_ADDR MT6356_DCXO_ELR0
#define PMIC_RG_XO_GS_VTEMP_MASK 0x7
#define PMIC_RG_XO_GS_VTEMP_SHIFT 1
#define PMIC_XO_PWRKEY_RSTB_SEL_ADDR MT6356_DCXO_ELR0
#define PMIC_XO_PWRKEY_RSTB_SEL_MASK 0x1
#define PMIC_XO_PWRKEY_RSTB_SEL_SHIFT 4
#define PMIC_RTC_ANA_ID_ADDR MT6356_RTC_DSN_ID
#define PMIC_RTC_ANA_ID_MASK 0xFF
#define PMIC_RTC_ANA_ID_SHIFT 0
#define PMIC_RTC_DIG_ID_ADDR MT6356_RTC_DSN_ID
#define PMIC_RTC_DIG_ID_MASK 0xFF
#define PMIC_RTC_DIG_ID_SHIFT 8
#define PMIC_RTC_ANA_MINOR_REV_ADDR MT6356_RTC_DSN_REV0
#define PMIC_RTC_ANA_MINOR_REV_MASK 0xF
#define PMIC_RTC_ANA_MINOR_REV_SHIFT 0
#define PMIC_RTC_ANA_MAJOR_REV_ADDR MT6356_RTC_DSN_REV0
#define PMIC_RTC_ANA_MAJOR_REV_MASK 0xF
#define PMIC_RTC_ANA_MAJOR_REV_SHIFT 4
#define PMIC_RTC_DIG_MINOR_REV_ADDR MT6356_RTC_DSN_REV0
#define PMIC_RTC_DIG_MINOR_REV_MASK 0xF
#define PMIC_RTC_DIG_MINOR_REV_SHIFT 8
#define PMIC_RTC_DIG_MAJOR_REV_ADDR MT6356_RTC_DSN_REV0
#define PMIC_RTC_DIG_MAJOR_REV_MASK 0xF
#define PMIC_RTC_DIG_MAJOR_REV_SHIFT 12
#define PMIC_RTC_SW_MINOR_REV_ADDR MT6356_RTC_DSN_REV1
#define PMIC_RTC_SW_MINOR_REV_MASK 0xF
#define PMIC_RTC_SW_MINOR_REV_SHIFT 0
#define PMIC_RTC_SW_MAJOR_REV_ADDR MT6356_RTC_DSN_REV1
#define PMIC_RTC_SW_MAJOR_REV_MASK 0xF
#define PMIC_RTC_SW_MAJOR_REV_SHIFT 4
#define PMIC_RTC_ESP_ADDR MT6356_RTC_DSN_REV1
#define PMIC_RTC_ESP_MASK 0xFF
#define PMIC_RTC_ESP_SHIFT 8
#define PMIC_RTC_DUMMY_ADDR MT6356_RTC_DUMMY_CON0
#define PMIC_RTC_DUMMY_MASK 0xFFFF
#define PMIC_RTC_DUMMY_SHIFT 0
#define PMIC_PWREN_ADDR MT6356_RTC_BBPU
#define PMIC_PWREN_MASK 0x1
#define PMIC_PWREN_SHIFT 0
#define PMIC_BBPU_ADDR MT6356_RTC_BBPU
#define PMIC_BBPU_MASK 0x1
#define PMIC_BBPU_SHIFT 2
#define PMIC_AUTO_ADDR MT6356_RTC_BBPU
#define PMIC_AUTO_MASK 0x1
#define PMIC_AUTO_SHIFT 3
#define PMIC_CLRPKY_ADDR MT6356_RTC_BBPU
#define PMIC_CLRPKY_MASK 0x1
#define PMIC_CLRPKY_SHIFT 4
#define PMIC_RELOAD_ADDR MT6356_RTC_BBPU
#define PMIC_RELOAD_MASK 0x1
#define PMIC_RELOAD_SHIFT 5
#define PMIC_CBUSY_ADDR MT6356_RTC_BBPU
#define PMIC_CBUSY_MASK 0x1
#define PMIC_CBUSY_SHIFT 6
#define PMIC_KEY_BBPU_ADDR MT6356_RTC_BBPU
#define PMIC_KEY_BBPU_MASK 0xFF
#define PMIC_KEY_BBPU_SHIFT 8
#define PMIC_ALSTA_ADDR MT6356_RTC_IRQ_STA
#define PMIC_ALSTA_MASK 0x1
#define PMIC_ALSTA_SHIFT 0
#define PMIC_TCSTA_ADDR MT6356_RTC_IRQ_STA
#define PMIC_TCSTA_MASK 0x1
#define PMIC_TCSTA_SHIFT 1
#define PMIC_LPSTA_ADDR MT6356_RTC_IRQ_STA
#define PMIC_LPSTA_MASK 0x1
#define PMIC_LPSTA_SHIFT 3
#define PMIC_AL_EN_ADDR MT6356_RTC_IRQ_EN
#define PMIC_AL_EN_MASK 0x1
#define PMIC_AL_EN_SHIFT 0
#define PMIC_TC_EN_ADDR MT6356_RTC_IRQ_EN
#define PMIC_TC_EN_MASK 0x1
#define PMIC_TC_EN_SHIFT 1
#define PMIC_ONESHOT_ADDR MT6356_RTC_IRQ_EN
#define PMIC_ONESHOT_MASK 0x1
#define PMIC_ONESHOT_SHIFT 2
#define PMIC_LP_EN_ADDR MT6356_RTC_IRQ_EN
#define PMIC_LP_EN_MASK 0x1
#define PMIC_LP_EN_SHIFT 3
#define PMIC_SECCII_ADDR MT6356_RTC_CII_EN
#define PMIC_SECCII_MASK 0x1
#define PMIC_SECCII_SHIFT 0
#define PMIC_MINCII_ADDR MT6356_RTC_CII_EN
#define PMIC_MINCII_MASK 0x1
#define PMIC_MINCII_SHIFT 1
#define PMIC_HOUCII_ADDR MT6356_RTC_CII_EN
#define PMIC_HOUCII_MASK 0x1
#define PMIC_HOUCII_SHIFT 2
#define PMIC_DOMCII_ADDR MT6356_RTC_CII_EN
#define PMIC_DOMCII_MASK 0x1
#define PMIC_DOMCII_SHIFT 3
#define PMIC_DOWCII_ADDR MT6356_RTC_CII_EN
#define PMIC_DOWCII_MASK 0x1
#define PMIC_DOWCII_SHIFT 4
#define PMIC_MTHCII_ADDR MT6356_RTC_CII_EN
#define PMIC_MTHCII_MASK 0x1
#define PMIC_MTHCII_SHIFT 5
#define PMIC_YEACII_ADDR MT6356_RTC_CII_EN
#define PMIC_YEACII_MASK 0x1
#define PMIC_YEACII_SHIFT 6
#define PMIC_SECCII_1_2_ADDR MT6356_RTC_CII_EN
#define PMIC_SECCII_1_2_MASK 0x1
#define PMIC_SECCII_1_2_SHIFT 7
#define PMIC_SECCII_1_4_ADDR MT6356_RTC_CII_EN
#define PMIC_SECCII_1_4_MASK 0x1
#define PMIC_SECCII_1_4_SHIFT 8
#define PMIC_SECCII_1_8_ADDR MT6356_RTC_CII_EN
#define PMIC_SECCII_1_8_MASK 0x1
#define PMIC_SECCII_1_8_SHIFT 9
#define PMIC_SEC_MSK_ADDR MT6356_RTC_AL_MASK
#define PMIC_SEC_MSK_MASK 0x1
#define PMIC_SEC_MSK_SHIFT 0
#define PMIC_MIN_MSK_ADDR MT6356_RTC_AL_MASK
#define PMIC_MIN_MSK_MASK 0x1
#define PMIC_MIN_MSK_SHIFT 1
#define PMIC_HOU_MSK_ADDR MT6356_RTC_AL_MASK
#define PMIC_HOU_MSK_MASK 0x1
#define PMIC_HOU_MSK_SHIFT 2
#define PMIC_DOM_MSK_ADDR MT6356_RTC_AL_MASK
#define PMIC_DOM_MSK_MASK 0x1
#define PMIC_DOM_MSK_SHIFT 3
#define PMIC_DOW_MSK_ADDR MT6356_RTC_AL_MASK
#define PMIC_DOW_MSK_MASK 0x1
#define PMIC_DOW_MSK_SHIFT 4
#define PMIC_MTH_MSK_ADDR MT6356_RTC_AL_MASK
#define PMIC_MTH_MSK_MASK 0x1
#define PMIC_MTH_MSK_SHIFT 5
#define PMIC_YEA_MSK_ADDR MT6356_RTC_AL_MASK
#define PMIC_YEA_MSK_MASK 0x1
#define PMIC_YEA_MSK_SHIFT 6
#define PMIC_TC_SECOND_ADDR MT6356_RTC_TC_SEC
#define PMIC_TC_SECOND_MASK 0x3F
#define PMIC_TC_SECOND_SHIFT 0
#define PMIC_TC_MINUTE_ADDR MT6356_RTC_TC_MIN
#define PMIC_TC_MINUTE_MASK 0x3F
#define PMIC_TC_MINUTE_SHIFT 0
#define PMIC_TC_HOUR_ADDR MT6356_RTC_TC_HOU
#define PMIC_TC_HOUR_MASK 0x1F
#define PMIC_TC_HOUR_SHIFT 0
#define PMIC_TC_DOM_ADDR MT6356_RTC_TC_DOM
#define PMIC_TC_DOM_MASK 0x1F
#define PMIC_TC_DOM_SHIFT 0
#define PMIC_TC_DOW_ADDR MT6356_RTC_TC_DOW
#define PMIC_TC_DOW_MASK 0x7
#define PMIC_TC_DOW_SHIFT 0
#define PMIC_TC_MONTH_ADDR MT6356_RTC_TC_MTH
#define PMIC_TC_MONTH_MASK 0xF
#define PMIC_TC_MONTH_SHIFT 0
#define PMIC_TC_YEAR_ADDR MT6356_RTC_TC_YEA
#define PMIC_TC_YEAR_MASK 0x7F
#define PMIC_TC_YEAR_SHIFT 0
#define PMIC_AL_SECOND_ADDR MT6356_RTC_AL_SEC
#define PMIC_AL_SECOND_MASK 0x3F
#define PMIC_AL_SECOND_SHIFT 0
#define PMIC_BBPU_AUTO_PDN_SEL_ADDR MT6356_RTC_AL_SEC
#define PMIC_BBPU_AUTO_PDN_SEL_MASK 0x1
#define PMIC_BBPU_AUTO_PDN_SEL_SHIFT 6
#define PMIC_BBPU_2SEC_CK_SEL_ADDR MT6356_RTC_AL_SEC
#define PMIC_BBPU_2SEC_CK_SEL_MASK 0x1
#define PMIC_BBPU_2SEC_CK_SEL_SHIFT 7
#define PMIC_BBPU_2SEC_EN_ADDR MT6356_RTC_AL_SEC
#define PMIC_BBPU_2SEC_EN_MASK 0x1
#define PMIC_BBPU_2SEC_EN_SHIFT 8
#define PMIC_BBPU_2SEC_MODE_ADDR MT6356_RTC_AL_SEC
#define PMIC_BBPU_2SEC_MODE_MASK 0x3
#define PMIC_BBPU_2SEC_MODE_SHIFT 9
#define PMIC_BBPU_2SEC_STAT_CLEAR_ADDR MT6356_RTC_AL_SEC
#define PMIC_BBPU_2SEC_STAT_CLEAR_MASK 0x1
#define PMIC_BBPU_2SEC_STAT_CLEAR_SHIFT 11
#define PMIC_BBPU_2SEC_STAT_STA_ADDR MT6356_RTC_AL_SEC
#define PMIC_BBPU_2SEC_STAT_STA_MASK 0x1
#define PMIC_BBPU_2SEC_STAT_STA_SHIFT 12
#define PMIC_RTC_LPD_OPT_ADDR MT6356_RTC_AL_SEC
#define PMIC_RTC_LPD_OPT_MASK 0x3
#define PMIC_RTC_LPD_OPT_SHIFT 13
#define PMIC_K_EOSC32_VTCXO_ON_SEL_ADDR MT6356_RTC_AL_SEC
#define PMIC_K_EOSC32_VTCXO_ON_SEL_MASK 0x1
#define PMIC_K_EOSC32_VTCXO_ON_SEL_SHIFT 15
#define PMIC_AL_MINUTE_ADDR MT6356_RTC_AL_MIN
#define PMIC_AL_MINUTE_MASK 0x3F
#define PMIC_AL_MINUTE_SHIFT 0
#define PMIC_AL_HOUR_ADDR MT6356_RTC_AL_HOU
#define PMIC_AL_HOUR_MASK 0x1F
#define PMIC_AL_HOUR_SHIFT 0
#define PMIC_NEW_SPARE0_ADDR MT6356_RTC_AL_HOU
#define PMIC_NEW_SPARE0_MASK 0xFF
#define PMIC_NEW_SPARE0_SHIFT 8
#define PMIC_AL_DOM_ADDR MT6356_RTC_AL_DOM
#define PMIC_AL_DOM_MASK 0x1F
#define PMIC_AL_DOM_SHIFT 0
#define PMIC_NEW_SPARE1_ADDR MT6356_RTC_AL_DOM
#define PMIC_NEW_SPARE1_MASK 0xFF
#define PMIC_NEW_SPARE1_SHIFT 8
#define PMIC_AL_DOW_ADDR MT6356_RTC_AL_DOW
#define PMIC_AL_DOW_MASK 0x7
#define PMIC_AL_DOW_SHIFT 0
#define PMIC_NEW_SPARE2_ADDR MT6356_RTC_AL_DOW
#define PMIC_NEW_SPARE2_MASK 0xFF
#define PMIC_NEW_SPARE2_SHIFT 8
#define PMIC_AL_MONTH_ADDR MT6356_RTC_AL_MTH
#define PMIC_AL_MONTH_MASK 0xF
#define PMIC_AL_MONTH_SHIFT 0
#define PMIC_NEW_SPARE3_ADDR MT6356_RTC_AL_MTH
#define PMIC_NEW_SPARE3_MASK 0xFF
#define PMIC_NEW_SPARE3_SHIFT 8
#define PMIC_AL_YEAR_ADDR MT6356_RTC_AL_YEA
#define PMIC_AL_YEAR_MASK 0x7F
#define PMIC_AL_YEAR_SHIFT 0
#define PMIC_RTC_K_EOSC_RSV_ADDR MT6356_RTC_AL_YEA
#define PMIC_RTC_K_EOSC_RSV_MASK 0xFF
#define PMIC_RTC_K_EOSC_RSV_SHIFT 8
#define PMIC_XOSCCALI_ADDR MT6356_RTC_OSC32CON
#define PMIC_XOSCCALI_MASK 0x1F
#define PMIC_XOSCCALI_SHIFT 0
#define PMIC_RTC_XOSC32_ENB_ADDR MT6356_RTC_OSC32CON
#define PMIC_RTC_XOSC32_ENB_MASK 0x1
#define PMIC_RTC_XOSC32_ENB_SHIFT 5
#define PMIC_RTC_EMBCK_SEL_MODE_ADDR MT6356_RTC_OSC32CON
#define PMIC_RTC_EMBCK_SEL_MODE_MASK 0x3
#define PMIC_RTC_EMBCK_SEL_MODE_SHIFT 6
#define PMIC_RTC_EMBCK_SRC_SEL_ADDR MT6356_RTC_OSC32CON
#define PMIC_RTC_EMBCK_SRC_SEL_MASK 0x1
#define PMIC_RTC_EMBCK_SRC_SEL_SHIFT 8
#define PMIC_RTC_EMBCK_SEL_OPTION_ADDR MT6356_RTC_OSC32CON
#define PMIC_RTC_EMBCK_SEL_OPTION_MASK 0x1
#define PMIC_RTC_EMBCK_SEL_OPTION_SHIFT 9
#define PMIC_RTC_EOSC32_OPT_ADDR MT6356_RTC_OSC32CON
#define PMIC_RTC_EOSC32_OPT_MASK 0x1
#define PMIC_RTC_EOSC32_OPT_SHIFT 10
#define PMIC_RTC_EOSC32_VCT_EN_ADDR MT6356_RTC_OSC32CON
#define PMIC_RTC_EOSC32_VCT_EN_MASK 0x1
#define PMIC_RTC_EOSC32_VCT_EN_SHIFT 11
#define PMIC_RTC_EOSC32_CHOP_EN_ADDR MT6356_RTC_OSC32CON
#define PMIC_RTC_EOSC32_CHOP_EN_MASK 0x1
#define PMIC_RTC_EOSC32_CHOP_EN_SHIFT 12
#define PMIC_RTC_GP_OSC32_CON_ADDR MT6356_RTC_OSC32CON
#define PMIC_RTC_GP_OSC32_CON_MASK 0x3
#define PMIC_RTC_GP_OSC32_CON_SHIFT 13
#define PMIC_RTC_REG_XOSC32_ENB_ADDR MT6356_RTC_OSC32CON
#define PMIC_RTC_REG_XOSC32_ENB_MASK 0x1
#define PMIC_RTC_REG_XOSC32_ENB_SHIFT 15
#define PMIC_RTC_POWERKEY1_ADDR MT6356_RTC_POWERKEY1
#define PMIC_RTC_POWERKEY1_MASK 0xFFFF
#define PMIC_RTC_POWERKEY1_SHIFT 0
#define PMIC_RTC_POWERKEY2_ADDR MT6356_RTC_POWERKEY2
#define PMIC_RTC_POWERKEY2_MASK 0xFFFF
#define PMIC_RTC_POWERKEY2_SHIFT 0
#define PMIC_RTC_PDN1_ADDR MT6356_RTC_PDN1
#define PMIC_RTC_PDN1_MASK 0xFFFF
#define PMIC_RTC_PDN1_SHIFT 0
#define PMIC_RTC_PDN2_ADDR MT6356_RTC_PDN2
#define PMIC_RTC_PDN2_MASK 0xFFFF
#define PMIC_RTC_PDN2_SHIFT 0
#define PMIC_RTC_SPAR0_ADDR MT6356_RTC_SPAR0
#define PMIC_RTC_SPAR0_MASK 0xFFFF
#define PMIC_RTC_SPAR0_SHIFT 0
#define PMIC_RTC_SPAR1_ADDR MT6356_RTC_SPAR1
#define PMIC_RTC_SPAR1_MASK 0xFFFF
#define PMIC_RTC_SPAR1_SHIFT 0
#define PMIC_RTC_PROT_ADDR MT6356_RTC_PROT
#define PMIC_RTC_PROT_MASK 0xFFFF
#define PMIC_RTC_PROT_SHIFT 0
#define PMIC_RTC_DIFF_ADDR MT6356_RTC_DIFF
#define PMIC_RTC_DIFF_MASK 0xFFF
#define PMIC_RTC_DIFF_SHIFT 0
#define PMIC_POWER_DETECTED_ADDR MT6356_RTC_DIFF
#define PMIC_POWER_DETECTED_MASK 0x1
#define PMIC_POWER_DETECTED_SHIFT 12
#define PMIC_K_EOSC32_RSV_ADDR MT6356_RTC_DIFF
#define PMIC_K_EOSC32_RSV_MASK 0x1
#define PMIC_K_EOSC32_RSV_SHIFT 14
#define PMIC_CALI_RD_SEL_ADDR MT6356_RTC_DIFF
#define PMIC_CALI_RD_SEL_MASK 0x1
#define PMIC_CALI_RD_SEL_SHIFT 15
#define PMIC_RTC_CALI_ADDR MT6356_RTC_CALI
#define PMIC_RTC_CALI_MASK 0x3FFF
#define PMIC_RTC_CALI_SHIFT 0
#define PMIC_CALI_WR_SEL_ADDR MT6356_RTC_CALI
#define PMIC_CALI_WR_SEL_MASK 0x1
#define PMIC_CALI_WR_SEL_SHIFT 14
#define PMIC_K_EOSC32_OVERFLOW_ADDR MT6356_RTC_CALI
#define PMIC_K_EOSC32_OVERFLOW_MASK 0x1
#define PMIC_K_EOSC32_OVERFLOW_SHIFT 15
#define PMIC_WRTGR_ADDR MT6356_RTC_WRTGR
#define PMIC_WRTGR_MASK 0x1
#define PMIC_WRTGR_SHIFT 0
#define PMIC_VBAT_LPSTA_RAW_ADDR MT6356_RTC_CON
#define PMIC_VBAT_LPSTA_RAW_MASK 0x1
#define PMIC_VBAT_LPSTA_RAW_SHIFT 0
#define PMIC_EOSC32_LPEN_ADDR MT6356_RTC_CON
#define PMIC_EOSC32_LPEN_MASK 0x1
#define PMIC_EOSC32_LPEN_SHIFT 1
#define PMIC_XOSC32_LPEN_ADDR MT6356_RTC_CON
#define PMIC_XOSC32_LPEN_MASK 0x1
#define PMIC_XOSC32_LPEN_SHIFT 2
#define PMIC_LPRST_ADDR MT6356_RTC_CON
#define PMIC_LPRST_MASK 0x1
#define PMIC_LPRST_SHIFT 3
#define PMIC_CDBO_ADDR MT6356_RTC_CON
#define PMIC_CDBO_MASK 0x1
#define PMIC_CDBO_SHIFT 4
#define PMIC_F32KOB_ADDR MT6356_RTC_CON
#define PMIC_F32KOB_MASK 0x1
#define PMIC_F32KOB_SHIFT 5
#define PMIC_GPO_ADDR MT6356_RTC_CON
#define PMIC_GPO_MASK 0x1
#define PMIC_GPO_SHIFT 6
#define PMIC_GOE_ADDR MT6356_RTC_CON
#define PMIC_GOE_MASK 0x1
#define PMIC_GOE_SHIFT 7
#define PMIC_GSR_ADDR MT6356_RTC_CON
#define PMIC_GSR_MASK 0x1
#define PMIC_GSR_SHIFT 8
#define PMIC_GSMT_ADDR MT6356_RTC_CON
#define PMIC_GSMT_MASK 0x1
#define PMIC_GSMT_SHIFT 9
#define PMIC_GPEN_ADDR MT6356_RTC_CON
#define PMIC_GPEN_MASK 0x1
#define PMIC_GPEN_SHIFT 10
#define PMIC_GPU_ADDR MT6356_RTC_CON
#define PMIC_GPU_MASK 0x1
#define PMIC_GPU_SHIFT 11
#define PMIC_GE4_ADDR MT6356_RTC_CON
#define PMIC_GE4_MASK 0x1
#define PMIC_GE4_SHIFT 12
#define PMIC_GE8_ADDR MT6356_RTC_CON
#define PMIC_GE8_MASK 0x1
#define PMIC_GE8_SHIFT 13
#define PMIC_GPI_ADDR MT6356_RTC_CON
#define PMIC_GPI_MASK 0x1
#define PMIC_GPI_SHIFT 14
#define PMIC_LPSTA_RAW_ADDR MT6356_RTC_CON
#define PMIC_LPSTA_RAW_MASK 0x1
#define PMIC_LPSTA_RAW_SHIFT 15
#define PMIC_DAT0_LOCK_ADDR MT6356_RTC_SEC_CTRL
#define PMIC_DAT0_LOCK_MASK 0x1
#define PMIC_DAT0_LOCK_SHIFT 0
#define PMIC_DAT1_LOCK_ADDR MT6356_RTC_SEC_CTRL
#define PMIC_DAT1_LOCK_MASK 0x1
#define PMIC_DAT1_LOCK_SHIFT 1
#define PMIC_DAT2_LOCK_ADDR MT6356_RTC_SEC_CTRL
#define PMIC_DAT2_LOCK_MASK 0x1
#define PMIC_DAT2_LOCK_SHIFT 2
#define PMIC_RTC_INT_CNT_ADDR MT6356_RTC_INT_CNT
#define PMIC_RTC_INT_CNT_MASK 0x7FFF
#define PMIC_RTC_INT_CNT_SHIFT 0
#define PMIC_RTC_SEC_DAT0_ADDR MT6356_RTC_SEC_DAT0
#define PMIC_RTC_SEC_DAT0_MASK 0xFFFF
#define PMIC_RTC_SEC_DAT0_SHIFT 0
#define PMIC_RTC_SEC_DAT1_ADDR MT6356_RTC_SEC_DAT1
#define PMIC_RTC_SEC_DAT1_MASK 0xFFFF
#define PMIC_RTC_SEC_DAT1_SHIFT 0
#define PMIC_RTC_SEC_DAT2_ADDR MT6356_RTC_SEC_DAT2
#define PMIC_RTC_SEC_DAT2_MASK 0xFFFF
#define PMIC_RTC_SEC_DAT2_SHIFT 0
#define PMIC_EOSC_CALI_ANA_ID_ADDR MT6356_EOSC_CALI_DSN_ID
#define PMIC_EOSC_CALI_ANA_ID_MASK 0xFF
#define PMIC_EOSC_CALI_ANA_ID_SHIFT 0
#define PMIC_EOSC_CALI_DIG_ID_ADDR MT6356_EOSC_CALI_DSN_ID
#define PMIC_EOSC_CALI_DIG_ID_MASK 0xFF
#define PMIC_EOSC_CALI_DIG_ID_SHIFT 8
#define PMIC_EOSC_CALI_ANA_MINOR_REV_ADDR MT6356_EOSC_CALI_DSN_REV0
#define PMIC_EOSC_CALI_ANA_MINOR_REV_MASK 0xF
#define PMIC_EOSC_CALI_ANA_MINOR_REV_SHIFT 0
#define PMIC_EOSC_CALI_ANA_MAJOR_REV_ADDR MT6356_EOSC_CALI_DSN_REV0
#define PMIC_EOSC_CALI_ANA_MAJOR_REV_MASK 0xF
#define PMIC_EOSC_CALI_ANA_MAJOR_REV_SHIFT 4
#define PMIC_EOSC_CALI_DIG_MINOR_REV_ADDR MT6356_EOSC_CALI_DSN_REV0
#define PMIC_EOSC_CALI_DIG_MINOR_REV_MASK 0xF
#define PMIC_EOSC_CALI_DIG_MINOR_REV_SHIFT 8
#define PMIC_EOSC_CALI_DIG_MAJOR_REV_ADDR MT6356_EOSC_CALI_DSN_REV0
#define PMIC_EOSC_CALI_DIG_MAJOR_REV_MASK 0xF
#define PMIC_EOSC_CALI_DIG_MAJOR_REV_SHIFT 12
#define PMIC_EOSC_CALI_SW_MINOR_REV_ADDR MT6356_EOSC_CALI_DSN_REV1
#define PMIC_EOSC_CALI_SW_MINOR_REV_MASK 0xF
#define PMIC_EOSC_CALI_SW_MINOR_REV_SHIFT 0
#define PMIC_EOSC_CALI_SW_MAJOR_REV_ADDR MT6356_EOSC_CALI_DSN_REV1
#define PMIC_EOSC_CALI_SW_MAJOR_REV_MASK 0xF
#define PMIC_EOSC_CALI_SW_MAJOR_REV_SHIFT 4
#define PMIC_EOSC_CALI_ESP_ADDR MT6356_EOSC_CALI_DSN_REV1
#define PMIC_EOSC_CALI_ESP_MASK 0xFF
#define PMIC_EOSC_CALI_ESP_SHIFT 8
#define PMIC_EOSC_CALI_START_ADDR MT6356_EOSC_CALI_CON0
#define PMIC_EOSC_CALI_START_MASK 0x1
#define PMIC_EOSC_CALI_START_SHIFT 0
#define PMIC_EOSC_CALI_TD_ADDR MT6356_EOSC_CALI_CON0
#define PMIC_EOSC_CALI_TD_MASK 0x7
#define PMIC_EOSC_CALI_TD_SHIFT 5
#define PMIC_EOSC_CALI_TEST_ADDR MT6356_EOSC_CALI_CON0
#define PMIC_EOSC_CALI_TEST_MASK 0xF
#define PMIC_EOSC_CALI_TEST_SHIFT 9
#define PMIC_EOSC_CALI_DCXO_RDY_TD_ADDR MT6356_EOSC_CALI_CON1
#define PMIC_EOSC_CALI_DCXO_RDY_TD_MASK 0x7
#define PMIC_EOSC_CALI_DCXO_RDY_TD_SHIFT 0
#define PMIC_FRC_VTCXO0_ON_ADDR MT6356_EOSC_CALI_CON1
#define PMIC_FRC_VTCXO0_ON_MASK 0x1
#define PMIC_FRC_VTCXO0_ON_SHIFT 8
#define PMIC_EOSC_CALI_RSV_ADDR MT6356_EOSC_CALI_CON1
#define PMIC_EOSC_CALI_RSV_MASK 0xF
#define PMIC_EOSC_CALI_RSV_SHIFT 11
#define PMIC_MIX_EOSC32_STP_LPDTB_ADDR MT6356_RTC_MIX_CON0
#define PMIC_MIX_EOSC32_STP_LPDTB_MASK 0x1
#define PMIC_MIX_EOSC32_STP_LPDTB_SHIFT 1
#define PMIC_MIX_EOSC32_STP_LPDEN_ADDR MT6356_RTC_MIX_CON0
#define PMIC_MIX_EOSC32_STP_LPDEN_MASK 0x1
#define PMIC_MIX_EOSC32_STP_LPDEN_SHIFT 2
#define PMIC_MIX_XOSC32_STP_PWDB_ADDR MT6356_RTC_MIX_CON0
#define PMIC_MIX_XOSC32_STP_PWDB_MASK 0x1
#define PMIC_MIX_XOSC32_STP_PWDB_SHIFT 3
#define PMIC_MIX_XOSC32_STP_LPDTB_ADDR MT6356_RTC_MIX_CON0
#define PMIC_MIX_XOSC32_STP_LPDTB_MASK 0x1
#define PMIC_MIX_XOSC32_STP_LPDTB_SHIFT 4
#define PMIC_MIX_XOSC32_STP_LPDEN_ADDR MT6356_RTC_MIX_CON0
#define PMIC_MIX_XOSC32_STP_LPDEN_MASK 0x1
#define PMIC_MIX_XOSC32_STP_LPDEN_SHIFT 5
#define PMIC_MIX_XOSC32_STP_LPDRST_ADDR MT6356_RTC_MIX_CON0
#define PMIC_MIX_XOSC32_STP_LPDRST_MASK 0x1
#define PMIC_MIX_XOSC32_STP_LPDRST_SHIFT 6
#define PMIC_MIX_XOSC32_STP_CALI_ADDR MT6356_RTC_MIX_CON0
#define PMIC_MIX_XOSC32_STP_CALI_MASK 0x1F
#define PMIC_MIX_XOSC32_STP_CALI_SHIFT 7
#define PMIC_STMP_MODE_ADDR MT6356_RTC_MIX_CON0
#define PMIC_STMP_MODE_MASK 0x1
#define PMIC_STMP_MODE_SHIFT 12
#define PMIC_MIX_EOSC32_STP_CHOP_EN_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_EOSC32_STP_CHOP_EN_MASK 0x1
#define PMIC_MIX_EOSC32_STP_CHOP_EN_SHIFT 0
#define PMIC_MIX_DCXO_STP_LVSH_EN_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_DCXO_STP_LVSH_EN_MASK 0x1
#define PMIC_MIX_DCXO_STP_LVSH_EN_SHIFT 1
#define PMIC_MIX_PMU_STP_DDLO_VRTC_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_PMU_STP_DDLO_VRTC_MASK 0x1
#define PMIC_MIX_PMU_STP_DDLO_VRTC_SHIFT 2
#define PMIC_MIX_PMU_STP_DDLO_VRTC_EN_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_PMU_STP_DDLO_VRTC_EN_MASK 0x1
#define PMIC_MIX_PMU_STP_DDLO_VRTC_EN_SHIFT 3
#define PMIC_MIX_RTC_STP_XOSC32_ENB_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_RTC_STP_XOSC32_ENB_MASK 0x1
#define PMIC_MIX_RTC_STP_XOSC32_ENB_SHIFT 4
#define PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_MASK 0x1
#define PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_SHIFT 5
#define PMIC_MIX_EOSC32_STP_RSV_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_EOSC32_STP_RSV_MASK 0x3
#define PMIC_MIX_EOSC32_STP_RSV_SHIFT 6
#define PMIC_MIX_EOSC32_VCT_EN_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_EOSC32_VCT_EN_MASK 0x1
#define PMIC_MIX_EOSC32_VCT_EN_SHIFT 8
#define PMIC_MIX_EOSC32_OPT_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_EOSC32_OPT_MASK 0x3
#define PMIC_MIX_EOSC32_OPT_SHIFT 9
#define PMIC_MIX_DCXO_STP_LVSH_EN_INT_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_DCXO_STP_LVSH_EN_INT_MASK 0x1
#define PMIC_MIX_DCXO_STP_LVSH_EN_INT_SHIFT 11
#define PMIC_MIX_RTC_GPIO_COREDETB_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_RTC_GPIO_COREDETB_MASK 0x1
#define PMIC_MIX_RTC_GPIO_COREDETB_SHIFT 12
#define PMIC_MIX_RTC_GPIO_F32KOB_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_RTC_GPIO_F32KOB_MASK 0x1
#define PMIC_MIX_RTC_GPIO_F32KOB_SHIFT 13
#define PMIC_MIX_RTC_GPIO_GPO_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_RTC_GPIO_GPO_MASK 0x1
#define PMIC_MIX_RTC_GPIO_GPO_SHIFT 14
#define PMIC_MIX_RTC_GPIO_OE_ADDR MT6356_RTC_MIX_CON1
#define PMIC_MIX_RTC_GPIO_OE_MASK 0x1
#define PMIC_MIX_RTC_GPIO_OE_SHIFT 15
#define PMIC_MIX_RTC_STP_DEBUG_OUT_ADDR MT6356_RTC_MIX_CON2
#define PMIC_MIX_RTC_STP_DEBUG_OUT_MASK 0x3
#define PMIC_MIX_RTC_STP_DEBUG_OUT_SHIFT 0
#define PMIC_MIX_RTC_STP_DEBUG_SEL_ADDR MT6356_RTC_MIX_CON2
#define PMIC_MIX_RTC_STP_DEBUG_SEL_MASK 0x3
#define PMIC_MIX_RTC_STP_DEBUG_SEL_SHIFT 4
#define PMIC_MIX_RTC_STP_K_EOSC32_EN_ADDR MT6356_RTC_MIX_CON2
#define PMIC_MIX_RTC_STP_K_EOSC32_EN_MASK 0x1
#define PMIC_MIX_RTC_STP_K_EOSC32_EN_SHIFT 7
#define PMIC_MIX_RTC_STP_EMBCK_SEL_ADDR MT6356_RTC_MIX_CON2
#define PMIC_MIX_RTC_STP_EMBCK_SEL_MASK 0x1
#define PMIC_MIX_RTC_STP_EMBCK_SEL_SHIFT 8
#define PMIC_MIX_STP_BBWAKEUP_ADDR MT6356_RTC_MIX_CON2
#define PMIC_MIX_STP_BBWAKEUP_MASK 0x1
#define PMIC_MIX_STP_BBWAKEUP_SHIFT 9
#define PMIC_MIX_STP_RTC_DDLO_ADDR MT6356_RTC_MIX_CON2
#define PMIC_MIX_STP_RTC_DDLO_MASK 0x1
#define PMIC_MIX_STP_RTC_DDLO_SHIFT 10
#define PMIC_MIX_RTC_XOSC32_ENB_ADDR MT6356_RTC_MIX_CON2
#define PMIC_MIX_RTC_XOSC32_ENB_MASK 0x1
#define PMIC_MIX_RTC_XOSC32_ENB_SHIFT 11
#define PMIC_MIX_EFUSE_XOSC32_ENB_OPT_ADDR MT6356_RTC_MIX_CON2
#define PMIC_MIX_EFUSE_XOSC32_ENB_OPT_MASK 0x1
#define PMIC_MIX_EFUSE_XOSC32_ENB_OPT_SHIFT 12
#define PMIC_RTC_SEC_ANA_ID_ADDR MT6356_RTC_SEC_DSN_ID
#define PMIC_RTC_SEC_ANA_ID_MASK 0xFF
#define PMIC_RTC_SEC_ANA_ID_SHIFT 0
#define PMIC_RTC_SEC_DIG_ID_ADDR MT6356_RTC_SEC_DSN_ID
#define PMIC_RTC_SEC_DIG_ID_MASK 0xFF
#define PMIC_RTC_SEC_DIG_ID_SHIFT 8
#define PMIC_RTC_SEC_ANA_MINOR_REV_ADDR MT6356_RTC_SEC_DSN_REV0
#define PMIC_RTC_SEC_ANA_MINOR_REV_MASK 0xF
#define PMIC_RTC_SEC_ANA_MINOR_REV_SHIFT 0
#define PMIC_RTC_SEC_ANA_MAJOR_REV_ADDR MT6356_RTC_SEC_DSN_REV0
#define PMIC_RTC_SEC_ANA_MAJOR_REV_MASK 0xF
#define PMIC_RTC_SEC_ANA_MAJOR_REV_SHIFT 4
#define PMIC_RTC_SEC_DIG_MINOR_REV_ADDR MT6356_RTC_SEC_DSN_REV0
#define PMIC_RTC_SEC_DIG_MINOR_REV_MASK 0xF
#define PMIC_RTC_SEC_DIG_MINOR_REV_SHIFT 8
#define PMIC_RTC_SEC_DIG_MAJOR_REV_ADDR MT6356_RTC_SEC_DSN_REV0
#define PMIC_RTC_SEC_DIG_MAJOR_REV_MASK 0xF
#define PMIC_RTC_SEC_DIG_MAJOR_REV_SHIFT 12
#define PMIC_RTC_SEC_SW_MINOR_REV_ADDR MT6356_RTC_SEC_DSN_REV1
#define PMIC_RTC_SEC_SW_MINOR_REV_MASK 0xF
#define PMIC_RTC_SEC_SW_MINOR_REV_SHIFT 0
#define PMIC_RTC_SEC_SW_MAJOR_REV_ADDR MT6356_RTC_SEC_DSN_REV1
#define PMIC_RTC_SEC_SW_MAJOR_REV_MASK 0xF
#define PMIC_RTC_SEC_SW_MAJOR_REV_SHIFT 4
#define PMIC_RTC_SEC_ESP_ADDR MT6356_RTC_SEC_DSN_REV1
#define PMIC_RTC_SEC_ESP_MASK 0xFF
#define PMIC_RTC_SEC_ESP_SHIFT 8
#define PMIC_RTC_SEC_DUMMY_ADDR MT6356_RTC_SEC_DUMMY_CON0
#define PMIC_RTC_SEC_DUMMY_MASK 0xFFFF
#define PMIC_RTC_SEC_DUMMY_SHIFT 0
#define PMIC_TC_SECOND_SEC_ADDR MT6356_RTC_TC_SEC_SEC
#define PMIC_TC_SECOND_SEC_MASK 0x3F
#define PMIC_TC_SECOND_SEC_SHIFT 0
#define PMIC_TC_MINUTE_SEC_ADDR MT6356_RTC_TC_MIN_SEC
#define PMIC_TC_MINUTE_SEC_MASK 0x3F
#define PMIC_TC_MINUTE_SEC_SHIFT 0
#define PMIC_TC_HOUR_SEC_ADDR MT6356_RTC_TC_HOU_SEC
#define PMIC_TC_HOUR_SEC_MASK 0x1F
#define PMIC_TC_HOUR_SEC_SHIFT 0
#define PMIC_TC_DOM_SEC_ADDR MT6356_RTC_TC_DOM_SEC
#define PMIC_TC_DOM_SEC_MASK 0x1F
#define PMIC_TC_DOM_SEC_SHIFT 0
#define PMIC_TC_DOW_SEC_ADDR MT6356_RTC_TC_DOW_SEC
#define PMIC_TC_DOW_SEC_MASK 0x7
#define PMIC_TC_DOW_SEC_SHIFT 0
#define PMIC_TC_MONTH_SEC_ADDR MT6356_RTC_TC_MTH_SEC
#define PMIC_TC_MONTH_SEC_MASK 0xF
#define PMIC_TC_MONTH_SEC_SHIFT 0
#define PMIC_TC_YEAR_SEC_ADDR MT6356_RTC_TC_YEA_SEC
#define PMIC_TC_YEAR_SEC_MASK 0x7F
#define PMIC_TC_YEAR_SEC_SHIFT 0
#define PMIC_RTC_SEC_CK_PDN_ADDR MT6356_RTC_SEC_CK_PDN
#define PMIC_RTC_SEC_CK_PDN_MASK 0x1
#define PMIC_RTC_SEC_CK_PDN_SHIFT 0
#define PMIC_RTC_SEC_WRTGR_ADDR MT6356_RTC_SEC_WRTGR
#define PMIC_RTC_SEC_WRTGR_MASK 0x1
#define PMIC_RTC_SEC_WRTGR_SHIFT 0
#define PMIC_BUCK_TOP_ANA_ID_ADDR MT6356_BUCK_TOP_DSN_ID
#define PMIC_BUCK_TOP_ANA_ID_MASK 0xFF
#define PMIC_BUCK_TOP_ANA_ID_SHIFT 0
#define PMIC_BUCK_TOP_DIG_ID_ADDR MT6356_BUCK_TOP_DSN_ID
#define PMIC_BUCK_TOP_DIG_ID_MASK 0xFF
#define PMIC_BUCK_TOP_DIG_ID_SHIFT 8
#define PMIC_BUCK_TOP_ANA_MINOR_REV_ADDR MT6356_BUCK_TOP_DSN_REV0
#define PMIC_BUCK_TOP_ANA_MINOR_REV_MASK 0xF
#define PMIC_BUCK_TOP_ANA_MINOR_REV_SHIFT 0
#define PMIC_BUCK_TOP_ANA_MAJOR_REV_ADDR MT6356_BUCK_TOP_DSN_REV0
#define PMIC_BUCK_TOP_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_TOP_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_TOP_DIG_MINOR_REV_ADDR MT6356_BUCK_TOP_DSN_REV0
#define PMIC_BUCK_TOP_DIG_MINOR_REV_MASK 0xF
#define PMIC_BUCK_TOP_DIG_MINOR_REV_SHIFT 8
#define PMIC_BUCK_TOP_DIG_MAJOR_REV_ADDR MT6356_BUCK_TOP_DSN_REV0
#define PMIC_BUCK_TOP_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_TOP_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BUCK_TOP_SW_MINOR_REV_ADDR MT6356_BUCK_TOP_DSN_REV1
#define PMIC_BUCK_TOP_SW_MINOR_REV_MASK 0xF
#define PMIC_BUCK_TOP_SW_MINOR_REV_SHIFT 0
#define PMIC_BUCK_TOP_SW_MAJOR_REV_ADDR MT6356_BUCK_TOP_DSN_REV1
#define PMIC_BUCK_TOP_SW_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_TOP_SW_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_TOP_ESP_ADDR MT6356_BUCK_TOP_DSN_REV1
#define PMIC_BUCK_TOP_ESP_MASK 0xFF
#define PMIC_BUCK_TOP_ESP_SHIFT 8
#define PMIC_BUCK_TOP_CLK_OFFSET_ADDR MT6356_BUCK_TOP_PAM0
#define PMIC_BUCK_TOP_CLK_OFFSET_MASK 0xFF
#define PMIC_BUCK_TOP_CLK_OFFSET_SHIFT 0
#define PMIC_BUCK_TOP_RST_OFFSET_ADDR MT6356_BUCK_TOP_PAM0
#define PMIC_BUCK_TOP_RST_OFFSET_MASK 0xFF
#define PMIC_BUCK_TOP_RST_OFFSET_SHIFT 8
#define PMIC_BUCK_TOP_INT_OFFSET_ADDR MT6356_BUCK_TOP_PAM1
#define PMIC_BUCK_TOP_INT_OFFSET_MASK 0xFF
#define PMIC_BUCK_TOP_INT_OFFSET_SHIFT 0
#define PMIC_BUCK_TOP_INT_LEN_ADDR MT6356_BUCK_TOP_PAM1
#define PMIC_BUCK_TOP_INT_LEN_MASK 0xFF
#define PMIC_BUCK_TOP_INT_LEN_SHIFT 8
#define PMIC_RG_BUCK32K_CK_PDN_ADDR MT6356_BUCK_TOP_CLK_CON0
#define PMIC_RG_BUCK32K_CK_PDN_MASK 0x1
#define PMIC_RG_BUCK32K_CK_PDN_SHIFT 0
#define PMIC_RG_BUCK1M_CK_PDN_ADDR MT6356_BUCK_TOP_CLK_CON0
#define PMIC_RG_BUCK1M_CK_PDN_MASK 0x1
#define PMIC_RG_BUCK1M_CK_PDN_SHIFT 1
#define PMIC_RG_BUCK26M_CK_PDN_ADDR MT6356_BUCK_TOP_CLK_CON0
#define PMIC_RG_BUCK26M_CK_PDN_MASK 0x1
#define PMIC_RG_BUCK26M_CK_PDN_SHIFT 2
#define PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_ADDR MT6356_BUCK_TOP_CLK_CON0
#define PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_MASK 0x1
#define PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_SHIFT 3
#define PMIC_RG_BUCK_ANA_CK_PDN_ADDR MT6356_BUCK_TOP_CLK_CON0
#define PMIC_RG_BUCK_ANA_CK_PDN_MASK 0x1
#define PMIC_RG_BUCK_ANA_CK_PDN_SHIFT 4
#define PMIC_BUCK_TOP_CLK_CON0_RSV_ADDR MT6356_BUCK_TOP_CLK_CON0
#define PMIC_BUCK_TOP_CLK_CON0_RSV_MASK 0x7FF
#define PMIC_BUCK_TOP_CLK_CON0_RSV_SHIFT 5
#define PMIC_RG_BUCK_TOP_CLK_CON0_SET_ADDR MT6356_BUCK_TOP_CLK_CON0_SET
#define PMIC_RG_BUCK_TOP_CLK_CON0_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_CLK_CON0_SET_SHIFT 0
#define PMIC_RG_BUCK_TOP_CLK_CON0_CLR_ADDR MT6356_BUCK_TOP_CLK_CON0_CLR
#define PMIC_RG_BUCK_TOP_CLK_CON0_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_CLK_CON0_CLR_SHIFT 0
#define PMIC_RG_BUCK32K_CK_PDN_HWEN_ADDR MT6356_BUCK_TOP_CLK_HWEN_CON0
#define PMIC_RG_BUCK32K_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_BUCK32K_CK_PDN_HWEN_SHIFT 0
#define PMIC_RG_BUCK1M_CK_PDN_HWEN_ADDR MT6356_BUCK_TOP_CLK_HWEN_CON0
#define PMIC_RG_BUCK1M_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_BUCK1M_CK_PDN_HWEN_SHIFT 1
#define PMIC_RG_BUCK26M_CK_PDN_HWEN_ADDR MT6356_BUCK_TOP_CLK_HWEN_CON0
#define PMIC_RG_BUCK26M_CK_PDN_HWEN_MASK 0x1
#define PMIC_RG_BUCK26M_CK_PDN_HWEN_SHIFT 2
#define PMIC_RG_BUCK_DCM_MODE_ADDR MT6356_BUCK_TOP_CLK_HWEN_CON0
#define PMIC_RG_BUCK_DCM_MODE_MASK 0x1
#define PMIC_RG_BUCK_DCM_MODE_SHIFT 3
#define PMIC_BUCK_TOP_CLK_HWEN_CON0_RSV_ADDR MT6356_BUCK_TOP_CLK_HWEN_CON0
#define PMIC_BUCK_TOP_CLK_HWEN_CON0_RSV_MASK 0xFFF
#define PMIC_BUCK_TOP_CLK_HWEN_CON0_RSV_SHIFT 4
#define PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET_ADDR                               \
	MT6356_BUCK_TOP_CLK_HWEN_CON0_SET
#define PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET_SHIFT 0
#define PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR_ADDR                               \
	MT6356_BUCK_TOP_CLK_HWEN_CON0_CLR
#define PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR_SHIFT 0
#define PMIC_RG_BUCK_VPROC_FREQ_SEL_ADDR MT6356_BUCK_TOP_CLK_MISC_CON0
#define PMIC_RG_BUCK_VPROC_FREQ_SEL_MASK 0x3
#define PMIC_RG_BUCK_VPROC_FREQ_SEL_SHIFT 0
#define PMIC_RG_BUCK_VCORE_FREQ_SEL_ADDR MT6356_BUCK_TOP_CLK_MISC_CON0
#define PMIC_RG_BUCK_VCORE_FREQ_SEL_MASK 0x3
#define PMIC_RG_BUCK_VCORE_FREQ_SEL_SHIFT 2
#define PMIC_RG_BUCK_VMODEM_FREQ_SEL_ADDR MT6356_BUCK_TOP_CLK_MISC_CON0
#define PMIC_RG_BUCK_VMODEM_FREQ_SEL_MASK 0x3
#define PMIC_RG_BUCK_VMODEM_FREQ_SEL_SHIFT 4
#define PMIC_RG_BUCK_VS1_FREQ_SEL_ADDR MT6356_BUCK_TOP_CLK_MISC_CON0
#define PMIC_RG_BUCK_VS1_FREQ_SEL_MASK 0x3
#define PMIC_RG_BUCK_VS1_FREQ_SEL_SHIFT 6
#define PMIC_RG_BUCK_VS2_FREQ_SEL_ADDR MT6356_BUCK_TOP_CLK_MISC_CON0
#define PMIC_RG_BUCK_VS2_FREQ_SEL_MASK 0x3
#define PMIC_RG_BUCK_VS2_FREQ_SEL_SHIFT 8
#define PMIC_RG_BUCK_VPA_FREQ_SEL_ADDR MT6356_BUCK_TOP_CLK_MISC_CON0
#define PMIC_RG_BUCK_VPA_FREQ_SEL_MASK 0x3
#define PMIC_RG_BUCK_VPA_FREQ_SEL_SHIFT 10
#define PMIC_RG_RST_CON0_RSV_ADDR MT6356_BUCK_TOP_RST_CON0
#define PMIC_RG_RST_CON0_RSV_MASK 0xFFFF
#define PMIC_RG_RST_CON0_RSV_SHIFT 0
#define PMIC_RG_BUCK_TOP_RST_CON0_SET_ADDR MT6356_BUCK_TOP_RST_CON0_SET
#define PMIC_RG_BUCK_TOP_RST_CON0_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_RST_CON0_SET_SHIFT 0
#define PMIC_RG_BUCK_TOP_RST_CON0_CLR_ADDR MT6356_BUCK_TOP_RST_CON0_CLR
#define PMIC_RG_BUCK_TOP_RST_CON0_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_RST_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_EN_VPROC_OC_ADDR MT6356_BUCK_TOP_INT_CON0
#define PMIC_RG_INT_EN_VPROC_OC_MASK 0x1
#define PMIC_RG_INT_EN_VPROC_OC_SHIFT 0
#define PMIC_RG_INT_EN_VCORE_OC_ADDR MT6356_BUCK_TOP_INT_CON0
#define PMIC_RG_INT_EN_VCORE_OC_MASK 0x1
#define PMIC_RG_INT_EN_VCORE_OC_SHIFT 1
#define PMIC_RG_INT_EN_VMODEM_OC_ADDR MT6356_BUCK_TOP_INT_CON0
#define PMIC_RG_INT_EN_VMODEM_OC_MASK 0x1
#define PMIC_RG_INT_EN_VMODEM_OC_SHIFT 2
#define PMIC_RG_INT_EN_VS1_OC_ADDR MT6356_BUCK_TOP_INT_CON0
#define PMIC_RG_INT_EN_VS1_OC_MASK 0x1
#define PMIC_RG_INT_EN_VS1_OC_SHIFT 3
#define PMIC_RG_INT_EN_VS2_OC_ADDR MT6356_BUCK_TOP_INT_CON0
#define PMIC_RG_INT_EN_VS2_OC_MASK 0x1
#define PMIC_RG_INT_EN_VS2_OC_SHIFT 4
#define PMIC_RG_INT_EN_VPA_OC_ADDR MT6356_BUCK_TOP_INT_CON0
#define PMIC_RG_INT_EN_VPA_OC_MASK 0x1
#define PMIC_RG_INT_EN_VPA_OC_SHIFT 5
#define PMIC_RG_INT_EN_VCORE_PREOC_ADDR MT6356_BUCK_TOP_INT_CON0
#define PMIC_RG_INT_EN_VCORE_PREOC_MASK 0x1
#define PMIC_RG_INT_EN_VCORE_PREOC_SHIFT 6
#define PMIC_RG_BUCK_TOP_INT_CON0_SET_ADDR MT6356_BUCK_TOP_INT_CON0_SET
#define PMIC_RG_BUCK_TOP_INT_CON0_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_INT_CON0_SET_SHIFT 0
#define PMIC_RG_BUCK_TOP_INT_CON0_CLR_ADDR MT6356_BUCK_TOP_INT_CON0_CLR
#define PMIC_RG_BUCK_TOP_INT_CON0_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_INT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_VPROC_OC_ADDR MT6356_BUCK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VPROC_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VPROC_OC_SHIFT 0
#define PMIC_RG_INT_MASK_VCORE_OC_ADDR MT6356_BUCK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VCORE_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VCORE_OC_SHIFT 1
#define PMIC_RG_INT_MASK_VMODEM_OC_ADDR MT6356_BUCK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VMODEM_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VMODEM_OC_SHIFT 2
#define PMIC_RG_INT_MASK_VS1_OC_ADDR MT6356_BUCK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VS1_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VS1_OC_SHIFT 3
#define PMIC_RG_INT_MASK_VS2_OC_ADDR MT6356_BUCK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VS2_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VS2_OC_SHIFT 4
#define PMIC_RG_INT_MASK_VPA_OC_ADDR MT6356_BUCK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VPA_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VPA_OC_SHIFT 5
#define PMIC_RG_INT_MASK_VCORE_PREOC_ADDR MT6356_BUCK_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VCORE_PREOC_MASK 0x1
#define PMIC_RG_INT_MASK_VCORE_PREOC_SHIFT 6
#define PMIC_RG_BUCK_TOP_INT_MASK_CON0_SET_ADDR                               \
	MT6356_BUCK_TOP_INT_MASK_CON0_SET
#define PMIC_RG_BUCK_TOP_INT_MASK_CON0_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_RG_BUCK_TOP_INT_MASK_CON0_CLR_ADDR                               \
	MT6356_BUCK_TOP_INT_MASK_CON0_CLR
#define PMIC_RG_BUCK_TOP_INT_MASK_CON0_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_TOP_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_STATUS_VPROC_OC_ADDR MT6356_BUCK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VPROC_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VPROC_OC_SHIFT 0
#define PMIC_RG_INT_STATUS_VCORE_OC_ADDR MT6356_BUCK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VCORE_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VCORE_OC_SHIFT 1
#define PMIC_RG_INT_STATUS_VMODEM_OC_ADDR MT6356_BUCK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VMODEM_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VMODEM_OC_SHIFT 2
#define PMIC_RG_INT_STATUS_VS1_OC_ADDR MT6356_BUCK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VS1_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VS1_OC_SHIFT 3
#define PMIC_RG_INT_STATUS_VS2_OC_ADDR MT6356_BUCK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VS2_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VS2_OC_SHIFT 4
#define PMIC_RG_INT_STATUS_VPA_OC_ADDR MT6356_BUCK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VPA_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VPA_OC_SHIFT 5
#define PMIC_RG_INT_STATUS_VCORE_PREOC_ADDR MT6356_BUCK_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VCORE_PREOC_MASK 0x1
#define PMIC_RG_INT_STATUS_VCORE_PREOC_SHIFT 6
#define PMIC_RG_INT_RAW_STATUS_VPROC_OC_ADDR MT6356_BUCK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VPROC_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VPROC_OC_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_VCORE_OC_ADDR MT6356_BUCK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VCORE_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VCORE_OC_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_VMODEM_OC_ADDR MT6356_BUCK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VMODEM_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VMODEM_OC_SHIFT 2
#define PMIC_RG_INT_RAW_STATUS_VS1_OC_ADDR MT6356_BUCK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VS1_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VS1_OC_SHIFT 3
#define PMIC_RG_INT_RAW_STATUS_VS2_OC_ADDR MT6356_BUCK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VS2_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VS2_OC_SHIFT 4
#define PMIC_RG_INT_RAW_STATUS_VPA_OC_ADDR MT6356_BUCK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VPA_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VPA_OC_SHIFT 5
#define PMIC_RG_INT_RAW_STATUS_VCORE_PREOC_ADDR MT6356_BUCK_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VCORE_PREOC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VCORE_PREOC_SHIFT 6
#define PMIC_RG_BUCK_ALL_CON0_RSV_ADDR MT6356_BUCK_TOP_ALL_CON0
#define PMIC_RG_BUCK_ALL_CON0_RSV_MASK 0xFFFF
#define PMIC_RG_BUCK_ALL_CON0_RSV_SHIFT 0
#define PMIC_RG_BUCK_STB_MAX_ADDR MT6356_BUCK_TOP_STB_CON
#define PMIC_RG_BUCK_STB_MAX_MASK 0x1FF
#define PMIC_RG_BUCK_STB_MAX_SHIFT 0
#define PMIC_RG_BUCK_LP_PROT_DISABLE_ADDR MT6356_BUCK_TOP_STB_CON
#define PMIC_RG_BUCK_LP_PROT_DISABLE_MASK 0x1
#define PMIC_RG_BUCK_LP_PROT_DISABLE_SHIFT 9
#define PMIC_RG_BUCK_VSLEEP_SRC0_ADDR MT6356_BUCK_TOP_SLP_CON0
#define PMIC_RG_BUCK_VSLEEP_SRC0_MASK 0x1FF
#define PMIC_RG_BUCK_VSLEEP_SRC0_SHIFT 0
#define PMIC_RG_BUCK_VSLEEP_SRC1_ADDR MT6356_BUCK_TOP_SLP_CON0
#define PMIC_RG_BUCK_VSLEEP_SRC1_MASK 0xF
#define PMIC_RG_BUCK_VSLEEP_SRC1_SHIFT 12
#define PMIC_RG_BUCK_R2R_SRC0_ADDR MT6356_BUCK_TOP_SLP_CON1
#define PMIC_RG_BUCK_R2R_SRC0_MASK 0x1FF
#define PMIC_RG_BUCK_R2R_SRC0_SHIFT 0
#define PMIC_RG_BUCK_R2R_SRC1_ADDR MT6356_BUCK_TOP_SLP_CON1
#define PMIC_RG_BUCK_R2R_SRC1_MASK 0xF
#define PMIC_RG_BUCK_R2R_SRC1_SHIFT 12
#define PMIC_RG_BUCK_LP_SEQ_COUNT_ADDR MT6356_BUCK_TOP_SLP_CON2
#define PMIC_RG_BUCK_LP_SEQ_COUNT_MASK 0x1FF
#define PMIC_RG_BUCK_LP_SEQ_COUNT_SHIFT 0
#define PMIC_RG_BUCK_ON_SEQ_COUNT_ADDR MT6356_BUCK_TOP_SLP_CON2
#define PMIC_RG_BUCK_ON_SEQ_COUNT_MASK 0xF
#define PMIC_RG_BUCK_ON_SEQ_COUNT_SHIFT 12
#define PMIC_RG_BUCK_MINFREQ_LATENCY_MAX_ADDR MT6356_BUCK_TOP_MINFREQ_CON
#define PMIC_RG_BUCK_MINFREQ_LATENCY_MAX_MASK 0xFF
#define PMIC_RG_BUCK_MINFREQ_LATENCY_MAX_SHIFT 0
#define PMIC_RG_BUCK_MINFREQ_DURATION_MAX_ADDR MT6356_BUCK_TOP_MINFREQ_CON
#define PMIC_RG_BUCK_MINFREQ_DURATION_MAX_MASK 0x7
#define PMIC_RG_BUCK_MINFREQ_DURATION_MAX_SHIFT 8
#define PMIC_RG_BUCK_VPROC_OC_SDN_STATUS_ADDR MT6356_BUCK_TOP_OC_CON0
#define PMIC_RG_BUCK_VPROC_OC_SDN_STATUS_MASK 0x1
#define PMIC_RG_BUCK_VPROC_OC_SDN_STATUS_SHIFT 0
#define PMIC_RG_BUCK_VCORE_OC_SDN_STATUS_ADDR MT6356_BUCK_TOP_OC_CON0
#define PMIC_RG_BUCK_VCORE_OC_SDN_STATUS_MASK 0x1
#define PMIC_RG_BUCK_VCORE_OC_SDN_STATUS_SHIFT 1
#define PMIC_RG_BUCK_VMODEM_OC_SDN_STATUS_ADDR MT6356_BUCK_TOP_OC_CON0
#define PMIC_RG_BUCK_VMODEM_OC_SDN_STATUS_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_OC_SDN_STATUS_SHIFT 2
#define PMIC_RG_BUCK_VS1_OC_SDN_STATUS_ADDR MT6356_BUCK_TOP_OC_CON0
#define PMIC_RG_BUCK_VS1_OC_SDN_STATUS_MASK 0x1
#define PMIC_RG_BUCK_VS1_OC_SDN_STATUS_SHIFT 3
#define PMIC_RG_BUCK_VS2_OC_SDN_STATUS_ADDR MT6356_BUCK_TOP_OC_CON0
#define PMIC_RG_BUCK_VS2_OC_SDN_STATUS_MASK 0x1
#define PMIC_RG_BUCK_VS2_OC_SDN_STATUS_SHIFT 4
#define PMIC_RG_BUCK_VPA_OC_SDN_STATUS_ADDR MT6356_BUCK_TOP_OC_CON0
#define PMIC_RG_BUCK_VPA_OC_SDN_STATUS_MASK 0x1
#define PMIC_RG_BUCK_VPA_OC_SDN_STATUS_SHIFT 5
#define PMIC_RG_BUCK_K_RST_DONE_ADDR MT6356_BUCK_TOP_K_CON0
#define PMIC_RG_BUCK_K_RST_DONE_MASK 0x1
#define PMIC_RG_BUCK_K_RST_DONE_SHIFT 0
#define PMIC_RG_BUCK_K_MAP_SEL_ADDR MT6356_BUCK_TOP_K_CON0
#define PMIC_RG_BUCK_K_MAP_SEL_MASK 0x1
#define PMIC_RG_BUCK_K_MAP_SEL_SHIFT 1
#define PMIC_RG_BUCK_K_ONCE_EN_ADDR MT6356_BUCK_TOP_K_CON0
#define PMIC_RG_BUCK_K_ONCE_EN_MASK 0x1
#define PMIC_RG_BUCK_K_ONCE_EN_SHIFT 2
#define PMIC_RG_BUCK_K_ONCE_ADDR MT6356_BUCK_TOP_K_CON0
#define PMIC_RG_BUCK_K_ONCE_MASK 0x1
#define PMIC_RG_BUCK_K_ONCE_SHIFT 3
#define PMIC_RG_BUCK_K_START_MANUAL_ADDR MT6356_BUCK_TOP_K_CON0
#define PMIC_RG_BUCK_K_START_MANUAL_MASK 0x1
#define PMIC_RG_BUCK_K_START_MANUAL_SHIFT 4
#define PMIC_RG_BUCK_K_SRC_SEL_ADDR MT6356_BUCK_TOP_K_CON0
#define PMIC_RG_BUCK_K_SRC_SEL_MASK 0x1
#define PMIC_RG_BUCK_K_SRC_SEL_SHIFT 5
#define PMIC_RG_BUCK_K_AUTO_EN_ADDR MT6356_BUCK_TOP_K_CON0
#define PMIC_RG_BUCK_K_AUTO_EN_MASK 0x1
#define PMIC_RG_BUCK_K_AUTO_EN_SHIFT 6
#define PMIC_RG_BUCK_K_INV_ADDR MT6356_BUCK_TOP_K_CON0
#define PMIC_RG_BUCK_K_INV_MASK 0x1
#define PMIC_RG_BUCK_K_INV_SHIFT 7
#define PMIC_RG_BUCK_K_CK_EN_ADDR MT6356_BUCK_TOP_K_CON0
#define PMIC_RG_BUCK_K_CK_EN_MASK 0x1
#define PMIC_RG_BUCK_K_CK_EN_SHIFT 8
#define PMIC_BUCK_K_RESULT_ADDR MT6356_BUCK_TOP_K_CON1
#define PMIC_BUCK_K_RESULT_MASK 0x1
#define PMIC_BUCK_K_RESULT_SHIFT 0
#define PMIC_BUCK_K_DONE_ADDR MT6356_BUCK_TOP_K_CON1
#define PMIC_BUCK_K_DONE_MASK 0x1
#define PMIC_BUCK_K_DONE_SHIFT 1
#define PMIC_BUCK_K_CONTROL_ADDR MT6356_BUCK_TOP_K_CON1
#define PMIC_BUCK_K_CONTROL_MASK 0x3F
#define PMIC_BUCK_K_CONTROL_SHIFT 2
#define PMIC_DA_SMPS_OSC_CAL_ADDR MT6356_BUCK_TOP_K_CON1
#define PMIC_DA_SMPS_OSC_CAL_MASK 0x3F
#define PMIC_DA_SMPS_OSC_CAL_SHIFT 8
#define PMIC_RG_BUCK_K_BUCK_CK_CNT_ADDR MT6356_BUCK_TOP_K_CON2
#define PMIC_RG_BUCK_K_BUCK_CK_CNT_MASK 0x3FF
#define PMIC_RG_BUCK_K_BUCK_CK_CNT_SHIFT 0
#define PMIC_BUCK_VPROC_WDTDBG_VOSEL_ADDR MT6356_BUCK_TOP_WDTDBG0
#define PMIC_BUCK_VPROC_WDTDBG_VOSEL_MASK 0x7F
#define PMIC_BUCK_VPROC_WDTDBG_VOSEL_SHIFT 0
#define PMIC_BUCK_VCORE_WDTDBG_VOSEL_ADDR MT6356_BUCK_TOP_WDTDBG0
#define PMIC_BUCK_VCORE_WDTDBG_VOSEL_MASK 0x7F
#define PMIC_BUCK_VCORE_WDTDBG_VOSEL_SHIFT 8
#define PMIC_BUCK_VMODEM_WDTDBG_VOSEL_ADDR MT6356_BUCK_TOP_WDTDBG1
#define PMIC_BUCK_VMODEM_WDTDBG_VOSEL_MASK 0x7F
#define PMIC_BUCK_VMODEM_WDTDBG_VOSEL_SHIFT 0
#define PMIC_BUCK_VS1_WDTDBG_VOSEL_ADDR MT6356_BUCK_TOP_WDTDBG1
#define PMIC_BUCK_VS1_WDTDBG_VOSEL_MASK 0x7F
#define PMIC_BUCK_VS1_WDTDBG_VOSEL_SHIFT 8
#define PMIC_BUCK_VS2_WDTDBG_VOSEL_ADDR MT6356_BUCK_TOP_WDTDBG2
#define PMIC_BUCK_VS2_WDTDBG_VOSEL_MASK 0x7F
#define PMIC_BUCK_VS2_WDTDBG_VOSEL_SHIFT 0
#define PMIC_BUCK_VPA_WDTDBG_VOSEL_ADDR MT6356_BUCK_TOP_WDTDBG2
#define PMIC_BUCK_VPA_WDTDBG_VOSEL_MASK 0x3F
#define PMIC_BUCK_VPA_WDTDBG_VOSEL_SHIFT 8
#define PMIC_BUCK_TOP_ELR_LEN_ADDR MT6356_BUCK_TOP_ELR_NUM
#define PMIC_BUCK_TOP_ELR_LEN_MASK 0xFF
#define PMIC_BUCK_TOP_ELR_LEN_SHIFT 0
#define PMIC_RG_BUCK_VPROC_OC_SDN_EN_ADDR MT6356_BUCK_TOP_ELR0
#define PMIC_RG_BUCK_VPROC_OC_SDN_EN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_OC_SDN_EN_SHIFT 0
#define PMIC_RG_BUCK_VCORE_OC_SDN_EN_ADDR MT6356_BUCK_TOP_ELR0
#define PMIC_RG_BUCK_VCORE_OC_SDN_EN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_OC_SDN_EN_SHIFT 1
#define PMIC_RG_BUCK_VMODEM_OC_SDN_EN_ADDR MT6356_BUCK_TOP_ELR0
#define PMIC_RG_BUCK_VMODEM_OC_SDN_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_OC_SDN_EN_SHIFT 2
#define PMIC_RG_BUCK_VS1_OC_SDN_EN_ADDR MT6356_BUCK_TOP_ELR0
#define PMIC_RG_BUCK_VS1_OC_SDN_EN_MASK 0x1
#define PMIC_RG_BUCK_VS1_OC_SDN_EN_SHIFT 3
#define PMIC_RG_BUCK_VS2_OC_SDN_EN_ADDR MT6356_BUCK_TOP_ELR0
#define PMIC_RG_BUCK_VS2_OC_SDN_EN_MASK 0x1
#define PMIC_RG_BUCK_VS2_OC_SDN_EN_SHIFT 4
#define PMIC_RG_BUCK_VPA_OC_SDN_EN_ADDR MT6356_BUCK_TOP_ELR0
#define PMIC_RG_BUCK_VPA_OC_SDN_EN_MASK 0x1
#define PMIC_RG_BUCK_VPA_OC_SDN_EN_SHIFT 5
#define PMIC_RG_BUCK_OC_SDN_EN_SEL_ADDR MT6356_BUCK_TOP_ELR0
#define PMIC_RG_BUCK_OC_SDN_EN_SEL_MASK 0x1
#define PMIC_RG_BUCK_OC_SDN_EN_SEL_SHIFT 6
#define PMIC_RG_BUCK_K_CONTROL_SMPS_ADDR MT6356_BUCK_TOP_ELR0
#define PMIC_RG_BUCK_K_CONTROL_SMPS_MASK 0x3F
#define PMIC_RG_BUCK_K_CONTROL_SMPS_SHIFT 7
#define PMIC_RG_BUCK_VPROC_VOSEL_LIMIT_SEL_ADDR MT6356_BUCK_TOP_ELR1
#define PMIC_RG_BUCK_VPROC_VOSEL_LIMIT_SEL_MASK 0x3
#define PMIC_RG_BUCK_VPROC_VOSEL_LIMIT_SEL_SHIFT 0
#define PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL_ADDR MT6356_BUCK_TOP_ELR1
#define PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL_MASK 0x3
#define PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL_SHIFT 2
#define PMIC_RG_BUCK_VMODEM_VOSEL_LIMIT_SEL_ADDR MT6356_BUCK_TOP_ELR1
#define PMIC_RG_BUCK_VMODEM_VOSEL_LIMIT_SEL_MASK 0x3
#define PMIC_RG_BUCK_VMODEM_VOSEL_LIMIT_SEL_SHIFT 4
#define PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL_ADDR MT6356_BUCK_TOP_ELR1
#define PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL_MASK 0x3
#define PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL_SHIFT 6
#define PMIC_RG_BUCK_VS2_VOSEL_LIMIT_SEL_ADDR MT6356_BUCK_TOP_ELR1
#define PMIC_RG_BUCK_VS2_VOSEL_LIMIT_SEL_MASK 0x3
#define PMIC_RG_BUCK_VS2_VOSEL_LIMIT_SEL_SHIFT 8
#define PMIC_RG_BUCK_VPA_VOSEL_LIMIT_SEL_ADDR MT6356_BUCK_TOP_ELR1
#define PMIC_RG_BUCK_VPA_VOSEL_LIMIT_SEL_MASK 0x3
#define PMIC_RG_BUCK_VPA_VOSEL_LIMIT_SEL_SHIFT 10
#define PMIC_BUCK_VPROC_ANA_ID_ADDR MT6356_BUCK_VPROC_DSN_ID
#define PMIC_BUCK_VPROC_ANA_ID_MASK 0xFF
#define PMIC_BUCK_VPROC_ANA_ID_SHIFT 0
#define PMIC_BUCK_VPROC_DIG_ID_ADDR MT6356_BUCK_VPROC_DSN_ID
#define PMIC_BUCK_VPROC_DIG_ID_MASK 0xFF
#define PMIC_BUCK_VPROC_DIG_ID_SHIFT 8
#define PMIC_BUCK_VPROC_ANA_MINOR_REV_ADDR MT6356_BUCK_VPROC_DSN_REV0
#define PMIC_BUCK_VPROC_ANA_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VPROC_ANA_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VPROC_ANA_MAJOR_REV_ADDR MT6356_BUCK_VPROC_DSN_REV0
#define PMIC_BUCK_VPROC_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VPROC_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VPROC_DIG_MINOR_REV_ADDR MT6356_BUCK_VPROC_DSN_REV0
#define PMIC_BUCK_VPROC_DIG_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VPROC_DIG_MINOR_REV_SHIFT 8
#define PMIC_BUCK_VPROC_DIG_MAJOR_REV_ADDR MT6356_BUCK_VPROC_DSN_REV0
#define PMIC_BUCK_VPROC_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VPROC_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BUCK_VPROC_SW_MINOR_REV_ADDR MT6356_BUCK_VPROC_DSN_REV1
#define PMIC_BUCK_VPROC_SW_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VPROC_SW_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VPROC_SW_MAJOR_REV_ADDR MT6356_BUCK_VPROC_DSN_REV1
#define PMIC_BUCK_VPROC_SW_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VPROC_SW_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VPROC_ESP_ADDR MT6356_BUCK_VPROC_DSN_REV1
#define PMIC_BUCK_VPROC_ESP_MASK 0xFF
#define PMIC_BUCK_VPROC_ESP_SHIFT 8
#define PMIC_RG_BUCK_VPROC_EN_ADDR MT6356_BUCK_VPROC_CON0
#define PMIC_RG_BUCK_VPROC_EN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_EN_SHIFT 0
#define PMIC_RG_BUCK_VPROC_LP_ADDR MT6356_BUCK_VPROC_CON0
#define PMIC_RG_BUCK_VPROC_LP_MASK 0x1
#define PMIC_RG_BUCK_VPROC_LP_SHIFT 1
#define PMIC_RG_BUCK_VPROC_VOSEL_SLEEP_ADDR MT6356_BUCK_VPROC_CON1
#define PMIC_RG_BUCK_VPROC_VOSEL_SLEEP_MASK 0x7F
#define PMIC_RG_BUCK_VPROC_VOSEL_SLEEP_SHIFT 0
#define PMIC_RG_BUCK_VPROC_SFCHG_FRATE_ADDR MT6356_BUCK_VPROC_CFG0
#define PMIC_RG_BUCK_VPROC_SFCHG_FRATE_MASK 0x7F
#define PMIC_RG_BUCK_VPROC_SFCHG_FRATE_SHIFT 0
#define PMIC_RG_BUCK_VPROC_SFCHG_FEN_ADDR MT6356_BUCK_VPROC_CFG0
#define PMIC_RG_BUCK_VPROC_SFCHG_FEN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_SFCHG_FEN_SHIFT 7
#define PMIC_RG_BUCK_VPROC_SFCHG_RRATE_ADDR MT6356_BUCK_VPROC_CFG0
#define PMIC_RG_BUCK_VPROC_SFCHG_RRATE_MASK 0x7F
#define PMIC_RG_BUCK_VPROC_SFCHG_RRATE_SHIFT 8
#define PMIC_RG_BUCK_VPROC_SFCHG_REN_ADDR MT6356_BUCK_VPROC_CFG0
#define PMIC_RG_BUCK_VPROC_SFCHG_REN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_SFCHG_REN_SHIFT 15
#define PMIC_RG_BUCK_VPROC_DVS_EN_TD_ADDR MT6356_BUCK_VPROC_CFG1
#define PMIC_RG_BUCK_VPROC_DVS_EN_TD_MASK 0x3
#define PMIC_RG_BUCK_VPROC_DVS_EN_TD_SHIFT 0
#define PMIC_RG_BUCK_VPROC_DVS_EN_CTRL_ADDR MT6356_BUCK_VPROC_CFG1
#define PMIC_RG_BUCK_VPROC_DVS_EN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VPROC_DVS_EN_CTRL_SHIFT 4
#define PMIC_RG_BUCK_VPROC_DVS_EN_ONCE_ADDR MT6356_BUCK_VPROC_CFG1
#define PMIC_RG_BUCK_VPROC_DVS_EN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VPROC_DVS_EN_ONCE_SHIFT 6
#define PMIC_RG_BUCK_VPROC_DVS_DOWN_TD_ADDR MT6356_BUCK_VPROC_CFG1
#define PMIC_RG_BUCK_VPROC_DVS_DOWN_TD_MASK 0x3
#define PMIC_RG_BUCK_VPROC_DVS_DOWN_TD_SHIFT 8
#define PMIC_RG_BUCK_VPROC_DVS_DOWN_CTRL_ADDR MT6356_BUCK_VPROC_CFG1
#define PMIC_RG_BUCK_VPROC_DVS_DOWN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VPROC_DVS_DOWN_CTRL_SHIFT 12
#define PMIC_RG_BUCK_VPROC_DVS_DOWN_ONCE_ADDR MT6356_BUCK_VPROC_CFG1
#define PMIC_RG_BUCK_VPROC_DVS_DOWN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VPROC_DVS_DOWN_ONCE_SHIFT 14
#define PMIC_RG_BUCK_VPROC_SW_OP_EN_ADDR MT6356_BUCK_VPROC_OP_EN
#define PMIC_RG_BUCK_VPROC_SW_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_SW_OP_EN_SHIFT 0
#define PMIC_RG_BUCK_VPROC_HW0_OP_EN_ADDR MT6356_BUCK_VPROC_OP_EN
#define PMIC_RG_BUCK_VPROC_HW0_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_HW0_OP_EN_SHIFT 1
#define PMIC_RG_BUCK_VPROC_HW1_OP_EN_ADDR MT6356_BUCK_VPROC_OP_EN
#define PMIC_RG_BUCK_VPROC_HW1_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_HW1_OP_EN_SHIFT 2
#define PMIC_RG_BUCK_VPROC_HW2_OP_EN_ADDR MT6356_BUCK_VPROC_OP_EN
#define PMIC_RG_BUCK_VPROC_HW2_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_HW2_OP_EN_SHIFT 3
#define PMIC_RG_BUCK_VPROC_OP_EN_SET_ADDR MT6356_BUCK_VPROC_OP_EN_SET
#define PMIC_RG_BUCK_VPROC_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VPROC_OP_EN_SET_SHIFT 0
#define PMIC_RG_BUCK_VPROC_OP_EN_CLR_ADDR MT6356_BUCK_VPROC_OP_EN_CLR
#define PMIC_RG_BUCK_VPROC_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VPROC_OP_EN_CLR_SHIFT 0
#define PMIC_RG_BUCK_VPROC_HW0_OP_CFG_ADDR MT6356_BUCK_VPROC_OP_CFG
#define PMIC_RG_BUCK_VPROC_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VPROC_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_BUCK_VPROC_HW1_OP_CFG_ADDR MT6356_BUCK_VPROC_OP_CFG
#define PMIC_RG_BUCK_VPROC_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VPROC_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_BUCK_VPROC_HW2_OP_CFG_ADDR MT6356_BUCK_VPROC_OP_CFG
#define PMIC_RG_BUCK_VPROC_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VPROC_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_BUCK_VPROC_ON_OP_ADDR MT6356_BUCK_VPROC_OP_CFG
#define PMIC_RG_BUCK_VPROC_ON_OP_MASK 0x1
#define PMIC_RG_BUCK_VPROC_ON_OP_SHIFT 8
#define PMIC_RG_BUCK_VPROC_LP_OP_ADDR MT6356_BUCK_VPROC_OP_CFG
#define PMIC_RG_BUCK_VPROC_LP_OP_MASK 0x1
#define PMIC_RG_BUCK_VPROC_LP_OP_SHIFT 9
#define PMIC_RG_BUCK_VPROC_OP_CFG_SET_ADDR MT6356_BUCK_VPROC_OP_CFG_SET
#define PMIC_RG_BUCK_VPROC_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VPROC_OP_CFG_SET_SHIFT 0
#define PMIC_RG_BUCK_VPROC_OP_CFG_CLR_ADDR MT6356_BUCK_VPROC_OP_CFG_CLR
#define PMIC_RG_BUCK_VPROC_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VPROC_OP_CFG_CLR_SHIFT 0
#define PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_ADDR MT6356_BUCK_VPROC_SP_CON
#define PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_SHIFT 0
#define PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_EN_ADDR MT6356_BUCK_VPROC_SP_CFG
#define PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_EN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_EN_SHIFT 0
#define PMIC_RG_BUCK_VPROC_SP_ON_VOSEL_MUX_SEL_ADDR MT6356_BUCK_VPROC_SP_CFG
#define PMIC_RG_BUCK_VPROC_SP_ON_VOSEL_MUX_SEL_MASK 0x1
#define PMIC_RG_BUCK_VPROC_SP_ON_VOSEL_MUX_SEL_SHIFT 1
#define PMIC_RG_BUCK_VPROC_OC_DEG_EN_ADDR MT6356_BUCK_VPROC_OC_CFG
#define PMIC_RG_BUCK_VPROC_OC_DEG_EN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_OC_DEG_EN_SHIFT 1
#define PMIC_RG_BUCK_VPROC_OC_WND_ADDR MT6356_BUCK_VPROC_OC_CFG
#define PMIC_RG_BUCK_VPROC_OC_WND_MASK 0x3
#define PMIC_RG_BUCK_VPROC_OC_WND_SHIFT 2
#define PMIC_RG_BUCK_VPROC_OC_THD_ADDR MT6356_BUCK_VPROC_OC_CFG
#define PMIC_RG_BUCK_VPROC_OC_THD_MASK 0x3
#define PMIC_RG_BUCK_VPROC_OC_THD_SHIFT 6
#define PMIC_DA_VPROC_VOSEL_ADDR MT6356_BUCK_VPROC_DBG0
#define PMIC_DA_VPROC_VOSEL_MASK 0x7F
#define PMIC_DA_VPROC_VOSEL_SHIFT 0
#define PMIC_DA_VPROC_VOSEL_GRAY_ADDR MT6356_BUCK_VPROC_DBG0
#define PMIC_DA_VPROC_VOSEL_GRAY_MASK 0x7F
#define PMIC_DA_VPROC_VOSEL_GRAY_SHIFT 8
#define PMIC_DA_VPROC_EN_ADDR MT6356_BUCK_VPROC_DBG1
#define PMIC_DA_VPROC_EN_MASK 0x1
#define PMIC_DA_VPROC_EN_SHIFT 0
#define PMIC_DA_VPROC_STB_ADDR MT6356_BUCK_VPROC_DBG1
#define PMIC_DA_VPROC_STB_MASK 0x1
#define PMIC_DA_VPROC_STB_SHIFT 1
#define PMIC_DA_VPROC_VSLEEP_SEL_ADDR MT6356_BUCK_VPROC_DBG1
#define PMIC_DA_VPROC_VSLEEP_SEL_MASK 0x1
#define PMIC_DA_VPROC_VSLEEP_SEL_SHIFT 2
#define PMIC_DA_VPROC_R2R_PDN_ADDR MT6356_BUCK_VPROC_DBG1
#define PMIC_DA_VPROC_R2R_PDN_MASK 0x1
#define PMIC_DA_VPROC_R2R_PDN_SHIFT 3
#define PMIC_DA_VPROC_DVS_EN_ADDR MT6356_BUCK_VPROC_DBG1
#define PMIC_DA_VPROC_DVS_EN_MASK 0x1
#define PMIC_DA_VPROC_DVS_EN_SHIFT 4
#define PMIC_DA_VPROC_DVS_DOWN_ADDR MT6356_BUCK_VPROC_DBG1
#define PMIC_DA_VPROC_DVS_DOWN_MASK 0x1
#define PMIC_DA_VPROC_DVS_DOWN_SHIFT 5
#define PMIC_DA_VPROC_SSH_ADDR MT6356_BUCK_VPROC_DBG1
#define PMIC_DA_VPROC_SSH_MASK 0x1
#define PMIC_DA_VPROC_SSH_SHIFT 6
#define PMIC_DA_VPROC_MINFREQ_DISCHARGE_ADDR MT6356_BUCK_VPROC_DBG1
#define PMIC_DA_VPROC_MINFREQ_DISCHARGE_MASK 0x1
#define PMIC_DA_VPROC_MINFREQ_DISCHARGE_SHIFT 8
#define PMIC_RG_BUCK_VPROC_OC_FLAG_CLR_SEL_ADDR MT6356_BUCK_VPROC_DBG2
#define PMIC_RG_BUCK_VPROC_OC_FLAG_CLR_SEL_MASK 0x1
#define PMIC_RG_BUCK_VPROC_OC_FLAG_CLR_SEL_SHIFT 4
#define PMIC_RG_BUCK_VPROC_OSC_SEL_DIS_ADDR MT6356_BUCK_VPROC_DBG2
#define PMIC_RG_BUCK_VPROC_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_BUCK_VPROC_OSC_SEL_DIS_SHIFT 5
#define PMIC_RG_BUCK_VPROC_CK_SW_MODE_ADDR MT6356_BUCK_VPROC_DBG2
#define PMIC_RG_BUCK_VPROC_CK_SW_MODE_MASK 0x1
#define PMIC_RG_BUCK_VPROC_CK_SW_MODE_SHIFT 6
#define PMIC_RG_BUCK_VPROC_CK_SW_EN_ADDR MT6356_BUCK_VPROC_DBG2
#define PMIC_RG_BUCK_VPROC_CK_SW_EN_MASK 0x1
#define PMIC_RG_BUCK_VPROC_CK_SW_EN_SHIFT 7
#define PMIC_BUCK_VPROC_ELR_LEN_ADDR MT6356_BUCK_VPROC_ELR_NUM
#define PMIC_BUCK_VPROC_ELR_LEN_MASK 0xFF
#define PMIC_BUCK_VPROC_ELR_LEN_SHIFT 0
#define PMIC_RG_BUCK_VPROC_VOSEL_ADDR MT6356_BUCK_VPROC_ELR0
#define PMIC_RG_BUCK_VPROC_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VPROC_VOSEL_SHIFT 0
#define PMIC_BUCK_VCORE_ANA_ID_ADDR MT6356_BUCK_VCORE_DSN_ID
#define PMIC_BUCK_VCORE_ANA_ID_MASK 0xFF
#define PMIC_BUCK_VCORE_ANA_ID_SHIFT 0
#define PMIC_BUCK_VCORE_DIG_ID_ADDR MT6356_BUCK_VCORE_DSN_ID
#define PMIC_BUCK_VCORE_DIG_ID_MASK 0xFF
#define PMIC_BUCK_VCORE_DIG_ID_SHIFT 8
#define PMIC_BUCK_VCORE_ANA_MINOR_REV_ADDR MT6356_BUCK_VCORE_DSN_REV0
#define PMIC_BUCK_VCORE_ANA_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VCORE_ANA_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VCORE_ANA_MAJOR_REV_ADDR MT6356_BUCK_VCORE_DSN_REV0
#define PMIC_BUCK_VCORE_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VCORE_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VCORE_DIG_MINOR_REV_ADDR MT6356_BUCK_VCORE_DSN_REV0
#define PMIC_BUCK_VCORE_DIG_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VCORE_DIG_MINOR_REV_SHIFT 8
#define PMIC_BUCK_VCORE_DIG_MAJOR_REV_ADDR MT6356_BUCK_VCORE_DSN_REV0
#define PMIC_BUCK_VCORE_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VCORE_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BUCK_VCORE_SW_MINOR_REV_ADDR MT6356_BUCK_VCORE_DSN_REV1
#define PMIC_BUCK_VCORE_SW_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VCORE_SW_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VCORE_SW_MAJOR_REV_ADDR MT6356_BUCK_VCORE_DSN_REV1
#define PMIC_BUCK_VCORE_SW_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VCORE_SW_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VCORE_ESP_ADDR MT6356_BUCK_VCORE_DSN_REV1
#define PMIC_BUCK_VCORE_ESP_MASK 0xFF
#define PMIC_BUCK_VCORE_ESP_SHIFT 8
#define PMIC_RG_BUCK_VCORE_EN_ADDR MT6356_BUCK_VCORE_CON0
#define PMIC_RG_BUCK_VCORE_EN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_EN_SHIFT 0
#define PMIC_RG_BUCK_VCORE_LP_ADDR MT6356_BUCK_VCORE_CON0
#define PMIC_RG_BUCK_VCORE_LP_MASK 0x1
#define PMIC_RG_BUCK_VCORE_LP_SHIFT 1
#define PMIC_RG_BUCK_VCORE_VOSEL_SLEEP_ADDR MT6356_BUCK_VCORE_CON1
#define PMIC_RG_BUCK_VCORE_VOSEL_SLEEP_MASK 0x7F
#define PMIC_RG_BUCK_VCORE_VOSEL_SLEEP_SHIFT 0
#define PMIC_RG_BUCK_VCORE_SFCHG_FRATE_ADDR MT6356_BUCK_VCORE_CFG0
#define PMIC_RG_BUCK_VCORE_SFCHG_FRATE_MASK 0x7F
#define PMIC_RG_BUCK_VCORE_SFCHG_FRATE_SHIFT 0
#define PMIC_RG_BUCK_VCORE_SFCHG_FEN_ADDR MT6356_BUCK_VCORE_CFG0
#define PMIC_RG_BUCK_VCORE_SFCHG_FEN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_SFCHG_FEN_SHIFT 7
#define PMIC_RG_BUCK_VCORE_SFCHG_RRATE_ADDR MT6356_BUCK_VCORE_CFG0
#define PMIC_RG_BUCK_VCORE_SFCHG_RRATE_MASK 0x7F
#define PMIC_RG_BUCK_VCORE_SFCHG_RRATE_SHIFT 8
#define PMIC_RG_BUCK_VCORE_SFCHG_REN_ADDR MT6356_BUCK_VCORE_CFG0
#define PMIC_RG_BUCK_VCORE_SFCHG_REN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_SFCHG_REN_SHIFT 15
#define PMIC_RG_BUCK_VCORE_DVS_EN_TD_ADDR MT6356_BUCK_VCORE_CFG1
#define PMIC_RG_BUCK_VCORE_DVS_EN_TD_MASK 0x3
#define PMIC_RG_BUCK_VCORE_DVS_EN_TD_SHIFT 0
#define PMIC_RG_BUCK_VCORE_DVS_EN_CTRL_ADDR MT6356_BUCK_VCORE_CFG1
#define PMIC_RG_BUCK_VCORE_DVS_EN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VCORE_DVS_EN_CTRL_SHIFT 4
#define PMIC_RG_BUCK_VCORE_DVS_EN_ONCE_ADDR MT6356_BUCK_VCORE_CFG1
#define PMIC_RG_BUCK_VCORE_DVS_EN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VCORE_DVS_EN_ONCE_SHIFT 6
#define PMIC_RG_BUCK_VCORE_DVS_DOWN_TD_ADDR MT6356_BUCK_VCORE_CFG1
#define PMIC_RG_BUCK_VCORE_DVS_DOWN_TD_MASK 0x3
#define PMIC_RG_BUCK_VCORE_DVS_DOWN_TD_SHIFT 8
#define PMIC_RG_BUCK_VCORE_DVS_DOWN_CTRL_ADDR MT6356_BUCK_VCORE_CFG1
#define PMIC_RG_BUCK_VCORE_DVS_DOWN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VCORE_DVS_DOWN_CTRL_SHIFT 12
#define PMIC_RG_BUCK_VCORE_DVS_DOWN_ONCE_ADDR MT6356_BUCK_VCORE_CFG1
#define PMIC_RG_BUCK_VCORE_DVS_DOWN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VCORE_DVS_DOWN_ONCE_SHIFT 14
#define PMIC_RG_BUCK_VCORE_SW_OP_EN_ADDR MT6356_BUCK_VCORE_OP_EN
#define PMIC_RG_BUCK_VCORE_SW_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_SW_OP_EN_SHIFT 0
#define PMIC_RG_BUCK_VCORE_HW0_OP_EN_ADDR MT6356_BUCK_VCORE_OP_EN
#define PMIC_RG_BUCK_VCORE_HW0_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_HW0_OP_EN_SHIFT 1
#define PMIC_RG_BUCK_VCORE_HW1_OP_EN_ADDR MT6356_BUCK_VCORE_OP_EN
#define PMIC_RG_BUCK_VCORE_HW1_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_HW1_OP_EN_SHIFT 2
#define PMIC_RG_BUCK_VCORE_HW2_OP_EN_ADDR MT6356_BUCK_VCORE_OP_EN
#define PMIC_RG_BUCK_VCORE_HW2_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_HW2_OP_EN_SHIFT 3
#define PMIC_RG_BUCK_VCORE_OP_EN_SET_ADDR MT6356_BUCK_VCORE_OP_EN_SET
#define PMIC_RG_BUCK_VCORE_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VCORE_OP_EN_SET_SHIFT 0
#define PMIC_RG_BUCK_VCORE_OP_EN_CLR_ADDR MT6356_BUCK_VCORE_OP_EN_CLR
#define PMIC_RG_BUCK_VCORE_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VCORE_OP_EN_CLR_SHIFT 0
#define PMIC_RG_BUCK_VCORE_HW0_OP_CFG_ADDR MT6356_BUCK_VCORE_OP_CFG
#define PMIC_RG_BUCK_VCORE_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VCORE_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_BUCK_VCORE_HW1_OP_CFG_ADDR MT6356_BUCK_VCORE_OP_CFG
#define PMIC_RG_BUCK_VCORE_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VCORE_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_BUCK_VCORE_HW2_OP_CFG_ADDR MT6356_BUCK_VCORE_OP_CFG
#define PMIC_RG_BUCK_VCORE_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VCORE_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_BUCK_VCORE_ON_OP_ADDR MT6356_BUCK_VCORE_OP_CFG
#define PMIC_RG_BUCK_VCORE_ON_OP_MASK 0x1
#define PMIC_RG_BUCK_VCORE_ON_OP_SHIFT 8
#define PMIC_RG_BUCK_VCORE_LP_OP_ADDR MT6356_BUCK_VCORE_OP_CFG
#define PMIC_RG_BUCK_VCORE_LP_OP_MASK 0x1
#define PMIC_RG_BUCK_VCORE_LP_OP_SHIFT 9
#define PMIC_RG_BUCK_VCORE_OP_CFG_SET_ADDR MT6356_BUCK_VCORE_OP_CFG_SET
#define PMIC_RG_BUCK_VCORE_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VCORE_OP_CFG_SET_SHIFT 0
#define PMIC_RG_BUCK_VCORE_OP_CFG_CLR_ADDR MT6356_BUCK_VCORE_OP_CFG_CLR
#define PMIC_RG_BUCK_VCORE_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VCORE_OP_CFG_CLR_SHIFT 0
#define PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_ADDR MT6356_BUCK_VCORE_SP_CON
#define PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_SHIFT 0
#define PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_EN_ADDR MT6356_BUCK_VCORE_SP_CFG
#define PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_EN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_EN_SHIFT 0
#define PMIC_RG_BUCK_VCORE_SP_ON_VOSEL_MUX_SEL_ADDR MT6356_BUCK_VCORE_SP_CFG
#define PMIC_RG_BUCK_VCORE_SP_ON_VOSEL_MUX_SEL_MASK 0x1
#define PMIC_RG_BUCK_VCORE_SP_ON_VOSEL_MUX_SEL_SHIFT 1
#define PMIC_RG_BUCK_VCORE_OC_DEG_EN_ADDR MT6356_BUCK_VCORE_OC_CFG
#define PMIC_RG_BUCK_VCORE_OC_DEG_EN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_OC_DEG_EN_SHIFT 1
#define PMIC_RG_BUCK_VCORE_OC_WND_ADDR MT6356_BUCK_VCORE_OC_CFG
#define PMIC_RG_BUCK_VCORE_OC_WND_MASK 0x3
#define PMIC_RG_BUCK_VCORE_OC_WND_SHIFT 2
#define PMIC_RG_BUCK_VCORE_OC_THD_ADDR MT6356_BUCK_VCORE_OC_CFG
#define PMIC_RG_BUCK_VCORE_OC_THD_MASK 0x3
#define PMIC_RG_BUCK_VCORE_OC_THD_SHIFT 6
#define PMIC_DA_VCORE_VOSEL_ADDR MT6356_BUCK_VCORE_DBG0
#define PMIC_DA_VCORE_VOSEL_MASK 0x7F
#define PMIC_DA_VCORE_VOSEL_SHIFT 0
#define PMIC_DA_VCORE_VOSEL_GRAY_ADDR MT6356_BUCK_VCORE_DBG0
#define PMIC_DA_VCORE_VOSEL_GRAY_MASK 0x7F
#define PMIC_DA_VCORE_VOSEL_GRAY_SHIFT 8
#define PMIC_DA_VCORE_EN_ADDR MT6356_BUCK_VCORE_DBG1
#define PMIC_DA_VCORE_EN_MASK 0x1
#define PMIC_DA_VCORE_EN_SHIFT 0
#define PMIC_DA_VCORE_STB_ADDR MT6356_BUCK_VCORE_DBG1
#define PMIC_DA_VCORE_STB_MASK 0x1
#define PMIC_DA_VCORE_STB_SHIFT 1
#define PMIC_DA_VCORE_VSLEEP_SEL_ADDR MT6356_BUCK_VCORE_DBG1
#define PMIC_DA_VCORE_VSLEEP_SEL_MASK 0x1
#define PMIC_DA_VCORE_VSLEEP_SEL_SHIFT 2
#define PMIC_DA_VCORE_R2R_PDN_ADDR MT6356_BUCK_VCORE_DBG1
#define PMIC_DA_VCORE_R2R_PDN_MASK 0x1
#define PMIC_DA_VCORE_R2R_PDN_SHIFT 3
#define PMIC_DA_VCORE_DVS_EN_ADDR MT6356_BUCK_VCORE_DBG1
#define PMIC_DA_VCORE_DVS_EN_MASK 0x1
#define PMIC_DA_VCORE_DVS_EN_SHIFT 4
#define PMIC_DA_VCORE_DVS_DOWN_ADDR MT6356_BUCK_VCORE_DBG1
#define PMIC_DA_VCORE_DVS_DOWN_MASK 0x1
#define PMIC_DA_VCORE_DVS_DOWN_SHIFT 5
#define PMIC_DA_VCORE_SSH_ADDR MT6356_BUCK_VCORE_DBG1
#define PMIC_DA_VCORE_SSH_MASK 0x1
#define PMIC_DA_VCORE_SSH_SHIFT 6
#define PMIC_DA_VCORE_MINFREQ_DISCHARGE_ADDR MT6356_BUCK_VCORE_DBG1
#define PMIC_DA_VCORE_MINFREQ_DISCHARGE_MASK 0x1
#define PMIC_DA_VCORE_MINFREQ_DISCHARGE_SHIFT 8
#define PMIC_RG_BUCK_VCORE_OC_FLAG_CLR_SEL_ADDR MT6356_BUCK_VCORE_DBG2
#define PMIC_RG_BUCK_VCORE_OC_FLAG_CLR_SEL_MASK 0x1
#define PMIC_RG_BUCK_VCORE_OC_FLAG_CLR_SEL_SHIFT 4
#define PMIC_RG_BUCK_VCORE_OSC_SEL_DIS_ADDR MT6356_BUCK_VCORE_DBG2
#define PMIC_RG_BUCK_VCORE_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_BUCK_VCORE_OSC_SEL_DIS_SHIFT 5
#define PMIC_RG_BUCK_VCORE_CK_SW_MODE_ADDR MT6356_BUCK_VCORE_DBG2
#define PMIC_RG_BUCK_VCORE_CK_SW_MODE_MASK 0x1
#define PMIC_RG_BUCK_VCORE_CK_SW_MODE_SHIFT 6
#define PMIC_RG_BUCK_VCORE_CK_SW_EN_ADDR MT6356_BUCK_VCORE_DBG2
#define PMIC_RG_BUCK_VCORE_CK_SW_EN_MASK 0x1
#define PMIC_RG_BUCK_VCORE_CK_SW_EN_SHIFT 7
#define PMIC_BUCK_VCORE_ELR_LEN_ADDR MT6356_BUCK_VCORE_ELR_NUM
#define PMIC_BUCK_VCORE_ELR_LEN_MASK 0xFF
#define PMIC_BUCK_VCORE_ELR_LEN_SHIFT 0
#define PMIC_RG_BUCK_VCORE_VOSEL_ADDR MT6356_BUCK_VCORE_ELR0
#define PMIC_RG_BUCK_VCORE_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VCORE_VOSEL_SHIFT 0
#define PMIC_BUCK_VMODEM_ANA_ID_ADDR MT6356_BUCK_VMODEM_DSN_ID
#define PMIC_BUCK_VMODEM_ANA_ID_MASK 0xFF
#define PMIC_BUCK_VMODEM_ANA_ID_SHIFT 0
#define PMIC_BUCK_VMODEM_DIG_ID_ADDR MT6356_BUCK_VMODEM_DSN_ID
#define PMIC_BUCK_VMODEM_DIG_ID_MASK 0xFF
#define PMIC_BUCK_VMODEM_DIG_ID_SHIFT 8
#define PMIC_BUCK_VMODEM_ANA_MINOR_REV_ADDR MT6356_BUCK_VMODEM_DSN_REV0
#define PMIC_BUCK_VMODEM_ANA_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VMODEM_ANA_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VMODEM_ANA_MAJOR_REV_ADDR MT6356_BUCK_VMODEM_DSN_REV0
#define PMIC_BUCK_VMODEM_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VMODEM_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VMODEM_DIG_MINOR_REV_ADDR MT6356_BUCK_VMODEM_DSN_REV0
#define PMIC_BUCK_VMODEM_DIG_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VMODEM_DIG_MINOR_REV_SHIFT 8
#define PMIC_BUCK_VMODEM_DIG_MAJOR_REV_ADDR MT6356_BUCK_VMODEM_DSN_REV0
#define PMIC_BUCK_VMODEM_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VMODEM_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BUCK_VMODEM_SW_MINOR_REV_ADDR MT6356_BUCK_VMODEM_DSN_REV1
#define PMIC_BUCK_VMODEM_SW_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VMODEM_SW_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VMODEM_SW_MAJOR_REV_ADDR MT6356_BUCK_VMODEM_DSN_REV1
#define PMIC_BUCK_VMODEM_SW_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VMODEM_SW_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VMODEM_ESP_ADDR MT6356_BUCK_VMODEM_DSN_REV1
#define PMIC_BUCK_VMODEM_ESP_MASK 0xFF
#define PMIC_BUCK_VMODEM_ESP_SHIFT 8
#define PMIC_RG_BUCK_VMODEM_EN_ADDR MT6356_BUCK_VMODEM_CON0
#define PMIC_RG_BUCK_VMODEM_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_EN_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_LP_ADDR MT6356_BUCK_VMODEM_CON0
#define PMIC_RG_BUCK_VMODEM_LP_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_LP_SHIFT 1
#define PMIC_RG_BUCK_VMODEM_VOSEL_SLEEP_ADDR MT6356_BUCK_VMODEM_CON1
#define PMIC_RG_BUCK_VMODEM_VOSEL_SLEEP_MASK 0x7F
#define PMIC_RG_BUCK_VMODEM_VOSEL_SLEEP_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_SFCHG_FRATE_ADDR MT6356_BUCK_VMODEM_CFG0
#define PMIC_RG_BUCK_VMODEM_SFCHG_FRATE_MASK 0x7F
#define PMIC_RG_BUCK_VMODEM_SFCHG_FRATE_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_SFCHG_FEN_ADDR MT6356_BUCK_VMODEM_CFG0
#define PMIC_RG_BUCK_VMODEM_SFCHG_FEN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_SFCHG_FEN_SHIFT 7
#define PMIC_RG_BUCK_VMODEM_SFCHG_RRATE_ADDR MT6356_BUCK_VMODEM_CFG0
#define PMIC_RG_BUCK_VMODEM_SFCHG_RRATE_MASK 0x7F
#define PMIC_RG_BUCK_VMODEM_SFCHG_RRATE_SHIFT 8
#define PMIC_RG_BUCK_VMODEM_SFCHG_REN_ADDR MT6356_BUCK_VMODEM_CFG0
#define PMIC_RG_BUCK_VMODEM_SFCHG_REN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_SFCHG_REN_SHIFT 15
#define PMIC_RG_BUCK_VMODEM_DVS_EN_TD_ADDR MT6356_BUCK_VMODEM_CFG1
#define PMIC_RG_BUCK_VMODEM_DVS_EN_TD_MASK 0x3
#define PMIC_RG_BUCK_VMODEM_DVS_EN_TD_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_DVS_EN_CTRL_ADDR MT6356_BUCK_VMODEM_CFG1
#define PMIC_RG_BUCK_VMODEM_DVS_EN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VMODEM_DVS_EN_CTRL_SHIFT 4
#define PMIC_RG_BUCK_VMODEM_DVS_EN_ONCE_ADDR MT6356_BUCK_VMODEM_CFG1
#define PMIC_RG_BUCK_VMODEM_DVS_EN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_DVS_EN_ONCE_SHIFT 6
#define PMIC_RG_BUCK_VMODEM_DVS_DOWN_TD_ADDR MT6356_BUCK_VMODEM_CFG1
#define PMIC_RG_BUCK_VMODEM_DVS_DOWN_TD_MASK 0x3
#define PMIC_RG_BUCK_VMODEM_DVS_DOWN_TD_SHIFT 8
#define PMIC_RG_BUCK_VMODEM_DVS_DOWN_CTRL_ADDR MT6356_BUCK_VMODEM_CFG1
#define PMIC_RG_BUCK_VMODEM_DVS_DOWN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VMODEM_DVS_DOWN_CTRL_SHIFT 12
#define PMIC_RG_BUCK_VMODEM_DVS_DOWN_ONCE_ADDR MT6356_BUCK_VMODEM_CFG1
#define PMIC_RG_BUCK_VMODEM_DVS_DOWN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_DVS_DOWN_ONCE_SHIFT 14
#define PMIC_RG_BUCK_VMODEM_SW_OP_EN_ADDR MT6356_BUCK_VMODEM_OP_EN
#define PMIC_RG_BUCK_VMODEM_SW_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_SW_OP_EN_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_HW0_OP_EN_ADDR MT6356_BUCK_VMODEM_OP_EN
#define PMIC_RG_BUCK_VMODEM_HW0_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_HW0_OP_EN_SHIFT 1
#define PMIC_RG_BUCK_VMODEM_HW1_OP_EN_ADDR MT6356_BUCK_VMODEM_OP_EN
#define PMIC_RG_BUCK_VMODEM_HW1_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_HW1_OP_EN_SHIFT 2
#define PMIC_RG_BUCK_VMODEM_HW2_OP_EN_ADDR MT6356_BUCK_VMODEM_OP_EN
#define PMIC_RG_BUCK_VMODEM_HW2_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_HW2_OP_EN_SHIFT 3
#define PMIC_RG_BUCK_VMODEM_OP_EN_SET_ADDR MT6356_BUCK_VMODEM_OP_EN_SET
#define PMIC_RG_BUCK_VMODEM_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VMODEM_OP_EN_SET_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_OP_EN_CLR_ADDR MT6356_BUCK_VMODEM_OP_EN_CLR
#define PMIC_RG_BUCK_VMODEM_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VMODEM_OP_EN_CLR_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_HW0_OP_CFG_ADDR MT6356_BUCK_VMODEM_OP_CFG
#define PMIC_RG_BUCK_VMODEM_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_BUCK_VMODEM_HW1_OP_CFG_ADDR MT6356_BUCK_VMODEM_OP_CFG
#define PMIC_RG_BUCK_VMODEM_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_BUCK_VMODEM_HW2_OP_CFG_ADDR MT6356_BUCK_VMODEM_OP_CFG
#define PMIC_RG_BUCK_VMODEM_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_BUCK_VMODEM_ON_OP_ADDR MT6356_BUCK_VMODEM_OP_CFG
#define PMIC_RG_BUCK_VMODEM_ON_OP_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_ON_OP_SHIFT 8
#define PMIC_RG_BUCK_VMODEM_LP_OP_ADDR MT6356_BUCK_VMODEM_OP_CFG
#define PMIC_RG_BUCK_VMODEM_LP_OP_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_LP_OP_SHIFT 9
#define PMIC_RG_BUCK_VMODEM_OP_CFG_SET_ADDR MT6356_BUCK_VMODEM_OP_CFG_SET
#define PMIC_RG_BUCK_VMODEM_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VMODEM_OP_CFG_SET_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_OP_CFG_CLR_ADDR MT6356_BUCK_VMODEM_OP_CFG_CLR
#define PMIC_RG_BUCK_VMODEM_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VMODEM_OP_CFG_CLR_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_ADDR MT6356_BUCK_VMODEM_SP_CON
#define PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_EN_ADDR MT6356_BUCK_VMODEM_SP_CFG
#define PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_EN_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_SP_ON_VOSEL_MUX_SEL_ADDR MT6356_BUCK_VMODEM_SP_CFG
#define PMIC_RG_BUCK_VMODEM_SP_ON_VOSEL_MUX_SEL_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_SP_ON_VOSEL_MUX_SEL_SHIFT 1
#define PMIC_RG_BUCK_VMODEM_OC_DEG_EN_ADDR MT6356_BUCK_VMODEM_OC_CFG
#define PMIC_RG_BUCK_VMODEM_OC_DEG_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_OC_DEG_EN_SHIFT 1
#define PMIC_RG_BUCK_VMODEM_OC_WND_ADDR MT6356_BUCK_VMODEM_OC_CFG
#define PMIC_RG_BUCK_VMODEM_OC_WND_MASK 0x3
#define PMIC_RG_BUCK_VMODEM_OC_WND_SHIFT 2
#define PMIC_RG_BUCK_VMODEM_OC_THD_ADDR MT6356_BUCK_VMODEM_OC_CFG
#define PMIC_RG_BUCK_VMODEM_OC_THD_MASK 0x3
#define PMIC_RG_BUCK_VMODEM_OC_THD_SHIFT 6
#define PMIC_DA_VMODEM_VOSEL_ADDR MT6356_BUCK_VMODEM_DBG0
#define PMIC_DA_VMODEM_VOSEL_MASK 0x7F
#define PMIC_DA_VMODEM_VOSEL_SHIFT 0
#define PMIC_DA_VMODEM_VOSEL_GRAY_ADDR MT6356_BUCK_VMODEM_DBG0
#define PMIC_DA_VMODEM_VOSEL_GRAY_MASK 0x7F
#define PMIC_DA_VMODEM_VOSEL_GRAY_SHIFT 8
#define PMIC_DA_VMODEM_EN_ADDR MT6356_BUCK_VMODEM_DBG1
#define PMIC_DA_VMODEM_EN_MASK 0x1
#define PMIC_DA_VMODEM_EN_SHIFT 0
#define PMIC_DA_VMODEM_STB_ADDR MT6356_BUCK_VMODEM_DBG1
#define PMIC_DA_VMODEM_STB_MASK 0x1
#define PMIC_DA_VMODEM_STB_SHIFT 1
#define PMIC_DA_VMODEM_VSLEEP_SEL_ADDR MT6356_BUCK_VMODEM_DBG1
#define PMIC_DA_VMODEM_VSLEEP_SEL_MASK 0x1
#define PMIC_DA_VMODEM_VSLEEP_SEL_SHIFT 2
#define PMIC_DA_VMODEM_R2R_PDN_ADDR MT6356_BUCK_VMODEM_DBG1
#define PMIC_DA_VMODEM_R2R_PDN_MASK 0x1
#define PMIC_DA_VMODEM_R2R_PDN_SHIFT 3
#define PMIC_DA_VMODEM_DVS_EN_ADDR MT6356_BUCK_VMODEM_DBG1
#define PMIC_DA_VMODEM_DVS_EN_MASK 0x1
#define PMIC_DA_VMODEM_DVS_EN_SHIFT 4
#define PMIC_DA_VMODEM_MINFREQ_DISCHARGE_ADDR MT6356_BUCK_VMODEM_DBG1
#define PMIC_DA_VMODEM_MINFREQ_DISCHARGE_MASK 0x1
#define PMIC_DA_VMODEM_MINFREQ_DISCHARGE_SHIFT 8
#define PMIC_RG_BUCK_VMODEM_OC_FLAG_CLR_SEL_ADDR MT6356_BUCK_VMODEM_DBG2
#define PMIC_RG_BUCK_VMODEM_OC_FLAG_CLR_SEL_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_OC_FLAG_CLR_SEL_SHIFT 4
#define PMIC_RG_BUCK_VMODEM_OSC_SEL_DIS_ADDR MT6356_BUCK_VMODEM_DBG2
#define PMIC_RG_BUCK_VMODEM_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_OSC_SEL_DIS_SHIFT 5
#define PMIC_RG_BUCK_VMODEM_CK_SW_MODE_ADDR MT6356_BUCK_VMODEM_DBG2
#define PMIC_RG_BUCK_VMODEM_CK_SW_MODE_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_CK_SW_MODE_SHIFT 6
#define PMIC_RG_BUCK_VMODEM_CK_SW_EN_ADDR MT6356_BUCK_VMODEM_DBG2
#define PMIC_RG_BUCK_VMODEM_CK_SW_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_CK_SW_EN_SHIFT 7
#define PMIC_RG_BUCK_VMODEM_VOSEL_DLC0_ADDR MT6356_BUCK_VMODEM_DLC_CON0
#define PMIC_RG_BUCK_VMODEM_VOSEL_DLC0_MASK 0x7F
#define PMIC_RG_BUCK_VMODEM_VOSEL_DLC0_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_VOSEL_DLC1_ADDR MT6356_BUCK_VMODEM_DLC_CON0
#define PMIC_RG_BUCK_VMODEM_VOSEL_DLC1_MASK 0x7F
#define PMIC_RG_BUCK_VMODEM_VOSEL_DLC1_SHIFT 8
#define PMIC_RG_BUCK_VMODEM_VOSEL_DLC2_ADDR MT6356_BUCK_VMODEM_DLC_CON1
#define PMIC_RG_BUCK_VMODEM_VOSEL_DLC2_MASK 0x7F
#define PMIC_RG_BUCK_VMODEM_VOSEL_DLC2_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_DLC0_ADDR MT6356_BUCK_VMODEM_DLC_CON2
#define PMIC_RG_BUCK_VMODEM_DLC0_MASK 0x7
#define PMIC_RG_BUCK_VMODEM_DLC0_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_DLC1_ADDR MT6356_BUCK_VMODEM_DLC_CON2
#define PMIC_RG_BUCK_VMODEM_DLC1_MASK 0x7
#define PMIC_RG_BUCK_VMODEM_DLC1_SHIFT 4
#define PMIC_RG_BUCK_VMODEM_DLC2_ADDR MT6356_BUCK_VMODEM_DLC_CON2
#define PMIC_RG_BUCK_VMODEM_DLC2_MASK 0x7
#define PMIC_RG_BUCK_VMODEM_DLC2_SHIFT 8
#define PMIC_RG_BUCK_VMODEM_DLC3_ADDR MT6356_BUCK_VMODEM_DLC_CON2
#define PMIC_RG_BUCK_VMODEM_DLC3_MASK 0x7
#define PMIC_RG_BUCK_VMODEM_DLC3_SHIFT 12
#define PMIC_RG_BUCK_VMODEM_DLC_MAP_EN_ADDR MT6356_BUCK_VMODEM_DLC_CON3
#define PMIC_RG_BUCK_VMODEM_DLC_MAP_EN_MASK 0x1
#define PMIC_RG_BUCK_VMODEM_DLC_MAP_EN_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_DLC_ADDR MT6356_BUCK_VMODEM_DLC_CON3
#define PMIC_RG_BUCK_VMODEM_DLC_MASK 0x7
#define PMIC_RG_BUCK_VMODEM_DLC_SHIFT 8
#define PMIC_DA_VMODEM_DLC_ADDR MT6356_BUCK_VMODEM_DLC_CON3
#define PMIC_DA_VMODEM_DLC_MASK 0x7
#define PMIC_DA_VMODEM_DLC_SHIFT 12
#define PMIC_BUCK_VMODEM_ELR_LEN_ADDR MT6356_BUCK_VMODEM_ELR_NUM
#define PMIC_BUCK_VMODEM_ELR_LEN_MASK 0xFF
#define PMIC_BUCK_VMODEM_ELR_LEN_SHIFT 0
#define PMIC_RG_BUCK_VMODEM_VOSEL_ADDR MT6356_BUCK_VMODEM_ELR0
#define PMIC_RG_BUCK_VMODEM_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VMODEM_VOSEL_SHIFT 0
#define PMIC_BUCK_VS1_ANA_ID_ADDR MT6356_BUCK_VS1_DSN_ID
#define PMIC_BUCK_VS1_ANA_ID_MASK 0xFF
#define PMIC_BUCK_VS1_ANA_ID_SHIFT 0
#define PMIC_BUCK_VS1_DIG_ID_ADDR MT6356_BUCK_VS1_DSN_ID
#define PMIC_BUCK_VS1_DIG_ID_MASK 0xFF
#define PMIC_BUCK_VS1_DIG_ID_SHIFT 8
#define PMIC_BUCK_VS1_ANA_MINOR_REV_ADDR MT6356_BUCK_VS1_DSN_REV0
#define PMIC_BUCK_VS1_ANA_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VS1_ANA_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VS1_ANA_MAJOR_REV_ADDR MT6356_BUCK_VS1_DSN_REV0
#define PMIC_BUCK_VS1_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VS1_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VS1_DIG_MINOR_REV_ADDR MT6356_BUCK_VS1_DSN_REV0
#define PMIC_BUCK_VS1_DIG_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VS1_DIG_MINOR_REV_SHIFT 8
#define PMIC_BUCK_VS1_DIG_MAJOR_REV_ADDR MT6356_BUCK_VS1_DSN_REV0
#define PMIC_BUCK_VS1_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VS1_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BUCK_VS1_SW_MINOR_REV_ADDR MT6356_BUCK_VS1_DSN_REV1
#define PMIC_BUCK_VS1_SW_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VS1_SW_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VS1_SW_MAJOR_REV_ADDR MT6356_BUCK_VS1_DSN_REV1
#define PMIC_BUCK_VS1_SW_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VS1_SW_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VS1_ESP_ADDR MT6356_BUCK_VS1_DSN_REV1
#define PMIC_BUCK_VS1_ESP_MASK 0xFF
#define PMIC_BUCK_VS1_ESP_SHIFT 8
#define PMIC_RG_BUCK_VS1_EN_ADDR MT6356_BUCK_VS1_CON0
#define PMIC_RG_BUCK_VS1_EN_MASK 0x1
#define PMIC_RG_BUCK_VS1_EN_SHIFT 0
#define PMIC_RG_BUCK_VS1_LP_ADDR MT6356_BUCK_VS1_CON0
#define PMIC_RG_BUCK_VS1_LP_MASK 0x1
#define PMIC_RG_BUCK_VS1_LP_SHIFT 1
#define PMIC_RG_BUCK_VS1_VOSEL_SLEEP_ADDR MT6356_BUCK_VS1_CON1
#define PMIC_RG_BUCK_VS1_VOSEL_SLEEP_MASK 0x7F
#define PMIC_RG_BUCK_VS1_VOSEL_SLEEP_SHIFT 0
#define PMIC_RG_BUCK_VS1_SFCHG_FRATE_ADDR MT6356_BUCK_VS1_CFG0
#define PMIC_RG_BUCK_VS1_SFCHG_FRATE_MASK 0x7F
#define PMIC_RG_BUCK_VS1_SFCHG_FRATE_SHIFT 0
#define PMIC_RG_BUCK_VS1_SFCHG_FEN_ADDR MT6356_BUCK_VS1_CFG0
#define PMIC_RG_BUCK_VS1_SFCHG_FEN_MASK 0x1
#define PMIC_RG_BUCK_VS1_SFCHG_FEN_SHIFT 7
#define PMIC_RG_BUCK_VS1_SFCHG_RRATE_ADDR MT6356_BUCK_VS1_CFG0
#define PMIC_RG_BUCK_VS1_SFCHG_RRATE_MASK 0x7F
#define PMIC_RG_BUCK_VS1_SFCHG_RRATE_SHIFT 8
#define PMIC_RG_BUCK_VS1_SFCHG_REN_ADDR MT6356_BUCK_VS1_CFG0
#define PMIC_RG_BUCK_VS1_SFCHG_REN_MASK 0x1
#define PMIC_RG_BUCK_VS1_SFCHG_REN_SHIFT 15
#define PMIC_RG_BUCK_VS1_DVS_EN_TD_ADDR MT6356_BUCK_VS1_CFG1
#define PMIC_RG_BUCK_VS1_DVS_EN_TD_MASK 0x3
#define PMIC_RG_BUCK_VS1_DVS_EN_TD_SHIFT 0
#define PMIC_RG_BUCK_VS1_DVS_EN_CTRL_ADDR MT6356_BUCK_VS1_CFG1
#define PMIC_RG_BUCK_VS1_DVS_EN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VS1_DVS_EN_CTRL_SHIFT 4
#define PMIC_RG_BUCK_VS1_DVS_EN_ONCE_ADDR MT6356_BUCK_VS1_CFG1
#define PMIC_RG_BUCK_VS1_DVS_EN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VS1_DVS_EN_ONCE_SHIFT 6
#define PMIC_RG_BUCK_VS1_DVS_DOWN_TD_ADDR MT6356_BUCK_VS1_CFG1
#define PMIC_RG_BUCK_VS1_DVS_DOWN_TD_MASK 0x3
#define PMIC_RG_BUCK_VS1_DVS_DOWN_TD_SHIFT 8
#define PMIC_RG_BUCK_VS1_DVS_DOWN_CTRL_ADDR MT6356_BUCK_VS1_CFG1
#define PMIC_RG_BUCK_VS1_DVS_DOWN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VS1_DVS_DOWN_CTRL_SHIFT 12
#define PMIC_RG_BUCK_VS1_DVS_DOWN_ONCE_ADDR MT6356_BUCK_VS1_CFG1
#define PMIC_RG_BUCK_VS1_DVS_DOWN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VS1_DVS_DOWN_ONCE_SHIFT 14
#define PMIC_RG_BUCK_VS1_SW_OP_EN_ADDR MT6356_BUCK_VS1_OP_EN
#define PMIC_RG_BUCK_VS1_SW_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VS1_SW_OP_EN_SHIFT 0
#define PMIC_RG_BUCK_VS1_HW0_OP_EN_ADDR MT6356_BUCK_VS1_OP_EN
#define PMIC_RG_BUCK_VS1_HW0_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VS1_HW0_OP_EN_SHIFT 1
#define PMIC_RG_BUCK_VS1_HW1_OP_EN_ADDR MT6356_BUCK_VS1_OP_EN
#define PMIC_RG_BUCK_VS1_HW1_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VS1_HW1_OP_EN_SHIFT 2
#define PMIC_RG_BUCK_VS1_HW2_OP_EN_ADDR MT6356_BUCK_VS1_OP_EN
#define PMIC_RG_BUCK_VS1_HW2_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VS1_HW2_OP_EN_SHIFT 3
#define PMIC_RG_BUCK_VS1_OP_EN_SET_ADDR MT6356_BUCK_VS1_OP_EN_SET
#define PMIC_RG_BUCK_VS1_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VS1_OP_EN_SET_SHIFT 0
#define PMIC_RG_BUCK_VS1_OP_EN_CLR_ADDR MT6356_BUCK_VS1_OP_EN_CLR
#define PMIC_RG_BUCK_VS1_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VS1_OP_EN_CLR_SHIFT 0
#define PMIC_RG_BUCK_VS1_HW0_OP_CFG_ADDR MT6356_BUCK_VS1_OP_CFG
#define PMIC_RG_BUCK_VS1_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VS1_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_BUCK_VS1_HW1_OP_CFG_ADDR MT6356_BUCK_VS1_OP_CFG
#define PMIC_RG_BUCK_VS1_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VS1_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_BUCK_VS1_HW2_OP_CFG_ADDR MT6356_BUCK_VS1_OP_CFG
#define PMIC_RG_BUCK_VS1_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VS1_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_BUCK_VS1_ON_OP_ADDR MT6356_BUCK_VS1_OP_CFG
#define PMIC_RG_BUCK_VS1_ON_OP_MASK 0x1
#define PMIC_RG_BUCK_VS1_ON_OP_SHIFT 8
#define PMIC_RG_BUCK_VS1_LP_OP_ADDR MT6356_BUCK_VS1_OP_CFG
#define PMIC_RG_BUCK_VS1_LP_OP_MASK 0x1
#define PMIC_RG_BUCK_VS1_LP_OP_SHIFT 9
#define PMIC_RG_BUCK_VS1_OP_CFG_SET_ADDR MT6356_BUCK_VS1_OP_CFG_SET
#define PMIC_RG_BUCK_VS1_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VS1_OP_CFG_SET_SHIFT 0
#define PMIC_RG_BUCK_VS1_OP_CFG_CLR_ADDR MT6356_BUCK_VS1_OP_CFG_CLR
#define PMIC_RG_BUCK_VS1_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VS1_OP_CFG_CLR_SHIFT 0
#define PMIC_RG_BUCK_VS1_SP_SW_VOSEL_ADDR MT6356_BUCK_VS1_SP_CON
#define PMIC_RG_BUCK_VS1_SP_SW_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VS1_SP_SW_VOSEL_SHIFT 0
#define PMIC_RG_BUCK_VS1_SP_SW_VOSEL_EN_ADDR MT6356_BUCK_VS1_SP_CFG
#define PMIC_RG_BUCK_VS1_SP_SW_VOSEL_EN_MASK 0x1
#define PMIC_RG_BUCK_VS1_SP_SW_VOSEL_EN_SHIFT 0
#define PMIC_RG_BUCK_VS1_SP_ON_VOSEL_MUX_SEL_ADDR MT6356_BUCK_VS1_SP_CFG
#define PMIC_RG_BUCK_VS1_SP_ON_VOSEL_MUX_SEL_MASK 0x1
#define PMIC_RG_BUCK_VS1_SP_ON_VOSEL_MUX_SEL_SHIFT 1
#define PMIC_RG_BUCK_VS1_OC_DEG_EN_ADDR MT6356_BUCK_VS1_OC_CFG
#define PMIC_RG_BUCK_VS1_OC_DEG_EN_MASK 0x1
#define PMIC_RG_BUCK_VS1_OC_DEG_EN_SHIFT 1
#define PMIC_RG_BUCK_VS1_OC_WND_ADDR MT6356_BUCK_VS1_OC_CFG
#define PMIC_RG_BUCK_VS1_OC_WND_MASK 0x3
#define PMIC_RG_BUCK_VS1_OC_WND_SHIFT 2
#define PMIC_RG_BUCK_VS1_OC_THD_ADDR MT6356_BUCK_VS1_OC_CFG
#define PMIC_RG_BUCK_VS1_OC_THD_MASK 0x3
#define PMIC_RG_BUCK_VS1_OC_THD_SHIFT 6
#define PMIC_DA_VS1_VOSEL_ADDR MT6356_BUCK_VS1_DBG0
#define PMIC_DA_VS1_VOSEL_MASK 0x7F
#define PMIC_DA_VS1_VOSEL_SHIFT 0
#define PMIC_DA_VS1_VOSEL_GRAY_ADDR MT6356_BUCK_VS1_DBG0
#define PMIC_DA_VS1_VOSEL_GRAY_MASK 0x7F
#define PMIC_DA_VS1_VOSEL_GRAY_SHIFT 8
#define PMIC_DA_VS1_EN_ADDR MT6356_BUCK_VS1_DBG1
#define PMIC_DA_VS1_EN_MASK 0x1
#define PMIC_DA_VS1_EN_SHIFT 0
#define PMIC_DA_VS1_STB_ADDR MT6356_BUCK_VS1_DBG1
#define PMIC_DA_VS1_STB_MASK 0x1
#define PMIC_DA_VS1_STB_SHIFT 1
#define PMIC_DA_VS1_VSLEEP_SEL_ADDR MT6356_BUCK_VS1_DBG1
#define PMIC_DA_VS1_VSLEEP_SEL_MASK 0x1
#define PMIC_DA_VS1_VSLEEP_SEL_SHIFT 2
#define PMIC_DA_VS1_R2R_PDN_ADDR MT6356_BUCK_VS1_DBG1
#define PMIC_DA_VS1_R2R_PDN_MASK 0x1
#define PMIC_DA_VS1_R2R_PDN_SHIFT 3
#define PMIC_DA_VS1_DVS_EN_ADDR MT6356_BUCK_VS1_DBG1
#define PMIC_DA_VS1_DVS_EN_MASK 0x1
#define PMIC_DA_VS1_DVS_EN_SHIFT 4
#define PMIC_DA_VS1_MINFREQ_DISCHARGE_ADDR MT6356_BUCK_VS1_DBG1
#define PMIC_DA_VS1_MINFREQ_DISCHARGE_MASK 0x1
#define PMIC_DA_VS1_MINFREQ_DISCHARGE_SHIFT 8
#define PMIC_RG_BUCK_VS1_OC_FLAG_CLR_SEL_ADDR MT6356_BUCK_VS1_DBG2
#define PMIC_RG_BUCK_VS1_OC_FLAG_CLR_SEL_MASK 0x1
#define PMIC_RG_BUCK_VS1_OC_FLAG_CLR_SEL_SHIFT 4
#define PMIC_RG_BUCK_VS1_OSC_SEL_DIS_ADDR MT6356_BUCK_VS1_DBG2
#define PMIC_RG_BUCK_VS1_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_BUCK_VS1_OSC_SEL_DIS_SHIFT 5
#define PMIC_RG_BUCK_VS1_CK_SW_MODE_ADDR MT6356_BUCK_VS1_DBG2
#define PMIC_RG_BUCK_VS1_CK_SW_MODE_MASK 0x1
#define PMIC_RG_BUCK_VS1_CK_SW_MODE_SHIFT 6
#define PMIC_RG_BUCK_VS1_CK_SW_EN_ADDR MT6356_BUCK_VS1_DBG2
#define PMIC_RG_BUCK_VS1_CK_SW_EN_MASK 0x1
#define PMIC_RG_BUCK_VS1_CK_SW_EN_SHIFT 7
#define PMIC_RG_BUCK_VS1_VOTER_EN_ADDR MT6356_BUCK_VS1_VOTER
#define PMIC_RG_BUCK_VS1_VOTER_EN_MASK 0xFF
#define PMIC_RG_BUCK_VS1_VOTER_EN_SHIFT 0
#define PMIC_RG_BUCK_VS1_VOTER_EN_SET_ADDR MT6356_BUCK_VS1_VOTER_SET
#define PMIC_RG_BUCK_VS1_VOTER_EN_SET_MASK 0xFF
#define PMIC_RG_BUCK_VS1_VOTER_EN_SET_SHIFT 0
#define PMIC_RG_BUCK_VS1_VOTER_EN_CLR_ADDR MT6356_BUCK_VS1_VOTER_CLR
#define PMIC_RG_BUCK_VS1_VOTER_EN_CLR_MASK 0xFF
#define PMIC_RG_BUCK_VS1_VOTER_EN_CLR_SHIFT 0
#define PMIC_RG_BUCK_VS1_VOTER_VOSEL_ADDR MT6356_BUCK_VS1_VOTER_CFG
#define PMIC_RG_BUCK_VS1_VOTER_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VS1_VOTER_VOSEL_SHIFT 0
#define PMIC_BUCK_VS1_ELR_LEN_ADDR MT6356_BUCK_VS1_ELR_NUM
#define PMIC_BUCK_VS1_ELR_LEN_MASK 0xFF
#define PMIC_BUCK_VS1_ELR_LEN_SHIFT 0
#define PMIC_RG_BUCK_VS1_VOSEL_ADDR MT6356_BUCK_VS1_ELR0
#define PMIC_RG_BUCK_VS1_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VS1_VOSEL_SHIFT 0
#define PMIC_BUCK_VS2_ANA_ID_ADDR MT6356_BUCK_VS2_DSN_ID
#define PMIC_BUCK_VS2_ANA_ID_MASK 0xFF
#define PMIC_BUCK_VS2_ANA_ID_SHIFT 0
#define PMIC_BUCK_VS2_DIG_ID_ADDR MT6356_BUCK_VS2_DSN_ID
#define PMIC_BUCK_VS2_DIG_ID_MASK 0xFF
#define PMIC_BUCK_VS2_DIG_ID_SHIFT 8
#define PMIC_BUCK_VS2_ANA_MINOR_REV_ADDR MT6356_BUCK_VS2_DSN_REV0
#define PMIC_BUCK_VS2_ANA_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VS2_ANA_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VS2_ANA_MAJOR_REV_ADDR MT6356_BUCK_VS2_DSN_REV0
#define PMIC_BUCK_VS2_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VS2_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VS2_DIG_MINOR_REV_ADDR MT6356_BUCK_VS2_DSN_REV0
#define PMIC_BUCK_VS2_DIG_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VS2_DIG_MINOR_REV_SHIFT 8
#define PMIC_BUCK_VS2_DIG_MAJOR_REV_ADDR MT6356_BUCK_VS2_DSN_REV0
#define PMIC_BUCK_VS2_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VS2_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BUCK_VS2_SW_MINOR_REV_ADDR MT6356_BUCK_VS2_DSN_REV1
#define PMIC_BUCK_VS2_SW_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VS2_SW_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VS2_SW_MAJOR_REV_ADDR MT6356_BUCK_VS2_DSN_REV1
#define PMIC_BUCK_VS2_SW_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VS2_SW_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VS2_ESP_ADDR MT6356_BUCK_VS2_DSN_REV1
#define PMIC_BUCK_VS2_ESP_MASK 0xFF
#define PMIC_BUCK_VS2_ESP_SHIFT 8
#define PMIC_RG_BUCK_VS2_EN_ADDR MT6356_BUCK_VS2_CON0
#define PMIC_RG_BUCK_VS2_EN_MASK 0x1
#define PMIC_RG_BUCK_VS2_EN_SHIFT 0
#define PMIC_RG_BUCK_VS2_LP_ADDR MT6356_BUCK_VS2_CON0
#define PMIC_RG_BUCK_VS2_LP_MASK 0x1
#define PMIC_RG_BUCK_VS2_LP_SHIFT 1
#define PMIC_RG_BUCK_VS2_VOSEL_SLEEP_ADDR MT6356_BUCK_VS2_CON1
#define PMIC_RG_BUCK_VS2_VOSEL_SLEEP_MASK 0x7F
#define PMIC_RG_BUCK_VS2_VOSEL_SLEEP_SHIFT 0
#define PMIC_RG_BUCK_VS2_SFCHG_FRATE_ADDR MT6356_BUCK_VS2_CFG0
#define PMIC_RG_BUCK_VS2_SFCHG_FRATE_MASK 0x7F
#define PMIC_RG_BUCK_VS2_SFCHG_FRATE_SHIFT 0
#define PMIC_RG_BUCK_VS2_SFCHG_FEN_ADDR MT6356_BUCK_VS2_CFG0
#define PMIC_RG_BUCK_VS2_SFCHG_FEN_MASK 0x1
#define PMIC_RG_BUCK_VS2_SFCHG_FEN_SHIFT 7
#define PMIC_RG_BUCK_VS2_SFCHG_RRATE_ADDR MT6356_BUCK_VS2_CFG0
#define PMIC_RG_BUCK_VS2_SFCHG_RRATE_MASK 0x7F
#define PMIC_RG_BUCK_VS2_SFCHG_RRATE_SHIFT 8
#define PMIC_RG_BUCK_VS2_SFCHG_REN_ADDR MT6356_BUCK_VS2_CFG0
#define PMIC_RG_BUCK_VS2_SFCHG_REN_MASK 0x1
#define PMIC_RG_BUCK_VS2_SFCHG_REN_SHIFT 15
#define PMIC_RG_BUCK_VS2_DVS_EN_TD_ADDR MT6356_BUCK_VS2_CFG1
#define PMIC_RG_BUCK_VS2_DVS_EN_TD_MASK 0x3
#define PMIC_RG_BUCK_VS2_DVS_EN_TD_SHIFT 0
#define PMIC_RG_BUCK_VS2_DVS_EN_CTRL_ADDR MT6356_BUCK_VS2_CFG1
#define PMIC_RG_BUCK_VS2_DVS_EN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VS2_DVS_EN_CTRL_SHIFT 4
#define PMIC_RG_BUCK_VS2_DVS_EN_ONCE_ADDR MT6356_BUCK_VS2_CFG1
#define PMIC_RG_BUCK_VS2_DVS_EN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VS2_DVS_EN_ONCE_SHIFT 6
#define PMIC_RG_BUCK_VS2_DVS_DOWN_TD_ADDR MT6356_BUCK_VS2_CFG1
#define PMIC_RG_BUCK_VS2_DVS_DOWN_TD_MASK 0x3
#define PMIC_RG_BUCK_VS2_DVS_DOWN_TD_SHIFT 8
#define PMIC_RG_BUCK_VS2_DVS_DOWN_CTRL_ADDR MT6356_BUCK_VS2_CFG1
#define PMIC_RG_BUCK_VS2_DVS_DOWN_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VS2_DVS_DOWN_CTRL_SHIFT 12
#define PMIC_RG_BUCK_VS2_DVS_DOWN_ONCE_ADDR MT6356_BUCK_VS2_CFG1
#define PMIC_RG_BUCK_VS2_DVS_DOWN_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VS2_DVS_DOWN_ONCE_SHIFT 14
#define PMIC_RG_BUCK_VS2_SW_OP_EN_ADDR MT6356_BUCK_VS2_OP_EN
#define PMIC_RG_BUCK_VS2_SW_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VS2_SW_OP_EN_SHIFT 0
#define PMIC_RG_BUCK_VS2_HW0_OP_EN_ADDR MT6356_BUCK_VS2_OP_EN
#define PMIC_RG_BUCK_VS2_HW0_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VS2_HW0_OP_EN_SHIFT 1
#define PMIC_RG_BUCK_VS2_HW1_OP_EN_ADDR MT6356_BUCK_VS2_OP_EN
#define PMIC_RG_BUCK_VS2_HW1_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VS2_HW1_OP_EN_SHIFT 2
#define PMIC_RG_BUCK_VS2_HW2_OP_EN_ADDR MT6356_BUCK_VS2_OP_EN
#define PMIC_RG_BUCK_VS2_HW2_OP_EN_MASK 0x1
#define PMIC_RG_BUCK_VS2_HW2_OP_EN_SHIFT 3
#define PMIC_RG_BUCK_VS2_OP_EN_SET_ADDR MT6356_BUCK_VS2_OP_EN_SET
#define PMIC_RG_BUCK_VS2_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VS2_OP_EN_SET_SHIFT 0
#define PMIC_RG_BUCK_VS2_OP_EN_CLR_ADDR MT6356_BUCK_VS2_OP_EN_CLR
#define PMIC_RG_BUCK_VS2_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VS2_OP_EN_CLR_SHIFT 0
#define PMIC_RG_BUCK_VS2_HW0_OP_CFG_ADDR MT6356_BUCK_VS2_OP_CFG
#define PMIC_RG_BUCK_VS2_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VS2_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_BUCK_VS2_HW1_OP_CFG_ADDR MT6356_BUCK_VS2_OP_CFG
#define PMIC_RG_BUCK_VS2_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VS2_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_BUCK_VS2_HW2_OP_CFG_ADDR MT6356_BUCK_VS2_OP_CFG
#define PMIC_RG_BUCK_VS2_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_BUCK_VS2_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_BUCK_VS2_ON_OP_ADDR MT6356_BUCK_VS2_OP_CFG
#define PMIC_RG_BUCK_VS2_ON_OP_MASK 0x1
#define PMIC_RG_BUCK_VS2_ON_OP_SHIFT 8
#define PMIC_RG_BUCK_VS2_LP_OP_ADDR MT6356_BUCK_VS2_OP_CFG
#define PMIC_RG_BUCK_VS2_LP_OP_MASK 0x1
#define PMIC_RG_BUCK_VS2_LP_OP_SHIFT 9
#define PMIC_RG_BUCK_VS2_OP_CFG_SET_ADDR MT6356_BUCK_VS2_OP_CFG_SET
#define PMIC_RG_BUCK_VS2_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_BUCK_VS2_OP_CFG_SET_SHIFT 0
#define PMIC_RG_BUCK_VS2_OP_CFG_CLR_ADDR MT6356_BUCK_VS2_OP_CFG_CLR
#define PMIC_RG_BUCK_VS2_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_BUCK_VS2_OP_CFG_CLR_SHIFT 0
#define PMIC_RG_BUCK_VS2_SP_SW_VOSEL_ADDR MT6356_BUCK_VS2_SP_CON
#define PMIC_RG_BUCK_VS2_SP_SW_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VS2_SP_SW_VOSEL_SHIFT 0
#define PMIC_RG_BUCK_VS2_SP_SW_VOSEL_EN_ADDR MT6356_BUCK_VS2_SP_CFG
#define PMIC_RG_BUCK_VS2_SP_SW_VOSEL_EN_MASK 0x1
#define PMIC_RG_BUCK_VS2_SP_SW_VOSEL_EN_SHIFT 0
#define PMIC_RG_BUCK_VS2_SP_ON_VOSEL_MUX_SEL_ADDR MT6356_BUCK_VS2_SP_CFG
#define PMIC_RG_BUCK_VS2_SP_ON_VOSEL_MUX_SEL_MASK 0x1
#define PMIC_RG_BUCK_VS2_SP_ON_VOSEL_MUX_SEL_SHIFT 1
#define PMIC_RG_BUCK_VS2_OC_DEG_EN_ADDR MT6356_BUCK_VS2_OC_CFG
#define PMIC_RG_BUCK_VS2_OC_DEG_EN_MASK 0x1
#define PMIC_RG_BUCK_VS2_OC_DEG_EN_SHIFT 1
#define PMIC_RG_BUCK_VS2_OC_WND_ADDR MT6356_BUCK_VS2_OC_CFG
#define PMIC_RG_BUCK_VS2_OC_WND_MASK 0x3
#define PMIC_RG_BUCK_VS2_OC_WND_SHIFT 2
#define PMIC_RG_BUCK_VS2_OC_THD_ADDR MT6356_BUCK_VS2_OC_CFG
#define PMIC_RG_BUCK_VS2_OC_THD_MASK 0x3
#define PMIC_RG_BUCK_VS2_OC_THD_SHIFT 6
#define PMIC_DA_VS2_VOSEL_ADDR MT6356_BUCK_VS2_DBG0
#define PMIC_DA_VS2_VOSEL_MASK 0x7F
#define PMIC_DA_VS2_VOSEL_SHIFT 0
#define PMIC_DA_VS2_VOSEL_GRAY_ADDR MT6356_BUCK_VS2_DBG0
#define PMIC_DA_VS2_VOSEL_GRAY_MASK 0x7F
#define PMIC_DA_VS2_VOSEL_GRAY_SHIFT 8
#define PMIC_DA_VS2_EN_ADDR MT6356_BUCK_VS2_DBG1
#define PMIC_DA_VS2_EN_MASK 0x1
#define PMIC_DA_VS2_EN_SHIFT 0
#define PMIC_DA_VS2_STB_ADDR MT6356_BUCK_VS2_DBG1
#define PMIC_DA_VS2_STB_MASK 0x1
#define PMIC_DA_VS2_STB_SHIFT 1
#define PMIC_DA_VS2_VSLEEP_SEL_ADDR MT6356_BUCK_VS2_DBG1
#define PMIC_DA_VS2_VSLEEP_SEL_MASK 0x1
#define PMIC_DA_VS2_VSLEEP_SEL_SHIFT 2
#define PMIC_DA_VS2_R2R_PDN_ADDR MT6356_BUCK_VS2_DBG1
#define PMIC_DA_VS2_R2R_PDN_MASK 0x1
#define PMIC_DA_VS2_R2R_PDN_SHIFT 3
#define PMIC_DA_VS2_DVS_EN_ADDR MT6356_BUCK_VS2_DBG1
#define PMIC_DA_VS2_DVS_EN_MASK 0x1
#define PMIC_DA_VS2_DVS_EN_SHIFT 4
#define PMIC_DA_VS2_MINFREQ_DISCHARGE_ADDR MT6356_BUCK_VS2_DBG1
#define PMIC_DA_VS2_MINFREQ_DISCHARGE_MASK 0x1
#define PMIC_DA_VS2_MINFREQ_DISCHARGE_SHIFT 8
#define PMIC_RG_BUCK_VS2_OC_FLAG_CLR_SEL_ADDR MT6356_BUCK_VS2_DBG2
#define PMIC_RG_BUCK_VS2_OC_FLAG_CLR_SEL_MASK 0x1
#define PMIC_RG_BUCK_VS2_OC_FLAG_CLR_SEL_SHIFT 4
#define PMIC_RG_BUCK_VS2_OSC_SEL_DIS_ADDR MT6356_BUCK_VS2_DBG2
#define PMIC_RG_BUCK_VS2_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_BUCK_VS2_OSC_SEL_DIS_SHIFT 5
#define PMIC_RG_BUCK_VS2_CK_SW_MODE_ADDR MT6356_BUCK_VS2_DBG2
#define PMIC_RG_BUCK_VS2_CK_SW_MODE_MASK 0x1
#define PMIC_RG_BUCK_VS2_CK_SW_MODE_SHIFT 6
#define PMIC_RG_BUCK_VS2_CK_SW_EN_ADDR MT6356_BUCK_VS2_DBG2
#define PMIC_RG_BUCK_VS2_CK_SW_EN_MASK 0x1
#define PMIC_RG_BUCK_VS2_CK_SW_EN_SHIFT 7
#define PMIC_RG_BUCK_VS2_VOTER_EN_ADDR MT6356_BUCK_VS2_VOTER
#define PMIC_RG_BUCK_VS2_VOTER_EN_MASK 0xFF
#define PMIC_RG_BUCK_VS2_VOTER_EN_SHIFT 0
#define PMIC_RG_BUCK_VS2_VOTER_EN_SET_ADDR MT6356_BUCK_VS2_VOTER_SET
#define PMIC_RG_BUCK_VS2_VOTER_EN_SET_MASK 0xFF
#define PMIC_RG_BUCK_VS2_VOTER_EN_SET_SHIFT 0
#define PMIC_RG_BUCK_VS2_VOTER_EN_CLR_ADDR MT6356_BUCK_VS2_VOTER_CLR
#define PMIC_RG_BUCK_VS2_VOTER_EN_CLR_MASK 0xFF
#define PMIC_RG_BUCK_VS2_VOTER_EN_CLR_SHIFT 0
#define PMIC_RG_BUCK_VS2_VOTER_VOSEL_ADDR MT6356_BUCK_VS2_VOTER_CFG
#define PMIC_RG_BUCK_VS2_VOTER_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VS2_VOTER_VOSEL_SHIFT 0
#define PMIC_BUCK_VS2_ELR_LEN_ADDR MT6356_BUCK_VS2_ELR_NUM
#define PMIC_BUCK_VS2_ELR_LEN_MASK 0xFF
#define PMIC_BUCK_VS2_ELR_LEN_SHIFT 0
#define PMIC_RG_BUCK_VS2_VOSEL_ADDR MT6356_BUCK_VS2_ELR0
#define PMIC_RG_BUCK_VS2_VOSEL_MASK 0x7F
#define PMIC_RG_BUCK_VS2_VOSEL_SHIFT 0
#define PMIC_BUCK_VPA_ANA_ID_ADDR MT6356_BUCK_VPA_DSN_ID
#define PMIC_BUCK_VPA_ANA_ID_MASK 0xFF
#define PMIC_BUCK_VPA_ANA_ID_SHIFT 0
#define PMIC_BUCK_VPA_DIG_ID_ADDR MT6356_BUCK_VPA_DSN_ID
#define PMIC_BUCK_VPA_DIG_ID_MASK 0xFF
#define PMIC_BUCK_VPA_DIG_ID_SHIFT 8
#define PMIC_BUCK_VPA_ANA_MINOR_REV_ADDR MT6356_BUCK_VPA_DSN_REV0
#define PMIC_BUCK_VPA_ANA_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VPA_ANA_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VPA_ANA_MAJOR_REV_ADDR MT6356_BUCK_VPA_DSN_REV0
#define PMIC_BUCK_VPA_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VPA_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VPA_DIG_MINOR_REV_ADDR MT6356_BUCK_VPA_DSN_REV0
#define PMIC_BUCK_VPA_DIG_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VPA_DIG_MINOR_REV_SHIFT 8
#define PMIC_BUCK_VPA_DIG_MAJOR_REV_ADDR MT6356_BUCK_VPA_DSN_REV0
#define PMIC_BUCK_VPA_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VPA_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BUCK_VPA_SW_MINOR_REV_ADDR MT6356_BUCK_VPA_DSN_REV1
#define PMIC_BUCK_VPA_SW_MINOR_REV_MASK 0xF
#define PMIC_BUCK_VPA_SW_MINOR_REV_SHIFT 0
#define PMIC_BUCK_VPA_SW_MAJOR_REV_ADDR MT6356_BUCK_VPA_DSN_REV1
#define PMIC_BUCK_VPA_SW_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_VPA_SW_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_VPA_ESP_ADDR MT6356_BUCK_VPA_DSN_REV1
#define PMIC_BUCK_VPA_ESP_MASK 0xFF
#define PMIC_BUCK_VPA_ESP_SHIFT 8
#define PMIC_RG_BUCK_VPA_EN_ADDR MT6356_BUCK_VPA_CON0
#define PMIC_RG_BUCK_VPA_EN_MASK 0x1
#define PMIC_RG_BUCK_VPA_EN_SHIFT 0
#define PMIC_RG_BUCK_VPA_VOSEL_ADDR MT6356_BUCK_VPA_CON1
#define PMIC_RG_BUCK_VPA_VOSEL_MASK 0x3F
#define PMIC_RG_BUCK_VPA_VOSEL_SHIFT 0
#define PMIC_RG_BUCK_VPA_SFCHG_FRATE_ADDR MT6356_BUCK_VPA_CFG0
#define PMIC_RG_BUCK_VPA_SFCHG_FRATE_MASK 0x7F
#define PMIC_RG_BUCK_VPA_SFCHG_FRATE_SHIFT 0
#define PMIC_RG_BUCK_VPA_SFCHG_FEN_ADDR MT6356_BUCK_VPA_CFG0
#define PMIC_RG_BUCK_VPA_SFCHG_FEN_MASK 0x1
#define PMIC_RG_BUCK_VPA_SFCHG_FEN_SHIFT 7
#define PMIC_RG_BUCK_VPA_SFCHG_RRATE_ADDR MT6356_BUCK_VPA_CFG0
#define PMIC_RG_BUCK_VPA_SFCHG_RRATE_MASK 0x7F
#define PMIC_RG_BUCK_VPA_SFCHG_RRATE_SHIFT 8
#define PMIC_RG_BUCK_VPA_SFCHG_REN_ADDR MT6356_BUCK_VPA_CFG0
#define PMIC_RG_BUCK_VPA_SFCHG_REN_MASK 0x1
#define PMIC_RG_BUCK_VPA_SFCHG_REN_SHIFT 15
#define PMIC_RG_BUCK_VPA_DVS_TRANST_TD_ADDR MT6356_BUCK_VPA_CFG1
#define PMIC_RG_BUCK_VPA_DVS_TRANST_TD_MASK 0x3
#define PMIC_RG_BUCK_VPA_DVS_TRANST_TD_SHIFT 0
#define PMIC_RG_BUCK_VPA_DVS_TRANST_CTRL_ADDR MT6356_BUCK_VPA_CFG1
#define PMIC_RG_BUCK_VPA_DVS_TRANST_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VPA_DVS_TRANST_CTRL_SHIFT 4
#define PMIC_RG_BUCK_VPA_DVS_TRANST_ONCE_ADDR MT6356_BUCK_VPA_CFG1
#define PMIC_RG_BUCK_VPA_DVS_TRANST_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VPA_DVS_TRANST_ONCE_SHIFT 6
#define PMIC_RG_BUCK_VPA_DVS_BW_TD_ADDR MT6356_BUCK_VPA_CFG1
#define PMIC_RG_BUCK_VPA_DVS_BW_TD_MASK 0x3
#define PMIC_RG_BUCK_VPA_DVS_BW_TD_SHIFT 8
#define PMIC_RG_BUCK_VPA_DVS_BW_CTRL_ADDR MT6356_BUCK_VPA_CFG1
#define PMIC_RG_BUCK_VPA_DVS_BW_CTRL_MASK 0x3
#define PMIC_RG_BUCK_VPA_DVS_BW_CTRL_SHIFT 12
#define PMIC_RG_BUCK_VPA_DVS_BW_ONCE_ADDR MT6356_BUCK_VPA_CFG1
#define PMIC_RG_BUCK_VPA_DVS_BW_ONCE_MASK 0x1
#define PMIC_RG_BUCK_VPA_DVS_BW_ONCE_SHIFT 14
#define PMIC_RG_BUCK_VPA_OC_DEG_EN_ADDR MT6356_BUCK_VPA_OC_CFG
#define PMIC_RG_BUCK_VPA_OC_DEG_EN_MASK 0x1
#define PMIC_RG_BUCK_VPA_OC_DEG_EN_SHIFT 1
#define PMIC_RG_BUCK_VPA_OC_WND_ADDR MT6356_BUCK_VPA_OC_CFG
#define PMIC_RG_BUCK_VPA_OC_WND_MASK 0x3
#define PMIC_RG_BUCK_VPA_OC_WND_SHIFT 2
#define PMIC_RG_BUCK_VPA_OC_THD_ADDR MT6356_BUCK_VPA_OC_CFG
#define PMIC_RG_BUCK_VPA_OC_THD_MASK 0x3
#define PMIC_RG_BUCK_VPA_OC_THD_SHIFT 6
#define PMIC_DA_VPA_VOSEL_ADDR MT6356_BUCK_VPA_DBG0
#define PMIC_DA_VPA_VOSEL_MASK 0x3F
#define PMIC_DA_VPA_VOSEL_SHIFT 0
#define PMIC_DA_VPA_VOSEL_GRAY_ADDR MT6356_BUCK_VPA_DBG0
#define PMIC_DA_VPA_VOSEL_GRAY_MASK 0x3F
#define PMIC_DA_VPA_VOSEL_GRAY_SHIFT 8
#define PMIC_DA_VPA_EN_ADDR MT6356_BUCK_VPA_DBG1
#define PMIC_DA_VPA_EN_MASK 0x1
#define PMIC_DA_VPA_EN_SHIFT 0
#define PMIC_DA_VPA_STB_ADDR MT6356_BUCK_VPA_DBG1
#define PMIC_DA_VPA_STB_MASK 0x1
#define PMIC_DA_VPA_STB_SHIFT 1
#define PMIC_DA_VPA_DVS_TRANST_ADDR MT6356_BUCK_VPA_DBG1
#define PMIC_DA_VPA_DVS_TRANST_MASK 0x1
#define PMIC_DA_VPA_DVS_TRANST_SHIFT 5
#define PMIC_DA_VPA_DVS_BW_ADDR MT6356_BUCK_VPA_DBG1
#define PMIC_DA_VPA_DVS_BW_MASK 0x1
#define PMIC_DA_VPA_DVS_BW_SHIFT 6
#define PMIC_RG_BUCK_VPA_OC_FLAG_CLR_SEL_ADDR MT6356_BUCK_VPA_DBG2
#define PMIC_RG_BUCK_VPA_OC_FLAG_CLR_SEL_MASK 0x1
#define PMIC_RG_BUCK_VPA_OC_FLAG_CLR_SEL_SHIFT 4
#define PMIC_RG_BUCK_VPA_OSC_SEL_DIS_ADDR MT6356_BUCK_VPA_DBG2
#define PMIC_RG_BUCK_VPA_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_BUCK_VPA_OSC_SEL_DIS_SHIFT 5
#define PMIC_RG_BUCK_VPA_CK_SW_MODE_ADDR MT6356_BUCK_VPA_DBG2
#define PMIC_RG_BUCK_VPA_CK_SW_MODE_MASK 0x1
#define PMIC_RG_BUCK_VPA_CK_SW_MODE_SHIFT 6
#define PMIC_RG_BUCK_VPA_CK_SW_EN_ADDR MT6356_BUCK_VPA_DBG2
#define PMIC_RG_BUCK_VPA_CK_SW_EN_MASK 0x1
#define PMIC_RG_BUCK_VPA_CK_SW_EN_SHIFT 7
#define PMIC_RG_BUCK_VPA_VOSEL_DLC011_ADDR MT6356_BUCK_VPA_DLC_CON0
#define PMIC_RG_BUCK_VPA_VOSEL_DLC011_MASK 0x3F
#define PMIC_RG_BUCK_VPA_VOSEL_DLC011_SHIFT 0
#define PMIC_RG_BUCK_VPA_VOSEL_DLC111_ADDR MT6356_BUCK_VPA_DLC_CON0
#define PMIC_RG_BUCK_VPA_VOSEL_DLC111_MASK 0x3F
#define PMIC_RG_BUCK_VPA_VOSEL_DLC111_SHIFT 8
#define PMIC_RG_BUCK_VPA_VOSEL_DLC001_ADDR MT6356_BUCK_VPA_DLC_CON1
#define PMIC_RG_BUCK_VPA_VOSEL_DLC001_MASK 0x3F
#define PMIC_RG_BUCK_VPA_VOSEL_DLC001_SHIFT 8
#define PMIC_RG_BUCK_VPA_DLC_MAP_EN_ADDR MT6356_BUCK_VPA_DLC_CON2
#define PMIC_RG_BUCK_VPA_DLC_MAP_EN_MASK 0x1
#define PMIC_RG_BUCK_VPA_DLC_MAP_EN_SHIFT 0
#define PMIC_RG_BUCK_VPA_DLC_ADDR MT6356_BUCK_VPA_DLC_CON2
#define PMIC_RG_BUCK_VPA_DLC_MASK 0x7
#define PMIC_RG_BUCK_VPA_DLC_SHIFT 8
#define PMIC_DA_VPA_DLC_ADDR MT6356_BUCK_VPA_DLC_CON2
#define PMIC_DA_VPA_DLC_MASK 0x7
#define PMIC_DA_VPA_DLC_SHIFT 12
#define PMIC_RG_BUCK_VPA_MSFG_EN_ADDR MT6356_BUCK_VPA_MSFG_CON0
#define PMIC_RG_BUCK_VPA_MSFG_EN_MASK 0x1
#define PMIC_RG_BUCK_VPA_MSFG_EN_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_RDELTA2GO_ADDR MT6356_BUCK_VPA_MSFG_CON1
#define PMIC_RG_BUCK_VPA_MSFG_RDELTA2GO_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RDELTA2GO_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_FDELTA2GO_ADDR MT6356_BUCK_VPA_MSFG_CON1
#define PMIC_RG_BUCK_VPA_MSFG_FDELTA2GO_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FDELTA2GO_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_RRATE0_ADDR MT6356_BUCK_VPA_MSFG_RRATE0
#define PMIC_RG_BUCK_VPA_MSFG_RRATE0_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RRATE0_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_RRATE1_ADDR MT6356_BUCK_VPA_MSFG_RRATE0
#define PMIC_RG_BUCK_VPA_MSFG_RRATE1_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RRATE1_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_RRATE2_ADDR MT6356_BUCK_VPA_MSFG_RRATE1
#define PMIC_RG_BUCK_VPA_MSFG_RRATE2_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RRATE2_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_RRATE3_ADDR MT6356_BUCK_VPA_MSFG_RRATE1
#define PMIC_RG_BUCK_VPA_MSFG_RRATE3_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RRATE3_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_RRATE4_ADDR MT6356_BUCK_VPA_MSFG_RRATE2
#define PMIC_RG_BUCK_VPA_MSFG_RRATE4_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RRATE4_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_RRATE5_ADDR MT6356_BUCK_VPA_MSFG_RRATE2
#define PMIC_RG_BUCK_VPA_MSFG_RRATE5_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RRATE5_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_RTHD0_ADDR MT6356_BUCK_VPA_MSFG_RTHD0
#define PMIC_RG_BUCK_VPA_MSFG_RTHD0_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RTHD0_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_RTHD1_ADDR MT6356_BUCK_VPA_MSFG_RTHD0
#define PMIC_RG_BUCK_VPA_MSFG_RTHD1_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RTHD1_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_RTHD2_ADDR MT6356_BUCK_VPA_MSFG_RTHD1
#define PMIC_RG_BUCK_VPA_MSFG_RTHD2_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RTHD2_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_RTHD3_ADDR MT6356_BUCK_VPA_MSFG_RTHD1
#define PMIC_RG_BUCK_VPA_MSFG_RTHD3_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RTHD3_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_RTHD4_ADDR MT6356_BUCK_VPA_MSFG_RTHD2
#define PMIC_RG_BUCK_VPA_MSFG_RTHD4_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_RTHD4_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_FRATE0_ADDR MT6356_BUCK_VPA_MSFG_FRATE0
#define PMIC_RG_BUCK_VPA_MSFG_FRATE0_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FRATE0_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_FRATE1_ADDR MT6356_BUCK_VPA_MSFG_FRATE0
#define PMIC_RG_BUCK_VPA_MSFG_FRATE1_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FRATE1_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_FRATE2_ADDR MT6356_BUCK_VPA_MSFG_FRATE1
#define PMIC_RG_BUCK_VPA_MSFG_FRATE2_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FRATE2_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_FRATE3_ADDR MT6356_BUCK_VPA_MSFG_FRATE1
#define PMIC_RG_BUCK_VPA_MSFG_FRATE3_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FRATE3_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_FRATE4_ADDR MT6356_BUCK_VPA_MSFG_FRATE2
#define PMIC_RG_BUCK_VPA_MSFG_FRATE4_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FRATE4_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_FRATE5_ADDR MT6356_BUCK_VPA_MSFG_FRATE2
#define PMIC_RG_BUCK_VPA_MSFG_FRATE5_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FRATE5_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_FTHD0_ADDR MT6356_BUCK_VPA_MSFG_FTHD0
#define PMIC_RG_BUCK_VPA_MSFG_FTHD0_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FTHD0_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_FTHD1_ADDR MT6356_BUCK_VPA_MSFG_FTHD0
#define PMIC_RG_BUCK_VPA_MSFG_FTHD1_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FTHD1_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_FTHD2_ADDR MT6356_BUCK_VPA_MSFG_FTHD1
#define PMIC_RG_BUCK_VPA_MSFG_FTHD2_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FTHD2_SHIFT 0
#define PMIC_RG_BUCK_VPA_MSFG_FTHD3_ADDR MT6356_BUCK_VPA_MSFG_FTHD1
#define PMIC_RG_BUCK_VPA_MSFG_FTHD3_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FTHD3_SHIFT 8
#define PMIC_RG_BUCK_VPA_MSFG_FTHD4_ADDR MT6356_BUCK_VPA_MSFG_FTHD2
#define PMIC_RG_BUCK_VPA_MSFG_FTHD4_MASK 0x3F
#define PMIC_RG_BUCK_VPA_MSFG_FTHD4_SHIFT 0
#define PMIC_BUCK_ANA_ANA_ID_ADDR MT6356_BUCK_ANA_DSN_ID
#define PMIC_BUCK_ANA_ANA_ID_MASK 0xFF
#define PMIC_BUCK_ANA_ANA_ID_SHIFT 0
#define PMIC_BUCK_ANA_DIG_ID_ADDR MT6356_BUCK_ANA_DSN_ID
#define PMIC_BUCK_ANA_DIG_ID_MASK 0xFF
#define PMIC_BUCK_ANA_DIG_ID_SHIFT 8
#define PMIC_BUCK_ANA_ANA_MINOR_REV_ADDR MT6356_BUCK_ANA_DSN_REV0
#define PMIC_BUCK_ANA_ANA_MINOR_REV_MASK 0xF
#define PMIC_BUCK_ANA_ANA_MINOR_REV_SHIFT 0
#define PMIC_BUCK_ANA_ANA_MAJOR_REV_ADDR MT6356_BUCK_ANA_DSN_REV0
#define PMIC_BUCK_ANA_ANA_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_ANA_ANA_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_ANA_DIG_MINOR_REV_ADDR MT6356_BUCK_ANA_DSN_REV0
#define PMIC_BUCK_ANA_DIG_MINOR_REV_MASK 0xF
#define PMIC_BUCK_ANA_DIG_MINOR_REV_SHIFT 8
#define PMIC_BUCK_ANA_DIG_MAJOR_REV_ADDR MT6356_BUCK_ANA_DSN_REV0
#define PMIC_BUCK_ANA_DIG_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_ANA_DIG_MAJOR_REV_SHIFT 12
#define PMIC_BUCK_ANA_SW_MINOR_REV_ADDR MT6356_BUCK_ANA_DSN_REV1
#define PMIC_BUCK_ANA_SW_MINOR_REV_MASK 0xF
#define PMIC_BUCK_ANA_SW_MINOR_REV_SHIFT 0
#define PMIC_BUCK_ANA_SW_MAJOR_REV_ADDR MT6356_BUCK_ANA_DSN_REV1
#define PMIC_BUCK_ANA_SW_MAJOR_REV_MASK 0xF
#define PMIC_BUCK_ANA_SW_MAJOR_REV_SHIFT 4
#define PMIC_BUCK_ANA_ESP_ADDR MT6356_BUCK_ANA_DSN_REV1
#define PMIC_BUCK_ANA_ESP_MASK 0xFF
#define PMIC_BUCK_ANA_ESP_SHIFT 8
#define PMIC_RG_SMPS_TESTMODE_B_ADDR MT6356_SMPS_ANA_CON0
#define PMIC_RG_SMPS_TESTMODE_B_MASK 0xFFF
#define PMIC_RG_SMPS_TESTMODE_B_SHIFT 0
#define PMIC_RG_VPA_BURSTH_ADDR MT6356_SMPS_ANA_CON0
#define PMIC_RG_VPA_BURSTH_MASK 0x3
#define PMIC_RG_VPA_BURSTH_SHIFT 12
#define PMIC_RG_VPA_BURSTL_ADDR MT6356_SMPS_ANA_CON0
#define PMIC_RG_VPA_BURSTL_MASK 0x3
#define PMIC_RG_VPA_BURSTL_SHIFT 14
#define PMIC_RG_VCORE_TRIML_ADDR MT6356_SMPS_ANA_CON1
#define PMIC_RG_VCORE_TRIML_MASK 0x1F
#define PMIC_RG_VCORE_TRIML_SHIFT 0
#define PMIC_RG_VCORE_SLEEP_VOLTAGE_ADDR MT6356_SMPS_ANA_CON1
#define PMIC_RG_VCORE_SLEEP_VOLTAGE_MASK 0x7
#define PMIC_RG_VCORE_SLEEP_VOLTAGE_SHIFT 5
#define PMIC_RG_VMODEM_SLEEP_VOLTAGE_ADDR MT6356_SMPS_ANA_CON1
#define PMIC_RG_VMODEM_SLEEP_VOLTAGE_MASK 0x7
#define PMIC_RG_VMODEM_SLEEP_VOLTAGE_SHIFT 8
#define PMIC_RG_VPROC_TRIML_ADDR MT6356_SMPS_ANA_CON1
#define PMIC_RG_VPROC_TRIML_MASK 0x1F
#define PMIC_RG_VPROC_TRIML_SHIFT 11
#define PMIC_RG_VPROC_SLEEP_VOLTAGE_ADDR MT6356_SMPS_ANA_CON2
#define PMIC_RG_VPROC_SLEEP_VOLTAGE_MASK 0x7
#define PMIC_RG_VPROC_SLEEP_VOLTAGE_SHIFT 0
#define PMIC_RG_VS1_SLEEP_VOLTAGE_ADDR MT6356_SMPS_ANA_CON2
#define PMIC_RG_VS1_SLEEP_VOLTAGE_MASK 0x3
#define PMIC_RG_VS1_SLEEP_VOLTAGE_SHIFT 3
#define PMIC_RG_VS2_SLEEP_VOLTAGE_ADDR MT6356_SMPS_ANA_CON2
#define PMIC_RG_VS2_SLEEP_VOLTAGE_MASK 0x3
#define PMIC_RG_VS2_SLEEP_VOLTAGE_SHIFT 5
#define PMIC_RG_VSRAM_PROC_SLEEP_VOLTAGE_ADDR MT6356_SMPS_ANA_CON2
#define PMIC_RG_VSRAM_PROC_SLEEP_VOLTAGE_MASK 0x7
#define PMIC_RG_VSRAM_PROC_SLEEP_VOLTAGE_SHIFT 7
#define PMIC_RG_VSRAM_GPU_SLEEP_VOLTAGE_ADDR MT6356_SMPS_ANA_CON2
#define PMIC_RG_VSRAM_GPU_SLEEP_VOLTAGE_MASK 0x7
#define PMIC_RG_VSRAM_GPU_SLEEP_VOLTAGE_SHIFT 10
#define PMIC_RG_VSRAM_OTHERS_SLEEP_VOLTAGE_ADDR MT6356_SMPS_ANA_CON2
#define PMIC_RG_VSRAM_OTHERS_SLEEP_VOLTAGE_MASK 0x7
#define PMIC_RG_VSRAM_OTHERS_SLEEP_VOLTAGE_SHIFT 13
#define PMIC_RG_SMPS_IVGD_DET_ADDR MT6356_SMPS_ANA_CON3
#define PMIC_RG_SMPS_IVGD_DET_MASK 0x1
#define PMIC_RG_SMPS_IVGD_DET_SHIFT 0
#define PMIC_RG_AUTOK_RST_ADDR MT6356_SMPS_ANA_CON3
#define PMIC_RG_AUTOK_RST_MASK 0x1
#define PMIC_RG_AUTOK_RST_SHIFT 1
#define PMIC_RG_VCORE_FPWM_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VCORE_FPWM_MASK 0x1
#define PMIC_RG_VCORE_FPWM_SHIFT 1
#define PMIC_RG_VPROC_FPWM_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VPROC_FPWM_MASK 0x1
#define PMIC_RG_VPROC_FPWM_SHIFT 2
#define PMIC_RG_VCORE_NDIS_EN_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VCORE_NDIS_EN_MASK 0x1
#define PMIC_RG_VCORE_NDIS_EN_SHIFT 3
#define PMIC_RG_VPROC_NDIS_EN_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VPROC_NDIS_EN_MASK 0x1
#define PMIC_RG_VPROC_NDIS_EN_SHIFT 4
#define PMIC_RG_VCORE_FCOT_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VCORE_FCOT_MASK 0x1
#define PMIC_RG_VCORE_FCOT_SHIFT 5
#define PMIC_RG_VPROC_FCOT_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VPROC_FCOT_MASK 0x1
#define PMIC_RG_VPROC_FCOT_SHIFT 6
#define PMIC_RG_VCOREVPROC_TMDL_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VCOREVPROC_TMDL_MASK 0x1
#define PMIC_RG_VCOREVPROC_TMDL_SHIFT 7
#define PMIC_RG_VCORE_TBDIS_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VCORE_TBDIS_MASK 0x1
#define PMIC_RG_VCORE_TBDIS_SHIFT 8
#define PMIC_RG_VPROC_TBDIS_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VPROC_TBDIS_MASK 0x1
#define PMIC_RG_VPROC_TBDIS_SHIFT 9
#define PMIC_RG_VCORE_VDIFFOFF_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VCORE_VDIFFOFF_MASK 0x1
#define PMIC_RG_VCORE_VDIFFOFF_SHIFT 10
#define PMIC_RG_VPROC_VDIFFOFF_ADDR MT6356_VCORE_VPROC_ANA_CON0
#define PMIC_RG_VPROC_VDIFFOFF_MASK 0x1
#define PMIC_RG_VPROC_VDIFFOFF_SHIFT 11
#define PMIC_RG_VCORE_RCOMP0_ADDR MT6356_VCORE_VPROC_ANA_CON1
#define PMIC_RG_VCORE_RCOMP0_MASK 0xF
#define PMIC_RG_VCORE_RCOMP0_SHIFT 0
#define PMIC_RG_VCORE_RCOMP1_ADDR MT6356_VCORE_VPROC_ANA_CON1
#define PMIC_RG_VCORE_RCOMP1_MASK 0x7
#define PMIC_RG_VCORE_RCOMP1_SHIFT 4
#define PMIC_RG_VCORE_CCOMP0_ADDR MT6356_VCORE_VPROC_ANA_CON1
#define PMIC_RG_VCORE_CCOMP0_MASK 0x3
#define PMIC_RG_VCORE_CCOMP0_SHIFT 7
#define PMIC_RG_VCORE_CCOMP1_ADDR MT6356_VCORE_VPROC_ANA_CON1
#define PMIC_RG_VCORE_CCOMP1_MASK 0x3
#define PMIC_RG_VCORE_CCOMP1_SHIFT 9
#define PMIC_RG_VCORE_RAMP_SLP_ADDR MT6356_VCORE_VPROC_ANA_CON1
#define PMIC_RG_VCORE_RAMP_SLP_MASK 0x7
#define PMIC_RG_VCORE_RAMP_SLP_SHIFT 11
#define PMIC_RG_VPROC_RCOMP0_ADDR MT6356_VCORE_VPROC_ANA_CON2
#define PMIC_RG_VPROC_RCOMP0_MASK 0xF
#define PMIC_RG_VPROC_RCOMP0_SHIFT 0
#define PMIC_RG_VPROC_RCOMP1_ADDR MT6356_VCORE_VPROC_ANA_CON2
#define PMIC_RG_VPROC_RCOMP1_MASK 0x7
#define PMIC_RG_VPROC_RCOMP1_SHIFT 4
#define PMIC_RG_VPROC_CCOMP0_ADDR MT6356_VCORE_VPROC_ANA_CON2
#define PMIC_RG_VPROC_CCOMP0_MASK 0x3
#define PMIC_RG_VPROC_CCOMP0_SHIFT 7
#define PMIC_RG_VPROC_CCOMP1_ADDR MT6356_VCORE_VPROC_ANA_CON2
#define PMIC_RG_VPROC_CCOMP1_MASK 0x3
#define PMIC_RG_VPROC_CCOMP1_SHIFT 9
#define PMIC_RG_VPROC_RAMP_SLP_ADDR MT6356_VCORE_VPROC_ANA_CON2
#define PMIC_RG_VPROC_RAMP_SLP_MASK 0x7
#define PMIC_RG_VPROC_RAMP_SLP_SHIFT 11
#define PMIC_RG_VCORE_RCS_ADDR MT6356_VCORE_VPROC_ANA_CON3
#define PMIC_RG_VCORE_RCS_MASK 0x7
#define PMIC_RG_VCORE_RCS_SHIFT 0
#define PMIC_RG_VPROC_RCS_ADDR MT6356_VCORE_VPROC_ANA_CON3
#define PMIC_RG_VPROC_RCS_MASK 0x7
#define PMIC_RG_VPROC_RCS_SHIFT 3
#define PMIC_RG_VCORE_RCB_ADDR MT6356_VCORE_VPROC_ANA_CON3
#define PMIC_RG_VCORE_RCB_MASK 0xF
#define PMIC_RG_VCORE_RCB_SHIFT 6
#define PMIC_RG_VPROC_RCB_ADDR MT6356_VCORE_VPROC_ANA_CON3
#define PMIC_RG_VPROC_RCB_MASK 0xF
#define PMIC_RG_VPROC_RCB_SHIFT 10
#define PMIC_RG_VCORE_TB_WIDTH_ADDR MT6356_VCORE_VPROC_ANA_CON4
#define PMIC_RG_VCORE_TB_WIDTH_MASK 0x3
#define PMIC_RG_VCORE_TB_WIDTH_SHIFT 0
#define PMIC_RG_VPROC_TB_WIDTH_ADDR MT6356_VCORE_VPROC_ANA_CON4
#define PMIC_RG_VPROC_TB_WIDTH_MASK 0x3
#define PMIC_RG_VPROC_TB_WIDTH_SHIFT 2
#define PMIC_RG_VCORE_UG_SR_ADDR MT6356_VCORE_VPROC_ANA_CON4
#define PMIC_RG_VCORE_UG_SR_MASK 0x3
#define PMIC_RG_VCORE_UG_SR_SHIFT 4
#define PMIC_RG_VCORE_LG_SR_ADDR MT6356_VCORE_VPROC_ANA_CON4
#define PMIC_RG_VCORE_LG_SR_MASK 0x3
#define PMIC_RG_VCORE_LG_SR_SHIFT 6
#define PMIC_RG_VPROC_UG_SR_ADDR MT6356_VCORE_VPROC_ANA_CON4
#define PMIC_RG_VPROC_UG_SR_MASK 0x3
#define PMIC_RG_VPROC_UG_SR_SHIFT 8
#define PMIC_RG_VPROC_LG_SR_ADDR MT6356_VCORE_VPROC_ANA_CON4
#define PMIC_RG_VPROC_LG_SR_MASK 0x3
#define PMIC_RG_VPROC_LG_SR_SHIFT 10
#define PMIC_RG_VCORE_PFM_TON_ADDR MT6356_VCORE_VPROC_ANA_CON4
#define PMIC_RG_VCORE_PFM_TON_MASK 0x7
#define PMIC_RG_VCORE_PFM_TON_SHIFT 12
#define PMIC_RG_VPROC_PFM_TON_ADDR MT6356_VCORE_VPROC_ANA_CON5
#define PMIC_RG_VPROC_PFM_TON_MASK 0x7
#define PMIC_RG_VPROC_PFM_TON_SHIFT 0
#define PMIC_RGS_VCORE_OC_STATUS_ADDR MT6356_VCORE_VPROC_ANA_CON5
#define PMIC_RGS_VCORE_OC_STATUS_MASK 0x1
#define PMIC_RGS_VCORE_OC_STATUS_SHIFT 3
#define PMIC_RGS_VPROC_OC_STATUS_ADDR MT6356_VCORE_VPROC_ANA_CON5
#define PMIC_RGS_VPROC_OC_STATUS_MASK 0x1
#define PMIC_RGS_VPROC_OC_STATUS_SHIFT 4
#define PMIC_RGS_VCORE_PREOC_STATUS_ADDR MT6356_VCORE_VPROC_ANA_CON5
#define PMIC_RGS_VCORE_PREOC_STATUS_MASK 0x1
#define PMIC_RGS_VCORE_PREOC_STATUS_SHIFT 5
#define PMIC_RGS_VCORE_DIG_MON_ADDR MT6356_VCORE_VPROC_ANA_CON5
#define PMIC_RGS_VCORE_DIG_MON_MASK 0xFF
#define PMIC_RGS_VCORE_DIG_MON_SHIFT 6
#define PMIC_RGS_VPROC_DIG_MON_ADDR MT6356_VCORE_VPROC_ANA_CON6
#define PMIC_RGS_VPROC_DIG_MON_MASK 0xFF
#define PMIC_RGS_VPROC_DIG_MON_SHIFT 0
#define PMIC_RG_VCORE_TRAN_BST_ADDR MT6356_VCORE_VPROC_ANA_CON7
#define PMIC_RG_VCORE_TRAN_BST_MASK 0x3F
#define PMIC_RG_VCORE_TRAN_BST_SHIFT 0
#define PMIC_RG_VPROC_TRAN_BST_ADDR MT6356_VCORE_VPROC_ANA_CON7
#define PMIC_RG_VPROC_TRAN_BST_MASK 0x3F
#define PMIC_RG_VPROC_TRAN_BST_SHIFT 7
#define PMIC_RG_VCORE_COTRAMP_SLP_ADDR MT6356_VCORE_VPROC_ANA_CON7
#define PMIC_RG_VCORE_COTRAMP_SLP_MASK 0x7
#define PMIC_RG_VCORE_COTRAMP_SLP_SHIFT 13
#define PMIC_RG_VPROC_COTRAMP_SLP_ADDR MT6356_VCORE_VPROC_ANA_CON8
#define PMIC_RG_VPROC_COTRAMP_SLP_MASK 0x7
#define PMIC_RG_VPROC_COTRAMP_SLP_SHIFT 0
#define PMIC_RG_VCORE_SLEEP_TIME_ADDR MT6356_VCORE_VPROC_ANA_CON8
#define PMIC_RG_VCORE_SLEEP_TIME_MASK 0x3
#define PMIC_RG_VCORE_SLEEP_TIME_SHIFT 3
#define PMIC_RG_VPROC_SLEEP_TIME_ADDR MT6356_VCORE_VPROC_ANA_CON8
#define PMIC_RG_VPROC_SLEEP_TIME_MASK 0x3
#define PMIC_RG_VPROC_SLEEP_TIME_SHIFT 5
#define PMIC_RG_VCORE_VREFTB_ADDR MT6356_VCORE_VPROC_ANA_CON8
#define PMIC_RG_VCORE_VREFTB_MASK 0x3
#define PMIC_RG_VCORE_VREFTB_SHIFT 7
#define PMIC_RG_VPROC_VREFTB_ADDR MT6356_VCORE_VPROC_ANA_CON8
#define PMIC_RG_VPROC_VREFTB_MASK 0x3
#define PMIC_RG_VPROC_VREFTB_SHIFT 9
#define PMIC_RG_VCORE_FUGON_ADDR MT6356_VCORE_VPROC_ANA_CON8
#define PMIC_RG_VCORE_FUGON_MASK 0x1
#define PMIC_RG_VCORE_FUGON_SHIFT 11
#define PMIC_RG_VPROC_FUGON_ADDR MT6356_VCORE_VPROC_ANA_CON8
#define PMIC_RG_VPROC_FUGON_MASK 0x1
#define PMIC_RG_VPROC_FUGON_SHIFT 12
#define PMIC_RG_VCORE_FLGON_ADDR MT6356_VCORE_VPROC_ANA_CON8
#define PMIC_RG_VCORE_FLGON_MASK 0x1
#define PMIC_RG_VCORE_FLGON_SHIFT 13
#define PMIC_RG_VPROC_FLGON_ADDR MT6356_VCORE_VPROC_ANA_CON8
#define PMIC_RG_VPROC_FLGON_MASK 0x1
#define PMIC_RG_VPROC_FLGON_SHIFT 14
#define PMIC_RG_VCORE_RSV_ADDR MT6356_VCORE_VPROC_ANA_CON9
#define PMIC_RG_VCORE_RSV_MASK 0xFFFF
#define PMIC_RG_VCORE_RSV_SHIFT 0
#define PMIC_RG_VPROC_RSV_ADDR MT6356_VCORE_VPROC_ANA_CON10
#define PMIC_RG_VPROC_RSV_MASK 0xFFFF
#define PMIC_RG_VPROC_RSV_SHIFT 0
#define PMIC_RG_VCORE_NONAUDIBLE_EN_ADDR MT6356_VCORE_VPROC_ANA_CON11
#define PMIC_RG_VCORE_NONAUDIBLE_EN_MASK 0x1
#define PMIC_RG_VCORE_NONAUDIBLE_EN_SHIFT 0
#define PMIC_RG_VPROC_NONAUDIBLE_EN_ADDR MT6356_VCORE_VPROC_ANA_CON11
#define PMIC_RG_VPROC_NONAUDIBLE_EN_MASK 0x1
#define PMIC_RG_VPROC_NONAUDIBLE_EN_SHIFT 1
#define PMIC_RG_VCOREVPROC_DISAUTOK_ADDR MT6356_VCORE_VPROC_ANA_CON11
#define PMIC_RG_VCOREVPROC_DISAUTOK_MASK 0x1
#define PMIC_RG_VCOREVPROC_DISAUTOK_SHIFT 2
#define PMIC_RGS_VCORE_PFM_FLAG_ADDR MT6356_VCORE_VPROC_ANA_CON11
#define PMIC_RGS_VCORE_PFM_FLAG_MASK 0x1
#define PMIC_RGS_VCORE_PFM_FLAG_SHIFT 3
#define PMIC_RGS_VPROC_PFM_FLAG_ADDR MT6356_VCORE_VPROC_ANA_CON11
#define PMIC_RGS_VPROC_PFM_FLAG_MASK 0x1
#define PMIC_RGS_VPROC_PFM_FLAG_SHIFT 4
#define PMIC_RG_VMODEM_MODESET_ADDR MT6356_VMODEM_ANA_CON0
#define PMIC_RG_VMODEM_MODESET_MASK 0x1
#define PMIC_RG_VMODEM_MODESET_SHIFT 1
#define PMIC_RG_VMODEM_NDIS_EN_ADDR MT6356_VMODEM_ANA_CON0
#define PMIC_RG_VMODEM_NDIS_EN_MASK 0x1
#define PMIC_RG_VMODEM_NDIS_EN_SHIFT 2
#define PMIC_RG_VMODEM_VRF18_SSTART_EN_ADDR MT6356_VMODEM_ANA_CON0
#define PMIC_RG_VMODEM_VRF18_SSTART_EN_MASK 0x1
#define PMIC_RG_VMODEM_VRF18_SSTART_EN_SHIFT 3
#define PMIC_RG_VMODEM_AUTO_MODE_ADDR MT6356_VMODEM_ANA_CON0
#define PMIC_RG_VMODEM_AUTO_MODE_MASK 0x1
#define PMIC_RG_VMODEM_AUTO_MODE_SHIFT 4
#define PMIC_RG_VMODEM_RZSEL0_ADDR MT6356_VMODEM_ANA_CON1
#define PMIC_RG_VMODEM_RZSEL0_MASK 0x7
#define PMIC_RG_VMODEM_RZSEL0_SHIFT 0
#define PMIC_RG_VMODEM_RZSEL1_ADDR MT6356_VMODEM_ANA_CON1
#define PMIC_RG_VMODEM_RZSEL1_MASK 0xF
#define PMIC_RG_VMODEM_RZSEL1_SHIFT 3
#define PMIC_RG_VMODEM_CCSEL0_ADDR MT6356_VMODEM_ANA_CON1
#define PMIC_RG_VMODEM_CCSEL0_MASK 0x3
#define PMIC_RG_VMODEM_CCSEL0_SHIFT 7
#define PMIC_RG_VMODEM_CCSEL1_ADDR MT6356_VMODEM_ANA_CON1
#define PMIC_RG_VMODEM_CCSEL1_MASK 0x3
#define PMIC_RG_VMODEM_CCSEL1_SHIFT 9
#define PMIC_RG_VMODEM_CSL_ADDR MT6356_VMODEM_ANA_CON1
#define PMIC_RG_VMODEM_CSL_MASK 0xF
#define PMIC_RG_VMODEM_CSL_SHIFT 11
#define PMIC_RG_VMODEM_SLP_ADDR MT6356_VMODEM_ANA_CON2
#define PMIC_RG_VMODEM_SLP_MASK 0x7
#define PMIC_RG_VMODEM_SLP_SHIFT 0
#define PMIC_RG_VMODEM_ADRC_FEN_ADDR MT6356_VMODEM_ANA_CON2
#define PMIC_RG_VMODEM_ADRC_FEN_MASK 0x1
#define PMIC_RG_VMODEM_ADRC_FEN_SHIFT 3
#define PMIC_RG_VMODEM_VC_CAP_CLAMP_FEN_ADDR MT6356_VMODEM_ANA_CON2
#define PMIC_RG_VMODEM_VC_CAP_CLAMP_FEN_MASK 0x1
#define PMIC_RG_VMODEM_VC_CAP_CLAMP_FEN_SHIFT 4
#define PMIC_RG_VMODEM_VC_CLAMP_FEN_ADDR MT6356_VMODEM_ANA_CON2
#define PMIC_RG_VMODEM_VC_CLAMP_FEN_MASK 0x1
#define PMIC_RG_VMODEM_VC_CLAMP_FEN_SHIFT 5
#define PMIC_RG_VMODEM_BURST_ADDR MT6356_VMODEM_ANA_CON2
#define PMIC_RG_VMODEM_BURST_MASK 0x7
#define PMIC_RG_VMODEM_BURST_SHIFT 6
#define PMIC_RG_VMODEM_CSR_ADDR MT6356_VMODEM_ANA_CON2
#define PMIC_RG_VMODEM_CSR_MASK 0x7
#define PMIC_RG_VMODEM_CSR_SHIFT 9
#define PMIC_RG_VMODEM_PFMSR_EH_ADDR MT6356_VMODEM_ANA_CON3
#define PMIC_RG_VMODEM_PFMSR_EH_MASK 0x1
#define PMIC_RG_VMODEM_PFMSR_EH_SHIFT 0
#define PMIC_RG_VMODEM_NLIM_GATING_ADDR MT6356_VMODEM_ANA_CON3
#define PMIC_RG_VMODEM_NLIM_GATING_MASK 0x1
#define PMIC_RG_VMODEM_NLIM_GATING_SHIFT 1
#define PMIC_RG_VMODEM_PWMSR_EH_ADDR MT6356_VMODEM_ANA_CON3
#define PMIC_RG_VMODEM_PWMSR_EH_MASK 0x1
#define PMIC_RG_VMODEM_PWMSR_EH_SHIFT 2
#define PMIC_RG_VMODEM_HS_VTHDET_ADDR MT6356_VMODEM_ANA_CON3
#define PMIC_RG_VMODEM_HS_VTHDET_MASK 0x1
#define PMIC_RG_VMODEM_HS_VTHDET_SHIFT 3
#define PMIC_RG_VMODEM_PG_GATING_ADDR MT6356_VMODEM_ANA_CON3
#define PMIC_RG_VMODEM_PG_GATING_MASK 0x1
#define PMIC_RG_VMODEM_PG_GATING_SHIFT 4
#define PMIC_RG_VMODEM_HS_ONSPEED_EH_ADDR MT6356_VMODEM_ANA_CON3
#define PMIC_RG_VMODEM_HS_ONSPEED_EH_MASK 0x1
#define PMIC_RG_VMODEM_HS_ONSPEED_EH_SHIFT 5
#define PMIC_RG_VMODEM_SR_P_ADDR MT6356_VMODEM_ANA_CON3
#define PMIC_RG_VMODEM_SR_P_MASK 0x3
#define PMIC_RG_VMODEM_SR_P_SHIFT 6
#define PMIC_RG_VMODEM_SR_N_ADDR MT6356_VMODEM_ANA_CON3
#define PMIC_RG_VMODEM_SR_N_MASK 0x3
#define PMIC_RG_VMODEM_SR_N_SHIFT 8
#define PMIC_RG_VMODEM_PFM_RIP_ADDR MT6356_VMODEM_ANA_CON3
#define PMIC_RG_VMODEM_PFM_RIP_MASK 0x7
#define PMIC_RG_VMODEM_PFM_RIP_SHIFT 10
#define PMIC_RG_VMODEM_TRAN_BST_ADDR MT6356_VMODEM_ANA_CON4
#define PMIC_RG_VMODEM_TRAN_BST_MASK 0x3F
#define PMIC_RG_VMODEM_TRAN_BST_SHIFT 0
#define PMIC_RG_VMODEM_DTS_ENB_ADDR MT6356_VMODEM_ANA_CON4
#define PMIC_RG_VMODEM_DTS_ENB_MASK 0x1
#define PMIC_RG_VMODEM_DTS_ENB_SHIFT 6
#define PMIC_RG_VMODEM_MIN_OFF_ADDR MT6356_VMODEM_ANA_CON4
#define PMIC_RG_VMODEM_MIN_OFF_MASK 0x3
#define PMIC_RG_VMODEM_MIN_OFF_SHIFT 7
#define PMIC_RG_VMODEM_1P35UP_SEL_EN_ADDR MT6356_VMODEM_ANA_CON4
#define PMIC_RG_VMODEM_1P35UP_SEL_EN_MASK 0x1
#define PMIC_RG_VMODEM_1P35UP_SEL_EN_SHIFT 9
#define PMIC_RG_VMODEM_DLC_AUTO_MODE_ADDR MT6356_VMODEM_ANA_CON4
#define PMIC_RG_VMODEM_DLC_AUTO_MODE_MASK 0x1
#define PMIC_RG_VMODEM_DLC_AUTO_MODE_SHIFT 10
#define PMIC_RG_VMODEM_SRC_AUTO_MODE_ADDR MT6356_VMODEM_ANA_CON4
#define PMIC_RG_VMODEM_SRC_AUTO_MODE_MASK 0x1
#define PMIC_RG_VMODEM_SRC_AUTO_MODE_SHIFT 11
#define PMIC_RG_VMODEM_UGP_SR_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_UGP_SR_MASK 0x3
#define PMIC_RG_VMODEM_UGP_SR_SHIFT 0
#define PMIC_RG_VMODEM_LGP_SR_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_LGP_SR_MASK 0x3
#define PMIC_RG_VMODEM_LGP_SR_SHIFT 2
#define PMIC_RG_VMODEM_UGP_SR_PFM_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_UGP_SR_PFM_MASK 0x3
#define PMIC_RG_VMODEM_UGP_SR_PFM_SHIFT 4
#define PMIC_RG_VMODEM_LGP_SR_PFM_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_LGP_SR_PFM_MASK 0x3
#define PMIC_RG_VMODEM_LGP_SR_PFM_SHIFT 6
#define PMIC_RG_VMODEM_UGD_VTHSEL_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_UGD_VTHSEL_MASK 0x3
#define PMIC_RG_VMODEM_UGD_VTHSEL_SHIFT 8
#define PMIC_RG_VMODEM_FNLX_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_FNLX_MASK 0x1
#define PMIC_RG_VMODEM_FNLX_SHIFT 10
#define PMIC_RG_VMODEM_VDIFF_ENLOWIQ_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_VDIFF_ENLOWIQ_MASK 0x1
#define PMIC_RG_VMODEM_VDIFF_ENLOWIQ_SHIFT 11
#define PMIC_RG_VMODEM_PFMOC_FWUPOFF_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_PFMOC_FWUPOFF_MASK 0x1
#define PMIC_RG_VMODEM_PFMOC_FWUPOFF_SHIFT 12
#define PMIC_RG_VMODEM_PWMOC_FWUPOFF_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_PWMOC_FWUPOFF_MASK 0x1
#define PMIC_RG_VMODEM_PWMOC_FWUPOFF_SHIFT 13
#define PMIC_RG_VMODEM_CP_FWUPOFF_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_CP_FWUPOFF_MASK 0x1
#define PMIC_RG_VMODEM_CP_FWUPOFF_SHIFT 14
#define PMIC_RG_VMODEM_ZX_GATING_ADDR MT6356_VMODEM_ANA_CON5
#define PMIC_RG_VMODEM_ZX_GATING_MASK 0x1
#define PMIC_RG_VMODEM_ZX_GATING_SHIFT 15
#define PMIC_RG_VMODEM_RSV_ADDR MT6356_VMODEM_ANA_CON6
#define PMIC_RG_VMODEM_RSV_MASK 0xFFFF
#define PMIC_RG_VMODEM_RSV_SHIFT 0
#define PMIC_RG_VMODEM_AZC_EN_ADDR MT6356_VMODEM_ANA_CON7
#define PMIC_RG_VMODEM_AZC_EN_MASK 0x1
#define PMIC_RG_VMODEM_AZC_EN_SHIFT 0
#define PMIC_RG_VMODEM_AZC_DELAY_ADDR MT6356_VMODEM_ANA_CON7
#define PMIC_RG_VMODEM_AZC_DELAY_MASK 0x3
#define PMIC_RG_VMODEM_AZC_DELAY_SHIFT 1
#define PMIC_RG_VMODEM_AZC_HOLD_ENB_ADDR MT6356_VMODEM_ANA_CON7
#define PMIC_RG_VMODEM_AZC_HOLD_ENB_MASK 0x1
#define PMIC_RG_VMODEM_AZC_HOLD_ENB_SHIFT 3
#define PMIC_RGS_VMODEM_OC_STATUS_ADDR MT6356_VMODEM_ANA_CON7
#define PMIC_RGS_VMODEM_OC_STATUS_MASK 0x1
#define PMIC_RGS_VMODEM_OC_STATUS_SHIFT 4
#define PMIC_RGS_VMODEM_DIG_MON_ADDR MT6356_VMODEM_ANA_CON7
#define PMIC_RGS_VMODEM_DIG_MON_MASK 0xF
#define PMIC_RGS_VMODEM_DIG_MON_SHIFT 5
#define PMIC_RG_VMODEM_IODETECT_EN18_ADDR MT6356_VMODEM_ANA_CON7
#define PMIC_RG_VMODEM_IODETECT_EN18_MASK 0x1
#define PMIC_RG_VMODEM_IODETECT_EN18_SHIFT 9
#define PMIC_RG_VMODEM_PREOC_SEL_ADDR MT6356_VMODEM_ANA_CON7
#define PMIC_RG_VMODEM_PREOC_SEL_MASK 0x7
#define PMIC_RG_VMODEM_PREOC_SEL_SHIFT 10
#define PMIC_RG_VMODEM_NONAUDIBLE_EN_ADDR MT6356_VMODEM_ANA_CON7
#define PMIC_RG_VMODEM_NONAUDIBLE_EN_MASK 0x1
#define PMIC_RG_VMODEM_NONAUDIBLE_EN_SHIFT 13
#define PMIC_RGS_VMODEM_PFM_FLAG_ADDR MT6356_VMODEM_ANA_CON7
#define PMIC_RGS_VMODEM_PFM_FLAG_MASK 0x1
#define PMIC_RGS_VMODEM_PFM_FLAG_SHIFT 14
#define PMIC_RG_VS1_MIN_OFF_ADDR MT6356_VS1_ANA_CON0
#define PMIC_RG_VS1_MIN_OFF_MASK 0x3
#define PMIC_RG_VS1_MIN_OFF_SHIFT 0
#define PMIC_RG_VS1_VRF18_SSTART_EN_ADDR MT6356_VS1_ANA_CON0
#define PMIC_RG_VS1_VRF18_SSTART_EN_MASK 0x1
#define PMIC_RG_VS1_VRF18_SSTART_EN_SHIFT 2
#define PMIC_RG_VS1_1P35UP_SEL_EN_ADDR MT6356_VS1_ANA_CON0
#define PMIC_RG_VS1_1P35UP_SEL_EN_MASK 0x1
#define PMIC_RG_VS1_1P35UP_SEL_EN_SHIFT 3
#define PMIC_RG_VS1_RZSEL_ADDR MT6356_VS1_ANA_CON0
#define PMIC_RG_VS1_RZSEL_MASK 0x7
#define PMIC_RG_VS1_RZSEL_SHIFT 4
#define PMIC_RG_VS1_CSR_ADDR MT6356_VS1_ANA_CON0
#define PMIC_RG_VS1_CSR_MASK 0x7
#define PMIC_RG_VS1_CSR_SHIFT 7
#define PMIC_RG_VS1_CSL_ADDR MT6356_VS1_ANA_CON0
#define PMIC_RG_VS1_CSL_MASK 0xF
#define PMIC_RG_VS1_CSL_SHIFT 10
#define PMIC_RG_VS1_SLP_ADDR MT6356_VS1_ANA_CON1
#define PMIC_RG_VS1_SLP_MASK 0x7
#define PMIC_RG_VS1_SLP_SHIFT 0
#define PMIC_RG_VS1_NDIS_EN_ADDR MT6356_VS1_ANA_CON1
#define PMIC_RG_VS1_NDIS_EN_MASK 0x1
#define PMIC_RG_VS1_NDIS_EN_SHIFT 3
#define PMIC_RG_VS1_CSM_N_ADDR MT6356_VS1_ANA_CON1
#define PMIC_RG_VS1_CSM_N_MASK 0x3F
#define PMIC_RG_VS1_CSM_N_SHIFT 4
#define PMIC_RG_VS1_CSM_P_ADDR MT6356_VS1_ANA_CON1
#define PMIC_RG_VS1_CSM_P_MASK 0x3F
#define PMIC_RG_VS1_CSM_P_SHIFT 10
#define PMIC_RG_VS1_RSV_ADDR MT6356_VS1_ANA_CON2
#define PMIC_RG_VS1_RSV_MASK 0xFF
#define PMIC_RG_VS1_RSV_SHIFT 0
#define PMIC_RG_VS1_MODESET_ADDR MT6356_VS1_ANA_CON2
#define PMIC_RG_VS1_MODESET_MASK 0x1
#define PMIC_RG_VS1_MODESET_SHIFT 8
#define PMIC_RG_VS1_PFM_RIP_ADDR MT6356_VS1_ANA_CON2
#define PMIC_RG_VS1_PFM_RIP_MASK 0x7
#define PMIC_RG_VS1_PFM_RIP_SHIFT 9
#define PMIC_RG_VS1_TRAN_BST_ADDR MT6356_VS1_ANA_CON3
#define PMIC_RG_VS1_TRAN_BST_MASK 0x3F
#define PMIC_RG_VS1_TRAN_BST_SHIFT 0
#define PMIC_RG_VS1_DTS_ENB_ADDR MT6356_VS1_ANA_CON3
#define PMIC_RG_VS1_DTS_ENB_MASK 0x1
#define PMIC_RG_VS1_DTS_ENB_SHIFT 6
#define PMIC_RG_VS1_AUTO_MODE_ADDR MT6356_VS1_ANA_CON3
#define PMIC_RG_VS1_AUTO_MODE_MASK 0x1
#define PMIC_RG_VS1_AUTO_MODE_SHIFT 7
#define PMIC_RG_VS1_PWM_TRIG_ADDR MT6356_VS1_ANA_CON3
#define PMIC_RG_VS1_PWM_TRIG_MASK 0x1
#define PMIC_RG_VS1_PWM_TRIG_SHIFT 8
#define PMIC_RG_VS1_RSV_H_ADDR MT6356_VS1_ANA_CON3
#define PMIC_RG_VS1_RSV_H_MASK 0xF
#define PMIC_RG_VS1_RSV_H_SHIFT 9
#define PMIC_RG_VS1_RSV_L_ADDR MT6356_VS1_ANA_CON4
#define PMIC_RG_VS1_RSV_L_MASK 0xF
#define PMIC_RG_VS1_RSV_L_SHIFT 0
#define PMIC_RG_VS1_NONAUDIBLE_EN_ADDR MT6356_VS1_ANA_CON4
#define PMIC_RG_VS1_NONAUDIBLE_EN_MASK 0x1
#define PMIC_RG_VS1_NONAUDIBLE_EN_SHIFT 4
#define PMIC_RG_VS1_SR_P_ADDR MT6356_VS1_ANA_CON4
#define PMIC_RG_VS1_SR_P_MASK 0x3
#define PMIC_RG_VS1_SR_P_SHIFT 5
#define PMIC_RG_VS1_SR_N_ADDR MT6356_VS1_ANA_CON4
#define PMIC_RG_VS1_SR_N_MASK 0x3
#define PMIC_RG_VS1_SR_N_SHIFT 7
#define PMIC_RG_VS1_BURST_ADDR MT6356_VS1_ANA_CON4
#define PMIC_RG_VS1_BURST_MASK 0x7
#define PMIC_RG_VS1_BURST_SHIFT 9
#define PMIC_RGS_VS1_OC_STATUS_ADDR MT6356_VS1_ANA_CON4
#define PMIC_RGS_VS1_OC_STATUS_MASK 0x1
#define PMIC_RGS_VS1_OC_STATUS_SHIFT 12
#define PMIC_RGS_VS1_DIG_MON_ADDR MT6356_VS1_ANA_CON5
#define PMIC_RGS_VS1_DIG_MON_MASK 0xF
#define PMIC_RGS_VS1_DIG_MON_SHIFT 0
#define PMIC_RGS_VS1_PFM_FLAG_ADDR MT6356_VS1_ANA_CON5
#define PMIC_RGS_VS1_PFM_FLAG_MASK 0x1
#define PMIC_RGS_VS1_PFM_FLAG_SHIFT 4
#define PMIC_RG_VS2_MIN_OFF_ADDR MT6356_VS2_ANA_CON0
#define PMIC_RG_VS2_MIN_OFF_MASK 0x3
#define PMIC_RG_VS2_MIN_OFF_SHIFT 0
#define PMIC_RG_VS2_VRF18_SSTART_EN_ADDR MT6356_VS2_ANA_CON0
#define PMIC_RG_VS2_VRF18_SSTART_EN_MASK 0x1
#define PMIC_RG_VS2_VRF18_SSTART_EN_SHIFT 2
#define PMIC_RG_VS2_1P35UP_SEL_EN_ADDR MT6356_VS2_ANA_CON0
#define PMIC_RG_VS2_1P35UP_SEL_EN_MASK 0x1
#define PMIC_RG_VS2_1P35UP_SEL_EN_SHIFT 3
#define PMIC_RG_VS2_RZSEL_ADDR MT6356_VS2_ANA_CON0
#define PMIC_RG_VS2_RZSEL_MASK 0x7
#define PMIC_RG_VS2_RZSEL_SHIFT 4
#define PMIC_RG_VS2_CSR_ADDR MT6356_VS2_ANA_CON0
#define PMIC_RG_VS2_CSR_MASK 0x7
#define PMIC_RG_VS2_CSR_SHIFT 7
#define PMIC_RG_VS2_CSL_ADDR MT6356_VS2_ANA_CON0
#define PMIC_RG_VS2_CSL_MASK 0xF
#define PMIC_RG_VS2_CSL_SHIFT 10
#define PMIC_RG_VS2_SLP_ADDR MT6356_VS2_ANA_CON1
#define PMIC_RG_VS2_SLP_MASK 0x7
#define PMIC_RG_VS2_SLP_SHIFT 0
#define PMIC_RG_VS2_NDIS_EN_ADDR MT6356_VS2_ANA_CON1
#define PMIC_RG_VS2_NDIS_EN_MASK 0x1
#define PMIC_RG_VS2_NDIS_EN_SHIFT 3
#define PMIC_RG_VS2_CSM_N_ADDR MT6356_VS2_ANA_CON1
#define PMIC_RG_VS2_CSM_N_MASK 0x3F
#define PMIC_RG_VS2_CSM_N_SHIFT 4
#define PMIC_RG_VS2_CSM_P_ADDR MT6356_VS2_ANA_CON1
#define PMIC_RG_VS2_CSM_P_MASK 0x3F
#define PMIC_RG_VS2_CSM_P_SHIFT 10
#define PMIC_RG_VS2_RSV_ADDR MT6356_VS2_ANA_CON2
#define PMIC_RG_VS2_RSV_MASK 0xFF
#define PMIC_RG_VS2_RSV_SHIFT 0
#define PMIC_RG_VS2_MODESET_ADDR MT6356_VS2_ANA_CON2
#define PMIC_RG_VS2_MODESET_MASK 0x1
#define PMIC_RG_VS2_MODESET_SHIFT 8
#define PMIC_RG_VS2_PFM_RIP_ADDR MT6356_VS2_ANA_CON2
#define PMIC_RG_VS2_PFM_RIP_MASK 0x7
#define PMIC_RG_VS2_PFM_RIP_SHIFT 9
#define PMIC_RG_VS2_TRAN_BST_ADDR MT6356_VS2_ANA_CON3
#define PMIC_RG_VS2_TRAN_BST_MASK 0x3F
#define PMIC_RG_VS2_TRAN_BST_SHIFT 0
#define PMIC_RG_VS2_DTS_ENB_ADDR MT6356_VS2_ANA_CON3
#define PMIC_RG_VS2_DTS_ENB_MASK 0x1
#define PMIC_RG_VS2_DTS_ENB_SHIFT 6
#define PMIC_RG_VS2_AUTO_MODE_ADDR MT6356_VS2_ANA_CON3
#define PMIC_RG_VS2_AUTO_MODE_MASK 0x1
#define PMIC_RG_VS2_AUTO_MODE_SHIFT 7
#define PMIC_RG_VS2_PWM_TRIG_ADDR MT6356_VS2_ANA_CON3
#define PMIC_RG_VS2_PWM_TRIG_MASK 0x1
#define PMIC_RG_VS2_PWM_TRIG_SHIFT 8
#define PMIC_RG_VS2_RSV_H_ADDR MT6356_VS2_ANA_CON3
#define PMIC_RG_VS2_RSV_H_MASK 0xF
#define PMIC_RG_VS2_RSV_H_SHIFT 9
#define PMIC_RG_VS2_RSV_L_ADDR MT6356_VS2_ANA_CON4
#define PMIC_RG_VS2_RSV_L_MASK 0xF
#define PMIC_RG_VS2_RSV_L_SHIFT 0
#define PMIC_RG_VS2_NONAUDIBLE_EN_ADDR MT6356_VS2_ANA_CON4
#define PMIC_RG_VS2_NONAUDIBLE_EN_MASK 0x1
#define PMIC_RG_VS2_NONAUDIBLE_EN_SHIFT 4
#define PMIC_RG_VS2_SR_P_ADDR MT6356_VS2_ANA_CON4
#define PMIC_RG_VS2_SR_P_MASK 0x3
#define PMIC_RG_VS2_SR_P_SHIFT 5
#define PMIC_RG_VS2_SR_N_ADDR MT6356_VS2_ANA_CON4
#define PMIC_RG_VS2_SR_N_MASK 0x3
#define PMIC_RG_VS2_SR_N_SHIFT 7
#define PMIC_RG_VS2_BURST_ADDR MT6356_VS2_ANA_CON4
#define PMIC_RG_VS2_BURST_MASK 0x7
#define PMIC_RG_VS2_BURST_SHIFT 9
#define PMIC_RGS_VS2_OC_STATUS_ADDR MT6356_VS2_ANA_CON4
#define PMIC_RGS_VS2_OC_STATUS_MASK 0x1
#define PMIC_RGS_VS2_OC_STATUS_SHIFT 12
#define PMIC_RGS_VS2_DIG_MON_ADDR MT6356_VS2_ANA_CON5
#define PMIC_RGS_VS2_DIG_MON_MASK 0xF
#define PMIC_RGS_VS2_DIG_MON_SHIFT 0
#define PMIC_RGS_VS2_PFM_FLAG_ADDR MT6356_VS2_ANA_CON5
#define PMIC_RGS_VS2_PFM_FLAG_MASK 0x1
#define PMIC_RGS_VS2_PFM_FLAG_SHIFT 4
#define PMIC_RG_VPA_NDIS_EN_ADDR MT6356_VPA_ANA_CON0
#define PMIC_RG_VPA_NDIS_EN_MASK 0x1
#define PMIC_RG_VPA_NDIS_EN_SHIFT 1
#define PMIC_RG_VPA_MODESET_ADDR MT6356_VPA_ANA_CON0
#define PMIC_RG_VPA_MODESET_MASK 0x1
#define PMIC_RG_VPA_MODESET_SHIFT 3
#define PMIC_RG_VPA_CC_ADDR MT6356_VPA_ANA_CON1
#define PMIC_RG_VPA_CC_MASK 0x3
#define PMIC_RG_VPA_CC_SHIFT 0
#define PMIC_RG_VPA_CSR_ADDR MT6356_VPA_ANA_CON1
#define PMIC_RG_VPA_CSR_MASK 0x3
#define PMIC_RG_VPA_CSR_SHIFT 2
#define PMIC_RG_VPA_CSMIR_ADDR MT6356_VPA_ANA_CON1
#define PMIC_RG_VPA_CSMIR_MASK 0x3
#define PMIC_RG_VPA_CSMIR_SHIFT 4
#define PMIC_RG_VPA_CSL_ADDR MT6356_VPA_ANA_CON1
#define PMIC_RG_VPA_CSL_MASK 0x3
#define PMIC_RG_VPA_CSL_SHIFT 6
#define PMIC_RG_VPA_SLP_ADDR MT6356_VPA_ANA_CON1
#define PMIC_RG_VPA_SLP_MASK 0x3
#define PMIC_RG_VPA_SLP_SHIFT 8
#define PMIC_RG_VPA_AZC_EN_ADDR MT6356_VPA_ANA_CON1
#define PMIC_RG_VPA_AZC_EN_MASK 0x1
#define PMIC_RG_VPA_AZC_EN_SHIFT 10
#define PMIC_RG_VPA_CP_FWUPOFF_ADDR MT6356_VPA_ANA_CON1
#define PMIC_RG_VPA_CP_FWUPOFF_MASK 0x1
#define PMIC_RG_VPA_CP_FWUPOFF_SHIFT 11
#define PMIC_RG_VPA_AZC_DELAY_ADDR MT6356_VPA_ANA_CON1
#define PMIC_RG_VPA_AZC_DELAY_MASK 0x3
#define PMIC_RG_VPA_AZC_DELAY_SHIFT 12
#define PMIC_RG_VPA_RZSEL_ADDR MT6356_VPA_ANA_CON1
#define PMIC_RG_VPA_RZSEL_MASK 0x3
#define PMIC_RG_VPA_RZSEL_SHIFT 14
#define PMIC_RG_VPA_HZP_ADDR MT6356_VPA_ANA_CON2
#define PMIC_RG_VPA_HZP_MASK 0x1
#define PMIC_RG_VPA_HZP_SHIFT 0
#define PMIC_RG_VPA_BWEX_GAT_ADDR MT6356_VPA_ANA_CON2
#define PMIC_RG_VPA_BWEX_GAT_MASK 0x1
#define PMIC_RG_VPA_BWEX_GAT_SHIFT 1
#define PMIC_RG_VPA_SLEW_ADDR MT6356_VPA_ANA_CON2
#define PMIC_RG_VPA_SLEW_MASK 0x3
#define PMIC_RG_VPA_SLEW_SHIFT 2
#define PMIC_RG_VPA_SLEW_NMOS_ADDR MT6356_VPA_ANA_CON2
#define PMIC_RG_VPA_SLEW_NMOS_MASK 0x3
#define PMIC_RG_VPA_SLEW_NMOS_SHIFT 4
#define PMIC_RG_VPA_MIN_ON_ADDR MT6356_VPA_ANA_CON2
#define PMIC_RG_VPA_MIN_ON_MASK 0x3
#define PMIC_RG_VPA_MIN_ON_SHIFT 6
#define PMIC_RG_VPA_VBAT_DEL_ADDR MT6356_VPA_ANA_CON2
#define PMIC_RG_VPA_VBAT_DEL_MASK 0x3
#define PMIC_RG_VPA_VBAT_DEL_SHIFT 8
#define PMIC_RGS_VPA_AZC_VOS_SEL_ADDR MT6356_VPA_ANA_CON3
#define PMIC_RGS_VPA_AZC_VOS_SEL_MASK 0xFF
#define PMIC_RGS_VPA_AZC_VOS_SEL_SHIFT 0
#define PMIC_RG_VPA_MIN_PK_ADDR MT6356_VPA_ANA_CON3
#define PMIC_RG_VPA_MIN_PK_MASK 0x3
#define PMIC_RG_VPA_MIN_PK_SHIFT 8
#define PMIC_RG_VPA_RSV1_ADDR MT6356_VPA_ANA_CON4
#define PMIC_RG_VPA_RSV1_MASK 0xFF
#define PMIC_RG_VPA_RSV1_SHIFT 0
#define PMIC_RG_VPA_RSV2_ADDR MT6356_VPA_ANA_CON4
#define PMIC_RG_VPA_RSV2_MASK 0xFF
#define PMIC_RG_VPA_RSV2_SHIFT 8
#define PMIC_RGS_VPA_OC_STATUS_ADDR MT6356_VPA_ANA_CON5
#define PMIC_RGS_VPA_OC_STATUS_MASK 0x1
#define PMIC_RGS_VPA_OC_STATUS_SHIFT 0
#define PMIC_RGS_VPA_AZC_ZX_ADDR MT6356_VPA_ANA_CON5
#define PMIC_RGS_VPA_AZC_ZX_MASK 0x1
#define PMIC_RGS_VPA_AZC_ZX_SHIFT 1
#define PMIC_BUCK_ANA_ELR_LEN_ADDR MT6356_BUCK_ANA_ELR_NUM
#define PMIC_BUCK_ANA_ELR_LEN_MASK 0xFF
#define PMIC_BUCK_ANA_ELR_LEN_SHIFT 0
#define PMIC_RG_VS1_TRIMH_ADDR MT6356_SMPS_ELR_0
#define PMIC_RG_VS1_TRIMH_MASK 0x1F
#define PMIC_RG_VS1_TRIMH_SHIFT 0
#define PMIC_RG_VS1_TRIML_ADDR MT6356_SMPS_ELR_0
#define PMIC_RG_VS1_TRIML_MASK 0x1F
#define PMIC_RG_VS1_TRIML_SHIFT 5
#define PMIC_RG_VS1_VSLEEP_TRIM_ADDR MT6356_SMPS_ELR_0
#define PMIC_RG_VS1_VSLEEP_TRIM_MASK 0x7
#define PMIC_RG_VS1_VSLEEP_TRIM_SHIFT 10
#define PMIC_RG_VS2_TRIMH_ADDR MT6356_SMPS_ELR_1
#define PMIC_RG_VS2_TRIMH_MASK 0x1F
#define PMIC_RG_VS2_TRIMH_SHIFT 0
#define PMIC_RG_VS2_TRIML_ADDR MT6356_SMPS_ELR_1
#define PMIC_RG_VS2_TRIML_MASK 0x1F
#define PMIC_RG_VS2_TRIML_SHIFT 5
#define PMIC_RG_VS2_VSLEEP_TRIM_ADDR MT6356_SMPS_ELR_1
#define PMIC_RG_VS2_VSLEEP_TRIM_MASK 0x7
#define PMIC_RG_VS2_VSLEEP_TRIM_SHIFT 10
#define PMIC_RG_VCORE_TRIMH_ADDR MT6356_SMPS_ELR_2
#define PMIC_RG_VCORE_TRIMH_MASK 0x1F
#define PMIC_RG_VCORE_TRIMH_SHIFT 0
#define PMIC_RG_VCORE_VSLEEP_TRIM_ADDR MT6356_SMPS_ELR_2
#define PMIC_RG_VCORE_VSLEEP_TRIM_MASK 0x7
#define PMIC_RG_VCORE_VSLEEP_TRIM_SHIFT 5
#define PMIC_RG_VPROC_TRIMH_ADDR MT6356_SMPS_ELR_2
#define PMIC_RG_VPROC_TRIMH_MASK 0x1F
#define PMIC_RG_VPROC_TRIMH_SHIFT 8
#define PMIC_RG_VPROC_VSLEEP_TRIM_ADDR MT6356_SMPS_ELR_2
#define PMIC_RG_VPROC_VSLEEP_TRIM_MASK 0x7
#define PMIC_RG_VPROC_VSLEEP_TRIM_SHIFT 13
#define PMIC_RG_VMODEM_TRIMH_ADDR MT6356_SMPS_ELR_3
#define PMIC_RG_VMODEM_TRIMH_MASK 0x1F
#define PMIC_RG_VMODEM_TRIMH_SHIFT 0
#define PMIC_RG_VMODEM_TRIML_ADDR MT6356_SMPS_ELR_3
#define PMIC_RG_VMODEM_TRIML_MASK 0x1F
#define PMIC_RG_VMODEM_TRIML_SHIFT 5
#define PMIC_RG_VMODEM_VSLEEP_TRIM_ADDR MT6356_SMPS_ELR_3
#define PMIC_RG_VMODEM_VSLEEP_TRIM_MASK 0x7
#define PMIC_RG_VMODEM_VSLEEP_TRIM_SHIFT 10
#define PMIC_RG_VPA_TRIMH_ADDR MT6356_SMPS_ELR_4
#define PMIC_RG_VPA_TRIMH_MASK 0x1F
#define PMIC_RG_VPA_TRIMH_SHIFT 0
#define PMIC_RG_VPA_TRIML_ADDR MT6356_SMPS_ELR_4
#define PMIC_RG_VPA_TRIML_MASK 0x1F
#define PMIC_RG_VPA_TRIML_SHIFT 5
#define PMIC_RG_VPA_TRIM_REF_ADDR MT6356_SMPS_ELR_4
#define PMIC_RG_VPA_TRIM_REF_MASK 0x1F
#define PMIC_RG_VPA_TRIM_REF_SHIFT 10
#define PMIC_RG_VSRAM_PROC_TRIMH_ADDR MT6356_SMPS_ELR_5
#define PMIC_RG_VSRAM_PROC_TRIMH_MASK 0x1F
#define PMIC_RG_VSRAM_PROC_TRIMH_SHIFT 0
#define PMIC_RG_VSRAM_PROC_TRIML_ADDR MT6356_SMPS_ELR_5
#define PMIC_RG_VSRAM_PROC_TRIML_MASK 0x1F
#define PMIC_RG_VSRAM_PROC_TRIML_SHIFT 5
#define PMIC_RG_VSRAM_PROC_VSLEEP_TRIM_ADDR MT6356_SMPS_ELR_5
#define PMIC_RG_VSRAM_PROC_VSLEEP_TRIM_MASK 0x7
#define PMIC_RG_VSRAM_PROC_VSLEEP_TRIM_SHIFT 10
#define PMIC_RG_VSRAM_GPU_TRIMH_ADDR MT6356_SMPS_ELR_6
#define PMIC_RG_VSRAM_GPU_TRIMH_MASK 0x1F
#define PMIC_RG_VSRAM_GPU_TRIMH_SHIFT 0
#define PMIC_RG_VSRAM_GPU_TRIML_ADDR MT6356_SMPS_ELR_6
#define PMIC_RG_VSRAM_GPU_TRIML_MASK 0x1F
#define PMIC_RG_VSRAM_GPU_TRIML_SHIFT 5
#define PMIC_RG_VSRAM_GPU_VSLEEP_TRIM_ADDR MT6356_SMPS_ELR_6
#define PMIC_RG_VSRAM_GPU_VSLEEP_TRIM_MASK 0x7
#define PMIC_RG_VSRAM_GPU_VSLEEP_TRIM_SHIFT 10
#define PMIC_RG_VSRAM_OTHERS_TRIMH_ADDR MT6356_SMPS_ELR_7
#define PMIC_RG_VSRAM_OTHERS_TRIMH_MASK 0x1F
#define PMIC_RG_VSRAM_OTHERS_TRIMH_SHIFT 0
#define PMIC_RG_VSRAM_OTHERS_TRIML_ADDR MT6356_SMPS_ELR_7
#define PMIC_RG_VSRAM_OTHERS_TRIML_MASK 0x1F
#define PMIC_RG_VSRAM_OTHERS_TRIML_SHIFT 5
#define PMIC_RG_VSRAM_OTHERS_VSLEEP_TRIM_ADDR MT6356_SMPS_ELR_7
#define PMIC_RG_VSRAM_OTHERS_VSLEEP_TRIM_MASK 0x7
#define PMIC_RG_VSRAM_OTHERS_VSLEEP_TRIM_SHIFT 10
#define PMIC_RG_VOUTDET_EN_ADDR MT6356_SMPS_ELR_7
#define PMIC_RG_VOUTDET_EN_MASK 0x1
#define PMIC_RG_VOUTDET_EN_SHIFT 13
#define PMIC_RG_M17L17_FLAG_ADDR MT6356_SMPS_ELR_7
#define PMIC_RG_M17L17_FLAG_MASK 0x1
#define PMIC_RG_M17L17_FLAG_SHIFT 14
#define PMIC_RG_VCORE_ZC_TRIM_ADDR MT6356_VCORE_VPROC_ELR_0
#define PMIC_RG_VCORE_ZC_TRIM_MASK 0x3
#define PMIC_RG_VCORE_ZC_TRIM_SHIFT 0
#define PMIC_RG_VCORE_NLIM_TRIM_ADDR MT6356_VCORE_VPROC_ELR_0
#define PMIC_RG_VCORE_NLIM_TRIM_MASK 0xF
#define PMIC_RG_VCORE_NLIM_TRIM_SHIFT 2
#define PMIC_RG_VCORE_TON_TRIM_ADDR MT6356_VCORE_VPROC_ELR_0
#define PMIC_RG_VCORE_TON_TRIM_MASK 0x3F
#define PMIC_RG_VCORE_TON_TRIM_SHIFT 6
#define PMIC_RG_VCORE_CSP_TRIM_ADDR MT6356_VCORE_VPROC_ELR_0
#define PMIC_RG_VCORE_CSP_TRIM_MASK 0x7
#define PMIC_RG_VCORE_CSP_TRIM_SHIFT 12
#define PMIC_RG_VCORE_CSN_TRIM_ADDR MT6356_VCORE_VPROC_ELR_1
#define PMIC_RG_VCORE_CSN_TRIM_MASK 0x7
#define PMIC_RG_VCORE_CSN_TRIM_SHIFT 0
#define PMIC_RG_VCORE_RPSI1_TRIM_ADDR MT6356_VCORE_VPROC_ELR_1
#define PMIC_RG_VCORE_RPSI1_TRIM_MASK 0x7
#define PMIC_RG_VCORE_RPSI1_TRIM_SHIFT 3
#define PMIC_RG_VCORE_PREOC_TRIM_ADDR MT6356_VCORE_VPROC_ELR_1
#define PMIC_RG_VCORE_PREOC_TRIM_MASK 0x7
#define PMIC_RG_VCORE_PREOC_TRIM_SHIFT 6
#define PMIC_RG_VCORE_CSPSLP_TRIM_ADDR MT6356_VCORE_VPROC_ELR_1
#define PMIC_RG_VCORE_CSPSLP_TRIM_MASK 0xF
#define PMIC_RG_VCORE_CSPSLP_TRIM_SHIFT 9
#define PMIC_RG_VCORE_CSNSLP_TRIM_ADDR MT6356_VCORE_VPROC_ELR_2
#define PMIC_RG_VCORE_CSNSLP_TRIM_MASK 0xF
#define PMIC_RG_VCORE_CSNSLP_TRIM_SHIFT 0
#define PMIC_RG_VPROC_ZC_TRIM_ADDR MT6356_VCORE_VPROC_ELR_2
#define PMIC_RG_VPROC_ZC_TRIM_MASK 0x3
#define PMIC_RG_VPROC_ZC_TRIM_SHIFT 4
#define PMIC_RG_VPROC_NLIM_TRIM_ADDR MT6356_VCORE_VPROC_ELR_2
#define PMIC_RG_VPROC_NLIM_TRIM_MASK 0xF
#define PMIC_RG_VPROC_NLIM_TRIM_SHIFT 6
#define PMIC_RG_VPROC_TON_TRIM_ADDR MT6356_VCORE_VPROC_ELR_2
#define PMIC_RG_VPROC_TON_TRIM_MASK 0x3F
#define PMIC_RG_VPROC_TON_TRIM_SHIFT 10
#define PMIC_RG_VPROC_CSP_TRIM_ADDR MT6356_VCORE_VPROC_ELR_3
#define PMIC_RG_VPROC_CSP_TRIM_MASK 0x7
#define PMIC_RG_VPROC_CSP_TRIM_SHIFT 0
#define PMIC_RG_VPROC_CSN_TRIM_ADDR MT6356_VCORE_VPROC_ELR_3
#define PMIC_RG_VPROC_CSN_TRIM_MASK 0x7
#define PMIC_RG_VPROC_CSN_TRIM_SHIFT 3
#define PMIC_RG_VPROC_RPSI1_TRIM_ADDR MT6356_VCORE_VPROC_ELR_3
#define PMIC_RG_VPROC_RPSI1_TRIM_MASK 0x7
#define PMIC_RG_VPROC_RPSI1_TRIM_SHIFT 6
#define PMIC_RG_VPROC_CSPSLP_TRIM_ADDR MT6356_VCORE_VPROC_ELR_3
#define PMIC_RG_VPROC_CSPSLP_TRIM_MASK 0xF
#define PMIC_RG_VPROC_CSPSLP_TRIM_SHIFT 9
#define PMIC_RG_VPROC_CSNSLP_TRIM_ADDR MT6356_VCORE_VPROC_ELR_4
#define PMIC_RG_VPROC_CSNSLP_TRIM_MASK 0xF
#define PMIC_RG_VPROC_CSNSLP_TRIM_SHIFT 0
#define PMIC_RG_VCOREVPROC_DISCONFIG20_ADDR MT6356_VCORE_VPROC_ELR_4
#define PMIC_RG_VCOREVPROC_DISCONFIG20_MASK 0x1
#define PMIC_RG_VCOREVPROC_DISCONFIG20_SHIFT 4
#define PMIC_RG_VMODEM_ZXOS_TRIM_ADDR MT6356_VMODEM_ELR_0
#define PMIC_RG_VMODEM_ZXOS_TRIM_MASK 0xFF
#define PMIC_RG_VMODEM_ZXOS_TRIM_SHIFT 0
#define PMIC_RG_VMODEM_NLIM_TRIMMING_ADDR MT6356_VMODEM_ELR_0
#define PMIC_RG_VMODEM_NLIM_TRIMMING_MASK 0xF
#define PMIC_RG_VMODEM_NLIM_TRIMMING_SHIFT 8
#define PMIC_RG_VS1_ZXOS_TRIM_ADDR MT6356_VS1_ELR_0
#define PMIC_RG_VS1_ZXOS_TRIM_MASK 0xFF
#define PMIC_RG_VS1_ZXOS_TRIM_SHIFT 0
#define PMIC_RG_VS1_ZX_OS_ADDR MT6356_VS1_ELR_0
#define PMIC_RG_VS1_ZX_OS_MASK 0xF
#define PMIC_RG_VS1_ZX_OS_SHIFT 8
#define PMIC_RG_VS2_ZXOS_TRIM_ADDR MT6356_VS2_ELR_0
#define PMIC_RG_VS2_ZXOS_TRIM_MASK 0xFF
#define PMIC_RG_VS2_ZXOS_TRIM_SHIFT 0
#define PMIC_RG_VS2_ZX_OS_ADDR MT6356_VS2_ELR_0
#define PMIC_RG_VS2_ZX_OS_MASK 0xF
#define PMIC_RG_VS2_ZX_OS_SHIFT 8
#define PMIC_RG_VPA_ZXREF_ADDR MT6356_VPA_ELR_0
#define PMIC_RG_VPA_ZXREF_MASK 0xFF
#define PMIC_RG_VPA_ZXREF_SHIFT 0
#define PMIC_RG_VPA_NLIM_SEL_ADDR MT6356_VPA_ELR_0
#define PMIC_RG_VPA_NLIM_SEL_MASK 0xF
#define PMIC_RG_VPA_NLIM_SEL_SHIFT 8
#define PMIC_LDO_TOP_ANA_ID_ADDR MT6356_LDO_TOP_DSN_ID
#define PMIC_LDO_TOP_ANA_ID_MASK 0xFF
#define PMIC_LDO_TOP_ANA_ID_SHIFT 0
#define PMIC_LDO_TOP_DIG_ID_ADDR MT6356_LDO_TOP_DSN_ID
#define PMIC_LDO_TOP_DIG_ID_MASK 0xFF
#define PMIC_LDO_TOP_DIG_ID_SHIFT 8
#define PMIC_LDO_TOP_ANA_MINOR_REV_ADDR MT6356_LDO_TOP_DSN_REV0
#define PMIC_LDO_TOP_ANA_MINOR_REV_MASK 0xF
#define PMIC_LDO_TOP_ANA_MINOR_REV_SHIFT 0
#define PMIC_LDO_TOP_ANA_MAJOR_REV_ADDR MT6356_LDO_TOP_DSN_REV0
#define PMIC_LDO_TOP_ANA_MAJOR_REV_MASK 0xF
#define PMIC_LDO_TOP_ANA_MAJOR_REV_SHIFT 4
#define PMIC_LDO_TOP_DIG_MINOR_REV_ADDR MT6356_LDO_TOP_DSN_REV0
#define PMIC_LDO_TOP_DIG_MINOR_REV_MASK 0xF
#define PMIC_LDO_TOP_DIG_MINOR_REV_SHIFT 8
#define PMIC_LDO_TOP_DIG_MAJOR_REV_ADDR MT6356_LDO_TOP_DSN_REV0
#define PMIC_LDO_TOP_DIG_MAJOR_REV_MASK 0xF
#define PMIC_LDO_TOP_DIG_MAJOR_REV_SHIFT 12
#define PMIC_LDO_TOP_SW_MINOR_REV_ADDR MT6356_LDO_TOP_DSN_REV1
#define PMIC_LDO_TOP_SW_MINOR_REV_MASK 0xF
#define PMIC_LDO_TOP_SW_MINOR_REV_SHIFT 0
#define PMIC_LDO_TOP_SW_MAJOR_REV_ADDR MT6356_LDO_TOP_DSN_REV1
#define PMIC_LDO_TOP_SW_MAJOR_REV_MASK 0xF
#define PMIC_LDO_TOP_SW_MAJOR_REV_SHIFT 4
#define PMIC_LDO_TOP_ESP_ADDR MT6356_LDO_TOP_DSN_REV1
#define PMIC_LDO_TOP_ESP_MASK 0xFF
#define PMIC_LDO_TOP_ESP_SHIFT 8
#define PMIC_LDO_TOP_CLK_OFFSET_ADDR MT6356_LDO_TOP_PAM0
#define PMIC_LDO_TOP_CLK_OFFSET_MASK 0xFF
#define PMIC_LDO_TOP_CLK_OFFSET_SHIFT 0
#define PMIC_LDO_TOP_RST_OFFSET_ADDR MT6356_LDO_TOP_PAM0
#define PMIC_LDO_TOP_RST_OFFSET_MASK 0xFF
#define PMIC_LDO_TOP_RST_OFFSET_SHIFT 8
#define PMIC_LDO_TOP_INT_OFFSET_ADDR MT6356_LDO_TOP_PAM1
#define PMIC_LDO_TOP_INT_OFFSET_MASK 0xFF
#define PMIC_LDO_TOP_INT_OFFSET_SHIFT 0
#define PMIC_LDO_TOP_INT_LEN_ADDR MT6356_LDO_TOP_PAM1
#define PMIC_LDO_TOP_INT_LEN_MASK 0xFF
#define PMIC_LDO_TOP_INT_LEN_SHIFT 8
#define PMIC_RG_LDO_DCM_MODE_ADDR MT6356_LDO_TOP_CLK_DCM_CON0
#define PMIC_RG_LDO_DCM_MODE_MASK 0x1
#define PMIC_RG_LDO_DCM_MODE_SHIFT 0
#define PMIC_RG_LDO_VIO28_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VIO28_CON0
#define PMIC_RG_LDO_VIO28_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VIO28_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VIO28_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VIO28_CON0
#define PMIC_RG_LDO_VIO28_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VIO28_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VIO28_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VIO28_CON0
#define PMIC_RG_LDO_VIO28_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VIO28_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VIO18_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VIO18_CON0
#define PMIC_RG_LDO_VIO18_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VIO18_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VIO18_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VIO18_CON0
#define PMIC_RG_LDO_VIO18_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VIO18_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VIO18_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VIO18_CON0
#define PMIC_RG_LDO_VIO18_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VIO18_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VAUD28_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VAUD28_CON0
#define PMIC_RG_LDO_VAUD28_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VAUD28_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VAUD28_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VAUD28_CON0
#define PMIC_RG_LDO_VAUD28_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VAUD28_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VAUD28_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VAUD28_CON0
#define PMIC_RG_LDO_VAUD28_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VAUD28_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VDRAM_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VDRAM_CON0
#define PMIC_RG_LDO_VDRAM_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VDRAM_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VDRAM_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VDRAM_CON0
#define PMIC_RG_LDO_VDRAM_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VDRAM_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VDRAM_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VDRAM_CON0
#define PMIC_RG_LDO_VDRAM_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VDRAM_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VA12_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VA12_CON0
#define PMIC_RG_LDO_VA12_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VA12_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VA12_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VA12_CON0
#define PMIC_RG_LDO_VA12_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VA12_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VA12_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VA12_CON0
#define PMIC_RG_LDO_VA12_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VA12_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VSRAM_PROC_CK_SW_MODE_ADDR                                \
	MT6356_LDO_TOP_CLK_VSRAM_PROC_CON0
#define PMIC_RG_LDO_VSRAM_PROC_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VSRAM_PROC_CON0
#define PMIC_RG_LDO_VSRAM_PROC_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VSRAM_PROC_OSC_SEL_DIS_ADDR                               \
	MT6356_LDO_TOP_CLK_VSRAM_PROC_CON0
#define PMIC_RG_LDO_VSRAM_PROC_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VSRAM_OTHERS_CK_SW_MODE_ADDR                              \
	MT6356_LDO_TOP_CLK_VSRAM_OTHERS_CON0
#define PMIC_RG_LDO_VSRAM_OTHERS_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_CK_SW_EN_ADDR                                \
	MT6356_LDO_TOP_CLK_VSRAM_OTHERS_CON0
#define PMIC_RG_LDO_VSRAM_OTHERS_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VSRAM_OTHERS_OSC_SEL_DIS_ADDR                             \
	MT6356_LDO_TOP_CLK_VSRAM_OTHERS_CON0
#define PMIC_RG_LDO_VSRAM_OTHERS_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VSRAM_GPU_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VSRAM_GPU_CON0
#define PMIC_RG_LDO_VSRAM_GPU_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VSRAM_GPU_CON0
#define PMIC_RG_LDO_VSRAM_GPU_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VSRAM_GPU_OSC_SEL_DIS_ADDR                                \
	MT6356_LDO_TOP_CLK_VSRAM_GPU_CON0
#define PMIC_RG_LDO_VSRAM_GPU_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VAUX18_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VAUX18_CON0
#define PMIC_RG_LDO_VAUX18_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VAUX18_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VAUX18_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VAUX18_CON0
#define PMIC_RG_LDO_VAUX18_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VAUX18_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VAUX18_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VAUX18_CON0
#define PMIC_RG_LDO_VAUX18_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VAUX18_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VUSB_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VUSB_CON0
#define PMIC_RG_LDO_VUSB_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VUSB_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VUSB_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VUSB_CON0
#define PMIC_RG_LDO_VUSB_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VUSB_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VUSB_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VUSB_CON0
#define PMIC_RG_LDO_VUSB_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VUSB_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VEMC_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VEMC_CON0
#define PMIC_RG_LDO_VEMC_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VEMC_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VEMC_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VEMC_CON0
#define PMIC_RG_LDO_VEMC_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VEMC_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VEMC_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VEMC_CON0
#define PMIC_RG_LDO_VEMC_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VEMC_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VXO22_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VXO22_CON0
#define PMIC_RG_LDO_VXO22_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VXO22_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VXO22_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VXO22_CON0
#define PMIC_RG_LDO_VXO22_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VXO22_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VXO22_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VXO22_CON0
#define PMIC_RG_LDO_VXO22_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VXO22_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VSIM1_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VSIM1_CON0
#define PMIC_RG_LDO_VSIM1_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VSIM1_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VSIM1_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VSIM1_CON0
#define PMIC_RG_LDO_VSIM1_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM1_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VSIM1_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VSIM1_CON0
#define PMIC_RG_LDO_VSIM1_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VSIM1_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VSIM2_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VSIM2_CON0
#define PMIC_RG_LDO_VSIM2_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VSIM2_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VSIM2_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VSIM2_CON0
#define PMIC_RG_LDO_VSIM2_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM2_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VSIM2_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VSIM2_CON0
#define PMIC_RG_LDO_VSIM2_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VSIM2_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VCAMD_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VCAMD_CON0
#define PMIC_RG_LDO_VCAMD_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VCAMD_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VCAMD_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VCAMD_CON0
#define PMIC_RG_LDO_VCAMD_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMD_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VCAMD_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VCAMD_CON0
#define PMIC_RG_LDO_VCAMD_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VCAMD_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VCAMIO_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VCAMIO_CON0
#define PMIC_RG_LDO_VCAMIO_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VCAMIO_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VCAMIO_CON0
#define PMIC_RG_LDO_VCAMIO_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VCAMIO_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VCAMIO_CON0
#define PMIC_RG_LDO_VCAMIO_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VMIPI_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VMIPI_CON0
#define PMIC_RG_LDO_VMIPI_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VMIPI_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VMIPI_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VMIPI_CON0
#define PMIC_RG_LDO_VMIPI_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VMIPI_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VMIPI_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VMIPI_CON0
#define PMIC_RG_LDO_VMIPI_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VMIPI_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VCN33_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VCN33_CON0
#define PMIC_RG_LDO_VCN33_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VCN33_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VCN33_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VCN33_CON0
#define PMIC_RG_LDO_VCN33_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VCN33_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VCN33_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VCN33_CON0
#define PMIC_RG_LDO_VCN33_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VCN33_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VCN18_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VCN18_CON0
#define PMIC_RG_LDO_VCN18_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VCN18_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VCN18_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VCN18_CON0
#define PMIC_RG_LDO_VCN18_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VCN18_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VCN18_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VCN18_CON0
#define PMIC_RG_LDO_VCN18_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VCN18_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VCN28_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VCN28_CON0
#define PMIC_RG_LDO_VCN28_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VCN28_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VCN28_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VCN28_CON0
#define PMIC_RG_LDO_VCN28_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VCN28_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VCN28_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VCN28_CON0
#define PMIC_RG_LDO_VCN28_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VCN28_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VIBR_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VIBR_CON0
#define PMIC_RG_LDO_VIBR_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VIBR_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VIBR_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VIBR_CON0
#define PMIC_RG_LDO_VIBR_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VIBR_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VIBR_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VIBR_CON0
#define PMIC_RG_LDO_VIBR_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VIBR_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VBIF28_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VBIF28_CON0
#define PMIC_RG_LDO_VBIF28_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VBIF28_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VBIF28_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VBIF28_CON0
#define PMIC_RG_LDO_VBIF28_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VBIF28_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VBIF28_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VBIF28_CON0
#define PMIC_RG_LDO_VBIF28_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VBIF28_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VFE28_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VFE28_CON0
#define PMIC_RG_LDO_VFE28_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VFE28_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VFE28_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VFE28_CON0
#define PMIC_RG_LDO_VFE28_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VFE28_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VFE28_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VFE28_CON0
#define PMIC_RG_LDO_VFE28_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VFE28_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VMCH_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VMCH_CON0
#define PMIC_RG_LDO_VMCH_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VMCH_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VMCH_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VMCH_CON0
#define PMIC_RG_LDO_VMCH_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VMCH_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VMCH_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VMCH_CON0
#define PMIC_RG_LDO_VMCH_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VMCH_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VMC_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VMC_CON0
#define PMIC_RG_LDO_VMC_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VMC_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VMC_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VMC_CON0
#define PMIC_RG_LDO_VMC_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VMC_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VMC_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VMC_CON0
#define PMIC_RG_LDO_VMC_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VMC_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VRF18_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VRF18_CON0
#define PMIC_RG_LDO_VRF18_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VRF18_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VRF18_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VRF18_CON0
#define PMIC_RG_LDO_VRF18_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VRF18_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VRF18_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VRF18_CON0
#define PMIC_RG_LDO_VRF18_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VRF18_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VLDO28_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VLDO28_CON0
#define PMIC_RG_LDO_VLDO28_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VLDO28_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VLDO28_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VLDO28_CON0
#define PMIC_RG_LDO_VLDO28_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VLDO28_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VLDO28_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VLDO28_CON0
#define PMIC_RG_LDO_VLDO28_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VLDO28_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VRF12_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VRF12_CON0
#define PMIC_RG_LDO_VRF12_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VRF12_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VRF12_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VRF12_CON0
#define PMIC_RG_LDO_VRF12_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VRF12_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VRF12_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VRF12_CON0
#define PMIC_RG_LDO_VRF12_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VRF12_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_VCAMA_CK_SW_MODE_ADDR MT6356_LDO_TOP_CLK_VCAMA_CON0
#define PMIC_RG_LDO_VCAMA_CK_SW_MODE_MASK 0x1
#define PMIC_RG_LDO_VCAMA_CK_SW_MODE_SHIFT 0
#define PMIC_RG_LDO_VCAMA_CK_SW_EN_ADDR MT6356_LDO_TOP_CLK_VCAMA_CON0
#define PMIC_RG_LDO_VCAMA_CK_SW_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMA_CK_SW_EN_SHIFT 1
#define PMIC_RG_LDO_VCAMA_OSC_SEL_DIS_ADDR MT6356_LDO_TOP_CLK_VCAMA_CON0
#define PMIC_RG_LDO_VCAMA_OSC_SEL_DIS_MASK 0x1
#define PMIC_RG_LDO_VCAMA_OSC_SEL_DIS_SHIFT 2
#define PMIC_RG_LDO_TOP_SWRST_ADDR MT6356_LDO_TOP_RST_CON0
#define PMIC_RG_LDO_TOP_SWRST_MASK 0x1
#define PMIC_RG_LDO_TOP_SWRST_SHIFT 0
#define PMIC_RG_LDO_GON_SWRST_ADDR MT6356_LDO_TOP_RST_CON0
#define PMIC_RG_LDO_GON_SWRST_MASK 0x1
#define PMIC_RG_LDO_GON_SWRST_SHIFT 1
#define PMIC_RG_LDO_GOFF0_SWRST_ADDR MT6356_LDO_TOP_RST_CON0
#define PMIC_RG_LDO_GOFF0_SWRST_MASK 0x1
#define PMIC_RG_LDO_GOFF0_SWRST_SHIFT 2
#define PMIC_RG_LDO_GOFF1_SWRST_ADDR MT6356_LDO_TOP_RST_CON0
#define PMIC_RG_LDO_GOFF1_SWRST_MASK 0x1
#define PMIC_RG_LDO_GOFF1_SWRST_SHIFT 3
#define PMIC_RG_LDO_MULTIUSER_SWRST_ADDR MT6356_LDO_TOP_RST_CON0
#define PMIC_RG_LDO_MULTIUSER_SWRST_MASK 0x1
#define PMIC_RG_LDO_MULTIUSER_SWRST_SHIFT 4
#define PMIC_RG_LDO_FOURUSER_SWRST_ADDR MT6356_LDO_TOP_RST_CON0
#define PMIC_RG_LDO_FOURUSER_SWRST_MASK 0x1
#define PMIC_RG_LDO_FOURUSER_SWRST_SHIFT 5
#define PMIC_RG_LDO_VSRAM_SWRST_ADDR MT6356_LDO_TOP_RST_CON0
#define PMIC_RG_LDO_VSRAM_SWRST_MASK 0x1
#define PMIC_RG_LDO_VSRAM_SWRST_SHIFT 6
#define PMIC_RG_LDO_VRTC_SWRST_ADDR MT6356_LDO_TOP_RST_CON0
#define PMIC_RG_LDO_VRTC_SWRST_MASK 0x1
#define PMIC_RG_LDO_VRTC_SWRST_SHIFT 7
#define PMIC_RG_LDO_ANA_SWRST_ADDR MT6356_LDO_TOP_RST_CON0
#define PMIC_RG_LDO_ANA_SWRST_MASK 0x1
#define PMIC_RG_LDO_ANA_SWRST_SHIFT 8
#define PMIC_LDO_SWRST_CON0_SET_ADDR MT6356_LDO_TOP_RST_CON0_SET
#define PMIC_LDO_SWRST_CON0_SET_MASK 0xFFFF
#define PMIC_LDO_SWRST_CON0_SET_SHIFT 0
#define PMIC_LDO_SWRST_CON0_CLR_ADDR MT6356_LDO_TOP_RST_CON0_CLR
#define PMIC_LDO_SWRST_CON0_CLR_MASK 0xFFFF
#define PMIC_LDO_SWRST_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_EN_VFE28_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VFE28_OC_MASK 0x1
#define PMIC_RG_INT_EN_VFE28_OC_SHIFT 0
#define PMIC_RG_INT_EN_VXO22_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VXO22_OC_MASK 0x1
#define PMIC_RG_INT_EN_VXO22_OC_SHIFT 1
#define PMIC_RG_INT_EN_VRF18_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VRF18_OC_MASK 0x1
#define PMIC_RG_INT_EN_VRF18_OC_SHIFT 2
#define PMIC_RG_INT_EN_VRF12_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VRF12_OC_MASK 0x1
#define PMIC_RG_INT_EN_VRF12_OC_SHIFT 3
#define PMIC_RG_INT_EN_VMIPI_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VMIPI_OC_MASK 0x1
#define PMIC_RG_INT_EN_VMIPI_OC_SHIFT 4
#define PMIC_RG_INT_EN_VCN33_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VCN33_OC_MASK 0x1
#define PMIC_RG_INT_EN_VCN33_OC_SHIFT 5
#define PMIC_RG_INT_EN_VCN28_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VCN28_OC_MASK 0x1
#define PMIC_RG_INT_EN_VCN28_OC_SHIFT 6
#define PMIC_RG_INT_EN_VCN18_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VCN18_OC_MASK 0x1
#define PMIC_RG_INT_EN_VCN18_OC_SHIFT 7
#define PMIC_RG_INT_EN_VCAMA_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VCAMA_OC_MASK 0x1
#define PMIC_RG_INT_EN_VCAMA_OC_SHIFT 8
#define PMIC_RG_INT_EN_VCAMD_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VCAMD_OC_MASK 0x1
#define PMIC_RG_INT_EN_VCAMD_OC_SHIFT 9
#define PMIC_RG_INT_EN_VCAMIO_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VCAMIO_OC_MASK 0x1
#define PMIC_RG_INT_EN_VCAMIO_OC_SHIFT 10
#define PMIC_RG_INT_EN_VLDO28_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VLDO28_OC_MASK 0x1
#define PMIC_RG_INT_EN_VLDO28_OC_SHIFT 11
#define PMIC_RG_INT_EN_VA12_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VA12_OC_MASK 0x1
#define PMIC_RG_INT_EN_VA12_OC_SHIFT 12
#define PMIC_RG_INT_EN_VAUX18_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VAUX18_OC_MASK 0x1
#define PMIC_RG_INT_EN_VAUX18_OC_SHIFT 13
#define PMIC_RG_INT_EN_VAUD28_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VAUD28_OC_MASK 0x1
#define PMIC_RG_INT_EN_VAUD28_OC_SHIFT 14
#define PMIC_RG_INT_EN_VIO28_OC_ADDR MT6356_LDO_TOP_INT_CON0
#define PMIC_RG_INT_EN_VIO28_OC_MASK 0x1
#define PMIC_RG_INT_EN_VIO28_OC_SHIFT 15
#define PMIC_LDO_INT_CON0_SET_ADDR MT6356_LDO_TOP_INT_CON0_SET
#define PMIC_LDO_INT_CON0_SET_MASK 0xFFFF
#define PMIC_LDO_INT_CON0_SET_SHIFT 0
#define PMIC_LDO_INT_CON0_CLR_ADDR MT6356_LDO_TOP_INT_CON0_CLR
#define PMIC_LDO_INT_CON0_CLR_MASK 0xFFFF
#define PMIC_LDO_INT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_EN_VIO18_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VIO18_OC_MASK 0x1
#define PMIC_RG_INT_EN_VIO18_OC_SHIFT 0
#define PMIC_RG_INT_EN_VSRAM_PROC_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VSRAM_PROC_OC_MASK 0x1
#define PMIC_RG_INT_EN_VSRAM_PROC_OC_SHIFT 1
#define PMIC_RG_INT_EN_VSRAM_OTHERS_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VSRAM_OTHERS_OC_MASK 0x1
#define PMIC_RG_INT_EN_VSRAM_OTHERS_OC_SHIFT 2
#define PMIC_RG_INT_EN_VSRAM_GPU_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VSRAM_GPU_OC_MASK 0x1
#define PMIC_RG_INT_EN_VSRAM_GPU_OC_SHIFT 3
#define PMIC_RG_INT_EN_VDRAM_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VDRAM_OC_MASK 0x1
#define PMIC_RG_INT_EN_VDRAM_OC_SHIFT 4
#define PMIC_RG_INT_EN_VMC_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VMC_OC_MASK 0x1
#define PMIC_RG_INT_EN_VMC_OC_SHIFT 5
#define PMIC_RG_INT_EN_VMCH_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VMCH_OC_MASK 0x1
#define PMIC_RG_INT_EN_VMCH_OC_SHIFT 6
#define PMIC_RG_INT_EN_VEMC_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VEMC_OC_MASK 0x1
#define PMIC_RG_INT_EN_VEMC_OC_SHIFT 7
#define PMIC_RG_INT_EN_VSIM1_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VSIM1_OC_MASK 0x1
#define PMIC_RG_INT_EN_VSIM1_OC_SHIFT 8
#define PMIC_RG_INT_EN_VSIM2_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VSIM2_OC_MASK 0x1
#define PMIC_RG_INT_EN_VSIM2_OC_SHIFT 9
#define PMIC_RG_INT_EN_VIBR_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VIBR_OC_MASK 0x1
#define PMIC_RG_INT_EN_VIBR_OC_SHIFT 10
#define PMIC_RG_INT_EN_VUSB_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VUSB_OC_MASK 0x1
#define PMIC_RG_INT_EN_VUSB_OC_SHIFT 11
#define PMIC_RG_INT_EN_VBIF28_OC_ADDR MT6356_LDO_TOP_INT_CON1
#define PMIC_RG_INT_EN_VBIF28_OC_MASK 0x1
#define PMIC_RG_INT_EN_VBIF28_OC_SHIFT 12
#define PMIC_LDO_INT_CON1_SET_ADDR MT6356_LDO_TOP_INT_CON1_SET
#define PMIC_LDO_INT_CON1_SET_MASK 0xFFFF
#define PMIC_LDO_INT_CON1_SET_SHIFT 0
#define PMIC_LDO_INT_CON1_CLR_ADDR MT6356_LDO_TOP_INT_CON1_CLR
#define PMIC_LDO_INT_CON1_CLR_MASK 0xFFFF
#define PMIC_LDO_INT_CON1_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_VFE28_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VFE28_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VFE28_OC_SHIFT 0
#define PMIC_RG_INT_MASK_VXO22_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VXO22_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VXO22_OC_SHIFT 1
#define PMIC_RG_INT_MASK_VRF18_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VRF18_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VRF18_OC_SHIFT 2
#define PMIC_RG_INT_MASK_VRF12_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VRF12_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VRF12_OC_SHIFT 3
#define PMIC_RG_INT_MASK_VMIPI_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VMIPI_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VMIPI_OC_SHIFT 4
#define PMIC_RG_INT_MASK_VCN33_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VCN33_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VCN33_OC_SHIFT 5
#define PMIC_RG_INT_MASK_VCN28_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VCN28_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VCN28_OC_SHIFT 6
#define PMIC_RG_INT_MASK_VCN18_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VCN18_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VCN18_OC_SHIFT 7
#define PMIC_RG_INT_MASK_VCAMA_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VCAMA_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VCAMA_OC_SHIFT 8
#define PMIC_RG_INT_MASK_VCAMD_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VCAMD_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VCAMD_OC_SHIFT 9
#define PMIC_RG_INT_MASK_VCAMIO_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VCAMIO_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VCAMIO_OC_SHIFT 10
#define PMIC_RG_INT_MASK_VLDO28_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VLDO28_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VLDO28_OC_SHIFT 11
#define PMIC_RG_INT_MASK_VA12_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VA12_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VA12_OC_SHIFT 12
#define PMIC_RG_INT_MASK_VAUX18_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VAUX18_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VAUX18_OC_SHIFT 13
#define PMIC_RG_INT_MASK_VAUD28_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VAUD28_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VAUD28_OC_SHIFT 14
#define PMIC_RG_INT_MASK_VIO28_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_VIO28_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VIO28_OC_SHIFT 15
#define PMIC_LDO_INT_MASK_CON0_SET_ADDR MT6356_LDO_TOP_INT_MASK_CON0_SET
#define PMIC_LDO_INT_MASK_CON0_SET_MASK 0xFFFF
#define PMIC_LDO_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_LDO_INT_MASK_CON0_CLR_ADDR MT6356_LDO_TOP_INT_MASK_CON0_CLR
#define PMIC_LDO_INT_MASK_CON0_CLR_MASK 0xFFFF
#define PMIC_LDO_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_VIO18_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VIO18_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VIO18_OC_SHIFT 0
#define PMIC_RG_INT_MASK_VSRAM_PROC_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VSRAM_PROC_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VSRAM_PROC_OC_SHIFT 1
#define PMIC_RG_INT_MASK_VSRAM_OTHERS_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VSRAM_OTHERS_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VSRAM_OTHERS_OC_SHIFT 2
#define PMIC_RG_INT_MASK_VSRAM_GPU_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VSRAM_GPU_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VSRAM_GPU_OC_SHIFT 3
#define PMIC_RG_INT_MASK_VDRAM_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VDRAM_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VDRAM_OC_SHIFT 4
#define PMIC_RG_INT_MASK_VMC_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VMC_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VMC_OC_SHIFT 5
#define PMIC_RG_INT_MASK_VMCH_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VMCH_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VMCH_OC_SHIFT 6
#define PMIC_RG_INT_MASK_VEMC_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VEMC_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VEMC_OC_SHIFT 7
#define PMIC_RG_INT_MASK_VSIM1_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VSIM1_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VSIM1_OC_SHIFT 8
#define PMIC_RG_INT_MASK_VSIM2_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VSIM2_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VSIM2_OC_SHIFT 9
#define PMIC_RG_INT_MASK_VIBR_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VIBR_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VIBR_OC_SHIFT 10
#define PMIC_RG_INT_MASK_VUSB_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VUSB_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VUSB_OC_SHIFT 11
#define PMIC_RG_INT_MASK_VBIF28_OC_ADDR MT6356_LDO_TOP_INT_MASK_CON1
#define PMIC_RG_INT_MASK_VBIF28_OC_MASK 0x1
#define PMIC_RG_INT_MASK_VBIF28_OC_SHIFT 12
#define PMIC_LDO_INT_MASK_CON1_SET_ADDR MT6356_LDO_TOP_INT_MASK_CON1_SET
#define PMIC_LDO_INT_MASK_CON1_SET_MASK 0xFFFF
#define PMIC_LDO_INT_MASK_CON1_SET_SHIFT 0
#define PMIC_LDO_INT_MASK_CON1_CLR_ADDR MT6356_LDO_TOP_INT_MASK_CON1_CLR
#define PMIC_LDO_INT_MASK_CON1_CLR_MASK 0xFFFF
#define PMIC_LDO_INT_MASK_CON1_CLR_SHIFT 0
#define PMIC_RG_INT_STATUS_VFE28_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VFE28_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VFE28_OC_SHIFT 0
#define PMIC_RG_INT_STATUS_VXO22_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VXO22_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VXO22_OC_SHIFT 1
#define PMIC_RG_INT_STATUS_VRF18_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VRF18_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VRF18_OC_SHIFT 2
#define PMIC_RG_INT_STATUS_VRF12_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VRF12_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VRF12_OC_SHIFT 3
#define PMIC_RG_INT_STATUS_VMIPI_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VMIPI_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VMIPI_OC_SHIFT 4
#define PMIC_RG_INT_STATUS_VCN33_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VCN33_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VCN33_OC_SHIFT 5
#define PMIC_RG_INT_STATUS_VCN28_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VCN28_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VCN28_OC_SHIFT 6
#define PMIC_RG_INT_STATUS_VCN18_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VCN18_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VCN18_OC_SHIFT 7
#define PMIC_RG_INT_STATUS_VCAMA_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VCAMA_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VCAMA_OC_SHIFT 8
#define PMIC_RG_INT_STATUS_VCAMD_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VCAMD_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VCAMD_OC_SHIFT 9
#define PMIC_RG_INT_STATUS_VCAMIO_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VCAMIO_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VCAMIO_OC_SHIFT 10
#define PMIC_RG_INT_STATUS_VLDO28_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VLDO28_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VLDO28_OC_SHIFT 11
#define PMIC_RG_INT_STATUS_VA12_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VA12_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VA12_OC_SHIFT 12
#define PMIC_RG_INT_STATUS_VAUX18_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VAUX18_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VAUX18_OC_SHIFT 13
#define PMIC_RG_INT_STATUS_VAUD28_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VAUD28_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VAUD28_OC_SHIFT 14
#define PMIC_RG_INT_STATUS_VIO28_OC_ADDR MT6356_LDO_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_VIO28_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VIO28_OC_SHIFT 15
#define PMIC_RG_INT_STATUS_VIO18_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VIO18_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VIO18_OC_SHIFT 0
#define PMIC_RG_INT_STATUS_VSRAM_PROC_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VSRAM_PROC_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VSRAM_PROC_OC_SHIFT 1
#define PMIC_RG_INT_STATUS_VSRAM_OTHERS_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VSRAM_OTHERS_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VSRAM_OTHERS_OC_SHIFT 2
#define PMIC_RG_INT_STATUS_VSRAM_GPU_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VSRAM_GPU_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VSRAM_GPU_OC_SHIFT 3
#define PMIC_RG_INT_STATUS_VDRAM_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VDRAM_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VDRAM_OC_SHIFT 4
#define PMIC_RG_INT_STATUS_VMC_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VMC_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VMC_OC_SHIFT 5
#define PMIC_RG_INT_STATUS_VMCH_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VMCH_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VMCH_OC_SHIFT 6
#define PMIC_RG_INT_STATUS_VEMC_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VEMC_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VEMC_OC_SHIFT 7
#define PMIC_RG_INT_STATUS_VSIM1_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VSIM1_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VSIM1_OC_SHIFT 8
#define PMIC_RG_INT_STATUS_VSIM2_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VSIM2_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VSIM2_OC_SHIFT 9
#define PMIC_RG_INT_STATUS_VIBR_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VIBR_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VIBR_OC_SHIFT 10
#define PMIC_RG_INT_STATUS_VUSB_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VUSB_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VUSB_OC_SHIFT 11
#define PMIC_RG_INT_STATUS_VBIF28_OC_ADDR MT6356_LDO_TOP_INT_STATUS1
#define PMIC_RG_INT_STATUS_VBIF28_OC_MASK 0x1
#define PMIC_RG_INT_STATUS_VBIF28_OC_SHIFT 12
#define PMIC_RG_INT_RAW_STATUS_VFE28_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VFE28_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VFE28_OC_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_VXO22_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VXO22_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VXO22_OC_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_VRF18_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VRF18_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VRF18_OC_SHIFT 2
#define PMIC_RG_INT_RAW_STATUS_VRF12_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VRF12_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VRF12_OC_SHIFT 3
#define PMIC_RG_INT_RAW_STATUS_VMIPI_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VMIPI_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VMIPI_OC_SHIFT 4
#define PMIC_RG_INT_RAW_STATUS_VCN33_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VCN33_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VCN33_OC_SHIFT 5
#define PMIC_RG_INT_RAW_STATUS_VCN28_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VCN28_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VCN28_OC_SHIFT 6
#define PMIC_RG_INT_RAW_STATUS_VCN18_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VCN18_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VCN18_OC_SHIFT 7
#define PMIC_RG_INT_RAW_STATUS_VCAMA_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VCAMA_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VCAMA_OC_SHIFT 8
#define PMIC_RG_INT_RAW_STATUS_VCAMD_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VCAMD_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VCAMD_OC_SHIFT 9
#define PMIC_RG_INT_RAW_STATUS_VCAMIO_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VCAMIO_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VCAMIO_OC_SHIFT 10
#define PMIC_RG_INT_RAW_STATUS_VLDO28_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VLDO28_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VLDO28_OC_SHIFT 11
#define PMIC_RG_INT_RAW_STATUS_VA12_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VA12_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VA12_OC_SHIFT 12
#define PMIC_RG_INT_RAW_STATUS_VAUX18_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VAUX18_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VAUX18_OC_SHIFT 13
#define PMIC_RG_INT_RAW_STATUS_VAUD28_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VAUD28_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VAUD28_OC_SHIFT 14
#define PMIC_RG_INT_RAW_STATUS_VIO28_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_VIO28_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VIO28_OC_SHIFT 15
#define PMIC_RG_INT_RAW_STATUS_VIO18_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VIO18_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VIO18_OC_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_VSRAM_PROC_OC_ADDR                             \
	MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VSRAM_PROC_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VSRAM_PROC_OC_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_VSRAM_OTHERS_OC_ADDR                           \
	MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VSRAM_OTHERS_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VSRAM_OTHERS_OC_SHIFT 2
#define PMIC_RG_INT_RAW_STATUS_VSRAM_GPU_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VSRAM_GPU_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VSRAM_GPU_OC_SHIFT 3
#define PMIC_RG_INT_RAW_STATUS_VDRAM_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VDRAM_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VDRAM_OC_SHIFT 4
#define PMIC_RG_INT_RAW_STATUS_VMC_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VMC_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VMC_OC_SHIFT 5
#define PMIC_RG_INT_RAW_STATUS_VMCH_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VMCH_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VMCH_OC_SHIFT 6
#define PMIC_RG_INT_RAW_STATUS_VEMC_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VEMC_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VEMC_OC_SHIFT 7
#define PMIC_RG_INT_RAW_STATUS_VSIM1_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VSIM1_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VSIM1_OC_SHIFT 8
#define PMIC_RG_INT_RAW_STATUS_VSIM2_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VSIM2_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VSIM2_OC_SHIFT 9
#define PMIC_RG_INT_RAW_STATUS_VIBR_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VIBR_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VIBR_OC_SHIFT 10
#define PMIC_RG_INT_RAW_STATUS_VUSB_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VUSB_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VUSB_OC_SHIFT 11
#define PMIC_RG_INT_RAW_STATUS_VBIF28_OC_ADDR MT6356_LDO_TOP_INT_RAW_STATUS1
#define PMIC_RG_INT_RAW_STATUS_VBIF28_OC_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_VBIF28_OC_SHIFT 12
#define PMIC_RG_LDO_MON_FLAG_SEL_ADDR MT6356_LDO_TEST_CON0
#define PMIC_RG_LDO_MON_FLAG_SEL_MASK 0xFF
#define PMIC_RG_LDO_MON_FLAG_SEL_SHIFT 0
#define PMIC_RG_LDO_CTL_FLAG_EN_ADDR MT6356_LDO_TEST_CON0
#define PMIC_RG_LDO_CTL_FLAG_EN_MASK 0x1
#define PMIC_RG_LDO_CTL_FLAG_EN_SHIFT 8
#define PMIC_RG_LDO_INT_FLAG_EN_ADDR MT6356_LDO_TEST_CON0
#define PMIC_RG_LDO_INT_FLAG_EN_MASK 0x1
#define PMIC_RG_LDO_INT_FLAG_EN_SHIFT 9
#define PMIC_RG_LDO_MON_GRP_SEL_ADDR MT6356_LDO_TEST_CON0
#define PMIC_RG_LDO_MON_GRP_SEL_MASK 0x1
#define PMIC_RG_LDO_MON_GRP_SEL_SHIFT 10
#define PMIC_RG_LDO_WDT_MODE_ADDR MT6356_LDO_TOP_WDT_CON0
#define PMIC_RG_LDO_WDT_MODE_MASK 0x1
#define PMIC_RG_LDO_WDT_MODE_SHIFT 0
#define PMIC_RG_LDO_TOP_RSV0_ADDR MT6356_LDO_TOP_RSV_CON0
#define PMIC_RG_LDO_TOP_RSV0_MASK 0xFFFF
#define PMIC_RG_LDO_TOP_RSV0_SHIFT 0
#define PMIC_RG_LDO_TOP_RSV1_ADDR MT6356_LDO_TOP_RSV_CON1
#define PMIC_RG_LDO_TOP_RSV1_MASK 0xFFFF
#define PMIC_RG_LDO_TOP_RSV1_SHIFT 0
#define PMIC_LDO_GON_ANA_ID_ADDR MT6356_LDO_GON_DSN_ID
#define PMIC_LDO_GON_ANA_ID_MASK 0xFF
#define PMIC_LDO_GON_ANA_ID_SHIFT 0
#define PMIC_LDO_GON_DIG_ID_ADDR MT6356_LDO_GON_DSN_ID
#define PMIC_LDO_GON_DIG_ID_MASK 0xFF
#define PMIC_LDO_GON_DIG_ID_SHIFT 8
#define PMIC_LDO_GON_ANA_MINOR_REV_ADDR MT6356_LDO_GON_DSN_REV0
#define PMIC_LDO_GON_ANA_MINOR_REV_MASK 0xF
#define PMIC_LDO_GON_ANA_MINOR_REV_SHIFT 0
#define PMIC_LDO_GON_ANA_MAJOR_REV_ADDR MT6356_LDO_GON_DSN_REV0
#define PMIC_LDO_GON_ANA_MAJOR_REV_MASK 0xF
#define PMIC_LDO_GON_ANA_MAJOR_REV_SHIFT 4
#define PMIC_LDO_GON_DIG_MINOR_REV_ADDR MT6356_LDO_GON_DSN_REV0
#define PMIC_LDO_GON_DIG_MINOR_REV_MASK 0xF
#define PMIC_LDO_GON_DIG_MINOR_REV_SHIFT 8
#define PMIC_LDO_GON_DIG_MAJOR_REV_ADDR MT6356_LDO_GON_DSN_REV0
#define PMIC_LDO_GON_DIG_MAJOR_REV_MASK 0xF
#define PMIC_LDO_GON_DIG_MAJOR_REV_SHIFT 12
#define PMIC_LDO_GON_SW_MINOR_REV_ADDR MT6356_LDO_GON_DSN_REV1
#define PMIC_LDO_GON_SW_MINOR_REV_MASK 0xF
#define PMIC_LDO_GON_SW_MINOR_REV_SHIFT 0
#define PMIC_LDO_GON_SW_MAJOR_REV_ADDR MT6356_LDO_GON_DSN_REV1
#define PMIC_LDO_GON_SW_MAJOR_REV_MASK 0xF
#define PMIC_LDO_GON_SW_MAJOR_REV_SHIFT 4
#define PMIC_LDO_GON_ESP_ADDR MT6356_LDO_GON_DSN_REV1
#define PMIC_LDO_GON_ESP_MASK 0xFF
#define PMIC_LDO_GON_ESP_SHIFT 8
#define PMIC_RG_LDO_GON_RSV0_ADDR MT6356_LDO_GON_RSV_CON0
#define PMIC_RG_LDO_GON_RSV0_MASK 0xFFFF
#define PMIC_RG_LDO_GON_RSV0_SHIFT 0
#define PMIC_RG_LDO_GON_RSV1_ADDR MT6356_LDO_GON_RSV_CON1
#define PMIC_RG_LDO_GON_RSV1_MASK 0xFFFF
#define PMIC_RG_LDO_GON_RSV1_SHIFT 0
#define PMIC_RG_LDO_VXO22_EN_ADDR MT6356_LDO_VXO22_CON0
#define PMIC_RG_LDO_VXO22_EN_MASK 0x1
#define PMIC_RG_LDO_VXO22_EN_SHIFT 0
#define PMIC_RG_LDO_VXO22_LP_ADDR MT6356_LDO_VXO22_CON0
#define PMIC_RG_LDO_VXO22_LP_MASK 0x1
#define PMIC_RG_LDO_VXO22_LP_SHIFT 1
#define PMIC_RG_LDO_VXO22_SW_OP_EN_ADDR MT6356_LDO_VXO22_OP_EN
#define PMIC_RG_LDO_VXO22_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VXO22_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VXO22_HW0_OP_EN_ADDR MT6356_LDO_VXO22_OP_EN
#define PMIC_RG_LDO_VXO22_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VXO22_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VXO22_HW1_OP_EN_ADDR MT6356_LDO_VXO22_OP_EN
#define PMIC_RG_LDO_VXO22_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VXO22_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VXO22_HW2_OP_EN_ADDR MT6356_LDO_VXO22_OP_EN
#define PMIC_RG_LDO_VXO22_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VXO22_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VXO22_OP_EN_SET_ADDR MT6356_LDO_VXO22_OP_EN_SET
#define PMIC_RG_LDO_VXO22_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VXO22_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VXO22_OP_EN_CLR_ADDR MT6356_LDO_VXO22_OP_EN_CLR
#define PMIC_RG_LDO_VXO22_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VXO22_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VXO22_HW0_OP_CFG_ADDR MT6356_LDO_VXO22_OP_CFG
#define PMIC_RG_LDO_VXO22_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VXO22_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VXO22_HW1_OP_CFG_ADDR MT6356_LDO_VXO22_OP_CFG
#define PMIC_RG_LDO_VXO22_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VXO22_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VXO22_HW2_OP_CFG_ADDR MT6356_LDO_VXO22_OP_CFG
#define PMIC_RG_LDO_VXO22_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VXO22_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VXO22_ON_OP_ADDR MT6356_LDO_VXO22_OP_CFG
#define PMIC_RG_LDO_VXO22_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VXO22_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VXO22_LP_OP_ADDR MT6356_LDO_VXO22_OP_CFG
#define PMIC_RG_LDO_VXO22_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VXO22_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VXO22_OP_CFG_SET_ADDR MT6356_LDO_VXO22_OP_CFG_SET
#define PMIC_RG_LDO_VXO22_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VXO22_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VXO22_OP_CFG_CLR_ADDR MT6356_LDO_VXO22_OP_CFG_CLR
#define PMIC_RG_LDO_VXO22_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VXO22_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VXO22_MODE_ADDR MT6356_LDO_VXO22_CON1
#define PMIC_DA_VXO22_MODE_MASK 0x1
#define PMIC_DA_VXO22_MODE_SHIFT 8
#define PMIC_RG_LDO_VXO22_STBTD_ADDR MT6356_LDO_VXO22_CON1
#define PMIC_RG_LDO_VXO22_STBTD_MASK 0x3
#define PMIC_RG_LDO_VXO22_STBTD_SHIFT 9
#define PMIC_DA_VXO22_STB_ADDR MT6356_LDO_VXO22_CON1
#define PMIC_DA_VXO22_STB_MASK 0x1
#define PMIC_DA_VXO22_STB_SHIFT 14
#define PMIC_DA_VXO22_EN_ADDR MT6356_LDO_VXO22_CON1
#define PMIC_DA_VXO22_EN_MASK 0x1
#define PMIC_DA_VXO22_EN_SHIFT 15
#define PMIC_RG_LDO_VXO22_OCFB_EN_ADDR MT6356_LDO_VXO22_CON2
#define PMIC_RG_LDO_VXO22_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VXO22_OCFB_EN_SHIFT 9
#define PMIC_DA_VXO22_OCFB_EN_ADDR MT6356_LDO_VXO22_CON2
#define PMIC_DA_VXO22_OCFB_EN_MASK 0x1
#define PMIC_DA_VXO22_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VXO22_DUMMY_LOAD_ADDR MT6356_LDO_VXO22_CON3
#define PMIC_RG_LDO_VXO22_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VXO22_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VXO22_DUMMY_LOAD_ADDR MT6356_LDO_VXO22_CON3
#define PMIC_DA_VXO22_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VXO22_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VA12_EN_ADDR MT6356_LDO_VA12_CON0
#define PMIC_RG_LDO_VA12_EN_MASK 0x1
#define PMIC_RG_LDO_VA12_EN_SHIFT 0
#define PMIC_RG_LDO_VA12_LP_ADDR MT6356_LDO_VA12_CON0
#define PMIC_RG_LDO_VA12_LP_MASK 0x1
#define PMIC_RG_LDO_VA12_LP_SHIFT 1
#define PMIC_RG_LDO_VA12_SW_OP_EN_ADDR MT6356_LDO_VA12_OP_EN
#define PMIC_RG_LDO_VA12_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VA12_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VA12_HW0_OP_EN_ADDR MT6356_LDO_VA12_OP_EN
#define PMIC_RG_LDO_VA12_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VA12_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VA12_HW1_OP_EN_ADDR MT6356_LDO_VA12_OP_EN
#define PMIC_RG_LDO_VA12_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VA12_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VA12_HW2_OP_EN_ADDR MT6356_LDO_VA12_OP_EN
#define PMIC_RG_LDO_VA12_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VA12_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VA12_OP_EN_SET_ADDR MT6356_LDO_VA12_OP_EN_SET
#define PMIC_RG_LDO_VA12_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VA12_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VA12_OP_EN_CLR_ADDR MT6356_LDO_VA12_OP_EN_CLR
#define PMIC_RG_LDO_VA12_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VA12_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VA12_HW0_OP_CFG_ADDR MT6356_LDO_VA12_OP_CFG
#define PMIC_RG_LDO_VA12_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VA12_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VA12_HW1_OP_CFG_ADDR MT6356_LDO_VA12_OP_CFG
#define PMIC_RG_LDO_VA12_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VA12_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VA12_HW2_OP_CFG_ADDR MT6356_LDO_VA12_OP_CFG
#define PMIC_RG_LDO_VA12_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VA12_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VA12_ON_OP_ADDR MT6356_LDO_VA12_OP_CFG
#define PMIC_RG_LDO_VA12_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VA12_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VA12_LP_OP_ADDR MT6356_LDO_VA12_OP_CFG
#define PMIC_RG_LDO_VA12_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VA12_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VA12_OP_CFG_SET_ADDR MT6356_LDO_VA12_OP_CFG_SET
#define PMIC_RG_LDO_VA12_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VA12_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VA12_OP_CFG_CLR_ADDR MT6356_LDO_VA12_OP_CFG_CLR
#define PMIC_RG_LDO_VA12_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VA12_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VA12_MODE_ADDR MT6356_LDO_VA12_CON1
#define PMIC_DA_VA12_MODE_MASK 0x1
#define PMIC_DA_VA12_MODE_SHIFT 8
#define PMIC_RG_LDO_VA12_STBTD_ADDR MT6356_LDO_VA12_CON1
#define PMIC_RG_LDO_VA12_STBTD_MASK 0x3
#define PMIC_RG_LDO_VA12_STBTD_SHIFT 9
#define PMIC_DA_VA12_STB_ADDR MT6356_LDO_VA12_CON1
#define PMIC_DA_VA12_STB_MASK 0x1
#define PMIC_DA_VA12_STB_SHIFT 14
#define PMIC_DA_VA12_EN_ADDR MT6356_LDO_VA12_CON1
#define PMIC_DA_VA12_EN_MASK 0x1
#define PMIC_DA_VA12_EN_SHIFT 15
#define PMIC_RG_LDO_VA12_OCFB_EN_ADDR MT6356_LDO_VA12_CON2
#define PMIC_RG_LDO_VA12_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VA12_OCFB_EN_SHIFT 9
#define PMIC_DA_VA12_OCFB_EN_ADDR MT6356_LDO_VA12_CON2
#define PMIC_DA_VA12_OCFB_EN_MASK 0x1
#define PMIC_DA_VA12_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VA12_DUMMY_LOAD_ADDR MT6356_LDO_VA12_CON3
#define PMIC_RG_LDO_VA12_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VA12_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VA12_DUMMY_LOAD_ADDR MT6356_LDO_VA12_CON3
#define PMIC_DA_VA12_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VA12_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VAUX18_EN_ADDR MT6356_LDO_VAUX18_CON0
#define PMIC_RG_LDO_VAUX18_EN_MASK 0x1
#define PMIC_RG_LDO_VAUX18_EN_SHIFT 0
#define PMIC_RG_LDO_VAUX18_LP_ADDR MT6356_LDO_VAUX18_CON0
#define PMIC_RG_LDO_VAUX18_LP_MASK 0x1
#define PMIC_RG_LDO_VAUX18_LP_SHIFT 1
#define PMIC_RG_LDO_VAUX18_SW_OP_EN_ADDR MT6356_LDO_VAUX18_OP_EN
#define PMIC_RG_LDO_VAUX18_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VAUX18_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VAUX18_HW0_OP_EN_ADDR MT6356_LDO_VAUX18_OP_EN
#define PMIC_RG_LDO_VAUX18_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VAUX18_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VAUX18_HW1_OP_EN_ADDR MT6356_LDO_VAUX18_OP_EN
#define PMIC_RG_LDO_VAUX18_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VAUX18_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VAUX18_HW2_OP_EN_ADDR MT6356_LDO_VAUX18_OP_EN
#define PMIC_RG_LDO_VAUX18_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VAUX18_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VAUX18_OP_EN_SET_ADDR MT6356_LDO_VAUX18_OP_EN_SET
#define PMIC_RG_LDO_VAUX18_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VAUX18_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VAUX18_OP_EN_CLR_ADDR MT6356_LDO_VAUX18_OP_EN_CLR
#define PMIC_RG_LDO_VAUX18_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VAUX18_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VAUX18_HW0_OP_CFG_ADDR MT6356_LDO_VAUX18_OP_CFG
#define PMIC_RG_LDO_VAUX18_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VAUX18_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VAUX18_HW1_OP_CFG_ADDR MT6356_LDO_VAUX18_OP_CFG
#define PMIC_RG_LDO_VAUX18_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VAUX18_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VAUX18_HW2_OP_CFG_ADDR MT6356_LDO_VAUX18_OP_CFG
#define PMIC_RG_LDO_VAUX18_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VAUX18_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VAUX18_ON_OP_ADDR MT6356_LDO_VAUX18_OP_CFG
#define PMIC_RG_LDO_VAUX18_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VAUX18_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VAUX18_LP_OP_ADDR MT6356_LDO_VAUX18_OP_CFG
#define PMIC_RG_LDO_VAUX18_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VAUX18_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VAUX18_OP_CFG_SET_ADDR MT6356_LDO_VAUX18_OP_CFG_SET
#define PMIC_RG_LDO_VAUX18_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VAUX18_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VAUX18_OP_CFG_CLR_ADDR MT6356_LDO_VAUX18_OP_CFG_CLR
#define PMIC_RG_LDO_VAUX18_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VAUX18_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VAUX18_MODE_ADDR MT6356_LDO_VAUX18_CON1
#define PMIC_DA_VAUX18_MODE_MASK 0x1
#define PMIC_DA_VAUX18_MODE_SHIFT 8
#define PMIC_RG_LDO_VAUX18_STBTD_ADDR MT6356_LDO_VAUX18_CON1
#define PMIC_RG_LDO_VAUX18_STBTD_MASK 0x3
#define PMIC_RG_LDO_VAUX18_STBTD_SHIFT 9
#define PMIC_DA_VAUX18_STB_ADDR MT6356_LDO_VAUX18_CON1
#define PMIC_DA_VAUX18_STB_MASK 0x1
#define PMIC_DA_VAUX18_STB_SHIFT 14
#define PMIC_DA_VAUX18_EN_ADDR MT6356_LDO_VAUX18_CON1
#define PMIC_DA_VAUX18_EN_MASK 0x1
#define PMIC_DA_VAUX18_EN_SHIFT 15
#define PMIC_RG_LDO_VAUX18_AUXADC_PWDB_EN_ADDR MT6356_LDO_VAUX18_CON2
#define PMIC_RG_LDO_VAUX18_AUXADC_PWDB_EN_MASK 0x1
#define PMIC_RG_LDO_VAUX18_AUXADC_PWDB_EN_SHIFT 2
#define PMIC_RG_LDO_VAUX18_OCFB_EN_ADDR MT6356_LDO_VAUX18_CON2
#define PMIC_RG_LDO_VAUX18_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VAUX18_OCFB_EN_SHIFT 9
#define PMIC_DA_VAUX18_OCFB_EN_ADDR MT6356_LDO_VAUX18_CON2
#define PMIC_DA_VAUX18_OCFB_EN_MASK 0x1
#define PMIC_DA_VAUX18_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VAUX18_DUMMY_LOAD_ADDR MT6356_LDO_VAUX18_CON3
#define PMIC_RG_LDO_VAUX18_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VAUX18_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VAUX18_DUMMY_LOAD_ADDR MT6356_LDO_VAUX18_CON3
#define PMIC_DA_VAUX18_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VAUX18_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VAUD28_EN_ADDR MT6356_LDO_VAUD28_CON0
#define PMIC_RG_LDO_VAUD28_EN_MASK 0x1
#define PMIC_RG_LDO_VAUD28_EN_SHIFT 0
#define PMIC_RG_LDO_VAUD28_LP_ADDR MT6356_LDO_VAUD28_CON0
#define PMIC_RG_LDO_VAUD28_LP_MASK 0x1
#define PMIC_RG_LDO_VAUD28_LP_SHIFT 1
#define PMIC_RG_LDO_VAUD28_SW_OP_EN_ADDR MT6356_LDO_VAUD28_OP_EN
#define PMIC_RG_LDO_VAUD28_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VAUD28_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VAUD28_HW0_OP_EN_ADDR MT6356_LDO_VAUD28_OP_EN
#define PMIC_RG_LDO_VAUD28_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VAUD28_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VAUD28_HW1_OP_EN_ADDR MT6356_LDO_VAUD28_OP_EN
#define PMIC_RG_LDO_VAUD28_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VAUD28_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VAUD28_HW2_OP_EN_ADDR MT6356_LDO_VAUD28_OP_EN
#define PMIC_RG_LDO_VAUD28_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VAUD28_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VAUD28_OP_EN_SET_ADDR MT6356_LDO_VAUD28_OP_EN_SET
#define PMIC_RG_LDO_VAUD28_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VAUD28_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VAUD28_OP_EN_CLR_ADDR MT6356_LDO_VAUD28_OP_EN_CLR
#define PMIC_RG_LDO_VAUD28_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VAUD28_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VAUD28_HW0_OP_CFG_ADDR MT6356_LDO_VAUD28_OP_CFG
#define PMIC_RG_LDO_VAUD28_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VAUD28_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VAUD28_HW1_OP_CFG_ADDR MT6356_LDO_VAUD28_OP_CFG
#define PMIC_RG_LDO_VAUD28_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VAUD28_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VAUD28_HW2_OP_CFG_ADDR MT6356_LDO_VAUD28_OP_CFG
#define PMIC_RG_LDO_VAUD28_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VAUD28_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VAUD28_ON_OP_ADDR MT6356_LDO_VAUD28_OP_CFG
#define PMIC_RG_LDO_VAUD28_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VAUD28_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VAUD28_LP_OP_ADDR MT6356_LDO_VAUD28_OP_CFG
#define PMIC_RG_LDO_VAUD28_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VAUD28_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VAUD28_OP_CFG_SET_ADDR MT6356_LDO_VAUD28_OP_CFG_SET
#define PMIC_RG_LDO_VAUD28_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VAUD28_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VAUD28_OP_CFG_CLR_ADDR MT6356_LDO_VAUD28_OP_CFG_CLR
#define PMIC_RG_LDO_VAUD28_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VAUD28_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VAUD28_MODE_ADDR MT6356_LDO_VAUD28_CON1
#define PMIC_DA_VAUD28_MODE_MASK 0x1
#define PMIC_DA_VAUD28_MODE_SHIFT 8
#define PMIC_RG_LDO_VAUD28_STBTD_ADDR MT6356_LDO_VAUD28_CON1
#define PMIC_RG_LDO_VAUD28_STBTD_MASK 0x3
#define PMIC_RG_LDO_VAUD28_STBTD_SHIFT 9
#define PMIC_DA_VAUD28_STB_ADDR MT6356_LDO_VAUD28_CON1
#define PMIC_DA_VAUD28_STB_MASK 0x1
#define PMIC_DA_VAUD28_STB_SHIFT 14
#define PMIC_DA_VAUD28_EN_ADDR MT6356_LDO_VAUD28_CON1
#define PMIC_DA_VAUD28_EN_MASK 0x1
#define PMIC_DA_VAUD28_EN_SHIFT 15
#define PMIC_RG_LDO_VAUD28_AUXADC_PWDB_EN_ADDR MT6356_LDO_VAUD28_CON2
#define PMIC_RG_LDO_VAUD28_AUXADC_PWDB_EN_MASK 0x1
#define PMIC_RG_LDO_VAUD28_AUXADC_PWDB_EN_SHIFT 2
#define PMIC_RG_LDO_VAUD28_OCFB_EN_ADDR MT6356_LDO_VAUD28_CON2
#define PMIC_RG_LDO_VAUD28_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VAUD28_OCFB_EN_SHIFT 9
#define PMIC_DA_VAUD28_OCFB_EN_ADDR MT6356_LDO_VAUD28_CON2
#define PMIC_DA_VAUD28_OCFB_EN_MASK 0x1
#define PMIC_DA_VAUD28_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VAUD28_DUMMY_LOAD_ADDR MT6356_LDO_VAUD28_CON3
#define PMIC_RG_LDO_VAUD28_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VAUD28_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VAUD28_DUMMY_LOAD_ADDR MT6356_LDO_VAUD28_CON3
#define PMIC_DA_VAUD28_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VAUD28_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VIO28_EN_ADDR MT6356_LDO_VIO28_CON0
#define PMIC_RG_LDO_VIO28_EN_MASK 0x1
#define PMIC_RG_LDO_VIO28_EN_SHIFT 0
#define PMIC_RG_LDO_VIO28_LP_ADDR MT6356_LDO_VIO28_CON0
#define PMIC_RG_LDO_VIO28_LP_MASK 0x1
#define PMIC_RG_LDO_VIO28_LP_SHIFT 1
#define PMIC_RG_LDO_VIO28_SW_OP_EN_ADDR MT6356_LDO_VIO28_OP_EN
#define PMIC_RG_LDO_VIO28_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIO28_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VIO28_HW0_OP_EN_ADDR MT6356_LDO_VIO28_OP_EN
#define PMIC_RG_LDO_VIO28_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIO28_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VIO28_HW1_OP_EN_ADDR MT6356_LDO_VIO28_OP_EN
#define PMIC_RG_LDO_VIO28_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIO28_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VIO28_HW2_OP_EN_ADDR MT6356_LDO_VIO28_OP_EN
#define PMIC_RG_LDO_VIO28_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIO28_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VIO28_OP_EN_SET_ADDR MT6356_LDO_VIO28_OP_EN_SET
#define PMIC_RG_LDO_VIO28_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VIO28_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VIO28_OP_EN_CLR_ADDR MT6356_LDO_VIO28_OP_EN_CLR
#define PMIC_RG_LDO_VIO28_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VIO28_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VIO28_HW0_OP_CFG_ADDR MT6356_LDO_VIO28_OP_CFG
#define PMIC_RG_LDO_VIO28_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VIO28_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VIO28_HW1_OP_CFG_ADDR MT6356_LDO_VIO28_OP_CFG
#define PMIC_RG_LDO_VIO28_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VIO28_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VIO28_HW2_OP_CFG_ADDR MT6356_LDO_VIO28_OP_CFG
#define PMIC_RG_LDO_VIO28_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VIO28_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VIO28_ON_OP_ADDR MT6356_LDO_VIO28_OP_CFG
#define PMIC_RG_LDO_VIO28_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VIO28_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VIO28_LP_OP_ADDR MT6356_LDO_VIO28_OP_CFG
#define PMIC_RG_LDO_VIO28_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VIO28_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VIO28_OP_CFG_SET_ADDR MT6356_LDO_VIO28_OP_CFG_SET
#define PMIC_RG_LDO_VIO28_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VIO28_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VIO28_OP_CFG_CLR_ADDR MT6356_LDO_VIO28_OP_CFG_CLR
#define PMIC_RG_LDO_VIO28_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VIO28_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VIO28_MODE_ADDR MT6356_LDO_VIO28_CON1
#define PMIC_DA_VIO28_MODE_MASK 0x1
#define PMIC_DA_VIO28_MODE_SHIFT 8
#define PMIC_RG_LDO_VIO28_STBTD_ADDR MT6356_LDO_VIO28_CON1
#define PMIC_RG_LDO_VIO28_STBTD_MASK 0x3
#define PMIC_RG_LDO_VIO28_STBTD_SHIFT 9
#define PMIC_DA_VIO28_STB_ADDR MT6356_LDO_VIO28_CON1
#define PMIC_DA_VIO28_STB_MASK 0x1
#define PMIC_DA_VIO28_STB_SHIFT 14
#define PMIC_DA_VIO28_EN_ADDR MT6356_LDO_VIO28_CON1
#define PMIC_DA_VIO28_EN_MASK 0x1
#define PMIC_DA_VIO28_EN_SHIFT 15
#define PMIC_RG_LDO_VIO28_OCFB_EN_ADDR MT6356_LDO_VIO28_CON2
#define PMIC_RG_LDO_VIO28_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VIO28_OCFB_EN_SHIFT 9
#define PMIC_DA_VIO28_OCFB_EN_ADDR MT6356_LDO_VIO28_CON2
#define PMIC_DA_VIO28_OCFB_EN_MASK 0x1
#define PMIC_DA_VIO28_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VIO28_DUMMY_LOAD_ADDR MT6356_LDO_VIO28_CON3
#define PMIC_RG_LDO_VIO28_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VIO28_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VIO28_DUMMY_LOAD_ADDR MT6356_LDO_VIO28_CON3
#define PMIC_DA_VIO28_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VIO28_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VIO18_EN_ADDR MT6356_LDO_VIO18_CON0
#define PMIC_RG_LDO_VIO18_EN_MASK 0x1
#define PMIC_RG_LDO_VIO18_EN_SHIFT 0
#define PMIC_RG_LDO_VIO18_LP_ADDR MT6356_LDO_VIO18_CON0
#define PMIC_RG_LDO_VIO18_LP_MASK 0x1
#define PMIC_RG_LDO_VIO18_LP_SHIFT 1
#define PMIC_RG_LDO_VIO18_SW_OP_EN_ADDR MT6356_LDO_VIO18_OP_EN
#define PMIC_RG_LDO_VIO18_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIO18_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VIO18_HW0_OP_EN_ADDR MT6356_LDO_VIO18_OP_EN
#define PMIC_RG_LDO_VIO18_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIO18_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VIO18_HW1_OP_EN_ADDR MT6356_LDO_VIO18_OP_EN
#define PMIC_RG_LDO_VIO18_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIO18_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VIO18_HW2_OP_EN_ADDR MT6356_LDO_VIO18_OP_EN
#define PMIC_RG_LDO_VIO18_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIO18_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VIO18_OP_EN_SET_ADDR MT6356_LDO_VIO18_OP_EN_SET
#define PMIC_RG_LDO_VIO18_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VIO18_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VIO18_OP_EN_CLR_ADDR MT6356_LDO_VIO18_OP_EN_CLR
#define PMIC_RG_LDO_VIO18_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VIO18_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VIO18_HW0_OP_CFG_ADDR MT6356_LDO_VIO18_OP_CFG
#define PMIC_RG_LDO_VIO18_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VIO18_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VIO18_HW1_OP_CFG_ADDR MT6356_LDO_VIO18_OP_CFG
#define PMIC_RG_LDO_VIO18_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VIO18_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VIO18_HW2_OP_CFG_ADDR MT6356_LDO_VIO18_OP_CFG
#define PMIC_RG_LDO_VIO18_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VIO18_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VIO18_ON_OP_ADDR MT6356_LDO_VIO18_OP_CFG
#define PMIC_RG_LDO_VIO18_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VIO18_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VIO18_LP_OP_ADDR MT6356_LDO_VIO18_OP_CFG
#define PMIC_RG_LDO_VIO18_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VIO18_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VIO18_OP_CFG_SET_ADDR MT6356_LDO_VIO18_OP_CFG_SET
#define PMIC_RG_LDO_VIO18_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VIO18_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VIO18_OP_CFG_CLR_ADDR MT6356_LDO_VIO18_OP_CFG_CLR
#define PMIC_RG_LDO_VIO18_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VIO18_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VIO18_MODE_ADDR MT6356_LDO_VIO18_CON1
#define PMIC_DA_VIO18_MODE_MASK 0x1
#define PMIC_DA_VIO18_MODE_SHIFT 8
#define PMIC_RG_LDO_VIO18_STBTD_ADDR MT6356_LDO_VIO18_CON1
#define PMIC_RG_LDO_VIO18_STBTD_MASK 0x3
#define PMIC_RG_LDO_VIO18_STBTD_SHIFT 9
#define PMIC_DA_VIO18_STB_ADDR MT6356_LDO_VIO18_CON1
#define PMIC_DA_VIO18_STB_MASK 0x1
#define PMIC_DA_VIO18_STB_SHIFT 14
#define PMIC_DA_VIO18_EN_ADDR MT6356_LDO_VIO18_CON1
#define PMIC_DA_VIO18_EN_MASK 0x1
#define PMIC_DA_VIO18_EN_SHIFT 15
#define PMIC_RG_LDO_VIO18_OCFB_EN_ADDR MT6356_LDO_VIO18_CON2
#define PMIC_RG_LDO_VIO18_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VIO18_OCFB_EN_SHIFT 9
#define PMIC_DA_VIO18_OCFB_EN_ADDR MT6356_LDO_VIO18_CON2
#define PMIC_DA_VIO18_OCFB_EN_MASK 0x1
#define PMIC_DA_VIO18_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VIO18_DUMMY_LOAD_ADDR MT6356_LDO_VIO18_CON3
#define PMIC_RG_LDO_VIO18_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VIO18_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VIO18_DUMMY_LOAD_ADDR MT6356_LDO_VIO18_CON3
#define PMIC_DA_VIO18_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VIO18_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VDRAM_EN_ADDR MT6356_LDO_VDRAM_CON0
#define PMIC_RG_LDO_VDRAM_EN_MASK 0x1
#define PMIC_RG_LDO_VDRAM_EN_SHIFT 0
#define PMIC_RG_LDO_VDRAM_LP_ADDR MT6356_LDO_VDRAM_CON0
#define PMIC_RG_LDO_VDRAM_LP_MASK 0x1
#define PMIC_RG_LDO_VDRAM_LP_SHIFT 1
#define PMIC_RG_LDO_VDRAM_SW_OP_EN_ADDR MT6356_LDO_VDRAM_OP_EN
#define PMIC_RG_LDO_VDRAM_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VDRAM_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VDRAM_HW0_OP_EN_ADDR MT6356_LDO_VDRAM_OP_EN
#define PMIC_RG_LDO_VDRAM_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VDRAM_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VDRAM_HW1_OP_EN_ADDR MT6356_LDO_VDRAM_OP_EN
#define PMIC_RG_LDO_VDRAM_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VDRAM_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VDRAM_HW2_OP_EN_ADDR MT6356_LDO_VDRAM_OP_EN
#define PMIC_RG_LDO_VDRAM_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VDRAM_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VDRAM_OP_EN_SET_ADDR MT6356_LDO_VDRAM_OP_EN_SET
#define PMIC_RG_LDO_VDRAM_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VDRAM_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VDRAM_OP_EN_CLR_ADDR MT6356_LDO_VDRAM_OP_EN_CLR
#define PMIC_RG_LDO_VDRAM_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VDRAM_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VDRAM_HW0_OP_CFG_ADDR MT6356_LDO_VDRAM_OP_CFG
#define PMIC_RG_LDO_VDRAM_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VDRAM_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VDRAM_HW1_OP_CFG_ADDR MT6356_LDO_VDRAM_OP_CFG
#define PMIC_RG_LDO_VDRAM_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VDRAM_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VDRAM_HW2_OP_CFG_ADDR MT6356_LDO_VDRAM_OP_CFG
#define PMIC_RG_LDO_VDRAM_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VDRAM_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VDRAM_ON_OP_ADDR MT6356_LDO_VDRAM_OP_CFG
#define PMIC_RG_LDO_VDRAM_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VDRAM_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VDRAM_LP_OP_ADDR MT6356_LDO_VDRAM_OP_CFG
#define PMIC_RG_LDO_VDRAM_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VDRAM_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VDRAM_OP_CFG_SET_ADDR MT6356_LDO_VDRAM_OP_CFG_SET
#define PMIC_RG_LDO_VDRAM_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VDRAM_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VDRAM_OP_CFG_CLR_ADDR MT6356_LDO_VDRAM_OP_CFG_CLR
#define PMIC_RG_LDO_VDRAM_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VDRAM_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VDRAM_MODE_ADDR MT6356_LDO_VDRAM_CON1
#define PMIC_DA_VDRAM_MODE_MASK 0x1
#define PMIC_DA_VDRAM_MODE_SHIFT 8
#define PMIC_RG_LDO_VDRAM_STBTD_ADDR MT6356_LDO_VDRAM_CON1
#define PMIC_RG_LDO_VDRAM_STBTD_MASK 0x3
#define PMIC_RG_LDO_VDRAM_STBTD_SHIFT 9
#define PMIC_DA_VDRAM_STB_ADDR MT6356_LDO_VDRAM_CON1
#define PMIC_DA_VDRAM_STB_MASK 0x1
#define PMIC_DA_VDRAM_STB_SHIFT 14
#define PMIC_DA_VDRAM_EN_ADDR MT6356_LDO_VDRAM_CON1
#define PMIC_DA_VDRAM_EN_MASK 0x1
#define PMIC_DA_VDRAM_EN_SHIFT 15
#define PMIC_RG_LDO_VDRAM_OCFB_EN_ADDR MT6356_LDO_VDRAM_CON2
#define PMIC_RG_LDO_VDRAM_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VDRAM_OCFB_EN_SHIFT 9
#define PMIC_DA_VDRAM_OCFB_EN_ADDR MT6356_LDO_VDRAM_CON2
#define PMIC_DA_VDRAM_OCFB_EN_MASK 0x1
#define PMIC_DA_VDRAM_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VDRAM_DUMMY_LOAD_ADDR MT6356_LDO_VDRAM_CON3
#define PMIC_RG_LDO_VDRAM_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VDRAM_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VDRAM_DUMMY_LOAD_ADDR MT6356_LDO_VDRAM_CON3
#define PMIC_DA_VDRAM_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VDRAM_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VEMC_EN_ADDR MT6356_LDO_VEMC_CON0
#define PMIC_RG_LDO_VEMC_EN_MASK 0x1
#define PMIC_RG_LDO_VEMC_EN_SHIFT 0
#define PMIC_RG_LDO_VEMC_LP_ADDR MT6356_LDO_VEMC_CON0
#define PMIC_RG_LDO_VEMC_LP_MASK 0x1
#define PMIC_RG_LDO_VEMC_LP_SHIFT 1
#define PMIC_RG_LDO_VEMC_SW_OP_EN_ADDR MT6356_LDO_VEMC_OP_EN
#define PMIC_RG_LDO_VEMC_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VEMC_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VEMC_HW0_OP_EN_ADDR MT6356_LDO_VEMC_OP_EN
#define PMIC_RG_LDO_VEMC_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VEMC_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VEMC_HW1_OP_EN_ADDR MT6356_LDO_VEMC_OP_EN
#define PMIC_RG_LDO_VEMC_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VEMC_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VEMC_HW2_OP_EN_ADDR MT6356_LDO_VEMC_OP_EN
#define PMIC_RG_LDO_VEMC_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VEMC_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VEMC_OP_EN_SET_ADDR MT6356_LDO_VEMC_OP_EN_SET
#define PMIC_RG_LDO_VEMC_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VEMC_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VEMC_OP_EN_CLR_ADDR MT6356_LDO_VEMC_OP_EN_CLR
#define PMIC_RG_LDO_VEMC_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VEMC_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VEMC_HW0_OP_CFG_ADDR MT6356_LDO_VEMC_OP_CFG
#define PMIC_RG_LDO_VEMC_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VEMC_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VEMC_HW1_OP_CFG_ADDR MT6356_LDO_VEMC_OP_CFG
#define PMIC_RG_LDO_VEMC_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VEMC_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VEMC_HW2_OP_CFG_ADDR MT6356_LDO_VEMC_OP_CFG
#define PMIC_RG_LDO_VEMC_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VEMC_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VEMC_ON_OP_ADDR MT6356_LDO_VEMC_OP_CFG
#define PMIC_RG_LDO_VEMC_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VEMC_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VEMC_LP_OP_ADDR MT6356_LDO_VEMC_OP_CFG
#define PMIC_RG_LDO_VEMC_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VEMC_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VEMC_OP_CFG_SET_ADDR MT6356_LDO_VEMC_OP_CFG_SET
#define PMIC_RG_LDO_VEMC_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VEMC_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VEMC_OP_CFG_CLR_ADDR MT6356_LDO_VEMC_OP_CFG_CLR
#define PMIC_RG_LDO_VEMC_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VEMC_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VEMC_MODE_ADDR MT6356_LDO_VEMC_CON1
#define PMIC_DA_VEMC_MODE_MASK 0x1
#define PMIC_DA_VEMC_MODE_SHIFT 8
#define PMIC_RG_LDO_VEMC_STBTD_ADDR MT6356_LDO_VEMC_CON1
#define PMIC_RG_LDO_VEMC_STBTD_MASK 0x3
#define PMIC_RG_LDO_VEMC_STBTD_SHIFT 9
#define PMIC_DA_VEMC_STB_ADDR MT6356_LDO_VEMC_CON1
#define PMIC_DA_VEMC_STB_MASK 0x1
#define PMIC_DA_VEMC_STB_SHIFT 14
#define PMIC_DA_VEMC_EN_ADDR MT6356_LDO_VEMC_CON1
#define PMIC_DA_VEMC_EN_MASK 0x1
#define PMIC_DA_VEMC_EN_SHIFT 15
#define PMIC_RG_LDO_VEMC_OCFB_EN_ADDR MT6356_LDO_VEMC_CON2
#define PMIC_RG_LDO_VEMC_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VEMC_OCFB_EN_SHIFT 9
#define PMIC_DA_VEMC_OCFB_EN_ADDR MT6356_LDO_VEMC_CON2
#define PMIC_DA_VEMC_OCFB_EN_MASK 0x1
#define PMIC_DA_VEMC_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VEMC_DUMMY_LOAD_ADDR MT6356_LDO_VEMC_CON3
#define PMIC_RG_LDO_VEMC_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VEMC_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VEMC_DUMMY_LOAD_ADDR MT6356_LDO_VEMC_CON3
#define PMIC_DA_VEMC_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VEMC_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VA12_ULP_EN_ADDR MT6356_LDO_VA12_ULP_CON0
#define PMIC_RG_LDO_VA12_ULP_EN_MASK 0x1
#define PMIC_RG_LDO_VA12_ULP_EN_SHIFT 0
#define PMIC_RG_LDO_VA12_T1_ADDR MT6356_LDO_VA12_ULP_CON0
#define PMIC_RG_LDO_VA12_T1_MASK 0x3
#define PMIC_RG_LDO_VA12_T1_SHIFT 1
#define PMIC_RG_LDO_VA12_T2_ADDR MT6356_LDO_VA12_ULP_CON0
#define PMIC_RG_LDO_VA12_T2_MASK 0xF
#define PMIC_RG_LDO_VA12_T2_SHIFT 8
#define PMIC_DA_VA12_ULP_EN_ADDR MT6356_LDO_VA12_ULP_CON0
#define PMIC_DA_VA12_ULP_EN_MASK 0x1
#define PMIC_DA_VA12_ULP_EN_SHIFT 14
#define PMIC_RG_LDO_VIO28_ULP_EN_ADDR MT6356_LDO_VIO28_ULP_CON0
#define PMIC_RG_LDO_VIO28_ULP_EN_MASK 0x1
#define PMIC_RG_LDO_VIO28_ULP_EN_SHIFT 0
#define PMIC_RG_LDO_VIO28_T1_ADDR MT6356_LDO_VIO28_ULP_CON0
#define PMIC_RG_LDO_VIO28_T1_MASK 0x3
#define PMIC_RG_LDO_VIO28_T1_SHIFT 1
#define PMIC_RG_LDO_VIO28_T2_ADDR MT6356_LDO_VIO28_ULP_CON0
#define PMIC_RG_LDO_VIO28_T2_MASK 0xF
#define PMIC_RG_LDO_VIO28_T2_SHIFT 8
#define PMIC_DA_VIO28_ULP_EN_ADDR MT6356_LDO_VIO28_ULP_CON0
#define PMIC_DA_VIO28_ULP_EN_MASK 0x1
#define PMIC_DA_VIO28_ULP_EN_SHIFT 14
#define PMIC_LDO_DEGTD_SEL_ADDR MT6356_LDO_OCFB0
#define PMIC_LDO_DEGTD_SEL_MASK 0x3
#define PMIC_LDO_DEGTD_SEL_SHIFT 14
#define PMIC_RG_LDO_LP_PROT_DISABLE_ADDR MT6356_LDO_LP_PROTECTION
#define PMIC_RG_LDO_LP_PROT_DISABLE_MASK 0x1
#define PMIC_RG_LDO_LP_PROT_DISABLE_SHIFT 0
#define PMIC_RG_LDO_DUMMY_LOAD_GATED_DIS_ADDR MT6356_LDO_DUMMY_LOAD_GATED
#define PMIC_RG_LDO_DUMMY_LOAD_GATED_DIS_MASK 0x1
#define PMIC_RG_LDO_DUMMY_LOAD_GATED_DIS_SHIFT 0
#define PMIC_LDO_GOFF0_ANA_ID_ADDR MT6356_LDO_GOFF0_DSN_ID
#define PMIC_LDO_GOFF0_ANA_ID_MASK 0xFF
#define PMIC_LDO_GOFF0_ANA_ID_SHIFT 0
#define PMIC_LDO_GOFF0_DIG_ID_ADDR MT6356_LDO_GOFF0_DSN_ID
#define PMIC_LDO_GOFF0_DIG_ID_MASK 0xFF
#define PMIC_LDO_GOFF0_DIG_ID_SHIFT 8
#define PMIC_LDO_GOFF0_ANA_MINOR_REV_ADDR MT6356_LDO_GOFF0_DSN_REV0
#define PMIC_LDO_GOFF0_ANA_MINOR_REV_MASK 0xF
#define PMIC_LDO_GOFF0_ANA_MINOR_REV_SHIFT 0
#define PMIC_LDO_GOFF0_ANA_MAJOR_REV_ADDR MT6356_LDO_GOFF0_DSN_REV0
#define PMIC_LDO_GOFF0_ANA_MAJOR_REV_MASK 0xF
#define PMIC_LDO_GOFF0_ANA_MAJOR_REV_SHIFT 4
#define PMIC_LDO_GOFF0_DIG_MINOR_REV_ADDR MT6356_LDO_GOFF0_DSN_REV0
#define PMIC_LDO_GOFF0_DIG_MINOR_REV_MASK 0xF
#define PMIC_LDO_GOFF0_DIG_MINOR_REV_SHIFT 8
#define PMIC_LDO_GOFF0_DIG_MAJOR_REV_ADDR MT6356_LDO_GOFF0_DSN_REV0
#define PMIC_LDO_GOFF0_DIG_MAJOR_REV_MASK 0xF
#define PMIC_LDO_GOFF0_DIG_MAJOR_REV_SHIFT 12
#define PMIC_LDO_GOFF0_SW_MINOR_REV_ADDR MT6356_LDO_GOFF0_DSN_REV1
#define PMIC_LDO_GOFF0_SW_MINOR_REV_MASK 0xF
#define PMIC_LDO_GOFF0_SW_MINOR_REV_SHIFT 0
#define PMIC_LDO_GOFF0_SW_MAJOR_REV_ADDR MT6356_LDO_GOFF0_DSN_REV1
#define PMIC_LDO_GOFF0_SW_MAJOR_REV_MASK 0xF
#define PMIC_LDO_GOFF0_SW_MAJOR_REV_SHIFT 4
#define PMIC_LDO_GOFF0_ESP_ADDR MT6356_LDO_GOFF0_DSN_REV1
#define PMIC_LDO_GOFF0_ESP_MASK 0xFF
#define PMIC_LDO_GOFF0_ESP_SHIFT 8
#define PMIC_RG_LDO_GOFF0_RSV0_ADDR MT6356_LDO_GOFF0_RSV_CON0
#define PMIC_RG_LDO_GOFF0_RSV0_MASK 0xFFFF
#define PMIC_RG_LDO_GOFF0_RSV0_SHIFT 0
#define PMIC_RG_LDO_GOFF0_RSV1_ADDR MT6356_LDO_GOFF0_RSV_CON1
#define PMIC_RG_LDO_GOFF0_RSV1_MASK 0xFFFF
#define PMIC_RG_LDO_GOFF0_RSV1_SHIFT 0
#define PMIC_RG_LDO_VFE28_EN_ADDR MT6356_LDO_VFE28_CON0
#define PMIC_RG_LDO_VFE28_EN_MASK 0x1
#define PMIC_RG_LDO_VFE28_EN_SHIFT 0
#define PMIC_RG_LDO_VFE28_LP_ADDR MT6356_LDO_VFE28_CON0
#define PMIC_RG_LDO_VFE28_LP_MASK 0x1
#define PMIC_RG_LDO_VFE28_LP_SHIFT 1
#define PMIC_RG_LDO_VFE28_SW_OP_EN_ADDR MT6356_LDO_VFE28_OP_EN
#define PMIC_RG_LDO_VFE28_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VFE28_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VFE28_HW0_OP_EN_ADDR MT6356_LDO_VFE28_OP_EN
#define PMIC_RG_LDO_VFE28_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VFE28_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VFE28_HW1_OP_EN_ADDR MT6356_LDO_VFE28_OP_EN
#define PMIC_RG_LDO_VFE28_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VFE28_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VFE28_HW2_OP_EN_ADDR MT6356_LDO_VFE28_OP_EN
#define PMIC_RG_LDO_VFE28_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VFE28_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VFE28_OP_EN_SET_ADDR MT6356_LDO_VFE28_OP_EN_SET
#define PMIC_RG_LDO_VFE28_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VFE28_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VFE28_OP_EN_CLR_ADDR MT6356_LDO_VFE28_OP_EN_CLR
#define PMIC_RG_LDO_VFE28_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VFE28_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VFE28_HW0_OP_CFG_ADDR MT6356_LDO_VFE28_OP_CFG
#define PMIC_RG_LDO_VFE28_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VFE28_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VFE28_HW1_OP_CFG_ADDR MT6356_LDO_VFE28_OP_CFG
#define PMIC_RG_LDO_VFE28_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VFE28_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VFE28_HW2_OP_CFG_ADDR MT6356_LDO_VFE28_OP_CFG
#define PMIC_RG_LDO_VFE28_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VFE28_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VFE28_ON_OP_ADDR MT6356_LDO_VFE28_OP_CFG
#define PMIC_RG_LDO_VFE28_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VFE28_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VFE28_LP_OP_ADDR MT6356_LDO_VFE28_OP_CFG
#define PMIC_RG_LDO_VFE28_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VFE28_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VFE28_OP_CFG_SET_ADDR MT6356_LDO_VFE28_OP_CFG_SET
#define PMIC_RG_LDO_VFE28_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VFE28_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VFE28_OP_CFG_CLR_ADDR MT6356_LDO_VFE28_OP_CFG_CLR
#define PMIC_RG_LDO_VFE28_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VFE28_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VFE28_MODE_ADDR MT6356_LDO_VFE28_CON1
#define PMIC_DA_VFE28_MODE_MASK 0x1
#define PMIC_DA_VFE28_MODE_SHIFT 8
#define PMIC_RG_LDO_VFE28_STBTD_ADDR MT6356_LDO_VFE28_CON1
#define PMIC_RG_LDO_VFE28_STBTD_MASK 0x3
#define PMIC_RG_LDO_VFE28_STBTD_SHIFT 9
#define PMIC_DA_VFE28_STB_ADDR MT6356_LDO_VFE28_CON1
#define PMIC_DA_VFE28_STB_MASK 0x1
#define PMIC_DA_VFE28_STB_SHIFT 14
#define PMIC_DA_VFE28_EN_ADDR MT6356_LDO_VFE28_CON1
#define PMIC_DA_VFE28_EN_MASK 0x1
#define PMIC_DA_VFE28_EN_SHIFT 15
#define PMIC_RG_LDO_VFE28_OCFB_EN_ADDR MT6356_LDO_VFE28_CON2
#define PMIC_RG_LDO_VFE28_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VFE28_OCFB_EN_SHIFT 9
#define PMIC_DA_VFE28_OCFB_EN_ADDR MT6356_LDO_VFE28_CON2
#define PMIC_DA_VFE28_OCFB_EN_MASK 0x1
#define PMIC_DA_VFE28_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VFE28_DUMMY_LOAD_ADDR MT6356_LDO_VFE28_CON3
#define PMIC_RG_LDO_VFE28_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VFE28_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VFE28_DUMMY_LOAD_ADDR MT6356_LDO_VFE28_CON3
#define PMIC_DA_VFE28_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VFE28_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VRF18_EN_ADDR MT6356_LDO_VRF18_CON0
#define PMIC_RG_LDO_VRF18_EN_MASK 0x1
#define PMIC_RG_LDO_VRF18_EN_SHIFT 0
#define PMIC_RG_LDO_VRF18_LP_ADDR MT6356_LDO_VRF18_CON0
#define PMIC_RG_LDO_VRF18_LP_MASK 0x1
#define PMIC_RG_LDO_VRF18_LP_SHIFT 1
#define PMIC_RG_LDO_VRF18_SW_OP_EN_ADDR MT6356_LDO_VRF18_OP_EN
#define PMIC_RG_LDO_VRF18_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VRF18_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VRF18_HW0_OP_EN_ADDR MT6356_LDO_VRF18_OP_EN
#define PMIC_RG_LDO_VRF18_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VRF18_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VRF18_HW1_OP_EN_ADDR MT6356_LDO_VRF18_OP_EN
#define PMIC_RG_LDO_VRF18_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VRF18_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VRF18_HW2_OP_EN_ADDR MT6356_LDO_VRF18_OP_EN
#define PMIC_RG_LDO_VRF18_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VRF18_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VRF18_OP_EN_SET_ADDR MT6356_LDO_VRF18_OP_EN_SET
#define PMIC_RG_LDO_VRF18_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VRF18_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VRF18_OP_EN_CLR_ADDR MT6356_LDO_VRF18_OP_EN_CLR
#define PMIC_RG_LDO_VRF18_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VRF18_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VRF18_HW0_OP_CFG_ADDR MT6356_LDO_VRF18_OP_CFG
#define PMIC_RG_LDO_VRF18_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VRF18_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VRF18_HW1_OP_CFG_ADDR MT6356_LDO_VRF18_OP_CFG
#define PMIC_RG_LDO_VRF18_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VRF18_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VRF18_HW2_OP_CFG_ADDR MT6356_LDO_VRF18_OP_CFG
#define PMIC_RG_LDO_VRF18_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VRF18_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VRF18_ON_OP_ADDR MT6356_LDO_VRF18_OP_CFG
#define PMIC_RG_LDO_VRF18_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VRF18_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VRF18_LP_OP_ADDR MT6356_LDO_VRF18_OP_CFG
#define PMIC_RG_LDO_VRF18_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VRF18_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VRF18_OP_CFG_SET_ADDR MT6356_LDO_VRF18_OP_CFG_SET
#define PMIC_RG_LDO_VRF18_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VRF18_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VRF18_OP_CFG_CLR_ADDR MT6356_LDO_VRF18_OP_CFG_CLR
#define PMIC_RG_LDO_VRF18_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VRF18_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VRF18_MODE_ADDR MT6356_LDO_VRF18_CON1
#define PMIC_DA_VRF18_MODE_MASK 0x1
#define PMIC_DA_VRF18_MODE_SHIFT 8
#define PMIC_RG_LDO_VRF18_STBTD_ADDR MT6356_LDO_VRF18_CON1
#define PMIC_RG_LDO_VRF18_STBTD_MASK 0x3
#define PMIC_RG_LDO_VRF18_STBTD_SHIFT 9
#define PMIC_DA_VRF18_STB_ADDR MT6356_LDO_VRF18_CON1
#define PMIC_DA_VRF18_STB_MASK 0x1
#define PMIC_DA_VRF18_STB_SHIFT 14
#define PMIC_DA_VRF18_EN_ADDR MT6356_LDO_VRF18_CON1
#define PMIC_DA_VRF18_EN_MASK 0x1
#define PMIC_DA_VRF18_EN_SHIFT 15
#define PMIC_RG_LDO_VRF18_OCFB_EN_ADDR MT6356_LDO_VRF18_CON2
#define PMIC_RG_LDO_VRF18_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VRF18_OCFB_EN_SHIFT 9
#define PMIC_DA_VRF18_OCFB_EN_ADDR MT6356_LDO_VRF18_CON2
#define PMIC_DA_VRF18_OCFB_EN_MASK 0x1
#define PMIC_DA_VRF18_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VRF18_DUMMY_LOAD_ADDR MT6356_LDO_VRF18_CON3
#define PMIC_RG_LDO_VRF18_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VRF18_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VRF18_DUMMY_LOAD_ADDR MT6356_LDO_VRF18_CON3
#define PMIC_DA_VRF18_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VRF18_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VRF12_EN_ADDR MT6356_LDO_VRF12_CON0
#define PMIC_RG_LDO_VRF12_EN_MASK 0x1
#define PMIC_RG_LDO_VRF12_EN_SHIFT 0
#define PMIC_RG_LDO_VRF12_LP_ADDR MT6356_LDO_VRF12_CON0
#define PMIC_RG_LDO_VRF12_LP_MASK 0x1
#define PMIC_RG_LDO_VRF12_LP_SHIFT 1
#define PMIC_RG_LDO_VRF12_SW_OP_EN_ADDR MT6356_LDO_VRF12_OP_EN
#define PMIC_RG_LDO_VRF12_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VRF12_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VRF12_HW0_OP_EN_ADDR MT6356_LDO_VRF12_OP_EN
#define PMIC_RG_LDO_VRF12_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VRF12_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VRF12_HW1_OP_EN_ADDR MT6356_LDO_VRF12_OP_EN
#define PMIC_RG_LDO_VRF12_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VRF12_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VRF12_HW2_OP_EN_ADDR MT6356_LDO_VRF12_OP_EN
#define PMIC_RG_LDO_VRF12_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VRF12_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VRF12_OP_EN_SET_ADDR MT6356_LDO_VRF12_OP_EN_SET
#define PMIC_RG_LDO_VRF12_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VRF12_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VRF12_OP_EN_CLR_ADDR MT6356_LDO_VRF12_OP_EN_CLR
#define PMIC_RG_LDO_VRF12_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VRF12_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VRF12_HW0_OP_CFG_ADDR MT6356_LDO_VRF12_OP_CFG
#define PMIC_RG_LDO_VRF12_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VRF12_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VRF12_HW1_OP_CFG_ADDR MT6356_LDO_VRF12_OP_CFG
#define PMIC_RG_LDO_VRF12_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VRF12_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VRF12_HW2_OP_CFG_ADDR MT6356_LDO_VRF12_OP_CFG
#define PMIC_RG_LDO_VRF12_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VRF12_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VRF12_ON_OP_ADDR MT6356_LDO_VRF12_OP_CFG
#define PMIC_RG_LDO_VRF12_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VRF12_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VRF12_LP_OP_ADDR MT6356_LDO_VRF12_OP_CFG
#define PMIC_RG_LDO_VRF12_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VRF12_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VRF12_OP_CFG_SET_ADDR MT6356_LDO_VRF12_OP_CFG_SET
#define PMIC_RG_LDO_VRF12_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VRF12_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VRF12_OP_CFG_CLR_ADDR MT6356_LDO_VRF12_OP_CFG_CLR
#define PMIC_RG_LDO_VRF12_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VRF12_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VRF12_MODE_ADDR MT6356_LDO_VRF12_CON1
#define PMIC_DA_VRF12_MODE_MASK 0x1
#define PMIC_DA_VRF12_MODE_SHIFT 8
#define PMIC_RG_LDO_VRF12_STBTD_ADDR MT6356_LDO_VRF12_CON1
#define PMIC_RG_LDO_VRF12_STBTD_MASK 0x3
#define PMIC_RG_LDO_VRF12_STBTD_SHIFT 9
#define PMIC_DA_VRF12_STB_ADDR MT6356_LDO_VRF12_CON1
#define PMIC_DA_VRF12_STB_MASK 0x1
#define PMIC_DA_VRF12_STB_SHIFT 14
#define PMIC_DA_VRF12_EN_ADDR MT6356_LDO_VRF12_CON1
#define PMIC_DA_VRF12_EN_MASK 0x1
#define PMIC_DA_VRF12_EN_SHIFT 15
#define PMIC_RG_LDO_VRF12_OCFB_EN_ADDR MT6356_LDO_VRF12_CON2
#define PMIC_RG_LDO_VRF12_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VRF12_OCFB_EN_SHIFT 9
#define PMIC_DA_VRF12_OCFB_EN_ADDR MT6356_LDO_VRF12_CON2
#define PMIC_DA_VRF12_OCFB_EN_MASK 0x1
#define PMIC_DA_VRF12_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VRF12_DUMMY_LOAD_ADDR MT6356_LDO_VRF12_CON3
#define PMIC_RG_LDO_VRF12_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VRF12_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VRF12_DUMMY_LOAD_ADDR MT6356_LDO_VRF12_CON3
#define PMIC_DA_VRF12_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VRF12_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VMIPI_EN_ADDR MT6356_LDO_VMIPI_CON0
#define PMIC_RG_LDO_VMIPI_EN_MASK 0x1
#define PMIC_RG_LDO_VMIPI_EN_SHIFT 0
#define PMIC_RG_LDO_VMIPI_LP_ADDR MT6356_LDO_VMIPI_CON0
#define PMIC_RG_LDO_VMIPI_LP_MASK 0x1
#define PMIC_RG_LDO_VMIPI_LP_SHIFT 1
#define PMIC_RG_LDO_VMIPI_SW_OP_EN_ADDR MT6356_LDO_VMIPI_OP_EN
#define PMIC_RG_LDO_VMIPI_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMIPI_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VMIPI_HW0_OP_EN_ADDR MT6356_LDO_VMIPI_OP_EN
#define PMIC_RG_LDO_VMIPI_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMIPI_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VMIPI_HW1_OP_EN_ADDR MT6356_LDO_VMIPI_OP_EN
#define PMIC_RG_LDO_VMIPI_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMIPI_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VMIPI_HW2_OP_EN_ADDR MT6356_LDO_VMIPI_OP_EN
#define PMIC_RG_LDO_VMIPI_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMIPI_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VMIPI_OP_EN_SET_ADDR MT6356_LDO_VMIPI_OP_EN_SET
#define PMIC_RG_LDO_VMIPI_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VMIPI_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VMIPI_OP_EN_CLR_ADDR MT6356_LDO_VMIPI_OP_EN_CLR
#define PMIC_RG_LDO_VMIPI_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VMIPI_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VMIPI_HW0_OP_CFG_ADDR MT6356_LDO_VMIPI_OP_CFG
#define PMIC_RG_LDO_VMIPI_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VMIPI_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VMIPI_HW1_OP_CFG_ADDR MT6356_LDO_VMIPI_OP_CFG
#define PMIC_RG_LDO_VMIPI_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VMIPI_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VMIPI_HW2_OP_CFG_ADDR MT6356_LDO_VMIPI_OP_CFG
#define PMIC_RG_LDO_VMIPI_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VMIPI_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VMIPI_ON_OP_ADDR MT6356_LDO_VMIPI_OP_CFG
#define PMIC_RG_LDO_VMIPI_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VMIPI_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VMIPI_LP_OP_ADDR MT6356_LDO_VMIPI_OP_CFG
#define PMIC_RG_LDO_VMIPI_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VMIPI_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VMIPI_OP_CFG_SET_ADDR MT6356_LDO_VMIPI_OP_CFG_SET
#define PMIC_RG_LDO_VMIPI_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VMIPI_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VMIPI_OP_CFG_CLR_ADDR MT6356_LDO_VMIPI_OP_CFG_CLR
#define PMIC_RG_LDO_VMIPI_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VMIPI_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VMIPI_MODE_ADDR MT6356_LDO_VMIPI_CON1
#define PMIC_DA_VMIPI_MODE_MASK 0x1
#define PMIC_DA_VMIPI_MODE_SHIFT 8
#define PMIC_RG_LDO_VMIPI_STBTD_ADDR MT6356_LDO_VMIPI_CON1
#define PMIC_RG_LDO_VMIPI_STBTD_MASK 0x3
#define PMIC_RG_LDO_VMIPI_STBTD_SHIFT 9
#define PMIC_DA_VMIPI_STB_ADDR MT6356_LDO_VMIPI_CON1
#define PMIC_DA_VMIPI_STB_MASK 0x1
#define PMIC_DA_VMIPI_STB_SHIFT 14
#define PMIC_DA_VMIPI_EN_ADDR MT6356_LDO_VMIPI_CON1
#define PMIC_DA_VMIPI_EN_MASK 0x1
#define PMIC_DA_VMIPI_EN_SHIFT 15
#define PMIC_RG_LDO_VMIPI_OCFB_EN_ADDR MT6356_LDO_VMIPI_CON2
#define PMIC_RG_LDO_VMIPI_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VMIPI_OCFB_EN_SHIFT 9
#define PMIC_DA_VMIPI_OCFB_EN_ADDR MT6356_LDO_VMIPI_CON2
#define PMIC_DA_VMIPI_OCFB_EN_MASK 0x1
#define PMIC_DA_VMIPI_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VMIPI_DUMMY_LOAD_ADDR MT6356_LDO_VMIPI_CON3
#define PMIC_RG_LDO_VMIPI_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VMIPI_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VMIPI_DUMMY_LOAD_ADDR MT6356_LDO_VMIPI_CON3
#define PMIC_DA_VMIPI_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VMIPI_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VCN18_EN_ADDR MT6356_LDO_VCN18_CON0
#define PMIC_RG_LDO_VCN18_EN_MASK 0x1
#define PMIC_RG_LDO_VCN18_EN_SHIFT 0
#define PMIC_RG_LDO_VCN18_LP_ADDR MT6356_LDO_VCN18_CON0
#define PMIC_RG_LDO_VCN18_LP_MASK 0x1
#define PMIC_RG_LDO_VCN18_LP_SHIFT 1
#define PMIC_RG_LDO_VCN18_SW_OP_EN_ADDR MT6356_LDO_VCN18_OP_EN
#define PMIC_RG_LDO_VCN18_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN18_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VCN18_HW0_OP_EN_ADDR MT6356_LDO_VCN18_OP_EN
#define PMIC_RG_LDO_VCN18_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN18_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VCN18_HW1_OP_EN_ADDR MT6356_LDO_VCN18_OP_EN
#define PMIC_RG_LDO_VCN18_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN18_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VCN18_HW2_OP_EN_ADDR MT6356_LDO_VCN18_OP_EN
#define PMIC_RG_LDO_VCN18_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN18_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VCN18_OP_EN_SET_ADDR MT6356_LDO_VCN18_OP_EN_SET
#define PMIC_RG_LDO_VCN18_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCN18_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VCN18_OP_EN_CLR_ADDR MT6356_LDO_VCN18_OP_EN_CLR
#define PMIC_RG_LDO_VCN18_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCN18_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VCN18_HW0_OP_CFG_ADDR MT6356_LDO_VCN18_OP_CFG
#define PMIC_RG_LDO_VCN18_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN18_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VCN18_HW1_OP_CFG_ADDR MT6356_LDO_VCN18_OP_CFG
#define PMIC_RG_LDO_VCN18_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN18_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VCN18_HW2_OP_CFG_ADDR MT6356_LDO_VCN18_OP_CFG
#define PMIC_RG_LDO_VCN18_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN18_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VCN18_ON_OP_ADDR MT6356_LDO_VCN18_OP_CFG
#define PMIC_RG_LDO_VCN18_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VCN18_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VCN18_LP_OP_ADDR MT6356_LDO_VCN18_OP_CFG
#define PMIC_RG_LDO_VCN18_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VCN18_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VCN18_OP_CFG_SET_ADDR MT6356_LDO_VCN18_OP_CFG_SET
#define PMIC_RG_LDO_VCN18_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCN18_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VCN18_OP_CFG_CLR_ADDR MT6356_LDO_VCN18_OP_CFG_CLR
#define PMIC_RG_LDO_VCN18_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCN18_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VCN18_MODE_ADDR MT6356_LDO_VCN18_CON1
#define PMIC_DA_VCN18_MODE_MASK 0x1
#define PMIC_DA_VCN18_MODE_SHIFT 8
#define PMIC_RG_LDO_VCN18_STBTD_ADDR MT6356_LDO_VCN18_CON1
#define PMIC_RG_LDO_VCN18_STBTD_MASK 0x3
#define PMIC_RG_LDO_VCN18_STBTD_SHIFT 9
#define PMIC_DA_VCN18_STB_ADDR MT6356_LDO_VCN18_CON1
#define PMIC_DA_VCN18_STB_MASK 0x1
#define PMIC_DA_VCN18_STB_SHIFT 14
#define PMIC_DA_VCN18_EN_ADDR MT6356_LDO_VCN18_CON1
#define PMIC_DA_VCN18_EN_MASK 0x1
#define PMIC_DA_VCN18_EN_SHIFT 15
#define PMIC_RG_LDO_VCN18_OCFB_EN_ADDR MT6356_LDO_VCN18_CON2
#define PMIC_RG_LDO_VCN18_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VCN18_OCFB_EN_SHIFT 9
#define PMIC_DA_VCN18_OCFB_EN_ADDR MT6356_LDO_VCN18_CON2
#define PMIC_DA_VCN18_OCFB_EN_MASK 0x1
#define PMIC_DA_VCN18_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VCN18_DUMMY_LOAD_ADDR MT6356_LDO_VCN18_CON3
#define PMIC_RG_LDO_VCN18_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VCN18_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VCN18_DUMMY_LOAD_ADDR MT6356_LDO_VCN18_CON3
#define PMIC_DA_VCN18_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VCN18_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VCAMA_EN_ADDR MT6356_LDO_VCAMA_CON0
#define PMIC_RG_LDO_VCAMA_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMA_EN_SHIFT 0
#define PMIC_RG_LDO_VCAMA_LP_ADDR MT6356_LDO_VCAMA_CON0
#define PMIC_RG_LDO_VCAMA_LP_MASK 0x1
#define PMIC_RG_LDO_VCAMA_LP_SHIFT 1
#define PMIC_RG_LDO_VCAMA_SW_OP_EN_ADDR MT6356_LDO_VCAMA_OP_EN
#define PMIC_RG_LDO_VCAMA_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMA_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VCAMA_HW0_OP_EN_ADDR MT6356_LDO_VCAMA_OP_EN
#define PMIC_RG_LDO_VCAMA_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMA_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VCAMA_HW1_OP_EN_ADDR MT6356_LDO_VCAMA_OP_EN
#define PMIC_RG_LDO_VCAMA_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMA_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VCAMA_HW2_OP_EN_ADDR MT6356_LDO_VCAMA_OP_EN
#define PMIC_RG_LDO_VCAMA_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMA_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VCAMA_OP_EN_SET_ADDR MT6356_LDO_VCAMA_OP_EN_SET
#define PMIC_RG_LDO_VCAMA_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMA_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VCAMA_OP_EN_CLR_ADDR MT6356_LDO_VCAMA_OP_EN_CLR
#define PMIC_RG_LDO_VCAMA_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMA_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VCAMA_HW0_OP_CFG_ADDR MT6356_LDO_VCAMA_OP_CFG
#define PMIC_RG_LDO_VCAMA_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCAMA_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VCAMA_HW1_OP_CFG_ADDR MT6356_LDO_VCAMA_OP_CFG
#define PMIC_RG_LDO_VCAMA_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCAMA_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VCAMA_HW2_OP_CFG_ADDR MT6356_LDO_VCAMA_OP_CFG
#define PMIC_RG_LDO_VCAMA_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCAMA_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VCAMA_ON_OP_ADDR MT6356_LDO_VCAMA_OP_CFG
#define PMIC_RG_LDO_VCAMA_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VCAMA_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VCAMA_LP_OP_ADDR MT6356_LDO_VCAMA_OP_CFG
#define PMIC_RG_LDO_VCAMA_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VCAMA_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VCAMA_OP_CFG_SET_ADDR MT6356_LDO_VCAMA_OP_CFG_SET
#define PMIC_RG_LDO_VCAMA_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMA_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VCAMA_OP_CFG_CLR_ADDR MT6356_LDO_VCAMA_OP_CFG_CLR
#define PMIC_RG_LDO_VCAMA_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMA_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VCAMA_MODE_ADDR MT6356_LDO_VCAMA_CON1
#define PMIC_DA_VCAMA_MODE_MASK 0x1
#define PMIC_DA_VCAMA_MODE_SHIFT 8
#define PMIC_RG_LDO_VCAMA_STBTD_ADDR MT6356_LDO_VCAMA_CON1
#define PMIC_RG_LDO_VCAMA_STBTD_MASK 0x3
#define PMIC_RG_LDO_VCAMA_STBTD_SHIFT 9
#define PMIC_DA_VCAMA_STB_ADDR MT6356_LDO_VCAMA_CON1
#define PMIC_DA_VCAMA_STB_MASK 0x1
#define PMIC_DA_VCAMA_STB_SHIFT 14
#define PMIC_DA_VCAMA_EN_ADDR MT6356_LDO_VCAMA_CON1
#define PMIC_DA_VCAMA_EN_MASK 0x1
#define PMIC_DA_VCAMA_EN_SHIFT 15
#define PMIC_RG_LDO_VCAMA_OCFB_EN_ADDR MT6356_LDO_VCAMA_CON2
#define PMIC_RG_LDO_VCAMA_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMA_OCFB_EN_SHIFT 9
#define PMIC_DA_VCAMA_OCFB_EN_ADDR MT6356_LDO_VCAMA_CON2
#define PMIC_DA_VCAMA_OCFB_EN_MASK 0x1
#define PMIC_DA_VCAMA_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VCAMA_DUMMY_LOAD_ADDR MT6356_LDO_VCAMA_CON3
#define PMIC_RG_LDO_VCAMA_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VCAMA_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VCAMA_DUMMY_LOAD_ADDR MT6356_LDO_VCAMA_CON3
#define PMIC_DA_VCAMA_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VCAMA_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VCAMD_EN_ADDR MT6356_LDO_VCAMD_CON0
#define PMIC_RG_LDO_VCAMD_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMD_EN_SHIFT 0
#define PMIC_RG_LDO_VCAMD_LP_ADDR MT6356_LDO_VCAMD_CON0
#define PMIC_RG_LDO_VCAMD_LP_MASK 0x1
#define PMIC_RG_LDO_VCAMD_LP_SHIFT 1
#define PMIC_RG_LDO_VCAMD_SW_OP_EN_ADDR MT6356_LDO_VCAMD_OP_EN
#define PMIC_RG_LDO_VCAMD_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMD_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VCAMD_HW0_OP_EN_ADDR MT6356_LDO_VCAMD_OP_EN
#define PMIC_RG_LDO_VCAMD_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMD_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VCAMD_HW1_OP_EN_ADDR MT6356_LDO_VCAMD_OP_EN
#define PMIC_RG_LDO_VCAMD_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMD_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VCAMD_HW2_OP_EN_ADDR MT6356_LDO_VCAMD_OP_EN
#define PMIC_RG_LDO_VCAMD_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMD_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VCAMD_OP_EN_SET_ADDR MT6356_LDO_VCAMD_OP_EN_SET
#define PMIC_RG_LDO_VCAMD_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMD_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VCAMD_OP_EN_CLR_ADDR MT6356_LDO_VCAMD_OP_EN_CLR
#define PMIC_RG_LDO_VCAMD_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMD_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VCAMD_HW0_OP_CFG_ADDR MT6356_LDO_VCAMD_OP_CFG
#define PMIC_RG_LDO_VCAMD_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCAMD_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VCAMD_HW1_OP_CFG_ADDR MT6356_LDO_VCAMD_OP_CFG
#define PMIC_RG_LDO_VCAMD_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCAMD_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VCAMD_HW2_OP_CFG_ADDR MT6356_LDO_VCAMD_OP_CFG
#define PMIC_RG_LDO_VCAMD_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCAMD_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VCAMD_ON_OP_ADDR MT6356_LDO_VCAMD_OP_CFG
#define PMIC_RG_LDO_VCAMD_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VCAMD_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VCAMD_LP_OP_ADDR MT6356_LDO_VCAMD_OP_CFG
#define PMIC_RG_LDO_VCAMD_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VCAMD_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VCAMD_OP_CFG_SET_ADDR MT6356_LDO_VCAMD_OP_CFG_SET
#define PMIC_RG_LDO_VCAMD_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMD_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VCAMD_OP_CFG_CLR_ADDR MT6356_LDO_VCAMD_OP_CFG_CLR
#define PMIC_RG_LDO_VCAMD_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMD_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VCAMD_MODE_ADDR MT6356_LDO_VCAMD_CON1
#define PMIC_DA_VCAMD_MODE_MASK 0x1
#define PMIC_DA_VCAMD_MODE_SHIFT 8
#define PMIC_RG_LDO_VCAMD_STBTD_ADDR MT6356_LDO_VCAMD_CON1
#define PMIC_RG_LDO_VCAMD_STBTD_MASK 0x3
#define PMIC_RG_LDO_VCAMD_STBTD_SHIFT 9
#define PMIC_DA_VCAMD_STB_ADDR MT6356_LDO_VCAMD_CON1
#define PMIC_DA_VCAMD_STB_MASK 0x1
#define PMIC_DA_VCAMD_STB_SHIFT 14
#define PMIC_DA_VCAMD_EN_ADDR MT6356_LDO_VCAMD_CON1
#define PMIC_DA_VCAMD_EN_MASK 0x1
#define PMIC_DA_VCAMD_EN_SHIFT 15
#define PMIC_RG_LDO_VCAMD_OCFB_EN_ADDR MT6356_LDO_VCAMD_CON2
#define PMIC_RG_LDO_VCAMD_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMD_OCFB_EN_SHIFT 9
#define PMIC_DA_VCAMD_OCFB_EN_ADDR MT6356_LDO_VCAMD_CON2
#define PMIC_DA_VCAMD_OCFB_EN_MASK 0x1
#define PMIC_DA_VCAMD_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VCAMD_DUMMY_LOAD_ADDR MT6356_LDO_VCAMD_CON3
#define PMIC_RG_LDO_VCAMD_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VCAMD_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VCAMD_DUMMY_LOAD_ADDR MT6356_LDO_VCAMD_CON3
#define PMIC_DA_VCAMD_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VCAMD_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VCAMIO_EN_ADDR MT6356_LDO_VCAMIO_CON0
#define PMIC_RG_LDO_VCAMIO_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_EN_SHIFT 0
#define PMIC_RG_LDO_VCAMIO_LP_ADDR MT6356_LDO_VCAMIO_CON0
#define PMIC_RG_LDO_VCAMIO_LP_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_LP_SHIFT 1
#define PMIC_RG_LDO_VCAMIO_SW_OP_EN_ADDR MT6356_LDO_VCAMIO_OP_EN
#define PMIC_RG_LDO_VCAMIO_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VCAMIO_HW0_OP_EN_ADDR MT6356_LDO_VCAMIO_OP_EN
#define PMIC_RG_LDO_VCAMIO_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VCAMIO_HW1_OP_EN_ADDR MT6356_LDO_VCAMIO_OP_EN
#define PMIC_RG_LDO_VCAMIO_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VCAMIO_HW2_OP_EN_ADDR MT6356_LDO_VCAMIO_OP_EN
#define PMIC_RG_LDO_VCAMIO_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VCAMIO_OP_EN_SET_ADDR MT6356_LDO_VCAMIO_OP_EN_SET
#define PMIC_RG_LDO_VCAMIO_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMIO_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VCAMIO_OP_EN_CLR_ADDR MT6356_LDO_VCAMIO_OP_EN_CLR
#define PMIC_RG_LDO_VCAMIO_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMIO_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VCAMIO_HW0_OP_CFG_ADDR MT6356_LDO_VCAMIO_OP_CFG
#define PMIC_RG_LDO_VCAMIO_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VCAMIO_HW1_OP_CFG_ADDR MT6356_LDO_VCAMIO_OP_CFG
#define PMIC_RG_LDO_VCAMIO_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VCAMIO_HW2_OP_CFG_ADDR MT6356_LDO_VCAMIO_OP_CFG
#define PMIC_RG_LDO_VCAMIO_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VCAMIO_ON_OP_ADDR MT6356_LDO_VCAMIO_OP_CFG
#define PMIC_RG_LDO_VCAMIO_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VCAMIO_LP_OP_ADDR MT6356_LDO_VCAMIO_OP_CFG
#define PMIC_RG_LDO_VCAMIO_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VCAMIO_OP_CFG_SET_ADDR MT6356_LDO_VCAMIO_OP_CFG_SET
#define PMIC_RG_LDO_VCAMIO_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMIO_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VCAMIO_OP_CFG_CLR_ADDR MT6356_LDO_VCAMIO_OP_CFG_CLR
#define PMIC_RG_LDO_VCAMIO_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCAMIO_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VCAMIO_MODE_ADDR MT6356_LDO_VCAMIO_CON1
#define PMIC_DA_VCAMIO_MODE_MASK 0x1
#define PMIC_DA_VCAMIO_MODE_SHIFT 8
#define PMIC_RG_LDO_VCAMIO_STBTD_ADDR MT6356_LDO_VCAMIO_CON1
#define PMIC_RG_LDO_VCAMIO_STBTD_MASK 0x3
#define PMIC_RG_LDO_VCAMIO_STBTD_SHIFT 9
#define PMIC_DA_VCAMIO_STB_ADDR MT6356_LDO_VCAMIO_CON1
#define PMIC_DA_VCAMIO_STB_MASK 0x1
#define PMIC_DA_VCAMIO_STB_SHIFT 14
#define PMIC_DA_VCAMIO_EN_ADDR MT6356_LDO_VCAMIO_CON1
#define PMIC_DA_VCAMIO_EN_MASK 0x1
#define PMIC_DA_VCAMIO_EN_SHIFT 15
#define PMIC_RG_LDO_VCAMIO_OCFB_EN_ADDR MT6356_LDO_VCAMIO_CON2
#define PMIC_RG_LDO_VCAMIO_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VCAMIO_OCFB_EN_SHIFT 9
#define PMIC_DA_VCAMIO_OCFB_EN_ADDR MT6356_LDO_VCAMIO_CON2
#define PMIC_DA_VCAMIO_OCFB_EN_MASK 0x1
#define PMIC_DA_VCAMIO_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VCAMIO_DUMMY_LOAD_ADDR MT6356_LDO_VCAMIO_CON3
#define PMIC_RG_LDO_VCAMIO_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VCAMIO_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VCAMIO_DUMMY_LOAD_ADDR MT6356_LDO_VCAMIO_CON3
#define PMIC_DA_VCAMIO_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VCAMIO_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VMC_EN_ADDR MT6356_LDO_VMC_CON0
#define PMIC_RG_LDO_VMC_EN_MASK 0x1
#define PMIC_RG_LDO_VMC_EN_SHIFT 0
#define PMIC_RG_LDO_VMC_LP_ADDR MT6356_LDO_VMC_CON0
#define PMIC_RG_LDO_VMC_LP_MASK 0x1
#define PMIC_RG_LDO_VMC_LP_SHIFT 1
#define PMIC_RG_LDO_VMC_SW_OP_EN_ADDR MT6356_LDO_VMC_OP_EN
#define PMIC_RG_LDO_VMC_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMC_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VMC_HW0_OP_EN_ADDR MT6356_LDO_VMC_OP_EN
#define PMIC_RG_LDO_VMC_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMC_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VMC_HW1_OP_EN_ADDR MT6356_LDO_VMC_OP_EN
#define PMIC_RG_LDO_VMC_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMC_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VMC_HW2_OP_EN_ADDR MT6356_LDO_VMC_OP_EN
#define PMIC_RG_LDO_VMC_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMC_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VMC_OP_EN_SET_ADDR MT6356_LDO_VMC_OP_EN_SET
#define PMIC_RG_LDO_VMC_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VMC_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VMC_OP_EN_CLR_ADDR MT6356_LDO_VMC_OP_EN_CLR
#define PMIC_RG_LDO_VMC_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VMC_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VMC_HW0_OP_CFG_ADDR MT6356_LDO_VMC_OP_CFG
#define PMIC_RG_LDO_VMC_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VMC_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VMC_HW1_OP_CFG_ADDR MT6356_LDO_VMC_OP_CFG
#define PMIC_RG_LDO_VMC_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VMC_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VMC_HW2_OP_CFG_ADDR MT6356_LDO_VMC_OP_CFG
#define PMIC_RG_LDO_VMC_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VMC_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VMC_ON_OP_ADDR MT6356_LDO_VMC_OP_CFG
#define PMIC_RG_LDO_VMC_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VMC_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VMC_LP_OP_ADDR MT6356_LDO_VMC_OP_CFG
#define PMIC_RG_LDO_VMC_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VMC_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VMC_OP_CFG_SET_ADDR MT6356_LDO_VMC_OP_CFG_SET
#define PMIC_RG_LDO_VMC_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VMC_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VMC_OP_CFG_CLR_ADDR MT6356_LDO_VMC_OP_CFG_CLR
#define PMIC_RG_LDO_VMC_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VMC_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VMC_MODE_ADDR MT6356_LDO_VMC_CON1
#define PMIC_DA_VMC_MODE_MASK 0x1
#define PMIC_DA_VMC_MODE_SHIFT 8
#define PMIC_RG_LDO_VMC_STBTD_ADDR MT6356_LDO_VMC_CON1
#define PMIC_RG_LDO_VMC_STBTD_MASK 0x3
#define PMIC_RG_LDO_VMC_STBTD_SHIFT 9
#define PMIC_DA_VMC_STB_ADDR MT6356_LDO_VMC_CON1
#define PMIC_DA_VMC_STB_MASK 0x1
#define PMIC_DA_VMC_STB_SHIFT 14
#define PMIC_DA_VMC_EN_ADDR MT6356_LDO_VMC_CON1
#define PMIC_DA_VMC_EN_MASK 0x1
#define PMIC_DA_VMC_EN_SHIFT 15
#define PMIC_RG_LDO_VMC_OCFB_EN_ADDR MT6356_LDO_VMC_CON2
#define PMIC_RG_LDO_VMC_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VMC_OCFB_EN_SHIFT 9
#define PMIC_DA_VMC_OCFB_EN_ADDR MT6356_LDO_VMC_CON2
#define PMIC_DA_VMC_OCFB_EN_MASK 0x1
#define PMIC_DA_VMC_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VMC_DUMMY_LOAD_ADDR MT6356_LDO_VMC_CON3
#define PMIC_RG_LDO_VMC_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VMC_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VMC_DUMMY_LOAD_ADDR MT6356_LDO_VMC_CON3
#define PMIC_DA_VMC_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VMC_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VMCH_EN_ADDR MT6356_LDO_VMCH_CON0
#define PMIC_RG_LDO_VMCH_EN_MASK 0x1
#define PMIC_RG_LDO_VMCH_EN_SHIFT 0
#define PMIC_RG_LDO_VMCH_LP_ADDR MT6356_LDO_VMCH_CON0
#define PMIC_RG_LDO_VMCH_LP_MASK 0x1
#define PMIC_RG_LDO_VMCH_LP_SHIFT 1
#define PMIC_RG_LDO_VMCH_SW_OP_EN_ADDR MT6356_LDO_VMCH_OP_EN
#define PMIC_RG_LDO_VMCH_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMCH_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VMCH_HW0_OP_EN_ADDR MT6356_LDO_VMCH_OP_EN
#define PMIC_RG_LDO_VMCH_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMCH_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VMCH_HW1_OP_EN_ADDR MT6356_LDO_VMCH_OP_EN
#define PMIC_RG_LDO_VMCH_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMCH_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VMCH_HW2_OP_EN_ADDR MT6356_LDO_VMCH_OP_EN
#define PMIC_RG_LDO_VMCH_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VMCH_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VMCH_OP_EN_SET_ADDR MT6356_LDO_VMCH_OP_EN_SET
#define PMIC_RG_LDO_VMCH_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VMCH_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VMCH_OP_EN_CLR_ADDR MT6356_LDO_VMCH_OP_EN_CLR
#define PMIC_RG_LDO_VMCH_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VMCH_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VMCH_HW0_OP_CFG_ADDR MT6356_LDO_VMCH_OP_CFG
#define PMIC_RG_LDO_VMCH_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VMCH_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VMCH_HW1_OP_CFG_ADDR MT6356_LDO_VMCH_OP_CFG
#define PMIC_RG_LDO_VMCH_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VMCH_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VMCH_HW2_OP_CFG_ADDR MT6356_LDO_VMCH_OP_CFG
#define PMIC_RG_LDO_VMCH_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VMCH_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VMCH_ON_OP_ADDR MT6356_LDO_VMCH_OP_CFG
#define PMIC_RG_LDO_VMCH_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VMCH_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VMCH_LP_OP_ADDR MT6356_LDO_VMCH_OP_CFG
#define PMIC_RG_LDO_VMCH_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VMCH_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VMCH_OP_CFG_SET_ADDR MT6356_LDO_VMCH_OP_CFG_SET
#define PMIC_RG_LDO_VMCH_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VMCH_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VMCH_OP_CFG_CLR_ADDR MT6356_LDO_VMCH_OP_CFG_CLR
#define PMIC_RG_LDO_VMCH_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VMCH_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VMCH_MODE_ADDR MT6356_LDO_VMCH_CON1
#define PMIC_DA_VMCH_MODE_MASK 0x1
#define PMIC_DA_VMCH_MODE_SHIFT 8
#define PMIC_RG_LDO_VMCH_STBTD_ADDR MT6356_LDO_VMCH_CON1
#define PMIC_RG_LDO_VMCH_STBTD_MASK 0x3
#define PMIC_RG_LDO_VMCH_STBTD_SHIFT 9
#define PMIC_DA_VMCH_STB_ADDR MT6356_LDO_VMCH_CON1
#define PMIC_DA_VMCH_STB_MASK 0x1
#define PMIC_DA_VMCH_STB_SHIFT 14
#define PMIC_DA_VMCH_EN_ADDR MT6356_LDO_VMCH_CON1
#define PMIC_DA_VMCH_EN_MASK 0x1
#define PMIC_DA_VMCH_EN_SHIFT 15
#define PMIC_RG_LDO_VMCH_OCFB_EN_ADDR MT6356_LDO_VMCH_CON2
#define PMIC_RG_LDO_VMCH_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VMCH_OCFB_EN_SHIFT 9
#define PMIC_DA_VMCH_OCFB_EN_ADDR MT6356_LDO_VMCH_CON2
#define PMIC_DA_VMCH_OCFB_EN_MASK 0x1
#define PMIC_DA_VMCH_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VMCH_DUMMY_LOAD_ADDR MT6356_LDO_VMCH_CON3
#define PMIC_RG_LDO_VMCH_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VMCH_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VMCH_DUMMY_LOAD_ADDR MT6356_LDO_VMCH_CON3
#define PMIC_DA_VMCH_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VMCH_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VSIM1_EN_ADDR MT6356_LDO_VSIM1_CON0
#define PMIC_RG_LDO_VSIM1_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM1_EN_SHIFT 0
#define PMIC_RG_LDO_VSIM1_LP_ADDR MT6356_LDO_VSIM1_CON0
#define PMIC_RG_LDO_VSIM1_LP_MASK 0x1
#define PMIC_RG_LDO_VSIM1_LP_SHIFT 1
#define PMIC_RG_LDO_VSIM1_SW_OP_EN_ADDR MT6356_LDO_VSIM1_OP_EN
#define PMIC_RG_LDO_VSIM1_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM1_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VSIM1_HW0_OP_EN_ADDR MT6356_LDO_VSIM1_OP_EN
#define PMIC_RG_LDO_VSIM1_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM1_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VSIM1_HW1_OP_EN_ADDR MT6356_LDO_VSIM1_OP_EN
#define PMIC_RG_LDO_VSIM1_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM1_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VSIM1_HW2_OP_EN_ADDR MT6356_LDO_VSIM1_OP_EN
#define PMIC_RG_LDO_VSIM1_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM1_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VSIM1_OP_EN_SET_ADDR MT6356_LDO_VSIM1_OP_EN_SET
#define PMIC_RG_LDO_VSIM1_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSIM1_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VSIM1_OP_EN_CLR_ADDR MT6356_LDO_VSIM1_OP_EN_CLR
#define PMIC_RG_LDO_VSIM1_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSIM1_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VSIM1_HW0_OP_CFG_ADDR MT6356_LDO_VSIM1_OP_CFG
#define PMIC_RG_LDO_VSIM1_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSIM1_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VSIM1_HW1_OP_CFG_ADDR MT6356_LDO_VSIM1_OP_CFG
#define PMIC_RG_LDO_VSIM1_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSIM1_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VSIM1_HW2_OP_CFG_ADDR MT6356_LDO_VSIM1_OP_CFG
#define PMIC_RG_LDO_VSIM1_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSIM1_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VSIM1_ON_OP_ADDR MT6356_LDO_VSIM1_OP_CFG
#define PMIC_RG_LDO_VSIM1_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VSIM1_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VSIM1_LP_OP_ADDR MT6356_LDO_VSIM1_OP_CFG
#define PMIC_RG_LDO_VSIM1_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VSIM1_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VSIM1_OP_CFG_SET_ADDR MT6356_LDO_VSIM1_OP_CFG_SET
#define PMIC_RG_LDO_VSIM1_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSIM1_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VSIM1_OP_CFG_CLR_ADDR MT6356_LDO_VSIM1_OP_CFG_CLR
#define PMIC_RG_LDO_VSIM1_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSIM1_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VSIM1_MODE_ADDR MT6356_LDO_VSIM1_CON1
#define PMIC_DA_VSIM1_MODE_MASK 0x1
#define PMIC_DA_VSIM1_MODE_SHIFT 8
#define PMIC_RG_LDO_VSIM1_STBTD_ADDR MT6356_LDO_VSIM1_CON1
#define PMIC_RG_LDO_VSIM1_STBTD_MASK 0x3
#define PMIC_RG_LDO_VSIM1_STBTD_SHIFT 9
#define PMIC_DA_VSIM1_STB_ADDR MT6356_LDO_VSIM1_CON1
#define PMIC_DA_VSIM1_STB_MASK 0x1
#define PMIC_DA_VSIM1_STB_SHIFT 14
#define PMIC_DA_VSIM1_EN_ADDR MT6356_LDO_VSIM1_CON1
#define PMIC_DA_VSIM1_EN_MASK 0x1
#define PMIC_DA_VSIM1_EN_SHIFT 15
#define PMIC_RG_LDO_VSIM1_OCFB_EN_ADDR MT6356_LDO_VSIM1_CON2
#define PMIC_RG_LDO_VSIM1_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM1_OCFB_EN_SHIFT 9
#define PMIC_DA_VSIM1_OCFB_EN_ADDR MT6356_LDO_VSIM1_CON2
#define PMIC_DA_VSIM1_OCFB_EN_MASK 0x1
#define PMIC_DA_VSIM1_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VSIM1_DUMMY_LOAD_ADDR MT6356_LDO_VSIM1_CON3
#define PMIC_RG_LDO_VSIM1_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VSIM1_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VSIM1_DUMMY_LOAD_ADDR MT6356_LDO_VSIM1_CON3
#define PMIC_DA_VSIM1_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VSIM1_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VSIM2_EN_ADDR MT6356_LDO_VSIM2_CON0
#define PMIC_RG_LDO_VSIM2_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM2_EN_SHIFT 0
#define PMIC_RG_LDO_VSIM2_LP_ADDR MT6356_LDO_VSIM2_CON0
#define PMIC_RG_LDO_VSIM2_LP_MASK 0x1
#define PMIC_RG_LDO_VSIM2_LP_SHIFT 1
#define PMIC_RG_LDO_VSIM2_SW_OP_EN_ADDR MT6356_LDO_VSIM2_OP_EN
#define PMIC_RG_LDO_VSIM2_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM2_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VSIM2_HW0_OP_EN_ADDR MT6356_LDO_VSIM2_OP_EN
#define PMIC_RG_LDO_VSIM2_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM2_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VSIM2_HW1_OP_EN_ADDR MT6356_LDO_VSIM2_OP_EN
#define PMIC_RG_LDO_VSIM2_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM2_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VSIM2_HW2_OP_EN_ADDR MT6356_LDO_VSIM2_OP_EN
#define PMIC_RG_LDO_VSIM2_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM2_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VSIM2_OP_EN_SET_ADDR MT6356_LDO_VSIM2_OP_EN_SET
#define PMIC_RG_LDO_VSIM2_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSIM2_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VSIM2_OP_EN_CLR_ADDR MT6356_LDO_VSIM2_OP_EN_CLR
#define PMIC_RG_LDO_VSIM2_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSIM2_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VSIM2_HW0_OP_CFG_ADDR MT6356_LDO_VSIM2_OP_CFG
#define PMIC_RG_LDO_VSIM2_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSIM2_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VSIM2_HW1_OP_CFG_ADDR MT6356_LDO_VSIM2_OP_CFG
#define PMIC_RG_LDO_VSIM2_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSIM2_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VSIM2_HW2_OP_CFG_ADDR MT6356_LDO_VSIM2_OP_CFG
#define PMIC_RG_LDO_VSIM2_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSIM2_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VSIM2_ON_OP_ADDR MT6356_LDO_VSIM2_OP_CFG
#define PMIC_RG_LDO_VSIM2_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VSIM2_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VSIM2_LP_OP_ADDR MT6356_LDO_VSIM2_OP_CFG
#define PMIC_RG_LDO_VSIM2_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VSIM2_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VSIM2_OP_CFG_SET_ADDR MT6356_LDO_VSIM2_OP_CFG_SET
#define PMIC_RG_LDO_VSIM2_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSIM2_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VSIM2_OP_CFG_CLR_ADDR MT6356_LDO_VSIM2_OP_CFG_CLR
#define PMIC_RG_LDO_VSIM2_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSIM2_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VSIM2_MODE_ADDR MT6356_LDO_VSIM2_CON1
#define PMIC_DA_VSIM2_MODE_MASK 0x1
#define PMIC_DA_VSIM2_MODE_SHIFT 8
#define PMIC_RG_LDO_VSIM2_STBTD_ADDR MT6356_LDO_VSIM2_CON1
#define PMIC_RG_LDO_VSIM2_STBTD_MASK 0x3
#define PMIC_RG_LDO_VSIM2_STBTD_SHIFT 9
#define PMIC_DA_VSIM2_STB_ADDR MT6356_LDO_VSIM2_CON1
#define PMIC_DA_VSIM2_STB_MASK 0x1
#define PMIC_DA_VSIM2_STB_SHIFT 14
#define PMIC_DA_VSIM2_EN_ADDR MT6356_LDO_VSIM2_CON1
#define PMIC_DA_VSIM2_EN_MASK 0x1
#define PMIC_DA_VSIM2_EN_SHIFT 15
#define PMIC_RG_LDO_VSIM2_OCFB_EN_ADDR MT6356_LDO_VSIM2_CON2
#define PMIC_RG_LDO_VSIM2_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VSIM2_OCFB_EN_SHIFT 9
#define PMIC_DA_VSIM2_OCFB_EN_ADDR MT6356_LDO_VSIM2_CON2
#define PMIC_DA_VSIM2_OCFB_EN_MASK 0x1
#define PMIC_DA_VSIM2_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VSIM2_DUMMY_LOAD_ADDR MT6356_LDO_VSIM2_CON3
#define PMIC_RG_LDO_VSIM2_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VSIM2_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VSIM2_DUMMY_LOAD_ADDR MT6356_LDO_VSIM2_CON3
#define PMIC_DA_VSIM2_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VSIM2_DUMMY_LOAD_SHIFT 14
#define PMIC_LDO_GOFF1_ANA_ID_ADDR MT6356_LDO_GOFF1_DSN_ID
#define PMIC_LDO_GOFF1_ANA_ID_MASK 0xFF
#define PMIC_LDO_GOFF1_ANA_ID_SHIFT 0
#define PMIC_LDO_GOFF1_DIG_ID_ADDR MT6356_LDO_GOFF1_DSN_ID
#define PMIC_LDO_GOFF1_DIG_ID_MASK 0xFF
#define PMIC_LDO_GOFF1_DIG_ID_SHIFT 8
#define PMIC_LDO_GOFF1_ANA_MINOR_REV_ADDR MT6356_LDO_GOFF1_DSN_REV0
#define PMIC_LDO_GOFF1_ANA_MINOR_REV_MASK 0xF
#define PMIC_LDO_GOFF1_ANA_MINOR_REV_SHIFT 0
#define PMIC_LDO_GOFF1_ANA_MAJOR_REV_ADDR MT6356_LDO_GOFF1_DSN_REV0
#define PMIC_LDO_GOFF1_ANA_MAJOR_REV_MASK 0xF
#define PMIC_LDO_GOFF1_ANA_MAJOR_REV_SHIFT 4
#define PMIC_LDO_GOFF1_DIG_MINOR_REV_ADDR MT6356_LDO_GOFF1_DSN_REV0
#define PMIC_LDO_GOFF1_DIG_MINOR_REV_MASK 0xF
#define PMIC_LDO_GOFF1_DIG_MINOR_REV_SHIFT 8
#define PMIC_LDO_GOFF1_DIG_MAJOR_REV_ADDR MT6356_LDO_GOFF1_DSN_REV0
#define PMIC_LDO_GOFF1_DIG_MAJOR_REV_MASK 0xF
#define PMIC_LDO_GOFF1_DIG_MAJOR_REV_SHIFT 12
#define PMIC_LDO_GOFF1_SW_MINOR_REV_ADDR MT6356_LDO_GOFF1_DSN_REV1
#define PMIC_LDO_GOFF1_SW_MINOR_REV_MASK 0xF
#define PMIC_LDO_GOFF1_SW_MINOR_REV_SHIFT 0
#define PMIC_LDO_GOFF1_SW_MAJOR_REV_ADDR MT6356_LDO_GOFF1_DSN_REV1
#define PMIC_LDO_GOFF1_SW_MAJOR_REV_MASK 0xF
#define PMIC_LDO_GOFF1_SW_MAJOR_REV_SHIFT 4
#define PMIC_LDO_GOFF1_ESP_ADDR MT6356_LDO_GOFF1_DSN_REV1
#define PMIC_LDO_GOFF1_ESP_MASK 0xFF
#define PMIC_LDO_GOFF1_ESP_SHIFT 8
#define PMIC_RG_LDO_GOFF1_RSV0_ADDR MT6356_LDO_GOFF1_RSV_CON0
#define PMIC_RG_LDO_GOFF1_RSV0_MASK 0xFFFF
#define PMIC_RG_LDO_GOFF1_RSV0_SHIFT 0
#define PMIC_RG_LDO_GOFF1_RSV1_ADDR MT6356_LDO_GOFF1_RSV_CON1
#define PMIC_RG_LDO_GOFF1_RSV1_MASK 0xFFFF
#define PMIC_RG_LDO_GOFF1_RSV1_SHIFT 0
#define PMIC_RG_LDO_VIBR_EN_ADDR MT6356_LDO_VIBR_CON0
#define PMIC_RG_LDO_VIBR_EN_MASK 0x1
#define PMIC_RG_LDO_VIBR_EN_SHIFT 0
#define PMIC_RG_LDO_VIBR_LP_ADDR MT6356_LDO_VIBR_CON0
#define PMIC_RG_LDO_VIBR_LP_MASK 0x1
#define PMIC_RG_LDO_VIBR_LP_SHIFT 1
#define PMIC_RG_LDO_VIBR_SW_OP_EN_ADDR MT6356_LDO_VIBR_OP_EN
#define PMIC_RG_LDO_VIBR_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIBR_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VIBR_HW0_OP_EN_ADDR MT6356_LDO_VIBR_OP_EN
#define PMIC_RG_LDO_VIBR_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIBR_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VIBR_HW1_OP_EN_ADDR MT6356_LDO_VIBR_OP_EN
#define PMIC_RG_LDO_VIBR_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIBR_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VIBR_HW2_OP_EN_ADDR MT6356_LDO_VIBR_OP_EN
#define PMIC_RG_LDO_VIBR_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VIBR_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VIBR_OP_EN_SET_ADDR MT6356_LDO_VIBR_OP_EN_SET
#define PMIC_RG_LDO_VIBR_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VIBR_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VIBR_OP_EN_CLR_ADDR MT6356_LDO_VIBR_OP_EN_CLR
#define PMIC_RG_LDO_VIBR_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VIBR_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VIBR_HW0_OP_CFG_ADDR MT6356_LDO_VIBR_OP_CFG
#define PMIC_RG_LDO_VIBR_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VIBR_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VIBR_HW1_OP_CFG_ADDR MT6356_LDO_VIBR_OP_CFG
#define PMIC_RG_LDO_VIBR_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VIBR_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VIBR_HW2_OP_CFG_ADDR MT6356_LDO_VIBR_OP_CFG
#define PMIC_RG_LDO_VIBR_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VIBR_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VIBR_ON_OP_ADDR MT6356_LDO_VIBR_OP_CFG
#define PMIC_RG_LDO_VIBR_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VIBR_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VIBR_LP_OP_ADDR MT6356_LDO_VIBR_OP_CFG
#define PMIC_RG_LDO_VIBR_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VIBR_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VIBR_OP_CFG_SET_ADDR MT6356_LDO_VIBR_OP_CFG_SET
#define PMIC_RG_LDO_VIBR_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VIBR_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VIBR_OP_CFG_CLR_ADDR MT6356_LDO_VIBR_OP_CFG_CLR
#define PMIC_RG_LDO_VIBR_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VIBR_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VIBR_MODE_ADDR MT6356_LDO_VIBR_CON1
#define PMIC_DA_VIBR_MODE_MASK 0x1
#define PMIC_DA_VIBR_MODE_SHIFT 8
#define PMIC_RG_LDO_VIBR_STBTD_ADDR MT6356_LDO_VIBR_CON1
#define PMIC_RG_LDO_VIBR_STBTD_MASK 0x3
#define PMIC_RG_LDO_VIBR_STBTD_SHIFT 9
#define PMIC_DA_VIBR_STB_ADDR MT6356_LDO_VIBR_CON1
#define PMIC_DA_VIBR_STB_MASK 0x1
#define PMIC_DA_VIBR_STB_SHIFT 14
#define PMIC_DA_VIBR_EN_ADDR MT6356_LDO_VIBR_CON1
#define PMIC_DA_VIBR_EN_MASK 0x1
#define PMIC_DA_VIBR_EN_SHIFT 15
#define PMIC_RG_LDO_VIBR_THER_SDN_EN_ADDR MT6356_LDO_VIBR_CON2
#define PMIC_RG_LDO_VIBR_THER_SDN_EN_MASK 0x1
#define PMIC_RG_LDO_VIBR_THER_SDN_EN_SHIFT 4
#define PMIC_RG_LDO_VIBR_OCFB_EN_ADDR MT6356_LDO_VIBR_CON2
#define PMIC_RG_LDO_VIBR_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VIBR_OCFB_EN_SHIFT 9
#define PMIC_DA_VIBR_OCFB_EN_ADDR MT6356_LDO_VIBR_CON2
#define PMIC_DA_VIBR_OCFB_EN_MASK 0x1
#define PMIC_DA_VIBR_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VIBR_DUMMY_LOAD_ADDR MT6356_LDO_VIBR_CON3
#define PMIC_RG_LDO_VIBR_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VIBR_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VIBR_DUMMY_LOAD_ADDR MT6356_LDO_VIBR_CON3
#define PMIC_DA_VIBR_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VIBR_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VBIF28_EN_ADDR MT6356_LDO_VBIF28_CON0
#define PMIC_RG_LDO_VBIF28_EN_MASK 0x1
#define PMIC_RG_LDO_VBIF28_EN_SHIFT 0
#define PMIC_RG_LDO_VBIF28_LP_ADDR MT6356_LDO_VBIF28_CON0
#define PMIC_RG_LDO_VBIF28_LP_MASK 0x1
#define PMIC_RG_LDO_VBIF28_LP_SHIFT 1
#define PMIC_RG_LDO_VBIF28_SW_OP_EN_ADDR MT6356_LDO_VBIF28_OP_EN
#define PMIC_RG_LDO_VBIF28_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VBIF28_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VBIF28_HW0_OP_EN_ADDR MT6356_LDO_VBIF28_OP_EN
#define PMIC_RG_LDO_VBIF28_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VBIF28_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VBIF28_HW1_OP_EN_ADDR MT6356_LDO_VBIF28_OP_EN
#define PMIC_RG_LDO_VBIF28_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VBIF28_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VBIF28_HW2_OP_EN_ADDR MT6356_LDO_VBIF28_OP_EN
#define PMIC_RG_LDO_VBIF28_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VBIF28_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VBIF28_OP_EN_SET_ADDR MT6356_LDO_VBIF28_OP_EN_SET
#define PMIC_RG_LDO_VBIF28_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VBIF28_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VBIF28_OP_EN_CLR_ADDR MT6356_LDO_VBIF28_OP_EN_CLR
#define PMIC_RG_LDO_VBIF28_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VBIF28_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VBIF28_HW0_OP_CFG_ADDR MT6356_LDO_VBIF28_OP_CFG
#define PMIC_RG_LDO_VBIF28_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VBIF28_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VBIF28_HW1_OP_CFG_ADDR MT6356_LDO_VBIF28_OP_CFG
#define PMIC_RG_LDO_VBIF28_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VBIF28_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VBIF28_HW2_OP_CFG_ADDR MT6356_LDO_VBIF28_OP_CFG
#define PMIC_RG_LDO_VBIF28_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VBIF28_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VBIF28_ON_OP_ADDR MT6356_LDO_VBIF28_OP_CFG
#define PMIC_RG_LDO_VBIF28_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VBIF28_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VBIF28_LP_OP_ADDR MT6356_LDO_VBIF28_OP_CFG
#define PMIC_RG_LDO_VBIF28_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VBIF28_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VBIF28_OP_CFG_SET_ADDR MT6356_LDO_VBIF28_OP_CFG_SET
#define PMIC_RG_LDO_VBIF28_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VBIF28_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VBIF28_OP_CFG_CLR_ADDR MT6356_LDO_VBIF28_OP_CFG_CLR
#define PMIC_RG_LDO_VBIF28_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VBIF28_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VBIF28_MODE_ADDR MT6356_LDO_VBIF28_CON1
#define PMIC_DA_VBIF28_MODE_MASK 0x1
#define PMIC_DA_VBIF28_MODE_SHIFT 8
#define PMIC_RG_LDO_VBIF28_STBTD_ADDR MT6356_LDO_VBIF28_CON1
#define PMIC_RG_LDO_VBIF28_STBTD_MASK 0x3
#define PMIC_RG_LDO_VBIF28_STBTD_SHIFT 9
#define PMIC_DA_VBIF28_STB_ADDR MT6356_LDO_VBIF28_CON1
#define PMIC_DA_VBIF28_STB_MASK 0x1
#define PMIC_DA_VBIF28_STB_SHIFT 14
#define PMIC_DA_VBIF28_EN_ADDR MT6356_LDO_VBIF28_CON1
#define PMIC_DA_VBIF28_EN_MASK 0x1
#define PMIC_DA_VBIF28_EN_SHIFT 15
#define PMIC_RG_LDO_VBIF28_OCFB_EN_ADDR MT6356_LDO_VBIF28_CON2
#define PMIC_RG_LDO_VBIF28_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VBIF28_OCFB_EN_SHIFT 9
#define PMIC_DA_VBIF28_OCFB_EN_ADDR MT6356_LDO_VBIF28_CON2
#define PMIC_DA_VBIF28_OCFB_EN_MASK 0x1
#define PMIC_DA_VBIF28_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VBIF28_DUMMY_LOAD_ADDR MT6356_LDO_VBIF28_CON3
#define PMIC_RG_LDO_VBIF28_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VBIF28_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VBIF28_DUMMY_LOAD_ADDR MT6356_LDO_VBIF28_CON3
#define PMIC_DA_VBIF28_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VBIF28_DUMMY_LOAD_SHIFT 14
#define PMIC_LDO_MULTIUSER_ANA_ID_ADDR MT6356_LDO_MULTIUSER_DSN_ID
#define PMIC_LDO_MULTIUSER_ANA_ID_MASK 0xFF
#define PMIC_LDO_MULTIUSER_ANA_ID_SHIFT 0
#define PMIC_LDO_MULTIUSER_DIG_ID_ADDR MT6356_LDO_MULTIUSER_DSN_ID
#define PMIC_LDO_MULTIUSER_DIG_ID_MASK 0xFF
#define PMIC_LDO_MULTIUSER_DIG_ID_SHIFT 8
#define PMIC_LDO_MULTIUSER_ANA_MINOR_REV_ADDR MT6356_LDO_MULTIUSER_DSN_REV0
#define PMIC_LDO_MULTIUSER_ANA_MINOR_REV_MASK 0xF
#define PMIC_LDO_MULTIUSER_ANA_MINOR_REV_SHIFT 0
#define PMIC_LDO_MULTIUSER_ANA_MAJOR_REV_ADDR MT6356_LDO_MULTIUSER_DSN_REV0
#define PMIC_LDO_MULTIUSER_ANA_MAJOR_REV_MASK 0xF
#define PMIC_LDO_MULTIUSER_ANA_MAJOR_REV_SHIFT 4
#define PMIC_LDO_MULTIUSER_DIG_MINOR_REV_ADDR MT6356_LDO_MULTIUSER_DSN_REV0
#define PMIC_LDO_MULTIUSER_DIG_MINOR_REV_MASK 0xF
#define PMIC_LDO_MULTIUSER_DIG_MINOR_REV_SHIFT 8
#define PMIC_LDO_MULTIUSER_DIG_MAJOR_REV_ADDR MT6356_LDO_MULTIUSER_DSN_REV0
#define PMIC_LDO_MULTIUSER_DIG_MAJOR_REV_MASK 0xF
#define PMIC_LDO_MULTIUSER_DIG_MAJOR_REV_SHIFT 12
#define PMIC_LDO_MULTIUSER_SW_MINOR_REV_ADDR MT6356_LDO_MULTIUSER_DSN_REV1
#define PMIC_LDO_MULTIUSER_SW_MINOR_REV_MASK 0xF
#define PMIC_LDO_MULTIUSER_SW_MINOR_REV_SHIFT 0
#define PMIC_LDO_MULTIUSER_SW_MAJOR_REV_ADDR MT6356_LDO_MULTIUSER_DSN_REV1
#define PMIC_LDO_MULTIUSER_SW_MAJOR_REV_MASK 0xF
#define PMIC_LDO_MULTIUSER_SW_MAJOR_REV_SHIFT 4
#define PMIC_LDO_MULTIUSER_ESP_ADDR MT6356_LDO_MULTIUSER_DSN_REV1
#define PMIC_LDO_MULTIUSER_ESP_MASK 0xFF
#define PMIC_LDO_MULTIUSER_ESP_SHIFT 8
#define PMIC_RG_LDO_MULTIUSER_RSV0_ADDR MT6356_LDO_MULTIUSER_RSV_CON0
#define PMIC_RG_LDO_MULTIUSER_RSV0_MASK 0xFFFF
#define PMIC_RG_LDO_MULTIUSER_RSV0_SHIFT 0
#define PMIC_RG_LDO_MULTIUSER_RSV1_ADDR MT6356_LDO_MULTIUSER_RSV_CON1
#define PMIC_RG_LDO_MULTIUSER_RSV1_MASK 0xFFFF
#define PMIC_RG_LDO_MULTIUSER_RSV1_SHIFT 0
#define PMIC_RG_LDO_VCN33_EN_0_ADDR MT6356_LDO_VCN33_CON0_0
#define PMIC_RG_LDO_VCN33_EN_0_MASK 0x1
#define PMIC_RG_LDO_VCN33_EN_0_SHIFT 0
#define PMIC_RG_LDO_VCN33_LP_ADDR MT6356_LDO_VCN33_CON0_0
#define PMIC_RG_LDO_VCN33_LP_MASK 0x1
#define PMIC_RG_LDO_VCN33_LP_SHIFT 1
#define PMIC_RG_LDO_VCN33_SW_OP_EN_ADDR MT6356_LDO_VCN33_OP_EN
#define PMIC_RG_LDO_VCN33_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN33_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VCN33_HW0_OP_EN_ADDR MT6356_LDO_VCN33_OP_EN
#define PMIC_RG_LDO_VCN33_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN33_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VCN33_HW1_OP_EN_ADDR MT6356_LDO_VCN33_OP_EN
#define PMIC_RG_LDO_VCN33_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN33_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VCN33_HW2_OP_EN_ADDR MT6356_LDO_VCN33_OP_EN
#define PMIC_RG_LDO_VCN33_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN33_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VCN33_OP_EN_SET_ADDR MT6356_LDO_VCN33_OP_EN_SET
#define PMIC_RG_LDO_VCN33_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCN33_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VCN33_OP_EN_CLR_ADDR MT6356_LDO_VCN33_OP_EN_CLR
#define PMIC_RG_LDO_VCN33_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCN33_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VCN33_HW0_OP_CFG_ADDR MT6356_LDO_VCN33_OP_CFG
#define PMIC_RG_LDO_VCN33_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN33_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VCN33_HW1_OP_CFG_ADDR MT6356_LDO_VCN33_OP_CFG
#define PMIC_RG_LDO_VCN33_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN33_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VCN33_HW2_OP_CFG_ADDR MT6356_LDO_VCN33_OP_CFG
#define PMIC_RG_LDO_VCN33_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN33_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VCN33_ON_OP_ADDR MT6356_LDO_VCN33_OP_CFG
#define PMIC_RG_LDO_VCN33_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VCN33_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VCN33_LP_OP_ADDR MT6356_LDO_VCN33_OP_CFG
#define PMIC_RG_LDO_VCN33_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VCN33_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VCN33_OP_CFG_SET_ADDR MT6356_LDO_VCN33_OP_CFG_SET
#define PMIC_RG_LDO_VCN33_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCN33_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VCN33_OP_CFG_CLR_ADDR MT6356_LDO_VCN33_OP_CFG_CLR
#define PMIC_RG_LDO_VCN33_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCN33_OP_CFG_CLR_SHIFT 0
#define PMIC_RG_LDO_VCN33_EN_1_ADDR MT6356_LDO_VCN33_CON0_1
#define PMIC_RG_LDO_VCN33_EN_1_MASK 0x1
#define PMIC_RG_LDO_VCN33_EN_1_SHIFT 0
#define PMIC_DA_VCN33_MODE_ADDR MT6356_LDO_VCN33_CON1
#define PMIC_DA_VCN33_MODE_MASK 0x1
#define PMIC_DA_VCN33_MODE_SHIFT 8
#define PMIC_RG_LDO_VCN33_STBTD_ADDR MT6356_LDO_VCN33_CON1
#define PMIC_RG_LDO_VCN33_STBTD_MASK 0x3
#define PMIC_RG_LDO_VCN33_STBTD_SHIFT 9
#define PMIC_DA_VCN33_STB_ADDR MT6356_LDO_VCN33_CON1
#define PMIC_DA_VCN33_STB_MASK 0x1
#define PMIC_DA_VCN33_STB_SHIFT 14
#define PMIC_DA_VCN33_EN_ADDR MT6356_LDO_VCN33_CON1
#define PMIC_DA_VCN33_EN_MASK 0x1
#define PMIC_DA_VCN33_EN_SHIFT 15
#define PMIC_RG_LDO_VCN33_OCFB_EN_ADDR MT6356_LDO_VCN33_CON2
#define PMIC_RG_LDO_VCN33_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VCN33_OCFB_EN_SHIFT 9
#define PMIC_DA_VCN33_OCFB_EN_ADDR MT6356_LDO_VCN33_CON2
#define PMIC_DA_VCN33_OCFB_EN_MASK 0x1
#define PMIC_DA_VCN33_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VCN33_DUMMY_LOAD_ADDR MT6356_LDO_VCN33_CON3
#define PMIC_RG_LDO_VCN33_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VCN33_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VCN33_DUMMY_LOAD_ADDR MT6356_LDO_VCN33_CON3
#define PMIC_DA_VCN33_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VCN33_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VLDO28_EN_0_ADDR MT6356_LDO_VLDO28_CON0_0
#define PMIC_RG_LDO_VLDO28_EN_0_MASK 0x1
#define PMIC_RG_LDO_VLDO28_EN_0_SHIFT 0
#define PMIC_RG_LDO_VLDO28_LP_ADDR MT6356_LDO_VLDO28_CON0_0
#define PMIC_RG_LDO_VLDO28_LP_MASK 0x1
#define PMIC_RG_LDO_VLDO28_LP_SHIFT 1
#define PMIC_RG_LDO_VLDO28_SW_OP_EN_ADDR MT6356_LDO_VLDO28_OP_EN
#define PMIC_RG_LDO_VLDO28_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VLDO28_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VLDO28_HW0_OP_EN_ADDR MT6356_LDO_VLDO28_OP_EN
#define PMIC_RG_LDO_VLDO28_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VLDO28_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VLDO28_HW1_OP_EN_ADDR MT6356_LDO_VLDO28_OP_EN
#define PMIC_RG_LDO_VLDO28_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VLDO28_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VLDO28_HW2_OP_EN_ADDR MT6356_LDO_VLDO28_OP_EN
#define PMIC_RG_LDO_VLDO28_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VLDO28_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VLDO28_OP_EN_SET_ADDR MT6356_LDO_VLDO28_OP_EN_SET
#define PMIC_RG_LDO_VLDO28_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VLDO28_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VLDO28_OP_EN_CLR_ADDR MT6356_LDO_VLDO28_OP_EN_CLR
#define PMIC_RG_LDO_VLDO28_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VLDO28_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VLDO28_HW0_OP_CFG_ADDR MT6356_LDO_VLDO28_OP_CFG
#define PMIC_RG_LDO_VLDO28_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VLDO28_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VLDO28_HW1_OP_CFG_ADDR MT6356_LDO_VLDO28_OP_CFG
#define PMIC_RG_LDO_VLDO28_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VLDO28_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VLDO28_HW2_OP_CFG_ADDR MT6356_LDO_VLDO28_OP_CFG
#define PMIC_RG_LDO_VLDO28_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VLDO28_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VLDO28_ON_OP_ADDR MT6356_LDO_VLDO28_OP_CFG
#define PMIC_RG_LDO_VLDO28_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VLDO28_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VLDO28_LP_OP_ADDR MT6356_LDO_VLDO28_OP_CFG
#define PMIC_RG_LDO_VLDO28_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VLDO28_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VLDO28_OP_CFG_SET_ADDR MT6356_LDO_VLDO28_OP_CFG_SET
#define PMIC_RG_LDO_VLDO28_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VLDO28_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VLDO28_OP_CFG_CLR_ADDR MT6356_LDO_VLDO28_OP_CFG_CLR
#define PMIC_RG_LDO_VLDO28_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VLDO28_OP_CFG_CLR_SHIFT 0
#define PMIC_RG_LDO_VLDO28_EN_1_ADDR MT6356_LDO_VLDO28_CON0_1
#define PMIC_RG_LDO_VLDO28_EN_1_MASK 0x1
#define PMIC_RG_LDO_VLDO28_EN_1_SHIFT 0
#define PMIC_DA_VLDO28_MODE_ADDR MT6356_LDO_VLDO28_CON1
#define PMIC_DA_VLDO28_MODE_MASK 0x1
#define PMIC_DA_VLDO28_MODE_SHIFT 8
#define PMIC_RG_LDO_VLDO28_STBTD_ADDR MT6356_LDO_VLDO28_CON1
#define PMIC_RG_LDO_VLDO28_STBTD_MASK 0x3
#define PMIC_RG_LDO_VLDO28_STBTD_SHIFT 9
#define PMIC_DA_VLDO28_STB_ADDR MT6356_LDO_VLDO28_CON1
#define PMIC_DA_VLDO28_STB_MASK 0x1
#define PMIC_DA_VLDO28_STB_SHIFT 14
#define PMIC_DA_VLDO28_EN_ADDR MT6356_LDO_VLDO28_CON1
#define PMIC_DA_VLDO28_EN_MASK 0x1
#define PMIC_DA_VLDO28_EN_SHIFT 15
#define PMIC_RG_LDO_VLDO28_OCFB_EN_ADDR MT6356_LDO_VLDO28_CON2
#define PMIC_RG_LDO_VLDO28_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VLDO28_OCFB_EN_SHIFT 9
#define PMIC_DA_VLDO28_OCFB_EN_ADDR MT6356_LDO_VLDO28_CON2
#define PMIC_DA_VLDO28_OCFB_EN_MASK 0x1
#define PMIC_DA_VLDO28_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VLDO28_DUMMY_LOAD_ADDR MT6356_LDO_VLDO28_CON3
#define PMIC_RG_LDO_VLDO28_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VLDO28_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VLDO28_DUMMY_LOAD_ADDR MT6356_LDO_VLDO28_CON3
#define PMIC_DA_VLDO28_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VLDO28_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VUSB_EN_0_ADDR MT6356_LDO_VUSB_CON0_0
#define PMIC_RG_LDO_VUSB_EN_0_MASK 0x1
#define PMIC_RG_LDO_VUSB_EN_0_SHIFT 0
#define PMIC_RG_LDO_VUSB_LP_ADDR MT6356_LDO_VUSB_CON0_0
#define PMIC_RG_LDO_VUSB_LP_MASK 0x1
#define PMIC_RG_LDO_VUSB_LP_SHIFT 1
#define PMIC_RG_LDO_VUSB_SW_OP_EN_ADDR MT6356_LDO_VUSB_OP_EN
#define PMIC_RG_LDO_VUSB_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VUSB_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VUSB_HW0_OP_EN_ADDR MT6356_LDO_VUSB_OP_EN
#define PMIC_RG_LDO_VUSB_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VUSB_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VUSB_HW1_OP_EN_ADDR MT6356_LDO_VUSB_OP_EN
#define PMIC_RG_LDO_VUSB_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VUSB_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VUSB_HW2_OP_EN_ADDR MT6356_LDO_VUSB_OP_EN
#define PMIC_RG_LDO_VUSB_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VUSB_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VUSB_OP_EN_SET_ADDR MT6356_LDO_VUSB_OP_EN_SET
#define PMIC_RG_LDO_VUSB_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VUSB_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VUSB_OP_EN_CLR_ADDR MT6356_LDO_VUSB_OP_EN_CLR
#define PMIC_RG_LDO_VUSB_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VUSB_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VUSB_HW0_OP_CFG_ADDR MT6356_LDO_VUSB_OP_CFG
#define PMIC_RG_LDO_VUSB_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VUSB_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VUSB_HW1_OP_CFG_ADDR MT6356_LDO_VUSB_OP_CFG
#define PMIC_RG_LDO_VUSB_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VUSB_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VUSB_HW2_OP_CFG_ADDR MT6356_LDO_VUSB_OP_CFG
#define PMIC_RG_LDO_VUSB_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VUSB_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VUSB_ON_OP_ADDR MT6356_LDO_VUSB_OP_CFG
#define PMIC_RG_LDO_VUSB_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VUSB_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VUSB_LP_OP_ADDR MT6356_LDO_VUSB_OP_CFG
#define PMIC_RG_LDO_VUSB_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VUSB_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VUSB_OP_CFG_SET_ADDR MT6356_LDO_VUSB_OP_CFG_SET
#define PMIC_RG_LDO_VUSB_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VUSB_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VUSB_OP_CFG_CLR_ADDR MT6356_LDO_VUSB_OP_CFG_CLR
#define PMIC_RG_LDO_VUSB_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VUSB_OP_CFG_CLR_SHIFT 0
#define PMIC_RG_LDO_VUSB_EN_1_ADDR MT6356_LDO_VUSB_CON0_1
#define PMIC_RG_LDO_VUSB_EN_1_MASK 0x1
#define PMIC_RG_LDO_VUSB_EN_1_SHIFT 0
#define PMIC_DA_VUSB_MODE_ADDR MT6356_LDO_VUSB_CON1
#define PMIC_DA_VUSB_MODE_MASK 0x1
#define PMIC_DA_VUSB_MODE_SHIFT 8
#define PMIC_RG_LDO_VUSB_STBTD_ADDR MT6356_LDO_VUSB_CON1
#define PMIC_RG_LDO_VUSB_STBTD_MASK 0x3
#define PMIC_RG_LDO_VUSB_STBTD_SHIFT 9
#define PMIC_DA_VUSB_STB_ADDR MT6356_LDO_VUSB_CON1
#define PMIC_DA_VUSB_STB_MASK 0x1
#define PMIC_DA_VUSB_STB_SHIFT 14
#define PMIC_DA_VUSB_EN_ADDR MT6356_LDO_VUSB_CON1
#define PMIC_DA_VUSB_EN_MASK 0x1
#define PMIC_DA_VUSB_EN_SHIFT 15
#define PMIC_RG_LDO_VUSB_OCFB_EN_ADDR MT6356_LDO_VUSB_CON2
#define PMIC_RG_LDO_VUSB_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VUSB_OCFB_EN_SHIFT 9
#define PMIC_DA_VUSB_OCFB_EN_ADDR MT6356_LDO_VUSB_CON2
#define PMIC_DA_VUSB_OCFB_EN_MASK 0x1
#define PMIC_DA_VUSB_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VUSB_DUMMY_LOAD_ADDR MT6356_LDO_VUSB_CON3
#define PMIC_RG_LDO_VUSB_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VUSB_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VUSB_DUMMY_LOAD_ADDR MT6356_LDO_VUSB_CON3
#define PMIC_DA_VUSB_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VUSB_DUMMY_LOAD_SHIFT 14
#define PMIC_RG_LDO_VLDO28_ULP_EN_ADDR MT6356_LDO_VLDO28_ULP_CON0
#define PMIC_RG_LDO_VLDO28_ULP_EN_MASK 0x1
#define PMIC_RG_LDO_VLDO28_ULP_EN_SHIFT 0
#define PMIC_RG_LDO_VLDO28_T1_ADDR MT6356_LDO_VLDO28_ULP_CON0
#define PMIC_RG_LDO_VLDO28_T1_MASK 0x3
#define PMIC_RG_LDO_VLDO28_T1_SHIFT 1
#define PMIC_RG_LDO_VLDO28_T2_ADDR MT6356_LDO_VLDO28_ULP_CON0
#define PMIC_RG_LDO_VLDO28_T2_MASK 0xF
#define PMIC_RG_LDO_VLDO28_T2_SHIFT 8
#define PMIC_DA_VLDO28_ULP_EN_ADDR MT6356_LDO_VLDO28_ULP_CON0
#define PMIC_DA_VLDO28_ULP_EN_MASK 0x1
#define PMIC_DA_VLDO28_ULP_EN_SHIFT 14
#define PMIC_RG_LDO_VUSB_ULP_EN_ADDR MT6356_LDO_VUSB_ULP_CON0
#define PMIC_RG_LDO_VUSB_ULP_EN_MASK 0x1
#define PMIC_RG_LDO_VUSB_ULP_EN_SHIFT 0
#define PMIC_RG_LDO_VUSB_T1_ADDR MT6356_LDO_VUSB_ULP_CON0
#define PMIC_RG_LDO_VUSB_T1_MASK 0x3
#define PMIC_RG_LDO_VUSB_T1_SHIFT 1
#define PMIC_RG_LDO_VUSB_T2_ADDR MT6356_LDO_VUSB_ULP_CON0
#define PMIC_RG_LDO_VUSB_T2_MASK 0xF
#define PMIC_RG_LDO_VUSB_T2_SHIFT 8
#define PMIC_DA_VUSB_ULP_EN_ADDR MT6356_LDO_VUSB_ULP_CON0
#define PMIC_DA_VUSB_ULP_EN_MASK 0x1
#define PMIC_DA_VUSB_ULP_EN_SHIFT 14
#define PMIC_LDO_FOURUSER_ANA_ID_ADDR MT6356_LDO_FOURUSER_DSN_ID
#define PMIC_LDO_FOURUSER_ANA_ID_MASK 0xFF
#define PMIC_LDO_FOURUSER_ANA_ID_SHIFT 0
#define PMIC_LDO_FOURUSER_DIG_ID_ADDR MT6356_LDO_FOURUSER_DSN_ID
#define PMIC_LDO_FOURUSER_DIG_ID_MASK 0xFF
#define PMIC_LDO_FOURUSER_DIG_ID_SHIFT 8
#define PMIC_LDO_FOURUSER_ANA_MINOR_REV_ADDR MT6356_LDO_FOURUSER_DSN_REV0
#define PMIC_LDO_FOURUSER_ANA_MINOR_REV_MASK 0xF
#define PMIC_LDO_FOURUSER_ANA_MINOR_REV_SHIFT 0
#define PMIC_LDO_FOURUSER_ANA_MAJOR_REV_ADDR MT6356_LDO_FOURUSER_DSN_REV0
#define PMIC_LDO_FOURUSER_ANA_MAJOR_REV_MASK 0xF
#define PMIC_LDO_FOURUSER_ANA_MAJOR_REV_SHIFT 4
#define PMIC_LDO_FOURUSER_DIG_MINOR_REV_ADDR MT6356_LDO_FOURUSER_DSN_REV0
#define PMIC_LDO_FOURUSER_DIG_MINOR_REV_MASK 0xF
#define PMIC_LDO_FOURUSER_DIG_MINOR_REV_SHIFT 8
#define PMIC_LDO_FOURUSER_DIG_MAJOR_REV_ADDR MT6356_LDO_FOURUSER_DSN_REV0
#define PMIC_LDO_FOURUSER_DIG_MAJOR_REV_MASK 0xF
#define PMIC_LDO_FOURUSER_DIG_MAJOR_REV_SHIFT 12
#define PMIC_LDO_FOURUSER_SW_MINOR_REV_ADDR MT6356_LDO_FOURUSER_DSN_REV1
#define PMIC_LDO_FOURUSER_SW_MINOR_REV_MASK 0xF
#define PMIC_LDO_FOURUSER_SW_MINOR_REV_SHIFT 0
#define PMIC_LDO_FOURUSER_SW_MAJOR_REV_ADDR MT6356_LDO_FOURUSER_DSN_REV1
#define PMIC_LDO_FOURUSER_SW_MAJOR_REV_MASK 0xF
#define PMIC_LDO_FOURUSER_SW_MAJOR_REV_SHIFT 4
#define PMIC_LDO_FOURUSER_ESP_ADDR MT6356_LDO_FOURUSER_DSN_REV1
#define PMIC_LDO_FOURUSER_ESP_MASK 0xFF
#define PMIC_LDO_FOURUSER_ESP_SHIFT 8
#define PMIC_RG_LDO_FOURUSER_RSV0_ADDR MT6356_LDO_FOURUSER_RSV_CON0
#define PMIC_RG_LDO_FOURUSER_RSV0_MASK 0xFFFF
#define PMIC_RG_LDO_FOURUSER_RSV0_SHIFT 0
#define PMIC_RG_LDO_FOURUSER_RSV1_ADDR MT6356_LDO_FOURUSER_RSV_CON1
#define PMIC_RG_LDO_FOURUSER_RSV1_MASK 0xFFFF
#define PMIC_RG_LDO_FOURUSER_RSV1_SHIFT 0
#define PMIC_RG_LDO_VCN28_EN_ADDR MT6356_LDO_VCN28_CON0
#define PMIC_RG_LDO_VCN28_EN_MASK 0x1
#define PMIC_RG_LDO_VCN28_EN_SHIFT 0
#define PMIC_RG_LDO_VCN28_LP_ADDR MT6356_LDO_VCN28_CON0
#define PMIC_RG_LDO_VCN28_LP_MASK 0x1
#define PMIC_RG_LDO_VCN28_LP_SHIFT 1
#define PMIC_RG_LDO_VCN28_SW_OP_EN_ADDR MT6356_LDO_VCN28_OP_EN
#define PMIC_RG_LDO_VCN28_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN28_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VCN28_HW0_OP_EN_ADDR MT6356_LDO_VCN28_OP_EN
#define PMIC_RG_LDO_VCN28_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN28_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VCN28_HW1_OP_EN_ADDR MT6356_LDO_VCN28_OP_EN
#define PMIC_RG_LDO_VCN28_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN28_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VCN28_HW2_OP_EN_ADDR MT6356_LDO_VCN28_OP_EN
#define PMIC_RG_LDO_VCN28_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN28_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VCN28_HW3_OP_EN_ADDR MT6356_LDO_VCN28_OP_EN
#define PMIC_RG_LDO_VCN28_HW3_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VCN28_HW3_OP_EN_SHIFT 4
#define PMIC_RG_LDO_VCN28_OP_EN_SET_ADDR MT6356_LDO_VCN28_OP_EN_SET
#define PMIC_RG_LDO_VCN28_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCN28_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VCN28_OP_EN_CLR_ADDR MT6356_LDO_VCN28_OP_EN_CLR
#define PMIC_RG_LDO_VCN28_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCN28_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VCN28_HW0_OP_CFG_ADDR MT6356_LDO_VCN28_OP_CFG
#define PMIC_RG_LDO_VCN28_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN28_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VCN28_HW1_OP_CFG_ADDR MT6356_LDO_VCN28_OP_CFG
#define PMIC_RG_LDO_VCN28_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN28_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VCN28_HW2_OP_CFG_ADDR MT6356_LDO_VCN28_OP_CFG
#define PMIC_RG_LDO_VCN28_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN28_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VCN28_HW3_OP_CFG_ADDR MT6356_LDO_VCN28_OP_CFG
#define PMIC_RG_LDO_VCN28_HW3_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VCN28_HW3_OP_CFG_SHIFT 4
#define PMIC_RG_LDO_VCN28_ON_OP_ADDR MT6356_LDO_VCN28_OP_CFG
#define PMIC_RG_LDO_VCN28_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VCN28_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VCN28_LP_OP_ADDR MT6356_LDO_VCN28_OP_CFG
#define PMIC_RG_LDO_VCN28_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VCN28_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VCN28_OP_CFG_SET_ADDR MT6356_LDO_VCN28_OP_CFG_SET
#define PMIC_RG_LDO_VCN28_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VCN28_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VCN28_OP_CFG_CLR_ADDR MT6356_LDO_VCN28_OP_CFG_CLR
#define PMIC_RG_LDO_VCN28_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VCN28_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VCN28_MODE_ADDR MT6356_LDO_VCN28_CON1
#define PMIC_DA_VCN28_MODE_MASK 0x1
#define PMIC_DA_VCN28_MODE_SHIFT 8
#define PMIC_RG_LDO_VCN28_STBTD_ADDR MT6356_LDO_VCN28_CON1
#define PMIC_RG_LDO_VCN28_STBTD_MASK 0x3
#define PMIC_RG_LDO_VCN28_STBTD_SHIFT 9
#define PMIC_DA_VCN28_STB_ADDR MT6356_LDO_VCN28_CON1
#define PMIC_DA_VCN28_STB_MASK 0x1
#define PMIC_DA_VCN28_STB_SHIFT 14
#define PMIC_DA_VCN28_EN_ADDR MT6356_LDO_VCN28_CON1
#define PMIC_DA_VCN28_EN_MASK 0x1
#define PMIC_DA_VCN28_EN_SHIFT 15
#define PMIC_RG_LDO_VCN28_OCFB_EN_ADDR MT6356_LDO_VCN28_CON2
#define PMIC_RG_LDO_VCN28_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VCN28_OCFB_EN_SHIFT 9
#define PMIC_DA_VCN28_OCFB_EN_ADDR MT6356_LDO_VCN28_CON2
#define PMIC_DA_VCN28_OCFB_EN_MASK 0x1
#define PMIC_DA_VCN28_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VCN28_DUMMY_LOAD_ADDR MT6356_LDO_VCN28_CON3
#define PMIC_RG_LDO_VCN28_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VCN28_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VCN28_DUMMY_LOAD_ADDR MT6356_LDO_VCN28_CON3
#define PMIC_DA_VCN28_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VCN28_DUMMY_LOAD_SHIFT 14
#define PMIC_LDO_VSRAM_ANA_ID_ADDR MT6356_LDO_VSRAM_DSN_ID
#define PMIC_LDO_VSRAM_ANA_ID_MASK 0xFF
#define PMIC_LDO_VSRAM_ANA_ID_SHIFT 0
#define PMIC_LDO_VSRAM_DIG_ID_ADDR MT6356_LDO_VSRAM_DSN_ID
#define PMIC_LDO_VSRAM_DIG_ID_MASK 0xFF
#define PMIC_LDO_VSRAM_DIG_ID_SHIFT 8
#define PMIC_LDO_VSRAM_ANA_MINOR_REV_ADDR MT6356_LDO_VSRAM_DSN_REV0
#define PMIC_LDO_VSRAM_ANA_MINOR_REV_MASK 0xF
#define PMIC_LDO_VSRAM_ANA_MINOR_REV_SHIFT 0
#define PMIC_LDO_VSRAM_ANA_MAJOR_REV_ADDR MT6356_LDO_VSRAM_DSN_REV0
#define PMIC_LDO_VSRAM_ANA_MAJOR_REV_MASK 0xF
#define PMIC_LDO_VSRAM_ANA_MAJOR_REV_SHIFT 4
#define PMIC_LDO_VSRAM_DIG_MINOR_REV_ADDR MT6356_LDO_VSRAM_DSN_REV0
#define PMIC_LDO_VSRAM_DIG_MINOR_REV_MASK 0xF
#define PMIC_LDO_VSRAM_DIG_MINOR_REV_SHIFT 8
#define PMIC_LDO_VSRAM_DIG_MAJOR_REV_ADDR MT6356_LDO_VSRAM_DSN_REV0
#define PMIC_LDO_VSRAM_DIG_MAJOR_REV_MASK 0xF
#define PMIC_LDO_VSRAM_DIG_MAJOR_REV_SHIFT 12
#define PMIC_LDO_VSRAM_SW_MINOR_REV_ADDR MT6356_LDO_VSRAM_DSN_REV1
#define PMIC_LDO_VSRAM_SW_MINOR_REV_MASK 0xF
#define PMIC_LDO_VSRAM_SW_MINOR_REV_SHIFT 0
#define PMIC_LDO_VSRAM_SW_MAJOR_REV_ADDR MT6356_LDO_VSRAM_DSN_REV1
#define PMIC_LDO_VSRAM_SW_MAJOR_REV_MASK 0xF
#define PMIC_LDO_VSRAM_SW_MAJOR_REV_SHIFT 4
#define PMIC_LDO_VSRAM_ESP_ADDR MT6356_LDO_VSRAM_DSN_REV1
#define PMIC_LDO_VSRAM_ESP_MASK 0xFF
#define PMIC_LDO_VSRAM_ESP_SHIFT 8
#define PMIC_RG_DIG_VSRAM_RSV0_ADDR MT6356_LDO_VSRAM_RSV_CON0
#define PMIC_RG_DIG_VSRAM_RSV0_MASK 0xFFFF
#define PMIC_RG_DIG_VSRAM_RSV0_SHIFT 0
#define PMIC_RG_DIG_VSRAM_RSV1_ADDR MT6356_LDO_VSRAM_RSV_CON1
#define PMIC_RG_DIG_VSRAM_RSV1_MASK 0xFFFF
#define PMIC_RG_DIG_VSRAM_RSV1_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_EN_ADDR MT6356_LDO_VSRAM_PROC_CON0
#define PMIC_RG_LDO_VSRAM_PROC_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_EN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_LP_ADDR MT6356_LDO_VSRAM_PROC_CON0
#define PMIC_RG_LDO_VSRAM_PROC_LP_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_LP_SHIFT 1
#define PMIC_RG_LDO_VSRAM_PROC_VOSEL_SLEEP_ADDR MT6356_LDO_VSRAM_PROC_CON2
#define PMIC_RG_LDO_VSRAM_PROC_VOSEL_SLEEP_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_PROC_VOSEL_SLEEP_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_FRATE_ADDR MT6356_LDO_VSRAM_PROC_CFG0
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_FRATE_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_FRATE_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_FEN_ADDR MT6356_LDO_VSRAM_PROC_CFG0
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_FEN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_FEN_SHIFT 7
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_RRATE_ADDR MT6356_LDO_VSRAM_PROC_CFG0
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_RRATE_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_RRATE_SHIFT 8
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_REN_ADDR MT6356_LDO_VSRAM_PROC_CFG0
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_REN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_SFCHG_REN_SHIFT 15
#define PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_TD_ADDR MT6356_LDO_VSRAM_PROC_CFG1
#define PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_TD_MASK 0x3
#define PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_TD_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_CTRL_ADDR MT6356_LDO_VSRAM_PROC_CFG1
#define PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_CTRL_MASK 0x3
#define PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_CTRL_SHIFT 4
#define PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_ONCE_ADDR MT6356_LDO_VSRAM_PROC_CFG1
#define PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_ONCE_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_ONCE_SHIFT 6
#define PMIC_RG_LDO_VSRAM_PROC_SW_OP_EN_ADDR MT6356_LDO_VSRAM_PROC_OP_EN
#define PMIC_RG_LDO_VSRAM_PROC_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_HW0_OP_EN_ADDR MT6356_LDO_VSRAM_PROC_OP_EN
#define PMIC_RG_LDO_VSRAM_PROC_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VSRAM_PROC_HW1_OP_EN_ADDR MT6356_LDO_VSRAM_PROC_OP_EN
#define PMIC_RG_LDO_VSRAM_PROC_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VSRAM_PROC_HW2_OP_EN_ADDR MT6356_LDO_VSRAM_PROC_OP_EN
#define PMIC_RG_LDO_VSRAM_PROC_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VSRAM_PROC_OP_EN_SET_ADDR MT6356_LDO_VSRAM_PROC_OP_EN_SET
#define PMIC_RG_LDO_VSRAM_PROC_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_PROC_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_OP_EN_CLR_ADDR MT6356_LDO_VSRAM_PROC_OP_EN_CLR
#define PMIC_RG_LDO_VSRAM_PROC_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_PROC_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_HW0_OP_CFG_ADDR MT6356_LDO_VSRAM_PROC_OP_CFG
#define PMIC_RG_LDO_VSRAM_PROC_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VSRAM_PROC_HW1_OP_CFG_ADDR MT6356_LDO_VSRAM_PROC_OP_CFG
#define PMIC_RG_LDO_VSRAM_PROC_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VSRAM_PROC_HW2_OP_CFG_ADDR MT6356_LDO_VSRAM_PROC_OP_CFG
#define PMIC_RG_LDO_VSRAM_PROC_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VSRAM_PROC_ON_OP_ADDR MT6356_LDO_VSRAM_PROC_OP_CFG
#define PMIC_RG_LDO_VSRAM_PROC_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VSRAM_PROC_LP_OP_ADDR MT6356_LDO_VSRAM_PROC_OP_CFG
#define PMIC_RG_LDO_VSRAM_PROC_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VSRAM_PROC_OP_CFG_SET_ADDR MT6356_LDO_VSRAM_PROC_OP_CFG_SET
#define PMIC_RG_LDO_VSRAM_PROC_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_PROC_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_OP_CFG_CLR_ADDR MT6356_LDO_VSRAM_PROC_OP_CFG_CLR
#define PMIC_RG_LDO_VSRAM_PROC_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_PROC_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VSRAM_PROC_MODE_ADDR MT6356_LDO_VSRAM_PROC_CON3
#define PMIC_DA_VSRAM_PROC_MODE_MASK 0x1
#define PMIC_DA_VSRAM_PROC_MODE_SHIFT 8
#define PMIC_RG_LDO_VSRAM_PROC_STBTD_ADDR MT6356_LDO_VSRAM_PROC_CON3
#define PMIC_RG_LDO_VSRAM_PROC_STBTD_MASK 0x3
#define PMIC_RG_LDO_VSRAM_PROC_STBTD_SHIFT 9
#define PMIC_RG_LDO_VSRAM_PROC_OCFB_EN_ADDR MT6356_LDO_VSRAM_PROC_CON4
#define PMIC_RG_LDO_VSRAM_PROC_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_OCFB_EN_SHIFT 9
#define PMIC_DA_VSRAM_PROC_OCFB_EN_ADDR MT6356_LDO_VSRAM_PROC_CON4
#define PMIC_DA_VSRAM_PROC_OCFB_EN_MASK 0x1
#define PMIC_DA_VSRAM_PROC_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VSRAM_PROC_DUMMY_LOAD_ADDR MT6356_LDO_VSRAM_PROC_CON5
#define PMIC_RG_LDO_VSRAM_PROC_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VSRAM_PROC_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VSRAM_PROC_DUMMY_LOAD_ADDR MT6356_LDO_VSRAM_PROC_CON5
#define PMIC_DA_VSRAM_PROC_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VSRAM_PROC_DUMMY_LOAD_SHIFT 14
#define PMIC_DA_VSRAM_PROC_VOSEL_GRAY_ADDR MT6356_LDO_VSRAM_PROC_DBG0
#define PMIC_DA_VSRAM_PROC_VOSEL_GRAY_MASK 0x7F
#define PMIC_DA_VSRAM_PROC_VOSEL_GRAY_SHIFT 0
#define PMIC_DA_VSRAM_PROC_VOSEL_ADDR MT6356_LDO_VSRAM_PROC_DBG0
#define PMIC_DA_VSRAM_PROC_VOSEL_MASK 0x7F
#define PMIC_DA_VSRAM_PROC_VOSEL_SHIFT 8
#define PMIC_DA_VSRAM_PROC_EN_ADDR MT6356_LDO_VSRAM_PROC_DBG1
#define PMIC_DA_VSRAM_PROC_EN_MASK 0x1
#define PMIC_DA_VSRAM_PROC_EN_SHIFT 0
#define PMIC_DA_VSRAM_PROC_STB_ADDR MT6356_LDO_VSRAM_PROC_DBG1
#define PMIC_DA_VSRAM_PROC_STB_MASK 0x1
#define PMIC_DA_VSRAM_PROC_STB_SHIFT 1
#define PMIC_DA_VSRAM_PROC_VSLEEP_SEL_ADDR MT6356_LDO_VSRAM_PROC_DBG1
#define PMIC_DA_VSRAM_PROC_VSLEEP_SEL_MASK 0x1
#define PMIC_DA_VSRAM_PROC_VSLEEP_SEL_SHIFT 2
#define PMIC_DA_VSRAM_PROC_R2R_PDN_ADDR MT6356_LDO_VSRAM_PROC_DBG1
#define PMIC_DA_VSRAM_PROC_R2R_PDN_MASK 0x1
#define PMIC_DA_VSRAM_PROC_R2R_PDN_SHIFT 3
#define PMIC_DA_VSRAM_PROC_TRACK_NDIS_EN_ADDR MT6356_LDO_VSRAM_PROC_DBG1
#define PMIC_DA_VSRAM_PROC_TRACK_NDIS_EN_MASK 0x1
#define PMIC_DA_VSRAM_PROC_TRACK_NDIS_EN_SHIFT 4
#define PMIC_RG_LDO_VSRAM_OTHERS_EN_ADDR MT6356_LDO_VSRAM_OTHERS_CON0
#define PMIC_RG_LDO_VSRAM_OTHERS_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_EN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_LP_ADDR MT6356_LDO_VSRAM_OTHERS_CON0
#define PMIC_RG_LDO_VSRAM_OTHERS_LP_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_LP_SHIFT 1
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_SLEEP_ADDR MT6356_LDO_VSRAM_OTHERS_CON2
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_SLEEP_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_SLEEP_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FRATE_ADDR MT6356_LDO_VSRAM_OTHERS_CFG0
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FRATE_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FRATE_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FEN_ADDR MT6356_LDO_VSRAM_OTHERS_CFG0
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FEN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FEN_SHIFT 7
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_RRATE_ADDR MT6356_LDO_VSRAM_OTHERS_CFG0
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_RRATE_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_RRATE_SHIFT 8
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_REN_ADDR MT6356_LDO_VSRAM_OTHERS_CFG0
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_REN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_REN_SHIFT 15
#define PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_TD_ADDR MT6356_LDO_VSRAM_OTHERS_CFG1
#define PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_TD_MASK 0x3
#define PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_TD_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_CTRL_ADDR                          \
	MT6356_LDO_VSRAM_OTHERS_CFG1
#define PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_CTRL_MASK 0x3
#define PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_CTRL_SHIFT 4
#define PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_ONCE_ADDR                          \
	MT6356_LDO_VSRAM_OTHERS_CFG1
#define PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_ONCE_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_ONCE_SHIFT 6
#define PMIC_RG_LDO_VSRAM_OTHERS_SW_OP_EN_ADDR MT6356_LDO_VSRAM_OTHERS_OP_EN
#define PMIC_RG_LDO_VSRAM_OTHERS_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_EN_ADDR MT6356_LDO_VSRAM_OTHERS_OP_EN
#define PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_EN_ADDR MT6356_LDO_VSRAM_OTHERS_OP_EN
#define PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_EN_ADDR MT6356_LDO_VSRAM_OTHERS_OP_EN
#define PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_SET_ADDR                               \
	MT6356_LDO_VSRAM_OTHERS_OP_EN_SET
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_CLR_ADDR                               \
	MT6356_LDO_VSRAM_OTHERS_OP_EN_CLR
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_CFG_ADDR MT6356_LDO_VSRAM_OTHERS_OP_CFG
#define PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_CFG_ADDR MT6356_LDO_VSRAM_OTHERS_OP_CFG
#define PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_CFG_ADDR MT6356_LDO_VSRAM_OTHERS_OP_CFG
#define PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VSRAM_OTHERS_ON_OP_ADDR MT6356_LDO_VSRAM_OTHERS_OP_CFG
#define PMIC_RG_LDO_VSRAM_OTHERS_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VSRAM_OTHERS_LP_OP_ADDR MT6356_LDO_VSRAM_OTHERS_OP_CFG
#define PMIC_RG_LDO_VSRAM_OTHERS_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_SET_ADDR                              \
	MT6356_LDO_VSRAM_OTHERS_OP_CFG_SET
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_CLR_ADDR                              \
	MT6356_LDO_VSRAM_OTHERS_OP_CFG_CLR
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VSRAM_OTHERS_MODE_ADDR MT6356_LDO_VSRAM_OTHERS_CON3
#define PMIC_DA_VSRAM_OTHERS_MODE_MASK 0x1
#define PMIC_DA_VSRAM_OTHERS_MODE_SHIFT 8
#define PMIC_RG_LDO_VSRAM_OTHERS_STBTD_ADDR MT6356_LDO_VSRAM_OTHERS_CON3
#define PMIC_RG_LDO_VSRAM_OTHERS_STBTD_MASK 0x3
#define PMIC_RG_LDO_VSRAM_OTHERS_STBTD_SHIFT 9
#define PMIC_RG_LDO_VSRAM_OTHERS_OCFB_EN_ADDR MT6356_LDO_VSRAM_OTHERS_CON4
#define PMIC_RG_LDO_VSRAM_OTHERS_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_OCFB_EN_SHIFT 9
#define PMIC_DA_VSRAM_OTHERS_OCFB_EN_ADDR MT6356_LDO_VSRAM_OTHERS_CON4
#define PMIC_DA_VSRAM_OTHERS_OCFB_EN_MASK 0x1
#define PMIC_DA_VSRAM_OTHERS_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VSRAM_OTHERS_DUMMY_LOAD_ADDR MT6356_LDO_VSRAM_OTHERS_CON5
#define PMIC_RG_LDO_VSRAM_OTHERS_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VSRAM_OTHERS_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VSRAM_OTHERS_DUMMY_LOAD_ADDR MT6356_LDO_VSRAM_OTHERS_CON5
#define PMIC_DA_VSRAM_OTHERS_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VSRAM_OTHERS_DUMMY_LOAD_SHIFT 14
#define PMIC_DA_VSRAM_OTHERS_VOSEL_GRAY_ADDR MT6356_LDO_VSRAM_OTHERS_DBG0
#define PMIC_DA_VSRAM_OTHERS_VOSEL_GRAY_MASK 0x7F
#define PMIC_DA_VSRAM_OTHERS_VOSEL_GRAY_SHIFT 0
#define PMIC_DA_VSRAM_OTHERS_VOSEL_ADDR MT6356_LDO_VSRAM_OTHERS_DBG0
#define PMIC_DA_VSRAM_OTHERS_VOSEL_MASK 0x7F
#define PMIC_DA_VSRAM_OTHERS_VOSEL_SHIFT 8
#define PMIC_DA_VSRAM_OTHERS_EN_ADDR MT6356_LDO_VSRAM_OTHERS_DBG1
#define PMIC_DA_VSRAM_OTHERS_EN_MASK 0x1
#define PMIC_DA_VSRAM_OTHERS_EN_SHIFT 0
#define PMIC_DA_VSRAM_OTHERS_STB_ADDR MT6356_LDO_VSRAM_OTHERS_DBG1
#define PMIC_DA_VSRAM_OTHERS_STB_MASK 0x1
#define PMIC_DA_VSRAM_OTHERS_STB_SHIFT 1
#define PMIC_DA_VSRAM_OTHERS_VSLEEP_SEL_ADDR MT6356_LDO_VSRAM_OTHERS_DBG1
#define PMIC_DA_VSRAM_OTHERS_VSLEEP_SEL_MASK 0x1
#define PMIC_DA_VSRAM_OTHERS_VSLEEP_SEL_SHIFT 2
#define PMIC_DA_VSRAM_OTHERS_R2R_PDN_ADDR MT6356_LDO_VSRAM_OTHERS_DBG1
#define PMIC_DA_VSRAM_OTHERS_R2R_PDN_MASK 0x1
#define PMIC_DA_VSRAM_OTHERS_R2R_PDN_SHIFT 3
#define PMIC_DA_VSRAM_OTHERS_TRACK_NDIS_EN_ADDR MT6356_LDO_VSRAM_OTHERS_DBG1
#define PMIC_DA_VSRAM_OTHERS_TRACK_NDIS_EN_MASK 0x1
#define PMIC_DA_VSRAM_OTHERS_TRACK_NDIS_EN_SHIFT 4
#define PMIC_RG_LDO_VSRAM_GPU_EN_ADDR MT6356_LDO_VSRAM_GPU_CON0
#define PMIC_RG_LDO_VSRAM_GPU_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_EN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_LP_ADDR MT6356_LDO_VSRAM_GPU_CON0
#define PMIC_RG_LDO_VSRAM_GPU_LP_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_LP_SHIFT 1
#define PMIC_RG_LDO_VSRAM_GPU_VOSEL_SLEEP_ADDR MT6356_LDO_VSRAM_GPU_CON2
#define PMIC_RG_LDO_VSRAM_GPU_VOSEL_SLEEP_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_GPU_VOSEL_SLEEP_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_FRATE_ADDR MT6356_LDO_VSRAM_GPU_CFG0
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_FRATE_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_FRATE_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_FEN_ADDR MT6356_LDO_VSRAM_GPU_CFG0
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_FEN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_FEN_SHIFT 7
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_RRATE_ADDR MT6356_LDO_VSRAM_GPU_CFG0
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_RRATE_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_RRATE_SHIFT 8
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_REN_ADDR MT6356_LDO_VSRAM_GPU_CFG0
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_REN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_SFCHG_REN_SHIFT 15
#define PMIC_RG_LDO_VSRAM_GPU_DVS_TRANS_TD_ADDR MT6356_LDO_VSRAM_GPU_CFG1
#define PMIC_RG_LDO_VSRAM_GPU_DVS_TRANS_TD_MASK 0x3
#define PMIC_RG_LDO_VSRAM_GPU_DVS_TRANS_TD_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_DVS_TRANS_CTRL_ADDR MT6356_LDO_VSRAM_GPU_CFG1
#define PMIC_RG_LDO_VSRAM_GPU_DVS_TRANS_CTRL_MASK 0x3
#define PMIC_RG_LDO_VSRAM_GPU_DVS_TRANS_CTRL_SHIFT 4
#define PMIC_RG_LDO_VSRAM_GPU_DVS_TRANS_ONCE_ADDR MT6356_LDO_VSRAM_GPU_CFG1
#define PMIC_RG_LDO_VSRAM_GPU_DVS_TRANS_ONCE_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_DVS_TRANS_ONCE_SHIFT 6
#define PMIC_RG_LDO_VSRAM_GPU_SW_OP_EN_ADDR MT6356_LDO_VSRAM_GPU_OP_EN
#define PMIC_RG_LDO_VSRAM_GPU_SW_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_SW_OP_EN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_HW0_OP_EN_ADDR MT6356_LDO_VSRAM_GPU_OP_EN
#define PMIC_RG_LDO_VSRAM_GPU_HW0_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_HW0_OP_EN_SHIFT 1
#define PMIC_RG_LDO_VSRAM_GPU_HW1_OP_EN_ADDR MT6356_LDO_VSRAM_GPU_OP_EN
#define PMIC_RG_LDO_VSRAM_GPU_HW1_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_HW1_OP_EN_SHIFT 2
#define PMIC_RG_LDO_VSRAM_GPU_HW2_OP_EN_ADDR MT6356_LDO_VSRAM_GPU_OP_EN
#define PMIC_RG_LDO_VSRAM_GPU_HW2_OP_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_HW2_OP_EN_SHIFT 3
#define PMIC_RG_LDO_VSRAM_GPU_OP_EN_SET_ADDR MT6356_LDO_VSRAM_GPU_OP_EN_SET
#define PMIC_RG_LDO_VSRAM_GPU_OP_EN_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_GPU_OP_EN_SET_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_OP_EN_CLR_ADDR MT6356_LDO_VSRAM_GPU_OP_EN_CLR
#define PMIC_RG_LDO_VSRAM_GPU_OP_EN_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_GPU_OP_EN_CLR_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_HW0_OP_CFG_ADDR MT6356_LDO_VSRAM_GPU_OP_CFG
#define PMIC_RG_LDO_VSRAM_GPU_HW0_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_HW0_OP_CFG_SHIFT 1
#define PMIC_RG_LDO_VSRAM_GPU_HW1_OP_CFG_ADDR MT6356_LDO_VSRAM_GPU_OP_CFG
#define PMIC_RG_LDO_VSRAM_GPU_HW1_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_HW1_OP_CFG_SHIFT 2
#define PMIC_RG_LDO_VSRAM_GPU_HW2_OP_CFG_ADDR MT6356_LDO_VSRAM_GPU_OP_CFG
#define PMIC_RG_LDO_VSRAM_GPU_HW2_OP_CFG_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_HW2_OP_CFG_SHIFT 3
#define PMIC_RG_LDO_VSRAM_GPU_ON_OP_ADDR MT6356_LDO_VSRAM_GPU_OP_CFG
#define PMIC_RG_LDO_VSRAM_GPU_ON_OP_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_ON_OP_SHIFT 8
#define PMIC_RG_LDO_VSRAM_GPU_LP_OP_ADDR MT6356_LDO_VSRAM_GPU_OP_CFG
#define PMIC_RG_LDO_VSRAM_GPU_LP_OP_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_LP_OP_SHIFT 9
#define PMIC_RG_LDO_VSRAM_GPU_OP_CFG_SET_ADDR MT6356_LDO_VSRAM_GPU_OP_CFG_SET
#define PMIC_RG_LDO_VSRAM_GPU_OP_CFG_SET_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_GPU_OP_CFG_SET_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_OP_CFG_CLR_ADDR MT6356_LDO_VSRAM_GPU_OP_CFG_CLR
#define PMIC_RG_LDO_VSRAM_GPU_OP_CFG_CLR_MASK 0xFFFF
#define PMIC_RG_LDO_VSRAM_GPU_OP_CFG_CLR_SHIFT 0
#define PMIC_DA_VSRAM_GPU_MODE_ADDR MT6356_LDO_VSRAM_GPU_CON3
#define PMIC_DA_VSRAM_GPU_MODE_MASK 0x1
#define PMIC_DA_VSRAM_GPU_MODE_SHIFT 8
#define PMIC_RG_LDO_VSRAM_GPU_STBTD_ADDR MT6356_LDO_VSRAM_GPU_CON3
#define PMIC_RG_LDO_VSRAM_GPU_STBTD_MASK 0x3
#define PMIC_RG_LDO_VSRAM_GPU_STBTD_SHIFT 9
#define PMIC_RG_LDO_VSRAM_GPU_OCFB_EN_ADDR MT6356_LDO_VSRAM_GPU_CON4
#define PMIC_RG_LDO_VSRAM_GPU_OCFB_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_OCFB_EN_SHIFT 9
#define PMIC_DA_VSRAM_GPU_OCFB_EN_ADDR MT6356_LDO_VSRAM_GPU_CON4
#define PMIC_DA_VSRAM_GPU_OCFB_EN_MASK 0x1
#define PMIC_DA_VSRAM_GPU_OCFB_EN_SHIFT 10
#define PMIC_RG_LDO_VSRAM_GPU_DUMMY_LOAD_ADDR MT6356_LDO_VSRAM_GPU_CON5
#define PMIC_RG_LDO_VSRAM_GPU_DUMMY_LOAD_MASK 0x3
#define PMIC_RG_LDO_VSRAM_GPU_DUMMY_LOAD_SHIFT 5
#define PMIC_DA_VSRAM_GPU_DUMMY_LOAD_ADDR MT6356_LDO_VSRAM_GPU_CON5
#define PMIC_DA_VSRAM_GPU_DUMMY_LOAD_MASK 0x3
#define PMIC_DA_VSRAM_GPU_DUMMY_LOAD_SHIFT 14
#define PMIC_DA_VSRAM_GPU_VOSEL_GRAY_ADDR MT6356_LDO_VSRAM_GPU_DBG0
#define PMIC_DA_VSRAM_GPU_VOSEL_GRAY_MASK 0x7F
#define PMIC_DA_VSRAM_GPU_VOSEL_GRAY_SHIFT 0
#define PMIC_DA_VSRAM_GPU_VOSEL_ADDR MT6356_LDO_VSRAM_GPU_DBG0
#define PMIC_DA_VSRAM_GPU_VOSEL_MASK 0x7F
#define PMIC_DA_VSRAM_GPU_VOSEL_SHIFT 8
#define PMIC_DA_VSRAM_GPU_EN_ADDR MT6356_LDO_VSRAM_GPU_DBG1
#define PMIC_DA_VSRAM_GPU_EN_MASK 0x1
#define PMIC_DA_VSRAM_GPU_EN_SHIFT 0
#define PMIC_DA_VSRAM_GPU_STB_ADDR MT6356_LDO_VSRAM_GPU_DBG1
#define PMIC_DA_VSRAM_GPU_STB_MASK 0x1
#define PMIC_DA_VSRAM_GPU_STB_SHIFT 1
#define PMIC_DA_VSRAM_GPU_VSLEEP_SEL_ADDR MT6356_LDO_VSRAM_GPU_DBG1
#define PMIC_DA_VSRAM_GPU_VSLEEP_SEL_MASK 0x1
#define PMIC_DA_VSRAM_GPU_VSLEEP_SEL_SHIFT 2
#define PMIC_DA_VSRAM_GPU_R2R_PDN_ADDR MT6356_LDO_VSRAM_GPU_DBG1
#define PMIC_DA_VSRAM_GPU_R2R_PDN_MASK 0x1
#define PMIC_DA_VSRAM_GPU_R2R_PDN_SHIFT 3
#define PMIC_DA_VSRAM_GPU_TRACK_NDIS_EN_ADDR MT6356_LDO_VSRAM_GPU_DBG1
#define PMIC_DA_VSRAM_GPU_TRACK_NDIS_EN_MASK 0x1
#define PMIC_DA_VSRAM_GPU_TRACK_NDIS_EN_SHIFT 4
#define PMIC_RG_LDO_VSRAM_PROC_SP_SW_VOSEL_EN_ADDR MT6356_LDO_VSRAM_PROC_SP
#define PMIC_RG_LDO_VSRAM_PROC_SP_SW_VOSEL_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_SP_SW_VOSEL_EN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_SP_SW_VOSEL_ADDR MT6356_LDO_VSRAM_PROC_SP
#define PMIC_RG_LDO_VSRAM_PROC_SP_SW_VOSEL_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_PROC_SP_SW_VOSEL_SHIFT 1
#define PMIC_RG_LDO_VSRAM_GPU_SP_SW_VOSEL_EN_ADDR MT6356_LDO_VSRAM_GPU_SP
#define PMIC_RG_LDO_VSRAM_GPU_SP_SW_VOSEL_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_SP_SW_VOSEL_EN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_SP_SW_VOSEL_ADDR MT6356_LDO_VSRAM_GPU_SP
#define PMIC_RG_LDO_VSRAM_GPU_SP_SW_VOSEL_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_GPU_SP_SW_VOSEL_SHIFT 1
#define PMIC_RG_LDO_VSRAM_OTHERS_SP_SW_VOSEL_EN_ADDR MT6356_LDO_VSRAM_OTHERS_SP
#define PMIC_RG_LDO_VSRAM_OTHERS_SP_SW_VOSEL_EN_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_SP_SW_VOSEL_EN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_SP_SW_VOSEL_ADDR MT6356_LDO_VSRAM_OTHERS_SP
#define PMIC_RG_LDO_VSRAM_OTHERS_SP_SW_VOSEL_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_OTHERS_SP_SW_VOSEL_SHIFT 1
#define PMIC_RG_LDO_VSRAM_CORE_SSHUB_ON_ADDR MT6356_LDO_VSRAM_CORE_SSHUB
#define PMIC_RG_LDO_VSRAM_CORE_SSHUB_ON_MASK 0x1
#define PMIC_RG_LDO_VSRAM_CORE_SSHUB_ON_SHIFT 0
#define PMIC_RG_LDO_VSRAM_CORE_SSHUB_MODE_ADDR MT6356_LDO_VSRAM_CORE_SSHUB
#define PMIC_RG_LDO_VSRAM_CORE_SSHUB_MODE_MASK 0x1
#define PMIC_RG_LDO_VSRAM_CORE_SSHUB_MODE_SHIFT 1
#define PMIC_RG_LDO_VSRAM_CORE_SSHUB_VOSEL_ADDR MT6356_LDO_VSRAM_CORE_SSHUB
#define PMIC_RG_LDO_VSRAM_CORE_SSHUB_VOSEL_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_CORE_SSHUB_VOSEL_SHIFT 2
#define PMIC_RG_LDO_VSRAM_PROC_R2R_PDN_DIS_ADDR                               \
	MT6356_LDO_VSRAM_PROC_R2R_PDN_DIS
#define PMIC_RG_LDO_VSRAM_PROC_R2R_PDN_DIS_MASK 0x1
#define PMIC_RG_LDO_VSRAM_PROC_R2R_PDN_DIS_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_R2R_PDN_DIS_ADDR                             \
	MT6356_LDO_VSRAM_OTHERS_R2R_PDN_DIS
#define PMIC_RG_LDO_VSRAM_OTHERS_R2R_PDN_DIS_MASK 0x1
#define PMIC_RG_LDO_VSRAM_OTHERS_R2R_PDN_DIS_SHIFT 0
#define PMIC_RG_LDO_VSRAM_GPU_R2R_PDN_DIS_ADDR MT6356_LDO_VSRAM_GPU_R2R_PDN_DIS
#define PMIC_RG_LDO_VSRAM_GPU_R2R_PDN_DIS_MASK 0x1
#define PMIC_RG_LDO_VSRAM_GPU_R2R_PDN_DIS_SHIFT 0
#define PMIC_RG_LDO_VSRAM_CORE_TRACK_SLEEP_CTRL_ADDR MT6356_LDO_TRACKING_CON0
#define PMIC_RG_LDO_VSRAM_CORE_TRACK_SLEEP_CTRL_MASK 0x1
#define PMIC_RG_LDO_VSRAM_CORE_TRACK_SLEEP_CTRL_SHIFT 0
#define PMIC_RG_LDO_VSRAM_CORE_TRACK_ON_CTRL_ADDR MT6356_LDO_TRACKING_CON0
#define PMIC_RG_LDO_VSRAM_CORE_TRACK_ON_CTRL_MASK 0x1
#define PMIC_RG_LDO_VSRAM_CORE_TRACK_ON_CTRL_SHIFT 1
#define PMIC_RG_LDO_VSRAM_CORE_TRACK_VBUCK_ON_CTRL_ADDR                       \
	MT6356_LDO_TRACKING_CON0
#define PMIC_RG_LDO_VSRAM_CORE_TRACK_VBUCK_ON_CTRL_MASK 0x1
#define PMIC_RG_LDO_VSRAM_CORE_TRACK_VBUCK_ON_CTRL_SHIFT 2
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_DELTA_ADDR MT6356_LDO_TRACKING_CON1
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_DELTA_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_DELTA_SHIFT 0
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_OFFSET_ADDR MT6356_LDO_TRACKING_CON1
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_OFFSET_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_OFFSET_SHIFT 8
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_ON_LB_ADDR MT6356_LDO_TRACKING_CON2
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_ON_LB_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_ON_LB_SHIFT 0
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_ON_HB_ADDR MT6356_LDO_TRACKING_CON2
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_ON_HB_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_ON_HB_SHIFT 8
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_SLEEP_LB_ADDR MT6356_LDO_TRACKING_CON3
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_SLEEP_LB_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_CORE_VOSEL_SLEEP_LB_SHIFT 0
#define PMIC_RG_LDO_STB_MAX_ADDR MT6356_LDO_VSRAM_STB_CON
#define PMIC_RG_LDO_STB_MAX_MASK 0x1FF
#define PMIC_RG_LDO_STB_MAX_SHIFT 0
#define PMIC_RG_LDO_VSLEEP_SRC0_ADDR MT6356_LDO_VSRAM_SLP_CON0
#define PMIC_RG_LDO_VSLEEP_SRC0_MASK 0x1FF
#define PMIC_RG_LDO_VSLEEP_SRC0_SHIFT 0
#define PMIC_RG_LDO_VSLEEP_SRC1_ADDR MT6356_LDO_VSRAM_SLP_CON0
#define PMIC_RG_LDO_VSLEEP_SRC1_MASK 0xF
#define PMIC_RG_LDO_VSLEEP_SRC1_SHIFT 12
#define PMIC_RG_LDO_R2R_SRC0_ADDR MT6356_LDO_VSRAM_SLP_CON1
#define PMIC_RG_LDO_R2R_SRC0_MASK 0x1FF
#define PMIC_RG_LDO_R2R_SRC0_SHIFT 0
#define PMIC_RG_LDO_R2R_SRC1_ADDR MT6356_LDO_VSRAM_SLP_CON1
#define PMIC_RG_LDO_R2R_SRC1_MASK 0xF
#define PMIC_RG_LDO_R2R_SRC1_SHIFT 12
#define PMIC_RG_LDO_LP_SEQ_COUNT_ADDR MT6356_LDO_VSRAM_SLP_CON2
#define PMIC_RG_LDO_LP_SEQ_COUNT_MASK 0x1FF
#define PMIC_RG_LDO_LP_SEQ_COUNT_SHIFT 0
#define PMIC_RG_LDO_ON_SEQ_COUNT_ADDR MT6356_LDO_VSRAM_SLP_CON2
#define PMIC_RG_LDO_ON_SEQ_COUNT_MASK 0xF
#define PMIC_RG_LDO_ON_SEQ_COUNT_SHIFT 12
#define PMIC_LDO_VSRAM_PROC_WDTDBG_VOSEL_ADDR MT6356_LDO_VSRAM_WDT_DBG0
#define PMIC_LDO_VSRAM_PROC_WDTDBG_VOSEL_MASK 0x7F
#define PMIC_LDO_VSRAM_PROC_WDTDBG_VOSEL_SHIFT 0
#define PMIC_LDO_VSRAM_GPU_WDTDBG_VOSEL_ADDR MT6356_LDO_VSRAM_WDT_DBG0
#define PMIC_LDO_VSRAM_GPU_WDTDBG_VOSEL_MASK 0x7F
#define PMIC_LDO_VSRAM_GPU_WDTDBG_VOSEL_SHIFT 8
#define PMIC_LDO_VSRAM_OTHERS_WDTDBG_VOSEL_ADDR MT6356_LDO_VSRAM_WDT_DBG1
#define PMIC_LDO_VSRAM_OTHERS_WDTDBG_VOSEL_MASK 0x7F
#define PMIC_LDO_VSRAM_OTHERS_WDTDBG_VOSEL_SHIFT 0
#define PMIC_LDO_VSRAM_ELR_LEN_ADDR MT6356_LDO_VSRAM_ELR_NUM
#define PMIC_LDO_VSRAM_ELR_LEN_MASK 0xFF
#define PMIC_LDO_VSRAM_ELR_LEN_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_VOSEL_ADDR MT6356_LDO_VSRAM_CON0
#define PMIC_RG_LDO_VSRAM_PROC_VOSEL_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_PROC_VOSEL_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_RO_ADDR MT6356_LDO_VSRAM_CON0
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_RO_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_RO_SHIFT 8
#define PMIC_RG_LDO_VSRAM_GPU_VOSEL_ADDR MT6356_LDO_VSRAM_CON1
#define PMIC_RG_LDO_VSRAM_GPU_VOSEL_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_GPU_VOSEL_SHIFT 0
#define PMIC_RG_LDO_VSRAM_PROC_VOSEL_LIMIT_SEL_ADDR MT6356_LDO_VSRAM_CON2
#define PMIC_RG_LDO_VSRAM_PROC_VOSEL_LIMIT_SEL_MASK 0x3
#define PMIC_RG_LDO_VSRAM_PROC_VOSEL_LIMIT_SEL_SHIFT 0
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_LIMIT_SEL_ADDR MT6356_LDO_VSRAM_CON2
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_LIMIT_SEL_MASK 0x3
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_LIMIT_SEL_SHIFT 4
#define PMIC_RG_LDO_VSRAM_GPU_VOSEL_LIMIT_SEL_ADDR MT6356_LDO_VSRAM_CON2
#define PMIC_RG_LDO_VSRAM_GPU_VOSEL_LIMIT_SEL_MASK 0x3
#define PMIC_RG_LDO_VSRAM_GPU_VOSEL_LIMIT_SEL_SHIFT 8
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_ADDR MT6356_LDO_VSRAM_CON3
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_MASK 0x7F
#define PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_SHIFT 8
#define PMIC_LDO_VRTC_ANA_ID_ADDR MT6356_LDO_VRTC_DSN_ID
#define PMIC_LDO_VRTC_ANA_ID_MASK 0xFF
#define PMIC_LDO_VRTC_ANA_ID_SHIFT 0
#define PMIC_LDO_VRTC_DIG_ID_ADDR MT6356_LDO_VRTC_DSN_ID
#define PMIC_LDO_VRTC_DIG_ID_MASK 0xFF
#define PMIC_LDO_VRTC_DIG_ID_SHIFT 8
#define PMIC_LDO_VRTC_ANA_MINOR_REV_ADDR MT6356_LDO_VRTC_DSN_REV0
#define PMIC_LDO_VRTC_ANA_MINOR_REV_MASK 0xF
#define PMIC_LDO_VRTC_ANA_MINOR_REV_SHIFT 0
#define PMIC_LDO_VRTC_ANA_MAJOR_REV_ADDR MT6356_LDO_VRTC_DSN_REV0
#define PMIC_LDO_VRTC_ANA_MAJOR_REV_MASK 0xF
#define PMIC_LDO_VRTC_ANA_MAJOR_REV_SHIFT 4
#define PMIC_LDO_VRTC_DIG_MINOR_REV_ADDR MT6356_LDO_VRTC_DSN_REV0
#define PMIC_LDO_VRTC_DIG_MINOR_REV_MASK 0xF
#define PMIC_LDO_VRTC_DIG_MINOR_REV_SHIFT 8
#define PMIC_LDO_VRTC_DIG_MAJOR_REV_ADDR MT6356_LDO_VRTC_DSN_REV0
#define PMIC_LDO_VRTC_DIG_MAJOR_REV_MASK 0xF
#define PMIC_LDO_VRTC_DIG_MAJOR_REV_SHIFT 12
#define PMIC_LDO_VRTC_SW_MINOR_REV_ADDR MT6356_LDO_VRTC_DSN_REV1
#define PMIC_LDO_VRTC_SW_MINOR_REV_MASK 0xF
#define PMIC_LDO_VRTC_SW_MINOR_REV_SHIFT 0
#define PMIC_LDO_VRTC_SW_MAJOR_REV_ADDR MT6356_LDO_VRTC_DSN_REV1
#define PMIC_LDO_VRTC_SW_MAJOR_REV_MASK 0xF
#define PMIC_LDO_VRTC_SW_MAJOR_REV_SHIFT 4
#define PMIC_LDO_VRTC_ESP_ADDR MT6356_LDO_VRTC_DSN_REV1
#define PMIC_LDO_VRTC_ESP_MASK 0xFF
#define PMIC_LDO_VRTC_ESP_SHIFT 8
#define PMIC_RG_LDO_VRTC_RSV0_ADDR MT6356_LDO_VRTC_RSV_CON0
#define PMIC_RG_LDO_VRTC_RSV0_MASK 0xFFFF
#define PMIC_RG_LDO_VRTC_RSV0_SHIFT 0
#define PMIC_RG_LDO_VRTC_RSV1_ADDR MT6356_LDO_VRTC_RSV_CON1
#define PMIC_RG_LDO_VRTC_RSV1_MASK 0xFFFF
#define PMIC_RG_LDO_VRTC_RSV1_SHIFT 0
#define PMIC_RG_VRTC_EN_ADDR MT6356_VRTC_CON0
#define PMIC_RG_VRTC_EN_MASK 0x1
#define PMIC_RG_VRTC_EN_SHIFT 1
#define PMIC_DA_VRTC_EN_ADDR MT6356_VRTC_CON0
#define PMIC_DA_VRTC_EN_MASK 0x1
#define PMIC_DA_VRTC_EN_SHIFT 15
#define PMIC_LDO_ANA_ANA_ID_ADDR MT6356_LDO_ANA_DSN_ID
#define PMIC_LDO_ANA_ANA_ID_MASK 0xFF
#define PMIC_LDO_ANA_ANA_ID_SHIFT 0
#define PMIC_LDO_ANA_DIG_ID_ADDR MT6356_LDO_ANA_DSN_ID
#define PMIC_LDO_ANA_DIG_ID_MASK 0xFF
#define PMIC_LDO_ANA_DIG_ID_SHIFT 8
#define PMIC_LDO_ANA_ANA_MINOR_REV_ADDR MT6356_LDO_ANA_DSN_REV0
#define PMIC_LDO_ANA_ANA_MINOR_REV_MASK 0xF
#define PMIC_LDO_ANA_ANA_MINOR_REV_SHIFT 0
#define PMIC_LDO_ANA_ANA_MAJOR_REV_ADDR MT6356_LDO_ANA_DSN_REV0
#define PMIC_LDO_ANA_ANA_MAJOR_REV_MASK 0xF
#define PMIC_LDO_ANA_ANA_MAJOR_REV_SHIFT 4
#define PMIC_LDO_ANA_DIG_MINOR_REV_ADDR MT6356_LDO_ANA_DSN_REV0
#define PMIC_LDO_ANA_DIG_MINOR_REV_MASK 0xF
#define PMIC_LDO_ANA_DIG_MINOR_REV_SHIFT 8
#define PMIC_LDO_ANA_DIG_MAJOR_REV_ADDR MT6356_LDO_ANA_DSN_REV0
#define PMIC_LDO_ANA_DIG_MAJOR_REV_MASK 0xF
#define PMIC_LDO_ANA_DIG_MAJOR_REV_SHIFT 12
#define PMIC_LDO_ANA_SW_MINOR_REV_ADDR MT6356_LDO_ANA_DSN_REV1
#define PMIC_LDO_ANA_SW_MINOR_REV_MASK 0xF
#define PMIC_LDO_ANA_SW_MINOR_REV_SHIFT 0
#define PMIC_LDO_ANA_SW_MAJOR_REV_ADDR MT6356_LDO_ANA_DSN_REV1
#define PMIC_LDO_ANA_SW_MAJOR_REV_MASK 0xF
#define PMIC_LDO_ANA_SW_MAJOR_REV_SHIFT 4
#define PMIC_LDO_ANA_ESP_ADDR MT6356_LDO_ANA_DSN_REV1
#define PMIC_LDO_ANA_ESP_MASK 0xFF
#define PMIC_LDO_ANA_ESP_SHIFT 8
#define PMIC_RG_VCAMA_VOCAL_ADDR MT6356_VCAMA_ANA_CON0
#define PMIC_RG_VCAMA_VOCAL_MASK 0xF
#define PMIC_RG_VCAMA_VOCAL_SHIFT 0
#define PMIC_RG_VCAMA_VOSEL_ADDR MT6356_VCAMA_ANA_CON0
#define PMIC_RG_VCAMA_VOSEL_MASK 0xF
#define PMIC_RG_VCAMA_VOSEL_SHIFT 8
#define PMIC_RGS_VCAMA_CAL_INDI_ADDR MT6356_VCAMA_ANA_CON1
#define PMIC_RGS_VCAMA_CAL_INDI_MASK 0x1
#define PMIC_RGS_VCAMA_CAL_INDI_SHIFT 4
#define PMIC_RG_VCAMA_NDIS_EN_ADDR MT6356_VCAMA_ANA_CON1
#define PMIC_RG_VCAMA_NDIS_EN_MASK 0x1
#define PMIC_RG_VCAMA_NDIS_EN_SHIFT 11
#define PMIC_RG_VCAMA_STB_SEL_ADDR MT6356_VCAMA_ANA_CON1
#define PMIC_RG_VCAMA_STB_SEL_MASK 0x1
#define PMIC_RG_VCAMA_STB_SEL_SHIFT 12
#define PMIC_RG_VCAMA_RSV_ADDR MT6356_VCAMA_ANA_CON1
#define PMIC_RG_VCAMA_RSV_MASK 0x3
#define PMIC_RG_VCAMA_RSV_SHIFT 13
#define PMIC_RG_VCAMA_VOS_CAL_EN_ADDR MT6356_VCAMA_ANA_CON1
#define PMIC_RG_VCAMA_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VCAMA_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VFE28_VOCAL_ADDR MT6356_VFE28_ANA_CON0
#define PMIC_RG_VFE28_VOCAL_MASK 0xF
#define PMIC_RG_VFE28_VOCAL_SHIFT 0
#define PMIC_RG_VFE28_VOSEL_ADDR MT6356_VFE28_ANA_CON0
#define PMIC_RG_VFE28_VOSEL_MASK 0xF
#define PMIC_RG_VFE28_VOSEL_SHIFT 8
#define PMIC_RGS_VFE28_CAL_INDI_ADDR MT6356_VFE28_ANA_CON1
#define PMIC_RGS_VFE28_CAL_INDI_MASK 0x1
#define PMIC_RGS_VFE28_CAL_INDI_SHIFT 4
#define PMIC_RG_VFE28_NDIS_EN_ADDR MT6356_VFE28_ANA_CON1
#define PMIC_RG_VFE28_NDIS_EN_MASK 0x1
#define PMIC_RG_VFE28_NDIS_EN_SHIFT 11
#define PMIC_RG_VFE28_STB_SEL_ADDR MT6356_VFE28_ANA_CON1
#define PMIC_RG_VFE28_STB_SEL_MASK 0x1
#define PMIC_RG_VFE28_STB_SEL_SHIFT 12
#define PMIC_RG_VFE28_RSV_ADDR MT6356_VFE28_ANA_CON1
#define PMIC_RG_VFE28_RSV_MASK 0x3
#define PMIC_RG_VFE28_RSV_SHIFT 13
#define PMIC_RG_VFE28_VOS_CAL_EN_ADDR MT6356_VFE28_ANA_CON1
#define PMIC_RG_VFE28_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VFE28_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VCN28_VOCAL_ADDR MT6356_VCN28_ANA_CON0
#define PMIC_RG_VCN28_VOCAL_MASK 0xF
#define PMIC_RG_VCN28_VOCAL_SHIFT 0
#define PMIC_RG_VCN28_VOSEL_ADDR MT6356_VCN28_ANA_CON0
#define PMIC_RG_VCN28_VOSEL_MASK 0xF
#define PMIC_RG_VCN28_VOSEL_SHIFT 8
#define PMIC_RGS_VCN28_CAL_INDI_ADDR MT6356_VCN28_ANA_CON1
#define PMIC_RGS_VCN28_CAL_INDI_MASK 0x1
#define PMIC_RGS_VCN28_CAL_INDI_SHIFT 4
#define PMIC_RG_VCN28_NDIS_EN_ADDR MT6356_VCN28_ANA_CON1
#define PMIC_RG_VCN28_NDIS_EN_MASK 0x1
#define PMIC_RG_VCN28_NDIS_EN_SHIFT 11
#define PMIC_RG_VCN28_STB_SEL_ADDR MT6356_VCN28_ANA_CON1
#define PMIC_RG_VCN28_STB_SEL_MASK 0x1
#define PMIC_RG_VCN28_STB_SEL_SHIFT 12
#define PMIC_RG_VCN28_RSV_ADDR MT6356_VCN28_ANA_CON1
#define PMIC_RG_VCN28_RSV_MASK 0x3
#define PMIC_RG_VCN28_RSV_SHIFT 13
#define PMIC_RG_VCN28_VOS_CAL_EN_ADDR MT6356_VCN28_ANA_CON1
#define PMIC_RG_VCN28_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VCN28_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VBIF28_VOCAL_ADDR MT6356_VBIF28_ANA_CON0
#define PMIC_RG_VBIF28_VOCAL_MASK 0xF
#define PMIC_RG_VBIF28_VOCAL_SHIFT 0
#define PMIC_RG_VBIF28_VOSEL_ADDR MT6356_VBIF28_ANA_CON0
#define PMIC_RG_VBIF28_VOSEL_MASK 0xF
#define PMIC_RG_VBIF28_VOSEL_SHIFT 8
#define PMIC_RGS_VBIF28_CAL_INDI_ADDR MT6356_VBIF28_ANA_CON1
#define PMIC_RGS_VBIF28_CAL_INDI_MASK 0x1
#define PMIC_RGS_VBIF28_CAL_INDI_SHIFT 4
#define PMIC_RG_VBIF28_NDIS_EN_ADDR MT6356_VBIF28_ANA_CON1
#define PMIC_RG_VBIF28_NDIS_EN_MASK 0x1
#define PMIC_RG_VBIF28_NDIS_EN_SHIFT 11
#define PMIC_RG_VBIF28_STB_SEL_ADDR MT6356_VBIF28_ANA_CON1
#define PMIC_RG_VBIF28_STB_SEL_MASK 0x1
#define PMIC_RG_VBIF28_STB_SEL_SHIFT 12
#define PMIC_RG_VBIF28_RSV_ADDR MT6356_VBIF28_ANA_CON1
#define PMIC_RG_VBIF28_RSV_MASK 0x3
#define PMIC_RG_VBIF28_RSV_SHIFT 13
#define PMIC_RG_VBIF28_VOS_CAL_EN_ADDR MT6356_VBIF28_ANA_CON1
#define PMIC_RG_VBIF28_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VBIF28_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VAUD28_VOCAL_ADDR MT6356_VAUD28_ANA_CON0
#define PMIC_RG_VAUD28_VOCAL_MASK 0xF
#define PMIC_RG_VAUD28_VOCAL_SHIFT 0
#define PMIC_RG_VAUD28_VOSEL_ADDR MT6356_VAUD28_ANA_CON0
#define PMIC_RG_VAUD28_VOSEL_MASK 0xF
#define PMIC_RG_VAUD28_VOSEL_SHIFT 8
#define PMIC_RGS_VAUD28_CAL_INDI_ADDR MT6356_VAUD28_ANA_CON1
#define PMIC_RGS_VAUD28_CAL_INDI_MASK 0x1
#define PMIC_RGS_VAUD28_CAL_INDI_SHIFT 4
#define PMIC_RG_VAUD28_NDIS_EN_ADDR MT6356_VAUD28_ANA_CON1
#define PMIC_RG_VAUD28_NDIS_EN_MASK 0x1
#define PMIC_RG_VAUD28_NDIS_EN_SHIFT 11
#define PMIC_RG_VAUD28_STB_SEL_ADDR MT6356_VAUD28_ANA_CON1
#define PMIC_RG_VAUD28_STB_SEL_MASK 0x1
#define PMIC_RG_VAUD28_STB_SEL_SHIFT 12
#define PMIC_RG_VAUD28_RSV_ADDR MT6356_VAUD28_ANA_CON1
#define PMIC_RG_VAUD28_RSV_MASK 0x3
#define PMIC_RG_VAUD28_RSV_SHIFT 13
#define PMIC_RG_VAUD28_VOS_CAL_EN_ADDR MT6356_VAUD28_ANA_CON1
#define PMIC_RG_VAUD28_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VAUD28_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VAUX18_VOCAL_ADDR MT6356_VAUX18_ANA_CON0
#define PMIC_RG_VAUX18_VOCAL_MASK 0xF
#define PMIC_RG_VAUX18_VOCAL_SHIFT 0
#define PMIC_RG_VAUX18_VOSEL_ADDR MT6356_VAUX18_ANA_CON0
#define PMIC_RG_VAUX18_VOSEL_MASK 0xF
#define PMIC_RG_VAUX18_VOSEL_SHIFT 8
#define PMIC_RGS_VAUX18_CAL_INDI_ADDR MT6356_VAUX18_ANA_CON1
#define PMIC_RGS_VAUX18_CAL_INDI_MASK 0x1
#define PMIC_RGS_VAUX18_CAL_INDI_SHIFT 4
#define PMIC_RG_VAUX18_NDIS_EN_ADDR MT6356_VAUX18_ANA_CON1
#define PMIC_RG_VAUX18_NDIS_EN_MASK 0x1
#define PMIC_RG_VAUX18_NDIS_EN_SHIFT 11
#define PMIC_RG_VAUX18_STB_SEL_ADDR MT6356_VAUX18_ANA_CON1
#define PMIC_RG_VAUX18_STB_SEL_MASK 0x1
#define PMIC_RG_VAUX18_STB_SEL_SHIFT 12
#define PMIC_RG_VAUX18_RSV_ADDR MT6356_VAUX18_ANA_CON1
#define PMIC_RG_VAUX18_RSV_MASK 0x3
#define PMIC_RG_VAUX18_RSV_SHIFT 13
#define PMIC_RG_VAUX18_VOS_CAL_EN_ADDR MT6356_VAUX18_ANA_CON1
#define PMIC_RG_VAUX18_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VAUX18_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VXO22_VOCAL_ADDR MT6356_VXO22_ANA_CON0
#define PMIC_RG_VXO22_VOCAL_MASK 0xF
#define PMIC_RG_VXO22_VOCAL_SHIFT 0
#define PMIC_RG_VXO22_VOSEL_ADDR MT6356_VXO22_ANA_CON0
#define PMIC_RG_VXO22_VOSEL_MASK 0xF
#define PMIC_RG_VXO22_VOSEL_SHIFT 8
#define PMIC_RGS_VXO22_CAL_INDI_ADDR MT6356_VXO22_ANA_CON1
#define PMIC_RGS_VXO22_CAL_INDI_MASK 0x1
#define PMIC_RGS_VXO22_CAL_INDI_SHIFT 4
#define PMIC_RG_VXO22_NDIS_EN_ADDR MT6356_VXO22_ANA_CON1
#define PMIC_RG_VXO22_NDIS_EN_MASK 0x1
#define PMIC_RG_VXO22_NDIS_EN_SHIFT 11
#define PMIC_RG_VXO22_STB_SEL_ADDR MT6356_VXO22_ANA_CON1
#define PMIC_RG_VXO22_STB_SEL_MASK 0x1
#define PMIC_RG_VXO22_STB_SEL_SHIFT 12
#define PMIC_RG_VXO22_RSV_ADDR MT6356_VXO22_ANA_CON1
#define PMIC_RG_VXO22_RSV_MASK 0x3
#define PMIC_RG_VXO22_RSV_SHIFT 13
#define PMIC_RG_VXO22_VOS_CAL_EN_ADDR MT6356_VXO22_ANA_CON1
#define PMIC_RG_VXO22_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VXO22_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VCN33_VOCAL_ADDR MT6356_VCN33_ANA_CON0
#define PMIC_RG_VCN33_VOCAL_MASK 0xF
#define PMIC_RG_VCN33_VOCAL_SHIFT 0
#define PMIC_RG_VCN33_VOSEL_ADDR MT6356_VCN33_ANA_CON0
#define PMIC_RG_VCN33_VOSEL_MASK 0xF
#define PMIC_RG_VCN33_VOSEL_SHIFT 8
#define PMIC_RGS_VCN33_CAL_INDI_ADDR MT6356_VCN33_ANA_CON1
#define PMIC_RGS_VCN33_CAL_INDI_MASK 0x1
#define PMIC_RGS_VCN33_CAL_INDI_SHIFT 4
#define PMIC_RG_VCN33_NDIS_EN_ADDR MT6356_VCN33_ANA_CON1
#define PMIC_RG_VCN33_NDIS_EN_MASK 0x1
#define PMIC_RG_VCN33_NDIS_EN_SHIFT 11
#define PMIC_RG_VCN33_STB_SEL_ADDR MT6356_VCN33_ANA_CON1
#define PMIC_RG_VCN33_STB_SEL_MASK 0x1
#define PMIC_RG_VCN33_STB_SEL_SHIFT 12
#define PMIC_RG_VCN33_RSV_ADDR MT6356_VCN33_ANA_CON1
#define PMIC_RG_VCN33_RSV_MASK 0x3
#define PMIC_RG_VCN33_RSV_SHIFT 13
#define PMIC_RG_VCN33_VOS_CAL_EN_ADDR MT6356_VCN33_ANA_CON1
#define PMIC_RG_VCN33_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VCN33_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VUSB_VOCAL_ADDR MT6356_VUSB_ANA_CON0
#define PMIC_RG_VUSB_VOCAL_MASK 0xF
#define PMIC_RG_VUSB_VOCAL_SHIFT 0
#define PMIC_RG_VUSB_VOSEL_ADDR MT6356_VUSB_ANA_CON0
#define PMIC_RG_VUSB_VOSEL_MASK 0xF
#define PMIC_RG_VUSB_VOSEL_SHIFT 8
#define PMIC_RGS_VUSB_CAL_INDI_ADDR MT6356_VUSB_ANA_CON1
#define PMIC_RGS_VUSB_CAL_INDI_MASK 0x1
#define PMIC_RGS_VUSB_CAL_INDI_SHIFT 4
#define PMIC_RG_VUSB_NDIS_EN_ADDR MT6356_VUSB_ANA_CON1
#define PMIC_RG_VUSB_NDIS_EN_MASK 0x1
#define PMIC_RG_VUSB_NDIS_EN_SHIFT 11
#define PMIC_RG_VUSB_STB_SEL_ADDR MT6356_VUSB_ANA_CON1
#define PMIC_RG_VUSB_STB_SEL_MASK 0x1
#define PMIC_RG_VUSB_STB_SEL_SHIFT 12
#define PMIC_RG_VUSB_RSV_ADDR MT6356_VUSB_ANA_CON1
#define PMIC_RG_VUSB_RSV_MASK 0x3
#define PMIC_RG_VUSB_RSV_SHIFT 13
#define PMIC_RG_VUSB_VOS_CAL_EN_ADDR MT6356_VUSB_ANA_CON1
#define PMIC_RG_VUSB_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VUSB_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VEMC_VOCAL_ADDR MT6356_VEMC_ANA_CON0
#define PMIC_RG_VEMC_VOCAL_MASK 0xF
#define PMIC_RG_VEMC_VOCAL_SHIFT 0
#define PMIC_RG_VEMC_VOSEL_ADDR MT6356_VEMC_ANA_CON0
#define PMIC_RG_VEMC_VOSEL_MASK 0xF
#define PMIC_RG_VEMC_VOSEL_SHIFT 8
#define PMIC_RGS_VEMC_CAL_INDI_ADDR MT6356_VEMC_ANA_CON1
#define PMIC_RGS_VEMC_CAL_INDI_MASK 0x1
#define PMIC_RGS_VEMC_CAL_INDI_SHIFT 4
#define PMIC_RG_VEMC_NDIS_EN_ADDR MT6356_VEMC_ANA_CON1
#define PMIC_RG_VEMC_NDIS_EN_MASK 0x1
#define PMIC_RG_VEMC_NDIS_EN_SHIFT 11
#define PMIC_RG_VEMC_STB_SEL_ADDR MT6356_VEMC_ANA_CON1
#define PMIC_RG_VEMC_STB_SEL_MASK 0x1
#define PMIC_RG_VEMC_STB_SEL_SHIFT 12
#define PMIC_RG_VEMC_RSV_ADDR MT6356_VEMC_ANA_CON1
#define PMIC_RG_VEMC_RSV_MASK 0x3
#define PMIC_RG_VEMC_RSV_SHIFT 13
#define PMIC_RG_VEMC_VOS_CAL_EN_ADDR MT6356_VEMC_ANA_CON1
#define PMIC_RG_VEMC_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VEMC_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VLDO28_VOCAL_ADDR MT6356_VLDO28_ANA_CON0
#define PMIC_RG_VLDO28_VOCAL_MASK 0xF
#define PMIC_RG_VLDO28_VOCAL_SHIFT 0
#define PMIC_RG_VLDO28_VOSEL_ADDR MT6356_VLDO28_ANA_CON0
#define PMIC_RG_VLDO28_VOSEL_MASK 0xF
#define PMIC_RG_VLDO28_VOSEL_SHIFT 8
#define PMIC_RGS_VLDO28_CAL_INDI_ADDR MT6356_VLDO28_ANA_CON1
#define PMIC_RGS_VLDO28_CAL_INDI_MASK 0x1
#define PMIC_RGS_VLDO28_CAL_INDI_SHIFT 4
#define PMIC_RG_VLDO28_NDIS_EN_ADDR MT6356_VLDO28_ANA_CON1
#define PMIC_RG_VLDO28_NDIS_EN_MASK 0x1
#define PMIC_RG_VLDO28_NDIS_EN_SHIFT 11
#define PMIC_RG_VLDO28_STB_SEL_ADDR MT6356_VLDO28_ANA_CON1
#define PMIC_RG_VLDO28_STB_SEL_MASK 0x1
#define PMIC_RG_VLDO28_STB_SEL_SHIFT 12
#define PMIC_RG_VLDO28_RSV_ADDR MT6356_VLDO28_ANA_CON1
#define PMIC_RG_VLDO28_RSV_MASK 0x3
#define PMIC_RG_VLDO28_RSV_SHIFT 13
#define PMIC_RG_VLDO28_VOS_CAL_EN_ADDR MT6356_VLDO28_ANA_CON1
#define PMIC_RG_VLDO28_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VLDO28_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VIO28_VOCAL_ADDR MT6356_VIO28_ANA_CON0
#define PMIC_RG_VIO28_VOCAL_MASK 0xF
#define PMIC_RG_VIO28_VOCAL_SHIFT 0
#define PMIC_RG_VIO28_VOSEL_ADDR MT6356_VIO28_ANA_CON0
#define PMIC_RG_VIO28_VOSEL_MASK 0xF
#define PMIC_RG_VIO28_VOSEL_SHIFT 8
#define PMIC_RGS_VIO28_CAL_INDI_ADDR MT6356_VIO28_ANA_CON1
#define PMIC_RGS_VIO28_CAL_INDI_MASK 0x1
#define PMIC_RGS_VIO28_CAL_INDI_SHIFT 4
#define PMIC_RG_VIO28_NDIS_EN_ADDR MT6356_VIO28_ANA_CON1
#define PMIC_RG_VIO28_NDIS_EN_MASK 0x1
#define PMIC_RG_VIO28_NDIS_EN_SHIFT 11
#define PMIC_RG_VIO28_STB_SEL_ADDR MT6356_VIO28_ANA_CON1
#define PMIC_RG_VIO28_STB_SEL_MASK 0x1
#define PMIC_RG_VIO28_STB_SEL_SHIFT 12
#define PMIC_RG_VIO28_RSV_ADDR MT6356_VIO28_ANA_CON1
#define PMIC_RG_VIO28_RSV_MASK 0x3
#define PMIC_RG_VIO28_RSV_SHIFT 13
#define PMIC_RG_VIO28_VOS_CAL_EN_ADDR MT6356_VIO28_ANA_CON1
#define PMIC_RG_VIO28_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VIO28_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VIBR_VOCAL_ADDR MT6356_VIBR_ANA_CON0
#define PMIC_RG_VIBR_VOCAL_MASK 0xF
#define PMIC_RG_VIBR_VOCAL_SHIFT 0
#define PMIC_RG_VIBR_VOSEL_ADDR MT6356_VIBR_ANA_CON0
#define PMIC_RG_VIBR_VOSEL_MASK 0xF
#define PMIC_RG_VIBR_VOSEL_SHIFT 8
#define PMIC_RGS_VIBR_CAL_INDI_ADDR MT6356_VIBR_ANA_CON1
#define PMIC_RGS_VIBR_CAL_INDI_MASK 0x1
#define PMIC_RGS_VIBR_CAL_INDI_SHIFT 4
#define PMIC_RG_VIBR_NDIS_EN_ADDR MT6356_VIBR_ANA_CON1
#define PMIC_RG_VIBR_NDIS_EN_MASK 0x1
#define PMIC_RG_VIBR_NDIS_EN_SHIFT 11
#define PMIC_RG_VIBR_STB_SEL_ADDR MT6356_VIBR_ANA_CON1
#define PMIC_RG_VIBR_STB_SEL_MASK 0x1
#define PMIC_RG_VIBR_STB_SEL_SHIFT 12
#define PMIC_RG_VIBR_RSV_ADDR MT6356_VIBR_ANA_CON1
#define PMIC_RG_VIBR_RSV_MASK 0x3
#define PMIC_RG_VIBR_RSV_SHIFT 13
#define PMIC_RG_VIBR_VOS_CAL_EN_ADDR MT6356_VIBR_ANA_CON1
#define PMIC_RG_VIBR_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VIBR_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VSIM1_VOCAL_ADDR MT6356_VSIM1_ANA_CON0
#define PMIC_RG_VSIM1_VOCAL_MASK 0xF
#define PMIC_RG_VSIM1_VOCAL_SHIFT 0
#define PMIC_RG_VSIM1_VOSEL_ADDR MT6356_VSIM1_ANA_CON0
#define PMIC_RG_VSIM1_VOSEL_MASK 0xF
#define PMIC_RG_VSIM1_VOSEL_SHIFT 8
#define PMIC_RGS_VSIM1_CAL_INDI_ADDR MT6356_VSIM1_ANA_CON1
#define PMIC_RGS_VSIM1_CAL_INDI_MASK 0x1
#define PMIC_RGS_VSIM1_CAL_INDI_SHIFT 4
#define PMIC_RG_VSIM1_NDIS_EN_ADDR MT6356_VSIM1_ANA_CON1
#define PMIC_RG_VSIM1_NDIS_EN_MASK 0x1
#define PMIC_RG_VSIM1_NDIS_EN_SHIFT 11
#define PMIC_RG_VSIM1_STB_SEL_ADDR MT6356_VSIM1_ANA_CON1
#define PMIC_RG_VSIM1_STB_SEL_MASK 0x1
#define PMIC_RG_VSIM1_STB_SEL_SHIFT 12
#define PMIC_RG_VSIM1_RSV_ADDR MT6356_VSIM1_ANA_CON1
#define PMIC_RG_VSIM1_RSV_MASK 0x3
#define PMIC_RG_VSIM1_RSV_SHIFT 13
#define PMIC_RG_VSIM1_VOS_CAL_EN_ADDR MT6356_VSIM1_ANA_CON1
#define PMIC_RG_VSIM1_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VSIM1_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VSIM2_VOCAL_ADDR MT6356_VSIM2_ANA_CON0
#define PMIC_RG_VSIM2_VOCAL_MASK 0xF
#define PMIC_RG_VSIM2_VOCAL_SHIFT 0
#define PMIC_RG_VSIM2_VOSEL_ADDR MT6356_VSIM2_ANA_CON0
#define PMIC_RG_VSIM2_VOSEL_MASK 0xF
#define PMIC_RG_VSIM2_VOSEL_SHIFT 8
#define PMIC_RGS_VSIM2_CAL_INDI_ADDR MT6356_VSIM2_ANA_CON1
#define PMIC_RGS_VSIM2_CAL_INDI_MASK 0x1
#define PMIC_RGS_VSIM2_CAL_INDI_SHIFT 4
#define PMIC_RG_VSIM2_NDIS_EN_ADDR MT6356_VSIM2_ANA_CON1
#define PMIC_RG_VSIM2_NDIS_EN_MASK 0x1
#define PMIC_RG_VSIM2_NDIS_EN_SHIFT 11
#define PMIC_RG_VSIM2_STB_SEL_ADDR MT6356_VSIM2_ANA_CON1
#define PMIC_RG_VSIM2_STB_SEL_MASK 0x1
#define PMIC_RG_VSIM2_STB_SEL_SHIFT 12
#define PMIC_RG_VSIM2_RSV_ADDR MT6356_VSIM2_ANA_CON1
#define PMIC_RG_VSIM2_RSV_MASK 0x3
#define PMIC_RG_VSIM2_RSV_SHIFT 13
#define PMIC_RG_VSIM2_VOS_CAL_EN_ADDR MT6356_VSIM2_ANA_CON1
#define PMIC_RG_VSIM2_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VSIM2_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VMCH_VOCAL_ADDR MT6356_VMCH_ANA_CON0
#define PMIC_RG_VMCH_VOCAL_MASK 0xF
#define PMIC_RG_VMCH_VOCAL_SHIFT 0
#define PMIC_RG_VMCH_VOSEL_ADDR MT6356_VMCH_ANA_CON0
#define PMIC_RG_VMCH_VOSEL_MASK 0xF
#define PMIC_RG_VMCH_VOSEL_SHIFT 8
#define PMIC_RGS_VMCH_CAL_INDI_ADDR MT6356_VMCH_ANA_CON1
#define PMIC_RGS_VMCH_CAL_INDI_MASK 0x1
#define PMIC_RGS_VMCH_CAL_INDI_SHIFT 4
#define PMIC_RG_VMCH_NDIS_EN_ADDR MT6356_VMCH_ANA_CON1
#define PMIC_RG_VMCH_NDIS_EN_MASK 0x1
#define PMIC_RG_VMCH_NDIS_EN_SHIFT 11
#define PMIC_RG_VMCH_STB_SEL_ADDR MT6356_VMCH_ANA_CON1
#define PMIC_RG_VMCH_STB_SEL_MASK 0x1
#define PMIC_RG_VMCH_STB_SEL_SHIFT 12
#define PMIC_RG_VMCH_RSV_ADDR MT6356_VMCH_ANA_CON1
#define PMIC_RG_VMCH_RSV_MASK 0x3
#define PMIC_RG_VMCH_RSV_SHIFT 13
#define PMIC_RG_VMCH_VOS_CAL_EN_ADDR MT6356_VMCH_ANA_CON1
#define PMIC_RG_VMCH_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VMCH_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VMC_VOCAL_ADDR MT6356_VMC_ANA_CON0
#define PMIC_RG_VMC_VOCAL_MASK 0xF
#define PMIC_RG_VMC_VOCAL_SHIFT 0
#define PMIC_RG_VMC_VOSEL_ADDR MT6356_VMC_ANA_CON0
#define PMIC_RG_VMC_VOSEL_MASK 0xF
#define PMIC_RG_VMC_VOSEL_SHIFT 8
#define PMIC_RGS_VMC_CAL_INDI_ADDR MT6356_VMC_ANA_CON1
#define PMIC_RGS_VMC_CAL_INDI_MASK 0x1
#define PMIC_RGS_VMC_CAL_INDI_SHIFT 4
#define PMIC_RG_VMC_NDIS_EN_ADDR MT6356_VMC_ANA_CON1
#define PMIC_RG_VMC_NDIS_EN_MASK 0x1
#define PMIC_RG_VMC_NDIS_EN_SHIFT 11
#define PMIC_RG_VMC_STB_SEL_ADDR MT6356_VMC_ANA_CON1
#define PMIC_RG_VMC_STB_SEL_MASK 0x1
#define PMIC_RG_VMC_STB_SEL_SHIFT 12
#define PMIC_RG_VMC_RSV_ADDR MT6356_VMC_ANA_CON1
#define PMIC_RG_VMC_RSV_MASK 0x3
#define PMIC_RG_VMC_RSV_SHIFT 13
#define PMIC_RG_VMC_VOS_CAL_EN_ADDR MT6356_VMC_ANA_CON1
#define PMIC_RG_VMC_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VMC_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VCAMIO_VOCAL_ADDR MT6356_VCAMIO_ANA_CON0
#define PMIC_RG_VCAMIO_VOCAL_MASK 0xF
#define PMIC_RG_VCAMIO_VOCAL_SHIFT 0
#define PMIC_RG_VCAMIO_VOSEL_ADDR MT6356_VCAMIO_ANA_CON0
#define PMIC_RG_VCAMIO_VOSEL_MASK 0xF
#define PMIC_RG_VCAMIO_VOSEL_SHIFT 8
#define PMIC_RGS_VCAMIO_CAL_INDI_ADDR MT6356_VCAMIO_ANA_CON1
#define PMIC_RGS_VCAMIO_CAL_INDI_MASK 0x1
#define PMIC_RGS_VCAMIO_CAL_INDI_SHIFT 4
#define PMIC_RG_VCAMIO_NDIS_EN_ADDR MT6356_VCAMIO_ANA_CON1
#define PMIC_RG_VCAMIO_NDIS_EN_MASK 0x1
#define PMIC_RG_VCAMIO_NDIS_EN_SHIFT 11
#define PMIC_RG_VCAMIO_STB_SEL_ADDR MT6356_VCAMIO_ANA_CON1
#define PMIC_RG_VCAMIO_STB_SEL_MASK 0x1
#define PMIC_RG_VCAMIO_STB_SEL_SHIFT 12
#define PMIC_RG_VCAMIO_RSV_ADDR MT6356_VCAMIO_ANA_CON1
#define PMIC_RG_VCAMIO_RSV_MASK 0x3
#define PMIC_RG_VCAMIO_RSV_SHIFT 13
#define PMIC_RG_VCAMIO_VOS_CAL_EN_ADDR MT6356_VCAMIO_ANA_CON1
#define PMIC_RG_VCAMIO_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VCAMIO_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VCN18_VOCAL_ADDR MT6356_VCN18_ANA_CON0
#define PMIC_RG_VCN18_VOCAL_MASK 0xF
#define PMIC_RG_VCN18_VOCAL_SHIFT 0
#define PMIC_RG_VCN18_VOSEL_ADDR MT6356_VCN18_ANA_CON0
#define PMIC_RG_VCN18_VOSEL_MASK 0xF
#define PMIC_RG_VCN18_VOSEL_SHIFT 8
#define PMIC_RGS_VCN18_CAL_INDI_ADDR MT6356_VCN18_ANA_CON1
#define PMIC_RGS_VCN18_CAL_INDI_MASK 0x1
#define PMIC_RGS_VCN18_CAL_INDI_SHIFT 4
#define PMIC_RG_VCN18_NDIS_EN_ADDR MT6356_VCN18_ANA_CON1
#define PMIC_RG_VCN18_NDIS_EN_MASK 0x1
#define PMIC_RG_VCN18_NDIS_EN_SHIFT 11
#define PMIC_RG_VCN18_STB_SEL_ADDR MT6356_VCN18_ANA_CON1
#define PMIC_RG_VCN18_STB_SEL_MASK 0x1
#define PMIC_RG_VCN18_STB_SEL_SHIFT 12
#define PMIC_RG_VCN18_RSV_ADDR MT6356_VCN18_ANA_CON1
#define PMIC_RG_VCN18_RSV_MASK 0x3
#define PMIC_RG_VCN18_RSV_SHIFT 13
#define PMIC_RG_VCN18_VOS_CAL_EN_ADDR MT6356_VCN18_ANA_CON1
#define PMIC_RG_VCN18_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VCN18_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VRF18_VOCAL_ADDR MT6356_VRF18_ANA_CON0
#define PMIC_RG_VRF18_VOCAL_MASK 0xF
#define PMIC_RG_VRF18_VOCAL_SHIFT 0
#define PMIC_RG_VRF18_VOSEL_ADDR MT6356_VRF18_ANA_CON0
#define PMIC_RG_VRF18_VOSEL_MASK 0xF
#define PMIC_RG_VRF18_VOSEL_SHIFT 8
#define PMIC_RGS_VRF18_CAL_INDI_ADDR MT6356_VRF18_ANA_CON1
#define PMIC_RGS_VRF18_CAL_INDI_MASK 0x1
#define PMIC_RGS_VRF18_CAL_INDI_SHIFT 4
#define PMIC_RG_VRF18_NDIS_EN_ADDR MT6356_VRF18_ANA_CON1
#define PMIC_RG_VRF18_NDIS_EN_MASK 0x1
#define PMIC_RG_VRF18_NDIS_EN_SHIFT 11
#define PMIC_RG_VRF18_STB_SEL_ADDR MT6356_VRF18_ANA_CON1
#define PMIC_RG_VRF18_STB_SEL_MASK 0x1
#define PMIC_RG_VRF18_STB_SEL_SHIFT 12
#define PMIC_RG_VRF18_RSV_ADDR MT6356_VRF18_ANA_CON1
#define PMIC_RG_VRF18_RSV_MASK 0x3
#define PMIC_RG_VRF18_RSV_SHIFT 13
#define PMIC_RG_VRF18_VOS_CAL_EN_ADDR MT6356_VRF18_ANA_CON1
#define PMIC_RG_VRF18_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VRF18_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VIO18_VOCAL_ADDR MT6356_VIO18_ANA_CON0
#define PMIC_RG_VIO18_VOCAL_MASK 0xF
#define PMIC_RG_VIO18_VOCAL_SHIFT 0
#define PMIC_RG_VIO18_VOSEL_ADDR MT6356_VIO18_ANA_CON0
#define PMIC_RG_VIO18_VOSEL_MASK 0xF
#define PMIC_RG_VIO18_VOSEL_SHIFT 8
#define PMIC_RGS_VIO18_CAL_INDI_ADDR MT6356_VIO18_ANA_CON1
#define PMIC_RGS_VIO18_CAL_INDI_MASK 0x1
#define PMIC_RGS_VIO18_CAL_INDI_SHIFT 4
#define PMIC_RG_VIO18_NDIS_EN_ADDR MT6356_VIO18_ANA_CON1
#define PMIC_RG_VIO18_NDIS_EN_MASK 0x1
#define PMIC_RG_VIO18_NDIS_EN_SHIFT 11
#define PMIC_RG_VIO18_STB_SEL_ADDR MT6356_VIO18_ANA_CON1
#define PMIC_RG_VIO18_STB_SEL_MASK 0x1
#define PMIC_RG_VIO18_STB_SEL_SHIFT 12
#define PMIC_RG_VIO18_RSV_ADDR MT6356_VIO18_ANA_CON1
#define PMIC_RG_VIO18_RSV_MASK 0x3
#define PMIC_RG_VIO18_RSV_SHIFT 13
#define PMIC_RG_VIO18_VOS_CAL_EN_ADDR MT6356_VIO18_ANA_CON1
#define PMIC_RG_VIO18_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VIO18_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VMIPI_VOCAL_ADDR MT6356_VMIPI_ANA_CON0
#define PMIC_RG_VMIPI_VOCAL_MASK 0xF
#define PMIC_RG_VMIPI_VOCAL_SHIFT 0
#define PMIC_RG_VMIPI_VOSEL_ADDR MT6356_VMIPI_ANA_CON0
#define PMIC_RG_VMIPI_VOSEL_MASK 0xF
#define PMIC_RG_VMIPI_VOSEL_SHIFT 8
#define PMIC_RGS_VMIPI_CAL_INDI_ADDR MT6356_VMIPI_ANA_CON1
#define PMIC_RGS_VMIPI_CAL_INDI_MASK 0x1
#define PMIC_RGS_VMIPI_CAL_INDI_SHIFT 4
#define PMIC_RG_VMIPI_NDIS_EN_ADDR MT6356_VMIPI_ANA_CON1
#define PMIC_RG_VMIPI_NDIS_EN_MASK 0x1
#define PMIC_RG_VMIPI_NDIS_EN_SHIFT 11
#define PMIC_RG_VMIPI_STB_SEL_ADDR MT6356_VMIPI_ANA_CON1
#define PMIC_RG_VMIPI_STB_SEL_MASK 0x1
#define PMIC_RG_VMIPI_STB_SEL_SHIFT 12
#define PMIC_RG_VMIPI_RSV_ADDR MT6356_VMIPI_ANA_CON1
#define PMIC_RG_VMIPI_RSV_MASK 0x3
#define PMIC_RG_VMIPI_RSV_SHIFT 13
#define PMIC_RG_VMIPI_VOS_CAL_EN_ADDR MT6356_VMIPI_ANA_CON1
#define PMIC_RG_VMIPI_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VMIPI_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VDRAM_VOCAL_ADDR MT6356_VDRAM_ANA_CON0
#define PMIC_RG_VDRAM_VOCAL_MASK 0xF
#define PMIC_RG_VDRAM_VOCAL_SHIFT 0
#define PMIC_RG_VDRAM_VOSEL_ADDR MT6356_VDRAM_ANA_CON0
#define PMIC_RG_VDRAM_VOSEL_MASK 0xF
#define PMIC_RG_VDRAM_VOSEL_SHIFT 8
#define PMIC_RGS_VDRAM_CAL_INDI_ADDR MT6356_VDRAM_ANA_CON1
#define PMIC_RGS_VDRAM_CAL_INDI_MASK 0x1
#define PMIC_RGS_VDRAM_CAL_INDI_SHIFT 4
#define PMIC_RG_VDRAM_NDIS_EN_ADDR MT6356_VDRAM_ANA_CON1
#define PMIC_RG_VDRAM_NDIS_EN_MASK 0x1
#define PMIC_RG_VDRAM_NDIS_EN_SHIFT 11
#define PMIC_RG_VDRAM_STB_SEL_ADDR MT6356_VDRAM_ANA_CON1
#define PMIC_RG_VDRAM_STB_SEL_MASK 0x1
#define PMIC_RG_VDRAM_STB_SEL_SHIFT 12
#define PMIC_RG_VDRAM_RSV_ADDR MT6356_VDRAM_ANA_CON1
#define PMIC_RG_VDRAM_RSV_MASK 0x3
#define PMIC_RG_VDRAM_RSV_SHIFT 13
#define PMIC_RG_VDRAM_VOS_CAL_EN_ADDR MT6356_VDRAM_ANA_CON1
#define PMIC_RG_VDRAM_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VDRAM_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VRF12_VOCAL_ADDR MT6356_VRF12_ANA_CON0
#define PMIC_RG_VRF12_VOCAL_MASK 0xF
#define PMIC_RG_VRF12_VOCAL_SHIFT 0
#define PMIC_RG_VRF12_VOSEL_ADDR MT6356_VRF12_ANA_CON0
#define PMIC_RG_VRF12_VOSEL_MASK 0xF
#define PMIC_RG_VRF12_VOSEL_SHIFT 8
#define PMIC_RGS_VRF12_CAL_INDI_ADDR MT6356_VRF12_ANA_CON1
#define PMIC_RGS_VRF12_CAL_INDI_MASK 0x1
#define PMIC_RGS_VRF12_CAL_INDI_SHIFT 4
#define PMIC_RG_VRF12_NDIS_EN_ADDR MT6356_VRF12_ANA_CON1
#define PMIC_RG_VRF12_NDIS_EN_MASK 0x1
#define PMIC_RG_VRF12_NDIS_EN_SHIFT 11
#define PMIC_RG_VRF12_STB_SEL_ADDR MT6356_VRF12_ANA_CON1
#define PMIC_RG_VRF12_STB_SEL_MASK 0x1
#define PMIC_RG_VRF12_STB_SEL_SHIFT 12
#define PMIC_RG_VRF12_RSV_ADDR MT6356_VRF12_ANA_CON1
#define PMIC_RG_VRF12_RSV_MASK 0x3
#define PMIC_RG_VRF12_RSV_SHIFT 13
#define PMIC_RG_VRF12_VOS_CAL_EN_ADDR MT6356_VRF12_ANA_CON1
#define PMIC_RG_VRF12_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VRF12_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VA12_VOCAL_ADDR MT6356_VA12_ANA_CON0
#define PMIC_RG_VA12_VOCAL_MASK 0xF
#define PMIC_RG_VA12_VOCAL_SHIFT 0
#define PMIC_RG_VA12_VOSEL_ADDR MT6356_VA12_ANA_CON0
#define PMIC_RG_VA12_VOSEL_MASK 0xF
#define PMIC_RG_VA12_VOSEL_SHIFT 8
#define PMIC_RGS_VA12_CAL_INDI_ADDR MT6356_VA12_ANA_CON1
#define PMIC_RGS_VA12_CAL_INDI_MASK 0x1
#define PMIC_RGS_VA12_CAL_INDI_SHIFT 4
#define PMIC_RG_VA12_NDIS_EN_ADDR MT6356_VA12_ANA_CON1
#define PMIC_RG_VA12_NDIS_EN_MASK 0x1
#define PMIC_RG_VA12_NDIS_EN_SHIFT 11
#define PMIC_RG_VA12_STB_SEL_ADDR MT6356_VA12_ANA_CON1
#define PMIC_RG_VA12_STB_SEL_MASK 0x1
#define PMIC_RG_VA12_STB_SEL_SHIFT 12
#define PMIC_RG_VA12_RSV_ADDR MT6356_VA12_ANA_CON1
#define PMIC_RG_VA12_RSV_MASK 0x3
#define PMIC_RG_VA12_RSV_SHIFT 13
#define PMIC_RG_VA12_VOS_CAL_EN_ADDR MT6356_VA12_ANA_CON1
#define PMIC_RG_VA12_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VA12_VOS_CAL_EN_SHIFT 15
#define PMIC_RG_VSRAM_PROC_STB_SEL_ADDR MT6356_VSRAM_PROC_ANA_CON0
#define PMIC_RG_VSRAM_PROC_STB_SEL_MASK 0x1
#define PMIC_RG_VSRAM_PROC_STB_SEL_SHIFT 4
#define PMIC_RG_VSRAM_PROC_NDIS_EN_ADDR MT6356_VSRAM_PROC_ANA_CON0
#define PMIC_RG_VSRAM_PROC_NDIS_EN_MASK 0x1
#define PMIC_RG_VSRAM_PROC_NDIS_EN_SHIFT 5
#define PMIC_RG_VSRAM_PROC_NDIS_PLCUR_ADDR MT6356_VSRAM_PROC_ANA_CON0
#define PMIC_RG_VSRAM_PROC_NDIS_PLCUR_MASK 0x3
#define PMIC_RG_VSRAM_PROC_NDIS_PLCUR_SHIFT 6
#define PMIC_RG_VSRAM_PROC_PLCUR_EN_ADDR MT6356_VSRAM_PROC_ANA_CON0
#define PMIC_RG_VSRAM_PROC_PLCUR_EN_MASK 0x1
#define PMIC_RG_VSRAM_PROC_PLCUR_EN_SHIFT 8
#define PMIC_RG_VSRAM_PROC_RSV_H_ADDR MT6356_VSRAM_PROC_ANA_CON0
#define PMIC_RG_VSRAM_PROC_RSV_H_MASK 0x7
#define PMIC_RG_VSRAM_PROC_RSV_H_SHIFT 9
#define PMIC_RG_VSRAM_PROC_RSV_L_ADDR MT6356_VSRAM_PROC_ANA_CON0
#define PMIC_RG_VSRAM_PROC_RSV_L_MASK 0x7
#define PMIC_RG_VSRAM_PROC_RSV_L_SHIFT 12
#define PMIC_RG_VSRAM_OTHERS_STB_SEL_ADDR MT6356_VSRAM_OTHERS_ANA_CON0
#define PMIC_RG_VSRAM_OTHERS_STB_SEL_MASK 0x1
#define PMIC_RG_VSRAM_OTHERS_STB_SEL_SHIFT 4
#define PMIC_RG_VSRAM_OTHERS_NDIS_EN_ADDR MT6356_VSRAM_OTHERS_ANA_CON0
#define PMIC_RG_VSRAM_OTHERS_NDIS_EN_MASK 0x1
#define PMIC_RG_VSRAM_OTHERS_NDIS_EN_SHIFT 5
#define PMIC_RG_VSRAM_OTHERS_NDIS_PLCUR_ADDR MT6356_VSRAM_OTHERS_ANA_CON0
#define PMIC_RG_VSRAM_OTHERS_NDIS_PLCUR_MASK 0x3
#define PMIC_RG_VSRAM_OTHERS_NDIS_PLCUR_SHIFT 6
#define PMIC_RG_VSRAM_OTHERS_PLCUR_EN_ADDR MT6356_VSRAM_OTHERS_ANA_CON0
#define PMIC_RG_VSRAM_OTHERS_PLCUR_EN_MASK 0x1
#define PMIC_RG_VSRAM_OTHERS_PLCUR_EN_SHIFT 8
#define PMIC_RG_VSRAM_OTHERS_RSV_H_ADDR MT6356_VSRAM_OTHERS_ANA_CON0
#define PMIC_RG_VSRAM_OTHERS_RSV_H_MASK 0x7
#define PMIC_RG_VSRAM_OTHERS_RSV_H_SHIFT 9
#define PMIC_RG_VSRAM_OTHERS_RSV_L_ADDR MT6356_VSRAM_OTHERS_ANA_CON0
#define PMIC_RG_VSRAM_OTHERS_RSV_L_MASK 0x7
#define PMIC_RG_VSRAM_OTHERS_RSV_L_SHIFT 12
#define PMIC_RG_VSRAM_GPU_STB_SEL_ADDR MT6356_VSRAM_GPU_ANA_CON0
#define PMIC_RG_VSRAM_GPU_STB_SEL_MASK 0x1
#define PMIC_RG_VSRAM_GPU_STB_SEL_SHIFT 4
#define PMIC_RG_VSRAM_GPU_NDIS_EN_ADDR MT6356_VSRAM_GPU_ANA_CON0
#define PMIC_RG_VSRAM_GPU_NDIS_EN_MASK 0x1
#define PMIC_RG_VSRAM_GPU_NDIS_EN_SHIFT 5
#define PMIC_RG_VSRAM_GPU_NDIS_PLCUR_ADDR MT6356_VSRAM_GPU_ANA_CON0
#define PMIC_RG_VSRAM_GPU_NDIS_PLCUR_MASK 0x3
#define PMIC_RG_VSRAM_GPU_NDIS_PLCUR_SHIFT 6
#define PMIC_RG_VSRAM_GPU_PLCUR_EN_ADDR MT6356_VSRAM_GPU_ANA_CON0
#define PMIC_RG_VSRAM_GPU_PLCUR_EN_MASK 0x1
#define PMIC_RG_VSRAM_GPU_PLCUR_EN_SHIFT 8
#define PMIC_RG_VSRAM_GPU_RSV_H_ADDR MT6356_VSRAM_GPU_ANA_CON0
#define PMIC_RG_VSRAM_GPU_RSV_H_MASK 0x7
#define PMIC_RG_VSRAM_GPU_RSV_H_SHIFT 9
#define PMIC_RG_VSRAM_GPU_RSV_L_ADDR MT6356_VSRAM_GPU_ANA_CON0
#define PMIC_RG_VSRAM_GPU_RSV_L_MASK 0x7
#define PMIC_RG_VSRAM_GPU_RSV_L_SHIFT 12
#define PMIC_RG_VCAMD_VOCAL_ADDR MT6356_CAMD_ANA_CON0
#define PMIC_RG_VCAMD_VOCAL_MASK 0xF
#define PMIC_RG_VCAMD_VOCAL_SHIFT 0
#define PMIC_RG_VCAMD_VOSEL_ADDR MT6356_CAMD_ANA_CON0
#define PMIC_RG_VCAMD_VOSEL_MASK 0xF
#define PMIC_RG_VCAMD_VOSEL_SHIFT 8
#define PMIC_RGS_VCAMD_CAL_INDI_ADDR MT6356_CAMD_ANA_CON1
#define PMIC_RGS_VCAMD_CAL_INDI_MASK 0x1
#define PMIC_RGS_VCAMD_CAL_INDI_SHIFT 4
#define PMIC_RG_VCAMD_NDIS_EN_ADDR MT6356_CAMD_ANA_CON1
#define PMIC_RG_VCAMD_NDIS_EN_MASK 0x1
#define PMIC_RG_VCAMD_NDIS_EN_SHIFT 11
#define PMIC_RG_VCAMD_STB_SEL_ADDR MT6356_CAMD_ANA_CON1
#define PMIC_RG_VCAMD_STB_SEL_MASK 0x1
#define PMIC_RG_VCAMD_STB_SEL_SHIFT 12
#define PMIC_RG_VCAMD_RSV_ADDR MT6356_CAMD_ANA_CON1
#define PMIC_RG_VCAMD_RSV_MASK 0x3
#define PMIC_RG_VCAMD_RSV_SHIFT 13
#define PMIC_RG_VCAMD_VOS_CAL_EN_ADDR MT6356_CAMD_ANA_CON1
#define PMIC_RG_VCAMD_VOS_CAL_EN_MASK 0x1
#define PMIC_RG_VCAMD_VOS_CAL_EN_SHIFT 15
#define PMIC_LDO_ANA_ELR_LEN_ADDR MT6356_LDO_ANA_ELR_NUM
#define PMIC_LDO_ANA_ELR_LEN_MASK 0xFF
#define PMIC_LDO_ANA_ELR_LEN_SHIFT 0
#define PMIC_RG_VCAMA_VOTRIM_ADDR MT6356_VCAMA_ELR_0
#define PMIC_RG_VCAMA_VOTRIM_MASK 0xF
#define PMIC_RG_VCAMA_VOTRIM_SHIFT 0
#define PMIC_RG_VCAMA_OC_TRIM_ADDR MT6356_VCAMA_ELR_0
#define PMIC_RG_VCAMA_OC_TRIM_MASK 0x7
#define PMIC_RG_VCAMA_OC_TRIM_SHIFT 4
#define PMIC_RG_VFE28_VOTRIM_ADDR MT6356_VFE28_ELR_0
#define PMIC_RG_VFE28_VOTRIM_MASK 0xF
#define PMIC_RG_VFE28_VOTRIM_SHIFT 0
#define PMIC_RG_VFE28_OC_TRIM_ADDR MT6356_VFE28_ELR_0
#define PMIC_RG_VFE28_OC_TRIM_MASK 0x7
#define PMIC_RG_VFE28_OC_TRIM_SHIFT 4
#define PMIC_RG_VCN28_VOTRIM_ADDR MT6356_VCN28_ELR_0
#define PMIC_RG_VCN28_VOTRIM_MASK 0xF
#define PMIC_RG_VCN28_VOTRIM_SHIFT 0
#define PMIC_RG_VCN28_OC_TRIM_ADDR MT6356_VCN28_ELR_0
#define PMIC_RG_VCN28_OC_TRIM_MASK 0x7
#define PMIC_RG_VCN28_OC_TRIM_SHIFT 4
#define PMIC_RG_VBIF28_VOTRIM_ADDR MT6356_VBIF28_ELR_0
#define PMIC_RG_VBIF28_VOTRIM_MASK 0xF
#define PMIC_RG_VBIF28_VOTRIM_SHIFT 0
#define PMIC_RG_VBIF28_OC_TRIM_ADDR MT6356_VBIF28_ELR_0
#define PMIC_RG_VBIF28_OC_TRIM_MASK 0x7
#define PMIC_RG_VBIF28_OC_TRIM_SHIFT 4
#define PMIC_RG_VAUD28_VOTRIM_ADDR MT6356_VAUD28_ELR_0
#define PMIC_RG_VAUD28_VOTRIM_MASK 0xF
#define PMIC_RG_VAUD28_VOTRIM_SHIFT 0
#define PMIC_RG_VAUD28_OC_TRIM_ADDR MT6356_VAUD28_ELR_0
#define PMIC_RG_VAUD28_OC_TRIM_MASK 0x7
#define PMIC_RG_VAUD28_OC_TRIM_SHIFT 4
#define PMIC_RG_VAUX18_VOTRIM_ADDR MT6356_VAUX18_ELR_0
#define PMIC_RG_VAUX18_VOTRIM_MASK 0xF
#define PMIC_RG_VAUX18_VOTRIM_SHIFT 0
#define PMIC_RG_VAUX18_OC_TRIM_ADDR MT6356_VAUX18_ELR_0
#define PMIC_RG_VAUX18_OC_TRIM_MASK 0x7
#define PMIC_RG_VAUX18_OC_TRIM_SHIFT 4
#define PMIC_RG_VXO22_VOTRIM_ADDR MT6356_VXO22_ELR_0
#define PMIC_RG_VXO22_VOTRIM_MASK 0xF
#define PMIC_RG_VXO22_VOTRIM_SHIFT 0
#define PMIC_RG_VXO22_OC_TRIM_ADDR MT6356_VXO22_ELR_0
#define PMIC_RG_VXO22_OC_TRIM_MASK 0x7
#define PMIC_RG_VXO22_OC_TRIM_SHIFT 4
#define PMIC_RG_VCN33_VOTRIM_ADDR MT6356_VCN33_ELR_0
#define PMIC_RG_VCN33_VOTRIM_MASK 0xF
#define PMIC_RG_VCN33_VOTRIM_SHIFT 0
#define PMIC_RG_VCN33_OC_TRIM_ADDR MT6356_VCN33_ELR_0
#define PMIC_RG_VCN33_OC_TRIM_MASK 0x7
#define PMIC_RG_VCN33_OC_TRIM_SHIFT 4
#define PMIC_RG_VUSB_VOTRIM_ADDR MT6356_VUSB_ELR_0
#define PMIC_RG_VUSB_VOTRIM_MASK 0xF
#define PMIC_RG_VUSB_VOTRIM_SHIFT 0
#define PMIC_RG_VUSB_OC_TRIM_ADDR MT6356_VUSB_ELR_0
#define PMIC_RG_VUSB_OC_TRIM_MASK 0x7
#define PMIC_RG_VUSB_OC_TRIM_SHIFT 4
#define PMIC_RG_VEMC_VOTRIM_ADDR MT6356_VEMC_ELR_0
#define PMIC_RG_VEMC_VOTRIM_MASK 0xF
#define PMIC_RG_VEMC_VOTRIM_SHIFT 0
#define PMIC_RG_VEMC_OC_TRIM_ADDR MT6356_VEMC_ELR_0
#define PMIC_RG_VEMC_OC_TRIM_MASK 0x7
#define PMIC_RG_VEMC_OC_TRIM_SHIFT 4
#define PMIC_RG_VLDO28_VOTRIM_ADDR MT6356_VLDO28_ELR_0
#define PMIC_RG_VLDO28_VOTRIM_MASK 0xF
#define PMIC_RG_VLDO28_VOTRIM_SHIFT 0
#define PMIC_RG_VLDO28_OC_TRIM_ADDR MT6356_VLDO28_ELR_0
#define PMIC_RG_VLDO28_OC_TRIM_MASK 0x7
#define PMIC_RG_VLDO28_OC_TRIM_SHIFT 4
#define PMIC_RG_VIO28_VOTRIM_ADDR MT6356_VIO28_ELR_0
#define PMIC_RG_VIO28_VOTRIM_MASK 0xF
#define PMIC_RG_VIO28_VOTRIM_SHIFT 0
#define PMIC_RG_VIO28_OC_TRIM_ADDR MT6356_VIO28_ELR_0
#define PMIC_RG_VIO28_OC_TRIM_MASK 0x7
#define PMIC_RG_VIO28_OC_TRIM_SHIFT 4
#define PMIC_RG_VIBR_VOTRIM_ADDR MT6356_VIBR_ELR_0
#define PMIC_RG_VIBR_VOTRIM_MASK 0xF
#define PMIC_RG_VIBR_VOTRIM_SHIFT 0
#define PMIC_RG_VIBR_OC_TRIM_ADDR MT6356_VIBR_ELR_0
#define PMIC_RG_VIBR_OC_TRIM_MASK 0x7
#define PMIC_RG_VIBR_OC_TRIM_SHIFT 4
#define PMIC_RG_VSIM1_VOTRIM_ADDR MT6356_VSIM1_ELR_0
#define PMIC_RG_VSIM1_VOTRIM_MASK 0xF
#define PMIC_RG_VSIM1_VOTRIM_SHIFT 0
#define PMIC_RG_VSIM1_OC_TRIM_ADDR MT6356_VSIM1_ELR_0
#define PMIC_RG_VSIM1_OC_TRIM_MASK 0x7
#define PMIC_RG_VSIM1_OC_TRIM_SHIFT 4
#define PMIC_RG_VSIM2_VOTRIM_ADDR MT6356_VSIM2_ELR_0
#define PMIC_RG_VSIM2_VOTRIM_MASK 0xF
#define PMIC_RG_VSIM2_VOTRIM_SHIFT 0
#define PMIC_RG_VSIM2_OC_TRIM_ADDR MT6356_VSIM2_ELR_0
#define PMIC_RG_VSIM2_OC_TRIM_MASK 0x7
#define PMIC_RG_VSIM2_OC_TRIM_SHIFT 4
#define PMIC_RG_VMCH_VOTRIM_ADDR MT6356_VMCH_ELR_0
#define PMIC_RG_VMCH_VOTRIM_MASK 0xF
#define PMIC_RG_VMCH_VOTRIM_SHIFT 0
#define PMIC_RG_VMCH_OC_TRIM_ADDR MT6356_VMCH_ELR_0
#define PMIC_RG_VMCH_OC_TRIM_MASK 0x7
#define PMIC_RG_VMCH_OC_TRIM_SHIFT 4
#define PMIC_RG_VMC_VOTRIM_ADDR MT6356_VMC_ELR_0
#define PMIC_RG_VMC_VOTRIM_MASK 0xF
#define PMIC_RG_VMC_VOTRIM_SHIFT 0
#define PMIC_RG_VMC_OC_TRIM_ADDR MT6356_VMC_ELR_0
#define PMIC_RG_VMC_OC_TRIM_MASK 0x7
#define PMIC_RG_VMC_OC_TRIM_SHIFT 4
#define PMIC_RG_VCAMIO_VOTRIM_ADDR MT6356_VCAMIO_ELR_0
#define PMIC_RG_VCAMIO_VOTRIM_MASK 0xF
#define PMIC_RG_VCAMIO_VOTRIM_SHIFT 0
#define PMIC_RG_VCAMIO_OC_TRIM_ADDR MT6356_VCAMIO_ELR_0
#define PMIC_RG_VCAMIO_OC_TRIM_MASK 0x7
#define PMIC_RG_VCAMIO_OC_TRIM_SHIFT 4
#define PMIC_RG_VCN18_VOTRIM_ADDR MT6356_VCN18_ELR_0
#define PMIC_RG_VCN18_VOTRIM_MASK 0xF
#define PMIC_RG_VCN18_VOTRIM_SHIFT 0
#define PMIC_RG_VCN18_OC_TRIM_ADDR MT6356_VCN18_ELR_0
#define PMIC_RG_VCN18_OC_TRIM_MASK 0x7
#define PMIC_RG_VCN18_OC_TRIM_SHIFT 4
#define PMIC_RG_VRF18_VOTRIM_ADDR MT6356_VRF18_ELR_0
#define PMIC_RG_VRF18_VOTRIM_MASK 0xF
#define PMIC_RG_VRF18_VOTRIM_SHIFT 0
#define PMIC_RG_VRF18_OC_TRIM_ADDR MT6356_VRF18_ELR_0
#define PMIC_RG_VRF18_OC_TRIM_MASK 0x7
#define PMIC_RG_VRF18_OC_TRIM_SHIFT 4
#define PMIC_RG_VIO18_VOTRIM_ADDR MT6356_VIO18_ELR_0
#define PMIC_RG_VIO18_VOTRIM_MASK 0xF
#define PMIC_RG_VIO18_VOTRIM_SHIFT 0
#define PMIC_RG_VIO18_OC_TRIM_ADDR MT6356_VIO18_ELR_0
#define PMIC_RG_VIO18_OC_TRIM_MASK 0x7
#define PMIC_RG_VIO18_OC_TRIM_SHIFT 4
#define PMIC_RG_VMIPI_VOTRIM_ADDR MT6356_VMIPI_ELR_0
#define PMIC_RG_VMIPI_VOTRIM_MASK 0xF
#define PMIC_RG_VMIPI_VOTRIM_SHIFT 0
#define PMIC_RG_VMIPI_OC_TRIM_ADDR MT6356_VMIPI_ELR_0
#define PMIC_RG_VMIPI_OC_TRIM_MASK 0x7
#define PMIC_RG_VMIPI_OC_TRIM_SHIFT 4
#define PMIC_RG_VDRAM_VOTRIM_ADDR MT6356_VDRAM_ELR_0
#define PMIC_RG_VDRAM_VOTRIM_MASK 0xF
#define PMIC_RG_VDRAM_VOTRIM_SHIFT 0
#define PMIC_RG_VDRAM_OC_TRIM_ADDR MT6356_VDRAM_ELR_0
#define PMIC_RG_VDRAM_OC_TRIM_MASK 0x7
#define PMIC_RG_VDRAM_OC_TRIM_SHIFT 4
#define PMIC_RG_VRF12_VOTRIM_ADDR MT6356_VRF12_ELR_0
#define PMIC_RG_VRF12_VOTRIM_MASK 0xF
#define PMIC_RG_VRF12_VOTRIM_SHIFT 0
#define PMIC_RG_RF12_OC_TRIM_ADDR MT6356_VRF12_ELR_0
#define PMIC_RG_RF12_OC_TRIM_MASK 0x7
#define PMIC_RG_RF12_OC_TRIM_SHIFT 4
#define PMIC_RG_VA12_VOTRIM_ADDR MT6356_VA12_ELR_0
#define PMIC_RG_VA12_VOTRIM_MASK 0xF
#define PMIC_RG_VA12_VOTRIM_SHIFT 0
#define PMIC_RG_VA12_OC_TRIM_ADDR MT6356_VA12_ELR_0
#define PMIC_RG_VA12_OC_TRIM_MASK 0x7
#define PMIC_RG_VA12_OC_TRIM_SHIFT 4
#define PMIC_RG_VSRAM_PROC_OC_TRIM_ADDR MT6356_VSRAM_PROC_ELR_0
#define PMIC_RG_VSRAM_PROC_OC_TRIM_MASK 0xF
#define PMIC_RG_VSRAM_PROC_OC_TRIM_SHIFT 0
#define PMIC_RG_VSRAM_OTHERS_OC_TRIM_ADDR MT6356_VSRAM_OTHERS_ELR_0
#define PMIC_RG_VSRAM_OTHERS_OC_TRIM_MASK 0xF
#define PMIC_RG_VSRAM_OTHERS_OC_TRIM_SHIFT 0
#define PMIC_RG_VSRAM_GPU_OC_TRIM_ADDR MT6356_VSRAM_GPU_ELR_0
#define PMIC_RG_VSRAM_GPU_OC_TRIM_MASK 0xF
#define PMIC_RG_VSRAM_GPU_OC_TRIM_SHIFT 0
#define PMIC_RG_VCAMD_VOTRIM_ADDR MT6356_CAMD_ELR_0
#define PMIC_RG_VCAMD_VOTRIM_MASK 0xF
#define PMIC_RG_VCAMD_VOTRIM_SHIFT 0
#define PMIC_RG_VCAMD_OC_TRIM_ADDR MT6356_CAMD_ELR_0
#define PMIC_RG_VCAMD_OC_TRIM_MASK 0x7
#define PMIC_RG_VCAMD_OC_TRIM_SHIFT 4
#define PMIC_RG_VRTC_BIAS_SEL_ADDR MT6356_VRTC_ELR_0
#define PMIC_RG_VRTC_BIAS_SEL_MASK 0x1
#define PMIC_RG_VRTC_BIAS_SEL_SHIFT 0
#define PMIC_XPP_TOP_ANA_ID_ADDR MT6356_XPP_TOP_DSN_ID
#define PMIC_XPP_TOP_ANA_ID_MASK 0xFF
#define PMIC_XPP_TOP_ANA_ID_SHIFT 0
#define PMIC_XPP_TOP_DIG_ID_ADDR MT6356_XPP_TOP_DSN_ID
#define PMIC_XPP_TOP_DIG_ID_MASK 0xFF
#define PMIC_XPP_TOP_DIG_ID_SHIFT 8
#define PMIC_XPP_TOP_ANA_MINOR_REV_ADDR MT6356_XPP_TOP_DSN_REV0
#define PMIC_XPP_TOP_ANA_MINOR_REV_MASK 0xF
#define PMIC_XPP_TOP_ANA_MINOR_REV_SHIFT 0
#define PMIC_XPP_TOP_ANA_MAJOR_REV_ADDR MT6356_XPP_TOP_DSN_REV0
#define PMIC_XPP_TOP_ANA_MAJOR_REV_MASK 0xF
#define PMIC_XPP_TOP_ANA_MAJOR_REV_SHIFT 4
#define PMIC_XPP_TOP_DIG_MINOR_REV_ADDR MT6356_XPP_TOP_DSN_REV0
#define PMIC_XPP_TOP_DIG_MINOR_REV_MASK 0xF
#define PMIC_XPP_TOP_DIG_MINOR_REV_SHIFT 8
#define PMIC_XPP_TOP_DIG_MAJOR_REV_ADDR MT6356_XPP_TOP_DSN_REV0
#define PMIC_XPP_TOP_DIG_MAJOR_REV_MASK 0xF
#define PMIC_XPP_TOP_DIG_MAJOR_REV_SHIFT 12
#define PMIC_XPP_TOP_SW_MINOR_REV_ADDR MT6356_XPP_TOP_DSN_REV1
#define PMIC_XPP_TOP_SW_MINOR_REV_MASK 0xF
#define PMIC_XPP_TOP_SW_MINOR_REV_SHIFT 0
#define PMIC_XPP_TOP_SW_MAJOR_REV_ADDR MT6356_XPP_TOP_DSN_REV1
#define PMIC_XPP_TOP_SW_MAJOR_REV_MASK 0xF
#define PMIC_XPP_TOP_SW_MAJOR_REV_SHIFT 4
#define PMIC_XPP_TOP_ESP_ADDR MT6356_XPP_TOP_DSN_REV1
#define PMIC_XPP_TOP_ESP_MASK 0xFF
#define PMIC_XPP_TOP_ESP_SHIFT 8
#define PMIC_XPP_TOP_CLK_OFFSET_ADDR MT6356_XPP_TOP_PAM0
#define PMIC_XPP_TOP_CLK_OFFSET_MASK 0xFF
#define PMIC_XPP_TOP_CLK_OFFSET_SHIFT 0
#define PMIC_XPP_TOP_RST_OFFSET_ADDR MT6356_XPP_TOP_PAM0
#define PMIC_XPP_TOP_RST_OFFSET_MASK 0xFF
#define PMIC_XPP_TOP_RST_OFFSET_SHIFT 8
#define PMIC_XPP_TOP_INT_OFFSET_ADDR MT6356_XPP_TOP_PAM1
#define PMIC_XPP_TOP_INT_OFFSET_MASK 0xFF
#define PMIC_XPP_TOP_INT_OFFSET_SHIFT 0
#define PMIC_XPP_TOP_INT_LEN_ADDR MT6356_XPP_TOP_PAM1
#define PMIC_XPP_TOP_INT_LEN_MASK 0xFF
#define PMIC_XPP_TOP_INT_LEN_SHIFT 8
#define PMIC_XPP_TEST_OUT_ADDR MT6356_XPP_TOP_TEST_OUT
#define PMIC_XPP_TEST_OUT_MASK 0xFF
#define PMIC_XPP_TEST_OUT_SHIFT 0
#define PMIC_XPP_MON_FLAG_SEL_ADDR MT6356_XPP_TOP_TEST_CON0
#define PMIC_XPP_MON_FLAG_SEL_MASK 0xFF
#define PMIC_XPP_MON_FLAG_SEL_SHIFT 0
#define PMIC_XPP_MON_GRP_SEL_ADDR MT6356_XPP_TOP_TEST_CON0
#define PMIC_XPP_MON_GRP_SEL_MASK 0x1F
#define PMIC_XPP_MON_GRP_SEL_SHIFT 8
#define PMIC_RG_DRV_ISINK0_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_DRV_ISINK0_CK_PDN_MASK 0x1
#define PMIC_RG_DRV_ISINK0_CK_PDN_SHIFT 0
#define PMIC_RG_DRV_ISINK1_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_DRV_ISINK1_CK_PDN_MASK 0x1
#define PMIC_RG_DRV_ISINK1_CK_PDN_SHIFT 1
#define PMIC_RG_DRV_ISINK2_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_DRV_ISINK2_CK_PDN_MASK 0x1
#define PMIC_RG_DRV_ISINK2_CK_PDN_SHIFT 2
#define PMIC_RG_DRV_ISINK3_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_DRV_ISINK3_CK_PDN_MASK 0x1
#define PMIC_RG_DRV_ISINK3_CK_PDN_SHIFT 3
#define PMIC_RG_DRV_128K_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_DRV_128K_CK_PDN_MASK 0x1
#define PMIC_RG_DRV_128K_CK_PDN_SHIFT 4
#define PMIC_RG_DRV_CHRIND_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_DRV_CHRIND_CK_PDN_MASK 0x1
#define PMIC_RG_DRV_CHRIND_CK_PDN_SHIFT 5
#define PMIC_RG_TYPE_C_CC_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_TYPE_C_CC_CK_PDN_MASK 0x1
#define PMIC_RG_TYPE_C_CC_CK_PDN_SHIFT 6
#define PMIC_RG_TYPE_C_CSR_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_TYPE_C_CSR_CK_PDN_MASK 0x1
#define PMIC_RG_TYPE_C_CSR_CK_PDN_SHIFT 7
#define PMIC_RG_XPP_RSV0_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_XPP_RSV0_CK_PDN_MASK 0x1
#define PMIC_RG_XPP_RSV0_CK_PDN_SHIFT 8
#define PMIC_RG_XPP_RSV1_CK_PDN_ADDR MT6356_XPP_TOP_CKPDN_CON0
#define PMIC_RG_XPP_RSV1_CK_PDN_MASK 0x1
#define PMIC_RG_XPP_RSV1_CK_PDN_SHIFT 9
#define PMIC_XPP_TOP_CKPDN_CON0_SET_ADDR MT6356_XPP_TOP_CKPDN_CON0_SET
#define PMIC_XPP_TOP_CKPDN_CON0_SET_MASK 0xFFFF
#define PMIC_XPP_TOP_CKPDN_CON0_SET_SHIFT 0
#define PMIC_XPP_TOP_CKPDN_CON0_CLR_ADDR MT6356_XPP_TOP_CKPDN_CON0_CLR
#define PMIC_XPP_TOP_CKPDN_CON0_CLR_MASK 0xFFFF
#define PMIC_XPP_TOP_CKPDN_CON0_CLR_SHIFT 0
#define PMIC_RG_DRV_ISINK_CK_CKSEL_ADDR MT6356_XPP_TOP_CKSEL_CON0
#define PMIC_RG_DRV_ISINK_CK_CKSEL_MASK 0x1
#define PMIC_RG_DRV_ISINK_CK_CKSEL_SHIFT 0
#define PMIC_RG_TYPE_C_CC_CK_CKSEL_ADDR MT6356_XPP_TOP_CKSEL_CON0
#define PMIC_RG_TYPE_C_CC_CK_CKSEL_MASK 0x1
#define PMIC_RG_TYPE_C_CC_CK_CKSEL_SHIFT 1
#define PMIC_XPP_CKSEL_CON0_RSV_ADDR MT6356_XPP_TOP_CKSEL_CON0
#define PMIC_XPP_CKSEL_CON0_RSV_MASK 0x3
#define PMIC_XPP_CKSEL_CON0_RSV_SHIFT 2
#define PMIC_XPP_TOP_CKSEL_CON0_SET_ADDR MT6356_XPP_TOP_CKSEL_CON0_SET
#define PMIC_XPP_TOP_CKSEL_CON0_SET_MASK 0xFFFF
#define PMIC_XPP_TOP_CKSEL_CON0_SET_SHIFT 0
#define PMIC_XPP_TOP_CKSEL_CON0_CLR_ADDR MT6356_XPP_TOP_CKSEL_CON0_CLR
#define PMIC_XPP_TOP_CKSEL_CON0_CLR_MASK 0xFFFF
#define PMIC_XPP_TOP_CKSEL_CON0_CLR_SHIFT 0
#define PMIC_XPP_CKDIVSEL_CON0_RSV_ADDR MT6356_XPP_TOP_CKDIVSEL_CON0
#define PMIC_XPP_CKDIVSEL_CON0_RSV_MASK 0x1
#define PMIC_XPP_CKDIVSEL_CON0_RSV_SHIFT 0
#define PMIC_XPP_TOP_CKDIVSEL_CON0_SET_ADDR MT6356_XPP_TOP_CKDIVSEL_CON0_SET
#define PMIC_XPP_TOP_CKDIVSEL_CON0_SET_MASK 0xFFFF
#define PMIC_XPP_TOP_CKDIVSEL_CON0_SET_SHIFT 0
#define PMIC_XPP_TOP_CKDIVSEL_CON0_CLR_ADDR MT6356_XPP_TOP_CKDIVSEL_CON0_CLR
#define PMIC_XPP_TOP_CKDIVSEL_CON0_CLR_MASK 0xFFFF
#define PMIC_XPP_TOP_CKDIVSEL_CON0_CLR_SHIFT 0
#define PMIC_XPP_CKHWEN_CON0_RSV_ADDR MT6356_XPP_TOP_CKHWEN_CON0
#define PMIC_XPP_CKHWEN_CON0_RSV_MASK 0x1
#define PMIC_XPP_CKHWEN_CON0_RSV_SHIFT 0
#define PMIC_XPP_TOP_CKHWEN_CON0_SET_ADDR MT6356_XPP_TOP_CKHWEN_CON0_SET
#define PMIC_XPP_TOP_CKHWEN_CON0_SET_MASK 0xFFFF
#define PMIC_XPP_TOP_CKHWEN_CON0_SET_SHIFT 0
#define PMIC_XPP_TOP_CKHWEN_CON0_CLR_ADDR MT6356_XPP_TOP_CKHWEN_CON0_CLR
#define PMIC_XPP_TOP_CKHWEN_CON0_CLR_MASK 0xFFFF
#define PMIC_XPP_TOP_CKHWEN_CON0_CLR_SHIFT 0
#define PMIC_RG_DRIVER_BL_RST_ADDR MT6356_XPP_TOP_RST_CON0
#define PMIC_RG_DRIVER_BL_RST_MASK 0x1
#define PMIC_RG_DRIVER_BL_RST_SHIFT 0
#define PMIC_RG_DRIVER_CI_RST_ADDR MT6356_XPP_TOP_RST_CON0
#define PMIC_RG_DRIVER_CI_RST_MASK 0x1
#define PMIC_RG_DRIVER_CI_RST_SHIFT 1
#define PMIC_RG_XPP_RSV0_RST_ADDR MT6356_XPP_TOP_RST_CON0
#define PMIC_RG_XPP_RSV0_RST_MASK 0x1
#define PMIC_RG_XPP_RSV0_RST_SHIFT 2
#define PMIC_RG_XPP_RSV1_RST_ADDR MT6356_XPP_TOP_RST_CON0
#define PMIC_RG_XPP_RSV1_RST_MASK 0x1
#define PMIC_RG_XPP_RSV1_RST_SHIFT 3
#define PMIC_RG_TYPE_C_RST_ADDR MT6356_XPP_TOP_RST_CON0
#define PMIC_RG_TYPE_C_RST_MASK 0x1
#define PMIC_RG_TYPE_C_RST_SHIFT 4
#define PMIC_XPP_TOP_RST_CON0_SET_ADDR MT6356_XPP_TOP_RST_CON0_SET
#define PMIC_XPP_TOP_RST_CON0_SET_MASK 0xFFFF
#define PMIC_XPP_TOP_RST_CON0_SET_SHIFT 0
#define PMIC_XPP_TOP_RST_CON0_CLR_ADDR MT6356_XPP_TOP_RST_CON0_CLR
#define PMIC_XPP_TOP_RST_CON0_CLR_MASK 0xFFFF
#define PMIC_XPP_TOP_RST_CON0_CLR_SHIFT 0
#define PMIC_RG_DRIVER_BL_BANK_RST_ADDR MT6356_XPP_TOP_RST_BANK_CON0
#define PMIC_RG_DRIVER_BL_BANK_RST_MASK 0x1
#define PMIC_RG_DRIVER_BL_BANK_RST_SHIFT 0
#define PMIC_RG_DRIVER_CI_BANK_RST_ADDR MT6356_XPP_TOP_RST_BANK_CON0
#define PMIC_RG_DRIVER_CI_BANK_RST_MASK 0x1
#define PMIC_RG_DRIVER_CI_BANK_RST_SHIFT 1
#define PMIC_RG_DRIVER_DL_BANK_RST_ADDR MT6356_XPP_TOP_RST_BANK_CON0
#define PMIC_RG_DRIVER_DL_BANK_RST_MASK 0x1
#define PMIC_RG_DRIVER_DL_BANK_RST_SHIFT 2
#define PMIC_RG_DRIVER_ANA_BANK_RST_ADDR MT6356_XPP_TOP_RST_BANK_CON0
#define PMIC_RG_DRIVER_ANA_BANK_RST_MASK 0x1
#define PMIC_RG_DRIVER_ANA_BANK_RST_SHIFT 3
#define PMIC_RG_TYPE_C_BANK_RST_ADDR MT6356_XPP_TOP_RST_BANK_CON0
#define PMIC_RG_TYPE_C_BANK_RST_MASK 0x1
#define PMIC_RG_TYPE_C_BANK_RST_SHIFT 4
#define PMIC_XPP_TOP_RST_BANK_CON0_SET_ADDR MT6356_XPP_TOP_RST_BANK_CON0_SET
#define PMIC_XPP_TOP_RST_BANK_CON0_SET_MASK 0xFFFF
#define PMIC_XPP_TOP_RST_BANK_CON0_SET_SHIFT 0
#define PMIC_XPP_TOP_RST_BANK_CON0_CLR_ADDR MT6356_XPP_TOP_RST_BANK_CON0_CLR
#define PMIC_XPP_TOP_RST_BANK_CON0_CLR_MASK 0xFFFF
#define PMIC_XPP_TOP_RST_BANK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_EN_TYPE_C_CC_IRQ_ADDR MT6356_XPP_TOP_INT_CON0
#define PMIC_RG_INT_EN_TYPE_C_CC_IRQ_MASK 0x1
#define PMIC_RG_INT_EN_TYPE_C_CC_IRQ_SHIFT 0
#define PMIC_RG_INT_EN_XPP_RSV0_ADDR MT6356_XPP_TOP_INT_CON0
#define PMIC_RG_INT_EN_XPP_RSV0_MASK 0x1
#define PMIC_RG_INT_EN_XPP_RSV0_SHIFT 1
#define PMIC_RG_INT_EN_XPP_RSV1_ADDR MT6356_XPP_TOP_INT_CON0
#define PMIC_RG_INT_EN_XPP_RSV1_MASK 0x1
#define PMIC_RG_INT_EN_XPP_RSV1_SHIFT 2
#define PMIC_XPP_TOP_INT_CON0_SET_ADDR MT6356_XPP_TOP_INT_CON0_SET
#define PMIC_XPP_TOP_INT_CON0_SET_MASK 0xFFFF
#define PMIC_XPP_TOP_INT_CON0_SET_SHIFT 0
#define PMIC_XPP_TOP_INT_CON0_CLR_ADDR MT6356_XPP_TOP_INT_CON0_CLR
#define PMIC_XPP_TOP_INT_CON0_CLR_MASK 0xFFFF
#define PMIC_XPP_TOP_INT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_TYPE_C_CC_IRQ_ADDR MT6356_XPP_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_TYPE_C_CC_IRQ_MASK 0x1
#define PMIC_RG_INT_MASK_TYPE_C_CC_IRQ_SHIFT 0
#define PMIC_RG_INT_MASK_XPP_RSV0_ADDR MT6356_XPP_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_XPP_RSV0_MASK 0x1
#define PMIC_RG_INT_MASK_XPP_RSV0_SHIFT 1
#define PMIC_RG_INT_MASK_XPP_RSV1_ADDR MT6356_XPP_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_XPP_RSV1_MASK 0x1
#define PMIC_RG_INT_MASK_XPP_RSV1_SHIFT 2
#define PMIC_XPP_TOP_INT_MASK_CON0_SET_ADDR MT6356_XPP_TOP_INT_MASK_CON0_SET
#define PMIC_XPP_TOP_INT_MASK_CON0_SET_MASK 0xFFFF
#define PMIC_XPP_TOP_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_XPP_TOP_INT_MASK_CON0_CLR_ADDR MT6356_XPP_TOP_INT_MASK_CON0_CLR
#define PMIC_XPP_TOP_INT_MASK_CON0_CLR_MASK 0xFFFF
#define PMIC_XPP_TOP_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_STATUS_TYPE_C_CC_IRQ_ADDR MT6356_XPP_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_TYPE_C_CC_IRQ_MASK 0x1
#define PMIC_RG_INT_STATUS_TYPE_C_CC_IRQ_SHIFT 0
#define PMIC_RG_INT_STATUS_XPP_RSV0_ADDR MT6356_XPP_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_XPP_RSV0_MASK 0x1
#define PMIC_RG_INT_STATUS_XPP_RSV0_SHIFT 1
#define PMIC_RG_INT_STATUS_XPP_RSV1_ADDR MT6356_XPP_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_XPP_RSV1_MASK 0x1
#define PMIC_RG_INT_STATUS_XPP_RSV1_SHIFT 2
#define PMIC_RG_INT_RAW_STATUS_TYPE_C_CC_IRQ_ADDR                             \
	MT6356_XPP_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_TYPE_C_CC_IRQ_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_TYPE_C_CC_IRQ_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_XPP_RSV0_ADDR MT6356_XPP_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_XPP_RSV0_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_XPP_RSV0_SHIFT 1
#define PMIC_RG_INT_RAW_STATUS_XPP_RSV1_ADDR MT6356_XPP_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_XPP_RSV1_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_XPP_RSV1_SHIFT 2
#define PMIC_XPP_TOP_POLARITY_ADDR MT6356_XPP_TOP_INT_MISC_CON
#define PMIC_XPP_TOP_POLARITY_MASK 0x1
#define PMIC_XPP_TOP_POLARITY_SHIFT 0
#define PMIC_DRIVER_BL_ANA_ID_ADDR MT6356_DRIVER_BL_DSN_ID
#define PMIC_DRIVER_BL_ANA_ID_MASK 0xFF
#define PMIC_DRIVER_BL_ANA_ID_SHIFT 0
#define PMIC_DRIVER_BL_DIG_ID_ADDR MT6356_DRIVER_BL_DSN_ID
#define PMIC_DRIVER_BL_DIG_ID_MASK 0xFF
#define PMIC_DRIVER_BL_DIG_ID_SHIFT 8
#define PMIC_DRIVER_BL_ANA_MINOR_REV_ADDR MT6356_DRIVER_BL_DSN_REV0
#define PMIC_DRIVER_BL_ANA_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_BL_ANA_MINOR_REV_SHIFT 0
#define PMIC_DRIVER_BL_ANA_MAJOR_REV_ADDR MT6356_DRIVER_BL_DSN_REV0
#define PMIC_DRIVER_BL_ANA_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_BL_ANA_MAJOR_REV_SHIFT 4
#define PMIC_DRIVER_BL_DIG_MINOR_REV_ADDR MT6356_DRIVER_BL_DSN_REV0
#define PMIC_DRIVER_BL_DIG_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_BL_DIG_MINOR_REV_SHIFT 8
#define PMIC_DRIVER_BL_DIG_MAJOR_REV_ADDR MT6356_DRIVER_BL_DSN_REV0
#define PMIC_DRIVER_BL_DIG_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_BL_DIG_MAJOR_REV_SHIFT 12
#define PMIC_DRIVER_BL_SW_MINOR_REV_ADDR MT6356_DRIVER_BL_DSN_REV1
#define PMIC_DRIVER_BL_SW_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_BL_SW_MINOR_REV_SHIFT 0
#define PMIC_DRIVER_BL_SW_MAJOR_REV_ADDR MT6356_DRIVER_BL_DSN_REV1
#define PMIC_DRIVER_BL_SW_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_BL_SW_MAJOR_REV_SHIFT 4
#define PMIC_DRIVER_BL_ESP_ADDR MT6356_DRIVER_BL_DSN_REV1
#define PMIC_DRIVER_BL_ESP_MASK 0xFF
#define PMIC_DRIVER_BL_ESP_SHIFT 8
#define PMIC_ISINK_DIM0_FSEL_ADDR MT6356_ISINK0_CON0
#define PMIC_ISINK_DIM0_FSEL_MASK 0xFFFF
#define PMIC_ISINK_DIM0_FSEL_SHIFT 0
#define PMIC_ISINK0_RSV1_ADDR MT6356_ISINK0_CON1
#define PMIC_ISINK0_RSV1_MASK 0xF
#define PMIC_ISINK0_RSV1_SHIFT 0
#define PMIC_ISINK_DIM0_DUTY_ADDR MT6356_ISINK0_CON1
#define PMIC_ISINK_DIM0_DUTY_MASK 0xFF
#define PMIC_ISINK_DIM0_DUTY_SHIFT 4
#define PMIC_ISINK_CH0_STEP_ADDR MT6356_ISINK0_CON1
#define PMIC_ISINK_CH0_STEP_MASK 0x7
#define PMIC_ISINK_CH0_STEP_SHIFT 12
#define PMIC_ISINK_BREATH0_TF2_SEL_ADDR MT6356_ISINK0_CON2
#define PMIC_ISINK_BREATH0_TF2_SEL_MASK 0xF
#define PMIC_ISINK_BREATH0_TF2_SEL_SHIFT 0
#define PMIC_ISINK_BREATH0_TF1_SEL_ADDR MT6356_ISINK0_CON2
#define PMIC_ISINK_BREATH0_TF1_SEL_MASK 0xF
#define PMIC_ISINK_BREATH0_TF1_SEL_SHIFT 4
#define PMIC_ISINK_BREATH0_TR2_SEL_ADDR MT6356_ISINK0_CON2
#define PMIC_ISINK_BREATH0_TR2_SEL_MASK 0xF
#define PMIC_ISINK_BREATH0_TR2_SEL_SHIFT 8
#define PMIC_ISINK_BREATH0_TR1_SEL_ADDR MT6356_ISINK0_CON2
#define PMIC_ISINK_BREATH0_TR1_SEL_MASK 0xF
#define PMIC_ISINK_BREATH0_TR1_SEL_SHIFT 12
#define PMIC_ISINK_BREATH0_TOFF_SEL_ADDR MT6356_ISINK0_CON3
#define PMIC_ISINK_BREATH0_TOFF_SEL_MASK 0xF
#define PMIC_ISINK_BREATH0_TOFF_SEL_SHIFT 0
#define PMIC_ISINK_BREATH0_TON_SEL_ADDR MT6356_ISINK0_CON3
#define PMIC_ISINK_BREATH0_TON_SEL_MASK 0xF
#define PMIC_ISINK_BREATH0_TON_SEL_SHIFT 8
#define PMIC_ISINK_DIM1_FSEL_ADDR MT6356_ISINK1_CON0
#define PMIC_ISINK_DIM1_FSEL_MASK 0xFFFF
#define PMIC_ISINK_DIM1_FSEL_SHIFT 0
#define PMIC_ISINK1_RSV1_ADDR MT6356_ISINK1_CON1
#define PMIC_ISINK1_RSV1_MASK 0xF
#define PMIC_ISINK1_RSV1_SHIFT 0
#define PMIC_ISINK_DIM1_DUTY_ADDR MT6356_ISINK1_CON1
#define PMIC_ISINK_DIM1_DUTY_MASK 0xFF
#define PMIC_ISINK_DIM1_DUTY_SHIFT 4
#define PMIC_ISINK_CH1_STEP_ADDR MT6356_ISINK1_CON1
#define PMIC_ISINK_CH1_STEP_MASK 0x7
#define PMIC_ISINK_CH1_STEP_SHIFT 12
#define PMIC_ISINK_BREATH1_TF2_SEL_ADDR MT6356_ISINK1_CON2
#define PMIC_ISINK_BREATH1_TF2_SEL_MASK 0xF
#define PMIC_ISINK_BREATH1_TF2_SEL_SHIFT 0
#define PMIC_ISINK_BREATH1_TF1_SEL_ADDR MT6356_ISINK1_CON2
#define PMIC_ISINK_BREATH1_TF1_SEL_MASK 0xF
#define PMIC_ISINK_BREATH1_TF1_SEL_SHIFT 4
#define PMIC_ISINK_BREATH1_TR2_SEL_ADDR MT6356_ISINK1_CON2
#define PMIC_ISINK_BREATH1_TR2_SEL_MASK 0xF
#define PMIC_ISINK_BREATH1_TR2_SEL_SHIFT 8
#define PMIC_ISINK_BREATH1_TR1_SEL_ADDR MT6356_ISINK1_CON2
#define PMIC_ISINK_BREATH1_TR1_SEL_MASK 0xF
#define PMIC_ISINK_BREATH1_TR1_SEL_SHIFT 12
#define PMIC_ISINK_BREATH1_TOFF_SEL_ADDR MT6356_ISINK1_CON3
#define PMIC_ISINK_BREATH1_TOFF_SEL_MASK 0xF
#define PMIC_ISINK_BREATH1_TOFF_SEL_SHIFT 0
#define PMIC_ISINK_BREATH1_TON_SEL_ADDR MT6356_ISINK1_CON3
#define PMIC_ISINK_BREATH1_TON_SEL_MASK 0xF
#define PMIC_ISINK_BREATH1_TON_SEL_SHIFT 8
#define PMIC_AD_ISINK3_STATUS_ADDR MT6356_ISINK_ANA1
#define PMIC_AD_ISINK3_STATUS_MASK 0x1
#define PMIC_AD_ISINK3_STATUS_SHIFT 0
#define PMIC_AD_ISINK2_STATUS_ADDR MT6356_ISINK_ANA1
#define PMIC_AD_ISINK2_STATUS_MASK 0x1
#define PMIC_AD_ISINK2_STATUS_SHIFT 1
#define PMIC_AD_ISINK1_STATUS_ADDR MT6356_ISINK_ANA1
#define PMIC_AD_ISINK1_STATUS_MASK 0x1
#define PMIC_AD_ISINK1_STATUS_SHIFT 2
#define PMIC_AD_ISINK0_STATUS_ADDR MT6356_ISINK_ANA1
#define PMIC_AD_ISINK0_STATUS_MASK 0x1
#define PMIC_AD_ISINK0_STATUS_SHIFT 3
#define PMIC_ISINK_PHASE0_DLY_EN_ADDR MT6356_ISINK_PHASE_DLY
#define PMIC_ISINK_PHASE0_DLY_EN_MASK 0x1
#define PMIC_ISINK_PHASE0_DLY_EN_SHIFT 0
#define PMIC_ISINK_PHASE1_DLY_EN_ADDR MT6356_ISINK_PHASE_DLY
#define PMIC_ISINK_PHASE1_DLY_EN_MASK 0x1
#define PMIC_ISINK_PHASE1_DLY_EN_SHIFT 1
#define PMIC_ISINK_PHASE0_DLY_TC_ADDR MT6356_ISINK_PHASE_DLY
#define PMIC_ISINK_PHASE0_DLY_TC_MASK 0x3
#define PMIC_ISINK_PHASE0_DLY_TC_SHIFT 4
#define PMIC_ISINK_PHASE1_DLY_TC_ADDR MT6356_ISINK_PHASE_DLY
#define PMIC_ISINK_PHASE1_DLY_TC_MASK 0x3
#define PMIC_ISINK_PHASE1_DLY_TC_SHIFT 6
#define PMIC_ISINK_CHOP0_SW_ADDR MT6356_ISINK_PHASE_DLY
#define PMIC_ISINK_CHOP0_SW_MASK 0x1
#define PMIC_ISINK_CHOP0_SW_SHIFT 14
#define PMIC_ISINK_CHOP1_SW_ADDR MT6356_ISINK_PHASE_DLY
#define PMIC_ISINK_CHOP1_SW_MASK 0x1
#define PMIC_ISINK_CHOP1_SW_SHIFT 15
#define PMIC_ISINK_SFSTR1_EN_ADDR MT6356_ISINK_SFSTR
#define PMIC_ISINK_SFSTR1_EN_MASK 0x1
#define PMIC_ISINK_SFSTR1_EN_SHIFT 8
#define PMIC_ISINK_SFSTR1_TC_ADDR MT6356_ISINK_SFSTR
#define PMIC_ISINK_SFSTR1_TC_MASK 0x3
#define PMIC_ISINK_SFSTR1_TC_SHIFT 9
#define PMIC_ISINK_SFSTR0_EN_ADDR MT6356_ISINK_SFSTR
#define PMIC_ISINK_SFSTR0_EN_MASK 0x1
#define PMIC_ISINK_SFSTR0_EN_SHIFT 12
#define PMIC_ISINK_SFSTR0_TC_ADDR MT6356_ISINK_SFSTR
#define PMIC_ISINK_SFSTR0_TC_MASK 0x3
#define PMIC_ISINK_SFSTR0_TC_SHIFT 13
#define PMIC_ISINK_CH0_EN_ADDR MT6356_ISINK_EN_CTRL
#define PMIC_ISINK_CH0_EN_MASK 0x1
#define PMIC_ISINK_CH0_EN_SHIFT 0
#define PMIC_ISINK_CH1_EN_ADDR MT6356_ISINK_EN_CTRL
#define PMIC_ISINK_CH1_EN_MASK 0x1
#define PMIC_ISINK_CH1_EN_SHIFT 1
#define PMIC_ISINK_CHOP0_EN_ADDR MT6356_ISINK_EN_CTRL
#define PMIC_ISINK_CHOP0_EN_MASK 0x1
#define PMIC_ISINK_CHOP0_EN_SHIFT 4
#define PMIC_ISINK_CHOP1_EN_ADDR MT6356_ISINK_EN_CTRL
#define PMIC_ISINK_CHOP1_EN_MASK 0x1
#define PMIC_ISINK_CHOP1_EN_SHIFT 5
#define PMIC_ISINK_CH0_BIAS_EN_ADDR MT6356_ISINK_EN_CTRL
#define PMIC_ISINK_CH0_BIAS_EN_MASK 0x1
#define PMIC_ISINK_CH0_BIAS_EN_SHIFT 10
#define PMIC_ISINK_CH1_BIAS_EN_ADDR MT6356_ISINK_EN_CTRL
#define PMIC_ISINK_CH1_BIAS_EN_MASK 0x1
#define PMIC_ISINK_CH1_BIAS_EN_SHIFT 11
#define PMIC_ISINK_RSV_ADDR MT6356_ISINK_MODE_CTRL
#define PMIC_ISINK_RSV_MASK 0x1F
#define PMIC_ISINK_RSV_SHIFT 0
#define PMIC_ISINK_CH1_MODE_ADDR MT6356_ISINK_MODE_CTRL
#define PMIC_ISINK_CH1_MODE_MASK 0x3
#define PMIC_ISINK_CH1_MODE_SHIFT 12
#define PMIC_ISINK_CH0_MODE_ADDR MT6356_ISINK_MODE_CTRL
#define PMIC_ISINK_CH0_MODE_MASK 0x3
#define PMIC_ISINK_CH0_MODE_SHIFT 14
#define PMIC_ISINK_CH0_PWM_MODE_ADDR MT6356_ISINK_PWM_CTRL
#define PMIC_ISINK_CH0_PWM_MODE_MASK 0x1
#define PMIC_ISINK_CH0_PWM_MODE_SHIFT 0
#define PMIC_ISINK_CH1_PWM_MODE_ADDR MT6356_ISINK_PWM_CTRL
#define PMIC_ISINK_CH1_PWM_MODE_MASK 0x1
#define PMIC_ISINK_CH1_PWM_MODE_SHIFT 1
#define PMIC_DA_ISINK0_STEP_ADDR MT6356_ISINK_ANA_CON0
#define PMIC_DA_ISINK0_STEP_MASK 0x7
#define PMIC_DA_ISINK0_STEP_SHIFT 0
#define PMIC_DA_ISINK1_STEP_ADDR MT6356_ISINK_ANA_CON0
#define PMIC_DA_ISINK1_STEP_MASK 0x7
#define PMIC_DA_ISINK1_STEP_SHIFT 3
#define PMIC_DA_ISINK2_STEP_ADDR MT6356_ISINK_ANA_CON0
#define PMIC_DA_ISINK2_STEP_MASK 0x7
#define PMIC_DA_ISINK2_STEP_SHIFT 6
#define PMIC_DA_ISINK3_STEP_ADDR MT6356_ISINK_ANA_CON0
#define PMIC_DA_ISINK3_STEP_MASK 0x7
#define PMIC_DA_ISINK3_STEP_SHIFT 9
#define PMIC_DRIVER_CI_ANA_ID_ADDR MT6356_DRIVER_CI_DSN_ID
#define PMIC_DRIVER_CI_ANA_ID_MASK 0xFF
#define PMIC_DRIVER_CI_ANA_ID_SHIFT 0
#define PMIC_DRIVER_CI_DIG_ID_ADDR MT6356_DRIVER_CI_DSN_ID
#define PMIC_DRIVER_CI_DIG_ID_MASK 0xFF
#define PMIC_DRIVER_CI_DIG_ID_SHIFT 8
#define PMIC_DRIVER_CI_ANA_MINOR_REV_ADDR MT6356_DRIVER_CI_DSN_REV0
#define PMIC_DRIVER_CI_ANA_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_CI_ANA_MINOR_REV_SHIFT 0
#define PMIC_DRIVER_CI_ANA_MAJOR_REV_ADDR MT6356_DRIVER_CI_DSN_REV0
#define PMIC_DRIVER_CI_ANA_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_CI_ANA_MAJOR_REV_SHIFT 4
#define PMIC_DRIVER_CI_DIG_MINOR_REV_ADDR MT6356_DRIVER_CI_DSN_REV0
#define PMIC_DRIVER_CI_DIG_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_CI_DIG_MINOR_REV_SHIFT 8
#define PMIC_DRIVER_CI_DIG_MAJOR_REV_ADDR MT6356_DRIVER_CI_DSN_REV0
#define PMIC_DRIVER_CI_DIG_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_CI_DIG_MAJOR_REV_SHIFT 12
#define PMIC_DRIVER_CI_SW_MINOR_REV_ADDR MT6356_DRIVER_CI_DSN_REV1
#define PMIC_DRIVER_CI_SW_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_CI_SW_MINOR_REV_SHIFT 0
#define PMIC_DRIVER_CI_SW_MAJOR_REV_ADDR MT6356_DRIVER_CI_DSN_REV1
#define PMIC_DRIVER_CI_SW_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_CI_SW_MAJOR_REV_SHIFT 4
#define PMIC_DRIVER_CI_ESP_ADDR MT6356_DRIVER_CI_DSN_REV1
#define PMIC_DRIVER_CI_ESP_MASK 0xFF
#define PMIC_DRIVER_CI_ESP_SHIFT 8
#define PMIC_CHRIND_DIM_FSEL_ADDR MT6356_CHRIND_CON0
#define PMIC_CHRIND_DIM_FSEL_MASK 0xFFFF
#define PMIC_CHRIND_DIM_FSEL_SHIFT 0
#define PMIC_CHRIND_DIM_DUTY_ADDR MT6356_CHRIND_CON1
#define PMIC_CHRIND_DIM_DUTY_MASK 0xFF
#define PMIC_CHRIND_DIM_DUTY_SHIFT 0
#define PMIC_CHRIND_RSV1_ADDR MT6356_CHRIND_CON2
#define PMIC_CHRIND_RSV1_MASK 0xF
#define PMIC_CHRIND_RSV1_SHIFT 0
#define PMIC_CHRIND_RSV0_ADDR MT6356_CHRIND_CON2
#define PMIC_CHRIND_RSV0_MASK 0x7
#define PMIC_CHRIND_RSV0_SHIFT 4
#define PMIC_CHRIND_STEP_ADDR MT6356_CHRIND_CON2
#define PMIC_CHRIND_STEP_MASK 0x7
#define PMIC_CHRIND_STEP_SHIFT 12
#define PMIC_CHRIND_PWM_MODE_ADDR MT6356_CHRIND_CON2
#define PMIC_CHRIND_PWM_MODE_MASK 0x1
#define PMIC_CHRIND_PWM_MODE_SHIFT 15
#define PMIC_CHRIND_BREATH_TF2_SEL_ADDR MT6356_CHRIND_CON3
#define PMIC_CHRIND_BREATH_TF2_SEL_MASK 0xF
#define PMIC_CHRIND_BREATH_TF2_SEL_SHIFT 0
#define PMIC_CHRIND_BREATH_TF1_SEL_ADDR MT6356_CHRIND_CON3
#define PMIC_CHRIND_BREATH_TF1_SEL_MASK 0xF
#define PMIC_CHRIND_BREATH_TF1_SEL_SHIFT 4
#define PMIC_CHRIND_BREATH_TR2_SEL_ADDR MT6356_CHRIND_CON3
#define PMIC_CHRIND_BREATH_TR2_SEL_MASK 0xF
#define PMIC_CHRIND_BREATH_TR2_SEL_SHIFT 8
#define PMIC_CHRIND_BREATH_TR1_SEL_ADDR MT6356_CHRIND_CON3
#define PMIC_CHRIND_BREATH_TR1_SEL_MASK 0xF
#define PMIC_CHRIND_BREATH_TR1_SEL_SHIFT 12
#define PMIC_CHRIND_BREATH_TOFF_SEL_ADDR MT6356_CHRIND_CON4
#define PMIC_CHRIND_BREATH_TOFF_SEL_MASK 0xF
#define PMIC_CHRIND_BREATH_TOFF_SEL_SHIFT 0
#define PMIC_CHRIND_BREATH_TON_SEL_ADDR MT6356_CHRIND_CON4
#define PMIC_CHRIND_BREATH_TON_SEL_MASK 0xF
#define PMIC_CHRIND_BREATH_TON_SEL_SHIFT 8
#define PMIC_CHRIND_SFSTR_EN_ADDR MT6356_CHRIND_EN_CTRL
#define PMIC_CHRIND_SFSTR_EN_MASK 0x1
#define PMIC_CHRIND_SFSTR_EN_SHIFT 0
#define PMIC_CHRIND_SFSTR_TC_ADDR MT6356_CHRIND_EN_CTRL
#define PMIC_CHRIND_SFSTR_TC_MASK 0x3
#define PMIC_CHRIND_SFSTR_TC_SHIFT 1
#define PMIC_CHRIND_EN_SEL_ADDR MT6356_CHRIND_EN_CTRL
#define PMIC_CHRIND_EN_SEL_MASK 0x1
#define PMIC_CHRIND_EN_SEL_SHIFT 3
#define PMIC_CHRIND_EN_ADDR MT6356_CHRIND_EN_CTRL
#define PMIC_CHRIND_EN_MASK 0x1
#define PMIC_CHRIND_EN_SHIFT 4
#define PMIC_CHRIND_CHOP_EN_ADDR MT6356_CHRIND_EN_CTRL
#define PMIC_CHRIND_CHOP_EN_MASK 0x1
#define PMIC_CHRIND_CHOP_EN_SHIFT 5
#define PMIC_CHRIND_MODE_ADDR MT6356_CHRIND_EN_CTRL
#define PMIC_CHRIND_MODE_MASK 0x3
#define PMIC_CHRIND_MODE_SHIFT 6
#define PMIC_CHRIND_CHOP_SW_ADDR MT6356_CHRIND_EN_CTRL
#define PMIC_CHRIND_CHOP_SW_MASK 0x1
#define PMIC_CHRIND_CHOP_SW_SHIFT 8
#define PMIC_CHRIND_BIAS_EN_ADDR MT6356_CHRIND_EN_CTRL
#define PMIC_CHRIND_BIAS_EN_MASK 0x1
#define PMIC_CHRIND_BIAS_EN_SHIFT 9
#define PMIC_CHRIND_MODE_SEL_ADDR MT6356_CHRIND_EN_CTRL
#define PMIC_CHRIND_MODE_SEL_MASK 0x1
#define PMIC_CHRIND_MODE_SEL_SHIFT 15
#define PMIC_DRIVER_DL_ANA_ID_ADDR MT6356_DRIVER_DL_DSN_ID
#define PMIC_DRIVER_DL_ANA_ID_MASK 0xFF
#define PMIC_DRIVER_DL_ANA_ID_SHIFT 0
#define PMIC_DRIVER_DL_DIG_ID_ADDR MT6356_DRIVER_DL_DSN_ID
#define PMIC_DRIVER_DL_DIG_ID_MASK 0xFF
#define PMIC_DRIVER_DL_DIG_ID_SHIFT 8
#define PMIC_DRIVER_DL_ANA_MINOR_REV_ADDR MT6356_DRIVER_DL_DSN_REV0
#define PMIC_DRIVER_DL_ANA_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_DL_ANA_MINOR_REV_SHIFT 0
#define PMIC_DRIVER_DL_ANA_MAJOR_REV_ADDR MT6356_DRIVER_DL_DSN_REV0
#define PMIC_DRIVER_DL_ANA_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_DL_ANA_MAJOR_REV_SHIFT 4
#define PMIC_DRIVER_DL_DIG_MINOR_REV_ADDR MT6356_DRIVER_DL_DSN_REV0
#define PMIC_DRIVER_DL_DIG_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_DL_DIG_MINOR_REV_SHIFT 8
#define PMIC_DRIVER_DL_DIG_MAJOR_REV_ADDR MT6356_DRIVER_DL_DSN_REV0
#define PMIC_DRIVER_DL_DIG_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_DL_DIG_MAJOR_REV_SHIFT 12
#define PMIC_DRIVER_DL_SW_MINOR_REV_ADDR MT6356_DRIVER_DL_DSN_REV1
#define PMIC_DRIVER_DL_SW_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_DL_SW_MINOR_REV_SHIFT 0
#define PMIC_DRIVER_DL_SW_MAJOR_REV_ADDR MT6356_DRIVER_DL_DSN_REV1
#define PMIC_DRIVER_DL_SW_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_DL_SW_MAJOR_REV_SHIFT 4
#define PMIC_DRIVER_DL_ESP_ADDR MT6356_DRIVER_DL_DSN_REV1
#define PMIC_DRIVER_DL_ESP_MASK 0xFF
#define PMIC_DRIVER_DL_ESP_SHIFT 8
#define PMIC_ISINK2_RSV1_ADDR MT6356_ISINK2_CON0
#define PMIC_ISINK2_RSV1_MASK 0xF
#define PMIC_ISINK2_RSV1_SHIFT 0
#define PMIC_ISINK2_RSV0_ADDR MT6356_ISINK2_CON0
#define PMIC_ISINK2_RSV0_MASK 0x7
#define PMIC_ISINK2_RSV0_SHIFT 4
#define PMIC_ISINK_CH2_STEP_ADDR MT6356_ISINK2_CON0
#define PMIC_ISINK_CH2_STEP_MASK 0x7
#define PMIC_ISINK_CH2_STEP_SHIFT 12
#define PMIC_ISINK3_RSV1_ADDR MT6356_ISINK3_CON0
#define PMIC_ISINK3_RSV1_MASK 0xF
#define PMIC_ISINK3_RSV1_SHIFT 0
#define PMIC_ISINK3_RSV0_ADDR MT6356_ISINK3_CON0
#define PMIC_ISINK3_RSV0_MASK 0x7
#define PMIC_ISINK3_RSV0_SHIFT 4
#define PMIC_ISINK_CH3_STEP_ADDR MT6356_ISINK3_CON0
#define PMIC_ISINK_CH3_STEP_MASK 0x7
#define PMIC_ISINK_CH3_STEP_SHIFT 12
#define PMIC_ISINK_CHOP3_SW_ADDR MT6356_ISINK_CHOPSW_CON0
#define PMIC_ISINK_CHOP3_SW_MASK 0x1
#define PMIC_ISINK_CHOP3_SW_SHIFT 14
#define PMIC_ISINK_CHOP2_SW_ADDR MT6356_ISINK_CHOPSW_CON0
#define PMIC_ISINK_CHOP2_SW_MASK 0x1
#define PMIC_ISINK_CHOP2_SW_SHIFT 15
#define PMIC_ISINK_CH3_EN_ADDR MT6356_ISINK_EN_CTRL_SMPL
#define PMIC_ISINK_CH3_EN_MASK 0x1
#define PMIC_ISINK_CH3_EN_SHIFT 2
#define PMIC_ISINK_CH2_EN_ADDR MT6356_ISINK_EN_CTRL_SMPL
#define PMIC_ISINK_CH2_EN_MASK 0x1
#define PMIC_ISINK_CH2_EN_SHIFT 3
#define PMIC_ISINK_CHOP3_EN_ADDR MT6356_ISINK_EN_CTRL_SMPL
#define PMIC_ISINK_CHOP3_EN_MASK 0x1
#define PMIC_ISINK_CHOP3_EN_SHIFT 6
#define PMIC_ISINK_CHOP2_EN_ADDR MT6356_ISINK_EN_CTRL_SMPL
#define PMIC_ISINK_CHOP2_EN_MASK 0x1
#define PMIC_ISINK_CHOP2_EN_SHIFT 7
#define PMIC_ISINK_CH3_BIAS_EN_ADDR MT6356_ISINK_EN_CTRL_SMPL
#define PMIC_ISINK_CH3_BIAS_EN_MASK 0x1
#define PMIC_ISINK_CH3_BIAS_EN_SHIFT 10
#define PMIC_ISINK_CH2_BIAS_EN_ADDR MT6356_ISINK_EN_CTRL_SMPL
#define PMIC_ISINK_CH2_BIAS_EN_MASK 0x1
#define PMIC_ISINK_CH2_BIAS_EN_SHIFT 11
#define PMIC_DRIVER_ANA_ANA_ID_ADDR MT6356_DRIVER_DSN_ID
#define PMIC_DRIVER_ANA_ANA_ID_MASK 0xFF
#define PMIC_DRIVER_ANA_ANA_ID_SHIFT 0
#define PMIC_DRIVER_ANA_DIG_ID_ADDR MT6356_DRIVER_DSN_ID
#define PMIC_DRIVER_ANA_DIG_ID_MASK 0xFF
#define PMIC_DRIVER_ANA_DIG_ID_SHIFT 8
#define PMIC_DRIVER_ANA_ANA_MINOR_REV_ADDR MT6356_DRIVER_DSN_REV0
#define PMIC_DRIVER_ANA_ANA_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_ANA_ANA_MINOR_REV_SHIFT 0
#define PMIC_DRIVER_ANA_ANA_MAJOR_REV_ADDR MT6356_DRIVER_DSN_REV0
#define PMIC_DRIVER_ANA_ANA_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_ANA_ANA_MAJOR_REV_SHIFT 4
#define PMIC_DRIVER_ANA_DIG_MINOR_REV_ADDR MT6356_DRIVER_DSN_REV0
#define PMIC_DRIVER_ANA_DIG_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_ANA_DIG_MINOR_REV_SHIFT 8
#define PMIC_DRIVER_ANA_DIG_MAJOR_REV_ADDR MT6356_DRIVER_DSN_REV0
#define PMIC_DRIVER_ANA_DIG_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_ANA_DIG_MAJOR_REV_SHIFT 12
#define PMIC_DRIVER_ANA_SW_MINOR_REV_ADDR MT6356_DRIVER_DSN_REV1
#define PMIC_DRIVER_ANA_SW_MINOR_REV_MASK 0xF
#define PMIC_DRIVER_ANA_SW_MINOR_REV_SHIFT 0
#define PMIC_DRIVER_ANA_SW_MAJOR_REV_ADDR MT6356_DRIVER_DSN_REV1
#define PMIC_DRIVER_ANA_SW_MAJOR_REV_MASK 0xF
#define PMIC_DRIVER_ANA_SW_MAJOR_REV_SHIFT 4
#define PMIC_DRIVER_ANA_ESP_ADDR MT6356_DRIVER_DSN_REV1
#define PMIC_DRIVER_ANA_ESP_MASK 0xFF
#define PMIC_DRIVER_ANA_ESP_SHIFT 8
#define PMIC_RG_ISINK_TRIM_EN_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK_TRIM_EN_MASK 0x1
#define PMIC_RG_ISINK_TRIM_EN_SHIFT 0
#define PMIC_RG_ISINK_TRIM_SEL_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK_TRIM_SEL_MASK 0x7
#define PMIC_RG_ISINK_TRIM_SEL_SHIFT 1
#define PMIC_RG_ISINK_RSV_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK_RSV_MASK 0xF
#define PMIC_RG_ISINK_RSV_SHIFT 4
#define PMIC_RG_ISINK0_CHOP_EN_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK0_CHOP_EN_MASK 0x1
#define PMIC_RG_ISINK0_CHOP_EN_SHIFT 8
#define PMIC_RG_ISINK1_CHOP_EN_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK1_CHOP_EN_MASK 0x1
#define PMIC_RG_ISINK1_CHOP_EN_SHIFT 9
#define PMIC_RG_ISINK2_CHOP_EN_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK2_CHOP_EN_MASK 0x1
#define PMIC_RG_ISINK2_CHOP_EN_SHIFT 10
#define PMIC_RG_ISINK3_CHOP_EN_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK3_CHOP_EN_MASK 0x1
#define PMIC_RG_ISINK3_CHOP_EN_SHIFT 11
#define PMIC_RG_ISINK0_DOUBLE_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK0_DOUBLE_MASK 0x1
#define PMIC_RG_ISINK0_DOUBLE_SHIFT 12
#define PMIC_RG_ISINK1_DOUBLE_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK1_DOUBLE_MASK 0x1
#define PMIC_RG_ISINK1_DOUBLE_SHIFT 13
#define PMIC_RG_ISINK2_DOUBLE_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK2_DOUBLE_MASK 0x1
#define PMIC_RG_ISINK2_DOUBLE_SHIFT 14
#define PMIC_RG_ISINK3_DOUBLE_ADDR MT6356_DRIVER_ANA_CON0
#define PMIC_RG_ISINK3_DOUBLE_MASK 0x1
#define PMIC_RG_ISINK3_DOUBLE_SHIFT 15
#define PMIC_DRIVER_ANA_ELR_LEN_ADDR MT6356_DRIVER_ANA_ELR_NUM
#define PMIC_DRIVER_ANA_ELR_LEN_MASK 0xFF
#define PMIC_DRIVER_ANA_ELR_LEN_SHIFT 0
#define PMIC_RG_ISINK_TRIM_BIAS_ADDR MT6356_DRIVER_ANA_ELR_0
#define PMIC_RG_ISINK_TRIM_BIAS_MASK 0x7
#define PMIC_RG_ISINK_TRIM_BIAS_SHIFT 0
#define PMIC_TYPE_C_ANA_ID_ADDR MT6356_TYPE_C_DIG_DSN_ID
#define PMIC_TYPE_C_ANA_ID_MASK 0xFF
#define PMIC_TYPE_C_ANA_ID_SHIFT 0
#define PMIC_TYPE_C_DIG_ID_ADDR MT6356_TYPE_C_DIG_DSN_ID
#define PMIC_TYPE_C_DIG_ID_MASK 0xFF
#define PMIC_TYPE_C_DIG_ID_SHIFT 8
#define PMIC_TYPE_C_ANA_MINOR_REV_ADDR MT6356_TYPE_C_DIG_DSN_REV0
#define PMIC_TYPE_C_ANA_MINOR_REV_MASK 0xF
#define PMIC_TYPE_C_ANA_MINOR_REV_SHIFT 0
#define PMIC_TYPE_C_ANA_MAJOR_REV_ADDR MT6356_TYPE_C_DIG_DSN_REV0
#define PMIC_TYPE_C_ANA_MAJOR_REV_MASK 0xF
#define PMIC_TYPE_C_ANA_MAJOR_REV_SHIFT 4
#define PMIC_TYPE_C_DIG_MINOR_REV_ADDR MT6356_TYPE_C_DIG_DSN_REV0
#define PMIC_TYPE_C_DIG_MINOR_REV_MASK 0xF
#define PMIC_TYPE_C_DIG_MINOR_REV_SHIFT 8
#define PMIC_TYPE_C_DIG_MAJOR_REV_ADDR MT6356_TYPE_C_DIG_DSN_REV0
#define PMIC_TYPE_C_DIG_MAJOR_REV_MASK 0xF
#define PMIC_TYPE_C_DIG_MAJOR_REV_SHIFT 12
#define PMIC_TYPE_C_SW_MINOR_REV_ADDR MT6356_TYPE_C_DIG_DSN_REV1
#define PMIC_TYPE_C_SW_MINOR_REV_MASK 0xF
#define PMIC_TYPE_C_SW_MINOR_REV_SHIFT 0
#define PMIC_TYPE_C_SW_MAJOR_REV_ADDR MT6356_TYPE_C_DIG_DSN_REV1
#define PMIC_TYPE_C_SW_MAJOR_REV_MASK 0xF
#define PMIC_TYPE_C_SW_MAJOR_REV_SHIFT 4
#define PMIC_TYPE_C_ESP_ADDR MT6356_TYPE_C_DIG_DSN_REV1
#define PMIC_TYPE_C_ESP_MASK 0xFF
#define PMIC_TYPE_C_ESP_SHIFT 8
#define PMIC_TYPE_C_PHY_RG_CC_RP_SEL_ADDR MT6356_TYPE_C_PHY_RG_0
#define PMIC_TYPE_C_PHY_RG_CC_RP_SEL_MASK 0x3
#define PMIC_TYPE_C_PHY_RG_CC_RP_SEL_SHIFT 0
#define PMIC_REG_TYPE_C_PHY_RG_CC_V2I_BYPASS_ADDR MT6356_TYPE_C_PHY_RG_0
#define PMIC_REG_TYPE_C_PHY_RG_CC_V2I_BYPASS_MASK 0x1
#define PMIC_REG_TYPE_C_PHY_RG_CC_V2I_BYPASS_SHIFT 2
#define PMIC_REG_TYPE_C_PHY_RG_CC_REFG_SEL_ADDR MT6356_TYPE_C_PHY_RG_0
#define PMIC_REG_TYPE_C_PHY_RG_CC_REFG_SEL_MASK 0x1
#define PMIC_REG_TYPE_C_PHY_RG_CC_REFG_SEL_SHIFT 3
#define PMIC_REG_TYPE_C_PHY_RG_CC_MPX_SEL_ADDR MT6356_TYPE_C_PHY_RG_0
#define PMIC_REG_TYPE_C_PHY_RG_CC_MPX_SEL_MASK 0xFF
#define PMIC_REG_TYPE_C_PHY_RG_CC_MPX_SEL_SHIFT 8
#define PMIC_REG_TYPE_C_PHY_RG_CC_RESERVE_ADDR                                \
	MT6356_TYPE_C_PHY_RG_CC_RESERVE_CSR
#define PMIC_REG_TYPE_C_PHY_RG_CC_RESERVE_MASK 0xFF
#define PMIC_REG_TYPE_C_PHY_RG_CC_RESERVE_SHIFT 0
#define PMIC_REG_TYPE_C_VCMP_CC2_SW_SEL_ST_CNT_VAL_ADDR MT6356_TYPE_C_VCMP_CTRL
#define PMIC_REG_TYPE_C_VCMP_CC2_SW_SEL_ST_CNT_VAL_MASK 0x1F
#define PMIC_REG_TYPE_C_VCMP_CC2_SW_SEL_ST_CNT_VAL_SHIFT 0
#define PMIC_REG_TYPE_C_VCMP_BIAS_EN_ST_CNT_VAL_ADDR MT6356_TYPE_C_VCMP_CTRL
#define PMIC_REG_TYPE_C_VCMP_BIAS_EN_ST_CNT_VAL_MASK 0x3
#define PMIC_REG_TYPE_C_VCMP_BIAS_EN_ST_CNT_VAL_SHIFT 5
#define PMIC_REG_TYPE_C_VCMP_DAC_EN_ST_CNT_VAL_ADDR MT6356_TYPE_C_VCMP_CTRL
#define PMIC_REG_TYPE_C_VCMP_DAC_EN_ST_CNT_VAL_MASK 0x1
#define PMIC_REG_TYPE_C_VCMP_DAC_EN_ST_CNT_VAL_SHIFT 7
#define PMIC_REG_TYPE_C_PORT_SUPPORT_ROLE_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_PORT_SUPPORT_ROLE_MASK 0x3
#define PMIC_REG_TYPE_C_PORT_SUPPORT_ROLE_SHIFT 0
#define PMIC_REG_TYPE_C_ADC_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_ADC_EN_MASK 0x1
#define PMIC_REG_TYPE_C_ADC_EN_SHIFT 2
#define PMIC_REG_TYPE_C_ACC_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_ACC_EN_MASK 0x1
#define PMIC_REG_TYPE_C_ACC_EN_SHIFT 3
#define PMIC_REG_TYPE_C_AUDIO_ACC_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_AUDIO_ACC_EN_MASK 0x1
#define PMIC_REG_TYPE_C_AUDIO_ACC_EN_SHIFT 4
#define PMIC_REG_TYPE_C_DEBUG_ACC_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_DEBUG_ACC_EN_MASK 0x1
#define PMIC_REG_TYPE_C_DEBUG_ACC_EN_SHIFT 5
#define PMIC_REG_TYPE_C_TRY_SRC_ST_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_TRY_SRC_ST_EN_MASK 0x1
#define PMIC_REG_TYPE_C_TRY_SRC_ST_EN_SHIFT 6
#define PMIC_REG_TYPE_C_TRY_SNK_ST_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_TRY_SNK_ST_EN_MASK 0x1
#define PMIC_REG_TYPE_C_TRY_SNK_ST_EN_SHIFT 7
#define PMIC_REG_TYPE_C_ATTACH_SRC_2_TRY_WAIT_SNK_ST_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_ATTACH_SRC_2_TRY_WAIT_SNK_ST_EN_MASK 0x1
#define PMIC_REG_TYPE_C_ATTACH_SRC_2_TRY_WAIT_SNK_ST_EN_SHIFT 8
#define PMIC_REG_TYPE_C_PD2CC_DET_DISABLE_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_PD2CC_DET_DISABLE_EN_MASK 0x1
#define PMIC_REG_TYPE_C_PD2CC_DET_DISABLE_EN_SHIFT 9
#define PMIC_REG_TYPE_C_ATTACH_SRC_OPEN_PDDEBOUNCE_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_ATTACH_SRC_OPEN_PDDEBOUNCE_EN_MASK 0x1
#define PMIC_REG_TYPE_C_ATTACH_SRC_OPEN_PDDEBOUNCE_EN_SHIFT 10
#define PMIC_REG_TYPE_C_DISABLE_ST_RD_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_DISABLE_ST_RD_EN_MASK 0x1
#define PMIC_REG_TYPE_C_DISABLE_ST_RD_EN_SHIFT 11
#define PMIC_REG_TYPE_C_DA_CC_SACLK_SW_EN_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_DA_CC_SACLK_SW_EN_MASK 0x1
#define PMIC_REG_TYPE_C_DA_CC_SACLK_SW_EN_SHIFT 12
#define PMIC_REG_TYPE_C_TRY_WAIT_SRC2ATTACH_SRC_DEB_SEL_ADDR MT6356_TYPE_C_CTRL
#define PMIC_REG_TYPE_C_TRY_WAIT_SRC2ATTACH_SRC_DEB_SEL_MASK 0x1
#define PMIC_REG_TYPE_C_TRY_WAIT_SRC2ATTACH_SRC_DEB_SEL_SHIFT 13
#define PMIC_W1_TYPE_C_SW_ENT_DISABLE_CMD_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_W1_TYPE_C_SW_ENT_DISABLE_CMD_MASK 0x1
#define PMIC_W1_TYPE_C_SW_ENT_DISABLE_CMD_SHIFT 0
#define PMIC_W1_TYPE_C_SW_ENT_UNATCH_SRC_CMD_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_W1_TYPE_C_SW_ENT_UNATCH_SRC_CMD_MASK 0x1
#define PMIC_W1_TYPE_C_SW_ENT_UNATCH_SRC_CMD_SHIFT 1
#define PMIC_W1_TYPE_C_SW_ENT_UNATCH_SNK_CMD_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_W1_TYPE_C_SW_ENT_UNATCH_SNK_CMD_MASK 0x1
#define PMIC_W1_TYPE_C_SW_ENT_UNATCH_SNK_CMD_SHIFT 2
#define PMIC_W1_TYPE_C_SW_PR_SWAP_INDICATE_CMD_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_W1_TYPE_C_SW_PR_SWAP_INDICATE_CMD_MASK 0x1
#define PMIC_W1_TYPE_C_SW_PR_SWAP_INDICATE_CMD_SHIFT 3
#define PMIC_W1_TYPE_C_SW_VCONN_SWAP_INDICATE_CMD_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_W1_TYPE_C_SW_VCONN_SWAP_INDICATE_CMD_MASK 0x1
#define PMIC_W1_TYPE_C_SW_VCONN_SWAP_INDICATE_CMD_SHIFT 4
#define PMIC_W1_TYPE_C_SW_ADC_RESULT_MET_VRD_DEFAULT_CMD_ADDR                 \
	MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_W1_TYPE_C_SW_ADC_RESULT_MET_VRD_DEFAULT_CMD_MASK 0x1
#define PMIC_W1_TYPE_C_SW_ADC_RESULT_MET_VRD_DEFAULT_CMD_SHIFT 5
#define PMIC_W1_TYPE_C_SW_ADC_RESULT_MET_VRD_15_CMD_ADDR                      \
	MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_W1_TYPE_C_SW_ADC_RESULT_MET_VRD_15_CMD_MASK 0x1
#define PMIC_W1_TYPE_C_SW_ADC_RESULT_MET_VRD_15_CMD_SHIFT 6
#define PMIC_W1_TYPE_C_SW_ADC_RESULT_MET_VRD_30_CMD_ADDR                      \
	MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_W1_TYPE_C_SW_ADC_RESULT_MET_VRD_30_CMD_MASK 0x1
#define PMIC_W1_TYPE_C_SW_ADC_RESULT_MET_VRD_30_CMD_SHIFT 7
#define PMIC_TYPE_C_SW_VBUS_PRESENT_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_TYPE_C_SW_VBUS_PRESENT_MASK 0x1
#define PMIC_TYPE_C_SW_VBUS_PRESENT_SHIFT 8
#define PMIC_TYPE_C_SW_DA_DRIVE_VCONN_EN_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_TYPE_C_SW_DA_DRIVE_VCONN_EN_MASK 0x1
#define PMIC_TYPE_C_SW_DA_DRIVE_VCONN_EN_SHIFT 9
#define PMIC_TYPE_C_SW_VBUS_DET_DIS_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_TYPE_C_SW_VBUS_DET_DIS_MASK 0x1
#define PMIC_TYPE_C_SW_VBUS_DET_DIS_SHIFT 10
#define PMIC_TYPE_C_SW_CC_DET_DIS_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_TYPE_C_SW_CC_DET_DIS_MASK 0x1
#define PMIC_TYPE_C_SW_CC_DET_DIS_SHIFT 11
#define PMIC_TYPE_C_SW_PD_EN_ADDR MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_TYPE_C_SW_PD_EN_MASK 0x1
#define PMIC_TYPE_C_SW_PD_EN_SHIFT 12
#define PMIC_W1_TYPE_C_SW_ENT_SNK_PWR_REDETECT_CMD_ADDR                       \
	MT6356_TYPE_C_CC_SW_CTRL
#define PMIC_W1_TYPE_C_SW_ENT_SNK_PWR_REDETECT_CMD_MASK 0x1
#define PMIC_W1_TYPE_C_SW_ENT_SNK_PWR_REDETECT_CMD_SHIFT 15
#define PMIC_REG_TYPE_C_CC_VOL_PERIODIC_MEAS_VAL_ADDR                         \
	MT6356_TYPE_C_CC_VOL_PERIODIC_MEAS_VAL
#define PMIC_REG_TYPE_C_CC_VOL_PERIODIC_MEAS_VAL_MASK 0x1FFF
#define PMIC_REG_TYPE_C_CC_VOL_PERIODIC_MEAS_VAL_SHIFT 0
#define PMIC_REG_TYPE_C_CC_VOL_CC_DEBOUNCE_CNT_VAL_ADDR                       \
	MT6356_TYPE_C_CC_VOL_DEBOUCE_CNT_VAL
#define PMIC_REG_TYPE_C_CC_VOL_CC_DEBOUNCE_CNT_VAL_MASK 0xFF
#define PMIC_REG_TYPE_C_CC_VOL_CC_DEBOUNCE_CNT_VAL_SHIFT 0
#define PMIC_REG_TYPE_C_CC_VOL_PD_DEBOUNCE_CNT_VAL_ADDR                       \
	MT6356_TYPE_C_CC_VOL_DEBOUCE_CNT_VAL
#define PMIC_REG_TYPE_C_CC_VOL_PD_DEBOUNCE_CNT_VAL_MASK 0x1F
#define PMIC_REG_TYPE_C_CC_VOL_PD_DEBOUNCE_CNT_VAL_SHIFT 8
#define PMIC_REG_TYPE_C_DRP_SRC_CNT_VAL_0_ADDR MT6356_TYPE_C_DRP_SRC_CNT_VAL_0
#define PMIC_REG_TYPE_C_DRP_SRC_CNT_VAL_0_MASK 0xFFFF
#define PMIC_REG_TYPE_C_DRP_SRC_CNT_VAL_0_SHIFT 0
#define PMIC_REG_TYPE_C_DRP_SNK_CNT_VAL_0_ADDR MT6356_TYPE_C_DRP_SNK_CNT_VAL_0
#define PMIC_REG_TYPE_C_DRP_SNK_CNT_VAL_0_MASK 0xFFFF
#define PMIC_REG_TYPE_C_DRP_SNK_CNT_VAL_0_SHIFT 0
#define PMIC_REG_TYPE_C_DRP_TRY_CNT_VAL_0_ADDR MT6356_TYPE_C_DRP_TRY_CNT_VAL_0
#define PMIC_REG_TYPE_C_DRP_TRY_CNT_VAL_0_MASK 0xFFFF
#define PMIC_REG_TYPE_C_DRP_TRY_CNT_VAL_0_SHIFT 0
#define PMIC_REG_TYPE_C_CC_SRC_VOPEN_DEFAULT_DAC_VAL_ADDR                     \
	MT6356_TYPE_C_CC_SRC_DEFAULT_DAC_VAL
#define PMIC_REG_TYPE_C_CC_SRC_VOPEN_DEFAULT_DAC_VAL_MASK 0x3F
#define PMIC_REG_TYPE_C_CC_SRC_VOPEN_DEFAULT_DAC_VAL_SHIFT 0
#define PMIC_REG_TYPE_C_CC_SRC_VRD_DEFAULT_DAC_VAL_ADDR                       \
	MT6356_TYPE_C_CC_SRC_DEFAULT_DAC_VAL
#define PMIC_REG_TYPE_C_CC_SRC_VRD_DEFAULT_DAC_VAL_MASK 0x3F
#define PMIC_REG_TYPE_C_CC_SRC_VRD_DEFAULT_DAC_VAL_SHIFT 8
#define PMIC_REG_TYPE_C_CC_SRC_VOPEN_15_DAC_VAL_ADDR                          \
	MT6356_TYPE_C_CC_SRC_15_DAC_VAL
#define PMIC_REG_TYPE_C_CC_SRC_VOPEN_15_DAC_VAL_MASK 0x3F
#define PMIC_REG_TYPE_C_CC_SRC_VOPEN_15_DAC_VAL_SHIFT 0
#define PMIC_REG_TYPE_C_CC_SRC_VRD_15_DAC_VAL_ADDR                            \
	MT6356_TYPE_C_CC_SRC_15_DAC_VAL
#define PMIC_REG_TYPE_C_CC_SRC_VRD_15_DAC_VAL_MASK 0x3F
#define PMIC_REG_TYPE_C_CC_SRC_VRD_15_DAC_VAL_SHIFT 8
#define PMIC_REG_TYPE_C_CC_SRC_VOPEN_30_DAC_VAL_ADDR                          \
	MT6356_TYPE_C_CC_SRC_30_DAC_VAL
#define PMIC_REG_TYPE_C_CC_SRC_VOPEN_30_DAC_VAL_MASK 0x3F
#define PMIC_REG_TYPE_C_CC_SRC_VOPEN_30_DAC_VAL_SHIFT 0
#define PMIC_REG_TYPE_C_CC_SRC_VRD_30_DAC_VAL_ADDR                            \
	MT6356_TYPE_C_CC_SRC_30_DAC_VAL
#define PMIC_REG_TYPE_C_CC_SRC_VRD_30_DAC_VAL_MASK 0x3F
#define PMIC_REG_TYPE_C_CC_SRC_VRD_30_DAC_VAL_SHIFT 8
#define PMIC_REG_TYPE_C_CC_SNK_VRP30_DAC_VAL_ADDR                             \
	MT6356_TYPE_C_CC_SNK_DAC_VAL_0
#define PMIC_REG_TYPE_C_CC_SNK_VRP30_DAC_VAL_MASK 0x3F
#define PMIC_REG_TYPE_C_CC_SNK_VRP30_DAC_VAL_SHIFT 0
#define PMIC_REG_TYPE_C_CC_SNK_VRP15_DAC_VAL_ADDR                             \
	MT6356_TYPE_C_CC_SNK_DAC_VAL_0
#define PMIC_REG_TYPE_C_CC_SNK_VRP15_DAC_VAL_MASK 0x3F
#define PMIC_REG_TYPE_C_CC_SNK_VRP15_DAC_VAL_SHIFT 8
#define PMIC_REG_TYPE_C_CC_SNK_VRPUSB_DAC_VAL_ADDR                            \
	MT6356_TYPE_C_CC_SNK_DAC_VAL_1
#define PMIC_REG_TYPE_C_CC_SNK_VRPUSB_DAC_VAL_MASK 0x3F
#define PMIC_REG_TYPE_C_CC_SNK_VRPUSB_DAC_VAL_SHIFT 0
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_SRC_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_SRC_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_SRC_INTR_EN_SHIFT 0
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_SNK_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_SNK_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_SNK_INTR_EN_SHIFT 1
#define PMIC_REG_TYPE_C_CC_ENT_AUDIO_ACC_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_AUDIO_ACC_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_AUDIO_ACC_INTR_EN_SHIFT 2
#define PMIC_REG_TYPE_C_CC_ENT_DISABLE_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_DISABLE_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_DISABLE_INTR_EN_SHIFT 3
#define PMIC_REG_TYPE_C_CC_ENT_UNATTACH_SRC_INTR_EN_ADDR                      \
	MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_UNATTACH_SRC_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_UNATTACH_SRC_INTR_EN_SHIFT 4
#define PMIC_REG_TYPE_C_CC_ENT_UNATTACH_SNK_INTR_EN_ADDR                      \
	MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_UNATTACH_SNK_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_UNATTACH_SNK_INTR_EN_SHIFT 5
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_WAIT_SRC_INTR_EN_ADDR                   \
	MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_WAIT_SRC_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_WAIT_SRC_INTR_EN_SHIFT 6
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_WAIT_SNK_INTR_EN_ADDR                   \
	MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_WAIT_SNK_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_WAIT_SNK_INTR_EN_SHIFT 7
#define PMIC_REG_TYPE_C_CC_ENT_TRY_SRC_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_TRY_SRC_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_TRY_SRC_INTR_EN_SHIFT 8
#define PMIC_REG_TYPE_C_CC_ENT_TRY_WAIT_SNK_INTR_EN_ADDR                      \
	MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_TRY_WAIT_SNK_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_TRY_WAIT_SNK_INTR_EN_SHIFT 9
#define PMIC_REG_TYPE_C_CC_ENT_UNATTACH_ACC_INTR_EN_ADDR                      \
	MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_UNATTACH_ACC_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_UNATTACH_ACC_INTR_EN_SHIFT 10
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_WAIT_ACC_INTR_EN_ADDR                   \
	MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_WAIT_ACC_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_ATTACH_WAIT_ACC_INTR_EN_SHIFT 11
#define PMIC_REG_TYPE_C_CC_ENT_TRY_SNK_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_TRY_SNK_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_TRY_SNK_INTR_EN_SHIFT 12
#define PMIC_REG_TYPE_C_CC_ENT_TRY_WAIT_SRC_INTR_EN_ADDR                      \
	MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_TRY_WAIT_SRC_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_TRY_WAIT_SRC_INTR_EN_SHIFT 13
#define PMIC_REG_TYPE_C_CC_ENT_DBG_ACC_SRC_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_DBG_ACC_SRC_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_DBG_ACC_SRC_INTR_EN_SHIFT 14
#define PMIC_REG_TYPE_C_CC_ENT_DBG_ACC_SNK_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_0
#define PMIC_REG_TYPE_C_CC_ENT_DBG_ACC_SNK_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_DBG_ACC_SNK_INTR_EN_SHIFT 15
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_IDLE_INTR_EN_ADDR                      \
	MT6356_TYPE_C_INTR_EN_2
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_IDLE_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_IDLE_INTR_EN_SHIFT 0
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_DEFAULT_INTR_EN_ADDR                   \
	MT6356_TYPE_C_INTR_EN_2
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_DEFAULT_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_DEFAULT_INTR_EN_SHIFT 1
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_15_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_2
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_15_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_15_INTR_EN_SHIFT 2
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_30_INTR_EN_ADDR MT6356_TYPE_C_INTR_EN_2
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_30_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_30_INTR_EN_SHIFT 3
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_REDETECT_INTR_EN_ADDR                  \
	MT6356_TYPE_C_INTR_EN_2
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_REDETECT_INTR_EN_MASK 0x1
#define PMIC_REG_TYPE_C_CC_ENT_SNK_PWR_REDETECT_INTR_EN_SHIFT 4
#define PMIC_TYPE_C_CC_ENT_ATTACH_SRC_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_ATTACH_SRC_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_ATTACH_SRC_INTR_SHIFT 0
#define PMIC_TYPE_C_CC_ENT_ATTACH_SNK_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_ATTACH_SNK_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_ATTACH_SNK_INTR_SHIFT 1
#define PMIC_TYPE_C_CC_ENT_AUDIO_ACC_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_AUDIO_ACC_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_AUDIO_ACC_INTR_SHIFT 2
#define PMIC_TYPE_C_CC_ENT_DISABLE_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_DISABLE_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_DISABLE_INTR_SHIFT 3
#define PMIC_TYPE_C_CC_ENT_UNATTACH_SRC_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_UNATTACH_SRC_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_UNATTACH_SRC_INTR_SHIFT 4
#define PMIC_TYPE_C_CC_ENT_UNATTACH_SNK_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_UNATTACH_SNK_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_UNATTACH_SNK_INTR_SHIFT 5
#define PMIC_TYPE_C_CC_ENT_ATTACH_WAIT_SRC_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_ATTACH_WAIT_SRC_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_ATTACH_WAIT_SRC_INTR_SHIFT 6
#define PMIC_TYPE_C_CC_ENT_ATTACH_WAIT_SNK_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_ATTACH_WAIT_SNK_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_ATTACH_WAIT_SNK_INTR_SHIFT 7
#define PMIC_TYPE_C_CC_ENT_TRY_SRC_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_TRY_SRC_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_TRY_SRC_INTR_SHIFT 8
#define PMIC_TYPE_C_CC_ENT_TRY_WAIT_SNK_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_TRY_WAIT_SNK_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_TRY_WAIT_SNK_INTR_SHIFT 9
#define PMIC_TYPE_C_CC_ENT_UNATTACH_ACC_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_UNATTACH_ACC_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_UNATTACH_ACC_INTR_SHIFT 10
#define PMIC_TYPE_C_CC_ENT_ATTACH_WAIT_ACC_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_ATTACH_WAIT_ACC_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_ATTACH_WAIT_ACC_INTR_SHIFT 11
#define PMIC_TYPE_C_CC_ENT_TRY_SNK_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_TRY_SNK_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_TRY_SNK_INTR_SHIFT 12
#define PMIC_TYPE_C_CC_ENT_TRY_WAIT_SRC_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_TRY_WAIT_SRC_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_TRY_WAIT_SRC_INTR_SHIFT 13
#define PMIC_TYPE_C_CC_ENT_DBG_ACC_SRC_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_DBG_ACC_SRC_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_DBG_ACC_SRC_INTR_SHIFT 14
#define PMIC_TYPE_C_CC_ENT_DBG_ACC_SNK_INTR_ADDR MT6356_TYPE_C_INTR_0
#define PMIC_TYPE_C_CC_ENT_DBG_ACC_SNK_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_DBG_ACC_SNK_INTR_SHIFT 15
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_IDLE_INTR_ADDR MT6356_TYPE_C_INTR_2
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_IDLE_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_IDLE_INTR_SHIFT 0
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_DEFAULT_INTR_ADDR MT6356_TYPE_C_INTR_2
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_DEFAULT_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_DEFAULT_INTR_SHIFT 1
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_15_INTR_ADDR MT6356_TYPE_C_INTR_2
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_15_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_15_INTR_SHIFT 2
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_30_INTR_ADDR MT6356_TYPE_C_INTR_2
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_30_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_30_INTR_SHIFT 3
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_REDETECT_INTR_ADDR MT6356_TYPE_C_INTR_2
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_REDETECT_INTR_MASK 0x1
#define PMIC_TYPE_C_CC_ENT_SNK_PWR_REDETECT_INTR_SHIFT 4
#define PMIC_RO_TYPE_C_CC_ST_ADDR MT6356_TYPE_C_CC_STATUS
#define PMIC_RO_TYPE_C_CC_ST_MASK 0xF
#define PMIC_RO_TYPE_C_CC_ST_SHIFT 0
#define PMIC_RO_TYPE_C_ROUTED_CC_ADDR MT6356_TYPE_C_CC_STATUS
#define PMIC_RO_TYPE_C_ROUTED_CC_MASK 0x1
#define PMIC_RO_TYPE_C_ROUTED_CC_SHIFT 15
#define PMIC_RO_TYPE_C_CC_SNK_PWR_ST_ADDR MT6356_TYPE_C_PWR_STATUS
#define PMIC_RO_TYPE_C_CC_SNK_PWR_ST_MASK 0x7
#define PMIC_RO_TYPE_C_CC_SNK_PWR_ST_SHIFT 0
#define PMIC_RO_TYPE_C_CC_PWR_ROLE_ADDR MT6356_TYPE_C_PWR_STATUS
#define PMIC_RO_TYPE_C_CC_PWR_ROLE_MASK 0x1
#define PMIC_RO_TYPE_C_CC_PWR_ROLE_SHIFT 4
#define PMIC_RO_TYPE_C_DRIVE_VCONN_CAPABLE_ADDR MT6356_TYPE_C_PWR_STATUS
#define PMIC_RO_TYPE_C_DRIVE_VCONN_CAPABLE_MASK 0x1
#define PMIC_RO_TYPE_C_DRIVE_VCONN_CAPABLE_SHIFT 5
#define PMIC_RO_TYPE_C_AD_CC_CMP_OUT_ADDR MT6356_TYPE_C_PWR_STATUS
#define PMIC_RO_TYPE_C_AD_CC_CMP_OUT_MASK 0x1
#define PMIC_RO_TYPE_C_AD_CC_CMP_OUT_SHIFT 6
#define PMIC_RO_DA_CC_TYPEC_SYS_RSTB_ADDR MT6356_TYPE_C_PWR_STATUS
#define PMIC_RO_DA_CC_TYPEC_SYS_RSTB_MASK 0x1
#define PMIC_RO_DA_CC_TYPEC_SYS_RSTB_SHIFT 7
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_RCC1_ADDR                      \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_RCC1_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_RCC1_SHIFT 0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_RCC2_ADDR                      \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_RCC2_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_RCC2_SHIFT 1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_LEV_EN_ADDR                    \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_LEV_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_LEV_EN_SHIFT 2
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_SW_SEL_ADDR                    \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_SW_SEL_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_SW_SEL_SHIFT 3
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_BIAS_EN_ADDR                   \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_BIAS_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_BIAS_EN_SHIFT 4
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_LPF_EN_ADDR                    \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_LPF_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_LPF_EN_SHIFT 5
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_ADCSW_EN_ADDR                  \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_ADCSW_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_ADCSW_EN_SHIFT 6
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_SASW_EN_ADDR                   \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_SASW_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_SASW_EN_SHIFT 7
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_EN_ADDR                    \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_EN_SHIFT 8
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_SACLK_ADDR                     \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_SACLK_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_SACLK_SHIFT 9
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_IN_ADDR                    \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_IN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_IN_SHIFT 10
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_TYPEC_SYS_RSTB_ADDR            \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_TYPEC_SYS_RSTB_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_TYPEC_SYS_RSTB_SHIFT 11
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RPCC1_EN_ADDR                     \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RPCC1_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RPCC1_EN_SHIFT 0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RDCC1_EN_ADDR                     \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RDCC1_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RDCC1_EN_SHIFT 1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RACC1_EN_ADDR                     \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RACC1_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RACC1_EN_SHIFT 2
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RPCC2_EN_ADDR                     \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RPCC2_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RPCC2_EN_SHIFT 3
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RDCC2_EN_ADDR                     \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RDCC2_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RDCC2_EN_SHIFT 4
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RACC2_EN_ADDR                     \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RACC2_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_RACC2_EN_SHIFT 5
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_LEV_EN_ADDR                       \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_LEV_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_LEV_EN_SHIFT 6
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_SW_SEL_ADDR                       \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_SW_SEL_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_SW_SEL_SHIFT 7
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_BIAS_EN_ADDR                      \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_BIAS_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_BIAS_EN_SHIFT 8
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_LPF_EN_ADDR                       \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_LPF_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_LPF_EN_SHIFT 9
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_ADCSW_EN_ADDR                     \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_ADCSW_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_ADCSW_EN_SHIFT 10
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_SASW_EN_ADDR                      \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_SASW_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_SASW_EN_SHIFT 11
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_EN_ADDR                       \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_EN_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_EN_SHIFT 12
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_SACLK_ADDR                        \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_SACLK_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_SACLK_SHIFT 13
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_TYPEC_SYS_RSTB_ADDR               \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_TYPEC_SYS_RSTB_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_TYPEC_SYS_RSTB_SHIFT 14
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_IN_ADDR                       \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_IN_MASK 0x3F
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_IN_SHIFT 0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_CAL_ADDR                   \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_CAL_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_CAL_SHIFT 0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_GAIN_CAL_ADDR              \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_ENABLE_1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_GAIN_CAL_MASK 0x1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_EN_DA_CC_DAC_GAIN_CAL_SHIFT 1
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_CAL_ADDR                      \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_2
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_CAL_MASK 0x1F
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_CAL_SHIFT 0
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_GAIN_CAL_ADDR                 \
	MT6356_TYPE_C_CC_SW_FORCE_MODE_VAL_2
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_GAIN_CAL_MASK 0x1F
#define PMIC_REG_TYPE_C_SW_FORCE_MODE_DA_CC_DAC_GAIN_CAL_SHIFT 8
#define PMIC_TYPE_C_DAC_CAL_START_ADDR MT6356_TYPE_C_CC_DAC_CALI_CTRL
#define PMIC_TYPE_C_DAC_CAL_START_MASK 0x1
#define PMIC_TYPE_C_DAC_CAL_START_SHIFT 0
#define PMIC_REG_TYPE_C_DAC_CAL_STAGE_ADDR MT6356_TYPE_C_CC_DAC_CALI_CTRL
#define PMIC_REG_TYPE_C_DAC_CAL_STAGE_MASK 0x1
#define PMIC_REG_TYPE_C_DAC_CAL_STAGE_SHIFT 1
#define PMIC_RO_TYPE_C_DAC_CAL_OK_ADDR MT6356_TYPE_C_CC_DAC_CALI_CTRL
#define PMIC_RO_TYPE_C_DAC_CAL_OK_MASK 0x1
#define PMIC_RO_TYPE_C_DAC_CAL_OK_SHIFT 4
#define PMIC_RO_TYPE_C_DAC_CAL_FAIL_ADDR MT6356_TYPE_C_CC_DAC_CALI_CTRL
#define PMIC_RO_TYPE_C_DAC_CAL_FAIL_MASK 0x1
#define PMIC_RO_TYPE_C_DAC_CAL_FAIL_SHIFT 5
#define PMIC_RO_DA_CC_DAC_CAL_ADDR MT6356_TYPE_C_CC_DAC_CALI_RESULT
#define PMIC_RO_DA_CC_DAC_CAL_MASK 0x1F
#define PMIC_RO_DA_CC_DAC_CAL_SHIFT 0
#define PMIC_RO_DA_CC_DAC_GAIN_CAL_ADDR MT6356_TYPE_C_CC_DAC_CALI_RESULT
#define PMIC_RO_DA_CC_DAC_GAIN_CAL_MASK 0x1F
#define PMIC_RO_DA_CC_DAC_GAIN_CAL_SHIFT 8
#define PMIC_REG_TYPE_C_DBG_PORT_SEL_0_ADDR MT6356_TYPE_C_DEBUG_PORT_SELECT_0
#define PMIC_REG_TYPE_C_DBG_PORT_SEL_0_MASK 0xFFFF
#define PMIC_REG_TYPE_C_DBG_PORT_SEL_0_SHIFT 0
#define PMIC_REG_TYPE_C_DBG_PORT_SEL_1_ADDR MT6356_TYPE_C_DEBUG_PORT_SELECT_1
#define PMIC_REG_TYPE_C_DBG_PORT_SEL_1_MASK 0xFFFF
#define PMIC_REG_TYPE_C_DBG_PORT_SEL_1_SHIFT 0
#define PMIC_REG_TYPE_C_DBG_MOD_SEL_ADDR MT6356_TYPE_C_DEBUG_MODE_SELECT
#define PMIC_REG_TYPE_C_DBG_MOD_SEL_MASK 0xFFFF
#define PMIC_REG_TYPE_C_DBG_MOD_SEL_SHIFT 0
#define PMIC_RO_TYPE_C_DBG_OUT_READ_0_ADDR MT6356_TYPE_C_DEBUG_OUT_READ_0
#define PMIC_RO_TYPE_C_DBG_OUT_READ_0_MASK 0xFFFF
#define PMIC_RO_TYPE_C_DBG_OUT_READ_0_SHIFT 0
#define PMIC_RO_TYPE_C_DBG_OUT_READ_1_ADDR MT6356_TYPE_C_DEBUG_OUT_READ_1
#define PMIC_RO_TYPE_C_DBG_OUT_READ_1_MASK 0xFFFF
#define PMIC_RO_TYPE_C_DBG_OUT_READ_1_SHIFT 0
#define PMIC_REG_TYPE_C_SW_DBG_PORT_0_ADDR MT6356_TYPE_C_SW_DEBUG_PORT_0
#define PMIC_REG_TYPE_C_SW_DBG_PORT_0_MASK 0xFFFF
#define PMIC_REG_TYPE_C_SW_DBG_PORT_0_SHIFT 0
#define PMIC_REG_TYPE_C_SW_DBG_PORT_1_ADDR MT6356_TYPE_C_SW_DEBUG_PORT_1
#define PMIC_REG_TYPE_C_SW_DBG_PORT_1_MASK 0xFFFF
#define PMIC_REG_TYPE_C_SW_DBG_PORT_1_SHIFT 0
#define PMIC_TYPE_C_ELR_LEN_ADDR MT6356_TYPE_C_ELR_NUM
#define PMIC_TYPE_C_ELR_LEN_MASK 0xFF
#define PMIC_TYPE_C_ELR_LEN_SHIFT 0
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RPDE_ADDR                                  \
	MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_0
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RPDE_MASK 0x7
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RPDE_SHIFT 0
#define PMIC_REG_TYPE_C_PHY_DA_CC_DAC_CAL_ADDR                                \
	MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_0
#define PMIC_REG_TYPE_C_PHY_DA_CC_DAC_CAL_MASK 0x1F
#define PMIC_REG_TYPE_C_PHY_DA_CC_DAC_CAL_SHIFT 3
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RP15_ADDR                                  \
	MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_0
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RP15_MASK 0x1F
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RP15_SHIFT 8
#define PMIC_REG_TYPE_C_SPARE_ELR_0_ADDR MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_0
#define PMIC_REG_TYPE_C_SPARE_ELR_0_MASK 0x7
#define PMIC_REG_TYPE_C_SPARE_ELR_0_SHIFT 13
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RP3_ADDR                                   \
	MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_1
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RP3_MASK 0x1F
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RP3_SHIFT 0
#define PMIC_REG_TYPE_C_SPARE_ELR_1_ADDR MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_1
#define PMIC_REG_TYPE_C_SPARE_ELR_1_MASK 0x7
#define PMIC_REG_TYPE_C_SPARE_ELR_1_SHIFT 5
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RD_ADDR                                    \
	MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_1
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RD_MASK 0x1F
#define PMIC_REG_TYPE_C_PHY_RG_CC1_RD_SHIFT 8
#define PMIC_REG_TYPE_C_SPARE_ELR_2_ADDR MT6356_TYPE_C_PHY_RG_CC1_RESISTENCE_1
#define PMIC_REG_TYPE_C_SPARE_ELR_2_MASK 0x7
#define PMIC_REG_TYPE_C_SPARE_ELR_2_SHIFT 13
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RPDE_ADDR                                  \
	MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_0
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RPDE_MASK 0x7
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RPDE_SHIFT 0
#define PMIC_REG_TYPE_C_PHY_DA_CC_DAC_GAIN_CAL_ADDR                           \
	MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_0
#define PMIC_REG_TYPE_C_PHY_DA_CC_DAC_GAIN_CAL_MASK 0x1F
#define PMIC_REG_TYPE_C_PHY_DA_CC_DAC_GAIN_CAL_SHIFT 3
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RP15_ADDR                                  \
	MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_0
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RP15_MASK 0x1F
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RP15_SHIFT 8
#define PMIC_REG_TYPE_C_SPARE_ELR_3_ADDR MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_0
#define PMIC_REG_TYPE_C_SPARE_ELR_3_MASK 0x7
#define PMIC_REG_TYPE_C_SPARE_ELR_3_SHIFT 13
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RP3_ADDR                                   \
	MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_1
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RP3_MASK 0x1F
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RP3_SHIFT 0
#define PMIC_REG_TYPE_C_SPARE_ELR_4_ADDR MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_1
#define PMIC_REG_TYPE_C_SPARE_ELR_4_MASK 0x7
#define PMIC_REG_TYPE_C_SPARE_ELR_4_SHIFT 5
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RD_ADDR                                    \
	MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_1
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RD_MASK 0x1F
#define PMIC_REG_TYPE_C_PHY_RG_CC2_RD_SHIFT 8
#define PMIC_REG_TYPE_C_SPARE_ELR_5_ADDR MT6356_TYPE_C_PHY_RG_CC2_RESISTENCE_1
#define PMIC_REG_TYPE_C_SPARE_ELR_5_MASK 0x7
#define PMIC_REG_TYPE_C_SPARE_ELR_5_SHIFT 13
#define PMIC_AUD_TOP_ANA_ID_ADDR MT6356_AUD_TOP_ID
#define PMIC_AUD_TOP_ANA_ID_MASK 0xFF
#define PMIC_AUD_TOP_ANA_ID_SHIFT 0
#define PMIC_AUD_TOP_DIG_ID_ADDR MT6356_AUD_TOP_ID
#define PMIC_AUD_TOP_DIG_ID_MASK 0xFF
#define PMIC_AUD_TOP_DIG_ID_SHIFT 8
#define PMIC_AUD_TOP_ANA_MINOR_REV_ADDR MT6356_AUD_TOP_REV0
#define PMIC_AUD_TOP_ANA_MINOR_REV_MASK 0xF
#define PMIC_AUD_TOP_ANA_MINOR_REV_SHIFT 0
#define PMIC_AUD_TOP_ANA_MAJOR_REV_ADDR MT6356_AUD_TOP_REV0
#define PMIC_AUD_TOP_ANA_MAJOR_REV_MASK 0xF
#define PMIC_AUD_TOP_ANA_MAJOR_REV_SHIFT 4
#define PMIC_AUD_TOP_DIG_MINOR_REV_ADDR MT6356_AUD_TOP_REV0
#define PMIC_AUD_TOP_DIG_MINOR_REV_MASK 0xF
#define PMIC_AUD_TOP_DIG_MINOR_REV_SHIFT 8
#define PMIC_AUD_TOP_DIG_MAJOR_REV_ADDR MT6356_AUD_TOP_REV0
#define PMIC_AUD_TOP_DIG_MAJOR_REV_MASK 0xF
#define PMIC_AUD_TOP_DIG_MAJOR_REV_SHIFT 12
#define PMIC_AUD_TOP_SW_MINOR_REV_ADDR MT6356_AUD_TOP_REV1
#define PMIC_AUD_TOP_SW_MINOR_REV_MASK 0xF
#define PMIC_AUD_TOP_SW_MINOR_REV_SHIFT 0
#define PMIC_AUD_TOP_SW_MAJOR_REV_ADDR MT6356_AUD_TOP_REV1
#define PMIC_AUD_TOP_SW_MAJOR_REV_MASK 0xF
#define PMIC_AUD_TOP_SW_MAJOR_REV_SHIFT 4
#define PMIC_AUD_TOP_ESP_ADDR MT6356_AUD_TOP_REV1
#define PMIC_AUD_TOP_ESP_MASK 0xFF
#define PMIC_AUD_TOP_ESP_SHIFT 8
#define PMIC_AUD_TOP_CLK_OFFSET_ADDR MT6356_AUD_TOP_CKPDN_PM0
#define PMIC_AUD_TOP_CLK_OFFSET_MASK 0xFF
#define PMIC_AUD_TOP_CLK_OFFSET_SHIFT 0
#define PMIC_AUD_TOP_RST_OFFSET_ADDR MT6356_AUD_TOP_CKPDN_PM0
#define PMIC_AUD_TOP_RST_OFFSET_MASK 0xFF
#define PMIC_AUD_TOP_RST_OFFSET_SHIFT 8
#define PMIC_AUD_TOP_INT_OFFSET_ADDR MT6356_AUD_TOP_CKPDN_PM1
#define PMIC_AUD_TOP_INT_OFFSET_MASK 0xFF
#define PMIC_AUD_TOP_INT_OFFSET_SHIFT 0
#define PMIC_AUD_TOP_INT_LEN_ADDR MT6356_AUD_TOP_CKPDN_PM1
#define PMIC_AUD_TOP_INT_LEN_MASK 0xFF
#define PMIC_AUD_TOP_INT_LEN_SHIFT 8
#define PMIC_RG_ACCDET_CK_PDN_ADDR MT6356_AUD_TOP_CKPDN_CON0
#define PMIC_RG_ACCDET_CK_PDN_MASK 0x1
#define PMIC_RG_ACCDET_CK_PDN_SHIFT 0
#define PMIC_RG_AUD_CK_PDN_ADDR MT6356_AUD_TOP_CKPDN_CON0
#define PMIC_RG_AUD_CK_PDN_MASK 0x1
#define PMIC_RG_AUD_CK_PDN_SHIFT 1
#define PMIC_RG_AUDIF_CK_PDN_ADDR MT6356_AUD_TOP_CKPDN_CON0
#define PMIC_RG_AUDIF_CK_PDN_MASK 0x1
#define PMIC_RG_AUDIF_CK_PDN_SHIFT 2
#define PMIC_RG_ZCD13M_CK_PDN_ADDR MT6356_AUD_TOP_CKPDN_CON0
#define PMIC_RG_ZCD13M_CK_PDN_MASK 0x1
#define PMIC_RG_ZCD13M_CK_PDN_SHIFT 5
#define PMIC_RG_AUDNCP_CK_PDN_ADDR MT6356_AUD_TOP_CKPDN_CON0
#define PMIC_RG_AUDNCP_CK_PDN_MASK 0x1
#define PMIC_RG_AUDNCP_CK_PDN_SHIFT 6
#define PMIC_RG_AUD_CK_CKSEL_ADDR MT6356_AUD_TOP_CKSEL_CON0
#define PMIC_RG_AUD_CK_CKSEL_MASK 0x1
#define PMIC_RG_AUD_CK_CKSEL_SHIFT 2
#define PMIC_RG_AUDIF_CK_CKSEL_ADDR MT6356_AUD_TOP_CKSEL_CON0
#define PMIC_RG_AUDIF_CK_CKSEL_MASK 0x1
#define PMIC_RG_AUDIF_CK_CKSEL_SHIFT 3
#define PMIC_RG_AUD26M_CK_TST_DIS_ADDR MT6356_AUD_TOP_CKTST_CON0
#define PMIC_RG_AUD26M_CK_TST_DIS_MASK 0x1
#define PMIC_RG_AUD26M_CK_TST_DIS_SHIFT 0
#define PMIC_RG_AUD_CK_TSTSEL_ADDR MT6356_AUD_TOP_CKTST_CON0
#define PMIC_RG_AUD_CK_TSTSEL_MASK 0x1
#define PMIC_RG_AUD_CK_TSTSEL_SHIFT 2
#define PMIC_RG_AUDIF_CK_TSTSEL_ADDR MT6356_AUD_TOP_CKTST_CON0
#define PMIC_RG_AUDIF_CK_TSTSEL_MASK 0x1
#define PMIC_RG_AUDIF_CK_TSTSEL_SHIFT 3
#define PMIC_RG_AUD26M_CK_TSTSEL_ADDR MT6356_AUD_TOP_CKTST_CON0
#define PMIC_RG_AUD26M_CK_TSTSEL_MASK 0x1
#define PMIC_RG_AUD26M_CK_TSTSEL_SHIFT 4
#define PMIC_RG_AUDIO_RST_ADDR MT6356_AUD_TOP_RST_CON0
#define PMIC_RG_AUDIO_RST_MASK 0x1
#define PMIC_RG_AUDIO_RST_SHIFT 0
#define PMIC_RG_ACCDET_RST_ADDR MT6356_AUD_TOP_RST_CON0
#define PMIC_RG_ACCDET_RST_MASK 0x1
#define PMIC_RG_ACCDET_RST_SHIFT 1
#define PMIC_RG_ZCD_RST_ADDR MT6356_AUD_TOP_RST_CON0
#define PMIC_RG_ZCD_RST_MASK 0x1
#define PMIC_RG_ZCD_RST_SHIFT 2
#define PMIC_RG_AUDNCP_RST_ADDR MT6356_AUD_TOP_RST_CON0
#define PMIC_RG_AUDNCP_RST_MASK 0x1
#define PMIC_RG_AUDNCP_RST_SHIFT 3
#define PMIC_BANK_ACCDET_SWRST_ADDR MT6356_AUD_TOP_RST_BANK_CON0
#define PMIC_BANK_ACCDET_SWRST_MASK 0x1
#define PMIC_BANK_ACCDET_SWRST_SHIFT 0
#define PMIC_BANK_AUDIO_SWRST_ADDR MT6356_AUD_TOP_RST_BANK_CON0
#define PMIC_BANK_AUDIO_SWRST_MASK 0x1
#define PMIC_BANK_AUDIO_SWRST_SHIFT 1
#define PMIC_BANK_AUDZCD_SWRST_ADDR MT6356_AUD_TOP_RST_BANK_CON0
#define PMIC_BANK_AUDZCD_SWRST_MASK 0x1
#define PMIC_BANK_AUDZCD_SWRST_SHIFT 2
#define PMIC_RG_INT_EN_AUDIO_ADDR MT6356_AUD_TOP_INT_CON0
#define PMIC_RG_INT_EN_AUDIO_MASK 0x1
#define PMIC_RG_INT_EN_AUDIO_SHIFT 0
#define PMIC_RG_INT_EN_ACCDET_ADDR MT6356_AUD_TOP_INT_CON0
#define PMIC_RG_INT_EN_ACCDET_MASK 0x1
#define PMIC_RG_INT_EN_ACCDET_SHIFT 5
#define PMIC_RG_INT_EN_ACCDET_EINT_ADDR MT6356_AUD_TOP_INT_CON0
#define PMIC_RG_INT_EN_ACCDET_EINT_MASK 0x1
#define PMIC_RG_INT_EN_ACCDET_EINT_SHIFT 6
#define PMIC_RG_INT_EN_ACCDET_EINT1_ADDR MT6356_AUD_TOP_INT_CON0
#define PMIC_RG_INT_EN_ACCDET_EINT1_MASK 0x1
#define PMIC_RG_INT_EN_ACCDET_EINT1_SHIFT 7
#define PMIC_RG_AUD_INT_CON0_SET_ADDR MT6356_AUD_TOP_INT_CON0_SET
#define PMIC_RG_AUD_INT_CON0_SET_MASK 0xFFFF
#define PMIC_RG_AUD_INT_CON0_SET_SHIFT 0
#define PMIC_RG_AUD_INT_CON0_CLR_ADDR MT6356_AUD_TOP_INT_CON0_CLR
#define PMIC_RG_AUD_INT_CON0_CLR_MASK 0xFFFF
#define PMIC_RG_AUD_INT_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_MASK_AUDIO_ADDR MT6356_AUD_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_AUDIO_MASK 0x1
#define PMIC_RG_INT_MASK_AUDIO_SHIFT 0
#define PMIC_RG_INT_MASK_ACCDET_ADDR MT6356_AUD_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_ACCDET_MASK 0x1
#define PMIC_RG_INT_MASK_ACCDET_SHIFT 5
#define PMIC_RG_INT_MASK_ACCDET_EINT_ADDR MT6356_AUD_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_ACCDET_EINT_MASK 0x1
#define PMIC_RG_INT_MASK_ACCDET_EINT_SHIFT 6
#define PMIC_RG_INT_MASK_ACCDET_EINT1_ADDR MT6356_AUD_TOP_INT_MASK_CON0
#define PMIC_RG_INT_MASK_ACCDET_EINT1_MASK 0x1
#define PMIC_RG_INT_MASK_ACCDET_EINT1_SHIFT 7
#define PMIC_RG_AUD_INT_MASK_CON0_SET_ADDR MT6356_AUD_TOP_INT_MASK_CON0_SET
#define PMIC_RG_AUD_INT_MASK_CON0_SET_MASK 0xFFFF
#define PMIC_RG_AUD_INT_MASK_CON0_SET_SHIFT 0
#define PMIC_RG_AUD_INT_MASK_CON0_CLR_ADDR MT6356_AUD_TOP_INT_MASK_CON0_CLR
#define PMIC_RG_AUD_INT_MASK_CON0_CLR_MASK 0xFFFF
#define PMIC_RG_AUD_INT_MASK_CON0_CLR_SHIFT 0
#define PMIC_RG_INT_STATUS_AUDIO_ADDR MT6356_AUD_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_AUDIO_MASK 0x1
#define PMIC_RG_INT_STATUS_AUDIO_SHIFT 0
#define PMIC_RG_INT_STATUS_ACCDET_ADDR MT6356_AUD_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_ACCDET_MASK 0x1
#define PMIC_RG_INT_STATUS_ACCDET_SHIFT 5
#define PMIC_RG_INT_STATUS_ACCDET_EINT_ADDR MT6356_AUD_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_ACCDET_EINT_MASK 0x1
#define PMIC_RG_INT_STATUS_ACCDET_EINT_SHIFT 6
#define PMIC_RG_INT_STATUS_ACCDET_EINT1_ADDR MT6356_AUD_TOP_INT_STATUS0
#define PMIC_RG_INT_STATUS_ACCDET_EINT1_MASK 0x1
#define PMIC_RG_INT_STATUS_ACCDET_EINT1_SHIFT 7
#define PMIC_RG_INT_RAW_STATUS_AUDIO_ADDR MT6356_AUD_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_AUDIO_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_AUDIO_SHIFT 0
#define PMIC_RG_INT_RAW_STATUS_ACCDET_ADDR MT6356_AUD_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_ACCDET_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_ACCDET_SHIFT 5
#define PMIC_RG_INT_RAW_STATUS_ACCDET_EINT_ADDR MT6356_AUD_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_ACCDET_EINT_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_ACCDET_EINT_SHIFT 6
#define PMIC_RG_INT_RAW_STATUS_ACCDET_EINT1_ADDR MT6356_AUD_TOP_INT_RAW_STATUS0
#define PMIC_RG_INT_RAW_STATUS_ACCDET_EINT1_MASK 0x1
#define PMIC_RG_INT_RAW_STATUS_ACCDET_EINT1_SHIFT 7
#define PMIC_RG_AUD_TOP_INT_POLARITY_ADDR MT6356_AUD_TOP_INT_MISC_CON0
#define PMIC_RG_AUD_TOP_INT_POLARITY_MASK 0x1
#define PMIC_RG_AUD_TOP_INT_POLARITY_SHIFT 0
#define PMIC_RG_DIVCKS_CHG_ADDR MT6356_AUDNCP_CLKDIV_CON0
#define PMIC_RG_DIVCKS_CHG_MASK 0x1
#define PMIC_RG_DIVCKS_CHG_SHIFT 0
#define PMIC_RG_DIVCKS_ON_ADDR MT6356_AUDNCP_CLKDIV_CON1
#define PMIC_RG_DIVCKS_ON_MASK 0x1
#define PMIC_RG_DIVCKS_ON_SHIFT 0
#define PMIC_RG_DIVCKS_PRG_ADDR MT6356_AUDNCP_CLKDIV_CON2
#define PMIC_RG_DIVCKS_PRG_MASK 0x1FF
#define PMIC_RG_DIVCKS_PRG_SHIFT 0
#define PMIC_RG_DIVCKS_PWD_NCP_ADDR MT6356_AUDNCP_CLKDIV_CON3
#define PMIC_RG_DIVCKS_PWD_NCP_MASK 0x1
#define PMIC_RG_DIVCKS_PWD_NCP_SHIFT 0
#define PMIC_RG_DIVCKS_PWD_NCP_ST_SEL_ADDR MT6356_AUDNCP_CLKDIV_CON4
#define PMIC_RG_DIVCKS_PWD_NCP_ST_SEL_MASK 0x3
#define PMIC_RG_DIVCKS_PWD_NCP_ST_SEL_SHIFT 0
#define PMIC_RG_AUD_TOP_MON_SEL_ADDR MT6356_AUD_TOP_MON_CON0
#define PMIC_RG_AUD_TOP_MON_SEL_MASK 0x7
#define PMIC_RG_AUD_TOP_MON_SEL_SHIFT 0
#define PMIC_RG_AUD_CLK_INT_MON_FLAG_SEL_ADDR MT6356_AUD_TOP_MON_CON0
#define PMIC_RG_AUD_CLK_INT_MON_FLAG_SEL_MASK 0xFF
#define PMIC_RG_AUD_CLK_INT_MON_FLAG_SEL_SHIFT 3
#define PMIC_RG_AUD_CLK_INT_MON_FLAG_EN_ADDR MT6356_AUD_TOP_MON_CON0
#define PMIC_RG_AUD_CLK_INT_MON_FLAG_EN_MASK 0x1
#define PMIC_RG_AUD_CLK_INT_MON_FLAG_EN_SHIFT 11
#define PMIC_AUDIO_DIG_ANA_ID_ADDR MT6356_AUDIO_DIG_ID
#define PMIC_AUDIO_DIG_ANA_ID_MASK 0xFF
#define PMIC_AUDIO_DIG_ANA_ID_SHIFT 0
#define PMIC_AUDIO_DIG_DIG_ID_ADDR MT6356_AUDIO_DIG_ID
#define PMIC_AUDIO_DIG_DIG_ID_MASK 0xFF
#define PMIC_AUDIO_DIG_DIG_ID_SHIFT 8
#define PMIC_AUDIO_DIG_ANA_MINOR_REV_ADDR MT6356_AUDIO_DIG_REV0
#define PMIC_AUDIO_DIG_ANA_MINOR_REV_MASK 0xF
#define PMIC_AUDIO_DIG_ANA_MINOR_REV_SHIFT 0
#define PMIC_AUDIO_DIG_ANA_MAJOR_REV_ADDR MT6356_AUDIO_DIG_REV0
#define PMIC_AUDIO_DIG_ANA_MAJOR_REV_MASK 0xF
#define PMIC_AUDIO_DIG_ANA_MAJOR_REV_SHIFT 4
#define PMIC_AUDIO_DIG_DIG_MINOR_REV_ADDR MT6356_AUDIO_DIG_REV0
#define PMIC_AUDIO_DIG_DIG_MINOR_REV_MASK 0xF
#define PMIC_AUDIO_DIG_DIG_MINOR_REV_SHIFT 8
#define PMIC_AUDIO_DIG_DIG_MAJOR_REV_ADDR MT6356_AUDIO_DIG_REV0
#define PMIC_AUDIO_DIG_DIG_MAJOR_REV_MASK 0xF
#define PMIC_AUDIO_DIG_DIG_MAJOR_REV_SHIFT 12
#define PMIC_AUDIO_DIG_SW_MINOR_REV_ADDR MT6356_AUDIO_DIG_REV1
#define PMIC_AUDIO_DIG_SW_MINOR_REV_MASK 0xF
#define PMIC_AUDIO_DIG_SW_MINOR_REV_SHIFT 0
#define PMIC_AUDIO_DIG_SW_MAJOR_REV_ADDR MT6356_AUDIO_DIG_REV1
#define PMIC_AUDIO_DIG_SW_MAJOR_REV_MASK 0xF
#define PMIC_AUDIO_DIG_SW_MAJOR_REV_SHIFT 4
#define PMIC_AUDIO_DIG_ESP_ADDR MT6356_AUDIO_DIG_REV1
#define PMIC_AUDIO_DIG_ESP_MASK 0xFF
#define PMIC_AUDIO_DIG_ESP_SHIFT 8
#define PMIC_AFE_ON_ADDR MT6356_AFE_UL_DL_CON0
#define PMIC_AFE_ON_MASK 0x1
#define PMIC_AFE_ON_SHIFT 0
#define PMIC_AFE_DL_LR_SWAP_ADDR MT6356_AFE_UL_DL_CON0
#define PMIC_AFE_DL_LR_SWAP_MASK 0x1
#define PMIC_AFE_DL_LR_SWAP_SHIFT 14
#define PMIC_AFE_UL_LR_SWAP_ADDR MT6356_AFE_UL_DL_CON0
#define PMIC_AFE_UL_LR_SWAP_MASK 0x1
#define PMIC_AFE_UL_LR_SWAP_SHIFT 15
#define PMIC_DL_2_SRC_ON_TMP_CTL_PRE_ADDR MT6356_AFE_DL_SRC2_CON0_L
#define PMIC_DL_2_SRC_ON_TMP_CTL_PRE_MASK 0x1
#define PMIC_DL_2_SRC_ON_TMP_CTL_PRE_SHIFT 0
#define PMIC_C_TWO_DIGITAL_MIC_CTL_ADDR MT6356_AFE_UL_SRC_CON0_H
#define PMIC_C_TWO_DIGITAL_MIC_CTL_MASK 0x1
#define PMIC_C_TWO_DIGITAL_MIC_CTL_SHIFT 7
#define PMIC_C_DIGMIC_PHASE_SEL_CH2_CTL_ADDR MT6356_AFE_UL_SRC_CON0_H
#define PMIC_C_DIGMIC_PHASE_SEL_CH2_CTL_MASK 0x7
#define PMIC_C_DIGMIC_PHASE_SEL_CH2_CTL_SHIFT 8
#define PMIC_C_DIGMIC_PHASE_SEL_CH1_CTL_ADDR MT6356_AFE_UL_SRC_CON0_H
#define PMIC_C_DIGMIC_PHASE_SEL_CH1_CTL_MASK 0x7
#define PMIC_C_DIGMIC_PHASE_SEL_CH1_CTL_SHIFT 11
#define PMIC_UL_SRC_ON_TMP_CTL_ADDR MT6356_AFE_UL_SRC_CON0_L
#define PMIC_UL_SRC_ON_TMP_CTL_MASK 0x1
#define PMIC_UL_SRC_ON_TMP_CTL_SHIFT 0
#define PMIC_UL_SDM_3_LEVEL_CTL_ADDR MT6356_AFE_UL_SRC_CON0_L
#define PMIC_UL_SDM_3_LEVEL_CTL_MASK 0x1
#define PMIC_UL_SDM_3_LEVEL_CTL_SHIFT 1
#define PMIC_UL_LOOP_BACK_MODE_CTL_ADDR MT6356_AFE_UL_SRC_CON0_L
#define PMIC_UL_LOOP_BACK_MODE_CTL_MASK 0x1
#define PMIC_UL_LOOP_BACK_MODE_CTL_SHIFT 2
#define PMIC_DIGMIC_3P25M_1P625M_SEL_CTL_ADDR MT6356_AFE_UL_SRC_CON0_L
#define PMIC_DIGMIC_3P25M_1P625M_SEL_CTL_MASK 0x1
#define PMIC_DIGMIC_3P25M_1P625M_SEL_CTL_SHIFT 5
#define PMIC_DMIC_LOW_POWER_MODE_CTL_ADDR MT6356_AFE_UL_SRC_CON0_L
#define PMIC_DMIC_LOW_POWER_MODE_CTL_MASK 0x3
#define PMIC_DMIC_LOW_POWER_MODE_CTL_SHIFT 14
#define PMIC_DL_SINE_ON_ADDR MT6356_AFE_TOP_CON0
#define PMIC_DL_SINE_ON_MASK 0x1
#define PMIC_DL_SINE_ON_SHIFT 0
#define PMIC_UL_SINE_ON_ADDR MT6356_AFE_TOP_CON0
#define PMIC_UL_SINE_ON_MASK 0x1
#define PMIC_UL_SINE_ON_SHIFT 1
#define PMIC_PDN_RESERVED_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_PDN_RESERVED_MASK 0x1
#define PMIC_PDN_RESERVED_SHIFT 0
#define PMIC_PDN_AFE_TESTMODEL_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_PDN_AFE_TESTMODEL_CTL_MASK 0x1
#define PMIC_PDN_AFE_TESTMODEL_CTL_SHIFT 1
#define PMIC_PWR_CLK_DIS_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_PWR_CLK_DIS_CTL_MASK 0x1
#define PMIC_PWR_CLK_DIS_CTL_SHIFT 2
#define PMIC_PDN_I2S_DL_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_PDN_I2S_DL_CTL_MASK 0x1
#define PMIC_PDN_I2S_DL_CTL_SHIFT 3
#define PMIC_PDN_BUCKOSC_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_PDN_BUCKOSC_CTL_MASK 0x1
#define PMIC_PDN_BUCKOSC_CTL_SHIFT 4
#define PMIC_PDN_ADC_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_PDN_ADC_CTL_MASK 0x1
#define PMIC_PDN_ADC_CTL_SHIFT 5
#define PMIC_PDN_DAC_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_PDN_DAC_CTL_MASK 0x1
#define PMIC_PDN_DAC_CTL_SHIFT 6
#define PMIC_PDN_AFE_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_PDN_AFE_CTL_MASK 0x1
#define PMIC_PDN_AFE_CTL_SHIFT 7
#define PMIC_AFE_3P25M_PHASE_SEL_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_AFE_3P25M_PHASE_SEL_CTL_MASK 0x3
#define PMIC_AFE_3P25M_PHASE_SEL_CTL_SHIFT 8
#define PMIC_AFE_6P5M_PHASE_SEL_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_AFE_6P5M_PHASE_SEL_CTL_MASK 0x3
#define PMIC_AFE_6P5M_PHASE_SEL_CTL_SHIFT 10
#define PMIC_AFE_13M_PHASE_SEL_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_AFE_13M_PHASE_SEL_CTL_MASK 0x1
#define PMIC_AFE_13M_PHASE_SEL_CTL_SHIFT 12
#define PMIC_PDN_ADC_HIRES_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_PDN_ADC_HIRES_CTL_MASK 0x1
#define PMIC_PDN_ADC_HIRES_CTL_SHIFT 13
#define PMIC_AFE_CK_DIV_RST_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_AFE_CK_DIV_RST_CTL_MASK 0x1
#define PMIC_AFE_CK_DIV_RST_CTL_SHIFT 14
#define PMIC_FIFO_AUTO_RST_CTL_ADDR MT6356_AUDIO_TOP_CON0
#define PMIC_FIFO_AUTO_RST_CTL_MASK 0x1
#define PMIC_FIFO_AUTO_RST_CTL_SHIFT 15
#define PMIC_AFE_MON_SEL_ADDR MT6356_AFE_MON_DEBUG0
#define PMIC_AFE_MON_SEL_MASK 0xFF
#define PMIC_AFE_MON_SEL_SHIFT 0
#define PMIC_AUDIO_SYS_TOP_MON_SEL_ADDR MT6356_AFE_MON_DEBUG0
#define PMIC_AUDIO_SYS_TOP_MON_SEL_MASK 0x1F
#define PMIC_AUDIO_SYS_TOP_MON_SEL_SHIFT 8
#define PMIC_AUDIO_SYS_TOP_MON_SWAP_ADDR MT6356_AFE_MON_DEBUG0
#define PMIC_AUDIO_SYS_TOP_MON_SWAP_MASK 0x3
#define PMIC_AUDIO_SYS_TOP_MON_SWAP_SHIFT 14
#define PMIC_CCI_SCRAMBLER_EN_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_SCRAMBLER_EN_MASK 0x1
#define PMIC_CCI_SCRAMBLER_EN_SHIFT 0
#define PMIC_CCI_AUD_SDM_7BIT_SEL_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_AUD_SDM_7BIT_SEL_MASK 0x1
#define PMIC_CCI_AUD_SDM_7BIT_SEL_SHIFT 1
#define PMIC_CCI_AUD_SDM_MUTER_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_AUD_SDM_MUTER_MASK 0x1
#define PMIC_CCI_AUD_SDM_MUTER_SHIFT 2
#define PMIC_CCI_AUD_SDM_MUTEL_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_AUD_SDM_MUTEL_MASK 0x1
#define PMIC_CCI_AUD_SDM_MUTEL_SHIFT 3
#define PMIC_CCI_AUD_SPLIT_TEST_EN_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_AUD_SPLIT_TEST_EN_MASK 0x1
#define PMIC_CCI_AUD_SPLIT_TEST_EN_SHIFT 4
#define PMIC_CCI_ZERO_PAD_DISABLE_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_ZERO_PAD_DISABLE_MASK 0x1
#define PMIC_CCI_ZERO_PAD_DISABLE_SHIFT 5
#define PMIC_CCI_AUD_IDAC_TEST_EN_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_AUD_IDAC_TEST_EN_MASK 0x1
#define PMIC_CCI_AUD_IDAC_TEST_EN_SHIFT 6
#define PMIC_CCI_SPLT_SCRMB_ON_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_SPLT_SCRMB_ON_MASK 0x1
#define PMIC_CCI_SPLT_SCRMB_ON_SHIFT 7
#define PMIC_CCI_SPLT_SCRMB_CLK_ON_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_SPLT_SCRMB_CLK_ON_MASK 0x1
#define PMIC_CCI_SPLT_SCRMB_CLK_ON_SHIFT 8
#define PMIC_CCI_RAND_EN_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_RAND_EN_MASK 0x1
#define PMIC_CCI_RAND_EN_SHIFT 9
#define PMIC_CCI_LCH_INV_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_LCH_INV_MASK 0x1
#define PMIC_CCI_LCH_INV_SHIFT 10
#define PMIC_CCI_SCRAMBLER_CG_EN_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_SCRAMBLER_CG_EN_MASK 0x1
#define PMIC_CCI_SCRAMBLER_CG_EN_SHIFT 11
#define PMIC_CCI_AUDIO_FIFO_WPTR_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_AUDIO_FIFO_WPTR_MASK 0x7
#define PMIC_CCI_AUDIO_FIFO_WPTR_SHIFT 12
#define PMIC_CCI_AUD_ANACK_SEL_ADDR MT6356_AFUNC_AUD_CON0
#define PMIC_CCI_AUD_ANACK_SEL_MASK 0x1
#define PMIC_CCI_AUD_ANACK_SEL_SHIFT 15
#define PMIC_AUD_SDM_TEST_R_ADDR MT6356_AFUNC_AUD_CON1
#define PMIC_AUD_SDM_TEST_R_MASK 0xFF
#define PMIC_AUD_SDM_TEST_R_SHIFT 0
#define PMIC_AUD_SDM_TEST_L_ADDR MT6356_AFUNC_AUD_CON1
#define PMIC_AUD_SDM_TEST_L_MASK 0xFF
#define PMIC_AUD_SDM_TEST_L_SHIFT 8
#define PMIC_CCI_ACD_FUNC_RSTB_ADDR MT6356_AFUNC_AUD_CON2
#define PMIC_CCI_ACD_FUNC_RSTB_MASK 0x1
#define PMIC_CCI_ACD_FUNC_RSTB_SHIFT 0
#define PMIC_CCI_AFIFO_CLK_PWDB_ADDR MT6356_AFUNC_AUD_CON2
#define PMIC_CCI_AFIFO_CLK_PWDB_MASK 0x1
#define PMIC_CCI_AFIFO_CLK_PWDB_SHIFT 1
#define PMIC_CCI_ACD_MODE_ADDR MT6356_AFUNC_AUD_CON2
#define PMIC_CCI_ACD_MODE_MASK 0x1
#define PMIC_CCI_ACD_MODE_SHIFT 2
#define PMIC_CCI_AUDIO_FIFO_ENABLE_ADDR MT6356_AFUNC_AUD_CON2
#define PMIC_CCI_AUDIO_FIFO_ENABLE_MASK 0x1
#define PMIC_CCI_AUDIO_FIFO_ENABLE_SHIFT 3
#define PMIC_CCI_AUDIO_FIFO_CLKIN_INV_ADDR MT6356_AFUNC_AUD_CON2
#define PMIC_CCI_AUDIO_FIFO_CLKIN_INV_MASK 0x1
#define PMIC_CCI_AUDIO_FIFO_CLKIN_INV_SHIFT 4
#define PMIC_CCI_AUD_DAC_ANA_RSTB_SEL_ADDR MT6356_AFUNC_AUD_CON2
#define PMIC_CCI_AUD_DAC_ANA_RSTB_SEL_MASK 0x1
#define PMIC_CCI_AUD_DAC_ANA_RSTB_SEL_SHIFT 6
#define PMIC_CCI_AUD_DAC_ANA_MUTE_ADDR MT6356_AFUNC_AUD_CON2
#define PMIC_CCI_AUD_DAC_ANA_MUTE_MASK 0x1
#define PMIC_CCI_AUD_DAC_ANA_MUTE_SHIFT 7
#define PMIC_DIGMIC_TESTCK_SEL_ADDR MT6356_AFUNC_AUD_CON3
#define PMIC_DIGMIC_TESTCK_SEL_MASK 0x1
#define PMIC_DIGMIC_TESTCK_SEL_SHIFT 0
#define PMIC_DIGMIC_TESTCK_SRC_SEL_ADDR MT6356_AFUNC_AUD_CON3
#define PMIC_DIGMIC_TESTCK_SRC_SEL_MASK 0x7
#define PMIC_DIGMIC_TESTCK_SRC_SEL_SHIFT 4
#define PMIC_SDM_TESTCK_SRC_SEL_ADDR MT6356_AFUNC_AUD_CON3
#define PMIC_SDM_TESTCK_SRC_SEL_MASK 0x7
#define PMIC_SDM_TESTCK_SRC_SEL_SHIFT 8
#define PMIC_SDM_ANA13M_TESTCK_SRC_SEL_ADDR MT6356_AFUNC_AUD_CON3
#define PMIC_SDM_ANA13M_TESTCK_SRC_SEL_MASK 0x7
#define PMIC_SDM_ANA13M_TESTCK_SRC_SEL_SHIFT 12
#define PMIC_SDM_ANA13M_TESTCK_SEL_ADDR MT6356_AFUNC_AUD_CON3
#define PMIC_SDM_ANA13M_TESTCK_SEL_MASK 0x1
#define PMIC_SDM_ANA13M_TESTCK_SEL_SHIFT 15
#define PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SRC_SEL_ADDR MT6356_AFUNC_AUD_CON4
#define PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SRC_SEL_MASK 0x7
#define PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SRC_SEL_SHIFT 0
#define PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SEL_ADDR MT6356_AFUNC_AUD_CON4
#define PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SEL_MASK 0x1
#define PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SEL_SHIFT 3
#define PMIC_UL_FIFO_WDATA_TESTSRC_SEL_ADDR MT6356_AFUNC_AUD_CON4
#define PMIC_UL_FIFO_WDATA_TESTSRC_SEL_MASK 0x1
#define PMIC_UL_FIFO_WDATA_TESTSRC_SEL_SHIFT 4
#define PMIC_UL_FIFO_WDATA_TESTEN_ADDR MT6356_AFUNC_AUD_CON4
#define PMIC_UL_FIFO_WDATA_TESTEN_MASK 0x1
#define PMIC_UL_FIFO_WDATA_TESTEN_SHIFT 5
#define PMIC_UL_FIFO_DIGMIC_WDATA_TESTSRC_SEL_ADDR MT6356_AFUNC_AUD_CON4
#define PMIC_UL_FIFO_DIGMIC_WDATA_TESTSRC_SEL_MASK 0x1
#define PMIC_UL_FIFO_DIGMIC_WDATA_TESTSRC_SEL_SHIFT 6
#define PMIC_UL_FIFO_WCLK_INV_ADDR MT6356_AFUNC_AUD_CON4
#define PMIC_UL_FIFO_WCLK_INV_MASK 0x1
#define PMIC_UL_FIFO_WCLK_INV_SHIFT 8
#define PMIC_AUD_SCR_OUT_R_ADDR MT6356_AFUNC_AUD_MON0
#define PMIC_AUD_SCR_OUT_R_MASK 0xFF
#define PMIC_AUD_SCR_OUT_R_SHIFT 0
#define PMIC_AUD_SCR_OUT_L_ADDR MT6356_AFUNC_AUD_MON0
#define PMIC_AUD_SCR_OUT_L_MASK 0xFF
#define PMIC_AUD_SCR_OUT_L_SHIFT 8
#define PMIC_RGS_AUDRCTUNE0READ_ADDR MT6356_AUDRC_TUNE_MON0
#define PMIC_RGS_AUDRCTUNE0READ_MASK 0x1F
#define PMIC_RGS_AUDRCTUNE0READ_SHIFT 0
#define PMIC_RGS_AUDRCTUNE1READ_ADDR MT6356_AUDRC_TUNE_MON0
#define PMIC_RGS_AUDRCTUNE1READ_MASK 0x1F
#define PMIC_RGS_AUDRCTUNE1READ_SHIFT 8
#define PMIC_ASYNC_TEST_OUT_BCK_ADDR MT6356_AUDRC_TUNE_MON0
#define PMIC_ASYNC_TEST_OUT_BCK_MASK 0x1
#define PMIC_ASYNC_TEST_OUT_BCK_SHIFT 15
#define PMIC_RG_MTKAIF_RXIF_FIFO_INTEN_ADDR MT6356_AFE_ADDA_MTKAIF_FIFO_CFG0
#define PMIC_RG_MTKAIF_RXIF_FIFO_INTEN_MASK 0x1
#define PMIC_RG_MTKAIF_RXIF_FIFO_INTEN_SHIFT 0
#define PMIC_AFE_RESERVED_ADDR MT6356_AFE_ADDA_MTKAIF_FIFO_CFG0
#define PMIC_AFE_RESERVED_MASK 0x7FFF
#define PMIC_AFE_RESERVED_SHIFT 1
#define PMIC_MTKAIF_RXIF_RD_EMPTY_STATUS_ADDR                                 \
	MT6356_AFE_ADDA_MTKAIF_FIFO_LOG_MON1
#define PMIC_MTKAIF_RXIF_RD_EMPTY_STATUS_MASK 0x1
#define PMIC_MTKAIF_RXIF_RD_EMPTY_STATUS_SHIFT 0
#define PMIC_MTKAIF_RXIF_WR_FULL_STATUS_ADDR                                  \
	MT6356_AFE_ADDA_MTKAIF_FIFO_LOG_MON1
#define PMIC_MTKAIF_RXIF_WR_FULL_STATUS_MASK 0x1
#define PMIC_MTKAIF_RXIF_WR_FULL_STATUS_SHIFT 1
#define PMIC_MTKAIF_RXIF_FIFO_STATUS_ADDR MT6356_AFE_ADDA_MTKAIF_MON0
#define PMIC_MTKAIF_RXIF_FIFO_STATUS_MASK 0xFFF
#define PMIC_MTKAIF_RXIF_FIFO_STATUS_SHIFT 0
#define PMIC_MTKAIFTX_V3_SDATA_OUT1_ADDR MT6356_AFE_ADDA_MTKAIF_MON0
#define PMIC_MTKAIFTX_V3_SDATA_OUT1_MASK 0x1
#define PMIC_MTKAIFTX_V3_SDATA_OUT1_SHIFT 12
#define PMIC_MTKAIFTX_V3_SDATA_OUT2_ADDR MT6356_AFE_ADDA_MTKAIF_MON0
#define PMIC_MTKAIFTX_V3_SDATA_OUT2_MASK 0x1
#define PMIC_MTKAIFTX_V3_SDATA_OUT2_SHIFT 13
#define PMIC_MTKAIFTX_V3_SYNC_OUT_ADDR MT6356_AFE_ADDA_MTKAIF_MON0
#define PMIC_MTKAIFTX_V3_SYNC_OUT_MASK 0x1
#define PMIC_MTKAIFTX_V3_SYNC_OUT_SHIFT 14
#define PMIC_MTKAIF_RXIF_INVALID_CYCLE_ADDR MT6356_AFE_ADDA_MTKAIF_MON1
#define PMIC_MTKAIF_RXIF_INVALID_CYCLE_MASK 0xFF
#define PMIC_MTKAIF_RXIF_INVALID_CYCLE_SHIFT 0
#define PMIC_MTKAIF_RXIF_INVALID_FLAG_ADDR MT6356_AFE_ADDA_MTKAIF_MON1
#define PMIC_MTKAIF_RXIF_INVALID_FLAG_MASK 0x1
#define PMIC_MTKAIF_RXIF_INVALID_FLAG_SHIFT 8
#define PMIC_MTKAIF_RXIF_SEARCH_FAIL_FLAG_ADDR MT6356_AFE_ADDA_MTKAIF_MON1
#define PMIC_MTKAIF_RXIF_SEARCH_FAIL_FLAG_MASK 0x1
#define PMIC_MTKAIF_RXIF_SEARCH_FAIL_FLAG_SHIFT 11
#define PMIC_MTKAIFRX_V3_SDATA_IN1_ADDR MT6356_AFE_ADDA_MTKAIF_MON1
#define PMIC_MTKAIFRX_V3_SDATA_IN1_MASK 0x1
#define PMIC_MTKAIFRX_V3_SDATA_IN1_SHIFT 12
#define PMIC_MTKAIFRX_V3_SDATA_IN2_ADDR MT6356_AFE_ADDA_MTKAIF_MON1
#define PMIC_MTKAIFRX_V3_SDATA_IN2_MASK 0x1
#define PMIC_MTKAIFRX_V3_SDATA_IN2_SHIFT 13
#define PMIC_MTKAIFRX_V3_SYNC_IN_ADDR MT6356_AFE_ADDA_MTKAIF_MON1
#define PMIC_MTKAIFRX_V3_SYNC_IN_MASK 0x1
#define PMIC_MTKAIFRX_V3_SYNC_IN_SHIFT 14
#define PMIC_MTKAIF_TXIF_IN_CH1_ADDR MT6356_AFE_ADDA_MTKAIF_MON2
#define PMIC_MTKAIF_TXIF_IN_CH1_MASK 0xFF
#define PMIC_MTKAIF_TXIF_IN_CH1_SHIFT 0
#define PMIC_MTKAIF_TXIF_IN_CH2_ADDR MT6356_AFE_ADDA_MTKAIF_MON2
#define PMIC_MTKAIF_TXIF_IN_CH2_MASK 0xFF
#define PMIC_MTKAIF_TXIF_IN_CH2_SHIFT 8
#define PMIC_MTKAIF_RXIF_OUT_CH1_ADDR MT6356_AFE_ADDA_MTKAIF_MON3
#define PMIC_MTKAIF_RXIF_OUT_CH1_MASK 0xFF
#define PMIC_MTKAIF_RXIF_OUT_CH1_SHIFT 0
#define PMIC_MTKAIF_RXIF_OUT_CH2_ADDR MT6356_AFE_ADDA_MTKAIF_MON3
#define PMIC_MTKAIF_RXIF_OUT_CH2_MASK 0xFF
#define PMIC_MTKAIF_RXIF_OUT_CH2_SHIFT 8
#define PMIC_RG_MTKAIF_LOOPBACK_TEST1_ADDR MT6356_AFE_ADDA_MTKAIF_CFG0
#define PMIC_RG_MTKAIF_LOOPBACK_TEST1_MASK 0x1
#define PMIC_RG_MTKAIF_LOOPBACK_TEST1_SHIFT 0
#define PMIC_RG_MTKAIF_LOOPBACK_TEST2_ADDR MT6356_AFE_ADDA_MTKAIF_CFG0
#define PMIC_RG_MTKAIF_LOOPBACK_TEST2_MASK 0x1
#define PMIC_RG_MTKAIF_LOOPBACK_TEST2_SHIFT 1
#define PMIC_RG_MTKAIF_PMIC_TXIF_8TO5_ADDR MT6356_AFE_ADDA_MTKAIF_CFG0
#define PMIC_RG_MTKAIF_PMIC_TXIF_8TO5_MASK 0x1
#define PMIC_RG_MTKAIF_PMIC_TXIF_8TO5_SHIFT 2
#define PMIC_RG_MTKAIF_TXIF_PROTOCOL2_ADDR MT6356_AFE_ADDA_MTKAIF_CFG0
#define PMIC_RG_MTKAIF_TXIF_PROTOCOL2_MASK 0x1
#define PMIC_RG_MTKAIF_TXIF_PROTOCOL2_SHIFT 4
#define PMIC_RG_MTKAIF_RXIF_PROTOCOL2_ADDR MT6356_AFE_ADDA_MTKAIF_CFG0
#define PMIC_RG_MTKAIF_RXIF_PROTOCOL2_MASK 0x1
#define PMIC_RG_MTKAIF_RXIF_PROTOCOL2_SHIFT 8
#define PMIC_RG_MTKAIF_RXIF_CLKINV_ADDR MT6356_AFE_ADDA_MTKAIF_CFG0
#define PMIC_RG_MTKAIF_RXIF_CLKINV_MASK 0x1
#define PMIC_RG_MTKAIF_RXIF_CLKINV_SHIFT 15
#define PMIC_RG_MTKAIF_RXIF_DATA_MODE_ADDR MT6356_AFE_ADDA_MTKAIF_RX_CFG0
#define PMIC_RG_MTKAIF_RXIF_DATA_MODE_MASK 0x1
#define PMIC_RG_MTKAIF_RXIF_DATA_MODE_SHIFT 0
#define PMIC_RG_MTKAIF_RXIF_DETECT_ON_ADDR MT6356_AFE_ADDA_MTKAIF_RX_CFG0
#define PMIC_RG_MTKAIF_RXIF_DETECT_ON_MASK 0x1
#define PMIC_RG_MTKAIF_RXIF_DETECT_ON_SHIFT 3
#define PMIC_RG_MTKAIF_RXIF_FIFO_RSP_ADDR MT6356_AFE_ADDA_MTKAIF_RX_CFG0
#define PMIC_RG_MTKAIF_RXIF_FIFO_RSP_MASK 0x7
#define PMIC_RG_MTKAIF_RXIF_FIFO_RSP_SHIFT 4
#define PMIC_RG_MTKAIF_RXIF_DATA_BIT_ADDR MT6356_AFE_ADDA_MTKAIF_RX_CFG0
#define PMIC_RG_MTKAIF_RXIF_DATA_BIT_MASK 0x7
#define PMIC_RG_MTKAIF_RXIF_DATA_BIT_SHIFT 8
#define PMIC_RG_MTKAIF_RXIF_VOICE_MODE_ADDR MT6356_AFE_ADDA_MTKAIF_RX_CFG0
#define PMIC_RG_MTKAIF_RXIF_VOICE_MODE_MASK 0xF
#define PMIC_RG_MTKAIF_RXIF_VOICE_MODE_SHIFT 12
#define PMIC_RG_MTKAIF_RXIF_VOICE_MODE_PROTOCOL2_ADDR                         \
	MT6356_AFE_ADDA_MTKAIF_RX_CFG1
#define PMIC_RG_MTKAIF_RXIF_VOICE_MODE_PROTOCOL2_MASK 0xF
#define PMIC_RG_MTKAIF_RXIF_VOICE_MODE_PROTOCOL2_SHIFT 0
#define PMIC_RG_MTKAIF_RXIF_SYNC_CHECK_ROUND_ADDR                             \
	MT6356_AFE_ADDA_MTKAIF_RX_CFG1
#define PMIC_RG_MTKAIF_RXIF_SYNC_CHECK_ROUND_MASK 0xF
#define PMIC_RG_MTKAIF_RXIF_SYNC_CHECK_ROUND_SHIFT 4
#define PMIC_RG_MTKAIF_RXIF_INVALID_SYNC_CHECK_ROUND_ADDR                     \
	MT6356_AFE_ADDA_MTKAIF_RX_CFG1
#define PMIC_RG_MTKAIF_RXIF_INVALID_SYNC_CHECK_ROUND_MASK 0xF
#define PMIC_RG_MTKAIF_RXIF_INVALID_SYNC_CHECK_ROUND_SHIFT 8
#define PMIC_RG_MTKAIF_RXIF_SYNC_SEARCH_TABLE_ADDR                            \
	MT6356_AFE_ADDA_MTKAIF_RX_CFG1
#define PMIC_RG_MTKAIF_RXIF_SYNC_SEARCH_TABLE_MASK 0xF
#define PMIC_RG_MTKAIF_RXIF_SYNC_SEARCH_TABLE_SHIFT 12
#define PMIC_RG_MTKAIF_RXIF_SYNC_CNT_TABLE_ADDR MT6356_AFE_ADDA_MTKAIF_RX_CFG2
#define PMIC_RG_MTKAIF_RXIF_SYNC_CNT_TABLE_MASK 0xFFF
#define PMIC_RG_MTKAIF_RXIF_SYNC_CNT_TABLE_SHIFT 0
#define PMIC_RG_MTKAIF_RXIF_CLEAR_SYNC_FAIL_ADDR MT6356_AFE_ADDA_MTKAIF_RX_CFG2
#define PMIC_RG_MTKAIF_RXIF_CLEAR_SYNC_FAIL_MASK 0x1
#define PMIC_RG_MTKAIF_RXIF_CLEAR_SYNC_FAIL_SHIFT 12
#define PMIC_RG_MTKAIF_RXIF_DETECT_ON_PROTOCOL2_ADDR                          \
	MT6356_AFE_ADDA_MTKAIF_RX_CFG3
#define PMIC_RG_MTKAIF_RXIF_DETECT_ON_PROTOCOL2_MASK 0x1
#define PMIC_RG_MTKAIF_RXIF_DETECT_ON_PROTOCOL2_SHIFT 3
#define PMIC_RG_MTKAIF_RXIF_FIFO_RSP_PROTOCOL2_ADDR                           \
	MT6356_AFE_ADDA_MTKAIF_RX_CFG3
#define PMIC_RG_MTKAIF_RXIF_FIFO_RSP_PROTOCOL2_MASK 0x7
#define PMIC_RG_MTKAIF_RXIF_FIFO_RSP_PROTOCOL2_SHIFT 4
#define PMIC_RG_MTKAIF_RXIF_DELAY_DATA_ADDR MT6356_AFE_ADDA_MTKAIF_RX_CFG3
#define PMIC_RG_MTKAIF_RXIF_DELAY_DATA_MASK 0x1
#define PMIC_RG_MTKAIF_RXIF_DELAY_DATA_SHIFT 8
#define PMIC_RG_MTKAIF_RXIF_DELAY_CYCLE_ADDR MT6356_AFE_ADDA_MTKAIF_RX_CFG3
#define PMIC_RG_MTKAIF_RXIF_DELAY_CYCLE_MASK 0xF
#define PMIC_RG_MTKAIF_RXIF_DELAY_CYCLE_SHIFT 12
#define PMIC_RG_MTKAIF_SYNC_WORD1_ADDR MT6356_AFE_ADDA_MTKAIF_TX_CFG1
#define PMIC_RG_MTKAIF_SYNC_WORD1_MASK 0x7
#define PMIC_RG_MTKAIF_SYNC_WORD1_SHIFT 0
#define PMIC_RG_MTKAIF_SYNC_WORD2_ADDR MT6356_AFE_ADDA_MTKAIF_TX_CFG1
#define PMIC_RG_MTKAIF_SYNC_WORD2_MASK 0x7
#define PMIC_RG_MTKAIF_SYNC_WORD2_SHIFT 4
#define PMIC_C_MUTE_SW_CTL_ADDR MT6356_AFE_SGEN_CFG0
#define PMIC_C_MUTE_SW_CTL_MASK 0x1
#define PMIC_C_MUTE_SW_CTL_SHIFT 6
#define PMIC_C_DAC_EN_CTL_ADDR MT6356_AFE_SGEN_CFG0
#define PMIC_C_DAC_EN_CTL_MASK 0x1
#define PMIC_C_DAC_EN_CTL_SHIFT 7
#define PMIC_C_AMP_DIV_CH1_CTL_ADDR MT6356_AFE_SGEN_CFG0
#define PMIC_C_AMP_DIV_CH1_CTL_MASK 0xF
#define PMIC_C_AMP_DIV_CH1_CTL_SHIFT 12
#define PMIC_C_FREQ_DIV_CH1_CTL_ADDR MT6356_AFE_SGEN_CFG1
#define PMIC_C_FREQ_DIV_CH1_CTL_MASK 0x1F
#define PMIC_C_FREQ_DIV_CH1_CTL_SHIFT 0
#define PMIC_C_SGEN_RCH_INV_8BIT_ADDR MT6356_AFE_SGEN_CFG1
#define PMIC_C_SGEN_RCH_INV_8BIT_MASK 0x1
#define PMIC_C_SGEN_RCH_INV_8BIT_SHIFT 14
#define PMIC_C_SGEN_RCH_INV_5BIT_ADDR MT6356_AFE_SGEN_CFG1
#define PMIC_C_SGEN_RCH_INV_5BIT_MASK 0x1
#define PMIC_C_SGEN_RCH_INV_5BIT_SHIFT 15
#define PMIC_RG_AMIC_UL_ADC_CLK_SEL_ADDR MT6356_AFE_ADC_ASYNC_FIFO_CFG
#define PMIC_RG_AMIC_UL_ADC_CLK_SEL_MASK 0x1
#define PMIC_RG_AMIC_UL_ADC_CLK_SEL_SHIFT 1
#define PMIC_RG_UL_ASYNC_FIFO_SOFT_RST_ADDR MT6356_AFE_ADC_ASYNC_FIFO_CFG
#define PMIC_RG_UL_ASYNC_FIFO_SOFT_RST_MASK 0x1
#define PMIC_RG_UL_ASYNC_FIFO_SOFT_RST_SHIFT 4
#define PMIC_RG_UL_ASYNC_FIFO_SOFT_RST_EN_ADDR MT6356_AFE_ADC_ASYNC_FIFO_CFG
#define PMIC_RG_UL_ASYNC_FIFO_SOFT_RST_EN_MASK 0x1
#define PMIC_RG_UL_ASYNC_FIFO_SOFT_RST_EN_SHIFT 5
#define PMIC_DCCLK_GEN_ON_ADDR MT6356_AFE_DCCLK_CFG0
#define PMIC_DCCLK_GEN_ON_MASK 0x1
#define PMIC_DCCLK_GEN_ON_SHIFT 0
#define PMIC_DCCLK_PDN_ADDR MT6356_AFE_DCCLK_CFG0
#define PMIC_DCCLK_PDN_MASK 0x1
#define PMIC_DCCLK_PDN_SHIFT 1
#define PMIC_DCCLK_REF_CK_SEL_ADDR MT6356_AFE_DCCLK_CFG0
#define PMIC_DCCLK_REF_CK_SEL_MASK 0x3
#define PMIC_DCCLK_REF_CK_SEL_SHIFT 2
#define PMIC_DCCLK_INV_ADDR MT6356_AFE_DCCLK_CFG0
#define PMIC_DCCLK_INV_MASK 0x1
#define PMIC_DCCLK_INV_SHIFT 4
#define PMIC_DCCLK_DIV_ADDR MT6356_AFE_DCCLK_CFG0
#define PMIC_DCCLK_DIV_MASK 0x7FF
#define PMIC_DCCLK_DIV_SHIFT 5
#define PMIC_DA_AUDVOWCLK_BUCKOSC_DIV_ADDR MT6356_AFE_DCCLK_CFG1
#define PMIC_DA_AUDVOWCLK_BUCKOSC_DIV_MASK 0xF
#define PMIC_DA_AUDVOWCLK_BUCKOSC_DIV_SHIFT 0
#define PMIC_DCCLK_PHASE_SEL_ADDR MT6356_AFE_DCCLK_CFG1
#define PMIC_DCCLK_PHASE_SEL_MASK 0xF
#define PMIC_DCCLK_PHASE_SEL_SHIFT 4
#define PMIC_DCCLK_RESYNC_BYPASS_ADDR MT6356_AFE_DCCLK_CFG1
#define PMIC_DCCLK_RESYNC_BYPASS_MASK 0x1
#define PMIC_DCCLK_RESYNC_BYPASS_SHIFT 8
#define PMIC_RESYNC_SRC_CK_INV_ADDR MT6356_AFE_DCCLK_CFG1
#define PMIC_RESYNC_SRC_CK_INV_MASK 0x1
#define PMIC_RESYNC_SRC_CK_INV_SHIFT 9
#define PMIC_RESYNC_SRC_SEL_ADDR MT6356_AFE_DCCLK_CFG1
#define PMIC_RESYNC_SRC_SEL_MASK 0x3
#define PMIC_RESYNC_SRC_SEL_SHIFT 10
#define PMIC_DA_AUDVOWCLK_BUCKOSC_PDN_ADDR MT6356_AFE_DCCLK_CFG1
#define PMIC_DA_AUDVOWCLK_BUCKOSC_PDN_MASK 0x1
#define PMIC_DA_AUDVOWCLK_BUCKOSC_PDN_SHIFT 12
#define PMIC_AUDIO_DIG_CFG_ADDR MT6356_AUDIO_DIG_CFG
#define PMIC_AUDIO_DIG_CFG_MASK 0xFFFF
#define PMIC_AUDIO_DIG_CFG_SHIFT 0
#define PMIC_ADDA_AUD_PAD_TOP_CFG_ADDR MT6356_AFE_AUD_PAD_TOP
#define PMIC_ADDA_AUD_PAD_TOP_CFG_MASK 0xFFFF
#define PMIC_ADDA_AUD_PAD_TOP_CFG_SHIFT 0
#define PMIC_ADDA_AUD_PAD_TOP_MON_ADDR MT6356_AFE_AUD_PAD_TOP_MON
#define PMIC_ADDA_AUD_PAD_TOP_MON_MASK 0xFFFF
#define PMIC_ADDA_AUD_PAD_TOP_MON_SHIFT 0
#define PMIC_ADDA_AUD_PAD_TOP_MON1_ADDR MT6356_AFE_AUD_PAD_TOP_MON1
#define PMIC_ADDA_AUD_PAD_TOP_MON1_MASK 0xFFFF
#define PMIC_ADDA_AUD_PAD_TOP_MON1_SHIFT 0
#define PMIC_AUDENC_ANA_ID_ADDR MT6356_AUDENC_DSN_ID
#define PMIC_AUDENC_ANA_ID_MASK 0xFF
#define PMIC_AUDENC_ANA_ID_SHIFT 0
#define PMIC_AUDENC_DIG_ID_ADDR MT6356_AUDENC_DSN_ID
#define PMIC_AUDENC_DIG_ID_MASK 0xFF
#define PMIC_AUDENC_DIG_ID_SHIFT 8
#define PMIC_AUDENC_ANA_MINOR_REV_ADDR MT6356_AUDENC_DSN_REV0
#define PMIC_AUDENC_ANA_MINOR_REV_MASK 0xF
#define PMIC_AUDENC_ANA_MINOR_REV_SHIFT 0
#define PMIC_AUDENC_ANA_MAJOR_REV_ADDR MT6356_AUDENC_DSN_REV0
#define PMIC_AUDENC_ANA_MAJOR_REV_MASK 0xF
#define PMIC_AUDENC_ANA_MAJOR_REV_SHIFT 4
#define PMIC_AUDENC_DIG_MINOR_REV_ADDR MT6356_AUDENC_DSN_REV0
#define PMIC_AUDENC_DIG_MINOR_REV_MASK 0xF
#define PMIC_AUDENC_DIG_MINOR_REV_SHIFT 8
#define PMIC_AUDENC_DIG_MAJOR_REV_ADDR MT6356_AUDENC_DSN_REV0
#define PMIC_AUDENC_DIG_MAJOR_REV_MASK 0xF
#define PMIC_AUDENC_DIG_MAJOR_REV_SHIFT 12
#define PMIC_AUDENC_SW_MINOR_REV_ADDR MT6356_AUDENC_DSN_REV1
#define PMIC_AUDENC_SW_MINOR_REV_MASK 0xF
#define PMIC_AUDENC_SW_MINOR_REV_SHIFT 0
#define PMIC_AUDENC_SW_MAJOR_REV_ADDR MT6356_AUDENC_DSN_REV1
#define PMIC_AUDENC_SW_MAJOR_REV_MASK 0xF
#define PMIC_AUDENC_SW_MAJOR_REV_SHIFT 4
#define PMIC_AUDENC_ESP_ADDR MT6356_AUDENC_DSN_REV1
#define PMIC_AUDENC_ESP_MASK 0xFF
#define PMIC_AUDENC_ESP_SHIFT 8
#define PMIC_RG_AUDPREAMPLON_ADDR MT6356_AUDENC_ANA_CON0
#define PMIC_RG_AUDPREAMPLON_MASK 0x1
#define PMIC_RG_AUDPREAMPLON_SHIFT 0
#define PMIC_RG_AUDPREAMPLDCCEN_ADDR MT6356_AUDENC_ANA_CON0
#define PMIC_RG_AUDPREAMPLDCCEN_MASK 0x1
#define PMIC_RG_AUDPREAMPLDCCEN_SHIFT 1
#define PMIC_RG_AUDPREAMPLDCRPECHARGE_ADDR MT6356_AUDENC_ANA_CON0
#define PMIC_RG_AUDPREAMPLDCRPECHARGE_MASK 0x1
#define PMIC_RG_AUDPREAMPLDCRPECHARGE_SHIFT 2
#define PMIC_RG_AUDPREAMPLPGATEST_ADDR MT6356_AUDENC_ANA_CON0
#define PMIC_RG_AUDPREAMPLPGATEST_MASK 0x1
#define PMIC_RG_AUDPREAMPLPGATEST_SHIFT 3
#define PMIC_RG_AUDPREAMPLVSCALE_ADDR MT6356_AUDENC_ANA_CON0
#define PMIC_RG_AUDPREAMPLVSCALE_MASK 0x3
#define PMIC_RG_AUDPREAMPLVSCALE_SHIFT 4
#define PMIC_RG_AUDPREAMPLINPUTSEL_ADDR MT6356_AUDENC_ANA_CON0
#define PMIC_RG_AUDPREAMPLINPUTSEL_MASK 0x3
#define PMIC_RG_AUDPREAMPLINPUTSEL_SHIFT 6
#define PMIC_RG_AUDPREAMPLGAIN_ADDR MT6356_AUDENC_ANA_CON0
#define PMIC_RG_AUDPREAMPLGAIN_MASK 0x7
#define PMIC_RG_AUDPREAMPLGAIN_SHIFT 8
#define PMIC_RG_AUDADCLPWRUP_ADDR MT6356_AUDENC_ANA_CON0
#define PMIC_RG_AUDADCLPWRUP_MASK 0x1
#define PMIC_RG_AUDADCLPWRUP_SHIFT 12
#define PMIC_RG_AUDADCLINPUTSEL_ADDR MT6356_AUDENC_ANA_CON0
#define PMIC_RG_AUDADCLINPUTSEL_MASK 0x3
#define PMIC_RG_AUDADCLINPUTSEL_SHIFT 13
#define PMIC_RG_AUDPREAMPRON_ADDR MT6356_AUDENC_ANA_CON1
#define PMIC_RG_AUDPREAMPRON_MASK 0x1
#define PMIC_RG_AUDPREAMPRON_SHIFT 0
#define PMIC_RG_AUDPREAMPRDCCEN_ADDR MT6356_AUDENC_ANA_CON1
#define PMIC_RG_AUDPREAMPRDCCEN_MASK 0x1
#define PMIC_RG_AUDPREAMPRDCCEN_SHIFT 1
#define PMIC_RG_AUDPREAMPRDCRPECHARGE_ADDR MT6356_AUDENC_ANA_CON1
#define PMIC_RG_AUDPREAMPRDCRPECHARGE_MASK 0x1
#define PMIC_RG_AUDPREAMPRDCRPECHARGE_SHIFT 2
#define PMIC_RG_AUDPREAMPRPGATEST_ADDR MT6356_AUDENC_ANA_CON1
#define PMIC_RG_AUDPREAMPRPGATEST_MASK 0x1
#define PMIC_RG_AUDPREAMPRPGATEST_SHIFT 3
#define PMIC_RG_AUDPREAMPRVSCALE_ADDR MT6356_AUDENC_ANA_CON1
#define PMIC_RG_AUDPREAMPRVSCALE_MASK 0x3
#define PMIC_RG_AUDPREAMPRVSCALE_SHIFT 4
#define PMIC_RG_AUDPREAMPRINPUTSEL_ADDR MT6356_AUDENC_ANA_CON1
#define PMIC_RG_AUDPREAMPRINPUTSEL_MASK 0x3
#define PMIC_RG_AUDPREAMPRINPUTSEL_SHIFT 6
#define PMIC_RG_AUDPREAMPRGAIN_ADDR MT6356_AUDENC_ANA_CON1
#define PMIC_RG_AUDPREAMPRGAIN_MASK 0x7
#define PMIC_RG_AUDPREAMPRGAIN_SHIFT 8
#define PMIC_RG_AUDADCRPWRUP_ADDR MT6356_AUDENC_ANA_CON1
#define PMIC_RG_AUDADCRPWRUP_MASK 0x1
#define PMIC_RG_AUDADCRPWRUP_SHIFT 12
#define PMIC_RG_AUDADCRINPUTSEL_ADDR MT6356_AUDENC_ANA_CON1
#define PMIC_RG_AUDADCRINPUTSEL_MASK 0x3
#define PMIC_RG_AUDADCRINPUTSEL_SHIFT 13
#define PMIC_RG_AUDULHALFBIAS_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDULHALFBIAS_MASK 0x1
#define PMIC_RG_AUDULHALFBIAS_SHIFT 0
#define PMIC_RG_AUDGLBMADLPWEN_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDGLBMADLPWEN_MASK 0x1
#define PMIC_RG_AUDGLBMADLPWEN_SHIFT 1
#define PMIC_RG_AUDPREAMPLPEN_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDPREAMPLPEN_MASK 0x1
#define PMIC_RG_AUDPREAMPLPEN_SHIFT 2
#define PMIC_RG_AUDADC1STSTAGELPEN_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDADC1STSTAGELPEN_MASK 0x1
#define PMIC_RG_AUDADC1STSTAGELPEN_SHIFT 3
#define PMIC_RG_AUDADC2NDSTAGELPEN_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDADC2NDSTAGELPEN_MASK 0x1
#define PMIC_RG_AUDADC2NDSTAGELPEN_SHIFT 4
#define PMIC_RG_AUDADCFLASHLPEN_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDADCFLASHLPEN_MASK 0x1
#define PMIC_RG_AUDADCFLASHLPEN_SHIFT 5
#define PMIC_RG_AUDPREAMPIDDTEST_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDPREAMPIDDTEST_MASK 0x3
#define PMIC_RG_AUDPREAMPIDDTEST_SHIFT 6
#define PMIC_RG_AUDADC1STSTAGEIDDTEST_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDADC1STSTAGEIDDTEST_MASK 0x3
#define PMIC_RG_AUDADC1STSTAGEIDDTEST_SHIFT 8
#define PMIC_RG_AUDADC2NDSTAGEIDDTEST_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDADC2NDSTAGEIDDTEST_MASK 0x3
#define PMIC_RG_AUDADC2NDSTAGEIDDTEST_SHIFT 10
#define PMIC_RG_AUDADCREFBUFIDDTEST_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDADCREFBUFIDDTEST_MASK 0x3
#define PMIC_RG_AUDADCREFBUFIDDTEST_SHIFT 12
#define PMIC_RG_AUDADCFLASHIDDTEST_ADDR MT6356_AUDENC_ANA_CON2
#define PMIC_RG_AUDADCFLASHIDDTEST_MASK 0x3
#define PMIC_RG_AUDADCFLASHIDDTEST_SHIFT 14
#define PMIC_RG_AUDADCDAC0P25FS_ADDR MT6356_AUDENC_ANA_CON3
#define PMIC_RG_AUDADCDAC0P25FS_MASK 0x1
#define PMIC_RG_AUDADCDAC0P25FS_SHIFT 0
#define PMIC_RG_AUDADCCLKSEL_ADDR MT6356_AUDENC_ANA_CON3
#define PMIC_RG_AUDADCCLKSEL_MASK 0x1
#define PMIC_RG_AUDADCCLKSEL_SHIFT 1
#define PMIC_RG_AUDADCCLKSOURCE_ADDR MT6356_AUDENC_ANA_CON3
#define PMIC_RG_AUDADCCLKSOURCE_MASK 0x3
#define PMIC_RG_AUDADCCLKSOURCE_SHIFT 2
#define PMIC_RG_AUDPREAMPAAFEN_ADDR MT6356_AUDENC_ANA_CON3
#define PMIC_RG_AUDPREAMPAAFEN_MASK 0x1
#define PMIC_RG_AUDPREAMPAAFEN_SHIFT 8
#define PMIC_RG_DCCVCMBUFLPMODSEL_ADDR MT6356_AUDENC_ANA_CON3
#define PMIC_RG_DCCVCMBUFLPMODSEL_MASK 0x1
#define PMIC_RG_DCCVCMBUFLPMODSEL_SHIFT 9
#define PMIC_RG_DCCVCMBUFLPSWEN_ADDR MT6356_AUDENC_ANA_CON3
#define PMIC_RG_DCCVCMBUFLPSWEN_MASK 0x1
#define PMIC_RG_DCCVCMBUFLPSWEN_SHIFT 10
#define PMIC_RG_AUDSPAREPGA_ADDR MT6356_AUDENC_ANA_CON3
#define PMIC_RG_AUDSPAREPGA_MASK 0x1
#define PMIC_RG_AUDSPAREPGA_SHIFT 11
#define PMIC_RG_AUDADC1STSTAGESDENB_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADC1STSTAGESDENB_MASK 0x1
#define PMIC_RG_AUDADC1STSTAGESDENB_SHIFT 0
#define PMIC_RG_AUDADC2NDSTAGERESET_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADC2NDSTAGERESET_MASK 0x1
#define PMIC_RG_AUDADC2NDSTAGERESET_SHIFT 1
#define PMIC_RG_AUDADC3RDSTAGERESET_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADC3RDSTAGERESET_MASK 0x1
#define PMIC_RG_AUDADC3RDSTAGERESET_SHIFT 2
#define PMIC_RG_AUDADCFSRESET_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCFSRESET_MASK 0x1
#define PMIC_RG_AUDADCFSRESET_SHIFT 3
#define PMIC_RG_AUDADCWIDECM_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCWIDECM_MASK 0x1
#define PMIC_RG_AUDADCWIDECM_SHIFT 4
#define PMIC_RG_AUDADCNOPATEST_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCNOPATEST_MASK 0x1
#define PMIC_RG_AUDADCNOPATEST_SHIFT 5
#define PMIC_RG_AUDADCBYPASS_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCBYPASS_MASK 0x1
#define PMIC_RG_AUDADCBYPASS_SHIFT 6
#define PMIC_RG_AUDADCFFBYPASS_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCFFBYPASS_MASK 0x1
#define PMIC_RG_AUDADCFFBYPASS_SHIFT 7
#define PMIC_RG_AUDADCDACFBCURRENT_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCDACFBCURRENT_MASK 0x1
#define PMIC_RG_AUDADCDACFBCURRENT_SHIFT 8
#define PMIC_RG_AUDADCDACIDDTEST_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCDACIDDTEST_MASK 0x3
#define PMIC_RG_AUDADCDACIDDTEST_SHIFT 9
#define PMIC_RG_AUDADCDACNRZ_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCDACNRZ_MASK 0x1
#define PMIC_RG_AUDADCDACNRZ_SHIFT 11
#define PMIC_RG_AUDADCNODEM_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCNODEM_MASK 0x1
#define PMIC_RG_AUDADCNODEM_SHIFT 12
#define PMIC_RG_AUDADCDACTEST_ADDR MT6356_AUDENC_ANA_CON4
#define PMIC_RG_AUDADCDACTEST_MASK 0x1
#define PMIC_RG_AUDADCDACTEST_SHIFT 13
#define PMIC_RG_AUDADCTESTDATA_ADDR MT6356_AUDENC_ANA_CON5
#define PMIC_RG_AUDADCTESTDATA_MASK 0xFFFF
#define PMIC_RG_AUDADCTESTDATA_SHIFT 0
#define PMIC_RG_AUDRCTUNEL_ADDR MT6356_AUDENC_ANA_CON6
#define PMIC_RG_AUDRCTUNEL_MASK 0x1F
#define PMIC_RG_AUDRCTUNEL_SHIFT 0
#define PMIC_RG_AUDRCTUNELSEL_ADDR MT6356_AUDENC_ANA_CON6
#define PMIC_RG_AUDRCTUNELSEL_MASK 0x1
#define PMIC_RG_AUDRCTUNELSEL_SHIFT 5
#define PMIC_RG_AUDRCTUNER_ADDR MT6356_AUDENC_ANA_CON6
#define PMIC_RG_AUDRCTUNER_MASK 0x1F
#define PMIC_RG_AUDRCTUNER_SHIFT 8
#define PMIC_RG_AUDRCTUNERSEL_ADDR MT6356_AUDENC_ANA_CON6
#define PMIC_RG_AUDRCTUNERSEL_MASK 0x1
#define PMIC_RG_AUDRCTUNERSEL_SHIFT 13
#define PMIC_RG_AUDSPAREVA28_ADDR MT6356_AUDENC_ANA_CON7
#define PMIC_RG_AUDSPAREVA28_MASK 0xF
#define PMIC_RG_AUDSPAREVA28_SHIFT 0
#define PMIC_RG_AUDSPAREVA18_ADDR MT6356_AUDENC_ANA_CON7
#define PMIC_RG_AUDSPAREVA18_MASK 0xF
#define PMIC_RG_AUDSPAREVA18_SHIFT 4
#define PMIC_RG_AUDENCSPAREVA28_ADDR MT6356_AUDENC_ANA_CON7
#define PMIC_RG_AUDENCSPAREVA28_MASK 0xF
#define PMIC_RG_AUDENCSPAREVA28_SHIFT 8
#define PMIC_RG_AUDENCSPAREVA18_ADDR MT6356_AUDENC_ANA_CON7
#define PMIC_RG_AUDENCSPAREVA18_MASK 0xF
#define PMIC_RG_AUDENCSPAREVA18_SHIFT 12
#define PMIC_RG_AUDDIGMICEN_ADDR MT6356_AUDENC_ANA_CON8
#define PMIC_RG_AUDDIGMICEN_MASK 0x1
#define PMIC_RG_AUDDIGMICEN_SHIFT 0
#define PMIC_RG_AUDDIGMICBIAS_ADDR MT6356_AUDENC_ANA_CON8
#define PMIC_RG_AUDDIGMICBIAS_MASK 0x3
#define PMIC_RG_AUDDIGMICBIAS_SHIFT 1
#define PMIC_RG_DMICHPCLKEN_ADDR MT6356_AUDENC_ANA_CON8
#define PMIC_RG_DMICHPCLKEN_MASK 0x1
#define PMIC_RG_DMICHPCLKEN_SHIFT 3
#define PMIC_RG_AUDDIGMICPDUTY_ADDR MT6356_AUDENC_ANA_CON8
#define PMIC_RG_AUDDIGMICPDUTY_MASK 0x3
#define PMIC_RG_AUDDIGMICPDUTY_SHIFT 4
#define PMIC_RG_AUDDIGMICNDUTY_ADDR MT6356_AUDENC_ANA_CON8
#define PMIC_RG_AUDDIGMICNDUTY_MASK 0x3
#define PMIC_RG_AUDDIGMICNDUTY_SHIFT 6
#define PMIC_RG_DMICMONEN_ADDR MT6356_AUDENC_ANA_CON8
#define PMIC_RG_DMICMONEN_MASK 0x1
#define PMIC_RG_DMICMONEN_SHIFT 8
#define PMIC_RG_DMICMONSEL_ADDR MT6356_AUDENC_ANA_CON8
#define PMIC_RG_DMICMONSEL_MASK 0x7
#define PMIC_RG_DMICMONSEL_SHIFT 9
#define PMIC_RG_AUDSPAREVMIC_ADDR MT6356_AUDENC_ANA_CON8
#define PMIC_RG_AUDSPAREVMIC_MASK 0xF
#define PMIC_RG_AUDSPAREVMIC_SHIFT 12
#define PMIC_RG_AUDPWDBMICBIAS0_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDPWDBMICBIAS0_MASK 0x1
#define PMIC_RG_AUDPWDBMICBIAS0_SHIFT 0
#define PMIC_RG_AUDMICBIAS0BYPASSEN_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDMICBIAS0BYPASSEN_MASK 0x1
#define PMIC_RG_AUDMICBIAS0BYPASSEN_SHIFT 1
#define PMIC_RG_AUDMICBIAS0LOWPEN_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDMICBIAS0LOWPEN_MASK 0x1
#define PMIC_RG_AUDMICBIAS0LOWPEN_SHIFT 2
#define PMIC_RG_AUDMICBIAS0VREF_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDMICBIAS0VREF_MASK 0x7
#define PMIC_RG_AUDMICBIAS0VREF_SHIFT 4
#define PMIC_RG_AUDMICBIAS0DCSW0P1EN_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDMICBIAS0DCSW0P1EN_MASK 0x1
#define PMIC_RG_AUDMICBIAS0DCSW0P1EN_SHIFT 8
#define PMIC_RG_AUDMICBIAS0DCSW0P2EN_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDMICBIAS0DCSW0P2EN_MASK 0x1
#define PMIC_RG_AUDMICBIAS0DCSW0P2EN_SHIFT 9
#define PMIC_RG_AUDMICBIAS0DCSW0NEN_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDMICBIAS0DCSW0NEN_MASK 0x1
#define PMIC_RG_AUDMICBIAS0DCSW0NEN_SHIFT 10
#define PMIC_RG_AUDMICBIAS0DCSW2P1EN_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDMICBIAS0DCSW2P1EN_MASK 0x1
#define PMIC_RG_AUDMICBIAS0DCSW2P1EN_SHIFT 12
#define PMIC_RG_AUDMICBIAS0DCSW2P2EN_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDMICBIAS0DCSW2P2EN_MASK 0x1
#define PMIC_RG_AUDMICBIAS0DCSW2P2EN_SHIFT 13
#define PMIC_RG_AUDMICBIAS0DCSW2NEN_ADDR MT6356_AUDENC_ANA_CON9
#define PMIC_RG_AUDMICBIAS0DCSW2NEN_MASK 0x1
#define PMIC_RG_AUDMICBIAS0DCSW2NEN_SHIFT 14
#define PMIC_RG_AUDPWDBMICBIAS1_ADDR MT6356_AUDENC_ANA_CON10
#define PMIC_RG_AUDPWDBMICBIAS1_MASK 0x1
#define PMIC_RG_AUDPWDBMICBIAS1_SHIFT 0
#define PMIC_RG_AUDMICBIAS1BYPASSEN_ADDR MT6356_AUDENC_ANA_CON10
#define PMIC_RG_AUDMICBIAS1BYPASSEN_MASK 0x1
#define PMIC_RG_AUDMICBIAS1BYPASSEN_SHIFT 1
#define PMIC_RG_AUDMICBIAS1LOWPEN_ADDR MT6356_AUDENC_ANA_CON10
#define PMIC_RG_AUDMICBIAS1LOWPEN_MASK 0x1
#define PMIC_RG_AUDMICBIAS1LOWPEN_SHIFT 2
#define PMIC_RG_AUDMICBIAS1VREF_ADDR MT6356_AUDENC_ANA_CON10
#define PMIC_RG_AUDMICBIAS1VREF_MASK 0x7
#define PMIC_RG_AUDMICBIAS1VREF_SHIFT 4
#define PMIC_RG_AUDMICBIAS1DCSW1PEN_ADDR MT6356_AUDENC_ANA_CON10
#define PMIC_RG_AUDMICBIAS1DCSW1PEN_MASK 0x1
#define PMIC_RG_AUDMICBIAS1DCSW1PEN_SHIFT 8
#define PMIC_RG_AUDMICBIAS1DCSW1NEN_ADDR MT6356_AUDENC_ANA_CON10
#define PMIC_RG_AUDMICBIAS1DCSW1NEN_MASK 0x1
#define PMIC_RG_AUDMICBIAS1DCSW1NEN_SHIFT 9
#define PMIC_RG_BANDGAPGEN_ADDR MT6356_AUDENC_ANA_CON10
#define PMIC_RG_BANDGAPGEN_MASK 0x1
#define PMIC_RG_BANDGAPGEN_SHIFT 12
#define PMIC_RG_AUDACCDETMICBIAS0PULLLOW_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_AUDACCDETMICBIAS0PULLLOW_MASK 0x1
#define PMIC_RG_AUDACCDETMICBIAS0PULLLOW_SHIFT 0
#define PMIC_RG_AUDACCDETMICBIAS1PULLLOW_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_AUDACCDETMICBIAS1PULLLOW_MASK 0x1
#define PMIC_RG_AUDACCDETMICBIAS1PULLLOW_SHIFT 1
#define PMIC_RG_AUDACCDETVIN1PULLLOW_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_AUDACCDETVIN1PULLLOW_MASK 0x1
#define PMIC_RG_AUDACCDETVIN1PULLLOW_SHIFT 2
#define PMIC_RG_AUDACCDETVTHACAL_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_AUDACCDETVTHACAL_MASK 0x1
#define PMIC_RG_AUDACCDETVTHACAL_SHIFT 4
#define PMIC_RG_AUDACCDETVTHBCAL_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_AUDACCDETVTHBCAL_MASK 0x1
#define PMIC_RG_AUDACCDETVTHBCAL_SHIFT 5
#define PMIC_RG_AUDACCDETTVDET_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_AUDACCDETTVDET_MASK 0x1
#define PMIC_RG_AUDACCDETTVDET_SHIFT 6
#define PMIC_RG_ACCDETSEL_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_ACCDETSEL_MASK 0x1
#define PMIC_RG_ACCDETSEL_SHIFT 7
#define PMIC_RG_SWBUFMODSEL_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_SWBUFMODSEL_MASK 0x1
#define PMIC_RG_SWBUFMODSEL_SHIFT 8
#define PMIC_RG_SWBUFSWEN_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_SWBUFSWEN_MASK 0x1
#define PMIC_RG_SWBUFSWEN_SHIFT 9
#define PMIC_RG_EINTCOMPVTH_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_EINTCOMPVTH_MASK 0x1
#define PMIC_RG_EINTCOMPVTH_SHIFT 10
#define PMIC_RG_EINTCONFIGACCDET_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_EINTCONFIGACCDET_MASK 0x1
#define PMIC_RG_EINTCONFIGACCDET_SHIFT 11
#define PMIC_RG_EINTHIRENB_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_EINTHIRENB_MASK 0x1
#define PMIC_RG_EINTHIRENB_SHIFT 12
#define PMIC_RG_ACCDETSPAREVA28_ADDR MT6356_AUDENC_ANA_CON11
#define PMIC_RG_ACCDETSPAREVA28_MASK 0x7
#define PMIC_RG_ACCDETSPAREVA28_SHIFT 13
#define PMIC_RGS_AUDRCTUNELREAD_ADDR MT6356_AUDENC_ANA_CON12
#define PMIC_RGS_AUDRCTUNELREAD_MASK 0x1F
#define PMIC_RGS_AUDRCTUNELREAD_SHIFT 0
#define PMIC_RGS_AUDRCTUNERREAD_ADDR MT6356_AUDENC_ANA_CON12
#define PMIC_RGS_AUDRCTUNERREAD_MASK 0x1F
#define PMIC_RGS_AUDRCTUNERREAD_SHIFT 8
#define PMIC_AUDDEC_ANA_ID_ADDR MT6356_AUDDEC_DSN_ID
#define PMIC_AUDDEC_ANA_ID_MASK 0xFF
#define PMIC_AUDDEC_ANA_ID_SHIFT 0
#define PMIC_AUDDEC_DIG_ID_ADDR MT6356_AUDDEC_DSN_ID
#define PMIC_AUDDEC_DIG_ID_MASK 0xFF
#define PMIC_AUDDEC_DIG_ID_SHIFT 8
#define PMIC_AUDDEC_ANA_MINOR_REV_ADDR MT6356_AUDDEC_DSN_REV0
#define PMIC_AUDDEC_ANA_MINOR_REV_MASK 0xF
#define PMIC_AUDDEC_ANA_MINOR_REV_SHIFT 0
#define PMIC_AUDDEC_ANA_MAJOR_REV_ADDR MT6356_AUDDEC_DSN_REV0
#define PMIC_AUDDEC_ANA_MAJOR_REV_MASK 0xF
#define PMIC_AUDDEC_ANA_MAJOR_REV_SHIFT 4
#define PMIC_AUDDEC_DIG_MINOR_REV_ADDR MT6356_AUDDEC_DSN_REV0
#define PMIC_AUDDEC_DIG_MINOR_REV_MASK 0xF
#define PMIC_AUDDEC_DIG_MINOR_REV_SHIFT 8
#define PMIC_AUDDEC_DIG_MAJOR_REV_ADDR MT6356_AUDDEC_DSN_REV0
#define PMIC_AUDDEC_DIG_MAJOR_REV_MASK 0xF
#define PMIC_AUDDEC_DIG_MAJOR_REV_SHIFT 12
#define PMIC_AUDDEC_SW_MINOR_REV_ADDR MT6356_AUDDEC_DSN_REV1
#define PMIC_AUDDEC_SW_MINOR_REV_MASK 0xF
#define PMIC_AUDDEC_SW_MINOR_REV_SHIFT 0
#define PMIC_AUDDEC_SW_MAJOR_REV_ADDR MT6356_AUDDEC_DSN_REV1
#define PMIC_AUDDEC_SW_MAJOR_REV_MASK 0xF
#define PMIC_AUDDEC_SW_MAJOR_REV_SHIFT 4
#define PMIC_AUDDEC_ESP_ADDR MT6356_AUDDEC_DSN_REV1
#define PMIC_AUDDEC_ESP_MASK 0xFF
#define PMIC_AUDDEC_ESP_SHIFT 8
#define PMIC_RG_AUDDACLPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDDACLPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDDACLPWRUP_VAUDP15_SHIFT 0
#define PMIC_RG_AUDDACRPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDDACRPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDDACRPWRUP_VAUDP15_SHIFT 1
#define PMIC_RG_AUD_DAC_PWR_UP_VA28_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUD_DAC_PWR_UP_VA28_MASK 0x1
#define PMIC_RG_AUD_DAC_PWR_UP_VA28_SHIFT 2
#define PMIC_RG_AUD_DAC_PWL_UP_VA28_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUD_DAC_PWL_UP_VA28_MASK 0x1
#define PMIC_RG_AUD_DAC_PWL_UP_VA28_SHIFT 3
#define PMIC_RG_AUDHPLPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPLPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPLPWRUP_VAUDP15_SHIFT 4
#define PMIC_RG_AUDHPRPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPRPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPRPWRUP_VAUDP15_SHIFT 5
#define PMIC_RG_AUDHPLPWRUP_IBIAS_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPLPWRUP_IBIAS_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPLPWRUP_IBIAS_VAUDP15_SHIFT 6
#define PMIC_RG_AUDHPRPWRUP_IBIAS_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPRPWRUP_IBIAS_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPRPWRUP_IBIAS_VAUDP15_SHIFT 7
#define PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15_MASK 0x3
#define PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15_SHIFT 8
#define PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15_MASK 0x3
#define PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15_SHIFT 10
#define PMIC_RG_AUDHPLSCDISABLE_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPLSCDISABLE_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPLSCDISABLE_VAUDP15_SHIFT 12
#define PMIC_RG_AUDHPRSCDISABLE_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPRSCDISABLE_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPRSCDISABLE_VAUDP15_SHIFT 13
#define PMIC_RG_AUDHPLBSCCURRENT_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPLBSCCURRENT_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPLBSCCURRENT_VAUDP15_SHIFT 14
#define PMIC_RG_AUDHPRBSCCURRENT_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON0
#define PMIC_RG_AUDHPRBSCCURRENT_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPRBSCCURRENT_VAUDP15_SHIFT 15
#define PMIC_RG_AUDHPLOUTPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_AUDHPLOUTPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPLOUTPWRUP_VAUDP15_SHIFT 0
#define PMIC_RG_AUDHPROUTPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_AUDHPROUTPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPROUTPWRUP_VAUDP15_SHIFT 1
#define PMIC_RG_AUDHPLOUTAUXPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_AUDHPLOUTAUXPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPLOUTAUXPWRUP_VAUDP15_SHIFT 2
#define PMIC_RG_AUDHPROUTAUXPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_AUDHPROUTAUXPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPROUTAUXPWRUP_VAUDP15_SHIFT 3
#define PMIC_RG_HPLAUXFBRSW_EN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_HPLAUXFBRSW_EN_VAUDP15_MASK 0x1
#define PMIC_RG_HPLAUXFBRSW_EN_VAUDP15_SHIFT 4
#define PMIC_RG_HPRAUXFBRSW_EN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_HPRAUXFBRSW_EN_VAUDP15_MASK 0x1
#define PMIC_RG_HPRAUXFBRSW_EN_VAUDP15_SHIFT 5
#define PMIC_RG_HPLSHORT2HPLAUX_EN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_HPLSHORT2HPLAUX_EN_VAUDP15_MASK 0x1
#define PMIC_RG_HPLSHORT2HPLAUX_EN_VAUDP15_SHIFT 6
#define PMIC_RG_HPRSHORT2HPRAUX_EN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_HPRSHORT2HPRAUX_EN_VAUDP15_MASK 0x1
#define PMIC_RG_HPRSHORT2HPRAUX_EN_VAUDP15_SHIFT 7
#define PMIC_RG_HPLOUTSTGCTRL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_HPLOUTSTGCTRL_VAUDP15_MASK 0x7
#define PMIC_RG_HPLOUTSTGCTRL_VAUDP15_SHIFT 8
#define PMIC_RG_HPROUTSTGCTRL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON1
#define PMIC_RG_HPROUTSTGCTRL_VAUDP15_MASK 0x7
#define PMIC_RG_HPROUTSTGCTRL_VAUDP15_SHIFT 11
#define PMIC_RG_HPLOUTPUTSTBENH_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON2
#define PMIC_RG_HPLOUTPUTSTBENH_VAUDP15_MASK 0x7
#define PMIC_RG_HPLOUTPUTSTBENH_VAUDP15_SHIFT 0
#define PMIC_RG_HPROUTPUTSTBENH_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON2
#define PMIC_RG_HPROUTPUTSTBENH_VAUDP15_MASK 0x7
#define PMIC_RG_HPROUTPUTSTBENH_VAUDP15_SHIFT 4
#define PMIC_RG_AUDHPSTARTUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON2
#define PMIC_RG_AUDHPSTARTUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPSTARTUP_VAUDP15_SHIFT 13
#define PMIC_RG_AUDREFN_DERES_EN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON2
#define PMIC_RG_AUDREFN_DERES_EN_VAUDP15_MASK 0x1
#define PMIC_RG_AUDREFN_DERES_EN_VAUDP15_SHIFT 14
#define PMIC_RG_HPPSHORT2VCM_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON2
#define PMIC_RG_HPPSHORT2VCM_VAUDP15_MASK 0x1
#define PMIC_RG_HPPSHORT2VCM_VAUDP15_SHIFT 15
#define PMIC_RG_HPINPUTSTBENH_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON3
#define PMIC_RG_HPINPUTSTBENH_VAUDP15_MASK 0x1
#define PMIC_RG_HPINPUTSTBENH_VAUDP15_SHIFT 13
#define PMIC_RG_HPINPUTRESET0_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON3
#define PMIC_RG_HPINPUTRESET0_VAUDP15_MASK 0x1
#define PMIC_RG_HPINPUTRESET0_VAUDP15_SHIFT 14
#define PMIC_RG_HPOUTPUTRESET0_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON3
#define PMIC_RG_HPOUTPUTRESET0_VAUDP15_MASK 0x1
#define PMIC_RG_HPOUTPUTRESET0_VAUDP15_SHIFT 15
#define PMIC_RG_AUDHPDIFFINPBIASADJ_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON4
#define PMIC_RG_AUDHPDIFFINPBIASADJ_VAUDP15_MASK 0x7
#define PMIC_RG_AUDHPDIFFINPBIASADJ_VAUDP15_SHIFT 0
#define PMIC_RG_AUDHPLFCOMPRESSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON4
#define PMIC_RG_AUDHPLFCOMPRESSEL_VAUDP15_MASK 0x7
#define PMIC_RG_AUDHPLFCOMPRESSEL_VAUDP15_SHIFT 4
#define PMIC_RG_AUDHPHFCOMPRESSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON4
#define PMIC_RG_AUDHPHFCOMPRESSEL_VAUDP15_MASK 0x7
#define PMIC_RG_AUDHPHFCOMPRESSEL_VAUDP15_SHIFT 8
#define PMIC_RG_AUDHPHFCOMPBUFGAINSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON4
#define PMIC_RG_AUDHPHFCOMPBUFGAINSEL_VAUDP15_MASK 0x3
#define PMIC_RG_AUDHPHFCOMPBUFGAINSEL_VAUDP15_SHIFT 12
#define PMIC_RG_AUDHPCOMP_EN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON4
#define PMIC_RG_AUDHPCOMP_EN_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPCOMP_EN_VAUDP15_SHIFT 15
#define PMIC_RG_AUDHPDECMGAINADJ_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON5
#define PMIC_RG_AUDHPDECMGAINADJ_VAUDP15_MASK 0x7
#define PMIC_RG_AUDHPDECMGAINADJ_VAUDP15_SHIFT 0
#define PMIC_RG_AUDHPDEDMGAINADJ_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON5
#define PMIC_RG_AUDHPDEDMGAINADJ_VAUDP15_MASK 0x7
#define PMIC_RG_AUDHPDEDMGAINADJ_VAUDP15_SHIFT 4
#define PMIC_RG_AUDHSPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_AUDHSPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHSPWRUP_VAUDP15_SHIFT 0
#define PMIC_RG_AUDHSPWRUP_IBIAS_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_AUDHSPWRUP_IBIAS_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHSPWRUP_IBIAS_VAUDP15_SHIFT 1
#define PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15_MASK 0x3
#define PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15_SHIFT 2
#define PMIC_RG_AUDHSSCDISABLE_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_AUDHSSCDISABLE_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHSSCDISABLE_VAUDP15_SHIFT 4
#define PMIC_RG_AUDHSBSCCURRENT_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_AUDHSBSCCURRENT_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHSBSCCURRENT_VAUDP15_SHIFT 5
#define PMIC_RG_AUDHSSTARTUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_AUDHSSTARTUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHSSTARTUP_VAUDP15_SHIFT 6
#define PMIC_RG_HSOUTPUTSTBENH_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_HSOUTPUTSTBENH_VAUDP15_MASK 0x1
#define PMIC_RG_HSOUTPUTSTBENH_VAUDP15_SHIFT 7
#define PMIC_RG_HSINPUTSTBENH_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_HSINPUTSTBENH_VAUDP15_MASK 0x1
#define PMIC_RG_HSINPUTSTBENH_VAUDP15_SHIFT 8
#define PMIC_RG_HSINPUTRESET0_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_HSINPUTRESET0_VAUDP15_MASK 0x1
#define PMIC_RG_HSINPUTRESET0_VAUDP15_SHIFT 9
#define PMIC_RG_HSOUTPUTRESET0_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_HSOUTPUTRESET0_VAUDP15_MASK 0x1
#define PMIC_RG_HSOUTPUTRESET0_VAUDP15_SHIFT 10
#define PMIC_RG_HSOUT_SHORTVCM_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON6
#define PMIC_RG_HSOUT_SHORTVCM_VAUDP15_MASK 0x1
#define PMIC_RG_HSOUT_SHORTVCM_VAUDP15_SHIFT 11
#define PMIC_RG_AUDLOLPWRUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_AUDLOLPWRUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDLOLPWRUP_VAUDP15_SHIFT 0
#define PMIC_RG_AUDLOLPWRUP_IBIAS_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_AUDLOLPWRUP_IBIAS_VAUDP15_MASK 0x1
#define PMIC_RG_AUDLOLPWRUP_IBIAS_VAUDP15_SHIFT 1
#define PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP15_MASK 0x3
#define PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP15_SHIFT 2
#define PMIC_RG_AUDLOLSCDISABLE_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_AUDLOLSCDISABLE_VAUDP15_MASK 0x1
#define PMIC_RG_AUDLOLSCDISABLE_VAUDP15_SHIFT 4
#define PMIC_RG_AUDLOLBSCCURRENT_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_AUDLOLBSCCURRENT_VAUDP15_MASK 0x1
#define PMIC_RG_AUDLOLBSCCURRENT_VAUDP15_SHIFT 5
#define PMIC_RG_AUDLOSTARTUP_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_AUDLOSTARTUP_VAUDP15_MASK 0x1
#define PMIC_RG_AUDLOSTARTUP_VAUDP15_SHIFT 6
#define PMIC_RG_LOINPUTSTBENH_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_LOINPUTSTBENH_VAUDP15_MASK 0x1
#define PMIC_RG_LOINPUTSTBENH_VAUDP15_SHIFT 7
#define PMIC_RG_LOOUTPUTSTBENH_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_LOOUTPUTSTBENH_VAUDP15_MASK 0x1
#define PMIC_RG_LOOUTPUTSTBENH_VAUDP15_SHIFT 8
#define PMIC_RG_LOINPUTRESET0_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_LOINPUTRESET0_VAUDP15_MASK 0x1
#define PMIC_RG_LOINPUTRESET0_VAUDP15_SHIFT 9
#define PMIC_RG_LOOUTPUTRESET0_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_LOOUTPUTRESET0_VAUDP15_MASK 0x1
#define PMIC_RG_LOOUTPUTRESET0_VAUDP15_SHIFT 10
#define PMIC_RG_LOOUT_SHORTVCM_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON7
#define PMIC_RG_LOOUT_SHORTVCM_VAUDP15_MASK 0x1
#define PMIC_RG_LOOUT_SHORTVCM_VAUDP15_SHIFT 11
#define PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON8
#define PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15_MASK 0xF
#define PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15_SHIFT 0
#define PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON8
#define PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15_MASK 0x3
#define PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15_SHIFT 4
#define PMIC_RG_AUDTRIMBUF_EN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON8
#define PMIC_RG_AUDTRIMBUF_EN_VAUDP15_MASK 0x1
#define PMIC_RG_AUDTRIMBUF_EN_VAUDP15_SHIFT 6
#define PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON8
#define PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15_MASK 0x3
#define PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15_SHIFT 8
#define PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON8
#define PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15_MASK 0x3
#define PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15_SHIFT 10
#define PMIC_RG_AUDHPSPKDET_EN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON8
#define PMIC_RG_AUDHPSPKDET_EN_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPSPKDET_EN_VAUDP15_SHIFT 12
#define PMIC_RG_ABIDEC_RSVD0_VA28_ADDR MT6356_AUDDEC_ANA_CON9
#define PMIC_RG_ABIDEC_RSVD0_VA28_MASK 0xFF
#define PMIC_RG_ABIDEC_RSVD0_VA28_SHIFT 0
#define PMIC_RG_ABIDEC_RSVD0_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON9
#define PMIC_RG_ABIDEC_RSVD0_VAUDP15_MASK 0xFF
#define PMIC_RG_ABIDEC_RSVD0_VAUDP15_SHIFT 8
#define PMIC_RG_ABIDEC_RSVD1_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON10
#define PMIC_RG_ABIDEC_RSVD1_VAUDP15_MASK 0xFF
#define PMIC_RG_ABIDEC_RSVD1_VAUDP15_SHIFT 0
#define PMIC_RG_ABIDEC_RSVD2_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON10
#define PMIC_RG_ABIDEC_RSVD2_VAUDP15_MASK 0xFF
#define PMIC_RG_ABIDEC_RSVD2_VAUDP15_SHIFT 8
#define PMIC_RG_AUDZCDMUXSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON11
#define PMIC_RG_AUDZCDMUXSEL_VAUDP15_MASK 0x7
#define PMIC_RG_AUDZCDMUXSEL_VAUDP15_SHIFT 0
#define PMIC_RG_AUDZCDCLKSEL_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON11
#define PMIC_RG_AUDZCDCLKSEL_VAUDP15_MASK 0x1
#define PMIC_RG_AUDZCDCLKSEL_VAUDP15_SHIFT 3
#define PMIC_RG_AUDBIASADJ_0_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON11
#define PMIC_RG_AUDBIASADJ_0_VAUDP15_MASK 0x1FF
#define PMIC_RG_AUDBIASADJ_0_VAUDP15_SHIFT 7
#define PMIC_RG_AUDBIASADJ_1_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON12
#define PMIC_RG_AUDBIASADJ_1_VAUDP15_MASK 0xFF
#define PMIC_RG_AUDBIASADJ_1_VAUDP15_SHIFT 0
#define PMIC_RG_AUDIBIASPWRDN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON12
#define PMIC_RG_AUDIBIASPWRDN_VAUDP15_MASK 0x1
#define PMIC_RG_AUDIBIASPWRDN_VAUDP15_SHIFT 8
#define PMIC_RG_RSTB_DECODER_VA28_ADDR MT6356_AUDDEC_ANA_CON13
#define PMIC_RG_RSTB_DECODER_VA28_MASK 0x1
#define PMIC_RG_RSTB_DECODER_VA28_SHIFT 0
#define PMIC_RG_SEL_DECODER_96K_VA28_ADDR MT6356_AUDDEC_ANA_CON13
#define PMIC_RG_SEL_DECODER_96K_VA28_MASK 0x1
#define PMIC_RG_SEL_DECODER_96K_VA28_SHIFT 1
#define PMIC_RG_SEL_DELAY_VCORE_ADDR MT6356_AUDDEC_ANA_CON13
#define PMIC_RG_SEL_DELAY_VCORE_MASK 0x1
#define PMIC_RG_SEL_DELAY_VCORE_SHIFT 2
#define PMIC_RG_AUDGLB_PWRDN_VA28_ADDR MT6356_AUDDEC_ANA_CON13
#define PMIC_RG_AUDGLB_PWRDN_VA28_MASK 0x1
#define PMIC_RG_AUDGLB_PWRDN_VA28_SHIFT 4
#define PMIC_RG_RSTB_ENCODER_VA28_ADDR MT6356_AUDDEC_ANA_CON13
#define PMIC_RG_RSTB_ENCODER_VA28_MASK 0x1
#define PMIC_RG_RSTB_ENCODER_VA28_SHIFT 5
#define PMIC_RG_SEL_ENCODER_96K_VA28_ADDR MT6356_AUDDEC_ANA_CON13
#define PMIC_RG_SEL_ENCODER_96K_VA28_MASK 0x1
#define PMIC_RG_SEL_ENCODER_96K_VA28_SHIFT 6
#define PMIC_RG_HCLDO_EN_VA18_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_HCLDO_EN_VA18_MASK 0x1
#define PMIC_RG_HCLDO_EN_VA18_SHIFT 0
#define PMIC_RG_HCLDO_PDDIS_EN_VA18_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_HCLDO_PDDIS_EN_VA18_MASK 0x1
#define PMIC_RG_HCLDO_PDDIS_EN_VA18_SHIFT 1
#define PMIC_RG_HCLDO_REMOTE_SENSE_VA18_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_HCLDO_REMOTE_SENSE_VA18_MASK 0x1
#define PMIC_RG_HCLDO_REMOTE_SENSE_VA18_SHIFT 2
#define PMIC_RG_LCLDO_EN_VA18_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_LCLDO_EN_VA18_MASK 0x1
#define PMIC_RG_LCLDO_EN_VA18_SHIFT 4
#define PMIC_RG_LCLDO_PDDIS_EN_VA18_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_LCLDO_PDDIS_EN_VA18_MASK 0x1
#define PMIC_RG_LCLDO_PDDIS_EN_VA18_SHIFT 5
#define PMIC_RG_LCLDO_REMOTE_SENSE_VA18_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_LCLDO_REMOTE_SENSE_VA18_MASK 0x1
#define PMIC_RG_LCLDO_REMOTE_SENSE_VA18_SHIFT 6
#define PMIC_RG_LCLDO_ENC_EN_VA28_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_LCLDO_ENC_EN_VA28_MASK 0x1
#define PMIC_RG_LCLDO_ENC_EN_VA28_SHIFT 8
#define PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28_MASK 0x1
#define PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28_SHIFT 9
#define PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28_MASK 0x1
#define PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28_SHIFT 10
#define PMIC_RG_VA33REFGEN_EN_VA18_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_VA33REFGEN_EN_VA18_MASK 0x1
#define PMIC_RG_VA33REFGEN_EN_VA18_SHIFT 12
#define PMIC_RG_VA28REFGEN_EN_VA28_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_VA28REFGEN_EN_VA28_MASK 0x1
#define PMIC_RG_VA28REFGEN_EN_VA28_SHIFT 13
#define PMIC_RG_HCLDO_VOSEL_VA18_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_HCLDO_VOSEL_VA18_MASK 0x1
#define PMIC_RG_HCLDO_VOSEL_VA18_SHIFT 14
#define PMIC_RG_LCLDO_VOSEL_VA18_ADDR MT6356_AUDDEC_ANA_CON14
#define PMIC_RG_LCLDO_VOSEL_VA18_MASK 0x1
#define PMIC_RG_LCLDO_VOSEL_VA18_SHIFT 15
#define PMIC_RG_NVREG_EN_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON15
#define PMIC_RG_NVREG_EN_VAUDP15_MASK 0x1
#define PMIC_RG_NVREG_EN_VAUDP15_SHIFT 0
#define PMIC_RG_NVREG_PULL0V_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON15
#define PMIC_RG_NVREG_PULL0V_VAUDP15_MASK 0x1
#define PMIC_RG_NVREG_PULL0V_VAUDP15_SHIFT 1
#define PMIC_RG_AUDPMU_RSD0_VAUDP15_ADDR MT6356_AUDDEC_ANA_CON15
#define PMIC_RG_AUDPMU_RSD0_VAUDP15_MASK 0xF
#define PMIC_RG_AUDPMU_RSD0_VAUDP15_SHIFT 4
#define PMIC_RG_AUDPMU_RSD0_VA18_ADDR MT6356_AUDDEC_ANA_CON15
#define PMIC_RG_AUDPMU_RSD0_VA18_MASK 0xF
#define PMIC_RG_AUDPMU_RSD0_VA18_SHIFT 8
#define PMIC_RG_AUDPMU_RSD0_VA28_ADDR MT6356_AUDDEC_ANA_CON15
#define PMIC_RG_AUDPMU_RSD0_VA28_MASK 0xF
#define PMIC_RG_AUDPMU_RSD0_VA28_SHIFT 12
#define PMIC_AUDDEC_ELR_LEN_ADDR MT6356_AUDDEC_ELR_NUM
#define PMIC_AUDDEC_ELR_LEN_MASK 0xFF
#define PMIC_AUDDEC_ELR_LEN_SHIFT 0
#define PMIC_RG_AUDHPLTRIM_VAUDP15_ADDR MT6356_AUDDEC_ELR_0
#define PMIC_RG_AUDHPLTRIM_VAUDP15_MASK 0xF
#define PMIC_RG_AUDHPLTRIM_VAUDP15_SHIFT 0
#define PMIC_RG_AUDHPRTRIM_VAUDP15_ADDR MT6356_AUDDEC_ELR_0
#define PMIC_RG_AUDHPRTRIM_VAUDP15_MASK 0xF
#define PMIC_RG_AUDHPRTRIM_VAUDP15_SHIFT 4
#define PMIC_RG_AUDHPLFINETRIM_VAUDP15_ADDR MT6356_AUDDEC_ELR_0
#define PMIC_RG_AUDHPLFINETRIM_VAUDP15_MASK 0x3
#define PMIC_RG_AUDHPLFINETRIM_VAUDP15_SHIFT 8
#define PMIC_RG_AUDHPRFINETRIM_VAUDP15_ADDR MT6356_AUDDEC_ELR_0
#define PMIC_RG_AUDHPRFINETRIM_VAUDP15_MASK 0x3
#define PMIC_RG_AUDHPRFINETRIM_VAUDP15_SHIFT 10
#define PMIC_RG_AUDHPTRIM_EN_VAUDP15_ADDR MT6356_AUDDEC_ELR_0
#define PMIC_RG_AUDHPTRIM_EN_VAUDP15_MASK 0x1
#define PMIC_RG_AUDHPTRIM_EN_VAUDP15_SHIFT 12
#define PMIC_AUDZCD_ANA_ID_ADDR MT6356_AUDZCDID
#define PMIC_AUDZCD_ANA_ID_MASK 0xFF
#define PMIC_AUDZCD_ANA_ID_SHIFT 0
#define PMIC_AUDZCD_DIG_ID_ADDR MT6356_AUDZCDID
#define PMIC_AUDZCD_DIG_ID_MASK 0xFF
#define PMIC_AUDZCD_DIG_ID_SHIFT 8
#define PMIC_AUDZCD_ANA_MINOR_REV_ADDR MT6356_AUDZCDREV0
#define PMIC_AUDZCD_ANA_MINOR_REV_MASK 0xF
#define PMIC_AUDZCD_ANA_MINOR_REV_SHIFT 0
#define PMIC_AUDZCD_ANA_MAJOR_REV_ADDR MT6356_AUDZCDREV0
#define PMIC_AUDZCD_ANA_MAJOR_REV_MASK 0xF
#define PMIC_AUDZCD_ANA_MAJOR_REV_SHIFT 4
#define PMIC_AUDZCD_DIG_MINOR_REV_ADDR MT6356_AUDZCDREV0
#define PMIC_AUDZCD_DIG_MINOR_REV_MASK 0xF
#define PMIC_AUDZCD_DIG_MINOR_REV_SHIFT 8
#define PMIC_AUDZCD_DIG_MAJOR_REV_ADDR MT6356_AUDZCDREV0
#define PMIC_AUDZCD_DIG_MAJOR_REV_MASK 0xF
#define PMIC_AUDZCD_DIG_MAJOR_REV_SHIFT 12
#define PMIC_AUDZCD_SW_MINOR_REV_ADDR MT6356_AUDZCDREV1
#define PMIC_AUDZCD_SW_MINOR_REV_MASK 0xF
#define PMIC_AUDZCD_SW_MINOR_REV_SHIFT 0
#define PMIC_AUDZCD_SW_MAJOR_REV_ADDR MT6356_AUDZCDREV1
#define PMIC_AUDZCD_SW_MAJOR_REV_MASK 0xF
#define PMIC_AUDZCD_SW_MAJOR_REV_SHIFT 4
#define PMIC_AUDZCD_ESP_ADDR MT6356_AUDZCDREV1
#define PMIC_AUDZCD_ESP_MASK 0xFF
#define PMIC_AUDZCD_ESP_SHIFT 8
#define PMIC_RG_AUDZCDENABLE_ADDR MT6356_ZCD_CON0
#define PMIC_RG_AUDZCDENABLE_MASK 0x1
#define PMIC_RG_AUDZCDENABLE_SHIFT 0
#define PMIC_RG_AUDZCDGAINSTEPTIME_ADDR MT6356_ZCD_CON0
#define PMIC_RG_AUDZCDGAINSTEPTIME_MASK 0x7
#define PMIC_RG_AUDZCDGAINSTEPTIME_SHIFT 1
#define PMIC_RG_AUDZCDGAINSTEPSIZE_ADDR MT6356_ZCD_CON0
#define PMIC_RG_AUDZCDGAINSTEPSIZE_MASK 0x3
#define PMIC_RG_AUDZCDGAINSTEPSIZE_SHIFT 4
#define PMIC_RG_AUDZCDTIMEOUTMODESEL_ADDR MT6356_ZCD_CON0
#define PMIC_RG_AUDZCDTIMEOUTMODESEL_MASK 0x1
#define PMIC_RG_AUDZCDTIMEOUTMODESEL_SHIFT 6
#define PMIC_RG_AUDLOLGAIN_ADDR MT6356_ZCD_CON1
#define PMIC_RG_AUDLOLGAIN_MASK 0x1F
#define PMIC_RG_AUDLOLGAIN_SHIFT 0
#define PMIC_RG_AUDLORGAIN_ADDR MT6356_ZCD_CON1
#define PMIC_RG_AUDLORGAIN_MASK 0x1F
#define PMIC_RG_AUDLORGAIN_SHIFT 7
#define PMIC_RG_AUDHPLGAIN_ADDR MT6356_ZCD_CON2
#define PMIC_RG_AUDHPLGAIN_MASK 0x1F
#define PMIC_RG_AUDHPLGAIN_SHIFT 0
#define PMIC_RG_AUDHPRGAIN_ADDR MT6356_ZCD_CON2
#define PMIC_RG_AUDHPRGAIN_MASK 0x1F
#define PMIC_RG_AUDHPRGAIN_SHIFT 7
#define PMIC_RG_AUDHSGAIN_ADDR MT6356_ZCD_CON3
#define PMIC_RG_AUDHSGAIN_MASK 0x1F
#define PMIC_RG_AUDHSGAIN_SHIFT 0
#define PMIC_RG_AUDIVLGAIN_ADDR MT6356_ZCD_CON4
#define PMIC_RG_AUDIVLGAIN_MASK 0x7
#define PMIC_RG_AUDIVLGAIN_SHIFT 0
#define PMIC_RG_AUDIVRGAIN_ADDR MT6356_ZCD_CON4
#define PMIC_RG_AUDIVRGAIN_MASK 0x7
#define PMIC_RG_AUDIVRGAIN_SHIFT 8
#define PMIC_RG_AUDINTGAIN1_ADDR MT6356_ZCD_CON5
#define PMIC_RG_AUDINTGAIN1_MASK 0x3F
#define PMIC_RG_AUDINTGAIN1_SHIFT 0
#define PMIC_RG_AUDINTGAIN2_ADDR MT6356_ZCD_CON5
#define PMIC_RG_AUDINTGAIN2_MASK 0x3F
#define PMIC_RG_AUDINTGAIN2_SHIFT 8
#define PMIC_ACCDET_ANA_ID_ADDR MT6356_ACCDET_DIG_ID
#define PMIC_ACCDET_ANA_ID_MASK 0xFF
#define PMIC_ACCDET_ANA_ID_SHIFT 0
#define PMIC_ACCDET_DIG_ID_ADDR MT6356_ACCDET_DIG_ID
#define PMIC_ACCDET_DIG_ID_MASK 0xFF
#define PMIC_ACCDET_DIG_ID_SHIFT 8
#define PMIC_ACCDET_ANA_MINOR_REV_ADDR MT6356_ACCDET_DIG_REV0
#define PMIC_ACCDET_ANA_MINOR_REV_MASK 0xF
#define PMIC_ACCDET_ANA_MINOR_REV_SHIFT 0
#define PMIC_ACCDET_ANA_MAJOR_REV_ADDR MT6356_ACCDET_DIG_REV0
#define PMIC_ACCDET_ANA_MAJOR_REV_MASK 0xF
#define PMIC_ACCDET_ANA_MAJOR_REV_SHIFT 4
#define PMIC_ACCDET_DIG_MINOR_REV_ADDR MT6356_ACCDET_DIG_REV0
#define PMIC_ACCDET_DIG_MINOR_REV_MASK 0xF
#define PMIC_ACCDET_DIG_MINOR_REV_SHIFT 8
#define PMIC_ACCDET_DIG_MAJOR_REV_ADDR MT6356_ACCDET_DIG_REV0
#define PMIC_ACCDET_DIG_MAJOR_REV_MASK 0xF
#define PMIC_ACCDET_DIG_MAJOR_REV_SHIFT 12
#define PMIC_ACCDET_SW_MINOR_REV_ADDR MT6356_ACCDET_DIG_REV1
#define PMIC_ACCDET_SW_MINOR_REV_MASK 0xF
#define PMIC_ACCDET_SW_MINOR_REV_SHIFT 0
#define PMIC_ACCDET_SW_MAJOR_REV_ADDR MT6356_ACCDET_DIG_REV1
#define PMIC_ACCDET_SW_MAJOR_REV_MASK 0xF
#define PMIC_ACCDET_SW_MAJOR_REV_SHIFT 4
#define PMIC_ACCDET_ESP_ADDR MT6356_ACCDET_DIG_REV1
#define PMIC_ACCDET_ESP_MASK 0xFF
#define PMIC_ACCDET_ESP_SHIFT 8
#define PMIC_AUDACCDETAUXADCSWCTRL_ADDR MT6356_ACCDET_CON0
#define PMIC_AUDACCDETAUXADCSWCTRL_MASK 0x1
#define PMIC_AUDACCDETAUXADCSWCTRL_SHIFT 10
#define PMIC_AUDACCDETAUXADCSWCTRL_SEL_ADDR MT6356_ACCDET_CON0
#define PMIC_AUDACCDETAUXADCSWCTRL_SEL_MASK 0x1
#define PMIC_AUDACCDETAUXADCSWCTRL_SEL_SHIFT 11
#define PMIC_RG_AUDACCDETRSV_ADDR MT6356_ACCDET_CON0
#define PMIC_RG_AUDACCDETRSV_MASK 0x3
#define PMIC_RG_AUDACCDETRSV_SHIFT 13
#define PMIC_ACCDET_EN_ADDR MT6356_ACCDET_CON1
#define PMIC_ACCDET_EN_MASK 0x1
#define PMIC_ACCDET_EN_SHIFT 0
#define PMIC_ACCDET_SEQ_INIT_ADDR MT6356_ACCDET_CON1
#define PMIC_ACCDET_SEQ_INIT_MASK 0x1
#define PMIC_ACCDET_SEQ_INIT_SHIFT 1
#define PMIC_ACCDET_EINT_EN_ADDR MT6356_ACCDET_CON1
#define PMIC_ACCDET_EINT_EN_MASK 0x1
#define PMIC_ACCDET_EINT_EN_SHIFT 2
#define PMIC_ACCDET_EINT_SEQ_INIT_ADDR MT6356_ACCDET_CON1
#define PMIC_ACCDET_EINT_SEQ_INIT_MASK 0x1
#define PMIC_ACCDET_EINT_SEQ_INIT_SHIFT 3
#define PMIC_ACCDET_EINT1_EN_ADDR MT6356_ACCDET_CON1
#define PMIC_ACCDET_EINT1_EN_MASK 0x1
#define PMIC_ACCDET_EINT1_EN_SHIFT 4
#define PMIC_ACCDET_EINT1_SEQ_INIT_ADDR MT6356_ACCDET_CON1
#define PMIC_ACCDET_EINT1_SEQ_INIT_MASK 0x1
#define PMIC_ACCDET_EINT1_SEQ_INIT_SHIFT 5
#define PMIC_ACCDET_ANASWCTRL_SEL_ADDR MT6356_ACCDET_CON1
#define PMIC_ACCDET_ANASWCTRL_SEL_MASK 0x1
#define PMIC_ACCDET_ANASWCTRL_SEL_SHIFT 6
#define PMIC_ACCDET_CMP_PWM_EN_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_CMP_PWM_EN_MASK 0x1
#define PMIC_ACCDET_CMP_PWM_EN_SHIFT 0
#define PMIC_ACCDET_VTH_PWM_EN_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_VTH_PWM_EN_MASK 0x1
#define PMIC_ACCDET_VTH_PWM_EN_SHIFT 1
#define PMIC_ACCDET_MBIAS_PWM_EN_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_MBIAS_PWM_EN_MASK 0x1
#define PMIC_ACCDET_MBIAS_PWM_EN_SHIFT 2
#define PMIC_ACCDET_EINT_PWM_EN_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_EINT_PWM_EN_MASK 0x1
#define PMIC_ACCDET_EINT_PWM_EN_SHIFT 3
#define PMIC_ACCDET_EINT1_PWM_EN_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_EINT1_PWM_EN_MASK 0x1
#define PMIC_ACCDET_EINT1_PWM_EN_SHIFT 4
#define PMIC_ACCDET_CMP_PWM_IDLE_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_CMP_PWM_IDLE_MASK 0x1
#define PMIC_ACCDET_CMP_PWM_IDLE_SHIFT 8
#define PMIC_ACCDET_VTH_PWM_IDLE_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_VTH_PWM_IDLE_MASK 0x1
#define PMIC_ACCDET_VTH_PWM_IDLE_SHIFT 9
#define PMIC_ACCDET_MBIAS_PWM_IDLE_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_MBIAS_PWM_IDLE_MASK 0x1
#define PMIC_ACCDET_MBIAS_PWM_IDLE_SHIFT 10
#define PMIC_ACCDET_EINT_PWM_IDLE_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_EINT_PWM_IDLE_MASK 0x1
#define PMIC_ACCDET_EINT_PWM_IDLE_SHIFT 11
#define PMIC_ACCDET_EINT1_PWM_IDLE_ADDR MT6356_ACCDET_CON2
#define PMIC_ACCDET_EINT1_PWM_IDLE_MASK 0x1
#define PMIC_ACCDET_EINT1_PWM_IDLE_SHIFT 12
#define PMIC_ACCDET_PWM_WIDTH_ADDR MT6356_ACCDET_CON3
#define PMIC_ACCDET_PWM_WIDTH_MASK 0xFFFF
#define PMIC_ACCDET_PWM_WIDTH_SHIFT 0
#define PMIC_ACCDET_PWM_THRESH_ADDR MT6356_ACCDET_CON4
#define PMIC_ACCDET_PWM_THRESH_MASK 0xFFFF
#define PMIC_ACCDET_PWM_THRESH_SHIFT 0
#define PMIC_ACCDET_RISE_DELAY_ADDR MT6356_ACCDET_CON5
#define PMIC_ACCDET_RISE_DELAY_MASK 0x7FFF
#define PMIC_ACCDET_RISE_DELAY_SHIFT 0
#define PMIC_ACCDET_FALL_DELAY_ADDR MT6356_ACCDET_CON5
#define PMIC_ACCDET_FALL_DELAY_MASK 0x1
#define PMIC_ACCDET_FALL_DELAY_SHIFT 15
#define PMIC_ACCDET_DEBOUNCE0_ADDR MT6356_ACCDET_CON6
#define PMIC_ACCDET_DEBOUNCE0_MASK 0xFFFF
#define PMIC_ACCDET_DEBOUNCE0_SHIFT 0
#define PMIC_ACCDET_DEBOUNCE1_ADDR MT6356_ACCDET_CON7
#define PMIC_ACCDET_DEBOUNCE1_MASK 0xFFFF
#define PMIC_ACCDET_DEBOUNCE1_SHIFT 0
#define PMIC_ACCDET_DEBOUNCE2_ADDR MT6356_ACCDET_CON8
#define PMIC_ACCDET_DEBOUNCE2_MASK 0xFFFF
#define PMIC_ACCDET_DEBOUNCE2_SHIFT 0
#define PMIC_ACCDET_DEBOUNCE3_ADDR MT6356_ACCDET_CON9
#define PMIC_ACCDET_DEBOUNCE3_MASK 0xFFFF
#define PMIC_ACCDET_DEBOUNCE3_SHIFT 0
#define PMIC_ACCDET_DEBOUNCE4_ADDR MT6356_ACCDET_CON10
#define PMIC_ACCDET_DEBOUNCE4_MASK 0xFFFF
#define PMIC_ACCDET_DEBOUNCE4_SHIFT 0
#define PMIC_ACCDET_IVAL_CUR_IN_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_IVAL_CUR_IN_MASK 0x3
#define PMIC_ACCDET_IVAL_CUR_IN_SHIFT 0
#define PMIC_ACCDET_EINT_IVAL_CUR_IN_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_EINT_IVAL_CUR_IN_MASK 0x1
#define PMIC_ACCDET_EINT_IVAL_CUR_IN_SHIFT 2
#define PMIC_ACCDET_EINT1_IVAL_CUR_IN_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_EINT1_IVAL_CUR_IN_MASK 0x1
#define PMIC_ACCDET_EINT1_IVAL_CUR_IN_SHIFT 3
#define PMIC_ACCDET_IVAL_SAM_IN_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_IVAL_SAM_IN_MASK 0x3
#define PMIC_ACCDET_IVAL_SAM_IN_SHIFT 4
#define PMIC_ACCDET_EINT_IVAL_SAM_IN_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_EINT_IVAL_SAM_IN_MASK 0x1
#define PMIC_ACCDET_EINT_IVAL_SAM_IN_SHIFT 6
#define PMIC_ACCDET_EINT1_IVAL_SAM_IN_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_EINT1_IVAL_SAM_IN_MASK 0x1
#define PMIC_ACCDET_EINT1_IVAL_SAM_IN_SHIFT 7
#define PMIC_ACCDET_IVAL_MEM_IN_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_IVAL_MEM_IN_MASK 0x3
#define PMIC_ACCDET_IVAL_MEM_IN_SHIFT 8
#define PMIC_ACCDET_EINT_IVAL_MEM_IN_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_EINT_IVAL_MEM_IN_MASK 0x1
#define PMIC_ACCDET_EINT_IVAL_MEM_IN_SHIFT 10
#define PMIC_ACCDET_EINT1_IVAL_MEM_IN_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_EINT1_IVAL_MEM_IN_MASK 0x1
#define PMIC_ACCDET_EINT1_IVAL_MEM_IN_SHIFT 11
#define PMIC_ACCDET_IVAL_SEL_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_IVAL_SEL_MASK 0x1
#define PMIC_ACCDET_IVAL_SEL_SHIFT 13
#define PMIC_ACCDET_EINT_IVAL_SEL_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_EINT_IVAL_SEL_MASK 0x1
#define PMIC_ACCDET_EINT_IVAL_SEL_SHIFT 14
#define PMIC_ACCDET_EINT1_IVAL_SEL_ADDR MT6356_ACCDET_CON11
#define PMIC_ACCDET_EINT1_IVAL_SEL_MASK 0x1
#define PMIC_ACCDET_EINT1_IVAL_SEL_SHIFT 15
#define PMIC_ACCDET_IRQ_ADDR MT6356_ACCDET_CON12
#define PMIC_ACCDET_IRQ_MASK 0x1
#define PMIC_ACCDET_IRQ_SHIFT 0
#define PMIC_ACCDET_EINT_IRQ_ADDR MT6356_ACCDET_CON12
#define PMIC_ACCDET_EINT_IRQ_MASK 0x1
#define PMIC_ACCDET_EINT_IRQ_SHIFT 2
#define PMIC_ACCDET_EINT1_IRQ_ADDR MT6356_ACCDET_CON12
#define PMIC_ACCDET_EINT1_IRQ_MASK 0x1
#define PMIC_ACCDET_EINT1_IRQ_SHIFT 3
#define PMIC_ACCDET_IRQ_CLR_ADDR MT6356_ACCDET_CON12
#define PMIC_ACCDET_IRQ_CLR_MASK 0x1
#define PMIC_ACCDET_IRQ_CLR_SHIFT 8
#define PMIC_ACCDET_EINT_IRQ_CLR_ADDR MT6356_ACCDET_CON12
#define PMIC_ACCDET_EINT_IRQ_CLR_MASK 0x1
#define PMIC_ACCDET_EINT_IRQ_CLR_SHIFT 10
#define PMIC_ACCDET_EINT1_IRQ_CLR_ADDR MT6356_ACCDET_CON12
#define PMIC_ACCDET_EINT1_IRQ_CLR_MASK 0x1
#define PMIC_ACCDET_EINT1_IRQ_CLR_SHIFT 11
#define PMIC_ACCDET_EINT_IRQ_POLARITY_ADDR MT6356_ACCDET_CON12
#define PMIC_ACCDET_EINT_IRQ_POLARITY_MASK 0x1
#define PMIC_ACCDET_EINT_IRQ_POLARITY_SHIFT 14
#define PMIC_ACCDET_EINT1_IRQ_POLARITY_ADDR MT6356_ACCDET_CON12
#define PMIC_ACCDET_EINT1_IRQ_POLARITY_MASK 0x1
#define PMIC_ACCDET_EINT1_IRQ_POLARITY_SHIFT 15
#define PMIC_ACCDET_TEST_MODE0_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_TEST_MODE0_MASK 0x1
#define PMIC_ACCDET_TEST_MODE0_SHIFT 0
#define PMIC_ACCDET_CMP_SWSEL_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_CMP_SWSEL_MASK 0x1
#define PMIC_ACCDET_CMP_SWSEL_SHIFT 1
#define PMIC_ACCDET_VTH_SWSEL_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_VTH_SWSEL_MASK 0x1
#define PMIC_ACCDET_VTH_SWSEL_SHIFT 2
#define PMIC_ACCDET_MBIAS_SWSEL_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_MBIAS_SWSEL_MASK 0x1
#define PMIC_ACCDET_MBIAS_SWSEL_SHIFT 3
#define PMIC_ACCDET_TEST_MODE4_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_TEST_MODE4_MASK 0x1
#define PMIC_ACCDET_TEST_MODE4_SHIFT 4
#define PMIC_ACCDET_TEST_MODE5_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_TEST_MODE5_MASK 0x1
#define PMIC_ACCDET_TEST_MODE5_SHIFT 5
#define PMIC_ACCDET_PWM_SEL_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_PWM_SEL_MASK 0x3
#define PMIC_ACCDET_PWM_SEL_SHIFT 6
#define PMIC_ACCDET_IN_SW_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_IN_SW_MASK 0x3
#define PMIC_ACCDET_IN_SW_SHIFT 8
#define PMIC_ACCDET_CMP_EN_SW_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_CMP_EN_SW_MASK 0x1
#define PMIC_ACCDET_CMP_EN_SW_SHIFT 12
#define PMIC_ACCDET_VTH_EN_SW_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_VTH_EN_SW_MASK 0x1
#define PMIC_ACCDET_VTH_EN_SW_SHIFT 13
#define PMIC_ACCDET_MBIAS_EN_SW_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_MBIAS_EN_SW_MASK 0x1
#define PMIC_ACCDET_MBIAS_EN_SW_SHIFT 14
#define PMIC_ACCDET_PWM_EN_SW_ADDR MT6356_ACCDET_CON13
#define PMIC_ACCDET_PWM_EN_SW_MASK 0x1
#define PMIC_ACCDET_PWM_EN_SW_SHIFT 15
#define PMIC_ACCDET_IN_ADDR MT6356_ACCDET_CON14
#define PMIC_ACCDET_IN_MASK 0x3
#define PMIC_ACCDET_IN_SHIFT 0
#define PMIC_ACCDET_CUR_IN_ADDR MT6356_ACCDET_CON14
#define PMIC_ACCDET_CUR_IN_MASK 0x3
#define PMIC_ACCDET_CUR_IN_SHIFT 2
#define PMIC_ACCDET_SAM_IN_ADDR MT6356_ACCDET_CON14
#define PMIC_ACCDET_SAM_IN_MASK 0x3
#define PMIC_ACCDET_SAM_IN_SHIFT 4
#define PMIC_ACCDET_MEM_IN_ADDR MT6356_ACCDET_CON14
#define PMIC_ACCDET_MEM_IN_MASK 0x3
#define PMIC_ACCDET_MEM_IN_SHIFT 6
#define PMIC_ACCDET_STATE_ADDR MT6356_ACCDET_CON14
#define PMIC_ACCDET_STATE_MASK 0x7
#define PMIC_ACCDET_STATE_SHIFT 8
#define PMIC_ACCDET_MBIAS_CLK_ADDR MT6356_ACCDET_CON14
#define PMIC_ACCDET_MBIAS_CLK_MASK 0x1
#define PMIC_ACCDET_MBIAS_CLK_SHIFT 12
#define PMIC_ACCDET_VTH_CLK_ADDR MT6356_ACCDET_CON14
#define PMIC_ACCDET_VTH_CLK_MASK 0x1
#define PMIC_ACCDET_VTH_CLK_SHIFT 13
#define PMIC_ACCDET_CMP_CLK_ADDR MT6356_ACCDET_CON14
#define PMIC_ACCDET_CMP_CLK_MASK 0x1
#define PMIC_ACCDET_CMP_CLK_SHIFT 14
#define PMIC_DA_AUDACCDETAUXADCSWCTRL_ADDR MT6356_ACCDET_CON14
#define PMIC_DA_AUDACCDETAUXADCSWCTRL_MASK 0x1
#define PMIC_DA_AUDACCDETAUXADCSWCTRL_SHIFT 15
#define PMIC_ACCDET_EINT_DEB_SEL_ADDR MT6356_ACCDET_CON15
#define PMIC_ACCDET_EINT_DEB_SEL_MASK 0x1
#define PMIC_ACCDET_EINT_DEB_SEL_SHIFT 0
#define PMIC_ACCDET_EINT_DEBOUNCE_ADDR MT6356_ACCDET_CON15
#define PMIC_ACCDET_EINT_DEBOUNCE_MASK 0xF
#define PMIC_ACCDET_EINT_DEBOUNCE_SHIFT 3
#define PMIC_ACCDET_EINT_PWM_THRESH_ADDR MT6356_ACCDET_CON15
#define PMIC_ACCDET_EINT_PWM_THRESH_MASK 0x7
#define PMIC_ACCDET_EINT_PWM_THRESH_SHIFT 8
#define PMIC_ACCDET_EINT_PWM_WIDTH_ADDR MT6356_ACCDET_CON15
#define PMIC_ACCDET_EINT_PWM_WIDTH_MASK 0x3
#define PMIC_ACCDET_EINT_PWM_WIDTH_SHIFT 12
#define PMIC_ACCDET_EINT_PWM_FALL_DELAY_ADDR MT6356_ACCDET_CON16
#define PMIC_ACCDET_EINT_PWM_FALL_DELAY_MASK 0x1
#define PMIC_ACCDET_EINT_PWM_FALL_DELAY_SHIFT 5
#define PMIC_ACCDET_EINT_PWM_RISE_DELAY_ADDR MT6356_ACCDET_CON16
#define PMIC_ACCDET_EINT_PWM_RISE_DELAY_MASK 0x3FF
#define PMIC_ACCDET_EINT_PWM_RISE_DELAY_SHIFT 6
#define PMIC_ACCDET_TEST_MODE13_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_TEST_MODE13_MASK 0x1
#define PMIC_ACCDET_TEST_MODE13_SHIFT 1
#define PMIC_ACCDET_TEST_MODE12_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_TEST_MODE12_MASK 0x1
#define PMIC_ACCDET_TEST_MODE12_SHIFT 2
#define PMIC_ACCDET_TEST_MODE11_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_TEST_MODE11_MASK 0x1
#define PMIC_ACCDET_TEST_MODE11_SHIFT 5
#define PMIC_ACCDET_TEST_MODE10_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_TEST_MODE10_MASK 0x1
#define PMIC_ACCDET_TEST_MODE10_SHIFT 6
#define PMIC_ACCDET_EINT_CMPOUT_SW_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_EINT_CMPOUT_SW_MASK 0x1
#define PMIC_ACCDET_EINT_CMPOUT_SW_SHIFT 7
#define PMIC_ACCDET_EINT1_CMPOUT_SW_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_EINT1_CMPOUT_SW_MASK 0x1
#define PMIC_ACCDET_EINT1_CMPOUT_SW_SHIFT 8
#define PMIC_ACCDET_TEST_MODE9_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_TEST_MODE9_MASK 0x1
#define PMIC_ACCDET_TEST_MODE9_SHIFT 9
#define PMIC_ACCDET_TEST_MODE8_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_TEST_MODE8_MASK 0x1
#define PMIC_ACCDET_TEST_MODE8_SHIFT 10
#define PMIC_ACCDET_AUXADC_CTRL_SW_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_AUXADC_CTRL_SW_MASK 0x1
#define PMIC_ACCDET_AUXADC_CTRL_SW_SHIFT 11
#define PMIC_ACCDET_TEST_MODE7_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_TEST_MODE7_MASK 0x1
#define PMIC_ACCDET_TEST_MODE7_SHIFT 12
#define PMIC_ACCDET_TEST_MODE6_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_TEST_MODE6_MASK 0x1
#define PMIC_ACCDET_TEST_MODE6_SHIFT 13
#define PMIC_ACCDET_EINT_CMP_EN_SW_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_EINT_CMP_EN_SW_MASK 0x1
#define PMIC_ACCDET_EINT_CMP_EN_SW_SHIFT 14
#define PMIC_ACCDET_EINT1_CMP_EN_SW_ADDR MT6356_ACCDET_CON17
#define PMIC_ACCDET_EINT1_CMP_EN_SW_MASK 0x1
#define PMIC_ACCDET_EINT1_CMP_EN_SW_SHIFT 15
#define PMIC_ACCDET_EINT_STATE_ADDR MT6356_ACCDET_CON18
#define PMIC_ACCDET_EINT_STATE_MASK 0x7
#define PMIC_ACCDET_EINT_STATE_SHIFT 0
#define PMIC_ACCDET_AUXADC_DEBOUNCE_END_ADDR MT6356_ACCDET_CON18
#define PMIC_ACCDET_AUXADC_DEBOUNCE_END_MASK 0x1
#define PMIC_ACCDET_AUXADC_DEBOUNCE_END_SHIFT 3
#define PMIC_ACCDET_AUXADC_CONNECT_PRE_ADDR MT6356_ACCDET_CON18
#define PMIC_ACCDET_AUXADC_CONNECT_PRE_MASK 0x1
#define PMIC_ACCDET_AUXADC_CONNECT_PRE_SHIFT 4
#define PMIC_ACCDET_EINT_CUR_IN_ADDR MT6356_ACCDET_CON18
#define PMIC_ACCDET_EINT_CUR_IN_MASK 0x1
#define PMIC_ACCDET_EINT_CUR_IN_SHIFT 8
#define PMIC_ACCDET_EINT_SAM_IN_ADDR MT6356_ACCDET_CON18
#define PMIC_ACCDET_EINT_SAM_IN_MASK 0x1
#define PMIC_ACCDET_EINT_SAM_IN_SHIFT 9
#define PMIC_ACCDET_EINT_MEM_IN_ADDR MT6356_ACCDET_CON18
#define PMIC_ACCDET_EINT_MEM_IN_MASK 0x1
#define PMIC_ACCDET_EINT_MEM_IN_SHIFT 10
#define PMIC_AD_EINTCMPOUT_ADDR MT6356_ACCDET_CON18
#define PMIC_AD_EINTCMPOUT_MASK 0x1
#define PMIC_AD_EINTCMPOUT_SHIFT 14
#define PMIC_DA_NI_EINTCMPEN_ADDR MT6356_ACCDET_CON18
#define PMIC_DA_NI_EINTCMPEN_MASK 0x1
#define PMIC_DA_NI_EINTCMPEN_SHIFT 15
#define PMIC_ACCDET_CUR_DEB_ADDR MT6356_ACCDET_CON19
#define PMIC_ACCDET_CUR_DEB_MASK 0xFFFF
#define PMIC_ACCDET_CUR_DEB_SHIFT 0
#define PMIC_ACCDET_EINT_CUR_DEB_ADDR MT6356_ACCDET_CON20
#define PMIC_ACCDET_EINT_CUR_DEB_MASK 0x7FFF
#define PMIC_ACCDET_EINT_CUR_DEB_SHIFT 0
#define PMIC_ACCDET_MON_FLAG_EN_ADDR MT6356_ACCDET_CON21
#define PMIC_ACCDET_MON_FLAG_EN_MASK 0x1
#define PMIC_ACCDET_MON_FLAG_EN_SHIFT 0
#define PMIC_ACCDET_MON_FLAG_SEL_ADDR MT6356_ACCDET_CON21
#define PMIC_ACCDET_MON_FLAG_SEL_MASK 0xFF
#define PMIC_ACCDET_MON_FLAG_SEL_SHIFT 4
#define PMIC_ACCDET_RSV_CON1_ADDR MT6356_ACCDET_CON22
#define PMIC_ACCDET_RSV_CON1_MASK 0xFFFF
#define PMIC_ACCDET_RSV_CON1_SHIFT 0
#define PMIC_ACCDET_AUXADC_CONNECT_TIME_ADDR MT6356_ACCDET_CON23
#define PMIC_ACCDET_AUXADC_CONNECT_TIME_MASK 0xFFFF
#define PMIC_ACCDET_AUXADC_CONNECT_TIME_SHIFT 0
#define PMIC_ACCDET_HWEN_SEL_ADDR MT6356_ACCDET_CON24
#define PMIC_ACCDET_HWEN_SEL_MASK 0x3
#define PMIC_ACCDET_HWEN_SEL_SHIFT 0
#define PMIC_ACCDET_HWMODE_SEL_ADDR MT6356_ACCDET_CON24
#define PMIC_ACCDET_HWMODE_SEL_MASK 0x1
#define PMIC_ACCDET_HWMODE_SEL_SHIFT 2
#define PMIC_ACCDET_EINT_DEB_OUT_DFF_ADDR MT6356_ACCDET_CON24
#define PMIC_ACCDET_EINT_DEB_OUT_DFF_MASK 0x1
#define PMIC_ACCDET_EINT_DEB_OUT_DFF_SHIFT 3
#define PMIC_ACCDET_EINT_REVERSE_ADDR MT6356_ACCDET_CON24
#define PMIC_ACCDET_EINT_REVERSE_MASK 0x1
#define PMIC_ACCDET_EINT_REVERSE_SHIFT 14
#define PMIC_ACCDET_EINT1_REVERSE_ADDR MT6356_ACCDET_CON24
#define PMIC_ACCDET_EINT1_REVERSE_MASK 0x1
#define PMIC_ACCDET_EINT1_REVERSE_SHIFT 15
#define PMIC_ACCDET_EINT1_DEB_SEL_ADDR MT6356_ACCDET_CON25
#define PMIC_ACCDET_EINT1_DEB_SEL_MASK 0x1
#define PMIC_ACCDET_EINT1_DEB_SEL_SHIFT 0
#define PMIC_ACCDET_EINT1_DEBOUNCE_ADDR MT6356_ACCDET_CON25
#define PMIC_ACCDET_EINT1_DEBOUNCE_MASK 0xF
#define PMIC_ACCDET_EINT1_DEBOUNCE_SHIFT 3
#define PMIC_ACCDET_EINT1_PWM_THRESH_ADDR MT6356_ACCDET_CON25
#define PMIC_ACCDET_EINT1_PWM_THRESH_MASK 0x7
#define PMIC_ACCDET_EINT1_PWM_THRESH_SHIFT 8
#define PMIC_ACCDET_EINT1_PWM_WIDTH_ADDR MT6356_ACCDET_CON25
#define PMIC_ACCDET_EINT1_PWM_WIDTH_MASK 0x3
#define PMIC_ACCDET_EINT1_PWM_WIDTH_SHIFT 12
#define PMIC_ACCDET_EINT1_PWM_FALL_DELAY_ADDR MT6356_ACCDET_CON26
#define PMIC_ACCDET_EINT1_PWM_FALL_DELAY_MASK 0x1
#define PMIC_ACCDET_EINT1_PWM_FALL_DELAY_SHIFT 5
#define PMIC_ACCDET_EINT1_PWM_RISE_DELAY_ADDR MT6356_ACCDET_CON26
#define PMIC_ACCDET_EINT1_PWM_RISE_DELAY_MASK 0x3FF
#define PMIC_ACCDET_EINT1_PWM_RISE_DELAY_SHIFT 6
#define PMIC_ACCDET_EINT1_STATE_ADDR MT6356_ACCDET_CON27
#define PMIC_ACCDET_EINT1_STATE_MASK 0x7
#define PMIC_ACCDET_EINT1_STATE_SHIFT 0
#define PMIC_ACCDET_EINT1_CUR_IN_ADDR MT6356_ACCDET_CON27
#define PMIC_ACCDET_EINT1_CUR_IN_MASK 0x1
#define PMIC_ACCDET_EINT1_CUR_IN_SHIFT 8
#define PMIC_ACCDET_EINT1_SAM_IN_ADDR MT6356_ACCDET_CON27
#define PMIC_ACCDET_EINT1_SAM_IN_MASK 0x1
#define PMIC_ACCDET_EINT1_SAM_IN_SHIFT 9
#define PMIC_ACCDET_EINT1_MEM_IN_ADDR MT6356_ACCDET_CON27
#define PMIC_ACCDET_EINT1_MEM_IN_MASK 0x1
#define PMIC_ACCDET_EINT1_MEM_IN_SHIFT 10
#define PMIC_AD_EINT1CMPOUT_ADDR MT6356_ACCDET_CON27
#define PMIC_AD_EINT1CMPOUT_MASK 0x1
#define PMIC_AD_EINT1CMPOUT_SHIFT 14
#define PMIC_DA_NI_EINT1CMPEN_ADDR MT6356_ACCDET_CON27
#define PMIC_DA_NI_EINT1CMPEN_MASK 0x1
#define PMIC_DA_NI_EINT1CMPEN_SHIFT 15
#define PMIC_ACCDET_EINT1_CUR_DEB_ADDR MT6356_ACCDET_CON28
#define PMIC_ACCDET_EINT1_CUR_DEB_MASK 0x7FFF
#define PMIC_ACCDET_EINT1_CUR_DEB_SHIFT 0
#define PMIC_ACCDET_ELR_LEN_ADDR MT6356_ACCDET_ELR_NUM
#define PMIC_ACCDET_ELR_LEN_MASK 0xFF
#define PMIC_ACCDET_ELR_LEN_SHIFT 0
#define PMIC_RG_ACCDET_OFFSET_CAL_ADDR MT6356_ACCDET_ELR0
#define PMIC_RG_ACCDET_OFFSET_CAL_MASK 0xFF
#define PMIC_RG_ACCDET_OFFSET_CAL_SHIFT 0
#define PMIC_RG_ACCDET_RES_ADDR MT6356_ACCDET_ELR0
#define PMIC_RG_ACCDET_RES_MASK 0xFF
#define PMIC_RG_ACCDET_RES_SHIFT 8
#define PMIC_RG_ACCDET_AD_ADDR MT6356_ACCDET_ELR1
#define PMIC_RG_ACCDET_AD_MASK 0xFF
#define PMIC_RG_ACCDET_AD_SHIFT 0
#define PMIC_RG_ACCDET_DB_ADDR MT6356_ACCDET_ELR1
#define PMIC_RG_ACCDET_DB_MASK 0xFF
#define PMIC_RG_ACCDET_DB_SHIFT 8
#define PMIC_RG_ACCDET_BC_ADDR MT6356_ACCDET_ELR2
#define PMIC_RG_ACCDET_BC_MASK 0xFF
#define PMIC_RG_ACCDET_BC_SHIFT 0

enum PMU_FLAGS_LIST {
	PMIC_TOP0_ANA_ID,
	PMIC_TOP0_DIG_ID,
	PMIC_TOP0_ANA_MINOR_REV,
	PMIC_TOP0_ANA_MAJOR_REV,
	PMIC_TOP0_DIG_MINOR_REV,
	PMIC_TOP0_DIG_MAJOR_REV,
	PMIC_TOP0_SW_MINOR_REV,
	PMIC_TOP0_SW_MAJOR_REV,
	PMIC_TOP0_ESP,
	PMIC_HWCID,
	PMIC_SWCID,
	PMIC_STS_PWRKEY,
	PMIC_STS_RTCA,
	PMIC_STS_CHRIN,
	PMIC_STS_SPAR,
	PMIC_STS_RBOOT,
	PMIC_STS_UVLO,
	PMIC_STS_PGFAIL,
	PMIC_STS_PSOC,
	PMIC_STS_THRDN,
	PMIC_STS_WRST,
	PMIC_STS_CRST,
	PMIC_STS_PKEYLP,
	PMIC_STS_NORMOFF,
	PMIC_STS_BWDT,
	PMIC_STS_DDLO,
	PMIC_STS_WDT,
	PMIC_STS_PUPSRC,
	PMIC_STS_KEYPWR,
	PMIC_RG_POFFSTS_CLR,
	PMIC_RG_PONSTS_CLR,
	PMIC_VUSB_PG_DEB,
	PMIC_VDRAM_PG_DEB,
	PMIC_VIO28_PG_DEB,
	PMIC_VEMC_PG_DEB,
	PMIC_VIO18_PG_DEB,
	PMIC_VSRAM_PROC_PG_DEB,
	PMIC_VA12_PG_DEB,
	PMIC_VSRAM_GPU_PG_DEB,
	PMIC_VSRAM_OTHERS_PG_DEB,
	PMIC_VAUX18_PG_DEB,
	PMIC_BUCK_RSV_PG_DEB,
	PMIC_VPROC_PG_DEB,
	PMIC_VS1_PG_DEB,
	PMIC_VMODEM_PG_DEB,
	PMIC_VCORE_PG_DEB,
	PMIC_VS2_PG_DEB,
	PMIC_EXT_PMIC_PG_DEB,
	PMIC_VXO22_PG_DEB,
	PMIC_VAUD28_PG_DEB,
	PMIC_STRUP_VUSB_PG_STATUS,
	PMIC_STRUP_VDRAM_PG_STATUS,
	PMIC_STRUP_VIO28_PG_STATUS,
	PMIC_STRUP_VEMC_PG_STATUS,
	PMIC_STRUP_VIO18_PG_STATUS,
	PMIC_STRUP_VSRAM_PROC_PG_STATUS,
	PMIC_STRUP_VA12_PG_STATUS,
	PMIC_STRUP_VSRAM_GPU_PG_STATUS,
	PMIC_STRUP_VSRAM_OTHERS_PG_STATUS,
	PMIC_STRUP_VAUX18_PG_STATUS,
	PMIC_STRUP_BUCK_RSV_PG_STATUS,
	PMIC_STRUP_VPROC_PG_STATUS,
	PMIC_STRUP_VS1_PG_STATUS,
	PMIC_STRUP_VMODEM_PG_STATUS,
	PMIC_STRUP_VCORE_PG_STATUS,
	PMIC_STRUP_VS2_PG_STATUS,
	PMIC_STRUP_EXT_PMIC_PG_STATUS,
	PMIC_STRUP_VXO22_PG_STATUS,
	PMIC_STRUP_VAUD28_PG_STATUS,
	PMIC_STRUP_BUCK_RSV_OC_STATUS,
	PMIC_STRUP_VPROC_OC_STATUS,
	PMIC_STRUP_VS1_OC_STATUS,
	PMIC_STRUP_VMODEM_OC_STATUS,
	PMIC_STRUP_VCORE_OC_STATUS,
	PMIC_STRUP_VS2_OC_STATUS,
	PMIC_PMU_THERMAL_DEB,
	PMIC_STRUP_THERMAL_STATUS,
	PMIC_RG_SRCLKEN_IN0_EN,
	PMIC_RG_SRCLKEN_IN0_HW_MODE,
	PMIC_RG_SRCLKEN_IN1_EN,
	PMIC_RG_SRCLKEN_IN1_HW_MODE,
	PMIC_RG_SRCLKEN_IN_SYNC_EN,
	PMIC_RG_OSC_EN_AUTO_OFF,
	PMIC_TEST_OUT,
	PMIC_RG_MON_FLAG_SEL,
	PMIC_RG_MON_GRP_SEL,
	PMIC_RG_NANDTREE_MODE,
	PMIC_RG_TEST_AUXADC,
	PMIC_RG_EFUSE_MODE,
	PMIC_RG_TEST_STRUP,
	PMIC_TESTMODE_SW,
	PMIC_PMU_TEST_MODE_SCAN,
	PMIC_PWRKEY_DEB,
	PMIC_CHRDET_DEB,
	PMIC_HOMEKEY_DEB,
	PMIC_RG_PMU_TDSEL,
	PMIC_RG_SPI_TDSEL,
	PMIC_RG_AUD_TDSEL,
	PMIC_RG_E32CAL_TDSEL,
	PMIC_RG_PMU_RDSEL,
	PMIC_RG_SPI_RDSEL,
	PMIC_RG_AUD_RDSEL,
	PMIC_RG_E32CAL_RDSEL,
	PMIC_RG_SMT_WDTRSTB_IN,
	PMIC_RG_SMT_SRCLKEN_IN0,
	PMIC_RG_SMT_SRCLKEN_IN1,
	PMIC_RG_SMT_RTC_32K1V8_0,
	PMIC_RG_SMT_RTC_32K1V8_1,
	PMIC_RG_SMT_SPI_CLK,
	PMIC_RG_SMT_SPI_CSN,
	PMIC_RG_SMT_SPI_MOSI,
	PMIC_RG_SMT_SPI_MISO,
	PMIC_RG_SMT_AUD_CLK_MOSI,
	PMIC_RG_SMT_AUD_DAT_MOSI0,
	PMIC_RG_SMT_AUD_DAT_MOSI1,
	PMIC_RG_SMT_AUD_SYNC_MOSI,
	PMIC_RG_SMT_AUD_CLK_MISO,
	PMIC_RG_SMT_AUD_DAT_MISO0,
	PMIC_RG_SMT_AUD_DAT_MISO1,
	PMIC_RG_SMT_AUD_SYNC_MISO,
	PMIC_RG_TOP_RSV0,
	PMIC_RG_TOP_RSV1,
	PMIC_RG_OCTL_SRCLKEN_IN0,
	PMIC_RG_OCTL_SRCLKEN_IN1,
	PMIC_RG_OCTL_RTC_32K1V8_0,
	PMIC_RG_OCTL_RTC_32K1V8_1,
	PMIC_RG_OCTL_SPI_CLK,
	PMIC_RG_OCTL_SPI_CSN,
	PMIC_RG_OCTL_SPI_MOSI,
	PMIC_RG_OCTL_SPI_MISO,
	PMIC_RG_OCTL_AUD_CLK_MOSI,
	PMIC_RG_OCTL_AUD_DAT_MOSI0,
	PMIC_RG_OCTL_AUD_DAT_MOSI1,
	PMIC_RG_OCTL_AUD_SYNC_MOSI,
	PMIC_RG_OCTL_AUD_CLK_MISO,
	PMIC_RG_OCTL_AUD_DAT_MISO0,
	PMIC_RG_OCTL_AUD_DAT_MISO1,
	PMIC_RG_OCTL_AUD_SYNC_MISO,
	PMIC_RG_SRCLKEN_IN0_FILTER_EN,
	PMIC_RG_SRCLKEN_IN1_FILTER_EN,
	PMIC_RG_RTC32K_1V8_0_FILTER_EN,
	PMIC_RG_RTC32K_1V8_1_FILTER_EN,
	PMIC_RG_SPI_CLK_FILTER_EN,
	PMIC_RG_SPI_CSN_FILTER_EN,
	PMIC_RG_SPI_MOSI_FILTER_EN,
	PMIC_RG_SPI_MISO_FILTER_EN,
	PMIC_RG_AUD_CLK_MOSI_FILTER_EN,
	PMIC_RG_AUD_DAT_MOSI0_FILTER_EN,
	PMIC_RG_AUD_DAT_MOSI1_FILTER_EN,
	PMIC_RG_AUD_SYNC_MOSI_FILTER_EN,
	PMIC_RG_AUD_CLK_MISO_FILTER_EN,
	PMIC_RG_AUD_DAT_MISO0_FILTER_EN,
	PMIC_RG_AUD_DAT_MISO1_FILTER_EN,
	PMIC_RG_AUD_SYNC_MISO_FILTER_EN,
	PMIC_RG_WDTRSTB_IN_FILTER_EN,
	PMIC_RG_SRCLKEN_IN0_RCSEL,
	PMIC_RG_SRCLKEN_IN1_RCSEL,
	PMIC_RG_RTC32K_1V8_0_RCSEL,
	PMIC_RG_RTC32K_1V8_1_RCSEL,
	PMIC_RG_SPI_CLK_RCSEL,
	PMIC_RG_SPI_CSN_RCSEL,
	PMIC_RG_SPI_MOSI_RCSEL,
	PMIC_RG_SPI_MISO_RCSEL,
	PMIC_RG_AUD_CLK_MOSI_RCSEL,
	PMIC_RG_AUD_DAT_MOSI0_RCSEL,
	PMIC_RG_AUD_DAT_MOSI1_RCSEL,
	PMIC_RG_AUD_SYNC_MOSI_RCSEL,
	PMIC_RG_AUD_CLK_MISO_RCSEL,
	PMIC_RG_AUD_DAT_MISO0_RCSEL,
	PMIC_RG_AUD_DAT_MISO1_RCSEL,
	PMIC_RG_AUD_SYNC_MISO_RCSEL,
	PMIC_RG_WDTRSTB_IN_RCSEL,
	PMIC_TOP_STATUS,
	PMIC_TOP_STATUS_SET,
	PMIC_TOP_STATUS_CLR,
	PMIC_VM_MODE,
	PMIC_GPIO_DIR0,
	PMIC_GPIO_DIR0_SET,
	PMIC_GPIO_DIR0_CLR,
	PMIC_GPIO_PULLEN0,
	PMIC_GPIO_PULLEN0_SET,
	PMIC_GPIO_PULLEN0_CLR,
	PMIC_GPIO_PULLSEL0,
	PMIC_GPIO_PULLSEL0_SET,
	PMIC_GPIO_PULLSEL0_CLR,
	PMIC_GPIO_DINV0,
	PMIC_GPIO_DINV0_SET,
	PMIC_GPIO_DINV0_CLR,
	PMIC_GPIO_DOUT0,
	PMIC_GPIO_DOUT0_SET,
	PMIC_GPIO_DOUT0_CLR,
	PMIC_GPIO_PI0,
	PMIC_GPIO_POE0,
	PMIC_GPIO0_MODE,
	PMIC_GPIO1_MODE,
	PMIC_GPIO2_MODE,
	PMIC_GPIO3_MODE,
	PMIC_GPIO_MODE0_SET,
	PMIC_GPIO_MODE0_CLR,
	PMIC_GPIO4_MODE,
	PMIC_GPIO5_MODE,
	PMIC_GPIO6_MODE,
	PMIC_GPIO7_MODE,
	PMIC_GPIO_MODE1_SET,
	PMIC_GPIO_MODE1_CLR,
	PMIC_GPIO8_MODE,
	PMIC_GPIO9_MODE,
	PMIC_GPIO10_MODE,
	PMIC_GPIO11_MODE,
	PMIC_GPIO_MODE2_SET,
	PMIC_GPIO_MODE2_CLR,
	PMIC_GPIO12_MODE,
	PMIC_GPIO13_MODE,
	PMIC_GPIO14_MODE,
	PMIC_GPIO15_MODE,
	PMIC_GPIO_MODE3_SET,
	PMIC_GPIO_MODE3_CLR,
	PMIC_GPIO_RSV,
	PMIC_TOP1_ANA_ID,
	PMIC_TOP1_DIG_ID,
	PMIC_TOP1_ANA_MINOR_REV,
	PMIC_TOP1_ANA_MAJOR_REV,
	PMIC_TOP1_DIG_MINOR_REV,
	PMIC_TOP1_DIG_MAJOR_REV,
	PMIC_TOP1_SW_MINOR_REV,
	PMIC_TOP1_SW_MAJOR_REV,
	PMIC_TOP1_ESP,
	PMIC_TOP_CLK_OFFSET,
	PMIC_TOP_RST_OFFSET,
	PMIC_TOP_INT_OFFSET,
	PMIC_TOP_INT_LEN,
	PMIC_RG_G_SMPS_CK_PDN,
	PMIC_RG_G_SMPS_TEST_CK_PDN,
	PMIC_RG_INTRP_CK_PDN,
	PMIC_RG_INTRP_PRE_OC_CK_PDN,
	PMIC_RG_EFUSE_CK_PDN,
	PMIC_RG_EINT_32K_CK_PDN,
	PMIC_RG_PMU1M_CK_PDN,
	PMIC_RG_SPI_CK_PDN,
	PMIC_RG_REG_CK_PDN,
	PMIC_RG_PMU32K_CK_PDN,
	PMIC_RG_FQMTR_32K_CK_PDN,
	PMIC_RG_FQMTR_CK_PDN,
	PMIC_RG_PMU26M_CK_PDN,
	PMIC_RG_PMU128K_CK_PDN,
	PMIC_RG_RTC26M_CK_PDN,
	PMIC_RG_RTC32K_CK_PDN,
	PMIC_TOP_CKPDN_CON0_SET,
	PMIC_TOP_CKPDN_CON0_CLR,
	PMIC_RG_RTC32K_1V8_0_PDN,
	PMIC_RG_RTC32K_1V8_1_PDN,
	PMIC_RG_TRIM_128K_CK_PDN,
	PMIC_RG_BGR_TEST_CK_PDN,
	PMIC_RG_PCHR_TEST_CK_PDN,
	PMIC_TOP_CKPDN_CON1_SET,
	PMIC_TOP_CKPDN_CON1_CLR,
	PMIC_RG_FQMTR_CK_CKSEL,
	PMIC_RG_RTC_32K1V8_SEL,
	PMIC_RG_BGR_TEST_CK_CKSEL,
	PMIC_RG_PCHR_TEST_CK_CKSEL,
	PMIC_RG_26M_CK_SEL_HWEN,
	PMIC_RG_26M_CK_SEL,
	PMIC_RG_PMU_1M_CK_SEL_HWEN,
	PMIC_RG_PMU_1M_CK_SEL,
	PMIC_RG_PMU32K_CK_CKSEL,
	PMIC_RG_TOP_CKSEL_CON0_RSV,
	PMIC_TOP_CKSEL_CON0_SET,
	PMIC_TOP_CKSEL_CON0_CLR,
	PMIC_RG_SRCVOLTEN_SW,
	PMIC_RG_BUCK_OSC_SEL_SW,
	PMIC_RG_VOWEN_SW,
	PMIC_RG_SRCVOLTEN_MODE,
	PMIC_RG_BUCK_OSC_SEL_MODE,
	PMIC_RG_VOWEN_MODE,
	PMIC_RG_TOP_CKSEL_CON2_RSV,
	PMIC_TOP_CKSEL_CON1_SET,
	PMIC_TOP_CKSEL_CON1_CLR,
	PMIC_RG_REG_CK_DIVSEL,
	PMIC_TOP_CKDIVSEL_CON0_RSV,
	PMIC_TOP_CKDIVSEL_CON0_SET,
	PMIC_TOP_CKDIVSEL_CON0_CLR,
	PMIC_RG_G_SMPS_CK_PDN_HWEN,
	PMIC_RG_REG_CK_PDN_HWEN,
	PMIC_RG_EFUSE_CK_PDN_HWEN,
	PMIC_RG_EINT_32K_CK_PDN_HWEN,
	PMIC_RG_RTC26M_CK_PDN_HWEN,
	PMIC_RG_PMU26M_CK_PDN_HWEN,
	PMIC_TOP_CKHWEN_CON0_RSV,
	PMIC_TOP_CKHWEN_CON0_SET,
	PMIC_TOP_CKHWEN_CON0_CLR,
	PMIC_RG_PMU128K_CK_TST_DIS,
	PMIC_RG_SMPS_CK_TST_DIS,
	PMIC_RG_XO_CLK_26M_PMU_TST_DIS,
	PMIC_RG_XO_CLK_26M_DIG_TST_DIS,
	PMIC_RG_RTC_26M_CK_TST_DIS,
	PMIC_RG_RTC_32K_CK_TST_DIS,
	PMIC_RG_PMU_M_CK_TST_DIS,
	PMIC_TOP_CKTST_CON0_RSV,
	PMIC_RG_PMU128K_CK_TSTSEL,
	PMIC_RG_SMPS_CK_TSTSEL,
	PMIC_RG_XO_CLK_26M_PMU_TSTSEL,
	PMIC_RG_XO_CLK_26M_DIG_TSTSEL,
	PMIC_RG_RTC_26M_CK_TSTSEL,
	PMIC_RG_RTC_32K_CK_TSTSEL,
	PMIC_RG_PMU_M_CK_TSTSEL,
	PMIC_RG_EFUSE_CK_TSTSEL,
	PMIC_RG_BGR_TEST_CK_TSTSEL,
	PMIC_RG_PCHR_TEST_CK_TSTSEL,
	PMIC_RG_FQMTR_CK_TSTSEL,
	PMIC_RG_CLKSQ_EN_AUD,
	PMIC_RG_CLKSQ_EN_FQR,
	PMIC_RG_CLKSQ_EN_AUX_AP,
	PMIC_RG_CLKSQ_EN_AUX_MD,
	PMIC_RG_CLKSQ_EN_AUX_GPS,
	PMIC_RG_CLKSQ_EN_AUX_RSV,
	PMIC_RG_CLKSQ_EN_AUX_AP_MODE,
	PMIC_RG_CLKSQ_EN_AUX_MD_MODE,
	PMIC_RG_CLKSQ_IN_SEL_VA28,
	PMIC_RG_CLKSQ_IN_SEL_VA28_SWCTRL,
	PMIC_TOP_CLKSQ_RSV,
	PMIC_DA_CLKSQ_EN_VA28,
	PMIC_TOP_CLKSQ_SET,
	PMIC_TOP_CLKSQ_CLR,
	PMIC_RG_CLKSQ_RTC_EN,
	PMIC_RG_CLKSQ_RTC_EN_HW_MODE,
	PMIC_TOP_CLKSQ_RTC_RSV0,
	PMIC_RG_ENBB_SEL,
	PMIC_RG_XOSC_EN_SEL,
	PMIC_TOP_CLKSQ_RTC_RSV1,
	PMIC_DA_CLKSQ_EN_VDIG28,
	PMIC_TOP_CLKSQ_RTC_SET,
	PMIC_TOP_CLKSQ_RTC_CLR,
	PMIC_RG_OSC_SEL_SW_EN,
	PMIC_RG_OSC_SEL,
	PMIC_RG_OSC_EN_SW_EN,
	PMIC_RG_OSC_EN,
	PMIC_RG_G_SMPS_CK_PDN_VOWEN_EN,
	PMIC_RG_SRCLKEN0_LP_EN,
	PMIC_RG_SRCLKEN1_LP_EN,
	PMIC_RG_SRCLKEN2_LP_EN,
	PMIC_RG_BUCK_LP_EN,
	PMIC_RG_LDO_LP_EN,
	PMIC_RG_BUCK_PFM_FLAG,
	PMIC_RG_BUCK_PFM_FLAG_SW_EN,
	PMIC_RG_DCXO26M_RDY,
	PMIC_RG_DCXO26M_RDY_SW_EN,
	PMIC_RG_PMU_LP,
	PMIC_RG_PMU_LP_SW_EN,
	PMIC_TOP_CLK_CON0_SET,
	PMIC_TOP_CLK_CON0_CLR,
	PMIC_RG_PMU_MDB_DCM_SW_EN,
	PMIC_RG_PMU_MDB_DCM_SW_MODE,
	PMIC_RG_RTC_SEC_MDB_DCM_SW_EN,
	PMIC_RG_RTC_SEC_MDB_DCM_SW_MODE,
	PMIC_RG_RTC_MDB_DCM_SW_EN,
	PMIC_RG_RTC_MDB_DCM_SW_MODE,
	PMIC_RO_HANDOVER_DEBUG,
	PMIC_RG_EFUSE_MAN_RST,
	PMIC_RG_DRIVER_RST,
	PMIC_RG_FQMTR_RST,
	PMIC_RG_RTC_RST,
	PMIC_RG_TYPE_C_CC_RST,
	PMIC_RG_CLK_TRIM_RST,
	PMIC_RG_BUCK_SRCLKEN_RST,
	PMIC_TOP_RST_CON0_SET,
	PMIC_TOP_RST_CON0_CLR,
	PMIC_RG_BUCK_PROT_PMPP_RST,
	PMIC_RG_SPK_RST,
	PMIC_RG_FT_VR_SYSRSTB,
	PMIC_RG_LDO_CALI_RST,
	PMIC_TOP_RST_CON1_RSV,
	PMIC_TOP_RST_CON1_SET,
	PMIC_TOP_RST_CON1_CLR,
	PMIC_RG_CHR_LDO_DET_MODE,
	PMIC_RG_CHR_LDO_DET_SW,
	PMIC_RG_CHRWDT_FLAG_MODE,
	PMIC_RG_CHRWDT_FLAG_SW,
	PMIC_TOP_RST_CON2_RSV,
	PMIC_RG_WDTRSTB_EN,
	PMIC_RG_WDTRSTB_MODE,
	PMIC_WDTRSTB_STATUS,
	PMIC_WDTRSTB_STATUS_CLR,
	PMIC_RG_WDTRSTB_FB_EN,
	PMIC_RG_WDTRSTB_DEB,
	PMIC_RG_HOMEKEY_RST_EN,
	PMIC_RG_PWRKEY_RST_EN,
	PMIC_RG_PWRRST_TMR_DIS,
	PMIC_RG_PWRKEY_RST_TD,
	PMIC_TOP_RST_MISC_RSV,
	PMIC_TOP_RST_MISC_SET,
	PMIC_TOP_RST_MISC_CLR,
	PMIC_VPWRIN_RSTB_STATUS,
	PMIC_DDLO_RSTB_STATUS,
	PMIC_UVLO_RSTB_STATUS,
	PMIC_RTC_DDLO_RSTB_STATUS,
	PMIC_CHRWDT_REG_RSTB_STATUS,
	PMIC_CHRDET_REG_RSTB_STATUS,
	PMIC_BWDT_DDLO_RSTB_STATUS,
	PMIC_TOP_RST_STATUS_RSV,
	PMIC_TOP_RST_STATUS_SET,
	PMIC_TOP_RST_STATUS_CLR,
	PMIC_RG_INT_EN_EINT_RTC32K_1V8_1,
	PMIC_RG_INT_EN_SPI_CMD_ALERT,
	PMIC_MISC_TOP_INT_CON0_SET,
	PMIC_MISC_TOP_INT_CON0_CLR,
	PMIC_RG_INT_MASK_EINT_RTC32K_1V8_1,
	PMIC_RG_INT_MASK_SPI_CMD_ALERT,
	PMIC_MISC_TOP_INT_MASK_CON0_SET,
	PMIC_MISC_TOP_INT_MASK_CON0_CLR,
	PMIC_RG_INT_STATUS_EINT_RTC32K_1V8_1,
	PMIC_RG_INT_STATUS_SPI_CMD_ALERT,
	PMIC_RG_INT_RAW_STATUS_EINT_RTC32K_1V8_1,
	PMIC_RG_INT_RAW_STATUS_SPI_CMD_ALERT,
	PMIC_RG_INT_SEN_EINT_RTC32K_1V8_1,
	PMIC_INT_EINT_CON0_SET,
	PMIC_INT_EINT_CON0_CLR,
	PMIC_RG_INT_POL_EINT_RTC32K_1V8_1,
	PMIC_INT_EINT_CON1_SET,
	PMIC_INT_EINT_CON1_CLR,
	PMIC_RG_SW_SEL_EINT_RTC32K_1V8_1,
	PMIC_INT_EINT_CON2_SET,
	PMIC_INT_EINT_CON2_CLR,
	PMIC_RG_SW_EINT_RTC32K_1V8_1,
	PMIC_INT_EINT_CON3_SET,
	PMIC_INT_EINT_CON3_CLR,
	PMIC_RG_DEB_EINT_RTC32K_1V8_1,
	PMIC_INT_EINT_CON4_SET,
	PMIC_INT_EINT_CON4_CLR,
	PMIC_RG_DEB_EINT_AUD_CLK_MOSI,
	PMIC_INT_EINT_CON5_SET,
	PMIC_INT_EINT_CON5_CLR,
	PMIC_RG_INT_MASK_BUCK_TOP,
	PMIC_RG_INT_MASK_LDO_TOP,
	PMIC_RG_INT_MASK_PSC_TOP,
	PMIC_RG_INT_MASK_SCK_TOP,
	PMIC_RG_INT_MASK_BM_TOP,
	PMIC_RG_INT_MASK_HK_TOP,
	PMIC_RG_INT_MASK_XPP_TOP,
	PMIC_RG_INT_MASK_AUD_TOP,
	PMIC_RG_INT_MASK_MISC_TOP,
	PMIC_RG_INT_MASK_TOP_CON0_RSV,
	PMIC_TOP_INT_MASK_CON0_SET,
	PMIC_TOP_INT_MASK_CON0_CLR,
	PMIC_INT_STATUS_BUCK_TOP,
	PMIC_INT_STATUS_LDO_TOP,
	PMIC_INT_STATUS_PSC_TOP,
	PMIC_INT_STATUS_SCK_TOP,
	PMIC_INT_STATUS_BM_TOP,
	PMIC_INT_STATUS_HK_TOP,
	PMIC_INT_STATUS_XPP_TOP,
	PMIC_INT_STATUS_AUD_TOP,
	PMIC_INT_STATUS_MISC_TOP,
	PMIC_INT_STATUS_TOP_RSV,
	PMIC_INT_RAW_STATUS_BUCK_TOP,
	PMIC_INT_RAW_STATUS_LDO_TOP,
	PMIC_INT_RAW_STATUS_PSC_TOP,
	PMIC_INT_RAW_STATUS_SCK_TOP,
	PMIC_INT_RAW_STATUS_BM_TOP,
	PMIC_INT_RAW_STATUS_HK_TOP,
	PMIC_INT_RAW_STATUS_XPP_TOP,
	PMIC_INT_RAW_STATUS_AUD_TOP,
	PMIC_INT_RAW_STATUS_MISC_TOP,
	PMIC_INT_RAW_STATUS_TOP_RSV,
	PMIC_RG_INT_POLARITY,
	PMIC_RG_OTP_PA,
	PMIC_RG_OTP_PDIN,
	PMIC_RG_OTP_PTM,
	PMIC_RG_OTP_PWE,
	PMIC_RG_OTP_PPROG,
	PMIC_RG_OTP_PWE_SRC,
	PMIC_RG_OTP_PROG_PKEY,
	PMIC_RG_OTP_RD_PKEY,
	PMIC_RG_OTP_RD_TRIG,
	PMIC_RG_RD_RDY_BYPASS,
	PMIC_RG_SKIP_OTP_OUT,
	PMIC_RG_OTP_RD_SW,
	PMIC_RG_OTP_DOUT_SW,
	PMIC_RG_OTP_RD_BUSY,
	PMIC_RG_OTP_RD_ACK,
	PMIC_RG_OTP_PA_SW,
	PMIC_TOP1_ELR_LEN,
	PMIC_RG_TOP1_RSV0,
	PMIC_RG_TOP1_RSV1,
	PMIC_EFUSE_OSC_MODE,
	PMIC_TOPA0_ANA_ID,
	PMIC_TOPA0_DIG_ID,
	PMIC_TOPA0_ANA_MINOR_REV,
	PMIC_TOPA0_ANA_MAJOR_REV,
	PMIC_TOPA0_DIG_MINOR_REV,
	PMIC_TOPA0_DIG_MAJOR_REV,
	PMIC_TOPA0_SW_MINOR_REV,
	PMIC_TOPA0_SW_MAJOR_REV,
	PMIC_TOPA0_ESP,
	PMIC_FQMTR_TCKSEL,
	PMIC_FQMTR_BUSY,
	PMIC_FQMTR_DCXO26M_EN,
	PMIC_FQMTR_EN,
	PMIC_FQMTR_WINSET,
	PMIC_FQMTR_DATA,
	PMIC_RG_OSC_128K_TRIM_EN,
	PMIC_RG_OSC_128K_TRIM_RATE,
	PMIC_DA_OSC_128K_TRIM,
	PMIC_TOP_MDB_RSV0,
	PMIC_RG_MDB_DM1_DS_EN,
	PMIC_TOP_MDB_RSV1,
	PMIC_TOPA0_ELR_LEN,
	PMIC_RG_OSC_128K_TRIM,
	PMIC_SPISLV_ANA_ID,
	PMIC_SPISLV_DIG_ID,
	PMIC_SPISLV_ANA_MINOR_REV,
	PMIC_SPISLV_ANA_MAJOR_REV,
	PMIC_SPISLV_DIG_MINOR_REV,
	PMIC_SPISLV_DIG_MAJOR_REV,
	PMIC_SPISLV_SW_MINOR_REV,
	PMIC_SPISLV_SW_MAJOR_REV,
	PMIC_SPISLV_ESP,
	PMIC_RG_SLP_RW_EN,
	PMIC_RG_EN_RECORD,
	PMIC_RG_MDB_BRIDGE_SWRST,
	PMIC_RG_MDB_BRIDGE_BYPASS_MODE,
	PMIC_RG_SPI_RSV,
	PMIC_DEW_DIO_EN,
	PMIC_DEW_READ_TEST,
	PMIC_DEW_WRITE_TEST,
	PMIC_DEW_CRC_SWRST,
	PMIC_DEW_CRC_EN,
	PMIC_DEW_CRC_VAL,
	PMIC_DEW_DBG_MON_SEL,
	PMIC_DEW_CIPHER_KEY_SEL,
	PMIC_DEW_CIPHER_IV_SEL,
	PMIC_DEW_CIPHER_EN,
	PMIC_DEW_CIPHER_RDY,
	PMIC_DEW_CIPHER_MODE,
	PMIC_DEW_CIPHER_SWRST,
	PMIC_DEW_RDDMY_NO,
	PMIC_INT_TYPE_CON0,
	PMIC_INT_TYPE_CON0_SET,
	PMIC_INT_TYPE_CON0_CLR,
	PMIC_INT_TYPE_CON1,
	PMIC_INT_TYPE_CON1_SET,
	PMIC_INT_TYPE_CON1_CLR,
	PMIC_INT_TYPE_CON2,
	PMIC_INT_TYPE_CON2_SET,
	PMIC_INT_TYPE_CON2_CLR,
	PMIC_INT_TYPE_CON3,
	PMIC_INT_TYPE_CON3_SET,
	PMIC_INT_TYPE_CON3_CLR,
	PMIC_INT_TYPE_CON4,
	PMIC_INT_TYPE_CON4_SET,
	PMIC_INT_TYPE_CON4_CLR,
	PMIC_INT_TYPE_CON5,
	PMIC_INT_TYPE_CON5_SET,
	PMIC_INT_TYPE_CON5_CLR,
	PMIC_INT_TYPE_CON6,
	PMIC_INT_TYPE_CON6_SET,
	PMIC_INT_TYPE_CON6_CLR,
	PMIC_CPU_INT_STA,
	PMIC_MD32_INT_STA,
	PMIC_RG_SRCLKEN_IN3_SMPS_CLK_MODE,
	PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST,
	PMIC_RG_SRCLKEN_IN2_SMPS_CLK_MODE,
	PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST,
	PMIC_RG_SPI_DLY_SEL,
	PMIC_RECORD_CMD0,
	PMIC_RECORD_CMD1,
	PMIC_RECORD_CMD2,
	PMIC_RECORD_WDATA0,
	PMIC_RECORD_WDATA1,
	PMIC_RECORD_WDATA2,
	PMIC_RG_ADDR_TARGET,
	PMIC_RG_ADDR_MASK,
	PMIC_RG_WDATA_TARGET,
	PMIC_RG_WDATA_MASK,
	PMIC_RG_SPI_RECORD_CLR,
	PMIC_RG_CMD_ALERT_CLR,
	PMIC_RG_SRCLKEN_IN2_EN,
	PMIC_RG_SRCLKEN_IN3_EN,
	PMIC_PSC_TOP_ANA_ID,
	PMIC_PSC_TOP_DIG_ID,
	PMIC_PSC_TOP_ANA_MINOR_REV,
	PMIC_PSC_TOP_ANA_MAJOR_REV,
	PMIC_PSC_TOP_DIG_MINOR_REV,
	PMIC_PSC_TOP_DIG_MAJOR_REV,
	PMIC_PSC_TOP_SW_MINOR_REV,
	PMIC_PSC_TOP_SW_MAJOR_REV,
	PMIC_PSC_TOP_ESP,
	PMIC_PSC_TOP_CLK_OFFSET,
	PMIC_PSC_TOP_RST_OFFSET,
	PMIC_PSC_TOP_INT_OFFSET,
	PMIC_PSC_TOP_INT_LEN,
	PMIC_RG_STRUP_LONG_PRESS_RST,
	PMIC_RG_PSEQ_PWRMSK_RST_SEL,
	PMIC_BANK_STRUP_SWRST,
	PMIC_BANK_PSEQ_SWRST,
	PMIC_BANK_PCHR_DIG_SWRST,
	PMIC_BANK_PCHR_MACRO_SWRST,
	PMIC_RG_INT_EN_PWRKEY,
	PMIC_RG_INT_EN_HOMEKEY,
	PMIC_RG_INT_EN_P