#define LOG_TAG "LCM"

#ifndef BUILD_LK
#include <linux/string.h>
#include <linux/kernel.h>
#endif

#include "lcm_drv.h"

#ifdef BUILD_LK
#include <platform/upmu_common.h>
#include <platform/mt_gpio.h>
#include <platform/mt_i2c.h>
#include <platform/mt_pmic.h>
#include <string.h>
#elif defined(BUILD_UBOOT)
#include <asm/arch/mt_gpio.h>
#else
#endif

#ifdef BUILD_LK
#define LCM_LOGI(string, args...)  dprintf(0, "[LK/"LOG_TAG"]"string, ##args)
#define LCM_LOGD(string, args...)  dprintf(1, "[LK/"LOG_TAG"]"string, ##args)
#else
#define LCM_LOGI(fmt, args...)  pr_debug("[KERNEL/"LOG_TAG"]"fmt, ##args)
#define LCM_LOGD(fmt, args...)  pr_debug("[KERNEL/"LOG_TAG"]"fmt, ##args)
#endif

//prize-add tp enter low power mode-pengzhipeng-20190109-start
extern void fts_enter_low_power(void);
//int fts_reset_proc(int hdelayms);
//prize-add tp enter low power mode-pengzhipeng-20190109-end

static struct LCM_UTIL_FUNCS lcm_util;

#define SET_RESET_PIN(v)			(lcm_util.set_reset_pin((v)))
#define MDELAY(n)					(lcm_util.mdelay(n))

/* --------------------------------------------------------------------------- */
/* Local Functions */
/* --------------------------------------------------------------------------- */
#define dsi_set_cmdq_V2(cmd, count, ppara, force_update) \
	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update) \
	lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd) \
	lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums) \
	lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg(cmd) \
	lcm_util.dsi_dcs_read_lcm_reg(cmd)
#define read_reg_v2(cmd, buffer, buffer_size) \
	lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)
#define set_gpio_lcd_enp(cmd) \
		lcm_util.set_gpio_lcd_enp_bias(cmd)
		

static const unsigned char LCD_MODULE_ID = 0x01;
/* --------------------------------------------------------------------------- */
/* Local Constants */
/* --------------------------------------------------------------------------- */
#define LCM_DSI_CMD_MODE	0
#define FRAME_WIDTH  										 (720)
#define FRAME_HEIGHT 										 (1600)

#define REGFLAG_DELAY             							 0xFFFA
#define REGFLAG_UDELAY             							 0xFFFB
#define REGFLAG_PORT_SWAP									 0xFFFC
#define REGFLAG_END_OF_TABLE      							 0xFFFD   // END OF REGISTERS MARKER

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* --------------------------------------------------------------------------- */
/* Local Variables */
/* --------------------------------------------------------------------------- */

struct LCM_setting_table
{
    unsigned int cmd;
    unsigned char count;
    unsigned char para_list[64];
};

static struct LCM_setting_table lcm_suspend_setting[] =
{
    {0x28, 1, {0x00}},
    {REGFLAG_DELAY, 10, {}},
    {0x10, 1, {0x00}},
    {REGFLAG_DELAY, 60, {} },
	//prize-add tp enter low power mode-pengzhipeng-20190109-start
	{0x04,1,{0x5a}},
    {0x05,1,{0x5a}},
	{REGFLAG_DELAY, 10, {} },
    {REGFLAG_END_OF_TABLE, 0x00, {}}
    //prize-add tp enter low power mode-pengzhipeng-20190109-start

};

static struct LCM_setting_table lcm_initialization_setting[] =
{
#if 1
//-------------  Display Initial Code Setting  -------------------------
//Stop reload
        {0x41,1,{0x5A}},
 
//INT CANCEL
        {0x4C,1,{0x03}},
 
//VCOM
        {0x41,2,{0x5A,0x03}},
        {0x80,2,{0xA9,0x00}},

//----------------------LCD initial code start----------------------//
//Blank 9
        {0x41,2,{0x5A,0x09}},
        {0x80,5,{0x64,0x00,0x64,0x00,0x00}},
//Blank 10
        {0x41,2,{0x5A,0x0A}},
        {0x80,16,{0xA5,0x15,0xA5,0xAA,0xA5,0x88,0x42,0xC8,0x8C,0x03,0x07,0x05,0x39,0x61,0x32,0x5A}},
        {0x90,16,{0x0C,0x0F,0x22,0x00,0x2A,0x18,0x64,0x00,0x88,0x03,0x03,0xEE,0xEE,0x00,0x3F,0x2A}},
        {0xA0,16,{0x00,0x30,0x02,0x32,0x11,0x0D,0x60,0x01,0xFF,0xFF,0x03,0x40,0x42,0x0F,0x94,0x11}},
        {0xB0,16,{0xE8,0x03,0x00,0x00,0x11,0x0D,0x60,0x00,0xFF,0xFF,0x03,0xFF,0x34,0x0C,0x0F,0x0E}},
        {0xC0,10,{0x1F,0x03,0x00,0x08,0x20,0x34,0x00,0x00,0x00,0x00}},
//Blank 11
        {0x41,2,{0x5A,0x0B}},
        {0x80,16,{0xFF,0xBE,0xE6,0x00,0x00,0x04,0x10,0x1D,0x26,0x30,0x40,0x4D,0x51,0x5E,0x63,0x7A}},
        {0x90,16,{0x86,0x70,0x6F,0x62,0x5A,0x4C,0x3D,0x33,0x29,0x18,0x06,0x01,0x00,0x04,0x10,0x1D}},
        {0xA0,16,{0x26,0x30,0x40,0x4D,0x51,0x5E,0x63,0x7A,0x86,0x70,0x6F,0x62,0x5A,0x4C,0x3D,0x33}},
        {0xB0,5,{0x29,0x18,0x06,0x01,0x00}},
//Blank 12
        {0x41,2,{0x5A,0x0C}},
        {0x80,16,{0x00,0x00,0x20,0x42,0x00,0x00,0x80,0x05,0x54,0x00,0x00,0x00,0x20,0x42,0x00,0x00}},
        {0x90,2,{0x80,0x05}},
//Blank 13
        {0x41,2,{0x5A,0x0D}},
        {0x80,16,{0x7A,0xD0,0x02,0x40,0x06,0xD7,0x00,0xFA,0x00,0x0A,0x0A,0x0A,0x0A,0x00,0x01,0x03}},
        {0x90,16,{0x00,0x00,0x00,0x00,0xAC,0xA2,0x2A,0x00,0x00,0x00,0xAC,0xA2,0x2A,0x57,0x31,0x00}},
        {0xA0,16,{0x00,0x00,0x00,0x00,0x00,0xAC,0xA2,0x2A,0xAA,0xC2,0x2A,0xAC,0xA2,0x2A,0xAA,0xC2}},
        {0xB0,6,{0x2A,0x00,0x00,0x00,0xAA,0x52}},
//Blank 14
        {0x41,2,{0x5A,0x0E}},
        {0x80,12,{0xF0,0xB1,0x71,0xEF,0x4B,0x20,0x37,0x0F,0xAA,0xAA,0x00,0x00}},
//Blank 15
        {0x41,2,{0x5A,0x0F}},
        {0x80,11,{0xFF,0x00,0x55,0x55,0x23,0x88,0x88,0x1C,0x00,0x5A,0x5A}},
//Blank 16
        {0x41,2,{0x5A,0x10}},
        {0x80,16,{0xB5,0x45,0x09,0x18,0x01,0x3C,0x94,0x32,0x10,0xC4,0xC4,0x04,0x00,0x60,0xC0,0x00}},
        {0x90,16,{0x04,0x00,0x00,0x86,0x10,0x31,0x98,0x34,0x34,0x34,0x26,0x26,0x3E,0x1A,0x62,0x20}},
        {0xA0,4,{0x0C,0x40,0x00,0x8A}},
//Blank 17
        {0x41,2,{0x5A,0x11}},
        {0x80,16,{0x00,0x00,0x03,0xE7,0x1F,0x17,0x10,0x48,0x80,0xAA,0x90,0x1A,0x30,0x88,0x41,0x8A}},
        {0x90,15,{0x39,0x28,0xA9,0xC5,0x9A,0x7B,0xF0,0x07,0x7E,0xE0,0x07,0x7E,0x20,0x10,0x00}},
//Blank 18
        {0x41,2,{0x5A,0x12}},
        {0x80,16,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x41,0x37}},
        {0x90,16,{0x2D,0x23,0x19,0x0F,0x05,0xFB,0xF1,0xE7,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
        {0xA0,16,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
        {0xB0,16,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2D,0x23,0x05,0xFB,0x00,0x2D,0x23}},
        {0xC0,4,{0x05,0xFB,0x00,0x01}},
//Blank 19
        {0x41,2,{0x5A,0x13}},
        {0x80,16,{0xFD,0x0F,0x00,0x0C,0x00,0x80,0x80,0x87,0x00,0x07,0x22,0x06,0xE7,0xB9,0x86,0x1A}},
        {0x90,16,{0x32,0x00,0xA2,0x2D,0x65,0x00,0x00,0x00,0x00,0xD0,0xC9,0xB7,0xFE,0x26,0x6F,0x32}},
        {0xA0,3,{0x22,0x90,0x04}},
//Blank 20
        {0x41,2,{0x5A,0x14}},
        {0x80,16,{0x01,0x02,0x40,0x5E,0xD1,0xDF,0xEF,0xF7,0xFB,0xFD,0x02,0x00,0x00,0x20,0x8B,0x0F}},
        {0x90,16,{0xD1,0x7B,0x40,0x6C,0x88,0xDE,0x03,0xE2,0x42,0xF4,0x1E,0x10,0x13,0xA2,0xF7,0x00}},
        {0xA0,16,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x02,0x00,0x00,0x00,0x00,0x00}},
        {0xB0,16,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x64,0x43,0x56,0x00,0x80,0x42}},
        {0xC0,16,{0xA1,0xF0,0x0E,0x44,0xEF,0x01,0xA5,0x38,0xDE,0x80,0xE8,0x3D,0xA0,0x14,0xC7,0x0B}},
        {0xD0,16,{0x10,0xBD,0x07,0x94,0xE2,0x78,0x05,0xA2,0xF7,0x80,0x52,0x1C,0xEF,0x42,0xF4,0x1E}},
        {0xE0,16,{0x50,0x8A,0xE3,0x4D,0x88,0xDE,0x03,0x4A,0x71,0xBC,0x07,0xD1,0x7B,0x40,0x29,0x8E}},
        {0xF0,16,{0xB7,0x20,0x7A,0x0F,0x28,0xC5,0x31,0x02,0x7E,0xBF,0x31,0x00,0x00,0x00,0x00,0x00}},
//Blank 21
        {0x41,2,{0x5A,0x15}},
        {0x80,16,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0xB0,0xC1,0xEF}},
        {0x90,16,{0xE7,0x01,0x42,0xF6,0x88,0x51,0xFB,0x0B,0x22,0x23,0x2B,0x62,0xD4,0x6A,0x83,0xC8}},
        {0xA0,16,{0xC8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x21}},
        {0xB0,16,{0x33,0x62,0xD4,0x2A,0x00,0x00,0x00,0x00,0x26,0x00,0xE0,0x01,0x28,0xAD,0x09,0x9A}},
        {0xC0,16,{0x92,0x95,0xA6,0x82,0xA1,0x38,0x6D,0xDB,0xB6,0x6D,0xDB,0xB6,0x6D,0xDB,0xA6,0xA0}},
        {0xD0,16,{0x49,0x41,0x66,0xCA,0x20,0x04,0xD0,0xB6,0x6D,0xDB,0xB6,0x6D,0xDB,0xB6,0xAD,0x09}},
        {0xE0,16,{0x9A,0x10,0x95,0xA6,0x00,0x81,0x30,0x6D,0xDB,0xB6,0x6D,0xDB,0xB6,0x6D,0xDB,0xA6}},
        {0xF0,16,{0xA0,0x69,0x49,0x66,0xEA,0x28,0x86,0xD0,0xB6,0x6D,0xDB,0xB6,0x6D,0xDB,0xB6,0x00}},
//Blank 22
        {0x41,2,{0x5A,0x16}},
        {0x80,16,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
        {0x90,10,{0x00,0x00,0x00,0x00,0x80,0x42,0x2B,0x01,0x00,0x00}},
//Blank 24
        {0x41,2,{0x5A,0x18}},
        {0x80,16,{0xEF,0xBD,0xF7,0xDE,0x7B,0xEF,0xBD,0x07,0x08,0x08,0x0A,0x0C,0x0C,0x0C,0x0C,0x0C}},
        {0x90,16,{0x0C,0x0C,0x0C,0x5C,0x09,0xA8,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0x5A}},
        {0xA0,16,{0x59,0x59,0x59,0x59,0x59,0x59,0x59,0x59,0x59,0x59,0x59,0x09,0x04,0xFF,0x00,0x80}},
        {0xB0,15,{0x80,0x00,0x04,0x20,0x00,0x01,0x08,0x40,0x00,0x02,0x10,0x80,0x00,0x04,0x00}},
//Blank 25
        {0x41,2,{0x5A,0x19}},
        {0x80,16,{0xF0,0xD9,0xC8,0xBA,0xAF,0xA6,0x9E,0x98,0x92,0x8D,0x88,0x84,0x00,0x60,0xF6,0xCF}},
        {0x90,16,{0xFC,0x6F,0xF6,0xEF,0xCF,0xAF,0x0F,0xFF,0xAF,0xB5,0x71,0x0E,0x6C,0x4A,0x69,0x08}},
        {0xA0,4,{0x00,0x00,0x48,0x00}},
//Blank 26
        {0x41,2,{0x5A,0x1A}},
        {0x80,16,{0xFF,0x04,0x04,0x08,0x0C,0x00,0x10,0x14,0x18,0x1C,0x00,0x20,0x28,0x30,0x38,0x00}},
        {0x90,16,{0x40,0x48,0x50,0x58,0x00,0x60,0x68,0x70,0x78,0x00,0x80,0x88,0x90,0x98,0x00,0xA0}},
        {0xA0,16,{0xA8,0xB0,0xB8,0x00,0xC0,0xC8,0xD0,0xD8,0x00,0xE0,0xE8,0xF0,0xF8,0x00,0xFC,0xFE}},
        {0xB0,16,{0xFF,0x00,0x00,0x04,0x08,0x0C,0x00,0x10,0x14,0x18,0x1C,0x00,0x20,0x28,0x30,0x38}},
        {0xC0,16,{0x00,0x40,0x48,0x50,0x58,0x00,0x60,0x68,0x70,0x78,0x00,0x80,0x88,0x90,0x98,0x00}},
        {0xD0,16,{0xA0,0xA8,0xB0,0xB8,0x00,0xC0,0xC8,0xD0,0xD8,0x00,0xE0,0xE8,0xF0,0xF8,0x00,0xFC}},
        {0xE0,16,{0xFE,0xFF,0x00,0x00,0x04,0x08,0x0C,0x00,0x10,0x14,0x18,0x1C,0x00,0x20,0x28,0x30}},
        {0xF0,16,{0x38,0x00,0x40,0x48,0x50,0x58,0x00,0x60,0x68,0x70,0x78,0x00,0x80,0x88,0x90,0x98}},
//Blank 27
        {0x41,2,{0x5A,0x1B}},
        {0x80,16,{0x00,0xA0,0xA8,0xB0,0xB8,0x00,0xC0,0xC8,0xD0,0xD8,0x00,0xE0,0xE8,0xF0,0xF8,0x00}},
        {0x90,5,{0xFC,0xFE,0xFF,0x00,0x00}},
//Blank 28
        {0x41,2,{0x5A,0x1C}},
        {0x80,16,{0x33,0x22,0x00,0x03,0x5A,0x02,0x5A,0x54,0xE5,0xFF,0xC7,0x00,0x18,0x28,0x18,0x08}},
        {0x90,16,{0x10,0x0C,0x07,0x09,0x06,0x06,0x0A,0x10,0x0C,0x09,0x0B,0x06,0x06,0xF0,0x78,0x40}},
        {0xA0,16,{0x20,0x08,0x08,0x06,0x13,0xC0,0x34,0x1E,0x0A,0x08,0x66,0xD1,0xA0,0x1C,0x20,0x20}},
        {0xB0,16,{0x18,0x04,0x20,0x00,0xC0,0x04,0x28,0x01,0x4C,0x00,0x23,0x18,0x10,0x0A,0x06,0xC9}},
        {0xC0,16,{0x04,0x70,0x41,0x58,0x54,0xB5,0x4A,0x55,0x15,0x00,0x78,0xF8,0x99,0x99,0x99,0x99}},
        {0xD0,16,{0x99,0x19,0x11,0x11,0x11,0x11,0x11,0x11,0x08,0xC8,0xE3,0x81,0x00,0x20,0x80,0x27}},
        {0xE0,16,{0xE2,0x89,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x31,0x04,0x41,0xB6,0x6D,0xDB,0xB6}},
        {0xF0,16,{0x6D,0xDB,0xB6,0x6D,0xDB,0xB6,0x6D,0xDB,0xB6,0x6D,0xDB,0xB6,0x6D,0xC0,0x03,0x40}},
//Blank 29
        {0x41,2,{0x5A,0x1D}},
        {0x80,16,{0x00,0x01,0x54,0x0B,0x23,0x18,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
//Blank 34
        {0x41,2,{0x5A,0x22}},
        {0x80,15,{0x00,0x5E,0x00,0x00,0x00,0x00,0x00,0x00,0x5E,0x00,0x00,0x00,0x00,0x00,0x00}},
//Blank 36
        {0x41,2,{0x5A,0x24}},
        {0x80,16,{0x2D,0xD3,0x00,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x1F,0x00,0xAA,0x3E,0x00}},
        {0x90,4,{0x00,0x00,0x00,0x00}},
//Blank 37
        {0x41,2,{0x5A,0x25}},
        {0x80,16,{0x01,0x05,0x00,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF}},
        {0x90,11,{0x0F,0x00,0x00,0x24,0x00,0x00,0x00,0x00,0xFF,0x07,0x35}},
//Blank 38
        {0x41,2,{0x5A,0x26}},
        {0x80,16,{0x00,0x83,0x00,0xFF,0xFF,0x60,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x2F,0x44}},
        {0x90,3,{0x5A,0xA5,0x5A}},

//----------------------LCD initial code End----------------------//

//SPI FINISH
        {0x90,1,{0xA5}},
//Blank select 2F 
        {0x41,2,{0x00,0x2F}},
#endif
{0x11,0,{}},
{REGFLAG_DELAY,60, {}},
{0x29,0,{}},

//-------------  Display Initial Setting end -------------------------
	{REGFLAG_END_OF_TABLE, 0x00, {}}    
};

static void push_table(struct LCM_setting_table *table, unsigned int count, unsigned char force_update)
{
    unsigned int i;

    for (i = 0; i < count; i++)
    {
        unsigned cmd;
        cmd = table[i].cmd;

        switch (cmd)
        {
        case REGFLAG_DELAY:
            if (table[i].count <= 10)
                MDELAY(table[i].count);
            else
                MDELAY(table[i].count);
            break;

        case REGFLAG_END_OF_TABLE:
            break;

        default:
            dsi_set_cmdq_V2(cmd, table[i].count, table[i].para_list, force_update);
        }
    }
}

/* --------------------------------------------------------------------------- */
/* LCM Driver Implementations */
/* --------------------------------------------------------------------------- */

static void lcm_set_util_funcs(const struct LCM_UTIL_FUNCS *util)
{
	memcpy(&lcm_util, util, sizeof(struct LCM_UTIL_FUNCS));
}

static void lcm_get_params(struct LCM_PARAMS *params)
{
	memset(params, 0, sizeof(struct LCM_PARAMS));

	params->type                         = LCM_TYPE_DSI;
	params->width                        = FRAME_WIDTH;
	params->height                       = FRAME_HEIGHT;

	#ifndef BUILD_LK
	params->physical_width               = 68;
	params->physical_height              = 151;
	params->physical_width_um            = 67930;
	params->physical_height_um           = 150960;
	params->density                      = 320;
	#endif

	// enable tearing-free
	params->dbi.te_mode                  = LCM_DBI_TE_MODE_VSYNC_ONLY;
	params->dbi.te_edge_polarity         = LCM_POLARITY_RISING;

	#if (LCM_DSI_CMD_MODE)
	params->dsi.mode                     = CMD_MODE;
	params->dsi.switch_mode              = SYNC_PULSE_VDO_MODE;
	#else
	params->dsi.mode                     = SYNC_PULSE_VDO_MODE;//SYNC_EVENT_VDO_MODE;//BURST_VDO_MODE;////
	#endif

	// DSI
	/* Command mode setting */
	//1 Three lane or Four lane
	params->dsi.LANE_NUM                 = LCM_FOUR_LANE;
	//The following defined the fomat for data coming from LCD engine.
	params->dsi.data_format.color_order  = LCM_COLOR_ORDER_RGB;
	params->dsi.data_format.trans_seq    = LCM_DSI_TRANS_SEQ_MSB_FIRST;
	params->dsi.data_format.padding      = LCM_DSI_PADDING_ON_LSB;
	params->dsi.data_format.format       = LCM_DSI_FORMAT_RGB888;

	params->dsi.PS                       = LCM_PACKED_PS_24BIT_RGB888;

	#if (LCM_DSI_CMD_MODE)
	params->dsi.intermediat_buffer_num   = 0;//because DSI/DPI HW design change, this parameters should be 0 when video mode in MT658X; or memory leakage
	params->dsi.word_count               = FRAME_WIDTH * 3; //DSI CMD mode need set these two bellow params, different to 6577
	#else
	params->dsi.intermediat_buffer_num   = 2;	//because DSI/DPI HW design change, this parameters should be 0 when video mode in MT658X; or memory leakage
	#endif

	// Video mode setting
	params->dsi.packet_size              = 256;

	params->dsi.vertical_sync_active     = 8;
	params->dsi.vertical_backporch       = 106;
	params->dsi.vertical_frontporch      = 130;
	params->dsi.vertical_active_line     = FRAME_HEIGHT;

	params->dsi.horizontal_sync_active   = 14;
	params->dsi.horizontal_backporch     = 35;//36
	params->dsi.horizontal_frontporch    = 55;//78
	params->dsi.horizontal_active_pixel  = FRAME_WIDTH;
	/* params->dsi.ssc_disable = 1; */

	params->dsi.PLL_CLOCK                = 288;
	params->dsi.ssc_disable                         = 0;
	params->dsi.ssc_range                           = 4;
	params->dsi.esd_check_enable = 1;
	params->dsi.customization_esd_check_enable = 1;
	params->dsi.lcm_esd_check_table[0].cmd          = 0x0a;
	params->dsi.lcm_esd_check_table[0].count        = 1;
	params->dsi.lcm_esd_check_table[0].para_list[0] = 0x9c;
}

#define AUXADC_LCM_VOLTAGE_CHANNEL (2)
#define MIN_VOLTAGE (1350000)
#define MAX_VOLTAGE (1550000)
extern int IMM_GetOneChannelValue_Cali(int Channel, int *voltage);
static unsigned int lcm_compare_id(void)
{
    int res = 0;
    int lcm_vol = 0;
#ifdef AUXADC_LCM_VOLTAGE_CHANNEL
    res = IMM_GetOneChannelValue_Cali(AUXADC_LCM_VOLTAGE_CHANNEL,&lcm_vol);
    if(res < 0)
    {
#ifdef BUILD_LK
        dprintf(0,"lixf lcd [adc_uboot]: get data error\n");
#endif
        return 0;
    }
#endif
#ifdef BUILD_LK
    dprintf(0,"lsw lk: lcm_vol= %d , file : %s, line : %d\n",lcm_vol, __FILE__, __LINE__);
#else
    printk("lsw kernel: lcm_vol= %d , file : %s, line : %d\n",lcm_vol, __FILE__, __LINE__);
#endif
    if (lcm_vol >= MIN_VOLTAGE && lcm_vol <= MAX_VOLTAGE)
    {
        return 1;
    }


    return 0;
}

static void lcm_init(void)
{
	display_bias_enable();
	
    MDELAY(5);
    SET_RESET_PIN(1);
    MDELAY(5);
    SET_RESET_PIN(0);
    MDELAY(5);
    SET_RESET_PIN(1);
    MDELAY(10);
    
    push_table(lcm_initialization_setting, sizeof(lcm_initialization_setting) / sizeof(struct LCM_setting_table), 1);
}

static void lcm_suspend(void)
{
	fts_enter_low_power();
	MDELAY(10);
    push_table(lcm_suspend_setting, sizeof(lcm_suspend_setting) / sizeof(struct LCM_setting_table), 1);

	SET_RESET_PIN(1);
    MDELAY(10);
	display_bias_disable();
}

#ifndef BUILD_LK
extern atomic_t ESDCheck_byCPU;
#endif
static unsigned int lcm_ata_check(unsigned char *bufferr)
{
	//prize-Solve ATA testing-pengzhipeng-20181127-start
	unsigned char buffer0[2]={0};
	unsigned char buffer1[2]={0};
	unsigned char buffer2[2]={0};
	
	unsigned int data_array[6]; 
	 
	data_array[0]= 0x00023902;//LS packet 
	data_array[1]= 0x00005002; 
	dsi_set_cmdq(data_array, 2, 1);

	data_array[0]= 0x0002390a;//HS packet 
	data_array[1]= 0x0000fe27; 
	dsi_set_cmdq(data_array, 2, 1);
	

	data_array[0]= 0x0002390a;//HS packet 
	data_array[1]= 0x00005658; 
	dsi_set_cmdq(data_array, 2, 1);
	data_array[0] = 0x00033700;// read id return two byte,version and id
	dsi_set_cmdq(data_array, 1, 1);
	atomic_set(&ESDCheck_byCPU, 1);
	
	read_reg_v2(0x02, buffer0, 1);
	read_reg_v2(0x27, buffer1, 1);
	read_reg_v2(0x58, buffer2, 1);
	atomic_set(&ESDCheck_byCPU, 0);
	
	printk("%s, Kernel TDDI id = 0x%04x buffer1 0x52= 0x%04x buffer2= 0x%04x\n", __func__, buffer0[0], buffer1[0], buffer2[0]);
	return ((0x50 == buffer0[0])&&(0xfe == buffer1[0])&&(0x56 == buffer2[0]))?1:0; 
	//prize-Solve ATA testing-pengzhipeng-20181127-end
}

static void lcm_resume(void)
{
#if defined(CONFIG_TOUCHSCREEN_MTK_FOCALTECH_TS_V22)
//fts_reset_proc(80);
#endif
    lcm_init();
}

struct LCM_DRIVER ft8006p_hdp_dsi_vdo_boe_drip_incell_lcm_drv =
{
    .name			= "ft8006p_hdp_dsi_vdo_boe_drip_incell",
#if defined(CONFIG_PRIZE_HARDWARE_INFO) && !defined (BUILD_LK)
	.lcm_info = {
		.chip	= "ft8006p",
		.vendor	= "focaltech",
		.id		= "0x82",
		.more	= "720*1600",
	},
#endif
    .set_util_funcs = lcm_set_util_funcs,
    .get_params     = lcm_get_params,
    .init           = lcm_init,
    .suspend        = lcm_suspend,
    .resume         = lcm_resume,
    .compare_id     = lcm_compare_id,
	.ata_check 		= lcm_ata_check,
};
