/*
 * Copyright (C) 2016 MediaTek Inc.

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#include <linux/kernel.h>
#include <linux/module.h>

#include <mach/upmu_sw.h>
#include <mach/upmu_hw.h>
#include <mt-plat/upmu_common.h>

unsigned int mt6356_upmu_get_top0_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP0_ID), (&val),
				  (unsigned int)(PMIC_TOP0_ANA_ID_MASK),
				  (unsigned int)(PMIC_TOP0_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top0_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP0_ID), (&val),
				  (unsigned int)(PMIC_TOP0_DIG_ID_MASK),
				  (unsigned int)(PMIC_TOP0_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top0_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP0_REV0), (&val),
				(unsigned int)(PMIC_TOP0_ANA_MINOR_REV_MASK),
				(unsigned int)(PMIC_TOP0_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top0_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP0_REV0), (&val),
				(unsigned int)(PMIC_TOP0_ANA_MAJOR_REV_MASK),
				(unsigned int)(PMIC_TOP0_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top0_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP0_REV0), (&val),
				(unsigned int)(PMIC_TOP0_DIG_MINOR_REV_MASK),
				(unsigned int)(PMIC_TOP0_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top0_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP0_REV0), (&val),
				(unsigned int)(PMIC_TOP0_DIG_MAJOR_REV_MASK),
				(unsigned int)(PMIC_TOP0_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top0_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP0_REV1), (&val),
				(unsigned int)(PMIC_TOP0_SW_MINOR_REV_MASK),
				(unsigned int)(PMIC_TOP0_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top0_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP0_REV1), (&val),
				(unsigned int)(PMIC_TOP0_SW_MAJOR_REV_MASK),
				(unsigned int)(PMIC_TOP0_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_hwcid(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_HWCID), (&val),
				  (unsigned int)(PMIC_HWCID_MASK),
				  (unsigned int)(PMIC_HWCID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_swcid(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_SWCID), (&val),
				  (unsigned int)(PMIC_SWCID_MASK),
				  (unsigned int)(PMIC_SWCID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_pwrkey(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PONSTS), (&val),
				  (unsigned int)(PMIC_STS_PWRKEY_MASK),
				  (unsigned int)(PMIC_STS_PWRKEY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_rtca(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PONSTS), (&val),
				  (unsigned int)(PMIC_STS_RTCA_MASK),
				  (unsigned int)(PMIC_STS_RTCA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_chrin(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PONSTS), (&val),
				  (unsigned int)(PMIC_STS_CHRIN_MASK),
				  (unsigned int)(PMIC_STS_CHRIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_spar(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PONSTS), (&val),
				  (unsigned int)(PMIC_STS_SPAR_MASK),
				  (unsigned int)(PMIC_STS_SPAR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_rboot(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PONSTS), (&val),
				  (unsigned int)(PMIC_STS_RBOOT_MASK),
				  (unsigned int)(PMIC_STS_RBOOT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_uvlo(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_UVLO_MASK),
				  (unsigned int)(PMIC_STS_UVLO_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_pgfail(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_PGFAIL_MASK),
				  (unsigned int)(PMIC_STS_PGFAIL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_psoc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_PSOC_MASK),
				  (unsigned int)(PMIC_STS_PSOC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_thrdn(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_THRDN_MASK),
				  (unsigned int)(PMIC_STS_THRDN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_wrst(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_WRST_MASK),
				  (unsigned int)(PMIC_STS_WRST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_crst(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_CRST_MASK),
				  (unsigned int)(PMIC_STS_CRST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_pkeylp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_PKEYLP_MASK),
				  (unsigned int)(PMIC_STS_PKEYLP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_normoff(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_NORMOFF_MASK),
				  (unsigned int)(PMIC_STS_NORMOFF_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_bwdt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_BWDT_MASK),
				  (unsigned int)(PMIC_STS_BWDT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_ddlo(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_DDLO_MASK),
				  (unsigned int)(PMIC_STS_DDLO_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_wdt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_WDT_MASK),
				  (unsigned int)(PMIC_STS_WDT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_pupsrc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_PUPSRC_MASK),
				  (unsigned int)(PMIC_STS_PUPSRC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sts_keypwr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_POFFSTS), (&val),
				  (unsigned int)(PMIC_STS_KEYPWR_MASK),
				  (unsigned int)(PMIC_STS_KEYPWR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_poffsts_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSTSCTL),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_POFFSTS_CLR_MASK),
				    (unsigned int)(PMIC_RG_POFFSTS_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_ponsts_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSTSCTL),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PONSTS_CLR_MASK),
				    (unsigned int)(PMIC_RG_PONSTS_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_vusb_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VUSB_PG_DEB_MASK),
				  (unsigned int)(PMIC_VUSB_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vdram_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VDRAM_PG_DEB_MASK),
				  (unsigned int)(PMIC_VDRAM_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vio28_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VIO28_PG_DEB_MASK),
				  (unsigned int)(PMIC_VIO28_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vemc_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VEMC_PG_DEB_MASK),
				  (unsigned int)(PMIC_VEMC_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vio18_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VIO18_PG_DEB_MASK),
				  (unsigned int)(PMIC_VIO18_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vsram_proc_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				(unsigned int)(PMIC_VSRAM_PROC_PG_DEB_MASK),
				(unsigned int)(PMIC_VSRAM_PROC_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_va12_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VA12_PG_DEB_MASK),
				  (unsigned int)(PMIC_VA12_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vsram_gpu_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VSRAM_GPU_PG_DEB_MASK),
				  (unsigned int)(PMIC_VSRAM_GPU_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vsram_others_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_DEB_STS0), (&val),
	    (unsigned int)(PMIC_VSRAM_OTHERS_PG_DEB_MASK),
	    (unsigned int)(PMIC_VSRAM_OTHERS_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vaux18_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VAUX18_PG_DEB_MASK),
				  (unsigned int)(PMIC_VAUX18_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_rsv_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_BUCK_RSV_PG_DEB_MASK),
				  (unsigned int)(PMIC_BUCK_RSV_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vproc_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VPROC_PG_DEB_MASK),
				  (unsigned int)(PMIC_VPROC_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vs1_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VS1_PG_DEB_MASK),
				  (unsigned int)(PMIC_VS1_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vmodem_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VMODEM_PG_DEB_MASK),
				  (unsigned int)(PMIC_VMODEM_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vcore_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VCORE_PG_DEB_MASK),
				  (unsigned int)(PMIC_VCORE_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vs2_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS0), (&val),
				  (unsigned int)(PMIC_VS2_PG_DEB_MASK),
				  (unsigned int)(PMIC_VS2_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_ext_pmic_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS1), (&val),
				  (unsigned int)(PMIC_EXT_PMIC_PG_DEB_MASK),
				  (unsigned int)(PMIC_EXT_PMIC_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vxo22_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS1), (&val),
				  (unsigned int)(PMIC_VXO22_PG_DEB_MASK),
				  (unsigned int)(PMIC_VXO22_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_vaud28_pg_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PG_DEB_STS1), (&val),
				  (unsigned int)(PMIC_VAUD28_PG_DEB_MASK),
				  (unsigned int)(PMIC_VAUD28_PG_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vusb_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VUSB_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VUSB_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vdram_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VDRAM_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VDRAM_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vio28_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VIO28_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VIO28_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vemc_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VEMC_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VEMC_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vio18_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VIO18_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VIO18_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vsram_proc_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VSRAM_PROC_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VSRAM_PROC_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_va12_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VA12_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VA12_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vsram_gpu_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VSRAM_GPU_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VSRAM_GPU_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vsram_others_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VSRAM_OTHERS_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VSRAM_OTHERS_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vaux18_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VAUX18_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VAUX18_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_buck_rsv_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_BUCK_RSV_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_BUCK_RSV_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vproc_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VPROC_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VPROC_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vs1_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VS1_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VS1_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vmodem_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VMODEM_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VMODEM_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vcore_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VCORE_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VCORE_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vs2_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VS2_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VS2_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_ext_pmic_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS1), (&val),
	    (unsigned int)(PMIC_STRUP_EXT_PMIC_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_EXT_PMIC_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vxo22_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS1), (&val),
	    (unsigned int)(PMIC_STRUP_VXO22_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VXO22_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vaud28_pg_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PG_SDN_STS1), (&val),
	    (unsigned int)(PMIC_STRUP_VAUD28_PG_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VAUD28_PG_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_buck_rsv_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_OC_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_BUCK_RSV_OC_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_BUCK_RSV_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vproc_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_OC_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VPROC_OC_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VPROC_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vs1_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_OC_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VS1_OC_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VS1_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vmodem_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_OC_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VMODEM_OC_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VMODEM_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vcore_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_OC_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VCORE_OC_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VCORE_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_vs2_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_OC_SDN_STS0), (&val),
	    (unsigned int)(PMIC_STRUP_VS2_OC_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_VS2_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pmu_thermal_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_THERMALSTATUS), (&val),
				  (unsigned int)(PMIC_PMU_THERMAL_DEB_MASK),
				  (unsigned int)(PMIC_PMU_THERMAL_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_thermal_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_THERMALSTATUS), (&val),
	    (unsigned int)(PMIC_STRUP_THERMAL_STATUS_MASK),
	    (unsigned int)(PMIC_STRUP_THERMAL_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken_in0_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken_in0_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_CON), (&val),
				(unsigned int)(PMIC_RG_SRCLKEN_IN0_EN_MASK),
				(unsigned int)(PMIC_RG_SRCLKEN_IN0_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken_in0_hw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_HW_MODE_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_HW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_srclken_in1_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken_in1_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_CON), (&val),
				(unsigned int)(PMIC_RG_SRCLKEN_IN1_EN_MASK),
				(unsigned int)(PMIC_RG_SRCLKEN_IN1_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken_in1_hw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_HW_MODE_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_HW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_srclken_in_sync_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN_SYNC_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN_SYNC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken_in_sync_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CON), (&val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN_SYNC_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN_SYNC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_osc_en_auto_off(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OSC_EN_AUTO_OFF_MASK),
	    (unsigned int)(PMIC_RG_OSC_EN_AUTO_OFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_osc_en_auto_off(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_CON), (&val),
				(unsigned int)(PMIC_RG_OSC_EN_AUTO_OFF_MASK),
				(unsigned int)(PMIC_RG_OSC_EN_AUTO_OFF_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_test_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TEST_OUT), (&val),
				  (unsigned int)(PMIC_TEST_OUT_MASK),
				  (unsigned int)(PMIC_TEST_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_mon_flag_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TEST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_MON_FLAG_SEL_MASK),
	    (unsigned int)(PMIC_RG_MON_FLAG_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_mon_grp_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_MON_GRP_SEL_MASK),
				    (unsigned int)(PMIC_RG_MON_GRP_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_nandtree_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TEST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_NANDTREE_MODE_MASK),
	    (unsigned int)(PMIC_RG_NANDTREE_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_test_auxadc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TEST_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_TEST_AUXADC_MASK),
				    (unsigned int)(PMIC_RG_TEST_AUXADC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_efuse_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TEST_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_EFUSE_MODE_MASK),
				    (unsigned int)(PMIC_RG_EFUSE_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_test_strup(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TEST_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_TEST_STRUP_MASK),
				    (unsigned int)(PMIC_RG_TEST_STRUP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_testmode_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TESTMODE_SW),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TESTMODE_SW_MASK),
				    (unsigned int)(PMIC_TESTMODE_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_pmu_test_mode_scan(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOPSTATUS), (&val),
				(unsigned int)(PMIC_PMU_TEST_MODE_SCAN_MASK),
				(unsigned int)(PMIC_PMU_TEST_MODE_SCAN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pwrkey_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOPSTATUS), (&val),
				  (unsigned int)(PMIC_PWRKEY_DEB_MASK),
				  (unsigned int)(PMIC_PWRKEY_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_chrdet_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOPSTATUS), (&val),
				  (unsigned int)(PMIC_CHRDET_DEB_MASK),
				  (unsigned int)(PMIC_CHRDET_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_homekey_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOPSTATUS), (&val),
				  (unsigned int)(PMIC_HOMEKEY_DEB_MASK),
				  (unsigned int)(PMIC_HOMEKEY_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pmu_tdsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TDSEL_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PMU_TDSEL_MASK),
				    (unsigned int)(PMIC_RG_PMU_TDSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spi_tdsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TDSEL_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SPI_TDSEL_MASK),
				    (unsigned int)(PMIC_RG_SPI_TDSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_tdsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TDSEL_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_AUD_TDSEL_MASK),
				    (unsigned int)(PMIC_RG_AUD_TDSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_e32cal_tdsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TDSEL_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_E32CAL_TDSEL_MASK),
	    (unsigned int)(PMIC_RG_E32CAL_TDSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu_rdsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RDSEL_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PMU_RDSEL_MASK),
				    (unsigned int)(PMIC_RG_PMU_RDSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spi_rdsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RDSEL_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SPI_RDSEL_MASK),
				    (unsigned int)(PMIC_RG_SPI_RDSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_rdsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RDSEL_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_AUD_RDSEL_MASK),
				    (unsigned int)(PMIC_RG_AUD_RDSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_e32cal_rdsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RDSEL_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_E32CAL_RDSEL_MASK),
	    (unsigned int)(PMIC_RG_E32CAL_RDSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_wdtrstb_in(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_WDTRSTB_IN_MASK),
	    (unsigned int)(PMIC_RG_SMT_WDTRSTB_IN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_srclken_in0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_SRCLKEN_IN0_MASK),
	    (unsigned int)(PMIC_RG_SMT_SRCLKEN_IN0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_srclken_in1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_SRCLKEN_IN1_MASK),
	    (unsigned int)(PMIC_RG_SMT_SRCLKEN_IN1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_rtc_32k1v8_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_RTC_32K1V8_0_MASK),
	    (unsigned int)(PMIC_RG_SMT_RTC_32K1V8_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_rtc_32k1v8_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_RTC_32K1V8_1_MASK),
	    (unsigned int)(PMIC_RG_SMT_RTC_32K1V8_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_spi_clk(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_SMT_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SMT_SPI_CLK_MASK),
				    (unsigned int)(PMIC_RG_SMT_SPI_CLK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_spi_csn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_SMT_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SMT_SPI_CSN_MASK),
				    (unsigned int)(PMIC_RG_SMT_SPI_CSN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_spi_mosi(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_SPI_MOSI_MASK),
	    (unsigned int)(PMIC_RG_SMT_SPI_MOSI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_spi_miso(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_SPI_MISO_MASK),
	    (unsigned int)(PMIC_RG_SMT_SPI_MISO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_aud_clk_mosi(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_AUD_CLK_MOSI_MASK),
	    (unsigned int)(PMIC_RG_SMT_AUD_CLK_MOSI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_aud_dat_mosi0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_AUD_DAT_MOSI0_MASK),
	    (unsigned int)(PMIC_RG_SMT_AUD_DAT_MOSI0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_aud_dat_mosi1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_AUD_DAT_MOSI1_MASK),
	    (unsigned int)(PMIC_RG_SMT_AUD_DAT_MOSI1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_aud_sync_mosi(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_AUD_SYNC_MOSI_MASK),
	    (unsigned int)(PMIC_RG_SMT_AUD_SYNC_MOSI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_aud_clk_miso(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_AUD_CLK_MISO_MASK),
	    (unsigned int)(PMIC_RG_SMT_AUD_CLK_MISO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_aud_dat_miso0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_AUD_DAT_MISO0_MASK),
	    (unsigned int)(PMIC_RG_SMT_AUD_DAT_MISO0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_aud_dat_miso1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_AUD_DAT_MISO1_MASK),
	    (unsigned int)(PMIC_RG_SMT_AUD_DAT_MISO1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smt_aud_sync_miso(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMT_AUD_SYNC_MISO_MASK),
	    (unsigned int)(PMIC_RG_SMT_AUD_SYNC_MISO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_top_rsv0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_RSV0), (&val),
				  (unsigned int)(PMIC_RG_TOP_RSV0_MASK),
				  (unsigned int)(PMIC_RG_TOP_RSV0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_top_rsv1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_RSV1), (&val),
				  (unsigned int)(PMIC_RG_TOP_RSV1_MASK),
				  (unsigned int)(PMIC_RG_TOP_RSV1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_octl_srclken_in0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_SRCLKEN_IN0_MASK),
	    (unsigned int)(PMIC_RG_OCTL_SRCLKEN_IN0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_srclken_in1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_SRCLKEN_IN1_MASK),
	    (unsigned int)(PMIC_RG_OCTL_SRCLKEN_IN1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_rtc_32k1v8_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_RTC_32K1V8_0_MASK),
	    (unsigned int)(PMIC_RG_OCTL_RTC_32K1V8_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_rtc_32k1v8_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_RTC_32K1V8_1_MASK),
	    (unsigned int)(PMIC_RG_OCTL_RTC_32K1V8_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_spi_clk(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_SPI_CLK_MASK),
	    (unsigned int)(PMIC_RG_OCTL_SPI_CLK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_spi_csn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_SPI_CSN_MASK),
	    (unsigned int)(PMIC_RG_OCTL_SPI_CSN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_spi_mosi(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_SPI_MOSI_MASK),
	    (unsigned int)(PMIC_RG_OCTL_SPI_MOSI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_spi_miso(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_SPI_MISO_MASK),
	    (unsigned int)(PMIC_RG_OCTL_SPI_MISO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_aud_clk_mosi(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_AUD_CLK_MOSI_MASK),
	    (unsigned int)(PMIC_RG_OCTL_AUD_CLK_MOSI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_aud_dat_mosi0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_AUD_DAT_MOSI0_MASK),
	    (unsigned int)(PMIC_RG_OCTL_AUD_DAT_MOSI0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_aud_dat_mosi1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_AUD_DAT_MOSI1_MASK),
	    (unsigned int)(PMIC_RG_OCTL_AUD_DAT_MOSI1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_aud_sync_mosi(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_AUD_SYNC_MOSI_MASK),
	    (unsigned int)(PMIC_RG_OCTL_AUD_SYNC_MOSI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_aud_clk_miso(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_AUD_CLK_MISO_MASK),
	    (unsigned int)(PMIC_RG_OCTL_AUD_CLK_MISO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_aud_dat_miso0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_AUD_DAT_MISO0_MASK),
	    (unsigned int)(PMIC_RG_OCTL_AUD_DAT_MISO0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_aud_dat_miso1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_AUD_DAT_MISO1_MASK),
	    (unsigned int)(PMIC_RG_OCTL_AUD_DAT_MISO1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_octl_aud_sync_miso(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DRV_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OCTL_AUD_SYNC_MISO_MASK),
	    (unsigned int)(PMIC_RG_OCTL_AUD_SYNC_MISO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_srclken_in0_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken_in0_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken_in1_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken_in1_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_rtc32k_1v8_0_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_0_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_0_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_rtc32k_1v8_0_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_0_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_0_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_rtc32k_1v8_1_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_1_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_1_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_rtc32k_1v8_1_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_1_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_1_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_spi_clk_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SPI_CLK_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SPI_CLK_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_spi_clk_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_SPI_CLK_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SPI_CLK_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_spi_csn_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SPI_CSN_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SPI_CSN_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_spi_csn_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_SPI_CSN_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SPI_CSN_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_spi_mosi_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SPI_MOSI_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SPI_MOSI_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_spi_mosi_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_SPI_MOSI_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SPI_MOSI_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_spi_miso_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SPI_MISO_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SPI_MISO_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_spi_miso_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_SPI_MISO_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_SPI_MISO_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_aud_clk_mosi_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_CLK_MOSI_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_CLK_MOSI_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_aud_clk_mosi_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_AUD_CLK_MOSI_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_CLK_MOSI_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_aud_dat_mosi0_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI0_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI0_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_aud_dat_mosi0_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI0_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI0_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_aud_dat_mosi1_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI1_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI1_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_aud_dat_mosi1_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI1_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI1_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_aud_sync_mosi_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MOSI_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MOSI_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_aud_sync_mosi_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MOSI_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MOSI_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_aud_clk_miso_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_CLK_MISO_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_CLK_MISO_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_aud_clk_miso_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_AUD_CLK_MISO_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_CLK_MISO_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_aud_dat_miso0_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO0_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO0_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_aud_dat_miso0_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO0_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO0_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_aud_dat_miso1_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO1_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO1_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_aud_dat_miso1_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO1_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO1_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_aud_sync_miso_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MISO_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MISO_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_aud_sync_miso_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON0), (&val),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MISO_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MISO_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_wdtrstb_in_filter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_WDTRSTB_IN_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_WDTRSTB_IN_FILTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_wdtrstb_in_filter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FILTER_CON1), (&val),
	    (unsigned int)(PMIC_RG_WDTRSTB_IN_FILTER_EN_MASK),
	    (unsigned int)(PMIC_RG_WDTRSTB_IN_FILTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken_in0_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN0_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_srclken_in1_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN1_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc32k_1v8_0_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_0_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_0_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc32k_1v8_1_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_1_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_1_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spi_clk_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SPI_CLK_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_SPI_CLK_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spi_csn_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SPI_CSN_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_SPI_CSN_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spi_mosi_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SPI_MOSI_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_SPI_MOSI_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spi_miso_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SPI_MISO_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_SPI_MISO_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_clk_mosi_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_CLK_MOSI_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_AUD_CLK_MOSI_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_dat_mosi0_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI0_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI0_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_dat_mosi1_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI1_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MOSI1_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_sync_mosi_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MOSI_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MOSI_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_clk_miso_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_CLK_MISO_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_AUD_CLK_MISO_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_dat_miso0_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO0_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO0_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_dat_miso1_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO1_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_AUD_DAT_MISO1_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aud_sync_miso_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MISO_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_AUD_SYNC_MISO_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_wdtrstb_in_rcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FILTER_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_WDTRSTB_IN_RCSEL_MASK),
	    (unsigned int)(PMIC_RG_WDTRSTB_IN_RCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_top_status(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_STATUS),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TOP_STATUS_MASK),
				    (unsigned int)(PMIC_TOP_STATUS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_vm_mode(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_TRAP), (&val),
				  (unsigned int)(PMIC_VM_MODE_MASK),
				  (unsigned int)(PMIC_VM_MODE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_gpio_dir0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_DIR0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO_DIR0_MASK),
				    (unsigned int)(PMIC_GPIO_DIR0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio_pullen0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_PULLEN0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO_PULLEN0_MASK),
				    (unsigned int)(PMIC_GPIO_PULLEN0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio_pullsel0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_PULLSEL0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO_PULLSEL0_MASK),
				    (unsigned int)(PMIC_GPIO_PULLSEL0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio_dinv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_DINV0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO_DINV0_MASK),
				    (unsigned int)(PMIC_GPIO_DINV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio_dout0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_DOUT0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO_DOUT0_MASK),
				    (unsigned int)(PMIC_GPIO_DOUT0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_gpio_pi0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_GPIO_PI0), (&val),
				  (unsigned int)(PMIC_GPIO_PI0_MASK),
				  (unsigned int)(PMIC_GPIO_PI0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_gpio_poe0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_GPIO_POE0), (&val),
				  (unsigned int)(PMIC_GPIO_POE0_MASK),
				  (unsigned int)(PMIC_GPIO_POE0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_gpio0_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO0_MODE_MASK),
				    (unsigned int)(PMIC_GPIO0_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio1_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO1_MODE_MASK),
				    (unsigned int)(PMIC_GPIO1_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio2_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO2_MODE_MASK),
				    (unsigned int)(PMIC_GPIO2_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio3_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO3_MODE_MASK),
				    (unsigned int)(PMIC_GPIO3_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio4_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO4_MODE_MASK),
				    (unsigned int)(PMIC_GPIO4_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio5_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO5_MODE_MASK),
				    (unsigned int)(PMIC_GPIO5_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio6_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO6_MODE_MASK),
				    (unsigned int)(PMIC_GPIO6_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio7_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO7_MODE_MASK),
				    (unsigned int)(PMIC_GPIO7_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio8_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO8_MODE_MASK),
				    (unsigned int)(PMIC_GPIO8_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio9_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO9_MODE_MASK),
				    (unsigned int)(PMIC_GPIO9_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio10_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO10_MODE_MASK),
				    (unsigned int)(PMIC_GPIO10_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio11_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO11_MODE_MASK),
				    (unsigned int)(PMIC_GPIO11_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio12_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO12_MODE_MASK),
				    (unsigned int)(PMIC_GPIO12_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio13_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO13_MODE_MASK),
				    (unsigned int)(PMIC_GPIO13_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio14_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO14_MODE_MASK),
				    (unsigned int)(PMIC_GPIO14_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio15_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_MODE3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO15_MODE_MASK),
				    (unsigned int)(PMIC_GPIO15_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpio_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_GPIO_RSV),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_GPIO_RSV_MASK),
				    (unsigned int)(PMIC_GPIO_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_top1_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP1_ID), (&val),
				  (unsigned int)(PMIC_TOP1_ANA_ID_MASK),
				  (unsigned int)(PMIC_TOP1_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top1_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP1_ID), (&val),
				  (unsigned int)(PMIC_TOP1_DIG_ID_MASK),
				  (unsigned int)(PMIC_TOP1_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top1_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP1_REV0), (&val),
				(unsigned int)(PMIC_TOP1_ANA_MINOR_REV_MASK),
				(unsigned int)(PMIC_TOP1_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top1_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP1_REV0), (&val),
				(unsigned int)(PMIC_TOP1_ANA_MAJOR_REV_MASK),
				(unsigned int)(PMIC_TOP1_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top1_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP1_REV0), (&val),
				(unsigned int)(PMIC_TOP1_DIG_MINOR_REV_MASK),
				(unsigned int)(PMIC_TOP1_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top1_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP1_REV0), (&val),
				(unsigned int)(PMIC_TOP1_DIG_MAJOR_REV_MASK),
				(unsigned int)(PMIC_TOP1_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top1_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP1_REV1), (&val),
				(unsigned int)(PMIC_TOP1_SW_MINOR_REV_MASK),
				(unsigned int)(PMIC_TOP1_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_top1_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP1_REV1), (&val),
				(unsigned int)(PMIC_TOP1_SW_MAJOR_REV_MASK),
				(unsigned int)(PMIC_TOP1_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_g_smps_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_G_SMPS_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_G_SMPS_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_g_smps_test_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_G_SMPS_TEST_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_G_SMPS_TEST_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_intrp_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INTRP_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_INTRP_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_intrp_pre_oc_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INTRP_PRE_OC_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_INTRP_PRE_OC_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_efuse_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EFUSE_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_EFUSE_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_eint_32k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EINT_32K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_EINT_32K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu1m_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU1M_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_PMU1M_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spi_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CKPDN_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SPI_CK_PDN_MASK),
				    (unsigned int)(PMIC_RG_SPI_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_reg_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CKPDN_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_REG_CK_PDN_MASK),
				    (unsigned int)(PMIC_RG_REG_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu32k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU32K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_PMU32K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fqmtr_32k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FQMTR_32K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_FQMTR_32K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fqmtr_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FQMTR_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_FQMTR_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu26m_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU26M_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_PMU26M_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu128k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU128K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_PMU128K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc26m_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC26M_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC26M_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc32k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC32K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC32K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc32k_1v8_0_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_0_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_0_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc32k_1v8_1_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_1_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC32K_1V8_1_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_trim_128k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_TRIM_128K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_TRIM_128K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bgr_test_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BGR_TEST_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BGR_TEST_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_test_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKPDN_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_TEST_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_PCHR_TEST_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fqmtr_ck_cksel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FQMTR_CK_CKSEL_MASK),
	    (unsigned int)(PMIC_RG_FQMTR_CK_CKSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_32k1v8_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_32K1V8_SEL_MASK),
	    (unsigned int)(PMIC_RG_RTC_32K1V8_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bgr_test_ck_cksel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BGR_TEST_CK_CKSEL_MASK),
	    (unsigned int)(PMIC_RG_BGR_TEST_CK_CKSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_test_ck_cksel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_TEST_CK_CKSEL_MASK),
	    (unsigned int)(PMIC_RG_PCHR_TEST_CK_CKSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_26m_ck_sel_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_26M_CK_SEL_HWEN_MASK),
	    (unsigned int)(PMIC_RG_26M_CK_SEL_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_26m_ck_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CKSEL_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_26M_CK_SEL_MASK),
				    (unsigned int)(PMIC_RG_26M_CK_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu_1m_ck_sel_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU_1M_CK_SEL_HWEN_MASK),
	    (unsigned int)(PMIC_RG_PMU_1M_CK_SEL_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu_1m_ck_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU_1M_CK_SEL_MASK),
	    (unsigned int)(PMIC_RG_PMU_1M_CK_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu32k_ck_cksel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU32K_CK_CKSEL_MASK),
	    (unsigned int)(PMIC_RG_PMU32K_CK_CKSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_top_cksel_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_TOP_CKSEL_CON0_RSV_MASK),
	    (unsigned int)(PMIC_RG_TOP_CKSEL_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_srcvolten_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCVOLTEN_SW_MASK),
	    (unsigned int)(PMIC_RG_SRCVOLTEN_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_osc_sel_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_OSC_SEL_SW_MASK),
	    (unsigned int)(PMIC_RG_BUCK_OSC_SEL_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vowen_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CKSEL_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VOWEN_SW_MASK),
				    (unsigned int)(PMIC_RG_VOWEN_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_srcvolten_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCVOLTEN_MODE_MASK),
	    (unsigned int)(PMIC_RG_SRCVOLTEN_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_osc_sel_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_OSC_SEL_MODE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_OSC_SEL_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vowen_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CKSEL_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VOWEN_MODE_MASK),
				    (unsigned int)(PMIC_RG_VOWEN_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_top_cksel_con2_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKSEL_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_TOP_CKSEL_CON2_RSV_MASK),
	    (unsigned int)(PMIC_RG_TOP_CKSEL_CON2_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_reg_ck_divsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKDIVSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_REG_CK_DIVSEL_MASK),
	    (unsigned int)(PMIC_RG_REG_CK_DIVSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_top_ckdivsel_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKDIVSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_TOP_CKDIVSEL_CON0_RSV_MASK),
	    (unsigned int)(PMIC_TOP_CKDIVSEL_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_g_smps_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_G_SMPS_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_G_SMPS_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_reg_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_REG_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_REG_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_efuse_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EFUSE_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_EFUSE_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_eint_32k_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EINT_32K_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_EINT_32K_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc26m_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC26M_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_RTC26M_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu26m_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU26M_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_PMU26M_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_top_ckhwen_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_TOP_CKHWEN_CON0_RSV_MASK),
	    (unsigned int)(PMIC_TOP_CKHWEN_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu128k_ck_tst_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU128K_CK_TST_DIS_MASK),
	    (unsigned int)(PMIC_RG_PMU128K_CK_TST_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smps_ck_tst_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMPS_CK_TST_DIS_MASK),
	    (unsigned int)(PMIC_RG_SMPS_CK_TST_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_clk_26m_pmu_tst_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CLK_26M_PMU_TST_DIS_MASK),
	    (unsigned int)(PMIC_RG_XO_CLK_26M_PMU_TST_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_clk_26m_dig_tst_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CLK_26M_DIG_TST_DIS_MASK),
	    (unsigned int)(PMIC_RG_XO_CLK_26M_DIG_TST_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_26m_ck_tst_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_26M_CK_TST_DIS_MASK),
	    (unsigned int)(PMIC_RG_RTC_26M_CK_TST_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_32k_ck_tst_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_32K_CK_TST_DIS_MASK),
	    (unsigned int)(PMIC_RG_RTC_32K_CK_TST_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu_m_ck_tst_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU_M_CK_TST_DIS_MASK),
	    (unsigned int)(PMIC_RG_PMU_M_CK_TST_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_top_cktst_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_TOP_CKTST_CON0_RSV_MASK),
	    (unsigned int)(PMIC_TOP_CKTST_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu128k_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU128K_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_PMU128K_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smps_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMPS_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_SMPS_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_clk_26m_pmu_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CLK_26M_PMU_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_XO_CLK_26M_PMU_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_clk_26m_dig_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CLK_26M_DIG_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_XO_CLK_26M_DIG_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_26m_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_26M_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_RTC_26M_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_32k_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_32K_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_RTC_32K_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu_m_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU_M_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_PMU_M_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_efuse_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EFUSE_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_EFUSE_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bgr_test_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BGR_TEST_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_BGR_TEST_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_test_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_TEST_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_PCHR_TEST_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fqmtr_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CKTST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FQMTR_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_FQMTR_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_clksq_en_aud(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUD_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_en_aud(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLKSQ), (&val),
				  (unsigned int)(PMIC_RG_CLKSQ_EN_AUD_MASK),
				  (unsigned int)(PMIC_RG_CLKSQ_EN_AUD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_en_fqr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_FQR_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_FQR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_en_fqr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLKSQ), (&val),
				  (unsigned int)(PMIC_RG_CLKSQ_EN_FQR_MASK),
				  (unsigned int)(PMIC_RG_CLKSQ_EN_FQR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_en_aux_ap(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_AP_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_AP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_en_aux_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_CLKSQ), (&val),
				(unsigned int)(PMIC_RG_CLKSQ_EN_AUX_AP_MASK),
				(unsigned int)(PMIC_RG_CLKSQ_EN_AUX_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_en_aux_md(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_MD_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_MD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_en_aux_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_CLKSQ), (&val),
				(unsigned int)(PMIC_RG_CLKSQ_EN_AUX_MD_MASK),
				(unsigned int)(PMIC_RG_CLKSQ_EN_AUX_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_en_aux_gps(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_GPS_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_GPS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_en_aux_gps(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (&val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_GPS_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_GPS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_en_aux_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_RSV_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_en_aux_rsv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (&val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_RSV_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_RSV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_en_aux_ap_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_AP_MODE_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_AP_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_en_aux_ap_mode(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (&val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_AP_MODE_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_AP_MODE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_en_aux_md_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_MD_MODE_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_MD_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_en_aux_md_mode(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (&val),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_MD_MODE_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_EN_AUX_MD_MODE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_in_sel_va28(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_IN_SEL_VA28_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_IN_SEL_VA28_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_clksq_in_sel_va28_swctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_IN_SEL_VA28_SWCTRL_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_IN_SEL_VA28_SWCTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_top_clksq_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CLKSQ),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TOP_CLKSQ_RSV_MASK),
				    (unsigned int)(PMIC_TOP_CLKSQ_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_clksq_en_va28(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLKSQ), (&val),
				  (unsigned int)(PMIC_DA_CLKSQ_EN_VA28_MASK),
				  (unsigned int)(PMIC_DA_CLKSQ_EN_VA28_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_rtc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ_RTC), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_RTC_EN_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_RTC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_rtc_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLKSQ_RTC), (&val),
				  (unsigned int)(PMIC_RG_CLKSQ_RTC_EN_MASK),
				  (unsigned int)(PMIC_RG_CLKSQ_RTC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clksq_rtc_en_hw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ_RTC), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLKSQ_RTC_EN_HW_MODE_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_RTC_EN_HW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clksq_rtc_en_hw_mode(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ_RTC), (&val),
	    (unsigned int)(PMIC_RG_CLKSQ_RTC_EN_HW_MODE_MASK),
	    (unsigned int)(PMIC_RG_CLKSQ_RTC_EN_HW_MODE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_top_clksq_rtc_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ_RTC), (unsigned int)(val),
	    (unsigned int)(PMIC_TOP_CLKSQ_RTC_RSV0_MASK),
	    (unsigned int)(PMIC_TOP_CLKSQ_RTC_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_enbb_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CLKSQ_RTC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_ENBB_SEL_MASK),
				    (unsigned int)(PMIC_RG_ENBB_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xosc_en_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CLKSQ_RTC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_XOSC_EN_SEL_MASK),
				    (unsigned int)(PMIC_RG_XOSC_EN_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xosc_en_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLKSQ_RTC), (&val),
				  (unsigned int)(PMIC_RG_XOSC_EN_SEL_MASK),
				  (unsigned int)(PMIC_RG_XOSC_EN_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_top_clksq_rtc_rsv1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLKSQ_RTC), (unsigned int)(val),
	    (unsigned int)(PMIC_TOP_CLKSQ_RTC_RSV1_MASK),
	    (unsigned int)(PMIC_TOP_CLKSQ_RTC_RSV1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_clksq_en_vdig28(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_CLKSQ_RTC), (&val),
				(unsigned int)(PMIC_DA_CLKSQ_EN_VDIG28_MASK),
				(unsigned int)(PMIC_DA_CLKSQ_EN_VDIG28_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_osc_sel_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OSC_SEL_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_OSC_SEL_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_osc_sel_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLK_CON0), (&val),
				  (unsigned int)(PMIC_RG_OSC_SEL_SW_EN_MASK),
				  (unsigned int)(PMIC_RG_OSC_SEL_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_osc_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CLK_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OSC_SEL_MASK),
				    (unsigned int)(PMIC_RG_OSC_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_osc_en_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OSC_EN_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_OSC_EN_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_osc_en_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLK_CON0), (&val),
				  (unsigned int)(PMIC_RG_OSC_EN_SW_EN_MASK),
				  (unsigned int)(PMIC_RG_OSC_EN_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_osc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CLK_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OSC_EN_MASK),
				    (unsigned int)(PMIC_RG_OSC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_osc_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLK_CON0), (&val),
				  (unsigned int)(PMIC_RG_OSC_EN_MASK),
				  (unsigned int)(PMIC_RG_OSC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_g_smps_ck_pdn_vowen_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_G_SMPS_CK_PDN_VOWEN_EN_MASK),
	    (unsigned int)(PMIC_RG_G_SMPS_CK_PDN_VOWEN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_g_smps_ck_pdn_vowen_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (&val),
	    (unsigned int)(PMIC_RG_G_SMPS_CK_PDN_VOWEN_EN_MASK),
	    (unsigned int)(PMIC_RG_G_SMPS_CK_PDN_VOWEN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken0_lp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN0_LP_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN0_LP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken0_lp_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_CLK_CON0), (&val),
				(unsigned int)(PMIC_RG_SRCLKEN0_LP_EN_MASK),
				(unsigned int)(PMIC_RG_SRCLKEN0_LP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken1_lp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN1_LP_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN1_LP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken1_lp_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_CLK_CON0), (&val),
				(unsigned int)(PMIC_RG_SRCLKEN1_LP_EN_MASK),
				(unsigned int)(PMIC_RG_SRCLKEN1_LP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken2_lp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN2_LP_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN2_LP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken2_lp_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_CLK_CON0), (&val),
				(unsigned int)(PMIC_RG_SRCLKEN2_LP_EN_MASK),
				(unsigned int)(PMIC_RG_SRCLKEN2_LP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_lp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CLK_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BUCK_LP_EN_MASK),
				    (unsigned int)(PMIC_RG_BUCK_LP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_lp_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLK_CON0), (&val),
				  (unsigned int)(PMIC_RG_BUCK_LP_EN_MASK),
				  (unsigned int)(PMIC_RG_BUCK_LP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_ldo_lp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CLK_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_LDO_LP_EN_MASK),
				    (unsigned int)(PMIC_RG_LDO_LP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_ldo_lp_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLK_CON0), (&val),
				  (unsigned int)(PMIC_RG_LDO_LP_EN_MASK),
				  (unsigned int)(PMIC_RG_LDO_LP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_pfm_flag(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_PFM_FLAG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_PFM_FLAG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_pfm_flag_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_PFM_FLAG_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_PFM_FLAG_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_pfm_flag_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_PFM_FLAG_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_PFM_FLAG_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_dcxo26m_rdy(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CLK_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_DCXO26M_RDY_MASK),
				    (unsigned int)(PMIC_RG_DCXO26M_RDY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_dcxo26m_rdy_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_DCXO26M_RDY_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_DCXO26M_RDY_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_dcxo26m_rdy_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (&val),
	    (unsigned int)(PMIC_RG_DCXO26M_RDY_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_DCXO26M_RDY_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pmu_lp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_CLK_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PMU_LP_MASK),
				    (unsigned int)(PMIC_RG_PMU_LP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu_lp_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU_LP_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_PMU_LP_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_pmu_lp_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLK_CON0), (&val),
				  (unsigned int)(PMIC_RG_PMU_LP_SW_EN_MASK),
				  (unsigned int)(PMIC_RG_PMU_LP_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pmu_mdb_dcm_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_DCM_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU_MDB_DCM_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_PMU_MDB_DCM_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_pmu_mdb_dcm_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_DCM_CON0), (&val),
	    (unsigned int)(PMIC_RG_PMU_MDB_DCM_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_PMU_MDB_DCM_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pmu_mdb_dcm_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_DCM_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU_MDB_DCM_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_PMU_MDB_DCM_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_sec_mdb_dcm_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_DCM_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_SEC_MDB_DCM_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC_SEC_MDB_DCM_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_rtc_sec_mdb_dcm_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_DCM_CON0), (&val),
	    (unsigned int)(PMIC_RG_RTC_SEC_MDB_DCM_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC_SEC_MDB_DCM_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_rtc_sec_mdb_dcm_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_DCM_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_SEC_MDB_DCM_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_RTC_SEC_MDB_DCM_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_mdb_dcm_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_DCM_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_MDB_DCM_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC_MDB_DCM_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_rtc_mdb_dcm_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_DCM_CON0), (&val),
	    (unsigned int)(PMIC_RG_RTC_MDB_DCM_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC_MDB_DCM_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_rtc_mdb_dcm_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_DCM_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_MDB_DCM_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_RTC_MDB_DCM_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_ro_handover_debug(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_HANDOVER_DEBUG0), (&val),
	    (unsigned int)(PMIC_RO_HANDOVER_DEBUG_MASK),
	    (unsigned int)(PMIC_RO_HANDOVER_DEBUG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_efuse_man_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EFUSE_MAN_RST_MASK),
	    (unsigned int)(PMIC_RG_EFUSE_MAN_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_driver_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_DRIVER_RST_MASK),
				    (unsigned int)(PMIC_RG_DRIVER_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fqmtr_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_FQMTR_RST_MASK),
				    (unsigned int)(PMIC_RG_FQMTR_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_RTC_RST_MASK),
				    (unsigned int)(PMIC_RG_RTC_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_type_c_cc_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_TYPE_C_CC_RST_MASK),
	    (unsigned int)(PMIC_RG_TYPE_C_CC_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_clk_trim_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLK_TRIM_RST_MASK),
	    (unsigned int)(PMIC_RG_CLK_TRIM_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_srclken_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_SRCLKEN_RST_MASK),
	    (unsigned int)(PMIC_RG_BUCK_SRCLKEN_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_prot_pmpp_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_PROT_PMPP_RST_MASK),
	    (unsigned int)(PMIC_RG_BUCK_PROT_PMPP_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spk_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_RST_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SPK_RST_MASK),
				    (unsigned int)(PMIC_RG_SPK_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_ft_vr_sysrstb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FT_VR_SYSRSTB_MASK),
	    (unsigned int)(PMIC_RG_FT_VR_SYSRSTB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_ldo_cali_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_LDO_CALI_RST_MASK),
	    (unsigned int)(PMIC_RG_LDO_CALI_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_top_rst_con1_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_TOP_RST_CON1_RSV_MASK),
	    (unsigned int)(PMIC_TOP_RST_CON1_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_chr_ldo_det_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CHR_LDO_DET_MODE_MASK),
	    (unsigned int)(PMIC_RG_CHR_LDO_DET_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_chr_ldo_det_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CHR_LDO_DET_SW_MASK),
	    (unsigned int)(PMIC_RG_CHR_LDO_DET_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_chrwdt_flag_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CHRWDT_FLAG_MODE_MASK),
	    (unsigned int)(PMIC_RG_CHRWDT_FLAG_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_chrwdt_flag_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CHRWDT_FLAG_SW_MASK),
	    (unsigned int)(PMIC_RG_CHRWDT_FLAG_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_top_rst_con2_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_TOP_RST_CON2_RSV_MASK),
	    (unsigned int)(PMIC_TOP_RST_CON2_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_wdtrstb_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_RST_MISC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_WDTRSTB_EN_MASK),
				    (unsigned int)(PMIC_RG_WDTRSTB_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_wdtrstb_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_RST_MISC), (&val),
				  (unsigned int)(PMIC_RG_WDTRSTB_EN_MASK),
				  (unsigned int)(PMIC_RG_WDTRSTB_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_wdtrstb_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_MISC), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_WDTRSTB_MODE_MASK),
	    (unsigned int)(PMIC_RG_WDTRSTB_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_wdtrstb_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_RST_MISC), (&val),
				  (unsigned int)(PMIC_WDTRSTB_STATUS_MASK),
				  (unsigned int)(PMIC_WDTRSTB_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_wdtrstb_status_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_MISC), (unsigned int)(val),
	    (unsigned int)(PMIC_WDTRSTB_STATUS_CLR_MASK),
	    (unsigned int)(PMIC_WDTRSTB_STATUS_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_wdtrstb_fb_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_MISC), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_WDTRSTB_FB_EN_MASK),
	    (unsigned int)(PMIC_RG_WDTRSTB_FB_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_wdtrstb_fb_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_RST_MISC), (&val),
				  (unsigned int)(PMIC_RG_WDTRSTB_FB_EN_MASK),
				  (unsigned int)(PMIC_RG_WDTRSTB_FB_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_wdtrstb_deb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_RST_MISC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_WDTRSTB_DEB_MASK),
				    (unsigned int)(PMIC_RG_WDTRSTB_DEB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_homekey_rst_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_MISC), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_HOMEKEY_RST_EN_MASK),
	    (unsigned int)(PMIC_RG_HOMEKEY_RST_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_homekey_rst_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_RST_MISC), (&val),
				(unsigned int)(PMIC_RG_HOMEKEY_RST_EN_MASK),
				(unsigned int)(PMIC_RG_HOMEKEY_RST_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pwrkey_rst_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_MISC), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PWRKEY_RST_EN_MASK),
	    (unsigned int)(PMIC_RG_PWRKEY_RST_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_pwrkey_rst_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_RST_MISC), (&val),
				  (unsigned int)(PMIC_RG_PWRKEY_RST_EN_MASK),
				  (unsigned int)(PMIC_RG_PWRKEY_RST_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pwrrst_tmr_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_MISC), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PWRRST_TMR_DIS_MASK),
	    (unsigned int)(PMIC_RG_PWRRST_TMR_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pwrkey_rst_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_MISC), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PWRKEY_RST_TD_MASK),
	    (unsigned int)(PMIC_RG_PWRKEY_RST_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_top_rst_misc_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_MISC), (unsigned int)(val),
	    (unsigned int)(PMIC_TOP_RST_MISC_RSV_MASK),
	    (unsigned int)(PMIC_TOP_RST_MISC_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_vpwrin_rstb_status(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_STATUS), (unsigned int)(val),
	    (unsigned int)(PMIC_VPWRIN_RSTB_STATUS_MASK),
	    (unsigned int)(PMIC_VPWRIN_RSTB_STATUS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_ddlo_rstb_status(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_STATUS), (unsigned int)(val),
	    (unsigned int)(PMIC_DDLO_RSTB_STATUS_MASK),
	    (unsigned int)(PMIC_DDLO_RSTB_STATUS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_uvlo_rstb_status(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_STATUS), (unsigned int)(val),
	    (unsigned int)(PMIC_UVLO_RSTB_STATUS_MASK),
	    (unsigned int)(PMIC_UVLO_RSTB_STATUS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_ddlo_rstb_status(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_STATUS), (unsigned int)(val),
	    (unsigned int)(PMIC_RTC_DDLO_RSTB_STATUS_MASK),
	    (unsigned int)(PMIC_RTC_DDLO_RSTB_STATUS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_chrwdt_reg_rstb_status(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_STATUS), (unsigned int)(val),
	    (unsigned int)(PMIC_CHRWDT_REG_RSTB_STATUS_MASK),
	    (unsigned int)(PMIC_CHRWDT_REG_RSTB_STATUS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_chrdet_reg_rstb_status(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_STATUS), (unsigned int)(val),
	    (unsigned int)(PMIC_CHRDET_REG_RSTB_STATUS_MASK),
	    (unsigned int)(PMIC_CHRDET_REG_RSTB_STATUS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bwdt_ddlo_rstb_status(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_STATUS), (unsigned int)(val),
	    (unsigned int)(PMIC_BWDT_DDLO_RSTB_STATUS_MASK),
	    (unsigned int)(PMIC_BWDT_DDLO_RSTB_STATUS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_top_rst_status_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_RST_STATUS), (unsigned int)(val),
	    (unsigned int)(PMIC_TOP_RST_STATUS_RSV_MASK),
	    (unsigned int)(PMIC_TOP_RST_STATUS_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_en_eint_rtc32k_1v8_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_EINT_RTC32K_1V8_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_eint_rtc32k_1v8_1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_EINT_RTC32K_1V8_1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_spi_cmd_alert(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_SPI_CMD_ALERT_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_SPI_CMD_ALERT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_spi_cmd_alert(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_SPI_CMD_ALERT_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_SPI_CMD_ALERT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_mask_eint_rtc32k_1v8_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_EINT_RTC32K_1V8_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_spi_cmd_alert(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_SPI_CMD_ALERT_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_SPI_CMD_ALERT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_status_eint_rtc32k_1v8_1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_EINT_RTC32K_1V8_1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_spi_cmd_alert(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_SPI_CMD_ALERT_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_SPI_CMD_ALERT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_eint_rtc32k_1v8_1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_EINT_RTC32K_1V8_1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_spi_cmd_alert(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_MISC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_SPI_CMD_ALERT_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_SPI_CMD_ALERT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_sen_eint_rtc32k_1v8_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_INT_EINT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_SEN_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_INT_SEN_EINT_RTC32K_1V8_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_pol_eint_rtc32k_1v8_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_INT_EINT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_POL_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_INT_POL_EINT_RTC32K_1V8_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_sw_sel_eint_rtc32k_1v8_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_INT_EINT_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SW_SEL_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_SW_SEL_EINT_RTC32K_1V8_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_sw_eint_rtc32k_1v8_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_INT_EINT_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SW_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_SW_EINT_RTC32K_1V8_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_deb_eint_rtc32k_1v8_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_INT_EINT_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_DEB_EINT_RTC32K_1V8_1_MASK),
	    (unsigned int)(PMIC_RG_DEB_EINT_RTC32K_1V8_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_deb_eint_aud_clk_mosi(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_INT_EINT_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_DEB_EINT_AUD_CLK_MOSI_MASK),
	    (unsigned int)(PMIC_RG_DEB_EINT_AUD_CLK_MOSI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_buck_top(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BUCK_TOP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BUCK_TOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_ldo_top(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_LDO_TOP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_LDO_TOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_psc_top(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_PSC_TOP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_PSC_TOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_sck_top(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_SCK_TOP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_SCK_TOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_bm_top(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BM_TOP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BM_TOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_hk_top(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_HK_TOP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_HK_TOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_xpp_top(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_XPP_TOP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_XPP_TOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_aud_top(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_AUD_TOP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_AUD_TOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_misc_top(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_MISC_TOP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_MISC_TOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_top_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_TOP_CON0_RSV_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_TOP_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_int_status_buck_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_STATUS_BUCK_TOP_MASK),
	    (unsigned int)(PMIC_INT_STATUS_BUCK_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_status_ldo_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
				(unsigned int)(PMIC_INT_STATUS_LDO_TOP_MASK),
				(unsigned int)(PMIC_INT_STATUS_LDO_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_status_psc_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
				(unsigned int)(PMIC_INT_STATUS_PSC_TOP_MASK),
				(unsigned int)(PMIC_INT_STATUS_PSC_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_status_sck_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
				(unsigned int)(PMIC_INT_STATUS_SCK_TOP_MASK),
				(unsigned int)(PMIC_INT_STATUS_SCK_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_status_bm_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
				(unsigned int)(PMIC_INT_STATUS_BM_TOP_MASK),
				(unsigned int)(PMIC_INT_STATUS_BM_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_status_hk_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
				(unsigned int)(PMIC_INT_STATUS_HK_TOP_MASK),
				(unsigned int)(PMIC_INT_STATUS_HK_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_status_xpp_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
				(unsigned int)(PMIC_INT_STATUS_XPP_TOP_MASK),
				(unsigned int)(PMIC_INT_STATUS_XPP_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_status_aud_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
				(unsigned int)(PMIC_INT_STATUS_AUD_TOP_MASK),
				(unsigned int)(PMIC_INT_STATUS_AUD_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_status_misc_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_STATUS_MISC_TOP_MASK),
	    (unsigned int)(PMIC_INT_STATUS_MISC_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_status_top_rsv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_INT_STATUS0), (&val),
				(unsigned int)(PMIC_INT_STATUS_TOP_RSV_MASK),
				(unsigned int)(PMIC_INT_STATUS_TOP_RSV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_buck_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_BUCK_TOP_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_BUCK_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_ldo_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_LDO_TOP_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_LDO_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_psc_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_PSC_TOP_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_PSC_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_sck_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_SCK_TOP_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_SCK_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_bm_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_BM_TOP_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_BM_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_hk_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_HK_TOP_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_HK_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_xpp_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_XPP_TOP_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_XPP_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_aud_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_AUD_TOP_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_AUD_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_misc_top(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_MISC_TOP_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_MISC_TOP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_int_raw_status_top_rsv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_INT_RAW_STATUS_TOP_RSV_MASK),
	    (unsigned int)(PMIC_INT_RAW_STATUS_TOP_RSV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_polarity(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_POLARITY_MASK),
	    (unsigned int)(PMIC_RG_INT_POLARITY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_pa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_OTP_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OTP_PA_MASK),
				    (unsigned int)(PMIC_RG_OTP_PA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_pdin(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_OTP_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OTP_PDIN_MASK),
				    (unsigned int)(PMIC_RG_OTP_PDIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_ptm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_OTP_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OTP_PTM_MASK),
				    (unsigned int)(PMIC_RG_OTP_PTM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_pwe(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_OTP_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OTP_PWE_MASK),
				    (unsigned int)(PMIC_RG_OTP_PWE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_pprog(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_OTP_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OTP_PPROG_MASK),
				    (unsigned int)(PMIC_RG_OTP_PPROG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_pwe_src(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_OTP_CON5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OTP_PWE_SRC_MASK),
				    (unsigned int)(PMIC_RG_OTP_PWE_SRC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_prog_pkey(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_OTP_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OTP_PROG_PKEY_MASK),
	    (unsigned int)(PMIC_RG_OTP_PROG_PKEY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_rd_pkey(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_OTP_CON7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OTP_RD_PKEY_MASK),
				    (unsigned int)(PMIC_RG_OTP_RD_PKEY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_rd_trig(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_OTP_CON8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OTP_RD_TRIG_MASK),
				    (unsigned int)(PMIC_RG_OTP_RD_TRIG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rd_rdy_bypass(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_OTP_CON9), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RD_RDY_BYPASS_MASK),
	    (unsigned int)(PMIC_RG_RD_RDY_BYPASS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_skip_otp_out(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_OTP_CON10), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SKIP_OTP_OUT_MASK),
	    (unsigned int)(PMIC_RG_SKIP_OTP_OUT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otp_rd_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_OTP_CON11),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OTP_RD_SW_MASK),
				    (unsigned int)(PMIC_RG_OTP_RD_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_otp_dout_sw(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_OTP_CON12), (&val),
				  (unsigned int)(PMIC_RG_OTP_DOUT_SW_MASK),
				  (unsigned int)(PMIC_RG_OTP_DOUT_SW_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_otp_rd_busy(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_OTP_CON13), (&val),
				  (unsigned int)(PMIC_RG_OTP_RD_BUSY_MASK),
				  (unsigned int)(PMIC_RG_OTP_RD_BUSY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_otp_rd_ack(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_OTP_CON13), (&val),
				  (unsigned int)(PMIC_RG_OTP_RD_ACK_MASK),
				  (unsigned int)(PMIC_RG_OTP_RD_ACK_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_otp_pa_sw(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_OTP_CON14), (&val),
				  (unsigned int)(PMIC_RG_OTP_PA_SW_MASK),
				  (unsigned int)(PMIC_RG_OTP_PA_SW_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_top1_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP1_ELR0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_TOP1_RSV0_MASK),
				    (unsigned int)(PMIC_RG_TOP1_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_top1_rsv1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP1_ELR1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_TOP1_RSV1_MASK),
				    (unsigned int)(PMIC_RG_TOP1_RSV1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_efuse_osc_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP1_ELR2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_EFUSE_OSC_MODE_MASK),
				    (unsigned int)(PMIC_EFUSE_OSC_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_topa0_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOPA0_ID), (&val),
				  (unsigned int)(PMIC_TOPA0_ANA_ID_MASK),
				  (unsigned int)(PMIC_TOPA0_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_topa0_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOPA0_ID), (&val),
				  (unsigned int)(PMIC_TOPA0_DIG_ID_MASK),
				  (unsigned int)(PMIC_TOPA0_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_topa0_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOPA0_REV0), (&val),
	    (unsigned int)(PMIC_TOPA0_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_TOPA0_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_topa0_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOPA0_REV0), (&val),
	    (unsigned int)(PMIC_TOPA0_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_TOPA0_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_topa0_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOPA0_REV0), (&val),
	    (unsigned int)(PMIC_TOPA0_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_TOPA0_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_topa0_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOPA0_REV0), (&val),
	    (unsigned int)(PMIC_TOPA0_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_TOPA0_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_topa0_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOPA0_REV1), (&val),
				(unsigned int)(PMIC_TOPA0_SW_MINOR_REV_MASK),
				(unsigned int)(PMIC_TOPA0_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_topa0_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOPA0_REV1), (&val),
				(unsigned int)(PMIC_TOPA0_SW_MAJOR_REV_MASK),
				(unsigned int)(PMIC_TOPA0_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fqmtr_tcksel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FQMTR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FQMTR_TCKSEL_MASK),
				    (unsigned int)(PMIC_FQMTR_TCKSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fqmtr_busy(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FQMTR_CON0), (&val),
				  (unsigned int)(PMIC_FQMTR_BUSY_MASK),
				  (unsigned int)(PMIC_FQMTR_BUSY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fqmtr_dcxo26m_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FQMTR_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_FQMTR_DCXO26M_EN_MASK),
	    (unsigned int)(PMIC_FQMTR_DCXO26M_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fqmtr_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FQMTR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FQMTR_EN_MASK),
				    (unsigned int)(PMIC_FQMTR_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fqmtr_winset(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FQMTR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FQMTR_WINSET_MASK),
				    (unsigned int)(PMIC_FQMTR_WINSET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fqmtr_data(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FQMTR_CON2), (&val),
				  (unsigned int)(PMIC_FQMTR_DATA_MASK),
				  (unsigned int)(PMIC_FQMTR_DATA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_osc_128k_trim_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_TRIM), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OSC_128K_TRIM_EN_MASK),
	    (unsigned int)(PMIC_RG_OSC_128K_TRIM_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_osc_128k_trim_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_TOP_CLK_TRIM), (&val),
	    (unsigned int)(PMIC_RG_OSC_128K_TRIM_EN_MASK),
	    (unsigned int)(PMIC_RG_OSC_128K_TRIM_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_osc_128k_trim_rate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_CLK_TRIM), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OSC_128K_TRIM_RATE_MASK),
	    (unsigned int)(PMIC_RG_OSC_128K_TRIM_RATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_osc_128k_trim(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_CLK_TRIM), (&val),
				  (unsigned int)(PMIC_DA_OSC_128K_TRIM_MASK),
				  (unsigned int)(PMIC_DA_OSC_128K_TRIM_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_top_mdb_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_MDB_CONF0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TOP_MDB_RSV0_MASK),
				    (unsigned int)(PMIC_TOP_MDB_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_mdb_dm1_ds_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_MDB_CONF1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_MDB_DM1_DS_EN_MASK),
	    (unsigned int)(PMIC_RG_MDB_DM1_DS_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_mdb_dm1_ds_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_TOP_MDB_CONF1), (&val),
				  (unsigned int)(PMIC_RG_MDB_DM1_DS_EN_MASK),
				  (unsigned int)(PMIC_RG_MDB_DM1_DS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_top_mdb_rsv1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_TOP_MDB_CONF1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TOP_MDB_RSV1_MASK),
				    (unsigned int)(PMIC_TOP_MDB_RSV1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_osc_128k_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOPA0_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OSC_128K_TRIM_MASK),
	    (unsigned int)(PMIC_RG_OSC_128K_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_spislv_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_SPISLV_ID), (&val),
				  (unsigned int)(PMIC_SPISLV_ANA_ID_MASK),
				  (unsigned int)(PMIC_SPISLV_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_spislv_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_SPISLV_ID), (&val),
				  (unsigned int)(PMIC_SPISLV_DIG_ID_MASK),
				  (unsigned int)(PMIC_SPISLV_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_spislv_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SPISLV_REV0), (&val),
	    (unsigned int)(PMIC_SPISLV_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_SPISLV_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_spislv_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SPISLV_REV0), (&val),
	    (unsigned int)(PMIC_SPISLV_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_SPISLV_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_spislv_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SPISLV_REV0), (&val),
	    (unsigned int)(PMIC_SPISLV_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_SPISLV_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_spislv_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SPISLV_REV0), (&val),
	    (unsigned int)(PMIC_SPISLV_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_SPISLV_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_spislv_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SPISLV_REV1), (&val),
	    (unsigned int)(PMIC_SPISLV_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_SPISLV_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_spislv_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SPISLV_REV1), (&val),
	    (unsigned int)(PMIC_SPISLV_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_SPISLV_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_slp_rw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RG_SPI_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SLP_RW_EN_MASK),
				    (unsigned int)(PMIC_RG_SLP_RW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_slp_rw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RG_SPI_CON0), (&val),
				  (unsigned int)(PMIC_RG_SLP_RW_EN_MASK),
				  (unsigned int)(PMIC_RG_SLP_RW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_en_record(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RG_SPI_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_EN_RECORD_MASK),
				    (unsigned int)(PMIC_RG_EN_RECORD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_mdb_bridge_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RG_SPI_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_MDB_BRIDGE_SWRST_MASK),
	    (unsigned int)(PMIC_RG_MDB_BRIDGE_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_mdb_bridge_bypass_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RG_SPI_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_MDB_BRIDGE_BYPASS_MODE_MASK),
	    (unsigned int)(PMIC_RG_MDB_BRIDGE_BYPASS_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spi_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RG_SPI_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SPI_RSV_MASK),
				    (unsigned int)(PMIC_RG_SPI_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dew_dio_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DEW_DIO_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DEW_DIO_EN_MASK),
				    (unsigned int)(PMIC_DEW_DIO_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_dew_read_test(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_DEW_READ_TEST), (&val),
				  (unsigned int)(PMIC_DEW_READ_TEST_MASK),
				  (unsigned int)(PMIC_DEW_READ_TEST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_dew_write_test(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DEW_WRITE_TEST),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DEW_WRITE_TEST_MASK),
				    (unsigned int)(PMIC_DEW_WRITE_TEST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dew_crc_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DEW_CRC_SWRST),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DEW_CRC_SWRST_MASK),
				    (unsigned int)(PMIC_DEW_CRC_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dew_crc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DEW_CRC_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DEW_CRC_EN_MASK),
				    (unsigned int)(PMIC_DEW_CRC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_dew_crc_val(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_DEW_CRC_VAL), (&val),
				  (unsigned int)(PMIC_DEW_CRC_VAL_MASK),
				  (unsigned int)(PMIC_DEW_CRC_VAL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_dew_dbg_mon_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DEW_DBG_MON_SEL), (unsigned int)(val),
	    (unsigned int)(PMIC_DEW_DBG_MON_SEL_MASK),
	    (unsigned int)(PMIC_DEW_DBG_MON_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dew_cipher_key_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DEW_CIPHER_KEY_SEL), (unsigned int)(val),
	    (unsigned int)(PMIC_DEW_CIPHER_KEY_SEL_MASK),
	    (unsigned int)(PMIC_DEW_CIPHER_KEY_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dew_cipher_iv_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DEW_CIPHER_IV_SEL), (unsigned int)(val),
	    (unsigned int)(PMIC_DEW_CIPHER_IV_SEL_MASK),
	    (unsigned int)(PMIC_DEW_CIPHER_IV_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dew_cipher_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DEW_CIPHER_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DEW_CIPHER_EN_MASK),
				    (unsigned int)(PMIC_DEW_CIPHER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_dew_cipher_rdy(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_DEW_CIPHER_RDY), (&val),
				(unsigned int)(PMIC_DEW_CIPHER_RDY_MASK),
				(unsigned int)(PMIC_DEW_CIPHER_RDY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_dew_cipher_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DEW_CIPHER_MODE), (unsigned int)(val),
	    (unsigned int)(PMIC_DEW_CIPHER_MODE_MASK),
	    (unsigned int)(PMIC_DEW_CIPHER_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dew_cipher_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DEW_CIPHER_SWRST), (unsigned int)(val),
	    (unsigned int)(PMIC_DEW_CIPHER_SWRST_MASK),
	    (unsigned int)(PMIC_DEW_CIPHER_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dew_rddmy_no(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DEW_RDDMY_NO),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DEW_RDDMY_NO_MASK),
				    (unsigned int)(PMIC_DEW_RDDMY_NO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_int_type_con0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_INT_TYPE_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_INT_TYPE_CON0_MASK),
				    (unsigned int)(PMIC_INT_TYPE_CON0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_int_type_con1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_INT_TYPE_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_INT_TYPE_CON1_MASK),
				    (unsigned int)(PMIC_INT_TYPE_CON1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_int_type_con2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_INT_TYPE_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_INT_TYPE_CON2_MASK),
				    (unsigned int)(PMIC_INT_TYPE_CON2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_int_type_con3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_INT_TYPE_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_INT_TYPE_CON3_MASK),
				    (unsigned int)(PMIC_INT_TYPE_CON3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_int_type_con4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_INT_TYPE_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_INT_TYPE_CON4_MASK),
				    (unsigned int)(PMIC_INT_TYPE_CON4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_int_type_con5(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_INT_TYPE_CON5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_INT_TYPE_CON5_MASK),
				    (unsigned int)(PMIC_INT_TYPE_CON5_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_int_type_con6(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_INT_TYPE_CON6),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_INT_TYPE_CON6_MASK),
				    (unsigned int)(PMIC_INT_TYPE_CON6_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_cpu_int_sta(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_INT_STA), (&val),
				  (unsigned int)(PMIC_CPU_INT_STA_MASK),
				  (unsigned int)(PMIC_CPU_INT_STA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_md32_int_sta(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_INT_STA), (&val),
				  (unsigned int)(PMIC_MD32_INT_STA_MASK),
				  (unsigned int)(PMIC_MD32_INT_STA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken_in3_smps_clk_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RG_SPI_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN3_SMPS_CLK_MODE_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN3_SMPS_CLK_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_srclken_in3_en_smps_test(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RG_SPI_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken_in3_en_smps_test(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RG_SPI_CON1), (&val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken_in2_smps_clk_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RG_SPI_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN2_SMPS_CLK_MODE_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN2_SMPS_CLK_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_srclken_in2_en_smps_test(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RG_SPI_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken_in2_en_smps_test(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RG_SPI_CON1), (&val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_spi_dly_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RG_SPI_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SPI_DLY_SEL_MASK),
				    (unsigned int)(PMIC_RG_SPI_DLY_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_record_cmd0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RG_SPI_CON3), (&val),
				  (unsigned int)(PMIC_RECORD_CMD0_MASK),
				  (unsigned int)(PMIC_RECORD_CMD0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_record_cmd1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RG_SPI_CON4), (&val),
				  (unsigned int)(PMIC_RECORD_CMD1_MASK),
				  (unsigned int)(PMIC_RECORD_CMD1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_record_cmd2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RG_SPI_CON5), (&val),
				  (unsigned int)(PMIC_RECORD_CMD2_MASK),
				  (unsigned int)(PMIC_RECORD_CMD2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_record_wdata0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RG_SPI_CON6), (&val),
				  (unsigned int)(PMIC_RECORD_WDATA0_MASK),
				  (unsigned int)(PMIC_RECORD_WDATA0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_record_wdata1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RG_SPI_CON7), (&val),
				  (unsigned int)(PMIC_RECORD_WDATA1_MASK),
				  (unsigned int)(PMIC_RECORD_WDATA1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_record_wdata2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RG_SPI_CON8), (&val),
				  (unsigned int)(PMIC_RECORD_WDATA2_MASK),
				  (unsigned int)(PMIC_RECORD_WDATA2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_addr_target(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RG_SPI_CON9),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_ADDR_TARGET_MASK),
				    (unsigned int)(PMIC_RG_ADDR_TARGET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_addr_mask(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RG_SPI_CON10),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_ADDR_MASK_MASK),
				    (unsigned int)(PMIC_RG_ADDR_MASK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_wdata_target(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RG_SPI_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_WDATA_TARGET_MASK),
	    (unsigned int)(PMIC_RG_WDATA_TARGET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_wdata_mask(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RG_SPI_CON12),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_WDATA_MASK_MASK),
				    (unsigned int)(PMIC_RG_WDATA_MASK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spi_record_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RG_SPI_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SPI_RECORD_CLR_MASK),
	    (unsigned int)(PMIC_RG_SPI_RECORD_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cmd_alert_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RG_SPI_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CMD_ALERT_CLR_MASK),
	    (unsigned int)(PMIC_RG_CMD_ALERT_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_srclken_in2_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_SPI_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN2_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN2_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken_in2_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_SPI_CON0), (&val),
				(unsigned int)(PMIC_RG_SRCLKEN_IN2_EN_MASK),
				(unsigned int)(PMIC_RG_SRCLKEN_IN2_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_srclken_in3_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_TOP_SPI_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN3_EN_MASK),
	    (unsigned int)(PMIC_RG_SRCLKEN_IN3_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_srclken_in3_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_TOP_SPI_CON1), (&val),
				(unsigned int)(PMIC_RG_SRCLKEN_IN3_EN_MASK),
				(unsigned int)(PMIC_RG_SRCLKEN_IN3_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSC_TOP_ID), (&val),
				  (unsigned int)(PMIC_PSC_TOP_ANA_ID_MASK),
				  (unsigned int)(PMIC_PSC_TOP_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSC_TOP_ID), (&val),
				  (unsigned int)(PMIC_PSC_TOP_DIG_ID_MASK),
				  (unsigned int)(PMIC_PSC_TOP_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_REV0), (&val),
	    (unsigned int)(PMIC_PSC_TOP_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_PSC_TOP_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_REV0), (&val),
	    (unsigned int)(PMIC_PSC_TOP_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_PSC_TOP_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_REV0), (&val),
	    (unsigned int)(PMIC_PSC_TOP_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_PSC_TOP_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_REV1), (&val),
	    (unsigned int)(PMIC_PSC_TOP_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_PSC_TOP_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_REV1), (&val),
	    (unsigned int)(PMIC_PSC_TOP_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_PSC_TOP_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_esp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSC_TOP_REV1), (&val),
				  (unsigned int)(PMIC_PSC_TOP_ESP_MASK),
				  (unsigned int)(PMIC_PSC_TOP_ESP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_clk_offset(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PSC_TOP_PAM0), (&val),
				(unsigned int)(PMIC_PSC_TOP_CLK_OFFSET_MASK),
				(unsigned int)(PMIC_PSC_TOP_CLK_OFFSET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_rst_offset(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PSC_TOP_PAM0), (&val),
				(unsigned int)(PMIC_PSC_TOP_RST_OFFSET_MASK),
				(unsigned int)(PMIC_PSC_TOP_RST_OFFSET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_int_offset(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PSC_TOP_PAM1), (&val),
				(unsigned int)(PMIC_PSC_TOP_INT_OFFSET_MASK),
				(unsigned int)(PMIC_PSC_TOP_INT_OFFSET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_psc_top_int_len(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSC_TOP_PAM1), (&val),
				  (unsigned int)(PMIC_PSC_TOP_INT_LEN_MASK),
				  (unsigned int)(PMIC_PSC_TOP_INT_LEN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_long_press_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_RSTCTL_0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_RST_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_pwrmsk_rst_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_RSTCTL_0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_PWRMSK_RST_SEL_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_PWRMSK_RST_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bank_strup_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_RSTCTL_0), (unsigned int)(val),
	    (unsigned int)(PMIC_BANK_STRUP_SWRST_MASK),
	    (unsigned int)(PMIC_BANK_STRUP_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bank_pseq_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_RSTCTL_0), (unsigned int)(val),
	    (unsigned int)(PMIC_BANK_PSEQ_SWRST_MASK),
	    (unsigned int)(PMIC_BANK_PSEQ_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bank_pchr_dig_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_RSTCTL_0), (unsigned int)(val),
	    (unsigned int)(PMIC_BANK_PCHR_DIG_SWRST_MASK),
	    (unsigned int)(PMIC_BANK_PCHR_DIG_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bank_pchr_macro_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_RSTCTL_0), (unsigned int)(val),
	    (unsigned int)(PMIC_BANK_PCHR_MACRO_SWRST_MASK),
	    (unsigned int)(PMIC_BANK_PCHR_MACRO_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_en_pwrkey(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_PWRKEY_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_PWRKEY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_pwrkey(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSC_TOP_INT_CON0),
				  (&val),
				  (unsigned int)(PMIC_RG_INT_EN_PWRKEY_MASK),
				  (unsigned int)(PMIC_RG_INT_EN_PWRKEY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_homekey(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_HOMEKEY_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_HOMEKEY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_homekey(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_HOMEKEY_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_HOMEKEY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_pwrkey_r(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_PWRKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_PWRKEY_R_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_pwrkey_r(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_PWRKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_PWRKEY_R_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_homekey_r(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_HOMEKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_HOMEKEY_R_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_homekey_r(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_HOMEKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_HOMEKEY_R_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_ni_lbat_int(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_NI_LBAT_INT_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_NI_LBAT_INT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_ni_lbat_int(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_NI_LBAT_INT_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_NI_LBAT_INT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_chrdet(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_CHRDET_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_CHRDET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_chrdet(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSC_TOP_INT_CON0),
				  (&val),
				  (unsigned int)(PMIC_RG_INT_EN_CHRDET_MASK),
				  (unsigned int)(PMIC_RG_INT_EN_CHRDET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_chrdet_edge(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_CHRDET_EDGE_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_CHRDET_EDGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_chrdet_edge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_CHRDET_EDGE_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_CHRDET_EDGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_vcdt_hv_det(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_VCDT_HV_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VCDT_HV_DET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_vcdt_hv_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_VCDT_HV_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VCDT_HV_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_pchr_cm_vinc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_PCHR_CM_VINC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_PCHR_CM_VINC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_pchr_cm_vinc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_PCHR_CM_VINC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_PCHR_CM_VINC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_pchr_cm_vdec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_PCHR_CM_VDEC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_PCHR_CM_VDEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_pchr_cm_vdec(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_PCHR_CM_VDEC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_PCHR_CM_VDEC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_watchdog(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_WATCHDOG_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_WATCHDOG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_watchdog(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_WATCHDOG_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_WATCHDOG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_vbaton_undet(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_VBATON_UNDET_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VBATON_UNDET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_vbaton_undet(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_VBATON_UNDET_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VBATON_UNDET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_bvalid_det(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BVALID_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BVALID_DET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_bvalid_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_BVALID_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BVALID_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_ov(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSC_TOP_INT_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_INT_EN_OV_MASK),
				    (unsigned int)(PMIC_RG_INT_EN_OV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_ov(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PSC_TOP_INT_CON0),
				(&val), (unsigned int)(PMIC_RG_INT_EN_OV_MASK),
				(unsigned int)(PMIC_RG_INT_EN_OV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_mask_pwrkey(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_PWRKEY_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_PWRKEY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_homekey(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_HOMEKEY_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_HOMEKEY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_pwrkey_r(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_PWRKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_PWRKEY_R_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_homekey_r(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_HOMEKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_HOMEKEY_R_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_ni_lbat_int(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_NI_LBAT_INT_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_NI_LBAT_INT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_chrdet(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_CHRDET_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_CHRDET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_chrdet_edge(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_CHRDET_EDGE_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_CHRDET_EDGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_vcdt_hv_det(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_VCDT_HV_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_VCDT_HV_DET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_pchr_cm_vinc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_PCHR_CM_VINC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_PCHR_CM_VINC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_pchr_cm_vdec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_PCHR_CM_VDEC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_PCHR_CM_VDEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_watchdog(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_WATCHDOG_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_WATCHDOG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_vbaton_undet(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_VBATON_UNDET_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_VBATON_UNDET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_bvalid_det(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BVALID_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BVALID_DET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_ov(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_OV_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_OV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_status_pwrkey(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_PWRKEY_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_PWRKEY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_homekey(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_HOMEKEY_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_HOMEKEY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_pwrkey_r(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_PWRKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_PWRKEY_R_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_homekey_r(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_HOMEKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_HOMEKEY_R_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_ni_lbat_int(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_NI_LBAT_INT_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_NI_LBAT_INT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_chrdet(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_CHRDET_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_CHRDET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_chrdet_edge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_CHRDET_EDGE_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_CHRDET_EDGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_vcdt_hv_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_VCDT_HV_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_VCDT_HV_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_pchr_cm_vinc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_PCHR_CM_VINC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_PCHR_CM_VINC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_pchr_cm_vdec(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_PCHR_CM_VDEC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_PCHR_CM_VDEC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_watchdog(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_WATCHDOG_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_WATCHDOG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_vbaton_undet(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_VBATON_UNDET_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_VBATON_UNDET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_bvalid_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BVALID_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BVALID_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_ov(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSC_TOP_INT_STATUS0),
				  (&val),
				  (unsigned int)(PMIC_RG_INT_STATUS_OV_MASK),
				  (unsigned int)(PMIC_RG_INT_STATUS_OV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_pwrkey(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_PWRKEY_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_PWRKEY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_homekey(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_HOMEKEY_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_HOMEKEY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_pwrkey_r(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_PWRKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_PWRKEY_R_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_homekey_r(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_HOMEKEY_R_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_HOMEKEY_R_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_ni_lbat_int(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_NI_LBAT_INT_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_NI_LBAT_INT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_chrdet(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_CHRDET_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_CHRDET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_chrdet_edge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_CHRDET_EDGE_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_CHRDET_EDGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_vcdt_hv_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VCDT_HV_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VCDT_HV_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_pchr_cm_vinc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_PCHR_CM_VINC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_PCHR_CM_VINC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_pchr_cm_vdec(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_PCHR_CM_VDEC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_PCHR_CM_VDEC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_watchdog(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_WATCHDOG_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_WATCHDOG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_vbaton_undet(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VBATON_UNDET_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VBATON_UNDET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_bvalid_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BVALID_DET_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BVALID_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_ov(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_OV_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_OV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_psc_int_polarity(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MISC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSC_INT_POLARITY_MASK),
	    (unsigned int)(PMIC_RG_PSC_INT_POLARITY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_homekey_int_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MISC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_HOMEKEY_INT_SEL_MASK),
	    (unsigned int)(PMIC_RG_HOMEKEY_INT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pwrkey_int_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MISC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PWRKEY_INT_SEL_MASK),
	    (unsigned int)(PMIC_RG_PWRKEY_INT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_chrdet_int_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MISC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CHRDET_INT_SEL_MASK),
	    (unsigned int)(PMIC_RG_CHRDET_INT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_cm_vinc_polarity_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MISC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_MASK),
	    (unsigned int)(PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_cm_vdec_polarity_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_INT_MISC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_MASK),
	    (unsigned int)(PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_psc_mon_grp_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSC_TOP_MON_CTL), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSC_MON_GRP_SEL_MASK),
	    (unsigned int)(PMIC_RG_PSC_MON_GRP_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_strup_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_ID), (&val),
				  (unsigned int)(PMIC_STRUP_ANA_ID_MASK),
				  (unsigned int)(PMIC_STRUP_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_ID), (&val),
				  (unsigned int)(PMIC_STRUP_DIG_ID_MASK),
				  (unsigned int)(PMIC_STRUP_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_REV0), (&val),
	    (unsigned int)(PMIC_STRUP_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_STRUP_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_REV0), (&val),
	    (unsigned int)(PMIC_STRUP_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_STRUP_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_REV0), (&val),
	    (unsigned int)(PMIC_STRUP_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_STRUP_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_STRUP_REV1), (&val),
				(unsigned int)(PMIC_STRUP_SW_MINOR_REV_MASK),
				(unsigned int)(PMIC_STRUP_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_STRUP_REV1), (&val),
				(unsigned int)(PMIC_STRUP_SW_MAJOR_REV_MASK),
				(unsigned int)(PMIC_STRUP_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_esp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_REV1), (&val),
				  (unsigned int)(PMIC_STRUP_ESP_MASK),
				  (unsigned int)(PMIC_STRUP_ESP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_tm_out(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_TM_OUT_MASK),
				    (unsigned int)(PMIC_RG_TM_OUT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_thrdet_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_THRDET_SEL_MASK),
				    (unsigned int)(PMIC_RG_THRDET_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_thr_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_THR_SEL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_THR_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_thr_tmode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_THR_TMODE_MASK),
				    (unsigned int)(PMIC_RG_THR_TMODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vref_bg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VREF_BG_MASK),
				    (unsigned int)(PMIC_RG_VREF_BG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rst_drvsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_RST_DRVSEL_MASK),
				    (unsigned int)(PMIC_RG_RST_DRVSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_en1_drvsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_EN1_DRVSEL_MASK),
				    (unsigned int)(PMIC_RG_EN1_DRVSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_en2_drvsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_EN2_DRVSEL_MASK),
				    (unsigned int)(PMIC_RG_EN2_DRVSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PMU_RSV_MASK),
				    (unsigned int)(PMIC_RG_PMU_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rgs_ana_chip_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_STRUP_ANA_CON1), (&val),
				(unsigned int)(PMIC_RGS_ANA_CHIP_ID_MASK),
				(unsigned int)(PMIC_RGS_ANA_CHIP_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_fchr_pu_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ANA_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_FCHR_PU_EN_MASK),
				    (unsigned int)(PMIC_RG_FCHR_PU_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_fchr_pu_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_STRUP_ANA_CON2), (&val),
				(unsigned int)(PMIC_RG_FCHR_PU_EN_MASK),
				(unsigned int)(PMIC_RG_FCHR_PU_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_fchr_keydet_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FCHR_KEYDET_EN_MASK),
	    (unsigned int)(PMIC_RG_FCHR_KEYDET_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_fchr_keydet_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_STRUP_ANA_CON2), (&val),
				(unsigned int)(PMIC_RG_FCHR_KEYDET_EN_MASK),
				(unsigned int)(PMIC_RG_FCHR_KEYDET_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_strup_elr_len(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_ELR_NUM), (&val),
				  (unsigned int)(PMIC_STRUP_ELR_LEN_MASK),
				  (unsigned int)(PMIC_STRUP_ELR_LEN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_iref_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_ELR_0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_IREF_TRIM_MASK),
	    (unsigned int)(PMIC_RG_STRUP_IREF_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_thr_loc_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_ELR_0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_THR_LOC_SEL_MASK),
				    (unsigned int)(PMIC_RG_THR_LOC_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_pseq_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSEQ_ID), (&val),
				  (unsigned int)(PMIC_PSEQ_ANA_ID_MASK),
				  (unsigned int)(PMIC_PSEQ_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pseq_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSEQ_ID), (&val),
				  (unsigned int)(PMIC_PSEQ_DIG_ID_MASK),
				  (unsigned int)(PMIC_PSEQ_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pseq_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PSEQ_REV0), (&val),
				(unsigned int)(PMIC_PSEQ_ANA_MINOR_REV_MASK),
				(unsigned int)(PMIC_PSEQ_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pseq_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PSEQ_REV0), (&val),
				(unsigned int)(PMIC_PSEQ_ANA_MAJOR_REV_MASK),
				(unsigned int)(PMIC_PSEQ_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pseq_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PSEQ_REV0), (&val),
				(unsigned int)(PMIC_PSEQ_DIG_MAJOR_REV_MASK),
				(unsigned int)(PMIC_PSEQ_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pseq_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PSEQ_REV1), (&val),
				(unsigned int)(PMIC_PSEQ_SW_MINOR_REV_MASK),
				(unsigned int)(PMIC_PSEQ_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pseq_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_PSEQ_REV1), (&val),
				(unsigned int)(PMIC_PSEQ_SW_MAJOR_REV_MASK),
				(unsigned int)(PMIC_PSEQ_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pseq_esp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSEQ_REV1), (&val),
				  (unsigned int)(PMIC_PSEQ_ESP_MASK),
				  (unsigned int)(PMIC_PSEQ_ESP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pwrhold(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCTL0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PWRHOLD_MASK),
				    (unsigned int)(PMIC_RG_PWRHOLD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_usbdl_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCTL0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_USBDL_MODE_MASK),
				    (unsigned int)(PMIC_RG_USBDL_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_crst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCTL0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CRST_MASK),
				    (unsigned int)(PMIC_RG_CRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_wrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCTL0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_WRST_MASK),
				    (unsigned int)(PMIC_RG_WRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rstb_onintv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCTL1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_RSTB_ONINTV_MASK),
				    (unsigned int)(PMIC_RG_RSTB_ONINTV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_crst_intv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCTL1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CRST_INTV_MASK),
				    (unsigned int)(PMIC_RG_CRST_INTV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_wrst_intv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCTL1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_WRST_INTV_MASK),
				    (unsigned int)(PMIC_RG_WRST_INTV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_pg_ck_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PPCCTL2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_PG_CK_SEL_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_PG_CK_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_spar_xcpt_mask(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PPCCTL2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_SPAR_XCPT_MASK_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_SPAR_XCPT_MASK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_rtca_xcpt_mask(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PPCCTL2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_RTCA_XCPT_MASK_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_RTCA_XCPT_MASK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_thm_shdn_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCTL2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_THM_SHDN_EN_MASK),
				    (unsigned int)(PMIC_RG_THM_SHDN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_thm_shdn_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PPCCTL2), (&val),
				  (unsigned int)(PMIC_RG_THM_SHDN_EN_MASK),
				  (unsigned int)(PMIC_RG_THM_SHDN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_wdtrst_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCFG0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_WDTRST_EN_MASK),
				    (unsigned int)(PMIC_RG_WDTRST_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_wdtrst_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PPCCFG0), (&val),
				  (unsigned int)(PMIC_RG_WDTRST_EN_MASK),
				  (unsigned int)(PMIC_RG_WDTRST_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_wdtrst_act(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCCFG0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_WDTRST_ACT_MASK),
				    (unsigned int)(PMIC_RG_WDTRST_ACT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_keypwr_vcore_opt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PPCCFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_KEYPWR_VCORE_OPT_MASK),
	    (unsigned int)(PMIC_RG_KEYPWR_VCORE_OPT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_force_on(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PPCTST0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_FORCE_ON_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_FORCE_ON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_force_all_doff(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PPCTST0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_FORCE_ALL_DOFF_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_FORCE_ALL_DOFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCRSV0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PSEQ_RSV0_MASK),
				    (unsigned int)(PMIC_RG_PSEQ_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_rsv1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCRSV0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PSEQ_RSV1_MASK),
				    (unsigned int)(PMIC_RG_PSEQ_RSV1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_rsv2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PPCRSV0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PSEQ_RSV2_MASK),
				    (unsigned int)(PMIC_RG_PSEQ_RSV2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cps_w_key(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSWKEY),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CPS_W_KEY_MASK),
				    (unsigned int)(PMIC_RG_CPS_W_KEY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_slot_intv_down(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CPSCFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SLOT_INTV_DOWN_MASK),
	    (unsigned int)(PMIC_RG_SLOT_INTV_DOWN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_dseq_len(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSCFG0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_DSEQ_LEN_MASK),
				    (unsigned int)(PMIC_RG_DSEQ_LEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vaux18_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VAUX18_DSA_MASK),
				    (unsigned int)(PMIC_RG_VAUX18_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs2_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS2_DSA_MASK),
				    (unsigned int)(PMIC_RG_VS2_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vsram_others_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CPSDSA1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VSRAM_OTHERS_DSA_MASK),
	    (unsigned int)(PMIC_RG_VSRAM_OTHERS_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vsram_gpu_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CPSDSA1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VSRAM_GPU_DSA_MASK),
	    (unsigned int)(PMIC_RG_VSRAM_GPU_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VCORE_DSA_MASK),
				    (unsigned int)(PMIC_RG_VCORE_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VMODEM_DSA_MASK),
				    (unsigned int)(PMIC_RG_VMODEM_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_DSA_MASK),
				    (unsigned int)(PMIC_RG_VS1_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_va12_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VA12_DSA_MASK),
				    (unsigned int)(PMIC_RG_VA12_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vsram_proc_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CPSDSA4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VSRAM_PROC_DSA_MASK),
	    (unsigned int)(PMIC_RG_VSRAM_PROC_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VPROC_DSA_MASK),
				    (unsigned int)(PMIC_RG_VPROC_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vio18_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VIO18_DSA_MASK),
				    (unsigned int)(PMIC_RG_VIO18_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vemc_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VEMC_DSA_MASK),
				    (unsigned int)(PMIC_RG_VEMC_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_ext_pmic_1_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CPSDSA6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EXT_PMIC_1_DSA_MASK),
	    (unsigned int)(PMIC_RG_EXT_PMIC_1_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vio28_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA6),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VIO28_DSA_MASK),
				    (unsigned int)(PMIC_RG_VIO28_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vdram_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VDRAM_DSA_MASK),
				    (unsigned int)(PMIC_RG_VDRAM_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_ext_pmic_2_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CPSDSA7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EXT_PMIC_2_DSA_MASK),
	    (unsigned int)(PMIC_RG_EXT_PMIC_2_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vusb_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VUSB_DSA_MASK),
				    (unsigned int)(PMIC_RG_VUSB_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vaud28_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VAUD28_DSA_MASK),
				    (unsigned int)(PMIC_RG_VAUD28_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vxo22_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CPSDSA9),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VXO22_DSA_MASK),
				    (unsigned int)(PMIC_RG_VXO22_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_rsv_dsa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CPSDSA9), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_RSV_DSA_MASK),
	    (unsigned int)(PMIC_RG_BUCK_RSV_DSA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_por_flag(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PORFLAG),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_POR_FLAG_MASK),
				    (unsigned int)(PMIC_RG_POR_FLAG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_usbdl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_CON0), (&val),
				  (unsigned int)(PMIC_USBDL_MASK),
				  (unsigned int)(PMIC_USBDL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_thr_det_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_THR_DET_DIS_MASK),
				    (unsigned int)(PMIC_RG_THR_DET_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_thr_test(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_THR_TEST_MASK),
				    (unsigned int)(PMIC_RG_THR_TEST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_ther_deb_rmax(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_THER_DEB_RMAX_MASK),
	    (unsigned int)(PMIC_RG_STRUP_THER_DEB_RMAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_ther_deb_fmax(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_THER_DEB_FMAX_MASK),
	    (unsigned int)(PMIC_RG_STRUP_THER_DEB_FMAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dduvlo_deb_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DDUVLO_DEB_EN_MASK),
				    (unsigned int)(PMIC_DDUVLO_DEB_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_osc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_OSC_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_OSC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_osc_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_CON3), (&val),
				  (unsigned int)(PMIC_RG_STRUP_OSC_EN_MASK),
				  (unsigned int)(PMIC_RG_STRUP_OSC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_osc_en_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_OSC_EN_SEL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_OSC_EN_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_osc_en_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (&val),
	    (unsigned int)(PMIC_RG_STRUP_OSC_EN_SEL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_OSC_EN_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_ft_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_FT_CTRL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_FT_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_pwron_force(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_PWRON_FORCE_MASK),
	    (unsigned int)(PMIC_RG_STRUP_PWRON_FORCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_biasgen_force(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BIASGEN_FORCE_MASK),
	    (unsigned int)(PMIC_RG_BIASGEN_FORCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_pwron(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_STRUP_PWRON_MASK),
				    (unsigned int)(PMIC_RG_STRUP_PWRON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_pwron_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_PWRON_SEL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_PWRON_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_biasgen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BIASGEN_MASK),
				    (unsigned int)(PMIC_RG_BIASGEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_biasgen_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BIASGEN_SEL_MASK),
				    (unsigned int)(PMIC_RG_BIASGEN_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_xosc32_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_XOSC32_ENB_MASK),
	    (unsigned int)(PMIC_RG_RTC_XOSC32_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_rtc_xosc32_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_STRUP_CON3), (&val),
				(unsigned int)(PMIC_RG_RTC_XOSC32_ENB_MASK),
				(unsigned int)(PMIC_RG_RTC_XOSC32_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_rtc_xosc32_enb_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_XOSC32_ENB_SEL_MASK),
	    (unsigned int)(PMIC_RG_RTC_XOSC32_ENB_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_rtc_xosc32_enb_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (&val),
	    (unsigned int)(PMIC_RG_RTC_XOSC32_ENB_SEL_MASK),
	    (unsigned int)(PMIC_RG_RTC_XOSC32_ENB_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_strup_dig_io_pg_force(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_STRUP_DIG_IO_PG_FORCE_MASK),
	    (unsigned int)(PMIC_STRUP_DIG_IO_PG_FORCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_clr_just_smart_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLR_JUST_SMART_RST_MASK),
	    (unsigned int)(PMIC_RG_CLR_JUST_SMART_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_clr_just_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_CLR_JUST_RST_MASK),
				    (unsigned int)(PMIC_CLR_JUST_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_just_smart_rst(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_CON4), (&val),
				  (unsigned int)(PMIC_JUST_SMART_RST_MASK),
				  (unsigned int)(PMIC_JUST_SMART_RST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_just_pwrkey_rst(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_CON4), (&val),
				  (unsigned int)(PMIC_JUST_PWRKEY_RST_MASK),
				  (unsigned int)(PMIC_JUST_PWRKEY_RST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_qi_osc_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_CON4), (&val),
				  (unsigned int)(PMIC_DA_QI_OSC_EN_MASK),
				  (unsigned int)(PMIC_DA_QI_OSC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_ext_pmic_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_ext_pmic_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON5), (&val),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_ext_pmic_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_SEL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_ext_pmic_en1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_CON5), (&val),
				  (unsigned int)(PMIC_DA_EXT_PMIC_EN1_MASK),
				  (unsigned int)(PMIC_DA_EXT_PMIC_EN1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_ext_pmic_en2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_CON5), (&val),
				  (unsigned int)(PMIC_DA_EXT_PMIC_EN2_MASK),
				  (unsigned int)(PMIC_DA_EXT_PMIC_EN2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_strup_con5_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_STRUP_CON5_RSV0_MASK),
	    (unsigned int)(PMIC_STRUP_CON5_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_auxadc_start_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_START_SW_MASK),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_START_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_auxadc_rstb_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_RSTB_SW_MASK),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_RSTB_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_auxadc_start_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_START_SEL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_START_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_auxadc_rstb_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_RSTB_SEL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_RSTB_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_auxadc_rpcnt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_RPCNT_MAX_MASK),
	    (unsigned int)(PMIC_RG_STRUP_AUXADC_RPCNT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_strup_pwroff_seq_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_STRUP_PWROFF_SEQ_EN_MASK),
	    (unsigned int)(PMIC_STRUP_PWROFF_SEQ_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_strup_pwroff_preoff_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_STRUP_PWROFF_PREOFF_EN_MASK),
	    (unsigned int)(PMIC_STRUP_PWROFF_PREOFF_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_strup_dig0_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_STRUP_DIG0_RSV0_MASK),
	    (unsigned int)(PMIC_STRUP_DIG0_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_strup_dig1_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_STRUP_DIG1_RSV0_MASK),
	    (unsigned int)(PMIC_STRUP_DIG1_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rsv_swreg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_STRUP_CON9),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_RSV_SWREG_MASK),
				    (unsigned int)(PMIC_RG_RSV_SWREG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_uvlo_u1u2_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON10), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_UVLO_U1U2_SEL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_UVLO_U1U2_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_uvlo_u1u2_sel_swctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON10), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_UVLO_U1U2_SEL_SWCTRL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_UVLO_U1U2_SEL_SWCTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_thr_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_THR_CLR_MASK),
	    (unsigned int)(PMIC_RG_STRUP_THR_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_long_press_ext_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_SEL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_long_press_ext_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_TD_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_long_press_ext_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_long_press_ext_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (&val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_long_press_ext_chr_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL_SHIFT));

	return ret;
}

unsigned int
mt6356_upmu_set_rg_strup_long_press_ext_pwrkey_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKEY_CTRL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKEY_CTRL_SHIFT));

	return ret;
}

unsigned int
mt6356_upmu_set_rg_strup_long_press_ext_spar_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_SPAR_CTRL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_SPAR_CTRL_SHIFT));

	return ret;
}

unsigned int
mt6356_upmu_set_rg_strup_long_press_ext_rtca_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_RTCA_CTRL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_EXT_RTCA_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smart_rst_sdn_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMART_RST_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_SMART_RST_SDN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_smart_rst_sdn_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (&val),
	    (unsigned int)(PMIC_RG_SMART_RST_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_SMART_RST_SDN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_smart_rst_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMART_RST_MODE_MASK),
	    (unsigned int)(PMIC_RG_SMART_RST_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_envtem(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_ENVTEM_MASK),
	    (unsigned int)(PMIC_RG_STRUP_ENVTEM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_envtem(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_STRUP_CON12), (&val),
				  (unsigned int)(PMIC_RG_STRUP_ENVTEM_MASK),
				  (unsigned int)(PMIC_RG_STRUP_ENVTEM_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_envtem_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_ENVTEM_CTRL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_ENVTEM_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_envtem_ctrl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON12), (&val),
	    (unsigned int)(PMIC_RG_STRUP_ENVTEM_CTRL_MASK),
	    (unsigned int)(PMIC_RG_STRUP_ENVTEM_CTRL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_pwrkey_count_reset(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_PWRKEY_COUNT_RESET_MASK),
	    (unsigned int)(PMIC_RG_STRUP_PWRKEY_COUNT_RESET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_ext_pmic_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_ext_pmic_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vaud28_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VAUD28_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VAUD28_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vaud28_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VAUD28_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VAUD28_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vusb_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VUSB_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VUSB_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vusb_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VUSB_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VUSB_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vdram_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VDRAM_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VDRAM_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vdram_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VDRAM_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VDRAM_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vemc_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VEMC_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VEMC_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vemc_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VEMC_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VEMC_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vsram_proc_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vsram_proc_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_va12_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VA12_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VA12_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_va12_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VA12_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VA12_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vsram_gpu_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_GPU_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_GPU_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vsram_gpu_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_GPU_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_GPU_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vsram_others_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_OTHERS_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_OTHERS_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vsram_others_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_OTHERS_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_OTHERS_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vaux18_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VAUX18_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VAUX18_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vaux18_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VAUX18_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VAUX18_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_buck_rsv_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_buck_rsv_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vproc_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vproc_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vs1_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VS1_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS1_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vs1_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VS1_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS1_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vmodem_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vmodem_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vcore_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vcore_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vs2_pg_h2l_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VS2_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS2_PG_H2L_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vs2_pg_h2l_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON14), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VS2_PG_H2L_EN_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS2_PG_H2L_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_con15_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_CON15_RSV_MASK),
	    (unsigned int)(PMIC_RG_STRUP_CON15_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_vusb_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VUSB_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VUSB_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vusb_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VUSB_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VUSB_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vdram_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VDRAM_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VDRAM_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vdram_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VDRAM_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VDRAM_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vio28_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VIO28_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VIO28_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vio28_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VIO28_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VIO28_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vemc_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VEMC_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VEMC_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vemc_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VEMC_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VEMC_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vio18_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VIO18_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VIO18_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vio18_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VIO18_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VIO18_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vsram_proc_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vsram_proc_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_PROC_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_va12_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VA12_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VA12_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_va12_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VA12_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VA12_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vsram_gpu_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_GPU_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_GPU_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vsram_gpu_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_GPU_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_GPU_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vsram_others_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_OTHERS_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_OTHERS_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vsram_others_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_OTHERS_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VSRAM_OTHERS_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vaux18_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VAUX18_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VAUX18_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vaux18_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VAUX18_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VAUX18_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_buck_rsv_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_buck_rsv_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vproc_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vproc_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vs1_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VS1_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS1_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vs1_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VS1_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS1_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vmodem_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vmodem_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vcore_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vcore_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vs2_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VS2_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS2_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vs2_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON16), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VS2_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS2_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_ext_pmic_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_ext_pmic_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON17), (&val),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_EXT_PMIC_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vxo22_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VXO22_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VXO22_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vxo22_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON17), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VXO22_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VXO22_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vaud28_pg_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VAUD28_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VAUD28_PG_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vaud28_pg_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON17), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VAUD28_PG_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VAUD28_PG_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_buck_rsv_oc_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_OC_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_buck_rsv_oc_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (&val),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_BUCK_RSV_OC_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vproc_oc_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_OC_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vproc_oc_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VPROC_OC_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vs1_oc_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VS1_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS1_OC_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vs1_oc_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VS1_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS1_OC_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vmodem_oc_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_OC_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vmodem_oc_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VMODEM_OC_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vcore_oc_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_OC_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vcore_oc_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VCORE_OC_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_strup_vs2_oc_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_VS2_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS2_OC_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_strup_vs2_oc_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON18), (&val),
	    (unsigned int)(PMIC_RG_STRUP_VS2_OC_ENB_MASK),
	    (unsigned int)(PMIC_RG_STRUP_VS2_OC_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_ext_pmic_pg_debtd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON19), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EXT_PMIC_PG_DEBTD_MASK),
	    (unsigned int)(PMIC_RG_EXT_PMIC_PG_DEBTD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_spar_deb_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON19), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_SPAR_DEB_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC_SPAR_DEB_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_rtc_spar_deb_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_STRUP_CON19), (&val),
				(unsigned int)(PMIC_RG_RTC_SPAR_DEB_EN_MASK),
				(unsigned int)(PMIC_RG_RTC_SPAR_DEB_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_rtc_alarm_deb_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_STRUP_CON19), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_ALARM_DEB_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC_ALARM_DEB_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_rtc_alarm_deb_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_STRUP_CON19), (&val),
	    (unsigned int)(PMIC_RG_RTC_ALARM_DEB_EN_MASK),
	    (unsigned int)(PMIC_RG_RTC_ALARM_DEB_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pseq_elr_len(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSEQ_ELR_NUM), (&val),
				  (unsigned int)(PMIC_PSEQ_ELR_LEN_MASK),
				  (unsigned int)(PMIC_PSEQ_ELR_LEN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vaux18_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VAUX18_USA_MASK),
				    (unsigned int)(PMIC_RG_VAUX18_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs2_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS2_USA_MASK),
				    (unsigned int)(PMIC_RG_VS2_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vsram_others_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VSRAM_OTHERS_USA_MASK),
	    (unsigned int)(PMIC_RG_VSRAM_OTHERS_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vsram_gpu_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VSRAM_GPU_USA_MASK),
	    (unsigned int)(PMIC_RG_VSRAM_GPU_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VCORE_USA_MASK),
				    (unsigned int)(PMIC_RG_VCORE_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VMODEM_USA_MASK),
				    (unsigned int)(PMIC_RG_VMODEM_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_USA_MASK),
				    (unsigned int)(PMIC_RG_VS1_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_va12_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VA12_USA_MASK),
				    (unsigned int)(PMIC_RG_VA12_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vsram_proc_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VSRAM_PROC_USA_MASK),
	    (unsigned int)(PMIC_RG_VSRAM_PROC_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VPROC_USA_MASK),
				    (unsigned int)(PMIC_RG_VPROC_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vio18_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VIO18_USA_MASK),
				    (unsigned int)(PMIC_RG_VIO18_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vemc_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VEMC_USA_MASK),
				    (unsigned int)(PMIC_RG_VEMC_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_ext_pmic_1_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EXT_PMIC_1_USA_MASK),
	    (unsigned int)(PMIC_RG_EXT_PMIC_1_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vio28_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VIO28_USA_MASK),
				    (unsigned int)(PMIC_RG_VIO28_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vdram_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VDRAM_USA_MASK),
				    (unsigned int)(PMIC_RG_VDRAM_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_ext_pmic_2_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EXT_PMIC_2_USA_MASK),
	    (unsigned int)(PMIC_RG_EXT_PMIC_2_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vusb_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VUSB_USA_MASK),
				    (unsigned int)(PMIC_RG_VUSB_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vaud28_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VAUD28_USA_MASK),
				    (unsigned int)(PMIC_RG_VAUD28_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vxo22_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR6),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VXO22_USA_MASK),
				    (unsigned int)(PMIC_RG_VXO22_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_rsv_usa(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_RSV_USA_MASK),
	    (unsigned int)(PMIC_RG_BUCK_RSV_USA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_seq_len(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR6),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SEQ_LEN_MASK),
				    (unsigned int)(PMIC_RG_SEQ_LEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bwdt_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BWDT_EN_MASK),
				    (unsigned int)(PMIC_RG_BWDT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bwdt_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSEQ_ELR7), (&val),
				  (unsigned int)(PMIC_RG_BWDT_EN_MASK),
				  (unsigned int)(PMIC_RG_BWDT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_bwdt_tsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BWDT_TSEL_MASK),
				    (unsigned int)(PMIC_RG_BWDT_TSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bwdt_csel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BWDT_CSEL_MASK),
				    (unsigned int)(PMIC_RG_BWDT_CSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bwdt_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BWDT_TD_MASK),
				    (unsigned int)(PMIC_RG_BWDT_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bwdt_chrtd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BWDT_CHRTD_MASK),
				    (unsigned int)(PMIC_RG_BWDT_CHRTD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bwdt_ddlo_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BWDT_DDLO_TD_MASK),
	    (unsigned int)(PMIC_RG_BWDT_DDLO_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bwdt_srcsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BWDT_SRCSEL_MASK),
				    (unsigned int)(PMIC_RG_BWDT_SRCSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_slot_intv_up(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SLOT_INTV_UP_MASK),
	    (unsigned int)(PMIC_RG_SLOT_INTV_UP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pspg_shdn_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSPG_SHDN_EN_MASK),
	    (unsigned int)(PMIC_RG_PSPG_SHDN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_pspg_shdn_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSEQ_ELR8), (&val),
				  (unsigned int)(PMIC_RG_PSPG_SHDN_EN_MASK),
				  (unsigned int)(PMIC_RG_PSPG_SHDN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pseq_fsm_rst_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_FSM_RST_SEL_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_FSM_RST_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_f75k_force(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_F75K_FORCE_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_F75K_FORCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_1ms_tk_ext(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_1MS_TK_EXT_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_1MS_TK_EXT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pseq_ivgen_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PSEQ_IVGEN_SEL_MASK),
	    (unsigned int)(PMIC_RG_PSEQ_IVGEN_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_long_press_reset_extend(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_RESET_EXTEND_MASK),
	    (unsigned int)(PMIC_RG_STRUP_LONG_PRESS_RESET_EXTEND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cps_s0ext_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CPS_S0EXT_ENB_MASK),
	    (unsigned int)(PMIC_RG_CPS_S0EXT_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_cps_s0ext_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSEQ_ELR8), (&val),
				  (unsigned int)(PMIC_RG_CPS_S0EXT_ENB_MASK),
				  (unsigned int)(PMIC_RG_CPS_S0EXT_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_cps_s0ext_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CPS_S0EXT_TD_MASK),
	    (unsigned int)(PMIC_RG_CPS_S0EXT_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_sdn_dly_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PSEQ_ELR8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SDN_DLY_ENB_MASK),
				    (unsigned int)(PMIC_RG_SDN_DLY_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_sdn_dly_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PSEQ_ELR8), (&val),
				  (unsigned int)(PMIC_RG_SDN_DLY_ENB_MASK),
				  (unsigned int)(PMIC_RG_SDN_DLY_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_chrdet_deb_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CHRDET_DEB_TD_MASK),
	    (unsigned int)(PMIC_RG_CHRDET_DEB_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_strup_uvlo_u1u2_sel_old(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_STRUP_UVLO_U1U2_SEL_OLD_MASK),
	    (unsigned int)(PMIC_RG_STRUP_UVLO_U1U2_SEL_OLD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_efuse_ivgen_enb_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PSEQ_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_EFUSE_IVGEN_ENB_SEL_MASK),
	    (unsigned int)(PMIC_EFUSE_IVGEN_ENB_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_pchr_dig_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PCHR_DIG_ID), (&val),
				  (unsigned int)(PMIC_PCHR_DIG_ANA_ID_MASK),
				  (unsigned int)(PMIC_PCHR_DIG_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pchr_dig_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PCHR_DIG_ID), (&val),
				  (unsigned int)(PMIC_PCHR_DIG_DIG_ID_MASK),
				  (unsigned int)(PMIC_PCHR_DIG_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pchr_dig_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PCHR_DIG_REV0), (&val),
	    (unsigned int)(PMIC_PCHR_DIG_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_PCHR_DIG_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pchr_dig_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PCHR_DIG_REV0), (&val),
	    (unsigned int)(PMIC_PCHR_DIG_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_PCHR_DIG_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pchr_dig_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_PCHR_DIG_REV1), (&val),
	    (unsigned int)(PMIC_PCHR_DIG_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_PCHR_DIG_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pchr_dig_esp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PCHR_DIG_REV1), (&val),
				  (unsigned int)(PMIC_PCHR_DIG_ESP_MASK),
				  (unsigned int)(PMIC_PCHR_DIG_ESP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pchr_dig_reg_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PCHR_DIG_REV2), (&val),
				  (unsigned int)(PMIC_PCHR_DIG_REG_ID_MASK),
				  (unsigned int)(PMIC_PCHR_DIG_REG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_chrwdt_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_TOP_CON0), (&val),
				  (unsigned int)(PMIC_RGS_CHRWDT_OUT_MASK),
				  (unsigned int)(PMIC_RGS_CHRWDT_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_otg_bvalid_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_CHR_TOP_CON0), (&val),
				(unsigned int)(PMIC_RGS_OTG_BVALID_DET_MASK),
				(unsigned int)(PMIC_RGS_OTG_BVALID_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vbat_ov_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_TOP_CON0), (&val),
				  (unsigned int)(PMIC_RGS_VBAT_OV_DET_MASK),
				  (unsigned int)(PMIC_RGS_VBAT_OV_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_chr_ldo_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_TOP_CON0), (&val),
				  (unsigned int)(PMIC_RGS_CHR_LDO_DET_MASK),
				  (unsigned int)(PMIC_RGS_CHR_LDO_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_chrdet(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_TOP_CON0), (&val),
				  (unsigned int)(PMIC_RGS_CHRDET_MASK),
				  (unsigned int)(PMIC_RGS_CHRDET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pchr_rv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_TOP_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PCHR_RV_MASK),
				    (unsigned int)(PMIC_RG_PCHR_RV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcdt_uvlo_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCDT_UVLO_EN_MASK),
	    (unsigned int)(PMIC_RG_VCDT_UVLO_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vcdt_uvlo_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_TOP_CON3), (&val),
				  (unsigned int)(PMIC_RG_VCDT_UVLO_EN_MASK),
				  (unsigned int)(PMIC_RG_VCDT_UVLO_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vcdt_uvlo_vth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCDT_UVLO_VTH_MASK),
	    (unsigned int)(PMIC_RG_VCDT_UVLO_VTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_uvlo_vthl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_TOP_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_UVLO_VTHL_MASK),
				    (unsigned int)(PMIC_RG_UVLO_VTHL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_uvlo_vh_lat(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_TOP_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_UVLO_VH_LAT_MASK),
				    (unsigned int)(PMIC_RG_UVLO_VH_LAT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcdt_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_TOP_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VCDT_MODE_MASK),
				    (unsigned int)(PMIC_RG_VCDT_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcdt_lv_vth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_TOP_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VCDT_LV_VTH_MASK),
				    (unsigned int)(PMIC_RG_VCDT_LV_VTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcdt_hv_vth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_TOP_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VCDT_HV_VTH_MASK),
				    (unsigned int)(PMIC_RG_VCDT_HV_VTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vbat_ov_vth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_TOP_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBAT_OV_VTH_MASK),
				    (unsigned int)(PMIC_RG_VBAT_OV_VTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_da_qi_bgr_ext_buf_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_DA_QI_BGR_EXT_BUF_EN_MASK),
	    (unsigned int)(PMIC_DA_QI_BGR_EXT_BUF_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bgr_test_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_TOP_CON5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BGR_TEST_EN_MASK),
				    (unsigned int)(PMIC_RG_BGR_TEST_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bgr_test_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_TOP_CON5), (&val),
				  (unsigned int)(PMIC_RG_BGR_TEST_EN_MASK),
				  (unsigned int)(PMIC_RG_BGR_TEST_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_bgr_test_rstb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BGR_TEST_RSTB_MASK),
	    (unsigned int)(PMIC_RG_BGR_TEST_RSTB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bgr_unchop_ph(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BGR_UNCHOP_PH_MASK),
	    (unsigned int)(PMIC_RG_BGR_UNCHOP_PH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bgr_unchop(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_TOP_CON5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BGR_UNCHOP_MASK),
				    (unsigned int)(PMIC_RG_BGR_UNCHOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_ft_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_FT_CTRL_MASK),
	    (unsigned int)(PMIC_RG_PCHR_FT_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_pchr_cm_vinc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON6), (&val),
	    (unsigned int)(PMIC_PCHR_CM_VINC_STATUS_MASK),
	    (unsigned int)(PMIC_PCHR_CM_VINC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pchr_cm_vdec_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON6), (&val),
	    (unsigned int)(PMIC_PCHR_CM_VDEC_STATUS_MASK),
	    (unsigned int)(PMIC_PCHR_CM_VDEC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pchr_flag_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_FLAG_EN_MASK),
	    (unsigned int)(PMIC_RG_PCHR_FLAG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_pchr_flag_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_TOP_CON6), (&val),
				  (unsigned int)(PMIC_RG_PCHR_FLAG_EN_MASK),
				  (unsigned int)(PMIC_RG_PCHR_FLAG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pchr_flag_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_FLAG_SEL_MASK),
	    (unsigned int)(PMIC_RG_PCHR_FLAG_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_lbat_int_vth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_LBAT_INT_VTH_MASK),
	    (unsigned int)(PMIC_RG_LBAT_INT_VTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_otg_bvalid_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_TOP_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_OTG_BVALID_EN_MASK),
	    (unsigned int)(PMIC_RG_OTG_BVALID_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_otg_bvalid_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_TOP_CON7), (&val),
				  (unsigned int)(PMIC_RG_OTG_BVALID_EN_MASK),
				  (unsigned int)(PMIC_RG_OTG_BVALID_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_pchr_dig_elr_len(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PCHR_DIG_ELR_NUM),
				  (&val),
				  (unsigned int)(PMIC_PCHR_DIG_ELR_LEN_MASK),
				  (unsigned int)(PMIC_PCHR_DIG_ELR_LEN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_ichrg_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PCHR_ELR0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_ICHRG_TRIM_MASK),
				    (unsigned int)(PMIC_RG_ICHRG_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vbat_cv_vth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PCHR_ELR0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBAT_CV_VTH_MASK),
				    (unsigned int)(PMIC_RG_VBAT_CV_VTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bgr_rsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PCHR_ELR0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BGR_RSEL_MASK),
				    (unsigned int)(PMIC_RG_BGR_RSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_chr_osc_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PCHR_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CHR_OSC_TRIM_MASK),
	    (unsigned int)(PMIC_RG_CHR_OSC_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_ovp_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PCHR_ELR1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_OVP_TRIM_MASK),
				    (unsigned int)(PMIC_RG_OVP_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bgr_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PCHR_ELR1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BGR_TRIM_MASK),
				    (unsigned int)(PMIC_RG_BGR_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bgr_trim_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PCHR_ELR1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BGR_TRIM_EN_MASK),
				    (unsigned int)(PMIC_RG_BGR_TRIM_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bgr_trim_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_PCHR_ELR1), (&val),
				  (unsigned int)(PMIC_RG_BGR_TRIM_EN_MASK),
				  (unsigned int)(PMIC_RG_BGR_TRIM_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pchr_spare_elr0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PCHR_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_SPARE_ELR0_MASK),
	    (unsigned int)(PMIC_RG_PCHR_SPARE_ELR0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_indicator_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PCHR_ELR2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INDICATOR_TRIM_MASK),
	    (unsigned int)(PMIC_RG_INDICATOR_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vbat_cv_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PCHR_ELR2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VBAT_CV_TRIM_MASK),
	    (unsigned int)(PMIC_RG_VBAT_CV_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcdt_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PCHR_ELR2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VCDT_TRIM_MASK),
				    (unsigned int)(PMIC_RG_VCDT_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_spare_elr1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_PCHR_ELR2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_SPARE_ELR1_MASK),
	    (unsigned int)(PMIC_RG_PCHR_SPARE_ELR1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_app2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PCHR_ELR3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PCHR_APP2_MASK),
				    (unsigned int)(PMIC_RG_PCHR_APP2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_app1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_PCHR_ELR3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PCHR_APP1_MASK),
				    (unsigned int)(PMIC_RG_PCHR_APP1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cs_vth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CS_VTH_MASK),
				    (unsigned int)(PMIC_RG_CS_VTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cs_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CS_EN_MASK),
				    (unsigned int)(PMIC_RG_CS_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_cs_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON0), (&val),
				  (unsigned int)(PMIC_RG_CS_EN_MASK),
				  (unsigned int)(PMIC_RG_CS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vbat_ov_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBAT_OV_EN_MASK),
				    (unsigned int)(PMIC_RG_VBAT_OV_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vbat_ov_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON0), (&val),
				  (unsigned int)(PMIC_RG_VBAT_OV_EN_MASK),
				  (unsigned int)(PMIC_RG_VBAT_OV_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vbat_ov_deg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBAT_OV_DEG_MASK),
				    (unsigned int)(PMIC_RG_VBAT_OV_DEG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vbat_cv_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBAT_CV_EN_MASK),
				    (unsigned int)(PMIC_RG_VBAT_CV_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vbat_cv_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON0), (&val),
				  (unsigned int)(PMIC_RG_VBAT_CV_EN_MASK),
				  (unsigned int)(PMIC_RG_VBAT_CV_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vbat_cc_vth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBAT_CC_VTH_MASK),
				    (unsigned int)(PMIC_RG_VBAT_CC_VTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vbat_cc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBAT_CC_EN_MASK),
				    (unsigned int)(PMIC_RG_VBAT_CC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vbat_cc_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON0), (&val),
				  (unsigned int)(PMIC_RG_VBAT_CC_EN_MASK),
				  (unsigned int)(PMIC_RG_VBAT_CC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vcdt_hv_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VCDT_HV_EN_MASK),
				    (unsigned int)(PMIC_RG_VCDT_HV_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vcdt_hv_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON0), (&val),
				  (unsigned int)(PMIC_RG_VCDT_HV_EN_MASK),
				  (unsigned int)(PMIC_RG_VCDT_HV_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_low_ich_db(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_LOW_ICH_DB_MASK),
				    (unsigned int)(PMIC_RG_LOW_ICH_DB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cv_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CV_MODE_MASK),
				    (unsigned int)(PMIC_RG_CV_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_csdac_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CSDAC_MODE_MASK),
				    (unsigned int)(PMIC_RG_CSDAC_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_tracking_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_TRACKING_EN_MASK),
				    (unsigned int)(PMIC_RG_TRACKING_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_tracking_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON1), (&val),
				  (unsigned int)(PMIC_RG_TRACKING_EN_MASK),
				  (unsigned int)(PMIC_RG_TRACKING_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_hwcv_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_HWCV_EN_MASK),
				    (unsigned int)(PMIC_RG_HWCV_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_hwcv_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON1), (&val),
				  (unsigned int)(PMIC_RG_HWCV_EN_MASK),
				  (unsigned int)(PMIC_RG_HWCV_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_ulc_det_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_ULC_DET_EN_MASK),
				    (unsigned int)(PMIC_RG_ULC_DET_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_ulc_det_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON1), (&val),
				  (unsigned int)(PMIC_RG_ULC_DET_EN_MASK),
				  (unsigned int)(PMIC_RG_ULC_DET_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_csdac_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CSDAC_EN_MASK),
				    (unsigned int)(PMIC_RG_CSDAC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_csdac_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON1), (&val),
				  (unsigned int)(PMIC_RG_CSDAC_EN_MASK),
				  (unsigned int)(PMIC_RG_CSDAC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_chr_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CHR_EN_MASK),
				    (unsigned int)(PMIC_RG_CHR_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_chr_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON1), (&val),
				  (unsigned int)(PMIC_RG_CHR_EN_MASK),
				  (unsigned int)(PMIC_RG_CHR_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_cs_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON2), (&val),
				  (unsigned int)(PMIC_RGS_CS_DET_MASK),
				  (unsigned int)(PMIC_RGS_CS_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vbat_cv_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON2), (&val),
				  (unsigned int)(PMIC_RGS_VBAT_CV_DET_MASK),
				  (unsigned int)(PMIC_RGS_VBAT_CV_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vbat_cc_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON2), (&val),
				  (unsigned int)(PMIC_RGS_VBAT_CC_DET_MASK),
				  (unsigned int)(PMIC_RGS_VBAT_CC_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vcdt_lv_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON2), (&val),
				  (unsigned int)(PMIC_RGS_VCDT_LV_DET_MASK),
				  (unsigned int)(PMIC_RGS_VCDT_LV_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vcdt_hv_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON2), (&val),
				  (unsigned int)(PMIC_RGS_VCDT_HV_DET_MASK),
				  (unsigned int)(PMIC_RGS_VCDT_HV_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_csdac_dly(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CSDAC_DLY_MASK),
				    (unsigned int)(PMIC_RG_CSDAC_DLY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_csdac_stp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CSDAC_STP_MASK),
				    (unsigned int)(PMIC_RG_CSDAC_STP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_csdac_stp_inc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CSDAC_STP_INC_MASK),
	    (unsigned int)(PMIC_RG_CSDAC_STP_INC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_csdac_stp_dec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CSDAC_STP_DEC_MASK),
	    (unsigned int)(PMIC_RG_CSDAC_STP_DEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_tohtc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PCHR_TOHTC_MASK),
				    (unsigned int)(PMIC_RG_PCHR_TOHTC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_toltc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PCHR_TOLTC_MASK),
				    (unsigned int)(PMIC_RG_PCHR_TOLTC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_csdac_data(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CSDAC_DATA_MASK),
				    (unsigned int)(PMIC_RG_CSDAC_DATA_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_frc_csvth_usbdl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FRC_CSVTH_USBDL_MASK),
	    (unsigned int)(PMIC_RG_FRC_CSVTH_USBDL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_usbdl_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON6),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_USBDL_RST_MASK),
				    (unsigned int)(PMIC_RG_USBDL_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_usbdl_set(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON6),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_USBDL_SET_MASK),
				    (unsigned int)(PMIC_RG_USBDL_SET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_dac_usbdl_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_DAC_USBDL_MAX_MASK),
	    (unsigned int)(PMIC_RG_DAC_USBDL_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rgs_pchr_flag_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_CHR_CON7), (&val),
				(unsigned int)(PMIC_RGS_PCHR_FLAG_OUT_MASK),
				(unsigned int)(PMIC_RGS_PCHR_FLAG_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_pchr_testmode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PCHR_TESTMODE_MASK),
	    (unsigned int)(PMIC_RG_PCHR_TESTMODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_csdac_testmode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CSDAC_TESTMODE_MASK),
	    (unsigned int)(PMIC_RG_CSDAC_TESTMODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pchr_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_PCHR_RST_MASK),
				    (unsigned int)(PMIC_RG_PCHR_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bc11_vref_vth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BC11_VREF_VTH_MASK),
	    (unsigned int)(PMIC_RG_BC11_VREF_VTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bc11_cmp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BC11_CMP_EN_MASK),
				    (unsigned int)(PMIC_RG_BC11_CMP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bc11_cmp_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON8), (&val),
				  (unsigned int)(PMIC_RG_BC11_CMP_EN_MASK),
				  (unsigned int)(PMIC_RG_BC11_CMP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_bc11_ipd_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BC11_IPD_EN_MASK),
				    (unsigned int)(PMIC_RG_BC11_IPD_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bc11_ipd_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON8), (&val),
				  (unsigned int)(PMIC_RG_BC11_IPD_EN_MASK),
				  (unsigned int)(PMIC_RG_BC11_IPD_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_bc11_ipu_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BC11_IPU_EN_MASK),
				    (unsigned int)(PMIC_RG_BC11_IPU_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bc11_ipu_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON8), (&val),
				  (unsigned int)(PMIC_RG_BC11_IPU_EN_MASK),
				  (unsigned int)(PMIC_RG_BC11_IPU_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_bc11_bias_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BC11_BIAS_EN_MASK),
	    (unsigned int)(PMIC_RG_BC11_BIAS_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bc11_bias_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON8), (&val),
				  (unsigned int)(PMIC_RG_BC11_BIAS_EN_MASK),
				  (unsigned int)(PMIC_RG_BC11_BIAS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_bc11_bb_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BC11_BB_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BC11_BB_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bc11_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BC11_RST_MASK),
				    (unsigned int)(PMIC_RG_BC11_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bc11_vsrc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BC11_VSRC_EN_MASK),
	    (unsigned int)(PMIC_RG_BC11_VSRC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bc11_vsrc_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON8), (&val),
				  (unsigned int)(PMIC_RG_BC11_VSRC_EN_MASK),
				  (unsigned int)(PMIC_RG_BC11_VSRC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_bc11_dcd_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BC11_DCD_EN_MASK),
				    (unsigned int)(PMIC_RG_BC11_DCD_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bc11_dcd_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON8), (&val),
				  (unsigned int)(PMIC_RG_BC11_DCD_EN_MASK),
				  (unsigned int)(PMIC_RG_BC11_DCD_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_bc11_cmp_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON8), (&val),
				  (unsigned int)(PMIC_RGS_BC11_CMP_OUT_MASK),
				  (unsigned int)(PMIC_RGS_BC11_CMP_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_cm_vdec_hprd1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON9), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD1_MASK),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vdec_hprd2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON9), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD2_MASK),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vdec_hprd3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON10), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD3_MASK),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vdec_hprd4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON10), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD4_MASK),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vdec_hprd5(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD5_MASK),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD5_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vdec_hprd6(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD6_MASK),
	    (unsigned int)(PMIC_RG_CM_VDEC_HPRD6_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vinc_hprd1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD1_MASK),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vinc_hprd2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD2_MASK),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vinc_hprd3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD3_MASK),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vinc_hprd4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD4_MASK),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vinc_hprd5(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD5_MASK),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD5_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vinc_hprd6(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD6_MASK),
	    (unsigned int)(PMIC_RG_CM_VINC_HPRD6_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_lprd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON15),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CM_LPRD_MASK),
				    (unsigned int)(PMIC_RG_CM_LPRD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_cs_vthl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON16),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CM_CS_VTHL_MASK),
				    (unsigned int)(PMIC_RG_CM_CS_VTHL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_cs_vthh(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON16),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CM_CS_VTHH_MASK),
				    (unsigned int)(PMIC_RG_CM_CS_VTHH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vinc_trig(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VINC_TRIG_MASK),
	    (unsigned int)(PMIC_RG_CM_VINC_TRIG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_cm_vdec_trig(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_CHR_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CM_VDEC_TRIG_MASK),
	    (unsigned int)(PMIC_RG_CM_VDEC_TRIG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_envtem_d(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON18),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_ENVTEM_D_MASK),
				    (unsigned int)(PMIC_RG_ENVTEM_D_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_envtem_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON18),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_ENVTEM_EN_MASK),
				    (unsigned int)(PMIC_RG_ENVTEM_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_envtem_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON18), (&val),
				  (unsigned int)(PMIC_RG_ENVTEM_EN_MASK),
				  (unsigned int)(PMIC_RG_ENVTEM_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_chrwdt_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON18),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CHRWDT_TD_MASK),
				    (unsigned int)(PMIC_RG_CHRWDT_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_chrwdt_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON18),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CHRWDT_EN_MASK),
				    (unsigned int)(PMIC_RG_CHRWDT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_chrwdt_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_CHR_CON18), (&val),
				  (unsigned int)(PMIC_RG_CHRWDT_EN_MASK),
				  (unsigned int)(PMIC_RG_CHRWDT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_chrwdt_wr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_CHR_CON18),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_CHRWDT_WR_MASK),
				    (unsigned int)(PMIC_RG_CHRWDT_WR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fgadc_32k_ck_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FGADC_32K_CK_SEL_MASK),
	    (unsigned int)(PMIC_RG_FGADC_32K_CK_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_32k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_32K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BATON_32K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_1k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_1K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BATON_1K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fgadc_ft_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FGADC_FT_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_FGADC_FT_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fgadc_dig_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FGADC_DIG_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_FGADC_DIG_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fgadc_ana_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FGADC_ANA_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_FGADC_ANA_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_g_bif_1m_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_G_BIF_1M_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_G_BIF_1M_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bif_x1_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BIF_X1_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BIF_X1_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bif_x4_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BIF_X4_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BIF_X4_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bif_x104_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BIF_X104_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BIF_X104_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_pmu26m_ck_div_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_PMU26M_CK_DIV_PDN_MASK),
	    (unsigned int)(PMIC_RG_PMU26M_CK_DIV_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_intrp_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BM_INTRP_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BM_INTRP_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_intrp_pre_oc_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BM_INTRP_PRE_OC_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BM_INTRP_PRE_OC_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_top_ckpdn_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BM_TOP_CKPDN_CON0_RSV_MASK),
	    (unsigned int)(PMIC_RG_BM_TOP_CKPDN_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fgadc_ana_ck_cksel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FGADC_ANA_CK_CKSEL_MASK),
	    (unsigned int)(PMIC_RG_FGADC_ANA_CK_CKSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_top_cksel_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BM_TOP_CKSEL_CON0_RSV_MASK),
	    (unsigned int)(PMIC_RG_BM_TOP_CKSEL_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bif_x4_ck_divsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKDIVSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BIF_X4_CK_DIVSEL_MASK),
	    (unsigned int)(PMIC_RG_BIF_X4_CK_DIVSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bm_top_ckdivsel_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKDIVSEL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BM_TOP_CKDIVSEL_CON0_RSV_MASK),
	    (unsigned int)(PMIC_BM_TOP_CKDIVSEL_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bif_x4_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BIF_X4_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_BIF_X4_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bif_x104_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BIF_X104_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_BIF_X104_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bm_top_ckhwen_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BM_TOP_CKHWEN_CON0_RSV_MASK),
	    (unsigned int)(PMIC_BM_TOP_CKHWEN_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fg_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FG_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_FG_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fgadc_ana_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FGADC_ANA_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_FGADC_ANA_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fg_ck_tst_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FG_CK_TST_DIS_MASK),
	    (unsigned int)(PMIC_RG_FG_CK_TST_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bm_top_cktst_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_CKTST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BM_TOP_CKTST_CON0_RSV_MASK),
	    (unsigned int)(PMIC_BM_TOP_CKTST_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fgadc_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_FGADC_SWRST_MASK),
				    (unsigned int)(PMIC_RG_FGADC_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BATON_SWRST_MASK),
				    (unsigned int)(PMIC_RG_BATON_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bif_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BIF_SWRST_MASK),
				    (unsigned int)(PMIC_RG_BIF_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_swrst_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SWRST_RSV_MASK),
				    (unsigned int)(PMIC_RG_SWRST_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bank_fgadc_ana_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BANK_FGADC_ANA_SWRST_MASK),
	    (unsigned int)(PMIC_RG_BANK_FGADC_ANA_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bank_fgadc_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BANK_FGADC_SWRST_MASK),
	    (unsigned int)(PMIC_RG_BANK_FGADC_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bank_bat_ana_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BANK_BAT_ANA_SWRST_MASK),
	    (unsigned int)(PMIC_RG_BANK_BAT_ANA_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bank_baton_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BANK_BATON_SWRST_MASK),
	    (unsigned int)(PMIC_RG_BANK_BATON_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bank_bif_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BANK_BIF_SWRST_MASK),
	    (unsigned int)(PMIC_RG_BANK_BIF_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bm_top_rst_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BM_TOP_RST_CON0_RSV_MASK),
	    (unsigned int)(PMIC_BM_TOP_RST_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fgadc_rst_src_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_RST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FGADC_RST_SRC_SEL_MASK),
	    (unsigned int)(PMIC_RG_FGADC_RST_SRC_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bm_top_rst_con1_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_RST_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_BM_TOP_RST_CON1_RSV_MASK),
	    (unsigned int)(PMIC_BM_TOP_RST_CON1_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_bat0_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT0_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT0_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_bat0_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT0_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT0_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_bat0_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT0_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT0_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_bat0_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT0_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT0_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_cur_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_CUR_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_CUR_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_cur_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
				(unsigned int)(PMIC_RG_INT_EN_FG_CUR_H_MASK),
				(unsigned int)(PMIC_RG_INT_EN_FG_CUR_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_cur_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_CUR_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_CUR_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_cur_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
				(unsigned int)(PMIC_RG_INT_EN_FG_CUR_L_MASK),
				(unsigned int)(PMIC_RG_INT_EN_FG_CUR_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_zcv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_ZCV_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_ZCV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_zcv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
				(unsigned int)(PMIC_RG_INT_EN_FG_ZCV_MASK),
				(unsigned int)(PMIC_RG_INT_EN_FG_ZCV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_bat1_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT1_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT1_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_bat1_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT1_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT1_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_bat1_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT1_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT1_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_bat1_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT1_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_BAT1_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_n_charge_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_N_CHARGE_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_N_CHARGE_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_n_charge_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_N_CHARGE_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_N_CHARGE_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_iavg_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_IAVG_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_IAVG_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_iavg_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_IAVG_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_IAVG_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_iavg_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_IAVG_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_IAVG_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_iavg_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_IAVG_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_IAVG_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_time_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_TIME_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_TIME_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_time_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_TIME_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_TIME_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_discharge(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_DISCHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_DISCHARGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_discharge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_DISCHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_DISCHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_fg_charge(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_CHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_CHARGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_fg_charge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_FG_CHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_FG_CHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_bm_int_en_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BM_INT_EN_CON0_RSV_MASK),
	    (unsigned int)(PMIC_RG_BM_INT_EN_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_bm_int_en_con0_rsv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_BM_INT_EN_CON0_RSV_MASK),
	    (unsigned int)(PMIC_RG_BM_INT_EN_CON0_RSV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_baton_lv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_LV_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_LV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_baton_lv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BM_TOP_INT_CON1), (&val),
				(unsigned int)(PMIC_RG_INT_EN_BATON_LV_MASK),
				(unsigned int)(PMIC_RG_INT_EN_BATON_LV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_baton_bat_in(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_BAT_IN_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_BAT_IN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_baton_bat_in(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON1), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_BAT_IN_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_BAT_IN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_baton_bat_out(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_BAT_OUT_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_BAT_OUT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_baton_bat_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_CON1), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_BAT_OUT_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BATON_BAT_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_bif(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_INT_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_INT_EN_BIF_MASK),
				    (unsigned int)(PMIC_RG_INT_EN_BIF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_bif(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BM_TOP_INT_CON1), (&val),
				(unsigned int)(PMIC_RG_INT_EN_BIF_MASK),
				(unsigned int)(PMIC_RG_INT_EN_BIF_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_bat0_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_BAT0_H_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_BAT0_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_bat0_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_BAT0_L_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_BAT0_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_cur_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_CUR_H_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_CUR_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_cur_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_CUR_L_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_CUR_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_zcv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_ZCV_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_ZCV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_bat1_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_BAT1_H_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_BAT1_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_bat1_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_BAT1_L_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_BAT1_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_n_charge_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_N_CHARGE_L_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_N_CHARGE_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_iavg_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_IAVG_H_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_IAVG_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_iavg_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_IAVG_L_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_IAVG_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_time_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_TIME_H_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_TIME_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_discharge(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_DISCHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_DISCHARGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_fg_charge(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_CHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_FG_CHARGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_int_mask_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BM_INT_MASK_CON0_RSV_MASK),
	    (unsigned int)(PMIC_RG_BM_INT_MASK_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_baton_lv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BATON_LV_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BATON_LV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_baton_bat_in(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BATON_BAT_IN_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BATON_BAT_IN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_baton_bat_out(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BATON_BAT_OUT_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BATON_BAT_OUT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_bif(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MASK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BIF_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BIF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_bat0_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_BAT0_H_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_BAT0_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_bat0_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_BAT0_L_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_BAT0_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_cur_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_CUR_H_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_CUR_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_cur_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_CUR_L_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_CUR_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_zcv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_ZCV_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_ZCV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_bat1_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_BAT1_H_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_BAT1_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_bat1_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_BAT1_L_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_BAT1_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_n_charge_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_N_CHARGE_L_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_N_CHARGE_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_iavg_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_IAVG_H_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_IAVG_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_iavg_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_IAVG_L_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_IAVG_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_time_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_TIME_H_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_TIME_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_discharge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_DISCHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_DISCHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_fg_charge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_CHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_FG_CHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_bm_int_status0_rsv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_BM_INT_STATUS0_RSV_MASK),
	    (unsigned int)(PMIC_RG_BM_INT_STATUS0_RSV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_baton_lv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BATON_LV_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BATON_LV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_baton_bat_in(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BATON_BAT_IN_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BATON_BAT_IN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_baton_bat_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BATON_BAT_OUT_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BATON_BAT_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_bif(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BIF_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BIF_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_bat0_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_BAT0_H_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_BAT0_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_bat0_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_BAT0_L_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_BAT0_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_cur_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_CUR_H_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_CUR_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_cur_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_CUR_L_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_CUR_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_zcv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_ZCV_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_ZCV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_bat1_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_BAT1_H_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_BAT1_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_bat1_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_BAT1_L_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_BAT1_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_n_charge_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_N_CHARGE_L_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_N_CHARGE_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_iavg_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_IAVG_H_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_IAVG_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_iavg_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_IAVG_L_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_IAVG_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_time_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_TIME_H_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_TIME_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_discharge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_DISCHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_DISCHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_fg_charge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_CHARGE_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_FG_CHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_bm_int_raw_status_rsv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_BM_INT_RAW_STATUS_RSV_MASK),
	    (unsigned int)(PMIC_RG_BM_INT_RAW_STATUS_RSV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_baton_lv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BATON_LV_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BATON_LV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_baton_bat_in(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BATON_BAT_IN_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BATON_BAT_IN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_baton_bat_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BATON_BAT_OUT_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BATON_BAT_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_bif(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_RAW_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BIF_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BIF_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_polarity(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_INT_MISC_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_POLARITY_MASK),
				    (unsigned int)(PMIC_POLARITY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bm_int_misc_con_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_INT_MISC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_BM_INT_MISC_CON_RSV_MASK),
	    (unsigned int)(PMIC_BM_INT_MISC_CON_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_mon_flag_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_DBG_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BM_MON_FLAG_SEL_MASK),
	    (unsigned int)(PMIC_RG_BM_MON_FLAG_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_mon_grp_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_DBG_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BM_MON_GRP_SEL_MASK),
	    (unsigned int)(PMIC_RG_BM_MON_GRP_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_top_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_RSV0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BM_TOP_RSV0_MASK),
				    (unsigned int)(PMIC_RG_BM_TOP_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_top_rsv1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_RSV1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BM_TOP_RSV1_MASK),
				    (unsigned int)(PMIC_RG_BM_TOP_RSV1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_top_rsv2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_RSV2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BM_TOP_RSV2_MASK),
				    (unsigned int)(PMIC_RG_BM_TOP_RSV2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bm_top_rsv3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BM_TOP_RSV3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BM_TOP_RSV3_MASK),
				    (unsigned int)(PMIC_RG_BM_TOP_RSV3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bm_top_elr0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BM_TOP_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_BM_TOP_ELR0_RSV_MASK),
	    (unsigned int)(PMIC_BM_TOP_ELR0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fganalogtest_3_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FGANALOGTEST_3_1_MASK),
	    (unsigned int)(PMIC_RG_FGANALOGTEST_3_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fgintmode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_FGINTMODE_MASK),
				    (unsigned int)(PMIC_RG_FGINTMODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_spare(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_SPARE_MASK),
				    (unsigned int)(PMIC_RG_SPARE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fgadc_ana_test_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_ANA_TEST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_FGADC_ANA_TEST_CON0_RSV_MASK),
	    (unsigned int)(PMIC_FGADC_ANA_TEST_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rng_bit_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_ANA_TEST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_RNG_BIT_MODE_MASK),
	    (unsigned int)(PMIC_FG_RNG_BIT_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rng_bit_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_ANA_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_RNG_BIT_SW_MASK),
				    (unsigned int)(PMIC_FG_RNG_BIT_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rng_en_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_ANA_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_RNG_EN_MODE_MASK),
				    (unsigned int)(PMIC_FG_RNG_EN_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rng_en_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_ANA_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_RNG_EN_SW_MASK),
				    (unsigned int)(PMIC_FG_RNG_EN_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_dwa_t0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_ANA_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_DWA_T0_MASK),
				    (unsigned int)(PMIC_FG_DWA_T0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_dwa_t1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_ANA_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_DWA_T1_MASK),
				    (unsigned int)(PMIC_FG_DWA_T1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_dwa_rst_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_ANA_TEST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_DWA_RST_MODE_MASK),
	    (unsigned int)(PMIC_FG_DWA_RST_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_dwa_rst_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_ANA_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_DWA_RST_SW_MASK),
				    (unsigned int)(PMIC_FG_DWA_RST_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_dwa_rst(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_ANA_TEST_CON0),
				  (&val), (unsigned int)(PMIC_FG_DWA_RST_MASK),
				  (unsigned int)(PMIC_FG_DWA_RST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_fgadc_gainerror_cal(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_ANA_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FGADC_GAINERROR_CAL_MASK),
	    (unsigned int)(PMIC_RG_FGADC_GAINERROR_CAL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_fg_offset_swap(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_ANA_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_FG_OFFSET_SWAP_MASK),
	    (unsigned int)(PMIC_RG_FG_OFFSET_SWAP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_on(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_ON_MASK), (unsigned int)(PMIC_FG_ON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_cal(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_CAL_MASK),
				    (unsigned int)(PMIC_FG_CAL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_autocalrate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_AUTOCALRATE_MASK),
				    (unsigned int)(PMIC_FG_AUTOCALRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_son_slp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_SON_SLP_EN_MASK),
				    (unsigned int)(PMIC_FG_SON_SLP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_soff_slp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_SOFF_SLP_EN_MASK),
				    (unsigned int)(PMIC_FG_SOFF_SLP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_zcv_det_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_ZCV_DET_EN_MASK),
				    (unsigned int)(PMIC_FG_ZCV_DET_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_auxadc_r(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_AUXADC_R_MASK),
				    (unsigned int)(PMIC_FG_AUXADC_R_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_iavg_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_IAVG_MODE_MASK),
				    (unsigned int)(PMIC_FG_IAVG_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_sw_read_pre(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_SW_READ_PRE_MASK),
				    (unsigned int)(PMIC_FG_SW_READ_PRE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_sw_rstclr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_SW_RSTCLR_MASK),
				    (unsigned int)(PMIC_FG_SW_RSTCLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_sw_cr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_SW_CR_MASK),
				    (unsigned int)(PMIC_FG_SW_CR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_sw_clear(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_SW_CLEAR_MASK),
				    (unsigned int)(PMIC_FG_SW_CLEAR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_offset_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_OFFSET_RST_MASK),
				    (unsigned int)(PMIC_FG_OFFSET_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_time_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_TIME_RST_MASK),
				    (unsigned int)(PMIC_FG_TIME_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_charge_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_CHARGE_RST_MASK),
				    (unsigned int)(PMIC_FG_CHARGE_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_n_charge_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_N_CHARGE_RST_MASK),
	    (unsigned int)(PMIC_FG_N_CHARGE_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_soff_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_SOFF_RST_MASK),
				    (unsigned int)(PMIC_FG_SOFF_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_latchdata_st(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON1), (&val),
				  (unsigned int)(PMIC_FG_LATCHDATA_ST_MASK),
				  (unsigned int)(PMIC_FG_LATCHDATA_ST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_bat0_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_BAT0_L_MASK),
				  (unsigned int)(PMIC_EVENT_FG_BAT0_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_bat0_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_BAT0_H_MASK),
				  (unsigned int)(PMIC_EVENT_FG_BAT0_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_bat1_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_BAT1_L_MASK),
				  (unsigned int)(PMIC_EVENT_FG_BAT1_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_bat1_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_BAT1_H_MASK),
				  (unsigned int)(PMIC_EVENT_FG_BAT1_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_cur_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_CUR_L_MASK),
				  (unsigned int)(PMIC_EVENT_FG_CUR_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_cur_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_CUR_H_MASK),
				  (unsigned int)(PMIC_EVENT_FG_CUR_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_iavg_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_IAVG_L_MASK),
				  (unsigned int)(PMIC_EVENT_FG_IAVG_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_iavg_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_IAVG_H_MASK),
				  (unsigned int)(PMIC_EVENT_FG_IAVG_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_n_charge_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_FGADC_CON2), (&val),
	    (unsigned int)(PMIC_EVENT_FG_N_CHARGE_L_MASK),
	    (unsigned int)(PMIC_EVENT_FG_N_CHARGE_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_time_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_TIME_H_MASK),
				  (unsigned int)(PMIC_EVENT_FG_TIME_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_discharge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				(unsigned int)(PMIC_EVENT_FG_DISCHARGE_MASK),
				(unsigned int)(PMIC_EVENT_FG_DISCHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_charge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_CHARGE_MASK),
				  (unsigned int)(PMIC_EVENT_FG_CHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_event_fg_zcv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON2), (&val),
				  (unsigned int)(PMIC_EVENT_FG_ZCV_MASK),
				  (unsigned int)(PMIC_EVENT_FG_ZCV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_osr1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_OSR1_MASK),
				    (unsigned int)(PMIC_FG_OSR1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_osr2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_OSR2_MASK),
				    (unsigned int)(PMIC_FG_OSR2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_fir1bypass(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_FIR1BYPASS_MASK),
				    (unsigned int)(PMIC_FG_FIR1BYPASS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_fir2bypass(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_FIR2BYPASS_MASK),
				    (unsigned int)(PMIC_FG_FIR2BYPASS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_adj_offset_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_ADJ_OFFSET_EN_MASK),
	    (unsigned int)(PMIC_FG_ADJ_OFFSET_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_adc_autorst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_ADC_AUTORST_MASK),
				    (unsigned int)(PMIC_FG_ADC_AUTORST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_adc_rstdetect(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CON4), (&val),
				  (unsigned int)(PMIC_FG_ADC_RSTDETECT_MASK),
				  (unsigned int)(PMIC_FG_ADC_RSTDETECT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_va18_aon(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_VA18_AON_MASK),
				    (unsigned int)(PMIC_FG_VA18_AON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_va18_aoff(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_VA18_AOFF_MASK),
				    (unsigned int)(PMIC_FG_VA18_AOFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_son_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_SON_SW_MASK),
				    (unsigned int)(PMIC_FG_SON_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_son_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_SON_SW_MODE_MASK),
				    (unsigned int)(PMIC_FG_SON_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fgadc_con4_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FGADC_CON4_RSV_MASK),
				    (unsigned int)(PMIC_FGADC_CON4_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rstb_status(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_RSTB_STATUS_MASK),
				    (unsigned int)(PMIC_FG_RSTB_STATUS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_r_curr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_R_CON0), (&val),
				  (unsigned int)(PMIC_FG_R_CURR_MASK),
				  (unsigned int)(PMIC_FG_R_CURR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_current_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_CUR_CON0), (&val),
				(unsigned int)(PMIC_FG_CURRENT_OUT_MASK),
				(unsigned int)(PMIC_FG_CURRENT_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_cur_lth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CUR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_CUR_LTH_MASK),
				    (unsigned int)(PMIC_FG_CUR_LTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_cur_hth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_CUR_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_CUR_HTH_MASK),
				    (unsigned int)(PMIC_FG_CUR_HTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_cic2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_CUR_CON3),
				  (&val), (unsigned int)(PMIC_FG_CIC2_MASK),
				  (unsigned int)(PMIC_FG_CIC2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_car_31_16(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_CAR_CON0), (&val),
				(unsigned int)(PMIC_FG_CAR_31_16_MASK),
				(unsigned int)(PMIC_FG_CAR_31_16_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_car_15_00(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_CAR_CON1), (&val),
				(unsigned int)(PMIC_FG_CAR_15_00_MASK),
				(unsigned int)(PMIC_FG_CAR_15_00_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_bat0_lth_31_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CAR_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_BAT0_LTH_31_16_MASK),
	    (unsigned int)(PMIC_FG_BAT0_LTH_31_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_bat0_lth_15_14(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CAR_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_BAT0_LTH_15_14_MASK),
	    (unsigned int)(PMIC_FG_BAT0_LTH_15_14_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_bat0_hth_31_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CAR_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_BAT0_HTH_31_16_MASK),
	    (unsigned int)(PMIC_FG_BAT0_HTH_31_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_bat0_hth_15_14(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CAR_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_BAT0_HTH_15_14_MASK),
	    (unsigned int)(PMIC_FG_BAT0_HTH_15_14_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_bat1_lth_31_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CAR_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_BAT1_LTH_31_16_MASK),
	    (unsigned int)(PMIC_FG_BAT1_LTH_31_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_bat1_lth_15_14(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CAR_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_BAT1_LTH_15_14_MASK),
	    (unsigned int)(PMIC_FG_BAT1_LTH_15_14_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_bat1_hth_31_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CAR_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_BAT1_HTH_31_16_MASK),
	    (unsigned int)(PMIC_FG_BAT1_HTH_31_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_bat1_hth_15_14(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_CAR_CON9), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_BAT1_HTH_15_14_MASK),
	    (unsigned int)(PMIC_FG_BAT1_HTH_15_14_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_ncar_31_16(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_NCAR_CON0), (&val),
				(unsigned int)(PMIC_FG_NCAR_31_16_MASK),
				(unsigned int)(PMIC_FG_NCAR_31_16_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_ncar_15_00(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_NCAR_CON1), (&val),
				(unsigned int)(PMIC_FG_NCAR_15_00_MASK),
				(unsigned int)(PMIC_FG_NCAR_15_00_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_n_charge_lth_31_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_NCAR_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_N_CHARGE_LTH_31_16_MASK),
	    (unsigned int)(PMIC_FG_N_CHARGE_LTH_31_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_n_charge_lth_15_14(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_NCAR_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_N_CHARGE_LTH_15_14_MASK),
	    (unsigned int)(PMIC_FG_N_CHARGE_LTH_15_14_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_iavg_27_16(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_IAVG_CON0), (&val),
				(unsigned int)(PMIC_FG_IAVG_27_16_MASK),
				(unsigned int)(PMIC_FG_IAVG_27_16_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_iavg_vld(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_IAVG_CON0), (&val),
				(unsigned int)(PMIC_FG_IAVG_VLD_MASK),
				(unsigned int)(PMIC_FG_IAVG_VLD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_iavg_15_00(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_IAVG_CON1), (&val),
				(unsigned int)(PMIC_FG_IAVG_15_00_MASK),
				(unsigned int)(PMIC_FG_IAVG_15_00_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_iavg_lth_28_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_IAVG_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_IAVG_LTH_28_16_MASK),
	    (unsigned int)(PMIC_FG_IAVG_LTH_28_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_iavg_lth_15_00(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_IAVG_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_IAVG_LTH_15_00_MASK),
	    (unsigned int)(PMIC_FG_IAVG_LTH_15_00_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_iavg_hth_28_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_IAVG_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_IAVG_HTH_28_16_MASK),
	    (unsigned int)(PMIC_FG_IAVG_HTH_28_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_iavg_hth_15_00(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_IAVG_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_IAVG_HTH_15_00_MASK),
	    (unsigned int)(PMIC_FG_IAVG_HTH_15_00_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_nter_29_16(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_NTER_CON0), (&val),
				(unsigned int)(PMIC_FG_NTER_29_16_MASK),
				(unsigned int)(PMIC_FG_NTER_29_16_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_nter_15_00(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_NTER_CON1), (&val),
				(unsigned int)(PMIC_FG_NTER_15_00_MASK),
				(unsigned int)(PMIC_FG_NTER_15_00_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_time_hth_29_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_NTER_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_TIME_HTH_29_16_MASK),
	    (unsigned int)(PMIC_FG_TIME_HTH_29_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_time_hth_15_00(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_NTER_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_TIME_HTH_15_00_MASK),
	    (unsigned int)(PMIC_FG_TIME_HTH_15_00_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_offset(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_OFFSET_CON0),
				  (&val), (unsigned int)(PMIC_FG_OFFSET_MASK),
				  (unsigned int)(PMIC_FG_OFFSET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_adjust_offset_value(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_OFFSET_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_ADJUST_OFFSET_VALUE_MASK),
	    (unsigned int)(PMIC_FG_ADJUST_OFFSET_VALUE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_gain(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_GAIN_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_GAIN_MASK),
				    (unsigned int)(PMIC_FG_GAIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_son_slp_cur_th(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_SON_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_SON_SLP_CUR_TH_MASK),
	    (unsigned int)(PMIC_FG_SON_SLP_CUR_TH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_son_slp_time(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_SON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_SON_SLP_TIME_MASK),
	    (unsigned int)(PMIC_FG_SON_SLP_TIME_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_son_det_time(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_SON_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_SON_DET_TIME_MASK),
	    (unsigned int)(PMIC_FG_SON_DET_TIME_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_fp_ftime(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_SON_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_FP_FTIME_MASK),
				    (unsigned int)(PMIC_FG_FP_FTIME_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_soff_slp_cur_th(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_SOFF_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_SOFF_SLP_CUR_TH_MASK),
	    (unsigned int)(PMIC_FG_SOFF_SLP_CUR_TH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_soff_slp_time(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_SOFF_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_SOFF_SLP_TIME_MASK),
	    (unsigned int)(PMIC_FG_SOFF_SLP_TIME_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_soff_det_time(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_SOFF_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_SOFF_DET_TIME_MASK),
	    (unsigned int)(PMIC_FG_SOFF_DET_TIME_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_soff_time_29_16(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_SOFF_CON3), (&val),
				(unsigned int)(PMIC_FG_SOFF_TIME_29_16_MASK),
				(unsigned int)(PMIC_FG_SOFF_TIME_29_16_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_soff(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_FGADC_SOFF_CON3),
				  (&val), (unsigned int)(PMIC_FG_SOFF_MASK),
				  (unsigned int)(PMIC_FG_SOFF_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_soff_time_15_00(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_SOFF_CON4), (&val),
				(unsigned int)(PMIC_FG_SOFF_TIME_15_00_MASK),
				(unsigned int)(PMIC_FG_SOFF_TIME_15_00_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_pwr_time0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_PWR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_PWR_TIME0_MASK),
				    (unsigned int)(PMIC_FG_PWR_TIME0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_pwr_time1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_PWR_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_PWR_TIME1_MASK),
				    (unsigned int)(PMIC_FG_PWR_TIME1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_pwr_time2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_PWR_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_PWR_TIME2_MASK),
				    (unsigned int)(PMIC_FG_PWR_TIME2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_zcv_det_iv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_ZCV_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_ZCV_DET_IV_MASK),
				    (unsigned int)(PMIC_FG_ZCV_DET_IV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_zcv_car_th_30_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_ZCV_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_ZCV_CAR_TH_30_16_MASK),
	    (unsigned int)(PMIC_FG_ZCV_CAR_TH_30_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_zcv_car_th_15_00(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_ZCV_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_ZCV_CAR_TH_15_00_MASK),
	    (unsigned int)(PMIC_FG_ZCV_CAR_TH_15_00_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_fg_zcv_car_31_16(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_ZCV_CON3), (&val),
				(unsigned int)(PMIC_FG_ZCV_CAR_31_16_MASK),
				(unsigned int)(PMIC_FG_ZCV_CAR_31_16_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_zcv_car_15_00(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_ZCV_CON4), (&val),
				(unsigned int)(PMIC_FG_ZCV_CAR_15_00_MASK),
				(unsigned int)(PMIC_FG_ZCV_CAR_15_00_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_fg_zcv_curr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_FGADC_ZCV_CON5), (&val),
				(unsigned int)(PMIC_FG_ZCV_CURR_MASK),
				(unsigned int)(PMIC_FG_ZCV_CURR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_fg_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_MODE_MASK),
				    (unsigned int)(PMIC_FG_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rst_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_RST_SW_MASK),
				    (unsigned int)(PMIC_FG_RST_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_fgcal_en_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_FGCAL_EN_SW_MASK),
				    (unsigned int)(PMIC_FG_FGCAL_EN_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_fgadc_en_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_FGADC_TEST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FG_FGADC_EN_SW_MASK),
				    (unsigned int)(PMIC_FG_FGADC_EN_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fgadc_test_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_TEST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_FGADC_TEST_CON0_RSV_MASK),
	    (unsigned int)(PMIC_FGADC_TEST_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rsv_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_RSV_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_RSV_CON0_RSV_MASK),
	    (unsigned int)(PMIC_FG_RSV_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rsv_con1_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_RSV_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_RSV_CON1_RSV_MASK),
	    (unsigned int)(PMIC_FG_RSV_CON1_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rsv_con2_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_RSV_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_RSV_CON2_RSV_MASK),
	    (unsigned int)(PMIC_FG_RSV_CON2_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_fg_rsv_con3_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_FGADC_RSV_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_FG_RSV_CON3_RSV_MASK),
	    (unsigned int)(PMIC_FG_RSV_CON3_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_system_info_con0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SYSTEM_INFO_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON0_MASK),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_system_info_con1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SYSTEM_INFO_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON1_MASK),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_system_info_con2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SYSTEM_INFO_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON2_MASK),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_system_info_con3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SYSTEM_INFO_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON3_MASK),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_system_info_con4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SYSTEM_INFO_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON4_MASK),
	    (unsigned int)(PMIC_RG_SYSTEM_INFO_CON4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BATON_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BATON_EN_MASK),
				    (unsigned int)(PMIC_RG_BATON_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_baton_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BATON_ANA_CON0), (&val),
				(unsigned int)(PMIC_RG_BATON_EN_MASK),
				(unsigned int)(PMIC_RG_BATON_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_baton_undet(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BATON_ANA_CON0), (&val),
				(unsigned int)(PMIC_RGS_BATON_UNDET_MASK),
				(unsigned int)(PMIC_RGS_BATON_UNDET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_baton_lt_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BATON_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BATON_LT_EN_MASK),
				    (unsigned int)(PMIC_RG_BATON_LT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_baton_lt_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BATON_ANA_CON0), (&val),
				(unsigned int)(PMIC_RG_BATON_LT_EN_MASK),
				(unsigned int)(PMIC_RG_BATON_LT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_baton_ht_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BATON_ANA_MON0), (&val),
				(unsigned int)(PMIC_DA_BATON_HT_EN_MASK),
				(unsigned int)(PMIC_DA_BATON_HT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_bif_tx_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_ANA_MON0), (&val),
				  (unsigned int)(PMIC_DA_BIF_TX_EN_MASK),
				  (unsigned int)(PMIC_DA_BIF_TX_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_bif_tx_data(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_ANA_MON0), (&val),
				  (unsigned int)(PMIC_DA_BIF_TX_DATA_MASK),
				  (unsigned int)(PMIC_DA_BIF_TX_DATA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_bif_rx_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_ANA_MON0), (&val),
				  (unsigned int)(PMIC_DA_BIF_RX_EN_MASK),
				  (unsigned int)(PMIC_DA_BIF_RX_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_ad_bif_rx_data(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_ANA_MON0), (&val),
				  (unsigned int)(PMIC_AD_BIF_RX_DATA_MASK),
				  (unsigned int)(PMIC_AD_BIF_RX_DATA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_baton_debounce_wnd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_DEBOUNCE_WND_MASK),
	    (unsigned int)(PMIC_RG_BATON_DEBOUNCE_WND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_debounce_thd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_DEBOUNCE_THD_MASK),
	    (unsigned int)(PMIC_RG_BATON_DEBOUNCE_THD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_chrdet_test_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_CHRDET_TEST_MODE_MASK),
	    (unsigned int)(PMIC_RG_BATON_CHRDET_TEST_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_undet_test_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_UNDET_TEST_MODE_MASK),
	    (unsigned int)(PMIC_RG_BATON_UNDET_TEST_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_auxadc_test_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_AUXADC_TEST_MODE_MASK),
	    (unsigned int)(PMIC_RG_BATON_AUXADC_TEST_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_fgadc_test_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_FGADC_TEST_MODE_MASK),
	    (unsigned int)(PMIC_RG_BATON_FGADC_TEST_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_rtc_test_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_RTC_TEST_MODE_MASK),
	    (unsigned int)(PMIC_RG_BATON_RTC_TEST_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_bif_test_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_BIF_TEST_MODE_MASK),
	    (unsigned int)(PMIC_RG_BATON_BIF_TEST_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BATON_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BATON_RSV_MASK),
				    (unsigned int)(PMIC_RG_BATON_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_chrdet_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_CHRDET_SW_MASK),
	    (unsigned int)(PMIC_RG_BATON_CHRDET_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_undet_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_UNDET_SW_MASK),
	    (unsigned int)(PMIC_RG_BATON_UNDET_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_auxadc_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_AUXADC_SW_MASK),
	    (unsigned int)(PMIC_RG_BATON_AUXADC_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_fgadc_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_FGADC_SW_MASK),
	    (unsigned int)(PMIC_RG_BATON_FGADC_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_rtc_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_RTC_SW_MASK),
	    (unsigned int)(PMIC_RG_BATON_RTC_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_bif_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_BIF_SW_MASK),
	    (unsigned int)(PMIC_RG_BATON_BIF_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_rsv_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_RSV_SW_MASK),
	    (unsigned int)(PMIC_RG_BATON_RSV_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_baton_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_STATUS_MASK),
				  (unsigned int)(PMIC_BATON_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_auxadc_set(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_AUXADC_SET_MASK),
				  (unsigned int)(PMIC_BATON_AUXADC_SET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_deb_valid(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_DEB_VALID_MASK),
				  (unsigned int)(PMIC_BATON_DEB_VALID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_bif_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_BIF_STATUS_MASK),
				  (unsigned int)(PMIC_BATON_BIF_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_rtc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_RTC_STATUS_MASK),
				  (unsigned int)(PMIC_BATON_RTC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_fgadc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				(unsigned int)(PMIC_BATON_FGADC_STATUS_MASK),
				(unsigned int)(PMIC_BATON_FGADC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_auxadc_trig(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				(unsigned int)(PMIC_BATON_AUXADC_TRIG_MASK),
				(unsigned int)(PMIC_BATON_AUXADC_TRIG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_chrdet_deb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_CHRDET_DEB_MASK),
				  (unsigned int)(PMIC_BATON_CHRDET_DEB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_ivgen_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_IVGEN_ENB_MASK),
				  (unsigned int)(PMIC_BATON_IVGEN_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_vbif28_stb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_VBIF28_STB_MASK),
				  (unsigned int)(PMIC_BATON_VBIF28_STB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_vbif28_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_VBIF28_EN_MASK),
				  (unsigned int)(PMIC_BATON_VBIF28_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_baton_rsv_0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BATON_CON2), (&val),
				  (unsigned int)(PMIC_BATON_RSV_0_MASK),
				  (unsigned int)(PMIC_BATON_RSV_0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_baton_pwr_time0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_PWR_TIME0_MASK),
	    (unsigned int)(PMIC_RG_BATON_PWR_TIME0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_pwr_time1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_PWR_TIME1_MASK),
	    (unsigned int)(PMIC_RG_BATON_PWR_TIME1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_baton_chrdet_deb_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BATON_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_CHRDET_DEB_TD_MASK),
	    (unsigned int)(PMIC_RG_BATON_CHRDET_DEB_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_0_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_1_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_2_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_3_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_4_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_5(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_5_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_5_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_6(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON6),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_6_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_6_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_7(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON7),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_7_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_7_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_8(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON8),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_8_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_8_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_9(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON9),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_9_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_9_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_10(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON10),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_10_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_10_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_11(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON11),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_11_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_11_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_12(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON12),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_12_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_12_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_13(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON13),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_13_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_13_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_14(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON14),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_COMMAND_14_MASK),
				    (unsigned int)(PMIC_BIF_COMMAND_14_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON15),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_RSV_MASK),
				    (unsigned int)(PMIC_BIF_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_command_type(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_COMMAND_TYPE_MASK),
	    (unsigned int)(PMIC_BIF_COMMAND_TYPE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_trasfer_num(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_TRASFER_NUM_MASK),
	    (unsigned int)(PMIC_BIF_TRASFER_NUM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_logic_0_set(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_LOGIC_0_SET_MASK),
	    (unsigned int)(PMIC_BIF_LOGIC_0_SET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_logic_1_set(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_LOGIC_1_SET_MASK),
	    (unsigned int)(PMIC_BIF_LOGIC_1_SET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_stop_set(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON16),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_STOP_SET_MASK),
				    (unsigned int)(PMIC_BIF_STOP_SET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_debounce_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_DEBOUNCE_EN_MASK),
	    (unsigned int)(PMIC_BIF_DEBOUNCE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_read_expect_num(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_READ_EXPECT_NUM_MASK),
	    (unsigned int)(PMIC_BIF_READ_EXPECT_NUM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_trasact_trigger(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_TRASACT_TRIGGER_MASK),
	    (unsigned int)(PMIC_BIF_TRASACT_TRIGGER_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_bif_data_num(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON19), (&val),
				  (unsigned int)(PMIC_BIF_DATA_NUM_MASK),
				  (unsigned int)(PMIC_BIF_DATA_NUM_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_response(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON19), (&val),
				  (unsigned int)(PMIC_BIF_RESPONSE_MASK),
				  (unsigned int)(PMIC_BIF_RESPONSE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON20), (&val),
				  (unsigned int)(PMIC_BIF_DATA_0_MASK),
				  (unsigned int)(PMIC_BIF_DATA_0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON20), (&val),
				  (unsigned int)(PMIC_BIF_ACK_0_MASK),
				  (unsigned int)(PMIC_BIF_ACK_0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON20), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_0_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON21), (&val),
				  (unsigned int)(PMIC_BIF_DATA_1_MASK),
				  (unsigned int)(PMIC_BIF_DATA_1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON21), (&val),
				  (unsigned int)(PMIC_BIF_ACK_1_MASK),
				  (unsigned int)(PMIC_BIF_ACK_1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON21), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_1_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON22), (&val),
				  (unsigned int)(PMIC_BIF_DATA_2_MASK),
				  (unsigned int)(PMIC_BIF_DATA_2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON22), (&val),
				  (unsigned int)(PMIC_BIF_ACK_2_MASK),
				  (unsigned int)(PMIC_BIF_ACK_2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON22), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_2_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_3(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON23), (&val),
				  (unsigned int)(PMIC_BIF_DATA_3_MASK),
				  (unsigned int)(PMIC_BIF_DATA_3_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_3(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON23), (&val),
				  (unsigned int)(PMIC_BIF_ACK_3_MASK),
				  (unsigned int)(PMIC_BIF_ACK_3_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_3(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON23), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_3_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_3_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_4(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON24), (&val),
				  (unsigned int)(PMIC_BIF_DATA_4_MASK),
				  (unsigned int)(PMIC_BIF_DATA_4_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_4(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON24), (&val),
				  (unsigned int)(PMIC_BIF_ACK_4_MASK),
				  (unsigned int)(PMIC_BIF_ACK_4_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_4(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON24), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_4_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_4_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_5(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON25), (&val),
				  (unsigned int)(PMIC_BIF_DATA_5_MASK),
				  (unsigned int)(PMIC_BIF_DATA_5_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_5(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON25), (&val),
				  (unsigned int)(PMIC_BIF_ACK_5_MASK),
				  (unsigned int)(PMIC_BIF_ACK_5_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_5(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON25), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_5_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_5_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_6(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON26), (&val),
				  (unsigned int)(PMIC_BIF_DATA_6_MASK),
				  (unsigned int)(PMIC_BIF_DATA_6_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_6(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON26), (&val),
				  (unsigned int)(PMIC_BIF_ACK_6_MASK),
				  (unsigned int)(PMIC_BIF_ACK_6_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_6(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON26), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_6_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_6_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_7(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON27), (&val),
				  (unsigned int)(PMIC_BIF_DATA_7_MASK),
				  (unsigned int)(PMIC_BIF_DATA_7_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_7(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON27), (&val),
				  (unsigned int)(PMIC_BIF_ACK_7_MASK),
				  (unsigned int)(PMIC_BIF_ACK_7_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_7(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON27), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_7_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_7_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_8(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON28), (&val),
				  (unsigned int)(PMIC_BIF_DATA_8_MASK),
				  (unsigned int)(PMIC_BIF_DATA_8_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_8(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON28), (&val),
				  (unsigned int)(PMIC_BIF_ACK_8_MASK),
				  (unsigned int)(PMIC_BIF_ACK_8_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_8(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON28), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_8_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_8_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_data_9(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON29), (&val),
				  (unsigned int)(PMIC_BIF_DATA_9_MASK),
				  (unsigned int)(PMIC_BIF_DATA_9_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_ack_9(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON29), (&val),
				  (unsigned int)(PMIC_BIF_ACK_9_MASK),
				  (unsigned int)(PMIC_BIF_ACK_9_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_error_9(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON29), (&val),
				  (unsigned int)(PMIC_BIF_ERROR_9_MASK),
				  (unsigned int)(PMIC_BIF_ERROR_9_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_bif_test_mode0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TEST_MODE0_MASK),
				    (unsigned int)(PMIC_BIF_TEST_MODE0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_test_mode1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TEST_MODE1_MASK),
				    (unsigned int)(PMIC_BIF_TEST_MODE1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_test_mode2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TEST_MODE2_MASK),
				    (unsigned int)(PMIC_BIF_TEST_MODE2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_test_mode3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TEST_MODE3_MASK),
				    (unsigned int)(PMIC_BIF_TEST_MODE3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_test_mode4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TEST_MODE4_MASK),
				    (unsigned int)(PMIC_BIF_TEST_MODE4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_test_mode5(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TEST_MODE5_MASK),
				    (unsigned int)(PMIC_BIF_TEST_MODE5_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_test_mode6(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TEST_MODE6_MASK),
				    (unsigned int)(PMIC_BIF_TEST_MODE6_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_test_mode7(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TEST_MODE7_MASK),
				    (unsigned int)(PMIC_BIF_TEST_MODE7_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_test_mode8(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TEST_MODE8_MASK),
				    (unsigned int)(PMIC_BIF_TEST_MODE8_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_bat_lost_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON30), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_BAT_LOST_SW_MASK),
	    (unsigned int)(PMIC_BIF_BAT_LOST_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_rx_data_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_RX_DATA_SW_MASK),
				    (unsigned int)(PMIC_BIF_RX_DATA_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_tx_data_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TX_DATA_SW_MASK),
				    (unsigned int)(PMIC_BIF_TX_DATA_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_rx_en_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_RX_EN_SW_MASK),
				    (unsigned int)(PMIC_BIF_RX_EN_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_tx_en_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON30),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_TX_EN_SW_MASK),
				    (unsigned int)(PMIC_BIF_TX_EN_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_back_normal(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON31), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_BACK_NORMAL_MASK),
	    (unsigned int)(PMIC_BIF_BACK_NORMAL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_irq_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON31),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_IRQ_CLR_MASK),
				    (unsigned int)(PMIC_BIF_IRQ_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_bif_irq(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON31), (&val),
				  (unsigned int)(PMIC_BIF_IRQ_MASK),
				  (unsigned int)(PMIC_BIF_IRQ_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_timeout(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON31), (&val),
				  (unsigned int)(PMIC_BIF_TIMEOUT_MASK),
				  (unsigned int)(PMIC_BIF_TIMEOUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_bat_undet(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON31), (&val),
				  (unsigned int)(PMIC_BIF_BAT_UNDET_MASK),
				  (unsigned int)(PMIC_BIF_BAT_UNDET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_total_valid(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON31), (&val),
				  (unsigned int)(PMIC_BIF_TOTAL_VALID_MASK),
				  (unsigned int)(PMIC_BIF_TOTAL_VALID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_bus_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON31), (&val),
				  (unsigned int)(PMIC_BIF_BUS_STATUS_MASK),
				  (unsigned int)(PMIC_BIF_BUS_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_bif_power_up_count(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON32), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_POWER_UP_COUNT_MASK),
	    (unsigned int)(PMIC_BIF_POWER_UP_COUNT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_power_up(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON32),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_POWER_UP_MASK),
				    (unsigned int)(PMIC_BIF_POWER_UP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_bif_rx_error_unknown(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BIF_CON33), (&val),
	    (unsigned int)(PMIC_BIF_RX_ERROR_UNKNOWN_MASK),
	    (unsigned int)(PMIC_BIF_RX_ERROR_UNKNOWN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_rx_error_insuff(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BIF_CON33), (&val),
	    (unsigned int)(PMIC_BIF_RX_ERROR_INSUFF_MASK),
	    (unsigned int)(PMIC_BIF_RX_ERROR_INSUFF_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_rx_error_lowphase(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BIF_CON33), (&val),
	    (unsigned int)(PMIC_BIF_RX_ERROR_LOWPHASE_MASK),
	    (unsigned int)(PMIC_BIF_RX_ERROR_LOWPHASE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_rx_state(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON33), (&val),
				  (unsigned int)(PMIC_BIF_RX_STATE_MASK),
				  (unsigned int)(PMIC_BIF_RX_STATE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_flow_ctl_state(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BIF_CON33), (&val),
				(unsigned int)(PMIC_BIF_FLOW_CTL_STATE_MASK),
				(unsigned int)(PMIC_BIF_FLOW_CTL_STATE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_tx_state(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON33), (&val),
				  (unsigned int)(PMIC_BIF_TX_STATE_MASK),
				  (unsigned int)(PMIC_BIF_TX_STATE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_tx_data_fianl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BIF_CON34), (&val),
				(unsigned int)(PMIC_BIF_TX_DATA_FIANL_MASK),
				(unsigned int)(PMIC_BIF_TX_DATA_FIANL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_rx_data_sampling(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BIF_CON35), (&val),
	    (unsigned int)(PMIC_BIF_RX_DATA_SAMPLING_MASK),
	    (unsigned int)(PMIC_BIF_RX_DATA_SAMPLING_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_bif_rx_data_recovery(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BIF_CON36), (&val),
	    (unsigned int)(PMIC_BIF_RX_DATA_RECOVERY_MASK),
	    (unsigned int)(PMIC_BIF_RX_DATA_RECOVERY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_baton_ht_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON36),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BATON_HT_EN_MASK),
				    (unsigned int)(PMIC_RG_BATON_HT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_baton_ht_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON36), (&val),
				  (unsigned int)(PMIC_RG_BATON_HT_EN_MASK),
				  (unsigned int)(PMIC_RG_BATON_HT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_baton_ht_en_dly_time(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON36), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BATON_HT_EN_DLY_TIME_MASK),
	    (unsigned int)(PMIC_RG_BATON_HT_EN_DLY_TIME_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_baton_ht_en_dly_time(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BIF_CON36), (&val),
	    (unsigned int)(PMIC_RG_BATON_HT_EN_DLY_TIME_MASK),
	    (unsigned int)(PMIC_RG_BATON_HT_EN_DLY_TIME_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_bif_timeout_set(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BIF_CON37), (unsigned int)(val),
	    (unsigned int)(PMIC_BIF_TIMEOUT_SET_MASK),
	    (unsigned int)(PMIC_BIF_TIMEOUT_SET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_rx_deg_wnd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON38),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_RX_DEG_WND_MASK),
				    (unsigned int)(PMIC_BIF_RX_DEG_WND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bif_rx_deg_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON38),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_RX_DEG_EN_MASK),
				    (unsigned int)(PMIC_BIF_RX_DEG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_bif_rsv1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BIF_CON39), (&val),
				  (unsigned int)(PMIC_BIF_RSV1_MASK),
				  (unsigned int)(PMIC_BIF_RSV1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_bif_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BIF_CON39),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BIF_RSV0_MASK),
				    (unsigned int)(PMIC_BIF_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_hk_top_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_HK_TOP_ID), (&val),
				  (unsigned int)(PMIC_HK_TOP_ANA_ID_MASK),
				  (unsigned int)(PMIC_HK_TOP_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_hk_top_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_HK_TOP_ID), (&val),
				  (unsigned int)(PMIC_HK_TOP_DIG_ID_MASK),
				  (unsigned int)(PMIC_HK_TOP_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_hk_top_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_REV0), (&val),
	    (unsigned int)(PMIC_HK_TOP_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_HK_TOP_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_hk_top_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_REV0), (&val),
	    (unsigned int)(PMIC_HK_TOP_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_HK_TOP_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_hk_top_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_REV0), (&val),
	    (unsigned int)(PMIC_HK_TOP_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_HK_TOP_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_hk_top_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_REV0), (&val),
	    (unsigned int)(PMIC_HK_TOP_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_HK_TOP_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_hk_top_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_REV1), (&val),
	    (unsigned int)(PMIC_HK_TOP_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_HK_TOP_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_hk_top_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_REV1), (&val),
	    (unsigned int)(PMIC_HK_TOP_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_HK_TOP_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_ao_1m_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_AO_1M_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_AO_1M_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_1m_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_1M_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_1M_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_1m_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_1M_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_1M_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_rng_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_RNG_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_RNG_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_rng_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_RNG_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_RNG_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_32k_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_32K_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_32K_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_32k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_32K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_32K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_1k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_1K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_1K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_ck_divsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_CK_DIVSEL_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_CK_DIVSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_intrp_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_CLK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_INTRP_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_INTRP_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_HK_TOP_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_AUXADC_RST_MASK),
				    (unsigned int)(PMIC_RG_AUXADC_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_reg_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_REG_RST_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_REG_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bank_hk_top_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BANK_HK_TOP_SWRST_MASK),
	    (unsigned int)(PMIC_BANK_HK_TOP_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bank_auxadc_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BANK_AUXADC_SWRST_MASK),
	    (unsigned int)(PMIC_BANK_AUXADC_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bank_auxadc_dig_1_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BANK_AUXADC_DIG_1_SWRST_MASK),
	    (unsigned int)(PMIC_BANK_AUXADC_DIG_1_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bank_auxadc_dig_2_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BANK_AUXADC_DIG_2_SWRST_MASK),
	    (unsigned int)(PMIC_BANK_AUXADC_DIG_2_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_en_thr_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_THR_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_THR_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_thr_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
				(unsigned int)(PMIC_RG_INT_EN_THR_H_MASK),
				(unsigned int)(PMIC_RG_INT_EN_THR_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_thr_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_THR_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_THR_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_thr_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
				(unsigned int)(PMIC_RG_INT_EN_THR_L_MASK),
				(unsigned int)(PMIC_RG_INT_EN_THR_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_bat_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_bat_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
				(unsigned int)(PMIC_RG_INT_EN_BAT_H_MASK),
				(unsigned int)(PMIC_RG_INT_EN_BAT_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_bat_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_bat_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
				(unsigned int)(PMIC_RG_INT_EN_BAT_L_MASK),
				(unsigned int)(PMIC_RG_INT_EN_BAT_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_bat2_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BAT2_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BAT2_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_bat2_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
				(unsigned int)(PMIC_RG_INT_EN_BAT2_H_MASK),
				(unsigned int)(PMIC_RG_INT_EN_BAT2_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_bat2_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BAT2_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BAT2_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_bat2_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
				(unsigned int)(PMIC_RG_INT_EN_BAT2_L_MASK),
				(unsigned int)(PMIC_RG_INT_EN_BAT2_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_bat_temp_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_TEMP_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_TEMP_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_bat_temp_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_TEMP_H_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_TEMP_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_bat_temp_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_TEMP_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_TEMP_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_bat_temp_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_TEMP_L_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_BAT_TEMP_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_auxadc_imp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_AUXADC_IMP_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_AUXADC_IMP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_auxadc_imp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_AUXADC_IMP_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_AUXADC_IMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_nag_c_dltv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_NAG_C_DLTV_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_NAG_C_DLTV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_nag_c_dltv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_NAG_C_DLTV_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_NAG_C_DLTV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_jeita_hot(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_HOT_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_HOT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_jeita_hot(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_HOT_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_HOT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_jeita_warm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_WARM_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_WARM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_jeita_warm(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_WARM_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_WARM_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_jeita_cool(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_COOL_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_COOL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_jeita_cool(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_COOL_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_COOL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_jeita_cold(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_COLD_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_COLD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_jeita_cold(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_COLD_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_JEITA_COLD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_typec_h_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_H_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_H_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_typec_h_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON1), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_H_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_H_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_typec_h_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_H_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_H_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_typec_h_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON1), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_H_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_H_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_typec_l_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_L_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_L_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_typec_l_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON1), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_L_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_L_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_typec_l_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_L_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_L_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_typec_l_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_CON1), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_L_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_TYPEC_L_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_mask_thr_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_THR_H_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_THR_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_thr_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_THR_L_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_THR_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_bat_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT_H_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_bat_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT_L_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_bat2_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT2_H_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT2_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_bat2_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT2_L_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT2_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_bat_temp_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT_TEMP_H_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT_TEMP_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_bat_temp_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT_TEMP_L_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_BAT_TEMP_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_auxadc_imp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_AUXADC_IMP_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_AUXADC_IMP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_nag_c_dltv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_NAG_C_DLTV_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_NAG_C_DLTV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_jeita_hot(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_JEITA_HOT_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_JEITA_HOT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_jeita_warm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_JEITA_WARM_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_JEITA_WARM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_jeita_cool(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_JEITA_COOL_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_JEITA_COOL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_jeita_cold(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_JEITA_COLD_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_JEITA_COLD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_typec_h_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_TYPEC_H_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_TYPEC_H_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_typec_h_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_TYPEC_H_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_TYPEC_H_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_typec_l_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_TYPEC_L_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_TYPEC_L_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_typec_l_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_MASK_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_TYPEC_L_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_TYPEC_L_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_status_thr_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_THR_H_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_THR_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_thr_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_THR_L_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_THR_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_bat_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT_H_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_bat_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT_L_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_bat2_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT2_H_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT2_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_bat2_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT2_L_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT2_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_bat_temp_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT_TEMP_H_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT_TEMP_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_bat_temp_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT_TEMP_L_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_BAT_TEMP_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_auxadc_imp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_AUXADC_IMP_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_AUXADC_IMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_nag_c_dltv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_NAG_C_DLTV_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_NAG_C_DLTV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_jeita_hot(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_JEITA_HOT_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_JEITA_HOT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_jeita_warm(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_JEITA_WARM_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_JEITA_WARM_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_jeita_cool(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_JEITA_COOL_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_JEITA_COOL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_jeita_cold(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_JEITA_COLD_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_JEITA_COLD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_typec_h_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_TYPEC_H_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_TYPEC_H_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_typec_h_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_TYPEC_H_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_TYPEC_H_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_typec_l_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_TYPEC_L_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_TYPEC_L_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_typec_l_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_TYPEC_L_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_TYPEC_L_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_thr_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_THR_H_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_THR_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_thr_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_THR_L_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_THR_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_bat_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT_H_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_bat_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT_L_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_bat2_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT2_H_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT2_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_bat2_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT2_L_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT2_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_bat_temp_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT_TEMP_H_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT_TEMP_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_bat_temp_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT_TEMP_L_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_BAT_TEMP_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_auxadc_imp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_AUXADC_IMP_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_AUXADC_IMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_nag_c_dltv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_NAG_C_DLTV_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_NAG_C_DLTV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_jeita_hot(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_JEITA_HOT_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_JEITA_HOT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_jeita_warm(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_JEITA_WARM_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_JEITA_WARM_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_jeita_cool(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_JEITA_COOL_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_JEITA_COOL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_jeita_cold(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_JEITA_COLD_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_JEITA_COLD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_typec_h_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_TYPEC_H_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_TYPEC_H_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_typec_h_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_TYPEC_H_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_TYPEC_H_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_typec_l_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_TYPEC_L_MAX_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_TYPEC_L_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_typec_l_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_HK_TOP_INT_RAW_STATUS1), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_TYPEC_L_MIN_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_TYPEC_L_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clk_mon_flag_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_MON_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLK_MON_FLAG_EN_MASK),
	    (unsigned int)(PMIC_RG_CLK_MON_FLAG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_clk_mon_flag_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_HK_TOP_MON_CON0), (&val),
				(unsigned int)(PMIC_RG_CLK_MON_FLAG_EN_MASK),
				(unsigned int)(PMIC_RG_CLK_MON_FLAG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_clk_mon_flag_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_MON_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_CLK_MON_FLAG_SEL_MASK),
	    (unsigned int)(PMIC_RG_CLK_MON_FLAG_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mon_flag_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_MON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MON_FLAG_EN_MASK),
	    (unsigned int)(PMIC_RG_INT_MON_FLAG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_mon_flag_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_HK_TOP_MON_CON1), (&val),
				(unsigned int)(PMIC_RG_INT_MON_FLAG_EN_MASK),
				(unsigned int)(PMIC_RG_INT_MON_FLAG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_mon_flag_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_MON_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MON_FLAG_SEL_MASK),
	    (unsigned int)(PMIC_RG_INT_MON_FLAG_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_hk_mon_flag_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_MON_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_HK_MON_FLAG_SEL_MASK),
	    (unsigned int)(PMIC_RG_HK_MON_FLAG_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_mon_flag_sel_auxadc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_HK_TOP_MON_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_MON_FLAG_SEL_AUXADC_MASK),
	    (unsigned int)(PMIC_RG_MON_FLAG_SEL_AUXADC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_ID), (&val),
				  (unsigned int)(PMIC_AUXADC_ANA_ID_MASK),
				  (unsigned int)(PMIC_AUXADC_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_ID), (&val),
				  (unsigned int)(PMIC_AUXADC_DIG_ID_MASK),
				  (unsigned int)(PMIC_AUXADC_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_REV1), (&val),
	    (unsigned int)(PMIC_AUXADC_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_REV1), (&val),
	    (unsigned int)(PMIC_AUXADC_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_cali(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_AUXADC_CALI_MASK),
				    (unsigned int)(PMIC_RG_AUXADC_CALI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_aux_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_AUX_RSV_MASK),
				    (unsigned int)(PMIC_RG_AUX_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vbuf_byp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBUF_BYP_MASK),
				    (unsigned int)(PMIC_RG_VBUF_BYP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vbuf_calen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBUF_CALEN_MASK),
				    (unsigned int)(PMIC_RG_VBUF_CALEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vbuf_exten(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VBUF_EXTEN_MASK),
				    (unsigned int)(PMIC_RG_VBUF_EXTEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_dig_1_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_ID), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_1_ANA_ID_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_1_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_1_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_ID), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_1_DIG_ID_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_1_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_1_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_1_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_1_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_1_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_1_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_1_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_1_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_1_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_1_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_1_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_1_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_1_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_1_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_REV1), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_1_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_1_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_1_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_REV1), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_1_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_1_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC0), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH0_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC0), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH0_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC1), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH1_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC1), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH1_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC2), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH2_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC2), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH2_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch3(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC3), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH3_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH3_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch3(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC3), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH3_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH3_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch4(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC4), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH4_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH4_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch4(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC4), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH4_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH4_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch5(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC5), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH5_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH5_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch5(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC5), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH5_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH5_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch6(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC6), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH6_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH6_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch6(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC6), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH6_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH6_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch7(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC7), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH7_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH7_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch7(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC7), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH7_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH7_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch8(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC8), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH8_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH8_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch8(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC8), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH8_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH8_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch9(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC9), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH9_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_CH9_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch9(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC9), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH9_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_CH9_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch10(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC10), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH10_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH10_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch10(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC10), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH10_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH10_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch11(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC11), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH11_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH11_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch11(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC11), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH11_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH11_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch12_15(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC12), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH12_15_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH12_15_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch12_15(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC12), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH12_15_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH12_15_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_thr_hw(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC13), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_THR_HW_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_THR_HW_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_thr_hw(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC13), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_THR_HW_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_THR_HW_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_lbat(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC14), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_LBAT_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_LBAT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_lbat(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC14), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_LBAT_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_LBAT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_lbat2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC15), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_LBAT2_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_LBAT2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_lbat2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC15), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_LBAT2_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_LBAT2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch7_by_gps(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC16), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch7_by_gps(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC16), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch7_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC17), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH7_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH7_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch7_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC17), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH7_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH7_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch7_by_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC18), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH7_BY_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH7_BY_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch7_by_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC18), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH7_BY_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH7_BY_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch4_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC19), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH4_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH4_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch4_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC19), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH4_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH4_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_pwron_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC20), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_PWRON_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_PWRON_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_pwron_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC20), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_PWRON_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_PWRON_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_pwron_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC21), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_PWRON_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_PWRON_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_pwron_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC21), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_PWRON_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_PWRON_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_wakeup_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC22), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_wakeup_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC22), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_wakeup_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC23), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_wakeup_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC23), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch0_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC24), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH0_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH0_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch0_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC24), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH0_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH0_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch0_by_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC25), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH0_BY_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH0_BY_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch0_by_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC25), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH0_BY_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH0_BY_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch1_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC26), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH1_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH1_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch1_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC26), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH1_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH1_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch1_by_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC27), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH1_BY_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH1_BY_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch1_by_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC27), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH1_BY_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH1_BY_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_bat_temp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC28), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_BAT_TEMP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_BAT_TEMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_bat_temp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC28), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BAT_TEMP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BAT_TEMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_fgadc_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC29), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_FGADC_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_FGADC_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_fgadc_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC29), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_FGADC_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_FGADC_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_fgadc_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC30), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_FGADC_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_FGADC_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_fgadc_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC30), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_FGADC_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_FGADC_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_bat_plugin_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC31), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_bat_plugin_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC31), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_bat_plugin_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC32), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_bat_plugin_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC32), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_imp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC33), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_IMP_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_IMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_imp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC33), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_IMP_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_IMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_imp_avg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC34), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_IMP_AVG_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_IMP_AVG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_imp_avg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC34), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_IMP_AVG_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_IMP_AVG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_raw(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC35), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_RAW_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_RAW_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_mdrt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC36), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_MDRT_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_MDRT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_mdrt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC36), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_MDRT_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_MDRT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_jeita(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC37), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_JEITA_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_JEITA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_jeita(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC37), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_JEITA_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_JEITA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_dcxo_by_gps(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC38), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_dcxo_by_gps(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC38), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_dcxo_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC39), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_dcxo_by_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC39), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_dcxo_by_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC40), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_dcxo_by_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC40), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_dcxo_mdrt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC41), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_DCXO_MDRT_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_DCXO_MDRT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_dcxo_mdrt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC41), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_DCXO_MDRT_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_DCXO_MDRT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_nag(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC42), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_NAG_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_OUT_NAG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_nag(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ADC42), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_NAG_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_RDY_NAG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_batid(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC43), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_BATID_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_BATID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_batid(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC43), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BATID_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BATID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_typec_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC44), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_TYPEC_H_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_TYPEC_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_typec_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC44), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_TYPEC_H_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_TYPEC_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_typec_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC45), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_TYPEC_L_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_TYPEC_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_typec_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC45), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_TYPEC_L_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_TYPEC_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch4_by_thr1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC46), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH4_BY_THR1_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH4_BY_THR1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch4_by_thr1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC46), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH4_BY_THR1_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH4_BY_THR1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_out_ch4_by_thr2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC47), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH4_BY_THR2_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_OUT_CH4_BY_THR2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_rdy_ch4_by_thr2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ADC47), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH4_BY_THR2_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_CH4_BY_THR2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_STA0), (&val),
				(unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_MASK),
				(unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_lbat(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA0), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_LBAT_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_LBAT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_lbat2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA0), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_LBAT2_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_LBAT2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_bat_temp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA0), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_wakeup(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA0), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_dcxo_mdrt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_dcxo_gps_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_dcxo_gps_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_dcxo_gps(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_jeita(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_JEITA_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_JEITA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_mdrt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_MDRT_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_MDRT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_share(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_SHARE_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_SHARE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_imp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_IMP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_IMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_fgadc_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_fgadc_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_gps_ap(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_gps_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_gps(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_GPS_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_GPS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_thr_hw(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_THR_HW_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_THR_HW_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_thr_md(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA1), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_THR_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_THR_MD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_bat_plugin_pchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA2), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_bat_plugin_swchr(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA2), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_batid(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA2), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_BATID_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_BATID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_pwron(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA2), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_PWRON_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_PWRON_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_thr1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA2), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_THR1_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_THR1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_thr2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA2), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_THR2_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_THR2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_typec_h(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA2), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_TYPEC_H_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_TYPEC_H_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_typec_l(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA2), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_TYPEC_L_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_TYPEC_L_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_adc_busy_in_nag(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_STA2), (&val),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_NAG_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_BUSY_IN_NAG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH0_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH1_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH2_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH3_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH4_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch5(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH5_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH5_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch6(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH6_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH6_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch7(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH7_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH7_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch8(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH8_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH8_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch9(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH9_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH9_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch10(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH10_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH10_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch11(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH11_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH11_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch12(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH12_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH12_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch13(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH13_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH13_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch14(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH14_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH14_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch15(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH15_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH15_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch4_by_thr1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH4_BY_THR1_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH4_BY_THR1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch4_by_thr2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH4_BY_THR2_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH4_BY_THR2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch0_by_md(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH0_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH0_BY_MD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch1_by_md(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH1_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH1_BY_MD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_RSV0_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_batid(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_BATID_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_BATID_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch4_by_md(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH4_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH4_BY_MD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch7_by_md(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH7_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH7_BY_MD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_ch7_by_gps(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_CH7_BY_GPS_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_CH7_BY_GPS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_dcxo_by_md(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_DCXO_BY_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_DCXO_BY_MD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_dcxo_by_gps(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_DCXO_BY_GPS_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_DCXO_BY_GPS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rqst_rsv1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RQST1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RQST_RSV1_MASK),
	    (unsigned int)(PMIC_AUXADC_RQST_RSV1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ck_on_extd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_CK_ON_EXTD_MASK),
	    (unsigned int)(PMIC_AUXADC_CK_ON_EXTD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_srclken_src_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SRCLKEN_SRC_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_SRCLKEN_SRC_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adc_pwdb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADC_PWDB_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_PWDB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adc_pwdb_swctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADC_PWDB_SWCTRL_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_PWDB_SWCTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_strup_ck_on_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_STRUP_CK_ON_ENB_MASK),
	    (unsigned int)(PMIC_AUXADC_STRUP_CK_ON_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_srclken_ck_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SRCLKEN_CK_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_SRCLKEN_CK_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ck_aon_gps(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_CK_AON_GPS_MASK),
	    (unsigned int)(PMIC_AUXADC_CK_AON_GPS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ck_aon_md(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_CK_AON_MD_MASK),
	    (unsigned int)(PMIC_AUXADC_CK_AON_MD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ck_aon(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_CK_AON_MASK),
				    (unsigned int)(PMIC_AUXADC_CK_AON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_small(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SMALL_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SMALL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_large(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_LARGE_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_LARGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_SPL_NUM_MASK),
				    (unsigned int)(PMIC_AUXADC_SPL_NUM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_sel_share(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_SHARE_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_SHARE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_sel_lbat(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_LBAT_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_LBAT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_sel_bat_temp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_sel_wakeup(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_large(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_LARGE_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_LARGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_sleep(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SLEEP_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SLEEP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_sleep_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SLEEP_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SLEEP_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_sel_share(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_SHARE_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_SHARE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_sel_lbat(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_LBAT_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_LBAT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_sel_bat_temp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_sel_wakeup(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_ch0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON6), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_CH0_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_CH0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_ch3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_CH3_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_CH3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_spl_num_ch7(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_CH7_MASK),
	    (unsigned int)(PMIC_AUXADC_SPL_NUM_CH7_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_lbat(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON9), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_LBAT_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_LBAT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_ch7(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON9), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_CH7_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_CH7_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_ch3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON9), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_CH3_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_CH3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_ch0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON9), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_CH0_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_CH0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_hpc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON10), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_HPC_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_HPC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_avg_num_dcxo(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON10), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_DCXO_MASK),
	    (unsigned int)(PMIC_AUXADC_AVG_NUM_DCXO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch0_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH0_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH0_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch1_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH1_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH1_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch2_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH2_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH2_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch3_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH3_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH3_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch4_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH4_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH4_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch5_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH5_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH5_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch6_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH6_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH6_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch7_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH7_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH7_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch8_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH8_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH8_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch9_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH9_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH9_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch10_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH10_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH10_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_trim_ch11_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH11_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TRIM_CH11_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adc_2s_comp_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADC_2S_COMP_ENB_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_2S_COMP_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adc_trim_comp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON12), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADC_TRIM_COMP_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_TRIM_COMP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_rng_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_CON13),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_RNG_EN_MASK),
				    (unsigned int)(PMIC_AUXADC_RNG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_test_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TEST_MODE_MASK),
	    (unsigned int)(PMIC_AUXADC_TEST_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bit_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_CON13),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_BIT_SEL_MASK),
				    (unsigned int)(PMIC_AUXADC_BIT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_start_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_START_SW_MASK),
	    (unsigned int)(PMIC_AUXADC_START_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_start_swctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_START_SWCTRL_MASK),
	    (unsigned int)(PMIC_AUXADC_START_SWCTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ts_vbe_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TS_VBE_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_TS_VBE_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ts_vbe_sel_swctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TS_VBE_SEL_SWCTRL_MASK),
	    (unsigned int)(PMIC_AUXADC_TS_VBE_SEL_SWCTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_vbuf_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_CON13),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_VBUF_EN_MASK),
				    (unsigned int)(PMIC_AUXADC_VBUF_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_vbuf_en_swctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON13), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_VBUF_EN_SWCTRL_MASK),
	    (unsigned int)(PMIC_AUXADC_VBUF_EN_SWCTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_out_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_CON13),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_OUT_SEL_MASK),
				    (unsigned int)(PMIC_AUXADC_OUT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_da_dac(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_CON14),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_DA_DAC_MASK),
				    (unsigned int)(PMIC_AUXADC_DA_DAC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_da_dac_swctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON14), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DA_DAC_SWCTRL_MASK),
	    (unsigned int)(PMIC_AUXADC_DA_DAC_SWCTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_ad_auxadc_comp(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_CON14), (&val),
				  (unsigned int)(PMIC_AD_AUXADC_COMP_MASK),
				  (unsigned int)(PMIC_AD_AUXADC_COMP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_adcin_vsen_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADCIN_VSEN_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_ADCIN_VSEN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adcin_vbat_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADCIN_VBAT_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_ADCIN_VBAT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adcin_vsen_mux_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADCIN_VSEN_MUX_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_ADCIN_VSEN_MUX_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adcin_vsen_ext_baton_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adcin_chr_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADCIN_CHR_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_ADCIN_CHR_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adcin_baton_tdet_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADCIN_BATON_TDET_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_ADCIN_BATON_TDET_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_accdet_anaswctrl_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ACCDET_ANASWCTRL_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_ACCDET_ANASWCTRL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_xo_thadc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_XO_THADC_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_XO_THADC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adcin_batid_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADCIN_BATID_SW_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_ADCIN_BATID_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dig0_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DIG0_RSV0_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG0_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_chsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_CON15),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_CHSEL_MASK),
				    (unsigned int)(PMIC_AUXADC_CHSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_swctrl_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON15), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SWCTRL_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_SWCTRL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_source_lbat_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SOURCE_LBAT_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_SOURCE_LBAT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_source_lbat2_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SOURCE_LBAT2_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_SOURCE_LBAT2_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_start_extd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_START_EXTD_MASK),
	    (unsigned int)(PMIC_AUXADC_START_EXTD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dac_extd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DAC_EXTD_MASK),
	    (unsigned int)(PMIC_AUXADC_DAC_EXTD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dac_extd_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON16), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DAC_EXTD_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_DAC_EXTD_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_pmu_thr_pdn_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_PMU_THR_PDN_SW_MASK),
	    (unsigned int)(PMIC_AUXADC_PMU_THR_PDN_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_pmu_thr_pdn_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_PMU_THR_PDN_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_PMU_THR_PDN_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_pmu_thr_pdn_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_CON17), (&val),
	    (unsigned int)(PMIC_AUXADC_PMU_THR_PDN_STATUS_MASK),
	    (unsigned int)(PMIC_AUXADC_PMU_THR_PDN_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_dig0_rsv1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON17), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DIG0_RSV1_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG0_RSV1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_start_shade_num(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_START_SHADE_NUM_MASK),
	    (unsigned int)(PMIC_AUXADC_START_SHADE_NUM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_start_shade_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_START_SHADE_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_START_SHADE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_start_shade_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON18), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_START_SHADE_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_START_SHADE_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adc_rdy_wakeup_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON19), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adc_rdy_fgadc_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON19), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_FGADC_CLR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_FGADC_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adc_rdy_bat_plugin_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON19), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_adc_rdy_pwron_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON19), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_PWRON_CLR_MASK),
	    (unsigned int)(PMIC_AUXADC_ADC_RDY_PWRON_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_data_reuse_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON20), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DATA_REUSE_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_DATA_REUSE_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ch0_data_reuse_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON20), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_CH0_DATA_REUSE_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_CH0_DATA_REUSE_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ch1_data_reuse_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON20), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_CH1_DATA_REUSE_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_CH1_DATA_REUSE_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dcxo_data_reuse_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON20), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_DATA_REUSE_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_DATA_REUSE_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_data_reuse_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON20), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DATA_REUSE_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_DATA_REUSE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ch0_data_reuse_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON20), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_CH0_DATA_REUSE_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_CH0_DATA_REUSE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_ch1_data_reuse_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON20), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_CH1_DATA_REUSE_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_CH1_DATA_REUSE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dcxo_data_reuse_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CON20), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_DATA_REUSE_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_DATA_REUSE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_autorpt_prd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_AUTORPT0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AUTORPT_PRD_MASK),
	    (unsigned int)(PMIC_AUXADC_AUTORPT_PRD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_autorpt_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_AUTORPT0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_AUTORPT_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_AUTORPT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat_debt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_DEBT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_DEBT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat_debt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_DEBT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_DEBT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat_det_prd_15_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_DET_PRD_15_0_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_DET_PRD_15_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat_det_prd_19_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_DET_PRD_19_16_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_DET_PRD_19_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat_volt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_VOLT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_VOLT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat_irq_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_IRQ_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_IRQ_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_lbat_max_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT3), (&val),
	    (unsigned int)(PMIC_AUXADC_LBAT_MAX_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_MAX_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_lbat_volt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_VOLT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_VOLT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat_irq_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_IRQ_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_IRQ_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_lbat_min_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT4), (&val),
	    (unsigned int)(PMIC_AUXADC_LBAT_MIN_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_MIN_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_lbat_debounce_count_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT5), (&val),
	    (unsigned int)(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_lbat_debounce_count_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT6), (&val),
	    (unsigned int)(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_accdet_auto_spl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_ACCDET), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ACCDET_AUTO_SPL_MASK),
	    (unsigned int)(PMIC_AUXADC_ACCDET_AUTO_SPL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_accdet_auto_rqst_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_ACCDET), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_MASK),
	    (unsigned int)(PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_accdet_dig1_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_ACCDET), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ACCDET_DIG1_RSV0_MASK),
	    (unsigned int)(PMIC_AUXADC_ACCDET_DIG1_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_accdet_dig0_rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_ACCDET), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_ACCDET_DIG0_RSV0_MASK),
	    (unsigned int)(PMIC_AUXADC_ACCDET_DIG0_RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_sw_gain_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SW_GAIN_TRIM_MASK),
	    (unsigned int)(PMIC_AUXADC_SW_GAIN_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_sw_offset_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_1_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_SW_OFFSET_TRIM_MASK),
	    (unsigned int)(PMIC_AUXADC_SW_OFFSET_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_dig_2_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ID), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_2_ANA_ID_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_2_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_2_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ID), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_2_DIG_ID_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_2_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_2_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_2_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_2_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_2_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_2_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_2_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_2_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_2_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_2_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_2_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_REV0), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_2_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_2_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_2_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_REV1), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_2_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_2_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_dig_2_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_REV1), (&val),
	    (unsigned int)(PMIC_AUXADC_DIG_2_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_AUXADC_DIG_2_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_thr_debt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_DEBT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_DEBT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_thr_debt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_DEBT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_DEBT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_thr_det_prd_15_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_DET_PRD_15_0_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_DET_PRD_15_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_thr_det_prd_19_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_DET_PRD_19_16_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_DET_PRD_19_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_thr_volt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_VOLT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_VOLT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_thr_irq_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_IRQ_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_IRQ_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_thr_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_thr_max_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_THR3), (&val),
	    (unsigned int)(PMIC_AUXADC_THR_MAX_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_MAX_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_thr_volt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_VOLT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_VOLT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_thr_irq_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_IRQ_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_IRQ_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_thr_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_THR_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_thr_min_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_THR4), (&val),
	    (unsigned int)(PMIC_AUXADC_THR_MIN_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_MIN_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_thr_debounce_count_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_THR5), (&val),
	    (unsigned int)(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_thr_debounce_count_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_THR6), (&val),
	    (unsigned int)(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_fgadc_start_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DBG0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_FGADC_START_SW_MASK),
	    (unsigned int)(PMIC_AUXADC_FGADC_START_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_fgadc_start_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DBG0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_FGADC_START_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_FGADC_START_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_fgadc_r_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DBG0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_FGADC_R_SW_MASK),
	    (unsigned int)(PMIC_AUXADC_FGADC_R_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_fgadc_r_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DBG0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_FGADC_R_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_FGADC_R_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_plugin_start_sw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DBG0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_PLUGIN_START_SW_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_PLUGIN_START_SW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_plugin_start_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DBG0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_PLUGIN_START_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_PLUGIN_START_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dbg_dig0_rsv2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DBG0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DBG_DIG0_RSV2_MASK),
	    (unsigned int)(PMIC_AUXADC_DBG_DIG0_RSV2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dbg_dig1_rsv2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DBG0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DBG_DIG1_RSV2_MASK),
	    (unsigned int)(PMIC_AUXADC_DBG_DIG1_RSV2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_impedance_cnt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_IMP0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_CNT_MASK),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_CNT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_impedance_chsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_IMP0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_CHSEL_MASK),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_CHSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_impedance_irq_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_IMP0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_IRQ_CLR_MASK),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_IRQ_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_impedance_irq_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_IMP0), (&val),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_MASK),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_clr_imp_cnt_stop(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_IMP0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_CLR_IMP_CNT_STOP_MASK),
	    (unsigned int)(PMIC_AUXADC_CLR_IMP_CNT_STOP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_impedance_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_IMP0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_MODE_MASK),
	    (unsigned int)(PMIC_AUXADC_IMPEDANCE_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_imp_autorpt_prd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_IMP1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_IMP_AUTORPT_PRD_MASK),
	    (unsigned int)(PMIC_AUXADC_IMP_AUTORPT_PRD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_imp_autorpt_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_IMP1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_IMP_AUTORPT_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_IMP_AUTORPT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_froze_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_FROZE_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_FROZE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_debt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DEBT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DEBT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_debt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DEBT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DEBT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_det_prd_15_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_det_prd_19_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_volt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_VOLT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_VOLT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_irq_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_bat_temp_max_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_4), (&val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_volt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_VOLT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_VOLT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_irq_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_bat_temp_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_bat_temp_min_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_5), (&val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_bat_temp_debounce_count_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_6), (&val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_bat_temp_debounce_count_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_7), (&val),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_debt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DEBT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DEBT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_debt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DEBT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DEBT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_det_prd_15_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DET_PRD_15_0_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DET_PRD_15_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_det_prd_19_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DET_PRD_19_16_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DET_PRD_19_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_volt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_VOLT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_VOLT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_irq_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_IRQ_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_IRQ_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_lbat2_max_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_4), (&val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_MAX_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_MAX_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_volt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_VOLT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_VOLT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_irq_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_IRQ_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_IRQ_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_lbat2_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_lbat2_min_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_5), (&val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_MIN_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_MIN_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_lbat2_debounce_count_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_6), (&val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_lbat2_debounce_count_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_7), (&val),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_prd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_PRD_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_PRD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_wkup_start_cnt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_wkup_start_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_wkup_start(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_START_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_START_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_wkup_start_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_wkup_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_WKUP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_srclken_ind(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_rdy_st_prd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_RDY_ST_PRD_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_RDY_ST_PRD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_rdy_st_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_RDY_ST_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_RDY_ST_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_mdrt_det_start_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_MDRT_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_START_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_MDRT_DET_START_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_jeita_irq_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_IRQ_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_IRQ_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_jeita_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_jeita_det_prd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_DET_PRD_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_DET_PRD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_jeita_debt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBT_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_jeita_mipi_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_MIPI_DIS_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_MIPI_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_jeita_froze_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_FROZE_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_FROZE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_jeita_volt_hot(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_VOLT_HOT_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_VOLT_HOT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_jeita_hot_irq(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_1), (&val),
	    (unsigned int)(PMIC_AUXADC_JEITA_HOT_IRQ_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_HOT_IRQ_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_jeita_volt_warm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_VOLT_WARM_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_VOLT_WARM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_jeita_warm_irq(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_2), (&val),
	    (unsigned int)(PMIC_AUXADC_JEITA_WARM_IRQ_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_WARM_IRQ_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_jeita_volt_cool(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_VOLT_COOL_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_VOLT_COOL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_jeita_cool_irq(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_3), (&val),
	    (unsigned int)(PMIC_AUXADC_JEITA_COOL_IRQ_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_COOL_IRQ_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_jeita_volt_cold(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_JEITA_VOLT_COLD_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_VOLT_COLD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_jeita_cold_irq(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_4), (&val),
	    (unsigned int)(PMIC_AUXADC_JEITA_COLD_IRQ_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_COLD_IRQ_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_jeita_debounce_count_cold(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_5), (&val),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_jeita_debounce_count_cool(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_5), (&val),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_jeita_debounce_count_warm(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_5), (&val),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_jeita_debounce_count_hot(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_5), (&val),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_MASK),
	    (unsigned int)(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_dcxo_mdrt_det_prd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DCXO_MDRT_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_PRD_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_PRD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dcxo_mdrt_det_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DCXO_MDRT_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_EN_SHIFT));

	return ret;
}

unsigned int
mt6356_upmu_set_auxadc_dcxo_mdrt_det_wkup_start_cnt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DCXO_MDRT_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_SHIFT));

	return ret;
}

unsigned int
mt6356_upmu_set_auxadc_dcxo_mdrt_det_wkup_start_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DCXO_MDRT_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dcxo_mdrt_det_wkup_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DCXO_MDRT_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_SHIFT));

	return ret;
}

unsigned int
mt6356_upmu_set_auxadc_dcxo_mdrt_det_wkup_start_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DCXO_MDRT_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dcxo_mdrt_det_wkup_start(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DCXO_MDRT_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dcxo_mdrt_det_srclken_ind(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DCXO_MDRT_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_dcxo_ch4_mux_ap_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DCXO_MDRT_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_nag_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_NAG_0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_NAG_EN_MASK),
				    (unsigned int)(PMIC_AUXADC_NAG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_nag_clr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_NAG_0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_NAG_CLR_MASK),
				    (unsigned int)(PMIC_AUXADC_NAG_CLR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_nag_vbat1_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_NAG_VBAT1_SEL_MASK),
	    (unsigned int)(PMIC_AUXADC_NAG_VBAT1_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_nag_prd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_NAG_0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_NAG_PRD_MASK),
				    (unsigned int)(PMIC_AUXADC_NAG_PRD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_nag_irq_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_0), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_NAG_IRQ_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_NAG_IRQ_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_nag_c_dltv_irq(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_0), (&val),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_IRQ_MASK),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_IRQ_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_nag_zcv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_NAG_1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AUXADC_NAG_ZCV_MASK),
				    (unsigned int)(PMIC_AUXADC_NAG_ZCV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_nag_c_dltv_th_15_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_TH_15_0_MASK),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_TH_15_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_nag_c_dltv_th_26_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_TH_26_16_MASK),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_TH_26_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_nag_cnt_15_0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_4), (&val),
	    (unsigned int)(PMIC_AUXADC_NAG_CNT_15_0_MASK),
	    (unsigned int)(PMIC_AUXADC_NAG_CNT_15_0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_nag_cnt_25_16(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_5), (&val),
	    (unsigned int)(PMIC_AUXADC_NAG_CNT_25_16_MASK),
	    (unsigned int)(PMIC_AUXADC_NAG_CNT_25_16_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_nag_dltv(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_NAG_6), (&val),
				  (unsigned int)(PMIC_AUXADC_NAG_DLTV_MASK),
				  (unsigned int)(PMIC_AUXADC_NAG_DLTV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_nag_c_dltv_15_0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_7), (&val),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_15_0_MASK),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_15_0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_nag_c_dltv_26_16(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_8), (&val),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_26_16_MASK),
	    (unsigned int)(PMIC_AUXADC_NAG_C_DLTV_26_16_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_rsv_1rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_RSV_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_RSV_1RSV0_MASK),
	    (unsigned int)(PMIC_AUXADC_RSV_1RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_adcin_vbat_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_ANA_0), (&val),
				  (unsigned int)(PMIC_DA_ADCIN_VBAT_EN_MASK),
				  (unsigned int)(PMIC_DA_ADCIN_VBAT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_auxadc_vbat_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_AUXADC_ANA_0), (&val),
				(unsigned int)(PMIC_DA_AUXADC_VBAT_EN_MASK),
				(unsigned int)(PMIC_DA_AUXADC_VBAT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_adcin_vsen_mux_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ANA_0), (&val),
	    (unsigned int)(PMIC_DA_ADCIN_VSEN_MUX_EN_MASK),
	    (unsigned int)(PMIC_DA_ADCIN_VSEN_MUX_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_adcin_vsen_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_ANA_0), (&val),
				  (unsigned int)(PMIC_DA_ADCIN_VSEN_EN_MASK),
				  (unsigned int)(PMIC_DA_ADCIN_VSEN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_adcin_chr_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_ANA_0), (&val),
				  (unsigned int)(PMIC_DA_ADCIN_CHR_EN_MASK),
				  (unsigned int)(PMIC_DA_ADCIN_CHR_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_baton_tdet_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_ANA_0), (&val),
				  (unsigned int)(PMIC_DA_BATON_TDET_EN_MASK),
				  (unsigned int)(PMIC_DA_BATON_TDET_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_adcin_batid_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_ANA_0), (&val),
	    (unsigned int)(PMIC_DA_ADCIN_BATID_SW_EN_MASK),
	    (unsigned int)(PMIC_DA_ADCIN_BATID_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_imp_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_IMP_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_IMP_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_IMP_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_imp_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_IMP_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_IMP_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_IMP_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_auxadc_imp_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_IMP_CG0), (&val),
	    (unsigned int)(PMIC_RG_AUXADC_IMP_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_IMP_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_lbat_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_lbat_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_auxadc_lbat_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT_CG0), (&val),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_thr_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_THR_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_THR_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_thr_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_THR_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_THR_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_THR_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_auxadc_thr_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_THR_CG0), (&val),
	    (unsigned int)(PMIC_RG_AUXADC_THR_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_THR_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_bat_temp_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_bat_temp_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_auxadc_bat_temp_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_BAT_TEMP_CG0), (&val),
	    (unsigned int)(PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_lbat2_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT2_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT2_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_lbat2_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT2_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT2_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_auxadc_lbat2_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_LBAT2_CG0), (&val),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT2_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_LBAT2_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_jeita_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_JEITA_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_JEITA_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_jeita_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_JEITA_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_JEITA_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_auxadc_jeita_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_JEITA_CG0), (&val),
	    (unsigned int)(PMIC_RG_AUXADC_JEITA_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_JEITA_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_nag_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_NAG_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_NAG_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_nag_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_CG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_NAG_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_NAG_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_auxadc_nag_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_NAG_CG0), (&val),
	    (unsigned int)(PMIC_RG_AUXADC_NAG_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_NAG_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_new_priority_list_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_PRI_NEW), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_adcin_vsen_mux_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CHR_TOP_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_MUX_EN_MASK),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_MUX_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_adcin_vsen_mux_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_CHR_TOP_CON2), (&val),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_MUX_EN_MASK),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_MUX_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_baton_tdet_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_AUXADC_CHR_TOP_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BATON_TDET_EN_MASK),
				    (unsigned int)(PMIC_BATON_TDET_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_adcin_vsen_ext_baton_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CHR_TOP_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_MASK),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_adcin_vsen_ext_baton_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_CHR_TOP_CON2), (&val),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_MASK),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_adcin_vbat_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CHR_TOP_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_ADCIN_VBAT_EN_MASK),
	    (unsigned int)(PMIC_RG_ADCIN_VBAT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_adcin_vbat_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_CHR_TOP_CON2),
				  (&val),
				  (unsigned int)(PMIC_RG_ADCIN_VBAT_EN_MASK),
				  (unsigned int)(PMIC_RG_ADCIN_VBAT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_adcin_vsen_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CHR_TOP_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_EN_MASK),
	    (unsigned int)(PMIC_RG_ADCIN_VSEN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_adcin_vsen_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_CHR_TOP_CON2),
				  (&val),
				  (unsigned int)(PMIC_RG_ADCIN_VSEN_EN_MASK),
				  (unsigned int)(PMIC_RG_ADCIN_VSEN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_adcin_chr_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_CHR_TOP_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_ADCIN_CHR_EN_MASK),
	    (unsigned int)(PMIC_RG_ADCIN_CHR_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_adcin_chr_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_AUXADC_CHR_TOP_CON2),
				  (&val),
				  (unsigned int)(PMIC_RG_ADCIN_CHR_EN_MASK),
				  (unsigned int)(PMIC_RG_ADCIN_CHR_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_debt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DEBT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DEBT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_debt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DEBT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DEBT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_det_prd_15_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DET_PRD_15_0_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DET_PRD_15_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_det_prd_19_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DET_PRD_19_16_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DET_PRD_19_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_volt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_VOLT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_VOLT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_irq_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_IRQ_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_IRQ_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_typec_h_max_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_4), (&val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_MAX_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_MAX_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_volt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_VOLT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_VOLT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_irq_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_IRQ_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_IRQ_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_h_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_typec_h_min_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_5), (&val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_MIN_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_MIN_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_typec_h_debounce_count_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_6), (&val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_typec_h_debounce_count_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_7), (&val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_H_DEBOUNCE_COUNT_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_typec_h_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_H_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_H_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_typec_h_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_H_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_H_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_auxadc_typec_h_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_H_8), (&val),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_H_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_H_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_debt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DEBT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DEBT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_debt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_1), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DEBT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DEBT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_det_prd_15_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_2), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DET_PRD_15_0_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DET_PRD_15_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_det_prd_19_16(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_3), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DET_PRD_19_16_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DET_PRD_19_16_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_volt_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_VOLT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_VOLT_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_irq_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_IRQ_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_IRQ_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_en_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_4), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_EN_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_EN_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_typec_l_max_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_4), (&val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_MAX_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_MAX_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_volt_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_VOLT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_VOLT_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_irq_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_IRQ_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_IRQ_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_typec_l_en_min(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_5), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_EN_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_EN_MIN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_auxadc_typec_l_min_irq_b(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_5), (&val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_MIN_IRQ_B_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_MIN_IRQ_B_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_typec_l_debounce_count_max(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_6), (&val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MAX_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MAX_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_auxadc_typec_l_debounce_count_min(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_7), (&val),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MIN_MASK),
	    (unsigned int)(PMIC_AUXADC_TYPEC_L_DEBOUNCE_COUNT_MIN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_auxadc_typec_l_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_L_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_L_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_auxadc_typec_l_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_L_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_L_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_auxadc_typec_l_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_AUXADC_TYPEC_L_8), (&val),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_L_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_AUXADC_TYPEC_L_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_efuse_gain_ch4_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_EFUSE_GAIN_CH4_TRIM_MASK),
	    (unsigned int)(PMIC_EFUSE_GAIN_CH4_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_efuse_offset_ch4_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_EFUSE_OFFSET_CH4_TRIM_MASK),
	    (unsigned int)(PMIC_EFUSE_OFFSET_CH4_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_efuse_gain_ch0_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR2), (unsigned int)(val),
	    (unsigned int)(PMIC_EFUSE_GAIN_CH0_TRIM_MASK),
	    (unsigned int)(PMIC_EFUSE_GAIN_CH0_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_efuse_offset_ch0_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR3), (unsigned int)(val),
	    (unsigned int)(PMIC_EFUSE_OFFSET_CH0_TRIM_MASK),
	    (unsigned int)(PMIC_EFUSE_OFFSET_CH0_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_efuse_gain_ch7_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR4), (unsigned int)(val),
	    (unsigned int)(PMIC_EFUSE_GAIN_CH7_TRIM_MASK),
	    (unsigned int)(PMIC_EFUSE_GAIN_CH7_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_efuse_offset_ch7_trim(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR5), (unsigned int)(val),
	    (unsigned int)(PMIC_EFUSE_OFFSET_CH7_TRIM_MASK),
	    (unsigned int)(PMIC_EFUSE_OFFSET_CH7_TRIM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_degc_cali(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR6), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_DEGC_CALI_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_DEGC_CALI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_adc_cali_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR6), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_ADC_CALI_EN_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_ADC_CALI_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_1rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR6), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_1RSV0_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_1RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_o_vts(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR7), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_VTS_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_VTS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_2rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR7), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_2RSV0_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_2RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_o_slope(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_SLOPE_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_SLOPE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_o_slope_sign(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_SLOPE_SIGN_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_SLOPE_SIGN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_3rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR8), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_3RSV0_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_3RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_auxadc_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR9), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_AUXADC_RSV_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_AUXADC_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_id(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR9), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_ID_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_ID_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_4rsv0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR9), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_4RSV0_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_4RSV0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_o_vts_2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR10), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_VTS_2_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_VTS_2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_2rsv0_2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR10), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_2RSV0_2_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_2RSV0_2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_o_vts_3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_VTS_3_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_O_VTS_3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auxadc_efuse_2rsv0_3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_AUXADC_DIG_2_ELR11), (unsigned int)(val),
	    (unsigned int)(PMIC_AUXADC_EFUSE_2RSV0_3_MASK),
	    (unsigned int)(PMIC_AUXADC_EFUSE_2RSV0_3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_sck_top_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_SCK_TOP_DSN_ID), (&val),
				(unsigned int)(PMIC_SCK_TOP_ANA_ID_MASK),
				(unsigned int)(PMIC_SCK_TOP_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sck_top_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_SCK_TOP_DSN_ID), (&val),
				(unsigned int)(PMIC_SCK_TOP_DIG_ID_MASK),
				(unsigned int)(PMIC_SCK_TOP_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sck_top_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SCK_TOP_DSN_REV0), (&val),
	    (unsigned int)(PMIC_SCK_TOP_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_SCK_TOP_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sck_top_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SCK_TOP_DSN_REV0), (&val),
	    (unsigned int)(PMIC_SCK_TOP_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_SCK_TOP_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sck_top_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SCK_TOP_DSN_REV0), (&val),
	    (unsigned int)(PMIC_SCK_TOP_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_SCK_TOP_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sck_top_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SCK_TOP_DSN_REV0), (&val),
	    (unsigned int)(PMIC_SCK_TOP_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_SCK_TOP_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sck_top_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SCK_TOP_DSN_REV1), (&val),
	    (unsigned int)(PMIC_SCK_TOP_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_SCK_TOP_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sck_top_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SCK_TOP_DSN_REV1), (&val),
	    (unsigned int)(PMIC_SCK_TOP_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_SCK_TOP_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_sck_top_xtal_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_SCK_TOP_XTAL_SEL_MASK),
	    (unsigned int)(PMIC_SCK_TOP_XTAL_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_sck_top_reserved(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_SCK_TOP_RESERVED_MASK),
	    (unsigned int)(PMIC_SCK_TOP_RESERVED_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_xosc32_enb_det(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_SCK_TOP_CON1), (&val),
				  (unsigned int)(PMIC_XOSC32_ENB_DET_MASK),
				  (unsigned int)(PMIC_XOSC32_ENB_DET_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_sck_top_test_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_SCK_TOP_TEST_OUT),
				  (&val),
				  (unsigned int)(PMIC_SCK_TOP_TEST_OUT_MASK),
				  (unsigned int)(PMIC_SCK_TOP_TEST_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_sck_top_mon_flag_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_TEST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_SCK_TOP_MON_FLAG_SEL_MASK),
	    (unsigned int)(PMIC_SCK_TOP_MON_FLAG_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_sck_top_mon_grp_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_TEST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_SCK_TOP_MON_GRP_SEL_MASK),
	    (unsigned int)(PMIC_SCK_TOP_MON_GRP_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_sec_mclk_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_SEC_MCLK_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC_SEC_MCLK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_eosc_cali_test_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EOSC_CALI_TEST_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_EOSC_CALI_TEST_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_eosc32_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_EOSC32_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC_EOSC32_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_sec_32k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_SEC_32K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC_SEC_32K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_mclk_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_MCLK_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC_MCLK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_32k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_32K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC_32K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_26m_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_26M_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC_26M_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_2sec_off_det_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKPDN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_2SEC_OFF_DET_PDN_MASK),
	    (unsigned int)(PMIC_RG_RTC_2SEC_OFF_DET_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_26m_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_26M_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_RTC_26M_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_mclk_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_MCLK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_RTC_MCLK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_sec_32k_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_SEC_32K_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_RTC_SEC_32K_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_sec_mclk_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_SEC_MCLK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_RTC_SEC_MCLK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_clk_pdn_hwen_rsv_1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_1_MASK),
	    (unsigned int)(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_clk_pdn_hwen_rsv_0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKHWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_0_MASK),
	    (unsigned int)(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_ck_tstsel_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKTST_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_CK_TSTSEL_RSV_MASK),
	    (unsigned int)(PMIC_RG_RTC_CK_TSTSEL_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtcdet_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKTST_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTCDET_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_RTCDET_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_eosc_cali_test_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKTST_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_eosc32_ck_tstsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_CKTST_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_EOSC32_CK_TSTSEL_MASK),
	    (unsigned int)(PMIC_RG_RTC_EOSC32_CK_TSTSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_mdb_dcm_ck_n(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_MDB_DCM_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_MDB_DCM_CK_N_MASK),
	    (unsigned int)(PMIC_RG_RTC_MDB_DCM_CK_N_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_sec_mdb_dcm_ck_n(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_MDB_DCM_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_SEC_MDB_DCM_CK_N_MASK),
	    (unsigned int)(PMIC_RG_RTC_SEC_MDB_DCM_CK_N_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_SCK_TOP_RST_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_RTC_SWRST_MASK),
				    (unsigned int)(PMIC_RG_RTC_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rtc_sec_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RTC_SEC_SWRST_MASK),
	    (unsigned int)(PMIC_RG_RTC_SEC_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bank_rtc_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BANK_RTC_SWRST_MASK),
	    (unsigned int)(PMIC_RG_BANK_RTC_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bank_rtc_sec_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BANK_RTC_SEC_SWRST_MASK),
	    (unsigned int)(PMIC_RG_BANK_RTC_SEC_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bank_eosc_cali_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BANK_EOSC_CALI_SWRST_MASK),
	    (unsigned int)(PMIC_RG_BANK_EOSC_CALI_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_bank_sck_top_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BANK_SCK_TOP_SWRST_MASK),
	    (unsigned int)(PMIC_RG_BANK_SCK_TOP_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_en_rtc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_SCK_TOP_INT_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_INT_EN_RTC_MASK),
				    (unsigned int)(PMIC_RG_INT_EN_RTC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_rtc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_SCK_TOP_INT_CON0),
				  (&val),
				  (unsigned int)(PMIC_RG_INT_EN_RTC_MASK),
				  (unsigned int)(PMIC_RG_INT_EN_RTC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_mask_rtc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_RTC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_RTC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_status_rtc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SCK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_RTC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_RTC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_rtc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_SCK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_RTC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_RTC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_sck_top_polarity(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SCK_TOP_INT_MISC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_SCK_TOP_POLARITY_MASK),
	    (unsigned int)(PMIC_SCK_TOP_POLARITY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf1_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW00), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF1_MODE_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF1_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf1_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW00), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF1_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF1_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf2_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW00), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF2_MODE_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF2_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf2_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW00), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF2_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF2_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf3_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW00), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF3_MODE_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF3_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf3_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW00), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF3_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF3_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf4_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW00), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF4_MODE_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF4_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf4_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW00), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF4_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF4_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_bb_lpm_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW00),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_BB_LPM_EN_MASK),
				    (unsigned int)(PMIC_XO_BB_LPM_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_enbb_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW00),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_ENBB_MAN_MASK),
				    (unsigned int)(PMIC_XO_ENBB_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_enbb_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW00),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_ENBB_EN_M_MASK),
				    (unsigned int)(PMIC_XO_ENBB_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_clksel_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW00),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_CLKSEL_MAN_MASK),
				    (unsigned int)(PMIC_XO_CLKSEL_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_clksel_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW01),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_CLKSEL_EN_M_MASK),
				    (unsigned int)(PMIC_XO_CLKSEL_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf1_ckg_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF1_CKG_MAN_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF1_CKG_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf1_ckg_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF1_CKG_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF1_CKG_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf2_ckg_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF2_CKG_MAN_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF2_CKG_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf2_ckg_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF2_CKG_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF2_CKG_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf3_ckg_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF3_CKG_MAN_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF3_CKG_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf3_ckg_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF3_CKG_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF3_CKG_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf4_ckg_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF4_CKG_MAN_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF4_CKG_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf4_ckg_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF4_CKG_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF4_CKG_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_intbuf_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW01),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_INTBUF_MAN_MASK),
				    (unsigned int)(PMIC_XO_INTBUF_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_pbuf_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW01),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_PBUF_EN_M_MASK),
				    (unsigned int)(PMIC_XO_PBUF_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ibuf_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW01),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_IBUF_EN_M_MASK),
				    (unsigned int)(PMIC_XO_IBUF_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_lpmbuf_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW01),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_LPMBUF_MAN_MASK),
				    (unsigned int)(PMIC_XO_LPMBUF_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_lpm_prebuf_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_LPM_PREBUF_EN_M_MASK),
	    (unsigned int)(PMIC_XO_LPM_PREBUF_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_lpbuf_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW01),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_LPBUF_EN_M_MASK),
				    (unsigned int)(PMIC_XO_LPBUF_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_bblpm_cksel_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW01), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_BBLPM_CKSEL_M_MASK),
	    (unsigned int)(PMIC_XO_BBLPM_CKSEL_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_en32k_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW02),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_EN32K_MAN_MASK),
				    (unsigned int)(PMIC_XO_EN32K_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_en32k_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW02),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_EN32K_M_MASK),
				    (unsigned int)(PMIC_XO_EN32K_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_xmode_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW02),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_XMODE_MAN_MASK),
				    (unsigned int)(PMIC_XO_XMODE_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_xmode_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW02),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_XMODE_M_MASK),
				    (unsigned int)(PMIC_XO_XMODE_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_strup_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW02),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_STRUP_MODE_MASK),
				    (unsigned int)(PMIC_XO_STRUP_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_fpm_time(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW02), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_FPM_TIME_MASK),
	    (unsigned int)(PMIC_XO_AAC_FPM_TIME_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_mode_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW02), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_MODE_LPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_MODE_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_mode_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW02), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_MODE_FPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_MODE_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_en26m_offsq_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW02), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EN26M_OFFSQ_EN_MASK),
	    (unsigned int)(PMIC_XO_EN26M_OFFSQ_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ldocal_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW02),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_LDOCAL_EN_MASK),
				    (unsigned int)(PMIC_XO_LDOCAL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_cbank_sync_dyn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW02), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CBANK_SYNC_DYN_MASK),
	    (unsigned int)(PMIC_XO_CBANK_SYNC_DYN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_26mlp_man_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW02), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_26MLP_MAN_EN_MASK),
	    (unsigned int)(PMIC_XO_26MLP_MAN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_bufldok_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW02),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_BUFLDOK_EN_MASK),
				    (unsigned int)(PMIC_XO_BUFLDOK_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_pmu_cken_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW03),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_PMU_CKEN_M_MASK),
				    (unsigned int)(PMIC_XO_PMU_CKEN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_pmu_cken_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW03), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_PMU_CKEN_MAN_MASK),
	    (unsigned int)(PMIC_XO_PMU_CKEN_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf6_ckg_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW03), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF6_CKG_MAN_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF6_CKG_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf6_ckg_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW03), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF6_CKG_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF6_CKG_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf7_ckg_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW03), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF7_CKG_MAN_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF7_CKG_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf7_ckg_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW03), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF7_CKG_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF7_CKG_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_lpm_isel_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW03), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_LPM_ISEL_MAN_MASK),
	    (unsigned int)(PMIC_XO_LPM_ISEL_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_fpm_isel_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW03), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_FPM_ISEL_MAN_MASK),
	    (unsigned int)(PMIC_XO_FPM_ISEL_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_cdac_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW04),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_CDAC_FPM_MASK),
				    (unsigned int)(PMIC_XO_CDAC_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_cdac_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW04),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_CDAC_LPM_MASK),
				    (unsigned int)(PMIC_XO_CDAC_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_32kdiv_nfrac_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW05), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_32KDIV_NFRAC_FPM_MASK),
	    (unsigned int)(PMIC_XO_32KDIV_NFRAC_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_cofst_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW05),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_COFST_FPM_MASK),
				    (unsigned int)(PMIC_XO_COFST_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_32kdiv_nfrac_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW06), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_32KDIV_NFRAC_LPM_MASK),
	    (unsigned int)(PMIC_XO_32KDIV_NFRAC_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_cofst_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW06),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_COFST_LPM_MASK),
				    (unsigned int)(PMIC_XO_COFST_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW07),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_CORE_MAN_MASK),
				    (unsigned int)(PMIC_XO_CORE_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW07),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_CORE_EN_M_MASK),
				    (unsigned int)(PMIC_XO_CORE_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_turbo_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_TURBO_EN_M_MASK),
	    (unsigned int)(PMIC_XO_CORE_TURBO_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_aac_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_AAC_EN_M_MASK),
	    (unsigned int)(PMIC_XO_CORE_AAC_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_startup_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_STARTUP_EN_M_MASK),
	    (unsigned int)(PMIC_XO_STARTUP_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_vbfpm_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_VBFPM_EN_M_MASK),
	    (unsigned int)(PMIC_XO_CORE_VBFPM_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_vblpm_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_VBLPM_EN_M_MASK),
	    (unsigned int)(PMIC_XO_CORE_VBLPM_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_lpmbias_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_LPMBIAS_EN_M_MASK),
	    (unsigned int)(PMIC_XO_LPMBIAS_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_vtcgen_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW07),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_VTCGEN_EN_M_MASK),
				    (unsigned int)(PMIC_XO_VTCGEN_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_iaac_comp_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_IAAC_COMP_EN_M_MASK),
	    (unsigned int)(PMIC_XO_IAAC_COMP_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ifpm_comp_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_IFPM_COMP_EN_M_MASK),
	    (unsigned int)(PMIC_XO_IFPM_COMP_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ilpm_comp_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_ILPM_COMP_EN_M_MASK),
	    (unsigned int)(PMIC_XO_ILPM_COMP_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_bypcas_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_BYPCAS_FPM_MASK),
	    (unsigned int)(PMIC_XO_CORE_BYPCAS_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_gmx2_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_GMX2_FPM_MASK),
	    (unsigned int)(PMIC_XO_CORE_GMX2_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_idac_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW07), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_IDAC_FPM_MASK),
	    (unsigned int)(PMIC_XO_CORE_IDAC_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_comp_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW08), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_COMP_MAN_MASK),
	    (unsigned int)(PMIC_XO_AAC_COMP_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW08),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_AAC_EN_M_MASK),
				    (unsigned int)(PMIC_XO_AAC_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_monen_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW08),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_AAC_MONEN_M_MASK),
				    (unsigned int)(PMIC_XO_AAC_MONEN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_comp_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW08),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_COMP_EN_M_MASK),
				    (unsigned int)(PMIC_XO_COMP_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_comp_tsten_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW08), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_COMP_TSTEN_M_MASK),
	    (unsigned int)(PMIC_XO_COMP_TSTEN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_hv_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW08),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_AAC_HV_FPM_MASK),
				    (unsigned int)(PMIC_XO_AAC_HV_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_ibias_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW08), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_IBIAS_FPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_IBIAS_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_vofst_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW08), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_VOFST_FPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_VOFST_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_comp_hv_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW08), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_COMP_HV_FPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_COMP_HV_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_vsel_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW08), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_VSEL_FPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_VSEL_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_comp_pol(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW08), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_COMP_POL_MASK),
	    (unsigned int)(PMIC_XO_AAC_COMP_POL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_bypcas_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW09), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_BYPCAS_LPM_MASK),
	    (unsigned int)(PMIC_XO_CORE_BYPCAS_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_gmx2_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW09), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_GMX2_LPM_MASK),
	    (unsigned int)(PMIC_XO_CORE_GMX2_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_core_idac_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW09), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CORE_IDAC_LPM_MASK),
	    (unsigned int)(PMIC_XO_CORE_IDAC_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_comp_hv_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW09), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_COMP_HV_LPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_COMP_HV_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_vsel_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW09), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_VSEL_LPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_VSEL_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_hv_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW09),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_AAC_HV_LPM_MASK),
				    (unsigned int)(PMIC_XO_AAC_HV_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_ibias_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW09), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_IBIAS_LPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_IBIAS_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_vofst_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW09), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_VOFST_LPM_MASK),
	    (unsigned int)(PMIC_XO_AAC_VOFST_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_aac_fpm_swen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW09), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_AAC_FPM_SWEN_MASK),
	    (unsigned int)(PMIC_XO_AAC_FPM_SWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW09),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_SWRST_MASK),
				    (unsigned int)(PMIC_XO_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_32kdiv_swrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_32KDIV_SWRST_MASK),
	    (unsigned int)(PMIC_XO_32KDIV_SWRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_32kdiv_ratio_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_32KDIV_RATIO_MAN_MASK),
	    (unsigned int)(PMIC_XO_32KDIV_RATIO_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_32kdiv_test_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_32KDIV_TEST_EN_MASK),
	    (unsigned int)(PMIC_XO_32KDIV_TEST_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_cbank_sync_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CBANK_SYNC_MAN_MASK),
	    (unsigned int)(PMIC_XO_CBANK_SYNC_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_cbank_sync_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CBANK_SYNC_EN_M_MASK),
	    (unsigned int)(PMIC_XO_CBANK_SYNC_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ctl_sync_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CTL_SYNC_MAN_MASK),
	    (unsigned int)(PMIC_XO_CTL_SYNC_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ctl_sync_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_CTL_SYNC_EN_M_MASK),
	    (unsigned int)(PMIC_XO_CTL_SYNC_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ldo_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW10),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_LDO_MAN_MASK),
				    (unsigned int)(PMIC_XO_LDO_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ldopbuf_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_LDOPBUF_EN_M_MASK),
	    (unsigned int)(PMIC_XO_LDOPBUF_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ldopbuf_vset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_LDOPBUF_VSET_M_MASK),
	    (unsigned int)(PMIC_XO_LDOPBUF_VSET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ldovtst_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_LDOVTST_EN_M_MASK),
	    (unsigned int)(PMIC_XO_LDOVTST_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_test_vcal_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW10), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_TEST_VCAL_EN_M_MASK),
	    (unsigned int)(PMIC_XO_TEST_VCAL_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_vbist_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW10),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_VBIST_EN_M_MASK),
				    (unsigned int)(PMIC_XO_VBIST_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_vtest_sel_mux(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW11), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_VTEST_SEL_MUX_MASK),
	    (unsigned int)(PMIC_XO_VTEST_SEL_MUX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_reserved3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW11),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_RESERVED3_MASK),
				    (unsigned int)(PMIC_XO_RESERVED3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf6_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW11), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF6_MODE_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF6_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf6_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW11), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF6_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF6_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf7_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW11), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF7_MODE_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF7_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf7_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW11), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF7_EN_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF7_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_bufldok_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW11),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_BUFLDOK_MAN_MASK),
				    (unsigned int)(PMIC_XO_BUFLDOK_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_buf1ldo_cal_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW11), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_BUF1LDO_CAL_M_MASK),
	    (unsigned int)(PMIC_XO_BUF1LDO_CAL_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_bufldo_cal_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_BUFLDO_CAL_M_MASK),
	    (unsigned int)(PMIC_XO_BUFLDO_CAL_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf4_clksel_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF4_CLKSEL_MAN_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF4_CLKSEL_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_vio18pg_bufen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_VIO18PG_BUFEN_MASK),
	    (unsigned int)(PMIC_XO_VIO18PG_BUFEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_cal_en_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW12),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_CAL_EN_MAN_MASK),
				    (unsigned int)(PMIC_XO_CAL_EN_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_cal_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW12),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_CAL_EN_M_MASK),
				    (unsigned int)(PMIC_XO_CAL_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_core_osctd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CORE_OSCTD_MASK),
	    (unsigned int)(PMIC_RG_XO_CORE_OSCTD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_thadc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW12),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_THADC_EN_MASK),
				    (unsigned int)(PMIC_XO_THADC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_sync_ckpol(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_SYNC_CKPOL_MASK),
	    (unsigned int)(PMIC_RG_XO_SYNC_CKPOL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_cbank_pol(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CBANK_POL_MASK),
	    (unsigned int)(PMIC_RG_XO_CBANK_POL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_cbank_sync_byp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CBANK_SYNC_BYP_MASK),
	    (unsigned int)(PMIC_RG_XO_CBANK_SYNC_BYP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_ctl_pol(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW12),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_XO_CTL_POL_MASK),
				    (unsigned int)(PMIC_RG_XO_CTL_POL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_ctl_sync_byp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CTL_SYNC_BYP_MASK),
	    (unsigned int)(PMIC_RG_XO_CTL_SYNC_BYP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_lpbuf_inv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_LPBUF_INV_MASK),
	    (unsigned int)(PMIC_RG_XO_LPBUF_INV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_ldopbuf_byp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_LDOPBUF_BYP_MASK),
	    (unsigned int)(PMIC_RG_XO_LDOPBUF_BYP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_ldopbuf_encl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW12), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_LDOPBUF_ENCL_MASK),
	    (unsigned int)(PMIC_RG_XO_LDOPBUF_ENCL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xo_ldopbuf_encl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_DCXO_CW12), (&val),
				(unsigned int)(PMIC_RG_XO_LDOPBUF_ENCL_MASK),
				(unsigned int)(PMIC_RG_XO_LDOPBUF_ENCL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_vgbias_vset(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_VGBIAS_VSET_MASK),
	    (unsigned int)(PMIC_RG_XO_VGBIAS_VSET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_pbuf_iset(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_PBUF_ISET_MASK),
	    (unsigned int)(PMIC_RG_XO_PBUF_ISET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_ibuf_iset(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_IBUF_ISET_MASK),
	    (unsigned int)(PMIC_RG_XO_IBUF_ISET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_reserved4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_RESERVED4_MASK),
	    (unsigned int)(PMIC_RG_XO_RESERVED4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_vow_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW13),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_XO_VOW_EN_MASK),
				    (unsigned int)(PMIC_RG_XO_VOW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xo_vow_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_DCXO_CW13), (&val),
				  (unsigned int)(PMIC_RG_XO_VOW_EN_MASK),
				  (unsigned int)(PMIC_RG_XO_VOW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_vow_div(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW13),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_XO_VOW_DIV_MASK),
				    (unsigned int)(PMIC_RG_XO_VOW_DIV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_bufldo24_encl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO24_ENCL_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO24_ENCL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xo_bufldo24_encl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_DCXO_CW13), (&val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO24_ENCL_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO24_ENCL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_bufldo24_ibx2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO24_IBX2_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO24_IBX2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_reserved5(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW13), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_RESERVED5_MASK),
	    (unsigned int)(PMIC_RG_XO_RESERVED5_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_bufldo13_encl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO13_ENCL_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO13_ENCL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xo_bufldo13_encl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (&val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO13_ENCL_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO13_ENCL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_bufldo13_ibx2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO13_IBX2_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO13_IBX2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_bufldo13_ix2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO13_IX2_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO13_IX2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_lvldo_i_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_LVLDO_I_CTRL_MASK),
	    (unsigned int)(PMIC_RG_XO_LVLDO_I_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_bufldo67_encl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO67_ENCL_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO67_ENCL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xo_bufldo67_encl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (&val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO67_ENCL_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO67_ENCL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_bufldo67_ibx2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO67_IBX2_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO67_IBX2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_bufldo67_ix2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_BUFLDO67_IX2_MASK),
	    (unsigned int)(PMIC_RG_XO_BUFLDO67_IX2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_lvldo_rfb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_LVLDO_RFB_MASK),
	    (unsigned int)(PMIC_RG_XO_LVLDO_RFB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_extbuf_inv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_EXTBUF_INV_MASK),
	    (unsigned int)(PMIC_RG_XO_EXTBUF_INV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_reserved0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_RESERVED0_MASK),
	    (unsigned int)(PMIC_RG_XO_RESERVED0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf2_clksel_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF2_CLKSEL_MAN_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF2_CLKSEL_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_audio_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW14),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_AUDIO_EN_M_MASK),
				    (unsigned int)(PMIC_XO_AUDIO_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_audio_atten(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW14), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_AUDIO_ATTEN_MASK),
	    (unsigned int)(PMIC_RG_XO_AUDIO_ATTEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_audio_iset(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW15), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_AUDIO_ISET_MASK),
	    (unsigned int)(PMIC_RG_XO_AUDIO_ISET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_extbuf1_hd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW15), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_EXTBUF1_HD_MASK),
	    (unsigned int)(PMIC_RG_XO_EXTBUF1_HD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_extbuf2_hd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW15), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_EXTBUF2_HD_MASK),
	    (unsigned int)(PMIC_RG_XO_EXTBUF2_HD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_extbuf3_hd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW15), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_EXTBUF3_HD_MASK),
	    (unsigned int)(PMIC_RG_XO_EXTBUF3_HD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_extbuf4_hd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW15), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_EXTBUF4_HD_MASK),
	    (unsigned int)(PMIC_RG_XO_EXTBUF4_HD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_reserved8(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW15), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_RESERVED8_MASK),
	    (unsigned int)(PMIC_RG_XO_RESERVED8_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_extbuf6_hd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW15), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_EXTBUF6_HD_MASK),
	    (unsigned int)(PMIC_RG_XO_EXTBUF6_HD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_extbuf7_hd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW15), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_EXTBUF7_HD_MASK),
	    (unsigned int)(PMIC_RG_XO_EXTBUF7_HD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf1_iset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW16), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF1_ISET_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF1_ISET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf2_iset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW16), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF2_ISET_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF2_ISET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf3_iset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW16), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF3_ISET_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF3_ISET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf4_iset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW16), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF4_ISET_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF4_ISET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_reserved9(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW16),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_RESERVED9_MASK),
				    (unsigned int)(PMIC_XO_RESERVED9_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf6_iset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW16), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF6_ISET_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF6_ISET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_extbuf7_iset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW16), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_EXTBUF7_ISET_M_MASK),
	    (unsigned int)(PMIC_XO_EXTBUF7_ISET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_lpm_prebuf_iset(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW16), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_LPM_PREBUF_ISET_MASK),
	    (unsigned int)(PMIC_RG_XO_LPM_PREBUF_ISET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_reserved1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW17), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_RESERVED1_MASK),
	    (unsigned int)(PMIC_RG_XO_RESERVED1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_thadc_en_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW17), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_THADC_EN_MAN_MASK),
	    (unsigned int)(PMIC_XO_THADC_EN_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_tsource_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW17), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_TSOURCE_EN_MASK),
	    (unsigned int)(PMIC_RG_XO_TSOURCE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xo_tsource_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_DCXO_CW17), (&val),
				  (unsigned int)(PMIC_RG_XO_TSOURCE_EN_MASK),
				  (unsigned int)(PMIC_RG_XO_TSOURCE_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_xo_bufldo13_vset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW17), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_BUFLDO13_VSET_M_MASK),
	    (unsigned int)(PMIC_XO_BUFLDO13_VSET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_bufldo24_vset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW17), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_BUFLDO24_VSET_M_MASK),
	    (unsigned int)(PMIC_XO_BUFLDO24_VSET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_bufldo67_vset_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW17), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_BUFLDO67_VSET_M_MASK),
	    (unsigned int)(PMIC_XO_BUFLDO67_VSET_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_static_auxout_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW18), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_STATIC_AUXOUT_SEL_MASK),
	    (unsigned int)(PMIC_XO_STATIC_AUXOUT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_auxout_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_CW18),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XO_AUXOUT_SEL_MASK),
				    (unsigned int)(PMIC_XO_AUXOUT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_xo_static_auxout(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_DCXO_CW19), (&val),
				  (unsigned int)(PMIC_XO_STATIC_AUXOUT_MASK),
				  (unsigned int)(PMIC_XO_STATIC_AUXOUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_pctat_comp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW20), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_PCTAT_COMP_EN_MASK),
	    (unsigned int)(PMIC_RG_XO_PCTAT_COMP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xo_pctat_comp_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_DCXO_CW20), (&val),
	    (unsigned int)(PMIC_RG_XO_PCTAT_COMP_EN_MASK),
	    (unsigned int)(PMIC_RG_XO_PCTAT_COMP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_heater_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW20), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_HEATER_SEL_MASK),
	    (unsigned int)(PMIC_RG_XO_HEATER_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_corner_detect_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW20), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CORNER_DETECT_EN_MASK),
	    (unsigned int)(PMIC_RG_XO_CORNER_DETECT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xo_corner_detect_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_DCXO_CW20), (&val),
	    (unsigned int)(PMIC_RG_XO_CORNER_DETECT_EN_MASK),
	    (unsigned int)(PMIC_RG_XO_CORNER_DETECT_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_corner_detect_en_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW20), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CORNER_DETECT_EN_MAN_MASK),
	    (unsigned int)(PMIC_RG_XO_CORNER_DETECT_EN_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_xo_corner_detect_en_man(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_DCXO_CW20), (&val),
	    (unsigned int)(PMIC_RG_XO_CORNER_DETECT_EN_MAN_MASK),
	    (unsigned int)(PMIC_RG_XO_CORNER_DETECT_EN_MAN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_resrved10(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW20), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_RESRVED10_MASK),
	    (unsigned int)(PMIC_RG_XO_RESRVED10_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_corner_setting_tune(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW21), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_CORNER_SETTING_TUNE_MASK),
	    (unsigned int)(PMIC_RG_XO_CORNER_SETTING_TUNE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_resrved11(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW21), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_RESRVED11_MASK),
	    (unsigned int)(PMIC_RG_XO_RESRVED11_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rgs_ad_xo_corner_cal_done(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_DCXO_CW22), (&val),
	    (unsigned int)(PMIC_RGS_AD_XO_CORNER_CAL_DONE_MASK),
	    (unsigned int)(PMIC_RGS_AD_XO_CORNER_CAL_DONE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_ad_xo_corner_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_DCXO_CW22), (&val),
	    (unsigned int)(PMIC_RGS_AD_XO_CORNER_SEL_MASK),
	    (unsigned int)(PMIC_RGS_AD_XO_CORNER_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_xo_mdb_tbo_en_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW22), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_MDB_TBO_EN_SEL_MASK),
	    (unsigned int)(PMIC_XO_MDB_TBO_EN_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ptatctat_en_man(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW22), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_PTATCTAT_EN_MAN_MASK),
	    (unsigned int)(PMIC_XO_PTATCTAT_EN_MAN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ptatctat_en_m(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW22), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_PTATCTAT_EN_M_MASK),
	    (unsigned int)(PMIC_XO_PTATCTAT_EN_M_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ptatctat_en_lpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW22), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_PTATCTAT_EN_LPM_MASK),
	    (unsigned int)(PMIC_XO_PTATCTAT_EN_LPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_ptatctat_en_fpm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_CW22), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_PTATCTAT_EN_FPM_MASK),
	    (unsigned int)(PMIC_XO_PTATCTAT_EN_FPM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_dcxo_elr_len(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_DCXO_ELR_NUM), (&val),
				  (unsigned int)(PMIC_DCXO_ELR_LEN_MASK),
				  (unsigned int)(PMIC_DCXO_ELR_LEN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_xo_pctat_rdeg_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_XO_PCTAT_RDEG_SEL_MASK),
	    (unsigned int)(PMIC_RG_XO_PCTAT_RDEG_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_xo_gs_vtemp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_DCXO_ELR0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_XO_GS_VTEMP_MASK),
				    (unsigned int)(PMIC_RG_XO_GS_VTEMP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xo_pwrkey_rstb_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_DCXO_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_XO_PWRKEY_RSTB_SEL_MASK),
	    (unsigned int)(PMIC_XO_PWRKEY_RSTB_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rtc_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_DSN_ID), (&val),
				  (unsigned int)(PMIC_RTC_ANA_ID_MASK),
				  (unsigned int)(PMIC_RTC_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_DSN_ID), (&val),
				  (unsigned int)(PMIC_RTC_DIG_ID_MASK),
				  (unsigned int)(PMIC_RTC_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_RTC_DSN_REV0), (&val),
				(unsigned int)(PMIC_RTC_ANA_MINOR_REV_MASK),
				(unsigned int)(PMIC_RTC_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_RTC_DSN_REV0), (&val),
				(unsigned int)(PMIC_RTC_ANA_MAJOR_REV_MASK),
				(unsigned int)(PMIC_RTC_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_RTC_DSN_REV0), (&val),
				(unsigned int)(PMIC_RTC_DIG_MINOR_REV_MASK),
				(unsigned int)(PMIC_RTC_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_RTC_DSN_REV0), (&val),
				(unsigned int)(PMIC_RTC_DIG_MAJOR_REV_MASK),
				(unsigned int)(PMIC_RTC_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_DSN_REV1), (&val),
				  (unsigned int)(PMIC_RTC_SW_MINOR_REV_MASK),
				  (unsigned int)(PMIC_RTC_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_DSN_REV1), (&val),
				  (unsigned int)(PMIC_RTC_SW_MAJOR_REV_MASK),
				  (unsigned int)(PMIC_RTC_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rtc_dummy(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_DUMMY_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_DUMMY_MASK),
				    (unsigned int)(PMIC_RTC_DUMMY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_pwren(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_BBPU), (unsigned int)(val),
	    (unsigned int)(PMIC_PWREN_MASK), (unsigned int)(PMIC_PWREN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bbpu(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_BBPU), (unsigned int)(val),
	    (unsigned int)(PMIC_BBPU_MASK), (unsigned int)(PMIC_BBPU_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_auto(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_BBPU), (unsigned int)(val),
	    (unsigned int)(PMIC_AUTO_MASK), (unsigned int)(PMIC_AUTO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_cbusy(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_BBPU), (&val),
				  (unsigned int)(PMIC_CBUSY_MASK),
				  (unsigned int)(PMIC_CBUSY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_alsta(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_IRQ_STA), (&val),
				  (unsigned int)(PMIC_ALSTA_MASK),
				  (unsigned int)(PMIC_ALSTA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_tcsta(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_IRQ_STA), (&val),
				  (unsigned int)(PMIC_TCSTA_MASK),
				  (unsigned int)(PMIC_TCSTA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_lpsta(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_IRQ_STA), (&val),
				  (unsigned int)(PMIC_LPSTA_MASK),
				  (unsigned int)(PMIC_LPSTA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_al_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_IRQ_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_AL_EN_MASK), (unsigned int)(PMIC_AL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_IRQ_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_TC_EN_MASK), (unsigned int)(PMIC_TC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_oneshot(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_IRQ_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_ONESHOT_MASK),
				    (unsigned int)(PMIC_ONESHOT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_lp_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_IRQ_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_LP_EN_MASK), (unsigned int)(PMIC_LP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_seccii(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_SECCII_MASK),
				    (unsigned int)(PMIC_SECCII_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mincii(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_MINCII_MASK),
				    (unsigned int)(PMIC_MINCII_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_houcii(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_HOUCII_MASK),
				    (unsigned int)(PMIC_HOUCII_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_domcii(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DOMCII_MASK),
				    (unsigned int)(PMIC_DOMCII_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dowcii(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DOWCII_MASK),
				    (unsigned int)(PMIC_DOWCII_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mthcii(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_MTHCII_MASK),
				    (unsigned int)(PMIC_MTHCII_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_yeacii(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_YEACII_MASK),
				    (unsigned int)(PMIC_YEACII_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_seccii_1_2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_SECCII_1_2_MASK),
				    (unsigned int)(PMIC_SECCII_1_2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_seccii_1_4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_SECCII_1_4_MASK),
				    (unsigned int)(PMIC_SECCII_1_4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_seccii_1_8(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CII_EN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_SECCII_1_8_MASK),
				    (unsigned int)(PMIC_SECCII_1_8_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_sec_msk(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MASK),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_SEC_MSK_MASK),
				    (unsigned int)(PMIC_SEC_MSK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_min_msk(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MASK),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_MIN_MSK_MASK),
				    (unsigned int)(PMIC_MIN_MSK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_hou_msk(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MASK),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_HOU_MSK_MASK),
				    (unsigned int)(PMIC_HOU_MSK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dom_msk(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MASK),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DOM_MSK_MASK),
				    (unsigned int)(PMIC_DOM_MSK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_dow_msk(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MASK),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_DOW_MSK_MASK),
				    (unsigned int)(PMIC_DOW_MSK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mth_msk(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MASK),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_MTH_MSK_MASK),
				    (unsigned int)(PMIC_MTH_MSK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_yea_msk(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MASK),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_YEA_MSK_MASK),
				    (unsigned int)(PMIC_YEA_MSK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_second(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_SECOND_MASK),
				    (unsigned int)(PMIC_TC_SECOND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_minute(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_MIN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_MINUTE_MASK),
				    (unsigned int)(PMIC_TC_MINUTE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_hour(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_HOU),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_HOUR_MASK),
				    (unsigned int)(PMIC_TC_HOUR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_dom(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_DOM),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_DOM_MASK),
				    (unsigned int)(PMIC_TC_DOM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_dow(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_DOW),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_DOW_MASK),
				    (unsigned int)(PMIC_TC_DOW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_month(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_MTH),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_MONTH_MASK),
				    (unsigned int)(PMIC_TC_MONTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_year(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_YEA),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_YEAR_MASK),
				    (unsigned int)(PMIC_TC_YEAR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_al_second(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AL_SECOND_MASK),
				    (unsigned int)(PMIC_AL_SECOND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bbpu_auto_pdn_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_AL_SEC), (unsigned int)(val),
	    (unsigned int)(PMIC_BBPU_AUTO_PDN_SEL_MASK),
	    (unsigned int)(PMIC_BBPU_AUTO_PDN_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bbpu_2sec_ck_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_AL_SEC), (unsigned int)(val),
	    (unsigned int)(PMIC_BBPU_2SEC_CK_SEL_MASK),
	    (unsigned int)(PMIC_BBPU_2SEC_CK_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bbpu_2sec_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BBPU_2SEC_EN_MASK),
				    (unsigned int)(PMIC_BBPU_2SEC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_bbpu_2sec_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_BBPU_2SEC_MODE_MASK),
				    (unsigned int)(PMIC_BBPU_2SEC_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_bbpu_2sec_stat_sta(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_RTC_AL_SEC), (&val),
				(unsigned int)(PMIC_BBPU_2SEC_STAT_STA_MASK),
				(unsigned int)(PMIC_BBPU_2SEC_STAT_STA_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rtc_lpd_opt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_LPD_OPT_MASK),
				    (unsigned int)(PMIC_RTC_LPD_OPT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_k_eosc32_vtcxo_on_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_AL_SEC), (unsigned int)(val),
	    (unsigned int)(PMIC_K_EOSC32_VTCXO_ON_SEL_MASK),
	    (unsigned int)(PMIC_K_EOSC32_VTCXO_ON_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_al_minute(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MIN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AL_MINUTE_MASK),
				    (unsigned int)(PMIC_AL_MINUTE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_al_hour(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_HOU),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AL_HOUR_MASK),
				    (unsigned int)(PMIC_AL_HOUR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_new_spare0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_HOU),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_NEW_SPARE0_MASK),
				    (unsigned int)(PMIC_NEW_SPARE0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_al_dom(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_DOM),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AL_DOM_MASK),
				    (unsigned int)(PMIC_AL_DOM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_new_spare1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_DOM),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_NEW_SPARE1_MASK),
				    (unsigned int)(PMIC_NEW_SPARE1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_al_dow(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_DOW),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AL_DOW_MASK),
				    (unsigned int)(PMIC_AL_DOW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_new_spare2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_DOW),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_NEW_SPARE2_MASK),
				    (unsigned int)(PMIC_NEW_SPARE2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_al_month(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MTH),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AL_MONTH_MASK),
				    (unsigned int)(PMIC_AL_MONTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_new_spare3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_MTH),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_NEW_SPARE3_MASK),
				    (unsigned int)(PMIC_NEW_SPARE3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_al_year(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_YEA),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_AL_YEAR_MASK),
				    (unsigned int)(PMIC_AL_YEAR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_k_eosc_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_AL_YEA),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_K_EOSC_RSV_MASK),
				    (unsigned int)(PMIC_RTC_K_EOSC_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xosccali(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_OSC32CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XOSCCALI_MASK),
				    (unsigned int)(PMIC_XOSCCALI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rtc_xosc32_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_OSC32CON), (&val),
				  (unsigned int)(PMIC_RTC_XOSC32_ENB_MASK),
				  (unsigned int)(PMIC_RTC_XOSC32_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rtc_embck_sel_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_OSC32CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RTC_EMBCK_SEL_MODE_MASK),
	    (unsigned int)(PMIC_RTC_EMBCK_SEL_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_embck_src_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_OSC32CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RTC_EMBCK_SRC_SEL_MASK),
	    (unsigned int)(PMIC_RTC_EMBCK_SRC_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_embck_sel_option(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_OSC32CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RTC_EMBCK_SEL_OPTION_MASK),
	    (unsigned int)(PMIC_RTC_EMBCK_SEL_OPTION_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_eosc32_opt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_OSC32CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_EOSC32_OPT_MASK),
				    (unsigned int)(PMIC_RTC_EOSC32_OPT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_eosc32_vct_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_OSC32CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RTC_EOSC32_VCT_EN_MASK),
	    (unsigned int)(PMIC_RTC_EOSC32_VCT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_eosc32_chop_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_OSC32CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RTC_EOSC32_CHOP_EN_MASK),
	    (unsigned int)(PMIC_RTC_EOSC32_CHOP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_gp_osc32_con(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_OSC32CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RTC_GP_OSC32_CON_MASK),
	    (unsigned int)(PMIC_RTC_GP_OSC32_CON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_reg_xosc32_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_OSC32CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RTC_REG_XOSC32_ENB_MASK),
	    (unsigned int)(PMIC_RTC_REG_XOSC32_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_powerkey1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_POWERKEY1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_POWERKEY1_MASK),
				    (unsigned int)(PMIC_RTC_POWERKEY1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_powerkey2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_POWERKEY2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_POWERKEY2_MASK),
				    (unsigned int)(PMIC_RTC_POWERKEY2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_pdn1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_PDN1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_PDN1_MASK),
				    (unsigned int)(PMIC_RTC_PDN1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_pdn2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_PDN2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_PDN2_MASK),
				    (unsigned int)(PMIC_RTC_PDN2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_spar0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_SPAR0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_SPAR0_MASK),
				    (unsigned int)(PMIC_RTC_SPAR0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_spar1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_SPAR1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_SPAR1_MASK),
				    (unsigned int)(PMIC_RTC_SPAR1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_prot(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_PROT),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_PROT_MASK),
				    (unsigned int)(PMIC_RTC_PROT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_diff(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_DIFF),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_DIFF_MASK),
				    (unsigned int)(PMIC_RTC_DIFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_power_detected(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_DIFF), (&val),
				  (unsigned int)(PMIC_POWER_DETECTED_MASK),
				  (unsigned int)(PMIC_POWER_DETECTED_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_k_eosc32_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_DIFF),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_K_EOSC32_RSV_MASK),
				    (unsigned int)(PMIC_K_EOSC32_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_cali_rd_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_DIFF),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_CALI_RD_SEL_MASK),
				    (unsigned int)(PMIC_CALI_RD_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_cali(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CALI),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_CALI_MASK),
				    (unsigned int)(PMIC_RTC_CALI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_cali_wr_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CALI),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_CALI_WR_SEL_MASK),
				    (unsigned int)(PMIC_CALI_WR_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_k_eosc32_overflow(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CALI), (unsigned int)(val),
	    (unsigned int)(PMIC_K_EOSC32_OVERFLOW_MASK),
	    (unsigned int)(PMIC_K_EOSC32_OVERFLOW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_vbat_lpsta_raw(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_VBAT_LPSTA_RAW_MASK),
				    (unsigned int)(PMIC_VBAT_LPSTA_RAW_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_eosc32_lpen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_EOSC32_LPEN_MASK),
				    (unsigned int)(PMIC_EOSC32_LPEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_xosc32_lpen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_XOSC32_LPEN_MASK),
				    (unsigned int)(PMIC_XOSC32_LPEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_lprst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_LPRST_MASK), (unsigned int)(PMIC_LPRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_cdbo(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_CDBO_MASK), (unsigned int)(PMIC_CDBO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_f32kob(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_CON),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_F32KOB_MASK),
				    (unsigned int)(PMIC_F32KOB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpo(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_GPO_MASK), (unsigned int)(PMIC_GPO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_goe(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_GOE_MASK), (unsigned int)(PMIC_GOE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gsr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_GSR_MASK), (unsigned int)(PMIC_GSR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gsmt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_GSMT_MASK), (unsigned int)(PMIC_GSMT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_GPEN_MASK), (unsigned int)(PMIC_GPEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_gpu(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_GPU_MASK), (unsigned int)(PMIC_GPU_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_ge4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_GE4_MASK), (unsigned int)(PMIC_GE4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_ge8(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_GE8_MASK), (unsigned int)(PMIC_GE8_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_gpi(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_CON), (&val),
				  (unsigned int)(PMIC_GPI_MASK),
				  (unsigned int)(PMIC_GPI_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_lpsta_raw(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_CON), (&val),
				  (unsigned int)(PMIC_LPSTA_RAW_MASK),
				  (unsigned int)(PMIC_LPSTA_RAW_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_int_cnt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_INT_CNT), (&val),
				  (unsigned int)(PMIC_RTC_INT_CNT_MASK),
				  (unsigned int)(PMIC_RTC_INT_CNT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rtc_sec_dat0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_SEC_DAT0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_SEC_DAT0_MASK),
				    (unsigned int)(PMIC_RTC_SEC_DAT0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_sec_dat1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_SEC_DAT1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_SEC_DAT1_MASK),
				    (unsigned int)(PMIC_RTC_SEC_DAT1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_sec_dat2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_SEC_DAT2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_SEC_DAT2_MASK),
				    (unsigned int)(PMIC_RTC_SEC_DAT2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_eosc_cali_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_EOSC_CALI_DSN_ID),
				  (&val),
				  (unsigned int)(PMIC_EOSC_CALI_ANA_ID_MASK),
				  (unsigned int)(PMIC_EOSC_CALI_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_eosc_cali_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_EOSC_CALI_DSN_ID),
				  (&val),
				  (unsigned int)(PMIC_EOSC_CALI_DIG_ID_MASK),
				  (unsigned int)(PMIC_EOSC_CALI_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_eosc_cali_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_EOSC_CALI_DSN_REV0), (&val),
	    (unsigned int)(PMIC_EOSC_CALI_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_EOSC_CALI_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_eosc_cali_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_EOSC_CALI_DSN_REV0), (&val),
	    (unsigned int)(PMIC_EOSC_CALI_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_EOSC_CALI_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_eosc_cali_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_EOSC_CALI_DSN_REV0), (&val),
	    (unsigned int)(PMIC_EOSC_CALI_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_EOSC_CALI_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_eosc_cali_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_EOSC_CALI_DSN_REV0), (&val),
	    (unsigned int)(PMIC_EOSC_CALI_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_EOSC_CALI_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_eosc_cali_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_EOSC_CALI_DSN_REV1), (&val),
	    (unsigned int)(PMIC_EOSC_CALI_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_EOSC_CALI_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_eosc_cali_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_EOSC_CALI_DSN_REV1), (&val),
	    (unsigned int)(PMIC_EOSC_CALI_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_EOSC_CALI_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_eosc_cali_start(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_EOSC_CALI_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_EOSC_CALI_START_MASK),
	    (unsigned int)(PMIC_EOSC_CALI_START_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_eosc_cali_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_EOSC_CALI_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_EOSC_CALI_TD_MASK),
				    (unsigned int)(PMIC_EOSC_CALI_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_eosc_cali_test(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_EOSC_CALI_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_EOSC_CALI_TEST_MASK),
				    (unsigned int)(PMIC_EOSC_CALI_TEST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_eosc_cali_dcxo_rdy_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_EOSC_CALI_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_EOSC_CALI_DCXO_RDY_TD_MASK),
	    (unsigned int)(PMIC_EOSC_CALI_DCXO_RDY_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_frc_vtcxo0_on(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_EOSC_CALI_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_FRC_VTCXO0_ON_MASK),
				    (unsigned int)(PMIC_FRC_VTCXO0_ON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_eosc_cali_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_EOSC_CALI_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_EOSC_CALI_RSV_MASK),
				    (unsigned int)(PMIC_EOSC_CALI_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_mix_eosc32_stp_lpdtb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON0), (&val),
	    (unsigned int)(PMIC_MIX_EOSC32_STP_LPDTB_MASK),
	    (unsigned int)(PMIC_MIX_EOSC32_STP_LPDTB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_mix_eosc32_stp_lpden(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_EOSC32_STP_LPDEN_MASK),
	    (unsigned int)(PMIC_MIX_EOSC32_STP_LPDEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_xosc32_stp_pwdb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_PWDB_MASK),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_PWDB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_mix_xosc32_stp_lpdtb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON0), (&val),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_LPDTB_MASK),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_LPDTB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_mix_xosc32_stp_lpden(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_LPDEN_MASK),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_LPDEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_xosc32_stp_lpdrst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_LPDRST_MASK),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_LPDRST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_xosc32_stp_cali(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_CALI_MASK),
	    (unsigned int)(PMIC_MIX_XOSC32_STP_CALI_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_stmp_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_MIX_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_STMP_MODE_MASK),
				    (unsigned int)(PMIC_STMP_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_eosc32_stp_chop_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_EOSC32_STP_CHOP_EN_MASK),
	    (unsigned int)(PMIC_MIX_EOSC32_STP_CHOP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_dcxo_stp_lvsh_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_DCXO_STP_LVSH_EN_MASK),
	    (unsigned int)(PMIC_MIX_DCXO_STP_LVSH_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_pmu_stp_ddlo_vrtc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_PMU_STP_DDLO_VRTC_MASK),
	    (unsigned int)(PMIC_MIX_PMU_STP_DDLO_VRTC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_pmu_stp_ddlo_vrtc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_PMU_STP_DDLO_VRTC_EN_MASK),
	    (unsigned int)(PMIC_MIX_PMU_STP_DDLO_VRTC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_rtc_stp_xosc32_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_RTC_STP_XOSC32_ENB_MASK),
	    (unsigned int)(PMIC_MIX_RTC_STP_XOSC32_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_dcxo_stp_test_deglitch_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_MASK),
	    (unsigned int)(PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_eosc32_stp_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_EOSC32_STP_RSV_MASK),
	    (unsigned int)(PMIC_MIX_EOSC32_STP_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_eosc32_vct_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_EOSC32_VCT_EN_MASK),
	    (unsigned int)(PMIC_MIX_EOSC32_VCT_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_eosc32_opt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_MIX_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_MIX_EOSC32_OPT_MASK),
				    (unsigned int)(PMIC_MIX_EOSC32_OPT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_dcxo_stp_lvsh_en_int(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_DCXO_STP_LVSH_EN_INT_MASK),
	    (unsigned int)(PMIC_MIX_DCXO_STP_LVSH_EN_INT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_rtc_gpio_coredetb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_RTC_GPIO_COREDETB_MASK),
	    (unsigned int)(PMIC_MIX_RTC_GPIO_COREDETB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_rtc_gpio_f32kob(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_RTC_GPIO_F32KOB_MASK),
	    (unsigned int)(PMIC_MIX_RTC_GPIO_F32KOB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_rtc_gpio_gpo(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_RTC_GPIO_GPO_MASK),
	    (unsigned int)(PMIC_MIX_RTC_GPIO_GPO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_rtc_gpio_oe(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_RTC_GPIO_OE_MASK),
	    (unsigned int)(PMIC_MIX_RTC_GPIO_OE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_mix_rtc_stp_debug_out(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON2), (&val),
	    (unsigned int)(PMIC_MIX_RTC_STP_DEBUG_OUT_MASK),
	    (unsigned int)(PMIC_MIX_RTC_STP_DEBUG_OUT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_mix_rtc_stp_debug_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_RTC_STP_DEBUG_SEL_MASK),
	    (unsigned int)(PMIC_MIX_RTC_STP_DEBUG_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_rtc_stp_k_eosc32_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_RTC_STP_K_EOSC32_EN_MASK),
	    (unsigned int)(PMIC_MIX_RTC_STP_K_EOSC32_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_rtc_stp_embck_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_RTC_STP_EMBCK_SEL_MASK),
	    (unsigned int)(PMIC_MIX_RTC_STP_EMBCK_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_mix_stp_bbwakeup(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_STP_BBWAKEUP_MASK),
	    (unsigned int)(PMIC_MIX_STP_BBWAKEUP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_mix_stp_rtc_ddlo(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_RTC_MIX_CON2), (&val),
				  (unsigned int)(PMIC_MIX_STP_RTC_DDLO_MASK),
				  (unsigned int)(PMIC_MIX_STP_RTC_DDLO_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_mix_rtc_xosc32_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_RTC_MIX_CON2), (&val),
				(unsigned int)(PMIC_MIX_RTC_XOSC32_ENB_MASK),
				(unsigned int)(PMIC_MIX_RTC_XOSC32_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_mix_efuse_xosc32_enb_opt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_RTC_MIX_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_MIX_EFUSE_XOSC32_ENB_OPT_MASK),
	    (unsigned int)(PMIC_MIX_EFUSE_XOSC32_ENB_OPT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rtc_sec_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_RTC_SEC_DSN_ID), (&val),
				(unsigned int)(PMIC_RTC_SEC_ANA_ID_MASK),
				(unsigned int)(PMIC_RTC_SEC_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_sec_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_RTC_SEC_DSN_ID), (&val),
				(unsigned int)(PMIC_RTC_SEC_DIG_ID_MASK),
				(unsigned int)(PMIC_RTC_SEC_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_sec_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RTC_SEC_DSN_REV0), (&val),
	    (unsigned int)(PMIC_RTC_SEC_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_RTC_SEC_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_sec_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RTC_SEC_DSN_REV0), (&val),
	    (unsigned int)(PMIC_RTC_SEC_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_RTC_SEC_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_sec_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RTC_SEC_DSN_REV0), (&val),
	    (unsigned int)(PMIC_RTC_SEC_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_RTC_SEC_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_sec_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RTC_SEC_DSN_REV0), (&val),
	    (unsigned int)(PMIC_RTC_SEC_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_RTC_SEC_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_sec_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RTC_SEC_DSN_REV1), (&val),
	    (unsigned int)(PMIC_RTC_SEC_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_RTC_SEC_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rtc_sec_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_RTC_SEC_DSN_REV1), (&val),
	    (unsigned int)(PMIC_RTC_SEC_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_RTC_SEC_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rtc_sec_dummy(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_SEC_DUMMY_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_SEC_DUMMY_MASK),
				    (unsigned int)(PMIC_RTC_SEC_DUMMY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_second_sec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_SEC_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_SECOND_SEC_MASK),
				    (unsigned int)(PMIC_TC_SECOND_SEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_minute_sec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_MIN_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_MINUTE_SEC_MASK),
				    (unsigned int)(PMIC_TC_MINUTE_SEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_hour_sec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_HOU_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_HOUR_SEC_MASK),
				    (unsigned int)(PMIC_TC_HOUR_SEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_dom_sec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_DOM_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_DOM_SEC_MASK),
				    (unsigned int)(PMIC_TC_DOM_SEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_dow_sec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_DOW_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_DOW_SEC_MASK),
				    (unsigned int)(PMIC_TC_DOW_SEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_month_sec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_MTH_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_MONTH_SEC_MASK),
				    (unsigned int)(PMIC_TC_MONTH_SEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_tc_year_sec(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_TC_YEA_SEC),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_TC_YEAR_SEC_MASK),
				    (unsigned int)(PMIC_TC_YEAR_SEC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rtc_sec_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_RTC_SEC_CK_PDN),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RTC_SEC_CK_PDN_MASK),
				    (unsigned int)(PMIC_RTC_SEC_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_buck_top_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_TOP_ANA_ID_MASK),
				(unsigned int)(PMIC_BUCK_TOP_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_top_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_TOP_DIG_ID_MASK),
				(unsigned int)(PMIC_BUCK_TOP_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_top_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_TOP_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_TOP_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_top_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_TOP_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_TOP_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_top_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_TOP_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_TOP_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_top_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_TOP_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_TOP_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_top_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_TOP_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_TOP_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_top_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_TOP_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_TOP_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck32k_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK32K_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BUCK32K_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck1m_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK1M_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BUCK1M_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck26m_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK26M_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BUCK26M_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_ana_auto_off_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_ana_ck_pdn(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_ANA_CK_PDN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_ANA_CK_PDN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_buck_top_clk_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BUCK_TOP_CLK_CON0_RSV_MASK),
	    (unsigned int)(PMIC_BUCK_TOP_CLK_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck32k_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_HWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK32K_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_BUCK32K_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck1m_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_HWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK1M_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_BUCK1M_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck26m_ck_pdn_hwen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_HWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK26M_CK_PDN_HWEN_MASK),
	    (unsigned int)(PMIC_RG_BUCK26M_CK_PDN_HWEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_dcm_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_HWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_DCM_MODE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_DCM_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_buck_top_clk_hwen_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_HWEN_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_BUCK_TOP_CLK_HWEN_CON0_RSV_MASK),
	    (unsigned int)(PMIC_BUCK_TOP_CLK_HWEN_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_freq_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_MISC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_FREQ_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_FREQ_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_freq_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_MISC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_FREQ_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_FREQ_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_freq_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_MISC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_FREQ_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_FREQ_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_freq_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_MISC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_FREQ_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_FREQ_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_freq_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_MISC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_FREQ_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_FREQ_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_freq_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_CLK_MISC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_FREQ_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_FREQ_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_rst_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_RST_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_RST_CON0_RSV_MASK),
	    (unsigned int)(PMIC_RG_RST_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_en_vproc_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_VPROC_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VPROC_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_vproc_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_VPROC_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VPROC_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_vcore_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_VCORE_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VCORE_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_vcore_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_VCORE_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VCORE_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_vmodem_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_VMODEM_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VMODEM_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_vmodem_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_VMODEM_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VMODEM_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_vs1_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_VS1_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VS1_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_vs1_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_INT_CON0),
				  (&val),
				  (unsigned int)(PMIC_RG_INT_EN_VS1_OC_MASK),
				  (unsigned int)(PMIC_RG_INT_EN_VS1_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_vs2_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_VS2_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VS2_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_vs2_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_INT_CON0),
				  (&val),
				  (unsigned int)(PMIC_RG_INT_EN_VS2_OC_MASK),
				  (unsigned int)(PMIC_RG_INT_EN_VS2_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_vpa_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_VPA_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VPA_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_vpa_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_INT_CON0),
				  (&val),
				  (unsigned int)(PMIC_RG_INT_EN_VPA_OC_MASK),
				  (unsigned int)(PMIC_RG_INT_EN_VPA_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_en_vcore_preoc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_EN_VCORE_PREOC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VCORE_PREOC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_en_vcore_preoc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_CON0), (&val),
	    (unsigned int)(PMIC_RG_INT_EN_VCORE_PREOC_MASK),
	    (unsigned int)(PMIC_RG_INT_EN_VCORE_PREOC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_int_mask_vproc_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_VPROC_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_VPROC_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_vcore_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_VCORE_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_VCORE_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_vmodem_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_VMODEM_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_VMODEM_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_vs1_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_VS1_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_VS1_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_vs2_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_VS2_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_VS2_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_vpa_oc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_VPA_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_VPA_OC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_int_mask_vcore_preoc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_MASK_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_INT_MASK_VCORE_PREOC_MASK),
	    (unsigned int)(PMIC_RG_INT_MASK_VCORE_PREOC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_int_status_vproc_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_VPROC_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_VPROC_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_vcore_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_VCORE_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_VCORE_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_vmodem_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_VMODEM_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_VMODEM_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_vs1_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_VS1_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_VS1_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_vs2_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_VS2_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_VS2_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_vpa_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_VPA_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_VPA_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_status_vcore_preoc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_STATUS_VCORE_PREOC_MASK),
	    (unsigned int)(PMIC_RG_INT_STATUS_VCORE_PREOC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_vproc_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VPROC_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VPROC_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_vcore_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VCORE_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VCORE_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_vmodem_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VMODEM_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VMODEM_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_vs1_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VS1_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VS1_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_vs2_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VS2_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VS2_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_vpa_oc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VPA_OC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VPA_OC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_int_raw_status_vcore_preoc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_INT_RAW_STATUS0), (&val),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VCORE_PREOC_MASK),
	    (unsigned int)(PMIC_RG_INT_RAW_STATUS_VCORE_PREOC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_all_con0_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ALL_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_ALL_CON0_RSV_MASK),
	    (unsigned int)(PMIC_RG_BUCK_ALL_CON0_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_stb_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_STB_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_STB_MAX_MASK),
	    (unsigned int)(PMIC_RG_BUCK_STB_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_lp_prot_disable(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_STB_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_LP_PROT_DISABLE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_LP_PROT_DISABLE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vsleep_src0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_SLP_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VSLEEP_SRC0_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VSLEEP_SRC0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vsleep_src1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_SLP_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VSLEEP_SRC1_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VSLEEP_SRC1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_r2r_src0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_SLP_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_R2R_SRC0_MASK),
	    (unsigned int)(PMIC_RG_BUCK_R2R_SRC0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_r2r_src1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_SLP_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_R2R_SRC1_MASK),
	    (unsigned int)(PMIC_RG_BUCK_R2R_SRC1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_lp_seq_count(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_SLP_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_LP_SEQ_COUNT_MASK),
	    (unsigned int)(PMIC_RG_BUCK_LP_SEQ_COUNT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_on_seq_count(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_SLP_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_ON_SEQ_COUNT_MASK),
	    (unsigned int)(PMIC_RG_BUCK_ON_SEQ_COUNT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_minfreq_latency_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_MINFREQ_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_MINFREQ_LATENCY_MAX_MASK),
	    (unsigned int)(PMIC_RG_BUCK_MINFREQ_LATENCY_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_minfreq_duration_max(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_MINFREQ_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_MINFREQ_DURATION_MAX_MASK),
	    (unsigned int)(PMIC_RG_BUCK_MINFREQ_DURATION_MAX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_oc_sdn_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_OC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_SDN_STATUS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_SDN_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_oc_sdn_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_OC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_SDN_STATUS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_SDN_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_oc_sdn_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_OC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_SDN_STATUS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_SDN_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_oc_sdn_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_OC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_SDN_STATUS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_SDN_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_oc_sdn_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_OC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_SDN_STATUS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_SDN_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_oc_sdn_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_OC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_SDN_STATUS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_SDN_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_k_rst_done(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_K_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_K_RST_DONE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_K_RST_DONE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_k_map_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_K_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_K_MAP_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_K_MAP_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_k_once_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_K_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_K_ONCE_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_K_ONCE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_k_once_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_K_CON0), (&val),
				(unsigned int)(PMIC_RG_BUCK_K_ONCE_EN_MASK),
				(unsigned int)(PMIC_RG_BUCK_K_ONCE_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_k_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BUCK_TOP_K_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BUCK_K_ONCE_MASK),
				    (unsigned int)(PMIC_RG_BUCK_K_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_k_start_manual(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_K_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_K_START_MANUAL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_K_START_MANUAL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_k_src_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_K_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_K_SRC_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_K_SRC_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_k_auto_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_K_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_K_AUTO_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_K_AUTO_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_k_auto_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_K_CON0), (&val),
				(unsigned int)(PMIC_RG_BUCK_K_AUTO_EN_MASK),
				(unsigned int)(PMIC_RG_BUCK_K_AUTO_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_k_inv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BUCK_TOP_K_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BUCK_K_INV_MASK),
				    (unsigned int)(PMIC_RG_BUCK_K_INV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_k_ck_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_K_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_K_CK_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_K_CK_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_k_ck_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_K_CON0), (&val),
				(unsigned int)(PMIC_RG_BUCK_K_CK_EN_MASK),
				(unsigned int)(PMIC_RG_BUCK_K_CK_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_k_result(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_K_CON1), (&val),
				(unsigned int)(PMIC_BUCK_K_RESULT_MASK),
				(unsigned int)(PMIC_BUCK_K_RESULT_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_k_done(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_K_CON1), (&val),
				(unsigned int)(PMIC_BUCK_K_DONE_MASK),
				(unsigned int)(PMIC_BUCK_K_DONE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_k_control(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_K_CON1), (&val),
				(unsigned int)(PMIC_BUCK_K_CONTROL_MASK),
				(unsigned int)(PMIC_BUCK_K_CONTROL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_smps_osc_cal(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_TOP_K_CON1), (&val),
				(unsigned int)(PMIC_DA_SMPS_OSC_CAL_MASK),
				(unsigned int)(PMIC_DA_SMPS_OSC_CAL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_k_buck_ck_cnt(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_K_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_K_BUCK_CK_CNT_MASK),
	    (unsigned int)(PMIC_RG_BUCK_K_BUCK_CK_CNT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_buck_vproc_wdtdbg_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_WDTDBG0), (&val),
	    (unsigned int)(PMIC_BUCK_VPROC_WDTDBG_VOSEL_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_WDTDBG_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vcore_wdtdbg_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_WDTDBG0), (&val),
	    (unsigned int)(PMIC_BUCK_VCORE_WDTDBG_VOSEL_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_WDTDBG_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vmodem_wdtdbg_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_WDTDBG1), (&val),
	    (unsigned int)(PMIC_BUCK_VMODEM_WDTDBG_VOSEL_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_WDTDBG_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs1_wdtdbg_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_WDTDBG1), (&val),
	    (unsigned int)(PMIC_BUCK_VS1_WDTDBG_VOSEL_MASK),
	    (unsigned int)(PMIC_BUCK_VS1_WDTDBG_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs2_wdtdbg_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_WDTDBG2), (&val),
	    (unsigned int)(PMIC_BUCK_VS2_WDTDBG_VOSEL_MASK),
	    (unsigned int)(PMIC_BUCK_VS2_WDTDBG_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vpa_wdtdbg_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_WDTDBG2), (&val),
	    (unsigned int)(PMIC_BUCK_VPA_WDTDBG_VOSEL_MASK),
	    (unsigned int)(PMIC_BUCK_VPA_WDTDBG_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_buck_top_elr_len(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR_NUM), (unsigned int)(val),
	    (unsigned int)(PMIC_BUCK_TOP_ELR_LEN_MASK),
	    (unsigned int)(PMIC_BUCK_TOP_ELR_LEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_oc_sdn_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_SDN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_oc_sdn_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_SDN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_oc_sdn_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_SDN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_oc_sdn_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_SDN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_oc_sdn_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_SDN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_oc_sdn_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_SDN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_oc_sdn_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_SDN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_oc_sdn_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_SDN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_oc_sdn_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_SDN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_oc_sdn_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_SDN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_oc_sdn_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_SDN_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_oc_sdn_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_SDN_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_SDN_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_oc_sdn_en_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_OC_SDN_EN_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_OC_SDN_EN_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_oc_sdn_en_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_OC_SDN_EN_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_OC_SDN_EN_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_k_control_smps(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_K_CONTROL_SMPS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_K_CONTROL_SMPS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_vosel_limit_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_LIMIT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_vosel_limit_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_LIMIT_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_vosel_limit_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_vosel_limit_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_vosel_limit_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_LIMIT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_vosel_limit_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_LIMIT_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_vosel_limit_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_vosel_limit_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_vosel_limit_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_LIMIT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_vosel_limit_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_LIMIT_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_vosel_limit_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_LIMIT_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_vosel_limit_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_TOP_ELR1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_LIMIT_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_LIMIT_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vproc_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DSN_ID), (&val),
	    (unsigned int)(PMIC_BUCK_VPROC_ANA_ID_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vproc_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DSN_ID), (&val),
	    (unsigned int)(PMIC_BUCK_VPROC_DIG_ID_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vproc_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VPROC_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vproc_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VPROC_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vproc_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VPROC_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vproc_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VPROC_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vproc_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VPROC_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vproc_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VPROC_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPROC_CON0), (&val),
				(unsigned int)(PMIC_RG_BUCK_VPROC_EN_MASK),
				(unsigned int)(PMIC_RG_BUCK_VPROC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_lp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_LP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_LP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_vosel_sleep(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_SLEEP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_vosel_sleep(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CON1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_SLEEP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_sfchg_frate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SFCHG_FRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SFCHG_FRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_sfchg_fen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SFCHG_FEN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SFCHG_FEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_sfchg_rrate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SFCHG_RRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SFCHG_RRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_sfchg_ren(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SFCHG_REN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SFCHG_REN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_dvs_en_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_dvs_en_td(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_TD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_dvs_en_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_dvs_en_ctrl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_CTRL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_dvs_en_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_dvs_en_once(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_EN_ONCE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_dvs_down_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_DOWN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_DOWN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_dvs_down_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_DOWN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_DOWN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_dvs_down_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_DOWN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_DVS_DOWN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_sw_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SW_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_sw_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SW_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_hw0_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW0_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_hw0_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW0_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_hw1_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW1_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_hw1_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW1_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_hw2_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW2_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_hw2_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW2_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_hw0_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW0_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_hw0_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW0_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_hw1_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW1_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_hw1_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW1_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_hw2_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW2_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_hw2_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_HW2_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_on_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_ON_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_ON_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_lp_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_LP_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_LP_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_sp_sw_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_SP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_sp_sw_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_SP_CON), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_sp_sw_vosel_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_sp_sw_vosel_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_EN_SHIFT));

	return val;
}

unsigned int
mt6356_upmu_set_rg_buck_vproc_sp_on_vosel_mux_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_sp_on_vosel_mux_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_oc_deg_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_DEG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_oc_deg_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OC_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_DEG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_oc_wnd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_WND_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_WND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_oc_thd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_THD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_THD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_vproc_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPROC_DBG0), (&val),
				(unsigned int)(PMIC_DA_VPROC_VOSEL_MASK),
				(unsigned int)(PMIC_DA_VPROC_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vproc_vosel_gray(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DBG0), (&val),
	    (unsigned int)(PMIC_DA_VPROC_VOSEL_GRAY_MASK),
	    (unsigned int)(PMIC_DA_VPROC_VOSEL_GRAY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vproc_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPROC_DBG1), (&val),
				(unsigned int)(PMIC_DA_VPROC_EN_MASK),
				(unsigned int)(PMIC_DA_VPROC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vproc_stb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPROC_DBG1), (&val),
				(unsigned int)(PMIC_DA_VPROC_STB_MASK),
				(unsigned int)(PMIC_DA_VPROC_STB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vproc_vsleep_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DBG1), (&val),
	    (unsigned int)(PMIC_DA_VPROC_VSLEEP_SEL_MASK),
	    (unsigned int)(PMIC_DA_VPROC_VSLEEP_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vproc_r2r_pdn(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPROC_DBG1), (&val),
				(unsigned int)(PMIC_DA_VPROC_R2R_PDN_MASK),
				(unsigned int)(PMIC_DA_VPROC_R2R_PDN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vproc_dvs_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPROC_DBG1), (&val),
				(unsigned int)(PMIC_DA_VPROC_DVS_EN_MASK),
				(unsigned int)(PMIC_DA_VPROC_DVS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vproc_dvs_down(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPROC_DBG1), (&val),
				(unsigned int)(PMIC_DA_VPROC_DVS_DOWN_MASK),
				(unsigned int)(PMIC_DA_VPROC_DVS_DOWN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vproc_ssh(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPROC_DBG1), (&val),
				(unsigned int)(PMIC_DA_VPROC_SSH_MASK),
				(unsigned int)(PMIC_DA_VPROC_SSH_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vproc_minfreq_discharge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DBG1), (&val),
	    (unsigned int)(PMIC_DA_VPROC_MINFREQ_DISCHARGE_MASK),
	    (unsigned int)(PMIC_DA_VPROC_MINFREQ_DISCHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_oc_flag_clr_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_FLAG_CLR_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OC_FLAG_CLR_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_osc_sel_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OSC_SEL_DIS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_OSC_SEL_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_DBG2), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_buck_vproc_elr_len(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_ELR_NUM), (unsigned int)(val),
	    (unsigned int)(PMIC_BUCK_VPROC_ELR_LEN_MASK),
	    (unsigned int)(PMIC_BUCK_VPROC_ELR_LEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vproc_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vproc_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPROC_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPROC_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vcore_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DSN_ID), (&val),
	    (unsigned int)(PMIC_BUCK_VCORE_ANA_ID_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vcore_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DSN_ID), (&val),
	    (unsigned int)(PMIC_BUCK_VCORE_DIG_ID_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vcore_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VCORE_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vcore_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VCORE_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vcore_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VCORE_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vcore_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VCORE_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vcore_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VCORE_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vcore_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VCORE_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VCORE_CON0), (&val),
				(unsigned int)(PMIC_RG_BUCK_VCORE_EN_MASK),
				(unsigned int)(PMIC_RG_BUCK_VCORE_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_lp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_LP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_LP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_vosel_sleep(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_SLEEP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_vosel_sleep(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CON1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_SLEEP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_sfchg_frate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SFCHG_FRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SFCHG_FRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_sfchg_fen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SFCHG_FEN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SFCHG_FEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_sfchg_rrate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SFCHG_RRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SFCHG_RRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_sfchg_ren(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SFCHG_REN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SFCHG_REN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_dvs_en_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_dvs_en_td(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_TD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_dvs_en_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_dvs_en_ctrl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_CTRL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_dvs_en_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_dvs_en_once(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_EN_ONCE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_dvs_down_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_DOWN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_DOWN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_dvs_down_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_DOWN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_DOWN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_dvs_down_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_DOWN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_DVS_DOWN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_sw_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SW_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_sw_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SW_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_hw0_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW0_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_hw0_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW0_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_hw1_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW1_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_hw1_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW1_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_hw2_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW2_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_hw2_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW2_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_hw0_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW0_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_hw0_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW0_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_hw1_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW1_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_hw1_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW1_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_hw2_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW2_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_hw2_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_HW2_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_on_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_ON_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_ON_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_lp_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_LP_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_LP_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_sp_sw_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_SP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_sp_sw_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_SP_CON), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_sp_sw_vosel_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_sp_sw_vosel_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_EN_SHIFT));

	return val;
}

unsigned int
mt6356_upmu_set_rg_buck_vcore_sp_on_vosel_mux_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_sp_on_vosel_mux_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_oc_deg_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_DEG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_oc_deg_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OC_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_DEG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_oc_wnd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_WND_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_WND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_oc_thd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_THD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_THD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_vcore_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VCORE_DBG0), (&val),
				(unsigned int)(PMIC_DA_VCORE_VOSEL_MASK),
				(unsigned int)(PMIC_DA_VCORE_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vcore_vosel_gray(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DBG0), (&val),
	    (unsigned int)(PMIC_DA_VCORE_VOSEL_GRAY_MASK),
	    (unsigned int)(PMIC_DA_VCORE_VOSEL_GRAY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vcore_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VCORE_DBG1), (&val),
				(unsigned int)(PMIC_DA_VCORE_EN_MASK),
				(unsigned int)(PMIC_DA_VCORE_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vcore_stb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VCORE_DBG1), (&val),
				(unsigned int)(PMIC_DA_VCORE_STB_MASK),
				(unsigned int)(PMIC_DA_VCORE_STB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vcore_vsleep_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DBG1), (&val),
	    (unsigned int)(PMIC_DA_VCORE_VSLEEP_SEL_MASK),
	    (unsigned int)(PMIC_DA_VCORE_VSLEEP_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vcore_r2r_pdn(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VCORE_DBG1), (&val),
				(unsigned int)(PMIC_DA_VCORE_R2R_PDN_MASK),
				(unsigned int)(PMIC_DA_VCORE_R2R_PDN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vcore_dvs_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VCORE_DBG1), (&val),
				(unsigned int)(PMIC_DA_VCORE_DVS_EN_MASK),
				(unsigned int)(PMIC_DA_VCORE_DVS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vcore_dvs_down(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VCORE_DBG1), (&val),
				(unsigned int)(PMIC_DA_VCORE_DVS_DOWN_MASK),
				(unsigned int)(PMIC_DA_VCORE_DVS_DOWN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vcore_ssh(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VCORE_DBG1), (&val),
				(unsigned int)(PMIC_DA_VCORE_SSH_MASK),
				(unsigned int)(PMIC_DA_VCORE_SSH_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vcore_minfreq_discharge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DBG1), (&val),
	    (unsigned int)(PMIC_DA_VCORE_MINFREQ_DISCHARGE_MASK),
	    (unsigned int)(PMIC_DA_VCORE_MINFREQ_DISCHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_oc_flag_clr_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_FLAG_CLR_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OC_FLAG_CLR_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_osc_sel_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OSC_SEL_DIS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_OSC_SEL_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_DBG2), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_buck_vcore_elr_len(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_ELR_NUM), (unsigned int)(val),
	    (unsigned int)(PMIC_BUCK_VCORE_ELR_LEN_MASK),
	    (unsigned int)(PMIC_BUCK_VCORE_ELR_LEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vcore_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vcore_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VCORE_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VCORE_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vmodem_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DSN_ID), (&val),
	    (unsigned int)(PMIC_BUCK_VMODEM_ANA_ID_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vmodem_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DSN_ID), (&val),
	    (unsigned int)(PMIC_BUCK_VMODEM_DIG_ID_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vmodem_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VMODEM_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vmodem_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VMODEM_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vmodem_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VMODEM_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vmodem_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VMODEM_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vmodem_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VMODEM_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vmodem_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VMODEM_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_lp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_LP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_LP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_vosel_sleep(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_SLEEP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_vosel_sleep(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CON1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_SLEEP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_sfchg_frate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SFCHG_FRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SFCHG_FRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_sfchg_fen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SFCHG_FEN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SFCHG_FEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_sfchg_rrate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SFCHG_RRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SFCHG_RRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_sfchg_ren(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SFCHG_REN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SFCHG_REN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dvs_en_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_dvs_en_td(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_TD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dvs_en_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_dvs_en_ctrl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_CTRL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dvs_en_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_dvs_en_once(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_EN_ONCE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dvs_down_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_DOWN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_DOWN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dvs_down_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_DOWN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_DOWN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dvs_down_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_DOWN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DVS_DOWN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_sw_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SW_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_sw_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SW_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_hw0_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW0_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_hw0_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW0_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_hw1_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW1_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_hw1_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW1_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_hw2_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW2_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_hw2_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW2_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_hw0_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW0_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_hw0_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW0_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_hw1_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW1_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_hw1_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW1_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_hw2_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW2_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_hw2_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_HW2_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_on_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_ON_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_ON_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_lp_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_LP_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_LP_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_sp_sw_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_SP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_sp_sw_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_SP_CON), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_sp_sw_vosel_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_sp_sw_vosel_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_EN_SHIFT));

	return val;
}

unsigned int
mt6356_upmu_set_rg_buck_vmodem_sp_on_vosel_mux_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_sp_on_vosel_mux_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_oc_deg_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_DEG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_oc_deg_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OC_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_DEG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_oc_wnd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_WND_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_WND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_oc_thd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_THD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_THD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_vmodem_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VMODEM_DBG0),
				  (&val),
				  (unsigned int)(PMIC_DA_VMODEM_VOSEL_MASK),
				  (unsigned int)(PMIC_DA_VMODEM_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vmodem_vosel_gray(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DBG0), (&val),
	    (unsigned int)(PMIC_DA_VMODEM_VOSEL_GRAY_MASK),
	    (unsigned int)(PMIC_DA_VMODEM_VOSEL_GRAY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vmodem_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VMODEM_DBG1),
				(&val), (unsigned int)(PMIC_DA_VMODEM_EN_MASK),
				(unsigned int)(PMIC_DA_VMODEM_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vmodem_stb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VMODEM_DBG1),
				  (&val),
				  (unsigned int)(PMIC_DA_VMODEM_STB_MASK),
				  (unsigned int)(PMIC_DA_VMODEM_STB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vmodem_vsleep_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DBG1), (&val),
	    (unsigned int)(PMIC_DA_VMODEM_VSLEEP_SEL_MASK),
	    (unsigned int)(PMIC_DA_VMODEM_VSLEEP_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vmodem_r2r_pdn(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DBG1), (&val),
	    (unsigned int)(PMIC_DA_VMODEM_R2R_PDN_MASK),
	    (unsigned int)(PMIC_DA_VMODEM_R2R_PDN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vmodem_dvs_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VMODEM_DBG1),
				  (&val),
				  (unsigned int)(PMIC_DA_VMODEM_DVS_EN_MASK),
				  (unsigned int)(PMIC_DA_VMODEM_DVS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vmodem_minfreq_discharge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DBG1), (&val),
	    (unsigned int)(PMIC_DA_VMODEM_MINFREQ_DISCHARGE_MASK),
	    (unsigned int)(PMIC_DA_VMODEM_MINFREQ_DISCHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_oc_flag_clr_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_FLAG_CLR_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OC_FLAG_CLR_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_osc_sel_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OSC_SEL_DIS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_OSC_SEL_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DBG2), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_vosel_dlc0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC0_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_vosel_dlc0(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC0_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC0_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_vosel_dlc1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC1_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_vosel_dlc1(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC1_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC1_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_vosel_dlc2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC2_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_vosel_dlc2(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC2_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_DLC2_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dlc0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC0_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dlc1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC1_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dlc2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC2_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dlc3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC3_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dlc_map_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC_MAP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC_MAP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_dlc_map_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON3), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC_MAP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC_MAP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_dlc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_DLC_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_DLC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_vmodem_dlc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VMODEM_DLC_CON3),
				  (&val),
				  (unsigned int)(PMIC_DA_VMODEM_DLC_MASK),
				  (unsigned int)(PMIC_DA_VMODEM_DLC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_buck_vmodem_elr_len(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_ELR_NUM), (unsigned int)(val),
	    (unsigned int)(PMIC_BUCK_VMODEM_ELR_LEN_MASK),
	    (unsigned int)(PMIC_BUCK_VMODEM_ELR_LEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vmodem_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vmodem_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VMODEM_ELR0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VMODEM_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs1_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_VS1_ANA_ID_MASK),
				(unsigned int)(PMIC_BUCK_VS1_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs1_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_VS1_DIG_ID_MASK),
				(unsigned int)(PMIC_BUCK_VS1_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs1_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VS1_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS1_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs1_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VS1_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS1_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs1_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VS1_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS1_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs1_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VS1_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS1_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs1_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VS1_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS1_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs1_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VS1_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS1_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BUCK_VS1_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BUCK_VS1_EN_MASK),
				    (unsigned int)(PMIC_RG_BUCK_VS1_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_CON0), (&val),
				  (unsigned int)(PMIC_RG_BUCK_VS1_EN_MASK),
				  (unsigned int)(PMIC_RG_BUCK_VS1_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_lp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BUCK_VS1_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BUCK_VS1_LP_MASK),
				    (unsigned int)(PMIC_RG_BUCK_VS1_LP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_vosel_sleep(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_SLEEP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_vosel_sleep(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CON1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_SLEEP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_sfchg_frate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SFCHG_FRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SFCHG_FRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_sfchg_fen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SFCHG_FEN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SFCHG_FEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_sfchg_rrate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SFCHG_RRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SFCHG_RRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_sfchg_ren(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SFCHG_REN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SFCHG_REN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_dvs_en_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_dvs_en_td(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_TD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_dvs_en_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_dvs_en_ctrl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_CTRL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_dvs_en_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_dvs_en_once(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_EN_ONCE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_dvs_down_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_DOWN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_DOWN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_dvs_down_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_DOWN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_DOWN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_dvs_down_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_DOWN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_DVS_DOWN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_sw_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SW_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_sw_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SW_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_hw0_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW0_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_hw0_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW0_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_hw1_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW1_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_hw1_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW1_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_hw2_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW2_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_hw2_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW2_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_hw0_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW0_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_hw0_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW0_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_hw1_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW1_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_hw1_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW1_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_hw2_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW2_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_hw2_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_HW2_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_on_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_ON_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_ON_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_lp_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_LP_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_LP_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_sp_sw_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_SP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_SW_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_sp_sw_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_SP_CON), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_SW_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_sp_sw_vosel_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_SW_VOSEL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_sp_sw_vosel_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_SW_VOSEL_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_sp_on_vosel_mux_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_sp_on_vosel_mux_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_oc_deg_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_DEG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_oc_deg_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OC_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_DEG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_oc_wnd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_WND_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_WND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_oc_thd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_THD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_THD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_vs1_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_DBG0), (&val),
				  (unsigned int)(PMIC_DA_VS1_VOSEL_MASK),
				  (unsigned int)(PMIC_DA_VS1_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs1_vosel_gray(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_DBG0), (&val),
				(unsigned int)(PMIC_DA_VS1_VOSEL_GRAY_MASK),
				(unsigned int)(PMIC_DA_VS1_VOSEL_GRAY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs1_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VS1_EN_MASK),
				  (unsigned int)(PMIC_DA_VS1_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs1_stb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VS1_STB_MASK),
				  (unsigned int)(PMIC_DA_VS1_STB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs1_vsleep_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_DBG1), (&val),
				(unsigned int)(PMIC_DA_VS1_VSLEEP_SEL_MASK),
				(unsigned int)(PMIC_DA_VS1_VSLEEP_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs1_r2r_pdn(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VS1_R2R_PDN_MASK),
				  (unsigned int)(PMIC_DA_VS1_R2R_PDN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs1_dvs_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VS1_DVS_EN_MASK),
				  (unsigned int)(PMIC_DA_VS1_DVS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs1_minfreq_discharge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DBG1), (&val),
	    (unsigned int)(PMIC_DA_VS1_MINFREQ_DISCHARGE_MASK),
	    (unsigned int)(PMIC_DA_VS1_MINFREQ_DISCHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_oc_flag_clr_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_FLAG_CLR_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OC_FLAG_CLR_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_osc_sel_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OSC_SEL_DIS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_OSC_SEL_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_DBG2), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_voter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_VOTER), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOTER_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_voter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_VOTER), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOTER_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_voter_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_VOTER_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOTER_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOTER_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_voter_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS1_VOTER_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOTER_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOTER_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_buck_vs1_elr_len(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_ELR_NUM), (unsigned int)(val),
	    (unsigned int)(PMIC_BUCK_VS1_ELR_LEN_MASK),
	    (unsigned int)(PMIC_BUCK_VS1_ELR_LEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs1_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS1_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs1_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS1_ELR0), (&val),
				(unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_MASK),
				(unsigned int)(PMIC_RG_BUCK_VS1_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs2_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_VS2_ANA_ID_MASK),
				(unsigned int)(PMIC_BUCK_VS2_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs2_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_VS2_DIG_ID_MASK),
				(unsigned int)(PMIC_BUCK_VS2_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs2_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VS2_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS2_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs2_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VS2_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS2_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs2_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VS2_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS2_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs2_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VS2_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS2_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs2_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VS2_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS2_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vs2_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VS2_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VS2_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BUCK_VS2_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BUCK_VS2_EN_MASK),
				    (unsigned int)(PMIC_RG_BUCK_VS2_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_CON0), (&val),
				  (unsigned int)(PMIC_RG_BUCK_VS2_EN_MASK),
				  (unsigned int)(PMIC_RG_BUCK_VS2_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_lp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BUCK_VS2_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BUCK_VS2_LP_MASK),
				    (unsigned int)(PMIC_RG_BUCK_VS2_LP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_vosel_sleep(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_SLEEP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_vosel_sleep(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CON1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_SLEEP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_SLEEP_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_sfchg_frate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SFCHG_FRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SFCHG_FRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_sfchg_fen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SFCHG_FEN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SFCHG_FEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_sfchg_rrate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SFCHG_RRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SFCHG_RRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_sfchg_ren(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SFCHG_REN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SFCHG_REN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_dvs_en_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_dvs_en_td(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_TD_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_dvs_en_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_dvs_en_ctrl(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_CTRL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_dvs_en_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_dvs_en_once(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_EN_ONCE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_dvs_down_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_DOWN_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_DOWN_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_dvs_down_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_DOWN_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_DOWN_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_dvs_down_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_DOWN_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_DVS_DOWN_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_sw_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SW_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_sw_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SW_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SW_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_hw0_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW0_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_hw0_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW0_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW0_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_hw1_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW1_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_hw1_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW1_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW1_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_hw2_op_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_EN), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW2_OP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_hw2_op_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_EN), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW2_OP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW2_OP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_hw0_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW0_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_hw0_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW0_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW0_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_hw1_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW1_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_hw1_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW1_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW1_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_hw2_op_cfg(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW2_OP_CFG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_hw2_op_cfg(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW2_OP_CFG_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_HW2_OP_CFG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_on_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_ON_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_ON_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_lp_op(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_LP_OP_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_LP_OP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_sp_sw_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_SP_CON), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_SW_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_sp_sw_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_SP_CON), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_SW_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_SW_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_sp_sw_vosel_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_SW_VOSEL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_sp_sw_vosel_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_SW_VOSEL_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_SW_VOSEL_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_sp_on_vosel_mux_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_SP_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_sp_on_vosel_mux_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_SP_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_ON_VOSEL_MUX_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_SP_ON_VOSEL_MUX_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_oc_deg_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_DEG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_oc_deg_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OC_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_DEG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_oc_wnd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_WND_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_WND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_oc_thd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_THD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_THD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_vs2_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_DBG0), (&val),
				  (unsigned int)(PMIC_DA_VS2_VOSEL_MASK),
				  (unsigned int)(PMIC_DA_VS2_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs2_vosel_gray(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_DBG0), (&val),
				(unsigned int)(PMIC_DA_VS2_VOSEL_GRAY_MASK),
				(unsigned int)(PMIC_DA_VS2_VOSEL_GRAY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs2_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VS2_EN_MASK),
				  (unsigned int)(PMIC_DA_VS2_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs2_stb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VS2_STB_MASK),
				  (unsigned int)(PMIC_DA_VS2_STB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs2_vsleep_sel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_DBG1), (&val),
				(unsigned int)(PMIC_DA_VS2_VSLEEP_SEL_MASK),
				(unsigned int)(PMIC_DA_VS2_VSLEEP_SEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs2_r2r_pdn(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VS2_R2R_PDN_MASK),
				  (unsigned int)(PMIC_DA_VS2_R2R_PDN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs2_dvs_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VS2_DVS_EN_MASK),
				  (unsigned int)(PMIC_DA_VS2_DVS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vs2_minfreq_discharge(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DBG1), (&val),
	    (unsigned int)(PMIC_DA_VS2_MINFREQ_DISCHARGE_MASK),
	    (unsigned int)(PMIC_DA_VS2_MINFREQ_DISCHARGE_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_oc_flag_clr_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_FLAG_CLR_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OC_FLAG_CLR_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_osc_sel_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OSC_SEL_DIS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_OSC_SEL_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_DBG2), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_voter_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_VOTER), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOTER_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOTER_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_voter_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_VOTER), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOTER_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOTER_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_voter_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_VOTER_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOTER_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOTER_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_voter_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VS2_VOTER_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOTER_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOTER_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_buck_vs2_elr_len(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_ELR_NUM), (unsigned int)(val),
	    (unsigned int)(PMIC_BUCK_VS2_ELR_LEN_MASK),
	    (unsigned int)(PMIC_BUCK_VS2_ELR_LEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vs2_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VS2_ELR0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vs2_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VS2_ELR0), (&val),
				(unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_MASK),
				(unsigned int)(PMIC_RG_BUCK_VS2_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vpa_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_VPA_ANA_ID_MASK),
				(unsigned int)(PMIC_BUCK_VPA_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vpa_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_VPA_DIG_ID_MASK),
				(unsigned int)(PMIC_BUCK_VPA_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vpa_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VPA_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPA_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vpa_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VPA_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPA_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vpa_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VPA_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPA_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vpa_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_VPA_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPA_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vpa_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VPA_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPA_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_vpa_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_VPA_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_VPA_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_BUCK_VPA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_BUCK_VPA_EN_MASK),
				    (unsigned int)(PMIC_RG_BUCK_VPA_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_CON0), (&val),
				  (unsigned int)(PMIC_RG_BUCK_VPA_EN_MASK),
				  (unsigned int)(PMIC_RG_BUCK_VPA_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_vosel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_CON1), (&val),
				(unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_MASK),
				(unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_sfchg_frate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_SFCHG_FRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_SFCHG_FRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_sfchg_fen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_SFCHG_FEN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_SFCHG_FEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_sfchg_rrate(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_SFCHG_RRATE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_SFCHG_RRATE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_sfchg_ren(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_SFCHG_REN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_SFCHG_REN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_dvs_transt_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_TRANST_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_TRANST_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_dvs_transt_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_TRANST_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_TRANST_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_dvs_transt_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_TRANST_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_TRANST_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_dvs_bw_td(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_BW_TD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_BW_TD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_dvs_bw_ctrl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_BW_CTRL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_BW_CTRL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_dvs_bw_once(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_CFG1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_BW_ONCE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DVS_BW_ONCE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_oc_deg_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_DEG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_oc_deg_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_OC_CFG), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_DEG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_DEG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_oc_wnd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_WND_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_WND_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_oc_thd(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_OC_CFG), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_THD_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_THD_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_vpa_vosel(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_DBG0), (&val),
				  (unsigned int)(PMIC_DA_VPA_VOSEL_MASK),
				  (unsigned int)(PMIC_DA_VPA_VOSEL_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vpa_vosel_gray(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_DBG0), (&val),
				(unsigned int)(PMIC_DA_VPA_VOSEL_GRAY_MASK),
				(unsigned int)(PMIC_DA_VPA_VOSEL_GRAY_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vpa_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VPA_EN_MASK),
				  (unsigned int)(PMIC_DA_VPA_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vpa_stb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VPA_STB_MASK),
				  (unsigned int)(PMIC_DA_VPA_STB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vpa_dvs_transt(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_DBG1), (&val),
				(unsigned int)(PMIC_DA_VPA_DVS_TRANST_MASK),
				(unsigned int)(PMIC_DA_VPA_DVS_TRANST_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_da_vpa_dvs_bw(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_DBG1), (&val),
				  (unsigned int)(PMIC_DA_VPA_DVS_BW_MASK),
				  (unsigned int)(PMIC_DA_VPA_DVS_BW_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_oc_flag_clr_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_FLAG_CLR_SEL_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OC_FLAG_CLR_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_osc_sel_dis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OSC_SEL_DIS_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_OSC_SEL_DIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_ck_sw_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_CK_SW_MODE_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_CK_SW_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_ck_sw_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DBG2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_CK_SW_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_ck_sw_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DBG2), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_CK_SW_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_CK_SW_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_vosel_dlc011(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DLC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC011_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC011_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_vosel_dlc011(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DLC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC011_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC011_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_vosel_dlc111(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DLC_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC111_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC111_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_vosel_dlc111(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DLC_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC111_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC111_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_vosel_dlc001(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DLC_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC001_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC001_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_vosel_dlc001(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DLC_CON1), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC001_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_VOSEL_DLC001_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_dlc_map_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DLC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DLC_MAP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DLC_MAP_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_dlc_map_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DLC_CON2), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DLC_MAP_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DLC_MAP_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_dlc(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_DLC_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DLC_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_DLC_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_da_vpa_dlc(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_BUCK_VPA_DLC_CON2),
				  (&val), (unsigned int)(PMIC_DA_VPA_DLC_MASK),
				  (unsigned int)(PMIC_DA_VPA_DLC_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_buck_vpa_msfg_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_CON0), (&val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_EN_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rdelta2go(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RDELTA2GO_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RDELTA2GO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_fdelta2go(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FDELTA2GO_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FDELTA2GO_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rrate0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RRATE0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE0_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rrate1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RRATE0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE1_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rrate2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RRATE1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE2_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rrate3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RRATE1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE3_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rrate4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RRATE2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE4_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rrate5(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RRATE2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE5_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RRATE5_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rthd0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RTHD0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD0_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rthd1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RTHD0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD1_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rthd2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RTHD1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD2_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rthd3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RTHD1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD3_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_rthd4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_RTHD2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD4_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_RTHD4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_frate0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FRATE0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE0_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_frate1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FRATE0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE1_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_frate2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FRATE1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE2_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_frate3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FRATE1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE3_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_frate4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FRATE2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE4_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_frate5(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FRATE2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE5_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FRATE5_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_fthd0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FTHD0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD0_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_fthd1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FTHD0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD1_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_fthd2(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FTHD1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD2_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD2_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_fthd3(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FTHD1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD3_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD3_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_buck_vpa_msfg_fthd4(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_BUCK_VPA_MSFG_FTHD2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD4_MASK),
	    (unsigned int)(PMIC_RG_BUCK_VPA_MSFG_FTHD4_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_buck_ana_ana_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_ANA_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_ANA_ANA_ID_MASK),
				(unsigned int)(PMIC_BUCK_ANA_ANA_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_ana_dig_id(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_BUCK_ANA_DSN_ID), (&val),
				(unsigned int)(PMIC_BUCK_ANA_DIG_ID_MASK),
				(unsigned int)(PMIC_BUCK_ANA_DIG_ID_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_ana_ana_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_ANA_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_ANA_ANA_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_ANA_ANA_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_ana_ana_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_ANA_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_ANA_ANA_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_ANA_ANA_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_ana_dig_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_ANA_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_ANA_DIG_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_ANA_DIG_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_ana_dig_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_ANA_DSN_REV0), (&val),
	    (unsigned int)(PMIC_BUCK_ANA_DIG_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_ANA_DIG_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_ana_sw_minor_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_ANA_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_ANA_SW_MINOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_ANA_SW_MINOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_buck_ana_sw_major_rev(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_BUCK_ANA_DSN_REV1), (&val),
	    (unsigned int)(PMIC_BUCK_ANA_SW_MAJOR_REV_MASK),
	    (unsigned int)(PMIC_BUCK_ANA_SW_MAJOR_REV_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_smps_testmode_b(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMPS_TESTMODE_B_MASK),
	    (unsigned int)(PMIC_RG_SMPS_TESTMODE_B_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vpa_bursth(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_SMPS_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VPA_BURSTH_MASK),
				    (unsigned int)(PMIC_RG_VPA_BURSTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vpa_burstl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_SMPS_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VPA_BURSTL_MASK),
				    (unsigned int)(PMIC_RG_VPA_BURSTL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_triml(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_SMPS_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VCORE_TRIML_MASK),
				    (unsigned int)(PMIC_RG_VCORE_TRIML_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_sleep_voltage(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_SLEEP_VOLTAGE_MASK),
	    (unsigned int)(PMIC_RG_VCORE_SLEEP_VOLTAGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_sleep_voltage(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_SLEEP_VOLTAGE_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_SLEEP_VOLTAGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_triml(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_SMPS_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VPROC_TRIML_MASK),
				    (unsigned int)(PMIC_RG_VPROC_TRIML_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_sleep_voltage(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_SLEEP_VOLTAGE_MASK),
	    (unsigned int)(PMIC_RG_VPROC_SLEEP_VOLTAGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_sleep_voltage(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VS1_SLEEP_VOLTAGE_MASK),
	    (unsigned int)(PMIC_RG_VS1_SLEEP_VOLTAGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs2_sleep_voltage(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VS2_SLEEP_VOLTAGE_MASK),
	    (unsigned int)(PMIC_RG_VS2_SLEEP_VOLTAGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vsram_proc_sleep_voltage(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VSRAM_PROC_SLEEP_VOLTAGE_MASK),
	    (unsigned int)(PMIC_RG_VSRAM_PROC_SLEEP_VOLTAGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vsram_gpu_sleep_voltage(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VSRAM_GPU_SLEEP_VOLTAGE_MASK),
	    (unsigned int)(PMIC_RG_VSRAM_GPU_SLEEP_VOLTAGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vsram_others_sleep_voltage(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VSRAM_OTHERS_SLEEP_VOLTAGE_MASK),
	    (unsigned int)(PMIC_RG_VSRAM_OTHERS_SLEEP_VOLTAGE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_smps_ivgd_det(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_SMPS_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_SMPS_IVGD_DET_MASK),
	    (unsigned int)(PMIC_RG_SMPS_IVGD_DET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_autok_rst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_SMPS_ANA_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_AUTOK_RST_MASK),
				    (unsigned int)(PMIC_RG_AUTOK_RST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_fpwm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_FPWM_MASK),
	    (unsigned int)(PMIC_RG_VCORE_FPWM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_fpwm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_FPWM_MASK),
	    (unsigned int)(PMIC_RG_VPROC_FPWM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_ndis_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_NDIS_EN_MASK),
	    (unsigned int)(PMIC_RG_VCORE_NDIS_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vcore_ndis_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_VCORE_VPROC_ANA_CON0),
				  (&val),
				  (unsigned int)(PMIC_RG_VCORE_NDIS_EN_MASK),
				  (unsigned int)(PMIC_RG_VCORE_NDIS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vproc_ndis_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_NDIS_EN_MASK),
	    (unsigned int)(PMIC_RG_VPROC_NDIS_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vproc_ndis_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_VCORE_VPROC_ANA_CON0),
				  (&val),
				  (unsigned int)(PMIC_RG_VPROC_NDIS_EN_MASK),
				  (unsigned int)(PMIC_RG_VPROC_NDIS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vcore_fcot(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_FCOT_MASK),
	    (unsigned int)(PMIC_RG_VCORE_FCOT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_fcot(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_FCOT_MASK),
	    (unsigned int)(PMIC_RG_VPROC_FCOT_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcorevproc_tmdl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCOREVPROC_TMDL_MASK),
	    (unsigned int)(PMIC_RG_VCOREVPROC_TMDL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_tbdis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_TBDIS_MASK),
	    (unsigned int)(PMIC_RG_VCORE_TBDIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_tbdis(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_TBDIS_MASK),
	    (unsigned int)(PMIC_RG_VPROC_TBDIS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_vdiffoff(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_VDIFFOFF_MASK),
	    (unsigned int)(PMIC_RG_VCORE_VDIFFOFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_vdiffoff(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_VDIFFOFF_MASK),
	    (unsigned int)(PMIC_RG_VPROC_VDIFFOFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_rcomp0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_RCOMP0_MASK),
	    (unsigned int)(PMIC_RG_VCORE_RCOMP0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_rcomp1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_RCOMP1_MASK),
	    (unsigned int)(PMIC_RG_VCORE_RCOMP1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_ccomp0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_CCOMP0_MASK),
	    (unsigned int)(PMIC_RG_VCORE_CCOMP0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_ccomp1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_CCOMP1_MASK),
	    (unsigned int)(PMIC_RG_VCORE_CCOMP1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_ramp_slp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_RAMP_SLP_MASK),
	    (unsigned int)(PMIC_RG_VCORE_RAMP_SLP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_rcomp0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_RCOMP0_MASK),
	    (unsigned int)(PMIC_RG_VPROC_RCOMP0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_rcomp1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_RCOMP1_MASK),
	    (unsigned int)(PMIC_RG_VPROC_RCOMP1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_ccomp0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_CCOMP0_MASK),
	    (unsigned int)(PMIC_RG_VPROC_CCOMP0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_ccomp1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_CCOMP1_MASK),
	    (unsigned int)(PMIC_RG_VPROC_CCOMP1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_ramp_slp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_RAMP_SLP_MASK),
	    (unsigned int)(PMIC_RG_VPROC_RAMP_SLP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_rcs(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_RCS_MASK),
	    (unsigned int)(PMIC_RG_VCORE_RCS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_rcs(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_RCS_MASK),
	    (unsigned int)(PMIC_RG_VPROC_RCS_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_rcb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_RCB_MASK),
	    (unsigned int)(PMIC_RG_VCORE_RCB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_rcb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_RCB_MASK),
	    (unsigned int)(PMIC_RG_VPROC_RCB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_tb_width(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_TB_WIDTH_MASK),
	    (unsigned int)(PMIC_RG_VCORE_TB_WIDTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_tb_width(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_TB_WIDTH_MASK),
	    (unsigned int)(PMIC_RG_VPROC_TB_WIDTH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_ug_sr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_UG_SR_MASK),
	    (unsigned int)(PMIC_RG_VCORE_UG_SR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_lg_sr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_LG_SR_MASK),
	    (unsigned int)(PMIC_RG_VCORE_LG_SR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_ug_sr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_UG_SR_MASK),
	    (unsigned int)(PMIC_RG_VPROC_UG_SR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_lg_sr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_LG_SR_MASK),
	    (unsigned int)(PMIC_RG_VPROC_LG_SR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_pfm_ton(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_PFM_TON_MASK),
	    (unsigned int)(PMIC_RG_VCORE_PFM_TON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_pfm_ton(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_PFM_TON_MASK),
	    (unsigned int)(PMIC_RG_VPROC_PFM_TON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rgs_vcore_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON5), (&val),
	    (unsigned int)(PMIC_RGS_VCORE_OC_STATUS_MASK),
	    (unsigned int)(PMIC_RGS_VCORE_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vproc_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON5), (&val),
	    (unsigned int)(PMIC_RGS_VPROC_OC_STATUS_MASK),
	    (unsigned int)(PMIC_RGS_VPROC_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vcore_preoc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON5), (&val),
	    (unsigned int)(PMIC_RGS_VCORE_PREOC_STATUS_MASK),
	    (unsigned int)(PMIC_RGS_VCORE_PREOC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vcore_dig_mon(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON5), (&val),
	    (unsigned int)(PMIC_RGS_VCORE_DIG_MON_MASK),
	    (unsigned int)(PMIC_RGS_VCORE_DIG_MON_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vproc_dig_mon(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON6), (&val),
	    (unsigned int)(PMIC_RGS_VPROC_DIG_MON_MASK),
	    (unsigned int)(PMIC_RGS_VPROC_DIG_MON_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vcore_tran_bst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_TRAN_BST_MASK),
	    (unsigned int)(PMIC_RG_VCORE_TRAN_BST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_tran_bst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_TRAN_BST_MASK),
	    (unsigned int)(PMIC_RG_VPROC_TRAN_BST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_cotramp_slp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_COTRAMP_SLP_MASK),
	    (unsigned int)(PMIC_RG_VCORE_COTRAMP_SLP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_cotramp_slp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_COTRAMP_SLP_MASK),
	    (unsigned int)(PMIC_RG_VPROC_COTRAMP_SLP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_sleep_time(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_SLEEP_TIME_MASK),
	    (unsigned int)(PMIC_RG_VCORE_SLEEP_TIME_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_sleep_time(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_SLEEP_TIME_MASK),
	    (unsigned int)(PMIC_RG_VPROC_SLEEP_TIME_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_vreftb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_VREFTB_MASK),
	    (unsigned int)(PMIC_RG_VCORE_VREFTB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_vreftb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_VREFTB_MASK),
	    (unsigned int)(PMIC_RG_VPROC_VREFTB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_fugon(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_FUGON_MASK),
	    (unsigned int)(PMIC_RG_VCORE_FUGON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_fugon(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_FUGON_MASK),
	    (unsigned int)(PMIC_RG_VPROC_FUGON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_flgon(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_FLGON_MASK),
	    (unsigned int)(PMIC_RG_VCORE_FLGON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_flgon(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON8), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_FLGON_MASK),
	    (unsigned int)(PMIC_RG_VPROC_FLGON_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON9), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_RSV_MASK),
	    (unsigned int)(PMIC_RG_VCORE_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vproc_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON10), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_RSV_MASK),
	    (unsigned int)(PMIC_RG_VPROC_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vcore_nonaudible_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCORE_NONAUDIBLE_EN_MASK),
	    (unsigned int)(PMIC_RG_VCORE_NONAUDIBLE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vcore_nonaudible_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON11), (&val),
	    (unsigned int)(PMIC_RG_VCORE_NONAUDIBLE_EN_MASK),
	    (unsigned int)(PMIC_RG_VCORE_NONAUDIBLE_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vproc_nonaudible_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VPROC_NONAUDIBLE_EN_MASK),
	    (unsigned int)(PMIC_RG_VPROC_NONAUDIBLE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vproc_nonaudible_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON11), (&val),
	    (unsigned int)(PMIC_RG_VPROC_NONAUDIBLE_EN_MASK),
	    (unsigned int)(PMIC_RG_VPROC_NONAUDIBLE_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vcorevproc_disautok(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON11), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VCOREVPROC_DISAUTOK_MASK),
	    (unsigned int)(PMIC_RG_VCOREVPROC_DISAUTOK_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rgs_vcore_pfm_flag(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON11), (&val),
	    (unsigned int)(PMIC_RGS_VCORE_PFM_FLAG_MASK),
	    (unsigned int)(PMIC_RGS_VCORE_PFM_FLAG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vproc_pfm_flag(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VCORE_VPROC_ANA_CON11), (&val),
	    (unsigned int)(PMIC_RGS_VPROC_PFM_FLAG_MASK),
	    (unsigned int)(PMIC_RGS_VPROC_PFM_FLAG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vmodem_modeset(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_MODESET_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_MODESET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_ndis_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_NDIS_EN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_NDIS_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vmodem_ndis_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_VMODEM_ANA_CON0), (&val),
				(unsigned int)(PMIC_RG_VMODEM_NDIS_EN_MASK),
				(unsigned int)(PMIC_RG_VMODEM_NDIS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vmodem_vrf18_sstart_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_VRF18_SSTART_EN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_VRF18_SSTART_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vmodem_vrf18_sstart_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON0), (&val),
	    (unsigned int)(PMIC_RG_VMODEM_VRF18_SSTART_EN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_VRF18_SSTART_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vmodem_auto_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_AUTO_MODE_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_AUTO_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_rzsel0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_RZSEL0_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_RZSEL0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_rzsel1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_RZSEL1_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_RZSEL1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_ccsel0(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_CCSEL0_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_CCSEL0_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_ccsel1(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON1), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_CCSEL1_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_CCSEL1_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_csl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VMODEM_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VMODEM_CSL_MASK),
				    (unsigned int)(PMIC_RG_VMODEM_CSL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_slp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VMODEM_ANA_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VMODEM_SLP_MASK),
				    (unsigned int)(PMIC_RG_VMODEM_SLP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_adrc_fen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_ADRC_FEN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_ADRC_FEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_vc_cap_clamp_fen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_VC_CAP_CLAMP_FEN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_VC_CAP_CLAMP_FEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_vc_clamp_fen(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_VC_CLAMP_FEN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_VC_CLAMP_FEN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_burst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON2), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_BURST_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_BURST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_csr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VMODEM_ANA_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VMODEM_CSR_MASK),
				    (unsigned int)(PMIC_RG_VMODEM_CSR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_pfmsr_eh(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_PFMSR_EH_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_PFMSR_EH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_nlim_gating(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_NLIM_GATING_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_NLIM_GATING_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_pwmsr_eh(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_PWMSR_EH_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_PWMSR_EH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_hs_vthdet(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_HS_VTHDET_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_HS_VTHDET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_pg_gating(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_PG_GATING_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_PG_GATING_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_hs_onspeed_eh(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_HS_ONSPEED_EH_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_HS_ONSPEED_EH_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_sr_p(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VMODEM_ANA_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VMODEM_SR_P_MASK),
				    (unsigned int)(PMIC_RG_VMODEM_SR_P_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_sr_n(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VMODEM_ANA_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VMODEM_SR_N_MASK),
				    (unsigned int)(PMIC_RG_VMODEM_SR_N_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_pfm_rip(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_PFM_RIP_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_PFM_RIP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_tran_bst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_TRAN_BST_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_TRAN_BST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_dts_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_DTS_ENB_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_DTS_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vmodem_dts_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_VMODEM_ANA_CON4), (&val),
				(unsigned int)(PMIC_RG_VMODEM_DTS_ENB_MASK),
				(unsigned int)(PMIC_RG_VMODEM_DTS_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vmodem_min_off(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_MIN_OFF_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_MIN_OFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_1p35up_sel_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_1P35UP_SEL_EN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_1P35UP_SEL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vmodem_1p35up_sel_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON4), (&val),
	    (unsigned int)(PMIC_RG_VMODEM_1P35UP_SEL_EN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_1P35UP_SEL_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vmodem_dlc_auto_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_DLC_AUTO_MODE_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_DLC_AUTO_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_src_auto_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_SRC_AUTO_MODE_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_SRC_AUTO_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_ugp_sr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_UGP_SR_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_UGP_SR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_lgp_sr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_LGP_SR_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_LGP_SR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_ugp_sr_pfm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_UGP_SR_PFM_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_UGP_SR_PFM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_lgp_sr_pfm(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_LGP_SR_PFM_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_LGP_SR_PFM_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_ugd_vthsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_UGD_VTHSEL_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_UGD_VTHSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_fnlx(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VMODEM_ANA_CON5),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VMODEM_FNLX_MASK),
				    (unsigned int)(PMIC_RG_VMODEM_FNLX_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_vdiff_enlowiq(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_VDIFF_ENLOWIQ_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_VDIFF_ENLOWIQ_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vmodem_vdiff_enlowiq(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (&val),
	    (unsigned int)(PMIC_RG_VMODEM_VDIFF_ENLOWIQ_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_VDIFF_ENLOWIQ_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vmodem_pfmoc_fwupoff(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_PFMOC_FWUPOFF_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_PFMOC_FWUPOFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_pwmoc_fwupoff(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_PWMOC_FWUPOFF_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_PWMOC_FWUPOFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_cp_fwupoff(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_CP_FWUPOFF_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_CP_FWUPOFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_zx_gating(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON5), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_ZX_GATING_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_ZX_GATING_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VMODEM_ANA_CON6),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VMODEM_RSV_MASK),
				    (unsigned int)(PMIC_RG_VMODEM_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_azc_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_AZC_EN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_AZC_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vmodem_azc_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_VMODEM_ANA_CON7), (&val),
				(unsigned int)(PMIC_RG_VMODEM_AZC_EN_MASK),
				(unsigned int)(PMIC_RG_VMODEM_AZC_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vmodem_azc_delay(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_AZC_DELAY_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_AZC_DELAY_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_azc_hold_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_AZC_HOLD_ENB_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_AZC_HOLD_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vmodem_azc_hold_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (&val),
	    (unsigned int)(PMIC_RG_VMODEM_AZC_HOLD_ENB_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_AZC_HOLD_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vmodem_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (&val),
	    (unsigned int)(PMIC_RGS_VMODEM_OC_STATUS_MASK),
	    (unsigned int)(PMIC_RGS_VMODEM_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vmodem_dig_mon(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_VMODEM_ANA_CON7), (&val),
				(unsigned int)(PMIC_RGS_VMODEM_DIG_MON_MASK),
				(unsigned int)(PMIC_RGS_VMODEM_DIG_MON_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vmodem_iodetect_en18(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_IODETECT_EN18_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_IODETECT_EN18_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vmodem_iodetect_en18(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (&val),
	    (unsigned int)(PMIC_RG_VMODEM_IODETECT_EN18_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_IODETECT_EN18_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vmodem_preoc_sel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_PREOC_SEL_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_PREOC_SEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vmodem_nonaudible_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VMODEM_NONAUDIBLE_EN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_NONAUDIBLE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vmodem_nonaudible_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (&val),
	    (unsigned int)(PMIC_RG_VMODEM_NONAUDIBLE_EN_MASK),
	    (unsigned int)(PMIC_RG_VMODEM_NONAUDIBLE_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vmodem_pfm_flag(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VMODEM_ANA_CON7), (&val),
	    (unsigned int)(PMIC_RGS_VMODEM_PFM_FLAG_MASK),
	    (unsigned int)(PMIC_RGS_VMODEM_PFM_FLAG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vs1_min_off(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_MIN_OFF_MASK),
				    (unsigned int)(PMIC_RG_VS1_MIN_OFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_vrf18_sstart_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VS1_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VS1_VRF18_SSTART_EN_MASK),
	    (unsigned int)(PMIC_RG_VS1_VRF18_SSTART_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vs1_vrf18_sstart_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VS1_ANA_CON0), (&val),
	    (unsigned int)(PMIC_RG_VS1_VRF18_SSTART_EN_MASK),
	    (unsigned int)(PMIC_RG_VS1_VRF18_SSTART_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vs1_1p35up_sel_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VS1_ANA_CON0), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VS1_1P35UP_SEL_EN_MASK),
	    (unsigned int)(PMIC_RG_VS1_1P35UP_SEL_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vs1_1p35up_sel_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VS1_ANA_CON0), (&val),
	    (unsigned int)(PMIC_RG_VS1_1P35UP_SEL_EN_MASK),
	    (unsigned int)(PMIC_RG_VS1_1P35UP_SEL_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vs1_rzsel(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_RZSEL_MASK),
				    (unsigned int)(PMIC_RG_VS1_RZSEL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_csr(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_CSR_MASK),
				    (unsigned int)(PMIC_RG_VS1_CSR_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_csl(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_CSL_MASK),
				    (unsigned int)(PMIC_RG_VS1_CSL_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_slp(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_SLP_MASK),
				    (unsigned int)(PMIC_RG_VS1_SLP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_ndis_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_NDIS_EN_MASK),
				    (unsigned int)(PMIC_RG_VS1_NDIS_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vs1_ndis_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_VS1_ANA_CON1), (&val),
				  (unsigned int)(PMIC_RG_VS1_NDIS_EN_MASK),
				  (unsigned int)(PMIC_RG_VS1_NDIS_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vs1_csm_n(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_CSM_N_MASK),
				    (unsigned int)(PMIC_RG_VS1_CSM_N_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_csm_p(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON1),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_CSM_P_MASK),
				    (unsigned int)(PMIC_RG_VS1_CSM_P_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_rsv(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_RSV_MASK),
				    (unsigned int)(PMIC_RG_VS1_RSV_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_modeset(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_MODESET_MASK),
				    (unsigned int)(PMIC_RG_VS1_MODESET_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_pfm_rip(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON2),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_PFM_RIP_MASK),
				    (unsigned int)(PMIC_RG_VS1_PFM_RIP_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_tran_bst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VS1_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VS1_TRAN_BST_MASK),
	    (unsigned int)(PMIC_RG_VS1_TRAN_BST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_dts_enb(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_DTS_ENB_MASK),
				    (unsigned int)(PMIC_RG_VS1_DTS_ENB_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vs1_dts_enb(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_VS1_ANA_CON3), (&val),
				  (unsigned int)(PMIC_RG_VS1_DTS_ENB_MASK),
				  (unsigned int)(PMIC_RG_VS1_DTS_ENB_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vs1_auto_mode(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VS1_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VS1_AUTO_MODE_MASK),
	    (unsigned int)(PMIC_RG_VS1_AUTO_MODE_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_pwm_trig(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VS1_ANA_CON3), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VS1_PWM_TRIG_MASK),
	    (unsigned int)(PMIC_RG_VS1_PWM_TRIG_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_rsv_h(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON3),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_RSV_H_MASK),
				    (unsigned int)(PMIC_RG_VS1_RSV_H_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_rsv_l(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_RSV_L_MASK),
				    (unsigned int)(PMIC_RG_VS1_RSV_L_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_nonaudible_en(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface(
	    (unsigned int)(MT6356_VS1_ANA_CON4), (unsigned int)(val),
	    (unsigned int)(PMIC_RG_VS1_NONAUDIBLE_EN_MASK),
	    (unsigned int)(PMIC_RG_VS1_NONAUDIBLE_EN_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rg_vs1_nonaudible_en(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface(
	    (unsigned int)(MT6356_VS1_ANA_CON4), (&val),
	    (unsigned int)(PMIC_RG_VS1_NONAUDIBLE_EN_MASK),
	    (unsigned int)(PMIC_RG_VS1_NONAUDIBLE_EN_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vs1_sr_p(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_SR_P_MASK),
				    (unsigned int)(PMIC_RG_VS1_SR_P_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_sr_n(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_SR_N_MASK),
				    (unsigned int)(PMIC_RG_VS1_SR_N_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_rg_vs1_burst(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS1_ANA_CON4),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS1_BURST_MASK),
				    (unsigned int)(PMIC_RG_VS1_BURST_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_get_rgs_vs1_oc_status(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret =
	    pmic_read_interface((unsigned int)(MT6356_VS1_ANA_CON4), (&val),
				(unsigned int)(PMIC_RGS_VS1_OC_STATUS_MASK),
				(unsigned int)(PMIC_RGS_VS1_OC_STATUS_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vs1_dig_mon(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_VS1_ANA_CON5), (&val),
				  (unsigned int)(PMIC_RGS_VS1_DIG_MON_MASK),
				  (unsigned int)(PMIC_RGS_VS1_DIG_MON_SHIFT));

	return val;
}

unsigned int mt6356_upmu_get_rgs_vs1_pfm_flag(void)
{
	unsigned int ret = 0;
	unsigned int val = 0;

	ret = pmic_read_interface((unsigned int)(MT6356_VS1_ANA_CON5), (&val),
				  (unsigned int)(PMIC_RGS_VS1_PFM_FLAG_MASK),
				  (unsigned int)(PMIC_RGS_VS1_PFM_FLAG_SHIFT));

	return val;
}

unsigned int mt6356_upmu_set_rg_vs2_min_off(unsigned int val)
{
	unsigned int ret = 0;

	ret = pmic_config_interface((unsigned int)(MT6356_VS2_ANA_CON0),
				    (unsigned int)(val),
				    (unsigned int)(PMIC_RG_VS2_MIN_OFF_MASK),
				    (unsigned int)(PMIC_RG_VS2_MIN_OFF_SHIFT));

	return ret;
}

unsigned int mt6356_upmu_set_