/*
 * Copyright (C) 2017 MediaTek Inc.

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#include <linux/kernel.h>

#include <mach/upmu_sw.h>
#include <mach/upmu_hw.h>
#include <mt-plat/upmu_common.h>

#include "include/pmic.h"

const PMU_FLAG_TABLE_ENTRY pmu_flags_table[] = {
	PMIC_ENTRY(PMIC_TOP0_ANA_ID),
	PMIC_ENTRY(PMIC_TOP0_DIG_ID),
	PMIC_ENTRY(PMIC_TOP0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP0_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP0_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP0_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP0_DSN_FPI),
	PMIC_ENTRY(PMIC_HWCID),
	PMIC_ENTRY(PMIC_SWCID),
	PMIC_ENTRY(PMIC_STS_PWRKEY),
	PMIC_ENTRY(PMIC_STS_RTCA),
	PMIC_ENTRY(PMIC_STS_CHRIN),
	PMIC_ENTRY(PMIC_STS_SPAR),
	PMIC_ENTRY(PMIC_STS_RBOOT),
	PMIC_ENTRY(PMIC_STS_UVLO),
	PMIC_ENTRY(PMIC_STS_PGFAIL),
	PMIC_ENTRY(PMIC_STS_PSOC),
	PMIC_ENTRY(PMIC_STS_THRDN),
	PMIC_ENTRY(PMIC_STS_WRST),
	PMIC_ENTRY(PMIC_STS_CRST),
	PMIC_ENTRY(PMIC_STS_PKEYLP),
	PMIC_ENTRY(PMIC_STS_NORMOFF),
	PMIC_ENTRY(PMIC_STS_BWDT),
	PMIC_ENTRY(PMIC_STS_DDLO),
	PMIC_ENTRY(PMIC_STS_WDT),
	PMIC_ENTRY(PMIC_STS_PUPSRC),
	PMIC_ENTRY(PMIC_STS_KEYPWR),
	PMIC_ENTRY(PMIC_RG_POFFSTS_CLR),
	PMIC_ENTRY(PMIC_RG_PONSTS_CLR),
	PMIC_ENTRY(PMIC_EXT_PMIC_PG_DEB),
	PMIC_ENTRY(PMIC_VAUD28_PG_DEB),
	PMIC_ENTRY(PMIC_VUSB33_PG_DEB),
	PMIC_ENTRY(PMIC_VDRAM_PG_DEB),
	PMIC_ENTRY(PMIC_VIO28_PG_DEB),
	PMIC_ENTRY(PMIC_VEMC_PG_DEB),
	PMIC_ENTRY(PMIC_VIO18_PG_DEB),
	PMIC_ENTRY(PMIC_VSRAM_PROC_PG_DEB),
	PMIC_ENTRY(PMIC_VSRAM_OTHERS_PG_DEB),
	PMIC_ENTRY(PMIC_VAUX18_PG_DEB),
	PMIC_ENTRY(PMIC_VXO22_PG_DEB),
	PMIC_ENTRY(PMIC_VPROC_PG_DEB),
	PMIC_ENTRY(PMIC_VMODEM_PG_DEB),
	PMIC_ENTRY(PMIC_VCORE_PG_DEB),
	PMIC_ENTRY(PMIC_VS1_PG_DEB),
	PMIC_ENTRY(PMIC_STRUP_EXT_PMIC_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VAUD28_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VUSB33_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VDRAM_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO28_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VEMC_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO18_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_PROC_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_OTHERS_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VAUX18_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VXO22_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VPROC_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMODEM_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VCORE_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS1_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VPROC_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMODEM_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VCORE_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS1_OC_STATUS),
	PMIC_ENTRY(PMIC_PMU_THERMAL_DEB),
	PMIC_ENTRY(PMIC_STRUP_THERMAL_STATUS),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_HW_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_HW_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN_SYNC_EN),
	PMIC_ENTRY(PMIC_RG_OSC_EN_AUTO_OFF),
	PMIC_ENTRY(PMIC_TEST_OUT),
	PMIC_ENTRY(PMIC_RG_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_NANDTREE_MODE),
	PMIC_ENTRY(PMIC_RG_TEST_AUXADC),
	PMIC_ENTRY(PMIC_RG_EFUSE_MODE),
	PMIC_ENTRY(PMIC_RG_TEST_STRUP),
	PMIC_ENTRY(PMIC_TESTMODE_SW),
	PMIC_ENTRY(PMIC_PMU_TEST_MODE_SCAN),
	PMIC_ENTRY(PMIC_PWRKEY_DEB),
	PMIC_ENTRY(PMIC_CHRDET_DEB),
	PMIC_ENTRY(PMIC_HOMEKEY_DEB),
	PMIC_ENTRY(PMIC_RG_PMU_TDSEL),
	PMIC_ENTRY(PMIC_RG_SPI_TDSEL),
	PMIC_ENTRY(PMIC_RG_AUD_TDSEL),
	PMIC_ENTRY(PMIC_RG_E32CAL_TDSEL),
	PMIC_ENTRY(PMIC_RG_PMU_RDSEL),
	PMIC_ENTRY(PMIC_RG_SPI_RDSEL),
	PMIC_ENTRY(PMIC_RG_AUD_RDSEL),
	PMIC_ENTRY(PMIC_RG_E32CAL_RDSEL),
	PMIC_ENTRY(PMIC_RG_SMT_WDTRSTB_IN),
	PMIC_ENTRY(PMIC_RG_SMT_SRCLKEN_IN0),
	PMIC_ENTRY(PMIC_RG_SMT_SRCLKEN_IN1),
	PMIC_ENTRY(PMIC_RG_SMT_RTC_32K1V8_0),
	PMIC_ENTRY(PMIC_RG_SMT_RTC_32K1V8_1),
	PMIC_ENTRY(PMIC_RG_SMT_SPI_CLK),
	PMIC_ENTRY(PMIC_RG_SMT_SPI_CSN),
	PMIC_ENTRY(PMIC_RG_SMT_SPI_MOSI),
	PMIC_ENTRY(PMIC_RG_SMT_SPI_MISO),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_CLK_MOSI),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MOSI0),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MOSI1),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_SYNC_MOSI),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_CLK_MISO),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MISO0),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MISO1),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_SYNC_MISO),
	PMIC_ENTRY(PMIC_RG_TOP_RSV0),
	PMIC_ENTRY(PMIC_RG_TOP_RSV1),
	PMIC_ENTRY(PMIC_RG_OCTL_SRCLKEN_IN0),
	PMIC_ENTRY(PMIC_RG_OCTL_SRCLKEN_IN1),
	PMIC_ENTRY(PMIC_RG_OCTL_RTC_32K1V8_0),
	PMIC_ENTRY(PMIC_RG_OCTL_RTC_32K1V8_1),
	PMIC_ENTRY(PMIC_RG_OCTL_SPI_CLK),
	PMIC_ENTRY(PMIC_RG_OCTL_SPI_CSN),
	PMIC_ENTRY(PMIC_RG_OCTL_SPI_MOSI),
	PMIC_ENTRY(PMIC_RG_OCTL_SPI_MISO),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_CLK_MOSI),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MOSI0),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MOSI1),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_SYNC_MOSI),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_CLK_MISO),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MISO0),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MISO1),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_SYNC_MISO),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPI_CLK_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPI_CSN_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPI_MOSI_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPI_MISO_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_MOSI_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_SYNC_MOSI_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_MISO_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_SYNC_MISO_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_IN_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_RCSEL),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_RCSEL),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_0_RCSEL),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_1_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPI_CLK_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPI_CSN_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPI_MOSI_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPI_MISO_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_MOSI_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI0_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI1_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_SYNC_MOSI_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_MISO_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO0_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO1_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_SYNC_MISO_RCSEL),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_IN_RCSEL),
	PMIC_ENTRY(PMIC_TOP_STATUS),
	PMIC_ENTRY(PMIC_TOP_STATUS_SET),
	PMIC_ENTRY(PMIC_TOP_STATUS_CLR),
	PMIC_ENTRY(PMIC_VM_MODE),
	PMIC_ENTRY(PMIC_TOP1_ANA_ID),
	PMIC_ENTRY(PMIC_TOP1_DIG_ID),
	PMIC_ENTRY(PMIC_TOP1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP1_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP1_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP1_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP1_DSN_FPI),
	PMIC_ENTRY(PMIC_GPIO_DIR0),
	PMIC_ENTRY(PMIC_GPIO_DIR0_SET),
	PMIC_ENTRY(PMIC_GPIO_DIR0_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLEN0),
	PMIC_ENTRY(PMIC_GPIO_PULLEN0_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLEN0_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL0),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL0_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL0_CLR),
	PMIC_ENTRY(PMIC_GPIO_DINV0),
	PMIC_ENTRY(PMIC_GPIO_DINV0_SET),
	PMIC_ENTRY(PMIC_GPIO_DINV0_CLR),
	PMIC_ENTRY(PMIC_GPIO_DOUT0),
	PMIC_ENTRY(PMIC_GPIO_DOUT0_SET),
	PMIC_ENTRY(PMIC_GPIO_DOUT0_CLR),
	PMIC_ENTRY(PMIC_GPIO_PI0),
	PMIC_ENTRY(PMIC_GPIO_POE0),
	PMIC_ENTRY(PMIC_GPIO0_MODE),
	PMIC_ENTRY(PMIC_GPIO1_MODE),
	PMIC_ENTRY(PMIC_GPIO2_MODE),
	PMIC_ENTRY(PMIC_GPIO3_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE0_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE0_CLR),
	PMIC_ENTRY(PMIC_GPIO4_MODE),
	PMIC_ENTRY(PMIC_GPIO5_MODE),
	PMIC_ENTRY(PMIC_GPIO6_MODE),
	PMIC_ENTRY(PMIC_GPIO7_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE1_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE1_CLR),
	PMIC_ENTRY(PMIC_GPIO8_MODE),
	PMIC_ENTRY(PMIC_GPIO9_MODE),
	PMIC_ENTRY(PMIC_GPIO10_MODE),
	PMIC_ENTRY(PMIC_GPIO11_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE2_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE2_CLR),
	PMIC_ENTRY(PMIC_GPIO12_MODE),
	PMIC_ENTRY(PMIC_GPIO13_MODE),
	PMIC_ENTRY(PMIC_GPIO14_MODE),
	PMIC_ENTRY(PMIC_GPIO15_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE3_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE3_CLR),
	PMIC_ENTRY(PMIC_GPIO_RSV),
	PMIC_ENTRY(PMIC_TOP2_ANA_ID),
	PMIC_ENTRY(PMIC_TOP2_DIG_ID),
	PMIC_ENTRY(PMIC_TOP2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP2_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP2_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP2_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP2_DSN_FPI),
	PMIC_ENTRY(PMIC_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_G_SMPS_CK_PDN),
	PMIC_ENTRY(PMIC_RG_G_SMPS_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_RG_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_INTRP_PRE_OC_CK_PDN),
	PMIC_ENTRY(PMIC_RG_EFUSE_CK_PDN),
	PMIC_ENTRY(PMIC_RG_EINT_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PMU1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_SPI_CK_PDN),
	PMIC_ENTRY(PMIC_RG_REG_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PMU32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FQMTR_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FQMTR_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PMU26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PMU128K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC32K_CK_PDN),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_0_PDN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_1_PDN),
	PMIC_ENTRY(PMIC_RG_TRIM_128K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PCHR_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_FQMTR_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_RTC_32K1V8_SEL),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_PCHR_TEST_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_26M_CK_SEL_HWEN),
	PMIC_ENTRY(PMIC_RG_26M_CK_SEL),
	PMIC_ENTRY(PMIC_RG_PMU_1M_CK_SEL_HWEN),
	PMIC_ENTRY(PMIC_RG_PMU_1M_CK_SEL),
	PMIC_ENTRY(PMIC_RG_PMU32K_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_TOP_CKSEL_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_SRCVOLTEN_SW),
	PMIC_ENTRY(PMIC_RG_BUCK_OSC_SEL_SW),
	PMIC_ENTRY(PMIC_RG_VOWEN_SW),
	PMIC_ENTRY(PMIC_RG_SRCVOLTEN_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_OSC_SEL_MODE),
	PMIC_ENTRY(PMIC_RG_VOWEN_MODE),
	PMIC_ENTRY(PMIC_RG_TOP_CKSEL_CON2_RSV),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_REG_CK_DIVSEL),
	PMIC_ENTRY(PMIC_TOP_CKDIVSEL_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_CKDIVSEL_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKDIVSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_G_SMPS_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_REG_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_EFUSE_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_EINT_32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_PMU26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_PMU_VXO22_ON),
	PMIC_ENTRY(PMIC_RG_PMU_VXO22_ON_SW_EN),
	PMIC_ENTRY(PMIC_TOP_CKHWEN_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_CKHWEN_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKHWEN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_PMU128K_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_SMPS_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_XO_CLK_26M_PMU_TST_DIS),
	PMIC_ENTRY(PMIC_RG_XO_CLK_26M_DIG_TST_DIS),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_RTC_32K_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_PMU_M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_TOP_CKTST_CON0_RSV),
	PMIC_ENTRY(PMIC_RG_PMU128K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_SMPS_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_XO_CLK_26M_PMU_TSTSEL),
	PMIC_ENTRY(PMIC_RG_XO_CLK_26M_DIG_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_32K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_PMU_M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_EFUSE_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_PCHR_TEST_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_FQMTR_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_OSC_SEL_SW_EN),
	PMIC_ENTRY(PMIC_RG_OSC_SEL),
	PMIC_ENTRY(PMIC_RG_OSC_EN_SW_EN),
	PMIC_ENTRY(PMIC_RG_OSC_EN),
	PMIC_ENTRY(PMIC_RG_G_SMPS_CK_PDN_VOWEN_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN0_LP_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN1_LP_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN2_LP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_LP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_LP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_PFM_FLAG),
	PMIC_ENTRY(PMIC_RG_BUCK_PFM_FLAG_SW_EN),
	PMIC_ENTRY(PMIC_RG_DCXO26M_RDY),
	PMIC_ENTRY(PMIC_RG_DCXO26M_RDY_SW_EN),
	PMIC_ENTRY(PMIC_RG_PMU_LP),
	PMIC_ENTRY(PMIC_RG_PMU_LP_SW_EN),
	PMIC_ENTRY(PMIC_TOP_CLK_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CLK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_PMU_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_PMU_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RO_HANDOVER_DEBUG),
	PMIC_ENTRY(PMIC_RG_EFUSE_MAN_RST),
	PMIC_ENTRY(PMIC_RG_DRIVER_RST),
	PMIC_ENTRY(PMIC_RG_FQMTR_RST),
	PMIC_ENTRY(PMIC_RG_RTC_RST),
	PMIC_ENTRY(PMIC_RG_TYPE_C_CC_RST),
	PMIC_ENTRY(PMIC_RG_CLK_TRIM_RST),
	PMIC_ENTRY(PMIC_RG_BUCK_SRCLKEN_RST),
	PMIC_ENTRY(PMIC_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_PROT_PMPP_RST),
	PMIC_ENTRY(PMIC_RG_SPK_RST),
	PMIC_ENTRY(PMIC_RG_FT_VR_SYSRSTB),
	PMIC_ENTRY(PMIC_RG_LDO_CALI_RST),
	PMIC_ENTRY(PMIC_TOP_RST_CON1_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_RST_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_CHR_LDO_DET_MODE),
	PMIC_ENTRY(PMIC_RG_CHR_LDO_DET_SW),
	PMIC_ENTRY(PMIC_RG_CHRWDT_FLAG_MODE),
	PMIC_ENTRY(PMIC_RG_CHRWDT_FLAG_SW),
	PMIC_ENTRY(PMIC_TOP_RST_CON2_RSV),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_EN),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_MODE),
	PMIC_ENTRY(PMIC_WDTRSTB_STATUS),
	PMIC_ENTRY(PMIC_WDTRSTB_STATUS_CLR),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_FB_EN),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_DEB),
	PMIC_ENTRY(PMIC_RG_HOMEKEY_RST_EN),
	PMIC_ENTRY(PMIC_RG_PWRKEY_RST_EN),
	PMIC_ENTRY(PMIC_RG_PWRRST_TMR_DIS),
	PMIC_ENTRY(PMIC_RG_PWRKEY_RST_TD),
	PMIC_ENTRY(PMIC_TOP_RST_MISC_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_MISC_SET),
	PMIC_ENTRY(PMIC_TOP_RST_MISC_CLR),
	PMIC_ENTRY(PMIC_VPWRIN_RSTB_STATUS),
	PMIC_ENTRY(PMIC_DDLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_UVLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_RTC_DDLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_CHRWDT_REG_RSTB_STATUS),
	PMIC_ENTRY(PMIC_CHRDET_REG_RSTB_STATUS),
	PMIC_ENTRY(PMIC_BWDT_DDLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_TOP_RST_STATUS_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_STATUS_SET),
	PMIC_ENTRY(PMIC_TOP_RST_STATUS_CLR),
	PMIC_ENTRY(PMIC_TOP2_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_TOP2_RSV0),
	PMIC_ENTRY(PMIC_RG_TOP2_RSV1),
	PMIC_ENTRY(PMIC_TOP3_ANA_ID),
	PMIC_ENTRY(PMIC_TOP3_DIG_ID),
	PMIC_ENTRY(PMIC_TOP3_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP3_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP3_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP3_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP3_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP3_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP3_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP3_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_INT_EN_SPI_CMD_ALERT),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_CON0_SET),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_SPI_CMD_ALERT),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_SPI_CMD_ALERT),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_SPI_CMD_ALERT),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BUCK_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_LDO_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PSC_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_SCK_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BM_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HK_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_XPP_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_AUD_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_MISC_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_TOP_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_INT_STATUS_BUCK_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_LDO_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_PSC_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_SCK_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_BM_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_HK_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_XPP_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_AUD_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_MISC_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_TOP_RSV),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_BUCK_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_LDO_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_PSC_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_SCK_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_BM_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_HK_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_XPP_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_AUD_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_MISC_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_TOP_RSV),
	PMIC_ENTRY(PMIC_RG_INT_POLARITY),
	PMIC_ENTRY(PMIC_PLT0_ANA_ID),
	PMIC_ENTRY(PMIC_PLT0_DIG_ID),
	PMIC_ENTRY(PMIC_PLT0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PLT0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PLT0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PLT0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PLT0_DSN_CBS),
	PMIC_ENTRY(PMIC_PLT0_DSN_BIX),
	PMIC_ENTRY(PMIC_PLT0_DSN_ESP),
	PMIC_ENTRY(PMIC_PLT0_DSN_FPI),
	PMIC_ENTRY(PMIC_FQMTR_TCKSEL),
	PMIC_ENTRY(PMIC_FQMTR_BUSY),
	PMIC_ENTRY(PMIC_FQMTR_DCXO26M_EN),
	PMIC_ENTRY(PMIC_FQMTR_EN),
	PMIC_ENTRY(PMIC_FQMTR_WINSET),
	PMIC_ENTRY(PMIC_FQMTR_DATA),
	PMIC_ENTRY(PMIC_RG_OSC_128K_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_OSC_128K_TRIM_RATE),
	PMIC_ENTRY(PMIC_DA_OSC_128K_TRIM),
	PMIC_ENTRY(PMIC_RG_OTP_PA),
	PMIC_ENTRY(PMIC_RG_OTP_PDIN),
	PMIC_ENTRY(PMIC_RG_OTP_PTM),
	PMIC_ENTRY(PMIC_RG_OTP_PWE),
	PMIC_ENTRY(PMIC_RG_OTP_PPROG),
	PMIC_ENTRY(PMIC_RG_OTP_PWE_SRC),
	PMIC_ENTRY(PMIC_RG_OTP_PROG_PKEY),
	PMIC_ENTRY(PMIC_RG_OTP_RD_PKEY),
	PMIC_ENTRY(PMIC_RG_OTP_RD_TRIG),
	PMIC_ENTRY(PMIC_RG_RD_RDY_BYPASS),
	PMIC_ENTRY(PMIC_RG_SKIP_OTP_OUT),
	PMIC_ENTRY(PMIC_RG_OTP_RD_SW),
	PMIC_ENTRY(PMIC_RG_OTP_DOUT_SW),
	PMIC_ENTRY(PMIC_RG_OTP_RD_BUSY),
	PMIC_ENTRY(PMIC_RG_OTP_RD_ACK),
	PMIC_ENTRY(PMIC_RG_OTP_PA_SW),
	PMIC_ENTRY(PMIC_TMA_KEY),
	PMIC_ENTRY(PMIC_TOP_MDB_RSV0),
	PMIC_ENTRY(PMIC_RG_MDB_DM1_DS_EN),
	PMIC_ENTRY(PMIC_TOP_MDB_RSV1),
	PMIC_ENTRY(PMIC_RG_PMU_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_PLT0_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_OSC_128K_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OSC_MODE),
	PMIC_ENTRY(PMIC_SPISLV_ANA_ID),
	PMIC_ENTRY(PMIC_SPISLV_DIG_ID),
	PMIC_ENTRY(PMIC_SPISLV_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_SPISLV_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_SPISLV_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_SPISLV_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_SPISLV_DSN_CBS),
	PMIC_ENTRY(PMIC_SPISLV_DSN_BIX),
	PMIC_ENTRY(PMIC_SPISLV_DSN_ESP),
	PMIC_ENTRY(PMIC_SPISLV_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_SLP_RW_EN),
	PMIC_ENTRY(PMIC_RG_SPI_RSV),
	PMIC_ENTRY(PMIC_DEW_DIO_EN),
	PMIC_ENTRY(PMIC_DEW_READ_TEST),
	PMIC_ENTRY(PMIC_DEW_WRITE_TEST),
	PMIC_ENTRY(PMIC_DEW_CRC_SWRST),
	PMIC_ENTRY(PMIC_DEW_CRC_EN),
	PMIC_ENTRY(PMIC_DEW_CRC_VAL),
	PMIC_ENTRY(PMIC_DEW_DBG_MON_SEL),
	PMIC_ENTRY(PMIC_DEW_CIPHER_KEY_SEL),
	PMIC_ENTRY(PMIC_DEW_CIPHER_IV_SEL),
	PMIC_ENTRY(PMIC_DEW_CIPHER_EN),
	PMIC_ENTRY(PMIC_DEW_CIPHER_RDY),
	PMIC_ENTRY(PMIC_DEW_CIPHER_MODE),
	PMIC_ENTRY(PMIC_DEW_CIPHER_SWRST),
	PMIC_ENTRY(PMIC_DEW_RDDMY_NO),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_SET),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_CLR),
	PMIC_ENTRY(PMIC_CPU_INT_STA),
	PMIC_ENTRY(PMIC_MD32_INT_STA),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN3_SMPS_CLK_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN2_SMPS_CLK_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST),
	PMIC_ENTRY(PMIC_RG_SPI_DLY_SEL),
	PMIC_ENTRY(PMIC_RECORD_CMD0),
	PMIC_ENTRY(PMIC_RECORD_CMD1),
	PMIC_ENTRY(PMIC_RECORD_CMD2),
	PMIC_ENTRY(PMIC_RECORD_WDATA0),
	PMIC_ENTRY(PMIC_RECORD_WDATA1),
	PMIC_ENTRY(PMIC_RECORD_WDATA2),
	PMIC_ENTRY(PMIC_RG_ADDR_TARGET),
	PMIC_ENTRY(PMIC_RG_ADDR_MASK),
	PMIC_ENTRY(PMIC_RG_WDATA_TARGET),
	PMIC_ENTRY(PMIC_RG_WDATA_MASK),
	PMIC_ENTRY(PMIC_RG_SPI_RECORD_CLR),
	PMIC_ENTRY(PMIC_RG_CMD_ALERT_CLR),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN2_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN3_EN),
	PMIC_ENTRY(PMIC_SCK_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_SCK_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_SCK_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_CBS),
	PMIC_ENTRY(PMIC_SCK_TOP_BIX),
	PMIC_ENTRY(PMIC_SCK_TOP_ESP),
	PMIC_ENTRY(PMIC_SCK_TOP_FPI),
	PMIC_ENTRY(PMIC_SCK_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_SCK_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_SCK_TOP_XTAL_SEL),
	PMIC_ENTRY(PMIC_SCK_TOP_RESERVED),
	PMIC_ENTRY(PMIC_XOSC32_ENB_DET),
	PMIC_ENTRY(PMIC_SCK_TOP_TEST_OUT),
	PMIC_ENTRY(PMIC_SCK_TOP_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_SCK_TOP_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_MCLK_PDN),
	PMIC_ENTRY(PMIC_RG_EOSC_CALI_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_EOSC32_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_MCLK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_2SEC_OFF_DET_PDN),
	PMIC_ENTRY(PMIC_SCK_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_MCLK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_MCLK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_1),
	PMIC_ENTRY(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_0),
	PMIC_ENTRY(PMIC_SCK_TOP_CKHWEN_CON_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_CKHWEN_CON_CLR),
	PMIC_ENTRY(PMIC_RG_RTC_CK_TSTSEL_RSV),
	PMIC_ENTRY(PMIC_RG_RTCDET_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_EOSC32_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_SWRST),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_RTC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_RTC_SEC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_EOSC_CALI_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_SCK_TOP_SWRST),
	PMIC_ENTRY(PMIC_SCK_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_RTC),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_RTC),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_RTC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_RTC),
	PMIC_ENTRY(PMIC_SCK_TOP_POLARITY),
	PMIC_ENTRY(PMIC_EOSC_CALI_START),
	PMIC_ENTRY(PMIC_EOSC_CALI_TD),
	PMIC_ENTRY(PMIC_EOSC_CALI_TEST),
	PMIC_ENTRY(PMIC_EOSC_CALI_DCXO_RDY_TD),
	PMIC_ENTRY(PMIC_FRC_VTCXO0_ON),
	PMIC_ENTRY(PMIC_EOSC_CALI_RSV),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_LPDTB),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_LPDEN),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_PWDB),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_LPDTB),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_LPDEN),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_LPDRST),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_CALI),
	PMIC_ENTRY(PMIC_STMP_MODE),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_CHOP_EN),
	PMIC_ENTRY(PMIC_MIX_DCXO_STP_LVSH_EN),
	PMIC_ENTRY(PMIC_MIX_PMU_STP_DDLO_VRTC),
	PMIC_ENTRY(PMIC_MIX_PMU_STP_DDLO_VRTC_EN),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_XOSC32_ENB),
	PMIC_ENTRY(PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_RSV),
	PMIC_ENTRY(PMIC_MIX_EOSC32_VCT_EN),
	PMIC_ENTRY(PMIC_MIX_EOSC32_OPT),
	PMIC_ENTRY(PMIC_MIX_DCXO_STP_LVSH_EN_INT),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_COREDETB),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_F32KOB),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_GPO),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_OE),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_DEBUG_OUT),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_DEBUG_SEL),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_K_EOSC32_EN),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_EMBCK_SEL),
	PMIC_ENTRY(PMIC_MIX_STP_BBWAKEUP),
	PMIC_ENTRY(PMIC_MIX_STP_RTC_DDLO),
	PMIC_ENTRY(PMIC_MIX_RTC_XOSC32_ENB),
	PMIC_ENTRY(PMIC_MIX_EFUSE_XOSC32_ENB_OPT),
	PMIC_ENTRY(PMIC_RTC_ANA_ID),
	PMIC_ENTRY(PMIC_RTC_DIG_ID),
	PMIC_ENTRY(PMIC_RTC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_DNS_CBS),
	PMIC_ENTRY(PMIC_RTC_DNS_BIX),
	PMIC_ENTRY(PMIC_RTC_DNS_ESP),
	PMIC_ENTRY(PMIC_RTC_DNS_FPI),
	PMIC_ENTRY(PMIC_PWREN),
	PMIC_ENTRY(PMIC_BBPU_CLR),
	PMIC_ENTRY(PMIC_BBPU_INIT),
	PMIC_ENTRY(PMIC_AUTO),
	PMIC_ENTRY(PMIC_CLRPKY),
	PMIC_ENTRY(PMIC_RELOAD),
	PMIC_ENTRY(PMIC_CBUSY),
	PMIC_ENTRY(PMIC_KEY_BBPU),
	PMIC_ENTRY(PMIC_ALSTA),
	PMIC_ENTRY(PMIC_TCSTA),
	PMIC_ENTRY(PMIC_LPSTA),
	PMIC_ENTRY(PMIC_AL_EN),
	PMIC_ENTRY(PMIC_TC_EN),
	PMIC_ENTRY(PMIC_ONESHOT),
	PMIC_ENTRY(PMIC_LP_EN),
	PMIC_ENTRY(PMIC_SECCII),
	PMIC_ENTRY(PMIC_MINCII),
	PMIC_ENTRY(PMIC_HOUCII),
	PMIC_ENTRY(PMIC_DOMCII),
	PMIC_ENTRY(PMIC_DOWCII),
	PMIC_ENTRY(PMIC_MTHCII),
	PMIC_ENTRY(PMIC_YEACII),
	PMIC_ENTRY(PMIC_SECCII_1_2),
	PMIC_ENTRY(PMIC_SECCII_1_4),
	PMIC_ENTRY(PMIC_SECCII_1_8),
	PMIC_ENTRY(PMIC_SEC_MSK),
	PMIC_ENTRY(PMIC_MIN_MSK),
	PMIC_ENTRY(PMIC_HOU_MSK),
	PMIC_ENTRY(PMIC_DOM_MSK),
	PMIC_ENTRY(PMIC_DOW_MSK),
	PMIC_ENTRY(PMIC_MTH_MSK),
	PMIC_ENTRY(PMIC_YEA_MSK),
	PMIC_ENTRY(PMIC_TC_SECOND),
	PMIC_ENTRY(PMIC_TC_MINUTE),
	PMIC_ENTRY(PMIC_TC_HOUR),
	PMIC_ENTRY(PMIC_TC_DOM),
	PMIC_ENTRY(PMIC_TC_DOW),
	PMIC_ENTRY(PMIC_TC_MONTH),
	PMIC_ENTRY(PMIC_TC_YEAR),
	PMIC_ENTRY(PMIC_AL_SECOND),
	PMIC_ENTRY(PMIC_BBPU_AUTO_PDN_SEL),
	PMIC_ENTRY(PMIC_BBPU_2SEC_CK_SEL),
	PMIC_ENTRY(PMIC_BBPU_2SEC_EN),
	PMIC_ENTRY(PMIC_BBPU_2SEC_MODE),
	PMIC_ENTRY(PMIC_BBPU_2SEC_STAT_CLEAR),
	PMIC_ENTRY(PMIC_BBPU_2SEC_STAT_STA),
	PMIC_ENTRY(PMIC_RTC_LPD_OPT),
	PMIC_ENTRY(PMIC_K_EOSC32_VTCXO_ON_SEL),
	PMIC_ENTRY(PMIC_AL_MINUTE),
	PMIC_ENTRY(PMIC_AL_HOUR),
	PMIC_ENTRY(PMIC_NEW_SPARE0),
	PMIC_ENTRY(PMIC_AL_DOM),
	PMIC_ENTRY(PMIC_NEW_SPARE1),
	PMIC_ENTRY(PMIC_AL_DOW),
	PMIC_ENTRY(PMIC_NEW_SPARE2),
	PMIC_ENTRY(PMIC_AL_MONTH),
	PMIC_ENTRY(PMIC_NEW_SPARE3),
	PMIC_ENTRY(PMIC_AL_YEAR),
	PMIC_ENTRY(PMIC_RTC_K_EOSC_RSV),
	PMIC_ENTRY(PMIC_XOSCCALI),
	PMIC_ENTRY(PMIC_RTC_XOSC32_ENB),
	PMIC_ENTRY(PMIC_RTC_EMBCK_SEL_MODE),
	PMIC_ENTRY(PMIC_RTC_EMBCK_SRC_SEL),
	PMIC_ENTRY(PMIC_RTC_EMBCK_SEL_OPTION),
	PMIC_ENTRY(PMIC_RTC_GPS_CKOUT_EN),
	PMIC_ENTRY(PMIC_RTC_EOSC32_VCT_EN),
	PMIC_ENTRY(PMIC_RTC_EOSC32_CHOP_EN),
	PMIC_ENTRY(PMIC_RTC_GP_OSC32_CON),
	PMIC_ENTRY(PMIC_RTC_REG_XOSC32_ENB),
	PMIC_ENTRY(PMIC_RTC_POWERKEY1),
	PMIC_ENTRY(PMIC_RTC_POWERKEY2),
	PMIC_ENTRY(PMIC_RTC_PDN1),
	PMIC_ENTRY(PMIC_RTC_PDN2),
	PMIC_ENTRY(PMIC_RTC_SPAR0),
	PMIC_ENTRY(PMIC_RTC_SPAR1),
	PMIC_ENTRY(PMIC_RTC_PROT),
	PMIC_ENTRY(PMIC_RTC_DIFF),
	PMIC_ENTRY(PMIC_POWER_DETECTED),
	PMIC_ENTRY(PMIC_K_EOSC32_RSV),
	PMIC_ENTRY(PMIC_CALI_RD_SEL),
	PMIC_ENTRY(PMIC_RTC_CALI),
	PMIC_ENTRY(PMIC_CALI_WR_SEL),
	PMIC_ENTRY(PMIC_K_EOSC32_OVERFLOW),
	PMIC_ENTRY(PMIC_WRTGR),
	PMIC_ENTRY(PMIC_VBAT_LPSTA_RAW),
	PMIC_ENTRY(PMIC_EOSC32_LPEN),
	PMIC_ENTRY(PMIC_XOSC32_LPEN),
	PMIC_ENTRY(PMIC_LPRST),
	PMIC_ENTRY(PMIC_CDBO),
	PMIC_ENTRY(PMIC_F32KOB),
	PMIC_ENTRY(PMIC_GPO),
	PMIC_ENTRY(PMIC_GOE),
	PMIC_ENTRY(PMIC_GSR),
	PMIC_ENTRY(PMIC_GSMT),
	PMIC_ENTRY(PMIC_GPEN),
	PMIC_ENTRY(PMIC_GPU),
	PMIC_ENTRY(PMIC_GE4),
	PMIC_ENTRY(PMIC_GE8),
	PMIC_ENTRY(PMIC_GPI),
	PMIC_ENTRY(PMIC_LPSTA_RAW),
	PMIC_ENTRY(PMIC_DAT0_LOCK),
	PMIC_ENTRY(PMIC_DAT1_LOCK),
	PMIC_ENTRY(PMIC_DAT2_LOCK),
	PMIC_ENTRY(PMIC_RTC_INT_CNT),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT0),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT1),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT2),
	PMIC_ENTRY(PMIC_RTC_SEC_ANA_ID),
	PMIC_ENTRY(PMIC_RTC_SEC_DIG_ID),
	PMIC_ENTRY(PMIC_RTC_SEC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_DNS_CBS),
	PMIC_ENTRY(PMIC_RTC_SEC_DNS_BIX),
	PMIC_ENTRY(PMIC_RTC_SEC_DNS_ESP),
	PMIC_ENTRY(PMIC_RTC_SEC_DNS_FPI),
	PMIC_ENTRY(PMIC_TC_SECOND_SEC),
	PMIC_ENTRY(PMIC_TC_MINUTE_SEC),
	PMIC_ENTRY(PMIC_TC_HOUR_SEC),
	PMIC_ENTRY(PMIC_TC_DOM_SEC),
	PMIC_ENTRY(PMIC_TC_DOW_SEC),
	PMIC_ENTRY(PMIC_TC_MONTH_SEC),
	PMIC_ENTRY(PMIC_TC_YEAR_SEC),
	PMIC_ENTRY(PMIC_RTC_SEC_CK_PDN),
	PMIC_ENTRY(PMIC_RTC_SEC_WRTGR),
	PMIC_ENTRY(PMIC_DCXO_ANA_ID),
	PMIC_ENTRY(PMIC_DCXO_DIG_ID),
	PMIC_ENTRY(PMIC_DCXO_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_DCXO_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_DCXO_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_DCXO_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_DCXO_DSN_CBS),
	PMIC_ENTRY(PMIC_DCXO_DSN_BIX),
	PMIC_ENTRY(PMIC_DCXO_DSN_ESP),
	PMIC_ENTRY(PMIC_DCXO_DSN_FPI),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_EN_M),
	PMIC_ENTRY(PMIC_XO_BB_LPM_EN),
	PMIC_ENTRY(PMIC_XO_ENBB_MAN),
	PMIC_ENTRY(PMIC_XO_ENBB_EN_M),
	PMIC_ENTRY(PMIC_XO_CLKSEL_MAN),
	PMIC_ENTRY(PMIC_DCXO_CW00_SET),
	PMIC_ENTRY(PMIC_DCXO_CW00_CLR),
	PMIC_ENTRY(PMIC_XO_CLKSEL_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_INTBUF_MAN),
	PMIC_ENTRY(PMIC_XO_PBUF_EN_M),
	PMIC_ENTRY(PMIC_XO_IBUF_EN_M),
	PMIC_ENTRY(PMIC_XO_LPMBUF_MAN),
	PMIC_ENTRY(PMIC_XO_LPM_PREBUF_EN_M),
	PMIC_ENTRY(PMIC_XO_LPBUF_EN_M),
	PMIC_ENTRY(PMIC_XO_BBLPM_CKSEL_M),
	PMIC_ENTRY(PMIC_XO_EN32K_MAN),
	PMIC_ENTRY(PMIC_XO_EN32K_M),
	PMIC_ENTRY(PMIC_XO_XMODE_MAN),
	PMIC_ENTRY(PMIC_XO_XMODE_M),
	PMIC_ENTRY(PMIC_XO_STRUP_MODE),
	PMIC_ENTRY(PMIC_XO_AAC_FPM_TIME),
	PMIC_ENTRY(PMIC_XO_AAC_MODE_LPM),
	PMIC_ENTRY(PMIC_XO_AAC_MODE_FPM),
	PMIC_ENTRY(PMIC_XO_EN26M_OFFSQ_EN),
	PMIC_ENTRY(PMIC_XO_LDOCAL_EN),
	PMIC_ENTRY(PMIC_XO_CBANK_SYNC_DYN),
	PMIC_ENTRY(PMIC_XO_26MLP_MAN_EN),
	PMIC_ENTRY(PMIC_XO_BUFLDOK_EN),
	PMIC_ENTRY(PMIC_XO_PMU_CKEN_M),
	PMIC_ENTRY(PMIC_XO_PMU_CKEN_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_LPM_ISEL_MAN),
	PMIC_ENTRY(PMIC_XO_FPM_ISEL_MAN),
	PMIC_ENTRY(PMIC_XO_CDAC_FPM),
	PMIC_ENTRY(PMIC_XO_CDAC_LPM),
	PMIC_ENTRY(PMIC_XO_32KDIV_NFRAC_FPM),
	PMIC_ENTRY(PMIC_XO_COFST_FPM),
	PMIC_ENTRY(PMIC_XO_32KDIV_NFRAC_LPM),
	PMIC_ENTRY(PMIC_XO_COFST_LPM),
	PMIC_ENTRY(PMIC_XO_CORE_MAN),
	PMIC_ENTRY(PMIC_XO_CORE_EN_M),
	PMIC_ENTRY(PMIC_XO_CORE_TURBO_EN_M),
	PMIC_ENTRY(PMIC_XO_CORE_AAC_EN_M),
	PMIC_ENTRY(PMIC_XO_STARTUP_EN_M),
	PMIC_ENTRY(PMIC_XO_CORE_VBFPM_EN_M),
	PMIC_ENTRY(PMIC_XO_CORE_VBLPM_EN_M),
	PMIC_ENTRY(PMIC_XO_LPMBIAS_EN_M),
	PMIC_ENTRY(PMIC_XO_VTCGEN_EN_M),
	PMIC_ENTRY(PMIC_XO_IAAC_COMP_EN_M),
	PMIC_ENTRY(PMIC_XO_IFPM_COMP_EN_M),
	PMIC_ENTRY(PMIC_XO_ILPM_COMP_EN_M),
	PMIC_ENTRY(PMIC_XO_CORE_BYPCAS_FPM),
	PMIC_ENTRY(PMIC_XO_CORE_GMX2_FPM),
	PMIC_ENTRY(PMIC_XO_CORE_IDAC_FPM),
	PMIC_ENTRY(PMIC_XO_AAC_COMP_MAN),
	PMIC_ENTRY(PMIC_XO_AAC_EN_M),
	PMIC_ENTRY(PMIC_XO_AAC_MONEN_M),
	PMIC_ENTRY(PMIC_XO_COMP_EN_M),
	PMIC_ENTRY(PMIC_XO_COMP_TSTEN_M),
	PMIC_ENTRY(PMIC_XO_AAC_HV_FPM),
	PMIC_ENTRY(PMIC_XO_AAC_IBIAS_FPM),
	PMIC_ENTRY(PMIC_XO_AAC_VOFST_FPM),
	PMIC_ENTRY(PMIC_XO_AAC_COMP_HV_FPM),
	PMIC_ENTRY(PMIC_XO_AAC_VSEL_FPM),
	PMIC_ENTRY(PMIC_XO_AAC_COMP_POL),
	PMIC_ENTRY(PMIC_XO_CORE_BYPCAS_LPM),
	PMIC_ENTRY(PMIC_XO_CORE_GMX2_LPM),
	PMIC_ENTRY(PMIC_XO_CORE_IDAC_LPM),
	PMIC_ENTRY(PMIC_XO_AAC_COMP_HV_LPM),
	PMIC_ENTRY(PMIC_XO_AAC_VSEL_LPM),
	PMIC_ENTRY(PMIC_XO_AAC_HV_LPM),
	PMIC_ENTRY(PMIC_XO_AAC_IBIAS_LPM),
	PMIC_ENTRY(PMIC_XO_AAC_VOFST_LPM),
	PMIC_ENTRY(PMIC_XO_AAC_FPM_SWEN),
	PMIC_ENTRY(PMIC_XO_SWRST),
	PMIC_ENTRY(PMIC_XO_32KDIV_SWRST),
	PMIC_ENTRY(PMIC_XO_32KDIV_RATIO_MAN),
	PMIC_ENTRY(PMIC_XO_32KDIV_TEST_EN),
	PMIC_ENTRY(PMIC_XO_CBANK_SYNC_MAN),
	PMIC_ENTRY(PMIC_XO_CBANK_SYNC_EN_M),
	PMIC_ENTRY(PMIC_XO_CTL_SYNC_MAN),
	PMIC_ENTRY(PMIC_XO_CTL_SYNC_EN_M),
	PMIC_ENTRY(PMIC_XO_LDO_MAN),
	PMIC_ENTRY(PMIC_XO_LDOPBUF_EN_M),
	PMIC_ENTRY(PMIC_XO_LDOPBUF_VSET_M),
	PMIC_ENTRY(PMIC_XO_LDOVTST_EN_M),
	PMIC_ENTRY(PMIC_XO_TEST_VCAL_EN_M),
	PMIC_ENTRY(PMIC_XO_VBIST_EN_M),
	PMIC_ENTRY(PMIC_XO_VTEST_SEL_MUX),
	PMIC_ENTRY(PMIC_XO_RESERVED3),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_EN_M),
	PMIC_ENTRY(PMIC_XO_BUFLDOK_MAN),
	PMIC_ENTRY(PMIC_XO_BUF1LDO_CAL_M),
	PMIC_ENTRY(PMIC_DCXO_CW11_SET),
	PMIC_ENTRY(PMIC_DCXO_CW11_CLR),
	PMIC_ENTRY(PMIC_XO_BUFLDO_CAL_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_CLKSEL_MAN),
	PMIC_ENTRY(PMIC_XO_VIO18PG_BUFEN),
	PMIC_ENTRY(PMIC_XO_CAL_EN_MAN),
	PMIC_ENTRY(PMIC_XO_CAL_EN_M),
	PMIC_ENTRY(PMIC_RG_XO_CORE_OSCTD),
	PMIC_ENTRY(PMIC_XO_THADC_EN),
	PMIC_ENTRY(PMIC_RG_XO_SYNC_CKPOL),
	PMIC_ENTRY(PMIC_RG_XO_CBANK_POL),
	PMIC_ENTRY(PMIC_RG_XO_CBANK_SYNC_BYP),
	PMIC_ENTRY(PMIC_RG_XO_CTL_POL),
	PMIC_ENTRY(PMIC_RG_XO_CTL_SYNC_BYP),
	PMIC_ENTRY(PMIC_RG_XO_LPBUF_INV),
	PMIC_ENTRY(PMIC_RG_XO_LDOPBUF_BYP),
	PMIC_ENTRY(PMIC_RG_XO_LDOPBUF_ENCL),
	PMIC_ENTRY(PMIC_RG_XO_VGBIAS_VSET),
	PMIC_ENTRY(PMIC_RG_XO_PBUF_ISET),
	PMIC_ENTRY(PMIC_RG_XO_IBUF_ISET),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED4),
	PMIC_ENTRY(PMIC_RG_XO_VOW_EN),
	PMIC_ENTRY(PMIC_RG_XO_VOW_DIV),
	PMIC_ENTRY(PMIC_RG_XO_BUFLDO24_ENCL),
	PMIC_ENTRY(PMIC_RG_XO_BUFLDO24_IBX2),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED5),
	PMIC_ENTRY(PMIC_RG_XO_BUFLDO13_ENCL),
	PMIC_ENTRY(PMIC_RG_XO_BUFLDO13_IBX2),
	PMIC_ENTRY(PMIC_RG_XO_BUFLDO13_IX2),
	PMIC_ENTRY(PMIC_RG_XO_LVLDO_I_CTRL),
	PMIC_ENTRY(PMIC_RG_XO_BUFLDO67_ENCL),
	PMIC_ENTRY(PMIC_RG_XO_BUFLDO67_IBX2),
	PMIC_ENTRY(PMIC_RG_XO_BUFLDO67_IX2),
	PMIC_ENTRY(PMIC_RG_XO_LVLDO_RFB),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF_INV),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED0),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_CLKSEL_MAN),
	PMIC_ENTRY(PMIC_XO_AUDIO_EN_M),
	PMIC_ENTRY(PMIC_RG_XO_AUDIO_ATTEN),
	PMIC_ENTRY(PMIC_RG_XO_AUDIO_ISET),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF1_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF2_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF3_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF4_HD),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED8),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF6_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF7_HD),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_ISET_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_ISET_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_ISET_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_ISET_M),
	PMIC_ENTRY(PMIC_XO_RESERVED9),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_ISET_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_ISET_M),
	PMIC_ENTRY(PMIC_RG_XO_LPM_PREBUF_ISET),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED1),
	PMIC_ENTRY(PMIC_XO_THADC_EN_MAN),
	PMIC_ENTRY(PMIC_RG_XO_TSOURCE_EN),
	PMIC_ENTRY(PMIC_XO_BUFLDO13_VSET_M),
	PMIC_ENTRY(PMIC_XO_BUFLDO24_VSET_M),
	PMIC_ENTRY(PMIC_XO_BUFLDO67_VSET_M),
	PMIC_ENTRY(PMIC_XO_STATIC_AUXOUT_SEL),
	PMIC_ENTRY(PMIC_XO_AUXOUT_SEL),
	PMIC_ENTRY(PMIC_XO_STATIC_AUXOUT),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_COMP_EN),
	PMIC_ENTRY(PMIC_RG_XO_HEATER_SEL),
	PMIC_ENTRY(PMIC_RG_XO_CORNER_DETECT_EN),
	PMIC_ENTRY(PMIC_RG_XO_CORNER_DETECT_EN_MAN),
	PMIC_ENTRY(PMIC_RG_XO_RESRVED10),
	PMIC_ENTRY(PMIC_RG_XO_CORNER_SETTING_TUNE),
	PMIC_ENTRY(PMIC_RG_XO_RESRVED11),
	PMIC_ENTRY(PMIC_RGS_AD_XO_CORNER_CAL_DONE),
	PMIC_ENTRY(PMIC_RGS_AD_XO_CORNER_SEL),
	PMIC_ENTRY(PMIC_XO_MDB_TBO_EN_SEL),
	PMIC_ENTRY(PMIC_XO_PTATCTAT_EN_MAN),
	PMIC_ENTRY(PMIC_XO_PTATCTAT_EN_M),
	PMIC_ENTRY(PMIC_XO_PTATCTAT_EN_LPM),
	PMIC_ENTRY(PMIC_XO_PTATCTAT_EN_FPM),
	PMIC_ENTRY(PMIC_DCXO_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_RDEG_SEL),
	PMIC_ENTRY(PMIC_RG_XO_GS_VTEMP),
	PMIC_ENTRY(PMIC_XO_PWRKEY_RSTB_SEL),
	PMIC_ENTRY(PMIC_PSC_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_PSC_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_PSC_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_CBS),
	PMIC_ENTRY(PMIC_PSC_TOP_BIX),
	PMIC_ENTRY(PMIC_PSC_TOP_ESP),
	PMIC_ENTRY(PMIC_PSC_TOP_FPI),
	PMIC_ENTRY(PMIC_PSC_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_PSC_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_PSC_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_PSC_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_RST),
	PMIC_ENTRY(PMIC_RG_PSEQ_PWRMSK_RST_SEL),
	PMIC_ENTRY(PMIC_BANK_STRUP_SWRST),
	PMIC_ENTRY(PMIC_BANK_PSEQ_SWRST),
	PMIC_ENTRY(PMIC_BANK_PCHR_DIG_SWRST),
	PMIC_ENTRY(PMIC_BANK_PCHR_MACRO_SWRST),
	PMIC_ENTRY(PMIC_RG_INT_EN_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_EN_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_EN_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_EN_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_EN_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_EN_CHRDET),
	PMIC_ENTRY(PMIC_RG_INT_EN_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCDT_HV_DET),
	PMIC_ENTRY(PMIC_RG_INT_EN_WATCHDOG),
	PMIC_ENTRY(PMIC_RG_INT_EN_VBATON_UNDET),
	PMIC_ENTRY(PMIC_RG_INT_EN_BVALID_DET),
	PMIC_ENTRY(PMIC_RG_INT_EN_OV),
	PMIC_ENTRY(PMIC_PSC_INT_CON0_SET),
	PMIC_ENTRY(PMIC_PSC_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_MASK_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_MASK_CHRDET),
	PMIC_ENTRY(PMIC_RG_INT_MASK_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCDT_HV_DET),
	PMIC_ENTRY(PMIC_RG_INT_MASK_WATCHDOG),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VBATON_UNDET),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BVALID_DET),
	PMIC_ENTRY(PMIC_RG_INT_MASK_OV),
	PMIC_ENTRY(PMIC_PSC_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_PSC_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_CHRDET),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCDT_HV_DET),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_WATCHDOG),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VBATON_UNDET),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BVALID_DET),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_OV),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_CHRDET),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCDT_HV_DET),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_WATCHDOG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VBATON_UNDET),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BVALID_DET),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_OV),
	PMIC_ENTRY(PMIC_RG_PSC_INT_POLARITY),
	PMIC_ENTRY(PMIC_RG_HOMEKEY_INT_SEL),
	PMIC_ENTRY(PMIC_RG_PWRKEY_INT_SEL),
	PMIC_ENTRY(PMIC_RG_CHRDET_INT_SEL),
	PMIC_ENTRY(PMIC_RG_PCHR_CM_VINC_POLARITY_RSV),
	PMIC_ENTRY(PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV),
	PMIC_ENTRY(PMIC_INT_MISC_CON_SET),
	PMIC_ENTRY(PMIC_INT_MISC_CON_CLR),
	PMIC_ENTRY(PMIC_RG_PSC_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_STRUP_ANA_ID),
	PMIC_ENTRY(PMIC_STRUP_DIG_ID),
	PMIC_ENTRY(PMIC_STRUP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_STRUP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_STRUP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_STRUP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_STRUP_CBS),
	PMIC_ENTRY(PMIC_STRUP_BIX),
	PMIC_ENTRY(PMIC_STRUP_ESP),
	PMIC_ENTRY(PMIC_STRUP_FPI),
	PMIC_ENTRY(PMIC_RG_TM_OUT),
	PMIC_ENTRY(PMIC_RG_THRDET_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_THR_SEL),
	PMIC_ENTRY(PMIC_RG_THR_TMODE),
	PMIC_ENTRY(PMIC_RG_VREF_BG),
	PMIC_ENTRY(PMIC_RG_RST_DRVSEL),
	PMIC_ENTRY(PMIC_RG_EN1_DRVSEL),
	PMIC_ENTRY(PMIC_RG_EN2_DRVSEL),
	PMIC_ENTRY(PMIC_RG_PMU_RSV),
	PMIC_ENTRY(PMIC_RGS_ANA_CHIP_ID),
	PMIC_ENTRY(PMIC_RG_FCHR_PU_EN),
	PMIC_ENTRY(PMIC_RG_FCHR_KEYDET_EN),
	PMIC_ENTRY(PMIC_STRUP_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_STRUP_IREF_TRIM),
	PMIC_ENTRY(PMIC_RG_THR_LOC_SEL),
	PMIC_ENTRY(PMIC_PSEQ_ANA_ID),
	PMIC_ENTRY(PMIC_PSEQ_DIG_ID),
	PMIC_ENTRY(PMIC_PSEQ_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_CBS),
	PMIC_ENTRY(PMIC_PSEQ_BIX),
	PMIC_ENTRY(PMIC_PSEQ_ESP),
	PMIC_ENTRY(PMIC_PSEQ_FPI),
	PMIC_ENTRY(PMIC_RG_PWRHOLD),
	PMIC_ENTRY(PMIC_RG_USBDL_MODE),
	PMIC_ENTRY(PMIC_RG_CRST),
	PMIC_ENTRY(PMIC_RG_WRST),
	PMIC_ENTRY(PMIC_RG_RSTB_ONINTV),
	PMIC_ENTRY(PMIC_RG_CRST_INTV),
	PMIC_ENTRY(PMIC_RG_WRST_INTV),
	PMIC_ENTRY(PMIC_RG_PSEQ_PG_CK_SEL),
	PMIC_ENTRY(PMIC_RG_PSEQ_SPAR_XCPT_MASK),
	PMIC_ENTRY(PMIC_RG_PSEQ_RTCA_XCPT_MASK),
	PMIC_ENTRY(PMIC_RG_THM_SHDN_EN),
	PMIC_ENTRY(PMIC_RG_WDTRST_EN),
	PMIC_ENTRY(PMIC_RG_WDTRST_ACT),
	PMIC_ENTRY(PMIC_RG_KEYPWR_VCORE_OPT),
	PMIC_ENTRY(PMIC_RG_PSEQ_FORCE_ON),
	PMIC_ENTRY(PMIC_RG_PSEQ_FORCE_ALL_DOFF),
	PMIC_ENTRY(PMIC_RG_POR_FLAG),
	PMIC_ENTRY(PMIC_USBDL),
	PMIC_ENTRY(PMIC_RG_THR_TEST),
	PMIC_ENTRY(PMIC_RG_STRUP_THER_DEB_RTD),
	PMIC_ENTRY(PMIC_RG_STRUP_THER_DEB_FTD),
	PMIC_ENTRY(PMIC_DDUVLO_DEB_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_PG_DEB_MODE),
	PMIC_ENTRY(PMIC_RG_STRUP_OSC_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_OSC_EN_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_FT_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRON_FORCE),
	PMIC_ENTRY(PMIC_RG_BIASGEN_FORCE),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRON),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRON_SEL),
	PMIC_ENTRY(PMIC_RG_BIASGEN),
	PMIC_ENTRY(PMIC_RG_BIASGEN_SEL),
	PMIC_ENTRY(PMIC_RG_RTC_XOSC32_ENB),
	PMIC_ENTRY(PMIC_RG_RTC_XOSC32_ENB_SEL),
	PMIC_ENTRY(PMIC_STRUP_DIG_IO_PG_FORCE),
	PMIC_ENTRY(PMIC_RG_CLR_JUST_SMART_RST),
	PMIC_ENTRY(PMIC_CLR_JUST_RST),
	PMIC_ENTRY(PMIC_JUST_SMART_RST),
	PMIC_ENTRY(PMIC_JUST_PWRKEY_RST),
	PMIC_ENTRY(PMIC_DA_QI_OSC_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_SEL),
	PMIC_ENTRY(PMIC_DA_EXT_PMIC_EN1),
	PMIC_ENTRY(PMIC_DA_EXT_PMIC_EN2),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_START_SW),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_RSTB_SW),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_START_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_RSTB_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_RPCNT_MAX),
	PMIC_ENTRY(PMIC_STRUP_PWROFF_SEQ_EN),
	PMIC_ENTRY(PMIC_STRUP_PWROFF_PREOFF_EN),
	PMIC_ENTRY(PMIC_RG_SLOT_INTV_DOWN_MSB),
	PMIC_ENTRY(PMIC_RG_RSV_SWREG),
	PMIC_ENTRY(PMIC_RG_STRUP_UVLO_U1U2_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_UVLO_U1U2_SEL_SWCTRL),
	PMIC_ENTRY(PMIC_RG_UVLO_DEC_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_THR_CLR),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_TD),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKEY_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_SPAR_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_RTCA_CTRL),
	PMIC_ENTRY(PMIC_RG_SMART_RST_SDN_EN),
	PMIC_ENTRY(PMIC_RG_SMART_RST_MODE),
	PMIC_ENTRY(PMIC_RG_STRUP_ENVTEM),
	PMIC_ENTRY(PMIC_RG_STRUP_ENVTEM_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRKEY_COUNT_RESET),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUD28_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VUSB33_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VDRAM_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VEMC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_OTHERS_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUX18_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VPROC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VMODEM_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VCORE_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VS1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUD28_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VUSB33_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VDRAM_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO28_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VEMC_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_OTHERS_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUX18_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VXO22_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VPROC_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMODEM_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VCORE_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS1_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VPROC_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMODEM_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VCORE_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS1_OC_ENB),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_PG_DEBTD),
	PMIC_ENTRY(PMIC_RG_RTC_SPAR_DEB_EN),
	PMIC_ENTRY(PMIC_RG_RTC_ALARM_DEB_EN),
	PMIC_ENTRY(PMIC_PSEQ_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BWDT_EN),
	PMIC_ENTRY(PMIC_RG_BWDT_TSEL),
	PMIC_ENTRY(PMIC_RG_BWDT_CSEL),
	PMIC_ENTRY(PMIC_RG_BWDT_TD),
	PMIC_ENTRY(PMIC_RG_BWDT_CHRTD),
	PMIC_ENTRY(PMIC_RG_BWDT_DDLO_TD),
	PMIC_ENTRY(PMIC_RG_BWDT_SRCSEL),
	PMIC_ENTRY(PMIC_RG_PSPG_SHDN_EN),
	PMIC_ENTRY(PMIC_RG_PSEQ_FSM_RST_SEL),
	PMIC_ENTRY(PMIC_RG_PSEQ_F75K_FORCE),
	PMIC_ENTRY(PMIC_RG_PSEQ_1MS_TK_EXT),
	PMIC_ENTRY(PMIC_RG_PSEQ_IVGEN_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_RESET_EXTEND),
	PMIC_ENTRY(PMIC_RG_CPS_S0EXT_ENB),
	PMIC_ENTRY(PMIC_RG_CPS_S0EXT_TD),
	PMIC_ENTRY(PMIC_RG_SDN_DLY_ENB),
	PMIC_ENTRY(PMIC_RG_CHRDET_DEB_TD),
	PMIC_ENTRY(PMIC_RG_STRUP_UVLO_U1U2_SEL_OLD),
	PMIC_ENTRY(PMIC_EFUSE_IVGEN_ENB_SEL),
	PMIC_ENTRY(PMIC_RG_DSEQ_SEL),
	PMIC_ENTRY(PMIC_RG_PSEQ_ELR_RSV),
	PMIC_ENTRY(PMIC_PCHR_DIG_ANA_ID),
	PMIC_ENTRY(PMIC_PCHR_DIG_DIG_ID),
	PMIC_ENTRY(PMIC_PCHR_DIG_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PCHR_DIG_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PCHR_DIG_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PCHR_DIG_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PCHR_DIG_DSN_CBS),
	PMIC_ENTRY(PMIC_PCHR_DIG_DSN_BIX),
	PMIC_ENTRY(PMIC_PCHR_DIG_DSN_ESP),
	PMIC_ENTRY(PMIC_PCHR_DIG_DSN_FPI),
	PMIC_ENTRY(PMIC_RGS_CHRWDT_OUT),
	PMIC_ENTRY(PMIC_RGS_OTG_BVALID_DET),
	PMIC_ENTRY(PMIC_RGS_VBAT_OV_DET),
	PMIC_ENTRY(PMIC_RGS_CHR_LDO_DET),
	PMIC_ENTRY(PMIC_RGS_CHRDET),
	PMIC_ENTRY(PMIC_RG_PCHR_RV),
	PMIC_ENTRY(PMIC_RG_VCDT_UVLO_EN),
	PMIC_ENTRY(PMIC_RG_VCDT_UVLO_VTH),
	PMIC_ENTRY(PMIC_RG_UVLO_VTHL),
	PMIC_ENTRY(PMIC_RG_UVLO_VH_LAT),
	PMIC_ENTRY(PMIC_RG_VCDT_MODE),
	PMIC_ENTRY(PMIC_RG_VCDT_LV_VTH),
	PMIC_ENTRY(PMIC_RG_VCDT_HV_VTH),
	PMIC_ENTRY(PMIC_RG_VBAT_OV_VTH),
	PMIC_ENTRY(PMIC_DA_QI_BGR_EXT_BUF_EN),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_EN),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_RSTB),
	PMIC_ENTRY(PMIC_RG_BGR_UNCHOP_PH),
	PMIC_ENTRY(PMIC_RG_BGR_UNCHOP),
	PMIC_ENTRY(PMIC_RG_VBAT_CV_VTH),
	PMIC_ENTRY(PMIC_RG_PCHR_FT_CTRL),
	PMIC_ENTRY(PMIC_RG_PCHR_FLAG_EN),
	PMIC_ENTRY(PMIC_RG_PCHR_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_LBAT_INT_VTH),
	PMIC_ENTRY(PMIC_RG_OTG_BVALID_EN),
	PMIC_ENTRY(PMIC_PCHR_DIG_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_ICHRG_TRIM),
	PMIC_ENTRY(PMIC_RG_OVP_TRIM),
	PMIC_ENTRY(PMIC_RG_BGR_TRIM),
	PMIC_ENTRY(PMIC_RG_PCHR_SPARE_ELR0),
	PMIC_ENTRY(PMIC_RG_VBAT_CV_TRIM),
	PMIC_ENTRY(PMIC_RG_PCHR_SPARE_ELR1),
	PMIC_ENTRY(PMIC_PCHR_MACRO_ANA_ID),
	PMIC_ENTRY(PMIC_PCHR_MACRO_DIG_ID),
	PMIC_ENTRY(PMIC_PCHR_MACRO_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PCHR_MACRO_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PCHR_MACRO_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PCHR_MACRO_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PCHR_MACRO_DSN_CBS),
	PMIC_ENTRY(PMIC_PCHR_MACRO_DSN_BIX),
	PMIC_ENTRY(PMIC_PCHR_MACRO_DSN_ESP),
	PMIC_ENTRY(PMIC_PCHR_MACRO_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_CS_VTH),
	PMIC_ENTRY(PMIC_RG_CS_EN),
	PMIC_ENTRY(PMIC_RG_VBAT_OV_EN),
	PMIC_ENTRY(PMIC_RG_VBAT_OV_DEG),
	PMIC_ENTRY(PMIC_RG_VBAT_CV_EN),
	PMIC_ENTRY(PMIC_RG_VBAT_CC_VTH),
	PMIC_ENTRY(PMIC_RG_VBAT_CC_EN),
	PMIC_ENTRY(PMIC_RG_VCDT_HV_EN),
	PMIC_ENTRY(PMIC_RG_LOW_ICH_DB),
	PMIC_ENTRY(PMIC_RG_CV_MODE),
	PMIC_ENTRY(PMIC_RG_CSDAC_MODE),
	PMIC_ENTRY(PMIC_RG_TRACKING_EN),
	PMIC_ENTRY(PMIC_RG_HWCV_EN),
	PMIC_ENTRY(PMIC_RG_ULC_DET_EN),
	PMIC_ENTRY(PMIC_RG_CSDAC_EN),
	PMIC_ENTRY(PMIC_RG_CHR_EN),
	PMIC_ENTRY(PMIC_RGS_CS_DET),
	PMIC_ENTRY(PMIC_RGS_VBAT_CV_DET),
	PMIC_ENTRY(PMIC_RGS_VBAT_CC_DET),
	PMIC_ENTRY(PMIC_RGS_VCDT_LV_DET),
	PMIC_ENTRY(PMIC_RGS_VCDT_HV_DET),
	PMIC_ENTRY(PMIC_RG_CSDAC_DLY),
	PMIC_ENTRY(PMIC_RG_CSDAC_STP),
	PMIC_ENTRY(PMIC_RG_CSDAC_STP_INC),
	PMIC_ENTRY(PMIC_RG_CSDAC_STP_DEC),
	PMIC_ENTRY(PMIC_RG_PCHR_TOHTC),
	PMIC_ENTRY(PMIC_RG_PCHR_TOLTC),
	PMIC_ENTRY(PMIC_RG_CSDAC_DATA),
	PMIC_ENTRY(PMIC_RG_FRC_CSVTH_USBDL),
	PMIC_ENTRY(PMIC_RG_USBDL_RST),
	PMIC_ENTRY(PMIC_RG_USBDL_SET),
	PMIC_ENTRY(PMIC_RG_DAC_USBDL_MAX),
	PMIC_ENTRY(PMIC_RGS_PCHR_FLAG_OUT),
	PMIC_ENTRY(PMIC_RG_PCHR_TESTMODE),
	PMIC_ENTRY(PMIC_RG_CSDAC_TESTMODE),
	PMIC_ENTRY(PMIC_RG_PCHR_RST),
	PMIC_ENTRY(PMIC_RG_BC11_VREF_VTH),
	PMIC_ENTRY(PMIC_RG_BC11_CMP_EN),
	PMIC_ENTRY(PMIC_RG_BC11_IPD_EN),
	PMIC_ENTRY(PMIC_RG_BC11_IPU_EN),
	PMIC_ENTRY(PMIC_RG_BC11_BIAS_EN),
	PMIC_ENTRY(PMIC_RG_BC11_BB_CTRL),
	PMIC_ENTRY(PMIC_RG_BC11_RST),
	PMIC_ENTRY(PMIC_RG_BC11_VSRC_EN),
	PMIC_ENTRY(PMIC_RG_BC11_DCD_EN),
	PMIC_ENTRY(PMIC_RGS_BC11_CMP_OUT),
	PMIC_ENTRY(PMIC_RG_ENVTEM_D),
	PMIC_ENTRY(PMIC_RG_ENVTEM_EN),
	PMIC_ENTRY(PMIC_RG_CHRWDT_TD),
	PMIC_ENTRY(PMIC_RG_CHRWDT_EN),
	PMIC_ENTRY(PMIC_RG_CHRWDT_WR),
	PMIC_ENTRY(PMIC_BM_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_BM_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_BM_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BM_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BM_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BM_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BM_TOP_CBS),
	PMIC_ENTRY(PMIC_BM_TOP_BIX),
	PMIC_ENTRY(PMIC_BM_TOP_ESP),
	PMIC_ENTRY(PMIC_BM_TOP_FPI),
	PMIC_ENTRY(PMIC_BM_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_BM_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_FGADC_FT_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FGADC_DIG_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FGADC_ANA_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BM_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_BM_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_FGADC_ANA_CK_CKSEL),
	PMIC_ENTRY(PMIC_BM_TOP_CKSEL_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_CKSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_FG_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_FGADC_ANA_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_FG_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_FGADC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_FGADC_ANA_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_FGADC0_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_FGADC1_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_BATON_ANA_SWRST),
	PMIC_ENTRY(PMIC_BM_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_BAT0_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_BAT0_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_CUR_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_CUR_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_ZCV),
	PMIC_ENTRY(PMIC_BM_TOP_INT_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_BATON_LV),
	PMIC_ENTRY(PMIC_RG_INT_EN_BATON_HT),
	PMIC_ENTRY(PMIC_BM_TOP_INT_CON1_SET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_BAT0_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_BAT0_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_CUR_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_CUR_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_ZCV),
	PMIC_ENTRY(PMIC_BM_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BATON_LV),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BATON_HT),
	PMIC_ENTRY(PMIC_BM_TOP_INT_MASK_CON1_SET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_MASK_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_BAT0_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_BAT0_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_CUR_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_CUR_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_ZCV),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BATON_LV),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BATON_HT),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_BAT0_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_BAT0_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_CUR_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_CUR_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_ZCV),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BATON_LV),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BATON_HT),
	PMIC_ENTRY(PMIC_POLARITY),
	PMIC_ENTRY(PMIC_BM_INT_MISC_CON_RSV),
	PMIC_ENTRY(PMIC_RG_BM_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_BM_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_BM_TOP_RSV0),
	PMIC_ENTRY(PMIC_FGADC_ANA_ANA_ID),
	PMIC_ENTRY(PMIC_FGADC_ANA_DIG_ID),
	PMIC_ENTRY(PMIC_FGADC_ANA_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC_ANA_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC_ANA_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC_ANA_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC_ANA_DSN_CBS),
	PMIC_ENTRY(PMIC_FGADC_ANA_DSN_BIX),
	PMIC_ENTRY(PMIC_FGADC_ANA_DSN_ESP),
	PMIC_ENTRY(PMIC_FGADC_ANA_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_FGANALOGTEST),
	PMIC_ENTRY(PMIC_RG_FGINTMODE),
	PMIC_ENTRY(PMIC_RG_SPARE),
	PMIC_ENTRY(PMIC_FG_DWA_T0),
	PMIC_ENTRY(PMIC_FG_DWA_T1),
	PMIC_ENTRY(PMIC_FG_DWA_RST_MODE),
	PMIC_ENTRY(PMIC_FG_DWA_RST_SW),
	PMIC_ENTRY(PMIC_DA_DWA_RST),
	PMIC_ENTRY(PMIC_FGADC_ANA_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_FGADC_GAINERROR_CAL),
	PMIC_ENTRY(PMIC_RG_FG_OFFSET_SWAP),
	PMIC_ENTRY(PMIC_FGADC0_ANA_ID),
	PMIC_ENTRY(PMIC_FGADC0_DIG_ID),
	PMIC_ENTRY(PMIC_FGADC0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC0_DSN_CBS),
	PMIC_ENTRY(PMIC_FGADC0_DSN_BIX),
	PMIC_ENTRY(PMIC_FGADC0_DSN_ESP),
	PMIC_ENTRY(PMIC_FGADC0_DSN_FPI),
	PMIC_ENTRY(PMIC_FG_ON),
	PMIC_ENTRY(PMIC_FG_CAL),
	PMIC_ENTRY(PMIC_FG_AUTOCALRATE),
	PMIC_ENTRY(PMIC_FG_SON_SLP_EN),
	PMIC_ENTRY(PMIC_FG_ZCV_DET_EN),
	PMIC_ENTRY(PMIC_FG_AUXADC_R),
	PMIC_ENTRY(PMIC_FG_SW_READ_PRE),
	PMIC_ENTRY(PMIC_FG_SW_RSTCLR),
	PMIC_ENTRY(PMIC_FG_SW_CR),
	PMIC_ENTRY(PMIC_FG_SW_CLEAR),
	PMIC_ENTRY(PMIC_FG_OFFSET_RST),
	PMIC_ENTRY(PMIC_FG_TIME_RST),
	PMIC_ENTRY(PMIC_FG_CHARGE_RST),
	PMIC_ENTRY(PMIC_FG_LATCHDATA_ST),
	PMIC_ENTRY(PMIC_EVENT_FG_BAT0_H),
	PMIC_ENTRY(PMIC_EVENT_FG_BAT0_L),
	PMIC_ENTRY(PMIC_EVENT_FG_CUR_H),
	PMIC_ENTRY(PMIC_EVENT_FG_CUR_L),
	PMIC_ENTRY(PMIC_EVENT_FG_ZCV),
	PMIC_ENTRY(PMIC_FG_OSR1),
	PMIC_ENTRY(PMIC_FG_ADJ_OFFSET_EN),
	PMIC_ENTRY(PMIC_FG_ADC_AUTORST),
	PMIC_ENTRY(PMIC_FG_ADC_RSTDETECT),
	PMIC_ENTRY(PMIC_FG_CAR_15_00),
	PMIC_ENTRY(PMIC_FG_CAR_31_16),
	PMIC_ENTRY(PMIC_FG_CAR_34_32),
	PMIC_ENTRY(PMIC_FG_BAT0_LTH_15_00),
	PMIC_ENTRY(PMIC_FG_BAT0_LTH_31_16),
	PMIC_ENTRY(PMIC_FG_BAT0_HTH_15_00),
	PMIC_ENTRY(PMIC_FG_BAT0_HTH_31_16),
	PMIC_ENTRY(PMIC_FG_NTER_15_00),
	PMIC_ENTRY(PMIC_FG_NTER_31_16),
	PMIC_ENTRY(PMIC_FG_NTER_32),
	PMIC_ENTRY(PMIC_FG_SON_SLP_CUR_TH),
	PMIC_ENTRY(PMIC_FG_SON_SLP_TIME),
	PMIC_ENTRY(PMIC_FG_SON_DET_TIME),
	PMIC_ENTRY(PMIC_FG_FP_FTIME),
	PMIC_ENTRY(PMIC_FG_ZCV_DET_TIME),
	PMIC_ENTRY(PMIC_FG_ZCV_CURR),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_15_00),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_31_16),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_34_32),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_TH_15_00),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_TH_31_16),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_TH_33_32),
	PMIC_ENTRY(PMIC_FGADC1_ANA_ID),
	PMIC_ENTRY(PMIC_FGADC1_DIG_ID),
	PMIC_ENTRY(PMIC_FGADC1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC1_DSN_CBS),
	PMIC_ENTRY(PMIC_FGADC1_DSN_BIX),
	PMIC_ENTRY(PMIC_FGADC1_DSN_ESP),
	PMIC_ENTRY(PMIC_FGADC1_DSN_FPI),
	PMIC_ENTRY(PMIC_FG_R_CURR),
	PMIC_ENTRY(PMIC_FG_CURRENT_OUT),
	PMIC_ENTRY(PMIC_FG_CUR_LTH),
	PMIC_ENTRY(PMIC_FG_CUR_HTH),
	PMIC_ENTRY(PMIC_FG_CIC2),
	PMIC_ENTRY(PMIC_FG_OFFSET),
	PMIC_ENTRY(PMIC_FG_ADJUST_OFFSET_VALUE),
	PMIC_ENTRY(PMIC_FG_GAIN),
	PMIC_ENTRY(PMIC_FG_MODE),
	PMIC_ENTRY(PMIC_FG_RST_SW),
	PMIC_ENTRY(PMIC_FG_FGCAL_EN_SW),
	PMIC_ENTRY(PMIC_FG_FGADC_EN_SW),
	PMIC_ENTRY(PMIC_RG_SYSTEM_INFO_CON0),
	PMIC_ENTRY(PMIC_RG_SYSTEM_INFO_CON1),
	PMIC_ENTRY(PMIC_RG_SYSTEM_INFO_CON2),
	PMIC_ENTRY(PMIC_RG_SYSTEM_INFO_CON3),
	PMIC_ENTRY(PMIC_RG_SYSTEM_INFO_CON4),
	PMIC_ENTRY(PMIC_BATON_ANA_ANA_ID),
	PMIC_ENTRY(PMIC_BATON_ANA_DIG_ID),
	PMIC_ENTRY(PMIC_BATON_ANA_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BATON_ANA_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BATON_ANA_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BATON_ANA_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BATON_ANA_DSN_CBS),
	PMIC_ENTRY(PMIC_BATON_ANA_DSN_BIX),
	PMIC_ENTRY(PMIC_BATON_ANA_DSN_ESP),
	PMIC_ENTRY(PMIC_BATON_ANA_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_BATON_EN),
	PMIC_ENTRY(PMIC_RGS_BATON_UNDET),
	PMIC_ENTRY(PMIC_RG_BATON_LT_EN),
	PMIC_ENTRY(PMIC_RG_BATON_HT_EN),
	PMIC_ENTRY(PMIC_RG_BATON_HT_VTH),
	PMIC_ENTRY(PMIC_RGS_BATON_HT),
	PMIC_ENTRY(PMIC_BATON_ANA_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BATON_HT_TRIM),
	PMIC_ENTRY(PMIC_HK_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_HK_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_HK_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_CBS),
	PMIC_ENTRY(PMIC_HK_TOP_BIX),
	PMIC_ENTRY(PMIC_HK_TOP_ESP),
	PMIC_ENTRY(PMIC_HK_TOP_FPI),
	PMIC_ENTRY(PMIC_HK_CLK_OFFSET),
	PMIC_ENTRY(PMIC_HK_RST_OFFSET),
	PMIC_ENTRY(PMIC_HK_INT_OFFSET),
	PMIC_ENTRY(PMIC_HK_INT_LEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_AO_1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_1M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_1K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_DIVSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_RST),
	PMIC_ENTRY(PMIC_RG_AUXADC_REG_RST),
	PMIC_ENTRY(PMIC_BANK_HK_TOP_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_1_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_2_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_3_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_4_SWRST),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_EN_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_HK_INT_CON0_SET),
	PMIC_ENTRY(PMIC_HK_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_HK_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_HK_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_RG_CLK_MON_FLAG_EN),
	PMIC_ENTRY(PMIC_RG_CLK_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_INT_MON_FLAG_EN),
	PMIC_ENTRY(PMIC_RG_INT_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_HK_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_MON_FLAG_SEL_AUXADC),
	PMIC_ENTRY(PMIC_AUXADC_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_AUXADC_CALI),
	PMIC_ENTRY(PMIC_RG_AUX_RSV),
	PMIC_ENTRY(PMIC_RG_VBUF_BYP),
	PMIC_ENTRY(PMIC_RG_VBUF_CALEN),
	PMIC_ENTRY(PMIC_RG_VBUF_EXTEN),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH5),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH5),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH6),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH6),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH8),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH8),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH9),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH9),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH10),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH10),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH11),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH11),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_15),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH12_15),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_PWRON_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_PWRON_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_FGADC_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP_AVG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_IMP_AVG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_RAW),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_NAG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_NAG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_THR1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_THR2),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ELR_LEN),
	PMIC_ENTRY(PMIC_AUXADC_SW_GAIN_TRIM),
	PMIC_ENTRY(PMIC_AUXADC_SW_OFFSET_TRIM),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_PWRON),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_NAG),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH0),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH1),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH2),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH3),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH5),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH6),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH8),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH9),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH10),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH11),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH12),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH13),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH14),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH15),
	PMIC_ENTRY(PMIC_AUXADC_RQST0_SET),
	PMIC_ENTRY(PMIC_AUXADC_RQST0_CLR),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_THR1),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_THR2),
	PMIC_ENTRY(PMIC_AUXADC_RQST2_SET),
	PMIC_ENTRY(PMIC_AUXADC_RQST2_CLR),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_RQST_BATID),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_RQST_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_RQST_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_RQST1_SET),
	PMIC_ENTRY(PMIC_AUXADC_RQST1_CLR),
	PMIC_ENTRY(PMIC_AUXADC_CK_ON_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_SRCLKEN_SRC_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_PWDB),
	PMIC_ENTRY(PMIC_AUXADC_ADC_PWDB_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_STRUP_CK_ON_ENB),
	PMIC_ENTRY(PMIC_AUXADC_SRCLKEN_CK_EN),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON_GPS),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON_MD),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON),
	PMIC_ENTRY(PMIC_AUXADC_CON0_SET),
	PMIC_ENTRY(PMIC_AUXADC_CON0_CLR),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SMALL),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_LARGE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_LARGE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SLEEP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SLEEP_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH0),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH3),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH7),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH7),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH3),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH0),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_HPC),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_DCXO),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH0_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH1_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH2_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH3_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH4_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH5_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH6_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH7_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH8_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH9_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH10_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH11_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_2S_COMP_ENB),
	PMIC_ENTRY(PMIC_AUXADC_ADC_TRIM_COMP),
	PMIC_ENTRY(PMIC_AUXADC_RNG_EN),
	PMIC_ENTRY(PMIC_AUXADC_TEST_MODE),
	PMIC_ENTRY(PMIC_AUXADC_BIT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_START_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_TS_VBE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TS_VBE_SEL_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_VBUF_EN),
	PMIC_ENTRY(PMIC_AUXADC_VBUF_EN_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_OUT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DA_DAC),
	PMIC_ENTRY(PMIC_AUXADC_DA_DAC_SWCTRL),
	PMIC_ENTRY(PMIC_AD_AUXADC_COMP),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_ANASWCTRL_EN),
	PMIC_ENTRY(PMIC_AUXADC_XO_THADC_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_BATID_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_DIG0_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_CHSEL),
	PMIC_ENTRY(PMIC_AUXADC_SWCTRL_EN),
	PMIC_ENTRY(PMIC_AUXADC_SOURCE_LBAT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SOURCE_LBAT2_SEL),
	PMIC_ENTRY(PMIC_AUXADC_START_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_DAC_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_DAC_EXTD_EN),
	PMIC_ENTRY(PMIC_AUXADC_DIG0_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_NUM),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_EN),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_CLR),
	PMIC_ENTRY(PMIC_AUXADC_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_CH0_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_CH1_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_CH0_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_CH1_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_AUTORPT_PRD),
	PMIC_ENTRY(PMIC_AUXADC_AUTORPT_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_PRD_15_0),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_PRD_19_16),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_AUTO_SPL),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_AUTO_RQST_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_DIG1_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_DIG0_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_R_SW),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_R_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_PLUGIN_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_BAT_PLUGIN_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DBG_DIG0_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_DBG_DIG1_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_CNT),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_CHSEL),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_IRQ_CLR),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_IRQ_STATUS),
	PMIC_ENTRY(PMIC_AUXADC_CLR_IMP_CNT_STOP),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_MODE),
	PMIC_ENTRY(PMIC_AUXADC_IMP_AUTORPT_PRD),
	PMIC_ENTRY(PMIC_AUXADC_IMP_AUTORPT_EN),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ELR_LEN),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH4_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH4_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH0_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH0_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH7_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH7_TRIM),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_DEGC_CALI),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ADC_CALI_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_1RSV0),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_2RSV0),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_SLOPE),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_SLOPE_SIGN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_3RSV0),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_AUXADC_RSV),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ID),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_4RSV0),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_2),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_2RSV0_2),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_3),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_2RSV0_3),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_PRD),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_CNT),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_CLR),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_SRCLKEN_IND),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_RDY_ST_PRD),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_RDY_ST_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_PRD),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL),
	PMIC_ENTRY(PMIC_AUXADC_NAG_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CLR),
	PMIC_ENTRY(PMIC_AUXADC_NAG_VBAT1_SEL),
	PMIC_ENTRY(PMIC_AUXADC_NAG_PRD),
	PMIC_ENTRY(PMIC_AUXADC_NAG_IRQ_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_IRQ),
	PMIC_ENTRY(PMIC_AUXADC_NAG_ZCV),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_15_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_26_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_15_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_25_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_DLTV),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_15_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_26_16),
	PMIC_ENTRY(PMIC_AUXADC_RSV_1RSV0),
	PMIC_ENTRY(PMIC_DA_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_VBAT_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_DA_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_BATID_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_IMP_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_IMP_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_LBAT_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_LBAT_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_NAG_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_NAG_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_EXT_BATON_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_BUCK_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_CBS),
	PMIC_ENTRY(PMIC_BUCK_TOP_BIX),
	PMIC_ENTRY(PMIC_BUCK_TOP_ESP),
	PMIC_ENTRY(PMIC_BUCK_TOP_FPI),
	PMIC_ENTRY(PMIC_BUCK_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_BUCK_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_BUCK_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_BUCK_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK_ANA_AUTO_OFF_DIS),
	PMIC_ENTRY(PMIC_RG_BUCK_ANA_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK1M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK_DCM_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_FREQ_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_FREQ_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_FREQ_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_FREQ_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_FREQ_SEL),
	PMIC_ENTRY(PMIC_RG_INT_EN_VPROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMODEM_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VPA_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCORE_PREOC),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_EN_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_EN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VPROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMODEM_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VPA_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCORE_PREOC),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VPROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMODEM_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VPA_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCORE_PREOC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VPROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMODEM_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VPA_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCORE_PREOC),
	PMIC_ENTRY(PMIC_RG_BUCK_STB_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_LP_PROT_DISABLE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSLEEP_SRC0),
	PMIC_ENTRY(PMIC_RG_BUCK_VSLEEP_SRC1),
	PMIC_ENTRY(PMIC_RG_BUCK_R2R_SRC0),
	PMIC_ENTRY(PMIC_RG_BUCK_R2R_SRC1),
	PMIC_ENTRY(PMIC_RG_BUCK_LP_SEQ_COUNT),
	PMIC_ENTRY(PMIC_RG_BUCK_ON_SEQ_COUNT),
	PMIC_ENTRY(PMIC_RG_BUCK_MINFREQ_LATENCY_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_MINFREQ_DURATION_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_K_RST_DONE),
	PMIC_ENTRY(PMIC_RG_BUCK_K_MAP_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_K_ONCE_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_K_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_K_START_MANUAL),
	PMIC_ENTRY(PMIC_RG_BUCK_K_SRC_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_K_AUTO_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_K_INV),
	PMIC_ENTRY(PMIC_RG_BUCK_K_CK_EN),
	PMIC_ENTRY(PMIC_BUCK_K_RESULT),
	PMIC_ENTRY(PMIC_BUCK_K_DONE),
	PMIC_ENTRY(PMIC_BUCK_K_CONTROL),
	PMIC_ENTRY(PMIC_DA_SMPS_OSC_CAL),
	PMIC_ENTRY(PMIC_RG_BUCK_K_BUCK_CK_CNT),
	PMIC_ENTRY(PMIC_BUCK_VPROC_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VCORE_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS1_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VPA_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_TOP_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_OC_SDN_EN_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_K_CONTROL_SMPS),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_BUCK_VPROC_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VPROC_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VPROC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VPROC_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VPROC_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VPROC_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_DVS_EN_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_DVS_EN_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_DVS_EN_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_DVS_DOWN_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_DVS_DOWN_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_DVS_DOWN_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_ON_OP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_LP_OP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_SP_SW_VOSEL_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_SP_ON_VOSEL_MUX_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OC_DEG_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OC_WND),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OC_THD),
	PMIC_ENTRY(PMIC_DA_VPROC_VOSEL),
	PMIC_ENTRY(PMIC_DA_VPROC_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VPROC_EN),
	PMIC_ENTRY(PMIC_DA_VPROC_STB),
	PMIC_ENTRY(PMIC_DA_VPROC_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VPROC_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VPROC_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VPROC_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VPROC_SSH),
	PMIC_ENTRY(PMIC_DA_VPROC_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OC_FLAG_CLR_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_CK_SW_EN),
	PMIC_ENTRY(PMIC_BUCK_VPROC_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_DVS_EN_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_DVS_EN_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_DVS_EN_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_DVS_DOWN_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_DVS_DOWN_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_DVS_DOWN_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_ON_OP),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_LP_OP),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SP_SW_VOSEL_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SP_ON_VOSEL_MUX_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_DEG_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_WND),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_THD),
	PMIC_ENTRY(PMIC_DA_VCORE_VOSEL),
	PMIC_ENTRY(PMIC_DA_VCORE_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VCORE_EN),
	PMIC_ENTRY(PMIC_DA_VCORE_STB),
	PMIC_ENTRY(PMIC_DA_VCORE_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VCORE_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VCORE_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VCORE_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VCORE_SSH),
	PMIC_ENTRY(PMIC_DA_VCORE_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_FLAG_CLR_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_CK_SW_EN),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_DVS_EN_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_DVS_EN_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_DVS_EN_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_DVS_DOWN_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_DVS_DOWN_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_DVS_DOWN_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_ON_OP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_LP_OP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SP_SW_VOSEL_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SP_ON_VOSEL_MUX_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OC_DEG_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OC_WND),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OC_THD),
	PMIC_ENTRY(PMIC_DA_VMODEM_VOSEL),
	PMIC_ENTRY(PMIC_DA_VMODEM_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VMODEM_EN),
	PMIC_ENTRY(PMIC_DA_VMODEM_STB),
	PMIC_ENTRY(PMIC_DA_VMODEM_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VMODEM_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VMODEM_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VMODEM_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VMODEM_SSH),
	PMIC_ENTRY(PMIC_DA_VMODEM_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OC_FLAG_CLR_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_CK_SW_EN),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS1_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VS1_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VS1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_DVS_EN_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_DVS_EN_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_DVS_EN_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_DVS_DOWN_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_DVS_DOWN_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_DVS_DOWN_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_ON_OP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_LP_OP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SP_SW_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SP_SW_VOSEL_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SP_ON_VOSEL_MUX_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_DEG_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_WND),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_THD),
	PMIC_ENTRY(PMIC_DA_VS1_VOSEL),
	PMIC_ENTRY(PMIC_DA_VS1_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VS1_EN),
	PMIC_ENTRY(PMIC_DA_VS1_STB),
	PMIC_ENTRY(PMIC_DA_VS1_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VS1_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VS1_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VS1_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_FLAG_CLR_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS1_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VPA_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VPA_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VPA_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPA_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPA_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPA_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DVS_TRANST_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DVS_TRANST_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DVS_TRANST_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DVS_BW_TD),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DVS_BW_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DVS_BW_ONCE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_OC_DEG_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_OC_WND),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_OC_THD),
	PMIC_ENTRY(PMIC_DA_VPA_VOSEL),
	PMIC_ENTRY(PMIC_DA_VPA_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VPA_EN),
	PMIC_ENTRY(PMIC_DA_VPA_STB),
	PMIC_ENTRY(PMIC_DA_VPA_DVS_TRANST),
	PMIC_ENTRY(PMIC_DA_VPA_DVS_BW),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_OC_FLAG_CLR_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL_DLC011),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL_DLC111),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL_DLC001),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DLC_MAP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DLC),
	PMIC_ENTRY(PMIC_DA_VPA_DLC),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RDELTA2GO),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FDELTA2GO),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE0),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE1),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE2),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE3),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE4),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE5),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD0),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD1),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD2),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD3),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD4),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE0),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE1),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE2),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE3),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE4),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE5),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD0),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD1),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD2),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD3),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD4),
	PMIC_ENTRY(PMIC_BUCK_ANA_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_ANA_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_ANA_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_ANA_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_SMPS_TESTMODE_B),
	PMIC_ENTRY(PMIC_RG_VPA_BURSTH),
	PMIC_ENTRY(PMIC_RG_VPA_BURSTL),
	PMIC_ENTRY(PMIC_RG_VCORE_TRIML),
	PMIC_ENTRY(PMIC_RG_VCORE_SLEEP_VOLTAGE),
	PMIC_ENTRY(PMIC_RG_VMODEM_SLEEP_VOLTAGE),
	PMIC_ENTRY(PMIC_RG_VPROC_TRIML),
	PMIC_ENTRY(PMIC_RG_VPROC_SLEEP_VOLTAGE),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_SLEEP_VOLTAGE),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_SLEEP_VOLTAGE),
	PMIC_ENTRY(PMIC_RG_SMPS_IVGD_DET),
	PMIC_ENTRY(PMIC_RG_AUTOK_RST),
	PMIC_ENTRY(PMIC_RG_VCORE_FPWM),
	PMIC_ENTRY(PMIC_RG_VPROC_FPWM),
	PMIC_ENTRY(PMIC_RG_VCORE_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VPROC_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_FCOT),
	PMIC_ENTRY(PMIC_RG_VPROC_FCOT),
	PMIC_ENTRY(PMIC_RG_VCOREVPROC_TMDL),
	PMIC_ENTRY(PMIC_RG_VCORE_TBDIS),
	PMIC_ENTRY(PMIC_RG_VPROC_TBDIS),
	PMIC_ENTRY(PMIC_RG_VCORE_VDIFFOFF),
	PMIC_ENTRY(PMIC_RG_VPROC_VDIFFOFF),
	PMIC_ENTRY(PMIC_RG_VCORE_RCOMP0),
	PMIC_ENTRY(PMIC_RG_VCORE_RCOMP1),
	PMIC_ENTRY(PMIC_RG_VCORE_CCOMP0),
	PMIC_ENTRY(PMIC_RG_VCORE_CCOMP1),
	PMIC_ENTRY(PMIC_RG_VCORE_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VPROC_RCOMP0),
	PMIC_ENTRY(PMIC_RG_VPROC_RCOMP1),
	PMIC_ENTRY(PMIC_RG_VPROC_CCOMP0),
	PMIC_ENTRY(PMIC_RG_VPROC_CCOMP1),
	PMIC_ENTRY(PMIC_RG_VPROC_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VCORE_RCS),
	PMIC_ENTRY(PMIC_RG_VPROC_RCS),
	PMIC_ENTRY(PMIC_RG_VCORE_RCB),
	PMIC_ENTRY(PMIC_RG_VPROC_RCB),
	PMIC_ENTRY(PMIC_RG_VCORE_TB_WIDTH),
	PMIC_ENTRY(PMIC_RG_VPROC_TB_WIDTH),
	PMIC_ENTRY(PMIC_RG_VCORE_UG_SR),
	PMIC_ENTRY(PMIC_RG_VCORE_LG_SR),
	PMIC_ENTRY(PMIC_RG_VPROC_UG_SR),
	PMIC_ENTRY(PMIC_RG_VPROC_LG_SR),
	PMIC_ENTRY(PMIC_RG_VCORE_PFM_TON),
	PMIC_ENTRY(PMIC_RG_VPROC_PFM_TON),
	PMIC_ENTRY(PMIC_RGS_VCORE_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VPROC_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VCORE_PREOC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VCORE_DIG_MON),
	PMIC_ENTRY(PMIC_RGS_VPROC_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VCORE_TRAN_BST),
	PMIC_ENTRY(PMIC_RG_VPROC_TRAN_BST),
	PMIC_ENTRY(PMIC_RG_VCORE_COTRAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VPROC_COTRAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VCORE_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VPROC_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VCORE_VREFTB),
	PMIC_ENTRY(PMIC_RG_VPROC_VREFTB),
	PMIC_ENTRY(PMIC_RG_VCORE_FUGON),
	PMIC_ENTRY(PMIC_RG_VPROC_FUGON),
	PMIC_ENTRY(PMIC_RG_VCORE_FLGON),
	PMIC_ENTRY(PMIC_RG_VPROC_FLGON),
	PMIC_ENTRY(PMIC_RG_VCORE_RSV),
	PMIC_ENTRY(PMIC_RG_VPROC_RSV),
	PMIC_ENTRY(PMIC_RG_VCOREVPROC_DISAUTOK),
	PMIC_ENTRY(PMIC_RGS_VCORE_PFM_FLAG),
	PMIC_ENTRY(PMIC_RGS_VPROC_PFM_FLAG),
	PMIC_ENTRY(PMIC_RG_VPROC_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_FCOT),
	PMIC_ENTRY(PMIC_RG_VMODEM_RCOMP),
	PMIC_ENTRY(PMIC_RG_VMODEM_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VMODEM_DISPG),
	PMIC_ENTRY(PMIC_RG_VMODEM_FPWM),
	PMIC_ENTRY(PMIC_RG_VMODEM_PFM_TON),
	PMIC_ENTRY(PMIC_RG_VMODEM_PWMRAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VMODEM_COTRAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VMODEM_RCS),
	PMIC_ENTRY(PMIC_RG_VMODEM_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VMODEM_NLIM_GATING),
	PMIC_ENTRY(PMIC_RG_VMODEM_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VMODEM_VREFUP),
	PMIC_ENTRY(PMIC_RG_VMODEM_TB_WIDTH),
	PMIC_ENTRY(PMIC_RG_VMODEM_UG_SR),
	PMIC_ENTRY(PMIC_RG_VMODEM_LG_SR),
	PMIC_ENTRY(PMIC_RG_VMODEM_CCOMP),
	PMIC_ENTRY(PMIC_RG_VMODEM_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_TMDL),
	PMIC_ENTRY(PMIC_RG_VMODEM_RSV),
	PMIC_ENTRY(PMIC_RG_VMODEM_FUGON),
	PMIC_ENTRY(PMIC_RG_VMODEM_FLGON),
	PMIC_ENTRY(PMIC_RG_VMODEM_VDIFFPFM_OFF),
	PMIC_ENTRY(PMIC_RGS_VMODEM_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMODEM_ENPWM_STATUS),
	PMIC_ENTRY(PMIC_RG_VMODEM_DISAUTOK),
	PMIC_ENTRY(PMIC_RGS_VMODEM_TRIMOK_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMODEM_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VMODEM_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RGS_VMODEM_PFM_FLAG),
	PMIC_ENTRY(PMIC_RG_VS1_MIN_OFF),
	PMIC_ENTRY(PMIC_RG_VS1_VRF18_SSTART_EN),
	PMIC_ENTRY(PMIC_RG_VS1_1P35UP_SEL_EN),
	PMIC_ENTRY(PMIC_RG_VS1_RZSEL),
	PMIC_ENTRY(PMIC_RG_VS1_CSR),
	PMIC_ENTRY(PMIC_RG_VS1_CSL),
	PMIC_ENTRY(PMIC_RG_VS1_SLP),
	PMIC_ENTRY(PMIC_RG_VS1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VS1_CSM_N),
	PMIC_ENTRY(PMIC_RG_VS1_CSM_P),
	PMIC_ENTRY(PMIC_RG_VS1_RSV),
	PMIC_ENTRY(PMIC_RG_VS1_MODESET),
	PMIC_ENTRY(PMIC_RG_VS1_TRAN_BST),
	PMIC_ENTRY(PMIC_RG_VS1_DTS_ENB),
	PMIC_ENTRY(PMIC_RG_VS1_AUTO_MODE),
	PMIC_ENTRY(PMIC_RG_VS1_PWM_TRIG),
	PMIC_ENTRY(PMIC_RG_VS1_RSV_L),
	PMIC_ENTRY(PMIC_RG_VS1_SR_P),
	PMIC_ENTRY(PMIC_RG_VS1_SR_N),
	PMIC_ENTRY(PMIC_RG_VS1_BURST),
	PMIC_ENTRY(PMIC_RGS_VS1_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VS1_DIG_MON),
	PMIC_ENTRY(PMIC_RGS_VS1_PFM_FLAG),
	PMIC_ENTRY(PMIC_RG_VS1_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VPA_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VPA_MODESET),
	PMIC_ENTRY(PMIC_RG_VPA_CC),
	PMIC_ENTRY(PMIC_RG_VPA_CSR),
	PMIC_ENTRY(PMIC_RG_VPA_CSMIR),
	PMIC_ENTRY(PMIC_RG_VPA_CSL),
	PMIC_ENTRY(PMIC_RG_VPA_SLP),
	PMIC_ENTRY(PMIC_RG_VPA_AZC_EN),
	PMIC_ENTRY(PMIC_RG_VPA_CP_FWUPOFF),
	PMIC_ENTRY(PMIC_RG_VPA_AZC_DELAY),
	PMIC_ENTRY(PMIC_RG_VPA_RZSEL),
	PMIC_ENTRY(PMIC_RG_VPA_HZP),
	PMIC_ENTRY(PMIC_RG_VPA_BWEX_GAT),
	PMIC_ENTRY(PMIC_RG_VPA_SLEW),
	PMIC_ENTRY(PMIC_RG_VPA_SLEW_NMOS),
	PMIC_ENTRY(PMIC_RG_VPA_MIN_ON),
	PMIC_ENTRY(PMIC_RG_VPA_VBAT_DEL),
	PMIC_ENTRY(PMIC_RGS_VPA_AZC_VOS_SEL),
	PMIC_ENTRY(PMIC_RG_VPA_MIN_PK),
	PMIC_ENTRY(PMIC_RG_VPA_RSV1),
	PMIC_ENTRY(PMIC_RG_VPA_RSV2),
	PMIC_ENTRY(PMIC_RGS_VPA_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VPA_AZC_ZX),
	PMIC_ENTRY(PMIC_RGS_VPA_DIG_MON),
	PMIC_ENTRY(PMIC_BUCK_ANA_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VS1_TRIMH),
	PMIC_ENTRY(PMIC_RG_VS1_TRIML),
	PMIC_ENTRY(PMIC_RG_VS1_VSLEEP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_SLEEP_VOLTAGE),
	PMIC_ENTRY(PMIC_RG_VCORE_TRIMH),
	PMIC_ENTRY(PMIC_RG_VCORE_VSLEEP_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC_TRIMH),
	PMIC_ENTRY(PMIC_RG_VPROC_VSLEEP_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_TRIMH),
	PMIC_ENTRY(PMIC_RG_VMODEM_TRIML),
	PMIC_ENTRY(PMIC_RG_VMODEM_VSLEEP_TRIM),
	PMIC_ENTRY(PMIC_RG_VPA_TRIMH),
	PMIC_ENTRY(PMIC_RG_VPA_TRIML),
	PMIC_ENTRY(PMIC_RG_VPA_TRIM_REF),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_TRIML),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_VSLEEP_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_TRIML),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_VSLEEP_TRIM),
	PMIC_ENTRY(PMIC_RG_VOUTDET_EN),
	PMIC_ENTRY(PMIC_RG_M17L17_FLAG),
	PMIC_ENTRY(PMIC_RG_VCORE_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CSP_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CSN_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_RPSI1_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_PREOC_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC_CSP_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC_CSN_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC_RPSI1_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VCOREVPROC_DISCONFIG20),
	PMIC_ENTRY(PMIC_RG_VMODEM_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_CSP_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_CSN_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_RPSI_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_ZXOS_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_ZX_OS),
	PMIC_ENTRY(PMIC_RG_VS1_RSV_H),
	PMIC_ENTRY(PMIC_RG_VS1_PFM_RIP),
	PMIC_ENTRY(PMIC_RG_VPA_ZXREF),
	PMIC_ENTRY(PMIC_RG_VPA_NLIM_SEL),
	PMIC_ENTRY(PMIC_LDO_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_CBS),
	PMIC_ENTRY(PMIC_LDO_TOP_BIX),
	PMIC_ENTRY(PMIC_LDO_TOP_ESP),
	PMIC_ENTRY(PMIC_LDO_TOP_FPI),
	PMIC_ENTRY(PMIC_LDO_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_LDO_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_LDO_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_LDO_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_LDO_DCM_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_INT_EN_VFE28_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRF12_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCN33_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCN28_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCAMA_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCAMD_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCAMIO_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VLDO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VUSB33_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VAUD28_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VIO28_OC),
	PMIC_ENTRY(PMIC_LDO_INT_CON0_SET),
	PMIC_ENTRY(PMIC_LDO_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_VIO18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_PROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_OTHERS_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VIBR_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VDRAM_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMCH_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSIM2_OC),
	PMIC_ENTRY(PMIC_LDO_INT_CON1_SET),
	PMIC_ENTRY(PMIC_LDO_INT_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VFE28_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRF12_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCN33_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCN28_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCAMA_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCAMD_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCAMIO_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VLDO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VUSB33_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VAUD28_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VIO28_OC),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VIO18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_PROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_OTHERS_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VIBR_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VDRAM_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMCH_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSIM2_OC),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON1_SET),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VFE28_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRF12_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCN33_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCN28_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCAMA_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCAMD_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCAMIO_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VLDO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VUSB33_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VAUD28_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VIO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VIO18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_PROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_OTHERS_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VIBR_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VDRAM_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMCH_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VFE28_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRF12_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCN33_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCN28_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCAMA_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCAMD_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCAMIO_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VLDO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VUSB33_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VAUD28_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VIO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VIO18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_PROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_OTHERS_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VIBR_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VDRAM_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMCH_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_LDO_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_INT_FLAG_EN),
	PMIC_ENTRY(PMIC_RG_LDO_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_WDT_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_TOP_RSV0),
	PMIC_ENTRY(PMIC_RG_LDO_TOP_RSV1),
	PMIC_ENTRY(PMIC_LDO_DEGTD_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_LP_PROT_DISABLE),
	PMIC_ENTRY(PMIC_RG_LDO_DUMMY_LOAD_GATED_DIS),
	PMIC_ENTRY(PMIC_LDO_GON0_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GON0_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GON0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GON0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GON0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GON0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GON0_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GON0_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GON0_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GON0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VXO22_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_STBTD),
	PMIC_ENTRY(PMIC_DA_VXO22_STB),
	PMIC_ENTRY(PMIC_DA_VXO22_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VXO22_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VXO22_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VAUX18_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_STBTD),
	PMIC_ENTRY(PMIC_DA_VAUX18_STB),
	PMIC_ENTRY(PMIC_DA_VAUX18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_AUXADC_PWDB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VAUX18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VAUX18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VAUD28_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_STBTD),
	PMIC_ENTRY(PMIC_DA_VAUD28_STB),
	PMIC_ENTRY(PMIC_DA_VAUD28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_AUXADC_PWDB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VAUD28_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VAUD28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VIO28_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_STBTD),
	PMIC_ENTRY(PMIC_DA_VIO28_STB),
	PMIC_ENTRY(PMIC_DA_VIO28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VIO28_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VIO28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VIO18_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_STBTD),
	PMIC_ENTRY(PMIC_DA_VIO18_STB),
	PMIC_ENTRY(PMIC_DA_VIO18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VIO18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VDRAM_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_STBTD),
	PMIC_ENTRY(PMIC_DA_VDRAM_STB),
	PMIC_ENTRY(PMIC_DA_VDRAM_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VDRAM_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VDRAM_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VDRAM_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_LDO_GON1_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GON1_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GON1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GON1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GON1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GON1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GON1_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GON1_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GON1_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GON1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VEMC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_STBTD),
	PMIC_ENTRY(PMIC_DA_VEMC_STB),
	PMIC_ENTRY(PMIC_DA_VEMC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VEMC_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VEMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_EN_0),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_EN_1),
	PMIC_ENTRY(PMIC_DA_VUSB33_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_STBTD),
	PMIC_ENTRY(PMIC_DA_VUSB33_STB),
	PMIC_ENTRY(PMIC_DA_VUSB33_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VUSB33_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB33_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VUSB33_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_TD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_CTRL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_ONCE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_TRACK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_TD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_CTRL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_ONCE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_TRACK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SP_SW_VOSEL_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SP_SW_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SP_SW_VOSEL_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SP_SW_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_R2R_PDN_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_R2R_PDN_DIS),
	PMIC_ENTRY(PMIC_LDO_VSRAM_PROC_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_LDO_VSRAM_OTHERS_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_LDO_GON1_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_LDO_GOFF0_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GOFF0_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GOFF0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF0_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GOFF0_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GOFF0_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GOFF0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VFE28_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_STBTD),
	PMIC_ENTRY(PMIC_DA_VFE28_STB),
	PMIC_ENTRY(PMIC_DA_VFE28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VFE28_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VFE28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VRF18_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_STBTD),
	PMIC_ENTRY(PMIC_DA_VRF18_STB),
	PMIC_ENTRY(PMIC_DA_VRF18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VRF18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VRF18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VRF12_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_STBTD),
	PMIC_ENTRY(PMIC_DA_VRF12_STB),
	PMIC_ENTRY(PMIC_DA_VRF12_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VRF12_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VRF12_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VEFUSE_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_STBTD),
	PMIC_ENTRY(PMIC_DA_VEFUSE_STB),
	PMIC_ENTRY(PMIC_DA_VEFUSE_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VEFUSE_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VEFUSE_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VCN18_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_STBTD),
	PMIC_ENTRY(PMIC_DA_VCN18_STB),
	PMIC_ENTRY(PMIC_DA_VCN18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCN18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VCN18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VCAMA_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_STBTD),
	PMIC_ENTRY(PMIC_DA_VCAMA_STB),
	PMIC_ENTRY(PMIC_DA_VCAMA_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCAMA_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMA_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VCAMA_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_LDO_GOFF1_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GOFF1_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GOFF1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF1_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GOFF1_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GOFF1_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GOFF1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VCAMD_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_STBTD),
	PMIC_ENTRY(PMIC_DA_VCAMD_STB),
	PMIC_ENTRY(PMIC_DA_VCAMD_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCAMD_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMD_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VCAMD_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VCAMIO_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_STBTD),
	PMIC_ENTRY(PMIC_DA_VCAMIO_STB),
	PMIC_ENTRY(PMIC_DA_VCAMIO_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCAMIO_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VCAMIO_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VMC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_STBTD),
	PMIC_ENTRY(PMIC_DA_VMC_STB),
	PMIC_ENTRY(PMIC_DA_VMC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VMC_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VMCH_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_STBTD),
	PMIC_ENTRY(PMIC_DA_VMCH_STB),
	PMIC_ENTRY(PMIC_DA_VMCH_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VMCH_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMCH_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VMCH_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VSIM1_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_STBTD),
	PMIC_ENTRY(PMIC_DA_VSIM1_STB),
	PMIC_ENTRY(PMIC_DA_VSIM1_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSIM1_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSIM1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VSIM2_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_STBTD),
	PMIC_ENTRY(PMIC_DA_VSIM2_STB),
	PMIC_ENTRY(PMIC_DA_VSIM2_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSIM2_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSIM2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_LDO_GOFF2_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GOFF2_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GOFF2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF2_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GOFF2_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GOFF2_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GOFF2_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VIBR_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_STBTD),
	PMIC_ENTRY(PMIC_DA_VIBR_STB),
	PMIC_ENTRY(PMIC_DA_VIBR_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VIBR_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VIBR_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_EN_0),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_EN_1),
	PMIC_ENTRY(PMIC_DA_VCN33_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_STBTD),
	PMIC_ENTRY(PMIC_DA_VCN33_STB),
	PMIC_ENTRY(PMIC_DA_VCN33_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCN33_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VCN33_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_EN_0),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_EN_1),
	PMIC_ENTRY(PMIC_DA_VLDO28_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_STBTD),
	PMIC_ENTRY(PMIC_DA_VLDO28_STB),
	PMIC_ENTRY(PMIC_DA_VLDO28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VLDO28_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VLDO28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VLDO28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_GOFF2_RSV0),
	PMIC_ENTRY(PMIC_RG_LDO_GOFF2_RSV1),
	PMIC_ENTRY(PMIC_LDO_GOFF3_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GOFF3_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GOFF3_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF3_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF3_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF3_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GOFF3_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GOFF3_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GOFF3_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GOFF3_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_DA_VCN28_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_STBTD),
	PMIC_ENTRY(PMIC_DA_VCN28_STB),
	PMIC_ENTRY(PMIC_DA_VCN28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCN28_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VCN28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_VRTC_EN),
	PMIC_ENTRY(PMIC_DA_VRTC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_EN),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_TREF_STBTD),
	PMIC_ENTRY(PMIC_DA_TREF_STB),
	PMIC_ENTRY(PMIC_DA_TREF_EN),
	PMIC_ENTRY(PMIC_RG_LDO_GOFF3_RSV0),
	PMIC_ENTRY(PMIC_RG_LDO_GOFF3_RSV1),
	PMIC_ENTRY(PMIC_LDO_ANA0_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_ANA0_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_ANA0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_ANA0_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_ANA0_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_ANA0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_VFE28_VOCAL),
	PMIC_ENTRY(PMIC_RG_VFE28_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCN28_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCN28_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VAUD28_VOCAL),
	PMIC_ENTRY(PMIC_RG_VAUD28_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VAUX18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VXO22_VOCAL),
	PMIC_ENTRY(PMIC_RG_VXO22_VOSEL),
	PMIC_ENTRY(PMIC_RG_VXO22_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCN33_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCN33_VOSEL),
	PMIC_ENTRY(PMIC_RG_VCN33_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VEMC_VOCAL),
	PMIC_ENTRY(PMIC_RG_VEMC_VOSEL),
	PMIC_ENTRY(PMIC_RG_VEMC_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VLDO28_VOCAL),
	PMIC_ENTRY(PMIC_RG_VLDO28_VOSEL),
	PMIC_ENTRY(PMIC_RG_VLDO28_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VIO28_VOCAL),
	PMIC_ENTRY(PMIC_RG_VIO28_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VIBR_VOCAL),
	PMIC_ENTRY(PMIC_RG_VIBR_VOSEL),
	PMIC_ENTRY(PMIC_RG_VIBR_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSIM1_VOCAL),
	PMIC_ENTRY(PMIC_RG_VSIM1_VOSEL),
	PMIC_ENTRY(PMIC_RG_VSIM1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSIM2_VOCAL),
	PMIC_ENTRY(PMIC_RG_VSIM2_VOSEL),
	PMIC_ENTRY(PMIC_RG_VSIM2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMCH_VOCAL),
	PMIC_ENTRY(PMIC_RG_VMCH_VOSEL),
	PMIC_ENTRY(PMIC_RG_VMCH_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMCH_RSV),
	PMIC_ENTRY(PMIC_RG_VMC_VOCAL),
	PMIC_ENTRY(PMIC_RG_VMC_VOSEL),
	PMIC_ENTRY(PMIC_RG_VMC_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCAMIO_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCAMIO_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCN18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCN18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRF18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VRF18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VIO18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VDRAM_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VDRAM_RSV),
	PMIC_ENTRY(PMIC_RG_VRF12_VOCAL),
	PMIC_ENTRY(PMIC_RG_VRF12_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_STB_SEL),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_NDIS_PLCUR),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_PLCUR_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_RSV_H),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_RSV_L),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_STB_SEL),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_NDIS_PLCUR),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_PLCUR_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_RSV_H),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_RSV_L),
	PMIC_ENTRY(PMIC_LDO_ANA0_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VFE28_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN28_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VAUD28_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VAUX18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VXO22_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN33_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VEMC_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VLDO28_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VIO28_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VIBR_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VSIM1_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VSIM2_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VMCH_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VMCH_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VMC_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCAMIO_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VRF18_VOTRIM),
	PMIC_ENTRY(PMIC_LDO_ANA1_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_ANA1_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_ANA1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_ANA1_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_ANA1_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_ANA1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_VUSB33_VOCAL),
	PMIC_ENTRY(PMIC_RG_VUSB33_VOSEL),
	PMIC_ENTRY(PMIC_RG_VUSB33_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCAMA_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCAMA_VOSEL),
	PMIC_ENTRY(PMIC_RG_VCAMA_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VOCAL),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VOSEL),
	PMIC_ENTRY(PMIC_RG_VEFUSE_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCAMD_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCAMD_VOSEL),
	PMIC_ENTRY(PMIC_RG_VCAMD_NDIS_EN),
	PMIC_ENTRY(PMIC_LDO_ANA1_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VUSB33_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCAMA_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCAMD_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VIO18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VDRAM_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VRF12_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VRTC_BIAS_SEL),
	PMIC_ENTRY(PMIC_RG_VDRAM_VOCAL_1),
	PMIC_ENTRY(PMIC_RG_VDRAM_VOSEL_1),
	PMIC_ENTRY(PMIC_RG_VDRAM_VOCAL),
	PMIC_ENTRY(PMIC_RG_VDRAM_VOSEL),
	PMIC_ENTRY(PMIC_XPP_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_XPP_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_XPP_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_XPP_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_XPP_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_XPP_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_XPP_TOP_CBS),
	PMIC_ENTRY(PMIC_XPP_TOP_BIX),
	PMIC_ENTRY(PMIC_XPP_TOP_ESP),
	PMIC_ENTRY(PMIC_XPP_TOP_FPI),
	PMIC_ENTRY(PMIC_XPP_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_XPP_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_XPP_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_XPP_TEST_OUT),
	PMIC_ENTRY(PMIC_XPP_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_XPP_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK0_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK1_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK2_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK3_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_128K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_CHRIND_CK_PDN),
	PMIC_ENTRY(PMIC_XPP_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_XPP_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK_CK_CKSEL),
	PMIC_ENTRY(PMIC_XPP_TOP_CKSEL_CON0_SET),
	PMIC_ENTRY(PMIC_XPP_TOP_CKSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_DRIVER_BL_RST),
	PMIC_ENTRY(PMIC_RG_DRIVER_CI_RST),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_DRIVER_BL_BANK_RST),
	PMIC_ENTRY(PMIC_RG_DRIVER_CI_BANK_RST),
	PMIC_ENTRY(PMIC_RG_DRIVER_DL_BANK_RST),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_BANK_CON0_SET),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_BANK_CON0_CLR),
	PMIC_ENTRY(PMIC_DRIVER_BL_ANA_ID),
	PMIC_ENTRY(PMIC_DRIVER_BL_DIG_ID),
	PMIC_ENTRY(PMIC_DRIVER_BL_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_BL_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_BL_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_BL_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_BL_DSN_CBS),
	PMIC_ENTRY(PMIC_DRIVER_BL_DSN_BIX),
	PMIC_ENTRY(PMIC_DRIVER_BL_DSN_ESP),
	PMIC_ENTRY(PMIC_DRIVER_BL_DSN_FPI),
	PMIC_ENTRY(PMIC_ISINK_DIM1_FSEL),
	PMIC_ENTRY(PMIC_EN1_GPIO_SEL),
	PMIC_ENTRY(PMIC_BIAS1_GPIO_SEL),
	PMIC_ENTRY(PMIC_STEP1_GPIO_SEL),
	PMIC_ENTRY(PMIC_CHOP1_GPIO_SEL),
	PMIC_ENTRY(PMIC_CHOP1_SW_SEL),
	PMIC_ENTRY(PMIC_ISINK_DIM1_DUTY),
	PMIC_ENTRY(PMIC_ISINK_CH1_STEP),
	PMIC_ENTRY(PMIC_ISINK_BREATH1_TF2_SEL),
	PMIC_ENTRY(PMIC_ISINK_BREATH1_TF1_SEL),
	PMIC_ENTRY(PMIC_ISINK_BREATH1_TR2_SEL),
	PMIC_ENTRY(PMIC_ISINK_BREATH1_TR1_SEL),
	PMIC_ENTRY(PMIC_ISINK_BREATH1_TOFF_SEL),
	PMIC_ENTRY(PMIC_ISINK_BREATH1_TON_SEL),
	PMIC_ENTRY(PMIC_AD_ISINK3_STATUS),
	PMIC_ENTRY(PMIC_AD_ISINK2_STATUS),
	PMIC_ENTRY(PMIC_AD_ISINK1_STATUS),
	PMIC_ENTRY(PMIC_ISINK_PHASE1_DLY_EN),
	PMIC_ENTRY(PMIC_ISINK_PHASE1_DLY_TC),
	PMIC_ENTRY(PMIC_ISINK_CHOP1_SW),
	PMIC_ENTRY(PMIC_ISINK_SFSTR1_EN),
	PMIC_ENTRY(PMIC_ISINK_SFSTR1_TC),
	PMIC_ENTRY(PMIC_ISINK_CH1_EN),
	PMIC_ENTRY(PMIC_ISINK_CHOP1_EN),
	PMIC_ENTRY(PMIC_ISINK_CH1_BIAS_EN),
	PMIC_ENTRY(PMIC_ISINK_RSV),
	PMIC_ENTRY(PMIC_ISINK_CH1_PWM_MODE),
	PMIC_ENTRY(PMIC_ISINK_CH1_MODE),
	PMIC_ENTRY(PMIC_RG_ISINK_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_ISINK_TRIM_SEL),
	PMIC_ENTRY(PMIC_RG_ISINK_RSV),
	PMIC_ENTRY(PMIC_RG_ISINK1_CHOP_EN),
	PMIC_ENTRY(PMIC_RG_ISINK2_CHOP_EN),
	PMIC_ENTRY(PMIC_RG_ISINK3_CHOP_EN),
	PMIC_ENTRY(PMIC_RG_ISINK1_DOUBLE),
	PMIC_ENTRY(PMIC_RG_ISINK2_DOUBLE),
	PMIC_ENTRY(PMIC_RG_ISINK3_DOUBLE),
	PMIC_ENTRY(PMIC_DA_ISINK1_EN),
	PMIC_ENTRY(PMIC_DA_ISINK1_BIAS_EN),
	PMIC_ENTRY(PMIC_DA_ISINK1_CHOP_CLK),
	PMIC_ENTRY(PMIC_DA_ISINK1_STEP),
	PMIC_ENTRY(PMIC_DA_ISINK3_EN),
	PMIC_ENTRY(PMIC_DA_ISINK3_BIAS_EN),
	PMIC_ENTRY(PMIC_DA_ISINK3_CHOP_CLK),
	PMIC_ENTRY(PMIC_DA_ISINK3_STEP),
	PMIC_ENTRY(PMIC_DA_ISINK2_EN),
	PMIC_ENTRY(PMIC_DA_ISINK2_BIAS_EN),
	PMIC_ENTRY(PMIC_DA_ISINK2_CHOP_CLK),
	PMIC_ENTRY(PMIC_DA_ISINK2_STEP),
	PMIC_ENTRY(PMIC_DRIVER_BL_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_ISINK_TRIM_BIAS),
	PMIC_ENTRY(PMIC_DRIVER_CI_ANA_ID),
	PMIC_ENTRY(PMIC_DRIVER_CI_DIG_ID),
	PMIC_ENTRY(PMIC_DRIVER_CI_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_CI_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_CI_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_CI_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_CI_DSN_CBS),
	PMIC_ENTRY(PMIC_DRIVER_CI_DSN_BIX),
	PMIC_ENTRY(PMIC_DRIVER_CI_DSN_ESP),
	PMIC_ENTRY(PMIC_DRIVER_CI_DSN_FPI),
	PMIC_ENTRY(PMIC_CHRIND_DIM_FSEL),
	PMIC_ENTRY(PMIC_CHRIND_DIM_DUTY),
	PMIC_ENTRY(PMIC_CHRIND_RSV0),
	PMIC_ENTRY(PMIC_INDICATOR_STEP_GPIO_SEL),
	PMIC_ENTRY(PMIC_INDICATOR_EN_GPIO_SEL),
	PMIC_ENTRY(PMIC_CHRIND_STEP),
	PMIC_ENTRY(PMIC_CHRIND_PWM_MODE),
	PMIC_ENTRY(PMIC_CHRIND_BREATH_TF2_SEL),
	PMIC_ENTRY(PMIC_CHRIND_BREATH_TF1_SEL),
	PMIC_ENTRY(PMIC_CHRIND_BREATH_TR2_SEL),
	PMIC_ENTRY(PMIC_CHRIND_BREATH_TR1_SEL),
	PMIC_ENTRY(PMIC_CHRIND_BREATH_TOFF_SEL),
	PMIC_ENTRY(PMIC_CHRIND_BREATH_TON_SEL),
	PMIC_ENTRY(PMIC_CHRIND_SFSTR_EN),
	PMIC_ENTRY(PMIC_CHRIND_SFSTR_TC),
	PMIC_ENTRY(PMIC_CHRIND_EN_SEL),
	PMIC_ENTRY(PMIC_CHRIND_EN),
	PMIC_ENTRY(PMIC_CHRIND_CHOP_EN),
	PMIC_ENTRY(PMIC_CHRIND_MODE),
	PMIC_ENTRY(PMIC_CHRIND_CHOP_SW),
	PMIC_ENTRY(PMIC_CHRIND_BIAS_EN),
	PMIC_ENTRY(PMIC_CHRIND_MODE_SEL),
	PMIC_ENTRY(PMIC_DA_INDICATOR_EN),
	PMIC_ENTRY(PMIC_DA_INDICATOR_STEP),
	PMIC_ENTRY(PMIC_DRIVER_DL_ANA_ID),
	PMIC_ENTRY(PMIC_DRIVER_DL_DIG_ID),
	PMIC_ENTRY(PMIC_DRIVER_DL_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_DL_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_DL_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_DL_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_DL_DSN_CBS),
	PMIC_ENTRY(PMIC_DRIVER_DL_DSN_BIX),
	PMIC_ENTRY(PMIC_DRIVER_DL_DSN_ESP),
	PMIC_ENTRY(PMIC_DRIVER_DL_DSN_FPI),
	PMIC_ENTRY(PMIC_EN2_GPIO_SEL),
	PMIC_ENTRY(PMIC_BIAS2_GPIO_SEL),
	PMIC_ENTRY(PMIC_STEP2_GPIO_SEL),
	PMIC_ENTRY(PMIC_CHOP2_GPIO_SEL),
	PMIC_ENTRY(PMIC_ISINK_CH2_STEP),
	PMIC_ENTRY(PMIC_EN3_GPIO_SEL),
	PMIC_ENTRY(PMIC_BIAS3_GPIO_SEL),
	PMIC_ENTRY(PMIC_STEP3_GPIO_SEL),
	PMIC_ENTRY(PMIC_CHOP3_GPIO_SEL),
	PMIC_ENTRY(PMIC_ISINK_CH3_STEP),
	PMIC_ENTRY(PMIC_ISINK_CH3_EN),
	PMIC_ENTRY(PMIC_ISINK_CH2_EN),
	PMIC_ENTRY(PMIC_ISINK_CHOP3_EN),
	PMIC_ENTRY(PMIC_ISINK_CHOP2_EN),
	PMIC_ENTRY(PMIC_ISINK_CH3_BIAS_EN),
	PMIC_ENTRY(PMIC_ISINK_CH2_BIAS_EN),
	PMIC_ENTRY(PMIC_AUD_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_AUD_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_AUD_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUD_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUD_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUD_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUD_TOP_CBS),
	PMIC_ENTRY(PMIC_AUD_TOP_BIX),
	PMIC_ENTRY(PMIC_AUD_TOP_ESP),
	PMIC_ENTRY(PMIC_AUD_TOP_FPI),
	PMIC_ENTRY(PMIC_AUD_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_AUD_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_AUD_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_AUD_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_ACCDET_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUD_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUDIF_CK_PDN),
	PMIC_ENTRY(PMIC_RG_ZCD13M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUDNCP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_AUD_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_AUDIF_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_CKSEL_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_CKSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_AUD26M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_AUD_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUDIF_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUD26M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUDIO_RST),
	PMIC_ENTRY(PMIC_RG_ACCDET_RST),
	PMIC_ENTRY(PMIC_RG_ZCD_RST),
	PMIC_ENTRY(PMIC_RG_AUDNCP_RST),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_BANK_ACCDET_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUDIO_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUDZCD_SWRST),
	PMIC_ENTRY(PMIC_RG_INT_EN_AUDIO),
	PMIC_ENTRY(PMIC_RG_INT_EN_ACCDET),
	PMIC_ENTRY(PMIC_RG_INT_EN_ACCDET_EINT0),
	PMIC_ENTRY(PMIC_RG_INT_EN_ACCDET_EINT1),
	PMIC_ENTRY(PMIC_RG_AUD_INT_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_AUDIO),
	PMIC_ENTRY(PMIC_RG_INT_MASK_ACCDET),
	PMIC_ENTRY(PMIC_RG_INT_MASK_ACCDET_EINT0),
	PMIC_ENTRY(PMIC_RG_INT_MASK_ACCDET_EINT1),
	PMIC_ENTRY(PMIC_RG_AUD_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_AUDIO),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_ACCDET),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_ACCDET_EINT0),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_ACCDET_EINT1),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_AUDIO),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_ACCDET),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_ACCDET_EINT0),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_ACCDET_EINT1),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_INT_POLARITY),
	PMIC_ENTRY(PMIC_RG_DIVCKS_CHG),
	PMIC_ENTRY(PMIC_RG_DIVCKS_ON),
	PMIC_ENTRY(PMIC_RG_DIVCKS_PRG),
	PMIC_ENTRY(PMIC_RG_DIVCKS_PWD_NCP),
	PMIC_ENTRY(PMIC_RG_DIVCKS_PWD_NCP_ST_SEL),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_MON_SEL),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_INT_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_INT_MON_FLAG_EN),
	PMIC_ENTRY(PMIC_AUDIO_DIG_ANA_ID),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DIG_ID),
	PMIC_ENTRY(PMIC_AUDIO_DIG_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDIO_DIG_ESP),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DSN_FPI),
	PMIC_ENTRY(PMIC_AFE_ON),
	PMIC_ENTRY(PMIC_AFE_DL_LR_SWAP),
	PMIC_ENTRY(PMIC_AFE_UL_LR_SWAP),
	PMIC_ENTRY(PMIC_DL_2_SRC_ON_TMP_CTL_PRE),
	PMIC_ENTRY(PMIC_C_TWO_DIGITAL_MIC_CTL),
	PMIC_ENTRY(PMIC_C_DIGMIC_PHASE_SEL_CH2_CTL),
	PMIC_ENTRY(PMIC_C_DIGMIC_PHASE_SEL_CH1_CTL),
	PMIC_ENTRY(PMIC_UL_SRC_ON_TMP_CTL),
	PMIC_ENTRY(PMIC_UL_SDM_3_LEVEL_CTL),
	PMIC_ENTRY(PMIC_UL_LOOP_BACK_MODE_CTL),
	PMIC_ENTRY(PMIC_DIGMIC_3P25M_1P625M_SEL_CTL),
	PMIC_ENTRY(PMIC_DMIC_LOW_POWER_MODE_CTL),
	PMIC_ENTRY(PMIC_DL_SINE_ON),
	PMIC_ENTRY(PMIC_UL_SINE_ON),
	PMIC_ENTRY(PMIC_PDN_RESERVED),
	PMIC_ENTRY(PMIC_PDN_AFE_TESTMODEL_CTL),
	PMIC_ENTRY(PMIC_PWR_CLK_DIS_CTL),
	PMIC_ENTRY(PMIC_PDN_I2S_DL_CTL),
	PMIC_ENTRY(PMIC_PDN_ADC_CTL),
	PMIC_ENTRY(PMIC_PDN_DAC_CTL),
	PMIC_ENTRY(PMIC_PDN_AFE_CTL),
	PMIC_ENTRY(PMIC_AFE_MON_SEL),
	PMIC_ENTRY(PMIC_AUDIO_SYS_TOP_MON_SEL),
	PMIC_ENTRY(PMIC_AUDIO_SYS_TOP_MON_SWAP),
	PMIC_ENTRY(PMIC_CCI_SCRAMBLER_EN),
	PMIC_ENTRY(PMIC_CCI_AUD_SDM_7BIT_SEL),
	PMIC_ENTRY(PMIC_CCI_AUD_SDM_MUTER),
	PMIC_ENTRY(PMIC_CCI_AUD_SDM_MUTEL),
	PMIC_ENTRY(PMIC_CCI_AUD_SPLIT_TEST_EN),
	PMIC_ENTRY(PMIC_CCI_ZERO_PAD_DISABLE),
	PMIC_ENTRY(PMIC_CCI_AUD_IDAC_TEST_EN),
	PMIC_ENTRY(PMIC_CCI_SPLT_SCRMB_ON),
	PMIC_ENTRY(PMIC_CCI_SPLT_SCRMB_CLK_ON),
	PMIC_ENTRY(PMIC_CCI_RAND_EN),
	PMIC_ENTRY(PMIC_CCI_LCH_INV),
	PMIC_ENTRY(PMIC_CCI_SCRAMBLER_CG_EN),
	PMIC_ENTRY(PMIC_CCI_AUDIO_FIFO_WPTR),
	PMIC_ENTRY(PMIC_CCI_AUD_ANACK_SEL),
	PMIC_ENTRY(PMIC_AUD_SDM_TEST_R),
	PMIC_ENTRY(PMIC_AUD_SDM_TEST_L),
	PMIC_ENTRY(PMIC_CCI_ACD_FUNC_RSTB),
	PMIC_ENTRY(PMIC_CCI_AFIFO_CLK_PWDB),
	PMIC_ENTRY(PMIC_CCI_ACD_MODE),
	PMIC_ENTRY(PMIC_CCI_AUDIO_FIFO_ENABLE),
	PMIC_ENTRY(PMIC_CCI_AUDIO_FIFO_CLKIN_INV),
	PMIC_ENTRY(PMIC_CCI_AUD_DAC_ANA_RSTB_SEL),
	PMIC_ENTRY(PMIC_CCI_AUD_DAC_ANA_MUTE),
	PMIC_ENTRY(PMIC_DIGMIC_TESTCK_SEL),
	PMIC_ENTRY(PMIC_DIGMIC_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_SDM_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_SDM_ANA13M_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_SDM_ANA13M_TESTCK_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WDATA_TESTSRC_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WDATA_TESTEN),
	PMIC_ENTRY(PMIC_UL_FIFO_DIGMIC_WDATA_TESTSRC_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WCLK_INV),
	PMIC_ENTRY(PMIC_R_AUD_DAC_NEG_LARGE_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_POS_LARGE_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_SW_RSTB),
	PMIC_ENTRY(PMIC_R_AUD_DAC_MONO_SEL),
	PMIC_ENTRY(PMIC_R_AUD_DAC_NEG_TINY_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_POS_TINY_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_NEG_SMALL_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_POS_SMALL_MONO),
	PMIC_ENTRY(PMIC_AUD_SCR_OUT_R),
	PMIC_ENTRY(PMIC_AUD_SCR_OUT_L),
	PMIC_ENTRY(PMIC_RGS_AUDRCTUNE0READ),
	PMIC_ENTRY(PMIC_RGS_AUDRCTUNE1READ),
	PMIC_ENTRY(PMIC_ASYNC_TEST_OUT_BCK),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_FIFO_INTEN),
	PMIC_ENTRY(PMIC_AFE_RESERVED),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_RD_EMPTY_STATUS),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_WR_FULL_STATUS),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_FIFO_STATUS),
	PMIC_ENTRY(PMIC_MTKAIFTX_V3_SDATA_OUT1),
	PMIC_ENTRY(PMIC_MTKAIFTX_V3_SDATA_OUT2),
	PMIC_ENTRY(PMIC_MTKAIFTX_V3_SYNC_OUT),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_INVALID_CYCLE),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_INVALID_FLAG),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_SEARCH_FAIL_FLAG),
	PMIC_ENTRY(PMIC_MTKAIFRX_V3_SDATA_IN1),
	PMIC_ENTRY(PMIC_MTKAIFRX_V3_SDATA_IN2),
	PMIC_ENTRY(PMIC_MTKAIFRX_V3_SYNC_IN),
	PMIC_ENTRY(PMIC_MTKAIF_TXIF_IN_CH1),
	PMIC_ENTRY(PMIC_MTKAIF_TXIF_IN_CH2),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_OUT_CH1),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_OUT_CH2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_LOOPBACK_TEST1),
	PMIC_ENTRY(PMIC_RG_MTKAIF_LOOPBACK_TEST2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_PMIC_TXIF_8TO5),
	PMIC_ENTRY(PMIC_RG_MTKAIF_TXIF_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_BYPASS_SRC_TEST),
	PMIC_ENTRY(PMIC_RG_MTKAIF_BYPASS_SRC_MODE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_CLKINV),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_DATA_MODE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_DETECT_ON),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_FIFO_RSP),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_DATA_BIT),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_VOICE_MODE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_VOICE_MODE_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_SYNC_CHECK_ROUND),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_INVALID_SYNC_CHECK_ROUND),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_SYNC_SEARCH_TABLE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_SYNC_CNT_TABLE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_CLEAR_SYNC_FAIL),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_DETECT_ON_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_FIFO_RSP_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_SYNC_WORD1),
	PMIC_ENTRY(PMIC_RG_MTKAIF_SYNC_WORD2),
	PMIC_ENTRY(PMIC_C_MUTE_SW_CTL),
	PMIC_ENTRY(PMIC_C_DAC_EN_CTL),
	PMIC_ENTRY(PMIC_C_AMP_DIV_CH1_CTL),
	PMIC_ENTRY(PMIC_C_FREQ_DIV_CH1_CTL),
	PMIC_ENTRY(PMIC_C_SGEN_RCH_INV_8BIT),
	PMIC_ENTRY(PMIC_C_SGEN_RCH_INV_5BIT),
	PMIC_ENTRY(PMIC_RG_AMIC_UL_ADC_CLK_SEL),
	PMIC_ENTRY(PMIC_RG_UL_ASYNC_FIFO_SOFT_RST),
	PMIC_ENTRY(PMIC_RG_UL_ASYNC_FIFO_SOFT_RST_EN),
	PMIC_ENTRY(PMIC_DCCLK_GEN_ON),
	PMIC_ENTRY(PMIC_DCCLK_PDN),
	PMIC_ENTRY(PMIC_DCCLK_INV),
	PMIC_ENTRY(PMIC_DCCLK_DIV),
	PMIC_ENTRY(PMIC_DCCLK_PHASE_SEL),
	PMIC_ENTRY(PMIC_DCCLK_RESYNC_BYPASS),
	PMIC_ENTRY(PMIC_RESYNC_SRC_CK_INV),
	PMIC_ENTRY(PMIC_RESYNC_SRC_SEL),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_PHASE_MODE),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_DAT_MISO_LOOPBACK),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_PHASE_MODE2),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_DAT_MISO2_LOOPBACK),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_TX_FIFO_ON),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_MTKAIF_CLK_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_TX_FIFO_RSP),
	PMIC_ENTRY(PMIC_ADDA_AUD_PAD_TOP_MON),
	PMIC_ENTRY(PMIC_ADDA_AUD_PAD_TOP_MON1),
	PMIC_ENTRY(PMIC_AUDENC_ANA_ID),
	PMIC_ENTRY(PMIC_AUDENC_DIG_ID),
	PMIC_ENTRY(PMIC_AUDENC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDENC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDENC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDENC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDENC_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDENC_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDENC_DSN_ESP),
	PMIC_ENTRY(PMIC_AUDENC_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLON),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLDCCEN),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLDCRPECHARGE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLPGATEST),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLVSCALE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLINPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLGAIN),
	PMIC_ENTRY(PMIC_RG_AUDADCLPWRUP),
	PMIC_ENTRY(PMIC_RG_AUDADCLINPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRON),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRDCCEN),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRDCRPECHARGE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRPGATEST),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRVSCALE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRINPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRGAIN),
	PMIC_ENTRY(PMIC_RG_AUDADCRPWRUP),
	PMIC_ENTRY(PMIC_RG_AUDADCRINPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADC1STSTAGEIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADC2NDSTAGEIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADCREFBUFIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADCFLASHIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADCDAC0P25FS),
	PMIC_ENTRY(PMIC_RG_AUDADCCLKSEL),
	PMIC_ENTRY(PMIC_RG_AUDADCCLKSOURCE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPAAFEN),
	PMIC_ENTRY(PMIC_RG_CMSTBENH),
	PMIC_ENTRY(PMIC_RG_PGABODYSW),
	PMIC_ENTRY(PMIC_RG_AUDADC1STSTAGESDENB),
	PMIC_ENTRY(PMIC_RG_AUDADC2NDSTAGERESET),
	PMIC_ENTRY(PMIC_RG_AUDADC3RDSTAGERESET),
	PMIC_ENTRY(PMIC_RG_AUDADCFSRESET),
	PMIC_ENTRY(PMIC_RG_AUDADCWIDECM),
	PMIC_ENTRY(PMIC_RG_AUDADCNOPATEST),
	PMIC_ENTRY(PMIC_RG_AUDADCBYPASS),
	PMIC_ENTRY(PMIC_RG_AUDADCFFBYPASS),
	PMIC_ENTRY(PMIC_RG_AUDADCDACFBCURRENT),
	PMIC_ENTRY(PMIC_RG_AUDADCDACIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADCDACNRZ),
	PMIC_ENTRY(PMIC_RG_AUDADCNODEM),
	PMIC_ENTRY(PMIC_RG_AUDADCDACTEST),
	PMIC_ENTRY(PMIC_RG_AUDRCTUNEL),
	PMIC_ENTRY(PMIC_RG_AUDRCTUNELSEL),
	PMIC_ENTRY(PMIC_RG_AUDRCTUNER),
	PMIC_ENTRY(PMIC_RG_AUDRCTUNERSEL),
	PMIC_ENTRY(PMIC_RG_CLKSQ_EN),
	PMIC_ENTRY(PMIC_RG_CLKSQ_IN_SEL_TEST),
	PMIC_ENTRY(PMIC_RG_CM_REFGENSEL),
	PMIC_ENTRY(PMIC_RG_AUDSPARE),
	PMIC_ENTRY(PMIC_RG_AUDENCSPARE),
	PMIC_ENTRY(PMIC_RG_AUDDIGMICEN),
	PMIC_ENTRY(PMIC_RG_AUDDIGMICBIAS),
	PMIC_ENTRY(PMIC_RG_DMICHPCLKEN),
	PMIC_ENTRY(PMIC_RG_AUDDIGMICPDUTY),
	PMIC_ENTRY(PMIC_RG_AUDDIGMICNDUTY),
	PMIC_ENTRY(PMIC_RG_DMICMONEN),
	PMIC_ENTRY(PMIC_RG_DMICMONSEL),
	PMIC_ENTRY(PMIC_RG_AUDSPAREVMIC),
	PMIC_ENTRY(PMIC_RG_AUDPWDBMICBIAS0),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0BYPASSEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0VREF),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW0P1EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW0P2EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW0NEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW2P1EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW2P2EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW2NEN),
	PMIC_ENTRY(PMIC_RG_AUDPWDBMICBIAS1),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1BYPASSEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1VREF),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1DCSW1PEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1DCSW1NEN),
	PMIC_ENTRY(PMIC_RG_BANDGAPGEN),
	PMIC_ENTRY(PMIC_RG_MTEST_EN),
	PMIC_ENTRY(PMIC_RG_MTEST_SEL),
	PMIC_ENTRY(PMIC_RG_MTEST_CURRENT),
	PMIC_ENTRY(PMIC_RG_AUDACCDETMICBIAS0PULLLOW),
	PMIC_ENTRY(PMIC_RG_AUDACCDETMICBIAS1PULLLOW),
	PMIC_ENTRY(PMIC_RG_AUDACCDETVIN1PULLLOW),
	PMIC_ENTRY(PMIC_RG_AUDACCDETVTHACAL),
	PMIC_ENTRY(PMIC_RG_AUDACCDETVTHBCAL),
	PMIC_ENTRY(PMIC_RG_AUDACCDETTVDET),
	PMIC_ENTRY(PMIC_RG_ACCDETSEL),
	PMIC_ENTRY(PMIC_RG_SWBUFMODSEL),
	PMIC_ENTRY(PMIC_RG_SWBUFSWEN),
	PMIC_ENTRY(PMIC_RG_EINTCOMPVTH),
	PMIC_ENTRY(PMIC_RG_EINTCONFIGACCDET),
	PMIC_ENTRY(PMIC_RG_EINTHIRENB),
	PMIC_ENTRY(PMIC_RG_ACCDET2AUXRESBYPASS),
	PMIC_ENTRY(PMIC_RG_ACCDET2AUXBUFFERBYPASS),
	PMIC_ENTRY(PMIC_RG_ACCDET2AUXSWEN),
	PMIC_ENTRY(PMIC_RGS_AUDRCTUNELREAD),
	PMIC_ENTRY(PMIC_RGS_AUDRCTUNERREAD),
	PMIC_ENTRY(PMIC_AUDDEC_ANA_ID),
	PMIC_ENTRY(PMIC_AUDDEC_DIG_ID),
	PMIC_ENTRY(PMIC_AUDDEC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDDEC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDDEC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDDEC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDDEC_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDDEC_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDDEC_DSN_ESP),
	PMIC_ENTRY(PMIC_AUDDEC_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_AUDDACLPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDDACRPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUD_DAC_PWR_UP_VA28),
	PMIC_ENTRY(PMIC_RG_AUD_DAC_PWL_UP_VA28),
	PMIC_ENTRY(PMIC_RG_AUDHPLPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPRPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPLPWRUP_IBIAS_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPRPWRUP_IBIAS_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPLSCDISABLE_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPRSCDISABLE_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPLBSCCURRENT_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPRBSCCURRENT_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPLOUTPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPROUTPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPLOUTAUXPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPROUTAUXPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPLAUXFBRSW_EN_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPRAUXFBRSW_EN_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPLSHORT2HPLAUX_EN_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPRSHORT2HPRAUX_EN_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPLOUTSTGCTRL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPROUTSTGCTRL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPLOUTPUTSTBENH_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPROUTPUTSTBENH_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPSTARTUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDREFN_DERES_EN_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPPSHORT2VCM_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPINPUTSTBENH_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPINPUTRESET0_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HPOUTPUTRESET0_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHSPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHSPWRUP_IBIAS_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHSSCDISABLE_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHSBSCCURRENT_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHSSTARTUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HSOUTPUTSTBENH_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HSINPUTSTBENH_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HSINPUTRESET0_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HSOUTPUTRESET0_VAUDP15),
	PMIC_ENTRY(PMIC_RG_HSOUT_SHORTVCM_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDLOLPWRUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDLOLPWRUP_IBIAS_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDLOLSCDISABLE_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDLOLBSCCURRENT_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDLOSTARTUP_VAUDP15),
	PMIC_ENTRY(PMIC_RG_LOINPUTSTBENH_VAUDP15),
	PMIC_ENTRY(PMIC_RG_LOOUTPUTSTBENH_VAUDP15),
	PMIC_ENTRY(PMIC_RG_LOINPUTRESET0_VAUDP15),
	PMIC_ENTRY(PMIC_RG_LOOUTPUTRESET0_VAUDP15),
	PMIC_ENTRY(PMIC_RG_LOOUT_SHORTVCM_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDTRIMBUF_EN_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPSPKDET_EN_VAUDP15),
	PMIC_ENTRY(PMIC_RG_ABIDEC_RSVD0_VA28),
	PMIC_ENTRY(PMIC_RG_ABIDEC_RSVD0_VAUDP15),
	PMIC_ENTRY(PMIC_RG_ABIDEC_RSVD1_VAUDP15),
	PMIC_ENTRY(PMIC_RG_ABIDEC_RSVD2_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDZCDMUXSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDZCDCLKSEL_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDBIASADJ_0_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDBIASADJ_1_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDIBIASPWRDN_VAUDP15),
	PMIC_ENTRY(PMIC_RG_RSTB_DECODER_VA28),
	PMIC_ENTRY(PMIC_RG_SEL_DECODER_96K_VA28),
	PMIC_ENTRY(PMIC_RG_SEL_DELAY_VCORE),
	PMIC_ENTRY(PMIC_RG_AUDGLB_PWRDN_VA28),
	PMIC_ENTRY(PMIC_RG_RSTB_ENCODER_VA28),
	PMIC_ENTRY(PMIC_RG_SEL_ENCODER_96K_VA28),
	PMIC_ENTRY(PMIC_RG_HCLDO_EN_VA18),
	PMIC_ENTRY(PMIC_RG_HCLDO_PDDIS_EN_VA18),
	PMIC_ENTRY(PMIC_RG_HCLDO_REMOTE_SENSE_VA18),
	PMIC_ENTRY(PMIC_RG_LCLDO_EN_VA18),
	PMIC_ENTRY(PMIC_RG_LCLDO_PDDIS_EN_VA18),
	PMIC_ENTRY(PMIC_RG_LCLDO_REMOTE_SENSE_VA18),
	PMIC_ENTRY(PMIC_RG_LCLDO_ENC_EN_VA28),
	PMIC_ENTRY(PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28),
	PMIC_ENTRY(PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28),
	PMIC_ENTRY(PMIC_RG_VA33REFGEN_EN_VA18),
	PMIC_ENTRY(PMIC_RG_VA28REFGEN_EN_VA28),
	PMIC_ENTRY(PMIC_RG_NVREG_EN_VAUDP15),
	PMIC_ENTRY(PMIC_RG_NVREG_PULL0V_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDPMU_RSD0_VA18),
	PMIC_ENTRY(PMIC_AUDDEC_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_AUDHPLTRIM_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPRTRIM_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPLFINETRIM_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPRFINETRIM_VAUDP15),
	PMIC_ENTRY(PMIC_RG_AUDHPTRIM_EN_VAUDP15),
	PMIC_ENTRY(PMIC_AUDZCD_ANA_ID),
	PMIC_ENTRY(PMIC_AUDZCD_DIG_ID),
	PMIC_ENTRY(PMIC_AUDZCD_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDZCD_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDZCD_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDZCD_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDZCD_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDZCD_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDZCD_DSN_ESP),
	PMIC_ENTRY(PMIC_AUDZCD_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_AUDZCDENABLE),
	PMIC_ENTRY(PMIC_RG_AUDZCDGAINSTEPTIME),
	PMIC_ENTRY(PMIC_RG_AUDZCDGAINSTEPSIZE),
	PMIC_ENTRY(PMIC_RG_AUDZCDTIMEOUTMODESEL),
	PMIC_ENTRY(PMIC_RG_AUDLOLGAIN),
	PMIC_ENTRY(PMIC_RG_AUDLORGAIN),
	PMIC_ENTRY(PMIC_RG_AUDHPLGAIN),
	PMIC_ENTRY(PMIC_RG_AUDHPRGAIN),
	PMIC_ENTRY(PMIC_RG_AUDHSGAIN),
	PMIC_ENTRY(PMIC_RG_AUDIVLGAIN),
	PMIC_ENTRY(PMIC_RG_AUDIVRGAIN),
	PMIC_ENTRY(PMIC_RG_AUDINTGAIN1),
	PMIC_ENTRY(PMIC_RG_AUDINTGAIN2),
	PMIC_ENTRY(PMIC_ACCDET_ANA_ID),
	PMIC_ENTRY(PMIC_ACCDET_DIG_ID),
	PMIC_ENTRY(PMIC_ACCDET_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_ACCDET_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_ACCDET_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_ACCDET_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_ACCDET_DSN_CBS),
	PMIC_ENTRY(PMIC_ACCDET_DSN_BIX),
	PMIC_ENTRY(PMIC_ACCDET_ESP),
	PMIC_ENTRY(PMIC_ACCDET_DSN_FPI),
	PMIC_ENTRY(PMIC_AUDACCDETAUXADCSWCTRL),
	PMIC_ENTRY(PMIC_AUDACCDETAUXADCSWCTRL_SEL),
	PMIC_ENTRY(PMIC_RG_AUDACCDETRSV),
	PMIC_ENTRY(PMIC_ACCDET_EN),
	PMIC_ENTRY(PMIC_ACCDET_SEQ_INIT),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_SEQ_INIT),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_SEQ_INIT),
	PMIC_ENTRY(PMIC_ACCDET_ANASWCTRL_SEL),
	PMIC_ENTRY(PMIC_ACCDET_CMP_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_VTH_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_MBIAS_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_CMP_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_VTH_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_MBIAS_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_PWM_WIDTH),
	PMIC_ENTRY(PMIC_ACCDET_PWM_THRESH),
	PMIC_ENTRY(PMIC_ACCDET_RISE_DELAY),
	PMIC_ENTRY(PMIC_ACCDET_FALL_DELAY),
	PMIC_ENTRY(PMIC_ACCDET_DEBOUNCE0),
	PMIC_ENTRY(PMIC_ACCDET_DEBOUNCE1),
	PMIC_ENTRY(PMIC_ACCDET_DEBOUNCE2),
	PMIC_ENTRY(PMIC_ACCDET_DEBOUNCE3),
	PMIC_ENTRY(PMIC_ACCDET_DEBOUNCE4),
	PMIC_ENTRY(PMIC_ACCDET_IVAL_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_IVAL_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_IVAL_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_IVAL_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_IVAL_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_IVAL_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_IVAL_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_IVAL_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_IVAL_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_IVAL_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_IVAL_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_IVAL_SEL),
	PMIC_ENTRY(PMIC_ACCDET_IRQ),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_IRQ),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_IRQ),
	PMIC_ENTRY(PMIC_ACCDET_IRQ_CLR),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_IRQ_CLR),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_IRQ_CLR),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_IRQ_POLARITY),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_IRQ_POLARITY),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MODE0),
	PMIC_ENTRY(PMIC_ACCDET_CMP_SWSEL),
	PMIC_ENTRY(PMIC_ACCDET_VTH_SWSEL),
	PMIC_ENTRY(PMIC_ACCDET_MBIAS_SWSEL),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MODE4),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MODE5),
	PMIC_ENTRY(PMIC_ACCDET_PWM_SEL),
	PMIC_ENTRY(PMIC_ACCDET_IN_SW),
	PMIC_ENTRY(PMIC_ACCDET_CMP_EN_SW),
	PMIC_ENTRY(PMIC_ACCDET_VTH_EN_SW),
	PMIC_ENTRY(PMIC_ACCDET_MBIAS_EN_SW),
	PMIC_ENTRY(PMIC_ACCDET_PWM_EN_SW),
	PMIC_ENTRY(PMIC_ACCDET_IN),
	PMIC_ENTRY(PMIC_ACCDET_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_STATE),
	PMIC_ENTRY(PMIC_ACCDET_MBIAS_CLK),
	PMIC_ENTRY(PMIC_ACCDET_VTH_CLK),
	PMIC_ENTRY(PMIC_ACCDET_CMP_CLK),
	PMIC_ENTRY(PMIC_DA_AUDACCDETAUXADCSWCTRL),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_DEB_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_DEBOUNCE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_PWM_THRESH),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_PWM_WIDTH),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_PWM_FALL_DELAY),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_PWM_RISE_DELAY),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MODE11),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MODE10),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CMPOUT_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CMPOUT_SW),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MODE9),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MODE8),
	PMIC_ENTRY(PMIC_ACCDET_AUXADC_CTRL_SW),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MODE7),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MODE6),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CMP_EN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CMP_EN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_STATE),
	PMIC_ENTRY(PMIC_ACCDET_AUXADC_DEBOUNCE_END),
	PMIC_ENTRY(PMIC_ACCDET_AUXADC_CONNECT_PRE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_MEM_IN),
	PMIC_ENTRY(PMIC_AD_EINT0CMPOUT),
	PMIC_ENTRY(PMIC_DA_NI_EINT0CMPEN),
	PMIC_ENTRY(PMIC_ACCDET_CUR_DEB),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CUR_DEB),
	PMIC_ENTRY(PMIC_ACCDET_MON_FLAG_EN),
	PMIC_ENTRY(PMIC_ACCDET_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_ACCDET_RSV_CON1),
	PMIC_ENTRY(PMIC_ACCDET_AUXADC_CONNECT_TIME),
	PMIC_ENTRY(PMIC_ACCDET_HWEN_SEL),
	PMIC_ENTRY(PMIC_ACCDET_HWMODE_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_DEB_OUT_DFF),
	PMIC_ENTRY(PMIC_ACCDET_FAST_DISCHARGE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_REVERSE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_REVERSE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_DEB_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_DEBOUNCE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_PWM_THRESH),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_PWM_WIDTH),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_PWM_FALL_DELAY),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_PWM_RISE_DELAY),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_STATE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_MEM_IN),
	PMIC_ENTRY(PMIC_AD_EINT1CMPOUT),
	PMIC_ENTRY(PMIC_DA_NI_EINT1CMPEN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CUR_DEB),
};
