/*
 * Copyright (C) 2018 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#include <linux/kernel.h>

#include <mach/upmu_sw.h>
#include <mach/upmu_hw.h>
#include <mt-plat/upmu_common.h>

#include "include/pmic.h"

const struct pmu_flag_table_entry_t pmu_flags_table[] = {
	PMIC_ENTRY(PMIC_TOP0_ANA_ID),
	PMIC_ENTRY(PMIC_TOP0_DIG_ID),
	PMIC_ENTRY(PMIC_TOP0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP0_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP0_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP0_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP0_DSN_FPI),
	PMIC_ENTRY(PMIC_HWCID),
	PMIC_ENTRY(PMIC_SWCID),
	PMIC_ENTRY(PMIC_STS_PWRKEY),
	PMIC_ENTRY(PMIC_STS_RTCA),
	PMIC_ENTRY(PMIC_STS_CHRIN),
	PMIC_ENTRY(PMIC_STS_SPAR),
	PMIC_ENTRY(PMIC_STS_RBOOT),
	PMIC_ENTRY(PMIC_STS_UVLO),
	PMIC_ENTRY(PMIC_STS_PGFAIL),
	PMIC_ENTRY(PMIC_STS_PSOC),
	PMIC_ENTRY(PMIC_STS_THRDN),
	PMIC_ENTRY(PMIC_STS_WRST),
	PMIC_ENTRY(PMIC_STS_CRST),
	PMIC_ENTRY(PMIC_STS_PKEYLP),
	PMIC_ENTRY(PMIC_STS_NORMOFF),
	PMIC_ENTRY(PMIC_STS_BWDT),
	PMIC_ENTRY(PMIC_STS_DDLO),
	PMIC_ENTRY(PMIC_STS_WDT),
	PMIC_ENTRY(PMIC_STS_PUPSRC),
	PMIC_ENTRY(PMIC_STS_KEYPWR),
	PMIC_ENTRY(PMIC_STS_PKSP),
	PMIC_ENTRY(PMIC_STS_OVLO),
	PMIC_ENTRY(PMIC_RG_POFFSTS_CLR),
	PMIC_ENTRY(PMIC_RG_PONSTS_CLR),
	PMIC_ENTRY(PMIC_VM18_PG_DEB),
	PMIC_ENTRY(PMIC_VIO18_PG_DEB),
	PMIC_ENTRY(PMIC_VUFS_PG_DEB),
	PMIC_ENTRY(PMIC_VBBCK_PG_DEB),
	PMIC_ENTRY(PMIC_VRFCK_1_PG_DEB),
	PMIC_ENTRY(PMIC_VS1_PG_DEB),
	PMIC_ENTRY(PMIC_VA12_PG_DEB),
	PMIC_ENTRY(PMIC_VA09_PG_DEB),
	PMIC_ENTRY(PMIC_VS2_PG_DEB),
	PMIC_ENTRY(PMIC_VMODEM_PG_DEB),
	PMIC_ENTRY(PMIC_VPU_PG_DEB),
	PMIC_ENTRY(PMIC_VGPU12_PG_DEB),
	PMIC_ENTRY(PMIC_VGPU11_PG_DEB),
	PMIC_ENTRY(PMIC_VCORE_PG_DEB),
	PMIC_ENTRY(PMIC_VAUX18_PG_DEB),
	PMIC_ENTRY(PMIC_VXO22_PG_DEB),
	PMIC_ENTRY(PMIC_VRF18_PG_DEB),
	PMIC_ENTRY(PMIC_VUSB_PG_DEB),
	PMIC_ENTRY(PMIC_VAUD18_PG_DEB),
	PMIC_ENTRY(PMIC_VSRAM_PROC1_PG_DEB),
	PMIC_ENTRY(PMIC_VPROC1_PG_DEB),
	PMIC_ENTRY(PMIC_VSRAM_PROC2_PG_DEB),
	PMIC_ENTRY(PMIC_VPROC2_PG_DEB),
	PMIC_ENTRY(PMIC_VSRAM_MD_PG_DEB),
	PMIC_ENTRY(PMIC_VSRAM_OTHERS_PG_DEB),
	PMIC_ENTRY(PMIC_VEMC_PG_DEB),
	PMIC_ENTRY(PMIC_EXT_PMIC_PG_DEB),
	PMIC_ENTRY(PMIC_STRUP_VM18_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO18_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VUFS_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VBBCK_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRFCK_1_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS1_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA12_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA09_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS2_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMODEM_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VPU_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VGPU12_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VGPU11_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VCORE_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VAUX18_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VXO22_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRF18_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VUSB_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VAUD18_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_PROC1_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VPROC1_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_PROC2_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VPROC2_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_MD_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_OTHERS_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VEMC_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_EXT_PMIC_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VM18_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO18_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VUFS_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VBBCK_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRFCK_1_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS1_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA12_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA09_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS2_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMODEM_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VPU_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VGPU12_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VGPU11_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VCORE_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VAUX18_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VXO22_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRF18_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VUSB_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VAUD18_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_PROC1_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VPROC1_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_PROC2_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VPROC2_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_MD_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_OTHERS_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VEMC_OC_STATUS),
	PMIC_ENTRY(PMIC_PMU_THERMAL_DEB),
	PMIC_ENTRY(PMIC_STRUP_THERMAL_STATUS),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_HW_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_HW_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN_SYNC_EN),
	PMIC_ENTRY(PMIC_RG_OSC_EN_AUTO_OFF),
	PMIC_ENTRY(PMIC_TEST_OUT),
	PMIC_ENTRY(PMIC_RG_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_NANDTREE_MODE),
	PMIC_ENTRY(PMIC_RG_TEST_AUXADC),
	PMIC_ENTRY(PMIC_RG_EFUSE_MODE),
	PMIC_ENTRY(PMIC_RG_TEST_STRUP),
	PMIC_ENTRY(PMIC_TESTMODE_SW),
	PMIC_ENTRY(PMIC_PMU_TEST_MODE_SCAN),
	PMIC_ENTRY(PMIC_PWRKEY_DEB),
	PMIC_ENTRY(PMIC_CHRDET_DEB),
	PMIC_ENTRY(PMIC_HOMEKEY_DEB),
	PMIC_ENTRY(PMIC_RG_PMU_TDSEL),
	PMIC_ENTRY(PMIC_RG_SPI_TDSEL),
	PMIC_ENTRY(PMIC_RG_AUD_TDSEL),
	PMIC_ENTRY(PMIC_RG_E32CAL_TDSEL),
	PMIC_ENTRY(PMIC_RG_PMU_RDSEL),
	PMIC_ENTRY(PMIC_RG_SPI_RDSEL),
	PMIC_ENTRY(PMIC_RG_AUD_RDSEL),
	PMIC_ENTRY(PMIC_RG_E32CAL_RDSEL),
	PMIC_ENTRY(PMIC_RG_SMT_WDTRSTB_IN),
	PMIC_ENTRY(PMIC_RG_SMT_SRCLKEN_IN0),
	PMIC_ENTRY(PMIC_RG_SMT_SRCLKEN_IN1),
	PMIC_ENTRY(PMIC_RG_SMT_RTC_32K1V8_0),
	PMIC_ENTRY(PMIC_RG_SMT_RTC_32K1V8_1),
	PMIC_ENTRY(PMIC_RG_SMT_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_SMT_SCP_VREQ_VAO),
	PMIC_ENTRY(PMIC_RG_SMT_SPI_CLK),
	PMIC_ENTRY(PMIC_RG_SMT_SPI_CSN),
	PMIC_ENTRY(PMIC_RG_SMT_SPI_MOSI),
	PMIC_ENTRY(PMIC_RG_SMT_SPI_MISO),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_CLK_MOSI),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MOSI0),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MOSI1),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MOSI2),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_SYNC_MOSI),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_NLE_MOSI0),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_NLE_MOSI1),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MISO0),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MISO1),
	PMIC_ENTRY(PMIC_RG_SMT_AUD_DAT_MISO2),
	PMIC_ENTRY(PMIC_RG_TOP_RSV0),
	PMIC_ENTRY(PMIC_RG_TOP_RSV1),
	PMIC_ENTRY(PMIC_RG_OCTL_SRCLKEN_IN0),
	PMIC_ENTRY(PMIC_RG_OCTL_SRCLKEN_IN1),
	PMIC_ENTRY(PMIC_RG_OCTL_RTC_32K1V8_0),
	PMIC_ENTRY(PMIC_RG_OCTL_RTC_32K1V8_1),
	PMIC_ENTRY(PMIC_RG_OCTL_SPI_CLK),
	PMIC_ENTRY(PMIC_RG_OCTL_SPI_CSN),
	PMIC_ENTRY(PMIC_RG_OCTL_SPI_MOSI),
	PMIC_ENTRY(PMIC_RG_OCTL_SPI_MISO),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_CLK_MOSI),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MOSI0),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MOSI1),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MOSI2),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_SYNC_MOSI),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_NLE_MOSI0),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_NLE_MOSI1),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MISO0),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MISO1),
	PMIC_ENTRY(PMIC_RG_OCTL_AUD_DAT_MISO2),
	PMIC_ENTRY(PMIC_RG_OCTL_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_OCTL_SCP_VREQ_VAO),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPI_CLK_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPI_CSN_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPI_MOSI_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPI_MISO_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_MOSI_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI2_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_SYNC_MOSI_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO2_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_IN_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_HOMEKEY_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SCP_VREQ_VAO_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_NLE_MOSI0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_AUD_NLE_MOSI1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_RCSEL),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_RCSEL),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_0_RCSEL),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_1_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPI_CLK_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPI_CSN_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPI_MOSI_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPI_MISO_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_MOSI_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI0_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI1_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MOSI2_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_SYNC_MOSI_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO0_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO1_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_DAT_MISO2_RCSEL),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_IN_RCSEL),
	PMIC_ENTRY(PMIC_RG_HOMEKEY_RCSEL),
	PMIC_ENTRY(PMIC_RG_SCP_VREQ_VAO_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_NLE_MOSI0_RCSEL),
	PMIC_ENTRY(PMIC_RG_AUD_NLE_MOSI1_RCSEL),
	PMIC_ENTRY(PMIC_TOP_STATUS),
	PMIC_ENTRY(PMIC_TOP_STATUS_SET),
	PMIC_ENTRY(PMIC_TOP_STATUS_CLR),
	PMIC_ENTRY(PMIC_VM_MODE),
	PMIC_ENTRY(PMIC_TOP1_ANA_ID),
	PMIC_ENTRY(PMIC_TOP1_DIG_ID),
	PMIC_ENTRY(PMIC_TOP1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP1_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP1_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP1_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP1_DSN_FPI),
	PMIC_ENTRY(PMIC_GPIO_DIR0),
	PMIC_ENTRY(PMIC_GPIO_DIR0_SET),
	PMIC_ENTRY(PMIC_GPIO_DIR0_CLR),
	PMIC_ENTRY(PMIC_GPIO_DIR1),
	PMIC_ENTRY(PMIC_GPIO_DIR1_SET),
	PMIC_ENTRY(PMIC_GPIO_DIR1_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLEN0),
	PMIC_ENTRY(PMIC_GPIO_PULLEN0_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLEN0_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLEN1),
	PMIC_ENTRY(PMIC_GPIO_PULLEN1_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLEN1_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL0),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL0_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL0_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL1),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL1_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL1_CLR),
	PMIC_ENTRY(PMIC_GPIO_DINV0),
	PMIC_ENTRY(PMIC_GPIO_DINV0_SET),
	PMIC_ENTRY(PMIC_GPIO_DINV0_CLR),
	PMIC_ENTRY(PMIC_GPIO_DINV1),
	PMIC_ENTRY(PMIC_GPIO_DINV1_SET),
	PMIC_ENTRY(PMIC_GPIO_DINV1_CLR),
	PMIC_ENTRY(PMIC_GPIO_DOUT0),
	PMIC_ENTRY(PMIC_GPIO_DOUT0_SET),
	PMIC_ENTRY(PMIC_GPIO_DOUT0_CLR),
	PMIC_ENTRY(PMIC_GPIO_DOUT1),
	PMIC_ENTRY(PMIC_GPIO_DOUT1_SET),
	PMIC_ENTRY(PMIC_GPIO_DOUT1_CLR),
	PMIC_ENTRY(PMIC_GPIO_PI0),
	PMIC_ENTRY(PMIC_GPIO_PI1),
	PMIC_ENTRY(PMIC_GPIO_POE0),
	PMIC_ENTRY(PMIC_GPIO_POE1),
	PMIC_ENTRY(PMIC_GPIO0_MODE),
	PMIC_ENTRY(PMIC_GPIO1_MODE),
	PMIC_ENTRY(PMIC_GPIO2_MODE),
	PMIC_ENTRY(PMIC_GPIO3_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE0_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE0_CLR),
	PMIC_ENTRY(PMIC_GPIO4_MODE),
	PMIC_ENTRY(PMIC_GPIO5_MODE),
	PMIC_ENTRY(PMIC_GPIO6_MODE),
	PMIC_ENTRY(PMIC_GPIO7_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE1_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE1_CLR),
	PMIC_ENTRY(PMIC_GPIO8_MODE),
	PMIC_ENTRY(PMIC_GPIO9_MODE),
	PMIC_ENTRY(PMIC_GPIO10_MODE),
	PMIC_ENTRY(PMIC_GPIO11_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE2_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE2_CLR),
	PMIC_ENTRY(PMIC_GPIO12_MODE),
	PMIC_ENTRY(PMIC_GPIO13_MODE),
	PMIC_ENTRY(PMIC_GPIO14_MODE),
	PMIC_ENTRY(PMIC_GPIO15_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE3_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE3_CLR),
	PMIC_ENTRY(PMIC_GPIO16_MODE),
	PMIC_ENTRY(PMIC_GPIO17_MODE),
	PMIC_ENTRY(PMIC_GPIO18_MODE),
	PMIC_ENTRY(PMIC_GPIO19_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE4_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE4_CLR),
	PMIC_ENTRY(PMIC_GPIO_RSV),
	PMIC_ENTRY(PMIC_TOP2_ANA_ID),
	PMIC_ENTRY(PMIC_TOP2_DIG_ID),
	PMIC_ENTRY(PMIC_TOP2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP2_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP2_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP2_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP2_DSN_FPI),
	PMIC_ENTRY(PMIC_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_SCK32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_EFUSE_CK_PDN),
	PMIC_ENTRY(PMIC_RG_CK_PDN_RSV0),
	PMIC_ENTRY(PMIC_RG_CK_PDN_RSV1),
	PMIC_ENTRY(PMIC_RG_SPI_CK_PDN),
	PMIC_ENTRY(PMIC_RG_CK_PDN_RSV2),
	PMIC_ENTRY(PMIC_RG_PMU32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FQMTR_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FQMTR_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PMU128K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC32K_CK_PDN),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_0_PDN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_1_PDN),
	PMIC_ENTRY(PMIC_RG_TRIM_128K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PCHR_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_FQMTR_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_RTC_32K1V8_SEL),
	PMIC_ENTRY(PMIC_RG_PMU32K_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_TOP_CKSEL_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_SRCVOLTEN_SW),
	PMIC_ENTRY(PMIC_RG_VOWEN_SW),
	PMIC_ENTRY(PMIC_RG_SRCVOLTEN_MODE),
	PMIC_ENTRY(PMIC_RG_VOWEN_MODE),
	PMIC_ENTRY(PMIC_RG_TOP_CKSEL_CON2_RSV),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_REG_CK_DIVSEL),
	PMIC_ENTRY(PMIC_TOP_CKDIVSEL_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_CKDIVSEL_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKDIVSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_EFUSE_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_EINT_32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_TOP_CKHWEN_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_CKHWEN_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKHWEN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_PMU128K_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_DCXO_1M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_DCXO_26M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_XO_CLK_26M_DIG_TST_DIS),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_RTC_32K_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_SCK_32K_CK_TST_DIS),
	PMIC_ENTRY(PMIC_TOP_CKTST_CON0_RSV),
	PMIC_ENTRY(PMIC_RG_PMU128K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_DCXO_1M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_DCXO_26M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_XO_CLK_26M_DIG_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_32K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_SCK_32K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_EFUSE_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_PCHR_TEST_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_FQMTR_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_TSTCK_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_BUCK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_BUCK_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_BM_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_BM_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_HK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_HK_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_LDO_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_LDO_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_SCK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_SCK_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_MDB_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_MDB_SW),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_BUCK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_BUCK_SW),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_LDO_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_LDO_SW),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_HK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_HK_SW),
	PMIC_ENTRY(PMIC_RG_TOP_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_TOP_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_SCK_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_SCK_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_LDO_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_MDB_DCXO26M_DCM_LP_EN),
	PMIC_ENTRY(PMIC_RG_EFUSE_MAN_RST),
	PMIC_ENTRY(PMIC_RG_DRIVER_RST),
	PMIC_ENTRY(PMIC_RG_FQMTR_RST),
	PMIC_ENTRY(PMIC_RG_RTC_RST),
	PMIC_ENTRY(PMIC_RG_TYPE_C_CC_RST),
	PMIC_ENTRY(PMIC_RG_CLK_TRIM_RST),
	PMIC_ENTRY(PMIC_RG_BUCK_SRCLKEN_RST),
	PMIC_ENTRY(PMIC_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_PROT_PMPP_RST),
	PMIC_ENTRY(PMIC_RG_SPK_RST),
	PMIC_ENTRY(PMIC_RG_FT_VR_SYSRSTB),
	PMIC_ENTRY(PMIC_RG_LDO_CALI_RST),
	PMIC_ENTRY(PMIC_TOP_RST_CON1_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_RST_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_CHR_LDO_DET_MODE),
	PMIC_ENTRY(PMIC_RG_CHR_LDO_DET_SW),
	PMIC_ENTRY(PMIC_RG_CHRWDT_FLAG_MODE),
	PMIC_ENTRY(PMIC_RG_CHRWDT_FLAG_SW),
	PMIC_ENTRY(PMIC_TOP_RST_CON2_RSV),
	PMIC_ENTRY(PMIC_RG_GPIO_RST_SEL),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_EN),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_MODE),
	PMIC_ENTRY(PMIC_WDTRSTB_STATUS),
	PMIC_ENTRY(PMIC_WDTRSTB_STATUS_CLR),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_FB_EN),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_DEB),
	PMIC_ENTRY(PMIC_RG_PWRKEY_KEY_MODE),
	PMIC_ENTRY(PMIC_RG_PWRKEY_RST_EN),
	PMIC_ENTRY(PMIC_RG_PWRRST_TMR_DIS),
	PMIC_ENTRY(PMIC_RG_PWRKEY_RST_TD),
	PMIC_ENTRY(PMIC_TOP_RST_MISC_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_MISC_SET),
	PMIC_ENTRY(PMIC_TOP_RST_MISC_CLR),
	PMIC_ENTRY(PMIC_VPWRIN_RSTB_STATUS),
	PMIC_ENTRY(PMIC_DDLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_UVLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_RTC_DDLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_CHRWDT_REG_RSTB_STATUS),
	PMIC_ENTRY(PMIC_CHRDET_REG_RSTB_STATUS),
	PMIC_ENTRY(PMIC_BWDT_DDLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_TOP_RST_STATUS_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_STATUS_SET),
	PMIC_ENTRY(PMIC_TOP_RST_STATUS_CLR),
	PMIC_ENTRY(PMIC_TOP2_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_TOP2_RSV0),
	PMIC_ENTRY(PMIC_RG_TOP2_RSV1),
	PMIC_ENTRY(PMIC_TOP3_ANA_ID),
	PMIC_ENTRY(PMIC_TOP3_DIG_ID),
	PMIC_ENTRY(PMIC_TOP3_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP3_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP3_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP3_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP3_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP3_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP3_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP3_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_INT_EN_SPI_CMD_ALERT),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_CON0_SET),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_SPI_CMD_ALERT),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_SPI_CMD_ALERT),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_SPI_CMD_ALERT),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BUCK_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_LDO_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PSC_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_SCK_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BM_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HK_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_XPP_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_AUD_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_MISC_TOP),
	PMIC_ENTRY(PMIC_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_INT_STATUS_BUCK_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_LDO_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_PSC_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_SCK_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_BM_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_HK_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_XPP_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_AUD_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_MISC_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_TOP_RSV),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_BUCK_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_LDO_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_PSC_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_SCK_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_BM_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_HK_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_XPP_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_AUD_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_MISC_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_TOP_RSV),
	PMIC_ENTRY(PMIC_RG_INT_POLARITY),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_SW),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_SW),
	PMIC_ENTRY(PMIC_PMRC_EN),
	PMIC_ENTRY(PMIC_PMRC_EN_SET),
	PMIC_ENTRY(PMIC_PMRC_EN_CLR),
	PMIC_ENTRY(PMIC_RG_VR_SPM_MODE),
	PMIC_ENTRY(PMIC_RG_VR_MD_MODE),
	PMIC_ENTRY(PMIC_RG_VR_SSHUB_MODE),
	PMIC_ENTRY(PMIC_PMRC_CON1_SET),
	PMIC_ENTRY(PMIC_PMRC_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_SRCLKEN2_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN3_MODE),
	PMIC_ENTRY(PMIC_PLT0_ANA_ID),
	PMIC_ENTRY(PMIC_PLT0_DIG_ID),
	PMIC_ENTRY(PMIC_PLT0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PLT0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PLT0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PLT0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PLT0_DSN_CBS),
	PMIC_ENTRY(PMIC_PLT0_DSN_BIX),
	PMIC_ENTRY(PMIC_PLT0_DSN_ESP),
	PMIC_ENTRY(PMIC_PLT0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_OSC_128K_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_OSC_128K_TRIM_RATE),
	PMIC_ENTRY(PMIC_DA_OSC_128K_TRIM),
	PMIC_ENTRY(PMIC_RG_OTP_PA),
	PMIC_ENTRY(PMIC_RG_OTP_PDIN),
	PMIC_ENTRY(PMIC_RG_OTP_PTM),
	PMIC_ENTRY(PMIC_RG_OTP_PWE),
	PMIC_ENTRY(PMIC_RG_OTP_PPROG),
	PMIC_ENTRY(PMIC_RG_OTP_PWE_SRC),
	PMIC_ENTRY(PMIC_RG_OTP_PROG_PKEY),
	PMIC_ENTRY(PMIC_RG_OTP_RD_PKEY),
	PMIC_ENTRY(PMIC_RG_OTP_RD_TRIG),
	PMIC_ENTRY(PMIC_RG_RD_RDY_BYPASS),
	PMIC_ENTRY(PMIC_RG_SKIP_OTP_OUT),
	PMIC_ENTRY(PMIC_RG_OTP_RD_SW),
	PMIC_ENTRY(PMIC_RG_OTP_DOUT_SW),
	PMIC_ENTRY(PMIC_RG_OTP_RD_BUSY),
	PMIC_ENTRY(PMIC_RG_OTP_RD_ACK),
	PMIC_ENTRY(PMIC_RG_OTP_PA_SW),
	PMIC_ENTRY(PMIC_TMA_KEY),
	PMIC_ENTRY(PMIC_TOP_MDB_RSV0),
	PMIC_ENTRY(PMIC_TOP_MDB_RSV1),
	PMIC_ENTRY(PMIC_RG_MDB_DM1_DS_EN),
	PMIC_ENTRY(PMIC_RG_AUTO_LOAD_FORCE),
	PMIC_ENTRY(PMIC_RG_OTP_WRITE_SEL),
	PMIC_ENTRY(PMIC_RG_TOP_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_SCK_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_MDB_BRDG_ACS_SUSPEND),
	PMIC_ENTRY(PMIC_RG_MDB_BRDG_ACS_DEEPIDLE),
	PMIC_ENTRY(PMIC_PLT0_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_OSC_128K_TRIM),
	PMIC_ENTRY(PMIC_SPISLV_ANA_ID),
	PMIC_ENTRY(PMIC_SPISLV_DIG_ID),
	PMIC_ENTRY(PMIC_SPISLV_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_SPISLV_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_SPISLV_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_SPISLV_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_SPISLV_DSN_CBS),
	PMIC_ENTRY(PMIC_SPISLV_DSN_BIX),
	PMIC_ENTRY(PMIC_SPISLV_DSN_ESP),
	PMIC_ENTRY(PMIC_SPISLV_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_SPI_MISO_MODE_SEL),
	PMIC_ENTRY(PMIC_RG_EN_RECORD),
	PMIC_ENTRY(PMIC_RG_RD_RECORD_EN),
	PMIC_ENTRY(PMIC_RG_SPI_RSV),
	PMIC_ENTRY(PMIC_DEW_DIO_EN),
	PMIC_ENTRY(PMIC_DEW_READ_TEST),
	PMIC_ENTRY(PMIC_DEW_WRITE_TEST),
	PMIC_ENTRY(PMIC_DEW_CRC_SWRST),
	PMIC_ENTRY(PMIC_DEW_CRC_EN),
	PMIC_ENTRY(PMIC_DEW_CRC_VAL),
	PMIC_ENTRY(PMIC_DEW_CIPHER_KEY_SEL),
	PMIC_ENTRY(PMIC_DEW_CIPHER_IV_SEL),
	PMIC_ENTRY(PMIC_DEW_CIPHER_EN),
	PMIC_ENTRY(PMIC_DEW_CIPHER_RDY),
	PMIC_ENTRY(PMIC_DEW_CIPHER_MODE),
	PMIC_ENTRY(PMIC_DEW_CIPHER_SWRST),
	PMIC_ENTRY(PMIC_DEW_RDDMY_NO),
	PMIC_ENTRY(PMIC_RG_SPI_DLY_SEL),
	PMIC_ENTRY(PMIC_RECORD_CMD0),
	PMIC_ENTRY(PMIC_RECORD_CMD1),
	PMIC_ENTRY(PMIC_RECORD_CMD2),
	PMIC_ENTRY(PMIC_RECORD_CMD3),
	PMIC_ENTRY(PMIC_RECORD_CMD4),
	PMIC_ENTRY(PMIC_RECORD_CMD5),
	PMIC_ENTRY(PMIC_RECORD_WDATA0),
	PMIC_ENTRY(PMIC_RECORD_WDATA1),
	PMIC_ENTRY(PMIC_RECORD_WDATA2),
	PMIC_ENTRY(PMIC_RECORD_WDATA3),
	PMIC_ENTRY(PMIC_RECORD_WDATA4),
	PMIC_ENTRY(PMIC_RECORD_WDATA5),
	PMIC_ENTRY(PMIC_RG_ADDR_TARGET),
	PMIC_ENTRY(PMIC_RG_ADDR_MASK),
	PMIC_ENTRY(PMIC_RG_WDATA_TARGET),
	PMIC_ENTRY(PMIC_RG_WDATA_MASK),
	PMIC_ENTRY(PMIC_RG_SPI_RECORD_CLR),
	PMIC_ENTRY(PMIC_RG_CMD_ALERT_CLR),
	PMIC_ENTRY(PMIC_SPISLV_KEY),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_SET),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_CLR),
	PMIC_ENTRY(PMIC_CPU_INT_STA),
	PMIC_ENTRY(PMIC_MD32_INT_STA),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN3_SMPS_CLK_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN2_SMPS_CLK_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN2_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN3_EN),
	PMIC_ENTRY(PMIC_SCK_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_SCK_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_SCK_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_CBS),
	PMIC_ENTRY(PMIC_SCK_TOP_BIX),
	PMIC_ENTRY(PMIC_SCK_TOP_ESP),
	PMIC_ENTRY(PMIC_SCK_TOP_FPI),
	PMIC_ENTRY(PMIC_SCK_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_SCK_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_SCK_TOP_XTAL_SEL),
	PMIC_ENTRY(PMIC_SCK_TOP_RESERVED),
	PMIC_ENTRY(PMIC_XOSC32_ENB_DET),
	PMIC_ENTRY(PMIC_SCK_TOP_TEST_OUT),
	PMIC_ENTRY(PMIC_SCK_TOP_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_SCK_TOP_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_MCLK_PDN),
	PMIC_ENTRY(PMIC_RG_EOSC_CALI_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_EOSC32_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_MCLK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_2SEC_OFF_DET_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_SCK_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_MCLK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_MCLK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_INTRP_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_1),
	PMIC_ENTRY(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_0),
	PMIC_ENTRY(PMIC_SCK_TOP_CKHWEN_CON_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_CKHWEN_CON_CLR),
	PMIC_ENTRY(PMIC_RG_RTC_CK_TSTSEL_RSV),
	PMIC_ENTRY(PMIC_RG_RTCDET_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_EOSC32_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_SWRST),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_RTC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_RTC_SEC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_EOSC_CALI_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_SCK_TOP_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_FQMTR_RST),
	PMIC_ENTRY(PMIC_SCK_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_RTC),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_RTC),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_RTC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_RTC),
	PMIC_ENTRY(PMIC_SCK_TOP_POLARITY),
	PMIC_ENTRY(PMIC_EOSC_CALI_START),
	PMIC_ENTRY(PMIC_EOSC_CALI_TD),
	PMIC_ENTRY(PMIC_EOSC_CALI_TEST),
	PMIC_ENTRY(PMIC_EOSC_CALI_DCXO_RDY_TD),
	PMIC_ENTRY(PMIC_FRC_VTCXO0_ON),
	PMIC_ENTRY(PMIC_EOSC_CALI_RSV),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_LPDTB),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_LPDEN),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_PWDB),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_LPDTB),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_LPDEN),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_LPDRST),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_CALI),
	PMIC_ENTRY(PMIC_STMP_MODE),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_CHOP_EN),
	PMIC_ENTRY(PMIC_MIX_DCXO_STP_LVSH_EN),
	PMIC_ENTRY(PMIC_MIX_PMU_STP_DDLO_VRTC),
	PMIC_ENTRY(PMIC_MIX_PMU_STP_DDLO_VRTC_EN),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_XOSC32_ENB),
	PMIC_ENTRY(PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_RSV),
	PMIC_ENTRY(PMIC_MIX_EOSC32_VCT_EN),
	PMIC_ENTRY(PMIC_MIX_EOSC32_OPT),
	PMIC_ENTRY(PMIC_MIX_DCXO_STP_LVSH_EN_INT),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_COREDETB),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_F32KOB),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_GPO),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_OE),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_DEBUG_OUT),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_DEBUG_SEL),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_K_EOSC32_EN),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_EMBCK_SEL),
	PMIC_ENTRY(PMIC_MIX_STP_BBWAKEUP),
	PMIC_ENTRY(PMIC_MIX_STP_RTC_DDLO),
	PMIC_ENTRY(PMIC_MIX_RTC_XOSC32_ENB),
	PMIC_ENTRY(PMIC_MIX_EFUSE_XOSC32_ENB_OPT),
	PMIC_ENTRY(PMIC_RG_RTC_TEST_OUT),
	PMIC_ENTRY(PMIC_RG_RTC_DIG_TEST_IN),
	PMIC_ENTRY(PMIC_RG_RTC_DIG_TEST_MODE),
	PMIC_ENTRY(PMIC_FQMTR_TCKSEL),
	PMIC_ENTRY(PMIC_FQMTR_BUSY),
	PMIC_ENTRY(PMIC_FQMTR_DCXO26M_EN),
	PMIC_ENTRY(PMIC_FQMTR_EN),
	PMIC_ENTRY(PMIC_FQMTR_WINSET),
	PMIC_ENTRY(PMIC_FQMTR_DATA),
	PMIC_ENTRY(PMIC_XO_SOC_VOTE),
	PMIC_ENTRY(PMIC_XO_WCN_VOTE),
	PMIC_ENTRY(PMIC_XO_NFC_VOTE),
	PMIC_ENTRY(PMIC_XO_CEL_VOTE),
	PMIC_ENTRY(PMIC_XO_EXT_VOTE),
	PMIC_ENTRY(PMIC_XO_MODE_CONN_BT_MASK),
	PMIC_ENTRY(PMIC_XO_BUF_CONN_BT_MASK),
	PMIC_ENTRY(PMIC_RTC_ANA_ID),
	PMIC_ENTRY(PMIC_RTC_DIG_ID),
	PMIC_ENTRY(PMIC_RTC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_DSN_CBS),
	PMIC_ENTRY(PMIC_RTC_DSN_BIX),
	PMIC_ENTRY(PMIC_RTC_DSN_ESP),
	PMIC_ENTRY(PMIC_RTC_DSN_FPI),
	PMIC_ENTRY(PMIC_BBPU),
	PMIC_ENTRY(PMIC_CLRPKY),
	PMIC_ENTRY(PMIC_RELOAD),
	PMIC_ENTRY(PMIC_CBUSY),
	PMIC_ENTRY(PMIC_ALARM_STATUS),
	PMIC_ENTRY(PMIC_KEY_BBPU),
	PMIC_ENTRY(PMIC_ALSTA),
	PMIC_ENTRY(PMIC_TCSTA),
	PMIC_ENTRY(PMIC_LPSTA),
	PMIC_ENTRY(PMIC_AL_EN),
	PMIC_ENTRY(PMIC_TC_EN),
	PMIC_ENTRY(PMIC_ONESHOT),
	PMIC_ENTRY(PMIC_LP_EN),
	PMIC_ENTRY(PMIC_SECCII),
	PMIC_ENTRY(PMIC_MINCII),
	PMIC_ENTRY(PMIC_HOUCII),
	PMIC_ENTRY(PMIC_DOMCII),
	PMIC_ENTRY(PMIC_DOWCII),
	PMIC_ENTRY(PMIC_MTHCII),
	PMIC_ENTRY(PMIC_YEACII),
	PMIC_ENTRY(PMIC_SECCII_1_2),
	PMIC_ENTRY(PMIC_SECCII_1_4),
	PMIC_ENTRY(PMIC_SECCII_1_8),
	PMIC_ENTRY(PMIC_SEC_MSK),
	PMIC_ENTRY(PMIC_MIN_MSK),
	PMIC_ENTRY(PMIC_HOU_MSK),
	PMIC_ENTRY(PMIC_DOM_MSK),
	PMIC_ENTRY(PMIC_DOW_MSK),
	PMIC_ENTRY(PMIC_MTH_MSK),
	PMIC_ENTRY(PMIC_YEA_MSK),
	PMIC_ENTRY(PMIC_TC_SECOND),
	PMIC_ENTRY(PMIC_TC_MINUTE),
	PMIC_ENTRY(PMIC_TC_HOUR),
	PMIC_ENTRY(PMIC_TC_DOM),
	PMIC_ENTRY(PMIC_TC_DOW),
	PMIC_ENTRY(PMIC_TC_MONTH),
	PMIC_ENTRY(PMIC_RTC_MACRO_ID),
	PMIC_ENTRY(PMIC_TC_YEAR),
	PMIC_ENTRY(PMIC_AL_SECOND),
	PMIC_ENTRY(PMIC_BBPU_AUTO_PDN_SEL),
	PMIC_ENTRY(PMIC_BBPU_2SEC_CK_SEL),
	PMIC_ENTRY(PMIC_BBPU_2SEC_EN),
	PMIC_ENTRY(PMIC_BBPU_2SEC_MODE),
	PMIC_ENTRY(PMIC_BBPU_2SEC_STAT_CLEAR),
	PMIC_ENTRY(PMIC_BBPU_2SEC_STAT_STA),
	PMIC_ENTRY(PMIC_RTC_LPD_OPT),
	PMIC_ENTRY(PMIC_K_EOSC32_VTCXO_ON_SEL),
	PMIC_ENTRY(PMIC_AL_MINUTE),
	PMIC_ENTRY(PMIC_AL_HOUR),
	PMIC_ENTRY(PMIC_NEW_SPARE0),
	PMIC_ENTRY(PMIC_AL_DOM),
	PMIC_ENTRY(PMIC_NEW_SPARE1),
	PMIC_ENTRY(PMIC_AL_DOW),
	PMIC_ENTRY(PMIC_RG_EOSC_CALI_TD),
	PMIC_ENTRY(PMIC_NEW_SPARE2),
	PMIC_ENTRY(PMIC_AL_MONTH),
	PMIC_ENTRY(PMIC_NEW_SPARE3),
	PMIC_ENTRY(PMIC_AL_YEAR),
	PMIC_ENTRY(PMIC_RTC_K_EOSC_RSV),
	PMIC_ENTRY(PMIC_XOSCCALI),
	PMIC_ENTRY(PMIC_RTC_XOSC32_ENB),
	PMIC_ENTRY(PMIC_RTC_EMBCK_SEL_MODE),
	PMIC_ENTRY(PMIC_RTC_EMBCK_SRC_SEL),
	PMIC_ENTRY(PMIC_RTC_EMBCK_SEL_OPTION),
	PMIC_ENTRY(PMIC_RTC_GPS_CKOUT_EN),
	PMIC_ENTRY(PMIC_RTC_EOSC32_VCT_EN),
	PMIC_ENTRY(PMIC_RTC_EOSC32_CHOP_EN),
	PMIC_ENTRY(PMIC_RTC_GP_OSC32_CON),
	PMIC_ENTRY(PMIC_RTC_REG_XOSC32_ENB),
	PMIC_ENTRY(PMIC_RTC_POWERKEY1),
	PMIC_ENTRY(PMIC_RTC_POWERKEY2),
	PMIC_ENTRY(PMIC_RTC_PDN1),
	PMIC_ENTRY(PMIC_RTC_PDN2),
	PMIC_ENTRY(PMIC_RTC_SPAR0),
	PMIC_ENTRY(PMIC_RTC_SPAR1),
	PMIC_ENTRY(PMIC_RTC_PROT),
	PMIC_ENTRY(PMIC_RTC_DIFF),
	PMIC_ENTRY(PMIC_POWER_DETECTED),
	PMIC_ENTRY(PMIC_K_EOSC32_RSV),
	PMIC_ENTRY(PMIC_CALI_RD_SEL),
	PMIC_ENTRY(PMIC_RTC_CALI),
	PMIC_ENTRY(PMIC_CALI_WR_SEL),
	PMIC_ENTRY(PMIC_K_EOSC32_OVERFLOW),
	PMIC_ENTRY(PMIC_WRTGR),
	PMIC_ENTRY(PMIC_VBAT_LPSTA_RAW),
	PMIC_ENTRY(PMIC_EOSC32_LPEN),
	PMIC_ENTRY(PMIC_XOSC32_LPEN),
	PMIC_ENTRY(PMIC_LPRST),
	PMIC_ENTRY(PMIC_CDBO),
	PMIC_ENTRY(PMIC_F32KOB),
	PMIC_ENTRY(PMIC_GPO),
	PMIC_ENTRY(PMIC_GOE),
	PMIC_ENTRY(PMIC_GSR),
	PMIC_ENTRY(PMIC_GSMT),
	PMIC_ENTRY(PMIC_GPEN),
	PMIC_ENTRY(PMIC_GPU),
	PMIC_ENTRY(PMIC_GE4),
	PMIC_ENTRY(PMIC_GE8),
	PMIC_ENTRY(PMIC_GPI),
	PMIC_ENTRY(PMIC_LPSTA_RAW),
	PMIC_ENTRY(PMIC_DAT0_LOCK),
	PMIC_ENTRY(PMIC_DAT1_LOCK),
	PMIC_ENTRY(PMIC_DAT2_LOCK),
	PMIC_ENTRY(PMIC_RTC_INT_CNT),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT0),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT1),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT2),
	PMIC_ENTRY(PMIC_RTC_SEC_ANA_ID),
	PMIC_ENTRY(PMIC_RTC_SEC_DIG_ID),
	PMIC_ENTRY(PMIC_RTC_SEC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_DSN_CBS),
	PMIC_ENTRY(PMIC_RTC_SEC_DSN_BIX),
	PMIC_ENTRY(PMIC_RTC_SEC_DSN_ESP),
	PMIC_ENTRY(PMIC_RTC_SEC_DSN_FPI),
	PMIC_ENTRY(PMIC_TC_SECOND_SEC),
	PMIC_ENTRY(PMIC_TC_MINUTE_SEC),
	PMIC_ENTRY(PMIC_TC_HOUR_SEC),
	PMIC_ENTRY(PMIC_TC_DOM_SEC),
	PMIC_ENTRY(PMIC_TC_DOW_SEC),
	PMIC_ENTRY(PMIC_TC_MONTH_SEC),
	PMIC_ENTRY(PMIC_TC_YEAR_SEC),
	PMIC_ENTRY(PMIC_RTC_SEC_CK_PDN),
	PMIC_ENTRY(PMIC_RTC_SEC_WRTGR),
	PMIC_ENTRY(PMIC_DCXO_ANA_ID),
	PMIC_ENTRY(PMIC_DCXO_DIG_ID),
	PMIC_ENTRY(PMIC_DCXO_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_DCXO_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_DCXO_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_DCXO_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_DCXO_DSN_CBS),
	PMIC_ENTRY(PMIC_DCXO_DSN_BIX),
	PMIC_ENTRY(PMIC_DCXO_DSN_ESP),
	PMIC_ENTRY(PMIC_DCXO_DSN_FPI),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_EN_M),
	PMIC_ENTRY(PMIC_XO_BB_LPM_EN_M),
	PMIC_ENTRY(PMIC_XO_ENBB_MAN),
	PMIC_ENTRY(PMIC_XO_ENBB_EN_M),
	PMIC_ENTRY(PMIC_XO_CLKSEL_MAN),
	PMIC_ENTRY(PMIC_DCXO_CW00_SET),
	PMIC_ENTRY(PMIC_DCXO_CW00_CLR),
	PMIC_ENTRY(PMIC_XO_CLKSEL_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_HV_PBUF_MAN),
	PMIC_ENTRY(PMIC_XO_HV_PBUF_EN_SYNC_M),
	PMIC_ENTRY(PMIC_XO_HV_PBUFBIAS_EN_M),
	PMIC_ENTRY(PMIC_XO_LV_PBUF_MAN),
	PMIC_ENTRY(PMIC_XO_LV_PBUFBIAS_EN_M),
	PMIC_ENTRY(PMIC_XO_LV_PBUF_EN_M),
	PMIC_ENTRY(PMIC_XO_BBLPM_CKSEL_M),
	PMIC_ENTRY(PMIC_XO_EN32K_MAN),
	PMIC_ENTRY(PMIC_XO_EN32K_M),
	PMIC_ENTRY(PMIC_RG_XO_CBANK_POL),
	PMIC_ENTRY(PMIC_XO_XMODE_M),
	PMIC_ENTRY(PMIC_XO_STRUP_MODE),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_CCOMP),
	PMIC_ENTRY(PMIC_RG_XO_VTEST_SEL_MUX),
	PMIC_ENTRY(PMIC_XO_SWRST),
	PMIC_ENTRY(PMIC_XO_CBANK_SYNC_DYN),
	PMIC_ENTRY(PMIC_XO_PCTAT_EN_MAN),
	PMIC_ENTRY(PMIC_XO_PCTAT_EN_M),
	PMIC_ENTRY(PMIC_XO_PMU_CKEN_M),
	PMIC_ENTRY(PMIC_XO_PMU_CKEN_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_CKG_EN_M),
	PMIC_ENTRY(PMIC_RG_XO_CORE_LPM_ISEL),
	PMIC_ENTRY(PMIC_XO_FPM_ISEL_M),
	PMIC_ENTRY(PMIC_XO_CDAC_FPM),
	PMIC_ENTRY(PMIC_XO_CDAC_LPM),
	PMIC_ENTRY(PMIC_XO_32KDIV_NFRAC_FPM),
	PMIC_ENTRY(PMIC_XO_COFST_FPM),
	PMIC_ENTRY(PMIC_XO_32KDIV_NFRAC_LPM),
	PMIC_ENTRY(PMIC_XO_COFST_LPM),
	PMIC_ENTRY(PMIC_XO_CORE_MAN),
	PMIC_ENTRY(PMIC_XO_CORE_EN_M),
	PMIC_ENTRY(PMIC_XO_CORE_TURBO_EN_SYNC_M),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_IS_EN),
	PMIC_ENTRY(PMIC_XO_STARTUP_EN_M),
	PMIC_ENTRY(PMIC_RG_XO_CMP_GSEL),
	PMIC_ENTRY(PMIC_XO_CORE_VBSEL_SYNC_M),
	PMIC_ENTRY(PMIC_XO_CORE_FPMBIAS_EN_M),
	PMIC_ENTRY(PMIC_XO_CORE_LPMCF_SYNC_FPM),
	PMIC_ENTRY(PMIC_XO_CORE_LPMCF_SYNC_LPM),
	PMIC_ENTRY(PMIC_RG_XO_CORE_LPM_ISEL_MAN),
	PMIC_ENTRY(PMIC_RG_XO_CORE_LPM_IDAC),
	PMIC_ENTRY(PMIC_XO_AAC_CMP_MAN),
	PMIC_ENTRY(PMIC_XO_AAC_EN_M),
	PMIC_ENTRY(PMIC_XO_PMIC_TOP_DIG_SW),
	PMIC_ENTRY(PMIC_XO_CMP_EN_M),
	PMIC_ENTRY(PMIC_XO_AAC_VSEL_M),
	PMIC_ENTRY(PMIC_RG_XO_AAC_X1EN),
	PMIC_ENTRY(PMIC_RG_XO_LVBUF_CKSEL),
	PMIC_ENTRY(PMIC_RG_XO_RFCK_EXTBUF_LP),
	PMIC_ENTRY(PMIC_RG_XO_BBCK_EXTBUF_LP),
	PMIC_ENTRY(PMIC_XO_AAC_FPM_TIME),
	PMIC_ENTRY(PMIC_XO_AAC_ISEL_MAN),
	PMIC_ENTRY(PMIC_XO_AAC_FPM_SWEN),
	PMIC_ENTRY(PMIC_XO_32KDIV_SWRST),
	PMIC_ENTRY(PMIC_XO_32KDIV_RATIO_MAN),
	PMIC_ENTRY(PMIC_XO_32KDIV_TEST_EN),
	PMIC_ENTRY(PMIC_XO_CTL_SYNC_BUF_MAN),
	PMIC_ENTRY(PMIC_XO_CTL_SYNC_BUF_EN_M),
	PMIC_ENTRY(PMIC_RG_XO_HV_PBUF_VSET),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_EN_M),
	PMIC_ENTRY(PMIC_DCXO_CW09_SET),
	PMIC_ENTRY(PMIC_DCXO_CW09_CLR),
	PMIC_ENTRY(PMIC_XO_MDB_TBO_EN_SEL),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_CLKSEL_MAN),
	PMIC_ENTRY(PMIC_XO_VIO18PG_BUFEN),
	PMIC_ENTRY(PMIC_XO_CAL_EN_MAN),
	PMIC_ENTRY(PMIC_XO_CAL_EN_M),
	PMIC_ENTRY(PMIC_RG_XO_CORE_OSCTD),
	PMIC_ENTRY(PMIC_XO_THADC_EN),
	PMIC_ENTRY(PMIC_RG_XO_SYNC_CKPOL),
	PMIC_ENTRY(PMIC_RG_XO_CORE_FPM_IDAC),
	PMIC_ENTRY(PMIC_RG_XO_CTL_POL),
	PMIC_ENTRY(PMIC_RG_XO_CTL_SYNC_BYP),
	PMIC_ENTRY(PMIC_RG_XO_VXO22PG_MAN),
	PMIC_ENTRY(PMIC_RG_XO_HV_PBUF_BYP),
	PMIC_ENTRY(PMIC_RG_XO_HV_PBUF_ENCL),
	PMIC_ENTRY(PMIC_RG_XO_CORE_VGBIAS_VSET),
	PMIC_ENTRY(PMIC_XO_CORE_TURBO_EN_SYNC_MAN),
	PMIC_ENTRY(PMIC_RG_XO_HV_PBUF_ISET),
	PMIC_ENTRY(PMIC_RG_XO_HEATER_SEL),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED6),
	PMIC_ENTRY(PMIC_RG_XO_VOW_EN),
	PMIC_ENTRY(PMIC_RG_XO_LV_PBUF_ISET),
	PMIC_ENTRY(PMIC_RG_XO_LV_PBUF_FPMISET),
	PMIC_ENTRY(PMIC_XO_BB_LPM_EN_SEL),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_RG_XO_DIG26M_DIV4_32KDIV),
	PMIC_ENTRY(PMIC_RG_XO_BBLPM_FREQ_FPM),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF2_INV),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF3_INV),
	PMIC_ENTRY(PMIC_XO_THADC_EN_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_CLKSEL_MAN),
	PMIC_ENTRY(PMIC_RG_XO_AUDIO_EN),
	PMIC_ENTRY(PMIC_RG_XO_AUDIO_ATTEN),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF2_SRSEL),
	PMIC_ENTRY(PMIC_RG_XO_DIG26M_DEGLITCH),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF4_SRSEL),
	PMIC_ENTRY(PMIC_RG_XO_DIG26M_DIV2_SW_MAN),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF1_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF3_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF6_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF7_HD),
	PMIC_ENTRY(PMIC_XO_STA_CTL_MAN),
	PMIC_ENTRY(PMIC_XO_STA_CTL_M),
	PMIC_ENTRY(PMIC_XO_VBBCK_EN_MAN),
	PMIC_ENTRY(PMIC_XO_VBBCK_EN_M),
	PMIC_ENTRY(PMIC_XO_VRFCK_EN_MAN),
	PMIC_ENTRY(PMIC_XO_VRFCK_EN_M),
	PMIC_ENTRY(PMIC_XO_RESERVED2),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED1),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED2),
	PMIC_ENTRY(PMIC_XO_STATIC_AUXOUT_SEL),
	PMIC_ENTRY(PMIC_XO_AUXOUT_SEL),
	PMIC_ENTRY(PMIC_XO_STATIC_AUXOUT),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_BG_EN),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_RPTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_IPTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_RCTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_ICTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_CBANK_SYNC_BYP),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_VCTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_VTEMP),
	PMIC_ENTRY(PMIC_RG_XO_CORE_LPM_PMICBIAS),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF1_RSEL),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF2_RSEL),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF3_RSEL),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF4_RSEL),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF7_RSEL),
	PMIC_ENTRY(PMIC_DCXO_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_XO_DIG26M_DIV2),
	PMIC_ENTRY(PMIC_XO_PWRKEY_RSTB_SEL),
	PMIC_ENTRY(PMIC_XO_ELR_RESERVED),
	PMIC_ENTRY(PMIC_PSC_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_PSC_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_PSC_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_CBS),
	PMIC_ENTRY(PMIC_PSC_TOP_BIX),
	PMIC_ENTRY(PMIC_PSC_TOP_ESP),
	PMIC_ENTRY(PMIC_PSC_TOP_FPI),
	PMIC_ENTRY(PMIC_PSC_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_PSC_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_PSC_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_PSC_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_CHRDET_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_RST),
	PMIC_ENTRY(PMIC_RG_PSEQ_PWRMSK_RST_SEL),
	PMIC_ENTRY(PMIC_BANK_STRUP_SWRST),
	PMIC_ENTRY(PMIC_BANK_PSEQ_SWRST),
	PMIC_ENTRY(PMIC_BANK_CHRDET_SWRST),
	PMIC_ENTRY(PMIC_RG_CHRDET_RST),
	PMIC_ENTRY(PMIC_RG_INT_EN_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_EN_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_EN_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_EN_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_EN_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_EN_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_PSC_INT_CON0_SET),
	PMIC_ENTRY(PMIC_PSC_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_MASK_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_MASK_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_PSC_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_PSC_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_PSC_INT_POLARITY),
	PMIC_ENTRY(PMIC_RG_HOMEKEY_INT_SEL),
	PMIC_ENTRY(PMIC_RG_PWRKEY_INT_SEL),
	PMIC_ENTRY(PMIC_INT_MISC_CON_SET),
	PMIC_ENTRY(PMIC_INT_MISC_CON_CLR),
	PMIC_ENTRY(PMIC_RG_PSC_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_STRUP_ANA_ID),
	PMIC_ENTRY(PMIC_STRUP_DIG_ID),
	PMIC_ENTRY(PMIC_STRUP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_STRUP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_STRUP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_STRUP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_STRUP_CBS),
	PMIC_ENTRY(PMIC_STRUP_BIX),
	PMIC_ENTRY(PMIC_STRUP_DSN_ESP),
	PMIC_ENTRY(PMIC_STRUP_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_TM_OUT),
	PMIC_ENTRY(PMIC_RG_THRDET_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_THR_SEL),
	PMIC_ENTRY(PMIC_RG_THR_TMODE),
	PMIC_ENTRY(PMIC_RG_VREF_BG),
	PMIC_ENTRY(PMIC_RGS_ANA_CHIP_ID),
	PMIC_ENTRY(PMIC_RG_PMU_RSV),
	PMIC_ENTRY(PMIC_RG_RST_DRVSEL),
	PMIC_ENTRY(PMIC_RG_EN1_DRVSEL),
	PMIC_ENTRY(PMIC_RG_EN2_DRVSEL),
	PMIC_ENTRY(PMIC_RGS_VUSB_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VAUX18_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VAUD18_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VXO22_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VEMC_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VIO18_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VUFS_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VSRAM_MD_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VSRAM_OTHERS_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VSRAM_PROC1_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VSRAM_PROC2_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VA12_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VA09_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VM18_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VRFCK_1_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VRFCK_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VBBCK_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VRF18_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VS1_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMODEM_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VPROC1_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VPROC2_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VCORE_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VPU_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VGPU11_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VGPU12_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VS2_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_STRUP_IREF_TRIM),
	PMIC_ENTRY(PMIC_RG_THR_LOC_SEL),
	PMIC_ENTRY(PMIC_PSEQ_ANA_ID),
	PMIC_ENTRY(PMIC_PSEQ_DIG_ID),
	PMIC_ENTRY(PMIC_PSEQ_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_CBS),
	PMIC_ENTRY(PMIC_PSEQ_BIX),
	PMIC_ENTRY(PMIC_PSEQ_ESP),
	PMIC_ENTRY(PMIC_PSEQ_FPI),
	PMIC_ENTRY(PMIC_RG_PWRHOLD),
	PMIC_ENTRY(PMIC_RG_USBDL_MODE),
	PMIC_ENTRY(PMIC_RG_WDTRST_ACT),
	PMIC_ENTRY(PMIC_RG_CRST),
	PMIC_ENTRY(PMIC_RG_WRST),
	PMIC_ENTRY(PMIC_RG_CRST_INTV),
	PMIC_ENTRY(PMIC_RG_WRST_INTV),
	PMIC_ENTRY(PMIC_RG_WDTRST_EN),
	PMIC_ENTRY(PMIC_RG_KEYPWR_VCORE_OPT),
	PMIC_ENTRY(PMIC_RG_RSV_SWREG),
	PMIC_ENTRY(PMIC_RG_STRUP_THR_CLR),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_TD),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKEY_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_SPAR_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_RTCA_CTRL),
	PMIC_ENTRY(PMIC_RG_SMART_RST_SDN_EN),
	PMIC_ENTRY(PMIC_RG_SMART_RST_MODE),
	PMIC_ENTRY(PMIC_RG_UVLO_DEC_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRKEY_COUNT_RESET),
	PMIC_ENTRY(PMIC_PUP_PKEY_RELEASE),
	PMIC_ENTRY(PMIC_PWRKEY_LONG_PRESS_COUNT),
	PMIC_ENTRY(PMIC_RG_POR_FLAG),
	PMIC_ENTRY(PMIC_USBDL),
	PMIC_ENTRY(PMIC_JUST_SMART_RST),
	PMIC_ENTRY(PMIC_JUST_PWRKEY_RST),
	PMIC_ENTRY(PMIC_RG_CLR_JUST_SMART_RST),
	PMIC_ENTRY(PMIC_CLR_JUST_RST),
	PMIC_ENTRY(PMIC_RG_STRUP_THER_DEB_RTD),
	PMIC_ENTRY(PMIC_RG_STRUP_THER_DEB_FTD),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_SEL),
	PMIC_ENTRY(PMIC_RGS_EXT_PMIC_PG),
	PMIC_ENTRY(PMIC_DA_EXT_PMIC_EN1),
	PMIC_ENTRY(PMIC_DA_EXT_PMIC_EN2),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_PG_DEBTD),
	PMIC_ENTRY(PMIC_RG_RTC_SPAR_DEB_EN),
	PMIC_ENTRY(PMIC_RG_RTC_ALARM_DEB_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VM18_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VUFS_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VBBCK_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VRFCK_1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VS1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VA12_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VA09_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VS2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VMODEM_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VPU_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VGPU12_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VGPU11_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VCORE_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUX18_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VRF18_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VUSB_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUD18_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VPROC1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VPROC2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_MD_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_OTHERS_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VEMC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VM18_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VUFS_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VBBCK_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VRFCK_1_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS1_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VA12_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VA09_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS2_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMODEM_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VPU_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VGPU12_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VGPU11_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VCORE_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUX18_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VXO22_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VRF18_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VUSB_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUD18_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC1_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VPROC1_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC2_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VPROC2_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_MD_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_OTHERS_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VEMC_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VM18_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VUFS_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VBBCK_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VRFCK_1_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS1_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VA12_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VA09_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS2_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMODEM_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VPU_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VGPU12_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VGPU11_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VCORE_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUX18_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VXO22_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VRF18_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VUSB_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUD18_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC1_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VPROC1_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC2_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VPROC2_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_MD_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_OTHERS_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VEMC_OC_ENB),
	PMIC_ENTRY(PMIC_RG_PSEQ_FORCE_ON),
	PMIC_ENTRY(PMIC_RG_PSEQ_FORCE_TEST_EN),
	PMIC_ENTRY(PMIC_RG_PSEQ_BYPASS_DEB),
	PMIC_ENTRY(PMIC_RG_PSEQ_BYPASS_SEQ),
	PMIC_ENTRY(PMIC_RG_PSEQ_LPBWDT_ACC),
	PMIC_ENTRY(PMIC_RG_PSEQ_FORCE_ALL_DOFF),
	PMIC_ENTRY(PMIC_RG_PSEQ_PG_CK_SEL),
	PMIC_ENTRY(PMIC_RG_PSEQ_SPAR_XCPT_MASK),
	PMIC_ENTRY(PMIC_RG_PSEQ_RTCA_XCPT_MASK),
	PMIC_ENTRY(PMIC_RG_THM_SHDN_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_UVLO_U1U2_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_UVLO_U1U2_SEL_SWCTRL),
	PMIC_ENTRY(PMIC_RG_OVLO_RDB_TD),
	PMIC_ENTRY(PMIC_RG_OVLO_RDB_EN),
	PMIC_ENTRY(PMIC_RG_THR_TEST),
	PMIC_ENTRY(PMIC_RG_STRUP_ENVTEM),
	PMIC_ENTRY(PMIC_RG_STRUP_ENVTEM_CTRL),
	PMIC_ENTRY(PMIC_DDUVLO_DEB_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_FT_CTRL),
	PMIC_ENTRY(PMIC_RG_BIASGEN_FORCE),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRON),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRON_SEL),
	PMIC_ENTRY(PMIC_RG_BIASGEN),
	PMIC_ENTRY(PMIC_RG_BIASGEN_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO_PMU_CKEN),
	PMIC_ENTRY(PMIC_RG_DCXO_PMU_CKEN_SEL),
	PMIC_ENTRY(PMIC_STRUP_DIG_IO_PG_FORCE),
	PMIC_ENTRY(PMIC_RG_ATST_PG_CHK),
	PMIC_ENTRY(PMIC_RG_STRUP_PG_DEB_MODE),
	PMIC_ENTRY(PMIC_RG_OVLO_FCMPL_SW_SEL),
	PMIC_ENTRY(PMIC_RG_OVLO_FCMPL_SW),
	PMIC_ENTRY(PMIC_RG_UVLO_VSYS_VTH_SW_SEL),
	PMIC_ENTRY(PMIC_RG_UVLO_VSYS_VTH_SW),
	PMIC_ENTRY(PMIC_RG_CPS_W_KEY),
	PMIC_ENTRY(PMIC_RG_SLOT_INTV_DOWN),
	PMIC_ENTRY(PMIC_RG_DSEQ_LEN),
	PMIC_ENTRY(PMIC_RG_VXO22_DSA),
	PMIC_ENTRY(PMIC_RG_VAUX18_DSA),
	PMIC_ENTRY(PMIC_RG_VCORE_DSA),
	PMIC_ENTRY(PMIC_RG_VGPU11_DSA),
	PMIC_ENTRY(PMIC_RG_VGPU12_DSA),
	PMIC_ENTRY(PMIC_RG_VPU_DSA),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_EN2_DSA),
	PMIC_ENTRY(PMIC_RG_VMODEM_DSA),
	PMIC_ENTRY(PMIC_RG_VS2_DSA),
	PMIC_ENTRY(PMIC_RG_VA09_DSA),
	PMIC_ENTRY(PMIC_RG_VA12_DSA),
	PMIC_ENTRY(PMIC_RG_VS1_DSA),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_DSA),
	PMIC_ENTRY(PMIC_RG_VBBCK_DSA),
	PMIC_ENTRY(PMIC_RG_VUFS_DSA),
	PMIC_ENTRY(PMIC_RG_VIO18_DSA),
	PMIC_ENTRY(PMIC_RG_VM18_DSA),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_EN1_DSA),
	PMIC_ENTRY(PMIC_RG_VEMC_DSA),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_DSA),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_DSA),
	PMIC_ENTRY(PMIC_RG_VPROC2_DSA),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_DSA),
	PMIC_ENTRY(PMIC_RG_VPROC1_DSA),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_DSA),
	PMIC_ENTRY(PMIC_RG_VAUD18_DSA),
	PMIC_ENTRY(PMIC_RG_VUSB_DSA),
	PMIC_ENTRY(PMIC_RG_VRF18_DSA),
	PMIC_ENTRY(PMIC_PSEQ_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BWDT_EN),
	PMIC_ENTRY(PMIC_RG_BWDT_TSEL),
	PMIC_ENTRY(PMIC_RG_BWDT_CSEL),
	PMIC_ENTRY(PMIC_RG_BWDT_TD),
	PMIC_ENTRY(PMIC_RG_BWDT_CHRTD),
	PMIC_ENTRY(PMIC_RG_BWDT_DDLO_TD),
	PMIC_ENTRY(PMIC_RG_SLOT_INTV_UP),
	PMIC_ENTRY(PMIC_RG_SEQ_LEN),
	PMIC_ENTRY(PMIC_RG_PSEQ_ELR_RSV0),
	PMIC_ENTRY(PMIC_RG_PSPG_SHDN_ENB),
	PMIC_ENTRY(PMIC_RG_PSEQ_F32K_FORCE),
	PMIC_ENTRY(PMIC_RG_PSEQ_1MS_TK_EXT),
	PMIC_ENTRY(PMIC_RG_SMPS_IVGEN_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_RESET_EXTEND),
	PMIC_ENTRY(PMIC_RG_CPS_S0EXT_ENB),
	PMIC_ENTRY(PMIC_RG_CPS_S0EXT_TD),
	PMIC_ENTRY(PMIC_RG_SDN_DLY_ENB),
	PMIC_ENTRY(PMIC_RG_CHRDET_DEB_TD),
	PMIC_ENTRY(PMIC_RG_PWRKEY_EVENT_MODE),
	PMIC_ENTRY(PMIC_RG_PWRKEY_EVENT_MODE_HW),
	PMIC_ENTRY(PMIC_RG_LDO_PG_STB_MODE),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_PG_ENB),
	PMIC_ENTRY(PMIC_RG_PSC_ELR_RSV0),
	PMIC_ENTRY(PMIC_RG_PSC_ELR_RSV1),
	PMIC_ENTRY(PMIC_RG_VXO22_USA),
	PMIC_ENTRY(PMIC_RG_VAUX18_USA),
	PMIC_ENTRY(PMIC_RG_VCORE_USA),
	PMIC_ENTRY(PMIC_RG_VGPU11_USA),
	PMIC_ENTRY(PMIC_RG_VGPU12_USA),
	PMIC_ENTRY(PMIC_RG_VPU_USA),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_EN2_USA),
	PMIC_ENTRY(PMIC_RG_VMODEM_USA),
	PMIC_ENTRY(PMIC_RG_VS2_USA),
	PMIC_ENTRY(PMIC_RG_VA09_USA),
	PMIC_ENTRY(PMIC_RG_VA12_USA),
	PMIC_ENTRY(PMIC_RG_VS1_USA),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_USA),
	PMIC_ENTRY(PMIC_RG_VBBCK_USA),
	PMIC_ENTRY(PMIC_RG_VUFS_USA),
	PMIC_ENTRY(PMIC_RG_VIO18_USA),
	PMIC_ENTRY(PMIC_RG_VM18_USA),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_EN1_USA),
	PMIC_ENTRY(PMIC_RG_VEMC_USA),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_USA),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_USA),
	PMIC_ENTRY(PMIC_RG_VPROC2_USA),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_USA),
	PMIC_ENTRY(PMIC_RG_VPROC1_USA),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_USA),
	PMIC_ENTRY(PMIC_RG_VAUD18_USA),
	PMIC_ENTRY(PMIC_RG_VUSB_USA),
	PMIC_ENTRY(PMIC_RG_VRF18_USA),
	PMIC_ENTRY(PMIC_CHRDET_ANA_ID),
	PMIC_ENTRY(PMIC_CHRDET_DIG_ID),
	PMIC_ENTRY(PMIC_CHRDET_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_CHRDET_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_CHRDET_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_CHRDET_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_CHRDET_CBS),
	PMIC_ENTRY(PMIC_CHRDET_BIX),
	PMIC_ENTRY(PMIC_CHRDET_ESP),
	PMIC_ENTRY(PMIC_CHRDET_FPI),
	PMIC_ENTRY(PMIC_RGS_CHRDET),
	PMIC_ENTRY(PMIC_AD_CHRDETB),
	PMIC_ENTRY(PMIC_RG_CHRDET_DEB_BYPASS),
	PMIC_ENTRY(PMIC_RG_ENVTEM_D),
	PMIC_ENTRY(PMIC_RG_ENVTEM_EN),
	PMIC_ENTRY(PMIC_DA_QI_BGR_EXT_BUF_EN),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_RSTB),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_EN),
	PMIC_ENTRY(PMIC_RG_BGR_UNCHOP),
	PMIC_ENTRY(PMIC_RG_BGR_UNCHOP_PH),
	PMIC_ENTRY(PMIC_RG_UVLO_VTHL),
	PMIC_ENTRY(PMIC_RG_LBAT_INT_VTH),
	PMIC_ENTRY(PMIC_RG_OVLO_VTH_SEL),
	PMIC_ENTRY(PMIC_RG_PCHR_RV),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_PCAS_EN),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_NCAS_EN),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_EN),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_BIAS_SELECT),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_SIZE_SELECT),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_RSV),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_CURRENT_TRIM),
	PMIC_ENTRY(PMIC_CHRDET_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BGR_TRIM),
	PMIC_ENTRY(PMIC_RG_BGR_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_BGR_RSEL),
	PMIC_ENTRY(PMIC_RG_OVLO_EN),
	PMIC_ENTRY(PMIC_BM_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_BM_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_BM_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BM_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BM_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BM_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BM_TOP_CBS),
	PMIC_ENTRY(PMIC_BM_TOP_BIX),
	PMIC_ENTRY(PMIC_BM_TOP_ESP),
	PMIC_ENTRY(PMIC_BM_TOP_FPI),
	PMIC_ENTRY(PMIC_BM_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_BM_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_BATON_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FGADC_FT_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FGADC_DIG_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FGADC_ANA_CK_PDN),
	PMIC_ENTRY(PMIC_RG_G_BIF_1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BIF_X1_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BIF_X4_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BIF_X104_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BM_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BM_TOP_CKPDN_CON0_RSV),
	PMIC_ENTRY(PMIC_BM_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_FGADC_ANA_CK_CKSEL),
	PMIC_ENTRY(PMIC_BM_TOP_CKSEL_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_CKSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BIF_X4_CK_DIVSEL),
	PMIC_ENTRY(PMIC_BM_TOP_CKDIVSEL_CON0_RSV),
	PMIC_ENTRY(PMIC_BM_TOP_CKDIVSEL_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_CKDIVSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BIF_X4_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BIF_X104_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_BM_TOP_CKHWEN_CON0_RSV),
	PMIC_ENTRY(PMIC_BM_TOP_CKHWEN_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_CKHWEN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_FG_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_FGADC_ANA_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_FG_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_FGADC_SWRST),
	PMIC_ENTRY(PMIC_RG_BATON_SWRST),
	PMIC_ENTRY(PMIC_RG_BIF_SWRST),
	PMIC_ENTRY(PMIC_RG_BATON_BATDEB_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_FGADC_ANA_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_FGADC0_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_FGADC1_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_BATON_ANA_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_BATON_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_BIF_SWRST),
	PMIC_ENTRY(PMIC_BM_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_FGADC_RST_SRC_SEL),
	PMIC_ENTRY(PMIC_BM_TOP_RST_CON1_RSV),
	PMIC_ENTRY(PMIC_BM_TOP_RST_CON1_SET),
	PMIC_ENTRY(PMIC_BM_TOP_RST_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_CUR_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_CUR_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_ZCV),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_N_CHARGE_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_IAVG_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_IAVG_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_INT_EN_FG_CHARGE),
	PMIC_ENTRY(PMIC_RG_BM_INT_EN_CON0_RSV),
	PMIC_ENTRY(PMIC_BM_TOP_INT_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_BATON_LV),
	PMIC_ENTRY(PMIC_RG_INT_EN_BATON_BAT_IN),
	PMIC_ENTRY(PMIC_RG_INT_EN_BATON_BAT_OUT),
	PMIC_ENTRY(PMIC_RG_INT_EN_BIF),
	PMIC_ENTRY(PMIC_BM_TOP_INT_CON1_SET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_CUR_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_CUR_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_ZCV),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_N_CHARGE_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_IAVG_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_IAVG_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_INT_MASK_FG_CHARGE),
	PMIC_ENTRY(PMIC_RG_BM_INT_MASK_CON0_RSV),
	PMIC_ENTRY(PMIC_BM_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BATON_LV),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BATON_BAT_IN),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BATON_BAT_OUT),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BIF),
	PMIC_ENTRY(PMIC_BM_TOP_INT_MASK_CON1_SET),
	PMIC_ENTRY(PMIC_BM_TOP_INT_MASK_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_CUR_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_CUR_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_ZCV),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_N_CHARGE_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_IAVG_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_IAVG_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_FG_CHARGE),
	PMIC_ENTRY(PMIC_RG_BM_INT_STATUS0_RSV),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BATON_LV),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BATON_BAT_IN),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BATON_BAT_OUT),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BIF),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_CUR_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_CUR_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_ZCV),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_N_CHARGE_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_IAVG_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_IAVG_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_FG_CHARGE),
	PMIC_ENTRY(PMIC_RG_BM_INT_RAW_STATUS_RSV),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BATON_LV),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BATON_BAT_IN),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BATON_BAT_OUT),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BIF),
	PMIC_ENTRY(PMIC_POLARITY),
	PMIC_ENTRY(PMIC_RG_BM_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_BM_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_BM_TOP_RSV0),
	PMIC_ENTRY(PMIC_BM_FGADC_KEY),
	PMIC_ENTRY(PMIC_BM_BATON_KEY),
	PMIC_ENTRY(PMIC_BM_BIF_KEY),
	PMIC_ENTRY(PMIC_FGADC_ANA_ANA_ID),
	PMIC_ENTRY(PMIC_FGADC_ANA_DIG_ID),
	PMIC_ENTRY(PMIC_FGADC_ANA_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC_ANA_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC_ANA_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC_ANA_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC_ANA_DSN_CBS),
	PMIC_ENTRY(PMIC_FGADC_ANA_DSN_BIX),
	PMIC_ENTRY(PMIC_FGADC_ANA_DSN_ESP),
	PMIC_ENTRY(PMIC_FGADC_ANA_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_FGANALOGTEST),
	PMIC_ENTRY(PMIC_RG_FGINTMODE),
	PMIC_ENTRY(PMIC_RG_SPARE),
	PMIC_ENTRY(PMIC_RG_CHOP_EN),
	PMIC_ENTRY(PMIC_FG_RNG_BIT_MODE),
	PMIC_ENTRY(PMIC_FG_RNG_BIT_SW),
	PMIC_ENTRY(PMIC_FG_RNG_EN_MODE),
	PMIC_ENTRY(PMIC_FG_RNG_EN_SW),
	PMIC_ENTRY(PMIC_DA_FG_RNG_EN),
	PMIC_ENTRY(PMIC_DA_FG_RNG_BIT),
	PMIC_ENTRY(PMIC_DA_FGCAL_EN),
	PMIC_ENTRY(PMIC_DA_FGADC_EN),
	PMIC_ENTRY(PMIC_FG_DWA_T0),
	PMIC_ENTRY(PMIC_FG_DWA_T1),
	PMIC_ENTRY(PMIC_FG_DWA_RST_MODE),
	PMIC_ENTRY(PMIC_FG_DWA_RST_SW),
	PMIC_ENTRY(PMIC_DA_DWA_RST),
	PMIC_ENTRY(PMIC_DA_FG_RST),
	PMIC_ENTRY(PMIC_FGADC_ANA_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_FGADC_GAINERR_CAL),
	PMIC_ENTRY(PMIC_RG_FG_OFFSET_SWAP),
	PMIC_ENTRY(PMIC_FGADC0_ANA_ID),
	PMIC_ENTRY(PMIC_FGADC0_DIG_ID),
	PMIC_ENTRY(PMIC_FGADC0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC0_DSN_CBS),
	PMIC_ENTRY(PMIC_FGADC0_DSN_BIX),
	PMIC_ENTRY(PMIC_FGADC0_DSN_ESP),
	PMIC_ENTRY(PMIC_FGADC0_DSN_FPI),
	PMIC_ENTRY(PMIC_FG_ON),
	PMIC_ENTRY(PMIC_FG_CAL),
	PMIC_ENTRY(PMIC_FG_AUTOCALRATE),
	PMIC_ENTRY(PMIC_FG_SON_SLP_EN),
	PMIC_ENTRY(PMIC_FG_SOFF_SLP_EN),
	PMIC_ENTRY(PMIC_FG_ZCV_DET_EN),
	PMIC_ENTRY(PMIC_FG_AUXADC_R),
	PMIC_ENTRY(PMIC_FG_IAVG_MODE),
	PMIC_ENTRY(PMIC_FG_SW_READ_PRE),
	PMIC_ENTRY(PMIC_FG_SW_RSTCLR),
	PMIC_ENTRY(PMIC_FG_SW_CR),
	PMIC_ENTRY(PMIC_FG_SW_CLEAR),
	PMIC_ENTRY(PMIC_FG_SON_FP_EN),
	PMIC_ENTRY(PMIC_FG_SON_SLP_HS),
	PMIC_ENTRY(PMIC_FG_OFFSET_RST),
	PMIC_ENTRY(PMIC_FG_TIME_RST),
	PMIC_ENTRY(PMIC_FG_CHARGE_RST),
	PMIC_ENTRY(PMIC_FG_N_CHARGE_RST),
	PMIC_ENTRY(PMIC_FG_SOFF_RST),
	PMIC_ENTRY(PMIC_FG_VA_ERR_RST),
	PMIC_ENTRY(PMIC_FG_LATCHDATA_ST),
	PMIC_ENTRY(PMIC_EVENT_FG_BAT_H),
	PMIC_ENTRY(PMIC_EVENT_FG_BAT_L),
	PMIC_ENTRY(PMIC_EVENT_FG_CUR_H),
	PMIC_ENTRY(PMIC_EVENT_FG_CUR_L),
	PMIC_ENTRY(PMIC_EVENT_FG_ZCV),
	PMIC_ENTRY(PMIC_EVENT_FG_N_CHARGE_L),
	PMIC_ENTRY(PMIC_EVENT_FG_IAVG_H),
	PMIC_ENTRY(PMIC_EVENT_FG_IAVG_L),
	PMIC_ENTRY(PMIC_EVENT_FG_DISCHARGE),
	PMIC_ENTRY(PMIC_EVENT_FG_CHARGE),
	PMIC_ENTRY(PMIC_FG_OSR1),
	PMIC_ENTRY(PMIC_FG_OSR2),
	PMIC_ENTRY(PMIC_FG_FP_RECAL_EN),
	PMIC_ENTRY(PMIC_FG_CUR_OV_MULT),
	PMIC_ENTRY(PMIC_FG_ADJ_OFFSET_EN),
	PMIC_ENTRY(PMIC_FG_ADC_AUTORST),
	PMIC_ENTRY(PMIC_FG_ADC_RSTDETECT),
	PMIC_ENTRY(PMIC_FG_VA_ERR),
	PMIC_ENTRY(PMIC_FG_VA_AON),
	PMIC_ENTRY(PMIC_FG_VA_AOFF),
	PMIC_ENTRY(PMIC_FG_SON_SW),
	PMIC_ENTRY(PMIC_FG_SON_SW_MODE),
	PMIC_ENTRY(PMIC_PWR_FG_VA_ACK),
	PMIC_ENTRY(PMIC_PWR_FG_VA_REQ),
	PMIC_ENTRY(PMIC_FG_VA_ACK_SW),
	PMIC_ENTRY(PMIC_FG_VA_ACK_SW_MODE),
	PMIC_ENTRY(PMIC_FG_VA_REQ_SW),
	PMIC_ENTRY(PMIC_FG_VA_REQ_SW_MODE),
	PMIC_ENTRY(PMIC_FGADC_CON5_RSV),
	PMIC_ENTRY(PMIC_FG_RSTB_STATUS),
	PMIC_ENTRY(PMIC_FG_CAR_15_00),
	PMIC_ENTRY(PMIC_FG_CAR_31_16),
	PMIC_ENTRY(PMIC_FG_BAT_LTH_15_00),
	PMIC_ENTRY(PMIC_FG_BAT_LTH_31_16),
	PMIC_ENTRY(PMIC_FG_BAT_HTH_15_00),
	PMIC_ENTRY(PMIC_FG_BAT_HTH_31_16),
	PMIC_ENTRY(PMIC_FG_NCAR_15_00),
	PMIC_ENTRY(PMIC_FG_NCAR_31_16),
	PMIC_ENTRY(PMIC_FG_N_CHARGE_LTH_15_00),
	PMIC_ENTRY(PMIC_FG_N_CHARGE_LTH_31_16),
	PMIC_ENTRY(PMIC_FG_IAVG_15_00),
	PMIC_ENTRY(PMIC_FG_IAVG_27_16),
	PMIC_ENTRY(PMIC_FG_IAVG_VLD),
	PMIC_ENTRY(PMIC_FG_IAVG_LTH_15_00),
	PMIC_ENTRY(PMIC_FG_IAVG_LTH_28_16),
	PMIC_ENTRY(PMIC_FG_IAVG_HTH_15_00),
	PMIC_ENTRY(PMIC_FG_IAVG_HTH_28_16),
	PMIC_ENTRY(PMIC_FG_NTER_15_00),
	PMIC_ENTRY(PMIC_FG_NTER_29_16),
	PMIC_ENTRY(PMIC_FG_SON_SLP_CUR_TH),
	PMIC_ENTRY(PMIC_FG_SON_SLP_TIME),
	PMIC_ENTRY(PMIC_FG_SON_DET_TIME),
	PMIC_ENTRY(PMIC_FG_SOFF_SLP_CUR_TH),
	PMIC_ENTRY(PMIC_FG_SOFF_SLP_TIME),
	PMIC_ENTRY(PMIC_FG_SOFF_DET_TIME),
	PMIC_ENTRY(PMIC_FG_SOFF_TIME_15_00),
	PMIC_ENTRY(PMIC_FG_SOFF_TIME_29_16),
	PMIC_ENTRY(PMIC_FG_SOFF),
	PMIC_ENTRY(PMIC_FG_ZCV_DET_IV),
	PMIC_ENTRY(PMIC_FGADC_ZCV_CON0_RSV),
	PMIC_ENTRY(PMIC_FG_ZCV_CURR),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_15_00),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_31_16),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_TH_15_00),
	PMIC_ENTRY(PMIC_FG_ZCV_CAR_TH_30_16),
	PMIC_ENTRY(PMIC_FGADC1_ANA_ID),
	PMIC_ENTRY(PMIC_FGADC1_DIG_ID),
	PMIC_ENTRY(PMIC_FGADC1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_FGADC1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_FGADC1_DSN_CBS),
	PMIC_ENTRY(PMIC_FGADC1_DSN_BIX),
	PMIC_ENTRY(PMIC_FGADC1_DSN_ESP),
	PMIC_ENTRY(PMIC_FGADC1_DSN_FPI),
	PMIC_ENTRY(PMIC_FG_R_CURR),
	PMIC_ENTRY(PMIC_FG_CURRENT_OUT),
	PMIC_ENTRY(PMIC_FG_CUR_LTH),
	PMIC_ENTRY(PMIC_FG_CUR_HTH),
	PMIC_ENTRY(PMIC_FG_CIC2),
	PMIC_ENTRY(PMIC_FG_OFFSET),
	PMIC_ENTRY(PMIC_FG_ADJUST_OFFSET_VALUE),
	PMIC_ENTRY(PMIC_FG_GAIN),
	PMIC_ENTRY(PMIC_FG_MODE),
	PMIC_ENTRY(PMIC_FG_RST_SW),
	PMIC_ENTRY(PMIC_FG_FGCAL_EN_SW),
	PMIC_ENTRY(PMIC_FG_FGADC_EN_SW),
	PMIC_ENTRY(PMIC_RG_SYSTEM_INFO_CON0),
	PMIC_ENTRY(PMIC_RG_SYSTEM_INFO_CON1),
	PMIC_ENTRY(PMIC_RG_SYSTEM_INFO_CON2),
	PMIC_ENTRY(PMIC_BATON_ANA_ANA_ID),
	PMIC_ENTRY(PMIC_BATON_ANA_DIG_ID),
	PMIC_ENTRY(PMIC_BATON_ANA_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BATON_ANA_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BATON_ANA_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BATON_ANA_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BATON_ANA_DSN_CBS),
	PMIC_ENTRY(PMIC_BATON_ANA_DSN_BIX),
	PMIC_ENTRY(PMIC_BATON_ANA_DSN_ESP),
	PMIC_ENTRY(PMIC_BATON_ANA_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_BATON_EN),
	PMIC_ENTRY(PMIC_RG_BIF_BATID_SW_EN),
	PMIC_ENTRY(PMIC_RG_QI_BATON_LT_EN),
	PMIC_ENTRY(PMIC_RG_BATON_HT_EN),
	PMIC_ENTRY(PMIC_DA_BATON_HT_EN),
	PMIC_ENTRY(PMIC_AD_BATON_UNDET),
	PMIC_ENTRY(PMIC_AD_BATON_UNDET_RAW),
	PMIC_ENTRY(PMIC_DA_BIF_TX_EN),
	PMIC_ENTRY(PMIC_DA_BIF_TX_DATA),
	PMIC_ENTRY(PMIC_DA_BIF_RX_EN),
	PMIC_ENTRY(PMIC_AD_BIF_RX_DATA),
	PMIC_ENTRY(PMIC_BATON_ANA_ID),
	PMIC_ENTRY(PMIC_BATON_DIG_ID),
	PMIC_ENTRY(PMIC_BATON_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BATON_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BATON_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BATON_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BATON_DSN_CBS),
	PMIC_ENTRY(PMIC_BATON_DSN_BIX),
	PMIC_ENTRY(PMIC_BATON_DSN_ESP),
	PMIC_ENTRY(PMIC_BATON_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_BATON_DEBOUNCE_WND),
	PMIC_ENTRY(PMIC_RG_BATON_DEBOUNCE_THD),
	PMIC_ENTRY(PMIC_RG_BATON_CHRDET_TESTMODE),
	PMIC_ENTRY(PMIC_RG_BATON_UNDET_TESTMODE),
	PMIC_ENTRY(PMIC_RG_BATON_AUXADC_TESTMODE),
	PMIC_ENTRY(PMIC_RG_BATON_FGADC_TESTMODE),
	PMIC_ENTRY(PMIC_RG_BATON_RTC_TESTMODE),
	PMIC_ENTRY(PMIC_RG_BATON_BIF_TESTMODE),
	PMIC_ENTRY(PMIC_RG_BATON_VBIF28_REQ_TESTMODE),
	PMIC_ENTRY(PMIC_RG_BATON_VBIF28_ACK_TESTMODE),
	PMIC_ENTRY(PMIC_RG_BATON_CHRDET_SW),
	PMIC_ENTRY(PMIC_RG_BATON_UNDET_SW),
	PMIC_ENTRY(PMIC_RG_BATON_AUXADC_SW),
	PMIC_ENTRY(PMIC_RG_BATON_FGADC_SW),
	PMIC_ENTRY(PMIC_RG_BATON_RTC_SW),
	PMIC_ENTRY(PMIC_RG_BATON_BIF_SW),
	PMIC_ENTRY(PMIC_RG_BATON_VBIF28_REQ_SW),
	PMIC_ENTRY(PMIC_RG_BATON_VBIF28_ACK_SW),
	PMIC_ENTRY(PMIC_BATON_DEB),
	PMIC_ENTRY(PMIC_BATON_AUXADC_SET),
	PMIC_ENTRY(PMIC_BATON_DEB_VLD),
	PMIC_ENTRY(PMIC_BATON_BIF_STATUS),
	PMIC_ENTRY(PMIC_BATON_RTC_STATUS),
	PMIC_ENTRY(PMIC_BATON_FGADC_STATUS),
	PMIC_ENTRY(PMIC_BATON_AUXADC_TRIG),
	PMIC_ENTRY(PMIC_BATON_CHRDET_DEB),
	PMIC_ENTRY(PMIC_PWR_BATON_VBIF28_ACK),
	PMIC_ENTRY(PMIC_PWR_BATON_VBIF28_REQ),
	PMIC_ENTRY(PMIC_BATON_RSV_0),
	PMIC_ENTRY(PMIC_BIF_ANA_ID),
	PMIC_ENTRY(PMIC_BIF_DIG_ID),
	PMIC_ENTRY(PMIC_BIF_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BIF_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BIF_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BIF_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BIF_DSN_CBS),
	PMIC_ENTRY(PMIC_BIF_DSN_BIX),
	PMIC_ENTRY(PMIC_BIF_ESP),
	PMIC_ENTRY(PMIC_BIF_DSN_FPI),
	PMIC_ENTRY(PMIC_BIF_COMMAND_0),
	PMIC_ENTRY(PMIC_BIF_COMMAND_1),
	PMIC_ENTRY(PMIC_BIF_COMMAND_2),
	PMIC_ENTRY(PMIC_BIF_COMMAND_3),
	PMIC_ENTRY(PMIC_BIF_COMMAND_4),
	PMIC_ENTRY(PMIC_BIF_COMMAND_5),
	PMIC_ENTRY(PMIC_BIF_COMMAND_6),
	PMIC_ENTRY(PMIC_BIF_COMMAND_7),
	PMIC_ENTRY(PMIC_BIF_COMMAND_8),
	PMIC_ENTRY(PMIC_BIF_COMMAND_9),
	PMIC_ENTRY(PMIC_BIF_COMMAND_10),
	PMIC_ENTRY(PMIC_BIF_COMMAND_11),
	PMIC_ENTRY(PMIC_BIF_COMMAND_12),
	PMIC_ENTRY(PMIC_BIF_COMMAND_13),
	PMIC_ENTRY(PMIC_BIF_COMMAND_14),
	PMIC_ENTRY(PMIC_BIF_RSV),
	PMIC_ENTRY(PMIC_BIF_COMMAND_TYPE),
	PMIC_ENTRY(PMIC_BIF_TRASFER_NUM),
	PMIC_ENTRY(PMIC_BIF_LOGIC_0_SET),
	PMIC_ENTRY(PMIC_BIF_LOGIC_1_SET),
	PMIC_ENTRY(PMIC_BIF_STOP_SET),
	PMIC_ENTRY(PMIC_BIF_DEBOUNCE_EN),
	PMIC_ENTRY(PMIC_BIF_READ_EXPECT_NUM),
	PMIC_ENTRY(PMIC_BIF_TRASACT_TRIGGER),
	PMIC_ENTRY(PMIC_BIF_DATA_NUM),
	PMIC_ENTRY(PMIC_BIF_RESPONSE),
	PMIC_ENTRY(PMIC_BIF_DATA_0),
	PMIC_ENTRY(PMIC_BIF_ACK_0),
	PMIC_ENTRY(PMIC_BIF_ERR_0),
	PMIC_ENTRY(PMIC_BIF_DATA_1),
	PMIC_ENTRY(PMIC_BIF_ACK_1),
	PMIC_ENTRY(PMIC_BIF_ERR_1),
	PMIC_ENTRY(PMIC_BIF_DATA_2),
	PMIC_ENTRY(PMIC_BIF_ACK_2),
	PMIC_ENTRY(PMIC_BIF_ERR_2),
	PMIC_ENTRY(PMIC_BIF_DATA_3),
	PMIC_ENTRY(PMIC_BIF_ACK_3),
	PMIC_ENTRY(PMIC_BIF_ERR_3),
	PMIC_ENTRY(PMIC_BIF_DATA_4),
	PMIC_ENTRY(PMIC_BIF_ACK_4),
	PMIC_ENTRY(PMIC_BIF_ERR_4),
	PMIC_ENTRY(PMIC_BIF_DATA_5),
	PMIC_ENTRY(PMIC_BIF_ACK_5),
	PMIC_ENTRY(PMIC_BIF_ERR_5),
	PMIC_ENTRY(PMIC_BIF_DATA_6),
	PMIC_ENTRY(PMIC_BIF_ACK_6),
	PMIC_ENTRY(PMIC_BIF_ERR_6),
	PMIC_ENTRY(PMIC_BIF_DATA_7),
	PMIC_ENTRY(PMIC_BIF_ACK_7),
	PMIC_ENTRY(PMIC_BIF_ERR_7),
	PMIC_ENTRY(PMIC_BIF_DATA_8),
	PMIC_ENTRY(PMIC_BIF_ACK_8),
	PMIC_ENTRY(PMIC_BIF_ERR_8),
	PMIC_ENTRY(PMIC_BIF_DATA_9),
	PMIC_ENTRY(PMIC_BIF_ACK_9),
	PMIC_ENTRY(PMIC_BIF_ERR_9),
	PMIC_ENTRY(PMIC_BIF_TEST_MODE0),
	PMIC_ENTRY(PMIC_BIF_TEST_MODE1),
	PMIC_ENTRY(PMIC_BIF_TEST_MODE2),
	PMIC_ENTRY(PMIC_BIF_TEST_MODE3),
	PMIC_ENTRY(PMIC_BIF_TEST_MODE4),
	PMIC_ENTRY(PMIC_BIF_TEST_MODE5),
	PMIC_ENTRY(PMIC_BIF_TEST_MODE6),
	PMIC_ENTRY(PMIC_BIF_TEST_MODE7),
	PMIC_ENTRY(PMIC_BIF_TEST_MODE8),
	PMIC_ENTRY(PMIC_BIF_BAT_LOST_SW),
	PMIC_ENTRY(PMIC_BIF_RX_DATA_SW),
	PMIC_ENTRY(PMIC_BIF_TX_DATA_SW),
	PMIC_ENTRY(PMIC_BIF_RX_EN_SW),
	PMIC_ENTRY(PMIC_BIF_TX_EN_SW),
	PMIC_ENTRY(PMIC_BIF_BACK_NORMAL),
	PMIC_ENTRY(PMIC_BIF_IRQ_CLR),
	PMIC_ENTRY(PMIC_BIF_IRQ),
	PMIC_ENTRY(PMIC_BIF_TIMEOUT),
	PMIC_ENTRY(PMIC_BIF_BAT_UNDET),
	PMIC_ENTRY(PMIC_BIF_TOTAL_VALID),
	PMIC_ENTRY(PMIC_BIF_BUS_STATUS),
	PMIC_ENTRY(PMIC_BIF_POWER_UP_COUNT),
	PMIC_ENTRY(PMIC_BIF_POWER_UP),
	PMIC_ENTRY(PMIC_BIF_RX_ERR_UNKNOWN),
	PMIC_ENTRY(PMIC_BIF_RX_ERR_INSUFF),
	PMIC_ENTRY(PMIC_BIF_RX_ERR_LOWPHASE),
	PMIC_ENTRY(PMIC_BIF_RX_STATE),
	PMIC_ENTRY(PMIC_BIF_FLOW_CTL_STATE),
	PMIC_ENTRY(PMIC_BIF_TX_STATE),
	PMIC_ENTRY(PMIC_BIF_TX_DATA_FIANL),
	PMIC_ENTRY(PMIC_BIF_RX_DATA_SAMPLING),
	PMIC_ENTRY(PMIC_BIF_RX_DATA_RECOVERY),
	PMIC_ENTRY(PMIC_RG_BATON_HT_EN_PRE),
	PMIC_ENTRY(PMIC_RG_BATON_HT_EN_DLY_TIME),
	PMIC_ENTRY(PMIC_BIF_TIMEOUT_SET),
	PMIC_ENTRY(PMIC_BIF_RX_DEG_WND),
	PMIC_ENTRY(PMIC_BIF_RX_DEG_EN),
	PMIC_ENTRY(PMIC_BIF_RSV1),
	PMIC_ENTRY(PMIC_BIF_RSV0),
	PMIC_ENTRY(PMIC_HK_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_HK_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_HK_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_CBS),
	PMIC_ENTRY(PMIC_HK_TOP_BIX),
	PMIC_ENTRY(PMIC_HK_TOP_ESP),
	PMIC_ENTRY(PMIC_HK_TOP_FPI),
	PMIC_ENTRY(PMIC_HK_CLK_OFFSET),
	PMIC_ENTRY(PMIC_HK_RST_OFFSET),
	PMIC_ENTRY(PMIC_HK_INT_OFFSET),
	PMIC_ENTRY(PMIC_HK_INT_LEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_HK_INTRP_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_HK_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_26M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_1M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_32K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_HK_INTRP_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_RST),
	PMIC_ENTRY(PMIC_RG_AUXADC_REG_RST),
	PMIC_ENTRY(PMIC_BANK_HK_TOP_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_1_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_2_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_3_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_4_SWRST),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT2_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT2_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_TEMP_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_TEMP_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_THR_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_THR_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_EN_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_HK_INT_CON0_SET),
	PMIC_ENTRY(PMIC_HK_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT2_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT2_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_TEMP_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_TEMP_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_THR_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_THR_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_HK_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_HK_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT2_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT2_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_TEMP_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_TEMP_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_THR_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_THR_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT2_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT2_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_TEMP_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_TEMP_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_THR_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_THR_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_RG_CLK_MON_FLAG_EN),
	PMIC_ENTRY(PMIC_RG_CLK_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_INT_MON_FLAG_EN),
	PMIC_ENTRY(PMIC_RG_INT_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_HK_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_MON_FLAG_SEL_AUXADC),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_RG_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_EXT_BATON_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_DIFFBUF_SWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_DIFFBUF_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_VBAT_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_DA_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_BATID_SW_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_DIFFBUF_EN),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_START_SW),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_RSTB_SW),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_START_SEL),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_RSTB_SEL),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_RPCNT_MAX),
	PMIC_ENTRY(PMIC_RG_VAUX18_AUXADC_STB_SWEN),
	PMIC_ENTRY(PMIC_RG_VAUX18_AUXADC_STB_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_AUXADC_ACK_SWEN),
	PMIC_ENTRY(PMIC_RG_VAUX18_AUXADC_ACK_EN),
	PMIC_ENTRY(PMIC_RG_VBIF28_AUXADC_STB_SWEN),
	PMIC_ENTRY(PMIC_RG_VBIF28_AUXADC_STB_EN),
	PMIC_ENTRY(PMIC_RG_VBIF28_AUXADC_ACK_SWEN),
	PMIC_ENTRY(PMIC_RG_VBIF28_AUXADC_ACK_EN),
	PMIC_ENTRY(PMIC_DD_AUXADC_VAUX18_REQ),
	PMIC_ENTRY(PMIC_DD_VAUX18_AUXADC_STB),
	PMIC_ENTRY(PMIC_DD_AUXADC_VAUX18_PWDB),
	PMIC_ENTRY(PMIC_DD_VAUX18_AUXADC_ACK),
	PMIC_ENTRY(PMIC_DD_AUXADC_VBIF28_REQ),
	PMIC_ENTRY(PMIC_DD_VBIF28_AUXADC_STB),
	PMIC_ENTRY(PMIC_DD_AUXADC_VBIF28_PWDB),
	PMIC_ENTRY(PMIC_DD_VBIF28_AUXADC_ACK),
	PMIC_ENTRY(PMIC_HK_AUXADC_KEY),
	PMIC_ENTRY(PMIC_AUXADC_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_AUX_RSV),
	PMIC_ENTRY(PMIC_RG_AUXADC_CALI),
	PMIC_ENTRY(PMIC_RG_VBUF_BYP),
	PMIC_ENTRY(PMIC_RG_VBUF_CALEN),
	PMIC_ENTRY(PMIC_RG_VBUF_EXTEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_NOISE_RES),
	PMIC_ENTRY(PMIC_RG_AUXADC_PULLH_EN),
	PMIC_ENTRY(PMIC_AUXADC_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_EFUSE_AUXADC_NDIF_EN),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH5),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH5),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH6),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH6),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH8),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH8),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH9),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH9),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH10),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH10),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH11),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH11),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_15),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH12_15),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_PWRON_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_RAW),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_THR1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_THR2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_THR3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_PWRON),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR3),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH0),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH1),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH2),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH3),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH5),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH6),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH8),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH9),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH10),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH11),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH12),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH13),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH14),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH15),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_RQST_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_RQST_BATID),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_THR1),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_THR2),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_THR3),
	PMIC_ENTRY(PMIC_AUXADC_RQST_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_CK_ON_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_SRCLKEN_SRC_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_PWDB),
	PMIC_ENTRY(PMIC_AUXADC_ADC_PWDB_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_STRUP_CK_ON_ENB),
	PMIC_ENTRY(PMIC_AUXADC_SRCLKEN_CK_EN),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON_GPS),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON_MD),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON),
	PMIC_ENTRY(PMIC_AUXADC_CON0_SET),
	PMIC_ENTRY(PMIC_AUXADC_CON0_CLR),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SMALL),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_LARGE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_LARGE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SLEEP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SLEEP_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH0),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH3),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH7),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH7),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH3),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH0),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_HPC),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_DCXO),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH7_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_BTMP),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH0_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH1_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH2_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH3_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH4_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH5_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH6_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH7_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH8_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH9_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH10_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH11_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_2S_COMP_ENB),
	PMIC_ENTRY(PMIC_AUXADC_ADC_TRIM_COMP),
	PMIC_ENTRY(PMIC_AUXADC_RNG_EN),
	PMIC_ENTRY(PMIC_AUXADC_TEST_MODE),
	PMIC_ENTRY(PMIC_AUXADC_BIT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_START_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_TS_VBE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TS_VBE_SEL_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_VBUF_EN),
	PMIC_ENTRY(PMIC_AUXADC_VBUF_EN_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_OUT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DA_DAC),
	PMIC_ENTRY(PMIC_AUXADC_DA_DAC_SWCTRL),
	PMIC_ENTRY(PMIC_AD_AUXADC_COMP),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_ANASWCTRL_EN),
	PMIC_ENTRY(PMIC_AUXADC_XO_THADC_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_BATID_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_VXO22_EN),
	PMIC_ENTRY(PMIC_AUXADC_DIG0_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_CHSEL),
	PMIC_ENTRY(PMIC_AUXADC_SWCTRL_EN),
	PMIC_ENTRY(PMIC_AUXADC_SOURCE_LBAT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SOURCE_LBAT2_SEL),
	PMIC_ENTRY(PMIC_AUXADC_START_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_DAC_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_DAC_EXTD_EN),
	PMIC_ENTRY(PMIC_AUXADC_DIG0_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_NUM),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_EN),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_CLR),
	PMIC_ENTRY(PMIC_AUXADC_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_CH0_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_CH1_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_CH0_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_CH1_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_STATE_CS_S),
	PMIC_ENTRY(PMIC_AUXADC_AUTORPT_PRD),
	PMIC_ENTRY(PMIC_AUXADC_AUTORPT_EN),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_AUTO_SPL),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_AUTO_RQST_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_DIG1_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_DIG0_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_IMP_FGADC_R_SW),
	PMIC_ENTRY(PMIC_AUXADC_IMP_FGADC_R_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_PLUGIN_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_BAT_PLUGIN_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DBG_DIG0_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_DBG_DIG1_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_NAG_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CLR),
	PMIC_ENTRY(PMIC_AUXADC_NAG_VBAT1_SEL),
	PMIC_ENTRY(PMIC_AUXADC_NAG_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_NAG_IRQ_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_IRQ),
	PMIC_ENTRY(PMIC_AUXADC_NAG_ZCV),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_15_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_26_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_15_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_25_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_DLTV),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_15_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_26_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_NAG_STATE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_NAG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_NAG),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_NAG),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ELR_LEN),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH7_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH7_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH4_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH4_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH0_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH0_TRIM),
	PMIC_ENTRY(PMIC_AUXADC_SW_GAIN_TRIM),
	PMIC_ENTRY(PMIC_AUXADC_SW_OFFSET_TRIM),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ID),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_SLOPE),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_SLOPE_SIGN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_DEGC_CALI),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ADC_CALI_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_2),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_3),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV3),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_4),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV4),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_GAIN_AUX),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV5),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_GAIN_BGRL),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_GAIN_BGRH),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV6),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_CALI_FROM_EFUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ADC_BGRCALI_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ADC_AUXCALI_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_TRMPL_CALI),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_TRMPH_CALI),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_SIGN_BGRL),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_SIGN_BGRH),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_SIGN_AUX),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV7),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_VBG12),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_VAUX18),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_IMP_EN),
	PMIC_ENTRY(PMIC_AUXADC_IMP_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_IMP_CNT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_CHSEL),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_IRQ_STATUS),
	PMIC_ENTRY(PMIC_AUXADC_IMP_START),
	PMIC_ENTRY(PMIC_AUXADC_IMP_STATE),
	PMIC_ENTRY(PMIC_AUXADC_IMP_COUNT),
	PMIC_ENTRY(PMIC_AUXADC_IMP_FGADC_R_S),
	PMIC_ENTRY(PMIC_FGADC_AUXADC_IMP_R_DONE_S),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP_AVG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_IMP_AVG),
	PMIC_ENTRY(PMIC_AUXADC_IMP_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_IMP_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_IMP),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBT_MAX_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBT_MIN_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_STATE),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_EN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_FROZE_EN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBT_MAX_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBT_MIN_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_VOLT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DET_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_VOLT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DET_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_STATE),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBT_MAX_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBT_MIN_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_VOLT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DET_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_VOLT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DET_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_STATE),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_LBAT2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_LBAT2),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_LBAT2),
	PMIC_ENTRY(PMIC_AUXADC_THR_EN),
	PMIC_ENTRY(PMIC_AUXADC_THR_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBT_MAX_SEL),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBT_MIN_SEL),
	PMIC_ENTRY(PMIC_AUXADC_THR_VOLT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_DET_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_THR_VOLT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_DET_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_STATE),
	PMIC_ENTRY(PMIC_AUXADC_THR_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_THR_HW),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_THR_HW),
	PMIC_ENTRY(PMIC_AUXADC_THR_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_THR_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR_HW),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_CNT),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_CLR),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_SRCLKEN_IND),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_STATE),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_START),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_RSV_1RSV0),
	PMIC_ENTRY(PMIC_AUXADC_NEW_PRIORITY_LIST_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SAMPLE_LIST_15_0),
	PMIC_ENTRY(PMIC_AUXADC_SAMPLE_LIST_31_16),
	PMIC_ENTRY(PMIC_AUXADC_SAMPLE_LIST_33_32),
	PMIC_ENTRY(PMIC_BUCK_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_CBS),
	PMIC_ENTRY(PMIC_BUCK_TOP_BIX),
	PMIC_ENTRY(PMIC_BUCK_TOP_ESP),
	PMIC_ENTRY(PMIC_BUCK_TOP_FPI),
	PMIC_ENTRY(PMIC_BUCK_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_BUCK_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_BUCK_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_BUCK_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_ANA_2M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK1M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK_SLEEP_CTRL_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_VPU_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VGPU11_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VGPU12_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMODEM_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VPROC1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VPROC2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VS2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VPA_OC),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_EN_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_EN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VPU_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VGPU11_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VGPU12_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMODEM_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VPROC1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VPROC2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VS2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VPA_OC),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VPU_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VGPU11_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VGPU12_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMODEM_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VPROC1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VPROC2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VS2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VPA_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VPU_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VGPU11_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VGPU12_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMODEM_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VPROC1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VPROC2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VS2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VPA_OC),
	PMIC_ENTRY(PMIC_RG_VOW_BUCK_VCORE_DVS_DONE),
	PMIC_ENTRY(PMIC_RG_VOW_BUCK_VCORE_DVS_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_STB_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_VGP2_MINFREQ_LATENCY_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_VGP2_MINFREQ_DURATION_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MINFREQ_LATENCY_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MINFREQ_DURATION_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_BUCK_TOP_WRITE_KEY),
	PMIC_ENTRY(PMIC_BUCK_VPU_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VCORE_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS1_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS2_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VPA_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_TOP_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_DCM_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_BUCK_VPU_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VPU_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VPU_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPU_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPU_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPU_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VPU_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_OP_MODE_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_OP_MODE_CLR),
	PMIC_ENTRY(PMIC_DA_VPU_VOSEL),
	PMIC_ENTRY(PMIC_DA_VPU_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VPU_EN),
	PMIC_ENTRY(PMIC_DA_VPU_STB),
	PMIC_ENTRY(PMIC_DA_VPU_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VPU_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VPU_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VPU_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VPU_SSH),
	PMIC_ENTRY(PMIC_DA_VPU_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_CK_SW_EN),
	PMIC_ENTRY(PMIC_BUCK_VPU_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPU_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_MODE_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_MODE_CLR),
	PMIC_ENTRY(PMIC_DA_VCORE_VOSEL),
	PMIC_ENTRY(PMIC_DA_VCORE_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VCORE_EN),
	PMIC_ENTRY(PMIC_DA_VCORE_STB),
	PMIC_ENTRY(PMIC_DA_VCORE_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VCORE_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VCORE_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VCORE_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VCORE_SSH),
	PMIC_ENTRY(PMIC_DA_VCORE_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SSHUB_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SSHUB_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SPI_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SPI_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_BT_LP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_BT_LP_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_TRACK_STALL_BYPASS),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_OP_MODE_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_OP_MODE_CLR),
	PMIC_ENTRY(PMIC_DA_VGPU11_VOSEL),
	PMIC_ENTRY(PMIC_DA_VGPU11_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VGPU11_EN),
	PMIC_ENTRY(PMIC_DA_VGPU11_STB),
	PMIC_ENTRY(PMIC_DA_VGPU11_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VGPU11_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VGPU11_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VGPU11_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VGPU11_SSH),
	PMIC_ENTRY(PMIC_DA_VGPU11_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_CK_SW_EN),
	PMIC_ENTRY(PMIC_BUCK_VGPU11_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU11_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_OP_MODE_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_OP_MODE_CLR),
	PMIC_ENTRY(PMIC_DA_VGPU12_VOSEL),
	PMIC_ENTRY(PMIC_DA_VGPU12_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VGPU12_EN),
	PMIC_ENTRY(PMIC_DA_VGPU12_STB),
	PMIC_ENTRY(PMIC_DA_VGPU12_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VGPU12_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VGPU12_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VGPU12_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VGPU12_SSH),
	PMIC_ENTRY(PMIC_DA_VGPU12_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_CK_SW_EN),
	PMIC_ENTRY(PMIC_BUCK_VGPU12_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VGPU12_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_MODE_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_OP_MODE_CLR),
	PMIC_ENTRY(PMIC_DA_VMODEM_VOSEL),
	PMIC_ENTRY(PMIC_DA_VMODEM_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VMODEM_EN),
	PMIC_ENTRY(PMIC_DA_VMODEM_STB),
	PMIC_ENTRY(PMIC_DA_VMODEM_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VMODEM_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VMODEM_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VMODEM_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VMODEM_SSH),
	PMIC_ENTRY(PMIC_DA_VMODEM_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_TRACK_STALL_BYPASS),
	PMIC_ENTRY(PMIC_BUCK_VMODEM_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMODEM_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_OP_MODE_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_OP_MODE_CLR),
	PMIC_ENTRY(PMIC_DA_VPROC1_VOSEL),
	PMIC_ENTRY(PMIC_DA_VPROC1_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VPROC1_EN),
	PMIC_ENTRY(PMIC_DA_VPROC1_STB),
	PMIC_ENTRY(PMIC_DA_VPROC1_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VPROC1_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VPROC1_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VPROC1_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VPROC1_SSH),
	PMIC_ENTRY(PMIC_DA_VPROC1_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_TRACK_STALL_BYPASS),
	PMIC_ENTRY(PMIC_BUCK_VPROC1_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC1_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_OP_MODE_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_OP_MODE_CLR),
	PMIC_ENTRY(PMIC_DA_VPROC2_VOSEL),
	PMIC_ENTRY(PMIC_DA_VPROC2_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VPROC2_EN),
	PMIC_ENTRY(PMIC_DA_VPROC2_STB),
	PMIC_ENTRY(PMIC_DA_VPROC2_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VPROC2_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VPROC2_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VPROC2_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VPROC2_SSH),
	PMIC_ENTRY(PMIC_DA_VPROC2_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_TRACK_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_TRACK_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_VOSEL_DELTA),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_VOSEL_OFFSET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_VOSEL_LB),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_VOSEL_HB),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_TRACK_STALL_BYPASS),
	PMIC_ENTRY(PMIC_BUCK_VPROC2_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPROC2_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS1_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VS1_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VS1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_MODE_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_MODE_CLR),
	PMIC_ENTRY(PMIC_DA_VS1_VOSEL),
	PMIC_ENTRY(PMIC_DA_VS1_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VS1_EN),
	PMIC_ENTRY(PMIC_DA_VS1_STB),
	PMIC_ENTRY(PMIC_DA_VS1_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VS1_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VS1_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VS1_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VS1_SSH),
	PMIC_ENTRY(PMIC_DA_VS1_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS1_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS2_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VS2_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VS2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_MODE_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_MODE_CLR),
	PMIC_ENTRY(PMIC_DA_VS2_VOSEL),
	PMIC_ENTRY(PMIC_DA_VS2_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VS2_EN),
	PMIC_ENTRY(PMIC_DA_VS2_STB),
	PMIC_ENTRY(PMIC_DA_VS2_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VS2_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VS2_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VS2_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VS2_SSH),
	PMIC_ENTRY(PMIC_DA_VS2_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS2_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VPA_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VPA_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VPA_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPA_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPA_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPA_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VPA_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DVS_DOWN_CTRL),
	PMIC_ENTRY(PMIC_DA_VPA_VOSEL),
	PMIC_ENTRY(PMIC_DA_VPA_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VPA_EN),
	PMIC_ENTRY(PMIC_DA_VPA_STB),
	PMIC_ENTRY(PMIC_DA_VPA_DVS_TRANST),
	PMIC_ENTRY(PMIC_DA_VPA_DVS_BW),
	PMIC_ENTRY(PMIC_DA_VPA_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VPA_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL_DLC011),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL_DLC111),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_VOSEL_DLC001),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DLC_MAP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_DLC),
	PMIC_ENTRY(PMIC_DA_VPA_DLC),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RDELTA2GO),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FDELTA2GO),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE0),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE1),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE2),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE3),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE4),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RRATE5),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD0),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD1),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD2),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD3),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_RTHD4),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE0),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE1),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE2),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE3),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE4),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FRATE5),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD0),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD1),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD2),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD3),
	PMIC_ENTRY(PMIC_RG_BUCK_VPA_MSFG_FTHD4),
	PMIC_ENTRY(PMIC_BUCK_ANA0_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_SMPS_TESTMODE_B),
	PMIC_ENTRY(PMIC_RG_AUTOK_RST),
	PMIC_ENTRY(PMIC_RG_SMPS_DISAUTOK),
	PMIC_ENTRY(PMIC_RG_VGPU11_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VGPU11_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU11_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU11_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VGPU11_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VGPU11_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_URT_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VGPU11_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VGPU11_OCP),
	PMIC_ENTRY(PMIC_RG_VGPU11_OCN),
	PMIC_ENTRY(PMIC_RG_VGPU11_FUGON),
	PMIC_ENTRY(PMIC_RG_VGPU11_FLGON),
	PMIC_ENTRY(PMIC_RG_VGPU11_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VGPU11_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VGPU11_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VGPU11_UG_SR),
	PMIC_ENTRY(PMIC_RG_VGPU11_LG_SR),
	PMIC_ENTRY(PMIC_RG_VGPU11_FCCM),
	PMIC_ENTRY(PMIC_RG_VGPU11_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_RSVH),
	PMIC_ENTRY(PMIC_RG_VGPU11_RSVL),
	PMIC_ENTRY(PMIC_RGS_VGPU11_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VGPU11_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VGPU11_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VGPU11_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU11_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU11_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU11_RCB),
	PMIC_ENTRY(PMIC_RG_VGPU11_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VGPU11_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_DAC_VREF_1P1V_EN),
	PMIC_ENTRY(PMIC_RG_VGPU11_DAC_VREF_1P2V_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VGPU12_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU12_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU12_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VGPU12_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VGPU12_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_URT_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VGPU12_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VGPU12_OCP),
	PMIC_ENTRY(PMIC_RG_VGPU12_OCN),
	PMIC_ENTRY(PMIC_RG_VGPU12_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VGPU12_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VGPU12_FLGON),
	PMIC_ENTRY(PMIC_RG_VGPU12_FUGON),
	PMIC_ENTRY(PMIC_RG_VGPU12_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VGPU12_UG_SR),
	PMIC_ENTRY(PMIC_RG_VGPU12_LG_SR),
	PMIC_ENTRY(PMIC_RG_VGPU12_FCCM),
	PMIC_ENTRY(PMIC_RG_VGPU12_RSVH),
	PMIC_ENTRY(PMIC_RG_VGPU12_RSVL),
	PMIC_ENTRY(PMIC_RG_VGPU12_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_RETENTION_EN),
	PMIC_ENTRY(PMIC_RGS_VGPU12_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VGPU12_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VGPU12_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VGPU12_RCB),
	PMIC_ENTRY(PMIC_RG_VGPU12_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU12_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU12_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VGPU12_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VGPU12_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_DAC_VREF_1P1V_EN),
	PMIC_ENTRY(PMIC_RG_VGPU12_DAC_VREF_1P2V_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VCORE_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VCORE_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VCORE_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_URT_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VCORE_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VCORE_OCP),
	PMIC_ENTRY(PMIC_RG_VCORE_OCN),
	PMIC_ENTRY(PMIC_RG_VCORE_FUGON),
	PMIC_ENTRY(PMIC_RG_VCORE_FLGON),
	PMIC_ENTRY(PMIC_RG_VCORE_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VCORE_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VCORE_UG_SR),
	PMIC_ENTRY(PMIC_RG_VCORE_LG_SR),
	PMIC_ENTRY(PMIC_RG_VCORE_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VCORE_FCCM),
	PMIC_ENTRY(PMIC_RG_VCORE_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_RSVH),
	PMIC_ENTRY(PMIC_RG_VCORE_RSVL),
	PMIC_ENTRY(PMIC_RGS_VCORE_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VCORE_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VCORE_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_TMDL),
	PMIC_ENTRY(PMIC_RG_VCORE_RCB),
	PMIC_ENTRY(PMIC_RG_VCORE_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VCORE_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_DAC_VREF_1P1V_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_DAC_VREF_1P2V_EN),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_DIFF_L),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_SR_VBAT),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_CONFIG_LAT_RSVH),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_RECONFIG_RSVH),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_RECONFIG_EN),
	PMIC_ENTRY(PMIC_RGS_3PH1_VGPU11_DIGCFG_EN),
	PMIC_ENTRY(PMIC_RGS_3PH2_VCORE_DIGCFG_EN),
	PMIC_ENTRY(PMIC_RGS_3PH3_VGPU12_DIGCFG_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_SR_VBAT),
	PMIC_ENTRY(PMIC_RG_VPROC1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VPROC1_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC1_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VPROC1_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC1_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VPROC1_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VPROC1_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_URT_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VPROC1_OCN),
	PMIC_ENTRY(PMIC_RG_VPROC1_OCP),
	PMIC_ENTRY(PMIC_RG_VPROC1_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VPROC1_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RGS_VPROC1_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VPROC1_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VPROC1_UG_SR),
	PMIC_ENTRY(PMIC_RG_VPROC1_LG_SR),
	PMIC_ENTRY(PMIC_RG_VPROC1_TMDL),
	PMIC_ENTRY(PMIC_RG_VPROC1_FUGON),
	PMIC_ENTRY(PMIC_RG_VPROC1_FLGON),
	PMIC_ENTRY(PMIC_RG_VPROC1_FCCM),
	PMIC_ENTRY(PMIC_RG_VPROC1_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VPROC1_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VPROC1_RSVH),
	PMIC_ENTRY(PMIC_RG_VPROC1_RSVL),
	PMIC_ENTRY(PMIC_RG_VPROC1_RCB),
	PMIC_ENTRY(PMIC_RG_VPROC1_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC1_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC1_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC1_DAC_VREF_1P1V_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_DAC_VREF_1P2V_EN),
	PMIC_ENTRY(PMIC_RG_VPROC1_VDIFF_OFF),
	PMIC_ENTRY(PMIC_BUCK_ANA0_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VGPU11_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU11_CCOMP),
	PMIC_ENTRY(PMIC_RG_VGPU11_RCOMP),
	PMIC_ENTRY(PMIC_RG_VGPU11_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VGPU11_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU12_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU12_CCOMP),
	PMIC_ENTRY(PMIC_RG_VGPU12_RCOMP),
	PMIC_ENTRY(PMIC_RG_VGPU12_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VGPU12_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CCOMP),
	PMIC_ENTRY(PMIC_RG_VCORE_RCOMP),
	PMIC_ENTRY(PMIC_RG_VCORE_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VCORE_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU11_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU11_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU12_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU12_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU11_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU12_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_PHIN_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC1_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC1_CCOMP),
	PMIC_ENTRY(PMIC_RG_VPROC1_RCOMP),
	PMIC_ENTRY(PMIC_RG_VPROC1_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VPROC1_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC1_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC1_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC1_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_TRIMH),
	PMIC_ENTRY(PMIC_RG_VS2_TRIMH),
	PMIC_ENTRY(PMIC_RG_VGPU11_TRIMH),
	PMIC_ENTRY(PMIC_RG_VGPU12_TRIMH),
	PMIC_ENTRY(PMIC_RG_VPROC2_TRIMH),
	PMIC_ENTRY(PMIC_RG_VPROC1_TRIMH),
	PMIC_ENTRY(PMIC_RG_VCORE_TRIMH),
	PMIC_ENTRY(PMIC_RG_VMODEM_TRIMH),
	PMIC_ENTRY(PMIC_RG_VPA_TRIMH),
	PMIC_ENTRY(PMIC_RG_VPU_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_TRIMH),
	PMIC_ENTRY(PMIC_RG_VGPU11_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPU12_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_PH2_OFF),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_PH3_OFF),
	PMIC_ENTRY(PMIC_RG_VGPUVCORE_PG_FB3),
	PMIC_ENTRY(PMIC_RG_VPROC1_TON_TRIM),
	PMIC_ENTRY(PMIC_BUCK_ANA1_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_VPROC2_SR_VBAT),
	PMIC_ENTRY(PMIC_RG_VPROC2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VPROC2_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC2_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VPROC2_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC2_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VPROC2_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VPROC2_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_URT_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VPROC2_OCN),
	PMIC_ENTRY(PMIC_RG_VPROC2_OCP),
	PMIC_ENTRY(PMIC_RG_VPROC2_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VPROC2_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RGS_VPROC2_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VPROC2_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VPROC2_UG_SR),
	PMIC_ENTRY(PMIC_RG_VPROC2_LG_SR),
	PMIC_ENTRY(PMIC_RG_VPROC2_TMDL),
	PMIC_ENTRY(PMIC_RG_VPROC2_FUGON),
	PMIC_ENTRY(PMIC_RG_VPROC2_FLGON),
	PMIC_ENTRY(PMIC_RG_VPROC2_FCCM),
	PMIC_ENTRY(PMIC_RG_VPROC2_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VPROC2_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VPROC2_RSVH),
	PMIC_ENTRY(PMIC_RG_VPROC2_RSVL),
	PMIC_ENTRY(PMIC_RG_VPROC2_RCB),
	PMIC_ENTRY(PMIC_RG_VPROC2_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC2_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC2_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VPROC2_DAC_VREF_1P1V_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_DAC_VREF_1P2V_EN),
	PMIC_ENTRY(PMIC_RG_VPROC2_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VMODEM_SR_VBAT),
	PMIC_ENTRY(PMIC_RG_VMODEM_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VMODEM_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VMODEM_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VMODEM_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VMODEM_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VMODEM_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VMODEM_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_URT_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VMODEM_OCN),
	PMIC_ENTRY(PMIC_RG_VMODEM_OCP),
	PMIC_ENTRY(PMIC_RG_VMODEM_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VMODEM_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RGS_VMODEM_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMODEM_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VMODEM_UG_SR),
	PMIC_ENTRY(PMIC_RG_VMODEM_LG_SR),
	PMIC_ENTRY(PMIC_RG_VMODEM_TMDL),
	PMIC_ENTRY(PMIC_RG_VMODEM_FUGON),
	PMIC_ENTRY(PMIC_RG_VMODEM_FLGON),
	PMIC_ENTRY(PMIC_RG_VMODEM_FCCM),
	PMIC_ENTRY(PMIC_RG_VMODEM_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VMODEM_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VMODEM_RSVH),
	PMIC_ENTRY(PMIC_RG_VMODEM_RSVL),
	PMIC_ENTRY(PMIC_RG_VMODEM_RCB),
	PMIC_ENTRY(PMIC_RG_VMODEM_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VMODEM_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VMODEM_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VMODEM_DAC_VREF_1P1V_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_DAC_VREF_1P2V_EN),
	PMIC_ENTRY(PMIC_RG_VMODEM_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VPU_SR_VBAT),
	PMIC_ENTRY(PMIC_RG_VPU_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VPU_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VPU_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VPU_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VPU_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VPU_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VPU_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VPU_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VPU_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VPU_URT_EN),
	PMIC_ENTRY(PMIC_RG_VPU_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VPU_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VPU_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VPU_OCN),
	PMIC_ENTRY(PMIC_RG_VPU_OCP),
	PMIC_ENTRY(PMIC_RG_VPU_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VPU_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RGS_VPU_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VPU_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VPU_UG_SR),
	PMIC_ENTRY(PMIC_RG_VPU_LG_SR),
	PMIC_ENTRY(PMIC_RG_VPU_TMDL),
	PMIC_ENTRY(PMIC_RG_VPU_FUGON),
	PMIC_ENTRY(PMIC_RG_VPU_FLGON),
	PMIC_ENTRY(PMIC_RG_VPU_FCCM),
	PMIC_ENTRY(PMIC_RG_VPU_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VPU_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VPU_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VPU_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VPU_RSVH),
	PMIC_ENTRY(PMIC_RG_VPU_RSVL),
	PMIC_ENTRY(PMIC_RG_VPU_RCB),
	PMIC_ENTRY(PMIC_RG_VPU_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VPU_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VPU_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VPU_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VPU_DAC_VREF_1P1V_EN),
	PMIC_ENTRY(PMIC_RG_VPU_DAC_VREF_1P2V_EN),
	PMIC_ENTRY(PMIC_RG_VPU_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VS1_TON_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS1_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VS1_FPWM),
	PMIC_ENTRY(PMIC_RG_VS1_PFM_TON),
	PMIC_ENTRY(PMIC_RG_VS1_VREF_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS1_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VS1_NLIM_GATING),
	PMIC_ENTRY(PMIC_RG_VS1_VREFUP),
	PMIC_ENTRY(PMIC_RG_VS1_TB_WIDTH),
	PMIC_ENTRY(PMIC_RG_VS1_VDIFFPFMOFF),
	PMIC_ENTRY(PMIC_RG_VS1_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VS1_UG_SR),
	PMIC_ENTRY(PMIC_RG_VS1_LG_SR),
	PMIC_ENTRY(PMIC_RG_VS1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VS1_TMDL),
	PMIC_ENTRY(PMIC_RG_VS1_CMPV_FCOT),
	PMIC_ENTRY(PMIC_RG_VS1_RSV1),
	PMIC_ENTRY(PMIC_RG_VS1_RSV2),
	PMIC_ENTRY(PMIC_RG_VS1_FUGON),
	PMIC_ENTRY(PMIC_RG_VS1_FLGON),
	PMIC_ENTRY(PMIC_RGS_VS1_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VS1_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VS1_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VS1_OCP),
	PMIC_ENTRY(PMIC_RG_VS1_OCN),
	PMIC_ENTRY(PMIC_RG_VS1_SONIC_PFM_TON),
	PMIC_ENTRY(PMIC_RG_VS1_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VS1_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VS2_TON_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS2_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VS2_FPWM),
	PMIC_ENTRY(PMIC_RG_VS2_PFM_TON),
	PMIC_ENTRY(PMIC_RG_VS2_VREF_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS2_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VS2_NLIM_GATING),
	PMIC_ENTRY(PMIC_RG_VS2_VREFUP),
	PMIC_ENTRY(PMIC_RG_VS2_TB_WIDTH),
	PMIC_ENTRY(PMIC_RG_VS2_VDIFFPFMOFF),
	PMIC_ENTRY(PMIC_RG_VS2_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VS2_UG_SR),
	PMIC_ENTRY(PMIC_RG_VS2_LG_SR),
	PMIC_ENTRY(PMIC_RG_VS2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VS2_TMDL),
	PMIC_ENTRY(PMIC_RG_VS2_CMPV_FCOT),
	PMIC_ENTRY(PMIC_RG_VS2_RSV1),
	PMIC_ENTRY(PMIC_RG_VS2_RSV2),
	PMIC_ENTRY(PMIC_RG_VS2_FUGON),
	PMIC_ENTRY(PMIC_RG_VS2_FLGON),
	PMIC_ENTRY(PMIC_RGS_VS2_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VS2_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VS2_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VS2_OCP),
	PMIC_ENTRY(PMIC_RG_VS2_OCN),
	PMIC_ENTRY(PMIC_RG_VS2_SONIC_PFM_TON),
	PMIC_ENTRY(PMIC_RG_VS2_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VS2_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VPA_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VPA_MODESET),
	PMIC_ENTRY(PMIC_RG_VPA_CC),
	PMIC_ENTRY(PMIC_RG_VPA_CSR),
	PMIC_ENTRY(PMIC_RG_VPA_CSMIR),
	PMIC_ENTRY(PMIC_RG_VPA_CSL),
	PMIC_ENTRY(PMIC_RG_VPA_SLP),
	PMIC_ENTRY(PMIC_RG_VPA_ZXFT_L),
	PMIC_ENTRY(PMIC_RG_VPA_CP_FWUPOFF),
	PMIC_ENTRY(PMIC_RG_VPA_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VPA_RZSEL),
	PMIC_ENTRY(PMIC_RG_VPA_SLEW),
	PMIC_ENTRY(PMIC_RG_VPA_SLEW_NMOS),
	PMIC_ENTRY(PMIC_RG_VPA_MIN_ON),
	PMIC_ENTRY(PMIC_RG_VPA_BURST_SEL),
	PMIC_ENTRY(PMIC_RG_VPA_ZC),
	PMIC_ENTRY(PMIC_RG_VPA_RSV1),
	PMIC_ENTRY(PMIC_RG_VPA_RSV2),
	PMIC_ENTRY(PMIC_RGS_VPA_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VPA_AZC_ZX),
	PMIC_ENTRY(PMIC_RGS_VPA_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VPA_PFM_DLC1_VTH),
	PMIC_ENTRY(PMIC_RG_VPA_PFM_DLC2_VTH),
	PMIC_ENTRY(PMIC_RG_VPA_PFM_DLC3_VTH),
	PMIC_ENTRY(PMIC_RG_VPA_PFM_DLC4_VTH),
	PMIC_ENTRY(PMIC_RG_VPA_ZXFT_H),
	PMIC_ENTRY(PMIC_RG_VPA_DECODE_TMB),
	PMIC_ENTRY(PMIC_RG_VPA_RSV3),
	PMIC_ENTRY(PMIC_BUCK_ANA1_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VPROC2_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC2_CCOMP),
	PMIC_ENTRY(PMIC_RG_VPROC2_RCOMP),
	PMIC_ENTRY(PMIC_RG_VPROC2_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VPROC2_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC2_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC2_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC2_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_CCOMP),
	PMIC_ENTRY(PMIC_RG_VMODEM_RCOMP),
	PMIC_ENTRY(PMIC_RG_VMODEM_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VMODEM_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VPU_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VPU_CCOMP),
	PMIC_ENTRY(PMIC_RG_VPU_RCOMP),
	PMIC_ENTRY(PMIC_RG_VPU_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VPU_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VPU_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VPU_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VPU_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_CCOMP),
	PMIC_ENTRY(PMIC_RG_VS1_RCOMP),
	PMIC_ENTRY(PMIC_RG_VS1_COTRAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VS1_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_LDO_SENSE),
	PMIC_ENTRY(PMIC_RG_VS1_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_CCOMP),
	PMIC_ENTRY(PMIC_RG_VS2_RCOMP),
	PMIC_ENTRY(PMIC_RG_VS2_COTRAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VS2_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_LDO_SENSE),
	PMIC_ENTRY(PMIC_RG_VS2_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VPROC2_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VMODEM_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VPU_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VPA_NLIM_SEL),
	PMIC_ENTRY(PMIC_LDO_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_CBS),
	PMIC_ENTRY(PMIC_LDO_TOP_BIX),
	PMIC_ENTRY(PMIC_LDO_TOP_ESP),
	PMIC_ENTRY(PMIC_LDO_TOP_FPI),
	PMIC_ENTRY(PMIC_LDO_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_LDO_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_LDO_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_LDO_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_LDO_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_LDO_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_LDO_1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_LDO_26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_LDO_32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_LDO_INTRP_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_LDO_1M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_LDO_26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_LDO_DCM_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_INT_EN_VFE28_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRF12_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCN33_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCN33_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCN13_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VA09_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCAMIO_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VA12_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VAUD18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VIO18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_PROC1_OC),
	PMIC_ENTRY(PMIC_LDO_INT_CON0_SET),
	PMIC_ENTRY(PMIC_LDO_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_PROC2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_OTHERS_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_MD_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VUSB_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRFCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VBBCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VBIF28_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VIBR_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VIO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VM18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VUFS_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VFE28_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRF12_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCN33_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCN33_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCN13_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VA09_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCAMIO_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VA12_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VAUD18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VIO18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_PROC1_OC),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_PROC2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_OTHERS_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_MD_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VUSB_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRFCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VBBCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VBIF28_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VIBR_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VIO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VM18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VUFS_OC),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON1_SET),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VFE28_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRF12_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCN33_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCN33_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCN13_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VA09_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCAMIO_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VA12_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VAUD18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VIO18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_PROC1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_PROC2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_OTHERS_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_MD_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VUSB_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRFCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VBBCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VBIF28_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VIBR_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VIO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VM18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VUFS_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VFE28_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRF12_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCN33_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCN33_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCN13_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VA09_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCAMIO_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VA12_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VAUD18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VIO18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_PROC1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_PROC2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_OTHERS_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_MD_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VUSB_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRFCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VBBCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VBIF28_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VIBR_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VIO28_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VM18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VUFS_OC),
	PMIC_ENTRY(PMIC_RG_LDO_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_INT_FLAG_EN),
	PMIC_ENTRY(PMIC_RG_LDO_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_WDT_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_DUMMY_LOAD_GATED_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_LP_PROT_DISABLE),
	PMIC_ENTRY(PMIC_RG_LDO_SLEEP_CTRL_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_TOP_RSV1),
	PMIC_ENTRY(PMIC_RG_LDO_TOP_RSV0),
	PMIC_ENTRY(PMIC_RG_VRTC28_EN),
	PMIC_ENTRY(PMIC_DA_VRTC28_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_OFF_ACKTIME_SEL),
	PMIC_ENTRY(PMIC_RG_VAUX18_LP_ACKTIME_SEL),
	PMIC_ENTRY(PMIC_RG_VBIF28_OFF_ACKTIME_SEL),
	PMIC_ENTRY(PMIC_RG_VBIF28_LP_ACKTIME_SEL),
	PMIC_ENTRY(PMIC_RG_VOW_LDO_VSRAM_CORE_DVS_DONE),
	PMIC_ENTRY(PMIC_RG_VOW_LDO_VSRAM_CORE_DVS_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_EN_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_EN_TEST),
	PMIC_ENTRY(PMIC_LDO_TOP_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_ANA_SEL),
	PMIC_ENTRY(PMIC_LDO_GNR0_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR0_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR0_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR0_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR0_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VFE28_B_EN),
	PMIC_ENTRY(PMIC_DA_VFE28_B_STB),
	PMIC_ENTRY(PMIC_DA_VFE28_B_LP),
	PMIC_ENTRY(PMIC_DA_VFE28_L_EN),
	PMIC_ENTRY(PMIC_DA_VFE28_L_STB),
	PMIC_ENTRY(PMIC_DA_VFE28_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VFE28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VFE28_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VXO22_B_EN),
	PMIC_ENTRY(PMIC_DA_VXO22_B_STB),
	PMIC_ENTRY(PMIC_DA_VXO22_B_LP),
	PMIC_ENTRY(PMIC_DA_VXO22_L_EN),
	PMIC_ENTRY(PMIC_DA_VXO22_L_STB),
	PMIC_ENTRY(PMIC_DA_VXO22_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VXO22_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VRF18_B_EN),
	PMIC_ENTRY(PMIC_DA_VRF18_B_STB),
	PMIC_ENTRY(PMIC_DA_VRF18_B_LP),
	PMIC_ENTRY(PMIC_DA_VRF18_L_EN),
	PMIC_ENTRY(PMIC_DA_VRF18_L_STB),
	PMIC_ENTRY(PMIC_DA_VRF18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VRF18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VRF12_B_EN),
	PMIC_ENTRY(PMIC_DA_VRF12_B_STB),
	PMIC_ENTRY(PMIC_DA_VRF12_B_LP),
	PMIC_ENTRY(PMIC_DA_VRF12_L_EN),
	PMIC_ENTRY(PMIC_DA_VRF12_L_STB),
	PMIC_ENTRY(PMIC_DA_VRF12_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VRF12_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF12_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VEFUSE_B_EN),
	PMIC_ENTRY(PMIC_DA_VEFUSE_B_STB),
	PMIC_ENTRY(PMIC_DA_VEFUSE_B_LP),
	PMIC_ENTRY(PMIC_DA_VEFUSE_L_EN),
	PMIC_ENTRY(PMIC_DA_VEFUSE_L_STB),
	PMIC_ENTRY(PMIC_DA_VEFUSE_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VEFUSE_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_EN_0),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VCN33_1_B_EN),
	PMIC_ENTRY(PMIC_DA_VCN33_1_B_STB),
	PMIC_ENTRY(PMIC_DA_VCN33_1_B_LP),
	PMIC_ENTRY(PMIC_DA_VCN33_1_L_EN),
	PMIC_ENTRY(PMIC_DA_VCN33_1_L_STB),
	PMIC_ENTRY(PMIC_DA_VCN33_1_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCN33_1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_1_EN_1),
	PMIC_ENTRY(PMIC_LDO_GNR1_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR1_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR1_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR1_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR1_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_EN_0),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VCN33_2_B_EN),
	PMIC_ENTRY(PMIC_DA_VCN33_2_B_STB),
	PMIC_ENTRY(PMIC_DA_VCN33_2_B_LP),
	PMIC_ENTRY(PMIC_DA_VCN33_2_L_EN),
	PMIC_ENTRY(PMIC_DA_VCN33_2_L_STB),
	PMIC_ENTRY(PMIC_DA_VCN33_2_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCN33_2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN33_2_EN_1),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VCN13_B_EN),
	PMIC_ENTRY(PMIC_DA_VCN13_B_STB),
	PMIC_ENTRY(PMIC_DA_VCN13_B_LP),
	PMIC_ENTRY(PMIC_DA_VCN13_L_EN),
	PMIC_ENTRY(PMIC_DA_VCN13_L_STB),
	PMIC_ENTRY(PMIC_DA_VCN13_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCN13_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN13_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VCN18_B_EN),
	PMIC_ENTRY(PMIC_DA_VCN18_B_STB),
	PMIC_ENTRY(PMIC_DA_VCN18_B_LP),
	PMIC_ENTRY(PMIC_DA_VCN18_L_EN),
	PMIC_ENTRY(PMIC_DA_VCN18_L_STB),
	PMIC_ENTRY(PMIC_DA_VCN18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCN18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VA09_B_EN),
	PMIC_ENTRY(PMIC_DA_VA09_B_STB),
	PMIC_ENTRY(PMIC_DA_VA09_B_LP),
	PMIC_ENTRY(PMIC_DA_VA09_L_EN),
	PMIC_ENTRY(PMIC_DA_VA09_L_STB),
	PMIC_ENTRY(PMIC_DA_VA09_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VA09_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA09_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VCAMIO_B_EN),
	PMIC_ENTRY(PMIC_DA_VCAMIO_B_STB),
	PMIC_ENTRY(PMIC_DA_VCAMIO_B_LP),
	PMIC_ENTRY(PMIC_DA_VCAMIO_L_EN),
	PMIC_ENTRY(PMIC_DA_VCAMIO_L_STB),
	PMIC_ENTRY(PMIC_DA_VCAMIO_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCAMIO_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCAMIO_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VA12_B_EN),
	PMIC_ENTRY(PMIC_DA_VA12_B_STB),
	PMIC_ENTRY(PMIC_DA_VA12_B_LP),
	PMIC_ENTRY(PMIC_DA_VA12_L_EN),
	PMIC_ENTRY(PMIC_DA_VA12_L_STB),
	PMIC_ENTRY(PMIC_DA_VA12_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VA12_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_LDO_GNR2_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR2_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR2_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR2_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR2_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR2_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VAUX18_B_EN),
	PMIC_ENTRY(PMIC_DA_VAUX18_B_STB),
	PMIC_ENTRY(PMIC_DA_VAUX18_B_LP),
	PMIC_ENTRY(PMIC_DA_VAUX18_L_EN),
	PMIC_ENTRY(PMIC_DA_VAUX18_L_STB),
	PMIC_ENTRY(PMIC_DA_VAUX18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VAUX18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VAUD18_B_EN),
	PMIC_ENTRY(PMIC_DA_VAUD18_B_STB),
	PMIC_ENTRY(PMIC_DA_VAUD18_B_LP),
	PMIC_ENTRY(PMIC_DA_VAUD18_L_EN),
	PMIC_ENTRY(PMIC_DA_VAUD18_L_STB),
	PMIC_ENTRY(PMIC_DA_VAUD18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VAUD18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUD18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VIO18_B_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_B_STB),
	PMIC_ENTRY(PMIC_DA_VIO18_B_LP),
	PMIC_ENTRY(PMIC_DA_VIO18_L_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_L_STB),
	PMIC_ENTRY(PMIC_DA_VIO18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VEMC_B_EN),
	PMIC_ENTRY(PMIC_DA_VEMC_B_STB),
	PMIC_ENTRY(PMIC_DA_VEMC_B_LP),
	PMIC_ENTRY(PMIC_DA_VEMC_L_EN),
	PMIC_ENTRY(PMIC_DA_VEMC_L_STB),
	PMIC_ENTRY(PMIC_DA_VEMC_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VEMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSIM1_B_EN),
	PMIC_ENTRY(PMIC_DA_VSIM1_B_STB),
	PMIC_ENTRY(PMIC_DA_VSIM1_B_LP),
	PMIC_ENTRY(PMIC_DA_VSIM1_L_EN),
	PMIC_ENTRY(PMIC_DA_VSIM1_L_STB),
	PMIC_ENTRY(PMIC_DA_VSIM1_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSIM1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSIM2_B_EN),
	PMIC_ENTRY(PMIC_DA_VSIM2_B_STB),
	PMIC_ENTRY(PMIC_DA_VSIM2_B_LP),
	PMIC_ENTRY(PMIC_DA_VSIM2_L_EN),
	PMIC_ENTRY(PMIC_DA_VSIM2_L_STB),
	PMIC_ENTRY(PMIC_DA_VSIM2_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSIM2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_LDO_GNR3_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR3_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR3_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR3_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR3_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR3_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR3_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR3_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR3_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR3_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_EN_0),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VUSB_B_EN),
	PMIC_ENTRY(PMIC_DA_VUSB_B_STB),
	PMIC_ENTRY(PMIC_DA_VUSB_B_LP),
	PMIC_ENTRY(PMIC_DA_VUSB_L_EN),
	PMIC_ENTRY(PMIC_DA_VUSB_L_STB),
	PMIC_ENTRY(PMIC_DA_VUSB_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VUSB_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_EN_1),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VRFCK_B_EN),
	PMIC_ENTRY(PMIC_DA_VRFCK_B_STB),
	PMIC_ENTRY(PMIC_DA_VRFCK_B_LP),
	PMIC_ENTRY(PMIC_DA_VRFCK_L_EN),
	PMIC_ENTRY(PMIC_DA_VRFCK_L_STB),
	PMIC_ENTRY(PMIC_DA_VRFCK_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VRFCK_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VBBCK_B_EN),
	PMIC_ENTRY(PMIC_DA_VBBCK_B_STB),
	PMIC_ENTRY(PMIC_DA_VBBCK_B_LP),
	PMIC_ENTRY(PMIC_DA_VBBCK_L_EN),
	PMIC_ENTRY(PMIC_DA_VBBCK_L_STB),
	PMIC_ENTRY(PMIC_DA_VBBCK_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VBBCK_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VBIF28_B_EN),
	PMIC_ENTRY(PMIC_DA_VBIF28_B_STB),
	PMIC_ENTRY(PMIC_DA_VBIF28_B_LP),
	PMIC_ENTRY(PMIC_DA_VBIF28_L_EN),
	PMIC_ENTRY(PMIC_DA_VBIF28_L_STB),
	PMIC_ENTRY(PMIC_DA_VBIF28_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VBIF28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VIBR_B_EN),
	PMIC_ENTRY(PMIC_DA_VIBR_B_STB),
	PMIC_ENTRY(PMIC_DA_VIBR_B_LP),
	PMIC_ENTRY(PMIC_DA_VIBR_L_EN),
	PMIC_ENTRY(PMIC_DA_VIBR_L_STB),
	PMIC_ENTRY(PMIC_DA_VIBR_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VIBR_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIBR_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VIO28_B_EN),
	PMIC_ENTRY(PMIC_DA_VIO28_B_STB),
	PMIC_ENTRY(PMIC_DA_VIO28_B_LP),
	PMIC_ENTRY(PMIC_DA_VIO28_L_EN),
	PMIC_ENTRY(PMIC_DA_VIO28_L_STB),
	PMIC_ENTRY(PMIC_DA_VIO28_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VIO28_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO28_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_LDO_GNR4_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR4_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR4_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR4_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR4_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR4_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR4_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR4_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR4_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR4_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VM18_B_EN),
	PMIC_ENTRY(PMIC_DA_VM18_B_STB),
	PMIC_ENTRY(PMIC_DA_VM18_B_LP),
	PMIC_ENTRY(PMIC_DA_VM18_L_EN),
	PMIC_ENTRY(PMIC_DA_VM18_L_STB),
	PMIC_ENTRY(PMIC_DA_VM18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VM18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VM18_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VUFS_B_EN),
	PMIC_ENTRY(PMIC_DA_VUFS_B_STB),
	PMIC_ENTRY(PMIC_DA_VUFS_B_LP),
	PMIC_ENTRY(PMIC_DA_VUFS_L_EN),
	PMIC_ENTRY(PMIC_DA_VUFS_L_STB),
	PMIC_ENTRY(PMIC_DA_VUFS_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VUFS_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUFS_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_LDO_GNR5_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR5_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR5_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR5_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR5_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR5_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR5_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR5_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR5_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR5_DSN_FPI),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_R2R_PDN_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_B_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_B_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_B_LP),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_L_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_L_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_TRACK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_LDO_VSRAM_PROC1_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC1_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_DVS_TRANS_TD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_DVS_TRANS_CTRL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_DVS_TRANS_ONCE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_TRACK_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_TRACK_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_VOSEL_DELTA),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_VOSEL_OFFSET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_VOSEL_LB),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC1_VOSEL_HB),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_R2R_PDN_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_B_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_B_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_B_LP),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_L_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_L_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_TRACK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_LDO_VSRAM_PROC2_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC2_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_DVS_TRANS_TD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_DVS_TRANS_CTRL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_DVS_TRANS_ONCE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_TRACK_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_TRACK_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_VOSEL_DELTA),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_VOSEL_OFFSET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_VOSEL_LB),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC2_VOSEL_HB),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_R2R_PDN_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_B_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_B_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_B_LP),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_L_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_L_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_TRACK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_LDO_VSRAM_OTHERS_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_OTHERS_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_TD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_CTRL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_DVS_TRANS_ONCE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_TRACK_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_TRACK_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_DELTA),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_OFFSET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_LB),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_VOSEL_HB),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SSHUB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SSHUB_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SSHUB_SLEEP_VOSEL_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SSHUB_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_BT_LP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_BT_LP_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SPI_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_OTHERS_SPI_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_R2R_PDN_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_B_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_B_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_B_LP),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_L_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_L_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_TRACK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_LDO_VSRAM_MD_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_DVS_TRANS_TD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_DVS_TRANS_CTRL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_DVS_TRANS_ONCE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_OP_CFG_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_OP_CFG_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_TRACK_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_TRACK_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_VOSEL_DELTA),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_VOSEL_OFFSET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_VOSEL_LB),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_MD_VOSEL_HB),
	PMIC_ENTRY(PMIC_LDO_ANA0_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_ANA0_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_ANA0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_ANA0_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_ANA0_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_ANA0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_VFE28_VOCAL),
	PMIC_ENTRY(PMIC_RG_VFE28_VOSEL),
	PMIC_ENTRY(PMIC_RG_VFE28_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VFE28_RSV_1),
	PMIC_ENTRY(PMIC_RG_VFE28_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VFE28_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VFE28_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VFE28_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VFE28_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VAUX18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VAUX18_VOSEL),
	PMIC_ENTRY(PMIC_RG_VAUX18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_RSV_1),
	PMIC_ENTRY(PMIC_RG_VAUX18_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VAUX18_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VUSB_VOCAL),
	PMIC_ENTRY(PMIC_RG_VUSB_VOSEL),
	PMIC_ENTRY(PMIC_RG_VUSB_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VUSB_RSV_1),
	PMIC_ENTRY(PMIC_RG_VUSB_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VUSB_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VUSB_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VUSB_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VUSB_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VBIF28_VOCAL),
	PMIC_ENTRY(PMIC_RG_VBIF28_VOSEL),
	PMIC_ENTRY(PMIC_RG_VBIF28_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VBIF28_RSV_1),
	PMIC_ENTRY(PMIC_RG_VBIF28_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VBIF28_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VBIF28_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VBIF28_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VBIF28_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VCN33_1_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCN33_1_VOSEL),
	PMIC_ENTRY(PMIC_RG_VCN33_1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCN33_1_RSV_0),
	PMIC_ENTRY(PMIC_RG_VCN33_1_RSV_1),
	PMIC_ENTRY(PMIC_RG_VCN33_1_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VCN33_1_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VCN33_1_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VCN33_1_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VCN33_1_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VCN33_2_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCN33_2_VOSEL),
	PMIC_ENTRY(PMIC_RG_VCN33_2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCN33_2_RSV_0),
	PMIC_ENTRY(PMIC_RG_VCN33_2_RSV_1),
	PMIC_ENTRY(PMIC_RG_VCN33_2_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VCN33_2_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VCN33_2_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VCN33_2_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VCN33_2_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VEMC_VOCAL),
	PMIC_ENTRY(PMIC_RG_VEMC_VOSEL),
	PMIC_ENTRY(PMIC_RG_VEMC_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VEMC_RSV_0),
	PMIC_ENTRY(PMIC_RG_VEMC_RSV_1),
	PMIC_ENTRY(PMIC_RG_VEMC_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VEMC_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VEMC_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VEMC_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VEMC_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSIM1_VOCAL),
	PMIC_ENTRY(PMIC_RG_VSIM1_VOSEL),
	PMIC_ENTRY(PMIC_RG_VSIM1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSIM1_RSV_1),
	PMIC_ENTRY(PMIC_RG_VSIM1_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSIM1_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSIM1_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSIM1_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSIM1_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSIM2_VOCAL),
	PMIC_ENTRY(PMIC_RG_VSIM2_VOSEL),
	PMIC_ENTRY(PMIC_RG_VSIM2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSIM2_RSV_1),
	PMIC_ENTRY(PMIC_RG_VSIM2_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSIM2_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSIM2_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSIM2_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSIM2_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VIO28_VOCAL),
	PMIC_ENTRY(PMIC_RG_VIO28_VOSEL),
	PMIC_ENTRY(PMIC_RG_VIO28_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VIO28_RSV_1),
	PMIC_ENTRY(PMIC_RG_VIO28_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VIO28_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VIO28_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VIO28_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VIO28_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VIBR_VOCAL),
	PMIC_ENTRY(PMIC_RG_VIBR_VOSEL),
	PMIC_ENTRY(PMIC_RG_VIBR_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VIBR_RSV_1),
	PMIC_ENTRY(PMIC_RG_VIBR_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VIBR_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VIBR_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VIBR_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VIBR_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_ADLDO_RSV),
	PMIC_ENTRY(PMIC_LDO_ANA0_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VFE28_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VAUX18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VUSB_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VBIF28_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN33_1_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN33_1_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VCN33_2_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN33_2_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VEMC_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VEMC_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VSIM1_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VSIM1_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VSIM2_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VSIM2_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VIO28_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VIBR_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VIBR_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VRTC28_BIAS_SEL),
	PMIC_ENTRY(PMIC_LDO_ANA1_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_ANA1_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_ANA1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_ANA1_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_ANA1_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_ANA1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_VRF18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VRF18_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRF18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRF18_RSV_0),
	PMIC_ENTRY(PMIC_RG_VRF18_RSV_1),
	PMIC_ENTRY(PMIC_RG_VRF18_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VRF18_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VRF18_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VRF18_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VRF18_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VOCAL),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VOSEL),
	PMIC_ENTRY(PMIC_RG_VEFUSE_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VEFUSE_RSV_1),
	PMIC_ENTRY(PMIC_RG_VEFUSE_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VEFUSE_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VEFUSE_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VEFUSE_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VEFUSE_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VCN18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCN18_VOSEL),
	PMIC_ENTRY(PMIC_RG_VCN18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCN18_RSV_1),
	PMIC_ENTRY(PMIC_RG_VCN18_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VCN18_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VCN18_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VCN18_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VCN18_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VCAMIO_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCAMIO_VOSEL),
	PMIC_ENTRY(PMIC_RG_VCAMIO_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCAMIO_RSV_1),
	PMIC_ENTRY(PMIC_RG_VCAMIO_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VCAMIO_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VCAMIO_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VCAMIO_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VCAMIO_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VAUD18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VAUD18_VOSEL),
	PMIC_ENTRY(PMIC_RG_VAUD18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VAUD18_RSV_1),
	PMIC_ENTRY(PMIC_RG_VAUD18_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VAUD18_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VAUD18_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VAUD18_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VAUD18_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VIO18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VIO18_VOSEL),
	PMIC_ENTRY(PMIC_RG_VIO18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_RSV_1),
	PMIC_ENTRY(PMIC_RG_VIO18_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VIO18_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VM18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VM18_VOSEL),
	PMIC_ENTRY(PMIC_RG_VM18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VM18_RSV_1),
	PMIC_ENTRY(PMIC_RG_VM18_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VM18_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VM18_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VM18_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VM18_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VUFS_VOCAL),
	PMIC_ENTRY(PMIC_RG_VUFS_VOSEL),
	PMIC_ENTRY(PMIC_RG_VUFS_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VUFS_RSV_1),
	PMIC_ENTRY(PMIC_RG_VUFS_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VUFS_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VUFS_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VUFS_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VUFS_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_SLDO20_RSV),
	PMIC_ENTRY(PMIC_RG_VRF12_VOCAL),
	PMIC_ENTRY(PMIC_RG_VRF12_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRF12_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRF12_RSV_0),
	PMIC_ENTRY(PMIC_RG_VRF12_RSV_1),
	PMIC_ENTRY(PMIC_RG_VRF12_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VRF12_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VRF12_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VRF12_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VRF12_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VCN13_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCN13_VOSEL),
	PMIC_ENTRY(PMIC_RG_VCN13_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCN13_RSV_0),
	PMIC_ENTRY(PMIC_RG_VCN13_RSV_1),
	PMIC_ENTRY(PMIC_RG_VCN13_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VCN13_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VCN13_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VCN13_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VCN13_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VA09_VOCAL),
	PMIC_ENTRY(PMIC_RG_VA09_VOSEL),
	PMIC_ENTRY(PMIC_RG_VA09_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VA09_RSV_1),
	PMIC_ENTRY(PMIC_RG_VA09_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VA09_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VA09_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VA09_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VA09_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VA12_VOCAL),
	PMIC_ENTRY(PMIC_RG_VA12_VOSEL),
	PMIC_ENTRY(PMIC_RG_VA12_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VA12_RSV_1),
	PMIC_ENTRY(PMIC_RG_VA12_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VA12_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VA12_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VA12_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VA12_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_NDIS_PLCUR),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_RSV_H),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_RSV_L),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC1_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSRAM_PROC1_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_NDIS_PLCUR),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_RSV_H),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_RSV_L),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC2_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSRAM_PROC2_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_NDIS_PLCUR),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_RSV_H),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_RSV_L),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_OTHERS_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSRAM_OTHERS_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_NDIS_PLCUR),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RSV_H),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RSV_L),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSRAM_MD_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_SLDO14_RSV),
	PMIC_ENTRY(PMIC_LDO_ANA1_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VRF18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN18_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VCAMIO_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VAUD18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VIO18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VM18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VUFS_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VUFS_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VRF12_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN13_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VA09_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VA12_VOTRIM),
	PMIC_ENTRY(PMIC_LDO_ANA2_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_ANA2_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_ANA2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA2_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_ANA2_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_ANA2_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_ANA2_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_VXO22_VOCAL),
	PMIC_ENTRY(PMIC_RG_VXO22_VOSEL),
	PMIC_ENTRY(PMIC_RG_VXO22_RSV_1),
	PMIC_ENTRY(PMIC_RG_VXO22_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VXO22_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VXO22_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VXO22_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VXO22_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VRFCK_VOCAL),
	PMIC_ENTRY(PMIC_RG_VRFCK_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRFCK_RSV_1),
	PMIC_ENTRY(PMIC_RG_VRFCK_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VRFCK_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_VOCAL),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_RSV_1),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VRFCK_1_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VBBCK_VOCAL),
	PMIC_ENTRY(PMIC_RG_VBBCK_VOSEL),
	PMIC_ENTRY(PMIC_RG_VBBCK_RSV_1),
	PMIC_ENTRY(PMIC_RG_VBBCK_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VBBCK_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VBBCK_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VBBCK_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VBBCK_OC_STATUS),
	PMIC_ENTRY(PMIC_LDO_ANA2_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VXO22_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VXO22_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VRFCK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VRFCK_1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VBBCK_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VBBCK_NDIS_EN),
	PMIC_ENTRY(PMIC_DUMMYLOAD_ANA_ID),
	PMIC_ENTRY(PMIC_DUMMYLOAD_DIG_ID),
	PMIC_ENTRY(PMIC_DUMMYLOAD_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_DUMMYLOAD_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_DUMMYLOAD_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_DUMMYLOAD_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_DUMMYLOAD_DSN_CBS),
	PMIC_ENTRY(PMIC_DUMMYLOAD_DSN_BIX),
	PMIC_ENTRY(PMIC_DUMMYLOAD_DSN_ESP),
	PMIC_ENTRY(PMIC_DUMMYLOAD_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_ISINK_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_ISINK_TRIM_SEL),
	PMIC_ENTRY(PMIC_RG_ISINK_RSV),
	PMIC_ENTRY(PMIC_RG_ISINK0_CHOP_EN),
	PMIC_ENTRY(PMIC_RG_ISINK1_CHOP_EN),
	PMIC_ENTRY(PMIC_RG_ISINK0_DOUBLE),
	PMIC_ENTRY(PMIC_RG_ISINK1_DOUBLE),
	PMIC_ENTRY(PMIC_ISINK0_RSV1),
	PMIC_ENTRY(PMIC_ISINK0_RSV0),
	PMIC_ENTRY(PMIC_ISINK_CH0_STEP),
	PMIC_ENTRY(PMIC_ISINK1_RSV1),
	PMIC_ENTRY(PMIC_ISINK1_RSV0),
	PMIC_ENTRY(PMIC_ISINK_CH1_STEP),
	PMIC_ENTRY(PMIC_AD_ISINK0_STATUS),
	PMIC_ENTRY(PMIC_AD_ISINK1_STATUS),
	PMIC_ENTRY(PMIC_ISINK_CH1_EN),
	PMIC_ENTRY(PMIC_ISINK_CH0_EN),
	PMIC_ENTRY(PMIC_ISINK_CHOP1_EN),
	PMIC_ENTRY(PMIC_ISINK_CHOP0_EN),
	PMIC_ENTRY(PMIC_ISINK_CH1_BIAS_EN),
	PMIC_ENTRY(PMIC_ISINK_CH0_BIAS_EN),
	PMIC_ENTRY(PMIC_DUMMYLOAD_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_ISINK_TRIM_BIAS),
	PMIC_ENTRY(PMIC_AUD_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_AUD_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_AUD_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUD_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUD_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUD_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUD_TOP_CBS),
	PMIC_ENTRY(PMIC_AUD_TOP_BIX),
	PMIC_ENTRY(PMIC_AUD_TOP_ESP),
	PMIC_ENTRY(PMIC_AUD_TOP_FPI),
	PMIC_ENTRY(PMIC_AUD_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_AUD_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_AUD_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_AUD_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_ACCDET_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUD_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUDIF_CK_PDN),
	PMIC_ENTRY(PMIC_RG_ZCD13M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUDNCP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PAD_AUD_CLK_MISO_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUD_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_VOW32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_VOW13M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_AUD_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_AUDIF_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_CKSEL_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_CKSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_AUD26M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_AUD_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUDIF_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUD26M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_VOW13M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_VOW13M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUD_INTRP_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUD_INTRP_CK_PND_HWEN_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_INTRP_CLK_PDN_HWEN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_AUDIO_RST),
	PMIC_ENTRY(PMIC_RG_ACCDET_RST),
	PMIC_ENTRY(PMIC_RG_ZCD_RST),
	PMIC_ENTRY(PMIC_RG_AUDNCP_RST),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_BANK_ACCDET_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUDIO_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUDZCD_SWRST),
	PMIC_ENTRY(PMIC_RG_INT_EN_AUDIO),
	PMIC_ENTRY(PMIC_RG_INT_EN_ACCDET),
	PMIC_ENTRY(PMIC_RG_INT_EN_ACCDET_EINT0),
	PMIC_ENTRY(PMIC_RG_INT_EN_ACCDET_EINT1),
	PMIC_ENTRY(PMIC_RG_AUD_INT_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_AUDIO),
	PMIC_ENTRY(PMIC_RG_INT_MASK_ACCDET),
	PMIC_ENTRY(PMIC_RG_INT_MASK_ACCDET_EINT0),
	PMIC_ENTRY(PMIC_RG_INT_MASK_ACCDET_EINT1),
	PMIC_ENTRY(PMIC_RG_AUD_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_RG_AUD_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_AUDIO),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_ACCDET),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_ACCDET_EINT0),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_ACCDET_EINT1),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_AUDIO),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_ACCDET),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_ACCDET_EINT0),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_ACCDET_EINT1),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_INT_POLARITY),
	PMIC_ENTRY(PMIC_RG_AUD_TOP_MON_SEL),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_INT_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_AUD_CLK_INT_MON_FLAG_EN),
	PMIC_ENTRY(PMIC_AUDIO_DIG_ANA_ID),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DIG_ID),
	PMIC_ENTRY(PMIC_AUDIO_DIG_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDIO_DIG_1_ESP),
	PMIC_ENTRY(PMIC_AUDIO_DIG_DSN_FPI),
	PMIC_ENTRY(PMIC_AFE_ON),
	PMIC_ENTRY(PMIC_AFE_DL_LR_SWAP),
	PMIC_ENTRY(PMIC_AFE_UL_LR_SWAP),
	PMIC_ENTRY(PMIC_DL_2_SRC_ON_TMP_CTL_PRE),
	PMIC_ENTRY(PMIC_C_TWO_DIGITAL_MIC_CTL),
	PMIC_ENTRY(PMIC_C_DIGMIC_PHASE_SEL_CH2_CTL),
	PMIC_ENTRY(PMIC_C_DIGMIC_PHASE_SEL_CH1_CTL),
	PMIC_ENTRY(PMIC_UL_SRC_ON_TMP_CTL),
	PMIC_ENTRY(PMIC_UL_SDM_3_LEVEL_CTL),
	PMIC_ENTRY(PMIC_UL_LOOP_BACK_MODE_CTL),
	PMIC_ENTRY(PMIC_DIGMIC_3P25M_1P625M_SEL_CTL),
	PMIC_ENTRY(PMIC_DIGMIC_4P33M_SEL_CTL),
	PMIC_ENTRY(PMIC_DMIC_LOW_POWER_MODE_CTL),
	PMIC_ENTRY(PMIC_ADDA6_C_TWO_DIGITAL_MIC_CTL),
	PMIC_ENTRY(PMIC_ADDA6_C_DIGMIC_PHASE_SEL_CH2_CTL),
	PMIC_ENTRY(PMIC_ADDA6_C_DIGMIC_PHASE_SEL_CH1_CTL),
	PMIC_ENTRY(PMIC_ADDA6_UL_SRC_ON_TMP_CTL),
	PMIC_ENTRY(PMIC_ADDA6_UL_SDM_3_LEVEL_CTL),
	PMIC_ENTRY(PMIC_ADDA6_UL_LOOP_BACK_MODE_CTL),
	PMIC_ENTRY(PMIC_ADDA6_DIGMIC_3P25M_1P625M_SEL_CTL),
	PMIC_ENTRY(PMIC_ADDA6_DIGMIC_4P33M_SEL_CTL),
	PMIC_ENTRY(PMIC_ADDA6_DMIC_LOW_POWER_MODE_CTL),
	PMIC_ENTRY(PMIC_DL_SINE_ON),
	PMIC_ENTRY(PMIC_UL_SINE_ON),
	PMIC_ENTRY(PMIC_MTKAIF_SINE_ON),
	PMIC_ENTRY(PMIC_ADDA6_UL_SINE_ON),
	PMIC_ENTRY(PMIC_ADDA6_MTKAIF_SINE_ON),
	PMIC_ENTRY(PMIC_PDN_RESERVED),
	PMIC_ENTRY(PMIC_PDN_AFE_TESTMODEL_CTL),
	PMIC_ENTRY(PMIC_PWR_CLK_DIS_CTL),
	PMIC_ENTRY(PMIC_PDN_I2S_DL_CTL),
	PMIC_ENTRY(PMIC_PDN_ADDA6_ADC_CTL),
	PMIC_ENTRY(PMIC_PDN_ADC_CTL),
	PMIC_ENTRY(PMIC_PDN_DAC_CTL),
	PMIC_ENTRY(PMIC_PDN_AFE_CTL),
	PMIC_ENTRY(PMIC_AFE_MON_SEL),
	PMIC_ENTRY(PMIC_AUDIO_SYS_TOP_MON_SEL),
	PMIC_ENTRY(PMIC_AUDIO_SYS_TOP_MON_SWAP),
	PMIC_ENTRY(PMIC_CCI_SCRAMBLER_EN),
	PMIC_ENTRY(PMIC_CCI_AUD_SDM_7BIT_SEL),
	PMIC_ENTRY(PMIC_CCI_AUD_SDM_MUTER),
	PMIC_ENTRY(PMIC_CCI_AUD_SDM_MUTEL),
	PMIC_ENTRY(PMIC_CCI_AUD_SPLIT_TEST_EN),
	PMIC_ENTRY(PMIC_CCI_ZERO_PAD_DISABLE),
	PMIC_ENTRY(PMIC_CCI_AUD_IDAC_TEST_EN),
	PMIC_ENTRY(PMIC_CCI_SPLT_SCRMB_ON),
	PMIC_ENTRY(PMIC_CCI_SPLT_SCRMB_CLK_ON),
	PMIC_ENTRY(PMIC_CCI_RAND_EN),
	PMIC_ENTRY(PMIC_CCI_LCH_INV),
	PMIC_ENTRY(PMIC_CCI_SCRAMBLER_CG_EN),
	PMIC_ENTRY(PMIC_CCI_AUDIO_FIFO_WPTR),
	PMIC_ENTRY(PMIC_CCI_AUD_ANACK_SEL),
	PMIC_ENTRY(PMIC_AUD_SDM_TEST_R),
	PMIC_ENTRY(PMIC_AUD_SDM_TEST_L),
	PMIC_ENTRY(PMIC_CCI_ACD_FUNC_RSTB),
	PMIC_ENTRY(PMIC_CCI_AFIFO_CLK_PWDB),
	PMIC_ENTRY(PMIC_CCI_ACD_MODE),
	PMIC_ENTRY(PMIC_CCI_AUDIO_FIFO_ENABLE),
	PMIC_ENTRY(PMIC_CCI_AUDIO_FIFO_CLKIN_INV),
	PMIC_ENTRY(PMIC_CCI_AUD_DAC_ANA_RSTB_SEL),
	PMIC_ENTRY(PMIC_CCI_AUD_DAC_ANA_MUTE),
	PMIC_ENTRY(PMIC_DIGMIC_TESTCK_SEL),
	PMIC_ENTRY(PMIC_DIGMIC_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_SDM_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_SDM_ANA13M_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_SDM_ANA13M_TESTCK_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WCLK_6P5M_TESTCK_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WDATA_TESTSRC_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WDATA_TESTEN),
	PMIC_ENTRY(PMIC_UL_FIFO_DIGMIC_WDATA_TESTSRC_SEL),
	PMIC_ENTRY(PMIC_UL_FIFO_WCLK_INV),
	PMIC_ENTRY(PMIC_R_AUD_DAC_NEG_LARGE_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_POS_LARGE_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_SW_RSTB),
	PMIC_ENTRY(PMIC_R_AUD_DAC_3TH_SEL),
	PMIC_ENTRY(PMIC_R_AUD_DAC_MONO_SEL),
	PMIC_ENTRY(PMIC_R_AUD_DAC_NEG_TINY_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_POS_TINY_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_NEG_SMALL_MONO),
	PMIC_ENTRY(PMIC_R_AUD_DAC_POS_SMALL_MONO),
	PMIC_ENTRY(PMIC_UL2_FIFO_WCLK_6P5M_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_UL2_FIFO_WCLK_6P5M_TESTCK_SEL),
	PMIC_ENTRY(PMIC_UL2_FIFO_WDATA_TESTSRC_SEL),
	PMIC_ENTRY(PMIC_UL2_FIFO_WDATA_TESTEN),
	PMIC_ENTRY(PMIC_UL2_FIFO_DIGMIC_WDATA_TESTSRC_SEL),
	PMIC_ENTRY(PMIC_UL2_FIFO_WCLK_INV),
	PMIC_ENTRY(PMIC_UL2_DIGMIC_TESTCK_SEL),
	PMIC_ENTRY(PMIC_UL2_DIGMIC_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_SPLITTER1_DITHER_GAIN),
	PMIC_ENTRY(PMIC_SPLITTER2_DITHER_GAIN),
	PMIC_ENTRY(PMIC_SPLITTER1_DITHER_EN),
	PMIC_ENTRY(PMIC_SPLITTER2_DITHER_EN),
	PMIC_ENTRY(PMIC_CCI_SCRAMBLER_EN_2ND),
	PMIC_ENTRY(PMIC_CCI_AUD_SDM_7BIT_SEL_2ND),
	PMIC_ENTRY(PMIC_CCI_AUD_SDM_MUTER_2ND),
	PMIC_ENTRY(PMIC_CCI_AUD_SDM_MUTEL_2ND),
	PMIC_ENTRY(PMIC_CCI_AUD_SPLIT_TEST_EN_2ND),
	PMIC_ENTRY(PMIC_CCI_ZERO_PAD_DISABLE_2ND),
	PMIC_ENTRY(PMIC_CCI_AUD_IDAC_TEST_EN_2ND),
	PMIC_ENTRY(PMIC_CCI_SPLT_SCRMB_ON_2ND),
	PMIC_ENTRY(PMIC_CCI_SPLT_SCRMB_CLK_ON_2ND),
	PMIC_ENTRY(PMIC_CCI_RAND_EN_2ND),
	PMIC_ENTRY(PMIC_CCI_LCH_INV_2ND),
	PMIC_ENTRY(PMIC_CCI_SCRAMBLER_CG_EN_2ND),
	PMIC_ENTRY(PMIC_CCI_AUDIO_FIFO_WPTR_2ND),
	PMIC_ENTRY(PMIC_CCI_AUD_ANACK_SEL_2ND),
	PMIC_ENTRY(PMIC_AUD_SDM_TEST_R_2ND),
	PMIC_ENTRY(PMIC_AUD_SDM_TEST_L_2ND),
	PMIC_ENTRY(PMIC_CCI_ACD_FUNC_RSTB_2ND),
	PMIC_ENTRY(PMIC_CCI_AFIFO_CLK_PWDB_2ND),
	PMIC_ENTRY(PMIC_CCI_ACD_MODE_2ND),
	PMIC_ENTRY(PMIC_CCI_AUDIO_FIFO_ENABLE_2ND),
	PMIC_ENTRY(PMIC_CCI_AUDIO_FIFO_CLKIN_INV_2ND),
	PMIC_ENTRY(PMIC_CCI_AUD_DAC_ANA_RSTB_SEL_2ND),
	PMIC_ENTRY(PMIC_CCI_AUD_DAC_ANA_MUTE_2ND),
	PMIC_ENTRY(PMIC_SPLITTER1_DITHER_GAIN_2ND),
	PMIC_ENTRY(PMIC_SPLITTER2_DITHER_GAIN_2ND),
	PMIC_ENTRY(PMIC_SPLITTER1_DITHER_EN_2ND),
	PMIC_ENTRY(PMIC_SPLITTER2_DITHER_EN_2ND),
	PMIC_ENTRY(PMIC_AUD_SCR_OUT_R),
	PMIC_ENTRY(PMIC_AUD_SCR_OUT_L),
	PMIC_ENTRY(PMIC_AUD_SCR_OUT_R_2ND),
	PMIC_ENTRY(PMIC_AUD_SCR_OUT_L_2ND),
	PMIC_ENTRY(PMIC_RGS_AUDRCTUNE0READ),
	PMIC_ENTRY(PMIC_RGS_AUDRCTUNE1READ),
	PMIC_ENTRY(PMIC_ASYNC_TEST_OUT_BCK),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_FIFO_INTEN),
	PMIC_ENTRY(PMIC_AFE_RESERVED),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_RD_EMPTY_STATUS),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_WR_FULL_STATUS),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_FIFO_STATUS),
	PMIC_ENTRY(PMIC_MTKAIFTX_V3_SDATA_OUT1),
	PMIC_ENTRY(PMIC_MTKAIFTX_V3_SDATA_OUT2),
	PMIC_ENTRY(PMIC_MTKAIFTX_V3_SDATA_OUT3),
	PMIC_ENTRY(PMIC_MTKAIFTX_V3_SYNC_OUT),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_INVALID_CYCLE),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_INVALID_FLAG),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_SEARCH_FAIL_FLAG),
	PMIC_ENTRY(PMIC_MTKAIFRX_V3_SDATA_IN1),
	PMIC_ENTRY(PMIC_MTKAIFRX_V3_SDATA_IN2),
	PMIC_ENTRY(PMIC_MTKAIFRX_V3_SDATA_IN3),
	PMIC_ENTRY(PMIC_MTKAIFRX_V3_SYNC_IN),
	PMIC_ENTRY(PMIC_MTKAIF_TXIF_IN_CH1),
	PMIC_ENTRY(PMIC_MTKAIF_TXIF_IN_CH2),
	PMIC_ENTRY(PMIC_ADDA6_MTKAIF_TXIF_IN_CH1),
	PMIC_ENTRY(PMIC_ADDA6_MTKAIF_TXIF_IN_CH2),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_OUT_CH1),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_OUT_CH2),
	PMIC_ENTRY(PMIC_MTKAIF_RXIF_OUT_CH3),
	PMIC_ENTRY(PMIC_RG_MTKAIF_LOOPBACK_TEST1),
	PMIC_ENTRY(PMIC_RG_MTKAIF_LOOPBACK_TEST2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_PMIC_TXIF_8TO5),
	PMIC_ENTRY(PMIC_RG_ADDA6_MTKAIF_PMIC_TXIF_8TO5),
	PMIC_ENTRY(PMIC_RG_MTKAIF_TXIF_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_BYPASS_SRC_TEST),
	PMIC_ENTRY(PMIC_RG_MTKAIF_BYPASS_SRC_MODE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_ADDA6_MTKAIF_TXIF_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_CLKINV),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_DATA_MODE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_DETECT_ON),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_FIFO_RSP),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_DATA_BIT),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_VOICE_MODE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_VOICE_MODE_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_SYNC_CHECK_ROUND),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_INVALID_SYNC_CHECK_ROUND),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_SYNC_SEARCH_TABLE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_SYNC_CNT_TABLE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_CLEAR_SYNC_FAIL),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_SYNC_WORD1_DISABLE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_SYNC_WORD2_DISABLE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_P2_INPUT_SEL),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_DETECT_ON_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_FIFO_RSP_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RXIF_LOOPBACK_USE_NLE),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RX_SYNC_WORD1),
	PMIC_ENTRY(PMIC_RG_MTKAIF_RX_SYNC_WORD2),
	PMIC_ENTRY(PMIC_RG_ADDA_MTKAIF_TX_SYNC_WORD1),
	PMIC_ENTRY(PMIC_RG_ADDA_MTKAIF_TX_SYNC_WORD2),
	PMIC_ENTRY(PMIC_RG_ADDA6_MTKAIF_TX_SYNC_WORD1),
	PMIC_ENTRY(PMIC_RG_ADDA6_MTKAIF_TX_SYNC_WORD2),
	PMIC_ENTRY(PMIC_R_AUD_SDM_MUTE_R_2ND),
	PMIC_ENTRY(PMIC_R_AUD_SDM_MUTE_L_2ND),
	PMIC_ENTRY(PMIC_R_AUD_SDM_MUTE_R),
	PMIC_ENTRY(PMIC_R_AUD_SDM_MUTE_L),
	PMIC_ENTRY(PMIC_C_MUTE_SW_CTL),
	PMIC_ENTRY(PMIC_C_DAC_EN_CTL),
	PMIC_ENTRY(PMIC_C_AMP_DIV_CH1_CTL),
	PMIC_ENTRY(PMIC_C_FREQ_DIV_CH1_CTL),
	PMIC_ENTRY(PMIC_C_SGEN_RCH_INV_8BIT),
	PMIC_ENTRY(PMIC_C_SGEN_RCH_INV_5BIT),
	PMIC_ENTRY(PMIC_RG_AMIC_UL_ADC_CLK_SEL),
	PMIC_ENTRY(PMIC_RG_UL_ASYNC_FIFO_SOFT_RST),
	PMIC_ENTRY(PMIC_RG_UL_ASYNC_FIFO_SOFT_RST_EN),
	PMIC_ENTRY(PMIC_RG_UL2_ASYNC_FIFO_SOFT_RST),
	PMIC_ENTRY(PMIC_RG_UL2_ASYNC_FIFO_SOFT_RST_EN),
	PMIC_ENTRY(PMIC_DCCLK_GEN_ON),
	PMIC_ENTRY(PMIC_DCCLK_PDN),
	PMIC_ENTRY(PMIC_DCCLK_REF_CK_SEL),
	PMIC_ENTRY(PMIC_DCCLK_INV),
	PMIC_ENTRY(PMIC_DCCLK_DIV),
	PMIC_ENTRY(PMIC_DCCLK_PHASE_SEL),
	PMIC_ENTRY(PMIC_DCCLK_RESYNC_BYPASS),
	PMIC_ENTRY(PMIC_RESYNC_SRC_CK_INV),
	PMIC_ENTRY(PMIC_RESYNC_SRC_SEL),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_PHASE_MODE),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_DAT_MISO_LOOPBACK),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_PHASE_MODE2),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_DAT_MISO2_LOOPBACK),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_PHASE_MODE3),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_DAT_MISO3_LOOPBACK),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_TX_FIFO_ON),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_MTKAIF_CLK_PROTOCOL2),
	PMIC_ENTRY(PMIC_RG_AUD_PAD_TOP_TX_FIFO_RSP),
	PMIC_ENTRY(PMIC_ADDA_AUD_PAD_TOP_MON),
	PMIC_ENTRY(PMIC_ADDA_AUD_PAD_TOP_MON1),
	PMIC_ENTRY(PMIC_ADDA_AUD_PAD_TOP_MON2),
	PMIC_ENTRY(PMIC_NLE_LCH_ON),
	PMIC_ENTRY(PMIC_NLE_LCH_CH_SEL),
	PMIC_ENTRY(PMIC_NLE_LCH_HPGAIN_SEL),
	PMIC_ENTRY(PMIC_NLE_RCH_ON),
	PMIC_ENTRY(PMIC_NLE_RCH_CH_SEL),
	PMIC_ENTRY(PMIC_NLE_RCH_HPGAIN_SEL),
	PMIC_ENTRY(PMIC_NLE_MONITOR),
	PMIC_ENTRY(PMIC_CK_CG_EN_MON),
	PMIC_ENTRY(PMIC_RG_DMIC_ADC3_SOURCE_SEL),
	PMIC_ENTRY(PMIC_RG_DMIC_ADC2_SOURCE_SEL),
	PMIC_ENTRY(PMIC_RG_DMIC_ADC1_SOURCE_SEL),
	PMIC_ENTRY(PMIC_RG_AMIC_ADC3_SOURCE_SEL),
	PMIC_ENTRY(PMIC_RG_AMIC_ADC2_SOURCE_SEL),
	PMIC_ENTRY(PMIC_RG_AMIC_ADC1_SOURCE_SEL),
	PMIC_ENTRY(PMIC_RG_CHOP_DIV_EN),
	PMIC_ENTRY(PMIC_RG_CHOP_DIV_SEL),
	PMIC_ENTRY(PMIC_RG_ADDA_CH1_SEL),
	PMIC_ENTRY(PMIC_RG_ADDA_CH2_SEL),
	PMIC_ENTRY(PMIC_RG_ADDA_EN_SEL),
	PMIC_ENTRY(PMIC_RG_ADDA6_CH1_SEL),
	PMIC_ENTRY(PMIC_RG_ADDA6_CH2_SEL),
	PMIC_ENTRY(PMIC_RG_ADDA6_EN_SEL),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2ND_ANA_ID),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2ND_DIG_ID),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2ND_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2ND_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2ND_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2ND_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2ND_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2ND_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2_ESP),
	PMIC_ENTRY(PMIC_AUDIO_DIG_2ND_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_UP8X_SYNC_WORD),
	PMIC_ENTRY(PMIC_RG_VOW_INTR_MODE_SEL),
	PMIC_ENTRY(PMIC_VOW_INTR_SW_VAL),
	PMIC_ENTRY(PMIC_VOW_INTR_SW_MODE),
	PMIC_ENTRY(PMIC_VOW_LOOP_BACK_MODE),
	PMIC_ENTRY(PMIC_VOW_SDM_3_LEVEL),
	PMIC_ENTRY(PMIC_VOW_CIC_MODE_SEL),
	PMIC_ENTRY(PMIC_MAIN_DMIC_CK_VOW_SEL),
	PMIC_ENTRY(PMIC_VOW_DMIC_CK_SEL),
	PMIC_ENTRY(PMIC_PDN_VOW),
	PMIC_ENTRY(PMIC_VOW_ON_CH1),
	PMIC_ENTRY(PMIC_SAMPLE_BASE_MODE_CH1),
	PMIC_ENTRY(PMIC_S_N_VALUE_RST_CH1),
	PMIC_ENTRY(PMIC_VOW_INTR_CLR_CH1),
	PMIC_ENTRY(PMIC_VOW_INTR_SOURCE_SEL_CH1),
	PMIC_ENTRY(PMIC_VOW_ADC_CLK_INV_CH1),
	PMIC_ENTRY(PMIC_VOW_DIGMIC_CK_PHASE_SEL_CH1),
	PMIC_ENTRY(PMIC_VOW_CK_PDN_CH1),
	PMIC_ENTRY(PMIC_VOW_ADC_CK_PDN_CH1),
	PMIC_ENTRY(PMIC_VOW_CK_DIV_RST_CH1),
	PMIC_ENTRY(PMIC_VOW_DIGMIC_ON_CH1),
	PMIC_ENTRY(PMIC_VOW_DMIC0_CK_PDN),
	PMIC_ENTRY(PMIC_VOW_ON_CH2),
	PMIC_ENTRY(PMIC_SAMPLE_BASE_MODE_CH2),
	PMIC_ENTRY(PMIC_S_N_VALUE_RST_CH2),
	PMIC_ENTRY(PMIC_VOW_INTR_CLR_CH2),
	PMIC_ENTRY(PMIC_VOW_INTR_SOURCE_SEL_CH2),
	PMIC_ENTRY(PMIC_VOW_ADC_CLK_INV_CH2),
	PMIC_ENTRY(PMIC_VOW_DIGMIC_CK_PHASE_SEL_CH2),
	PMIC_ENTRY(PMIC_VOW_CK_PDN_CH2),
	PMIC_ENTRY(PMIC_VOW_ADC_CK_PDN_CH2),
	PMIC_ENTRY(PMIC_VOW_CK_DIV_RST_CH2),
	PMIC_ENTRY(PMIC_VOW_DIGMIC_ON_CH2),
	PMIC_ENTRY(PMIC_VOW_DMIC1_CK_PDN),
	PMIC_ENTRY(PMIC_VOW_P2_SNRDET_AUTO_PDN),
	PMIC_ENTRY(PMIC_VOW_TXIF_SCK_DIV),
	PMIC_ENTRY(PMIC_VOW_TXIF_MONO),
	PMIC_ENTRY(PMIC_VOW_ADC_TESTCK_SEL),
	PMIC_ENTRY(PMIC_VOW_ADC_TESTCK_SRC_SEL),
	PMIC_ENTRY(PMIC_VOW_TXIF_SCK_INV),
	PMIC_ENTRY(PMIC_RG_VOW_AMIC_ADC2_SOURCE_SEL),
	PMIC_ENTRY(PMIC_RG_VOW_AMIC_ADC1_SOURCE_SEL),
	PMIC_ENTRY(PMIC_VOW_INTR_FLAG_CH2),
	PMIC_ENTRY(PMIC_VOW_INTR_FLAG_CH1),
	PMIC_ENTRY(PMIC_VOW_INTR),
	PMIC_ENTRY(PMIC_BUCK_DVFS_DONE),
	PMIC_ENTRY(PMIC_AMPREF_CH1),
	PMIC_ENTRY(PMIC_AMPREF_CH2),
	PMIC_ENTRY(PMIC_TIMERINI_CH1),
	PMIC_ENTRY(PMIC_TIMERINI_CH2),
	PMIC_ENTRY(PMIC_A_INI_CH1),
	PMIC_ENTRY(PMIC_B_INI_CH1),
	PMIC_ENTRY(PMIC_A_DEFAULT_CH1),
	PMIC_ENTRY(PMIC_B_DEFAULT_CH1),
	PMIC_ENTRY(PMIC_VOW_IRQ_LATCH_SNR_EN_CH1),
	PMIC_ENTRY(PMIC_A_INI_CH2),
	PMIC_ENTRY(PMIC_B_INI_CH2),
	PMIC_ENTRY(PMIC_A_DEFAULT_CH2),
	PMIC_ENTRY(PMIC_B_DEFAULT_CH2),
	PMIC_ENTRY(PMIC_VOW_IRQ_LATCH_SNR_EN_CH2),
	PMIC_ENTRY(PMIC_K_ALPHA_FALL_CH1),
	PMIC_ENTRY(PMIC_K_ALPHA_RISE_CH1),
	PMIC_ENTRY(PMIC_K_BETA_FALL_CH1),
	PMIC_ENTRY(PMIC_K_BETA_RISE_CH1),
	PMIC_ENTRY(PMIC_K_ALPHA_FALL_CH2),
	PMIC_ENTRY(PMIC_K_ALPHA_RISE_CH2),
	PMIC_ENTRY(PMIC_K_BETA_FALL_CH2),
	PMIC_ENTRY(PMIC_K_BETA_RISE_CH2),
	PMIC_ENTRY(PMIC_N_MIN_CH1),
	PMIC_ENTRY(PMIC_N_MIN_CH2),
	PMIC_ENTRY(PMIC_VOW_SN_INI_CFG_VAL_CH1),
	PMIC_ENTRY(PMIC_VOW_SN_INI_CFG_EN_CH1),
	PMIC_ENTRY(PMIC_VOW_SN_INI_CFG_VAL_CH2),
	PMIC_ENTRY(PMIC_VOW_SN_INI_CFG_EN_CH2),
	PMIC_ENTRY(PMIC_K_GAMMA_CH2),
	PMIC_ENTRY(PMIC_K_GAMMA_CH1),
	PMIC_ENTRY(PMIC_VOW_DOWNCNT_CH1),
	PMIC_ENTRY(PMIC_VOW_DOWNCNT_CH2),
	PMIC_ENTRY(PMIC_SECOND_CNT_START_CH1),
	PMIC_ENTRY(PMIC_VOW_A_CH1),
	PMIC_ENTRY(PMIC_VOW_B_CH1),
	PMIC_ENTRY(PMIC_SLT_COUNTER_MON_CH1),
	PMIC_ENTRY(PMIC_K_TMP_MON_CH1),
	PMIC_ENTRY(PMIC_SECOND_CNT_START_CH2),
	PMIC_ENTRY(PMIC_VOW_A_CH2),
	PMIC_ENTRY(PMIC_VOW_B_CH2),
	PMIC_ENTRY(PMIC_SLT_COUNTER_MON_CH2),
	PMIC_ENTRY(PMIC_K_TMP_MON_CH2),
	PMIC_ENTRY(PMIC_VOW_S_L_CH1),
	PMIC_ENTRY(PMIC_VOW_S_L_CH2),
	PMIC_ENTRY(PMIC_VOW_S_H_CH1),
	PMIC_ENTRY(PMIC_VOW_S_H_CH2),
	PMIC_ENTRY(PMIC_VOW_N_L_CH1),
	PMIC_ENTRY(PMIC_VOW_N_L_CH2),
	PMIC_ENTRY(PMIC_VOW_N_H_CH1),
	PMIC_ENTRY(PMIC_VOW_N_H_CH2),
	PMIC_ENTRY(PMIC_VOW_TGEN_FREQ_DIV_CH1),
	PMIC_ENTRY(PMIC_VOW_TGEN_MUTE_SW_CH1),
	PMIC_ENTRY(PMIC_VOW_TGEN_EN_CH1),
	PMIC_ENTRY(PMIC_VOW_TGEN_FREQ_DIV_CH2),
	PMIC_ENTRY(PMIC_VOW_TGEN_MUTE_SW_CH2),
	PMIC_ENTRY(PMIC_VOW_TGEN_EN_CH2),
	PMIC_ENTRY(PMIC_RG_HPF_ON_CH1),
	PMIC_ENTRY(PMIC_RG_SNRDET_HPF_BYPASS_CH1),
	PMIC_ENTRY(PMIC_RG_MTKAIF_HPF_BYPASS_CH1),
	PMIC_ENTRY(PMIC_RG_BASELINE_ALPHA_ORDER_CH1),
	PMIC_ENTRY(PMIC_VOW_HPF_DC_TEST_CH1),
	PMIC_ENTRY(PMIC_RG_HPF_ON_CH2),
	PMIC_ENTRY(PMIC_RG_SNRDET_HPF_BYPASS_CH2),
	PMIC_ENTRY(PMIC_RG_MTKAIF_HPF_BYPASS_CH2),
	PMIC_ENTRY(PMIC_RG_BASELINE_ALPHA_ORDER_CH2),
	PMIC_ENTRY(PMIC_VOW_HPF_DC_TEST_CH2),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3RD_ANA_ID),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3RD_DIG_ID),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3RD_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3RD_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3RD_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3RD_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3RD_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3RD_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3_ESP),
	PMIC_ENTRY(PMIC_AUDIO_DIG_3RD_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_PERIODIC_CNT_PERIOD),
	PMIC_ENTRY(PMIC_RG_PERIODIC_CNT_CLR),
	PMIC_ENTRY(PMIC_RG_PERIODIC_EN),
	PMIC_ENTRY(PMIC_RG_PERIODIC_CNT_SET_VALUE),
	PMIC_ENTRY(PMIC_RG_PERIODIC_CNT_PAUSE),
	PMIC_ENTRY(PMIC_RG_PERIODIC_CNT_SET),
	PMIC_ENTRY(PMIC_AUDPREAMPLON_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDPREAMPLON_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDPREAMPLON_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDPREAMPLDCPRECHARGE_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDPREAMPLDCPRECHARGE_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDPREAMPLDCPRECHARGE_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDADCLPWRUP_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDADCLPWRUP_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDADCLPWRUP_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDGLBVOWLPWEN_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDGLBVOWLPWEN_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDGLBVOWLPWEN_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDDIGMICEN_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDDIGMICEN_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDDIGMICEN_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS0_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS0_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS0_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS1_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS1_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS1_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_XO_VOW_CK_EN_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_XO_VOW_CK_EN_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_XO_VOW_CK_EN_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDGLB_PWRDN_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDGLB_PWRDN_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDGLB_PWRDN_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_VOW_ON_CH1_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_VOW_ON_CH1_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_VOW_ON_CH1_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_DMIC_ON_CH1_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_DMIC_ON_CH1_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_DMIC_ON_CH1_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDPREAMPLON_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_PDN_VOW_F32K_CK),
	PMIC_ENTRY(PMIC_AUDPREAMPLDCPRECHARGE_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_VOW_SNRDET_PERIODIC_CFG),
	PMIC_ENTRY(PMIC_AUDADCLPWRUP_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDGLBVOWLPWEN_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDDIGMICEN_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS0_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS1_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_XO_VOW_CK_EN_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_CLKSQ_EN_VOW_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDGLB_PWRDN_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_VOW_ON_CH1_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_DMIC_ON_CH1_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDPREAMPRON_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDPREAMPRON_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDPREAMPRON_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDPREAMPRDCPRECHARGE_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDPREAMPRDCPRECHARGE_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDPREAMPRDCPRECHARGE_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDADCRPWRUP_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDADCRPWRUP_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDADCRPWRUP_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDGLBRVOWLPWEN_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDGLBRVOWLPWEN_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDGLBRVOWLPWEN_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDDIGMIC1EN_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDDIGMIC1EN_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDDIGMIC1EN_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS2_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS2_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS2_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_VOW_ON_CH2_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_VOW_ON_CH2_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_VOW_ON_CH2_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_DMIC_ON_CH2_PERIODIC_ON_CYCLE),
	PMIC_ENTRY(PMIC_DMIC_ON_CH2_PERIODIC_INVERSE),
	PMIC_ENTRY(PMIC_DMIC_ON_CH2_PERIODIC_MODE),
	PMIC_ENTRY(PMIC_AUDPREAMPRON_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDPREAMPRDCPRECHARGE_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDADCRPWRUP_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDGLBRVOWLPWEN_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDDIGMIC1EN_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_AUDPWDBMICBIAS2_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_VOW_ON_CH2_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_DMIC_ON_CH2_PERIODIC_OFF_CYCLE),
	PMIC_ENTRY(PMIC_VOW_PERIODIC_MON0),
	PMIC_ENTRY(PMIC_VOW_PERIODIC_MON1),
	PMIC_ENTRY(PMIC_VOW_PERIODIC_COUNT_MON),
	PMIC_ENTRY(PMIC_RG_NCP_ON),
	PMIC_ENTRY(PMIC_RG_NCP_DITHER_FIXED_CK0_ACK2_2P),
	PMIC_ENTRY(PMIC_RG_NCP_DITHER_FIXED_CK0_ACK1_2P),
	PMIC_ENTRY(PMIC_RG_NCP_DITHER_EN),
	PMIC_ENTRY(PMIC_RG_NCP_ADITH),
	PMIC_ENTRY(PMIC_RG_NCP_CK1_VALID_CNT),
	PMIC_ENTRY(PMIC_RG_Y_VAL_CFG),
	PMIC_ENTRY(PMIC_RG_X_VAL_CFG),
	PMIC_ENTRY(PMIC_RG_XY_VAL_CFG_EN),
	PMIC_ENTRY(PMIC_RG_NCP_PDDIS_EN),
	PMIC_ENTRY(PMIC_RG_NCP_NONCLK_SET),
	PMIC_ENTRY(PMIC_AUDENC_ANA_ID),
	PMIC_ENTRY(PMIC_AUDENC_DIG_ID),
	PMIC_ENTRY(PMIC_AUDENC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDENC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDENC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDENC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDENC_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDENC_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDENC_DSN_ESP),
	PMIC_ENTRY(PMIC_AUDENC_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLON),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLDCCEN),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLDCPRECHARGE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLPGATEST),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLVSCALE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLINPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLGAIN),
	PMIC_ENTRY(PMIC_RG_BULKL_VCM_EN),
	PMIC_ENTRY(PMIC_RG_AUDADCLPWRUP),
	PMIC_ENTRY(PMIC_RG_AUDADCLINPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRON),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRDCCEN),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRDCPRECHARGE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRPGATEST),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRVSCALE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRINPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPRGAIN),
	PMIC_ENTRY(PMIC_RG_BULKR_VCM_EN),
	PMIC_ENTRY(PMIC_RG_AUDADCRPWRUP),
	PMIC_ENTRY(PMIC_RG_AUDADCRINPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDPREAMP3ON),
	PMIC_ENTRY(PMIC_RG_AUDPREAMP3DCCEN),
	PMIC_ENTRY(PMIC_RG_AUDPREAMP3DCPRECHARGE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMP3PGATEST),
	PMIC_ENTRY(PMIC_RG_AUDPREAMP3VSCALE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMP3INPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDPREAMP3GAIN),
	PMIC_ENTRY(PMIC_RG_BULK3_VCM_EN),
	PMIC_ENTRY(PMIC_RG_AUDADC3PWRUP),
	PMIC_ENTRY(PMIC_RG_AUDADC3INPUTSEL),
	PMIC_ENTRY(PMIC_RG_AUDULHALFBIAS),
	PMIC_ENTRY(PMIC_RG_AUDGLBVOWLPWEN),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPLPEN),
	PMIC_ENTRY(PMIC_RG_AUDADC1STSTAGELPEN),
	PMIC_ENTRY(PMIC_RG_AUDADC2NDSTAGELPEN),
	PMIC_ENTRY(PMIC_RG_AUDADCFLASHLPEN),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADC1STSTAGEIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADC2NDSTAGEIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADCREFBUFIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADCFLASHIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDRULHALFBIAS),
	PMIC_ENTRY(PMIC_RG_AUDGLBRVOWLPWEN),
	PMIC_ENTRY(PMIC_RG_AUDRPREAMPLPEN),
	PMIC_ENTRY(PMIC_RG_AUDRADC1STSTAGELPEN),
	PMIC_ENTRY(PMIC_RG_AUDRADC2NDSTAGELPEN),
	PMIC_ENTRY(PMIC_RG_AUDRADCFLASHLPEN),
	PMIC_ENTRY(PMIC_RG_AUDRPREAMPIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDRADC1STSTAGEIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDRADC2NDSTAGEIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDRADCREFBUFIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDRADCFLASHIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADCCLKRSTB),
	PMIC_ENTRY(PMIC_RG_AUDADCCLKSEL),
	PMIC_ENTRY(PMIC_RG_AUDADCCLKSOURCE),
	PMIC_ENTRY(PMIC_RG_AUDADCCLKGENMODE),
	PMIC_ENTRY(PMIC_RG_AUDPREAMP_ACCFS),
	PMIC_ENTRY(PMIC_RG_AUDPREAMPAAFEN),
	PMIC_ENTRY(PMIC_RG_DCCVCMBUFLPMODSEL),
	PMIC_ENTRY(PMIC_RG_DCCVCMBUFLPSWEN),
	PMIC_ENTRY(PMIC_RG_AUDSPAREPGA),
	PMIC_ENTRY(PMIC_RG_AUDADC1STSTAGESDENB),
	PMIC_ENTRY(PMIC_RG_AUDADC2NDSTAGERESET),
	PMIC_ENTRY(PMIC_RG_AUDADC3RDSTAGERESET),
	PMIC_ENTRY(PMIC_RG_AUDADCFSRESET),
	PMIC_ENTRY(PMIC_RG_AUDADCWIDECM),
	PMIC_ENTRY(PMIC_RG_AUDADCNOPATEST),
	PMIC_ENTRY(PMIC_RG_AUDADCBYPASS),
	PMIC_ENTRY(PMIC_RG_AUDADCFFBYPASS),
	PMIC_ENTRY(PMIC_RG_AUDADCDACFBCURRENT),
	PMIC_ENTRY(PMIC_RG_AUDADCDACIDDTEST),
	PMIC_ENTRY(PMIC_RG_AUDADCDACNRZ),
	PMIC_ENTRY(PMIC_RG_AUDADCNODEM),
	PMIC_ENTRY(PMIC_RG_AUDADCDACTEST),
	PMIC_ENTRY(PMIC_RG_AUDADCDAC0P25FS),
	PMIC_ENTRY(PMIC_RG_AUDADCRDAC0P25FS),
	PMIC_ENTRY(PMIC_RG_AUDADCTESTDATA),
	PMIC_ENTRY(PMIC_RG_AUDRCTUNEL),
	PMIC_ENTRY(PMIC_RG_AUDRCTUNELSEL),
	PMIC_ENTRY(PMIC_RG_AUDRCTUNER),
	PMIC_ENTRY(PMIC_RG_AUDRCTUNERSEL),
	PMIC_ENTRY(PMIC_RG_AUD3CTUNEL),
	PMIC_ENTRY(PMIC_RG_AUD3CTUNELSEL),
	PMIC_ENTRY(PMIC_RGS_AUDRCTUNE3READ),
	PMIC_ENTRY(PMIC_RG_AUD3SPARE),
	PMIC_ENTRY(PMIC_RGS_AUDRCTUNELREAD),
	PMIC_ENTRY(PMIC_RGS_AUDRCTUNERREAD),
	PMIC_ENTRY(PMIC_RG_AUDSPAREVA30),
	PMIC_ENTRY(PMIC_RG_AUDSPAREVA18),
	PMIC_ENTRY(PMIC_RG_AUDPGA_DECAP),
	PMIC_ENTRY(PMIC_RG_AUDPGA_CAPRA),
	PMIC_ENTRY(PMIC_RG_AUDPGA_ACCCMP),
	PMIC_ENTRY(PMIC_RG_AUDENC_SPARE2),
	PMIC_ENTRY(PMIC_RG_AUDDIGMICEN),
	PMIC_ENTRY(PMIC_RG_AUDDIGMICBIAS),
	PMIC_ENTRY(PMIC_RG_DMICHPCLKEN),
	PMIC_ENTRY(PMIC_RG_AUDDIGMICPDUTY),
	PMIC_ENTRY(PMIC_RG_AUDDIGMICNDUTY),
	PMIC_ENTRY(PMIC_RG_DMICMONEN),
	PMIC_ENTRY(PMIC_RG_DMICMONSEL),
	PMIC_ENTRY(PMIC_RG_AUDDIGMIC1EN),
	PMIC_ENTRY(PMIC_RG_AUDDIGMICBIAS1),
	PMIC_ENTRY(PMIC_RG_DMIC1HPCLKEN),
	PMIC_ENTRY(PMIC_RG_AUDDIGMIC1PDUTY),
	PMIC_ENTRY(PMIC_RG_AUDDIGMIC1NDUTY),
	PMIC_ENTRY(PMIC_RG_DMIC1MONEN),
	PMIC_ENTRY(PMIC_RG_DMIC1MONSEL),
	PMIC_ENTRY(PMIC_RG_AUDSPAREVMIC),
	PMIC_ENTRY(PMIC_RG_AUDPWDBMICBIAS0),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0BYPASSEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0LOWPEN),
	PMIC_ENTRY(PMIC_RG_AUDPWDBMICBIAS3),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0VREF),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW0P1EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW0P2EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW0NEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW2P1EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW2P2EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS0DCSW2NEN),
	PMIC_ENTRY(PMIC_RG_AUDPWDBMICBIAS1),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1BYPASSEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1LOWPEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1VREF),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1DCSW1PEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1DCSW1NEN),
	PMIC_ENTRY(PMIC_RG_BANDGAPGEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1HVEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS1HVVREF),
	PMIC_ENTRY(PMIC_RG_AUDPWDBMICBIAS2),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS2BYPASSEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS2LOWPEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS2VREF),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS2DCSW3P1EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS2DCSW3P2EN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIAS2DCSW3NEN),
	PMIC_ENTRY(PMIC_RG_AUDMICBIASSPARE),
	PMIC_ENTRY(PMIC_RG_AUDACCDETMICBIAS0PULLLOW),
	PMIC_ENTRY(PMIC_RG_AUDACCDETMICBIAS1PULLLOW),
	PMIC_ENTRY(PMIC_RG_AUDACCDETMICBIAS2PULLLOW),
	PMIC_ENTRY(PMIC_RG_AUDACCDETVIN1PULLLOW),
	PMIC_ENTRY(PMIC_RG_AUDACCDETVTHACAL),
	PMIC_ENTRY(PMIC_RG_AUDACCDETVTHBCAL),
	PMIC_ENTRY(PMIC_RG_AUDACCDETTVDET),
	PMIC_ENTRY(PMIC_RG_ACCDETSEL),
	PMIC_ENTRY(PMIC_RG_SWBUFMODSEL),
	PMIC_ENTRY(PMIC_RG_SWBUFSWEN),
	PMIC_ENTRY(PMIC_RG_EINT0NOHYS),
	PMIC_ENTRY(PMIC_RG_EINT0CONFIGACCDET),
	PMIC_ENTRY(PMIC_RG_EINT0HIRENB),
	PMIC_ENTRY(PMIC_RG_ACCDET2AUXRESBYPASS),
	PMIC_ENTRY(PMIC_RG_ACCDET2AUXSWEN),
	PMIC_ENTRY(PMIC_RG_AUDACCDETMICBIAS3PULLLOW),
	PMIC_ENTRY(PMIC_RG_EINT1CONFIGACCDET),
	PMIC_ENTRY(PMIC_RG_EINT1HIRENB),
	PMIC_ENTRY(PMIC_RG_EINT1NOHYS),
	PMIC_ENTRY(PMIC_RG_EINTCOMPVTH),
	PMIC_ENTRY(PMIC_RG_MTEST_EN),
	PMIC_ENTRY(PMIC_RG_MTEST_SEL),
	PMIC_ENTRY(PMIC_RG_MTEST_CURRENT),
	PMIC_ENTRY(PMIC_RG_ANALOGFDEN),
	PMIC_ENTRY(PMIC_RG_FDVIN1PPULLLOW),
	PMIC_ENTRY(PMIC_RG_FDEINT0TYPE),
	PMIC_ENTRY(PMIC_RG_FDEINT1TYPE),
	PMIC_ENTRY(PMIC_RG_EINT0CMPEN),
	PMIC_ENTRY(PMIC_RG_EINT0CMPMEN),
	PMIC_ENTRY(PMIC_RG_EINT0EN),
	PMIC_ENTRY(PMIC_RG_EINT0CEN),
	PMIC_ENTRY(PMIC_RG_EINT0INVEN),
	PMIC_ENTRY(PMIC_RG_EINT0CTURBO),
	PMIC_ENTRY(PMIC_RG_EINT1CMPEN),
	PMIC_ENTRY(PMIC_RG_EINT1CMPMEN),
	PMIC_ENTRY(PMIC_RG_EINT1EN),
	PMIC_ENTRY(PMIC_RG_EINT1CEN),
	PMIC_ENTRY(PMIC_RG_EINT1INVEN),
	PMIC_ENTRY(PMIC_RG_EINT1CTURBO),
	PMIC_ENTRY(PMIC_RG_ACCDETSPARE),
	PMIC_ENTRY(PMIC_RG_AUDENCSPAREVA30),
	PMIC_ENTRY(PMIC_RG_AUDENCSPAREVA18),
	PMIC_ENTRY(PMIC_RG_CLKSQ_EN),
	PMIC_ENTRY(PMIC_RG_CLKSQ_IN_SEL_TEST),
	PMIC_ENTRY(PMIC_RG_CM_REFGENSEL),
	PMIC_ENTRY(PMIC_RG_AUDIO_VOW_EN),
	PMIC_ENTRY(PMIC_RG_CLKSQ_EN_VOW),
	PMIC_ENTRY(PMIC_RG_CLKAND_EN_VOW),
	PMIC_ENTRY(PMIC_RG_VOWCLK_SEL_EN_VOW),
	PMIC_ENTRY(PMIC_RG_SPARE_VOW),
	PMIC_ENTRY(PMIC_AUDDEC_ANA_ID),
	PMIC_ENTRY(PMIC_AUDDEC_DIG_ID),
	PMIC_ENTRY(PMIC_AUDDEC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDDEC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDDEC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDDEC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDDEC_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDDEC_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDDEC_DSN_ESP),
	PMIC_ENTRY(PMIC_AUDDEC_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_AUDDACLPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDDACRPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUD_DAC_PWR_UP_VA32),
	PMIC_ENTRY(PMIC_RG_AUD_DAC_PWL_UP_VA32),
	PMIC_ENTRY(PMIC_RG_AUDHPLPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPRPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPLPWRUP_IBIAS_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPRPWRUP_IBIAS_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPLSCDISABLE_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPRSCDISABLE_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPLBSCCURRENT_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPRBSCCURRENT_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPLOUTPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPROUTPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPLOUTAUXPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPROUTAUXPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPLAUXFBRSW_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPRAUXFBRSW_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPLSHORT2HPLAUX_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPRSHORT2HPRAUX_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPLOUTSTGCTRL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPROUTSTGCTRL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPLOUTPUTSTBENH_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPROUTPUTSTBENH_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPSTARTUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDREFN_DERES_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPINPUTSTBENH_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPINPUTRESET0_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPOUTPUTRESET0_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HPPSHORT2VCM_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPTRIM_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPLTRIM_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPLFINETRIM_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPRTRIM_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPRFINETRIM_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPDIFFINPBIASADJ_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPLFCOMPRESSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPHFCOMPRESSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPHFCOMPBUFGAINSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPCOMP_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPDECMGAINADJ_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPDEDMGAINADJ_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHSPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHSPWRUP_IBIAS_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHSMUXINPUTSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHSSCDISABLE_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHSBSCCURRENT_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHSSTARTUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HSOUTPUTSTBENH_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HSINPUTSTBENH_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HSINPUTRESET0_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HSOUTPUTRESET0_VAUDP32),
	PMIC_ENTRY(PMIC_RG_HSOUT_SHORTVCM_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDLOLPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDLOLPWRUP_IBIAS_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDLOLMUXINPUTSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDLOLSCDISABLE_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDLOLBSCCURRENT_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDLOSTARTUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_LOINPUTSTBENH_VAUDP32),
	PMIC_ENTRY(PMIC_RG_LOOUTPUTSTBENH_VAUDP32),
	PMIC_ENTRY(PMIC_RG_LOINPUTRESET0_VAUDP32),
	PMIC_ENTRY(PMIC_RG_LOOUTPUTRESET0_VAUDP32),
	PMIC_ENTRY(PMIC_RG_LOOUT_SHORTVCM_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDDACTPWRUP_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUD_DAC_PWT_UP_VA32),
	PMIC_ENTRY(PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDTRIMBUF_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDHPSPKDET_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_ABIDEC_RSVD0_VA32),
	PMIC_ENTRY(PMIC_RG_ABIDEC_RSVD0_VAUDP32),
	PMIC_ENTRY(PMIC_RG_ABIDEC_RSVD1_VAUDP32),
	PMIC_ENTRY(PMIC_RG_ABIDEC_RSVD2_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDZCDMUXSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDZCDCLKSEL_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDBIASADJ_0_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDBIASADJ_1_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDIBIASPWRDN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_RSTB_DECODER_VA32),
	PMIC_ENTRY(PMIC_RG_SEL_DECODER_96K_VA32),
	PMIC_ENTRY(PMIC_RG_SEL_DELAY_VCORE),
	PMIC_ENTRY(PMIC_RG_AUDGLB_PWRDN_VA32),
	PMIC_ENTRY(PMIC_RG_AUDGLB_LP_VOW_EN_VA32),
	PMIC_ENTRY(PMIC_RG_AUDGLB_LP2_VOW_EN_VA32),
	PMIC_ENTRY(PMIC_RG_LCLDO_DEC_EN_VA32),
	PMIC_ENTRY(PMIC_RG_LCLDO_DEC_PDDIS_EN_VA18),
	PMIC_ENTRY(PMIC_RG_LCLDO_DEC_REMOTE_SENSE_VA18),
	PMIC_ENTRY(PMIC_RG_NVREG_EN_VAUDP32),
	PMIC_ENTRY(PMIC_RG_NVREG_PULL0V_VAUDP32),
	PMIC_ENTRY(PMIC_RG_AUDPMU_RSVD_VA18),
	PMIC_ENTRY(PMIC_AUDZCD_ANA_ID),
	PMIC_ENTRY(PMIC_AUDZCD_DIG_ID),
	PMIC_ENTRY(PMIC_AUDZCD_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDZCD_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDZCD_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUDZCD_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUDZCD_DSN_CBS),
	PMIC_ENTRY(PMIC_AUDZCD_DSN_BIX),
	PMIC_ENTRY(PMIC_AUDZCD_DSN_ESP),
	PMIC_ENTRY(PMIC_AUDZCD_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_AUDZCDENABLE),
	PMIC_ENTRY(PMIC_RG_AUDZCDGAINSTEPTIME),
	PMIC_ENTRY(PMIC_RG_AUDZCDGAINSTEPSIZE),
	PMIC_ENTRY(PMIC_RG_AUDZCDTIMEOUTMODESEL),
	PMIC_ENTRY(PMIC_RG_AUDLOLGAIN),
	PMIC_ENTRY(PMIC_RG_AUDLORGAIN),
	PMIC_ENTRY(PMIC_RG_AUDHPLGAIN),
	PMIC_ENTRY(PMIC_RG_AUDHPRGAIN),
	PMIC_ENTRY(PMIC_RG_AUDHSGAIN),
	PMIC_ENTRY(PMIC_RG_AUDIVLGAIN),
	PMIC_ENTRY(PMIC_RG_AUDIVRGAIN),
	PMIC_ENTRY(PMIC_RG_AUDINTGAIN1),
	PMIC_ENTRY(PMIC_RG_AUDINTGAIN2),
	PMIC_ENTRY(PMIC_ACCDET_ANA_ID),
	PMIC_ENTRY(PMIC_ACCDET_DIG_ID),
	PMIC_ENTRY(PMIC_ACCDET_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_ACCDET_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_ACCDET_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_ACCDET_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_ACCDET_DSN_CBS),
	PMIC_ENTRY(PMIC_ACCDET_DSN_BIX),
	PMIC_ENTRY(PMIC_ACCDET_ESP),
	PMIC_ENTRY(PMIC_ACCDET_DSN_FPI),
	PMIC_ENTRY(PMIC_ACCDET_AUXADC_SEL),
	PMIC_ENTRY(PMIC_ACCDET_AUXADC_SW),
	PMIC_ENTRY(PMIC_ACCDET_TEST_AUXADC),
	PMIC_ENTRY(PMIC_ACCDET_AUXADC_ANASWCTRL_SEL),
	PMIC_ENTRY(PMIC_AUDACCDETAUXADCSWCTRL_SEL),
	PMIC_ENTRY(PMIC_AUDACCDETAUXADCSWCTRL_SW),
	PMIC_ENTRY(PMIC_ACCDET_TEST_ANA),
	PMIC_ENTRY(PMIC_RG_AUDACCDETRSV),
	PMIC_ENTRY(PMIC_ACCDET_SW_EN),
	PMIC_ENTRY(PMIC_ACCDET_SEQ_INIT),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_SW_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_SEQ_INIT),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_SW_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_SEQ_INIT),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_INVERTER_SW_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_INVERTER_SEQ_INIT),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_INVERTER_SW_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_INVERTER_SEQ_INIT),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_M_SW_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_M_SW_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_M_DETECT_EN),
	PMIC_ENTRY(PMIC_ACCDET_CMP_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_VTH_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_MBIAS_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_EN_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPEN_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPMEN_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CTURBO_PWM_EN),
	PMIC_ENTRY(PMIC_ACCDET_CMP_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_VTH_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_MBIAS_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CMPEN_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CMPEN_PWM_IDLE),
	PMIC_ENTRY(PMIC_ACCDET_PWM_EN_SW),
	PMIC_ENTRY(PMIC_ACCDET_PWM_EN_SEL),
	PMIC_ENTRY(PMIC_ACCDET_PWM_WIDTH),
	PMIC_ENTRY(PMIC_ACCDET_PWM_THRESH),
	PMIC_ENTRY(PMIC_ACCDET_RISE_DELAY),
	PMIC_ENTRY(PMIC_ACCDET_FALL_DELAY),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPMEN_PWM_THRESH),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPMEN_PWM_WIDTH),
	PMIC_ENTRY(PMIC_ACCDET_EINT_EN_PWM_THRESH),
	PMIC_ENTRY(PMIC_ACCDET_EINT_EN_PWM_WIDTH),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPEN_PWM_THRESH),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPEN_PWM_WIDTH),
	PMIC_ENTRY(PMIC_ACCDET_DEBOUNCE0),
	PMIC_ENTRY(PMIC_ACCDET_DEBOUNCE1),
	PMIC_ENTRY(PMIC_ACCDET_DEBOUNCE2),
	PMIC_ENTRY(PMIC_ACCDET_DEBOUNCE3),
	PMIC_ENTRY(PMIC_ACCDET_CONNECT_AUXADC_TIME_DIG),
	PMIC_ENTRY(PMIC_ACCDET_CONNECT_AUXADC_TIME_ANA),
	PMIC_ENTRY(PMIC_ACCDET_EINT_DEBOUNCE0),
	PMIC_ENTRY(PMIC_ACCDET_EINT_DEBOUNCE1),
	PMIC_ENTRY(PMIC_ACCDET_EINT_DEBOUNCE2),
	PMIC_ENTRY(PMIC_ACCDET_EINT_DEBOUNCE3),
	PMIC_ENTRY(PMIC_ACCDET_EINT_INVERTER_DEBOUNCE),
	PMIC_ENTRY(PMIC_ACCDET_IVAL_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_IVAL_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_IVAL_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_IVAL_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_IVAL_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_IVAL_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_IVAL_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_IVAL_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_INVERTER_IVAL_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_INVERTER_IVAL_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_INVERTER_IVAL_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_INVERTER_IVAL_SEL),
	PMIC_ENTRY(PMIC_ACCDET_IRQ),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_IRQ),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_IRQ),
	PMIC_ENTRY(PMIC_ACCDET_EINT_IN_INVERSE),
	PMIC_ENTRY(PMIC_ACCDET_IRQ_CLR),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_IRQ_CLR),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_IRQ_CLR),
	PMIC_ENTRY(PMIC_ACCDET_EINT_M_PLUG_IN_NUM),
	PMIC_ENTRY(PMIC_ACCDET_DA_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_EN_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CMPEN_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CMPMEN_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CTURBO_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CEN_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_EN_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CMPEN_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CMPMEN_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CTURBO_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CEN_STABLE),
	PMIC_ENTRY(PMIC_ACCDET_HWMODE_EN),
	PMIC_ENTRY(PMIC_ACCDET_HWMODE_SEL),
	PMIC_ENTRY(PMIC_ACCDET_PLUG_OUT_DETECT),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_REVERSE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_REVERSE),
	PMIC_ENTRY(PMIC_ACCDET_EINT_HWMODE_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_PLUG_OUT_BYPASS_DEB),
	PMIC_ENTRY(PMIC_ACCDET_EINT_M_PLUG_IN_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_M_HWMODE_EN),
	PMIC_ENTRY(PMIC_ACCDET_TEST_CMPEN),
	PMIC_ENTRY(PMIC_ACCDET_TEST_VTHEN),
	PMIC_ENTRY(PMIC_ACCDET_TEST_MBIASEN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_TEST_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_TEST_INVEN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_TEST_CMPEN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_TEST_CMPMEN),
	PMIC_ENTRY(PMIC_ACCDET_EINT_TEST_CTURBO),
	PMIC_ENTRY(PMIC_ACCDET_EINT_TEST_CEN),
	PMIC_ENTRY(PMIC_ACCDET_TEST_B),
	PMIC_ENTRY(PMIC_ACCDET_TEST_A),
	PMIC_ENTRY(PMIC_ACCDET_EINT_TEST_CMPOUT),
	PMIC_ENTRY(PMIC_ACCDET_EINT_TEST_CMPMOUT),
	PMIC_ENTRY(PMIC_ACCDET_EINT_TEST_INVOUT),
	PMIC_ENTRY(PMIC_ACCDET_CMPEN_SEL),
	PMIC_ENTRY(PMIC_ACCDET_VTHEN_SEL),
	PMIC_ENTRY(PMIC_ACCDET_MBIASEN_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_EN_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_INVEN_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPEN_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPMEN_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CTURBO_SEL),
	PMIC_ENTRY(PMIC_ACCDET_B_SEL),
	PMIC_ENTRY(PMIC_ACCDET_A_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPOUT_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_CMPMOUT_SEL),
	PMIC_ENTRY(PMIC_ACCDET_EINT_INVOUT_SEL),
	PMIC_ENTRY(PMIC_ACCDET_CMPEN_SW),
	PMIC_ENTRY(PMIC_ACCDET_VTHEN_SW),
	PMIC_ENTRY(PMIC_ACCDET_MBIASEN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_EN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_INVEN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CMPEN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CMPMEN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CTURBO_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_EN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_INVEN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CMPEN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CMPMEN_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CTURBO_SW),
	PMIC_ENTRY(PMIC_ACCDET_B_SW),
	PMIC_ENTRY(PMIC_ACCDET_A_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CMPOUT_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CMPMOUT_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_INVOUT_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CMPOUT_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CMPMOUT_SW),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_INVOUT_SW),
	PMIC_ENTRY(PMIC_AD_AUDACCDETCMPOB),
	PMIC_ENTRY(PMIC_AD_AUDACCDETCMPOA),
	PMIC_ENTRY(PMIC_ACCDET_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_STATE),
	PMIC_ENTRY(PMIC_DA_AUDACCDETMBIASCLK),
	PMIC_ENTRY(PMIC_DA_AUDACCDETVTHCLK),
	PMIC_ENTRY(PMIC_DA_AUDACCDETCMPCLK),
	PMIC_ENTRY(PMIC_DA_AUDACCDETAUXADCSWCTRL),
	PMIC_ENTRY(PMIC_AD_EINT0CMPMOUT),
	PMIC_ENTRY(PMIC_AD_EINT0CMPOUT),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_STATE),
	PMIC_ENTRY(PMIC_DA_EINT0CMPEN),
	PMIC_ENTRY(PMIC_DA_EINT0CMPMEN),
	PMIC_ENTRY(PMIC_DA_EINT0CTURBO),
	PMIC_ENTRY(PMIC_AD_EINT1CMPMOUT),
	PMIC_ENTRY(PMIC_AD_EINT1CMPOUT),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_STATE),
	PMIC_ENTRY(PMIC_DA_EINT1CMPEN),
	PMIC_ENTRY(PMIC_DA_EINT1CMPMEN),
	PMIC_ENTRY(PMIC_DA_EINT1CTURBO),
	PMIC_ENTRY(PMIC_AD_EINT0INVOUT),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_INVERTER_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_INVERTER_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_INVERTER_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_INVERTER_STATE),
	PMIC_ENTRY(PMIC_DA_EINT0EN),
	PMIC_ENTRY(PMIC_DA_EINT0INVEN),
	PMIC_ENTRY(PMIC_DA_EINT0CEN),
	PMIC_ENTRY(PMIC_AD_EINT1INVOUT),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_INVERTER_CUR_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_INVERTER_SAM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_INVERTER_MEM_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_INVERTER_STATE),
	PMIC_ENTRY(PMIC_DA_EINT1EN),
	PMIC_ENTRY(PMIC_DA_EINT1INVEN),
	PMIC_ENTRY(PMIC_DA_EINT1CEN),
	PMIC_ENTRY(PMIC_ACCDET_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_M_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_DETECT_MOISTURE),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_PLUG_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_M_PLUG_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_M_EN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_DETECT_MOISTURE),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_PLUG_IN),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_M_PLUG_IN),
	PMIC_ENTRY(PMIC_ACCDET_CUR_DEB),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_CUR_DEB),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_CUR_DEB),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_INVERTER_CUR_DEB),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_INVERTER_CUR_DEB),
	PMIC_ENTRY(PMIC_AD_AUDACCDETCMPOB_MON),
	PMIC_ENTRY(PMIC_AD_AUDACCDETCMPOA_MON),
	PMIC_ENTRY(PMIC_AD_EINT0CMPMOUT_MON),
	PMIC_ENTRY(PMIC_AD_EINT0CMPOUT_MON),
	PMIC_ENTRY(PMIC_AD_EINT0INVOUT_MON),
	PMIC_ENTRY(PMIC_AD_EINT1CMPMOUT_MON),
	PMIC_ENTRY(PMIC_AD_EINT1CMPOUT_MON),
	PMIC_ENTRY(PMIC_AD_EINT1INVOUT_MON),
	PMIC_ENTRY(PMIC_DA_AUDACCDETCMPCLK_MON),
	PMIC_ENTRY(PMIC_DA_AUDACCDETVTHCLK_MON),
	PMIC_ENTRY(PMIC_DA_AUDACCDETMBIASCLK_MON),
	PMIC_ENTRY(PMIC_DA_AUDACCDETAUXADCSWCTRL_MON),
	PMIC_ENTRY(PMIC_DA_EINT0CTURBO_MON),
	PMIC_ENTRY(PMIC_DA_EINT0CMPMEN_MON),
	PMIC_ENTRY(PMIC_DA_EINT0CMPEN_MON),
	PMIC_ENTRY(PMIC_DA_EINT0INVEN_MON),
	PMIC_ENTRY(PMIC_DA_EINT0CEN_MON),
	PMIC_ENTRY(PMIC_DA_EINT0EN_MON),
	PMIC_ENTRY(PMIC_DA_EINT1CTURBO_MON),
	PMIC_ENTRY(PMIC_DA_EINT1CMPMEN_MON),
	PMIC_ENTRY(PMIC_DA_EINT1CMPEN_MON),
	PMIC_ENTRY(PMIC_DA_EINT1INVEN_MON),
	PMIC_ENTRY(PMIC_DA_EINT1CEN_MON),
	PMIC_ENTRY(PMIC_DA_EINT1EN_MON),
	PMIC_ENTRY(PMIC_ACCDET_EINT0_M_PLUG_IN_COUNT),
	PMIC_ENTRY(PMIC_ACCDET_EINT1_M_PLUG_IN_COUNT),
	PMIC_ENTRY(PMIC_ACCDET_MON_FLAG_EN),
	PMIC_ENTRY(PMIC_ACCDET_MON_FLAG_SEL),
};
