/*
 * Copyright (C) 2017 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */
#ifndef __PMIC_WRAP_INIT_H__
#define __PMIC_WRAP_INIT_H__

/****** SW ENV define *************************************/
#define PMIC_WRAP_PRELOADER      0
#define PMIC_WRAP_LK             0
#define PMIC_WRAP_KERNEL         1
#define PMIC_WRAP_SCP            0
#define PMIC_WRAP_CTP            0

#define PMIC_WRAP_DEBUG
#define PMIC_WRAP_SUPPORT
/****** For BringUp. if BringUp doesn't had PMIC, need open this ***********/
#if (PMIC_WRAP_PRELOADER)
#if CFG_FPGA_PLATFORM
#define PMIC_WRAP_NO_PMIC
#else
		/* #define PWRAP_TIMEOUT */
#endif
#elif (PMIC_WRAP_LK)
#if defined(MACH_FPGA)
#define PMIC_WRAP_NO_PMIC
#else
#define PWRAP_TIMEOUT
#endif
#elif (PMIC_WRAP_KERNEL)
#if defined(CONFIG_MTK_FPGA) || defined(CONFIG_FPGA_EARLY_PORTING)
#define PMIC_WRAP_NO_PMIC
#else
		/* #define PWRAP_TIMEOUT */
#endif
#elif (PMIC_WRAP_CTP)
#if defined(CONFIG_MTK_FPGA)
#define PMIC_WRAP_NO_PMIC
#else
		/* #define PWRAP_TIMEOUT */
#endif
#else
#define PWRAP_TIMEOUT
#endif

#define MTK_PLATFORM_MT6356      1

/******  SW ENV header define *****************************/
#if (PMIC_WRAP_PRELOADER)
#include <sync_write.h>
#include <typedefs.h>
#include <gpio.h>
#include <mt6763.h>
#elif (PMIC_WRAP_LK)
#include <debug.h>
#include <platform/mt_typedefs.h>
#include <platform/mt_reg_base.h>
#include <platform/mt_gpt.h>
#include <platform/mt_irq.h>
#include <sys/types.h>
#include <platform/sync_write.h>
#include <platform/upmu_hw.h>
#elif (PMIC_WRAP_KERNEL)
#ifndef CONFIG_OF
#include <mach/mtk_reg_base.h>
#include <mach/mtk_irq.h>
#endif
#include "mt-plat/sync_write.h"
#elif (PMIC_WRAP_SCP)
#include "stdio.h"
#include <string.h>
#include "FreeRTOS.h"
#elif (PMIC_WRAP_CTP)
#include <sync_write.h>
#include <typedefs.h>
#include <reg_base.H>
#else
### Compile error, check SW ENV define
#endif

/*******************macro for  regsister@PMIC *******************************/
#if (PMIC_WRAP_KERNEL)
#include <mach/upmu_hw.h>
#else
#include <upmu_hw.h>
#endif
/*******************start ---external API********************************/
extern signed int pwrap_read(unsigned int adr, unsigned int *rdata);
extern signed int pwrap_write(unsigned int adr, unsigned int wdata);
extern signed int pwrap_write_nochk(unsigned int adr, unsigned int wdata);
extern signed int pwrap_read_nochk(unsigned int adr, unsigned int *rdata);
extern signed int pwrap_wacs2(unsigned int write, unsigned int adr,
			      unsigned int wdata, unsigned int *rdata);
extern signed int pwrap_wacs2_read(unsigned int adr, unsigned int *rdata);
extern signed int pwrap_wacs2_write(unsigned int adr, unsigned int wdata);
extern void pwrap_dump_all_register(void);
extern signed int pwrap_init_preloader(void);
extern signed int pwrap_init_lk(void);
extern signed int pwrap_init_scp(void);
extern signed int pwrap_init(void);

/******  DEBUG marco define *******************************/
#define PWRAPTAG                "[PWRAP] "
#if (PMIC_WRAP_PRELOADER)
#ifdef PMIC_WRAP_DEBUG
#define PWRAPFUC(fmt, arg...)   print(PWRAPTAG "%s\n", __func__)
#define PWRAPLOG(fmt, arg...)   print(PWRAPTAG fmt, ##arg)
#else
#define PWRAPFUC(fmt, arg...)
#define PWRAPLOG(fmt, arg...)
#endif				/* end of #ifdef PMIC_WRAP_DEBUG */
#define PWRAPERR(fmt, arg...) \
	print(PWRAPTAG "ERROR,line=%d " fmt, __LINE__, ##arg)
#elif (PMIC_WRAP_LK)
#ifdef PMIC_WRAP_DEBUG
#define PWRAPFUC(fmt, arg...)   dprintf(CRITICAL, PWRAPTAG "%s\n", __func__)
#define PWRAPLOG(fmt, arg...)   dprintf(CRITICAL, PWRAPTAG fmt, ##arg)
#else
#define PWRAPFUC(fmt, arg...)
#define PWRAPLOG(fmt, arg...)
#endif				/* end of #ifdef PMIC_WRAP_DEBUG */
#define PWRAPERR(fmt, arg...) \
	dprintf(CRITICAL, PWRAPTAG "ERROR,line=%d " fmt, __LINE__, ##arg)
#elif (PMIC_WRAP_KERNEL)
#ifdef PMIC_WRAP_DEBUG
#define PWRAPDEB(fmt, arg...)
#define PWRAPLOG(fmt, arg...) pr_debug(PWRAPTAG fmt, ##arg)
#define PWRAPFUC(fmt, arg...)
#define PWRAPREG(fmt, arg...)   pr_debug(PWRAPTAG fmt, ##arg)
#else
#define PWRAPDEB(fmt, arg...)
#define PWRAPLOG(fmt, arg...)
#define PWRAPFUC(fmt, arg...)
#define PWRAPREG(fmt, arg...)
#endif				/* end of #ifdef PMIC_WRAP_DEBUG */
#elif (PMIC_WRAP_SCP)
#ifdef PMIC_WRAP_DEBUG
#define PWRAPFUC(fmt, arg...)   PRINTF_D(PWRAPTAG "%s\n", __func__)
#define PWRAPLOG(fmt, arg...)   PRINTF_D(PWRAPTAG fmt, ##arg)
#else
#define PWRAPFUC(fmt, arg...)	/*PRINTF_D(PWRAPTAG "%s\n", __FUNCTION__) */
#define PWRAPLOG(fmt, arg...)	/*PRINTF_D(PWRAPTAG fmt, ##arg) */
#endif				/* end of #ifdef PMIC_WRAP_DEBUG */
#define PWRAPERR(fmt, arg...) \
	PRINTF_E(PWRAPTAG "ERROR, line=%d " fmt, __LINE__, ##arg)
#elif (PMIC_WRAP_CTP)
#ifdef PMIC_WRAP_DEBUG
#define PWRAPFUC(fmt, arg...)   dbg_print(PWRAPTAG "%s\n", __func__)
#define PWRAPLOG(fmt, arg...)   dbg_print(PWRAPTAG fmt, ##arg)
#else
#define PWRAPFUC(fmt, arg...)   dbg_print(PWRAPTAG "%s\n", __func__)
#define PWRAPLOG(fmt, arg...)   dbg_print(PWRAPTAG fmt, ##arg)
#endif				/* end of #ifdef PMIC_WRAP_DEBUG */
#define PWRAPERR(fmt, arg...) \
	dbg_print(PWRAPTAG "ERROR,line=%d " fmt, __LINE__, ##arg)
#else
### Compile error, check SW ENV define
#endif
/**********************************************************/

/***********  platform info, PMIC info ********************/
#define PMIC_WRAP_REG_RANGE     (354)

#define DEFAULT_VALUE_READ_TEST                 (0x5aa5)
#define DEFAULT_VALUE_WRITE_TEST                (0xa55a)
#define PWRAP_WRITE_TEST_VALUE                  (0x1234)
#define PWRAP_EXT_WRITE_TEST_VALUE              (0x4321)


#ifdef CONFIG_OF
extern void __iomem *pwrap_base;
#define PMIC_WRAP_BASE		(pwrap_base)
#define MT_PMIC_WRAP_IRQ_ID	(pwrap_irq)
#define INFRACFG_AO_REG_BASE	(infracfg_ao_base)
#define TOPCKGEN_BASE		(topckgen_base)
#define SCP_CLK_CTRL_BASE       (scp_clk_ctrl_base)
#define PMIC_WRAP_P2P_BASE      (pwrap_p2p_base)
#else
#define PMIC_WRAP_BASE          (PWRAP_BASE)
#define MT_PMIC_WRAP_IRQ_ID     (PMIC_WRAP_ERR_IRQ_BIT_ID)
#define INFRACFG_AO_BASE        (0x10001000)
#define INFRACFG_AO_REG_BASE    (INFRACFG_AO_BASE)
#define CKSYS_BASE              (0x10000000)
#define TOPCKGEN_BASE           (CKSYS_BASE)
#endif

#define UINT32  unsigned int
#define UINT32P unsigned int *

/**********************************************************/

#define ENABLE          (1)
#define DISABLE         (0)
#define DISABLE_ALL     (0)

/* HIPRIS_ARB */

/* MUX SEL */
#define WRAPPER_MODE    (0)
#define MANUAL_MODE     (1)

/* macro for MAN_RDATA  FSM */
#define MAN_FSM_NO_REQ             (0x00)
#define MAN_FSM_IDLE               (0x00)
#define MAN_FSM_REQ                (0x02)
#define MAN_FSM_WFDLE              (0x04)
#define MAN_FSM_WFVLDCLR           (0x06)

/* macro for WACS_FSM */
#define WACS_FSM_IDLE               (0x00)
#define WACS_FSM_REQ                (0x02)
#define WACS_FSM_WFDLE              (0x04)
#define WACS_FSM_WFVLDCLR           (0x06)
#define WACS_INIT_DONE              (0x01)
#define WACS_SYNC_IDLE              (0x01)
#define WACS_SYNC_BUSY              (0x00)

/**** timeout time, unit :us ***********/
#define TIMEOUT_RESET           (0xFF)
#define TIMEOUT_READ            (0xFF)
#define TIMEOUT_WAIT_IDLE       (0xFF)

/*-----macro for manual commnd ---------------------------------*/
#define OP_WR    (0x1)
#define OP_RD    (0x0)
#define OP_CSH   (0x0)
#define OP_CSL   (0x1)
#define OP_CK    (0x2)
#define OP_OUTS  (0x8)
#define OP_OUTD  (0x9)
#define OP_OUTQ  (0xA)
#define OP_INS   (0xC)
#define OP_INS0  (0xD)
#define OP_IND   (0xE)
#define OP_INQ   (0xF)
#define OP_OS2IS (0x10)
#define OP_OS2ID (0x11)
#define OP_OS2IQ (0x12)
#define OP_OD2IS (0x13)
#define OP_OD2ID (0x14)
#define OP_OD2IQ (0x15)
#define OP_OQ2IS (0x16)
#define OP_OQ2ID (0x17)
#define OP_OQ2IQ (0x18)
#define OP_OSNIS (0x19)
#define OP_ODNID (0x1A)

/******************Error handle *****************************/
#define E_PWR_INVALID_ARG               (1)
#define E_PWR_INVALID_RW                (2)
#define E_PWR_INVALID_ADDR              (3)
#define E_PWR_INVALID_WDAT              (4)
#define E_PWR_INVALID_OP_MANUAL         (5)
#define E_PWR_NOT_IDLE_STATE            (6)
#define E_PWR_NOT_INIT_DONE             (7)
#define E_PWR_NOT_INIT_DONE_READ        (8)
#define E_PWR_WAIT_IDLE_TIMEOUT         (9)
#define E_PWR_WAIT_IDLE_TIMEOUT_READ    (10)
#define E_PWR_INIT_SIDLY_FAIL           (11)
#define E_PWR_RESET_TIMEOUT             (12)
#define E_PWR_TIMEOUT                   (13)
#define E_PWR_INIT_RESET_SPI            (20)
#define E_PWR_INIT_SIDLY                (21)
#define E_PWR_INIT_REG_CLOCK            (22)
#define E_PWR_INIT_ENABLE_PMIC          (23)
#define E_PWR_INIT_DIO                  (24)
#define E_PWR_INIT_CIPHER               (25)
#define E_PWR_INIT_WRITE_TEST           (26)
#define E_PWR_INIT_ENABLE_CRC           (27)
#define E_PWR_INIT_ENABLE_DEWRAP        (28)
#define E_PWR_READ_TEST_FAIL            (30)
#define E_PWR_WRITE_TEST_FAIL           (31)
#define E_PWR_SWITCH_DIO                (32)


/*-----macro for read/write register -------------------------------------*/
#define WRAP_RD32(addr)            __raw_readl((void *)addr)
#define WRAP_WR32(addr, val)        mt_reg_sync_writel((val), ((void *)addr))

#define WRAP_SET_BIT(BS, REG) \
mt_reg_sync_writel((__raw_readl((void *)REG) | (u32)(BS)), ((void *)REG))
#define WRAP_CLR_BIT(BS, REG) \
mt_reg_sync_writel((__raw_readl((void *)REG) & (~(u32)(BS))), ((void *)REG))




/**************** end ---external API***********************************/

/************* macro for spi clock config ******************************/
/* #if (MTK_PLATFORM_MT6757) || (MTK_PLATFORM_MT6757_OE2) */
#define CLK_CFG_4_SET				(TOPCKGEN_BASE+0x084)
#define CLK_CFG_4_CLR				(TOPCKGEN_BASE+0x088)
#define CLK_CFG_5_SET				(TOPCKGEN_BASE+0x094)
#define CLK_CFG_5_CLR				(TOPCKGEN_BASE+0x098)

#define CLK_SPI_CK_26M				0x1
#define INFRA_GLOBALCON_RST0			(INFRACFG_AO_REG_BASE+0x140)
#define INFRA_GLOBALCON_RST1			(INFRACFG_AO_REG_BASE+0x144)
#define PMIC_CLOCK_DCM				(INFRACFG_AO_REG_BASE+0x074)
#define APB_CLOCK_GATING			(INFRACFG_AO_REG_BASE+0xF0C)
/* #endif *//* end of MTK_PLATFORM_MT6757 */
#define MODULE_SW_CG_0_SET			(INFRACFG_AO_REG_BASE+0x080)
#define MODULE_SW_CG_0_CLR			(INFRACFG_AO_REG_BASE+0x084)
#define MODULE_CLK_SEL				(INFRACFG_AO_REG_BASE+0x098)
#define MODULE_SW_CG_2_SET			(INFRACFG_AO_REG_BASE+0x0A4)
#define MODULE_SW_CG_2_CLR			(INFRACFG_AO_REG_BASE+0x0A8)
#define INFRA_GLOBALCON_RST2_SET		(INFRACFG_AO_REG_BASE+0x140)
#define INFRA_GLOBALCON_RST2_CLR		(INFRACFG_AO_REG_BASE+0x144)

/*****************************************************************/
#define PMIC_WRAP_MUX_SEL	((UINT32P)(PMIC_WRAP_BASE+0x0))
#define PMIC_WRAP_WRAP_EN	((UINT32P)(PMIC_WRAP_BASE+0x4))
#define PMIC_WRAP_DIO_EN	((UINT32P)(PMIC_WRAP_BASE+0x8))
#define PMIC_WRAP_SI_SAMPLE_CTRL	((UINT32P)(PMIC_WRAP_BASE+0xC))
#define PMIC_WRAP_SI_SAMPLE_CTRL_ULPOSC	((UINT32P)(PMIC_WRAP_BASE+0x10))
#define PMIC_WRAP_RDDMY	((UINT32P)(PMIC_WRAP_BASE+0x14))
#define PMIC_WRAP_CSHEXT_WRITE	((UINT32P)(PMIC_WRAP_BASE+0x18))
#define PMIC_WRAP_CSHEXT_READ	((UINT32P)(PMIC_WRAP_BASE+0x1C))
#define PMIC_WRAP_CSLEXT_WRITE	((UINT32P)(PMIC_WRAP_BASE+0x20))
#define PMIC_WRAP_CSLEXT_READ	((UINT32P)(PMIC_WRAP_BASE+0x24))
#define PMIC_WRAP_EXT_CK_WRITE	((UINT32P)(PMIC_WRAP_BASE+0x28))
#define PMIC_WRAP_EXT_CK_READ	((UINT32P)(PMIC_WRAP_BASE+0x2C))
#define PMIC_WRAP_STAUPD_CTRL	((UINT32P)(PMIC_WRAP_BASE+0x30))
#define PMIC_WRAP_STAUPD_GRPEN	((UINT32P)(PMIC_WRAP_BASE+0x34))
#define PMIC_WRAP_EINT_STA0_ADR	((UINT32P)(PMIC_WRAP_BASE+0x38))
#define PMIC_WRAP_EINT_STA1_ADR	((UINT32P)(PMIC_WRAP_BASE+0x3C))
#define PMIC_WRAP_EINT_STA	((UINT32P)(PMIC_WRAP_BASE+0x40))
#define PMIC_WRAP_EINT_CLR	((UINT32P)(PMIC_WRAP_BASE+0x44))
#define PMIC_WRAP_EINT_CTRL	((UINT32P)(PMIC_WRAP_BASE+0x48))
#define PMIC_WRAP_STAUPD_MAN_TRIG	((UINT32P)(PMIC_WRAP_BASE+0x4C))
#define PMIC_WRAP_STAUPD_STA	((UINT32P)(PMIC_WRAP_BASE+0x50))
#define PMIC_WRAP_WRAP_STA	((UINT32P)(PMIC_WRAP_BASE+0x54))
#define PMIC_WRAP_HARB_INIT	((UINT32P)(PMIC_WRAP_BASE+0x58))
#define PMIC_WRAP_HARB_HPRIO	((UINT32P)(PMIC_WRAP_BASE+0x5C))
#define PMIC_WRAP_HPRIO_ARB_EN	((UINT32P)(PMIC_WRAP_BASE+0x60))
#define PMIC_WRAP_HARB_STA0	((UINT32P)(PMIC_WRAP_BASE+0x64))
#define PMIC_WRAP_HARB_STA1	((UINT32P)(PMIC_WRAP_BASE+0x68))
#define PMIC_WRAP_HARB_STA2	((UINT32P)(PMIC_WRAP_BASE+0x6C))
#define PMIC_WRAP_MAN_EN	((UINT32P)(PMIC_WRAP_BASE+0x70))
#define PMIC_WRAP_MAN_CMD	((UINT32P)(PMIC_WRAP_BASE+0x74))
#define PMIC_WRAP_MAN_RDATA	((UINT32P)(PMIC_WRAP_BASE+0x78))
#define PMIC_WRAP_MAN_VLDCLR	((UINT32P)(PMIC_WRAP_BASE+0x7C))
#define PMIC_WRAP_WACS0_EN	((UINT32P)(PMIC_WRAP_BASE+0x80))
#define PMIC_WRAP_INIT_DONE0	((UINT32P)(PMIC_WRAP_BASE+0x84))
#define PMIC_WRAP_WACS1_EN	((UINT32P)(PMIC_WRAP_BASE+0x88))
#define PMIC_WRAP_INIT_DONE1	((UINT32P)(PMIC_WRAP_BASE+0x8C))
#define PMIC_WRAP_WACS2_EN	((UINT32P)(PMIC_WRAP_BASE+0x90))
#define PMIC_WRAP_INIT_DONE2	((UINT32P)(PMIC_WRAP_BASE+0x94))
#define PMIC_WRAP_WACS3_EN	((UINT32P)(PMIC_WRAP_BASE+0x98))
#define PMIC_WRAP_INIT_DONE3	((UINT32P)(PMIC_WRAP_BASE+0x9C))
#define PMIC_WRAP_WACS_P2P_EN	((UINT32P)(PMIC_WRAP_BASE+0xA0))
#define PMIC_WRAP_INIT_DONE_P2P	((UINT32P)(PMIC_WRAP_BASE+0xA4))
#define PMIC_WRAP_WACS_MD32_EN	((UINT32P)(PMIC_WRAP_BASE+0xA8))
#define PMIC_WRAP_INIT_DONE_MD32	((UINT32P)(PMIC_WRAP_BASE+0xAC))
#define PMIC_WRAP_INT0_EN	((UINT32P)(PMIC_WRAP_BASE+0xB0))
#define PMIC_WRAP_INT0_FLG_RAW	((UINT32P)(PMIC_WRAP_BASE+0xB4))
#define PMIC_WRAP_INT0_FLG	((UINT32P)(PMIC_WRAP_BASE+0xB8))
#define PMIC_WRAP_INT0_CLR	((UINT32P)(PMIC_WRAP_BASE+0xBC))
#define PMIC_WRAP_INT1_EN	((UINT32P)(PMIC_WRAP_BASE+0xC0))
#define PMIC_WRAP_INT1_FLG_RAW	((UINT32P)(PMIC_WRAP_BASE+0xC4))
#define PMIC_WRAP_INT1_FLG	((UINT32P)(PMIC_WRAP_BASE+0xC8))
#define PMIC_WRAP_INT1_CLR	((UINT32P)(PMIC_WRAP_BASE+0xCC))
#define PMIC_WRAP_SIG_ADR	((UINT32P)(PMIC_WRAP_BASE+0xD0))
#define PMIC_WRAP_SIG_MODE	((UINT32P)(PMIC_WRAP_BASE+0xD4))
#define PMIC_WRAP_SIG_VALUE	((UINT32P)(PMIC_WRAP_BASE+0xD8))
#define PMIC_WRAP_SIG_ERRVAL	((UINT32P)(PMIC_WRAP_BASE+0xDC))
#define PMIC_WRAP_CRC_EN	((UINT32P)(PMIC_WRAP_BASE+0xE0))
#define PMIC_WRAP_TIMER_EN	((UINT32P)(PMIC_WRAP_BASE+0xE4))
#define PMIC_WRAP_TIMER_STA	((UINT32P)(PMIC_WRAP_BASE+0xE8))
#define PMIC_WRAP_WDT_UNIT	((UINT32P)(PMIC_WRAP_BASE+0xEC))
#define PMIC_WRAP_WDT_SRC_EN_0	((UINT32P)(PMIC_WRAP_BASE+0xF0))
#define PMIC_WRAP_WDT_SRC_EN_1	((UINT32P)(PMIC_WRAP_BASE+0xF4))
#define PMIC_WRAP_WDT_FLG_0	((UINT32P)(PMIC_WRAP_BASE+0xF8))
#define PMIC_WRAP_WDT_FLG_1	((UINT32P)(PMIC_WRAP_BASE+0xFC))
#define PMIC_WRAP_DEBUG_INT_SEL	((UINT32P)(PMIC_WRAP_BASE+0x100))
#define PMIC_WRAP_DVFS_ADR0	((UINT32P)(PMIC_WRAP_BASE+0x104))
#define PMIC_WRAP_DVFS_WDATA0	((UINT32P)(PMIC_WRAP_BASE+0x108))
#define PMIC_WRAP_DVFS_ADR1	((UINT32P)(PMIC_WRAP_BASE+0x10C))
#define PMIC_WRAP_DVFS_WDATA1	((UINT32P)(PMIC_WRAP_BASE+0x110))
#define PMIC_WRAP_DVFS_ADR2	((UINT32P)(PMIC_WRAP_BASE+0x114))
#define PMIC_WRAP_DVFS_WDATA2	((UINT32P)(PMIC_WRAP_BASE+0x118))
#define PMIC_WRAP_DVFS_ADR3	((UINT32P)(PMIC_WRAP_BASE+0x11C))
#define PMIC_WRAP_DVFS_WDATA3	((UINT32P)(PMIC_WRAP_BASE+0x120))
#define PMIC_WRAP_DVFS_ADR4	((UINT32P)(PMIC_WRAP_BASE+0x124))
#define PMIC_WRAP_DVFS_WDATA4	((UINT32P)(PMIC_WRAP_BASE+0x128))
#define PMIC_WRAP_DVFS_ADR5	((UINT32P)(PMIC_WRAP_BASE+0x12C))
#define PMIC_WRAP_DVFS_WDATA5	((UINT32P)(PMIC_WRAP_BASE+0x130))
#define PMIC_WRAP_DVFS_ADR6	((UINT32P)(PMIC_WRAP_BASE+0x134))
#define PMIC_WRAP_DVFS_WDATA6	((UINT32P)(PMIC_WRAP_BASE+0x138))
#define PMIC_WRAP_DVFS_ADR7	((UINT32P)(PMIC_WRAP_BASE+0x13C))
#define PMIC_WRAP_DVFS_WDATA7	((UINT32P)(PMIC_WRAP_BASE+0x140))
#define PMIC_WRAP_DVFS_ADR8	((UINT32P)(PMIC_WRAP_BASE+0x144))
#define PMIC_WRAP_DVFS_WDATA8	((UINT32P)(PMIC_WRAP_BASE+0x148))
#define PMIC_WRAP_DVFS_ADR9	((UINT32P)(PMIC_WRAP_BASE+0x14C))
#define PMIC_WRAP_DVFS_WDATA9	((UINT32P)(PMIC_WRAP_BASE+0x150))
#define PMIC_WRAP_DVFS_ADR10	((UINT32P)(PMIC_WRAP_BASE+0x154))
#define PMIC_WRAP_DVFS_WDATA10	((UINT32P)(PMIC_WRAP_BASE+0x158))
#define PMIC_WRAP_DVFS_ADR11	((UINT32P)(PMIC_WRAP_BASE+0x15C))
#define PMIC_WRAP_DVFS_WDATA11	((UINT32P)(PMIC_WRAP_BASE+0x160))
#define PMIC_WRAP_DVFS_ADR12	((UINT32P)(PMIC_WRAP_BASE+0x164))
#define PMIC_WRAP_DVFS_WDATA12	((UINT32P)(PMIC_WRAP_BASE+0x168))
#define PMIC_WRAP_DVFS_ADR13	((UINT32P)(PMIC_WRAP_BASE+0x16C))
#define PMIC_WRAP_DVFS_WDATA13	((UINT32P)(PMIC_WRAP_BASE+0x170))
#define PMIC_WRAP_DVFS_ADR14	((UINT32P)(PMIC_WRAP_BASE+0x174))
#define PMIC_WRAP_DVFS_WDATA14	((UINT32P)(PMIC_WRAP_BASE+0x178))
#define PMIC_WRAP_DVFS_ADR15	((UINT32P)(PMIC_WRAP_BASE+0x17C))
#define PMIC_WRAP_DVFS_WDATA15	((UINT32P)(PMIC_WRAP_BASE+0x180))
#define PMIC_WRAP_DCXO_ENABLE	((UINT32P)(PMIC_WRAP_BASE+0x184))
#define PMIC_WRAP_DCXO_CONN_ADR0	((UINT32P)(PMIC_WRAP_BASE+0x188))
#define PMIC_WRAP_DCXO_CONN_WDATA0	((UINT32P)(PMIC_WRAP_BASE+0x18C))
#define PMIC_WRAP_DCXO_CONN_ADR1	((UINT32P)(PMIC_WRAP_BASE+0x190))
#define PMIC_WRAP_DCXO_CONN_WDATA1	((UINT32P)(PMIC_WRAP_BASE+0x194))
#define PMIC_WRAP_DCXO_NFC_ADR0	((UINT32P)(PMIC_WRAP_BASE+0x198))
#define PMIC_WRAP_DCXO_NFC_WDATA0	((UINT32P)(PMIC_WRAP_BASE+0x19C))
#define PMIC_WRAP_DCXO_NFC_ADR1	((UINT32P)(PMIC_WRAP_BASE+0x1A0))
#define PMIC_WRAP_DCXO_NFC_WDATA1	((UINT32P)(PMIC_WRAP_BASE+0x1A4))
#define PMIC_WRAP_SPMINF_STA_0	((UINT32P)(PMIC_WRAP_BASE+0x1A8))
#define PMIC_WRAP_SPMINF_STA_1	((UINT32P)(PMIC_WRAP_BASE+0x1AC))
#define PMIC_WRAP_SPMINF_BACKUP_STA	((UINT32P)(PMIC_WRAP_BASE+0x1B0))
#define PMIC_WRAP_SCPINF_STA	((UINT32P)(PMIC_WRAP_BASE+0x1B4))
#define PMIC_WRAP_CIPHER_KEY_SEL	((UINT32P)(PMIC_WRAP_BASE+0x1B8))
#define PMIC_WRAP_CIPHER_IV_SEL	((UINT32P)(PMIC_WRAP_BASE+0x1BC))
#define PMIC_WRAP_CIPHER_EN	((UINT32P)(PMIC_WRAP_BASE+0x1C0))
#define PMIC_WRAP_CIPHER_RDY	((UINT32P)(PMIC_WRAP_BASE+0x1C4))
#define PMIC_WRAP_CIPHER_MODE	((UINT32P)(PMIC_WRAP_BASE+0x1C8))
#define PMIC_WRAP_CIPHER_SWRST	((UINT32P)(PMIC_WRAP_BASE+0x1CC))
#define PMIC_WRAP_DCM_EN	((UINT32P)(PMIC_WRAP_BASE+0x1D0))
#define PMIC_WRAP_DCM_SPI_DBC_PRD	((UINT32P)(PMIC_WRAP_BASE+0x1D4))
#define PMIC_WRAP_DCM_DBC_PRD	((UINT32P)(PMIC_WRAP_BASE+0x1D8))
#define PMIC_WRAP_INT_GPS_AUXADC_CMD_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x1DC))
#define PMIC_WRAP_INT_GPS_AUXADC_CMD	((UINT32P)(PMIC_WRAP_BASE+0x1E0))
#define PMIC_WRAP_INT_GPS_AUXADC_RDATA_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x1E4))
#define PMIC_WRAP_EXT_GPS_AUXADC_RDATA_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x1E8))
#define PMIC_WRAP_GPSINF_0_STA	((UINT32P)(PMIC_WRAP_BASE+0x1EC))
#define PMIC_WRAP_GPSINF_1_STA	((UINT32P)(PMIC_WRAP_BASE+0x1F0))
#define PMIC_WRAP_MD_ADCINF_CTRL	((UINT32P)(PMIC_WRAP_BASE+0x1F4))
#define PMIC_WRAP_MD_AUXADC_RDATA_LATEST_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x1F8))
#define PMIC_WRAP_MD_AUXADC_RDATA_WP_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x1FC))
#define PMIC_WRAP_MD_AUXADC_RDATA_0_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x200))
#define PMIC_WRAP_MD_AUXADC_RDATA_1_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x204))
#define PMIC_WRAP_MD_AUXADC_RDATA_2_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x208))
#define PMIC_WRAP_MD_AUXADC_RDATA_3_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x20C))
#define PMIC_WRAP_MD_AUXADC_RDATA_4_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x210))
#define PMIC_WRAP_MD_AUXADC_RDATA_5_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x214))
#define PMIC_WRAP_MD_AUXADC_RDATA_6_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x218))
#define PMIC_WRAP_MD_AUXADC_RDATA_7_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x21C))
#define PMIC_WRAP_MD_AUXADC_RDATA_8_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x220))
#define PMIC_WRAP_MD_AUXADC_RDATA_9_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x224))
#define PMIC_WRAP_MD_AUXADC_RDATA_10_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x228))
#define PMIC_WRAP_MD_AUXADC_RDATA_11_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x22C))
#define PMIC_WRAP_MD_AUXADC_RDATA_12_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x230))
#define PMIC_WRAP_MD_AUXADC_RDATA_13_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x234))
#define PMIC_WRAP_MD_AUXADC_RDATA_14_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x238))
#define PMIC_WRAP_MD_AUXADC_RDATA_15_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x23C))
#define PMIC_WRAP_MD_AUXADC_RDATA_16_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x240))
#define PMIC_WRAP_MD_AUXADC_RDATA_17_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x244))
#define PMIC_WRAP_MD_AUXADC_RDATA_18_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x248))
#define PMIC_WRAP_MD_AUXADC_RDATA_19_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x24C))
#define PMIC_WRAP_MD_AUXADC_RDATA_20_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x250))
#define PMIC_WRAP_MD_AUXADC_RDATA_21_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x254))
#define PMIC_WRAP_MD_AUXADC_RDATA_22_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x258))
#define PMIC_WRAP_MD_AUXADC_RDATA_23_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x25C))
#define PMIC_WRAP_MD_AUXADC_RDATA_24_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x260))
#define PMIC_WRAP_MD_AUXADC_RDATA_25_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x264))
#define PMIC_WRAP_MD_AUXADC_RDATA_26_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x268))
#define PMIC_WRAP_MD_AUXADC_RDATA_27_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x26C))
#define PMIC_WRAP_MD_AUXADC_RDATA_28_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x270))
#define PMIC_WRAP_MD_AUXADC_RDATA_29_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x274))
#define PMIC_WRAP_MD_AUXADC_RDATA_30_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x278))
#define PMIC_WRAP_MD_AUXADC_RDATA_31_ADDR ((UINT32P)(PMIC_WRAP_BASE+0x27C))
#define PMIC_WRAP_MD_ADCINF_0_STA_0	((UINT32P)(PMIC_WRAP_BASE+0x280))
#define PMIC_WRAP_MD_ADCINF_0_STA_1	((UINT32P)(PMIC_WRAP_BASE+0x284))
#define PMIC_WRAP_MD_ADCINF_1_STA_0	((UINT32P)(PMIC_WRAP_BASE+0x288))
#define PMIC_WRAP_MD_ADCINF_1_STA_1	((UINT32P)(PMIC_WRAP_BASE+0x28C))
#define PMIC_WRAP_SWRST	((UINT32P)(PMIC_WRAP_BASE+0x290))
#define PMIC_WRAP_SPM_SLEEP_GATING_CTRL	((UINT32P)(PMIC_WRAP_BASE+0x294))
#define PMIC_WRAP_SCP_SLEEP_GATING_CTRL	((UINT32P)(PMIC_WRAP_BASE+0x298))
#define PMIC_WRAP_PRIORITY_USER_SEL_0	((UINT32P)(PMIC_WRAP_BASE+0x29C))
#define PMIC_WRAP_PRIORITY_USER_SEL_1	((UINT32P)(PMIC_WRAP_BASE+0x2A0))
#define PMIC_WRAP_PRIORITY_USER_SEL_2	((UINT32P)(PMIC_WRAP_BASE+0x2A4))
#define PMIC_WRAP_PRIORITY_USER_SEL_3	((UINT32P)(PMIC_WRAP_BASE+0x2A8))
#define PMIC_WRAP_PRIORITY_USER_SEL_4	((UINT32P)(PMIC_WRAP_BASE+0x2AC))
#define PMIC_WRAP_ARBITER_OUT_SEL_0	((UINT32P)(PMIC_WRAP_BASE+0x2B0))
#define PMIC_WRAP_ARBITER_OUT_SEL_1	((UINT32P)(PMIC_WRAP_BASE+0x2B4))
#define PMIC_WRAP_ARBITER_OUT_SEL_2	((UINT32P)(PMIC_WRAP_BASE+0x2B8))
#define PMIC_WRAP_ARBITER_OUT_SEL_3	((UINT32P)(PMIC_WRAP_BASE+0x2BC))
#define PMIC_WRAP_ARBITER_OUT_SEL_4	((UINT32P)(PMIC_WRAP_BASE+0x2C0))
#define PMIC_WRAP_STARV_COUNTER_0	((UINT32P)(PMIC_WRAP_BASE+0x2C4))
#define PMIC_WRAP_STARV_COUNTER_1	((UINT32P)(PMIC_WRAP_BASE+0x2C8))
#define PMIC_WRAP_STARV_COUNTER_2	((UINT32P)(PMIC_WRAP_BASE+0x2CC))
#define PMIC_WRAP_STARV_COUNTER_3	((UINT32P)(PMIC_WRAP_BASE+0x2D0))
#define PMIC_WRAP_STARV_COUNTER_4	((UINT32P)(PMIC_WRAP_BASE+0x2D4))
#define PMIC_WRAP_STARV_COUNTER_5	((UINT32P)(PMIC_WRAP_BASE+0x2D8))
#define PMIC_WRAP_STARV_COUNTER_6	((UINT32P)(PMIC_WRAP_BASE+0x2DC))
#define PMIC_WRAP_STARV_COUNTER_7	((UINT32P)(PMIC_WRAP_BASE+0x2E0))
#define PMIC_WRAP_STARV_COUNTER_8	((UINT32P)(PMIC_WRAP_BASE+0x2E4))
#define PMIC_WRAP_STARV_COUNTER_9	((UINT32P)(PMIC_WRAP_BASE+0x2E8))
#define PMIC_WRAP_STARV_COUNTER_10	((UINT32P)(PMIC_WRAP_BASE+0x2EC))
#define PMIC_WRAP_STARV_COUNTER_11	((UINT32P)(PMIC_WRAP_BASE+0x2F0))
#define PMIC_WRAP_STARV_COUNTER_12	((UINT32P)(PMIC_WRAP_BASE+0x2F4))
#define PMIC_WRAP_STARV_COUNTER_13	((UINT32P)(PMIC_WRAP_BASE+0x2F8))
#define PMIC_WRAP_STARV_COUNTER_14	((UINT32P)(PMIC_WRAP_BASE+0x2FC))
#define PMIC_WRAP_STARV_COUNTER_15	((UINT32P)(PMIC_WRAP_BASE+0x300))
#define PMIC_WRAP_STARV_COUNTER_16	((UINT32P)(PMIC_WRAP_BASE+0x304))
#define PMIC_WRAP_STARV_COUNTER_0_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x308))
#define PMIC_WRAP_STARV_COUNTER_1_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x30C))
#define PMIC_WRAP_STARV_COUNTER_2_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x310))
#define PMIC_WRAP_STARV_COUNTER_3_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x314))
#define PMIC_WRAP_STARV_COUNTER_4_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x318))
#define PMIC_WRAP_STARV_COUNTER_5_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x31C))
#define PMIC_WRAP_STARV_COUNTER_6_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x320))
#define PMIC_WRAP_STARV_COUNTER_7_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x324))
#define PMIC_WRAP_STARV_COUNTER_8_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x328))
#define PMIC_WRAP_STARV_COUNTER_9_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x32C))
#define PMIC_WRAP_STARV_COUNTER_10_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x330))
#define PMIC_WRAP_STARV_COUNTER_11_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x334))
#define PMIC_WRAP_STARV_COUNTER_12_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x338))
#define PMIC_WRAP_STARV_COUNTER_13_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x33C))
#define PMIC_WRAP_STARV_COUNTER_14_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x340))
#define PMIC_WRAP_STARV_COUNTER_15_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x344))
#define PMIC_WRAP_STARV_COUNTER_16_STATUS ((UINT32P)(PMIC_WRAP_BASE+0x348))
#define PMIC_WRAP_STARV_COUNTER_CLR	((UINT32P)(PMIC_WRAP_BASE+0x34C))
#define PMIC_WRAP_STARV_PRIO_STATUS	((UINT32P)(PMIC_WRAP_BASE+0x350))
#define PMIC_WRAP_MONITOR_CTRL_0	((UINT32P)(PMIC_WRAP_BASE+0x354))
#define PMIC_WRAP_MONITOR_CTRL_1	((UINT32P)(PMIC_WRAP_BASE+0x358))
#define PMIC_WRAP_MONITOR_CTRL_2	((UINT32P)(PMIC_WRAP_BASE+0x35C))
#define PMIC_WRAP_MONITOR_CTRL_3	((UINT32P)(PMIC_WRAP_BASE+0x360))
#define PMIC_WRAP_CHANNEL_SEQUENCE_0	((UINT32P)(PMIC_WRAP_BASE+0x364))
#define PMIC_WRAP_CHANNEL_SEQUENCE_1	((UINT32P)(PMIC_WRAP_BASE+0x368))
#define PMIC_WRAP_CHANNEL_SEQUENCE_2	((UINT32P)(PMIC_WRAP_BASE+0x36C))
#define PMIC_WRAP_CHANNEL_SEQUENCE_3	((UINT32P)(PMIC_WRAP_BASE+0x370))
#define PMIC_WRAP_CMD_SEQUENCE_0	((UINT32P)(PMIC_WRAP_BASE+0x374))
#define PMIC_WRAP_CMD_SEQUENCE_1	((UINT32P)(PMIC_WRAP_BASE+0x378))
#define PMIC_WRAP_CMD_SEQUENCE_2	((UINT32P)(PMIC_WRAP_BASE+0x37C))
#define PMIC_WRAP_CMD_SEQUENCE_3	((UINT32P)(PMIC_WRAP_BASE+0x380))
#define PMIC_WRAP_CMD_SEQUENCE_4	((UINT32P)(PMIC_WRAP_BASE+0x384))
#define PMIC_WRAP_CMD_SEQUENCE_5	((UINT32P)(PMIC_WRAP_BASE+0x388))
#define PMIC_WRAP_CMD_SEQUENCE_6	((UINT32P)(PMIC_WRAP_BASE+0x38C))
#define PMIC_WRAP_CMD_SEQUENCE_7	((UINT32P)(PMIC_WRAP_BASE+0x390))
#define PMIC_WRAP_WDATA_SEQUENCE_0	((UINT32P)(PMIC_WRAP_BASE+0x394))
#define PMIC_WRAP_WDATA_SEQUENCE_1	((UINT32P)(PMIC_WRAP_BASE+0x398))
#define PMIC_WRAP_WDATA_SEQUENCE_2	((UINT32P)(PMIC_WRAP_BASE+0x39C))
#define PMIC_WRAP_WDATA_SEQUENCE_3	((UINT32P)(PMIC_WRAP_BASE+0x3A0))
#define PMIC_WRAP_WDATA_SEQUENCE_4	((UINT32P)(PMIC_WRAP_BASE+0x3A4))
#define PMIC_WRAP_WDATA_SEQUENCE_5	((UINT32P)(PMIC_WRAP_BASE+0x3A8))
#define PMIC_WRAP_WDATA_SEQUENCE_6	((UINT32P)(PMIC_WRAP_BASE+0x3AC))
#define PMIC_WRAP_WDATA_SEQUENCE_7	((UINT32P)(PMIC_WRAP_BASE+0x3B0))
#define PMIC_WRAP_DEBUG_SW_DRIVER_0	((UINT32P)(PMIC_WRAP_BASE+0x3B4))
#define PMIC_WRAP_DEBUG_SW_DRIVER_1	((UINT32P)(PMIC_WRAP_BASE+0x3B8))
#define PMIC_WRAP_DEBUG_SW_DRIVER_2	((UINT32P)(PMIC_WRAP_BASE+0x3BC))
#define PMIC_WRAP_DEBUG_SW_DRIVER_3	((UINT32P)(PMIC_WRAP_BASE+0x3C0))
#define PMIC_WRAP_DEBUG_SW_DRIVER_4	((UINT32P)(PMIC_WRAP_BASE+0x3C4))
#define PMIC_WRAP_DEBUG_SW_DRIVER_5	((UINT32P)(PMIC_WRAP_BASE+0x3C8))
#define PMIC_WRAP_BWC_OPTIONS	((UINT32P)(PMIC_WRAP_BASE+0x3CC))
#define PMIC_WRAP_RESERVED	((UINT32P)(PMIC_WRAP_BASE+0x3D0))
#define PMIC_WRAP_WACS0_CMD	((UINT32P)(PMIC_WRAP_BASE+0xC00))
#define PMIC_WRAP_WACS0_RDATA	((UINT32P)(PMIC_WRAP_BASE+0xC04))
#define PMIC_WRAP_WACS0_VLDCLR	((UINT32P)(PMIC_WRAP_BASE+0xC08))
#define PMIC_WRAP_WACS1_CMD	((UINT32P)(PMIC_WRAP_BASE+0xC10))
#define PMIC_WRAP_WACS1_RDATA	((UINT32P)(PMIC_WRAP_BASE+0xC14))
#define PMIC_WRAP_WACS1_VLDCLR	((UINT32P)(PMIC_WRAP_BASE+0xC18))
#define PMIC_WRAP_WACS2_CMD	((UINT32P)(PMIC_WRAP_BASE+0xC20))
#define PMIC_WRAP_WACS2_RDATA	((UINT32P)(PMIC_WRAP_BASE+0xC24))
#define PMIC_WRAP_WACS2_VLDCLR	((UINT32P)(PMIC_WRAP_BASE+0xC28))
#define PMIC_WRAP_WACS3_CMD	((UINT32P)(PMIC_WRAP_BASE+0xC30))
#define PMIC_WRAP_WACS3_RDATA	((UINT32P)(PMIC_WRAP_BASE+0xC34))
#define PMIC_WRAP_WACS3_VLDCLR	((UINT32P)(PMIC_WRAP_BASE+0xC38))

#define GET_MUX_SEL(x)               ((x>>0)  & 0x00000001)
#define GET_WRAP_EN(x)               ((x>>0)  & 0x00000001)
#define GET_DIO_EN0(x)               ((x>>0)  & 0x00000001)
#define GET_DIO_EN1(x)               ((x>>1)  & 0x00000001)
#define GET_SI_DLY0(x)               ((x>>0)  & 0x0000001f)
#define GET_SI_CK_SEL0(x)            ((x>>5)  & 0x00000001)
#define GET_SI_EN_SEL0(x)            ((x>>6)  & 0x00000007)
#define GET_SI_DLY1(x)               ((x>>9)  & 0x0000001f)
#define GET_SI_CK_SEL1(x)            ((x>>14) & 0x00000001)
#define GET_SI_EN_SEL1(x)            ((x>>15) & 0x00000007)
#define GET_DUAL_SI_SAMPLE_SETTINGS(x)  ((x>>18) & 0x00000001)
#define GET_SI_DLY0_ULPOSC(x)        ((x>>0)  & 0x0000001f)
#define GET_SI_CK_SEL0_ULPOSC(x)     ((x>>5)  & 0x00000001)
#define GET_SI_EN_SEL0_ULPOSC(x)     ((x>>6)  & 0x00000007)
#define GET_SI_DLY1_ULPOSC(x)        ((x>>9)  & 0x0000001f)
#define GET_SI_CK_SEL1_ULPOSC(x)     ((x>>14) & 0x00000001)
#define GET_SI_EN_SEL1_ULPOSC(x)     ((x>>15) & 0x00000007)
#define GET_ULPOSC_SI_SAMPLING_SETTINGS_EN(x)  ((x>>18) & 0x00000001)
#define GET_RDDMY0(x)                ((x>>0)  & 0x000000ff)
#define GET_RDDMY1(x)                ((x>>8)  & 0x000000ff)
#define GET_CSHEXT_WRITE_START(x)    ((x>>0)  & 0x000000ff)
#define GET_CSHEXT_WRITE_END(x)      ((x>>8)  & 0x000000ff)
#define GET_CSHEXT_READ_START(x)     ((x>>0)  & 0x000000ff)
#define GET_CSHEXT_READ_END(x)       ((x>>8)  & 0x000000ff)
#define GET_CSLEXT_WRITE_START(x)    ((x>>0)  & 0x000000ff)
#define GET_CSLEXT_WRITE_END(x)      ((x>>8)  & 0x000000ff)
#define GET_CSLEXT_READ_START(x)     ((x>>0)  & 0x000000ff)
#define GET_CSLEXT_READ_END(x)       ((x>>8)  & 0x000000ff)
#define GET_EXT_CK_WRITE(x)          ((x>>0)  & 0x000000ff)
#define GET_EXT_CK_READ(x)           ((x>>0)  & 0x000000ff)
#define GET_STAUPD_PRD(x)            ((x>>0)  & 0x0000000f)
#define GET_STAUPD_FETCH_ALL(x)      ((x>>4)  & 0x00000001)
#define GET_STAUPD_GRPEN(x)          ((x>>0)  & 0x000001ff)
#define GET_EINT_STA0_ADR(x)         ((x>>0)  & 0x0000ffff)
#define GET_EINT_STA1_ADR(x)         ((x>>0)  & 0x0000ffff)
#define GET_EINT_STA(x)              ((x>>0)  & 0x0000000f)
#define GET_EINT_CLR(x)              ((x>>0)  & 0x0000000f)
#define GET_EINT_BY_STAUPD_CTRL_SEL(x)  ((x>>0)  & 0x00000007)
#define GET_PMIC_EINT_OUT_0_SRC_SEL_NORMAL(x)  ((x>>3)  & 0x00000003)
#define GET_PMIC_EINT_OUT_0_SRC_SEL_SLEEP(x)  ((x>>5)  & 0x00000001)
#define GET_PMIC_EINT_OUT_1_SRC_SEL_NORMAL(x)  ((x>>6)  & 0x00000003)
#define GET_PMIC_EINT_OUT_1_SRC_SEL_SLEEP(x)  ((x>>8)  & 0x00000001)
#define GET_PMIC_EINT_SCP_SRC_SEL_NORMAL(x)  ((x>>9)  & 0x00000003)
#define GET_PMIC_EINT_SCP_SRC_SEL_SLEEP(x)  ((x>>11) & 0x00000001)
#define GET_SPM_PMIC_EINT_ACK_STAUPD_NO_SEL(x)  ((x>>12) & 0x0000000f)
#define GET_STAUPD_MAN_TRIG(x)       ((x>>0)  & 0x00000001)
#define GET_STAUPD_DLE_CNT(x)        ((x>>0)  & 0x0000000f)
#define GET_STAUPD_ALE_CNT(x)        ((x>>4)  & 0x0000000f)
#define GET_GRP_REQ_PENDING(x)       ((x>>8)  & 0x000001ff)
#define GET_GRP_DATA_PENDING(x)      ((x>>17) & 0x000001ff)
#define GET_STAUPD_FSM(x)            ((x>>26) & 0x00000007)
#define GET_WRAP_CH_DLE_RESTCNT(x)   ((x>>0)  & 0x00000007)
#define GET_WRAP_CH_ALE_RESTCNT(x)   ((x>>3)  & 0x00000003)
#define GET_WRAP_AG_DLE_RESTCNT(x)   ((x>>5)  & 0x00000003)
#define GET_WRAP_CH_W(x)             ((x>>7)  & 0x00000001)
#define GET_WRAP_CH_REQ(x)           ((x>>8)  & 0x00000001)
#define GET_AG_WRAP_W(x)             ((x>>9)  & 0x00000001)
#define GET_AG_WRAP_REQ(x)           ((x>>10) & 0x00000001)
#define GET_WRAP_FSM(x)              ((x>>11) & 0x0000000f)
#define GET_HARB_INIT(x)             ((x>>0)  & 0x00000001)
#define GET_HARB_HPRIO(x)            ((x>>0)  & 0x0000ffff)
#define GET_WACS0_HARB_EN(x)         ((x>>0)  & 0x00000001)
#define GET_WACS1_HARB_EN(x)         ((x>>1)  & 0x00000001)
#define GET_WACS2_HARB_EN(x)         ((x>>2)  & 0x00000001)
#define GET_WACS3_HARB_EN(x)         ((x>>3)  & 0x00000001)
#define GET_WACS_P2P_HARB_EN(x)      ((x>>4)  & 0x00000001)
#define GET_WACS_MD32_HARB_EN(x)     ((x>>5)  & 0x00000001)
#define GET_MDINF_HARB_EN(x)         ((x>>6)  & 0x00000001)
#define GET_C2KINF_HARB_EN(x)        ((x>>7)  & 0x00000001)
#define GET_MD_DVFSINF_HARB_EN(x)    ((x>>8)  & 0x00000001)
#define GET_SPMINF_HARB_EN(x)        ((x>>9)  & 0x00000001)
#define GET_SPMINF_BACKUP_HARB_EN(x)  ((x>>10) & 0x00000001)
#define GET_DCXO_CONNINF_HARB_EN(x)  ((x>>11) & 0x00000001)
#define GET_DCXO_NFCINF_HARB_EN(x)   ((x>>12) & 0x00000001)
#define GET_MD_ADCINF_0_HARB_EN(x)   ((x>>13) & 0x00000001)
#define GET_MD_ADCINF_1_HARB_EN(x)   ((x>>14) & 0x00000001)
#define GET_GPSINF_0_HARB_EN(x)      ((x>>15) & 0x00000001)
#define GET_GPSINF_1_HARB_EN(x)      ((x>>16) & 0x00000001)
#define GET_STAUPD_HARB_EN(x)        ((x>>17) & 0x00000001)
#define GET_HARB_WRAP_WDATA(x)       ((x>>0)  & 0x0000ffff)
#define GET_HARB_WRAP_ADR(x)         ((x>>16) & 0x00007fff)
#define GET_HARB_WRAP_W(x)           ((x>>31) & 0x00000001)
#define GET_AG_HARB_REQ(x)           ((x>>0)  & 0x0000ffff)
#define GET_HARB_WRAP_REQ(x)         ((x>>31) & 0x00000001)
#define GET_HARB_DLE_EMPTY(x)        ((x>>0)  & 0x00000001)
#define GET_HARB_DLE_FULL(x)         ((x>>1)  & 0x00000001)
#define GET_HARB_VLD(x)              ((x>>2)  & 0x00000001)
#define GET_HARB_DLE_OWN(x)          ((x>>3)  & 0x0000000f)
#define GET_HARB_OWN(x)              ((x>>7)  & 0x0000000f)
#define GET_HARB_DLE_RESTCNT(x)      ((x>>11) & 0x0000000f)
#define GET_MAN_EN(x)                ((x>>0)  & 0x00000001)
#define GET_SPI_WDATA(x)             ((x>>0)  & 0x000000ff)
#define GET_SPI_OP(x)                ((x>>8)  & 0x0000001f)
#define GET_SPI_W(x)                 ((x>>13) & 0x00000001)
#define GET_MAN_RDATA(x)             ((x>>0)  & 0x000000ff)
#define GET_MAN_FSM(x)               ((x>>8)  & 0x00000007)
#define GET_MAN_REQ(x)               ((x>>11) & 0x00000001)
#define GET_MAN_VLDCLR(x)            ((x>>0)  & 0x00000001)
#define GET_WACS0_EN(x)              ((x>>0)  & 0x00000001)
#define GET_INIT_DONE0(x)            ((x>>0)  & 0x00000001)
#define GET_WACS1_EN(x)              ((x>>0)  & 0x00000001)
#define GET_INIT_DONE1(x)            ((x>>0)  & 0x00000001)
#define GET_WACS2_EN(x)              ((x>>0)  & 0x00000001)
#define GET_INIT_DONE2(x)            ((x>>0)  & 0x00000001)
#define GET_WACS3_EN(x)              ((x>>0)  & 0x00000001)
#define GET_INIT_DONE3(x)            ((x>>0)  & 0x00000001)
#define GET_WACS_P2P_EN(x)           ((x>>0)  & 0x00000001)
#define GET_INIT_DONE_P2P(x)         ((x>>0)  & 0x00000001)
#define GET_WACS_MD32_EN(x)          ((x>>0)  & 0x00000001)
#define GET_INIT_DONE_MD32(x)        ((x>>0)  & 0x00000001)
#define GET_INT0_EN(x)               ((x>>0)  & 0x00000000)
#define GET_INT0_FLG_RAW(x)          ((x>>0)  & 0x00000000)
#define GET_INT0_FLG(x)              ((x>>0)  & 0x00000000)
#define GET_INT0_CLR(x)              ((x>>0)  & 0x00000000)
#define GET_INT1_EN(x)               ((x>>0)  & 0x00000000)
#define GET_INT1_FLG_RAW(x)          ((x>>0)  & 0x00000000)
#define GET_INT1_FLG(x)              ((x>>0)  & 0x00000000)
#define GET_INT1_CLR(x)              ((x>>0)  & 0x00000000)
#define GET_SIG_ADR0(x)              ((x>>0)  & 0x0000ffff)
#define GET_SIG_ADR1(x)              ((x>>16) & 0x0000ffff)
#define GET_SIG_MODE0(x)             ((x>>0)  & 0x00000001)
#define GET_SIG_MODE1(x)             ((x>>1)  & 0x00000001)
#define GET_SIG_VALUE0(x)            ((x>>0)  & 0x0000ffff)
#define GET_SIG_VALUE1(x)            ((x>>16) & 0x0000ffff)
#define GET_SIG_ERRVAL0(x)           ((x>>0)  & 0x0000ffff)
#define GET_SIG_ERRVAL1(x)           ((x>>16) & 0x0000ffff)
#define GET_CRC_EN(x)                ((x>>0)  & 0x00000001)
#define GET_TIMER_EN(x)              ((x>>0)  & 0x00000001)
#define GET_WDT_TIMER(x)             ((x>>0)  & 0x0000ffff)
#define GET_STAUPD_TIMER(x)          ((x>>16) & 0x00001fff)
#define GET_WDT_UNIT(x)              ((x>>0)  & 0x0000000f)
#define GET_WDT_SRC_EN_0(x)          ((x>>0)  & 0x00000000)
#define GET_WDT_SRC_EN_1(x)          ((x>>0)  & 0x00000000)
#define GET_WDT_FLG_0(x)             ((x>>0)  & 0x00000000)
#define GET_WDT_FLG_1(x)             ((x>>0)  & 0x00000000)
#define GET_DEBUG_INT_SEL(x)         ((x>>0)  & 0x00000007)
#define GET_DVFS_ADR0(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA0(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR1(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA1(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR2(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA2(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR3(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA3(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR4(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA4(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR5(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA5(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR6(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA6(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR7(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA7(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR8(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA8(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR9(x)             ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA9(x)           ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR10(x)            ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA10(x)          ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR11(x)            ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA11(x)          ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR12(x)            ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA12(x)          ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR13(x)            ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA13(x)          ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR14(x)            ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA14(x)          ((x>>0)  & 0x0000ffff)
#define GET_DVFS_ADR15(x)            ((x>>0)  & 0x0000ffff)
#define GET_DVFS_WDATA15(x)          ((x>>0)  & 0x0000ffff)
#define GET_DCXO_NFC_ENABLE(x)       ((x>>0)  & 0x00000001)
#define GET_DCXO_CONN_ENABLE(x)      ((x>>1)  & 0x00000001)
#define GET_DCXO_CONN_ADR0(x)        ((x>>0)  & 0x0000ffff)
#define GET_DCXO_CONN_WDATA0(x)      ((x>>0)  & 0x0000ffff)
#define GET_DCXO_CONN_ADR1(x)        ((x>>0)  & 0x0000ffff)
#define GET_DCXO_CONN_WDATA1(x)      ((x>>0)  & 0x0000ffff)
#define GET_DCXO_NFC_ADR0(x)         ((x>>0)  & 0x0000ffff)
#define GET_DCXO_NFC_WDATA0(x)       ((x>>0)  & 0x0000ffff)
#define GET_DCXO_NFC_ADR1(x)         ((x>>0)  & 0x0000ffff)
#define GET_DCXO_NFC_WDATA1(x)       ((x>>0)  & 0x0000ffff)
#define GET_SPM_PWRAP_REQ(x)         ((x>>0)  & 0x00000001)
#define GET_PWRAP_SPM_ACK(x)         ((x>>1)  & 0x00000001)
#define GET_SPM_PMIC_EINT_REQ(x)     ((x>>2)  & 0x00000001)
#define GET_SPM_PMIC_EINT_ACK(x)     ((x>>3)  & 0x00000001)
#define GET_SPM_SLEEP_REQ(x)         ((x>>4)  & 0x00000001)
#define GET_SPM_SLEEP_ACK(x)         ((x>>5)  & 0x00000001)
#define GET_SPMINF_BUSY(x)           ((x>>6)  & 0x00000001)
#define GET_SPM_PWRAP_ADR(x)         ((x>>0)  & 0x0000ffff)
#define GET_SPM_PWRAP_WDATA(x)       ((x>>16) & 0x0000ffff)
#define GET_SPM_PWRAP_DVFS_CTRL_RDY(x)  ((x>>0)  & 0x00000001)
#define GET_SPM_PWRAP_DVFS_CTRL(x)   ((x>>1)  & 0x0000000f)
#define GET_PWRAP_SPM_DVFS_CTRL_ACK(x)  ((x>>5)  & 0x00000001)
#define GET_SPMINF_BACKUP_BUSY(x)    ((x>>6)  & 0x00000001)
#define GET_SCP_SLEEP_REQ(x)         ((x>>0)  & 0x00000001)
#define GET_SCP_SLEEP_ACK(x)         ((x>>1)  & 0x00000001)
#define GET_PMIC_EINT_SCP(x)         ((x>>2)  & 0x00000001)
#define GET_CIPHER_KEY_SEL(x)        ((x>>0)  & 0x00000003)
#define GET_CIPHER_IV_SEL(x)         ((x>>0)  & 0x00000003)
#define GET_CIPHER_EN(x)             ((x>>0)  & 0x00000001)
#define GET_CIPHER_RDY(x)            ((x>>0)  & 0x00000003)
#define GET_CIPHER_MODE(x)           ((x>>0)  & 0x00000001)
#define GET_CIPHER_SWRST(x)          ((x>>0)  & 0x00000001)
#define GET_DCM_EN(x)                ((x>>0)  & 0x00000001)
#define GET_PCLK_MPU_EXCEPT_DCM_EN(x)  ((x>>1)  & 0x00000001)
#define GET_WACS_CK_DCM_EN(x)        ((x>>2)  & 0x00000001)
#define GET_MD_CK_DCM_EN(x)          ((x>>3)  & 0x00000001)
#define GET_C2K_CK_DCM_EN(x)         ((x>>4)  & 0x00000001)
#define GET_MD_DVFS_CK_DCM_EN(x)     ((x>>5)  & 0x00000001)
#define GET_SPMINF_CK_DCM_EN(x)      ((x>>6)  & 0x00000001)
#define GET_SPMINF_BACKUP_CK_DCM_EN(x)  ((x>>7)  & 0x00000001)
#define GET_DCXO_CK_DCM_EN(x)        ((x>>8)  & 0x00000001)
#define GET_MD_ADCINF_0_CK_DCM_EN(x)  ((x>>9)  & 0x00000001)
#define GET_MD_ADCINF_1_CK_DCM_EN(x)  ((x>>10) & 0x00000001)
#define GET_GPSINF_0_CK_DCM_EN(x)    ((x>>11) & 0x00000001)
#define GET_GPSINF_1_CK_DCM_EN(x)    ((x>>12) & 0x00000001)
#define GET_MD32INF_CK_DCM_EN(x)     ((x>>13) & 0x00000001)
#define GET_STAUPD_CK_DCM_EN(x)      ((x>>14) & 0x00000001)
#define GET_ARBITER_CK_DCM_EN(x)     ((x>>15) & 0x00000001)
#define GET_CRC_CK_DCM_EN(x)         ((x>>16) & 0x00000001)
#define GET_SPI_CK_DCM_EN(x)         ((x>>17) & 0x00000001)
#define GET_DCM_SPI_DBC_PRD(x)       ((x>>0)  & 0x000000ff)
#define GET_DCM_DBC_PRD(x)           ((x>>0)  & 0x000000ff)
#define GET_INT_GPS_AUXADC_CMD_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_INT_GPS_AUXADC_CMD_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_INT_GPS_AUXADC_CMD_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_INT_GPS_AUXADC_CMD_1(x)  ((x>>16) & 0x0000ffff)
#define GET_INT_GPS_AUXADC_RDATA_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_INT_GPS_AUXADC_RDATA_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_EXT_GPS_AUXADC_RDATA_ADDR(x)  ((x>>0)  & 0x0000ffff)
#define GET_GPS_PWRAP_REQ_0(x)       ((x>>0)  & 0x00000001)
#define GET_PWRAP_GPS_ACK_0(x)       ((x>>1)  & 0x00000001)
#define GET_PWRAP_GPS_RDATA_0(x)     ((x>>2)  & 0x00007fff)
#define GET_PWRAP_GPS_RDATA_VALID_0(x)  ((x>>17) & 0x00000001)
#define GET_GPSINF_0_FSM(x)          ((x>>18) & 0x00000007)
#define GET_GPSINF_0_BUSY(x)         ((x>>21) & 0x00000001)
#define GET_GPS_PWRAP_REQ_1(x)       ((x>>0)  & 0x00000001)
#define GET_PWRAP_GPS_ACK_1(x)       ((x>>1)  & 0x00000001)
#define GET_PWRAP_GPS_RDATA_1(x)     ((x>>2)  & 0x00007fff)
#define GET_PWRAP_GPS_RDATA_VALID_1(x)  ((x>>17) & 0x00000001)
#define GET_GPSINF_1_FSM(x)          ((x>>18) & 0x00000007)
#define GET_GPSINF_1_BUSY(x)         ((x>>21) & 0x00000001)
#define GET_MD_AUXADC_MODE_LATCH_SEL_0(x)  ((x>>0)  & 0x00000001)
#define GET_MD_AUXADC_MODE_LATCH_SEL_1(x)  ((x>>1)  & 0x00000001)
#define GET_MD_AUXADC_RDATA_LATEST_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_LATEST_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_WP_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_WP_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_0_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_0_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_1_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_1_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_2_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_2_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_3_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_3_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_4_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_4_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_5_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_5_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_6_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_6_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_7_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_7_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_8_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_8_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_9_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_9_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_10_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_10_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_11_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_11_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_12_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_12_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_13_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_13_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_14_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_14_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_15_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_15_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_16_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_16_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_17_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_17_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_18_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_18_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_19_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_19_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_20_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_20_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_21_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_21_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_22_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_22_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_23_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_23_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_24_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_24_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_25_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_25_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_26_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_26_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_27_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_27_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_28_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_28_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_29_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_29_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_30_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_30_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_31_ADDR_0(x)  ((x>>0)  & 0x0000ffff)
#define GET_MD_AUXADC_RDATA_31_ADDR_1(x)  ((x>>16) & 0x0000ffff)
#define GET_MTS_PWRAP_REQ_0(x)       ((x>>0)  & 0x00000001)
#define GET_PWRAP_MTS_ACK_0(x)       ((x>>1)  & 0x00000001)
#define GET_PWRAP_MTS_RDATA_0(x)     ((x>>2)  & 0x0000ffff)
#define GET_PWRAP_MTS_RDATA_VALID_0(x)  ((x>>18) & 0x00000001)
#define GET_MD_ADCINF_0_FSM(x)       ((x>>19) & 0x00000007)
#define GET_MD_ADCINF_0_BUSY(x)      ((x>>22) & 0x00000001)
#define GET_MD_ADCINF_0_ALE_CNT(x)   ((x>>0)  & 0x0000003f)
#define GET_MD_ADCINF_0_DLE_CNT_REAL(x)  ((x>>6)  & 0x0000003f)
#define GET_MD_ADCINF_0_ALE_CNT_FULL(x)  ((x>>12) & 0x00000001)
#define GET_MD_ADCINF_0_DLE_CNT_FULL(x)  ((x>>13) & 0x00000001)
#define GET_MTS_PWRAP_REQ_1(x)       ((x>>0)  & 0x00000001)
#define GET_PWRAP_MTS_ACK_1(x)       ((x>>1)  & 0x00000001)
#define GET_PWRAP_MTS_RDATA_1(x)     ((x>>2)  & 0x0000ffff)
#define GET_PWRAP_MTS_RDATA_VALID_1(x)  ((x>>18) & 0x00000001)
#define GET_MD_ADCINF_1_FSM(x)       ((x>>19) & 0x00000007)
#define GET_MD_ADCINF_1_BUSY(x)      ((x>>22) & 0x00000001)
#define GET_MD_ADCINF_1_ALE_CNT(x)   ((x>>0)  & 0x0000003f)
#define GET_MD_ADCINF_1_DLE_CNT_REAL(x)  ((x>>6)  & 0x0000003f)
#define GET_MD_ADCINF_1_ALE_CNT_FULL(x)  ((x>>12) & 0x00000001)
#define GET_MD_ADCINF_1_DLE_CNT_FULL(x)  ((x>>13) & 0x00000001)
#define GET_SWRST(x)                 ((x>>0)  & 0x00000001)
#define GET_HARB_SPM_SLEEP_GATING(x)  ((x>>0)  & 0x00000001)
#define GET_WACS0_REQ_SPM_SLEEP_GATING(x)  ((x>>1)  & 0x00000001)
#define GET_WACS1_REQ_SPM_SLEEP_GATING(x)  ((x>>2)  & 0x00000001)
#define GET_WACS2_REQ_SPM_SLEEP_GATING(x)  ((x>>3)  & 0x00000001)
#define GET_WACS3_REQ_SPM_SLEEP_GATING(x)  ((x>>4)  & 0x00000001)
#define GET_WACS_P2P_REQ_SPM_SLEEP_GATING(x)  ((x>>5)  & 0x00000001)
#define GET_WACS_MD32_REQ_SPM_SLEEP_GATING(x)  ((x>>6)  & 0x00000001)
#define GET_MDINF_REQ_SPM_SLEEP_GATING(x)  ((x>>7)  & 0x00000001)
#define GET_C2KINF_REQ_SPM_SLEEP_GATING(x)  ((x>>8)  & 0x00000001)
#define GET_MD_DVFSINF_REQ_SPM_SLEEP_GATING(x)  ((x>>9)  & 0x00000001)
#define GET_SPMINF_REQ_SPM_SLEEP_GATING(x)  ((x>>10) & 0x00000001)
#define GET_SPMINF_BACKUP_REQ_SPM_SLEEP_GATING(x)  ((x>>11) & 0x00000001)
#define GET_DCXO_CONNINF_REQ_SPM_SLEEP_GATING(x)  ((x>>12) & 0x00000001)
#define GET_DCXO_NFCINF_REQ_SPM_SLEEP_GATING(x)  ((x>>13) & 0x00000001)
#define GET_MD_ADCINF_0_REQ_SPM_SLEEP_GATING(x)  ((x>>14) & 0x00000001)
#define GET_MD_ADCINF_1_REQ_SPM_SLEEP_GATING(x)  ((x>>15) & 0x00000001)
#define GET_GPSINF_0_REQ_SPM_SLEEP_GATING(x)  ((x>>16) & 0x00000001)
#define GET_GPSINF_1_REQ_SPM_SLEEP_GATING(x)  ((x>>17) & 0x00000001)
#define GET_STAUPD_REQ_SPM_SLEEP_GATING(x)  ((x>>18) & 0x00000001)
#define GET_HARB_SCP_SLEEP_GATING(x)  ((x>>0)  & 0x00000001)
#define GET_WACS0_REQ_SCP_SLEEP_GATING(x)  ((x>>1)  & 0x00000001)
#define GET_WACS1_REQ_SCP_SLEEP_GATING(x)  ((x>>2)  & 0x00000001)
#define GET_WACS2_REQ_SCP_SLEEP_GATING(x)  ((x>>3)  & 0x00000001)
#define GET_WACS3_REQ_SCP_SLEEP_GATING(x)  ((x>>4)  & 0x00000001)
#define GET_WACS_P2P_REQ_SCP_SLEEP_GATING(x)  ((x>>5)  & 0x00000001)
#define GET_WACS_MD32_REQ_SCP_SLEEP_GATING(x)  ((x>>6)  & 0x00000001)
#define GET_MDINF_REQ_SCP_SLEEP_GATING(x)  ((x>>7)  & 0x00000001)
#define GET_C2KINF_REQ_SCP_SLEEP_GATING(x)  ((x>>8)  & 0x00000001)
#define GET_MD_DVFSINF_REQ_SCP_SLEEP_GATING(x)  ((x>>9)  & 0x00000001)
#define GET_SPMINF_REQ_SCP_SLEEP_GATING(x)  ((x>>10) & 0x00000001)
#define GET_SPMINF_BACKUP_REQ_SCP_SLEEP_GATING(x)  ((x>>11) & 0x00000001)
#define GET_DCXO_CONNINF_REQ_SCP_SLEEP_GATING(x)  ((x>>12) & 0x00000001)
#define GET_DCXO_NFCINF_REQ_SCP_SLEEP_GATING(x)  ((x>>13) & 0x00000001)
#define GET_MD_ADCINF_0_REQ_SCP_SLEEP_GATING(x)  ((x>>14) & 0x00000001)
#define GET_MD_ADCINF_1_REQ_SCP_SLEEP_GATING(x)  ((x>>15) & 0x00000001)
#define GET_GPSINF_0_REQ_SCP_SLEEP_GATING(x)  ((x>>16) & 0x00000001)
#define GET_GPSINF_1_REQ_SCP_SLEEP_GATING(x)  ((x>>17) & 0x00000001)
#define GET_STAUPD_REQ_SCP_SLEEP_GATING(x)  ((x>>18) & 0x00000001)
#define GET_ARBITER_SEL_CH0(x)       ((x>>0)  & 0x000000ff)
#define GET_ARBITER_SEL_CH1(x)       ((x>>8)  & 0x000000ff)
#define GET_ARBITER_SEL_CH2(x)       ((x>>16) & 0x000000ff)
#define GET_ARBITER_SEL_CH3(x)       ((x>>24) & 0x000000ff)
#define GET_ARBITER_SEL_CH4(x)       ((x>>0)  & 0x000000ff)
#define GET_ARBITER_SEL_CH5(x)       ((x>>8)  & 0x000000ff)
#define GET_ARBITER_SEL_CH6(x)       ((x>>16) & 0x000000ff)
#define GET_ARBITER_SEL_CH7(x)       ((x>>24) & 0x000000ff)
#define GET_ARBITER_SEL_CH8(x)       ((x>>0)  & 0x000000ff)
#define GET_ARBITER_SEL_CH9(x)       ((x>>8)  & 0x000000ff)
#define GET_ARBITER_SEL_CH10(x)      ((x>>16) & 0x000000ff)
#define GET_ARBITER_SEL_CH11(x)      ((x>>24) & 0x000000ff)
#define GET_ARBITER_SEL_CH12(x)      ((x>>0)  & 0x000000ff)
#define GET_ARBITER_SEL_CH13(x)      ((x>>8)  & 0x000000ff)
#define GET_ARBITER_SEL_CH14(x)      ((x>>16) & 0x000000ff)
#define GET_ARBITER_SEL_CH15(x)      ((x>>24) & 0x000000ff)
#define GET_ARBITER_SEL_CH16(x)      ((x>>0)  & 0x000000ff)
#define GET_ARBITER_OUT_MDINF_SEL(x)  ((x>>0)  & 0x000000ff)
#define GET_ARBITER_OUT_MD_DVFSINF_SEL(x)  ((x>>8)  & 0x000000ff)
#define GET_ARBITER_OUT_SPMINF_SEL(x)  ((x>>16) & 0x000000ff)
#define GET_ARBITER_OUT_SPMINF_BACKUP_SEL(x)  ((x>>24) & 0x000000ff)
#define GET_ARBITER_OUT_WACS0_SEL(x)  ((x>>0)  & 0x000000ff)
#define GET_ARBITER_OUT_WACS_MD32_SEL(x)  ((x>>8)  & 0x000000ff)
#define GET_ARBITER_OUT_DCXO_CONNINF_SEL(x)  ((x>>16) & 0x000000ff)
#define GET_ARBITER_OUT_DCXO_NFCINF_SEL(x)  ((x>>24) & 0x000000ff)
#define GET_ARBITER_OUT_MD_ADCINF_0_SEL(x)  ((x>>0)  & 0x000000ff)
#define GET_ARBITER_OUT_MD_ADCINF_1_SEL(x)  ((x>>8)  & 0x000000ff)
#define GET_ARBITER_OUT_STAUPD_SEL(x)  ((x>>16) & 0x000000ff)
#define GET_ARBITER_OUT_GPSINF_0_SEL(x)  ((x>>24) & 0x000000ff)
#define GET_ARBITER_OUT_GPSINF_1_SEL(x)  ((x>>0)  & 0x000000ff)
#define GET_ARBITER_OUT_WACS2_SEL(x)  ((x>>8)  & 0x000000ff)
#define GET_ARBITER_OUT_WACS1_SEL(x)  ((x>>16) & 0x000000ff)
#define GET_ARBITER_OUT_WACS3_SEL(x)  ((x>>24) & 0x000000ff)
#define GET_ARBITER_OUT_RESERVED_1_SEL(x)  ((x>>0)  & 0x000000ff)
#define GET_STARV_COUNTER0_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER0_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER1_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER1_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER2_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER2_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER3_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER3_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER4_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER4_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER5_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER5_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER6_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER6_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER7_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER7_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER8_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER8_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER9_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER9_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER10_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER10_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER11_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER11_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER12_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER12_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER13_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER13_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER14_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER14_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER15_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER15_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER16_TARGET(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER16_ENABLE(x)  ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER0_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER0(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER1_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER1(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER2_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER2(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER3_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER3(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER4_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER4(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER5_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER5(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER6_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER6(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER7_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER7(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER8_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER8(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER9_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER9(x)        ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER10_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER10(x)       ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER11_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER11(x)       ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER12_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER12(x)       ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER13_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER13(x)       ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER14_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER14(x)       ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER15_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER15(x)       ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER16_GATED(x)  ((x>>0)  & 0x000003ff)
#define GET_STARV_COUNTER16(x)       ((x>>10) & 0x000003ff)
#define GET_STARV_COUNTER0_CLR(x)    ((x>>0)  & 0x00000001)
#define GET_STARV_COUNTER1_CLR(x)    ((x>>1)  & 0x00000001)
#define GET_STARV_COUNTER2_CLR(x)    ((x>>2)  & 0x00000001)
#define GET_STARV_COUNTER3_CLR(x)    ((x>>3)  & 0x00000001)
#define GET_STARV_COUNTER4_CLR(x)    ((x>>4)  & 0x00000001)
#define GET_STARV_COUNTER5_CLR(x)    ((x>>5)  & 0x00000001)
#define GET_STARV_COUNTER6_CLR(x)    ((x>>6)  & 0x00000001)
#define GET_STARV_COUNTER7_CLR(x)    ((x>>7)  & 0x00000001)
#define GET_STARV_COUNTER8_CLR(x)    ((x>>8)  & 0x00000001)
#define GET_STARV_COUNTER9_CLR(x)    ((x>>9)  & 0x00000001)
#define GET_STARV_COUNTER10_CLR(x)   ((x>>10) & 0x00000001)
#define GET_STARV_COUNTER11_CLR(x)   ((x>>11) & 0x00000001)
#define GET_STARV_COUNTER12_CLR(x)   ((x>>12) & 0x00000001)
#define GET_STARV_COUNTER13_CLR(x)   ((x>>13) & 0x00000001)
#define GET_STARV_COUNTER14_CLR(x)   ((x>>14) & 0x00000001)
#define GET_STARV_COUNTER15_CLR(x)   ((x>>15) & 0x00000001)
#define GET_STARV_COUNTER16_CLR(x)   ((x>>16) & 0x00000001)
#define GET_AG_ARB_HPRIO_STARV(x)    ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_MODE(x)          ((x>>0)  & 0x00000003)
#define GET_MONITOR_STOP_AFTER_INT(x)  ((x>>2)  & 0x00000001)
#define GET_MONITOR_INIT(x)          ((x>>3)  & 0x00000001)
#define GET_MONITOR_RECORD_CNT(x)    ((x>>4)  & 0x0000001f)
#define GET_MONITOR_TARGET_CHANNEL(x)  ((x>>0)  & 0x00000000)
#define GET_MONITOR_TARGET_CMD(x)    ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_TARGET_CMD_MASK(x)  ((x>>16) & 0x0000ffff)
#define GET_MONITOR_TARGET_WDATA(x)  ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_TARGET_WDATA_MASK(x)  ((x>>16) & 0x0000ffff)
#define GET_MONITOR_CHANNEL_0(x)     ((x>>0)  & 0x000000ff)
#define GET_MONITOR_CHANNEL_1(x)     ((x>>8)  & 0x000000ff)
#define GET_MONITOR_CHANNEL_2(x)     ((x>>16) & 0x000000ff)
#define GET_MONITOR_CHANNEL_3(x)     ((x>>24) & 0x000000ff)
#define GET_MONITOR_CHANNEL_4(x)     ((x>>0)  & 0x000000ff)
#define GET_MONITOR_CHANNEL_5(x)     ((x>>8)  & 0x000000ff)
#define GET_MONITOR_CHANNEL_6(x)     ((x>>16) & 0x000000ff)
#define GET_MONITOR_CHANNEL_7(x)     ((x>>24) & 0x000000ff)
#define GET_MONITOR_CHANNEL_8(x)     ((x>>0)  & 0x000000ff)
#define GET_MONITOR_CHANNEL_9(x)     ((x>>8)  & 0x000000ff)
#define GET_MONITOR_CHANNEL_10(x)    ((x>>16) & 0x000000ff)
#define GET_MONITOR_CHANNEL_11(x)    ((x>>24) & 0x000000ff)
#define GET_MONITOR_CHANNEL_12(x)    ((x>>0)  & 0x000000ff)
#define GET_MONITOR_CHANNEL_13(x)    ((x>>8)  & 0x000000ff)
#define GET_MONITOR_CHANNEL_14(x)    ((x>>16) & 0x000000ff)
#define GET_MONITOR_CHANNEL_15(x)    ((x>>24) & 0x000000ff)
#define GET_MONITOR_CMD_0(x)         ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_CMD_1(x)         ((x>>16) & 0x0000ffff)
#define GET_MONITOR_CMD_2(x)         ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_CMD_3(x)         ((x>>16) & 0x0000ffff)
#define GET_MONITOR_CMD_4(x)         ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_CMD_5(x)         ((x>>16) & 0x0000ffff)
#define GET_MONITOR_CMD_6(x)         ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_CMD_7(x)         ((x>>16) & 0x0000ffff)
#define GET_MONITOR_CMD_8(x)         ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_CMD_9(x)         ((x>>16) & 0x0000ffff)
#define GET_MONITOR_CMD_10(x)        ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_CMD_11(x)        ((x>>16) & 0x0000ffff)
#define GET_MONITOR_CMD_12(x)        ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_CMD_13(x)        ((x>>16) & 0x0000ffff)
#define GET_MONITOR_CMD_14(x)        ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_CMD_15(x)        ((x>>16) & 0x0000ffff)
#define GET_MONITOR_WDATA_0(x)       ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_WDATA_1(x)       ((x>>16) & 0x0000ffff)
#define GET_MONITOR_WDATA_2(x)       ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_WDATA_3(x)       ((x>>16) & 0x0000ffff)
#define GET_MONITOR_WDATA_4(x)       ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_WDATA_5(x)       ((x>>16) & 0x0000ffff)
#define GET_MONITOR_WDATA_6(x)       ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_WDATA_7(x)       ((x>>16) & 0x0000ffff)
#define GET_MONITOR_WDATA_8(x)       ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_WDATA_9(x)       ((x>>16) & 0x0000ffff)
#define GET_MONITOR_WDATA_10(x)      ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_WDATA_11(x)      ((x>>16) & 0x0000ffff)
#define GET_MONITOR_WDATA_12(x)      ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_WDATA_13(x)      ((x>>16) & 0x0000ffff)
#define GET_MONITOR_WDATA_14(x)      ((x>>0)  & 0x0000ffff)
#define GET_MONITOR_WDATA_15(x)      ((x>>16) & 0x0000ffff)
#define GET_DEBUG_SW_DRIVER_0(x)     ((x>>0)  & 0x00000000)
#define GET_DEBUG_SW_DRIVER_1(x)     ((x>>0)  & 0x00000000)
#define GET_DEBUG_SW_DRIVER_2(x)     ((x>>0)  & 0x00000000)
#define GET_DEBUG_SW_DRIVER_3(x)     ((x>>0)  & 0x00000000)
#define GET_DEBUG_SW_DRIVER_4(x)     ((x>>0)  & 0x00000000)
#define GET_DEBUG_SW_DRIVER_5(x)     ((x>>0)  & 0x00000000)
#define GET_PWRAP_IDLE_WITHOUT_PSEL(x)  ((x>>0)  & 0x00000001)
#define GET_SYS_IDLE_WITH_PSEL_M(x)  ((x>>1)  & 0x00000001)
#define GET_IDLE_SIG_FOR_SLEEP_HANDSHAKING(x)  ((x>>2)  & 0x00000001)
#define GET_SLEEP_REQ_FOR_TIMER_EN(x)  ((x>>3)  & 0x00000001)
#define GET_TIMER_EN_GATING(x)       ((x>>4)  & 0x00000001)
#define GET_SCP_SLEEP_REQ_NO_ULPOSC_CLK_SEL(x)  ((x>>5)  & 0x00000001)
#define GET_BWC_OPTIONS_RESERVED(x)  ((x>>6)  & 0x03ffffff)
#define GET_WACS0_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS0_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS0_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS0_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS0_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS0_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE0(x)            ((x>>20) & 0x00000001)
#define GET_WACS0_INIT_DONE0(x)      ((x>>21) & 0x00000001)
#define GET_SYS_IDLE0(x)             ((x>>22) & 0x00000001)
#define GET_WACS0_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS0_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_WACS0_VLDCLR(x)          ((x>>0)  & 0x00000001)
#define GET_WACS1_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS1_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS1_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS1_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS1_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS1_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE1(x)            ((x>>20) & 0x00000001)
#define GET_WACS1_INIT_DONE1(x)      ((x>>21) & 0x00000001)
#define GET_SYS_IDLE1(x)             ((x>>22) & 0x00000001)
#define GET_WACS1_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS1_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_WACS1_VLDCLR(x)          ((x>>0)  & 0x00000001)
#define GET_WACS2_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS2_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS2_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS2_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS2_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS2_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE2(x)            ((x>>20) & 0x00000001)
#define GET_WACS2_INIT_DONE2(x)      ((x>>21) & 0x00000001)
#define GET_SYS_IDLE2(x)             ((x>>22) & 0x00000001)
#define GET_WACS2_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS2_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_WACS2_VLDCLR(x)          ((x>>0)  & 0x00000001)
#define GET_WACS3_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS3_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS3_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS3_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS3_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS3_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE3(x)            ((x>>20) & 0x00000001)
#define GET_WACS3_INIT_DONE3(x)      ((x>>21) & 0x00000001)
#define GET_SYS_IDLE3(x)             ((x>>22) & 0x00000001)
#define GET_WACS3_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS3_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_WACS3_VLDCLR(x)          ((x>>0)  & 0x00000001)

#endif
