/*
 * Copyright (c) 2015-2017 MICROTRUST Incorporated
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef TEEI_INTERNAL_API_TYPES_H
#define TEEI_INTERNAL_API_TYPES_H

#define TEE_ERROR_UNKNOWN_COMMAND 0xFFFF0009
#define TEE_ERROR_ALLOCATE_TRANSIENT_OBJECT 0xFFFF1000
#define TEE_ERROR_GENERATEKEY 0xFFFF1001
#define TEE_ERROR_ALLOCATE_OPERATION 0xFFFF1002
#define TEE_ERROR_SET_OPERATION_KEY 0xFFFF1003
#define TEE_ERROR_MAC_COMPUTE_FINAL 0xFFFF1004
#define TEE_ERROR_ASYMMETRIC_SIGN_DIGEST 0xFFFF1005
#define TEE_ERROR_ASYMMETRIC_VERIFY_DIGEST 0xFFFF1006
#define TEE_ERROR_CIPHER_UPDATE 0xFFFF1007
#define TEE_ERROR_CIPHER_DO_FINAL 0xFFFF1008
#define TEE_ERROR_MEM_COMPARE 0xFFFF1009
#define TEE_ERROR_ASYMMETRIC_ENCRYPT 0xFFFF1010
#define TEE_ERROR_ASYMMETRIC_DECRYPT 0xFFFF1011
#define TEE_ERROR_DIGEST_DO_FINAL 0xFFFF1012
#define TEE_ERROR_POPULATE_TRANSIENT_OBJECT 0xFFFF1013
#define TEE_ERROR_CHECK_MEMORY_ACCESS_RIGHTS 0xFFFF1014
#define TEE_ERROR_MALLOC 0xFFFF1015
#define TEE_ERROR_REALLOC 0xFFFF1016
#define TEE_ERROR_MEM_FILL 0xFFFF1017
#define TEE_ERROR_MEM_MOVE 0xFFFF1018
#define TEE_ERROR_GET_PROPERTY_AS_UUID 0xFFFF1019
#define TEE_ERROR_MDRV_OPEN 0xFFFF1020
#define TEE_ERROR_MDRV_IOCTL 0xFFFF1021
#define TEE_ERROR_MDRV_CLOSE 0xFFFF1022
#define TEE_ERROR_MAC_COMPARE_FINAL 0xFFFF1023
#define TEE_ERROR_GENERATE_RANDOM 0xFFFF1024
#define TEE_ERROR_REALLOC_COMPARE1 0xFFFF1025
#define TEE_ERROR_REALLOC_COMPARE2 0xFFFF1026
#define TEE_ERROR_MALLOC_COMPARE1 0xFFFF1027
#define TEE_ERROR_NULL_PARAMETERSS 0xFFFF1028
#define TEE_ERROR_REGISTER_SHARED_MEMORY_CONTENT 0xFFFF1029
#define TEE_ERROR_REGISTER_SHARED_MEMORY_SIZE 0xFFFF1030
#define TEE_ERROR_MDRV_OPEN_56 0xFFFF1031
#define TEE_ERROR_MDRV_IOCTL_56 0xFFFF1032
#define TEE_ERROR_MDRV_OPEN_57 0xFFFF1033
#define TEE_ERROR_MDRV_IOCTL_57 0xFFFF1034
#define TEE_ERROR_REGISTER_SHARED_MEMORY_CONTENT1 0xFFFF1035
#define TEE_ERROR_REGISTER_SHARED_MEMORY_SIZE1 0xFFFF1036
#define TEE_ERROR_REGISTER_SHARED_MEMORY_CONTENT2 0xFFFF1037
#define TEE_ERROR_REGISTER_SHARED_MEMORY_SIZE2 0xFFFF1038
#define TEE_ERROR_BAD_PARAMETER_TYPE 0xFFFF1039

#define DRV_ERROR_UNKNOWN_COMMAND 0xFFFF1999
#define DRV_ERROR_BAD_PARAMETERS 0xFFFF2000
#define DRV_ERROR_NOT_IMPLEMENTED 0xFFFF2001
#define DRV_ERROR_NO_NEED 0xFFFF2002
#define DRV_ERROR_MTK_SUPPORTED 0xFFFF2003
#define DRV_ERROR_MSEE_MAP_USER_LV1 0xFFFF2004
#define DRV_ERROR_MSEE_MAP_USER_LV2 0xFFFF2005
#define DRV_ERROR_MSEE_MAP_USER_LV2_16K 0xFFFF2006
#define DRV_ERROR_MSEE_MAP_USER_LV1_COMPARE 0xFFFF2007
#define DRV_ERROR_MSEE_MAP_USER_LV2_COMPARE 0xFFFF2008
#define DRV_ERROR_MSEE_MAP_USER_LV2_16K_COMPARE 0xFFFF2009
#define DRV_ERROR_MSEE_UNMAP_USER_LV1 0xFFFF2010
#define DRV_ERROR_MSEE_UNMAP_USER_LV2 0xFFFF2011
#define DRV_ERROR_MSEE_UNMAP_USER_LV2_16K 0xFFFF2012
#define DRV_ERROR_MSEE_MAP_REGION 0xFFFF2013
#define DRV_ERROR_MSEE_UNMAP_REGION 0xFFFF2014
#define DRV_ERROR_MSEE_MALLOC 0xFFFF2015
#define DRV_ERROR_MSEE_MALLOC_COMPARE1 0xFFFF2016
#define DRV_ERROR_MSEE_REALLOC 0xFFFF2017
#define DRV_ERROR_MSEE_REALLOC_COMPARE1 0xFFFF2018
#define DRV_ERROR_MSEE_REALLOC_COMPARE2 0xFFFF2019
#define DRV_ERROR_MSEE_STRNCPY 0xFFFF2020
#define DRV_ERROR_MSEE_STRNCPY_COMPARE1 0xFFFF2021
#define DRV_ERROR_MSEE_STRLEN 0xFFFF2022
#define DRV_ERROR_MSEE_MEMCPY 0xFFFF2023
#define DRV_ERROR_MSEE_MEMCPY_COMPARE1 0xFFFF2024
#define DRV_ERROR_MSEE_MEMSET 0xFFFF2025
#define DRV_ERROR_MSEE_MEMSET_COMPARE1 0xFFFF2026
#define DRV_ERROR_MSEE_GET_SYSTEM_TIME 0xFFFF2027
#define DRV_ERROR_MSEE_REQUEST_IRQ 0xFFFF2028
#define DRV_ERROR_MSEE_WAIT_FOR_IRQ_COMPLETE 0xFFFF2029
#define DRV_ERROR_NULL_PARAMETERS 0xFFFF2030
#define DRV_ERROR_MSEE_REALLOC1 0xFFFF2031
#define DRV_ERROR_REGISTER_SHARED_MEMORY_CONTENT_56 0xFFFF2032
#define DRV_ERROR_REGISTER_SHARED_MEMORY_SIZE_56 0xFFFF2033
#define DRV_ERROR_REGISTER_SHARED_MEMORY_CONTENT_57 0xFFFF2034
#define DRV_ERROR_REGISTER_SHARED_MEMORY_SIZE_57 0xFFFF2035
#define DRV_ERROR_BAD_PARAMETER_TYPE 0xFFFF2036
#define DRV_ERROR_MSEE_CLEAN_DCACHE_RANGE 0xFFFF2037
#define DRV_ERROR_MSEE_CLEAN_INVALIDATE_DCACHE_RANGE 0xFFFF2038
#define DRV_ERROR_MSEE_MAP_REGION_TEST1 0xFFFF2039
#define DRV_ERROR_MSEE_MAP_REGION_TEST2 0xFFFF2040
#define DRV_ERROR_MSEE_MAP_REGION_TEST3 0xFFFF2041
#define DRV_ERROR_MSEE_MAP_REGION_TEST4 0xFFFF2042

#define MDRV_OPEN_ERROR (~0UL << (12UL - 1))

#define TEEC_MEM_INOUT 0x00000003

#endif
