/*
 * Copyright (C) 2015 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef __DDP_OD_TABLE_H__
#define __DDP_OD_TABLE_H__

#define OD_TBL_S_DIM    17
#define OD_TBL_M_DIM    33

#define OD_TBL_S_SIZE   (OD_TBL_S_DIM * OD_TBL_S_DIM)
#define OD_TBL_M_SIZE   (OD_TBL_M_DIM * OD_TBL_M_DIM)


/* dummy 17x17 */
static const unsigned char OD_Table_dummy_17x17[OD_TBL_S_SIZE] = {
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
	0,  16,  32,  48,  64,  80,  96, 112, 128, 144, 160, 176, 192, 208,
	  224, 240, 255,
};
/* zero table for test */
static const unsigned char OD_Table_zero_17x17[OD_TBL_S_SIZE] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};
/* 255 table for test */
static const unsigned char OD_Table_255_17x17[OD_TBL_S_SIZE] = {
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255,
};

/* 120 hz */
static u8 OD_Table_17x17[OD_TBL_S_SIZE] = {
	0, 21, 44, 71, 99, 122, 141, 160, 175, 190, 203, 216, 228, 239, 251,
	255, 255,
	0, 16, 38, 65, 90, 115, 136, 153, 171, 186, 200, 213, 226, 237, 249,
	255, 255,
	0, 10, 32, 56, 83, 107, 130, 148, 166, 182, 196, 210, 223, 236, 248,
	255, 255,
	0, 4, 25, 48, 73, 98, 120, 142, 159, 176, 191, 206, 219, 234, 246,
	255, 255,
	0, 0, 19, 41, 64, 88, 113, 135, 154, 171, 188, 203, 217, 231, 245,
	255, 255,
	0, 0, 14, 35, 56, 80, 104, 126, 148, 166, 184, 200, 214, 229, 243,
	255, 255,
	0, 0, 9, 28, 49, 71, 96, 119, 141, 161, 179, 196, 212, 227, 241,
	255, 255,
	0, 0, 4, 23, 42, 64, 87, 112, 135, 155, 175, 192, 210, 226, 240,
	254, 255,
	0, 0, 0, 18, 37, 55, 78, 103, 128, 150, 171, 190, 208, 226, 239,
	253, 255,
	0, 0, 0, 12, 31, 49, 71, 95, 119, 144, 166, 186, 205, 224, 238,
	252, 255,
	0, 0, 0, 8, 24, 42, 62, 86, 111, 136, 160, 181, 202, 222, 237, 251, 255,
	0, 0, 0, 3, 19, 36, 54, 77, 102, 127, 152, 176, 197, 216, 235, 250, 255,
	0, 0, 0, 0, 13, 28, 47, 68, 94, 120, 145, 169, 192, 213, 232, 248, 255,
	0, 0, 0, 0, 8, 22, 40, 59, 83, 110, 136, 161, 183, 208, 228, 245, 255,
	0, 0, 0, 0, 2, 16, 30, 50, 72, 99, 127, 154, 175, 196, 224, 242, 255,
	0, 0, 0, 0, 0, 8, 22, 39, 60, 84, 112, 142, 165, 192, 218, 240, 255,
	0, 0, 0, 0, 0, 1, 15, 28, 48, 70, 99, 130, 158, 188, 213, 235, 255
};

#endif
