/*
 * Copyright (C) 2015 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _DDP_REG_DPI_H_
#define _DDP_REG_DPI_H_

/* field definition */
/* ------------------------------------------------------------- */
/* DPI */
#define DISP_REG_DPI_EN (DISPSYS_DPI_BASE + 0x000)
#define DISP_REG_DPI_RST (DISPSYS_DPI_BASE + 0x004)
#define DISP_REG_DPI_INTEN (DISPSYS_DPI_BASE + 0x008)
#define DISP_REG_DPI_INSTA (DISPSYS_DPI_BASE + 0x00C)
#define DISP_REG_DPI_CON (DISPSYS_DPI_BASE + 0x010)
#define DISP_REG_DPI_OUTPUT_SETTING (DISPSYS_DPI_BASE + 0x014)
#define DISP_REG_DPI_SIZE (DISPSYS_DPI_BASE + 0x018)
#define DISP_REG_DPI_DDR_SETTING (DISPSYS_DPI_BASE + 0x01c)
#define DISP_REG_DPI_TGEN_HWIDTH (DISPSYS_DPI_BASE + 0x020)
#define DISP_REG_DPI_TGEN_HPORCH (DISPSYS_DPI_BASE + 0x024)
#define DISP_REG_DPI_TGEN_VWIDTH (DISPSYS_DPI_BASE + 0x028)
#define DISP_REG_DPI_TGEN_VPORCH (DISPSYS_DPI_BASE + 0x02C)
#define DISP_REG_DPI_BG_HCNTL (DISPSYS_DPI_BASE + 0x030)
#define DISP_REG_DPI_BG_VCNTL (DISPSYS_DPI_BASE + 0x034)
#define DISP_REG_DPI_BG_COLOR (DISPSYS_DPI_BASE + 0x038)
#define DISP_REG_DPI_FIFO_CTL (DISPSYS_DPI_BASE + 0x03C)
#define DISP_REG_DPI_STATUS (DISPSYS_DPI_BASE + 0x040)
#define DISP_REG_DPI_TMODE (DISPSYS_DPI_BASE + 0x044)
#define DISP_REG_DPI_CHKSUM (DISPSYS_DPI_BASE + 0x048)
#define DISP_REG_DPI_DUMMY (DISPSYS_DPI_BASE + 0x050)
#define DISP_REG_DPI_TGEN_VWIDTH_LEVEN (DISPSYS_DPI_BASE + 0x068)
#define DISP_REG_DPI_TGEN_VPORCH_LEVEN (DISPSYS_DPI_BASE + 0x06c)
#define DISP_REG_DPI_TGEN_VWIDTH_RODD (DISPSYS_DPI_BASE + 0x070)
#define DISP_REG_DPI_TGEN_VPORCH_RODD (DISPSYS_DPI_BASE + 0x074)
#define DISP_REG_DPI_TGEN_VWIDTH_REVEN (DISPSYS_DPI_BASE + 0x078)
#define DISP_REG_DPI_TGEN_VPORCH_REVEN (DISPSYS_DPI_BASE + 0x07c)
#define DISP_REG_DPI_ESAV_VTIM_L (DISPSYS_DPI_BASE + 0x080)
/* #define DISP_REG_DPI_ESAV_VTIM_R
 * (DISPSYS_DPI_BASE + 0x084)
 */
#define DISP_REG_DPI_ESAV_VTIM_R (DISPSYS_DPI_BASE + 0x088)
#define DISP_REG_DPI_CLPF_SETTING (DISPSYS_DPI_BASE + 0x08c)
#define DISP_REG_DPI_Y_LIMIT (DISPSYS_DPI_BASE + 0x090)
#define DISP_REG_DPI_C_LIMIT (DISPSYS_DPI_BASE + 0x094)
#define DISP_REG_DPI_YUV422_SETTING (DISPSYS_DPI_BASE + 0x098)
#define DISP_REG_DPI_EMBSYNC_SETTING (DISPSYS_DPI_BASE + 0x09c)
/* #define DISP_REG_DPI_ESAV_CODE_SET0
 * (DISPSYS_DPI_BASE + 0x0a0)
 */
/* #define DISP_REG_DPI_ESAV_CODE_SET1
 * (DISPSYS_DPI_BASE + 0x0a4)
 */
#define DISP_REG_DPI_ESAV_CODE_SET0 (DISPSYS_DPI_BASE + 0x0a8)
#define DISP_REG_DPI_ESAV_CODE_SET1 (DISPSYS_DPI_BASE + 0x0ac)
#define DISP_REG_DPI_BLANK_CODE_SET (DISPSYS_DPI_BASE + 0x0b0)
#define DISP_REG_DPI_MATRIX_SET (DISPSYS_DPI_BASE + 0x0b4)

#define EN_FLD_EN REG_FLD(1, 0)
#define RST_FLD_RST REG_FLD(1, 0)
#define INTEN_FLD_INT_UNDERFLOW_EN REG_FLD(1, 2)
#define INTEN_FLD_INT_VDE_EN REG_FLD(1, 1)
#define INTEN_FLD_INT_VSYNC_EN REG_FLD(1, 0)
#define INSTA_FLD_INTSTA_UNDERFLOW_EN REG_FLD(1, 2)
#define INSTA_FLD_INTSTA_VDE_EN REG_FLD(1, 1)
#define INSTA_FLD_INTSTA_VSYNC_EN REG_FLD(1, 0)
#define CON_FLD_IN_RB_SWAP REG_FLD(1, 1)
#define CON_FLD_BG_ENABLE REG_FLD(1, 0)
#define OUTPUT_SETTING_FLD_EDGE_SEL REG_FLD(1, 17)
#define OUTPUT_SETTING_FLD_OEN_OFF REG_FLD(1, 16)
#define OUTPUT_SETTING_FLD_CK_POL REG_FLD(1, 15)
#define OUTPUT_SETTING_FLD_VSYNC_POL REG_FLD(1, 14)
#define OUTPUT_SETTING_FLD_HSYNC_POL REG_FLD(1, 13)
#define OUTPUT_SETTING_FLD_DE_POL REG_FLD(1, 12)
#define OUTPUT_SETTING_FLD_VS_MASK REG_FLD(1, 10)
#define OUTPUT_SETTING_FLD_HS_MASK REG_FLD(1, 9)
#define OUTPUT_SETTING_FLD_DE_MASK REG_FLD(1, 8)
#define OUTPUT_SETTING_FLD_R_MASK REG_FLD(1, 6)
#define OUTPUT_SETTING_FLD_G_MASK REG_FLD(1, 5)
#define OUTPUT_SETTING_FLD_B_MASK REG_FLD(1, 4)
#define OUTPUT_SETTING_FLD_BIT_SWAP REG_FLD(1, 3)
#define OUTPUT_SETTING_FLD_CH_SWAP REG_FLD(3, 0)
#define DPI_SIZE_FLD_HSIZE REG_FLD(11, 16)
#define DPI_SIZE_FLD_VSIZE REG_FLD(11, 0)
#define TGEN_HWIDTH_FLD_HPW REG_FLD(12, 0)
#define TGEN_HPORCH_FLD_HFP REG_FLD(12, 16)
#define TGEN_HPORCH_FLD_HBP REG_FLD(12, 0)
#define TGEN_VWIDTH_FLD_VPW REG_FLD(8, 0)
#define TGEN_VPORCH_FLD_VFP REG_FLD(8, 16)
#define TGEN_VPORCH_FLD_VBP REG_FLD(8, 0)
#define BG_HCNTL_FLD_BG_LEFT REG_FLD(11, 16)
#define BG_HCNTL_FLD_BG_RIGHT REG_FLD(11, 0)
#define BG_VCNTL_FLD_BG_TOP REG_FLD(11, 16)
#define BG_VCNTL_FLD_BG_BOT REG_FLD(11, 0)
#define BG_COLOR_FLD_BG_R REG_FLD(8, 16)
#define BG_COLOR_FLD_BG_G REG_FLD(8, 8)
#define BG_COLOR_FLD_BG_B REG_FLD(8, 0)
#define FIFO_CTL_FLD_FIFO_RST_SEL REG_FLD(1, 8)
#define FIFO_CTL_FLD_FIFO_VALID_SET REG_FLD(5, 0)
#define STATUS_FLD_OUTEN REG_FLD(1, 17)
#define STATUS_FLD_DPI_BUSY REG_FLD(1, 16)
#define STATUS_FLD_V_COUNTER REG_FLD(13, 0)
#define TMODE_FLD_DPI_OEN_ON REG_FLD(1, 0)
#define CHKSUM_FLD_DPI_CHKSUM_EN REG_FLD(1, 31)
#define CHKSUM_FLD_DPI_CHKSUM_READY REG_FLD(1, 30)
#define CHKSUM_FLD_DPI_CHKSUM REG_FLD(24, 0)
#define PATTERN_FLD_PAT_R_MAN REG_FLD(8, 24)
#define PATTERN_FLD_PAT_G_MAN REG_FLD(8, 16)
#define PATTERN_FLD_PAT_B_MAN REG_FLD(8, 8)
#define PATTERN_FLD_PAT_SEL REG_FLD(3, 4)
#define PATTERN_FLD_PAT_EN REG_FLD(1, 0)

#endif
