/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 MediaTek Inc.
 *
 * Author: Light Hsieh <light.hsieh@mediatek.com>
 *
 */

#ifndef __PINCTRL_MTK_MT6763_H
#define __PINCTRL_MTK_MT6763_H

#include "pinctrl-paris.h"

#define MTK_PIN_LEGACY(_number, _name, _eint, ...) {	\
		.number = _number,			\
		.name = _name,				\
		.eint = _eint,				\
		.funcs = (struct mtk_func_desc[]){	\
			__VA_ARGS__, { } },		\
	}

static struct mtk_pin_desc mtk_pins_mt6763[] = {
	MTK_PIN_LEGACY(
		0, "GPIO0",
		MTK_EINT_FUNCTION(0, 0),
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "PWM_B"),
		MTK_FUNCTION(2, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(3, "CLKM0"),
		MTK_FUNCTION(4, "IDDIG"),
		MTK_FUNCTION(5, "MD_INT0"),
		MTK_FUNCTION(6, "I2S3_MCK"),
		MTK_FUNCTION(7, "SPI2_CSB")
	),
	MTK_PIN_LEGACY(
		1, "GPIO1",
		MTK_EINT_FUNCTION(0, 1),
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "PWM_C"),
		MTK_FUNCTION(2, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(3, "CLKM1"),
		MTK_FUNCTION(4, "USB_DRVVBUS"),
		MTK_FUNCTION(6, "I2S3_BCK"),
		MTK_FUNCTION(7, "SPI2_MO")
	),
	MTK_PIN_LEGACY(
		2, "GPIO2",
		MTK_EINT_FUNCTION(0, 2),
		MTK_FUNCTION(0, "GPIO2"),
		MTK_FUNCTION(2, "UTXD1"),
		MTK_FUNCTION(3, "CLKM2"),
		MTK_FUNCTION(4, "SCL6"),
		MTK_FUNCTION(6, "I2S3_LRCK"),
		MTK_FUNCTION(7, "SPI2_CLK")
	),
	MTK_PIN_LEGACY(
		3, "GPIO3",
		MTK_EINT_FUNCTION(0, 3),
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "PWM_A"),
		MTK_FUNCTION(2, "URXD1"),
		MTK_FUNCTION(3, "CLKM3"),
		MTK_FUNCTION(4, "SDA6"),
		MTK_FUNCTION(6, "I2S3_DO"),
		MTK_FUNCTION(7, "SPI1_B_MI")
	),
	MTK_PIN_LEGACY(
		4, "GPIO4",
		MTK_EINT_FUNCTION(0, 4),
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "PWM_B"),
		MTK_FUNCTION(2, "I2S0_MCK"),
		MTK_FUNCTION(3, "UCTS0"),
		MTK_FUNCTION(4, "MD_URXD1"),
		MTK_FUNCTION(5, "SSPM_URXD_AO"),
		MTK_FUNCTION(6, "ANT_SEL3"),
		MTK_FUNCTION(7, "SPI1_B_MI")
	),
	MTK_PIN_LEGACY(
		5, "GPIO5",
		MTK_EINT_FUNCTION(0, 5),
		MTK_FUNCTION(0, "GPIO5"),
		MTK_FUNCTION(1, "PWM_C"),
		MTK_FUNCTION(2, "I2S0_BCK"),
		MTK_FUNCTION(3, "URTS0"),
		MTK_FUNCTION(4, "MD_UTXD1"),
		MTK_FUNCTION(5, "SSPM_UTXD_AO"),
		MTK_FUNCTION(6, "ANT_SEL4"),
		MTK_FUNCTION(7, "SPI1_B_CSB")
	),
	MTK_PIN_LEGACY(
		6, "GPIO6",
		MTK_EINT_FUNCTION(0, 6),
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "PWM_A"),
		MTK_FUNCTION(2, "I2S0_LRCK"),
		MTK_FUNCTION(3, "IDDIG"),
		MTK_FUNCTION(4, "MD_URXD0"),
		MTK_FUNCTION(5, "CCU_URXD_AO"),
		MTK_FUNCTION(6, "ANT_SEL5"),
		MTK_FUNCTION(7, "SPI1_B_MO")
	),
	MTK_PIN_LEGACY(
		7, "GPIO7",
		MTK_EINT_FUNCTION(0, 7),
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(1, "PWM_B"),
		MTK_FUNCTION(2, "I2S0_DI"),
		MTK_FUNCTION(3, "USB_DRVVBUS"),
		MTK_FUNCTION(4, "MD_UTXD0"),
		MTK_FUNCTION(5, "CCU_UTXD_AO"),
		MTK_FUNCTION(7, "SPI1_B_CLK")
	),
	MTK_PIN_LEGACY(
		8, "GPIO8",
		MTK_EINT_FUNCTION(0, 8),
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(1, "SRCLKENAI0"),
		MTK_FUNCTION(2, "UTXD1"),
		MTK_FUNCTION(3, "SCL6"),
		MTK_FUNCTION(4, "CONN_MCU_TRST_B"),
		MTK_FUNCTION(5, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(6, "ANT_SEL3"),
		MTK_FUNCTION(7, "JTRSTN_SEL1")
	),
	MTK_PIN_LEGACY(
		9, "GPIO9",
		MTK_EINT_FUNCTION(0, 9),
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(1, "PWM_A"),
		MTK_FUNCTION(2, "UCTS1"),
		MTK_FUNCTION(3, "DAP_MD32_SWD"),
		MTK_FUNCTION(4, "CONN_MCU_DBGACK_N"),
		MTK_FUNCTION(5, "SSPM_JTAG_TRSTN"),
		MTK_FUNCTION(6, "IO_JTAG_TRSTN"),
		MTK_FUNCTION(7, "DBG_MON_A43")
	),
	MTK_PIN_LEGACY(
		10, "GPIO10",
		MTK_EINT_FUNCTION(0, 10),
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(1, "PWM_B"),
		MTK_FUNCTION(2, "URTS1"),
		MTK_FUNCTION(3, "DAP_MD32_SWCK"),
		MTK_FUNCTION(4, "CONN_MCU_DBGI_N"),
		MTK_FUNCTION(5, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_A44")
	),
	MTK_PIN_LEGACY(
		11, "GPIO11",
		MTK_EINT_FUNCTION(0, 11),
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(1, "PWM_C"),
		MTK_FUNCTION(2, "IDDIG"),
		MTK_FUNCTION(3, "SCL6"),
		MTK_FUNCTION(4, "SRCLKENAI1"),
		MTK_FUNCTION(5, "CLKM0")
	),
	MTK_PIN_LEGACY(
		12, "GPIO12",
		MTK_EINT_FUNCTION(0, 12),
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(1, "CMFLASH"),
		MTK_FUNCTION(2, "USB_DRVVBUS"),
		MTK_FUNCTION(3, "SDA6"),
		MTK_FUNCTION(4, "PWM_C"),
		MTK_FUNCTION(5, "CLKM3")
	),
	MTK_PIN_LEGACY(
		13, "GPIO13",
		MTK_EINT_FUNCTION(0, 13),
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "DPI_D0"),
		MTK_FUNCTION(2, "MRG_SYNC"),
		MTK_FUNCTION(3, "PCM0_SYNC"),
		MTK_FUNCTION(4, "MD_URXD0"),
		MTK_FUNCTION(5, "SPI4_MI"),
		MTK_FUNCTION(6, "I2S0_MCK"),
		MTK_FUNCTION(7, "DBG_MON_A7")
	),
	MTK_PIN_LEGACY(
		14, "GPIO14",
		MTK_EINT_FUNCTION(0, 14),
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "DPI_D1"),
		MTK_FUNCTION(2, "MRG_CLK"),
		MTK_FUNCTION(3, "PCM0_CLK"),
		MTK_FUNCTION(4, "MD_UTXD0"),
		MTK_FUNCTION(5, "SPI4_CSB"),
		MTK_FUNCTION(6, "I2S0_BCK"),
		MTK_FUNCTION(7, "DBG_MON_A8")
	),
	MTK_PIN_LEGACY(
		15, "GPIO15",
		MTK_EINT_FUNCTION(0, 15),
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "DPI_D2"),
		MTK_FUNCTION(2, "MRG_DO"),
		MTK_FUNCTION(3, "PCM0_DO"),
		MTK_FUNCTION(4, "MD_URXD1"),
		MTK_FUNCTION(5, "SPI4_MO"),
		MTK_FUNCTION(6, "I2S0_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_A9")
	),
	MTK_PIN_LEGACY(
		16, "GPIO16",
		MTK_EINT_FUNCTION(0, 16),
		MTK_FUNCTION(0, "GPIO16"),
		MTK_FUNCTION(1, "DPI_D3"),
		MTK_FUNCTION(2, "MRG_DI"),
		MTK_FUNCTION(3, "PCM0_DI"),
		MTK_FUNCTION(4, "MD_UTXD1"),
		MTK_FUNCTION(5, "SPI4_CLK"),
		MTK_FUNCTION(6, "I2S0_DI"),
		MTK_FUNCTION(7, "DBG_MON_A10")
	),
	MTK_PIN_LEGACY(
		17, "GPIO17",
		MTK_EINT_FUNCTION(0, 17),
		MTK_FUNCTION(0, "GPIO17"),
		MTK_FUNCTION(1, "DPI_D4"),
		MTK_FUNCTION(2, "UCTS1"),
		MTK_FUNCTION(3, "CONN_MCU_TRST_B"),
		MTK_FUNCTION(4, "MD_INT0"),
		MTK_FUNCTION(5, "ANT_SEL4"),
		MTK_FUNCTION(6, "I2S3_MCK"),
		MTK_FUNCTION(7, "DBG_MON_A11")
	),
	MTK_PIN_LEGACY(
		18, "GPIO18",
		MTK_EINT_FUNCTION(0, 18),
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "DPI_D5"),
		MTK_FUNCTION(2, "URTS1"),
		MTK_FUNCTION(3, "CONN_MCU_DBGI_N"),
		MTK_FUNCTION(4, "MD_INT0"),
		MTK_FUNCTION(5, "ANT_SEL5"),
		MTK_FUNCTION(6, "I2S3_BCK"),
		MTK_FUNCTION(7, "DBG_MON_A12")
	),
	MTK_PIN_LEGACY(
		19, "GPIO19",
		MTK_EINT_FUNCTION(0, 19),
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "DPI_D6"),
		MTK_FUNCTION(2, "URXD1"),
		MTK_FUNCTION(3, "CONN_MCU_TDO"),
		MTK_FUNCTION(4, "MD_INT2_C2K_UIM1_HOT_PLUG"),
		MTK_FUNCTION(5, "SPI5_MO"),
		MTK_FUNCTION(6, "I2S3_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_A13")
	),
	MTK_PIN_LEGACY(
		20, "GPIO20",
		MTK_EINT_FUNCTION(0, 20),
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "DPI_D7"),
		MTK_FUNCTION(2, "UTXD1"),
		MTK_FUNCTION(3, "CONN_MCU_DBGACK_N"),
		MTK_FUNCTION(4, "MD_INT1_C2K_UIM0_HOT_PLUG"),
		MTK_FUNCTION(5, "SPI5_CLK"),
		MTK_FUNCTION(6, "I2S3_DO"),
		MTK_FUNCTION(7, "DBG_MON_A14")
	),
	MTK_PIN_LEGACY(
		21, "GPIO21",
		MTK_EINT_FUNCTION(0, 21),
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "DPI_D8"),
		MTK_FUNCTION(2, "SRCLKENAI1"),
		MTK_FUNCTION(3, "CONN_MCU_TMS"),
		MTK_FUNCTION(4, "DAP_MD32_SWD"),
		MTK_FUNCTION(5, "CONN_MCU_AICE_TMSC"),
		MTK_FUNCTION(6, "I2S2_MCK"),
		MTK_FUNCTION(7, "DBG_MON_A15")
	),
	MTK_PIN_LEGACY(
		22, "GPIO22",
		MTK_EINT_FUNCTION(0, 22),
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "DPI_D9"),
		MTK_FUNCTION(2, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(3, "CONN_MCU_TCK"),
		MTK_FUNCTION(4, "DAP_MD32_SWCK"),
		MTK_FUNCTION(5, "CONN_MCU_AICE_TCKC"),
		MTK_FUNCTION(6, "I2S2_BCK"),
		MTK_FUNCTION(7, "DBG_MON_A16")
	),
	MTK_PIN_LEGACY(
		23, "GPIO23",
		MTK_EINT_FUNCTION(0, 23),
		MTK_FUNCTION(0, "GPIO23"),
		MTK_FUNCTION(1, "DPI_D10"),
		MTK_FUNCTION(2, "IDDIG"),
		MTK_FUNCTION(3, "CONN_MCU_TDI"),
		MTK_FUNCTION(4, "CMVREF1"),
		MTK_FUNCTION(5, "ANT_SEL3"),
		MTK_FUNCTION(6, "I2S2_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_A17")
	),
	MTK_PIN_LEGACY(
		24, "GPIO24",
		MTK_EINT_FUNCTION(0, 24),
		MTK_FUNCTION(0, "GPIO24"),
		MTK_FUNCTION(1, "DPI_D11"),
		MTK_FUNCTION(2, "USB_DRVVBUS"),
		MTK_FUNCTION(3, "SRCLKENAI0"),
		MTK_FUNCTION(4, "SPI1_A_MI"),
		MTK_FUNCTION(5, "IO_JTAG_TCK"),
		MTK_FUNCTION(6, "I2S2_DI"),
		MTK_FUNCTION(7, "DBG_MON_A18")
	),
	MTK_PIN_LEGACY(
		25, "GPIO25",
		MTK_EINT_FUNCTION(0, 25),
		MTK_FUNCTION(0, "GPIO25"),
		MTK_FUNCTION(1, "DPI_HSYNC"),
		MTK_FUNCTION(2, "SPI1_A_MI"),
		MTK_FUNCTION(4, "CLKM0"),
		MTK_FUNCTION(5, "IO_JTAG_TMS"),
		MTK_FUNCTION(6, "I2S1_MCK"),
		MTK_FUNCTION(7, "DBG_MON_A19")
	),
	MTK_PIN_LEGACY(
		26, "GPIO26",
		MTK_EINT_FUNCTION(0, 26),
		MTK_FUNCTION(0, "GPIO26"),
		MTK_FUNCTION(1, "DPI_VSYNC"),
		MTK_FUNCTION(2, "SPI1_A_CSB"),
		MTK_FUNCTION(4, "CLKM1"),
		MTK_FUNCTION(5, "IO_JTAG_TDI"),
		MTK_FUNCTION(6, "I2S1_BCK"),
		MTK_FUNCTION(7, "DBG_MON_A20")
	),
	MTK_PIN_LEGACY(
		27, "GPIO27",
		MTK_EINT_FUNCTION(0, 27),
		MTK_FUNCTION(0, "GPIO27"),
		MTK_FUNCTION(1, "DPI_DE"),
		MTK_FUNCTION(2, "SPI1_A_MO"),
		MTK_FUNCTION(4, "CLKM2"),
		MTK_FUNCTION(5, "IO_JTAG_TDO"),
		MTK_FUNCTION(6, "I2S1_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_A21")
	),
	MTK_PIN_LEGACY(
		28, "GPIO28",
		MTK_EINT_FUNCTION(0, 28),
		MTK_FUNCTION(0, "GPIO28"),
		MTK_FUNCTION(1, "DPI_CK"),
		MTK_FUNCTION(2, "SPI1_A_CLK"),
		MTK_FUNCTION(4, "CLKM3"),
		MTK_FUNCTION(5, "IO_JTAG_TRSTN"),
		MTK_FUNCTION(6, "I2S1_DO"),
		MTK_FUNCTION(7, "DBG_MON_A22")
	),
	MTK_PIN_LEGACY(
		29, "GPIO29",
		MTK_EINT_FUNCTION(0, 29),
		MTK_FUNCTION(0, "GPIO29"),
		MTK_FUNCTION(1, "MSDC1_CLK"),
		MTK_FUNCTION(2, "IO_JTAG_TCK"),
		MTK_FUNCTION(3, "UDI_TCK"),
		MTK_FUNCTION(4, "CONN_DSP_JCK"),
		MTK_FUNCTION(5, "SSPM_JTAG_TCK"),
		MTK_FUNCTION(6, "PCM1_CLK"),
		MTK_FUNCTION(7, "DBG_MON_A23")
	),
	MTK_PIN_LEGACY(
		30, "GPIO30",
		MTK_EINT_FUNCTION(0, 30),
		MTK_FUNCTION(0, "GPIO30"),
		MTK_FUNCTION(1, "MSDC1_DAT3"),
		MTK_FUNCTION(2, "DAP_MD32_SWD"),
		MTK_FUNCTION(3, "CONN_MCU_AICE_TMSC"),
		MTK_FUNCTION(4, "CONN_DSP_JINTP"),
		MTK_FUNCTION(5, "SSPM_JTAG_TRSTN"),
		MTK_FUNCTION(6, "PCM1_DI"),
		MTK_FUNCTION(7, "DBG_MON_A24")
	),
	MTK_PIN_LEGACY(
		31, "GPIO31",
		MTK_EINT_FUNCTION(0, 31),
		MTK_FUNCTION(0, "GPIO31"),
		MTK_FUNCTION(1, "MSDC1_CMD"),
		MTK_FUNCTION(2, "IO_JTAG_TMS"),
		MTK_FUNCTION(3, "UDI_TMS"),
		MTK_FUNCTION(4, "CONN_DSP_JMS"),
		MTK_FUNCTION(5, "SSPM_JTAG_TMS"),
		MTK_FUNCTION(6, "PCM1_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_A25")
	),
	MTK_PIN_LEGACY(
		32, "GPIO32",
		MTK_EINT_FUNCTION(0, 32),
		MTK_FUNCTION(0, "GPIO32"),
		MTK_FUNCTION(1, "MSDC1_DAT0"),
		MTK_FUNCTION(2, "IO_JTAG_TDI"),
		MTK_FUNCTION(3, "UDI_TDI"),
		MTK_FUNCTION(4, "CONN_DSP_JDI"),
		MTK_FUNCTION(5, "SSPM_JTAG_TDI"),
		MTK_FUNCTION(6, "PCM1_DO0"),
		MTK_FUNCTION(7, "DBG_MON_A26")
	),
	MTK_PIN_LEGACY(
		33, "GPIO33",
		MTK_EINT_FUNCTION(0, 33),
		MTK_FUNCTION(0, "GPIO33"),
		MTK_FUNCTION(1, "MSDC1_DAT2"),
		MTK_FUNCTION(2, "IO_JTAG_TRSTN"),
		MTK_FUNCTION(3, "UDI_NTRST"),
		MTK_FUNCTION(4, "DAP_MD32_SWCK"),
		MTK_FUNCTION(5, "CONN_MCU_AICE_TCKC"),
		MTK_FUNCTION(6, "PCM1_DO2"),
		MTK_FUNCTION(7, "DBG_MON_B32")
	),
	MTK_PIN_LEGACY(
		34, "GPIO34",
		MTK_EINT_FUNCTION(0, 34),
		MTK_FUNCTION(0, "GPIO34"),
		MTK_FUNCTION(1, "MSDC1_DAT1"),
		MTK_FUNCTION(2, "IO_JTAG_TDO"),
		MTK_FUNCTION(3, "UDI_TDO"),
		MTK_FUNCTION(4, "CONN_DSP_JDO"),
		MTK_FUNCTION(5, "SSPM_JTAG_TDO"),
		MTK_FUNCTION(6, "PCM1_DO1"),
		MTK_FUNCTION(7, "DBG_MON_A27")
	),
	MTK_PIN_LEGACY(
		35, "GPIO35",
		MTK_EINT_FUNCTION(0, 35),
		MTK_FUNCTION(0, "GPIO35"),
		MTK_FUNCTION(1, "MD1_SIM2_SIO"),
		MTK_FUNCTION(2, "CCU_JTAG_TDO"),
		MTK_FUNCTION(3, "MD1_SIM1_SIO"),
		MTK_FUNCTION(4, "LVTS_SCF"),
		MTK_FUNCTION(6, "CONN_DSP_JMS"),
		MTK_FUNCTION(7, "DBG_MON_A28")
	),
	MTK_PIN_LEGACY(
		36, "GPIO36",
		MTK_EINT_FUNCTION(0, 36),
		MTK_FUNCTION(0, "GPIO36"),
		MTK_FUNCTION(1, "MD1_SIM2_SRST"),
		MTK_FUNCTION(2, "CCU_JTAG_TMS"),
		MTK_FUNCTION(3, "MD1_SIM1_SRST"),
		MTK_FUNCTION(4, "LVTS_SDI"),
		MTK_FUNCTION(6, "CONN_DSP_JINTP"),
		MTK_FUNCTION(7, "DBG_MON_A29")
	),
	MTK_PIN_LEGACY(
		37, "GPIO37",
		MTK_EINT_FUNCTION(0, 37),
		MTK_FUNCTION(0, "GPIO37"),
		MTK_FUNCTION(1, "MD1_SIM2_SCLK"),
		MTK_FUNCTION(2, "CCU_JTAG_TDI"),
		MTK_FUNCTION(3, "MD1_SIM1_SCLK"),
		MTK_FUNCTION(4, "LVTS_SCK"),
		MTK_FUNCTION(6, "CONN_DSP_JDO"),
		MTK_FUNCTION(7, "DBG_MON_A30")
	),
	MTK_PIN_LEGACY(
		38, "GPIO38",
		MTK_EINT_FUNCTION(0, 38),
		MTK_FUNCTION(0, "GPIO38"),
		MTK_FUNCTION(1, "MD1_SIM1_SCLK"),
		MTK_FUNCTION(3, "MD1_SIM2_SCLK"),
		MTK_FUNCTION(4, "LVTS_26M"),
		MTK_FUNCTION(7, "DBG_MON_B0")
	),
	MTK_PIN_LEGACY(
		39, "GPIO39",
		MTK_EINT_FUNCTION(0, 39),
		MTK_FUNCTION(0, "GPIO39"),
		MTK_FUNCTION(1, "MD1_SIM1_SRST"),
		MTK_FUNCTION(2, "CCU_JTAG_TCK"),
		MTK_FUNCTION(3, "MD1_SIM2_SRST"),
		MTK_FUNCTION(4, "LVTS_SDO"),
		MTK_FUNCTION(6, "CONN_DSP_JCK"),
		MTK_FUNCTION(7, "DBG_MON_A31")
	),
	MTK_PIN_LEGACY(
		40, "GPIO40",
		MTK_EINT_FUNCTION(0, 40),
		MTK_FUNCTION(0, "GPIO40"),
		MTK_FUNCTION(1, "MD1_SIM1_SIO"),
		MTK_FUNCTION(2, "CCU_JTAG_TRST"),
		MTK_FUNCTION(3, "MD1_SIM2_SIO"),
		MTK_FUNCTION(4, "LVTS_FOUT"),
		MTK_FUNCTION(6, "CONN_DSP_JDI"),
		MTK_FUNCTION(7, "DBG_MON_A32")
	),
	MTK_PIN_LEGACY(
		41, "GPIO41",
		MTK_EINT_FUNCTION(0, 41),
		MTK_FUNCTION(0, "GPIO41"),
		MTK_FUNCTION(1, "IDDIG"),
		MTK_FUNCTION(2, "URXD1"),
		MTK_FUNCTION(3, "UCTS0"),
		MTK_FUNCTION(4, "SSPM_UTXD_AO"),
		MTK_FUNCTION(5, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(6, "KPCOL2"),
		MTK_FUNCTION(7, "DBG_MON_B1")
	),
	MTK_PIN_LEGACY(
		42, "GPIO42",
		MTK_EINT_FUNCTION(0, 42),
		MTK_FUNCTION(0, "GPIO42"),
		MTK_FUNCTION(1, "USB_DRVVBUS"),
		MTK_FUNCTION(2, "UTXD1"),
		MTK_FUNCTION(3, "URTS0"),
		MTK_FUNCTION(4, "SSPM_URXD_AO"),
		MTK_FUNCTION(5, "EXT_FRAME_SYNC"),
		MTK_FUNCTION(6, "KPROW2"),
		MTK_FUNCTION(7, "DBG_MON_B2")
	),
	MTK_PIN_LEGACY(
		43, "GPIO43",
		MTK_EINT_FUNCTION(0, 43),
		MTK_FUNCTION(0, "GPIO43"),
		MTK_FUNCTION(1, "DISP_PWM"),
		MTK_FUNCTION(7, "DBG_MON_B3")
	),
	MTK_PIN_LEGACY(
		44, "GPIO44",
		MTK_EINT_FUNCTION(0, 44),
		MTK_FUNCTION(0, "GPIO44"),
		MTK_FUNCTION(1, "DSI_TE")
	),
	MTK_PIN_LEGACY(
		45, "GPIO45",
		MTK_EINT_FUNCTION(0, 45),
		MTK_FUNCTION(0, "GPIO45"),
		MTK_FUNCTION(1, "LCM_RST")
	),
	MTK_PIN_LEGACY(
		46, "GPIO46",
		MTK_EINT_FUNCTION(0, 46),
		MTK_FUNCTION(0, "GPIO46"),
		MTK_FUNCTION(1, "MD_INT2_C2K_UIM1_HOT_PLUG"),
		MTK_FUNCTION(2, "URXD1"),
		MTK_FUNCTION(3, "UCTS1"),
		MTK_FUNCTION(4, "CCU_UTXD_AO"),
		MTK_FUNCTION(5, "SPI5_MI"),
		MTK_FUNCTION(6, "IDDIG")
	),
	MTK_PIN_LEGACY(
		47, "GPIO47",
		MTK_EINT_FUNCTION(0, 47),
		MTK_FUNCTION(0, "GPIO47"),
		MTK_FUNCTION(1, "MD_INT1_C2K_UIM0_HOT_PLUG"),
		MTK_FUNCTION(2, "UTXD1"),
		MTK_FUNCTION(3, "URTS1"),
		MTK_FUNCTION(4, "CCU_URXD_AO"),
		MTK_FUNCTION(5, "SPI5_CSB"),
		MTK_FUNCTION(6, "USB_DRVVBUS")
	),
	MTK_PIN_LEGACY(
		48, "GPIO48",
		MTK_EINT_FUNCTION(0, 48),
		MTK_FUNCTION(0, "GPIO48"),
		MTK_FUNCTION(1, "SCL_APPM")
	),
	MTK_PIN_LEGACY(
		49, "GPIO49",
		MTK_EINT_FUNCTION(0, 49),
		MTK_FUNCTION(0, "GPIO49"),
		MTK_FUNCTION(1, "SDA_APPM")
	),
	MTK_PIN_LEGACY(
		50, "GPIO50",
		MTK_EINT_FUNCTION(0, 50),
		MTK_FUNCTION(0, "GPIO50"),
		MTK_FUNCTION(1, "SCL3")
	),
	MTK_PIN_LEGACY(
		51, "GPIO51",
		MTK_EINT_FUNCTION(0, 51),
		MTK_FUNCTION(0, "GPIO51"),
		MTK_FUNCTION(1, "SDA3")
	),
	MTK_PIN_LEGACY(
		52, "GPIO52",
		MTK_EINT_FUNCTION(0, 52),
		MTK_FUNCTION(0, "GPIO52"),
		MTK_FUNCTION(1, "BPI_ANT2")
	),
	MTK_PIN_LEGACY(
		53, "GPIO53",
		MTK_EINT_FUNCTION(0, 53),
		MTK_FUNCTION(0, "GPIO53"),
		MTK_FUNCTION(1, "BPI_ANT0")
	),
	MTK_PIN_LEGACY(
		54, "GPIO54",
		MTK_EINT_FUNCTION(0, 54),
		MTK_FUNCTION(0, "GPIO54"),
		MTK_FUNCTION(1, "BPI_OLAT1")
	),
	MTK_PIN_LEGACY(
		55, "GPIO55",
		MTK_EINT_FUNCTION(0, 55),
		MTK_FUNCTION(0, "GPIO55"),
		MTK_FUNCTION(1, "BPI_BUS8")
	),
	MTK_PIN_LEGACY(
		56, "GPIO56",
		MTK_EINT_FUNCTION(0, 56),
		MTK_FUNCTION(0, "GPIO56"),
		MTK_FUNCTION(1, "BPI_BUS9"),
		MTK_FUNCTION(3, "06")
	),
	MTK_PIN_LEGACY(
		57, "GPIO57",
		MTK_EINT_FUNCTION(0, 57),
		MTK_FUNCTION(0, "GPIO57"),
		MTK_FUNCTION(1, "BPI_BUS10"),
		MTK_FUNCTION(3, "06")
	),
	MTK_PIN_LEGACY(
		58, "GPIO58",
		MTK_EINT_FUNCTION(0, 58),
		MTK_FUNCTION(0, "GPIO58"),
		MTK_FUNCTION(1, "RFIC0_BSI_D2"),
		MTK_FUNCTION(2, "SPM_BSI_D2"),
		MTK_FUNCTION(3, "PWM_B"),
		MTK_FUNCTION(7, "DBG_MON_B4")
	),
	MTK_PIN_LEGACY(
		59, "GPIO59",
		MTK_EINT_FUNCTION(0, 59),
		MTK_FUNCTION(0, "GPIO59"),
		MTK_FUNCTION(1, "RFIC0_BSI_D1"),
		MTK_FUNCTION(2, "SPM_BSI_D1"),
		MTK_FUNCTION(7, "DBG_MON_B5")
	),
	MTK_PIN_LEGACY(
		60, "GPIO60",
		MTK_EINT_FUNCTION(0, 60),
		MTK_FUNCTION(0, "GPIO60"),
		MTK_FUNCTION(1, "RFIC0_BSI_D0"),
		MTK_FUNCTION(2, "SPM_BSI_D0"),
		MTK_FUNCTION(7, "DBG_MON_B6")
	),
	MTK_PIN_LEGACY(
		61, "GPIO61",
		MTK_EINT_FUNCTION(0, 61),
		MTK_FUNCTION(0, "GPIO61"),
		MTK_FUNCTION(1, "MIPI1_SDATA"),
		MTK_FUNCTION(7, "DBG_MON_B9")
	),
	MTK_PIN_LEGACY(
		62, "GPIO62",
		MTK_EINT_FUNCTION(0, 62),
		MTK_FUNCTION(0, "GPIO62"),
		MTK_FUNCTION(1, "MIPI1_SCLK"),
		MTK_FUNCTION(7, "DBG_MON_B10")
	),
	MTK_PIN_LEGACY(
		63, "GPIO63",
		MTK_EINT_FUNCTION(0, 63),
		MTK_FUNCTION(0, "GPIO63"),
		MTK_FUNCTION(1, "MIPI0_SDATA"),
		MTK_FUNCTION(7, "DBG_MON_B11")
	),
	MTK_PIN_LEGACY(
		64, "GPIO64",
		MTK_EINT_FUNCTION(0, 64),
		MTK_FUNCTION(0, "GPIO64"),
		MTK_FUNCTION(1, "MIPI0_SCLK"),
		MTK_FUNCTION(7, "DBG_MON_B12")
	),
	MTK_PIN_LEGACY(
		65, "GPIO65",
		MTK_EINT_FUNCTION(0, 65),
		MTK_FUNCTION(0, "GPIO65"),
		MTK_FUNCTION(1, "MIPI3_SDATA"),
		MTK_FUNCTION(2, "BPI_OLAT2"),
		MTK_FUNCTION(7, "DBG_MON_B13")
	),
	MTK_PIN_LEGACY(
		66, "GPIO66",
		MTK_EINT_FUNCTION(0, 66),
		MTK_FUNCTION(0, "GPIO66"),
		MTK_FUNCTION(1, "MIPI3_SCLK"),
		MTK_FUNCTION(2, "BPI_OLAT3"),
		MTK_FUNCTION(7, "DBG_MON_B14")
	),
	MTK_PIN_LEGACY(
		67, "GPIO67",
		MTK_EINT_FUNCTION(0, 67),
		MTK_FUNCTION(0, "GPIO67"),
		MTK_FUNCTION(1, "MIPI2_SDATA"),
		MTK_FUNCTION(7, "DBG_MON_B15")
	),
	MTK_PIN_LEGACY(
		68, "GPIO68",
		MTK_EINT_FUNCTION(0, 68),
		MTK_FUNCTION(0, "GPIO68"),
		MTK_FUNCTION(1, "MIPI2_SCLK"),
		MTK_FUNCTION(7, "DBG_MON_B16")
	),
	MTK_PIN_LEGACY(
		69, "GPIO69",
		MTK_EINT_FUNCTION(0, 69),
		MTK_FUNCTION(0, "GPIO69"),
		MTK_FUNCTION(1, "BPI_BUS7"),
		MTK_FUNCTION(7, "DBG_MON_B17")
	),
	MTK_PIN_LEGACY(
		70, "GPIO70",
		MTK_EINT_FUNCTION(0, 70),
		MTK_FUNCTION(0, "GPIO70"),
		MTK_FUNCTION(1, "BPI_BUS6"),
		MTK_FUNCTION(7, "DBG_MON_B18")
	),
	MTK_PIN_LEGACY(
		71, "GPIO71",
		MTK_EINT_FUNCTION(0, 71),
		MTK_FUNCTION(0, "GPIO71"),
		MTK_FUNCTION(1, "BPI_BUS5"),
		MTK_FUNCTION(7, "DBG_MON_B19")
	),
	MTK_PIN_LEGACY(
		72, "GPIO72",
		MTK_EINT_FUNCTION(0, 72),
		MTK_FUNCTION(0, "GPIO72"),
		MTK_FUNCTION(1, "BPI_BUS4"),
		MTK_FUNCTION(7, "DBG_MON_B20")
	),
	MTK_PIN_LEGACY(
		73, "GPIO73",
		MTK_EINT_FUNCTION(0, 73),
		MTK_FUNCTION(0, "GPIO73"),
		MTK_FUNCTION(1, "BPI_BUS3"),
		MTK_FUNCTION(7, "DBG_MON_B21")
	),
	MTK_PIN_LEGACY(
		74, "GPIO74",
		MTK_EINT_FUNCTION(0, 74),
		MTK_FUNCTION(0, "GPIO74"),
		MTK_FUNCTION(1, "BPI_BUS2"),
		MTK_FUNCTION(7, "DBG_MON_B22")
	),
	MTK_PIN_LEGACY(
		75, "GPIO75",
		MTK_EINT_FUNCTION(0, 75),
		MTK_FUNCTION(0, "GPIO75"),
		MTK_FUNCTION(1, "BPI_BUS1"),
		MTK_FUNCTION(7, "DBG_MON_B23")
	),
	MTK_PIN_LEGACY(
		76, "GPIO76",
		MTK_EINT_FUNCTION(0, 76),
		MTK_FUNCTION(0, "GPIO76"),
		MTK_FUNCTION(1, "BPI_BUS0"),
		MTK_FUNCTION(7, "DBG_MON_B24")
	),
	MTK_PIN_LEGACY(
		77, "GPIO77",
		MTK_EINT_FUNCTION(0, 77),
		MTK_FUNCTION(0, "GPIO77"),
		MTK_FUNCTION(1, "BPI_ANT1"),
		MTK_FUNCTION(7, "DBG_MON_B25")
	),
	MTK_PIN_LEGACY(
		78, "GPIO78",
		MTK_EINT_FUNCTION(0, 78),
		MTK_FUNCTION(0, "GPIO78"),
		MTK_FUNCTION(1, "BPI_OLAT0"),
		MTK_FUNCTION(7, "DBG_MON_B26")
	),
	MTK_PIN_LEGACY(
		79, "GPIO79",
		MTK_EINT_FUNCTION(0, 79),
		MTK_FUNCTION(0, "GPIO79"),
		MTK_FUNCTION(1, "BPI_PA_VM1"),
		MTK_FUNCTION(2, "MIPI4_SDATA"),
		MTK_FUNCTION(7, "DBG_MON_B27")
	),
	MTK_PIN_LEGACY(
		80, "GPIO80",
		MTK_EINT_FUNCTION(0, 80),
		MTK_FUNCTION(0, "GPIO80"),
		MTK_FUNCTION(1, "BPI_PA_VM0"),
		MTK_FUNCTION(2, "MIPI4_SCLK"),
		MTK_FUNCTION(7, "DBG_MON_B28")
	),
	MTK_PIN_LEGACY(
		81, "GPIO81",
		MTK_EINT_FUNCTION(0, 81),
		MTK_FUNCTION(0, "GPIO81"),
		MTK_FUNCTION(1, "SDA1")
	),
	MTK_PIN_LEGACY(
		82, "GPIO82",
		MTK_EINT_FUNCTION(0, 82),
		MTK_FUNCTION(0, "GPIO82"),
		MTK_FUNCTION(1, "SDA0")
	),
	MTK_PIN_LEGACY(
		83, "GPIO83",
		MTK_EINT_FUNCTION(0, 83),
		MTK_FUNCTION(0, "GPIO83"),
		MTK_FUNCTION(1, "SCL0")
	),
	MTK_PIN_LEGACY(
		84, "GPIO84",
		MTK_EINT_FUNCTION(0, 84),
		MTK_FUNCTION(0, "GPIO84"),
		MTK_FUNCTION(1, "SCL1")
	),
	MTK_PIN_LEGACY(
		85, "GPIO85",
		MTK_EINT_FUNCTION(0, 85),
		MTK_FUNCTION(0, "GPIO85"),
		MTK_FUNCTION(1, "SPI0_MI"),
		MTK_FUNCTION(2, "MRG_SYNC"),
		MTK_FUNCTION(3, "PCM0_SYNC"),
		MTK_FUNCTION(4, "I2S1_BCK"),
		MTK_FUNCTION(5, "MFG_DFD_JTAG_TDO"),
		MTK_FUNCTION(6, "DFD_TDO"),
		MTK_FUNCTION(7, "JTDO_SEL1")
	),
	MTK_PIN_LEGACY(
		86, "GPIO86",
		MTK_EINT_FUNCTION(0, 86),
		MTK_FUNCTION(0, "GPIO86"),
		MTK_FUNCTION(1, "SPI0_CSB"),
		MTK_FUNCTION(2, "MRG_DO"),
		MTK_FUNCTION(3, "PCM0_DO"),
		MTK_FUNCTION(4, "I2S1_LRCK"),
		MTK_FUNCTION(5, "MFG_DFD_JTAG_TMS"),
		MTK_FUNCTION(6, "DFD_TMS"),
		MTK_FUNCTION(7, "JTMS_SEL1")
	),
	MTK_PIN_LEGACY(
		87, "GPIO87",
		MTK_EINT_FUNCTION(0, 87),
		MTK_FUNCTION(0, "GPIO87"),
		MTK_FUNCTION(1, "SPI0_MO"),
		MTK_FUNCTION(2, "MRG_CLK"),
		MTK_FUNCTION(3, "PCM0_CLK"),
		MTK_FUNCTION(4, "I2S1_DO"),
		MTK_FUNCTION(5, "MFG_DFD_JTAG_TDI"),
		MTK_FUNCTION(6, "DFD_TDI"),
		MTK_FUNCTION(7, "JTDI_SEL1")
	),
	MTK_PIN_LEGACY(
		88, "GPIO88",
		MTK_EINT_FUNCTION(0, 88),
		MTK_FUNCTION(0, "GPIO88"),
		MTK_FUNCTION(1, "SPI0_CLK"),
		MTK_FUNCTION(2, "MRG_DI"),
		MTK_FUNCTION(3, "PCM0_DI"),
		MTK_FUNCTION(4, "I2S1_MCK"),
		MTK_FUNCTION(5, "MFG_DFD_JTAG_TCK"),
		MTK_FUNCTION(6, "DFD_TCK_XI"),
		MTK_FUNCTION(7, "JTCK_SEL1")
	),
	MTK_PIN_LEGACY(
		89, "GPIO89",
		MTK_EINT_FUNCTION(0, 89),
		MTK_FUNCTION(0, "GPIO89"),
		MTK_FUNCTION(1, "SRCLKENAI0"),
		MTK_FUNCTION(2, "PWM_C"),
		MTK_FUNCTION(3, "CMMCLK2"),
		MTK_FUNCTION(7, "DBG_MON_A42")
	),
	MTK_PIN_LEGACY(
		90, "GPIO90",
		MTK_EINT_FUNCTION(0, 90),
		MTK_FUNCTION(0, "GPIO90"),
		MTK_FUNCTION(1, "PWM_A"),
		MTK_FUNCTION(2, "URXD1"),
		MTK_FUNCTION(3, "SDA6"),
		MTK_FUNCTION(5, "MD_INT2_C2K_UIM1_HOT_PLUG"),
		MTK_FUNCTION(6, "ANT_SEL4"),
		MTK_FUNCTION(7, "DBG_MON_B29")
	),
	MTK_PIN_LEGACY(
		91, "GPIO91",
		MTK_EINT_FUNCTION(0, 91),
		MTK_FUNCTION(0, "GPIO91"),
		MTK_FUNCTION(1, "KPROW1"),
		MTK_FUNCTION(2, "PWM_B"),
		MTK_FUNCTION(6, "ANT_SEL5"),
		MTK_FUNCTION(7, "DBG_MON_B30")
	),
	MTK_PIN_LEGACY(
		92, "GPIO92",
		MTK_EINT_FUNCTION(0, 92),
		MTK_FUNCTION(0, "GPIO92"),
		MTK_FUNCTION(1, "KPROW0"),
		MTK_FUNCTION(7, "DBG_MON_B31")
	),
	MTK_PIN_LEGACY(
		93, "GPIO93",
		MTK_EINT_FUNCTION(0, 93),
		MTK_FUNCTION(0, "GPIO93"),
		MTK_FUNCTION(1, "KPCOL0"),
		MTK_FUNCTION(7, "DBG_MON_A33")
	),
	MTK_PIN_LEGACY(
		94, "GPIO94",
		MTK_EINT_FUNCTION(0, 94),
		MTK_FUNCTION(0, "GPIO94"),
		MTK_FUNCTION(1, "KPCOL1"),
		MTK_FUNCTION(6, "CMVREF0"),
		MTK_FUNCTION(7, "SPI2_MI")
	),
	MTK_PIN_LEGACY(
		95, "GPIO95",
		MTK_EINT_FUNCTION(0, 95),
		MTK_FUNCTION(0, "GPIO95"),
		MTK_FUNCTION(1, "URXD0"),
		MTK_FUNCTION(2, "UTXD0"),
		MTK_FUNCTION(3, "MD_URXD0"),
		MTK_FUNCTION(4, "MD_URXD1"),
		MTK_FUNCTION(5, "SSPM_URXD_AO"),
		MTK_FUNCTION(6, "CCU_URXD_AO"),
		MTK_FUNCTION(7, "DBG_MON_A34")
	),
	MTK_PIN_LEGACY(
		96, "GPIO96",
		MTK_EINT_FUNCTION(0, 96),
		MTK_FUNCTION(0, "GPIO96"),
		MTK_FUNCTION(1, "UTXD0"),
		MTK_FUNCTION(2, "URXD0"),
		MTK_FUNCTION(3, "MD_UTXD0"),
		MTK_FUNCTION(4, "MD_UTXD1"),
		MTK_FUNCTION(5, "SSPM_UTXD_AO"),
		MTK_FUNCTION(6, "CCU_UTXD_AO"),
		MTK_FUNCTION(7, "DBG_MON_A35")
	),
	MTK_PIN_LEGACY(
		97, "GPIO97",
		MTK_EINT_FUNCTION(0, 97),
		MTK_FUNCTION(0, "GPIO97"),
		MTK_FUNCTION(1, "UCTS0"),
		MTK_FUNCTION(2, "I2S2_MCK"),
		MTK_FUNCTION(3, "SPI3_CSB"),
		MTK_FUNCTION(4, "CONN_MCU_TDO"),
		MTK_FUNCTION(5, "SSPM_JTAG_TDO"),
		MTK_FUNCTION(6, "IO_JTAG_TDO"),
		MTK_FUNCTION(7, "DBG_MON_A36")
	),
	MTK_PIN_LEGACY(
		98, "GPIO98",
		MTK_EINT_FUNCTION(0, 98),
		MTK_FUNCTION(0, "GPIO98"),
		MTK_FUNCTION(1, "URTS0"),
		MTK_FUNCTION(2, "I2S2_BCK"),
		MTK_FUNCTION(3, "SPI3_MI"),
		MTK_FUNCTION(4, "CONN_MCU_TMS"),
		MTK_FUNCTION(5, "SSPM_JTAG_TMS"),
		MTK_FUNCTION(6, "IO_JTAG_TMS"),
		MTK_FUNCTION(7, "DBG_MON_A37")
	),
	MTK_PIN_LEGACY(
		99, "GPIO99",
		MTK_EINT_FUNCTION(0, 99),
		MTK_FUNCTION(0, "GPIO99"),
		MTK_FUNCTION(1, "CMMCLK0"),
		MTK_FUNCTION(4, "CONN_MCU_AICE_TMSC"),
		MTK_FUNCTION(7, "DBG_MON_A38")
	),
	MTK_PIN_LEGACY(
		100, "GPIO100",
		MTK_EINT_FUNCTION(0, 100),
		MTK_FUNCTION(0, "GPIO100"),
		MTK_FUNCTION(1, "CMMCLK1"),
		MTK_FUNCTION(2, "PWM_C"),
		MTK_FUNCTION(3, "MD_INT1_C2K_UIM0_HOT_PLUG"),
		MTK_FUNCTION(4, "CONN_MCU_AICE_TCKC"),
		MTK_FUNCTION(7, "DBG_MON_A39")
	),
	MTK_PIN_LEGACY(
		101, "GPIO101",
		MTK_EINT_FUNCTION(0, 101),
		MTK_FUNCTION(0, "GPIO101"),
		MTK_FUNCTION(1, "CLKM2"),
		MTK_FUNCTION(2, "I2S2_LRCK"),
		MTK_FUNCTION(3, "SPI3_CLK"),
		MTK_FUNCTION(4, "CONN_MCU_TCK"),
		MTK_FUNCTION(5, "SSPM_JTAG_TCK"),
		MTK_FUNCTION(6, "IO_JTAG_TCK"),
		MTK_FUNCTION(7, "DBG_MON_A40")
	),
	MTK_PIN_LEGACY(
		102, "GPIO102",
		MTK_EINT_FUNCTION(0, 102),
		MTK_FUNCTION(0, "GPIO102"),
		MTK_FUNCTION(1, "CLKM1"),
		MTK_FUNCTION(2, "I2S2_DI"),
		MTK_FUNCTION(3, "SPI3_MO"),
		MTK_FUNCTION(4, "CONN_MCU_TDI"),
		MTK_FUNCTION(5, "SSPM_JTAG_TDI"),
		MTK_FUNCTION(6, "IO_JTAG_TDI"),
		MTK_FUNCTION(7, "DBG_MON_A41")
	),
	MTK_PIN_LEGACY(
		103, "GPIO103",
		MTK_EINT_FUNCTION(0, 103),
		MTK_FUNCTION(0, "GPIO103"),
		MTK_FUNCTION(1, "SCL2")
	),
	MTK_PIN_LEGACY(
		104, "GPIO104",
		MTK_EINT_FUNCTION(0, 104),
		MTK_FUNCTION(0, "GPIO104"),
		MTK_FUNCTION(1, "SDA2")
	),
	MTK_PIN_LEGACY(
		105, "GPIO105",
		MTK_EINT_FUNCTION(0, 105),
		MTK_FUNCTION(0, "GPIO105"),
		MTK_FUNCTION(1, "SCL4")
	),
	MTK_PIN_LEGACY(
		106, "GPIO106",
		MTK_EINT_FUNCTION(0, 106),
		MTK_FUNCTION(0, "GPIO106"),
		MTK_FUNCTION(1, "SDA4")
	),
	MTK_PIN_LEGACY(
		107, "GPIO107",
		MTK_EINT_FUNCTION(0, 107),
		MTK_FUNCTION(0, "GPIO107"),
		MTK_FUNCTION(1, "ANT_SEL0"),
		MTK_FUNCTION(2, "PWM_A"),
		MTK_FUNCTION(3, "CLKM0"),
		MTK_FUNCTION(7, "DBG_MON_A45")
	),
	MTK_PIN_LEGACY(
		108, "GPIO108",
		MTK_EINT_FUNCTION(0, 108),
		MTK_FUNCTION(0, "GPIO108"),
		MTK_FUNCTION(1, "ANT_SEL1"),
		MTK_FUNCTION(2, "PWM_B"),
		MTK_FUNCTION(3, "CLKM1"),
		MTK_FUNCTION(4, "USB_DRVVBUS"),
		MTK_FUNCTION(5, "DAP_MD32_SWD"),
		MTK_FUNCTION(6, "PTA_RXD"),
		MTK_FUNCTION(7, "DBG_MON_A46")
	),
	MTK_PIN_LEGACY(
		109, "GPIO109",
		MTK_EINT_FUNCTION(0, 109),
		MTK_FUNCTION(0, "GPIO109"),
		MTK_FUNCTION(1, "ANT_SEL2"),
		MTK_FUNCTION(2, "PWM_C"),
		MTK_FUNCTION(3, "CLKM2"),
		MTK_FUNCTION(4, "IDDIG"),
		MTK_FUNCTION(5, "DAP_MD32_SWCK"),
		MTK_FUNCTION(6, "PTA_TXD"),
		MTK_FUNCTION(7, "DBG_MON_A47")
	),
	MTK_PIN_LEGACY(
		110, "GPIO110",
		MTK_EINT_FUNCTION(0, 110),
		MTK_FUNCTION(0, "GPIO110"),
		MTK_FUNCTION(1, "F2W_DATA"),
		MTK_FUNCTION(2, "PTA_TXD"),
		MTK_FUNCTION(3, "AUXIF_ST0"),
		MTK_FUNCTION(4, "SDA6"),
		MTK_FUNCTION(7, "DBG_MON_A48")
	),
	MTK_PIN_LEGACY(
		111, "GPIO111",
		MTK_EINT_FUNCTION(0, 111),
		MTK_FUNCTION(0, "GPIO111"),
		MTK_FUNCTION(1, "F2W_CK"),
		MTK_FUNCTION(2, "PTA_RXD"),
		MTK_FUNCTION(3, "AUXIF_CLK0"),
		MTK_FUNCTION(4, "SCL6"),
		MTK_FUNCTION(7, "DBG_MON_A49")
	),
	MTK_PIN_LEGACY(
		112, "GPIO112",
		MTK_EINT_FUNCTION(0, 112),
		MTK_FUNCTION(0, "GPIO112"),
		MTK_FUNCTION(1, "WB_RSTB"),
		MTK_FUNCTION(2, "URXD1"),
		MTK_FUNCTION(3, "PTA_RXD"),
		MTK_FUNCTION(7, "DBG_MON_A50")
	),
	MTK_PIN_LEGACY(
		113, "GPIO113",
		MTK_EINT_FUNCTION(0, 113),
		MTK_FUNCTION(0, "GPIO113"),
		MTK_FUNCTION(1, "WB_SCLK"),
		MTK_FUNCTION(2, "UTXD1"),
		MTK_FUNCTION(3, "PTA_TXD"),
		MTK_FUNCTION(4, "AUXIF_CLK1")
	),
	MTK_PIN_LEGACY(
		114, "GPIO114",
		MTK_EINT_FUNCTION(0, 114),
		MTK_FUNCTION(0, "GPIO114"),
		MTK_FUNCTION(1, "WB_SDATA"),
		MTK_FUNCTION(2, "AGPS_SYNC"),
		MTK_FUNCTION(3, "DAP_MD32_SWD"),
		MTK_FUNCTION(4, "AUXIF_ST1")
	),
	MTK_PIN_LEGACY(
		115, "GPIO115",
		MTK_EINT_FUNCTION(0, 115),
		MTK_FUNCTION(0, "GPIO115"),
		MTK_FUNCTION(1, "WB_SEN"),
		MTK_FUNCTION(2, "SRCLKENAI1"),
		MTK_FUNCTION(3, "DAP_MD32_SWCK")
	),
	MTK_PIN_LEGACY(
		116, "GPIO116",
		MTK_EINT_FUNCTION(0, 116),
		MTK_FUNCTION(0, "GPIO116"),
		MTK_FUNCTION(1, "WB_CTRL0"),
		MTK_FUNCTION(2, "MSDC2_DAT1"),
		MTK_FUNCTION(7, "DBG_MON_A55")
	),
	MTK_PIN_LEGACY(
		117, "GPIO117",
		MTK_EINT_FUNCTION(0, 117),
		MTK_FUNCTION(0, "GPIO117"),
		MTK_FUNCTION(1, "WB_CTRL1"),
		MTK_FUNCTION(2, "MSDC2_CMD"),
		MTK_FUNCTION(7, "DBG_MON_A53")
	),
	MTK_PIN_LEGACY(
		118, "GPIO118",
		MTK_EINT_FUNCTION(0, 118),
		MTK_FUNCTION(0, "GPIO118"),
		MTK_FUNCTION(1, "WB_CTRL2"),
		MTK_FUNCTION(2, "MSDC2_CLK"),
		MTK_FUNCTION(7, "DBG_MON_A54")
	),
	MTK_PIN_LEGACY(
		119, "GPIO119",
		MTK_EINT_FUNCTION(0, 119),
		MTK_FUNCTION(0, "GPIO119"),
		MTK_FUNCTION(1, "WB_CTRL3"),
		MTK_FUNCTION(2, "MSDC2_DAT3"),
		MTK_FUNCTION(7, "DBG_MON_A61")
	),
	MTK_PIN_LEGACY(
		120, "GPIO120",
		MTK_EINT_FUNCTION(0, 120),
		MTK_FUNCTION(0, "GPIO120"),
		MTK_FUNCTION(1, "WB_CTRL4"),
		MTK_FUNCTION(2, "MSDC2_DAT0"),
		MTK_FUNCTION(7, "DBG_MON_A51")
	),
	MTK_PIN_LEGACY(
		121, "GPIO121",
		MTK_EINT_FUNCTION(0, 121),
		MTK_FUNCTION(0, "GPIO121"),
		MTK_FUNCTION(1, "WB_CTRL5"),
		MTK_FUNCTION(2, "MSDC2_DAT2"),
		MTK_FUNCTION(7, "DBG_MON_A52")
	),
	MTK_PIN_LEGACY(
		122, "GPIO122",
		MTK_EINT_FUNCTION(0, 122),
		MTK_FUNCTION(0, "GPIO122"),
		MTK_FUNCTION(1, "MSDC0_CMD"),
		MTK_FUNCTION(3, "ANT_SEL1"),
		MTK_FUNCTION(7, "DBG_MON_A0")
	),
	MTK_PIN_LEGACY(
		123, "GPIO123",
		MTK_EINT_FUNCTION(0, 123),
		MTK_FUNCTION(0, "GPIO123"),
		MTK_FUNCTION(1, "MSDC0_DAT0"),
		MTK_FUNCTION(2, "MSDC0_DAT4"),
		MTK_FUNCTION(3, "ANT_SEL0"),
		MTK_FUNCTION(7, "DBG_MON_A4")
	),
	MTK_PIN_LEGACY(
		124, "GPIO124",
		MTK_EINT_FUNCTION(0, 124),
		MTK_FUNCTION(0, "GPIO124"),
		MTK_FUNCTION(1, "MSDC0_CLK"),
		MTK_FUNCTION(7, "DBG_MON_A5")
	),
	MTK_PIN_LEGACY(
		125, "GPIO125",
		MTK_EINT_FUNCTION(0, 125),
		MTK_FUNCTION(0, "GPIO125"),
		MTK_FUNCTION(1, "MSDC0_DAT2"),
		MTK_FUNCTION(2, "MSDC0_DAT5"),
		MTK_FUNCTION(3, "MRG_CLK"),
		MTK_FUNCTION(7, "DBG_MON_A6")
	),
	MTK_PIN_LEGACY(
		126, "GPIO126",
		MTK_EINT_FUNCTION(0, 126),
		MTK_FUNCTION(0, "GPIO126"),
		MTK_FUNCTION(1, "MSDC0_DAT4"),
		MTK_FUNCTION(2, "MSDC0_DAT2"),
		MTK_FUNCTION(3, "ANT_SEL5"),
		MTK_FUNCTION(6, "UFS_MPHY_SCL"),
		MTK_FUNCTION(7, "DBG_MON_A59")
	),
	MTK_PIN_LEGACY(
		127, "GPIO127",
		MTK_EINT_FUNCTION(0, 127),
		MTK_FUNCTION(0, "GPIO127"),
		MTK_FUNCTION(1, "MSDC0_DAT6"),
		MTK_FUNCTION(2, "MSDC0_DAT3"),
		MTK_FUNCTION(3, "ANT_SEL4"),
		MTK_FUNCTION(6, "UFS_MPHY_SDA"),
		MTK_FUNCTION(7, "DBG_MON_A58")
	),
	MTK_PIN_LEGACY(
		128, "GPIO128",
		MTK_EINT_FUNCTION(0, 128),
		MTK_FUNCTION(0, "GPIO128"),
		MTK_FUNCTION(1, "MSDC0_DAT1"),
		MTK_FUNCTION(2, "MSDC0_DAT6"),
		MTK_FUNCTION(3, "ANT_SEL2"),
		MTK_FUNCTION(6, "UFS_UNIPRO_SDA"),
		MTK_FUNCTION(7, "DBG_MON_A56")
	),
	MTK_PIN_LEGACY(
		129, "GPIO129",
		MTK_EINT_FUNCTION(0, 129),
		MTK_FUNCTION(0, "GPIO129"),
		MTK_FUNCTION(1, "MSDC0_DAT5"),
		MTK_FUNCTION(2, "MSDC0_DAT0"),
		MTK_FUNCTION(3, "ANT_SEL3"),
		MTK_FUNCTION(6, "UFS_UNIPRO_SCL"),
		MTK_FUNCTION(7, "DBG_MON_A57")
	),
	MTK_PIN_LEGACY(
		130, "GPIO130",
		MTK_EINT_FUNCTION(0, 130),
		MTK_FUNCTION(0, "GPIO130"),
		MTK_FUNCTION(1, "MSDC0_DAT7"),
		MTK_FUNCTION(3, "MRG_DO"),
		MTK_FUNCTION(7, "DBG_MON_A63")
	),
	MTK_PIN_LEGACY(
		131, "GPIO131",
		MTK_EINT_FUNCTION(0, 131),
		MTK_FUNCTION(0, "GPIO131"),
		MTK_FUNCTION(1, "MSDC0_DSL"),
		MTK_FUNCTION(3, "MRG_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_A64")
	),
	MTK_PIN_LEGACY(
		132, "GPIO132",
		MTK_EINT_FUNCTION(0, 132),
		MTK_FUNCTION(0, "GPIO132"),
		MTK_FUNCTION(1, "MSDC0_DAT3"),
		MTK_FUNCTION(2, "MSDC0_DAT1"),
		MTK_FUNCTION(3, "MRG_DI"),
		MTK_FUNCTION(7, "DBG_MON_A62")
	),
	MTK_PIN_LEGACY(
		133, "GPIO133",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO133"),
		MTK_FUNCTION(1, "MSDC0_RSTB"),
		MTK_FUNCTION(3, "AGPS_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_A60")
	),
	MTK_PIN_LEGACY(
		134, "GPIO134",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO134"),
		MTK_FUNCTION(1, "RTC32K_CK")
	),
	MTK_PIN_LEGACY(
		135, "GPIO135",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO135"),
		MTK_FUNCTION(1, "WATCHDOG")
	),
	MTK_PIN_LEGACY(
		136, "GPIO136",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO136"),
		MTK_FUNCTION(1, "AUD_CLK_MOSI"),
		MTK_FUNCTION(2, "AUD_CLK_MISO"),
		MTK_FUNCTION(3, "I2S1_MCK")
	),
	MTK_PIN_LEGACY(
		137, "GPIO137",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO137"),
		MTK_FUNCTION(1, "AUD_SYNC_MOSI"),
		MTK_FUNCTION(2, "AUD_SYNC_MISO"),
		MTK_FUNCTION(3, "I2S1_BCK")
	),
	MTK_PIN_LEGACY(
		138, "GPIO138",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO138"),
		MTK_FUNCTION(1, "AUD_DAT_MOSI0"),
		MTK_FUNCTION(2, "AUD_DAT_MISO0"),
		MTK_FUNCTION(3, "I2S1_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_A1")
	),
	MTK_PIN_LEGACY(
		139, "GPIO139",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO139"),
		MTK_FUNCTION(1, "AUD_DAT_MOSI1"),
		MTK_FUNCTION(2, "AUD_DAT_MISO1"),
		MTK_FUNCTION(3, "I2S1_DO")
	),
	MTK_PIN_LEGACY(
		140, "GPIO140",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO140"),
		MTK_FUNCTION(1, "AUD_CLK_MISO"),
		MTK_FUNCTION(2, "AUD_CLK_MOSI"),
		MTK_FUNCTION(3, "I2S0_MCK")
	),
	MTK_PIN_LEGACY(
		141, "GPIO141",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO141"),
		MTK_FUNCTION(1, "AUD_SYNC_MISO"),
		MTK_FUNCTION(2, "AUD_SYNC_MOSI"),
		MTK_FUNCTION(3, "I2S0_BCK")
	),
	MTK_PIN_LEGACY(
		142, "GPIO142",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO142"),
		MTK_FUNCTION(1, "AUD_DAT_MISO0"),
		MTK_FUNCTION(2, "AUD_DAT_MOSI0"),
		MTK_FUNCTION(3, "I2S0_LRCK"),
		MTK_FUNCTION(7, "DBG_MON_A2")
	),
	MTK_PIN_LEGACY(
		143, "GPIO143",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO143"),
		MTK_FUNCTION(1, "AUD_DAT_MISO1"),
		MTK_FUNCTION(2, "AUD_DAT_MOSI1"),
		MTK_FUNCTION(3, "I2S0_DI"),
		MTK_FUNCTION(7, "DBG_MON_A3")
	),
	MTK_PIN_LEGACY(
		144, "GPIO144",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO144"),
		MTK_FUNCTION(1, "PWRAP_SPI0_MI"),
		MTK_FUNCTION(2, "PWRAP_SPI0_MO")
	),
	MTK_PIN_LEGACY(
		145, "GPIO145",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO145"),
		MTK_FUNCTION(1, "PWRAP_SPI0_CSN")
	),
	MTK_PIN_LEGACY(
		146, "GPIO146",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO146"),
		MTK_FUNCTION(1, "PWRAP_SPI0_MO"),
		MTK_FUNCTION(2, "PWRAP_SPI0_MI")
	),
	MTK_PIN_LEGACY(
		147, "GPIO147",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO147"),
		MTK_FUNCTION(1, "PWRAP_SPI0_CK")
	),
	MTK_PIN_LEGACY(
		148, "GPIO148",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO148"),
		MTK_FUNCTION(1, "SRCLKENA0")
	),
	MTK_PIN_LEGACY(
		149, "GPIO149",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO149"),
		MTK_FUNCTION(1, "SRCLKENA1")
	),
	MTK_PIN_LEGACY(
		150, "GPIO150",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO150"),
		MTK_FUNCTION(1, "RFIC0_BSI_EN"),
		MTK_FUNCTION(2, "SPM_BSI_EN"),
		MTK_FUNCTION(7, "DBG_MON_B7")
	),
	MTK_PIN_LEGACY(
		151, "GPIO151",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO151"),
		MTK_FUNCTION(1, "RFIC0_BSI_CK"),
		MTK_FUNCTION(2, "SPM_BSI_CK"),
		MTK_FUNCTION(7, "DBG_MON_B8")
	),
	MTK_PIN_LEGACY(
		152, "GPIO152",
		MTK_EINT_FUNCTION(0, 139),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		153, "GPIO153",
		MTK_EINT_FUNCTION(0, 140),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		154, "GPIO154",
		MTK_EINT_FUNCTION(0, 141),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		155, "GPIO155",
		MTK_EINT_FUNCTION(0, 142),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		156, "GPIO156",
		MTK_EINT_FUNCTION(0, 143),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		157, "GPIO157",
		MTK_EINT_FUNCTION(0, 145),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		158, "GPIO158",
		MTK_EINT_FUNCTION(0, 146),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		159, "GPIO159",
		MTK_EINT_FUNCTION(0, 147),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		160, "GPIO160",
		MTK_EINT_FUNCTION(0, 148),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		161, "GPIO161",
		MTK_EINT_FUNCTION(0, 149),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		162, "GPIO162",
		MTK_EINT_FUNCTION(0, 150),
		MTK_FUNCTION(0, NULL)
	),
	MTK_PIN_LEGACY(
		163, "GPIO163",
		MTK_EINT_FUNCTION(0, 151),
		MTK_FUNCTION(0, NULL)
	),
};

#endif /* __PINCTRL_MTK_MT6763_H */
