/**
 * @file   maxic_mt5725.h
 * @date   Mon May 13 16:51:39 2019
 * @brief  Maxictech Proprietary and Confidential
 *         Copyright (c) 2017 Maxic Technology Corporation
 *         All Rights Reserved
 */
#ifndef __MAXIC_MT5725_H__
#define __MAXIC_MT5725_H__


/*typedef          unsigned int    u32;
typedef          unsigned short  u16;
typedef          unsigned char   u8;

typedef          signed int      s32;
typedef          signed short    s16;
typedef          signed char     s8;*/

typedef volatile unsigned int    vu32;
typedef volatile unsigned short  vu16;
typedef volatile unsigned char   vu8;

typedef volatile signed int      vs32;
typedef volatile signed short    vs16;
typedef volatile signed char     vs8;


#define MT5725_HSCLK          80000UL
#define MT5725_F2P(f)         (MT5725_HSCLK/(f)-2)
#define MT5725_P2F(p)         (MT5725_HSCLK/((p)+2))

#define MAX_PKT_SIZE          22 /// ASK PPe2
#define MAX_MSG_SIZE          20
#define MAX_BC_SIZE           10 /// FSK PP8f

#define FSK_WAITTING              0
#define FSK_SUCCESS               1
#define FSK_FAILED                2

#define LBIT(n)                (1<<(n))
#define _LBIT(n)              (~LBIT(n))

#define MT5725ID              0X5725
#define SRAM_PAGE_SIZE        128

#define MT5725_WDG_DISABLE    0X95
#define MT5725_WDT_INTFALG    0X01
#define MT5725_KEY            0X57
#define MT5725_M0_HOLD        BIT(5)
#define MT5725_M0_RESET       BIT(7)

#define DISABLE_ADD_CURRENT   0xFF
#define ENABLE_ADD_CURRENT   0x00

// ------------------------- REGISTER -------------------------
//Rx
#define REG_CHIPID            0x0000
#define REG_FW_VER            0x0004
#define REG_CMD               0x0006
#define REG_KEY               0x0008
#define REG_INTFLAG           0x000C
#define REG_INTCLR            0x000E
#define REG_IOUT              0x0018
#define REG_VOUT              0x001A
#define REG_VOUTSET           0x001E
#define REG_VFC               0x0022
#define REG_PPP               0x0040
#define REG_BC                0x0056
#define REG_MAXPOWER          0x0096
#define REG_CEPVALUE          0x0097
#define REG_CURFUNC           0x0099      

//TX
#define REG_STABILITY         0x0054
#define REG_IIN               0x007E
#define REG_VIN               0x0080
#define REG_F_TXPOWER         0x008E
#define REG_F_RXPOWER         0x0090
#define REG_F_ISTAY           0x0092
#define REG_FPERIOD           0x0094
#define REG_RXCHARGESTATUS    0x0096


#define REG_PMU_WDGEN         0x5808
#define REG_PMU_FLAG          0x5800
#define REG_SYS_KEY           0x5244
#define REG_SRAM_REMAP        0x5218
#define REG_CODE_REMAP        0x5208
#define REG_M0_CTRL           0x5200
#define REG_Tx_START          0x0800
#define REG_Rx_START          0x0600


typedef enum {
    ADAPTER_NONE                  = 0x00,
    ADAPTER_SDP                   = 0x01, // 500mA
    ADAPTER_CDP                   = 0x02, // 1.1A
    ADAPTER_DCP                   = 0x03, // 1.5A
    ADAPTER_QC20                  = 0x04, // QC2.0
    ADAPTER_QC30                  = 0x05, // QC3.0
    ADAPTER_PD                    = 0x06, // PD
    ADAPTER_FCP                   = 0x07, // FCP
    ADAPTER_SCP                   = 0x08, // SCP
    ADAPTER_DCS                   = 0x09, // DC source
    ADAPTER_AFC                   = 0x0b, // AFC
    ADAPTER_PDPPS                 = 0x0c, // PD PPS
} ADAPTER_TYPE;


// system mode
typedef enum {
    RXMODE                    = LBIT(0),
    TXMODE                    = LBIT(2),
    ACMISSING                 = LBIT(3),
    OTPMODE                   = LBIT(4),
    EPRMODE                   = LBIT(5),
    SRAMMODE                  = LBIT(6),
} _SYS_MODE_E;

typedef enum {
    SEND_PPP                  = LBIT(0),
    TOGGLE_LDO                = LBIT(1),
    CLEAR_INT                 = LBIT(5),
    FW_UPDATE                 = LBIT(6),
    FAST_CHARGE               = LBIT(7),

    OVP_CHANGE                = LBIT(8),
    OCP_CHANGE                = LBIT(9),
    VOUT_CHANGE               = LBIT(10),
    D2_ENABLE                 = LBIT(11),
    D2_DISABLE                = LBIT(12),
} _CUST_CMD_E;

// ------------------------- INTFLAG -------------------------
typedef enum {
     // RX
    INT_OCP                   = BIT(0),
    INT_TXACKFOD              = BIT(1),
    INT_PLDO                  = BIT(2),
    INT_RX_READY              = BIT(3),
    INT_FSK_RECV              = BIT(4),
    INT_NORESPOND             = BIT(5),
    INT_LDO_ON                = BIT(6),
    INT_LDO_OFF               = BIT(7),

    INT_AFC                   = BIT(8),
    INT_EPP                   = BIT(9),
    INT_FSK_TIMEOUT           = BIT(10),
    INT_FSK_SUCCESS           = BIT(11),
    INT_BPP                   = BIT(12),
    INT_ADDCURRENT            = BIT(13),

    INT_SLEEP                 = BIT(14),
    INT_POWER_ON              = BIT(15),

    // TX
    INT_BC                    = BIT(0),
    INT_TIMEOUT               = BIT(1),
    INT_SUCCESS               = BIT(2),
    INT_DETECT_RX             = BIT(3),
    INT_OCPFRX                = BIT(4),
    INT_FODDE                 = BIT(5),
    INT_REMOVE_POEWR          = BIT(6),
    INT_CHIP_DISABLE          = BIT(7),
    INT_POWER_TRANS           = BIT(8),
    INT_CHIP_ENABLE           = BIT(9),
    INT_TX_OVP                = BIT(10),
    INT_CHARGE_STATUS         = BIT(11),
    INT_TXINIT                = BIT(12),
} _INT_TYPE_E;

/// Table 6-3: Packet types
typedef enum {
    PP_NONE                   = 0x00,
    // ping phase
    SIGNALSTRENGTHPACKET      = 0x01,
    ENDPOWERXFERPACKET        = 0x02,
    // identification & configuration phase
    POWERHOLDOFFPACKET        = 0x06,
    CONFIGURATIONPACKET       = 0x51,
    IDENTIFICATIONPACKET      = 0x71,
    EXTIDENTPACKET            = 0x81,
    // power transfer phase
    CONTROLERRORPACKET        = 0x03,
    RECEIVEDPOWER8bit         = 0x04,
    CHARGESTATUSPACKET        = 0x05,
    GENERALREQUEST            = 0x07,
    RENEGOTIATE               = 0x09,
    SPECIFICREQUEST           = 0x20,
    FODSTATUS                 = 0x22,
    RECEIVEDPOWER24bit        = 0x31,
    WPIDPACKET54              = 0x54,
    WPIDPACKET55              = 0x55,
    // identification & configuration / power transfer phase
    PP18                      = 0x18,
    PP19                      = 0x19,
    PP28                      = 0x28,
    PP29                      = 0x29,
    PP38                      = 0x38,
    PP48                      = 0x48,
    PP58                      = 0x58,
    PP68                      = 0x68,
    PP78                      = 0x78,
    PP84                      = 0x84,
    PPa4                      = 0xa4,
    PPc4                      = 0xc4,
    PPe2                      = 0xe2,
    // Negotiation phase
    PP1E                      = 0x1e,
    PP1F                      = 0x1f,
    PP2E                      = 0x2e,
    PP2F                      = 0x2f,
    PP3F                      = 0x3f,
    PP4F                      = 0x4f,
    PP5F                      = 0x5f,
    PP6F                      = 0x6f,
    PP7F                      = 0x7f,
    PP8F                      = 0x8f,

    // General Request Packet
    PTDNAPACKET               = 0x00,
    PTIDPACKET                = 0x30,
    PTCAPPACKET               = 0x31,
} WPCHeaderType;

// customer command
typedef enum {
    CMD_NONE                  = 0x00,

    CMD_READ_HW_VER           = 0xa2,
    CMD_READ_FW_VER           = 0xa3,
    CMD_ADAPTER_TYPE          = 0xa4,

    CMD_TOGGLE_LOOPMODE       = 0xb0,
    CMD_SET_PERIOD            = 0xb1,
    CMD_GET_PERIOD            = 0xb2,
    CMD_SET_FREQ              = 0xb3,
    CMD_GET_FREQ              = 0xb4,
    CMD_SET_DUTYCYCLE         = 0xb5,
    CMD_SET_MINFREQ           = 0xb6,
    CMD_SET_MAXFREQ           = 0xb7,
    CMD_SET_PINGFREQ          = 0xb8,
    CMD_GET_DUTYCYCLE         = 0xb9,
    CMD_GET_MINFREQ           = 0xba,
    CMD_GET_MAXFREQ           = 0xbb,
    CMD_GET_PINGFREQ          = 0xbc,
    CMD_SET_DEADTIME          = 0xbd,
    CMD_GET_DEADTIME          = 0xbe,

    CMD_GET_Vcoil             = 0xcf,
    CMD_GET_Iin               = 0xd0,
    CMD_GET_Vin               = 0xd1,
    CMD_SET_Vin               = 0xd2,
    CMD_GET_Vbrg              = 0xd3,
    CMD_SET_Vbrg              = 0xd4,
    CMD_GET_TEMP              = 0xd6,

    CMD_TEST                  = 0xee,
} PrivateCmdType;

typedef struct {
    u8 header;
    union {
        u8 msg[MAX_MSG_SIZE-1];
        struct {
            u8 cmd;
            u8 data[MAX_MSG_SIZE-2];
        };
    } msg_pakt;
} PktType;

// End Power Transfer Packet Codes
typedef enum {
    EPT_UNKNOWN              = 0x00,   // The Receiver may use this value if it does not have a specific reason for terminating the power transfer, or if none of the other values listed in Table 6-6 is appropriate.
    EPT_CHGCOMPLETE          = 0x01,   // The Receiver should use this value if it determines that the battery of the Mobile Device is fully charged. On receipt of an End Power Transfer Packet containing this value, the Transmitter should set any charged indication on its user interface that is associated with the Receiver.
    EPT_INTERNALFAULT        = 0x02,   // The Receiver may use this value if it has encountered some internal problem, e.g. a software or logic error.
    EPT_OVERTEMPERATURE      = 0x03,   // The Receiver should use this value if it has measured a temperature within the Mobile Device that exceeds a limit.
    EPT_OVERVOLTAGE          = 0x04,   // The Receiver should use this value if it has measured a voltage within the Mobile Device that exceeds a limit.
    EPT_OVERCURRENT          = 0x05,   // The Receiver should use this value if it has measured a current within the Mobile Device that exceeds a limit.
    EPT_BATTERYFAILURE       = 0x06,   // The Receiver should use this value if it has determined a problem with the battery of the Mobile Device.
    EPT_RECONFIGURE          = 0x07,
    EPT_NORESPONSE           = 0x08,   // The Receiver should use this value if it determines that the Transmitter does not respond to Control Error Packets as expected (i.e. does not increase/decrease its Primary Cell current appropriately).
    EPT_RESERVED09           = 0x09,
    EPT_NEGOTIATION_FAILURE  = 0x0a,   // A Power Receiver should use this value if it cannot negotiate a suitable Guaranteed Power level.
    EPT_RESTART_POWER_TRANSFER = 0x0b, // A Power Receiver should use this value if sees a need for Foreign Object Detection with no power transfer in progress (see Section 11.3, FOD based on quality factor change). To enable such detection, the power transfer has to be terminated. Typically, the Power Transmitter then performs Foreign Object Detection before restarting the power transfer.
    EPT_MASK                 = 0x80,
    EPT_RESERVED_0X0C_0XFF   = 0xff,
} EPTResonType;

const u8 MT5725_onlg_boot_bin[] = {
    //Nothing
};

const u8 MT5725_forceotp_bin[] = { /// 0x00
0x00,0x06,0x00,0x20,0xed,0x01,0x00,0x00,0x8d,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x25,0x57,0x25,0x57,0x00,
0x06,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x91,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x93,0x00,0x00,0x00,0x13,0x01,0x00,
0x00,0x99,0x00,0x00,0x00,0x9f,0x00,0x00,0x00,0xa5,0x00,0x00,0x00,0xab,0x00,0x00,0x00,0xb1,0x00,0x00,0x00,
0xb7,0x00,0x00,0x00,0xbd,0x00,0x00,0x00,0xc3,0x00,0x00,0x00,0xc9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xcf,
0x00,0x00,0x00,0xd5,0x00,0x00,0x00,0xdb,0x00,0x00,0x00,0xe3,0x00,0x00,0x00,0xeb,0x00,0x00,0x00,0xf3,0x00,
0x00,0x00,0xfb,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0x0b,0x01,0x00,0x00,0xfe,0xe7,0xfe,0xe7,0xfe,0xe7,0xfe,
0xe7,0xfe,0xe7,0x00,0x00,0xa7,0x48,0x40,0x6d,0x00,0x47,0xa6,0x48,0x80,0x6d,0x00,0x47,0xa4,0x48,0xc0,0x6d,
0x00,0x47,0xa3,0x48,0x00,0x6e,0x00,0x47,0xa1,0x48,0x40,0x6e,0x00,0x47,0xa0,0x48,0x80,0x6e,0x00,0x47,0x9e,
0x48,0xc0,0x6e,0x00,0x47,0x9d,0x48,0x00,0x6f,0x00,0x47,0x9b,0x48,0x40,0x6f,0x00,0x47,0x9a,0x48,0x80,0x6f,
0x00,0x47,0x98,0x48,0xc0,0x6f,0x00,0x47,0x97,0x48,0x80,0x30,0x00,0x68,0x00,0x47,0x95,0x48,0x80,0x30,0x40,
0x68,0x00,0x47,0x93,0x48,0x80,0x30,0x80,0x68,0x00,0x47,0x91,0x48,0x80,0x30,0xc0,0x68,0x00,0x47,0x8f,0x48,
0x80,0x30,0x00,0x69,0x00,0x47,0x8d,0x48,0x80,0x30,0x40,0x69,0x00,0x47,0x8b,0x48,0x80,0x30,0x80,0x69,0x00,
0x47,0x8a,0x48,0x01,0x68,0x49,0x1c,0x01,0x60,0x70,0x47,0xf0,0xb5,0x87,0x4b,0x87,0x4d,0x5a,0x68,0x1e,0x1d,
0x14,0x68,0x72,0xb6,0x08,0xe0,0x0c,0x3a,0x97,0x68,0x87,0x42,0x02,0xd1,0x22,0xc2,0x62,0xb6,0xf0,0xbd,0x22,
0x46,0x24,0x68,0xb2,0x42,0xf4,0xd1,0x00,0x24,0x14,0x22,0x62,0x43,0xd2,0x18,0x56,0x69,0x0c,0x32,0x00,0x2e,
0x04,0xd0,0x64,0x1c,0x08,0x2c,0xf5,0xdb,0x62,0xb6,0xf0,0xbd,0x90,0x60,0x78,0x48,0x40,0x1c,0x81,0x42,0x03,
0xd1,0x01,0x21,0x11,0x60,0x50,0x60,0x01,0xe0,0x22,0xc2,0x08,0x3a,0x0c,0x32,0x98,0x68,0x9a,0x60,0x1b,0x1d,
0x13,0x60,0x50,0x60,0x02,0x60,0xea,0xe7,0x70,0x48,0x80,0x68,0x00,0x07,0x04,0xd4,0x6f,0x48,0x08,0x22,0x41,
0x79,0x11,0x43,0x41,0x71,0x70,0x47,0xf8,0xb5,0x72,0xb6,0x68,0x48,0x67,0x4e,0x40,0x68,0x00,0x27,0x36,0x1d,
0x04,0x68,0x06,0xe0,0x05,0x46,0x0c,0x3d,0x00,0xf0,0xba,0xf8,0xaf,0x60,0x20,0x46,0x24,0x68,0xb0,0x42,0xf6,
0xd1,0x63,0x48,0xc1,0x88,0x49,0x06,0xfc,0xd4,0x41,0x79,0xef,0x22,0xcd,0x07,0x40,0x23,0x60,0x4c,0x00,0x2d,
0x04,0xd0,0x11,0x40,0x19,0x43,0x41,0x71,0xa0,0x69,0x05,0xe0,0x4d,0x07,0x05,0xd5,0x11,0x40,0x19,0x43,0x41,
0x71,0xe0,0x69,0x80,0x47,0xf8,0xbd,0xfe,0xe7,0x1c,0xb5,0x58,0x49,0x57,0x20,0x48,0x63,0x95,0x20,0x88,0x60,
0x56,0x49,0x72,0xb6,0xf0,0x20,0x88,0x60,0xc8,0x14,0xc8,0x60,0x54,0x48,0x40,0x68,0x01,0x21,0x08,0x43,0x52,
0x49,0x48,0x60,0x48,0x68,0x40,0x08,0x40,0x00,0x48,0x60,0x4e,0x49,0x01,0x20,0x08,0x60,0x4f,0x48,0x48,0x60,
0x00,0x24,0x0c,0x60,0x4e,0x49,0x57,0x20,0x48,0x60,0x40,0x22,0x4d,0x49,0x4d,0x48,0x00,0xf0,0x61,0xfa,0xff,
0x22,0x41,0x32,0x00,0x21,0x4b,0x48,0x00,0xf0,0x5b,0xfa,0x4c,0x48,0x4a,0x49,0x41,0x61,0x4b,0x4a,0x07,0x23,
0xd5,0x69,0x04,0x21,0x2d,0x02,0x2d,0x0a,0x46,0x04,0x35,0x43,0xd5,0x61,0x84,0x61,0x03,0x61,0x37,0x4e,0x46,
0x4a,0x35,0x1d,0x75,0x60,0x30,0x46,0xac,0x30,0xb5,0x60,0x00,0x60,0x40,0x60,0x01,0x20,0x50,0x60,0x41,0x48,
0x40,0x38,0xc0,0x68,0x33,0x4c,0x80,0x04,0x60,0x79,0x00,0xd4,0x01,0x21,0x08,0x43,0x60,0x71,0x3d,0x48,0x3e,
0x49,0x00,0x88,0x88,0x42,0x08,0xd1,0x60,0x79,0x10,0x21,0x08,0x43,0x60,0x71,0x40,0x22,0x38,0x49,0x3a,0x48,
0x00,0xf0,0x3f,0xfa,0x61,0x79,0x29,0x48,0xca,0x07,0x01,0xd0,0x80,0x69,0x02,0xe0,0x49,0x07,0x01,0xd5,0xc0,
0x69,0x80,0x47,0x62,0xb6,0x20,0x48,0x00,0x1d,0x01,0x90,0x1e,0x49,0x08,0x68,0x87,0x1b,0x06,0x46,0x48,0x68,
0x26,0xe0,0x04,0x46,0x0c,0x3c,0x1b,0x4a,0x61,0x68,0x91,0x42,0x02,0xd1,0x00,0x20,0x60,0x60,0x1c,0xe0,0x21,
0x68,0xb9,0x42,0x01,0xd9,0xc9,0x1b,0x00,0xe0,0x00,0x21,0x21,0x60,0x00,0x29,0x13,0xd1,0x13,0x4a,0x61,0x68,
0x52,0x1c,0x91,0x42,0x04,0xd1,0xa0,0x68,0x80,0x47,0x01,0x20,0x20,0x60,0x09,0xe0,0xa1,0x68,0x00,0x91,0x72,
0xb6,0x00,0xf0,0x0b,0xf8,0x00,0x20,0xa0,0x60,0x00,0x99,0x62,0xb6,0x88,0x47,0x28,0x46,0x01,0x99,0x05,0x68,
0x88,0x42,0xce,0xd0,0xd3,0xe7,0x06,0xc8,0x08,0x38,0x4a,0x60,0x06,0xc8,0x11,0x60,0x00,0x21,0x08,0x38,0x01,
0x60,0x41,0x60,0x70,0x47,0x00,0x02,0x00,0x20,0x00,0x01,0x00,0x20,0xfe,0xff,0xff,0x7f,0x00,0x5c,0x00,0x40,
0x00,0x00,0x00,0x20,0x00,0x06,0x00,0x20,0x00,0x58,0x00,0x40,0x00,0x5a,0x00,0x40,0x00,0x44,0x00,0x40,0x01,
0x07,0x00,0x00,0x40,0x52,0x00,0x40,0xef,0xbe,0xad,0xde,0x10,0x05,0x00,0x20,0x00,0x00,0x00,0x20,0x3f,0x1f,
0x00,0x00,0x00,0xe0,0x00,0xe0,0x04,0xed,0x00,0xe0,0x40,0x60,0x00,0x40,0x00,0x0a,0x00,0x00,0x25,0x57,0x00,
0x00,0x00,0x06,0x00,0x20,0x5c,0x48,0x43,0x21,0x41,0x61,0x00,0x21,0x01,0x22,0x03,0x69,0x53,0x40,0x03,0x61,
0x49,0x1c,0x14,0x29,0xf9,0xdb,0x01,0x69,0x11,0x43,0x01,0x61,0x05,0x21,0x41,0x61,0x70,0x47,0x10,0xb5,0x54,
0x48,0xc1,0x68,0x01,0x24,0x21,0x43,0xc1,0x60,0xff,0xf7,0xe7,0xff,0x50,0x49,0x05,0x20,0x48,0x61,0x88,0x61,
0x50,0x48,0x00,0x21,0x41,0x60,0x01,0x60,0xff,0x22,0x42,0x61,0xa0,0x22,0x82,0x61,0x27,0x22,0xc2,0x61,0x30,
0x22,0x42,0x60,0x04,0x60,0x4a,0x48,0x01,0x60,0x01,0x61,0x10,0xbd,0x10,0xb5,0xff,0xf7,0xcf,0xff,0x46,0x49,
0x00,0x20,0x48,0x60,0x08,0x60,0x45,0x49,0x08,0x61,0x41,0x49,0x01,0x20,0x48,0x61,0x88,0x61,0x40,0x48,0xc1,
0x68,0x49,0x08,0x49,0x00,0xc1,0x60,0x10,0xbd,0xf8,0xb5,0x15,0x46,0x0f,0x46,0x06,0x46,0xff,0xf7,0xb9,0xff,
0x00,0x20,0x00,0xf0,0x64,0xf8,0x39,0x4c,0x38,0x0a,0xe0,0x60,0x10,0x20,0x00,0xf0,0x4d,0xf8,0xf8,0xb2,0xe0,
0x60,0x10,0x20,0x00,0xf0,0x48,0xf8,0x01,0x20,0x00,0xf0,0x56,0xf8,0x04,0x27,0x0a,0xe0,0x08,0x20,0x00,0xf0,
0x40,0xf8,0x01,0x2d,0x02,0xd1,0x60,0x68,0x38,0x43,0x60,0x60,0xe0,0x68,0x30,0x70,0x76,0x1c,0x6d,0x1e,0xf2,
0xd2,0x60,0x68,0x02,0x21,0x08,0x43,0x60,0x60,0x08,0x46,0x00,0xf0,0x2f,0xf8,0xf8,0xbd,0xf8,0xb5,0x15,0x46,
0x0f,0x46,0x06,0x46,0xff,0xf7,0x8b,0xff,0x00,0x20,0x00,0xf0,0x36,0xf8,0x22,0x4c,0x38,0x0a,0xe0,0x60,0x10,
0x20,0x00,0xf0,0x1f,0xf8,0xf8,0xb2,0xe0,0x60,0x10,0x20,0x00,0xf0,0x1a,0xf8,0x1f,0x48,0x02,0x68,0x08,0x21,
0x0a,0x43,0x02,0x60,0x20,0x68,0x08,0x43,0x20,0x60,0x1a,0x49,0xff,0x20,0xc8,0x60,0x88,0x60,0x00,0x20,0x08,
0x60,0x6d,0x1e,0x4d,0x61,0xce,0x61,0x14,0x48,0x0c,0x30,0x88,0x61,0x03,0x20,0x08,0x61,0x01,0x20,0x00,0xf0,
0x12,0xf8,0xf8,0xbd,0x70,0xb5,0x04,0x46,0x00,0x26,0x0e,0x4d,0x06,0xe0,0x30,0x46,0x76,0x1c,0x64,0x28,0x06,
0xd8,0x0a,0x20,0x00,0xf0,0xff,0xf8,0x68,0x69,0x20,0x42,0xf5,0xd0,0x6c,0x61,0x70,0xbd,0x07,0x49,0xff,0x22,
0x4a,0x61,0x00,0x28,0x01,0xd0,0x21,0x20,0x00,0xe0,0x31,0x20,0x48,0x60,0x01,0x20,0xe3,0xe7,0x00,0x00,0x00,
0x60,0x00,0x40,0x00,0x5a,0x00,0x40,0x00,0x22,0x00,0x40,0x00,0x50,0x00,0x40,0x00,0x52,0x00,0x40,0xf0,0xb5,
0x6a,0x4e,0x6a,0x4d,0x01,0x24,0xb0,0x42,0x02,0xd1,0xee,0x68,0x26,0x43,0x05,0xe0,0x68,0x4e,0xb0,0x42,0x03,
0xd1,0xee,0x68,0x02,0x27,0x3e,0x43,0xee,0x60,0x00,0x25,0x45,0x60,0x05,0x60,0xff,0x26,0x46,0x61,0x82,0x61,
0xc1,0x61,0x30,0x21,0x41,0x60,0x04,0x60,0xff,0x2b,0x0c,0xd0,0x5f,0x48,0x04,0x60,0x19,0x01,0x08,0x18,0x05,
0x61,0x5e,0x48,0x01,0x68,0x21,0x43,0x01,0x60,0x5d,0x48,0x01,0x68,0x21,0x43,0x01,0x60,0xf0,0xbd,0x10,0xb5,
0x00,0x22,0x42,0x60,0x02,0x60,0x53,0x4c,0x54,0x4b,0xa0,0x42,0x03,0xd1,0xd8,0x68,0x40,0x08,0x40,0x00,0x05,
0xe0,0x51,0x4c,0xa0,0x42,0x03,0xd1,0xd8,0x68,0x02,0x24,0xa0,0x43,0xd8,0x60,0x08,0x01,0x4e,0x49,0x40,0x18,
0x02,0x61,0x10,0xbd,0xf8,0xb5,0x0e,0x46,0x1f,0x46,0x15,0x46,0x04,0x46,0x00,0x21,0x00,0xf0,0x81,0xf8,0xf8,
0x07,0xc0,0x0f,0x00,0x90,0x09,0xe0,0x30,0x78,0xe0,0x60,0x00,0x98,0x76,0x1c,0x28,0x43,0x05,0xd0,0x10,0x21,
0x20,0x46,0x00,0xf0,0x62,0xf8,0x6d,0x1e,0xf3,0xd2,0xb8,0x07,0x07,0xd5,0x61,0x68,0x20,0x46,0x02,0x22,0x11,
0x43,0x61,0x60,0x11,0x46,0x00,0xf0,0x56,0xf8,0xf8,0xbd,0xf8,0xb5,0x0d,0x46,0x14,0x46,0x06,0x46,0x01,0x21,
0x00,0xf0,0x5f,0xf8,0x06,0x27,0x08,0xe0,0x08,0x21,0x30,0x46,0x00,0xf0,0x48,0xf8,0xf0,0x68,0x28,0x70,0x6d,
0x1c,0x01,0x2c,0x06,0xd0,0x64,0x1e,0xf4,0xd2,0x02,0x21,0x30,0x46,0x00,0xf0,0x3d,0xf8,0xf8,0xbd,0x70,0x68,
0x38,0x43,0x70,0x60,0x00,0x24,0xea,0xe7,0x70,0xb5,0x2e,0x4c,0x26,0x68,0x08,0x25,0x2e,0x43,0x26,0x60,0x04,
0x68,0x2c,0x43,0x04,0x60,0x27,0x4c,0xff,0x25,0xe5,0x60,0xa5,0x60,0x01,0x25,0x25,0x60,0x1b,0x01,0x1b,0x19,
0x52,0x1e,0x5a,0x61,0xd9,0x61,0x01,0x46,0x0c,0x31,0x99,0x61,0x23,0x21,0x19,0x61,0x29,0x46,0x00,0xf0,0x2c,
0xf8,0x70,0xbd,0x70,0xb5,0x04,0x68,0x04,0x25,0x2c,0x43,0x04,0x60,0x1e,0x4c,0x25,0x68,0x08,0x26,0x35,0x43,
0x25,0x60,0x18,0x4c,0xff,0x25,0xe5,0x60,0xa5,0x60,0x01,0x25,0x25,0x60,0x1b,0x01,0x1b,0x19,0x52,0x1e,0x5a,
0x61,0xd9,0x61,0x0c,0x30,0x98,0x61,0x21,0x20,0x18,0x61,0x70,0xbd,0x70,0xb5,0x0c,0x46,0x05,0x46,0x00,0x26,
0x06,0xe0,0x30,0x46,0x76,0x1c,0x64,0x28,0x06,0xd8,0x0a,0x20,0x00,0xf0,0x1e,0xf8,0x68,0x69,0x20,0x42,0xf5,
0xd0,0x6c,0x61,0x70,0xbd,0xff,0x22,0x42,0x61,0x00,0x29,0x01,0xd0,0x21,0x21,0x00,0xe0,0x31,0x21,0x41,0x60,
0x01,0x21,0xe4,0xe7,0x00,0x00,0x00,0x22,0x00,0x40,0x00,0x5a,0x00,0x40,0x00,0x24,0x00,0x40,0x00,0x50,0x00,
0x40,0x80,0xe2,0x00,0xe0,0x00,0xe1,0x00,0xe0,0x00,0x52,0x00,0x40,0x01,0xb5,0x00,0xe0,0x00,0xbf,0x00,0x98,
0x41,0x1e,0x00,0x91,0xfa,0xd2,0x08,0xbd,0x01,0xe0,0x01,0x70,0x40,0x1c,0x52,0x1e,0xfb,0xd2,0x70,0x47,0x00,
0xe0,0x02,0xc0,0x52,0x1e,0xfc,0xd2,0x70,0x47,0x03,0xe0,0x0b,0x78,0x03,0x70,0x40,0x1c,0x49,0x1c,0x52,0x1e,
0xf9,0xd2,0x70,0x47,0x03,0xe0,0x0b,0x88,0x03,0x80,0x80,0x1c,0x89,0x1c,0x52,0x1e,0xf9,0xd2,0x70,0x47,0x01,
0xe0,0x08,0xc9,0x08,0xc0,0x52,0x1e,0xfb,0xd2,0x70,0x47,0x10,0xb5,0x07,0xe0,0x03,0x78,0x0c,0x78,0x40,0x1c,
0x49,0x1c,0xa3,0x42,0x01,0xd0,0x00,0x20,0x10,0xbd,0x13,0x46,0x52,0x1e,0xd2,0xb2,0x00,0x2b,0xf2,0xd1,0x01,
0x20,0x10,0xbd,0x20,0x28,0x01,0xd2,0x01,0x20,0x70,0x47,0x80,0x28,0x03,0xd2,0x20,0x38,0x00,0x11,0x80,0x1c,
0x70,0x47,0xe0,0x28,0x03,0xd2,0x80,0x38,0xc0,0x10,0x08,0x30,0x70,0x47,0xe0,0x38,0x80,0x10,0x14,0x30,0x70,
0x47,0x02,0x46,0x00,0x20,0x02,0xe0,0x13,0x78,0x58,0x40,0x52,0x1c,0x49,0x1e,0xfa,0xd2,0x70,0x47,0x30,0xb5,
0x5f,0x4c,0x03,0x9d,0x20,0x60,0x90,0xb2,0x20,0x61,0x10,0x0c,0x60,0x61,0x88,0xb2,0x60,0x60,0x08,0x0c,0xa0,
0x60,0x02,0xe0,0x18,0x78,0xe0,0x60,0x5b,0x1c,0x6d,0x1e,0xfa,0xd2,0x20,0x69,0x61,0x69,0x09,0x04,0x08,0x43,
0x30,0xbd,0x54,0x4a,0x03,0x78,0x93,0x61,0x40,0x1c,0x49,0x1e,0x02,0xd3,0x03,0x78,0xd3,0x61,0xf9,0xe7,0x90,
0x69,0xc0,0xb2,0x70,0x47,0x70,0xb5,0x00,0x26,0x74,0x1e,0x33,0x46,0x35,0x46,0x09,0xe0,0x6a,0x00,0x82,0x5a,
0xa2,0x42,0x00,0xd8,0x14,0x46,0x9a,0x42,0x00,0xd3,0x13,0x46,0x96,0x19,0x6d,0x1c,0x8d,0x42,0xf3,0xd3,0xf0,
0x1a,0x00,0x1b,0x89,0x1e,0x00,0xf0,0x89,0xf8,0x70,0xbd,0x70,0xb5,0x1c,0x00,0x01,0xd4,0x1d,0x46,0x00,0xe0,
0x65,0x42,0x48,0x43,0x11,0x46,0x00,0xf0,0x7e,0xf8,0x00,0x2c,0x05,0xda,0xa8,0x42,0x01,0xd9,0x40,0x1b,0x02,
0xe0,0x00,0x20,0x00,0xe0,0x00,0x19,0x80,0xb2,0x70,0xbd,0xf0,0xb5,0x1d,0x78,0x00,0x24,0x00,0x2d,0x01,0xd1,
0x05,0x68,0x2c,0x80,0x00,0x29,0x11,0x78,0x11,0xd0,0x00,0x29,0x07,0xd0,0x02,0x68,0x1e,0x78,0x11,0x88,0x02,
0x25,0xb5,0x40,0x29,0x43,0x11,0x80,0x14,0xe0,0x06,0x68,0x1f,0x78,0x35,0x88,0x01,0x21,0xb9,0x40,0x0d,0x43,
0x35,0x80,0x01,0xe0,0x00,0x29,0x01,0xd0,0x14,0x70,0x08,0xe0,0x05,0x68,0x1f,0x78,0x29,0x88,0x03,0x26,0xbe,
0x40,0x31,0x43,0x29,0x80,0x01,0x21,0x11,0x70,0x19,0x78,0x89,0x1c,0xc9,0xb2,0x19,0x70,0x10,0x29,0x03,0xd3,
0x1c,0x70,0x01,0x68,0x89,0x1c,0x01,0x60,0xf0,0xbd,0xf7,0xb5,0x82,0xb0,0x0d,0x46,0x84,0x46,0x00,0x20,0x69,
0x46,0x08,0x70,0x08,0x71,0x26,0xe0,0x00,0x21,0x04,0xa8,0xff,0xf7,0xbf,0xff,0x00,0x26,0x34,0x46,0x60,0x46,
0x00,0x78,0x01,0xab,0xe0,0x40,0xc7,0x07,0xff,0x0f,0x6a,0x46,0x39,0x46,0x04,0xa8,0xff,0xf7,0xb2,0xff,0xf0,
0x19,0x64,0x1c,0xe4,0xb2,0xc6,0xb2,0x08,0x2c,0xee,0xd3,0xf1,0x07,0xc9,0x0f,0x01,0xab,0x6a,0x46,0x04,0xa8,
0xff,0xf7,0xa5,0xff,0x01,0xab,0x6a,0x46,0x01,0x21,0x04,0xa8,0xff,0xf7,0x9f,0xff,0x60,0x46,0x40,0x1c,0x84,
0x46,0x28,0x46,0x6d,0x1e,0xad,0xb2,0x00,0x28,0x01,0xab,0x6a,0x46,0xd1,0xd1,0x01,0x21,0x04,0xa8,0xff,0xf7,
0x91,0xff,0x05,0xb0,0xf0,0xbd,0x00,0x20,0x00,0x40,0x30,0xb5,0x0b,0x46,0x01,0x46,0x00,0x20,0x20,0x22,0x01,
0x24,0x09,0xe0,0x0d,0x46,0xd5,0x40,0x9d,0x42,0x05,0xd3,0x1d,0x46,0x95,0x40,0x49,0x1b,0x25,0x46,0x95,0x40,
0x40,0x19,0x15,0x46,0x52,0x1e,0x00,0x2d,0xf1,0xdc,0x30,0xbd,0x70,0xb5,0x00,0x24,0x25,0x46,0x00,0x28,0x01,
0xda,0x01,0x24,0x40,0x42,0x00,0x29,0x01,0xda,0x01,0x25,0x49,0x42,0xff,0xf7,0xdd,0xff,0xac,0x42,0x00,0xd0,
0x40,0x42,0x00,0x2c,0x00,0xd0,0x49,0x42,0x70,0xbd,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25,0x57,
0x05,0x06,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0xd4,0x0c,0x00,0x00,0xd4,0x0c,0x00,0x00,0xe4,0x24,0x00,
0x00,0x65,0x12,0x00,0x00,0x6b,0x35,0x00,0x00,0x37,0x0b,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,
0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,
0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x69,0x0b,0x00,0x00,0x7b,0x0b,0x00,0x00,0x95,0x00,
0x00,0x00,0xbb,0x0b,0x00,0x00,0x95,0x00,0x00,0x00,0x39,0x0c,0x00,0x00,0x5f,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x88,0x13,0xc0,0x5d,0x10,0x27,0x20,0x1c,0xd0,0x07,0xb8,0x0b,0x00,0x00,0x96,0x00,0x2c,0x01,0x23,0x00,0x19,
0x00,0xc4,0x09,0x32,0x00,0x86,0x00,0xdc,0x05,0x00,0x00,0x80,0x1c,0x80,0x1a,0x80,0x18,0x80,0x16,0x80,0x14,
0x80,0x14,0x00,0x00,0x00,0x00,0x80,0x12,0x80,0x0a,0x80,0x0c,0x80,0x11,0x80,0x09,0x80,0x07,0x80,0x0a,0x82,
0x0f,0x84,0x01,0xa3,0x02,0x53,0x02,0xf4,0x01,0xac,0x0d,0x94,0x11,0x50,0x46,0x4c,0x1d,0x00,0x00,0x00,0x00,
0x55,0x00,0x14,0xff,0xdc,0x05,0x4c,0x04,0x4c,0x04,0xb0,0x04,0xdc,0x05,0x40,0x06,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x69,0x49,0x8a,0x89,0x02,0x43,0x8a,0x81,0x49,0x89,0x01,0x42,0x04,0xd0,0x67,0x48,0x01,0x69,0x42,
0x15,0x91,0x43,0x01,0x61,0x70,0x47,0x63,0x49,0x8a,0x89,0x82,0x43,0x8a,0x81,0x88,0x89,0x49,0x89,0x08,0x42,
0x04,0xd1,0x60,0x48,0x01,0x69,0x42,0x15,0x11,0x43,0x01,0x61,0x70,0x47,0x10,0xb5,0x5d,0x48,0x81,0x68,0xc2,
0x68,0x81,0x60,0xc2,0x60,0x00,0x6a,0x80,0x06,0x0e,0xd5,0xff,0x20,0x03,0x30,0x01,0x42,0x0a,0xd0,0x55,0x48,
0x40,0x79,0xc0,0x07,0x02,0xd0,0x01,0x21,0x56,0x48,0x01,0xe0,0x01,0x21,0x55,0x48,0xff,0xf7,0xdb,0xfa,0x10,
0xbd,0x10,0xb5,0x54,0x49,0x88,0x68,0x88,0x60,0x40,0x06,0x01,0xd5,0x01,0xf0,0x30,0xff,0x10,0xbd,0x70,0xb5,
0x50,0x48,0x00,0x24,0x05,0x69,0x41,0x69,0x0d,0x40,0x01,0x6a,0xef,0x22,0x11,0x43,0x01,0x62,0x46,0x48,0x40,
0x79,0x40,0x07,0x0b,0xd5,0x01,0x26,0x30,0x46,0xa0,0x40,0x28,0x42,0x02,0xd0,0x20,0x46,0x01,0xf0,0x45,0xfd,
0x64,0x1c,0x08,0x2c,0xf5,0xdb,0x70,0xbd,0x28,0x07,0xfc,0xd5,0x03,0x20,0x00,0xf0,0xca,0xff,0x70,0xbd,0x10,
0xb5,0x41,0x48,0x81,0x68,0x81,0x60,0x89,0x07,0x37,0xd5,0x3a,0x49,0x40,0x31,0x0a,0x69,0x52,0x08,0x52,0x00,
0x0a,0x61,0x00,0x21,0x01,0x60,0x41,0x60,0x3b,0x48,0x42,0x7b,0xfd,0x21,0x0a,0x40,0x42,0x73,0x3a,0x48,0x02,
0x7c,0x3a,0x4c,0x92,0x07,0x0d,0xd5,0x22,0x68,0x12,0x07,0x0a,0xd5,0x22,0x46,0x80,0x32,0x12,0x8f,0x64,0x2a,
0x03,0xd9,0x02,0x7c,0x0a,0x40,0x02,0x74,0x01,0xe0,0x01,0x21,0x41,0x77,0x20,0x68,0x00,0x05,0x01,0xd5,0x00,
0xf0,0x1b,0xfe,0x20,0x68,0x01,0x21,0x49,0x05,0x88,0x43,0x20,0x60,0x2a,0x48,0x20,0x30,0x01,0x7d,0xbf,0x22,
0x11,0x40,0x01,0x75,0x20,0x68,0x00,0x04,0x03,0xd4,0xe1,0x68,0x60,0x6c,0xff,0xf7,0x73,0xfa,0x10,0xbd,0x23,
0x48,0x10,0xb5,0x20,0x38,0x83,0x68,0xd9,0x06,0x0a,0xd5,0x20,0x49,0x20,0x31,0x4c,0x7c,0x1f,0x4a,0x54,0x77,
0x0c,0x7b,0x54,0x72,0x49,0x7b,0x11,0x73,0x00,0x21,0x41,0x60,0x83,0x60,0x10,0xbd,0x1b,0x49,0x00,0xb5,0x40,
0x39,0x88,0x68,0x4a,0x68,0x10,0x40,0x0f,0x4a,0x52,0x79,0x52,0x07,0x17,0xd5,0x16,0x4a,0x52,0x7c,0x00,0x2a,
0x04,0xd1,0x14,0x4a,0x20,0x3a,0x12,0x7d,0xd2,0x07,0x0e,0xd0,0x0d,0x4a,0x00,0x20,0x10,0x60,0x0f,0x4a,0x10,
0x70,0x08,0x62,0xf0,0x21,0x51,0x77,0x0c,0x49,0x20,0x31,0x48,0x70,0x10,0x20,0xff,0xf7,0x30,0xff,0xfe,0xe7,
0x88,0x60,0x00,0xbd,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x60,0x00,0x40,0x00,0x50,0x00,0x40,0x89,0x0d,0x00,
0x00,0x85,0x33,0x00,0x00,0x00,0x40,0x00,0x40,0x00,0x42,0x00,0x40,0x00,0x44,0x00,0x40,0x20,0x46,0x00,0x40,
0x40,0x48,0x00,0x40,0x9c,0x02,0x00,0x20,0x4b,0x21,0x49,0x01,0x48,0x43,0x10,0xb5,0xfe,0x49,0x38,0x23,0xcb,
0x5e,0xff,0x22,0x00,0x0b,0x49,0x8f,0x01,0x32,0xff,0xf7,0x89,0xfd,0x10,0xbd,0xfa,0x4b,0x72,0xb6,0xe8,0x20,
0x98,0x60,0x00,0x22,0xf9,0x4c,0xf9,0x4d,0xfa,0x4f,0x10,0x46,0x91,0x00,0x0e,0x19,0x30,0x60,0x4e,0x19,0x30,
0x60,0xce,0x19,0x30,0x60,0xa0,0x29,0x04,0xd0,0x90,0x29,0x02,0xd0,0xf4,0x4e,0x89,0x19,0x08,0x60,0x52,0x1c,
0x3f,0x2a,0xee,0xdb,0xf2,0x4a,0x00,0x21,0x8c,0x00,0xa4,0x18,0x60,0x61,0x20,0x63,0x49,0x1c,0x08,0x29,0xf8,
0xdb,0xef,0x49,0x08,0x60,0x98,0x60,0xd8,0x60,0xee,0x48,0x57,0x21,0x41,0x63,0x01,0x22,0x1a,0x60,0x14,0x22,
0x42,0x60,0x01,0x60,0xfe,0xe7,0xe2,0x48,0x81,0x68,0x04,0x22,0x11,0x43,0x81,0x60,0xe9,0x48,0xe7,0x49,0x41,
0x62,0xe8,0x49,0x41,0x60,0xe6,0x49,0xef,0x22,0x40,0x39,0x0a,0x62,0x00,0x22,0x02,0x60,0xff,0x23,0x83,0x62,
0x88,0x23,0x0b,0x60,0x8a,0x60,0xe3,0x4a,0x42,0x63,0x11,0x22,0xc2,0x63,0x01,0x20,0x48,0x60,0x70,0x47,0xf8,
0xb5,0xd3,0x4f,0xd2,0x4e,0x40,0x37,0x78,0x8c,0x3c,0x46,0x81,0x08,0x80,0x34,0xa0,0x7b,0x40,0x00,0x80,0x19,
0x40,0x30,0x81,0x84,0x20,0x46,0x06,0x21,0x5c,0x38,0xff,0xf7,0x12,0xfd,0x25,0x46,0x40,0x3d,0x28,0x81,0x38,
0x8c,0x81,0x08,0xa0,0x7b,0x40,0x00,0x80,0x19,0x40,0x30,0x01,0x86,0x20,0x46,0x06,0x21,0x50,0x38,0xff,0xf7,
0x03,0xfd,0x68,0x81,0xf8,0x8b,0x81,0x08,0xa0,0x7b,0x40,0x00,0x80,0x19,0x40,0x30,0x81,0x87,0x06,0x21,0x28,
0x1f,0xff,0xf7,0xf7,0xfc,0xa8,0x81,0x28,0x89,0xff,0xf7,0x75,0xff,0x28,0x87,0x3c,0x23,0xf3,0x5e,0xf1,0x8f,
0x68,0x89,0x40,0x22,0xff,0xf7,0x03,0xfd,0x68,0x87,0x00,0x23,0xfb,0x5e,0x79,0x88,0xa8,0x89,0x40,0x22,0xff,
0xf7,0xfb,0xfc,0xa8,0x87,0xe0,0x7b,0xa9,0x89,0x40,0x00,0x80,0x19,0x80,0x30,0xc1,0x81,0xe0,0x7b,0x29,0x89,
0x40,0x00,0x80,0x19,0x80,0x30,0x41,0x84,0xe0,0x7b,0x40,0x1c,0xc0,0xb2,0xe0,0x73,0x0a,0x28,0x01,0xd3,0x00,
0x20,0xe0,0x73,0x30,0x68,0x80,0x06,0x01,0xd5,0x00,0xf0,0x96,0xff,0x30,0x68,0x00,0x07,0x43,0xd5,0xa8,0x8f,
0x69,0x8f,0x88,0x42,0x3f,0xd9,0x40,0x1a,0x64,0x21,0xff,0xf7,0x74,0xfd,0x06,0x46,0x28,0x8f,0x0a,0x21,0xff,
0xf7,0x59,0xfd,0x46,0x43,0xaa,0x48,0x01,0x8d,0x7d,0x20,0x00,0x01,0x08,0x18,0xb0,0x42,0x09,0xd2,0x00,0x20,
0x00,0xf0,0xb6,0xff,0x00,0x20,0x00,0xf0,0x5b,0xfb,0x04,0x20,0xff,0xf7,0x40,0xfe,0xfe,0xe7,0x01,0x20,0xb1,
0x42,0x21,0x89,0x22,0x7e,0x15,0xd2,0x90,0x40,0x01,0x43,0x88,0xb2,0x20,0x81,0x00,0x21,0x02,0xe0,0x42,0x1e,
0x10,0x40,0x49,0x1c,0x00,0x28,0xfa,0xd1,0x08,0x29,0x0b,0xd9,0x00,0xf0,0x9b,0xff,0x00,0x20,0x00,0xf0,0x40,
0xfb,0x04,0x20,0xff,0xf7,0x25,0xfe,0xfe,0xe7,0x90,0x40,0x81,0x43,0x21,0x81,0x20,0x7e,0x0f,0x28,0x01,0xd2,
0x40,0x1c,0x00,0xe0,0x00,0x20,0x20,0x76,0x02,0x21,0x90,0x48,0xff,0xf7,0x24,0xf9,0xa0,0x7b,0x05,0x28,0x01,
0xd2,0x40,0x1c,0x00,0xe0,0x00,0x20,0xa0,0x73,0xf8,0xbd,0xf8,0xb5,0x81,0x48,0x00,0x6a,0x01,0x21,0x08,0x43,
0x7f,0x49,0x08,0x62,0x48,0x6a,0x0a,0x21,0xc0,0x06,0xc0,0x0e,0x7c,0x4a,0x08,0x43,0x50,0x62,0x7a,0x48,0x20,
0x30,0x00,0x7d,0x01,0x22,0x10,0x43,0x78,0x4a,0x20,0x32,0x10,0x75,0x76,0x4a,0x50,0x20,0x90,0x62,0x90,0x6b,
0x40,0x22,0x74,0x4b,0x10,0x43,0x98,0x63,0x71,0x48,0x7c,0x4b,0x43,0x62,0x70,0x4c,0x3f,0x23,0x40,0x34,0x23,
0x73,0x61,0x73,0xf0,0x23,0x63,0x74,0x81,0x21,0x21,0x75,0x58,0x21,0x61,0x75,0x6a,0x49,0x20,0x31,0x4b,0x77,
0x19,0x23,0x0b,0x70,0x0b,0x7e,0x80,0x25,0x2b,0x43,0x0b,0x76,0x67,0x49,0xca,0x63,0x49,0x6a,0x03,0x22,0x12,
0x02,0x11,0x43,0x64,0x4a,0x51,0x62,0x63,0x49,0x0f,0x27,0x20,0x31,0x4f,0x75,0xff,0x21,0x91,0x60,0x00,0x22,
0xd2,0x43,0x82,0x60,0x10,0x22,0x42,0x60,0x01,0x22,0x02,0x60,0x59,0x4e,0x51,0x20,0x20,0x36,0x70,0x73,0xf8,
0x20,0x30,0x74,0x56,0x4d,0x2a,0x60,0x28,0x6a,0x90,0x43,0x28,0x62,0xa9,0x60,0x51,0x48,0x61,0x49,0x80,0x30,
0xc0,0x8f,0x40,0x18,0x19,0x21,0xff,0xf7,0xce,0xfc,0x68,0x62,0x37,0x76,0x03,0x20,0x51,0x49,0x80,0x02,0x80,
0x31,0x08,0x63,0x50,0x48,0x02,0x25,0x05,0x63,0x45,0x63,0x85,0x63,0x4d,0x49,0x01,0x22,0x40,0x31,0x8a,0x60,
0xca,0x60,0x04,0x21,0x81,0x62,0xc5,0x61,0x00,0x21,0x01,0x62,0x01,0x69,0x42,0x15,0x11,0x43,0x01,0x61,0x01,
0x69,0x82,0x15,0x91,0x43,0x01,0x61,0x01,0x69,0x02,0x15,0x91,0x43,0x01,0x61,0x00,0xf0,0x0d,0xfb,0x48,0x48,
0x4c,0x49,0xc0,0x8c,0x40,0x18,0x4b,0x49,0xff,0xf7,0xa3,0xfc,0x3a,0x49,0x40,0x31,0x08,0x76,0x1f,0x20,0x48,
0x76,0x0f,0x77,0x03,0x20,0x48,0x77,0x08,0x7c,0x28,0x43,0x08,0x74,0x34,0x49,0x17,0x20,0x60,0x31,0x08,0x70,
0x60,0x7e,0x08,0x21,0x08,0x43,0x60,0x76,0x3b,0x48,0x19,0x21,0x80,0x8c,0xff,0x38,0x91,0x38,0xff,0xf7,0x89,
0xfc,0x40,0x1e,0x30,0x73,0x00,0xf0,0x4c,0xf9,0x3d,0x49,0x3b,0x48,0x08,0x60,0x3c,0x49,0x08,0x60,0xf8,0xbd,
0x70,0x47,0x29,0x49,0x10,0x20,0x48,0x60,0x28,0x48,0x40,0x30,0x01,0x7d,0x80,0x22,0x11,0x43,0x01,0x75,0x70,
0x47,0x10,0xb5,0x2d,0x48,0xc1,0x8b,0x42,0x8f,0x91,0x42,0x0e,0xd0,0x1d,0x4b,0x1b,0x68,0x9b,0x02,0x01,0xd5,
0x05,0x21,0x05,0xe0,0x91,0x42,0x41,0x87,0x06,0xd9,0x00,0xf0,0x56,0xfe,0x32,0x21,0x2d,0x48,0xff,0xf7,0x4f,
0xf8,0x10,0xbd,0x15,0x48,0x03,0x21,0xc0,0x30,0x01,0x75,0x10,0xbd,0xf8,0xb5,0x18,0x48,0xc0,0x68,0x11,0x4c,
0x00,0x04,0x00,0x27,0xc0,0x34,0x00,0x28,0x08,0xda,0xa0,0x7c,0x40,0x1c,0xc0,0xb2,0xa0,0x74,0x14,0x28,0x03,
0xd9,0xa7,0x74,0xff,0xf7,0x21,0xfe,0xa7,0x74,0x00,0xf0,0xcb,0xf9,0x0a,0x48,0x20,0x30,0x41,0x7c,0x0a,0x07,
0x12,0x0f,0xef,0x21,0x01,0x2a,0x3e,0xd8,0xa2,0x88,0xff,0x23,0xf5,0x33,0x9a,0x42,0x35,0xd2,0x52,0x1c,0xa2,
0x80,0x01,0x7a,0x10,0x22,0x2d,0xe0,0x9c,0x02,0x00,0x20,0x00,0x5a,0x00,0x40,0x00,0x48,0x00,0x40,0x00,0x4a,
0x00,0x40,0x00,0x46,0x00,0x40,0x00,0x5c,0x00,0x40,0x00,0x60,0x00,0x40,0x00,0x52,0x00,0x40,0x00,0x58,0x00,
0x40,0x25,0x57,0x00,0x00,0x40,0x42,0x00,0x40,0x10,0x17,0x00,0x00,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x20,
0x37,0x13,0x00,0x00,0x06,0x06,0x00,0x00,0x48,0xf4,0xff,0xff,0x70,0xcc,0xff,0xff,0x26,0x02,0x00,0x00,0x01,
0xa0,0x02,0x00,0x80,0xe2,0x00,0xe0,0x00,0xe1,0x00,0xe0,0x55,0x10,0x00,0x00,0x11,0x43,0x01,0x72,0x0c,0xe0,
0x02,0x7a,0x0a,0x40,0x02,0x72,0x08,0xe0,0x42,0x7c,0x12,0x07,0x12,0x0f,0x07,0x2a,0x03,0xd3,0x02,0x7a,0x0a,
0x40,0x02,0x72,0xa7,0x80,0xcf,0x48,0x00,0x7d,0xc1,0x07,0x02,0x20,0x00,0x29,0xe1,0x88,0x01,0xd0,0x49,0x1c,
0x04,0xe0,0x02,0x29,0x00,0xd2,0xe0,0x80,0xe1,0x88,0x49,0x1e,0xc9,0x4d,0xe1,0x80,0xe9,0x88,0xc9,0x4e,0xc9,
0x05,0x09,0xd5,0xe8,0x8c,0xc8,0x49,0x40,0x18,0xc8,0x49,0xff,0xf7,0xda,0xfb,0xc2,0x49,0x20,0x31,0x08,0x76,
0x43,0xe0,0xe9,0x88,0x89,0x05,0x09,0xd5,0xa8,0x8c,0x19,0x21,0xff,0x38,0x91,0x38,0xff,0xf7,0xcd,0xfb,0xbc,
0x49,0x40,0x1e,0x08,0x73,0x36,0xe0,0xe9,0x88,0x4a,0x05,0x01,0x21,0x00,0x2a,0x03,0xda,0x21,0x75,0x96,0x21,
0xbb,0x48,0x24,0xe0,0xea,0x88,0x92,0x06,0x03,0xd5,0xe8,0x89,0xff,0xf7,0xa9,0xfc,0x26,0xe0,0xea,0x88,0x52,
0x06,0x07,0xd5,0x2a,0x89,0xb6,0x4b,0x9a,0x42,0x03,0xd1,0x2f,0x81,0xb5,0x49,0xb5,0x48,0x12,0xe0,0xea,0x88,
0xd2,0x07,0x03,0xd0,0x30,0x68,0x08,0x43,0x30,0x60,0x14,0xe0,0xe9,0x88,0x89,0x07,0x03,0xd5,0x31,0x68,0x01,
0x43,0x31,0x60,0x0d,0xe0,0xe8,0x88,0x40,0x07,0x04,0xd5,0x05,0x21,0xac,0x48,0xfe,0xf7,0x89,0xff,0x05,0xe0,
0xe8,0x88,0x00,0x07,0x02,0xd5,0x00,0x20,0x00,0xf0,0xe4,0xfd,0x30,0x68,0xc0,0x05,0x07,0xd5,0xa7,0x48,0x00,
0x68,0xb1,0x68,0x40,0x1a,0x0f,0x28,0x01,0xd9,0x00,0xf0,0xf9,0xfa,0xe8,0x88,0x40,0x21,0x08,0x40,0xe8,0x80,
0xf8,0xbd,0x98,0x49,0x10,0xb5,0xc0,0x31,0xcb,0x88,0x01,0x22,0x96,0x48,0xd2,0x04,0x64,0x2b,0x03,0x68,0x01,
0xd9,0x13,0x43,0x00,0xe0,0x93,0x43,0x03,0x60,0x00,0x20,0xc8,0x80,0x7d,0x21,0xc9,0x00,0x98,0x48,0xfe,0xf7,
0x5d,0xff,0x10,0xbd,0x10,0xb5,0x97,0x49,0x10,0x20,0x08,0x61,0x96,0x49,0x01,0x20,0xc8,0x60,0x95,0x48,0x40,
0x38,0xc0,0x68,0x00,0x04,0x01,0xd5,0xff,0xf7,0x38,0xfd,0x85,0x4c,0x60,0x79,0x40,0x06,0x09,0xd5,0x00,0xf0,
0x91,0xf8,0x00,0xf0,0x53,0xf8,0x82,0x49,0x8e,0x48,0x48,0x64,0x01,0xf0,0x1a,0xf8,0x0c,0xe0,0x00,0xf0,0x95,
0xf8,0xff,0xf7,0x20,0xfe,0x60,0x79,0xc0,0x06,0x01,0xd5,0x2a,0x21,0x00,0xe0,0x05,0x21,0x87,0x48,0xfe,0xf7,
0x33,0xff,0x7e,0x49,0x86,0x48,0xfe,0xf7,0x2f,0xff,0x7d,0x21,0xc9,0x00,0x7f,0x48,0xfe,0xf7,0x2a,0xff,0x10,
0xbd,0x30,0xb5,0x82,0x48,0x81,0x68,0x08,0x23,0x19,0x43,0x81,0x60,0x81,0x48,0x00,0x22,0x02,0x60,0x79,0x49,
0x0c,0x6a,0x45,0x15,0x2c,0x43,0x0c,0x62,0xff,0x24,0x7c,0x49,0x05,0x34,0x40,0x31,0x4c,0x61,0x7b,0x4c,0x0c,
0x60,0x42,0x60,0x07,0x24,0x84,0x60,0x02,0x61,0x10,0x22,0x42,0x61,0x0f,0x22,0x82,0x61,0x4c,0x60,0x43,0x22,
0x8a,0x60,0x76,0x49,0x0a,0x68,0x1a,0x43,0x0a,0x60,0x75,0x49,0x0a,0x68,0x01,0x23,0x1a,0x43,0x0a,0x60,0x2f,
0x22,0x0a,0x62,0x6e,0x4a,0x0c,0x32,0x8a,0x62,0x5d,0x4a,0x5e,0x32,0xca,0x62,0x02,0x22,0x4a,0x62,0xb3,0x21,
0x01,0x60,0x30,0xbd,0x69,0x48,0x01,0x68,0x80,0x22,0x11,0x43,0x01,0x60,0x70,0x47,0x70,0xb5,0x55,0x4c,0x00,
0x23,0x40,0x34,0xe0,0x8b,0x25,0x46,0x80,0x08,0x40,0x35,0xa8,0x81,0xe3,0x5e,0x61,0x88,0x40,0x22,0xff,0xf7,
0x51,0xfa,0xa8,0x87,0x62,0x49,0x02,0x02,0x89,0x88,0x10,0x1a,0xff,0xf7,0xd2,0xfa,0xff,0x28,0x00,0xd9,0xff,
0x20,0x49,0x4d,0x60,0x35,0x28,0x70,0x01,0x20,0xc0,0x03,0xff,0xf7,0xc0,0xfb,0x01,0x20,0x20,0x72,0x28,0x78,
0x60,0x72,0x02,0x20,0x00,0xf0,0x55,0xf9,0x4d,0x48,0x60,0x38,0x41,0x7d,0x4b,0x48,0x40,0x38,0x40,0x69,0x49,
0x1c,0xff,0xf7,0xb8,0xfa,0x3d,0x49,0x08,0x82,0x48,0x82,0x3d,0x49,0x51,0x48,0x48,0x64,0x70,0xbd,0x4f,0x49,
0x10,0xb5,0x05,0x22,0x80,0x39,0x38,0x48,0xff,0xf7,0xa3,0xf9,0x4b,0x49,0x12,0x22,0x60,0x39,0x4c,0x48,0xff,
0xf7,0xad,0xf9,0x10,0xbd,0x70,0xb5,0x04,0x22,0x00,0x21,0x49,0x48,0xff,0xf7,0x91,0xf9,0xff,0xf7,0xea,0xff,
0x44,0x4d,0x2f,0x48,0x29,0x88,0x80,0x30,0x2d,0x4c,0xc1,0x87,0xe1,0x83,0x61,0x87,0x68,0x88,0xe0,0x84,0x28,
0x89,0xa0,0x84,0x29,0x46,0x20,0x46,0x09,0x22,0x0a,0x31,0x28,0x30,0xff,0xf7,0x89,0xf9,0xa8,0x8b,0xe0,0x82,
0xf0,0x21,0x20,0x46,0x60,0x30,0x41,0x70,0x3b,0x48,0x60,0x81,0x29,0x46,0x20,0x46,0x10,0x22,0x20,0x31,0x68,
0x30,0xff,0xf7,0x72,0xf9,0x29,0x46,0x20,0x46,0x10,0x22,0x30,0x31,0x78,0x30,0xff,0xf7,0x6b,0xf9,0x68,0x8b,
0x20,0x87,0x1a,0x49,0x08,0x20,0xc8,0x60,0x19,0x48,0x0f,0x21,0xc0,0x30,0x41,0x74,0x06,0x22,0x2f,0x49,0x88,
0x38,0xff,0xf7,0x65,0xf9,0x70,0xbd,0x70,0xb5,0x1d,0x4b,0x80,0x3b,0x98,0x68,0x11,0x49,0x06,0x07,0x11,0x48,
0x08,0x25,0x4a,0x79,0x00,0x24,0xc0,0x30,0x00,0x2e,0x0d,0xda,0x9e,0x68,0x2e,0x43,0x9e,0x60,0xc4,0x75,0x83,
0x7d,0x5d,0x1c,0x85,0x75,0x0a,0x2b,0x03,0xd9,0xf7,0x23,0x1a,0x40,0x4a,0x71,0x84,0x75,0x70,0xbd,0x84,0x75,
0xc3,0x7d,0x5e,0x1c,0xc6,0x75,0x0a,0x2b,0xf8,0xd9,0x2a,0x43,0x4a,0x71,0xc4,0x75,0x70,0xbd,0x20,0x48,0x00,
0x40,0x00,0x00,0x00,0x20,0x9c,0x02,0x00,0x20,0x70,0xcc,0xff,0xff,0x26,0x02,0x00,0x00,0x55,0x10,0x00,0x00,
0x25,0x57,0x00,0x00,0xff,0xff,0xff,0x7f,0x97,0x01,0x00,0x00,0x59,0x1f,0x00,0x00,0x00,0x01,0x00,0x20,0x39,
0x12,0x00,0x00,0x80,0x5c,0x00,0x40,0x40,0x60,0x00,0x40,0xcf,0x22,0x00,0x00,0x43,0x13,0x00,0x00,0x8b,0x10,
0x00,0x00,0x00,0x5a,0x00,0x40,0x00,0x4a,0x00,0x40,0x07,0x30,0x00,0x00,0x00,0x52,0x00,0x40,0x00,0x50,0x00,
0x40,0x80,0x06,0x00,0x20,0xad,0x23,0x00,0x00,0x54,0x02,0x00,0x20,0x00,0x05,0x00,0x20,0xfe,0x8d,0x00,0x00,
0x24,0x3f,0x00,0x00,0xa4,0x4a,0x01,0x46,0x52,0x78,0x00,0x20,0x00,0x2a,0x07,0xd0,0x50,0x2a,0x03,0xd0,0xa0,
0x2a,0x02,0xd0,0xf0,0x2a,0x00,0xd1,0x07,0x20,0x70,0x47,0x9e,0x48,0x80,0x89,0x08,0x1a,0x64,0x30,0x40,0x09,
0x07,0x28,0xf6,0xd8,0x70,0x47,0xf1,0xb5,0x9a,0x4e,0x7d,0x27,0x40,0x3e,0xb1,0x8f,0x00,0x20,0xbf,0x01,0xb9,
0x42,0x05,0xd3,0x97,0x48,0x81,0x42,0x01,0xd2,0x64,0x20,0x00,0xe0,0x78,0x20,0x02,0x46,0x96,0x32,0x92,0x49,
0xff,0x30,0x4a,0x81,0x2d,0x30,0x92,0x4d,0x88,0x81,0x69,0x7f,0x68,0x46,0x00,0xf0,0xbc,0xf8,0x68,0x77,0x8b,
0x4b,0x58,0x70,0x00,0x98,0xff,0xf7,0xc9,0xff,0x28,0x77,0x88,0x48,0x5c,0x78,0x60,0x38,0x00,0x2c,0x08,0xd0,
0x50,0x2c,0x01,0xd0,0xa0,0x2c,0x0e,0xd1,0x00,0x8a,0x81,0x00,0x40,0x18,0x80,0x09,0x05,0xe0,0x00,0x8a,0x81,
0x00,0x40,0x18,0x30,0x21,0xff,0xf7,0xba,0xf9,0x00,0x28,0x01,0xd0,0x40,0x1e,0x00,0xe0,0x00,0x20,0x28,0x73,
0xb0,0x8f,0xb8,0x42,0x07,0xd2,0xf0,0x2c,0x0c,0xd0,0x50,0x2c,0x01,0xd0,0x05,0x20,0x17,0xe0,0x08,0x20,0x15,
0xe0,0x78,0x49,0x88,0x42,0x09,0xd2,0xf0,0x2c,0x03,0xd0,0x50,0x2c,0x03,0xd0,0x0f,0x20,0x0c,0xe0,0x1f,0x20,
0x0a,0xe0,0x17,0x20,0x08,0xe0,0xf0,0x2c,0x0c,0xd0,0x72,0x48,0x40,0x7c,0x00,0x07,0x08,0xd0,0x50,0x2c,0x08,
0xd0,0x19,0x20,0x68,0x72,0x00,0x2c,0x06,0xd0,0x44,0x20,0x68,0x70,0xf8,0xbd,0xbf,0x20,0xf7,0xe7,0x2c,0x20,
0xf5,0xe7,0x88,0x20,0xf7,0xe7,0x6a,0x49,0x5f,0x20,0x08,0x70,0x6a,0x48,0x69,0x49,0x81,0x61,0x40,0x21,0xc1,
0x61,0x69,0x48,0x01,0x68,0x08,0x22,0x11,0x43,0x01,0x60,0x67,0x48,0x01,0x68,0x01,0x22,0x11,0x43,0x01,0x60,
0x5d,0x49,0x64,0x48,0x78,0x39,0x40,0x30,0xc1,0x61,0x60,0x49,0x0c,0x31,0x81,0x61,0x70,0x47,0xf8,0xb5,0x58,
0x4e,0x07,0x46,0xc0,0x3e,0x30,0x68,0x01,0x21,0x49,0x05,0x08,0x43,0x30,0x60,0x56,0x4c,0x20,0x34,0x20,0x7d,
0x40,0x21,0x08,0x43,0x20,0x75,0x30,0x68,0x35,0x46,0x80,0x05,0x80,0x35,0x00,0x28,0x02,0xda,0x28,0x8f,0xff,
0xf7,0x64,0xff,0x4c,0x48,0x39,0x46,0x78,0x38,0xff,0xf7,0x83,0xf8,0xf1,0x19,0x40,0x31,0x08,0x72,0x47,0x48,
0xaa,0x8f,0x50,0x4b,0x4b,0x49,0x40,0x78,0x9a,0x42,0x05,0xd9,0x00,0x28,0x01,0xd0,0x0a,0x20,0x04,0xe0,0x5f,
0x20,0x02,0xe0,0x00,0x28,0xf9,0xd0,0x0f,0x20,0x08,0x70,0x42,0x48,0x42,0x7b,0x02,0x21,0x0a,0x43,0x42,0x73,
0x28,0x8f,0x64,0x28,0x06,0xd2,0x3f,0x48,0x03,0x22,0x20,0x30,0x42,0x77,0x02,0x7c,0x0a,0x43,0x02,0x74,0x40,
0x48,0x40,0x30,0x47,0x61,0x01,0x21,0x01,0x61,0x3c,0x48,0x2d,0x21,0x01,0x60,0x3e,0x49,0x41,0x60,0x37,0x49,
0x0f,0x20,0x40,0x39,0x48,0x75,0x20,0x7d,0x80,0x21,0x08,0x43,0x20,0x75,0xf8,0xbd,0x70,0xb5,0x31,0x4b,0x02,
0x46,0x00,0x68,0x5c,0x7c,0x24,0x07,0x24,0x0f,0x08,0x2c,0x03,0xd3,0x00,0x21,0x7d,0x20,0xc0,0x00,0x16,0xe0,
0x5b,0x7c,0x1b,0x07,0x11,0xd0,0x27,0x4b,0x5d,0x89,0x9c,0x89,0x2a,0x46,0x26,0x46,0x64,0x3a,0x64,0x3c,0x00,
0x29,0x20,0xd0,0x9b,0x89,0x64,0x33,0x50,0x29,0x0d,0xd0,0xa0,0x29,0x14,0xd0,0xf0,0x29,0x1f,0xd1,0x03,0xe0,
0xf0,0x21,0x00,0x20,0x10,0x60,0x1a,0xe0,0x83,0x42,0x0f,0xd3,0x85,0x42,0x15,0xd3,0x15,0xe0,0x83,0x42,0x0a,
0xd3,0x86,0x42,0x01,0xd2,0xa0,0x21,0x0f,0xe0,0x82,0x42,0x08,0xd8,0x0c,0xe0,0x82,0x42,0x05,0xd8,0x84,0x42,
0x07,0xd8,0x00,0x21,0x06,0xe0,0x82,0x42,0x01,0xd9,0xf0,0x21,0x02,0xe0,0x84,0x42,0x00,0xd9,0x50,0x21,0x10,
0x48,0x42,0x7f,0x8a,0x42,0x15,0xd0,0xf0,0x29,0x04,0xd0,0x50,0x29,0x02,0xd0,0x00,0x29,0x04,0xd0,0x09,0xe0,
0x02,0x78,0xfd,0x23,0x1a,0x40,0x08,0xe0,0x09,0x4a,0x20,0x32,0x13,0x7d,0x5b,0x06,0x5b,0x0e,0x13,0x75,0x02,
0x78,0x02,0x23,0x1a,0x43,0x02,0x70,0x41,0x77,0x08,0x46,0x70,0xbd,0x60,0x00,0x00,0x20,0x5c,0x03,0x00,0x20,
0xb0,0x36,0x00,0x00,0x20,0x46,0x00,0x40,0x20,0x48,0x00,0x40,0x60,0x5c,0x00,0x40,0x1f,0x03,0x00,0x00,0x00,
0x44,0x00,0x40,0x00,0x52,0x00,0x40,0x00,0x50,0x00,0x40,0x10,0x27,0x00,0x00,0x01,0x0b,0x00,0x00,0x10,0xb5,
0xf8,0x48,0x00,0x22,0x42,0x61,0xf6,0x49,0xf7,0x48,0x40,0x31,0x48,0x60,0xf6,0x4c,0x20,0x68,0x00,0x04,0x19,
0xd5,0x20,0x68,0xc9,0x13,0x88,0x43,0x20,0x60,0xf3,0x48,0x83,0x7a,0x59,0x1c,0x81,0x72,0x03,0x2b,0x0b,0xd3,
0x82,0x72,0xe2,0x60,0x01,0x7a,0x07,0x29,0x04,0xd2,0xef,0x4a,0x62,0x64,0x49,0x1c,0x01,0x72,0x01,0xe0,0xed,
0x48,0x60,0x64,0xe1,0x68,0x60,0x6c,0xfe,0xf7,0x84,0xfc,0x20,0x68,0xff,0x21,0x01,0x31,0x88,0x43,0x20,0x60,
0x10,0xbd,0x10,0xb5,0xe4,0x4c,0x20,0x68,0x40,0x07,0x06,0xd5,0x20,0x68,0x04,0x21,0x88,0x43,0x20,0x60,0x08,
0x02,0xff,0xf7,0x64,0xf9,0x20,0x68,0x00,0x04,0x01,0xd5,0x00,0x20,0xe0,0x60,0xff,0xf7,0xc1,0xff,0x10,0xbd,
0xd9,0x48,0xd8,0x49,0x10,0xb5,0x08,0x30,0x40,0x31,0x48,0x60,0x01,0x21,0xdb,0x48,0xfe,0xf7,0x60,0xfc,0x10,
0xbd,0xf8,0xb5,0xd4,0x4c,0xd4,0x4d,0x20,0x34,0x07,0x46,0x62,0x7a,0x2e,0x46,0x00,0x23,0x2c,0x36,0xa0,0x7a,
0x21,0x7b,0x00,0x2a,0x09,0xd0,0x09,0x2a,0x17,0xd0,0x0a,0x2a,0x75,0xd3,0x00,0x2f,0x07,0xd0,0x63,0x72,0x00,
0x28,0x62,0xd0,0x6b,0xe0,0x00,0x2f,0x03,0xd0,0x00,0x28,0x05,0xd0,0x02,0x20,0xf8,0xbd,0x01,0x21,0x61,0x72,
0x83,0x55,0x7e,0xe0,0x80,0x20,0x01,0x43,0x21,0x73,0x02,0x20,0x60,0x72,0x78,0xe0,0x0a,0x22,0x62,0x72,0x2a,
0x68,0x52,0x04,0x32,0xd4,0x6a,0x6c,0xc1,0x4b,0x9a,0x42,0x2e,0xd1,0x01,0x28,0x2c,0xd1,0x01,0x29,0x01,0xd0,
0x02,0x29,0x28,0xd1,0x02,0x22,0x31,0x46,0xbe,0x48,0xfe,0xf7,0x17,0xff,0xbc,0x49,0xb7,0x48,0x16,0x39,0x8a,
0x7d,0xc0,0x30,0x01,0x2a,0x02,0xd0,0x02,0x2a,0x1a,0xd1,0x06,0xe0,0x03,0x22,0x42,0x76,0xb6,0x48,0xc9,0x7d,
0x0a,0x30,0x81,0x70,0x12,0xe0,0x2a,0x68,0x92,0x05,0x01,0xd5,0x02,0x22,0x42,0x76,0xc8,0x7d,0x00,0x28,0x0a,
0xd0,0x28,0x68,0x80,0x04,0x07,0xd4,0x28,0x68,0x01,0x21,0x49,0x03,0x08,0x43,0x28,0x60,0x48,0x11,0xff,0xf7,
0xf2,0xf8,0xa0,0x7a,0x00,0x21,0x80,0x19,0xfe,0xf7,0x49,0xff,0x00,0x28,0x04,0xd0,0x00,0x20,0xb8,0x42,0x03,
0xd1,0x04,0x20,0xf8,0xbd,0x01,0x20,0xf9,0xe7,0xa0,0x7a,0xe1,0x7a,0x88,0x42,0x2e,0xd9,0x30,0x46,0x89,0x1c,
0xfe,0xf7,0x18,0xff,0x00,0x28,0xf2,0xd0,0x06,0x20,0xf8,0xbd,0x08,0x46,0xfe,0xf7,0xfd,0xfe,0xc0,0xb2,0xe0,
0x72,0x0a,0x28,0x02,0xd3,0x05,0x20,0xf8,0xbd,0x03,0xe0,0xa0,0x7a,0x40,0x1c,0xa0,0x72,0x18,0xe0,0x81,0x5d,
0xfa,0x01,0x49,0x08,0x11,0x43,0x81,0x55,0x60,0x7a,0x40,0x1c,0xc0,0xb2,0x60,0x72,0xa1,0x7a,0x00,0x29,0x0c,
0xd1,0x07,0x28,0x0a,0xd3,0x20,0x7b,0xff,0x28,0x0c,0xd0,0xfe,0x28,0x0a,0xd0,0x00,0x28,0x0c,0xd0,0x55,0x28,
0x0e,0xd0,0xaa,0x28,0x0c,0xd0,0x8b,0x48,0x00,0x68,0xa8,0x60,0x01,0x20,0xdb,0xe7,0x28,0x68,0x01,0x21,0x09,
0x04,0x06,0xe0,0x28,0x68,0x01,0x21,0x49,0x04,0x02,0xe0,0x28,0x68,0x01,0x21,0x89,0x04,0x08,0x43,0x28,0x60,
0x00,0x20,0xcc,0xe7,0x70,0xb5,0x7a,0x4d,0x28,0x68,0x7a,0x4c,0xc2,0x03,0x7b,0x49,0x00,0x26,0x20,0x7a,0x00,
0x2a,0x39,0xda,0x2a,0x68,0x01,0x23,0x1b,0x04,0x9a,0x43,0x2a,0x60,0x00,0x28,0x0b,0xd0,0x2a,0x46,0xc0,0x32,
0x07,0x28,0x0a,0xd0,0x08,0x28,0x1f,0xd0,0x04,0x28,0x5d,0xd3,0xe0,0x7a,0x40,0x1c,0xe0,0x72,0x59,0xe0,0x6e,
0x48,0x68,0x64,0x56,0xe0,0x01,0x20,0x60,0x72,0x08,0x20,0x50,0x74,0x28,0x68,0x01,0x22,0x92,0x03,0x10,0x43,
0x28,0x60,0x6b,0x48,0x56,0x38,0xc2,0x88,0x01,0x23,0x9b,0x02,0x1a,0x43,0xc2,0x80,0x6a,0x4a,0xc2,0x83,0x69,
0x64,0x58,0x10,0xff,0xf7,0x67,0xf8,0x3f,0xe0,0x60,0x7a,0x01,0x28,0x02,0xd0,0x02,0x28,0x03,0xd0,0x39,0xe0,
0x02,0x20,0x60,0x72,0x36,0xe0,0x0f,0x20,0x50,0x74,0x66,0x72,0x32,0xe0,0x2b,0x68,0x01,0x22,0x52,0x04,0x93,
0x42,0x0e,0xd1,0x2b,0x68,0x93,0x43,0x2b,0x60,0x00,0x28,0x13,0xd0,0x07,0x28,0x02,0xd0,0x01,0x28,0x04,0xd0,
0x23,0xe0,0xe6,0x72,0x03,0x20,0x20,0x72,0x1f,0xe0,0xfe,0xe7,0x00,0x28,0x07,0xd0,0x4e,0x4a,0x20,0x32,0x11,
0x7b,0x02,0x28,0x04,0xd0,0x03,0x28,0x0c,0xd0,0x14,0xe0,0x69,0x64,0x12,0xe0,0x30,0x29,0x10,0xd1,0x4d,0x48,
0x51,0x7b,0x2a,0x30,0x81,0x74,0xe9,0x8d,0x49,0xba,0x01,0x82,0x08,0xe0,0x31,0x29,0x06,0xd1,0x43,0x49,0x47,
0x48,0x03,0x22,0x2d,0x31,0x3d,0x30,0xfe,0xf7,0x27,0xfe,0x0c,0x20,0xe8,0x60,0xa6,0x72,0x20,0x7a,0x08,0x28,
0x01,0xd2,0x40,0x1c,0x20,0x72,0xff,0xf7,0x80,0xfe,0x70,0xbd,0x70,0xb5,0xff,0xf7,0xc7,0xfe,0x00,0x28,0x04,
0xd0,0x01,0x28,0x01,0xd0,0xff,0xf7,0xa2,0xfe,0x70,0xbd,0x35,0x49,0x08,0x68,0x0c,0x46,0x25,0x46,0x00,0x04,
0x2c,0x35,0x37,0x4e,0x20,0x34,0x00,0x28,0x10,0xda,0x20,0x7b,0x1a,0x28,0x0a,0xd1,0xc3,0x20,0x60,0x73,0xe2,
0x7a,0x29,0x46,0x30,0x46,0x52,0x1c,0xfe,0xf7,0xfd,0xfd,0x02,0x20,0xfe,0xf7,0xf9,0xff,0xff,0xf7,0x5a,0xff,
0x70,0xbd,0x08,0x68,0x40,0x07,0x07,0xd5,0x08,0x68,0x04,0x22,0x90,0x43,0x08,0x60,0x50,0x02,0xfe,0xf7,0xec,
0xff,0x01,0xe0,0x08,0x20,0xc8,0x60,0x20,0x7b,0x1e,0x28,0x02,0xd0,0x10,0x20,0xfe,0xf7,0xe3,0xff,0xe2,0x7a,
0x29,0x46,0x30,0x46,0x52,0x1c,0xfe,0xf7,0xde,0xfd,0xff,0xf7,0x3f,0xfe,0x70,0xbd,0x70,0xb5,0x19,0x4c,0x16,
0x49,0x20,0x34,0xa2,0x79,0x80,0x00,0x80,0x31,0xe2,0x71,0x40,0x18,0x00,0x68,0x01,0x23,0xc1,0xb2,0xa1,0x71,
0x25,0x79,0x12,0x48,0x00,0x2d,0x03,0xd0,0x91,0x42,0x07,0xd9,0x8a,0x1a,0x08,0xe0,0x23,0x71,0xe1,0x71,0x14,
0x49,0x09,0x68,0x81,0x60,0x70,0xbd,0x8a,0x1a,0xff,0x32,0x01,0x32,0x01,0x6a,0x06,0x69,0x51,0x43,0x09,0x4a,
0x00,0x25,0x52,0x69,0x8e,0x42,0x1d,0xd8,0x8a,0x42,0x1b,0xd9,0x60,0x79,0x00,0x28,0x01,0xd0,0x01,0x20,0x1c,
0xe0,0x63,0x71,0x70,0xbd,0x00,0x00,0x00,0x42,0x00,0x40,0x08,0x17,0x00,0x00,0x9c,0x02,0x00,0x20,0xfc,0x04,
0x00,0x20,0x01,0x22,0x00,0x00,0xcf,0x22,0x00,0x00,0xe9,0x1b,0x00,0x00,0x56,0x00,0x00,0x20,0x00,0x01,0x00,
0x20,0x28,0x23,0x00,0x00,0x8a,0x42,0xe7,0xd8,0x80,0x69,0x88,0x42,0xe4,0xd9,0x00,0x20,0xff,0xf7,0x73,0xff,
0x65,0x71,0xdf,0xe7,0x10,0xb5,0x17,0x4c,0x20,0x68,0xc0,0x05,0x28,0xd4,0x20,0x68,0xff,0x21,0x01,0x31,0x08,
0x43,0x20,0x60,0x20,0x46,0x28,0x22,0x00,0x21,0x10,0x30,0xfe,0xf7,0x72,0xfd,0x10,0x48,0x00,0x68,0x19,0x21,
0x40,0x1c,0x48,0x43,0x0f,0x49,0x40,0x09,0x21,0x62,0xe0,0x61,0x81,0x01,0x21,0x61,0xff,0x21,0x81,0x31,0x41,
0x43,0x61,0x61,0x03,0x21,0x09,0x02,0x48,0x43,0xa0,0x61,0x09,0x48,0x00,0x68,0xa0,0x60,0x05,0x48,0xc0,0x38,
0x01,0x6a,0xef,0x22,0x11,0x43,0x01,0x62,0x0f,0x21,0x41,0x61,0x10,0xbd,0x00,0x00,0x9c,0x02,0x00,0x20,0xc0,
0x42,0x00,0x40,0x38,0xc7,0x00,0x00,0x00,0x01,0x00,0x20,0xfe,0x48,0x18,0x21,0x01,0x70,0xff,0x21,0x41,0x70,
0x40,0x38,0xc1,0x88,0x01,0x22,0x11,0x43,0xc1,0x80,0x70,0x47,0xf9,0x4a,0x28,0x23,0x13,0x70,0x50,0x70,0x10,
0x46,0x91,0x70,0x40,0x38,0xc1,0x88,0x01,0x22,0x11,0x43,0xc1,0x80,0x70,0x47,0x70,0xb5,0xf3,0x4c,0x00,0x25,
0x60,0x7e,0x00,0x28,0x1a,0xd0,0x01,0x28,0x27,0xd0,0x02,0x28,0x31,0xd0,0x03,0x28,0x13,0xd1,0x04,0x20,0x26,
0x46,0x60,0x76,0xc0,0x3e,0x30,0x68,0x80,0x04,0x35,0xd5,0x2c,0x21,0x06,0x20,0xff,0xf7,0xdd,0xff,0xe7,0x49,
0xe9,0x48,0x40,0x39,0x48,0x84,0x30,0x68,0x21,0x21,0x08,0x43,0x30,0x60,0x65,0x80,0x70,0xbd,0xff,0xf7,0xc6,
0xff,0xa0,0x7e,0x41,0x1c,0xa1,0x76,0x02,0x28,0x02,0xd3,0xa5,0x76,0x01,0x20,0x1b,0xe0,0xc8,0x21,0xe0,0x48,
0xfe,0xf7,0x1c,0xfa,0x70,0xbd,0x00,0x21,0x0c,0x20,0xff,0xf7,0xc0,0xff,0xa0,0x7e,0x41,0x1c,0xa1,0x76,0x02,
0x28,0xf1,0xd3,0xa5,0x76,0x02,0x20,0x0a,0xe0,0x00,0x21,0x01,0x20,0xff,0xf7,0xb4,0xff,0xa0,0x7e,0x41,0x1c,
0xa1,0x76,0x02,0x28,0xe5,0xd3,0xa5,0x76,0x03,0x20,0x60,0x76,0xe1,0xe7,0x01,0x20,0x00,0x03,0xfe,0xf7,0xf0,
0xfe,0x70,0xbd,0xcc,0x48,0x10,0xb5,0xcc,0x49,0x40,0x38,0x42,0x8f,0x40,0x39,0xca,0x87,0xcc,0x49,0x8a,0x42,
0x08,0xd9,0x0c,0x21,0x01,0x86,0x7d,0x21,0xc9,0x00,0x81,0x86,0x0a,0x21,0x41,0x86,0x32,0x21,0x07,0xe0,0xc7,
0x49,0x4b,0x8a,0x03,0x86,0xcb,0x8a,0x83,0x86,0x8b,0x8a,0x43,0x86,0x09,0x8b,0xc1,0x86,0xc4,0x48,0x19,0x21,
0x10,0x18,0xfe,0xf7,0xec,0xfd,0xc2,0x49,0x48,0x62,0x10,0xbd,0xf8,0xb5,0xba,0x4a,0xb9,0x49,0x40,0x3a,0x40,
0x39,0x95,0x8f,0x48,0x8c,0xd6,0x8f,0xb7,0x4c,0x0a,0x46,0x43,0x1b,0xd2,0x8a,0xc0,0x3c,0x20,0x27,0xb0,0x42,
0x03,0xd9,0x85,0x42,0x08,0xd8,0x9a,0x42,0x06,0xdc,0xb0,0x42,0x0b,0xd2,0x85,0x42,0x02,0xd3,0x52,0x42,0x9a,
0x42,0x06,0xda,0x22,0x68,0xba,0x43,0x22,0x60,0xc8,0x83,0x48,0x87,0xff,0xf7,0xba,0xff,0xaa,0x48,0x41,0x88,
0x4a,0x1c,0x42,0x80,0xff,0x22,0xf5,0x32,0x91,0x42,0x08,0xd9,0x01,0x7c,0x05,0x29,0x06,0xd2,0x49,0x1c,0x01,
0x74,0x2c,0x21,0x06,0x20,0xff,0xf7,0x4f,0xff,0xf8,0xbd,0x00,0x21,0x01,0x74,0x20,0x68,0xb8,0x43,0x20,0x60,
0xf8,0xbd,0x70,0x47,0xf8,0xb5,0xa3,0x4f,0xa2,0x4a,0x9c,0x49,0x05,0x26,0x20,0x37,0xc0,0x39,0x10,0x23,0xa0,
0x4c,0x95,0x15,0x00,0x28,0x10,0xd0,0x01,0x28,0x0d,0xd1,0x7e,0x72,0x17,0x20,0x10,0x62,0x08,0x68,0x08,0x22,
0x98,0x43,0x10,0x43,0x08,0x60,0x40,0x20,0xfe,0xf7,0x77,0xfe,0x20,0x69,0x28,0x43,0x20,0x61,0xf8,0xbd,0x7e,
0x72,0x10,0x6a,0x0d,0x26,0xb0,0x43,0x10,0x62,0x08,0x68,0x94,0x4a,0x10,0x40,0x18,0x43,0x08,0x60,0x80,0x20,
0xfe,0xf7,0x66,0xfe,0x20,0x69,0xa8,0x43,0xed,0xe7,0x70,0xb5,0x05,0x46,0x86,0x48,0x84,0x4c,0x40,0x38,0x01,
0x8f,0x40,0x3c,0x20,0x8d,0xfe,0xf7,0x61,0xfd,0x01,0x28,0x00,0xd8,0x01,0x20,0x86,0x49,0x20,0x31,0x48,0x75,
0x14,0x21,0x28,0x46,0xfe,0xf7,0x57,0xfd,0x61,0x8e,0x09,0x1a,0x07,0xd4,0x20,0x8e,0x49,0x43,0x48,0x43,0xc1,
0x17,0x49,0x0f,0x08,0x18,0xc0,0x10,0x00,0xe0,0x00,0x20,0xe1,0x8e,0x08,0x18,0xa1,0x8e,0x81,0x42,0x00,0xd2,
0x08,0x46,0x74,0x49,0xc0,0x39,0x09,0x68,0x7b,0x4b,0x0a,0x03,0x7b,0x49,0x59,0x5e,0x01,0xd5,0x62,0x8b,0x00,
0xe0,0x62,0x8f,0x51,0x18,0x08,0x18,0x78,0x49,0x88,0x42,0x00,0xd9,0x08,0x46,0x6b,0x49,0x08,0x80,0x70,0xbd,
0xf8,0xb5,0x69,0x4c,0x19,0x21,0x20,0x46,0x40,0x38,0x86,0x8f,0x25,0x88,0x30,0x46,0xfe,0xf7,0x27,0xfd,0x00,
0x90,0x00,0x27,0x19,0x21,0x28,0x46,0xfe,0xf7,0x21,0xfd,0x01,0x46,0x00,0x98,0xb5,0x42,0x09,0xd3,0x08,0x1a,
0xc0,0x01,0xfe,0xf7,0x2f,0xfd,0x80,0xb2,0x7f,0x28,0x00,0xd9,0x7f,0x20,0x45,0xb2,0x1d,0xe0,0x40,0x1a,0xc0,
0x01,0xfe,0xf7,0x25,0xfd,0x80,0xb2,0x80,0x28,0x02,0xd9,0x7f,0x20,0xc0,0x43,0x00,0xe0,0x40,0x42,0x45,0xb2,
0x20,0x7d,0x03,0x28,0x0e,0xd3,0xa9,0x1c,0x0a,0xdd,0x40,0x1c,0xc0,0xb2,0x20,0x75,0x05,0x28,0x07,0xd9,0x27,
0x75,0x23,0x21,0x5b,0x48,0xfe,0xf7,0xfe,0xf8,0x01,0xe0,0x03,0x20,0x20,0x75,0x60,0x7d,0x04,0x2d,0x09,0xdd,
0x40,0x1c,0xc0,0xb2,0x60,0x75,0x14,0x28,0x0b,0xd9,0x67,0x75,0x20,0x20,0xfe,0xf7,0xe1,0xfd,0x06,0xe0,0x00,
0x28,0x01,0xd1,0x01,0x20,0x60,0x75,0xc0,0xb2,0x40,0x1e,0x60,0x75,0x41,0x48,0x40,0x30,0xc5,0x75,0x28,0x46,
0xf8,0xbd,0x3e,0x48,0x10,0xb5,0x40,0x30,0x00,0x6c,0x14,0x28,0x06,0xd8,0x3c,0x48,0x40,0x38,0x81,0x8f,0x3f,
0x48,0xc0,0x88,0x81,0x42,0x19,0xd9,0x40,0x48,0xc0,0x68,0x45,0x4c,0x40,0x04,0x04,0xd5,0x20,0x68,0x10,0x21,
0x08,0x43,0x20,0x60,0x02,0xe0,0x01,0x20,0xff,0xf7,0x2a,0xff,0x20,0x68,0x01,0x21,0x49,0x02,0x08,0x43,0x20,
0x60,0x08,0x20,0xfe,0xf7,0xb2,0xfd,0x20,0x68,0x40,0x04,0x01,0xd4,0xff,0xf7,0x70,0xfe,0x10,0xbd,0xf8,0xb5,
0x39,0x48,0x41,0x7d,0x38,0x48,0x20,0x30,0x40,0x69,0x49,0x1c,0xfe,0xf7,0xab,0xfc,0x30,0x4f,0x26,0x4e,0x38,
0x82,0x40,0x3e,0xb0,0x8f,0xb8,0x83,0x70,0x8f,0x78,0x83,0x30,0x8f,0x38,0x83,0xff,0xf7,0x34,0xff,0x2e,0x4d,
0x28,0x68,0x04,0x24,0x00,0x07,0xe4,0x43,0x22,0x49,0x00,0x28,0x02,0xdb,0x28,0x68,0xc0,0x06,0x0b,0xd5,0xb0,
0x8f,0xc9,0x88,0x88,0x42,0x03,0xd9,0x38,0x8a,0x28,0x49,0x88,0x42,0x11,0xd8,0xff,0xf7,0x59,0xff,0x04,0x46,
0x0a,0xe0,0xb0,0x8f,0x89,0x88,0x88,0x42,0x09,0xd2,0xff,0xf7,0x51,0xff,0x04,0x46,0x1e,0x21,0x21,0x48,0xfe,
0xf7,0x83,0xf8,0x20,0x1d,0x08,0x28,0x01,0xd9,0x24,0x20,0x00,0xe0,0xb4,0x20,0xe8,0x60,0x28,0x68,0x40,0x04,
0x05,0xd5,0x1c,0x48,0x40,0x7a,0x00,0x28,0x01,0xd0,0x24,0x20,0xe8,0x60,0x07,0x48,0x40,0x30,0x01,0x6c,0x49,
0x1c,0x01,0x64,0x12,0x48,0x03,0x21,0x40,0x30,0x01,0x72,0x44,0x72,0x02,0x20,0xff,0xf7,0xf4,0xfa,0xf8,0xbd,
0x00,0x00,0x40,0x00,0x00,0x20,0x5c,0x03,0x00,0x20,0x28,0x23,0x00,0x00,0x87,0x1c,0x00,0x00,0x10,0x27,0x00,
0x00,0x80,0x06,0x00,0x20,0x48,0xf4,0xff,0xff,0x00,0x48,0x00,0x40,0x00,0x60,0x00,0x40,0xf7,0xff,0xef,0xff,
0x00,0x00,0x00,0x20,0x20,0x00,0x00,0x00,0xf0,0x55,0x00,0x00,0x23,0x1d,0x00,0x00,0x9c,0x02,0x00,0x20,0x20,
0x5c,0x00,0x40,0xd5,0x02,0x00,0x00,0x59,0x1f,0x00,0x00,0xfc,0x04,0x00,0x20,0x70,0xb5,0x0c,0x46,0x68,0x21,
0x48,0x43,0x64,0x21,0xfe,0xf7,0x31,0xfc,0xc0,0x1f,0x00,0xd5,0x00,0x20,0xc9,0x49,0x49,0x78,0x00,0x29,0x06,
0xd0,0x60,0x00,0x20,0x18,0x64,0x21,0xfe,0xf7,0x25,0xfc,0xc8,0x30,0x0e,0xe0,0xc5,0x49,0xc5,0x4d,0x48,0x43,
0x29,0x46,0xfe,0xf7,0x33,0xfc,0x06,0x46,0x7d,0x20,0xbe,0x3e,0x60,0x43,0x29,0x46,0xfe,0xf7,0x16,0xfc,0x80,
0x19,0x26,0x30,0x00,0x28,0x00,0xda,0x00,0x20,0x70,0xbd,0x70,0xb5,0x04,0x46,0x0d,0x46,0x68,0x20,0x60,0x43,
0x64,0x21,0xfe,0xf7,0x08,0xfc,0xc0,0x1f,0x00,0xd5,0x00,0x20,0x25,0x30,0x64,0x2c,0x00,0xd2,0x10,0x30,0xb3,
0x4c,0x60,0x3c,0xa1,0x8c,0x81,0x42,0x00,0xda,0x08,0x46,0x7d,0x21,0x68,0x43,0xc9,0x00,0xfe,0xf7,0x0c,0xfc,
0x05,0x46,0xa0,0x89,0x00,0x28,0x0a,0xd0,0xae,0x4c,0x20,0x69,0x66,0x15,0x30,0x43,0x20,0x61,0x01,0x20,0xfe,
0xf7,0xd0,0xfa,0x20,0x69,0xb0,0x43,0x20,0x61,0x28,0x46,0x70,0xbd,0xf8,0xb5,0xa8,0x4f,0x0a,0x21,0x38,0x46,
0x3c,0x8f,0x0e,0x30,0xfe,0xf7,0x3d,0xfb,0x3e,0x46,0x40,0x3e,0x00,0x23,0xf3,0x5e,0x71,0x88,0x40,0x22,0xfe,
0xf7,0x4d,0xfb,0x05,0x46,0x01,0x46,0x20,0x46,0xff,0xf7,0xc0,0xff,0x00,0x90,0x29,0x46,0x20,0x46,0xff,0xf7,
0x93,0xff,0x05,0x46,0x9c,0x48,0x84,0x42,0x01,0xd9,0x05,0x20,0x03,0xe0,0x96,0x21,0x20,0x46,0xfe,0xf7,0xc1,
0xfb,0x93,0x4c,0x40,0x00,0x60,0x3c,0x00,0x19,0x60,0x30,0x01,0x7a,0x69,0x43,0xca,0x09,0x09,0x21,0x41,0x56,
0x0a,0x20,0x41,0x43,0x50,0x18,0x00,0x99,0x0d,0x18,0x91,0x48,0x85,0x42,0x05,0xd9,0x40,0x42,0x05,0x21,0x28,
0x18,0xfe,0xf7,0xaa,0xfb,0x45,0x19,0xe8,0x01,0x8c,0x49,0xfe,0xf7,0xa5,0xfb,0xf9,0x8f,0x8b,0x4a,0x91,0x42,
0x05,0xd9,0x87,0x49,0x80,0x39,0x09,0x68,0x89,0x04,0x00,0xd5,0x40,0x08,0xa0,0x82,0x04,0x21,0x31,0x72,0x70,
0x72,0x02,0x20,0xff,0xf7,0x28,0xfa,0x32,0xe7,0x80,0x4a,0x10,0xb5,0x20,0x23,0x40,0x3a,0x13,0x72,0x50,0x72,
0x91,0x72,0x03,0x20,0xff,0xf7,0x1d,0xfa,0x10,0xbd,0x70,0xb5,0x7e,0x4d,0x28,0x7a,0x01,0x28,0x08,0xd0,0x02,
0x28,0x12,0xd0,0x03,0x28,0x12,0xd0,0x72,0x4c,0x20,0x34,0x04,0x28,0x12,0xd0,0x1c,0xe0,0x73,0x48,0x22,0x23,
0x40,0x38,0x00,0x22,0x03,0x72,0x50,0x21,0x42,0x72,0x81,0x72,0x03,0x20,0xff,0xf7,0x03,0xfa,0x41,0xe0,0x30,
0x20,0x00,0xe0,0x31,0x20,0x00,0xf0,0x47,0xf9,0x3b,0xe0,0x20,0x7a,0x21,0x7b,0x88,0x42,0x02,0xd1,0x05,0x20,
0x28,0x72,0x06,0xe0,0x31,0x21,0x02,0x20,0xff,0xf7,0xca,0xff,0x28,0x7a,0x05,0x28,0x0d,0xd1,0x20,0x7d,0x81,
0x06,0x89,0x0e,0x28,0x29,0x02,0xd2,0x00,0x29,0x02,0xd0,0x02,0xe0,0x28,0x21,0x00,0xe0,0x14,0x21,0x01,0x20,
0xff,0xf7,0xb9,0xff,0x28,0x7a,0x06,0x28,0x15,0xd1,0xa0,0x7a,0xa1,0x7b,0x88,0x42,0x02,0xd1,0x07,0x20,0x28,
0x72,0x11,0xe0,0x20,0x7d,0x80,0x06,0x80,0x0e,0x28,0x28,0x00,0xd3,0x28,0x20,0xa0,0x75,0x00,0x28,0x01,0xd1,
0x14,0x20,0xa0,0x75,0xc1,0xb2,0x04,0x20,0xff,0xf7,0xa0,0xff,0x28,0x7a,0x07,0x28,0x03,0xd1,0xe9,0x7a,0x00,
0x20,0xff,0xf7,0x99,0xff,0x28,0x7a,0x07,0x28,0x06,0xd8,0x4b,0x48,0x80,0x38,0x01,0x68,0x01,0x22,0xd2,0x03,
0x11,0x43,0x01,0x60,0x70,0xbd,0x70,0xb5,0x46,0x4c,0x80,0x3c,0x20,0x68,0xc0,0x05,0x04,0xd5,0x24,0x21,0x48,
0x48,0xfd,0xf7,0x1d,0xff,0x70,0xbd,0x08,0x20,0xe0,0x60,0x60,0x68,0x41,0x1c,0x61,0x60,0x3f,0x49,0x40,0x31,
0x49,0x7c,0x88,0x42,0x0a,0xd3,0x00,0x20,0x60,0x60,0x20,0x68,0x40,0x04,0x02,0xd5,0x00,0xf0,0x87,0xf8,0x70,
0xbd,0xff,0xf7,0x1d,0xff,0x70,0xbd,0x20,0x68,0x40,0x25,0x40,0x06,0x00,0x28,0x1d,0xda,0x20,0x68,0xa8,0x43,
0x20,0x60,0x20,0x68,0xc0,0x07,0x17,0xd0,0x2d,0x49,0x31,0x48,0x16,0x22,0x20,0x39,0x38,0x38,0xfe,0xf7,0xe8,
0xf9,0x2e,0x48,0x40,0x38,0x00,0x7a,0xfe,0xf7,0x0a,0xfa,0x40,0x1c,0xff,0xf7,0x7b,0xf9,0x20,0x68,0x04,0x21,
0x08,0x43,0x20,0x60,0x20,0x68,0x40,0x08,0x40,0x00,0x20,0x60,0x70,0xbd,0xff,0xf7,0x28,0xfe,0x20,0x68,0x28,
0x43,0xf8,0xe7,0x23,0x48,0x10,0xb5,0x80,0x38,0x01,0x68,0x01,0x22,0xd2,0x02,0x11,0x43,0x01,0x60,0x25,0x49,
0x81,0x64,0x22,0x22,0x01,0x46,0x40,0x31,0x8a,0x81,0x21,0x4a,0x42,0x64,0x4a,0x7b,0x80,0x23,0x1a,0x43,0x4a,
0x73,0x01,0x68,0x1a,0x02,0x11,0x43,0x01,0x60,0x1b,0x49,0x00,0x20,0xc8,0x72,0x11,0x48,0x1c,0x49,0x20,0x30,
0x81,0x60,0x1b,0x49,0xc1,0x60,0x06,0x20,0xff,0xf7,0x49,0xf9,0xfe,0xf7,0xd3,0xfc,0x10,0xbd,0x0f,0x48,0x10,
0xb5,0x71,0x21,0x40,0x38,0x01,0x72,0x12,0x21,0x41,0x72,0x08,0x49,0x0b,0x4c,0x60,0x39,0x09,0x8f,0x80,0x3c,
0x0a,0x0a,0x82,0x72,0xc1,0x72,0x01,0x20,0xe0,0x64,0x08,0x20,0xff,0xf7,0x32,0xf9,0x0e,0x48,0x60,0x64,0x10,
0xbd,0x00,0x00,0x60,0x00,0x00,0x20,0xc2,0x21,0x00,0x00,0x10,0x27,0x00,0x00,0x00,0x60,0x00,0x40,0x1c,0x03,
0x00,0x20,0x52,0x03,0x00,0x00,0x88,0x13,0x00,0x00,0x58,0x1b,0x00,0x00,0xfc,0x04,0x00,0x20,0xcf,0x22,0x00,
0x00,0x51,0x0a,0x00,0x00,0x31,0x28,0x28,0x00,0x04,0x0a,0x0a,0x00,0x5f,0x23,0x00,0x00,0xf8,0xb5,0x28,0x48,
0x0a,0x21,0x04,0x8f,0x0e,0x30,0xfe,0xf7,0xd7,0xf9,0x25,0x4e,0x00,0x23,0x40,0x3e,0xf3,0x5e,0x71,0x88,0x40,
0x22,0xfe,0xf7,0xe7,0xf9,0x05,0x46,0x01,0x46,0x20,0x46,0xff,0xf7,0x5a,0xfe,0x07,0x46,0x29,0x46,0x20,0x46,
0xff,0xf7,0x2d,0xfe,0x05,0x46,0x1c,0x48,0x84,0x42,0x01,0xd9,0x05,0x20,0x03,0xe0,0x96,0x21,0x20,0x46,0xfe,
0xf7,0x5b,0xfa,0x41,0x00,0x18,0x48,0x08,0x18,0x60,0x30,0x01,0x7e,0x69,0x43,0xca,0x09,0x19,0x21,0x41,0x56,
0x0a,0x20,0x41,0x43,0x50,0x18,0x13,0x49,0x7d,0x22,0x80,0x31,0x89,0x7d,0x38,0x18,0x49,0x08,0xd2,0x00,0x51,
0x43,0xc0,0x03,0xfe,0xf7,0x44,0xfa,0x0e,0x49,0x88,0x42,0x00,0xd9,0x08,0x46,0x31,0x21,0x31,0x72,0x0c,0x49,
0x49,0x7a,0x71,0x72,0x01,0x0a,0xb1,0x72,0xf0,0x72,0x04,0x20,0xff,0xf7,0xc9,0xf8,0x04,0x48,0x80,0x38,0x01,
0x68,0x01,0x22,0xd2,0x03,0x11,0x43,0x01,0x60,0xf8,0xbd,0x00,0x00,0x1c,0x03,0x00,0x20,0x52,0x03,0x00,0x00,
0x00,0x00,0x00,0x20,0xff,0xff,0x00,0x00,0xfc,0x04,0x00,0x20,0x10,0xb5,0x04,0x49,0x07,0x22,0x0a,0x72,0x48,
0x72,0x02,0x20,0xff,0xf7,0xae,0xf8,0x10,0xbd,0x00,0x00,0xdc,0x02,0x00,0x20,0x9e,0x49,0x9d,0x48,0x48,0x62,
0x9e,0x4a,0x00,0x20,0x10,0x62,0x50,0x62,0x9d,0x48,0x02,0x6a,0x01,0x23,0x1a,0x43,0x02,0x62,0x9a,0x48,0x9b,
0x4a,0x40,0x38,0x02,0x63,0x45,0x22,0x42,0x63,0xff,0x22,0x95,0x48,0x10,0x32,0x40,0x38,0x42,0x60,0xe3,0x22,
0xd2,0x00,0x4a,0x60,0x95,0x4a,0x4a,0x63,0x12,0x22,0xca,0x63,0x94,0x4a,0x02,0x62,0x94,0x4b,0x43,0x62,0x30,
0x23,0x83,0x62,0xef,0x23,0x43,0x61,0x80,0x23,0x03,0x60,0x8a,0x62,0x70,0x47,0x70,0xb5,0x00,0x20,0x8f,0x4a,
0x01,0x46,0x43,0x01,0x9b,0x18,0xff,0x33,0x61,0x33,0x40,0x1c,0x99,0x72,0x08,0x28,0xf7,0xdb,0x8b,0x48,0x8b,
0x4c,0xc0,0x6a,0x2c,0x34,0x03,0x68,0x0c,0xe0,0x06,0x46,0x72,0xb6,0x24,0xc8,0x18,0x3e,0x55,0x60,0x08,0x38,
0x2a,0x60,0x01,0x60,0x41,0x60,0x31,0x70,0x62,0xb6,0x18,0x46,0x1b,0x68,0xa0,0x42,0xf0,0xd1,0x82,0x48,0x01,
0x71,0x70,0xbd,0xf8,0xb5,0x0d,0x46,0x7d,0x49,0x47,0x01,0x7e,0x18,0x34,0x46,0xff,0x34,0x61,0x34,0x20,0x7b,
0x16,0x28,0x0b,0xd2,0x00,0x28,0x0c,0xd1,0x28,0x46,0xfe,0xf7,0xd8,0xf8,0xc0,0xb2,0x00,0x2d,0x01,0xd0,0x14,
0x28,0x02,0xd9,0x00,0x20,0xa0,0x72,0xf8,0xbd,0x80,0x1c,0xa0,0x73,0x71,0x49,0x20,0x7b,0xff,0x37,0x41,0x18,
0x40,0x1c,0x20,0x73,0x71,0x37,0xcd,0x55,0x60,0x7b,0x68,0x40,0x60,0x73,0x22,0x7b,0xa1,0x7b,0x8a,0x42,0xed,
0xd1,0x6a,0x4a,0x05,0x23,0x80,0x32,0xd2,0x6a,0x9b,0x02,0x13,0x40,0x01,0x24,0x68,0x4d,0x00,0x2b,0x01,0xd1,
0xd2,0x07,0x07,0xd0,0x2c,0x71,0x0a,0x20,0xa8,0x70,0x65,0x48,0x01,0x8b,0x21,0x43,0x01,0x83,0xf8,0xbd,0x00,
0x28,0xa8,0x78,0x07,0xd0,0x08,0x28,0xf9,0xd1,0x03,0x29,0xf7,0xd1,0x60,0x48,0x00,0xf0,0xd9,0xfd,0xf8,0xbd,
0x00,0x28,0xfc,0xd0,0x30,0x46,0xff,0x30,0x71,0x30,0x00,0xf0,0xa8,0xfa,0x28,0x79,0x00,0x28,0xf4,0xd1,0x2c,
0x71,0x02,0x21,0x59,0x48,0xfd,0xf7,0x77,0xfd,0xf8,0xbd,0xf8,0xb5,0x4b,0x49,0x07,0x46,0x80,0x00,0x40,0x31,
0x40,0x18,0x01,0x68,0x7a,0x01,0x48,0x05,0x46,0x0f,0x4d,0x48,0x14,0x18,0xff,0x34,0x61,0x34,0x05,0x2e,0x1a,
0xd0,0x00,0x20,0x4a,0x4d,0x7b,0x01,0x5b,0x19,0xc0,0xb2,0xff,0x33,0xe0,0x72,0x61,0x33,0xf7,0x22,0x9b,0x7a,
0x0a,0x28,0x03,0xd8,0x05,0x28,0x05,0xd9,0x18,0x07,0x03,0xd4,0x04,0x20,0x03,0x43,0x13,0x40,0xa3,0x72,0xa0,
0x7a,0x05,0x2e,0x06,0xd2,0xfb,0x21,0x08,0x40,0x10,0x40,0x64,0xe0,0xe0,0x7a,0x40,0x1c,0xe2,0xe7,0x3b,0x4d,
0x7b,0x01,0x5d,0x19,0xff,0x35,0x42,0x07,0x41,0x35,0x00,0x2a,0x20,0xda,0x06,0x2e,0x1e,0xd3,0x00,0xf0,0x94,
0xfd,0xa0,0x7a,0xfb,0x21,0x08,0x40,0x08,0x21,0x08,0x43,0x00,0x21,0xa0,0x72,0x21,0x73,0x61,0x73,0x06,0x2e,
0x07,0xd0,0x01,0x22,0x10,0x43,0xa0,0x72,0x03,0x20,0x00,0x02,0xe8,0x84,0x29,0x85,0xf8,0xbd,0x03,0x21,0x08,
0x43,0xa0,0x72,0x01,0x20,0x40,0x02,0xe8,0x84,0x11,0x20,0x40,0x02,0x28,0x85,0xf8,0xbd,0x02,0x07,0xfc,0xd5,
0x1f,0x4a,0x11,0x61,0xc1,0x07,0x19,0xd0,0x07,0x2e,0x05,0xd1,0xe9,0x8c,0x89,0x04,0x02,0xd5,0x40,0x08,0x40,
0x00,0x10,0xe0,0x19,0x49,0xea,0x8c,0x4a,0x61,0x89,0x69,0x89,0xb2,0xe9,0x84,0x0a,0x04,0x09,0xd5,0xca,0x04,
0xf2,0xd5,0xc9,0xb2,0xf8,0xb2,0xff,0xf7,0x35,0xff,0xa0,0x7a,0xfd,0x21,0x08,0x40,0xa0,0x72,0xa0,0x7a,0x81,
0x07,0xdb,0xd5,0x07,0x2e,0x02,0xd1,0x29,0x8d,0x89,0x04,0x12,0xd4,0x0c,0x49,0x2a,0x8d,0x4a,0x61,0x89,0x69,
0x89,0xb2,0x29,0x85,0x0a,0x04,0xce,0xd5,0xca,0x04,0x08,0xd5,0xc9,0xb2,0xf8,0xb2,0xff,0xf7,0x1b,0xff,0xa0,
0x7a,0x40,0x08,0x40,0x00,0xa0,0x72,0xf8,0xbd,0xfd,0x21,0x08,0x40,0xfa,0xe7,0x00,0x00,0x25,0x57,0x00,0x00,
0x40,0x42,0x00,0x40,0x00,0x60,0x00,0x40,0x80,0x5c,0x00,0x40,0x39,0x70,0x00,0x00,0x10,0x10,0x00,0x00,0x0f,
0x0f,0x00,0x00,0x19,0x23,0x00,0x00,0x9c,0x02,0x00,0x20,0x80,0x01,0x00,0x20,0xdc,0x03,0x00,0x20,0x80,0x00,
0x00,0x20,0xdc,0x05,0x00,0x00,0x01,0x2f,0x00,0x00,0x70,0xb5,0x84,0x1e,0x0b,0x46,0x62,0x08,0x11,0x46,0x59,
0x43,0x0d,0x0a,0x83,0x49,0x00,0x26,0x8e,0x61,0xca,0x61,0x0d,0x62,0xaa,0x18,0x4a,0x62,0x0c,0x61,0x80,0x4a,
0x92,0x7c,0x0a,0x63,0x0a,0x68,0x80,0x24,0x22,0x43,0x0a,0x60,0x7d,0x49,0x88,0x82,0x40,0x31,0x4b,0x71,0x81,
0x1c,0x7c,0x48,0xfe,0xf7,0xa0,0xf8,0x78,0x49,0x40,0x31,0x88,0x82,0x70,0xbd,0xf8,0xb5,0x77,0x48,0x80,0x38,
0x81,0x6a,0x04,0x22,0x11,0x43,0x81,0x62,0x76,0x4d,0x06,0x20,0x68,0x70,0x72,0x4c,0x72,0x4e,0x40,0x34,0x61,
0x79,0xb0,0x8a,0xff,0xf7,0xcd,0xff,0x71,0x4f,0x00,0x20,0x20,0x3f,0x38,0x70,0x70,0x49,0x08,0x62,0x6f,0x49,
0x20,0x7d,0x60,0x31,0x08,0x70,0x27,0x20,0x68,0x77,0x01,0x21,0x39,0x70,0x66,0x48,0x02,0x68,0x0a,0x43,0x02,
0x60,0x14,0x20,0xfd,0xf7,0x5c,0xff,0xf0,0x20,0x78,0x77,0x0f,0x20,0x68,0x70,0x61,0x4d,0x60,0x4f,0x11,0xe0,
0xe9,0x7c,0x42,0x1d,0x8a,0x42,0x01,0xd2,0x40,0x1d,0x00,0xe0,0x08,0x46,0xc1,0xb2,0x61,0x71,0xb0,0x8a,0xff,
0xf7,0xa5,0xff,0x14,0x20,0xfd,0xf7,0x46,0xff,0x38,0x68,0x00,0x06,0xfc,0xd4,0x60,0x79,0xc0,0x28,0xea,0xd3,
0xf8,0xbd,0xf8,0xb5,0x53,0x4c,0x55,0x4d,0x58,0x4e,0x0a,0xe0,0xc0,0x1e,0x80,0xb2,0xff,0x21,0xff,0xf7,0x91,
0xff,0x14,0x20,0xfd,0xf7,0x32,0xff,0x20,0x68,0x00,0x06,0xfc,0xd4,0x31,0x88,0xa8,0x8a,0xc9,0x1e,0x88,0x42,
0xef,0xdc,0x20,0x68,0x40,0x08,0x40,0x00,0x20,0x60,0x7d,0x20,0xc0,0x00,0xfd,0xf7,0x22,0xff,0x49,0x48,0x20,
0x38,0x01,0x78,0x49,0x08,0x49,0x00,0x01,0x70,0x44,0x4c,0x80,0x3c,0xa0,0x6a,0x14,0x21,0x88,0x43,0xa0,0x62,
0x00,0x21,0x20,0x46,0xc0,0x30,0xc1,0x71,0xe9,0x82,0x81,0x70,0x43,0x4d,0x2a,0x68,0x22,0x63,0x62,0x63,0xff,
0x22,0x91,0x32,0xa2,0x63,0x01,0x73,0x81,0x72,0x81,0x74,0xc1,0x74,0x05,0x21,0x41,0x73,0xff,0xf7,0x2f,0xfe,
0xa0,0x8d,0x80,0x04,0x06,0xd5,0x28,0x68,0x00,0x90,0x28,0x68,0x00,0x99,0x40,0x1a,0x28,0x28,0xfa,0xd3,0xf8,
0xbd,0xf8,0xb5,0x31,0x4c,0x08,0x26,0x40,0x34,0xa6,0x57,0x30,0x1d,0x08,0x28,0x01,0xd9,0x04,0x23,0x00,0xe0,
0x01,0x23,0x32,0x49,0x2a,0x48,0xca,0x1d,0x40,0x30,0x87,0x7e,0x80,0x38,0xff,0x31,0xc5,0x8f,0xf9,0x32,0x41,
0x31,0x90,0x8a,0x49,0x79,0x01,0x2f,0x0a,0xd0,0x00,0x27,0x00,0x2e,0x1e,0xdd,0xff,0x29,0x10,0xd0,0xff,0x20,
0xc0,0x1a,0x81,0x42,0x14,0xd9,0xff,0x20,0x13,0xe0,0x03,0x1d,0xab,0x42,0x01,0xd9,0x28,0x46,0x00,0xe0,0x00,
0x1d,0x80,0xb2,0x90,0x82,0xff,0xf7,0x24,0xff,0xf8,0xbd,0xa8,0x42,0x13,0xd0,0xc0,0x18,0xa8,0x42,0x00,0xd8,
0x05,0x46,0x95,0x82,0x01,0xe0,0xc8,0x18,0x60,0x71,0xf0,0x1a,0x17,0xe0,0x00,0x2e,0x16,0xda,0x12,0x4d,0x40,
0x3d,0xad,0x8f,0xa8,0x42,0x0a,0xd1,0xa0,0x79,0x81,0x42,0x01,0xd1,0x27,0x72,0xf8,0xbd,0xc9,0x1a,0x81,0x42,
0x00,0xdd,0x08,0x46,0x60,0x71,0x04,0xe0,0xc0,0x1a,0xa8,0x42,0x00,0xdd,0x05,0x46,0x95,0x82,0xf0,0x18,0x20,
0x72,0x61,0x79,0x90,0x8a,0xff,0xf7,0xfa,0xfe,0x20,0x7a,0x00,0x28,0xea,0xd0,0x02,0x21,0x0a,0x48,0xfd,0xf7,
0xb7,0xfb,0xf8,0xbd,0x00,0x40,0x00,0x40,0x40,0x00,0x00,0x20,0x9c,0x03,0x00,0x20,0x80,0x38,0x01,0x00,0x40,
0x46,0x00,0x40,0x00,0x5c,0x00,0x40,0xc0,0x06,0x00,0x20,0x00,0x01,0x00,0x20,0x9c,0x02,0x00,0x20,0xf1,0x28,
0x00,0x00,0x70,0xb5,0x4b,0x49,0x4b,0x48,0x4a,0x8b,0x00,0x2a,0x19,0xd0,0x10,0x2a,0x01,0xd9,0x10,0x23,0x00,
0xe0,0x13,0x46,0xdc,0xb2,0x63,0x1e,0x1b,0x07,0x1b,0x0c,0xff,0x33,0x83,0x63,0x0b,0x8b,0x44,0x4e,0x5d,0x00,
0xad,0x19,0xff,0x35,0x01,0x35,0xad,0x8b,0xc5,0x60,0x5b,0x1c,0x12,0x1b,0x12,0x04,0x0b,0x83,0x12,0x0c,0x4a,
0x83,0x0c,0xd1,0x00,0x22,0x0a,0x83,0x42,0x68,0x40,0x21,0x8a,0x43,0x42,0x60,0x82,0x68,0x0a,0x43,0x82,0x60,
0x01,0x68,0x12,0x22,0x91,0x43,0x01,0x60,0x70,0xbd,0x70,0xb5,0x34,0x48,0x81,0x8a,0x36,0x48,0x0c,0x46,0x89,
0x1c,0xfd,0xf7,0x66,0xff,0x01,0x46,0x34,0x48,0xfd,0xf7,0x62,0xff,0x01,0x46,0x2e,0x48,0x32,0x4a,0x40,0x30,
0xc5,0x7f,0xa8,0x07,0x00,0x0f,0x10,0x58,0xfd,0xf7,0x58,0xff,0x69,0x07,0x2a,0x4d,0x01,0xd5,0x20,0x18,0x00,
0xe0,0x20,0x1a,0x68,0x61,0xff,0xf7,0xb3,0xff,0x40,0x20,0x68,0x60,0x28,0x68,0x92,0x21,0x08,0x43,0x28,0x60,
0x70,0xbd,0x70,0xb5,0x05,0x46,0x00,0x78,0xfd,0xf7,0x63,0xfe,0x04,0x46,0x40,0x1e,0x13,0x28,0x15,0xd2,0x61,
0x1c,0x28,0x46,0xfd,0xf7,0x6f,0xfe,0x29,0x19,0x48,0x70,0xa4,0x1c,0x20,0x46,0x16,0x21,0x4c,0x43,0x18,0x49,
0x17,0x4a,0x4c,0x83,0x81,0xb2,0x1c,0x32,0x28,0x46,0xfd,0xf7,0xee,0xfe,0x03,0x21,0x19,0x48,0xfd,0xf7,0x2f,
0xfb,0x70,0xbd,0x10,0xb5,0x11,0x49,0x2d,0x22,0x4a,0x83,0x0a,0x46,0x1c,0x32,0x02,0x21,0xfd,0xf7,0xe0,0xfe,
0x03,0x21,0x12,0x48,0xfd,0xf7,0x21,0xfb,0x10,0xbd,0x70,0x47,0x70,0xb5,0x0b,0x4c,0x00,0x21,0x20,0x68,0x02,
0x68,0x0a,0xe0,0x06,0x46,0x28,0xc8,0x18,0x3e,0x5d,0x60,0x08,0x38,0x2b,0x60,0x01,0x60,0x41,0x60,0x31,0x70,
0x10,0x46,0x12,0x68,0xa0,0x42,0xf2,0xd1,0x70,0xbd,0x00,0x00,0x9c,0x03,0x00,0x20,0x00,0x40,0x00,0x40,0x9c,
0x02,0x00,0x20,0x80,0x38,0x01,0x00,0x40,0x42,0x0f,0x00,0xcc,0x39,0x00,0x00,0x35,0x2a,0x00,0x00,0x70,0xb5,
0x15,0x46,0x03,0x46,0xfe,0x4a,0x00,0x20,0x44,0x01,0xa4,0x18,0x26,0x7a,0x08,0x34,0x00,0x2e,0x03,0xd0,0x40,
0x1c,0x05,0x28,0xf6,0xdb,0x70,0xbd,0x0a,0x46,0x19,0x46,0x20,0x46,0xfd,0xf7,0xdb,0xfd,0xf5,0x48,0x00,0x2d,
0x06,0xd0,0x18,0x34,0x41,0x68,0x44,0x60,0x03,0xc4,0x08,0x3c,0x0c,0x60,0x70,0xbd,0x01,0x68,0x18,0x34,0x4c,
0x60,0x21,0x60,0x60,0x60,0x04,0x60,0x70,0xbd,0x70,0xb5,0x03,0x46,0xed,0x4a,0x00,0x20,0x44,0x01,0xa4,0x18,
0xb4,0x34,0x25,0x78,0x00,0x2d,0x03,0xd0,0x40,0x1c,0x05,0x28,0xf6,0xdb,0x70,0xbd,0x0a,0x46,0x19,0x46,0x20,
0x46,0xfd,0xf7,0xb7,0xfd,0xe4,0x48,0x18,0x34,0xac,0x30,0x41,0x68,0x44,0x60,0x03,0xc4,0x08,0x3c,0x0c,0x60,
0x70,0xbd,0x10,0xb5,0x00,0x78,0xc1,0x09,0x01,0xd0,0xc0,0x43,0x40,0x1c,0x00,0x06,0x00,0x0e,0x14,0xd0,0x04,
0x28,0x06,0xd2,0x00,0x29,0x02,0xd0,0x00,0x20,0xc0,0x43,0x0d,0xe0,0x01,0x20,0x0b,0xe0,0xd8,0x4a,0x93,0x8a,
0xd8,0x4a,0x94,0x8f,0xa3,0x42,0x1e,0xd1,0x00,0x29,0x01,0xd0,0x40,0x08,0x2d,0xe0,0x40,0x08,0x40,0xb2,0xd2,
0x4c,0x40,0x34,0x20,0x72,0x61,0x7b,0xd2,0x48,0xfd,0xf7,0x96,0xfa,0xe0,0x7c,0x10,0x28,0x00,0xd2,0x40,0x1c,
0xe0,0x74,0xcf,0x48,0x00,0xf0,0xe0,0xfa,0xcb,0x48,0x80,0x30,0x01,0x6c,0x49,0x1c,0x01,0x64,0x19,0x21,0xcb,
0x48,0xfd,0xf7,0x85,0xfa,0x10,0xbd,0xd2,0x8f,0xd2,0x1a,0x12,0x12,0x52,0x1c,0x92,0xb2,0x1a,0x28,0x00,0xd9,
0x1a,0x20,0x00,0x29,0x02,0xd0,0x43,0x08,0x18,0x18,0xc0,0xb2,0x50,0x43,0x40,0x08,0x40,0x1c,0xc0,0xb2,0x00,
0x29,0xd2,0xd0,0x40,0x42,0xd0,0xe7,0x70,0xb5,0xbf,0x4d,0x00,0x24,0xe0,0x00,0x28,0x58,0xc0,0xb2,0x00,0xf0,
0xa3,0xf9,0x00,0x28,0x05,0xd0,0xe1,0x00,0x49,0x19,0x49,0x68,0x40,0x1c,0x88,0x47,0x70,0xbd,0x64,0x1c,0x05,
0x2c,0xef,0xd3,0x01,0x20,0x00,0xf0,0x95,0xf9,0xb0,0x4c,0x40,0x34,0x00,0x28,0x01,0xd0,0x01,0x20,0x0d,0xe0,
0xe0,0x79,0x01,0x28,0x09,0xd1,0x71,0x20,0x00,0xf0,0x89,0xf9,0x00,0x28,0x04,0xd0,0x0a,0x20,0xa0,0x70,0xff,
0xf7,0x28,0xff,0x70,0xbd,0x00,0x20,0xe0,0x71,0x70,0xbd,0xf8,0xb5,0x01,0x46,0xa4,0x48,0x05,0x22,0x60,0x30,
0x06,0x46,0xfd,0xf7,0x2e,0xfd,0xa1,0x4c,0xb0,0x78,0x40,0x34,0x40,0x07,0xa1,0x7a,0x25,0x46,0x40,0x0f,0x0a,
0x27,0xc0,0x3d,0x88,0x42,0x0e,0xd0,0xe8,0x6a,0x10,0x21,0x08,0x43,0xe8,0x62,0xa7,0x70,0x9a,0x48,0x02,0x22,
0x80,0x30,0x01,0x8b,0x11,0x43,0x01,0x83,0x40,0x20,0xfd,0xf7,0x14,0xff,0xf8,0xbd,0x94,0x48,0x04,0x22,0x00,
0x21,0x58,0x30,0xfd,0xf7,0x03,0xfd,0x32,0x79,0xfb,0x23,0xd0,0x09,0x20,0x73,0x30,0x78,0x80,0x06,0x80,0x0e,
0xa0,0x77,0x67,0x77,0x04,0x20,0x20,0x77,0xe1,0x7f,0x50,0x06,0xc0,0x0f,0x19,0x40,0x80,0x00,0x01,0x43,0x48,
0x07,0xc0,0x0f,0xe1,0x77,0x86,0x00,0xe0,0x7e,0x92,0x06,0x18,0x40,0x30,0x43,0xe0,0x76,0x93,0x0f,0x04,0xd0,
0x89,0x08,0x89,0x00,0x92,0x0f,0x11,0x43,0x02,0xe0,0x89,0x08,0x89,0x00,0x89,0x1c,0xe1,0x77,0x89,0x07,0x89,
0x0f,0x80,0x08,0x80,0x00,0x08,0x43,0xe0,0x76,0x7a,0x48,0x00,0x68,0x68,0x63,0x08,0x20,0xa0,0x70,0x7f,0x48,
0xe8,0x64,0x7b,0x48,0x00,0xf0,0x38,0xfa,0xf8,0xbd,0x10,0xb5,0x16,0x20,0x00,0xf0,0x33,0xfa,0x51,0x20,0x00,
0xf0,0x1a,0xf9,0x00,0x28,0x03,0xd0,0x40,0x1c,0xff,0xf7,0x96,0xff,0x10,0xbd,0x06,0x20,0x00,0xf0,0x11,0xf9,
0x6e,0x4c,0x40,0x34,0x00,0x28,0x20,0xd0,0x40,0x78,0x41,0x1f,0xc8,0x29,0x07,0xd8,0x60,0x73,0xa0,0x78,0x05,
0x28,0x14,0xd1,0xa0,0x7a,0x40,0x1c,0xa0,0x72,0x10,0xe0,0x64,0x48,0x20,0x22,0x80,0x30,0xc1,0x6a,0x11,0x43,
0xc1,0x62,0x0a,0x20,0xa0,0x70,0x40,0x20,0xfd,0xf7,0xac,0xfe,0x61,0x48,0x10,0x22,0x80,0x30,0x01,0x8b,0x11,
0x43,0x01,0x83,0x16,0x20,0x00,0xf0,0x03,0xfa,0x10,0xbd,0x18,0x20,0x00,0xf0,0xe9,0xf8,0x00,0x28,0x3b,0xd1,
0x19,0x20,0x00,0xf0,0xe4,0xf8,0x00,0x28,0x36,0xd1,0x28,0x20,0x00,0xf0,0xdf,0xf8,0x00,0x28,0x31,0xd1,0x29,
0x20,0x00,0xf0,0xda,0xf8,0x00,0x28,0x2c,0xd1,0x38,0x20,0x00,0xf0,0xd5,0xf8,0x00,0x28,0x27,0xd1,0x48,0x20,
0x00,0xf0,0xd0,0xf8,0x00,0x28,0x22,0xd1,0x58,0x20,0x00,0xf0,0xcb,0xf8,0x00,0x28,0x1d,0xd1,0x68,0x20,0x00,
0xf0,0xc6,0xf8,0x00,0x28,0x18,0xd1,0x78,0x20,0x00,0xf0,0xc1,0xf8,0x00,0x28,0x13,0xd1,0x84,0x20,0x00,0xf0,
0xbc,0xf8,0x00,0x28,0x0e,0xd1,0xa4,0x20,0x00,0xf0,0xb7,0xf8,0x00,0x28,0x09,0xd1,0xc4,0x20,0x00,0xf0,0xb2,
0xf8,0x00,0x28,0x04,0xd1,0xe2,0x20,0x00,0xf0,0xad,0xf8,0x00,0x28,0xbd,0xd0,0xa0,0x7a,0x40,0x1c,0xa0,0x72,
0x10,0xbd,0x10,0xb5,0x38,0x49,0x00,0x78,0x40,0x31,0x48,0x72,0x00,0x28,0x1c,0xd0,0x01,0x28,0x1a,0xd0,0x02,
0x28,0x18,0xd0,0x03,0x28,0x16,0xd0,0x04,0x28,0x14,0xd0,0x05,0x28,0x12,0xd0,0x06,0x28,0x10,0xd0,0x08,0x28,
0x0e,0xd0,0x07,0x28,0x0b,0xd1,0x88,0x78,0x08,0x28,0x08,0xd1,0x05,0x20,0x88,0x70,0x29,0x48,0x31,0x49,0x80,
0x30,0xc1,0x64,0x16,0x20,0x00,0xf0,0x9a,0xf9,0x10,0xbd,0x48,0x7c,0x42,0x1c,0x4a,0x74,0x00,0x28,0xf9,0xd1,
0x7d,0x21,0xc9,0x00,0x2b,0x48,0xfd,0xf7,0x3d,0xf9,0x10,0xbd,0x70,0xb5,0x01,0x20,0x00,0xf0,0x74,0xf8,0x1d,
0x4d,0x2c,0x46,0xff,0x35,0x80,0x34,0x41,0x35,0x00,0x28,0x0c,0xd0,0x40,0x78,0xe8,0x72,0x03,0x20,0xa8,0x70,
0x16,0x20,0x00,0xf0,0x7c,0xf9,0x21,0x48,0xe0,0x64,0x08,0x20,0xfd,0xf7,0x17,0xfe,0x70,0xbd,0x02,0x20,0x00,
0xf0,0x5d,0xf8,0x00,0x28,0x03,0xd0,0x40,0x1c,0xff,0xf7,0xb1,0xff,0x03,0xe0,0xe0,0x6a,0x02,0x21,0x08,0x43,
0xe0,0x62,0x0a,0x20,0xa8,0x70,0x0f,0x48,0x40,0x22,0x80,0x30,0x01,0x8b,0x11,0x43,0x01,0x83,0x70,0xbd,0x70,
0xb5,0x08,0x4e,0x80,0x36,0xf0,0x6c,0x00,0x28,0x01,0xd0,0xf0,0x6c,0x80,0x47,0xff,0xf7,0x12,0xfb,0x03,0x49,
0xff,0x20,0x0c,0x68,0x1b,0x30,0x43,0x5a,0x22,0x68,0x1f,0xe0,0x00,0x00,0x9c,0x02,0x00,0x20,0x00,0x01,0x00,
0x20,0x9c,0x03,0x00,0x20,0x00,0x00,0x00,0x20,0xf1,0x28,0x00,0x00,0xdc,0x05,0x00,0x00,0x05,0x32,0x00,0x00,
0xdc,0x39,0x00,0x00,0x33,0x30,0x00,0x00,0x53,0x2d,0x00,0x00,0x9b,0x30,0x00,0x00,0x63,0x30,0x00,0x00,0x25,
0x46,0x18,0x3d,0x28,0x46,0x00,0x2b,0x04,0xd0,0x14,0x46,0x12,0x68,0x8c,0x42,0xf6,0xd1,0x70,0xbd,0xb1,0x6a,
0xc9,0x06,0x04,0xd5,0x01,0x78,0x01,0x29,0x0c,0xd0,0x02,0x29,0x0a,0xd0,0xff,0xf7,0x82,0xfd,0x03,0xcc,0x41,
0x60,0x08,0x60,0x00,0x20,0x08,0x3c,0x20,0x60,0x60,0x60,0x28,0x70,0x70,0xbd,0xff,0xf7,0x97,0xfd,0xf3,0xe7,
0x03,0x46,0x10,0xb5,0x7e,0x48,0x7e,0x4a,0xc0,0x6a,0x2c,0x32,0x01,0x68,0x05,0xe0,0x18,0x38,0x04,0x78,0x9c,
0x42,0x04,0xd0,0x08,0x46,0x09,0x68,0x90,0x42,0xf7,0xd1,0x00,0x20,0x10,0xbd,0x10,0xb5,0x77,0x4c,0x21,0x7f,
0x04,0x29,0x0f,0xd1,0x00,0x78,0xe0,0x73,0xe0,0x7c,0x06,0x28,0x01,0xd9,0x00,0xf0,0x77,0xf9,0xe0,0x7b,0x20,
0x74,0x6f,0x48,0x80,0x38,0x01,0x68,0x6f,0x48,0xc0,0x38,0x01,0x63,0x41,0x63,0x10,0xbd,0x6c,0x49,0x0a,0x7f,
0x31,0x2a,0x12,0xd1,0x82,0x78,0x43,0x78,0x10,0x02,0x0a,0x46,0x20,0x32,0x12,0x78,0x18,0x43,0x92,0x06,0xc0,
0x0b,0x92,0x0e,0x50,0x43,0xc8,0x73,0x63,0x48,0x80,0x38,0x01,0x68,0x63,0x48,0xc0,0x38,0x01,0x63,0x41,0x63,
0x70,0x47,0x10,0xb5,0x60,0x49,0x02,0x78,0x8a,0x73,0x01,0x78,0x5f,0x48,0xc1,0x82,0x01,0x20,0xc0,0x02,0xfd,
0xf7,0x6b,0xfd,0x5d,0x48,0x00,0xf0,0xc8,0xf8,0x10,0xbd,0x10,0xb5,0x03,0x20,0xff,0xf7,0xad,0xff,0x00,0x28,
0x10,0xd0,0x40,0x1c,0xff,0xf7,0xb1,0xfd,0x54,0x48,0x57,0x49,0xc0,0x38,0xc1,0x64,0x40,0x20,0xfd,0xf7,0x64,
0xfd,0xff,0x20,0x01,0x30,0xfd,0xf7,0x53,0xfd,0x4f,0x48,0x08,0x21,0xc1,0x70,0x10,0xbd,0x10,0xb5,0x71,0x20,
0xff,0xf7,0x95,0xff,0x00,0x28,0x03,0xd0,0x40,0x1c,0x00,0xf0,0x2f,0xf8,0x10,0xbd,0x48,0x48,0x04,0x22,0xc0,
0x38,0xc1,0x6a,0x11,0x43,0xc1,0x62,0x0a,0x21,0xc0,0x30,0x81,0x70,0x40,0x20,0xfd,0xf7,0x39,0xfd,0x43,0x48,
0x08,0x22,0x01,0x8b,0x11,0x43,0x01,0x83,0x10,0xbd,0x10,0xb5,0x3e,0x4c,0x60,0x7c,0x03,0x28,0x13,0xd3,0x20,
0x46,0xc0,0x38,0xc1,0x6a,0x01,0x22,0x11,0x43,0xc1,0x62,0x0a,0x20,0xa0,0x70,0x40,0x20,0xfd,0xf7,0x23,0xfd,
0x38,0x48,0x20,0x22,0x01,0x8b,0x11,0x43,0x01,0x83,0x38,0x49,0x39,0x48,0xfd,0xf7,0x28,0xf8,0x00,0x20,0x60,
0x74,0x10,0xbd,0xf8,0xb5,0x01,0x78,0x30,0x4a,0x09,0x07,0x09,0x0f,0x11,0x70,0x83,0x78,0x41,0x78,0x1c,0x02,
0x0c,0x43,0x11,0x46,0x40,0x39,0x2c,0x4b,0x8c,0x87,0x2d,0x27,0x7f,0x02,0x20,0x26,0x80,0x3b,0x80,0x39,0xbc,
0x42,0x2d,0x4d,0x8c,0x6a,0x04,0xd1,0x34,0x43,0x8c,0x62,0xff,0x24,0xf3,0x34,0x03,0xe0,0xb4,0x43,0x8c,0x62,
0xff,0x24,0x85,0x34,0x9c,0x87,0xdd,0x87,0xc3,0x78,0xdb,0x09,0x03,0xd0,0x04,0x23,0x93,0x70,0x24,0x4b,0x02,
0xe0,0x05,0x23,0x93,0x70,0x23,0x4b,0xcb,0x64,0x00,0x78,0x00,0x07,0x05,0xd0,0x40,0x20,0x90,0x71,0x16,0x20,
0x00,0xf0,0x42,0xf8,0xf8,0xbd,0x14,0x20,0xf8,0xe7,0x15,0x48,0xc0,0x38,0xc1,0x6a,0x49,0x08,0x49,0x00,0xc1,
0x62,0x70,0x47,0x10,0xb5,0x81,0x20,0xff,0xf7,0x1e,0xff,0x18,0x4c,0x21,0x46,0xff,0x31,0x41,0x31,0x80,0x34,
0x00,0x28,0x07,0xd0,0x05,0x20,0x88,0x70,0x16,0x20,0x00,0xf0,0x28,0xf8,0x11,0x48,0xe0,0x64,0x10,0xbd,0xe0,
0x6a,0x08,0x22,0x10,0x43,0xe0,0x62,0x0a,0x20,0x88,0x70,0x40,0x20,0xfd,0xf7,0xbc,0xfc,0x04,0x48,0x04,0x22,
0x01,0x8b,0x11,0x43,0x01,0x83,0x10,0xbd,0x80,0x01,0x00,0x20,0xdc,0x03,0x00,0x20,0x80,0x00,0x00,0x20,0xdc,
0x05,0x00,0x00,0x3f,0x2c,0x00,0x00,0x80,0x4f,0x12,0x00,0x43,0x31,0x00,0x00,0xa3,0x02,0x00,0x00,0x51,0x31,
0x00,0x00,0x53,0x2d,0x00,0x00,0x9c,0x02,0x00,0x20,0xf8,0x49,0x0a,0x68,0xf8,0x49,0x0a,0x63,0x88,0x63,0x70,
0x47,0xf6,0x48,0xc0,0x30,0x81,0x78,0x02,0x29,0x0d,0xd0,0x81,0x78,0x03,0x29,0x0c,0xd0,0x81,0x78,0x04,0x29,
0x0b,0xd0,0x81,0x78,0x05,0x29,0x0a,0xd0,0x80,0x78,0x08,0x28,0x09,0xd1,0xef,0x48,0xe6,0xe7,0x14,0x20,0xfc,
0xe7,0x41,0x20,0xfa,0xe7,0x50,0x20,0xf8,0xe7,0xaa,0x20,0xf6,0xe7,0x70,0x47,0x70,0xb5,0xe8,0x4c,0x4b,0x21,
0x80,0x34,0x20,0x89,0x49,0x01,0x25,0x46,0x48,0x43,0x40,0x3d,0x10,0x23,0xff,0x22,0x00,0x0b,0xeb,0x5e,0x69,
0x8a,0x01,0x32,0xfd,0xf7,0xed,0xfa,0xe0,0x80,0x14,0x23,0xeb,0x5e,0xe9,0x8a,0xe0,0x89,0x40,0x22,0xfd,0xf7,
0xe5,0xfa,0xa0,0x81,0x18,0x23,0xeb,0x5e,0x69,0x8b,0x60,0x8a,0x40,0x22,0xfd,0xf7,0xdd,0xfa,0x20,0x82,0xd9,
0x48,0xe3,0x88,0xc3,0x87,0xa0,0x89,0xd7,0x4a,0xc3,0x24,0x40,0x32,0x10,0x80,0x10,0x46,0xa4,0x00,0x80,0x38,
0x00,0x21,0xa3,0x42,0x0b,0xd9,0xc4,0x8f,0xff,0x25,0x64,0x1e,0xa4,0xb2,0xf3,0x35,0xc4,0x87,0xac,0x42,0x00,
0xd2,0xc5,0x87,0x01,0x20,0x90,0x76,0x0c,0xe0,0xcd,0x4c,0xa3,0x42,0x09,0xd2,0xc4,0x8f,0xcb,0x4d,0x64,0x1c,
0xa4,0xb2,0x37,0x3d,0xc4,0x87,0xac,0x42,0x00,0xd9,0xc5,0x87,0x91,0x76,0xaf,0x20,0xc0,0x00,0x83,0x42,0x0e,
0xd9,0xc6,0x48,0x01,0x60,0xc6,0x48,0x01,0x70,0xc6,0x4a,0x11,0x62,0xf0,0x22,0x42,0x77,0xc3,0x48,0x20,0x30,
0x41,0x70,0x10,0x20,0xfd,0xf7,0x23,0xfc,0xfe,0xe7,0x70,0xbd,0xf8,0xb5,0xb9,0x4d,0x7d,0x22,0xc0,0x35,0xa9,
0x7f,0xe8,0x7b,0x49,0x08,0xd2,0x00,0x51,0x43,0x48,0x43,0xc7,0x09,0x28,0x46,0xb6,0x4c,0x40,0x38,0xc6,0x88,
0x40,0x34,0x20,0x88,0x11,0x46,0x70,0x43,0xfd,0xf7,0x2a,0xfb,0x87,0x42,0x4a,0xdc,0x38,0x1a,0x00,0xd5,0x40,
0x42,0xe0,0x81,0xff,0x21,0x27,0x82,0x41,0x31,0x66,0x82,0x8e,0x42,0x40,0xd3,0xa9,0x49,0xff,0x22,0xc0,0x31,
0xc3,0x32,0x89,0x7c,0x96,0x42,0x02,0xd2,0xa2,0x88,0x82,0x42,0x19,0xdb,0xa7,0x4a,0x14,0x32,0x96,0x42,0x02,
0xd2,0xe2,0x88,0x82,0x42,0x12,0xdb,0xa8,0x4a,0x96,0x42,0x02,0xd2,0x22,0x89,0x82,0x42,0x0c,0xdb,0x9f,0x4a,
0x32,0x32,0x96,0x42,0x02,0xd2,0x62,0x89,0x82,0x42,0x05,0xdb,0xa2,0x4a,0x96,0x42,0x09,0xd2,0xa2,0x89,0x82,
0x42,0x06,0xda,0x03,0x29,0x01,0xd9,0x03,0x20,0xa8,0x74,0xa8,0x7c,0x40,0x1c,0x05,0xe0,0x00,0x29,0x01,0xd1,
0x01,0x20,0xa8,0x74,0xa8,0x7c,0x40,0x1e,0xa8,0x74,0xc0,0xb2,0x03,0x28,0x0b,0xd9,0x20,0x20,0xfd,0xf7,0xc8,
0xfb,0x0a,0x20,0xa8,0x70,0x40,0x20,0xfd,0xf7,0xc3,0xfb,0x20,0x8b,0x80,0x21,0x08,0x43,0x20,0x83,0xf8,0xbd,
0xf8,0xb5,0x88,0x4d,0x40,0x35,0x28,0x8c,0x2f,0x46,0x81,0x08,0x80,0x37,0x78,0x78,0x2e,0x46,0x40,0x00,0xc0,
0x3e,0x80,0x19,0xc0,0x30,0xc1,0x85,0x28,0x46,0x06,0x21,0x2e,0x30,0xfd,0xf7,0x13,0xfa,0x83,0xb2,0x2c,0x46,
0x40,0x34,0x00,0x20,0x23,0x81,0xc0,0x43,0x60,0x81,0x00,0x20,0x41,0x00,0x89,0x19,0xc0,0x31,0x62,0x89,0xc9,
0x8d,0x8a,0x42,0x00,0xd2,0x11,0x46,0x40,0x1c,0xc0,0xb2,0x61,0x81,0x06,0x28,0xf2,0xd3,0x88,0xb2,0xc0,0x18,
0x40,0x08,0x20,0x81,0xe8,0x8b,0x81,0x08,0x78,0x78,0x40,0x00,0x80,0x19,0xc0,0x30,0x41,0x84,0x6f,0x48,0x06,
0x21,0x62,0x30,0xfd,0xf7,0xee,0xf9,0xe0,0x81,0xa8,0x8b,0x81,0x08,0x78,0x78,0x40,0x00,0x80,0x19,0xc0,0x30,
0x41,0x87,0x68,0x48,0x06,0x21,0x7a,0x30,0xfd,0xf7,0xe1,0xf9,0x60,0x82,0x78,0x78,0x05,0x28,0x01,0xd2,0x40,
0x1c,0x00,0xe0,0x00,0x20,0x78,0x70,0xff,0xf7,0xf1,0xfe,0xe8,0x8b,0x14,0x23,0xeb,0x5e,0xe9,0x8a,0x80,0x08,
0x40,0x22,0xfd,0xf7,0xe7,0xf9,0xa0,0x81,0x02,0x21,0x65,0x48,0xfc,0xf7,0x70,0xfe,0xf8,0xbd,0x70,0xb5,0x63,
0x4d,0xe8,0x68,0x00,0x04,0x2c,0xd5,0x72,0xb6,0xff,0xf7,0x08,0xfa,0x5c,0x48,0x00,0x24,0x04,0x62,0x54,0x48,
0x0a,0x21,0xc0,0x30,0x81,0x70,0x40,0x20,0xfd,0xf7,0x4f,0xfb,0x53,0x48,0xff,0x22,0x40,0x30,0x01,0x8b,0x01,
0x32,0x11,0x43,0x01,0x83,0x58,0x48,0xfd,0xf7,0x52,0xfb,0x00,0x20,0x81,0x00,0x49,0x19,0x4c,0x61,0x0c,0x63,
0x40,0x1c,0x08,0x28,0xf8,0xdb,0x54,0x48,0x04,0x60,0x54,0x49,0x8c,0x60,0xcc,0x60,0x53,0x48,0x57,0x22,0x42,
0x63,0x01,0x23,0x0b,0x60,0x14,0x21,0x41,0x60,0x02,0x60,0xfe,0xe7,0x70,0xbd,0x40,0x48,0x10,0xb5,0x80,0x38,
0x00,0x60,0x40,0x60,0x12,0x22,0x4c,0x49,0x4d,0x48,0xfd,0xf7,0x35,0xf9,0x4a,0x49,0x3d,0x48,0xa0,0x31,0x10,
0x22,0x0c,0x46,0x00,0x1f,0xfd,0xf7,0x2d,0xf9,0x37,0x49,0x48,0x48,0xc8,0x63,0x48,0x48,0x08,0x64,0x48,0x48,
0x48,0x64,0x48,0x48,0x88,0x64,0x42,0x48,0x34,0x4a,0x20,0x38,0x03,0x88,0x40,0x3a,0x13,0x80,0x83,0x78,0x93,
0x70,0x03,0x79,0x13,0x71,0xc0,0x78,0xd0,0x70,0x10,0x46,0x23,0x8b,0x80,0x30,0x43,0x80,0x63,0x8b,0x83,0x80,
0xa3,0x8b,0xc3,0x80,0xe3,0x8b,0x03,0x81,0x23,0x8c,0x43,0x81,0x63,0x8c,0x83,0x81,0x25,0x48,0x00,0x68,0x08,
0x63,0x39,0x48,0x50,0x81,0x23,0x48,0x0c,0x22,0x38,0x49,0x50,0x30,0xfd,0xf7,0xef,0xf8,0x37,0x48,0xc0,0x8a,
0x2f,0x28,0x07,0xd9,0x3f,0x21,0x09,0x02,0xca,0x8a,0x1d,0x48,0x40,0x30,0x42,0x82,0x89,0x8a,0x01,0x82,0x27,
0x48,0x40,0x30,0x41,0x69,0x8a,0x06,0x18,0x49,0xc0,0x31,0x00,0x2a,0x0c,0xd0,0x42,0x69,0x92,0x06,0x92,0x0e,
0x01,0x2a,0x07,0xd0,0x40,0x69,0x80,0x06,0x80,0x0e,0x02,0x28,0x01,0xd1,0xf0,0x20,0x08,0x75,0x10,0xbd,0xff,
0x20,0xfb,0xe7,0xf8,0xb5,0x01,0x26,0xff,0xf7,0x99,0xff,0x00,0xf0,0x67,0xf9,0x30,0x03,0xfd,0xf7,0xc2,0xfa,
0x0c,0x4c,0x22,0x48,0x25,0x46,0x22,0x4f,0xa0,0x82,0x40,0x3d,0xe8,0x88,0x80,0x06,0x02,0xd5,0xe8,0x89,0xfd,
0xf7,0xc3,0xfa,0xa0,0x8a,0xb8,0x42,0x1d,0x48,0x3b,0xd1,0xfd,0xf7,0x9e,0xf8,0x3c,0xe0,0x00,0x00,0x00,0x01,
0x00,0x20,0x1c,0x03,0x00,0x20,0xdc,0x05,0x00,0x00,0x40,0x00,0x00,0x20,0xda,0x02,0x00,0x00,0x00,0x40,0x00,
0x40,0x20,0x46,0x00,0x40,0x00,0x48,0x00,0x40,0x4c,0x04,0x00,0x00,0xb8,0x0b,0x00,0x00,0x57,0x36,0x00,0x00,
0x00,0x60,0x00,0x40,0xff,0xff,0x00,0x00,0x00,0x52,0x00,0x40,0x00,0x5a,0x00,0x40,0x00,0x58,0x00,0x40,0x20,
0x06,0x00,0x20,0x54,0x02,0x00,0x20,0x98,0xb7,0x00,0x00,0xb0,0x30,0x01,0x00,0xc8,0x26,0x02,0x00,0x10,0x0f,
0x04,0x00,0xf8,0x19,0x00,0x00,0x04,0x3a,0x00,0x00,0x20,0x3f,0x00,0x00,0x55,0x55,0x00,0x00,0x66,0x66,0x00,
0x00,0x88,0x13,0x00,0x00,0xfd,0xf7,0x62,0xf8,0x00,0x2e,0xb5,0xd1,0xcf,0x4d,0x57,0x26,0x6e,0x63,0x1f,0x20,
0x28,0x61,0xce,0x48,0xa0,0x82,0xce,0x49,0x10,0x20,0x08,0x61,0xcd,0x49,0x01,0x20,0xc8,0x60,0xff,0xf7,0x02,
0xff,0xcb,0x48,0x40,0x38,0x01,0x69,0x82,0x15,0x11,0x43,0x01,0x61,0x6e,0x63,0x59,0x20,0xa8,0x60,0xc7,0x49,
0xc8,0x48,0xfc,0xf7,0x64,0xfd,0xf8,0xbd,0xc7,0x48,0x01,0x68,0x80,0x22,0x11,0x43,0x01,0x60,0x70,0x47,0xf8,
0xb5,0xc0,0x48,0x40,0x38,0xc0,0x68,0x00,0x04,0x02,0xd5,0x80,0x20,0xfd,0xf7,0x46,0xfa,0xff,0xf7,0xe3,0xfe,
0xb8,0x49,0x59,0x20,0xc8,0x60,0xbe,0x4d,0xa8,0x89,0xbe,0x4f,0x80,0x06,0x3c,0x46,0xff,0x34,0xff,0x37,0x41,
0x34,0x01,0x37,0x00,0x28,0x0f,0xda,0xf8,0x8f,0xba,0x49,0x40,0x1c,0x80,0xb2,0xf8,0x87,0x88,0x42,0x06,0xd9,
0x00,0x20,0xf8,0x87,0xa8,0x89,0x20,0x21,0x88,0x43,0xa8,0x81,0x01,0xe0,0x0a,0x20,0xa0,0x70,0xe8,0x88,0xb0,
0x4e,0x80,0x06,0x80,0x36,0x00,0x28,0x03,0xda,0xe8,0x89,0xfd,0xf7,0x2a,0xfa,0x19,0xe0,0xe8,0x88,0x40,0x06,
0x0a,0xd5,0x28,0x89,0xac,0x49,0x88,0x42,0x06,0xd1,0x00,0x20,0x28,0x81,0xa4,0x49,0xaa,0x48,0xfc,0xf7,0x1d,
0xfd,0x0b,0xe0,0xe8,0x88,0x80,0x05,0x08,0xd5,0x70,0x88,0x19,0x21,0xff,0x38,0x91,0x38,0xfd,0xf7,0x23,0xf9,
0xa5,0x49,0x40,0x1e,0x08,0x73,0x9e,0x48,0xc1,0x88,0x40,0x22,0x11,0x40,0xc1,0x80,0x9d,0x4d,0x80,0x35,0xa8,
0x6a,0x00,0x07,0x3d,0xd4,0xa0,0x78,0x0a,0x28,0x3b,0xd0,0x9e,0x48,0x00,0x68,0x29,0x6b,0x40,0x1a,0xff,0x21,
0x91,0x31,0x88,0x42,0x0e,0xd9,0xa0,0x7d,0x40,0x1c,0xc0,0xb2,0xa0,0x75,0x14,0x28,0x08,0xd9,0xb0,0x7e,0x00,
0x28,0x03,0xd0,0x02,0x21,0x96,0x48,0xfc,0xf7,0xee,0xfc,0x00,0x20,0xa0,0x75,0x92,0x48,0x01,0x68,0x2a,0x6b,
0xab,0x6b,0x89,0x1a,0x92,0x4a,0x99,0x42,0x04,0xd8,0x01,0x68,0x6b,0x6b,0xc9,0x1a,0x91,0x42,0x16,0xd9,0xa3,
0x78,0x01,0x21,0x49,0x02,0x00,0x2b,0x23,0xd0,0x01,0x2b,0x32,0xd0,0xa3,0x78,0x08,0x2b,0x5a,0xd0,0xe8,0x6a,
0x80,0x21,0x08,0x43,0x88,0x49,0x08,0x40,0xe8,0x62,0x0a,0x20,0xa0,0x70,0x30,0x8b,0x01,0x21,0xc9,0x02,0x08,
0x43,0x30,0x83,0xf8,0xbd,0xff,0xf7,0x66,0xf8,0x83,0x49,0xf0,0x20,0x48,0x77,0x81,0x49,0x00,0x20,0x20,0x31,
0x48,0x70,0x08,0x20,0xfd,0xf7,0xba,0xf9,0xff,0x20,0x01,0x30,0xfd,0xf7,0xb6,0xf9,0xf8,0xbd,0xe8,0x6a,0x02,
0x05,0x92,0x0f,0x03,0xd1,0xc2,0x04,0x01,0xd4,0x40,0x04,0x04,0xd5,0x0a,0x20,0xa0,0x70,0x30,0x8b,0x08,0x43,
0x30,0x83,0x01,0x20,0xa0,0x70,0x1e,0x20,0x27,0xe0,0x69,0x48,0xb9,0x89,0x40,0x30,0x42,0x89,0x91,0x42,0x09,
0xd9,0xa0,0x78,0x01,0x21,0x49,0x04,0x40,0x18,0xa0,0x70,0x0a,0x20,0xa0,0x70,0x30,0x8b,0xc9,0x11,0xca,0xe7,
0x6c,0x49,0xe9,0x64,0xa9,0x6a,0x49,0x07,0x0f,0xd4,0x00,0x88,0xb8,0x82,0x10,0x20,0x60,0x71,0x5c,0x48,0x68,
0x49,0xc1,0x87,0x31,0x8b,0x01,0x20,0xc0,0x02,0x81,0x43,0x31,0x83,0x05,0x21,0x65,0x48,0xfc,0xf7,0x80,0xfc,
0x02,0x20,0xa0,0x70,0x5a,0x20,0xff,0xf7,0xcd,0xfc,0xf8,0xbd,0x00,0x68,0x6b,0x6b,0xc0,0x1a,0x90,0x42,0xe8,
0x6a,0x01,0xd8,0xff,0x21,0x01,0x31,0x08,0x43,0xe8,0x62,0x40,0x20,0xfd,0xf7,0x5f,0xf9,0x9c,0xe7,0x10,0xb5,
0x5a,0x49,0xee,0x20,0x88,0x60,0x46,0x48,0x02,0x21,0x40,0x38,0x81,0x63,0x01,0x63,0x00,0x24,0x04,0x62,0xc1,
0x61,0x41,0x63,0x02,0x69,0x43,0x15,0x1a,0x43,0x02,0x61,0x02,0x69,0x83,0x15,0x9a,0x43,0x02,0x61,0x4e,0x48,
0x4b,0x4a,0x60,0x30,0x20,0x3a,0x50,0x62,0x49,0x48,0x20,0x30,0x01,0x71,0x04,0x72,0x44,0x72,0x44,0x74,0x04,
0x75,0x46,0x48,0x44,0x77,0x19,0x21,0x01,0x70,0x1f,0x21,0x01,0x76,0x00,0xf0,0x30,0xf8,0xfe,0xf7,0x25,0xfe,
0x37,0x48,0x19,0x21,0x80,0x30,0x40,0x88,0xff,0x38,0x91,0x38,0xfd,0xf7,0x49,0xf8,0x38,0x49,0x40,0x1e,0x08,
0x73,0x36,0x48,0x27,0x21,0x20,0x38,0x01,0x62,0xc4,0x63,0xc8,0x21,0x41,0x62,0x33,0x49,0x08,0x22,0x20,0x31,
0x0a,0x75,0x03,0x22,0x12,0x02,0x4a,0x62,0x2f,0x4b,0x17,0x22,0x40,0x33,0x1a,0x70,0x0b,0x7c,0x01,0x22,0x13,
0x43,0x0b,0x74,0x41,0x68,0x14,0x23,0x19,0x43,0x41,0x60,0x01,0x68,0x11,0x43,0x01,0x60,0x33,0x49,0x31,0x48,
0x08,0x60,0x32,0x49,0x08,0x60,0x10,0xbd,0x10,0xb5,0x1e,0x48,0x00,0x22,0x02,0x60,0x19,0x49,0x0b,0x6a,0x44,
0x15,0x23,0x43,0x0b,0x62,0xff,0x23,0x1a,0x49,0x05,0x33,0x40,0x31,0x4b,0x61,0x2b,0x4b,0x0b,0x60,0x42,0x60,
0x07,0x23,0x83,0x60,0x02,0x61,0x10,0x22,0x42,0x61,0x0f,0x22,0x82,0x61,0x4b,0x60,0x43,0x22,0x8a,0x60,0x25,
0x49,0x0a,0x68,0x08,0x23,0x1a,0x43,0x0a,0x60,0x24,0x49,0x0a,0x68,0x01,0x23,0x1a,0x43,0x0a,0x60,0x2f,0x22,
0x0a,0x62,0x0b,0x4a,0x0c,0x32,0x8a,0x62,0x0c,0x4a,0xdc,0x32,0xca,0x62,0x02,0x22,0x4a,0x62,0xb3,0x21,0x01,
0x60,0x10,0xbd,0x00,0x00,0x00,0x58,0x00,0x40,0x77,0x77,0x00,0x00,0x80,0x5c,0x00,0x40,0x40,0x60,0x00,0x40,
0xff,0xff,0xff,0x7f,0x63,0x36,0x00,0x00,0x00,0x4a,0x00,0x40,0x00,0x00,0x00,0x20,0x9c,0x02,0x00,0x20,0x60,
0xea,0x00,0x00,0x25,0x57,0x00,0x00,0x97,0x01,0x00,0x00,0x20,0x48,0x00,0x40,0x00,0x01,0x00,0x20,0xf1,0x28,
0x00,0x00,0xd8,0x59,0x00,0x00,0xfe,0xcb,0xff,0xff,0x20,0x46,0x00,0x40,0xa5,0x2e,0x00,0x00,0xa3,0x02,0x00,
0x00,0xd9,0x27,0x00,0x00,0x00,0x5a,0x00,0x40,0x01,0x70,0x04,0x00,0x80,0xe2,0x00,0xe0,0x00,0xe1,0x00,0xe0,
0x07,0x30,0x00,0x00,0x00,0x52,0x00,0x40,0x00,0x50,0x00,0x40,0x98,0xb7,0x00,0x00,0xb0,0x30,0x01,0x00,0xc8,
0x26,0x02,0x00,0x10,0x0f,0x04,0x00,0x03,0x00,0x00,0x00,0xa7,0x2b,0x00,0x00,0x04,0x00,0x00,0x00,0xb9,0x2f,
0x00,0x00,0x31,0x00,0x00,0x00,0xe5,0x2f,0x00,0x00,0x05,0x00,0x00,0x00,0x15,0x30,0x00,0x00,0x02,0x00,0x00,
0x00,0x47,0x2e,0x00,0x00,0xf8,0xff,0x1a,0x01,0x81,0x00,0x9f,0x01,0x35,0x00,0xa3,0x01,
};

const u8 mt5725_pgm_bin[] ={
0x00,0x18,0x00,0x20,0xe7,0x01,0x00,0x00,0x8d,0x00,0x00,0x00,0x8f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x91,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x93,0x00,0x00,0x00,0x95,0x00,0x00,
0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,
0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,
0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,
0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0xfe,0xe7,0xfe,0xe7,0xfe,0xe7,0xfe,
0xe7,0xfe,0xe7,0x00,0x00,0xc0,0x46,0xc0,0x46,0x00,0xf0,0x04,0xf8,0x1f,0xb5,0x1f,0xbd,0x10,0xb5,0x10,0xbd,
0x00,0xf0,0xc6,0xf9,0x11,0x46,0xff,0xf7,0xf7,0xff,0x00,0xf0,0x98,0xf8,0x00,0xf0,0xde,0xf9,0x03,0xb4,0xff,
0xf7,0xf2,0xff,0x03,0xbc,0x00,0xf0,0x01,0xfa,0x00,0x00,0x01,0xb5,0x00,0xe0,0x00,0xbf,0x00,0x98,0x41,0x1e,
0x00,0x91,0xfa,0xd2,0x08,0xbd,0x03,0xe0,0x0b,0x78,0x03,0x70,0x40,0x1c,0x49,0x1c,0x52,0x1e,0xf9,0xd2,0x70,
0x47,0x00,0xe0,0x02,0xc0,0x52,0x1e,0xfc,0xd2,0x70,0x47,0x02,0x46,0x00,0x20,0x02,0xe0,0x13,0x78,0x58,0x40,
0x52,0x1c,0x49,0x1e,0xfa,0xd2,0x70,0x47,0x30,0xb5,0xc1,0x4c,0x12,0x23,0x63,0x72,0xc0,0x4c,0x00,0x23,0x63,
0x62,0x93,0x07,0x92,0x08,0x00,0x2b,0x00,0xd0,0x52,0x1c,0x00,0x23,0x01,0x24,0x24,0x07,0x05,0xe0,0x9d,0x00,
0x2d,0x18,0x2d,0x19,0x2d,0x68,0x5b,0x1c,0x20,0xc1,0x93,0x42,0xf7,0xd3,0x30,0xbd,0xf7,0xb5,0x8e,0x46,0x02,
0x25,0x91,0x07,0x90,0x08,0x81,0xb0,0x00,0x29,0x00,0xd0,0x40,0x1c,0x84,0x46,0xb0,0x48,0x00,0x21,0x20,0x38,
0xc1,0x62,0x0e,0x46,0xae,0x4a,0x38,0xe0,0x01,0x98,0xb1,0x00,0x08,0x18,0x01,0x21,0x09,0x07,0x40,0x18,0xa9,
0x49,0x12,0x23,0x4b,0x72,0x0f,0x27,0x57,0x62,0x71,0x46,0x08,0xc9,0x04,0x68,0x8e,0x46,0x9c,0x42,0x26,0xd0,
0x21,0x46,0x99,0x43,0x01,0xd0,0x20,0x25,0x24,0xe0,0x04,0x21,0x51,0x62,0x5c,0x40,0x1c,0x40,0x04,0x60,0x00,
0x24,0x00,0x94,0x08,0x21,0x51,0x62,0x04,0x68,0x9c,0x42,0x12,0xd0,0x9b,0x49,0x42,0x27,0x4f,0x72,0x04,0x27,
0x57,0x62,0x5c,0x40,0x1c,0x40,0x04,0x60,0x0f,0x21,0x51,0x62,0x01,0x68,0x99,0x42,0x05,0xd0,0x00,0x99,0x49,
0x1c,0x00,0x91,0x0a,0x29,0xe8,0xd3,0xde,0xe7,0x00,0x98,0x0a,0x28,0xdb,0xd2,0x76,0x1c,0x66,0x45,0xc4,0xd3,
0x8f,0x48,0x01,0x21,0x20,0x38,0xc1,0x62,0x02,0x15,0x00,0x21,0x8e,0x48,0xff,0xf7,0x84,0xff,0x28,0x46,0x04,
0xb0,0xf0,0xbd,0x08,0xb5,0x72,0xb6,0x8b,0x48,0x57,0x24,0x44,0x63,0x95,0x21,0x81,0x60,0x86,0x48,0x00,0x22,
0x02,0x60,0x88,0x49,0x41,0x60,0x30,0x21,0x01,0x62,0x04,0x21,0x41,0x62,0x03,0x21,0x81,0x62,0x7d,0x20,0x00,
0x01,0xff,0xf7,0x5b,0xff,0x7e,0x48,0x20,0x30,0x44,0x60,0x7c,0x48,0x20,0x38,0x42,0x62,0x80,0x48,0x80,0x49,
0x82,0x08,0x80,0x48,0xff,0xf7,0x5f,0xff,0x80,0x48,0x00,0x21,0x00,0x04,0x82,0x0c,0x7f,0x48,0xff,0xf7,0x58,
0xff,0x76,0x4c,0x7e,0x48,0x08,0x3c,0xa0,0x60,0x20,0x25,0x20,0x46,0x08,0x30,0x00,0x90,0x20,0x88,0x01,0x28,
0x36,0xd0,0x20,0x88,0x08,0x28,0x52,0xd0,0x20,0x88,0x40,0x28,0x67,0xd0,0x20,0x88,0x80,0x28,0x76,0xd0,0x20,
0x88,0xc1,0x1f,0xf9,0x39,0x16,0xd0,0x20,0x88,0xc1,0x1f,0xff,0x39,0xfa,0x39,0xea,0xd1,0x00,0x27,0x27,0x80,
0x67,0x80,0x01,0x20,0x80,0x02,0xa0,0x80,0x63,0x49,0x04,0x20,0x20,0x39,0x48,0x62,0x3e,0x46,0xa2,0x88,0x60,
0x88,0x00,0x99,0xff,0xf7,0x39,0xff,0x00,0x20,0xb1,0xe0,0x00,0x20,0x20,0x80,0x60,0x80,0x01,0x20,0x80,0x02,
0xa0,0x80,0x5a,0x49,0x02,0x20,0x20,0x39,0x48,0x62,0x00,0x26,0x87,0x07,0xa2,0x88,0x60,0x88,0x00,0x99,0xff,
0xf7,0x26,0xff,0x00,0x20,0x87,0xe0,0x61,0x88,0x00,0x9a,0xa0,0x88,0x08,0x18,0x81,0xb2,0x00,0x20,0x03,0xe0,
0x13,0x5c,0x59,0x18,0x89,0xb2,0x40,0x1c,0xa3,0x88,0x83,0x42,0xf8,0xdc,0xe0,0x88,0x88,0x42,0x01,0xd0,0x04,
0x20,0x09,0xe0,0xa0,0x88,0x00,0x28,0x05,0xd0,0xa2,0x88,0x60,0x88,0x00,0x99,0xff,0xf7,0x22,0xff,0x00,0xe0,
0x02,0x20,0x20,0x80,0xa6,0xe7,0xa0,0x88,0x00,0x9f,0x00,0x26,0x82,0x08,0x31,0x46,0x38,0x46,0xff,0xf7,0xef,
0xfe,0xa2,0x88,0x60,0x88,0x00,0x99,0xff,0xf7,0xf8,0xfe,0x00,0x20,0x03,0xe0,0x39,0x5c,0x89,0x19,0x8e,0xb2,
0x40,0x1c,0xa1,0x88,0x81,0x42,0xf8,0xdc,0xe6,0x80,0xe4,0xe7,0x00,0x27,0x27,0x80,0x67,0x80,0x01,0x20,0x80,
0x02,0xa0,0x80,0x35,0x48,0x08,0x21,0x20,0x38,0x41,0x62,0x3e,0x46,0xa2,0x88,0x60,0x88,0x00,0x99,0xff,0xf7,
0xdd,0xfe,0x00,0x20,0x08,0xe0,0x14,0xe0,0x81,0x00,0x09,0x19,0x89,0x68,0x49,0x1c,0x01,0xd0,0x25,0x80,0xfe,
0xe7,0x40,0x1c,0xa1,0x88,0x89,0x08,0x81,0x42,0xf3,0xdc,0x76,0x1c,0x10,0x2e,0xe8,0xdb,0x02,0x20,0x20,0x80,
0x26,0x48,0x20,0x38,0x47,0x62,0x66,0xe7,0x00,0x27,0x27,0x80,0x67,0x80,0x01,0x20,0x80,0x02,0xa0,0x80,0x21,
0x48,0x20,0x38,0x45,0x62,0x3e,0x46,0xa2,0x88,0x60,0x88,0x00,0x99,0xff,0xf7,0xb6,0xfe,0x00,0x20,0x07,0xe0,
0x81,0x00,0x09,0x19,0x89,0x68,0x00,0x29,0x01,0xd0,0x25,0x80,0xfe,0xe7,0x40,0x1c,0xa1,0x88,0x89,0x08,0x81,
0x42,0xf3,0xdc,0x76,0x1c,0x10,0x2e,0xe9,0xdb,0xd8,0xe7,0x81,0x00,0x09,0x19,0x89,0x68,0xb9,0x42,0x01,0xd0,
0x25,0x80,0xfe,0xe7,0x40,0x1c,0xa1,0x88,0x89,0x08,0x81,0x42,0xf3,0xdc,0x76,0x1c,0x10,0x2e,0x00,0xda,0x68,
0xe7,0x02,0x20,0x20,0x80,0x0a,0x49,0x00,0x20,0x20,0x39,0x48,0x62,0x2e,0xe7,0x81,0x00,0x09,0x19,0x89,0x68,
0x49,0x1c,0x01,0xd0,0x25,0x80,0xfe,0xe7,0x40,0x1c,0xa1,0x88,0x89,0x08,0x81,0x42,0xf3,0xdc,0x76,0x1c,0x10,
0x2e,0x00,0xda,0x3e,0xe7,0xb0,0xe7,0x20,0x52,0x00,0x40,0x00,0x5a,0x00,0x40,0x08,0x00,0x00,0x20,0x00,0x58,
0x00,0x40,0x01,0x06,0x00,0x00,0x00,0x01,0x00,0x00,0xef,0xbe,0xad,0xde,0x00,0x17,0x00,0x20,0x68,0x10,0x00,
0x20,0x00,0x00,0x00,0x20,0x25,0x57,0x25,0x57,0x75,0x46,0x00,0xf0,0x25,0xf8,0xae,0x46,0x05,0x00,0x69,0x46,
0x53,0x46,0xc0,0x08,0xc0,0x00,0x85,0x46,0x18,0xb0,0x20,0xb5,0x00,0xf0,0x1e,0xf8,0x60,0xbc,0x00,0x27,0x49,
0x08,0xb6,0x46,0x00,0x26,0xc0,0xc5,0xc0,0xc5,0xc0,0xc5,0xc0,0xc5,0xc0,0xc5,0xc0,0xc5,0xc0,0xc5,0xc0,0xc5,
0x40,0x3d,0x49,0x00,0x8d,0x46,0x70,0x47,0x10,0xb5,0x04,0x46,0xc0,0x46,0xc0,0x46,0x20,0x46,0xff,0xf7,0x1b,
0xfe,0x10,0xbd,0x00,0x00,0x00,0x48,0x70,0x47,0x08,0x10,0x00,0x20,0x00,0xb5,0x85,0xb0,0x69,0x46,0x01,0xaa,
0x09,0x48,0x0a,0x60,0xab,0xbe,0x01,0x98,0x00,0x28,0x03,0xd1,0x05,0x48,0x07,0x21,0x40,0x18,0x88,0x43,0x03,
0x99,0x02,0x9a,0x04,0x9b,0x05,0xb0,0x00,0xbd,0x00,0xbf,0x0d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x16,0x00,
0x00,0x00,0x70,0x47,0x00,0x00,0x01,0x49,0x18,0x20,0xab,0xbe,0xfe,0xe7,0x26,0x00,0x02,0x00,
};

#endif
