/*
 * Copyright (c) 2015-2016 MediaTek Inc.
 * Author: Honghui Zhang <honghui.zhang@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef _DTS_IOMMU_PORT_MT6763_H_
#define _DTS_IOMMU_PORT_MT6763_H_

#define MTK_IOMMU_LARB0_PORT_NUM 10
#define MTK_IOMMU_LARB1_PORT_NUM 10
#define MTK_IOMMU_LARB2_PORT_NUM 18
#define MTK_IOMMU_LARB3_PORT_NUM 11

#define MTK_IOMMU_LARB_NR 4

#define MTK_IOMMU_LARB0_PORT(port) (port)
#define MTK_IOMMU_LARB1_PORT(port)                                             \
	(port + MTK_IOMMU_LARB0_PORT(MTK_IOMMU_LARB0_PORT_NUM))
#define MTK_IOMMU_LARB2_PORT(port)                                             \
	(port + MTK_IOMMU_LARB1_PORT(MTK_IOMMU_LARB1_PORT_NUM))
#define MTK_IOMMU_LARB3_PORT(port)                                             \
	(port + MTK_IOMMU_LARB2_PORT(MTK_IOMMU_LARB2_PORT_NUM))

/* larb0 */
#define M4U_PORT_DISP_OVL0 MTK_IOMMU_LARB0_PORT(0)
#define M4U_PORT_DISP_2L_OVL0_LARB0 MTK_IOMMU_LARB0_PORT(1)
#define M4U_PORT_DISP_2L_OVL1_LARB0 MTK_IOMMU_LARB0_PORT(2)
#define M4U_PORT_DISP_RDMA0 MTK_IOMMU_LARB0_PORT(3)
#define M4U_PORT_DISP_RDMA1 MTK_IOMMU_LARB0_PORT(4)
#define M4U_PORT_DISP_WDMA0 MTK_IOMMU_LARB0_PORT(5)
#define M4U_PORT_MDP_RDMA0 MTK_IOMMU_LARB0_PORT(6)
#define M4U_PORT_MDP_WROT0 MTK_IOMMU_LARB0_PORT(7)
#define M4U_PORT_MDP_WDMA0 MTK_IOMMU_LARB0_PORT(8)
#define M4U_PORT_DISP_FAKE0 MTK_IOMMU_LARB0_PORT(9)

#define M4U_PORT_CAM_IMGI MTK_IOMMU_LARB1_PORT(0)
#define M4U_PORT_CAM_IMG2O MTK_IOMMU_LARB1_PORT(1)
#define M4U_PORT_CAM_IMG3O MTK_IOMMU_LARB1_PORT(2)
#define M4U_PORT_CAM_VIPI MTK_IOMMU_LARB1_PORT(3)
#define M4U_PORT_CAM_LCEI MTK_IOMMU_LARB1_PORT(4)
#define M4U_PORT_CAM_FD_RP MTK_IOMMU_LARB1_PORT(5)
#define M4U_PORT_CAM_FD_WR MTK_IOMMU_LARB1_PORT(6)
#define M4U_PORT_CAM_FD_RB MTK_IOMMU_LARB1_PORT(7)
#define M4U_PORT_CAM_DPE_RDMA MTK_IOMMU_LARB1_PORT(8)
#define M4U_PORT_CAM_DPE_WDMA MTK_IOMMU_LARB1_PORT(9)

#define M4U_PORT_CAM_IMGO MTK_IOMMU_LARB2_PORT(0)
#define M4U_PORT_CAM_RRZO MTK_IOMMU_LARB2_PORT(1)
#define M4U_PORT_CAM_AAO MTK_IOMMU_LARB2_PORT(2)
#define M4U_PORT_CAM_AFO MTK_IOMMU_LARB2_PORT(3)
#define M4U_PORT_CAM_LSCI_0 MTK_IOMMU_LARB2_PORT(4)
#define M4U_PORT_CAM_LSC3I MTK_IOMMU_LARB2_PORT(5)
#define M4U_PORT_CAM_RSSO MTK_IOMMU_LARB2_PORT(6)
#define M4U_PORT_CAM_SV0 MTK_IOMMU_LARB2_PORT(7)
#define M4U_PORT_CAM_SV1 MTK_IOMMU_LARB2_PORT(8)
#define M4U_PORT_CAM_SV2 MTK_IOMMU_LARB2_PORT(9)
#define M4U_PORT_CAM_LCSO MTK_IOMMU_LARB2_PORT(10)
#define M4U_PORT_CAM_UFEO MTK_IOMMU_LARB2_PORT(11)
#define M4U_PORT_CAM_BPCI MTK_IOMMU_LARB2_PORT(12)
#define M4U_PORT_CAM_PDO MTK_IOMMU_LARB2_PORT(13)
#define M4U_PORT_CAM_RAWI MTK_IOMMU_LARB2_PORT(14)
#define M4U_PORT_CAM_CCUI MTK_IOMMU_LARB2_PORT(15)
#define M4U_PORT_CAM_CCUO MTK_IOMMU_LARB2_PORT(16)
#define M4U_PORT_CAM_CCUG MTK_IOMMU_LARB2_PORT(17)

#define M4U_PORT_VENC_RCPU MTK_IOMMU_LARB3_PORT(0)
#define M4U_PORT_VENC_REC MTK_IOMMU_LARB3_PORT(1)
#define M4U_PORT_VENC_BSDMA MTK_IOMMU_LARB3_PORT(2)
#define M4U_PORT_VENC_SV_COMV MTK_IOMMU_LARB3_PORT(3)
#define M4U_PORT_VENC_RD_COMV MTK_IOMMU_LARB3_PORT(4)
#define M4U_PORT_JPGENC_RDMA MTK_IOMMU_LARB3_PORT(5)
#define M4U_PORT_JPGENC_BSDMA MTK_IOMMU_LARB3_PORT(6)
#define M4U_PORT_VENC_CUR_LUMA MTK_IOMMU_LARB3_PORT(7)
#define M4U_PORT_VENC_CUR_CHROMA MTK_IOMMU_LARB3_PORT(8)
#define M4U_PORT_VENC_REF_LUMA MTK_IOMMU_LARB3_PORT(9)
#define M4U_PORT_VENC_REF_CHROMA MTK_IOMMU_LARB3_PORT(10)

#endif
