/*
 * Copyright (C) 2015 MediaTek Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 * If not, see <http://www.gnu.org/licenses/>.
 */

/*******************************************************************
 *
 * Filename:
 * ---------
 *  mt_sco_analog_type.h
 *
 * Project:
 * --------
 *   MT6583  Audio Driver Kernel Function
 *
 * Description:
 * ------------
 *   Audio register
 *
 * Author:
 * -------
 * Chipeng Chang
 *
 *-------------------------------------------------------------------
 *
 *
 ******************************************************************/

#ifndef _AUDIO_ANALOG_TYPE_H
#define _AUDIO_ANALOG_TYPE_H

/***************************************************************************
 *                ENUM DEFINITION
 ***************************************************************************/

enum audio_analog_volume_type {
	AUDIO_ANALOG_VOLUME_HSOUTL = 0,
	AUDIO_ANALOG_VOLUME_HSOUTR,
	AUDIO_ANALOG_VOLUME_HPOUTL,
	AUDIO_ANALOG_VOLUME_HPOUTR,
	AUDIO_ANALOG_VOLUME_SPKL,
	AUDIO_ANALOG_VOLUME_SPKR,
	AUDIO_ANALOG_VOLUME_SPEAKER_HEADSET_R,
	AUDIO_ANALOG_VOLUME_SPEAKER_HEADSET_L,
	AUDIO_ANALOG_VOLUME_IV_BUFFER,
	AUDIO_ANALOG_VOLUME_LINEOUTL,
	AUDIO_ANALOG_VOLUME_LINEOUTR,
	AUDIO_ANALOG_VOLUME_LINEINL,
	AUDIO_ANALOG_VOLUME_LINEINR,
	AUDIO_ANALOG_VOLUME_MICAMP1,
	AUDIO_ANALOG_VOLUME_MICAMP2,
	AUDIO_ANALOG_VOLUME_MICAMP3,
	AUDIO_ANALOG_VOLUME_MICAMP4,
	AUDIO_ANALOG_VOLUME_LEVELSHIFTL,
	AUDIO_ANALOG_VOLUME_LEVELSHIFTR,
	AUDIO_ANALOG_VOLUME_TYPE_MAX
};

/* mux seleciotn */
enum audio_analog_mux_type {
	AUDIO_ANALOG_MUX_VOICE = 0,
	AUDIO_ANALOG_MUX_AUDIO,
	AUDIO_ANALOG_MUX_IV_BUFFER,
	AUDIO_ANALOG_MUX_LINEIN_STEREO,
	AUDIO_ANALOG_MUX_LINEIN_L,
	AUDIO_ANALOG_MUX_LINEIN_R,
	AUDIO_ANALOG_MUX_LINEIN_AUDIO_MONO,
	AUDIO_ANALOG_MUX_LINEIN_AUDIO_STEREO,
	AUDIO_ANALOG_MUX_IN_LINE_IN,
	AUDIO_ANALOG_MUX_IN_PREAMP_1,
	AUDIO_ANALOG_MUX_IN_PREAMP_2,
	AUDIO_ANALOG_MUX_IN_PREAMP_3,
	AUDIO_ANALOG_MUX_IN_PREAMP_4,
	AUDIO_MICSOURCE_MUX_IN_1,
	AUDIO_MICSOURCE_MUX_IN_2,
	AUDIO_MICSOURCE_MUX_IN_3,
	AUDIO_MICSOURCE_MUX_IN_4,
	AUDIO_UL1_LCH_MUX,
	AUDIO_UL1_RCH_MUX,
	AUDIO_UL2_LCH_MUX,
	AUDIO_UL2_RCH_MUX,
	AUDIO_ANALOG_MAX_MUX_TYPE
};

/* device power */
enum audio_analog_device_type {
	AUDIO_ANALOG_DEVICE_OUT_EARPIECER = 0,
	AUDIO_ANALOG_DEVICE_OUT_EARPIECEL = 1,
	AUDIO_ANALOG_DEVICE_OUT_HEADSETR = 2,
	AUDIO_ANALOG_DEVICE_OUT_HEADSETL = 3,
	AUDIO_ANALOG_DEVICE_OUT_SPEAKERR = 4,
	AUDIO_ANALOG_DEVICE_OUT_SPEAKERL = 5,
	AUDIO_ANALOG_DEVICE_OUT_SPEAKER_HEADSET_R = 6,
	AUDIO_ANALOG_DEVICE_OUT_SPEAKER_HEADSET_L = 7,
	AUDIO_ANALOG_DEVICE_OUT_LINEOUTR = 8,
	AUDIO_ANALOG_DEVICE_OUT_LINEOUTL = 9,
	AUDIO_ANALOG_DEVICE_OUT_EXTSPKAMP = 10,
	AUDIO_ANALOG_DEVICE_2IN1_SPK = 11,
	/* DEVICE_IN_LINEINR = 11, */
	/* DEVICE_IN_LINEINL = 12, */
	AUDIO_ANALOG_DEVICE_IN_ADC1 = 13,
	AUDIO_ANALOG_DEVICE_IN_ADC2 = 14,
	AUDIO_ANALOG_DEVICE_IN_ADC3 = 15,
	AUDIO_ANALOG_DEVICE_IN_ADC4 = 16,
	AUDIO_ANALOG_DEVICE_IN_DMIC0 = 17,
	AUDIO_ANALOG_DEVICE_IN_DMIC1 = 18,
	AUDIO_ANALOG_DEVICE_IN_DMIC2 = 19,
	AUDIO_ANALOG_DEVICE_RECEIVER_SPEAKER_SWITCH = 20,
	AUDIO_ANALOG_DEVICE_MAX
};

/* Codec tx/rx interface */
enum AUDIO_DAI_INTERFACE {
	AUDIO_DAI_DL1,
	AUDIO_DAI_DL2,
	AUDIO_DAI_UL1,
	AUDIO_DAI_UL2,
	AUDIO_DAI_INTERFACE_MAX
};

/* Audio Analog Mic Source */
enum audio_analog_mic_source {
	AUDIO_AMIC_AIN0, /* Main mic */
	AUDIO_AMIC_AIN1, /* Headset mic */
	AUDIO_AMIC_AIN2, /* Ref mic */
	AUDIO_AMIC_AIN3, /* Headset mic 2*/
	AUDIO_AMIC_AIN4, /* Error mic */
	AUDIO_AMIC_AIN5, /* 5-th mic for demo phone*/
	AUDIO_AMIC_AIN6, /* 4-th mic for demo phone*/
	AUDIO_AMIC_SOURCE_MAX
};

/* Audio Digital UL array type*/
enum audio_analog_uplink_array_type {
	AUDIO_UL_ARRAY_ADC1,
	AUDIO_UL_ARRAY_ADC2,
	AUDIO_UL_ARRAY_ADC3,
	AUDIO_UL_ARRAY_ADC4,
	AUDIO_UL_ARRAY_DMIC0_LCH,
	AUDIO_UL_ARRAY_DMIC1_LCH,
	AUDIO_UL_ARRAY_DMIC1_RCH,
	AUDIO_UL_ARRAY_DMIC2_LCH,
	AUDIO_UL_ARRAY_DMIC2_RCH,
	AUDIO_UL_ARRAY_MAX_TYPE
};

enum audio_analog_device_type_setting {
	AUDIO_ANALOG_DEVICE_PLATFORM_MACHINE,
	AUDIO_ANALOG_DEVICE_PLATFORM,
	AUDIO_ANALOG_DEVICE_MACHINE,
	AUDIO_ANALOG_DEVICE_TYPE_SETTING_MAX
};

enum audio_analog_zcd {
	AUDIO_ANALOG_ZCD_HEADPHONE = 1,
	AUDIO_ANALOG_ZCD_HANDSET = 2,
	AUDIO_ANALOG_ZCD_IVBUFFER = 3,
};

enum audio_analog_speaker_class {
	AUDIO_ANALOG_CLASS_AB = 0,
	AUDIO_ANALOG_CLASS_D,
};

enum audio_analog_channels {
	AUDIO_ANALOG_CHANNELS_LEFT1 = 0,
	AUDIO_ANALOG_CHANNELS_RIGHT1,
};

enum audio_analog_command {
	AUDIO_ANALOG_SET_SPEAKER_CLASS = 0,
	AUDIO_ANALOG_GET_SPEAKER_CLASS = 1,
	AUDIO_ANALOG_SET_CURRENT_SENSING = 2,
	AUDIO_ANALOG_SET_CURRENT_SENSING_PEAK_DETECTOR = 3,
};

enum audio_analog_loopback {
	AUDIO_ANALOG_DAC_LOOP_DAC_HS_ON = 0,
	AUDIO_ANALOG_DAC_LOOP_DAC_HS_OFF,
	AUDIO_ANALOG_DAC_LOOP_DAC_HP_ON,
	AUDIO_ANALOG_DAC_LOOP_DAC_HP_OFF,
	AUDIO_ANALOG_DAC_LOOP_DAC_SPEAKER_ON,
	AUDIO_ANALOG_DAC_LOOP_DAC_SPEAKER_OFF,
};

enum audio_analog_adc_mode {
	AUDIO_ANALOGUL_MODE_ACC = 0,
	AUDIO_ANALOGUL_MODE_DCC,
#ifdef MT6355_PORTING
	AUDIO_ANALOGUL_MODE_DMIC,
#endif
	AUDIO_ANALOGUL_MODE_DCCECMDIFF,
	AUDIO_ANALOGUL_MODE_DCCECMSINGLE,
};

enum audio_analog_uplink_power_mode {
	AUDIO_ANALOGUL_MODE_NORMAL = 0,
	AUDIO_ANALOGUL_MODE_LOWPOWER,
};

enum audio_speaker_mode {
	AUDIO_SPEAKER_MODE_D = 0,
	AUDIO_SPEAKER_MODE_AB = 1,
	AUDIO_SPEAKER_MODE_RECEIVER,
};

enum audio_mic_bias {
	AUDIO_MIC_BIAS0 = 0,
	AUDIO_MIC_BIAS1,
	AUDIO_MIC_BIAS2,
};

enum audio_sdm_level {
	AUDIO_SDM_LEVEL_MUTE = 0,
	AUDIO_SDM_LEVEL_NORMAL = 0x1D,
};

enum audio_offset_trim_mux {
	AUDIO_OFFSET_TRIM_MUX_OPEN = 0,
	AUDIO_OFFSET_TRIM_MUX_HPL,
	AUDIO_OFFSET_TRIM_MUX_HPR,
	AUDIO_OFFSET_TRIM_MUX_HSP,
	AUDIO_OFFSET_TRIM_MUX_HSN,
	AUDIO_OFFSET_TRIM_MUX_LOLP,
	AUDIO_OFFSET_TRIM_MUX_LOLN,
	AUDIO_OFFSET_TRIM_MUX_LORP,
	AUDIO_OFFSET_TRIM_MUX_LORN,
	AUDIO_OFFSET_TRIM_MUX_GROUND,
};

enum audio_offset_trim_voltage {
	AUDIO_OFFSET_TRIM_0V = 0,
	AUDIO_OFFSET_TRIM_MINUSP5,
	AUDIO_OFFSET_TRIM_MINUS1P5,
	AUDIO_OFFSET_TRIM_MINUS2P5,
	AUDIO_OFFSET_TRIM_MINUS3P5,
	AUDIO_OFFSET_TRIM_MINUS4P5,
	AUDIO_OFFSET_TRIM_MINUS5P5,
	AUDIO_OFFSET_TRIM_MINUS6P5,
	AUDIO_OFFSET_TRIM_P5 = 0x9,
	AUDIO_OFFSET_TRIM_1P5,
	AUDIO_OFFSET_TRIM_2P5,
	AUDIO_OFFSET_TRIM_3P5,
	AUDIO_OFFSET_TRIM_4P5,
	AUDIO_OFFSET_TRIM_5P5,
	AUDIO_OFFSET_TRIM_6P5,
};

enum audio_offset_finetrim_voltage {
	AUDIO_OFFSET_FINETUNE_ZREO = 0,
	AUDIO_OFFSET_FINETUNE_MINUSP5 = 1,
	AUDIO_OFFSET_FINETUNE_P5 = 2,
};

/* DPD */
enum dpd_impedance {
	DPD_IMPEDANCE_16OHM,
	DPD_IMPEDANCE_32OHM,
	DPD_IMPEDANCE_NUM,
};

enum dpd_fab {
	DPD_FAB_U8F,
	DPD_FAB_U8S,
	DPD_FAB_DBH,
	DPD_FAB_U8N,
	DPD_FAB_NUM,
};

enum dpd_channel {
	DPD_CHANNEL_L,
	DPD_CHANNEL_R,
	DPD_CHANNEL_NUM,
};

struct codec_data_private {
	int mAudio_Ana_Volume[AUDIO_ANALOG_VOLUME_TYPE_MAX];
	int mAudio_Ana_Mux[AUDIO_ANALOG_MAX_MUX_TYPE];
	int mAudio_Ana_DevicePower[AUDIO_ANALOG_DEVICE_MAX];
	int mAudio_BackUpAna_DevicePower[AUDIO_ANALOG_DEVICE_MAX];
	int audio_interface_power[AUDIO_DAI_INTERFACE_MAX];
};

#endif
